<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:bdf="http://banque-france.fr/namespace">
	<xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes"/>
  <xsl:param name="root" select="''"/>

  <xsl:template match="graphe" mode="grapheOR">
    <tr>
      <td class="clWidth636 t2">
	<br />
      <img src="{$root}Images/risque/shim_bleu.gif" width="635" height="1" vspace="8" alt=""/>
	<a name="graphe{position()}"></a> 
      <table class="clWidth635 clBorder0 clHeight10 clcellpadding0">
        <tr> 
		<xsl:if test="./serie">
       	   <td class="clCouleur2">
	            <div class="clAlignCenter"><xsl:value-of select="./titre"/></div>
		  </td>
		</xsl:if>
		<xsl:if test="not(./serie)">
       	   <td class="clItalic2">
	            <div class="clAlignLeft">Graphique <xsl:value-of select="./titre"/> non disponible</div>
		  </td>
		</xsl:if>
	 </tr>
      </table>
      <img src="{$root}Images/risque/shim_bleu.gif" width="635" height="1" vspace="8" alt=""/> 
      <table class="clBorder0 clHeight10">
        <span></span>
      </table>
      <br />
	<xsl:if test="./serie">
		<center>
			<xsl:element name="img">				
          <xsl:attribute name="src">M<xsl:value-of select="/FIBEN/@MODDEM"/>/Graphiques/Graphe13.aspx?date=<xsl:value-of select="/FIBEN/@DATJOUR"/><xsl:apply-templates select="serie|abcisse|unite"/>
				</xsl:attribute>
			</xsl:element>
		</center>
		<br />
	</xsl:if>
	</td>
	<xsl:call-template name="genFlecheHaut"/>
	</tr>
</xsl:template>

<xsl:template match="serie">
	<xsl:variable name="pos" select="position()"/>
	<xsl:for-each select="val">&amp;s<xsl:value-of select="$pos"/>v<xsl:value-of select="position()"/>=<xsl:value-of select="."/></xsl:for-each>
	<xsl:if test="titre">&amp;s<xsl:value-of select="$pos"/>t=<xsl:value-of select="./titre"/></xsl:if>
</xsl:template>

<xsl:template match="abcisse">
	<xsl:for-each select="val">&amp;ab<xsl:value-of select="position()"/>=<xsl:value-of select="."/>
	</xsl:for-each>
</xsl:template>

<xsl:template match="unite">
	&amp;<xsl:value-of select="name(.)"/>=<xsl:value-of select="."/>
</xsl:template>

</xsl:stylesheet>

