<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"  xmlns:bdf="http://banque-france.fr/namespace">
  <xsl:param name="root" select="''"/>

  <xsl:template match="graphe" mode="graphe63">
	<xsl:param name="indice" select='0'/>
 	<xsl:if test="(position()+$indice) != 1">
		<xsl:text disable-output-escaping="yes">&lt;tr class="clBreakPage"&gt;</xsl:text>
	</xsl:if>
	<xsl:if test="(position()+$indice) = 1">
		<xsl:text disable-output-escaping="yes">&lt;tr&gt;</xsl:text>
	</xsl:if>	  
	 <td class="clWidth636 t2">
	<br />
      <img src="{$root}Images/risque/shim_bleu.gif" width="635" height="1" vspace="8" alt=""/>
	<a name="Graphe{position()+$indice}"></a>
      <table class="clWidth635 clHeight10 clBorder0 clcellpadding0">
        <tr> 
		<xsl:if test="./serie">
       	   <td class="clCouleur2">
	            <div class="clAlignCenter"><xsl:value-of select="./titre"/></div>
		  </td>
		</xsl:if>
		<xsl:if test="not(./serie)">
       	   <td class="clItalic2">
	            <div class="clAlignLeft">Graphique <xsl:value-of select="./titre"/> non disponible</div>
		  </td>
		</xsl:if>
	 </tr>
      </table>
      <img src="{$root}Images/risque/shim_bleu.gif" width="635" height="1" vspace="8" alt=""/> 
      <table class="clBorder0 clHeight10">
        <span></span>
      </table>
      <br />
	<xsl:if test="./serie">
	<xsl:variable name="BFR" select="number(serie/val[1])"/>
	<xsl:variable name="DT" select="number(serie/val[2])"/>
	<xsl:variable name="FRNG" select="number(serie/val[3])"/>
		<center>
			<table class="clcellspacing1 clBorder1 clHeight250">
			<xsl:if test="$BFR>0">
				<xsl:if test="$DT>0">
					<tr>
						<td height="{250 * $BFR div $FRNG}" class="clWidth150 clAlignCenter clbgcolorlimegreen">BFR</td>
						<td class="clWidth150 clAlignCenter clbgcolormediumaquamarine" rowspan="2">FRNG</td>
					</tr>
					<tr>
						<td height="{250 * $DT div $FRNG}" class="clAlignCenter clbgcolormediumseagreen">TRSORERIE</td>
					</tr>
				</xsl:if>
				<xsl:if test="$DT&lt;0">
					<xsl:if test="$FRNG>0">
						<tr>
							<td class="clWidth150 clAlignCenter clbgcolorlimegreen" rowspan="2">BFR</td>
							<td height="{250 * $FRNG div $BFR}" class="clWidth150 clAlignCenter clbgcolormediumaquamarine">FRNG</td>
						</tr>
						<tr>
							<td height="{-250 * $DT div $BFR}" class="clAlignCenter clbgcolormediumseagreen">TRSORERIE</td>
						</tr>
					</xsl:if>
					<xsl:if test="$FRNG&lt;0">
						<tr>
							<td height="{-250 * $BFR div $DT}" class="clWidth150 clAlignCenter clbgcolorlimegreen">BFR</td>
							<td class="clWidth150 clAlignCenter clbgcolormediumseagreen" rowspan="2">TRSORERIE</td>
						</tr>
						<tr>
							<td height="{250*$FRNG div $DT}" class="clAlignCenter clbgcolormediumaquamarine">FRNG</td>
						</tr>					
					</xsl:if>
					<xsl:if test="$FRNG=0">
						<tr>
							<td class="clWidth150 clHeight250 clAlignCenter clbgcolorlimegreen">BFR</td>
							<td class="clWidth150 clHeight250 clAlignCenter clbgcolormediumseagreen">TRSORERIE</td>
						</tr>
					</xsl:if>
				</xsl:if>
				<xsl:if test="$DT=0">
					<tr>
						<td class="clWidth150 clHeight250 clAlignCenter clbgcolorlimegreen">BFR</td>
						<td class="clWidth150 clHeight250 clAlignCenter clbgcolormediumaquamarine">FRNG</td>
					</tr>
				</xsl:if>
			</xsl:if>
			<xsl:if test="$BFR&lt;0">
				<xsl:if test="$DT&lt;0">
					<tr>
						<td class="clWidth150 clAlignCenter mediumaquamarine" rowspan="2">FRNG</td>
						<td height="{250*$BFR div $FRNG}" class="clWidth150 clAlignCenter clbgcolorlimegreen">BFR</td>
					</tr>
					<tr>
						<td height="{250*$DT div $FRNG}" class="clAlignCenter clbgcolormediumseagreen">TRSORERIE</td>
					</tr>
				</xsl:if>
				<xsl:if test="$DT>0">
					<xsl:if test="$FRNG>0">
						<tr>
							<td class="clWidth150 clAlignCenter clbgcolormediumseagreen" rowspan="2">TRSORERIE</td>
							<td height="{250*$FRNG div $DT}" class="clWidth150 clAlignCenter clbgcolormediumaquamarine">FRNG</td>
						</tr>
						<tr>
							<td height="{-250*$BFR div $DT}" class="clWidth150 clAlignCenter clbgcolorlimegreen">BFR</td>
						</tr>
					</xsl:if>
					<xsl:if test="$FRNG&lt;0">
						<tr>
							<td height="{250*$FRNG div $BFR}" class="clWidth150 clAlignCenter clbgcolormediumaquamarine">FRNG</td>
							<td class="clWidth150 clAlignCenter clbgcolorlimegreen" rowspan="2">BFR</td>
						</tr>
						<tr>
							<td height="{-250*$DT div $BFR}" class="clWidth150 clAlignCenter clbgcolormediumseagreen">TRSORERIE</td>
						</tr>					
					</xsl:if>
					<xsl:if test="$FRNG=0">
						<tr>
							<td class="clWidth150 clHeight250 clAlignCenter clbgcolormediumseagreen">TRSORERIE</td>
							<td class="clWidth150 clHeight250 clAlignCenter clbgcolorlimegreen">BFR</td>
						</tr>
					</xsl:if>
				</xsl:if>
				<xsl:if test="$DT=0">
					<tr>
						<td class="clWidth150 clHeight250 clAlignCenter clbgcolormediumaquamarine">FRNG</td>
						<td class="clWidth150 clHeight250 clAlignCenter clbgcolorlimegreen">BFR</td>
					</tr>
				</xsl:if>	
			</xsl:if>
			<xsl:if test="$BFR=0">
				<xsl:if test="$DT&lt;0">
					<tr>
						<td class="clWidth150 clHeight250 clAlignCenter clbgcolormediumaquamarine">FRNG</td>
						<td class="clWidth150 clHeight250 clAlignCenter clbgcolormediumseagreen">TRSORERIE</td>											</tr>
				</xsl:if>
				<xsl:if test="$DT>0">
					<tr>
						<td class="clWidth150 clHeight250 clAlignCenter clbgcolormediumseagreen">TRSORERIE</td>
						<td class="clWidth150 clHeight250 clAlignCenter clbgcolormediumaquamarine">FRNG</td>
					</tr>
				</xsl:if>
			</xsl:if>
        <span></span>
			</table>
			<br/>
      <i>
        Source : Banque de France <xsl:call-template name ="displayDateXsl">
          <xsl:with-param name ="InputDate" select ="(../@DATJOUR)"/>
        </xsl:call-template>
      </i>			
		</center>
		<br />
	</xsl:if>
	</td>
	<xsl:call-template name="genFlecheHaut"/>
	<xsl:text disable-output-escaping="yes">&lt;/tr&gt;</xsl:text>
</xsl:template>

</xsl:stylesheet>
