<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:bdf="http://banque-france.fr/namespace">
	<xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes"/>
	<xsl:param name="langage" select="'fr'"/>
	<xsl:param name="root" select="''"/>
	<xsl:param name="familyNumber" select="''"/>
	<xsl:param name="familyName" select="''"/>
	<xsl:param name="familyTitle" select="''"/>
	<xsl:param name="nextModule" select="''"/>
	<xsl:param name="nextId" select="''"/>
	<xsl:param name="nextFamily" select="''"/>
	<xsl:param name="menuHTML1"/>
	<xsl:param name="Lang" select="''"/>
	<xsl:template match="graphe" mode="graphe60">
		<tr>
			<td class="clWidth636 t2">
				<br/>
				<img src="{$root}Images/risque/shim_bleu.gif" width="635" height="1" vspace="8"/>
				<a name="Graphe{position()}"/>
				<table class="clWidth635 clBorder0 clcellpadding0 clHeight10">
					<tr>
						<xsl:if test="./serie">
							<td class="clCouleur2">
								<div align="center">
									<xsl:value-of select="./titre"/>
								</div>
							</td>
						</xsl:if>
						<xsl:if test="not(./serie)">
							<td class="clItalic2">
								<div class="clAlignLeft">Graphique <xsl:value-of select="./titre"/> non disponible</div>
							</td>
						</xsl:if>
					</tr>
				</table>
				<img src="{$root}Images/risque/shim_bleu.gif" width="635" height="1" vspace="8"/>
				<table class="clBorder0 clHeight10">
					<span/>
				</table>
				<br/>
				<xsl:if test="./serie">
					<br/>
					<xsl:if test="./type = 'NF'">
						<xsl:variable name="AIMM" select="number(serie[1]/val[1])"/>
						<xsl:variable name="ACIR" select="number(serie[1]/val[2])"/>
						<xsl:variable name="AAUT" select="number(serie[1]/val[3])"/>
						<xsl:variable name="PFP" select="number(serie[2]/val[1])"/>
						<xsl:variable name="PDET" select="number(serie[2]/val[2])"/>
						<xsl:variable name="PAUT" select="number(serie[2]/val[3])"/>
						<xsl:variable name="TOT" select="number(serie[2]/val[4])"/>
						<xsl:variable name="RAIMM" select="number(1000 * $AIMM div $TOT)"/>
						<xsl:variable name="RACIR" select="number(1000 * $ACIR div $TOT)"/>
						<xsl:variable name="RAAUT" select="number(1000 * $AAUT div $TOT)"/>
						<xsl:variable name="RPFP" select="number(1000 * $PFP div $TOT)"/>
						<xsl:variable name="RPDET" select="number(1000 * $PDET div $TOT)"/>
						<xsl:variable name="RPAUT" select="number(1000 * $PAUT div $TOT)"/>
						<center>
							<table class="clWidth600 clBorder0 clHeight250 clcellspacing1">
								<tr>
									<!-- table des reprsentations des montants non nuls de l'actif relatives au total du bilan
      alternance de couleurs pour les postes de montant non nul  -->
									<td class="clWidth150 clHeight250 clValignTop">
										<table class="clWidth150 clBorder0 clcellspacing1 clHeight250"> 
                      <xsl:if test="((76 > $RAIMM ) and ($RAIMM > 15))">
												<tr>
													<td height="{100 * $AIMM div $TOT} %" class="clAlignCenter clWidth150 clfontSize1limegreen">
														Actif immobilis
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="not((76 > $RAIMM ) and ($RAIMM > 15))">
												<tr>
													<td height="{100 * $AIMM div $TOT} %" class="clAlignCenter clWidth150"/>
												</tr>
											</xsl:if>
											<xsl:if test="((15 > $RAIMM ) and ($RAIMM > 0))">
												<tr>
													<td height="{100 * $AIMM div $TOT} %" class="clAlignRight clWidth150 clfontSize0limegreen">
														*
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="((76 > $RACIR ) and ($RACIR > 15))">
												<tr>
													<td height="{100 * $ACIR div $TOT} %" class="clAlignCenter clWidth150 clfontSize1mediumaquamarine">
														Actif circulant
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="not((76 > $RACIR ) and ($RACIR > 15))">
												<tr>
													<td height="{100 * $ACIR div $TOT} %" class="clAlignCenter clWidth150"/>
												</tr>
											</xsl:if>
											<xsl:if test="((15 > $RACIR ) and ($RACIR > 0))">
												<tr>
													<td height="{100 * $ACIR div $TOT} %" class="clAlignRight clWidth150 clfontSize0mediumaquamarine">
														**
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="((76 > $RAAUT ) and ($RAAUT > 15))">
												<tr>
													<td height="{100 * $AAUT div $TOT} %" class="clAlignCenter clWidth150 clfontSize0mediumseagreen">
														Autres (actif)
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="not((76 > $RAAUT ) and ($RAAUT > 15))">
												<tr>
													<td height="{100 * $AAUT div $TOT} %" class="clAlignCenter clWidth150"/>
												</tr>
											</xsl:if>
											<xsl:if test="((15 > $RAAUT ) and ($RAAUT > 0))">
												<tr>
													<td height="{100 * $AAUT div $TOT} %" class="clAlignRight clWidth150 clfontSize0mediumseagreen">
														***
													</td>
												</tr>
											</xsl:if>
                      <span></span>
									</table>
									</td>
									<td class="clWidth150 clHeight250 clValignTop">
										<table class="clWidth150 clHeight250 clBorder0 clcellspacing1">
											<xsl:if test="((76 > $RAIMM ) and ($RAIMM > 15))">
												<tr>
													<td height="{100 * $AIMM div $TOT} %" class="clAlignRight clWidth150 clbgcolorlimegreen"/>
												</tr>
											</xsl:if>
											<xsl:if test="($RAIMM > 76 )">
												<tr>													
                        <td height="{100 * $AIMM div $TOT} %" class="clAlignCenter clWidth150 clbgcolorlimegreen clfontBlanc">
												Actif immobilis														
													</td>	
                      </tr>
											</xsl:if>
											<xsl:if test="((76 > $RACIR ) and ($RACIR > 15))">
												<tr>
													<td height="{100 * $ACIR div $TOT} %" class="clAlignCenter clWidth150 clbgcolormediumaquamarine"/>
												</tr>
											</xsl:if>
											<xsl:if test="($RACIR > 76  )">
												<tr>													
                        <td height="{100 * $ACIR div $TOT} %" class="clAlignCenter clWidth150 clbgcolormediumaquamarine clfontBlanc">
														Actif circulant
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="((76 > $RAAUT ) and ($RAAUT > 15))">
												<tr>
													<td height="{100 * $AAUT div $TOT} %" class="clAlignCenter clWidth150 clbgcolormediumseagreen"/>
												</tr>
											</xsl:if>
											<xsl:if test="($RAAUT > 76  )">
												<tr>
													<td height="{100 * $AAUT div $TOT} %" class="clAlignCenter clWidth150 clbgcolormediumseagreen clfontBlanc">
														Autres (actif)
													</td>
												</tr>
											</xsl:if>
											<span/>
										</table>
									</td>
									<!-- table des reprsentations des montants non nuls du passif relatives au total du bilan
      alternance de couleurs pour les postes de montant non nul  -->
									<td class="clWidth150 clHeight250 clValignTop">
										<table class="clWidth150 clHeight250 clBorder0 clcellspacing1">
											<xsl:if test="((76 > $RPFP) and ($RPFP > 15))">
												<tr>
													<td height="{100 * $PFP div $TOT} %" class="clAlignCenter clWidth150 clbgcolorlimegreen"/>
												</tr>
											</xsl:if>
											<xsl:if test="($RPFP > 76)">
												<tr>												
                        <td height="{100 * $PFP div $TOT} %" class="clAlignCenter clWidth150 clbgcolorlimegreen clfontBlanc">
														Fonds propres
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="((76 > $RPDET) and ($RPDET > 15))">
												<tr>
													<td height="{100 * $PDET div $TOT} %" class="clAlignCenter clWidth150 clbgcolormediumaquamarine"/>
												</tr>
											</xsl:if>
											<xsl:if test="($RPDET > 76)">
												<tr>													
                        <td height="{100 * $PDET div $TOT} %" class="clAlignCenter clWidth150 clbgcolormediumaquamarine clfontBlanc">
														Dettes
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="((76 > $RPAUT) and ($RPAUT > 15))">
												<tr>
													<td height="{100 * $PAUT div $TOT} %" class="clAlignCenter clWidth150 clbgcolormediumseagreen"/>
												</tr>
											</xsl:if>
											<xsl:if test="($RPAUT > 76)">
												<tr>
													<td height="{100 * $PAUT div $TOT} %" class="clAlignCenter clWidth150 clbgcolormediumseagreen clfontBlanc">														
															Autres (passif)														
													</td>
												</tr>
											</xsl:if>
											<span/>
										</table>
									</td>
									<td class="clWidth150 clHeight250 clValignTop">
										<table class="clWidth150 clHeight250 clBorder0 clcellspacing1">
											<xsl:if test="((76 > $RPFP) and ($RPFP > 15))">
												<tr>
													<td height="{100 * $PFP div $TOT} %" class="clAlignCenter clWidth150 clfontSize1limegreen">														
															Fonds propres														
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="not((76 > $RPFP) and ($RPFP > 15))">
												<tr>
													<td height="{100 * $PFP div $TOT} %" class="clAlignCenter clWidth150"/>
												</tr>
											</xsl:if>
											<xsl:if test="((15 > $RPFP) and ($RPFP > 0))">
												<tr>
													<td height="{100 * $PFP div $TOT} %" class="clAlignLeft clWidth150 clfontSize1limegreen">
															@														
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="((76 > $RPDET) and ($RPDET > 15))">
												<tr>
													<td height="{100 * $PDET div $TOT} %" class="clAlignCenter clWidth150 clfontSize1mediumaquamarine">
														Dettes														
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="not((76 > $RPDET) and ($RPDET > 15))">
												<tr>
													<td height="{100 * $PDET div $TOT} %" class="clAlignCenter clWidth150"/>
												</tr>
											</xsl:if>
											<xsl:if test="((15 > $RPDET) and ($RPDET > 0))">
												<tr>
													<td height="{100 * $PDET div $TOT} %" class="clAlignLeft clWidth150 clfontSize1mediumaquamarine">														
															@@														
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="((76 > $RPAUT) and ($RPAUT > 15))">
												<tr>
													<td height="{100 * $PAUT div $TOT} %" class="clAlignCenter clWidth150 clfontSize1mediumseagreen">														
															Autres (passif)														
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="not((76 > $RPAUT) and ($RPAUT > 15))">
												<tr>
													<td height="{100 * $PAUT div $TOT} %" class="clAlignCenter clWidth150"/>
												</tr>
											</xsl:if>
											<xsl:if test="((15 > $RPAUT) and ($RPAUT > 0))">
												<tr>
													<td height="{100 * $PAUT div $TOT} %" class="clAlignLeft clWidth150 clfontSize1mediumseagreen">
															@@@														
													</td>
												</tr>
											</xsl:if>
											<span/>
										</table>
									</td>
								</tr>
							</table>
							<table class="clWidth600 clBorder0 clcellspacing0">
								<tr>
									<td class="clWidth300">
										<table class="clWidth300 clBorder0 clcellspacing0">
											<xsl:if test="((15 > $RAIMM ) and ($RAIMM > 0))">
												<tr>
													<td class="clWidth300 clfontSize0limegreen">														
                        * : Actif immobilis(
															<xsl:call-template name="displayPourcentageXsl">
																	<xsl:with-param name="InputValue" select="($RAIMM)"/>
															</xsl:call-template> %)														
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="((15 > $RACIR ) and ($RACIR > 0))">
												<tr>
													<td class="clWidth300 clfontSize0mediumaquamarine">														
                      ** : Actif circulant(
                      <xsl:call-template name="displayPourcentageXsl">
																	<xsl:with-param name="InputValue" select="($RACIR)"/>
																</xsl:call-template> %)
                           </td>
												</tr>
											</xsl:if>
											<xsl:if test="((15 > $RAAUT ) and ($RAAUT > 0))">
												<tr>
													<td class="clWidth300 clfontSize0mediumseagreen">														
                      *** : Autres (actif) (
                      <xsl:call-template name="displayPourcentageXsl">
																	<xsl:with-param name="InputValue" select="($RAAUT)"/>
																</xsl:call-template> %)														
													</td>
												</tr>
											</xsl:if>
											<span/>
										</table>
									</td>
									<td class="clWidth300">
										<table class="clWidth300 clBorder0 clcellspacing0">
											<xsl:if test="((15 > $RPFP) and ($RPFP > 0))">
												<tr>
													<td class="clWidth300 clAlignRight clfontSize1limegreen">														
                      @ : Fonds propres(
                      <xsl:call-template name="displayPourcentageXsl">
																	<xsl:with-param name="InputValue" select="($RPFP)"/>
																</xsl:call-template> %)
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="((15 > $RPDET) and ($RPDET > 0))">
												<tr>
													<td class="clWidth300 clAlignRight clfontSize1mediumaquamarine">														
                      @@ : Dettes(
                      <xsl:call-template name="displayPourcentageXsl">
																	<xsl:with-param name="InputValue" select="($RPDET)"/>
																</xsl:call-template> %)
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="((15 > $RPAUT) and ($RPAUT > 0))">
												<tr>
													<td class="clWidth300 clAlignRight clfontSize1mediumseagreen">														
                      @@@ : Autres (passif)(
                      <xsl:call-template name="displayPourcentageXsl">
																	<xsl:with-param name="InputValue" select="($RPAUT)"/>
																</xsl:call-template> %)
													</td>
												</tr>
											</xsl:if>
											<span/>
										</table>
									</td>
								</tr>
							</table>
							<br/>
							<i>
        Source : Banque de France <xsl:call-template name="displayDateXsl">
									<xsl:with-param name="InputDate" select="(../@DATJOUR)"/>
								</xsl:call-template>
							</i>
						</center>
						<br/>
					</xsl:if>
					<xsl:if test="./type = 'IFRS'">
						<xsl:variable name="ACNC" select="number(serie[1]/val[1])"/>
						<xsl:variable name="ACCR" select="number(serie[1]/val[2])"/>
						<xsl:variable name="ADLV" select="number(serie[1]/val[3])"/>
						<xsl:variable name="KPT" select="number(serie[2]/val[1])"/>
						<xsl:variable name="PANC" select="number(serie[2]/val[2])"/>
						<xsl:variable name="PAC" select="number(serie[2]/val[3])"/>
						<xsl:variable name="PDLV" select="number(serie[2]/val[4])"/>
						<xsl:variable name="TOT" select="number(serie[2]/val[5])"/>
						<xsl:variable name="RACNC" select="number(1000 * $ACNC div $TOT)"/>
						<xsl:variable name="RACCR" select="number(1000 * $ACCR div $TOT)"/>
						<xsl:variable name="RADLV" select="number(1000 * $ADLV div $TOT)"/>
						<xsl:variable name="RKPT" select="number(1000 * $KPT div $TOT)"/>
						<xsl:variable name="RPANC" select="number(1000 * $PANC div $TOT)"/>
						<xsl:variable name="RPAC" select="number(1000 * $PAC div $TOT)"/>
						<xsl:variable name="RPDLV" select="number(1000 * $PDLV div $TOT)"/>
						<center>
							<table class="clWidth250 clBorder0 clcellspacing0">
								<tr>
									<!-- table des reprsentations des montants non nuls de l'actif relatives au total du bilan
      alternance de couleurs pour les postes de montant non nul  -->
									<td class="clWidth150 clHeight250 clValignTop">
										<table class="clWidth150 clHeight250 clBorder0 clcellspacing1">
											<xsl:if test="((76 > $RACNC ) and ($RACNC > 15))">
												<tr>
													<td height="{100 * $ACNC div $TOT} %" class="clAlignCenter clWidth150 clGraphe1 clGras">
														Actif non courant
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="not((76 > $RACNC ) and ($RACNC > 15))">
												<tr>
													<td height="{100 * $ACNC div $TOT} %" class="clAlignCenter clWidth150"/>
												</tr>
											</xsl:if>
											<xsl:if test="((15 > $RACNC ) and ($RACNC > 0))">
												<tr>
													<td height="{100 * $ACNC div $TOT} %" class="clAlignRight clWidth150 clGraphe1 clGras">
														*
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="((76 > $RACCR)  and ($RACCR > 15))">
												<tr>
													<td height="{100 * $ACCR div $TOT} %" class="clAlignCenter clWidth150 clGraphe2 clGras">
														Actif courant
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="not((76 > $RACCR)  and ($RACCR > 15))">
												<tr>
													<td height="{100 * $ACCR div $TOT} %" class="clAlignCenter clWidth150"/>
												</tr>
											</xsl:if>
											<xsl:if test="((15 > $RACCR)  and ($RACCR > 0))">
												<tr>
													<td height="{100 * $ACCR div $TOT} %" class="clAlignRight clWidth150 clGraphe2 clGras">
														**
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="((76 > $RADLV)  and ($RADLV > 15))">
												<tr>
													<td height="{100 * $ADLV div $TOT} %" class="clAlignCenter clWidth150 clGraphe3 clGras">
														Actifs destins  la vente
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="not((76 > $RADLV)  and ($RADLV > 15))">
												<tr>
													<td height="{100 * $ADLV div $TOT} %" class="clAlignCenter clWidth150"/>
												</tr>
											</xsl:if>
											<xsl:if test="((15 > $RADLV)  and ($RADLV >0))">
												<tr>
													<td height="{100 * $ADLV div $TOT} %" class="clAlignRight clWidth150 clGraphe3 clGras">
														***
													</td>
												</tr>
											</xsl:if>
											<span/>
										</table>
									</td>
									<td class="clWidth150 clHeight250 clValignTop">
										<table class="clWidth150 clHeight250 clBorder0 clcellspacing1">
											<xsl:if test="((76 > $RACNC ) and ($RACNC > 15))">
												<tr>
													<td height="{100 * $ACNC div $TOT} %" class="clAlignCenter clWidth150 clbgcolorlimegreen"/>
												</tr>
											</xsl:if>
											<xsl:if test="($RACNC > 76 )">
												<tr>
													<td height="{100 * $ACNC div $TOT} %" class="clAlignCenter clWidth150 clbgcolorlimegreen clGraphe clGras">
														Actif non courant
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="((76 > $RACCR)  and ($RACCR > 15))">
												<tr>
													<td height="{100 * $ACCR div $TOT} %" class="clAlignCenter clWidth150  clbgcolormediumaquamarine"/>
												</tr>
											</xsl:if>
											<xsl:if test="($RACCR > 76 )">
												<tr>
													<td height="{100 * $ACCR div $TOT} %" class="clAlignCenter clWidth150 clbgcolormediumaquamarine clGraphe clGras">
														Actif courant
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="((76 > $RADLV)  and ($RADLV > 15))">
												<tr>
													<td height="{100 * $ADLV div $TOT} %" class="clAlignCenter clWidth150 clbgcolormediumseagreen"/>
												</tr>
											</xsl:if>
											<xsl:if test="($RADLV > 76 )">
												<tr>
													<td height="{100 * $ADLV div $TOT} %" class="clAlignCenter clWidth150 clbgcolormediumseagreen clGraphe clGras">
														Actifs destins  la vente
													</td>
												</tr>
											</xsl:if>
											<span/>
										</table>
									</td>
									<!-- table des reprsentations des montants non nuls du passif relatives au total du bilan
      alternance de couleurs pour les postes de montant non nul  -->
									<td class="clWidth150 clHeight250 clValignTop">
										<table class="clWidth150 clHeight250 clBorder0 clcellspacing1">
											<xsl:if test="($RKPT > 76)">
												<tr>
													<td height="{100 * $KPT div $TOT} %" class="clAlignCenter clWidth150 clbgcolorlimegreen clGraphe clGras">
														Capitaux propres totaux
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="((76 > $RKPT ) and ($RKPT > 15))">
												<tr>
													<td height="{100 * $KPT div $TOT} %" class="clAlignCenter clWidth150 clbgcolorlimegreen"/>
												</tr>
											</xsl:if>
											<xsl:if test="($RPANC > 76)">
												<tr>
													<td height="{100 * $PANC div $TOT} %" class="clAlignCenter clWidth150 clbgcolormediumaquamarine clGraphe clGras">
														Passif non courant
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="((76 > $RPANC ) and ($RPANC > 15))">
												<tr>
													<td height="{100 * $PANC div $TOT} %" class="clAlignCenter clWidth150 clbgcolormediumaquamarine"/>
												</tr>
											</xsl:if>
											<xsl:if test="($RPAC > 76)">
												<tr>
													<td height="{100 * $PAC div $TOT} %" class="clAlignCenter clWidth150 clbgcolor66FFCC clGraphe clGras">
														Passif courant
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="((76 > $RPAC ) and ($RPAC > 15))">
												<tr>
													<td height="{100 * $PAC div $TOT} %" class="clAlignCenter clWidth150 clbgcolor66FFCC"/>
												</tr>
											</xsl:if>
											<xsl:if test="($RPDLV > 76)">
												<tr>
													<td height="{100 * $PDLV div $TOT} %" class="clAlignCenter clWidth150 clbgcolormediumseagreen clGraphe clGras">
														Passifs destin.  la vente
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="((76 > $RPDLV ) and ($RPDLV > 15))">
												<tr>
													<td height="{100 * $PDLV div $TOT} %" class="clAlignCenter clWidth150 clbgcolormediumseagreen"/>
												</tr>
											</xsl:if>
											<span/>
										</table>
									</td>
									<td class="clWidth150 clHeight250 clValignTop">
										<table class="clWidth150 clHeight250 clBorder0 clcellspacing1">
											<xsl:if test="((76 > $RKPT ) and ($RKPT > 15))">
												<tr>
													<td height="{100 * $KPT div $TOT} %" class="clAlignCenter clWidth150 clGraphe1 clGras">
														Capitaux propres totaux
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="not((76 > $RKPT ) and ($RKPT > 15))">
												<tr>
													<td height="{100 * $KPT div $TOT} %" class="clAlignCenter clWidth150"/>
												</tr>
											</xsl:if>
											<xsl:if test="((15 > $RKPT ) and ($RKPT > 0))">
												<tr>
													<td height="{100 * $KPT div $TOT} %" class="clAlignLeft clWidth150 clGraphe1 clGras">
														@
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="((76 > $RPANC) and ($RPANC > 15))">
												<tr>
													<td height="{100 * $PANC div $TOT} %" class="clAlignCenter clWidth150 clGraphe2 clGras">
														Passif non courant
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="not((76 > $RPANC) and ($RPANC > 15))">
												<tr>
													<td height="{100 * $PANC div $TOT} %" class="clAlignCenter clWidth150"/>
												</tr>
											</xsl:if>
											<xsl:if test="((15 > $RPANC) and ($RPANC > 0))">
												<tr>
													<td height="{100 * $PANC div $TOT} %" class="clAlignLeft clWidth150 clGraphe2 clGras">
														@@
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="((76 > $RPAC) and ($RPAC > 15))">
												<tr>
													<td height="{100 * $PAC div $TOT} %" class="clAlignCenter clWidth150 clGraphe4 clGras">
														Passif courant
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="not((76 > $RPAC) and ($RPAC > 15))">
												<tr>
													<td height="{100 * $PAC div $TOT} %" class="clAlignCenter clWidth150"/>
												</tr>
											</xsl:if>
											<xsl:if test="((15 > $RPAC) and ($RPAC > 0))">
												<tr>
													<td height="{100 * $PAC div $TOT} %" class="clAlignLeft clWidth150 clGraphe4 clGras">
														@@@
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="((76 > $RPDLV)  and ($RPDLV > 15))">
												<tr>
													<td height="{100 * $PDLV div $TOT} %" class="clAlignCenter clWidth150 clGraphe3 clGras">
														Passifs destins  la vente
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="not((76 > $RPDLV)  and ($RPDLV > 15))">
												<tr>
													<td height="{100 * $PDLV div $TOT} %" class="clAlignCenter clWidth150"/>
												</tr>
											</xsl:if>
											<xsl:if test="((15 > $RPDLV)  and ($RPDLV > 0))">
												<tr>
													<td height="{100 * $PDLV div $TOT} %" class="clAlignLeft clWidth150 clGraphe3 clGras">
														@@@@
													</td>
												</tr>
											</xsl:if>
											<span/>
										</table>
									</td>
								</tr>
							</table>
							<table class="clWidth600 clBorder0 clcellpadding0">
								<tr>
									<td class="clWidth300">
										<table class="clWidth300 clBorder0 clcellspacing0">
											<xsl:if test="((15 > $RACNC) and ($RACNC > 0))">
												<tr>
													<td class="clWidth300 clGraphe1 clGras">
														* : Actif non courant(<xsl:value-of select="format-number($RACNC, '###.00')"/> %)
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="((15 > $RACCR) and ($RACCR > 0))">
												<tr>
													<td class="clWidth300 clGraphe2 clGras">
														** : Actif courant(<xsl:value-of select="format-number($RACCR, '###.00')"/> %)
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="((15 > $RADLV) and ($RADLV > 0))">
												<tr>
													<td class="clWidth300 clGraphe3 clGras">
														*** : Actifs destins  la vente(<xsl:value-of select="format-number($RADLV, '###.00')"/> %)
													</td>
												</tr>
											</xsl:if>
											<span/>
										</table>
									</td>
									<td class="clWidth300">
										<table class="clWidth300 clBorder0 clcellspacing0">
											<xsl:if test="((15 > $RKPT ) and ($RKPT > 0))">
												<tr>
													<td class="clWidth300 clGraphe1 clGras">
														@ : Capitaux propres totaux(<xsl:value-of select="format-number($RKPT, '###.00')"/> %)
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="((15 > $RPANC ) and ($RPANC > 0))">
												<tr>
													<td class="clWidth300 clGraphe2 clGras">
														@@ : Passif non courant(<xsl:value-of select="format-number($RPANC, '###.00')"/> %)
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="((15 > $RPAC ) and ($RPAC > 0))">
												<tr>
													<td class="clWidth300 clGraphe4 clGras">
														@@@ : Passif courant(<xsl:value-of select="format-number($RPAC, '###.00')"/> %)
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="((15 > $RPDLV)  and ($RPDLV > 0))">
												<tr>
													<td class="clWidth300 clGraphe3 clGras">
														>@@@@ : Passifs destins  la vente(<xsl:value-of select="format-number($RPDLV, '###.00')"/> %)
													</td>
												</tr>
											</xsl:if>
											<span/>
										</table>
									</td>
								</tr>
							</table>
							<br/>
							<i>
        Source : Banque de France <xsl:call-template name="displayDateXsl">
									<xsl:with-param name="InputDate" select="(../@DATJOUR)"/>
								</xsl:call-template>
							</i>
						</center>
						<br/>
					</xsl:if>
				</xsl:if>
			</td>
			<xsl:call-template name="genFlecheHaut"/>
		</tr>
	</xsl:template>
	<xsl:template match="serie">
		<xsl:variable name="pos" select="position()"/>
		<xsl:for-each select="val">&amp;s<xsl:value-of select="$pos"/>v<xsl:value-of select="position()"/>=<xsl:value-of select="."/>
		</xsl:for-each>
		<xsl:if test="titre">&amp;s<xsl:value-of select="$pos"/>t=<xsl:value-of select="./titre"/>
		</xsl:if>
	</xsl:template>
	<xsl:template match="abcisse">
		<xsl:for-each select="val">&amp;ab<xsl:value-of select="position()"/>=<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:template>
	<xsl:template match="type">
	&amp;<xsl:value-of select="name(.)"/>=<xsl:value-of select="."/>
	</xsl:template>
</xsl:stylesheet>

