<?xml version="1.0" encoding="iso-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="urn:schemas-microsoft-com:office:spreadsheet" xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:x="urn:schemas-microsoft-com:office:excel" xmlns:ss="urn:schemas-microsoft-com:office:spreadsheet" xmlns:html="http://www.w3.org/TR/REC-html40">
  <xsl:output method="xml" encoding="utf-8" indent="yes"/>
  <xsl:template match="/">
    <xsl:text disable-output-escaping="yes">&lt;?mso-application progid=&quot;Excel.Sheet&quot;?&gt;&#10;</xsl:text>
    <Workbook>
      <ss:Styles>
        <ss:Style ss:ID="LigneTitre" ss:Name="LigneTitre">
          <ss:Alignment ss:Horizontal="Center" ss:Vertical="Center" />
          <ss:Font ss:Color="blue" ss:Bold="1"/>
        </ss:Style>
        <ss:Style ss:ID="LigneSuivi" ss:Name="LigneSuivi">
          <ss:Alignment ss:Horizontal="Center" ss:Vertical="Center" ss:WrapText="1"/>          
        </ss:Style>
      </ss:Styles>
      <Worksheet ss:Name="ListeSuivisAvecMouvementsS4">
        <Table>
          <Column ss:AutoFitWidth="1" ss:Width="100" />
          <Column ss:AutoFitWidth="1" ss:Width="200" />
          <Column ss:AutoFitWidth="1" ss:Width="120"/>
          <Column ss:AutoFitWidth="1" ss:Width="200"/>
          <Column ss:AutoFitWidth="1" ss:Width="60"/>
          <Column ss:AutoFitWidth="1" ss:Width="60"/>
          <Column ss:AutoFitWidth="1" ss:Width="100"/>

          <xsl:call-template name ="Entete">
          </xsl:call-template>

          <xsl:call-template name ="SuiviMouve">
          </xsl:call-template>

        </Table>
        <AutoFilter x:Range="R1C1:R1C7" xmlns="urn:schemas-microsoft-com:office:excel"></AutoFilter>
      </Worksheet>
    </Workbook>
  </xsl:template>

  <xsl:template name ="Entete">
    <Row>
      <Cell ss:StyleID="LigneTitre">
        <Data ss:Type="String">Identifiant</Data>
      </Cell>
      <Cell ss:StyleID="LigneTitre">
        <Data ss:Type="String">Dnomination / Nom</Data>
      </Cell>
      <Cell ss:StyleID="LigneTitre">
        <Data ss:Type="String">Prnom</Data>
      </Cell>
      <Cell ss:StyleID="LigneTitre">
        <Data ss:Type="String">Rfrence</Data>
      </Cell>
      <Cell ss:StyleID="LigneTitre">
        <Data ss:Type="String">Suivi</Data>
      </Cell>
      <Cell ss:StyleID="LigneTitre">
        <Data ss:Type="String">Package</Data>
      </Cell>
      <Cell ss:StyleID="LigneTitre">
        <Data ss:Type="String">Date de MVT</Data>
      </Cell>
    </Row>
  </xsl:template>

  <xsl:template name ="SuiviMouve">
    <xsl:for-each select="//MOUVE">
      <Row>
        <Cell ss:StyleID="LigneSuivi">
          <Data ss:Type="String">
            <xsl:value-of select="IDENT"/>
          </Data>
        </Cell>
        <Cell ss:StyleID="LigneSuivi">
          <Data ss:Type="String">
            <xsl:value-of select="NOM"/>
          </Data>
        </Cell>
        <Cell ss:StyleID="LigneSuivi">
          <Data ss:Type="String">
            <xsl:value-of select="PRENOM"/>
          </Data>
        </Cell>
        <Cell ss:StyleID="LigneSuivi">
          <Data ss:Type="String">
            <xsl:value-of select="REFERENCE"/>
          </Data>
        </Cell>
        <Cell ss:StyleID="LigneSuivi">
          <Data ss:Type="String">
            <xsl:value-of select="TYPESUIVI"/>
          </Data>
        </Cell>
        <Cell ss:StyleID="LigneSuivi">
          <Data ss:Type="String">
            <xsl:value-of select="PACKAGE"/>
          </Data>
        </Cell>
        <Cell ss:StyleID="LigneSuivi">
          <Data ss:Type="String">
            <xsl:variable name ="dateFinsuivi" select ="DATEMOUVE"></xsl:variable>
            <xsl:value-of select="concat(substring($dateFinsuivi,1,2),'/',substring($dateFinsuivi,3,2),'/',substring($dateFinsuivi,5,4))"/>
          </Data>
        </Cell>
      </Row>
    </xsl:for-each>
  </xsl:template>
</xsl:stylesheet>


