<?xml version="1.0" encoding="iso-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="urn:schemas-microsoft-com:office:spreadsheet" xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:x="urn:schemas-microsoft-com:office:excel" xmlns:ss="urn:schemas-microsoft-com:office:spreadsheet" xmlns:html="http://www.w3.org/TR/REC-html40">
    <xsl:output method="xml" encoding="utf-8" indent="yes"/>
    <xsl:variable name="dictionnaire" select="document('../../Ressources/XML/DicoLibelle.xml')/dictionnaire"/>
    <xsl:template match="/">
        <xsl:text disable-output-escaping="yes">&lt;?mso-application progid=&quot;Excel.Sheet&quot;?&gt;&#10;</xsl:text>
        <Workbook>
            <ss:Styles>
                <ss:Style ss:ID="LigneTitre" ss:Name="LigneTitre">
                    <ss:Alignment ss:Horizontal="Center" ss:Vertical="Center" />
                    <ss:Font ss:Color="blue" ss:Bold="1"/>
                </ss:Style>
                <ss:Style ss:ID="LigneSuivi" ss:Name="LigneSuivi">
                    <Interior ss:Color="#DCE6F1" ss:Pattern="Solid"/>
                    <ss:Alignment ss:Horizontal="Center" ss:Vertical="Center" ss:WrapText="1"/>
                </ss:Style>
                <ss:Style ss:ID="LigneDetail" ss:Name="LigneDetail">
                    <ss:Alignment ss:Horizontal="Left" ss:Vertical="Center" ss:WrapText="1"/>
                </ss:Style>
            </ss:Styles>
            <Worksheet ss:Name="DetailsMouvementsSuivis">
                <Table>
                    <Column ss:AutoFitWidth="1" ss:Width="100" />
                    <Column ss:AutoFitWidth="1" ss:Width="200" />
                    <Column ss:AutoFitWidth="1" ss:Width="120"/>
                    <Column ss:AutoFitWidth="1" ss:Width="200"/>
                    <Column ss:AutoFitWidth="1" ss:Width="60"/>
                    <Column ss:AutoFitWidth="1" ss:Width="60"/>
                    <Column ss:AutoFitWidth="1" ss:Width="100"/>

                    <xsl:call-template name ="Entete">
                    </xsl:call-template>

                    <xsl:call-template name ="SuiviMouve">
                    </xsl:call-template>

                </Table>
                <!--<AutoFilter x:Range="R1C1:R1C7" xmlns="urn:schemas-microsoft-com:office:excel"></AutoFilter>-->
            </Worksheet>
        </Workbook>
    </xsl:template>

    <xsl:template name ="Entete">
        <Row>
            <Cell ss:StyleID="LigneTitre">
                <Data ss:Type="String">Identifiant</Data>
            </Cell>
            <Cell ss:StyleID="LigneTitre">
                <Data ss:Type="String">Dnomination / Nom</Data>
            </Cell>
            <Cell ss:StyleID="LigneTitre">
                <Data ss:Type="String">Prnom</Data>
            </Cell>
            <Cell ss:StyleID="LigneTitre">
                <Data ss:Type="String">Rfrence</Data>
            </Cell>
            <Cell ss:StyleID="LigneTitre">
                <Data ss:Type="String">Suivi</Data>
            </Cell>
            <Cell ss:StyleID="LigneTitre">
                <Data ss:Type="String">Package</Data>
            </Cell>
            <Cell ss:StyleID="LigneTitre">
                <Data ss:Type="String">Date de MVT</Data>
            </Cell>
        </Row>
    </xsl:template>

    <xsl:template name ="SuiviMouve">
        <xsl:for-each select="//MOUVE">
            <Row>
                <Cell ss:StyleID="LigneSuivi">
                    <Data ss:Type="String">
                        <xsl:value-of select="IDENT"/>
                    </Data>
                </Cell>
                <Cell ss:StyleID="LigneSuivi">
                    <Data ss:Type="String">
                        <xsl:value-of select="NOM"/>
                    </Data>
                </Cell>
                <Cell ss:StyleID="LigneSuivi">
                    <Data ss:Type="String">
                        <xsl:value-of select="PRENOM"/>
                    </Data>
                </Cell>
                <Cell ss:StyleID="LigneSuivi">
                    <Data ss:Type="String">
                        <xsl:value-of select="REFERENCE"/>
                    </Data>
                </Cell>
                <Cell ss:StyleID="LigneSuivi">
                    <Data ss:Type="String">
                        <xsl:value-of select="TYPESUIVI"/>
                    </Data>
                </Cell>
                <Cell ss:StyleID="LigneSuivi">
                    <Data ss:Type="String">
                        <xsl:value-of select="PACKAGE"/>
                    </Data>
                </Cell>
                <Cell ss:StyleID="LigneSuivi">
                    <Data ss:Type="String">
                        <xsl:variable name ="dateFinsuivi" select ="DATEMOUVE"></xsl:variable>
                        <xsl:value-of select="concat(substring($dateFinsuivi,1,2),'/',substring($dateFinsuivi,3,2),'/',substring($dateFinsuivi,5,4))"/>
                    </Data>
                </Cell>
            </Row>
            <xsl:call-template name ="detailMouve">
            </xsl:call-template>
        </xsl:for-each>
        
    </xsl:template>

    <xsl:template name ="detailMouve">
        <xsl:for-each select="./MOTCLESUIVI">
            <Row>
                <Cell ss:StyleID="LigneDetail">
                    <Data ss:Type="String">
                        &#x21D2;
                    </Data>
                </Cell>
                <Cell ss:MergeAcross="2" ss:StyleID="LigneDetail">
                  <Data ss:Type="String">
                    <xsl:variable name ="motcle" select ="MOTCLE"></xsl:variable>
                    <xsl:variable name ="longueurMot" select ="string-length($motcle)-1"></xsl:variable>
                     <xsl:variable name ="longueurType" select ="string-length($motcle)-2"></xsl:variable>
                     <xsl:variable name ="annPrec" > (par rapport  l'anne prcdente)></xsl:variable>
                    <xsl:variable name ="moisPrec" > (par rapport au mois prcdent)></xsl:variable>
                    <xsl:choose>
                      <!-- cas particulier AB-->
                      <xsl:when test ="substring($motcle,$longueurMot,2) = 'AB'">
                        <xsl:choose>
                          <xsl:when test ="substring($motcle,$longueurType,1) = 'M'">
                            <xsl:value-of select="concat($dictionnaire/mot[@id=$motcle], $moisPrec )"/>
                          </xsl:when>
                          <xsl:when test ="substring($motcle,$longueurType,1) = 'A'">
                            <xsl:value-of select="concat($dictionnaire/mot[@id=$motcle], $annPrec) "/>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="($dictionnaire/mot[@id=$motcle])"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      
                      <!-- cas particulier AE-->
                      <xsl:when test ="substring($motcle,$longueurMot,2) = 'AE'">
                        <xsl:choose>
                          <xsl:when test ="substring($motcle,$longueurType,1) = 'M'">
                            <xsl:value-of select="concat($dictionnaire/mot[@id=$motcle], $moisPrec )"/>
                          </xsl:when>
                          <xsl:when test ="substring($motcle,$longueurType,1) = 'A'">
                            <xsl:value-of select="concat($dictionnaire/mot[@id=$motcle], $annPrec) "/>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="($dictionnaire/mot[@id=$motcle])"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      
                      <!-- cas gnral-->
                      <xsl:otherwise>
                        <xsl:value-of select="($dictionnaire/mot[@id=$motcle])"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </Data>
                </Cell>
                <Cell ss:MergeAcross="2" ss:StyleID="LigneDetail">
                    <Data ss:Type="String">
                      <xsl:if test="CONVERT">
                        <xsl:variable name ="motcleV" select ="VALEUR"></xsl:variable>
                        <xsl:value-of select="($dictionnaire/mot[@id=$motcleV])"/>
                      </xsl:if>
                      <xsl:if test="not(CONVERT)">
                          <xsl:value-of select="VALEUR"/>
                      </xsl:if>

                    </Data>
                </Cell>
            </Row>
        </xsl:for-each>
      </xsl:template>


  
   
</xsl:stylesheet>


