<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
					              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
					              xmlns:bdf="http://banque-france.fr/namespace">


  <xsl:variable name="lcletters">
    abcdefghijklmnopqrstuvwxyz
  </xsl:variable>

  <xsl:variable name="ucletters">
    ABCDEFGHIJKLMNOPQRSTUVWXYZ
  </xsl:variable>

  <xsl:template name='convertcase'>
    <xsl:param name='toconvert' />

    <xsl:param name='conversion' />

    <xsl:choose>
      <xsl:when test='$conversion="lower"'>
        <xsl:value-of
        select="translate($toconvert,$ucletters,$lcletters)" />
      </xsl:when>

      <xsl:when test='$conversion="upper"'>
        <xsl:value-of
        select="translate($toconvert,$lcletters,$ucletters)" />
      </xsl:when>

      <xsl:when test='$conversion="proper"'>
        <xsl:call-template name='convertpropercase'>
          <xsl:with-param name='toconvert'>
            <xsl:value-of
            select="translate($toconvert,$ucletters,$lcletters)" />
          </xsl:with-param>
        </xsl:call-template>
      </xsl:when>

      <xsl:otherwise>
        <xsl:value-of select='$toconvert' />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name='convertpropercase'>
    <xsl:param name='toconvert' />

    <xsl:if test="string-length($toconvert) > 0">
      <xsl:variable name='f'
      select='substring($toconvert, 1, 1)' />

      <xsl:variable name='s' select='substring($toconvert, 2)' />

      <xsl:call-template name='convertcase'>
        <xsl:with-param name='toconvert' select='$f' />

        <xsl:with-param name='conversion'>upper</xsl:with-param>
      </xsl:call-template>

      <xsl:choose>
        <xsl:when test="contains($s,' ')">
          <xsl:value-of select='substring-before($s," ")' />


          <xsl:call-template name='convertpropercase'>
            <xsl:with-param name='toconvert'
            select='substring-after($s," ")' />
          </xsl:call-template>
        </xsl:when>

        <xsl:otherwise>
          <xsl:value-of select='$s' />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:if>
  </xsl:template>

<!-- displayDate -->
<xsl:template name="displayDateXsl">
  <xsl:param name='InputDate'/>
  <xsl:choose>
    <xsl:when test="string-length($InputDate) > 0">
      <!-- Format nombre de mois (exemple :18 mois) -->
      <xsl:if test="string-length($InputDate) = 2">
        <xsl:value-of select="concat(substring($InputDate,1,2),' mois')"/>
      </xsl:if>
      <!-- Format annee -->
      <xsl:if test="string-length($InputDate) = 4">
        <xsl:value-of select="$InputDate"/>
      </xsl:if>
      <!-- Format numero trimestre + annee (exemple 3eme trimestre 2010)-->
      <xsl:if test="string-length($InputDate) = 5">
        <xsl:choose>
          <xsl:when test ="substring($InputDate,1,1) = 1">
            <xsl:value-of select="concat(substring($InputDate,1,1),'er trimestre ',substring($InputDate,2,4))"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="concat(substring($InputDate,1,1),'eme trimestre ',substring($InputDate,2,4))"/>
          </xsl:otherwise> 
        </xsl:choose> 
      </xsl:if>
      <!-- Format JJMMAA -->
      <xsl:if test="string-length($InputDate) = 6">
        <xsl:value-of select="concat(substring($InputDate,1,2),'/',substring($InputDate,3))"/>
      </xsl:if>
    <!-- Format JJ.MM.AA ou JJMMAAAA-->
      <xsl:if test="string-length($InputDate) = 8">
        <xsl:choose>
          <xsl:when test="contains($InputDate,'.')">
            <xsl:value-of select="concat(substring($InputDate,1,2),'/',substring($InputDate,4,2),'/',substring($InputDate,7))"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="concat(substring($InputDate,1,2),'/',substring($InputDate,3,2),'/',substring($InputDate,5))"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:if>
      <!-- Format JJ.MM.AAAA -->
      <xsl:if test="string-length($InputDate) = 10">
        <xsl:value-of select="concat(substring($InputDate,1,2),'/',substring($InputDate,4,2),'/',substring($InputDate,7))"/>
      </xsl:if>
      <!-- Format JJMMAAAAhhmm -->
      <xsl:if test="string-length($InputDate) = 12">
        <xsl:value-of select="concat(substring($InputDate,1,2),'/',substring($InputDate,3,2),'/',substring($InputDate,5,4),'  ',substring($InputDate,9,2),':',substring($InputDate,11))"/>
      </xsl:if>
      <!-- Format JJMMAAAAhhmmss -->
      <xsl:if test="string-length($InputDate) = 14">
        <xsl:value-of select="concat(substring($InputDate,1,2),'/',substring($InputDate,3,2),'/',substring($InputDate,5,4),'  ',substring($InputDate,9,2),':',substring($InputDate,11,2),':',substring($InputDate,13))"/>
      </xsl:if>
      <!-- Format JJMMAAAAhhmmssxx -->
      <xsl:if test="string-length($InputDate) = 16">
        <xsl:value-of select="concat(substring($InputDate,1,2),'/',substring($InputDate,3,2),'/',substring($InputDate,5,4),'  ',substring($InputDate,9,2),':',substring($InputDate,11,2),':',substring($InputDate,13))"/>
      </xsl:if>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="' '"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

  <!-- displayDateLettre -->
  <xsl:template name="displayDateLettre">
    <xsl:param name='InputDate'/>
    <xsl:choose>
      <!--format de la date 102014 en oct-2014 -->
      <xsl:when test="substring($InputDate,5,2) = '01'">
        <xsl:value-of select="concat('janvier ', substring($InputDate,1,4))"/>
      </xsl:when>
      <xsl:when test="substring($InputDate,5,2) = '02'">
        <xsl:value-of select="concat('fvrier ', substring($InputDate,1,4))"/>
      </xsl:when>
      <xsl:when test="substring($InputDate,5,2) = '03'">
        <xsl:value-of select="concat('mars ', substring($InputDate,1,4))"/>
      </xsl:when>
      <xsl:when test="substring($InputDate,5,2) = '04'">
        <xsl:value-of select="concat('avril ', substring($InputDate,1,4))"/>
      </xsl:when>
      <xsl:when test="substring($InputDate,5,2) = '05'">
        <xsl:value-of select="concat('mai ', substring($InputDate,1,4))"/>
      </xsl:when>
      <xsl:when test="substring($InputDate,5,2) = '06'">
        <xsl:value-of select="concat('juin ', substring($InputDate,1,4))"/>
      </xsl:when>
      <xsl:when test="substring($InputDate,5,2) = '07'">
        <xsl:value-of select="concat('juillet ', substring($InputDate,1,4))"/>
      </xsl:when>
      <xsl:when test="substring($InputDate,5,2) = '08'">
        <xsl:value-of select="concat('aout ', substring($InputDate,1,4))"/>
      </xsl:when>
      <xsl:when test="substring($InputDate,5,2) = '09'">
        <xsl:value-of select="concat('septembre ', substring($InputDate,1,4))"/>
      </xsl:when>
      <xsl:when test="substring($InputDate,5,2) = '10'">
        <xsl:value-of select="concat('octobre ', substring($InputDate,1,4))"/>
      </xsl:when>
      <xsl:when test="substring($InputDate,5,2) = '11'">
        <xsl:value-of select="concat('novembre ', substring($InputDate,1,4))"/>
      </xsl:when>
      <xsl:when test="substring($InputDate,5,2) = '12'">
        <xsl:value-of select="concat('dcembre ', substring($InputDate,1,4))"/>
      </xsl:when>       
      <xsl:otherwise>
        <xsl:value-of select="'displayDateLettre ERROR'"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  

 <!-- displayDateUKXsl -->
   
  <xsl:template name="displayDateUKXsl">
    <xsl:param name='InputDate'/>
    <xsl:choose>
      <xsl:when test="string-length($InputDate) > 0">
        
   <!-- Format nombre de mois (exemple :18 monts) -->
        <xsl:if test="string-length($InputDate) = 2">
          <xsl:value-of select="concat(substring($InputDate,1,2),' months')"/>
        </xsl:if>
        <!-- Format annee -->
        <xsl:if test="string-length($InputDate) = 4">
          <xsl:value-of select="$InputDate"/>
        </xsl:if>
        <!-- Format JJMMAA -->
        <xsl:if test="string-length($InputDate) = 6">
          <xsl:value-of select="concat(substring($InputDate,1,2),'/',substring($InputDate,3))"/>
        </xsl:if>
        <!-- Format numero trimestre + annee (exemple 3rd quarter 2010) -->
        <xsl:if test="string-length($InputDate) = 5">
            <xsl:if test ="substring($InputDate,1,1) = 1">
              <xsl:value-of select="concat(substring($InputDate,1,1),'st quarter ',substring($InputDate,2,4))"/>
            </xsl:if>
          <xsl:if test ="substring($InputDate,1,1) = 2">
            <xsl:value-of select="concat(substring($InputDate,1,1),'nd quarter ',substring($InputDate,2,4))"/>
          </xsl:if>
          <xsl:if test ="substring($InputDate,1,1) = 3">
            <xsl:value-of select="concat(substring($InputDate,1,1),'rd quarter ',substring($InputDate,2,4))"/>
          </xsl:if>
          <xsl:if test ="substring($InputDate,1,1) = 4">
            <xsl:value-of select="concat(substring($InputDate,1,1),'th quarter ',substring($InputDate,2,4))"/>
          </xsl:if>
        </xsl:if>
        <!-- Format JJ.MM.AA ou JJMMAAAA-->
        <xsl:if test="string-length($InputDate) = 8">
          <xsl:choose>
            <xsl:when test="contains($InputDate,'.')">
              <xsl:value-of select="concat(substring($InputDate,1,2),'/',substring($InputDate,4,2),'/',substring($InputDate,7))"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="concat(substring($InputDate,1,2),'/',substring($InputDate,3,2),'/',substring($InputDate,5))"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:if>
        <!-- Format JJ.MM.AAAA -->
        <xsl:if test="string-length($InputDate) = 10">
          <xsl:value-of select="concat(substring($InputDate,1,2),'/',substring($InputDate,4,2),'/',substring($InputDate,7))"/>
        </xsl:if>
       <!-- Format JJMMAAAAhhmm -->
        <xsl:if test="string-length($InputDate) = 12">
          <xsl:value-of select="concat(substring($InputDate,1,2),'/',substring($InputDate,3,2),'/',substring($InputDate,5,4),'  ',substring($InputDate,9,2),':',substring($InputDate,11))"/>
        </xsl:if>
        <!-- Format JJMMAAAAhhmmss -->
        <xsl:if test="string-length($InputDate) = 14">
          <xsl:value-of select="concat(substring($InputDate,1,2),'/',substring($InputDate,3,2),'/',substring($InputDate,5,4),'  ',substring($InputDate,9,2),':',substring($InputDate,11,2),':',substring($InputDate,13))"/>
        </xsl:if>
        <!-- Format JJMMAAAAhhmmssxx -->
        <xsl:if test="string-length($InputDate) = 16">
          <xsl:value-of select="concat(substring($InputDate,1,2),'/',substring($InputDate,3,2),'/',substring($InputDate,5,4),'  ',substring($InputDate,9,2),':',substring($InputDate,11,2),':',substring($InputDate,13))"/>
        </xsl:if>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="'displayDateUKXsl ERROR'"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  

  <!-- displayDateJourXsl -->
  <xsl:template name="displayDateJourXsl">
    <xsl:param name='InputDate'/>
    <xsl:if test="string-length($InputDate) > 0">
        <!-- Transformation de 07.05.2010154458 en 07/05/2010 -->
      <xsl:value-of select="concat(substring($InputDate,1,2),'/',substring($InputDate,4,2),'/',substring($InputDate,7,4))"/>
    </xsl:if>       
  </xsl:template> 
  

  <!-- displayDateOrg2    pour transformer une date du format 01012008 en 01/01/08--> 
  <xsl:template name="displayDateOrg2">
    <xsl:param name='InputDateOrg'/>
    <xsl:if test ="string-length($InputDateOrg) = 8">
      <xsl:value-of select="concat(substring($InputDateOrg,1,2),'/',substring($InputDateOrg,3,2),'/',substring($InputDateOrg,7,2))"/>
    </xsl:if>  
  </xsl:template>

  
  <!--displayDateForGraph2-->
  <xsl:template name="displayDateForGraph2">
    <xsl:param name='InputDateForGraph'/>
    <xsl:value-of select="concat(substring($InputDateForGraph,1,2),substring($InputDateForGraph,4,2),substring($InputDateForGraph,7,4))"/>
  </xsl:template>

  <!--displayDateClot-->
  <!-- transformation de 201112 en 12/2011-->
  <xsl:template name ="displayDateClot">
    <xsl:param name='InputDateClot'/>
    <xsl:value-of select="concat(substring($InputDateClot,5,2),'/',substring($InputDateClot,1,4))"/>
  </xsl:template>

   

  <!-- displaySirenXsl -->
  <xsl:template name="displaySirenXsl">
    <xsl:param name='InputSiren'/>
    <xsl:choose>
      <xsl:when test="string-length($InputSiren) = 0">
        <xsl:value-of select="$InputSiren"/>
      </xsl:when>
      <xsl:otherwise >
        <xsl:choose>
          <xsl:when test="string(number($InputSiren)) = 'NaN'">
            <!-- C'est une cl -->
            <xsl:value-of select="$InputSiren"/>
          </xsl:when>
          <xsl:when test="string-length($InputSiren) = 9">
            <!-- c'est un siren-->
            <xsl:value-of select="concat(substring($InputSiren,1,3),' ',substring($InputSiren,4,3),' ',substring($InputSiren,7,3))"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="$InputSiren"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>


  <!-- displaySiretXsl -->
  <xsl:template name="displaySiretXsl">
    <xsl:param name='InputSiret'/>
    <xsl:choose>
      <xsl:when test="string-length($InputSiret) > 13">
        <xsl:value-of select="concat(substring($InputSiret,1,3),' ',substring($InputSiret,4,3),' ',substring($InputSiret,7,3),' ',substring($InputSiret,10,5))"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="'displaySiretXsl ERROR'"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- displayIdentXsl -->
  <xsl:template name="displayIdentXsl">
    <xsl:param name='InputIdent'/>

    <xsl:choose>
      <xsl:when test="string-length($InputIdent) = 0">
        <xsl:value-of select="$InputIdent"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:choose>
          <xsl:when test="string(number($InputIdent)) = 'NaN'">
            <xsl:call-template name='convertcase'>
              <xsl:with-param name='toconvert' select="$InputIdent" />
              <xsl:with-param name='conversion' select="'upper'" />
            </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="concat(substring($InputIdent,1,3),' ',substring($InputIdent,4,3),' ',substring($InputIdent,7,3))"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>


  <!-- displayIdent2Xsl -->
  <xsl:template name="displayIdent2Xsl">
    <xsl:param name='InputIdent'/>


    <xsl:choose>
      <xsl:when test ="contains($InputIdent,'Recherche sur')">
        <xsl:value-of select="$InputIdent"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:choose>
          <xsl:when test ="contains($InputIdent,'Search on')">
            <xsl:value-of select="$InputIdent"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:choose>
              <xsl:when test="string-length($InputIdent) = 0">
                <xsl:value-of select="$InputIdent"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:choose>
                  <xsl:when test="string(number($InputIdent)) = 'NaN'">
                    <!-- C'est une cl -->
                    <xsl:value-of select="$InputIdent"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="concat(substring($InputIdent,1,3),' ',substring($InputIdent,4,3),' ',substring($InputIdent,7,3))"/>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>

  </xsl:template>

  <!-- displayConcatIdentXsl -->
  <xsl:template name="displayConcatIdentXsl">
    <xsl:param name='InputIdent1'/>
    <xsl:param name='InputIdent2'/>
    <xsl:param name='InputIdent3'/>
    <xsl:choose>
      <xsl:when test="string-length($InputIdent3) = 0">
        <!-- concatenation de 2 identifiants
        
        si longueur = 13 alors c'est une cle  ne pas transformer, sinon c'est un siren
        -->
        <xsl:if test ="string-length($InputIdent1) = 13 and string-length($InputIdent2) = 13">
          <xsl:value-of select="concat($InputIdent1, ' ; ' ,$InputIdent2)"/>
        </xsl:if>
        <xsl:if test ="string-length($InputIdent1) = 13 and string-length($InputIdent2) != 13">
          <xsl:value-of select="concat($InputIdent1, ' ; ' ,substring($InputIdent2,1,3),' ',substring($InputIdent2,4,3),' ',substring($InputIdent2,7,3))"/>
        </xsl:if>
        <xsl:if test ="string-length($InputIdent1) != 13 and string-length($InputIdent2) = 13">
          <xsl:value-of select="concat(substring($InputIdent1,1,3),' ',substring($InputIdent1,4,3),' ',substring($InputIdent1,7,3),' ; ',$InputIdent2)"/>
        </xsl:if>
        <xsl:if test ="string-length($InputIdent1) != 13 and string-length($InputIdent2) != 13">
          <xsl:value-of select="concat(substring($InputIdent1,1,3),' ',substring($InputIdent1,4,3),' ',substring($InputIdent1,7,3),' ; ',substring($InputIdent2,1,3),' ',substring($InputIdent2,4,3),' ',substring($InputIdent2,7,3))"/>
        </xsl:if>

      </xsl:when>
      <xsl:otherwise>
        <!-- concatenation de 3 identifiants-->
        <xsl:if test ="string-length($InputIdent3) = 13">
          <xsl:if test ="string-length($InputIdent1) = 13 and string-length($InputIdent2) = 13">
            <xsl:value-of select="concat($InputIdent1, ' ; ' ,$InputIdent2,' ; ' ,$InputIdent3)"/>
          </xsl:if>
          <xsl:if test ="string-length($InputIdent1) = 13 and string-length($InputIdent2) != 13">
            <xsl:value-of select="concat($InputIdent1, ' ; ' ,substring($InputIdent2,1,3),' ',substring($InputIdent2,4,3),' ',substring($InputIdent2,7,3),' ; ' ,$InputIdent3)"/>
          </xsl:if>
          <xsl:if test ="string-length($InputIdent1) != 13 and string-length($InputIdent2) = 13">
            <xsl:value-of select="concat(substring($InputIdent1,1,3),' ',substring($InputIdent1,4,3),' ',substring($InputIdent1,7,3),' ; ',$InputIdent2,' ; ' ,$InputIdent3)"/>
          </xsl:if>
          <xsl:if test ="string-length($InputIdent1) != 13 and string-length($InputIdent2) != 13">
            <xsl:value-of select="concat(substring($InputIdent1,1,3),' ',substring($InputIdent1,4,3),' ',substring($InputIdent1,7,3),' ; ',substring($InputIdent2,1,3),' ',substring($InputIdent2,4,3),' ',substring($InputIdent2,7,3),' ; ',$InputIdent3)"/>
          </xsl:if>
        </xsl:if>
        <xsl:if test ="string-length($InputIdent3) != 13">
          <xsl:if test ="string-length($InputIdent1) = 13 and string-length($InputIdent2) = 13">
            <xsl:value-of select="concat($InputIdent1, ' ; ' ,$InputIdent2,' ; ',substring($InputIdent3,1,3),' ',substring($InputIdent3,4,3),' ',substring($InputIdent3,7,3))"/>
          </xsl:if>
          <xsl:if test ="string-length($InputIdent1) = 13 and string-length($InputIdent2) != 13">
            <xsl:value-of select="concat($InputIdent1, ' ; ' ,substring($InputIdent2,1,3),' ',substring($InputIdent2,4,3),' ',substring($InputIdent2,7,3),' ; ',substring($InputIdent3,1,3),' ',substring($InputIdent3,4,3),' ',substring($InputIdent3,7,3))"/>
          </xsl:if>
          <xsl:if test ="string-length($InputIdent1) != 13 and string-length($InputIdent2) = 13">
            <xsl:value-of select="concat(substring($InputIdent1,1,3),' ',substring($InputIdent1,4,3),' ',substring($InputIdent1,7,3),' ; ',$InputIdent2,' ; ',substring($InputIdent3,1,3),' ',substring($InputIdent3,4,3),' ',substring($InputIdent3,7,3))"/>
          </xsl:if>
          <xsl:if test ="string-length($InputIdent1) != 13 and string-length($InputIdent2) != 13">
            <xsl:value-of select="concat(substring($InputIdent1,1,3),' ',substring($InputIdent1,4,3),' ',substring($InputIdent1,7,3),' ; ',substring($InputIdent2,1,3),' ',substring($InputIdent2,4,3),' ',substring($InputIdent2,7,3),' ; ',substring($InputIdent3,1,3),' ',substring($InputIdent3,4,3),' ',substring($InputIdent3,7,3))"/>
          </xsl:if>
        </xsl:if>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

   
  <!-- displayTeleph2 -->
  <xsl:template name="displayTeleph2">
    <xsl:param name='InputNumTel'/>
    <xsl:value-of select="concat(substring($InputNumTel,1,2),' ',substring($InputNumTel,3,2),' ',substring($InputNumTel,5,2),' ',substring($InputNumTel,7,2),' ',substring($InputNumTel,9,2))"/>
  </xsl:template>

  <!-- displayTitreACTBDF -->
  <xsl:template name="displayTitreACTBDF">
    <xsl:param name='Actbdf'/>
    <xsl:param name ='Libact'/>
    <xsl:value-of select="concat($Actbdf,' ',$Libact)"/>
  </xsl:template>
  
  <!-- displayUnitXsl -->
  <xsl:template name ="displayUnitXsl">
    <xsl:param name='InputUnit'/>
    <xsl:if test ="$InputUnit='U'">
      <xsl:value-of select='"&#160;"'/>
    </xsl:if>
    <xsl:if test ="$InputUnit='k'">
      <xsl:value-of select='"&#160;milliers d&#39;"'/>
    </xsl:if>
    <xsl:if test ="$InputUnit='K'">
      <xsl:value-of select='"&#160;milliers d&#39;"'/>
    </xsl:if>
    <xsl:if test ="$InputUnit='M'">
      <xsl:value-of select='"&#160;millions d&#39;"'/>
    </xsl:if>
    <xsl:if test ="$InputUnit='G'">
      <xsl:value-of select='"&#160;milliards d&#39;"'/>
    </xsl:if>
  </xsl:template>


  
  <!-- displayUnitXsl2 -->
  
  <xsl:template name ="displayUnitXsl2">
    <xsl:param name='InputUnit'/>
    <xsl:param name ='Indic'/>
    <xsl:choose >
      <xsl:when test ="$Indic = '1'">
        <xsl:if test ="$InputUnit= 'U'">
          <xsl:value-of select='"&#160;"'/>
        </xsl:if>
        <xsl:if test ="$InputUnit= 'k'">
          <xsl:value-of select='"&#160;k"'/>
        </xsl:if>
        <xsl:if test ="$InputUnit= 'K'">
          <xsl:value-of select='"&#160;k"'/>
        </xsl:if>
        <xsl:if test ="$InputUnit= 'M'">
          <xsl:value-of select='"&#160;M"'/>
        </xsl:if>
        <xsl:if test ="$InputUnit= 'G'">
          <xsl:value-of select='"&#160;G"'/>
        </xsl:if>
      </xsl:when>
      <xsl:otherwise >
        <xsl:if test ="$InputUnit= 'U'">
          <xsl:value-of select='"&#160;"'/>
        </xsl:if>
        <xsl:if test ="$InputUnit= 'k'">
          <xsl:value-of select='"&#160;milliers d&#39;"'/>
        </xsl:if>
        <xsl:if test ="$InputUnit= 'K'">
          <xsl:value-of select='"&#160;milliers d&#39;"'/>
        </xsl:if>
        <xsl:if test ="$InputUnit= 'M'">
          <xsl:value-of select='"&#160;millions d&#39;"'/>
        </xsl:if>
        <xsl:if test ="$InputUnit= 'G'">
          <xsl:value-of select='"&#160;milliards d&#39;"'/>
        </xsl:if>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template> 
    

  <xsl:template name="displayPourcentageXsl">
    <xsl:param name='InputValue'/>
    <xsl:choose >
      <xsl:when test="string-length($InputValue) > 0">
        <xsl:variable name='Pourcent' select='($InputValue div 10)'/>
        <xsl:variable name ="PartieDecimal" select ="(substring-after($Pourcent,'.'))"></xsl:variable>
        <xsl:variable name ="PartieEntiere" select ="(substring-before($Pourcent,'.'))"></xsl:variable>
        <xsl:value-of select ="concat(($PartieEntiere),'.',(substring($PartieDecimal,1,2)))"/>        
      </xsl:when>
      <xsl:otherwise >
        <xsl:value-of select="'displayPourcentageXsl ERROR'"/>
      </xsl:otherwise>
      </xsl:choose>   
  </xsl:template>
  
<!-- ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ --> 
<!-- -  -  -  -  -  -  - displayInLowerCaseXsl  -  -  -  -  -  - -->

  <!-- Concatenation du Nom et du Prnom aprs transformation -->
  <!-- de l'attribut prnom avec le 1er caractre en majuscule et la suite en minuscule. -->
  <!-- Attention : cas particulier des prnoms compos contenat soit des "-" soit des espaces soit les deux-->
  <!-- 11 cas possible ==> cas 1 : PRENOM1 PRENOM2 PRENOM3 PRENOM4 -->
  <!-- cas 2 : PRENOM1 PRENOM2 PRENOM3-PRENOM4 -->
  <!-- cas 3 : PRENOM1 PRENOM2-PRENOM3 PRENOM4 -->
  <!-- cas 4 : PRENOM1-PRENOM2 PRENOM3 PRENOM4 -->
  <!-- cas 5 : PRENOM1 PRENOM2 PRENOM3 -->
  <!-- cas 6 : PRENOM1 PRENOM2 -->
  <!-- cas 7 : PRENOM1 PRENOM2-PRENOM3 -->
  <!-- cas 8 : PRENOM1-PRENOM2 -->
  <!-- cas 9 : PRENOM1-PRENOM2 PRENOM3 -->
  <!-- cas 10 : PRENOM1-PRENOM2 PRENOM3-PRENOM4 -->
  <!-- cas 11 : PRENOM1-PRENOM2-PRENOM3 (normalement impossible)-->


  <xsl:template name="displayInLowerCaseXsl">
    <xsl:param name="InputIdentc"/>
    <xsl:param name="InputStringNom"/>
    <xsl:param name="InputStringPrenom"/>

    <xsl:variable name="MIN">abcdefghijklmnopqrstuvwxyz</xsl:variable>
    <xsl:variable name="MAJ">ABCDEFGHIJKLMNOPQRSTUVWXYZ</xsl:variable>

    <xsl:choose>
      <xsl:when test ="(contains($InputStringPrenom,'-'))">
        <xsl:choose >
          <xsl:when test ="(contains($InputStringPrenom,' '))">
            <!-- differents cas de composition de prnom soit avec 3 ou 4 parties -->
            <!-- cas n 2 ou 3 ou 4 ou 7 ou 9 ou 10 -->
            <!-- * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *-->
            <xsl:variable name ="AvantTiret" select ="(substring-before($InputStringPrenom,'-'))"></xsl:variable>
            <xsl:variable name ="ApresTiret" select ="(substring-after($InputStringPrenom,'-'))"></xsl:variable>

            <xsl:choose>
              <xsl:when test ="(contains($AvantTiret,' '))">
                <!-- cas n2 ou 3 ou 7 -->
                <!-- cas espace avant tiret ex: LEON ALBERT JACQUES-HENRY ou ALBERT JACQUES-HENRY -->

                <!-- la variable AvanTiret contient LEON ALBERT JACQUES ou ALBERT JACQUES-->
                <!-- la variable ApresTiret contient HENRY-->
                <!-- la variable premierepartieprenom contient LEON-->
                <!-- la variable Reste1erPartiePrenom contient ALBERT JACQUES  ou JACQUES-->
                <xsl:variable name="premierepartieprenom" select="(substring-before($AvantTiret,' '))"></xsl:variable>
                <xsl:variable name ="Reste1erPartiePrenom" select ="(substring-after($AvantTiret,' '))"></xsl:variable>
                <xsl:choose>
                  <xsl:when test ="(contains($Reste1erPartiePrenom,' '))">
                    <!-- cas n 2-->
                    <!-- ex: LEON ALBERT JACQUES-HENRY-->
                    <!-- la variable deuxiemepartieprenom contient ALBERT-->
                    <!-- la variable troisiemepartieprenom contient JACQUES-->
                    <xsl:variable name="deuxiemepartieprenom" select="(substring-before($Reste1erPartiePrenom,' '))"></xsl:variable>
                    <xsl:variable name="troisiemepartieprenom" select="(substring-after($Reste1erPartiePrenom,' '))"></xsl:variable>
                    <!-- la variable elementRestant1A contient EON-->
                    <!-- la variable elementRestant2A contient LBERT-->
                    <!-- la variable elementRestant3A contient ACQUES-->
                    <!-- la variable elementRestant4A contient ENRY-->
                    <xsl:variable name ="elementRestant1A" select ="substring($premierepartieprenom,2)"></xsl:variable>
                    <xsl:variable name ="elementRestant2A" select ="substring($deuxiemepartieprenom,2)"></xsl:variable>
                    <xsl:variable name ="elementRestant3A" select ="substring($troisiemepartieprenom,2)"></xsl:variable>
                    <xsl:variable name ="elementRestant4A" select ="substring($ApresTiret,2)"></xsl:variable>

                    <!-- cas particulier de la concatnation de l'identifiant avec le Nom et le Prnom-->
                    <xsl:if test ="string-length($InputIdentc) > 0">
                      <xsl:value-of select ="concat(($InputIdentc),'-',($InputStringNom),' ',(substring($premierepartieprenom,1,1)),(translate(string($elementRestant1A),string($MAJ),string($MIN))),' ',(substring($deuxiemepartieprenom,1,1)),(translate(string($elementRestant2A),string($MAJ),string($MIN))),' ',(substring($troisiemepartieprenom,1,1)),(translate(string($elementRestant3A),string($MAJ),string($MIN))),'-',(substring($ApresTiret,1,1)),(translate(string($elementRestant4A),string($MAJ),string($MIN))))"/>
                    </xsl:if>
                    <xsl:if test ="string-length($InputIdentc) = 0">
                      <xsl:value-of select ="concat(($InputStringNom),' ',(substring($premierepartieprenom,1,1)),(translate(string($elementRestant1A),string($MAJ),string($MIN))),' ',(substring($deuxiemepartieprenom,1,1)),(translate(string($elementRestant2A),string($MAJ),string($MIN))),' ',(substring($troisiemepartieprenom,1,1)),(translate(string($elementRestant3A),string($MAJ),string($MIN))),'-',(substring($ApresTiret,1,1)),(translate(string($elementRestant4A),string($MAJ),string($MIN))))"/>
                    </xsl:if>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:choose>
                      <xsl:when test ="(contains($ApresTiret,' '))">
                        <!-- cas n3 -->
                        <!-- ex: ALAIN JEAN-PIERRE ERIC-->
                        <!-- ALAIN est dj dansla variable premierepartieprenom -->
                        <!-- JEAN est dj dansla variable Reste1erPartiePrenom -->
                        <!-- la variable troisiemepartieprenom2 contient PIERRE-->
                        <!-- la variable quatriemepartieprenom2 contient ERIC-->
                        <xsl:variable name ="troisiemepartieprenom2" select ="substring-before($ApresTiret,' ')"></xsl:variable>
                        <xsl:variable name ="quatriemepartieprenom2" select ="substring-after($ApresTiret,' ')"></xsl:variable>
                        <!-- la variable elementRestant1C contient LAIN-->
                        <!-- la variable elementRestant2C contient EAN-->
                        <!-- la variable elementRestant3C contient IERRE-->
                        <!-- la variable elementRestant4C contient RIC-->
                        <xsl:variable name ="elementRestant1C" select ="substring($premierepartieprenom,2)"></xsl:variable>
                        <xsl:variable name ="elementRestant2C" select ="substring($Reste1erPartiePrenom,2)"></xsl:variable>
                        <xsl:variable name ="elementRestant3C" select ="substring($troisiemepartieprenom2,2)"></xsl:variable>
                        <xsl:variable name ="elementRestant4C" select ="substring($quatriemepartieprenom2,2)"></xsl:variable>

                        <!-- cas particulier de la concatnation de l'identifiant avec le Nom et le Prnom-->
                        <xsl:if test ="string-length($InputIdentc) > 0">
                          <xsl:value-of select ="concat(($InputIdentc),'-',($InputStringNom),' ',(substring($premierepartieprenom,1,1)),(translate(string($elementRestant1C),string($MAJ),string($MIN))),' ',(substring($Reste1erPartiePrenom,1,1)),(translate(string($elementRestant2C),string($MAJ),string($MIN))),'-',(substring($troisiemepartieprenom2,1,1)),(translate(string($elementRestant3C),string($MAJ),string($MIN))),' ',(substring($quatriemepartieprenom2,1,1)),(translate(string($elementRestant4C),string($MAJ),string($MIN))))"/>
                        </xsl:if>
                        <xsl:if test ="string-length($InputIdentc) = 0">
                          <xsl:value-of select ="concat(($InputStringNom),' ',(substring($premierepartieprenom,1,1)),(translate(string($elementRestant1C),string($MAJ),string($MIN))),' ',(substring($Reste1erPartiePrenom,1,1)),(translate(string($elementRestant2C),string($MAJ),string($MIN))),'-',(substring($troisiemepartieprenom2,1,1)),(translate(string($elementRestant3C),string($MAJ),string($MIN))),' ',(substring($quatriemepartieprenom2,1,1)),(translate(string($elementRestant4C),string($MAJ),string($MIN))))"/>
                        </xsl:if>
                      </xsl:when>

                      <xsl:otherwise>
                        <!-- cas n 7 -->
                        <!-- ex: ALBERT JACQUES-HENRY-->
                        <!-- ALBERT est dj dans la variable premierepartieprenom -->
                        <!-- JACQUES est dj dans la variable Reste1erPartiePrenom -->
                        <!-- HENRY est dj dans la variable ApresTiret-->
                        <!-- la variable elementRestant1B contient LBERT-->
                        <!-- la variable elementRestant2B contient ACQUES-->
                        <!-- la variable elementRestant3B contient ENRY-->
                        <xsl:variable name ="elementRestant1B" select ="substring($premierepartieprenom,2)"></xsl:variable>
                        <xsl:variable name ="elementRestant2B" select ="substring($Reste1erPartiePrenom,2)"></xsl:variable>
                        <xsl:variable name ="elementRestant3B" select ="substring($ApresTiret,2)"></xsl:variable>

                        <!-- cas particulier de la concatnation de l'identifiant avec le Nom et le Prnom-->
                        <xsl:if test ="string-length($InputIdentc) > 0">
                          <xsl:value-of select ="concat(($InputIdentc),'-',($InputStringNom),' ',(substring($premierepartieprenom,1,1)),(translate(string($elementRestant1B),string($MAJ),string($MIN))),' ',(substring($Reste1erPartiePrenom,1,1)),(translate(string($elementRestant2B),string($MAJ),string($MIN))),'-',(substring($ApresTiret,1,1)),(translate(string($elementRestant3B),string($MAJ),string($MIN))))"/>
                        </xsl:if>
                        <xsl:if test ="string-length($InputIdentc) = 0">
                          <xsl:value-of select ="concat(($InputStringNom),' ',(substring($premierepartieprenom,1,1)),(translate(string($elementRestant1B),string($MAJ),string($MIN))),' ',(substring($Reste1erPartiePrenom,1,1)),(translate(string($elementRestant2B),string($MAJ),string($MIN))),'-',(substring($ApresTiret,1,1)),(translate(string($elementRestant3B),string($MAJ),string($MIN))))"/>
                        </xsl:if>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>
              <xsl:otherwise>
                <xsl:choose>
                  <xsl:when test ="(contains($ApresTiret,'-'))">
                    <!-- cas n10-->
                    <!-- cas tiret avant espace  ex: JEAN-PATRICK PIERE-NICOLAS -->
                    <!-- la variable AvanTiret contient JEAN-->
                    <!-- la variable ApresTiret contient PATRICK PIERRE-NICOLAS-->
                    <!-- la variable deuxiemepartieprenom3 contient PATRICK-->
                    <!-- la variable restedeuxiemeprenom contient PIERRE-NICOLAS-->
                    <!-- la variable troisiemepartieprenom3 contient PIERRE-->
                    <!-- la variable quatriemepartieprenom3 contient NICOLAS-->
                    <xsl:variable name="deuxiemepartieprenom3" select="(substring-before($ApresTiret,' '))"></xsl:variable>
                    <xsl:variable name="restedeuxiemeprenom" select="(substring-after($ApresTiret,' '))"></xsl:variable>
                    <xsl:variable name="troisiemepartieprenom3" select="(substring-before($restedeuxiemeprenom,'-'))"></xsl:variable>
                    <xsl:variable name="quatriemepartieprenom3" select="(substring-after($restedeuxiemeprenom,'-'))"></xsl:variable>
                    <!-- la variable elementRestant1D contient EAN-->
                    <!-- la variable elementRestant2D contient ATRICK-->
                    <!-- la variable elementRestant3D contient IERRE-->
                    <!-- la variable elementRestant4D contient ICOLAS-->
                    <xsl:variable name ="elementRestant1D" select ="substring($AvantTiret,2)"></xsl:variable>
                    <xsl:variable name ="elementRestant2D" select ="substring($deuxiemepartieprenom3,2)"></xsl:variable>
                    <xsl:variable name ="elementRestant3D" select ="substring($troisiemepartieprenom3,2)"></xsl:variable>
                    <xsl:variable name ="elementRestant4D" select ="substring($quatriemepartieprenom3,2)"></xsl:variable>

                    <!-- cas particulier de la concatnation de l'identifiant avec le Nom et le Prnom-->
                    <xsl:if test ="string-length($InputIdentc) > 0">
                      <xsl:value-of select ="concat(($InputIdentc),'-',($InputStringNom),' ',(substring($AvantTiret,1,1)),(translate(string($elementRestant1D),string($MAJ),string($MIN))),'-',(substring($deuxiemepartieprenom3,1,1)),(translate(string($elementRestant2D),string($MAJ),string($MIN))),' ',(substring($troisiemepartieprenom3,1,1)),(translate(string($elementRestant3D),string($MAJ),string($MIN))),' ',(substring($quatriemepartieprenom3,1,1)),(translate(string($elementRestant4D),string($MAJ),string($MIN))))"/>
                    </xsl:if>
                    <xsl:if test ="string-length($InputIdentc) = 0">
                      <xsl:value-of select ="concat(($InputStringNom),' ',(substring($AvantTiret,1,1)),(translate(string($elementRestant1D),string($MAJ),string($MIN))),'-',(substring($deuxiemepartieprenom3,1,1)),(translate(string($elementRestant2D),string($MAJ),string($MIN))),' ',(substring($troisiemepartieprenom3,1,1)),(translate(string($elementRestant3D),string($MAJ),string($MIN))),' ',(substring($quatriemepartieprenom3,1,1)),(translate(string($elementRestant4D),string($MAJ),string($MIN))))"/>
                    </xsl:if>

                  </xsl:when>
                  <xsl:otherwise>
                    <!-- cas n 4 ou 9 -->
                    <!-- cas tiret avant espace  ex: JEAN-PIERRE MAURICE ou JEAN-PAUL LOUIS ERIC-->
                    <xsl:variable name ="TestApresTiret" select ="(substring-after($ApresTiret,' '))"></xsl:variable>
                    <xsl:choose>
                      <xsl:when test ="(contains($TestApresTiret,' '))">
                        <!-- cas n 4 -->
                        <!-- ex:JEAN-PAUL LOUIS ERIC-->
                        <!-- la variable AvanTiret contient JEAN-->
                        <!-- la variable ApresTiret contient PAUL LOUIS ERIC-->
                        <!-- la variable TestApresTiret contient LOUIS ERIC-->
                        <!-- la variable deuxiemepartieprenom4 contient PAUL-->
                        <!-- la variable restepartieprenom4 contient LOUIS ERIC-->
                        <!-- la variable troisiemepartieprenom4 contient LOUIS-->
                        <!-- la variable quatriemepartieprenom4 contient ERIC-->
                        <xsl:variable name="deuxiemepartieprenom4" select="(substring-before($ApresTiret,' '))"></xsl:variable>
                        <xsl:variable name="restepartieprenom4" select="(substring-after($ApresTiret,' '))"></xsl:variable>
                        <xsl:variable name="troisiemepartieprenom4" select="(substring-before($restepartieprenom4,' '))"></xsl:variable>
                        <xsl:variable name="quatriemepartieprenom4" select="(substring-after($restepartieprenom4,' '))"></xsl:variable>
                        <!-- la variable elementRestant1E contient EAN-->
                        <!-- la variable elementRestant2E contient AUL-->
                        <!-- la variable elementRestant3E contient OUIS-->
                        <!-- la variable elementRestant3E contient RIC-->
                        <xsl:variable name ="elementRestant1E" select ="substring($AvantTiret,2)"></xsl:variable>
                        <xsl:variable name ="elementRestant2E" select ="substring($deuxiemepartieprenom4,2)"></xsl:variable>
                        <xsl:variable name ="elementRestant3E" select ="substring($troisiemepartieprenom4,2)"></xsl:variable>
                        <xsl:variable name ="elementRestant4E" select ="substring($quatriemepartieprenom4,2)"></xsl:variable>

                        <!-- cas particulier de la concatnation de l'identifiant avec le Nom et le Prnom-->
                        <xsl:if test ="string-length($InputIdentc) > 0">
                          <xsl:value-of select ="concat(($InputIdentc),'-',($InputStringNom),' ',(substring($AvantTiret,1,1)),(translate(string($elementRestant1E),string($MAJ),string($MIN))),'-',(substring($deuxiemepartieprenom4,1,1)),(translate(string($elementRestant2E),string($MAJ),string($MIN))),' ',(substring($troisiemepartieprenom4,1,1)),(translate(string($elementRestant3E),string($MAJ),string($MIN))),' ',(substring($quatriemepartieprenom4,1,1)),(translate(string($elementRestant4E),string($MAJ),string($MIN))))"/>
                        </xsl:if>
                        <xsl:if test ="string-length($InputIdentc) = 0">
                          <xsl:value-of select ="concat(($InputStringNom),' ',(substring($AvantTiret,1,1)),(translate(string($elementRestant1E),string($MAJ),string($MIN))),'-',(substring($deuxiemepartieprenom4,1,1)),(translate(string($elementRestant2E),string($MAJ),string($MIN))),' ',(substring($troisiemepartieprenom4,1,1)),(translate(string($elementRestant3E),string($MAJ),string($MIN))),' ',(substring($quatriemepartieprenom4,1,1)),(translate(string($elementRestant4E),string($MAJ),string($MIN))))"/>
                        </xsl:if>
                      </xsl:when>

                      <xsl:otherwise>
                        <!-- cas n9 -->
                        <!-- ex: JEAN-PIERRE MAURICE -->

                        <!-- la variable AvanTiret contient JEAN-->
                        <!-- la variable ApresTiret contient PIERRE MAURICE-->
                        <!-- la variable deuxiemepartieprenom contient PIERRE-->
                        <!-- la variable troisiemepartieprenom contient MAURICE-->
                        <xsl:variable name="deuxiemepartieprenom" select="(substring-before($ApresTiret,' '))"></xsl:variable>
                        <xsl:variable name="troisiemepartieprenom" select="(substring-after($ApresTiret,' '))"></xsl:variable>
                        <!-- la variable elementRestant1B contient EAN-->
                        <!-- la variable elementRestant2B contient IERRE-->
                        <!-- la variable elementRestant3B contient AURICE-->
                        <xsl:variable name ="elementRestant1B" select ="substring($AvantTiret,2)"></xsl:variable>
                        <xsl:variable name ="elementRestant2B" select ="substring($deuxiemepartieprenom,2)"></xsl:variable>
                        <xsl:variable name ="elementRestant3B" select ="substring($troisiemepartieprenom,2)"></xsl:variable>

                        <!-- cas particulier de la concatnation de l'identifiant avec le Nom et le Prnom-->
                        <xsl:if test ="string-length($InputIdentc) > 0">
                          <xsl:value-of select ="concat(($InputIdentc),'-',($InputStringNom),' ',(substring($AvantTiret,1,1)),(translate(string($elementRestant1B),string($MAJ),string($MIN))),'-',(substring($deuxiemepartieprenom,1,1)),(translate(string($elementRestant2B),string($MAJ),string($MIN))),' ',(substring($troisiemepartieprenom,1,1)),(translate(string($elementRestant3B),string($MAJ),string($MIN))))"/>
                        </xsl:if>
                        <xsl:if test ="string-length($InputIdentc) = 0">
                          <xsl:value-of select ="concat(($InputStringNom),' ',(substring($AvantTiret,1,1)),(translate(string($elementRestant1B),string($MAJ),string($MIN))),'-',(substring($deuxiemepartieprenom,1,1)),(translate(string($elementRestant2B),string($MAJ),string($MIN))),' ',(substring($troisiemepartieprenom,1,1)),(translate(string($elementRestant3B),string($MAJ),string($MIN))))"/>
                        </xsl:if>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
          <xsl:otherwise>
            <!-- ex: JEAN-PIERRE-->
            <!-- * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *-->
            <xsl:variable name="premierepartieprenom" select="(substring-before($InputStringPrenom,'-'))"></xsl:variable>
            <xsl:variable name="resteprenom" select="(substring-after($InputStringPrenom,'-'))"></xsl:variable>
            <xsl:variable name="resteprenom2" select="(substring-after($resteprenom,'-'))"></xsl:variable>
            <!-- compos en 2,3 ou 4 parties ?-->

            <xsl:if test ="string-length($resteprenom2) = 0">
              <!-- cas n8 prnom en 2 parties exemple JEAN-PIERRE-->
              <!-- la variable "elementRestant1C" est gale  "EAN"-->
              <!-- la variable "elementRestant2C" est gale  "IERRE"-->
              <xsl:variable name ="elementRestant1C" select ="substring($premierepartieprenom,2)"></xsl:variable>
              <xsl:variable name ="elementRestant2C" select ="substring($resteprenom,2)"></xsl:variable>
              <!-- cas particulier de la concatnation de l'identifiant avec le Nom et le Prnom-->
              <xsl:if test ="string-length($InputIdentc) > 0">
                <xsl:value-of select ="concat(($InputIdentc),'-',($InputStringNom),' ',(substring($premierepartieprenom,1,1)),(translate(string($elementRestant1C),string($MAJ),string($MIN))),'-',(substring($resteprenom,1,1)),(translate(string($elementRestant2C),string($MAJ),string($MIN))))"/>
              </xsl:if>
              <xsl:if test ="string-length($InputIdentc) = 0">
                <xsl:value-of select ="concat(($InputStringNom),' ',(substring($premierepartieprenom,1,1)),(translate(string($elementRestant1C),string($MAJ),string($MIN))),'-',(substring($resteprenom,1,1)),(translate(string($elementRestant2C),string($MAJ),string($MIN))))"/>
              </xsl:if>
            </xsl:if>

            <!-- cas n 11 prnom en 3 parties exemple JEAN-PIERRE-ETIENNE-->
            <!-- la variable "deuxiemeprenom" est gale  "PIERRE"-->
            <!-- la variable "elementRestant1D" est gale  "EAN"-->
            <!-- la variable "elementRestant2D" est gale  "IERRE"-->
            <!-- la variable "elementRestant3D" est gale  "TIENNE"-->
            <xsl:if test ="string-length($resteprenom2) > 0">
              <!-- recupration de la 2eme partie du prnom -->
              <xsl:variable name ="deuxiemeprenom" select ="(substring-before($resteprenom,'-'))"></xsl:variable>
              <xsl:variable name ="elementRestant1D" select ="substring($premierepartieprenom,2)"></xsl:variable>
              <xsl:variable name ="elementRestant2D" select ="substring($deuxiemeprenom,2)"></xsl:variable>
              <xsl:variable name ="elementRestant3D" select ="substring($resteprenom2,2)"></xsl:variable>
              <!-- cas particulier de la concatnation de l'identifiant avec le Nom et le Prnom-->
              <xsl:if test ="string-length($InputIdentc) > 0">
                <xsl:value-of select ="concat(($InputIdentc),'-',($InputStringNom),' ',(substring($premierepartieprenom,1,1)),(translate(string($elementRestant1D),string($MAJ),string($MIN))),'-',(substring($deuxiemeprenom,1,1)),(translate(string($elementRestant2D),string($MAJ),string($MIN))),'-',(substring($resteprenom2,1,1)),(translate(string($elementRestant3D),string($MAJ),string($MIN))))"/>
              </xsl:if>
              <xsl:if test ="string-length($InputIdentc) = 0">
                <xsl:value-of select ="concat(($InputStringNom),' ',(substring($premierepartieprenom,1,1)),(translate(string($elementRestant1D),string($MAJ),string($MIN))),'-',(substring($deuxiemeprenom,1,1)),(translate(string($elementRestant2D),string($MAJ),string($MIN))),'-',(substring($resteprenom2,1,1)),(translate(string($elementRestant3D),string($MAJ),string($MIN))))"/>
              </xsl:if>
            </xsl:if>

          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <xsl:choose>
          <xsl:when test ="(contains($InputStringPrenom,' '))">
            <!-- * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *-->
            <xsl:variable name="premierepartieprenom" select="(substring-before($InputStringPrenom,' '))"></xsl:variable>
            <xsl:variable name="resteprenom" select="(substring-after($InputStringPrenom,' '))"></xsl:variable>
            <xsl:variable name="resteprenom2" select="(substring-after($resteprenom,' '))"></xsl:variable>
            <!-- compos en 2,3 ou 4 parties ?-->
            <xsl:choose>
              <xsl:when test ="string-length($resteprenom2) = 0">
                <!-- cas n6 prnom en 2 parties exemple PIERRE ETIENNE-->
                <!-- la variable "elementRestant1E" est gale  "IERRE"-->
                <!-- la variable "elementRestant2E" est gale  "TIENNE"-->
                <xsl:variable name ="elementRestant1E" select ="substring($premierepartieprenom,2)"></xsl:variable>
                <xsl:variable name ="elementRestant2E" select ="substring($resteprenom,2)"></xsl:variable>
                <!-- cas particulier de la concatnation de l'identifiant avec le Nom et le Prnom-->
                <xsl:if test ="string-length($InputIdentc) > 0">
                  <xsl:value-of select ="concat(($InputIdentc),'-',($InputStringNom),' ',(substring($premierepartieprenom,1,1)),(translate(string($elementRestant1E),string($MAJ),string($MIN))),' ',(substring($resteprenom,1,1)),(translate(string($elementRestant2E),string($MAJ),string($MIN))))"/>
                </xsl:if>
                <xsl:if test ="string-length($InputIdentc) = 0">
                  <xsl:value-of select ="concat(($InputStringNom),' ',(substring($premierepartieprenom,1,1)),(translate(string($elementRestant1E),string($MAJ),string($MIN))),' ',(substring($resteprenom,1,1)),(translate(string($elementRestant2E),string($MAJ),string($MIN))))"/>
                </xsl:if>
              </xsl:when>
              <xsl:otherwise>
                <!-- cas prnom en 3 ou 4 parties exemple PIERRE ETIENNE MARCEL ou ALAIN DENIS PASCAL LOUIS-->
                <xsl:choose>
                  <xsl:when test ="(contains($resteprenom2,' '))">
                    <!-- cas n1 -->
                    <!--ex: ALAIN DENIS PASCAL LOUIS-->
                    <!-- ALAIN est dj dans la variable "premierepartieprenom" -->
                    <!-- la variable "deuxiemepartieprenom5" est gale  "DENIS"-->
                    <!-- la variable "resteprenom2" est gale  PASCAL LOUIS-->
                    <!-- la variable "troisiemepartieprenom5" est gale  "PASCAL"-->
                    <!-- la variable "quatriemepartieprenom5" est gale  "LOUIS"-->
                    <xsl:variable name ="deuxiemepartieprenom5" select ="(substring-before($resteprenom,' '))"></xsl:variable>
                    <xsl:variable name ="troisiemepartieprenom5" select ="substring-before($resteprenom2,' ')"></xsl:variable>
                    <xsl:variable name ="quatriemepartieprenom5" select ="substring-after($resteprenom2,' ')"></xsl:variable>
                    <!-- la variable "elementRestant1G" est gale  "LAIN"-->
                    <!-- la variable "elementRestant2G" est gale  "ENIS"-->
                    <!-- la variable "elementRestant3G" est gale  "ASCAL"-->
                    <!-- la variable "elementRestant4G" est gale  "OUIS"-->
                    <xsl:variable name ="elementRestant1G" select ="substring($premierepartieprenom,2)"></xsl:variable>
                    <xsl:variable name ="elementRestant2G" select ="substring($deuxiemepartieprenom5,2)"></xsl:variable>
                    <xsl:variable name ="elementRestant3G" select ="substring($troisiemepartieprenom5,2)"></xsl:variable>
                    <xsl:variable name ="elementRestant4G" select ="substring($quatriemepartieprenom5,2)"></xsl:variable>

                    <!-- cas particulier de la concatnation de l'identifiant avec le Nom et le Prnom-->
                    <xsl:if test ="string-length($InputIdentc) > 0">
                      <xsl:value-of select ="concat(($InputIdentc),'-',($InputStringNom),' ',(substring($premierepartieprenom,1,1)),(translate(string($elementRestant1G),string($MAJ),string($MIN))),' ',(substring($deuxiemepartieprenom5,1,1)),(translate(string($elementRestant2G),string($MAJ),string($MIN))),' ',(substring($troisiemepartieprenom5,1,1)),(translate(string($elementRestant3G),string($MAJ),string($MIN))),' ',(substring($quatriemepartieprenom5,1,1)),(translate(string($elementRestant4G),string($MAJ),string($MIN))))"/>
                    </xsl:if>
                    <xsl:if test ="string-length($InputIdentc) = 0">
                      <xsl:value-of select ="concat(($InputStringNom),' ',(substring($premierepartieprenom,1,1)),(translate(string($elementRestant1G),string($MAJ),string($MIN))),' ',(substring($deuxiemepartieprenom5,1,1)),(translate(string($elementRestant2G),string($MAJ),string($MIN))),' ',(substring($troisiemepartieprenom5,1,1)),(translate(string($elementRestant3G),string($MAJ),string($MIN))),' ',(substring($quatriemepartieprenom5,1,1)),(translate(string($elementRestant4G),string($MAJ),string($MIN))))"/>
                    </xsl:if>
                  </xsl:when>
                  <xsl:otherwise>
                    <!-- cas n5 -->
                    <!--ex: PIERRE ETIENNE MARCEL-->
                    <!-- la variable "deuxiemeprenom" est gale  "ETIENNE MARCEL"-->
                    <!-- la variable "elementRestant1B" est gale  "IERRE"-->
                    <!-- la variable "elementRestant2B" est gale  "TIENNE"-->
                    <!-- la variable "elementRestant3B" est gale  "ARCEL"-->
                    <!--<xsl:if test ="string-length($resteprenom2) > 0">-->
                    <!-- recupration de la 2eme partie du prnom -->
                    <xsl:variable name ="deuxiemeprenom" select ="(substring-before($resteprenom,' '))"></xsl:variable>
                    <xsl:variable name ="elementRestant1F" select ="substring($premierepartieprenom,2)"></xsl:variable>
                    <xsl:variable name ="elementRestant2F" select ="substring($deuxiemeprenom,2)"></xsl:variable>
                    <xsl:variable name ="elementRestant3F" select ="substring($resteprenom2,2)"></xsl:variable>
                    <!-- cas particulier de la concatnation de l'identifiant avec le Nom et le Prnom-->
                    <xsl:if test ="string-length($InputIdentc) > 0">
                      <xsl:value-of select ="concat(($InputIdentc),'-',($InputStringNom),' ',(substring($premierepartieprenom,1,1)),(translate(string($elementRestant1F),string($MAJ),string($MIN))),' ',(substring($deuxiemeprenom,1,1)),(translate(string($elementRestant2F),string($MAJ),string($MIN))),' ',(substring($resteprenom2,1,1)),(translate(string($elementRestant3F),string($MAJ),string($MIN))))"/>
                    </xsl:if>
                    <xsl:if test ="string-length($InputIdentc) = 0">
                      <xsl:value-of select ="concat(($InputStringNom),' ',(substring($premierepartieprenom,1,1)),(translate(string($elementRestant1F),string($MAJ),string($MIN))),' ',(substring($deuxiemeprenom,1,1)),(translate(string($elementRestant2F),string($MAJ),string($MIN))),' ',(substring($resteprenom2,1,1)),(translate(string($elementRestant3F),string($MAJ),string($MIN))))"/>
                    </xsl:if>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
          <xsl:otherwise>
            <!--cas gnral ex: ALAIN-->
            <!-- * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *-->

            <!-- la variable "elementRestant" est gale  "LAIN"-->
            <xsl:variable name ="elementRestant" select ="substring($InputStringPrenom,2)"></xsl:variable>
            <!-- cas particulier de la concatnation de l'identifiant avec le Nom et le Prnom-->
            <xsl:if test ="string-length($InputIdentc) > 0">
              <xsl:value-of select ="concat(($InputIdentc),'-',($InputStringNom),' ',(substring($InputStringPrenom,1,1)),(translate(string($elementRestant),string($MAJ),string($MIN))))"/>
            </xsl:if>
            <xsl:if test ="string-length($InputIdentc) = 0">
              <xsl:value-of select ="concat(($InputStringNom),' ',(substring($InputStringPrenom,1,1)),(translate(string($elementRestant),string($MAJ),string($MIN))))"/>
            </xsl:if>

          </xsl:otherwise>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>

  </xsl:template>
  
  <!-- displayNumberXsl-->
  <!-- Mise en forme d'un nombre exemple: 99 999 999 ou 9 999,99 -->
  <xsl:template name="displayNumberXsl">
    <xsl:param name="InputStringNumber"/>

    <xsl:variable name ="ValeurEntiere" select ="(substring-before($InputStringNumber,','))"></xsl:variable>
    <xsl:variable name ="Valeurdecimal" select ="(substring-after($InputStringNumber,','))"></xsl:variable>
    <xsl:variable name ="ValEntiereAvecpoint" select ="(substring-before($InputStringNumber,'.'))"></xsl:variable>
    <xsl:variable name ="ValdecimalAvecpoint" select ="(substring-after($InputStringNumber,'.'))"></xsl:variable>

    <xsl:choose>
      <xsl:when test ="string-length($ValEntiereAvecpoint) > 0">
        <!-- nombre avec un point au lieu de la virgule -->
        
        <xsl:if test ="string-length($ValEntiereAvecpoint)&#60; 4">
          <xsl:value-of select ="concat(($ValEntiereAvecpoint),'.',($ValdecimalAvecpoint))"/>
        </xsl:if>
        <xsl:if test ="string-length($ValEntiereAvecpoint)= 4">
          <xsl:value-of select ="concat((substring($ValEntiereAvecpoint,1,1)),' ',(substring($ValEntiereAvecpoint,2)),'.',($ValdecimalAvecpoint))"/>
        </xsl:if>
        <xsl:if test ="string-length($ValEntiereAvecpoint)= 5">
          <xsl:value-of select ="concat((substring($ValEntiereAvecpoint,1,2)),' ',(substring($ValEntiereAvecpoint,3)),'.',($ValdecimalAvecpoint))"/>
        </xsl:if>
        <xsl:if test ="string-length($ValEntiereAvecpoint)= 6">
          <xsl:value-of select ="concat((substring($ValEntiereAvecpoint,1,3)),' ',(substring($ValEntiereAvecpoint,4)),'.',($ValdecimalAvecpoint))"/>
        </xsl:if>
        <xsl:if test ="string-length($ValEntiereAvecpoint)= 7">
          <xsl:value-of select ="concat((substring($ValEntiereAvecpoint,1,1)),' ',(substring($ValEntiereAvecpoint,2,3)),' ',(substring($ValEntiereAvecpoint,5)),'.',($ValdecimalAvecpoint))"/>
        </xsl:if>
        <xsl:if test ="string-length($ValEntiereAvecpoint)= 8">
          <xsl:value-of select ="concat((substring($ValEntiereAvecpoint,1,2)),' ',(substring($ValEntiereAvecpoint,3,3)),' ',(substring($ValEntiereAvecpoint,6)),'.',($ValdecimalAvecpoint))"/>
        </xsl:if>
        <xsl:if test ="string-length($ValEntiereAvecpoint)= 9">
          <xsl:value-of select ="concat((substring($ValEntiereAvecpoint,1,3)),' ',(substring($ValEntiereAvecpoint,4,3)),' ',(substring($ValEntiereAvecpoint,7)),'.',($ValdecimalAvecpoint))"/>
        </xsl:if>
        <xsl:if test ="string-length($ValEntiereAvecpoint)= 10">
          <xsl:value-of select ="concat((substring($ValEntiereAvecpoint,1,1)),' ',(substring($ValEntiereAvecpoint,2,3)),' ',(substring($ValEntiereAvecpoint,5,3)),' ',(substring($ValEntiereAvecpoint,8)),'.',($ValdecimalAvecpoint))"/>
        </xsl:if>
        <xsl:if test ="string-length($ValEntiereAvecpoint)= 11">
          <xsl:value-of select ="concat((substring($ValEntiereAvecpoint,1,2)),' ',(substring($ValEntiereAvecpoint,3,3)),' ',(substring($ValEntiereAvecpoint,6,3)),' ',(substring($ValEntiereAvecpoint,9)),'.',($ValdecimalAvecpoint))"/>
        </xsl:if>
        <xsl:if test ="string-length($ValEntiereAvecpoint)= 12">
          <xsl:value-of select ="concat((substring($ValEntiereAvecpoint,1,3)),' ',(substring($ValEntiereAvecpoint,4,3)),' ',(substring($ValEntiereAvecpoint,7,3)),' ',(substring($ValEntiereAvecpoint,10)),'.',($ValdecimalAvecpoint))"/>
        </xsl:if>
      </xsl:when>
      <xsl:otherwise>
        <xsl:choose >
          <xsl:when test ="(contains($ValeurEntiere,'-'))">
            <!-- nombre prced du signe "-" -->
            <xsl:choose>
              <xsl:when test ="string-length($Valeurdecimal) > 0">
                <!-- chiffres avec partie dcimal -->
                <xsl:if test ="string-length($ValeurEntiere)&#60; 5">
                  <xsl:value-of select ="concat(($ValeurEntiere),',',($Valeurdecimal))"/>
                </xsl:if>
                <xsl:if test ="string-length($ValeurEntiere)= 5">
                  <xsl:value-of select ="concat((substring($ValeurEntiere,1,2)),' ',(substring($ValeurEntiere,3)),',',($Valeurdecimal))"/>
                </xsl:if>
                <xsl:if test ="string-length($ValeurEntiere)= 6">
                  <xsl:value-of select ="concat((substring($ValeurEntiere,1,3)),' ',(substring($ValeurEntiere,4)),',',($Valeurdecimal))"/>
                </xsl:if>
                <xsl:if test ="string-length($ValeurEntiere)= 7">
                  <xsl:value-of select ="concat((substring($ValeurEntiere,1,4)),' ',(substring($ValeurEntiere,5)),',',($Valeurdecimal))"/>
                </xsl:if>
                <xsl:if test ="string-length($ValeurEntiere)= 8">
                  <xsl:value-of select ="concat((substring($ValeurEntiere,1,2)),' ',(substring($ValeurEntiere,3,3)),' ',(substring($ValeurEntiere,6)),',',($Valeurdecimal))"/>
                </xsl:if>
                <xsl:if test ="string-length($ValeurEntiere)= 9">
                  <xsl:value-of select ="concat((substring($ValeurEntiere,1,3)),' ',(substring($ValeurEntiere,4,3)),' ',(substring($ValeurEntiere,7)),',',($Valeurdecimal))"/>
                </xsl:if>
                <xsl:if test ="string-length($ValeurEntiere)= 10">
                  <xsl:value-of select ="concat((substring($ValeurEntiere,1,4)),' ',(substring($ValeurEntiere,5,3)),' ',(substring($ValeurEntiere,8)),',',($Valeurdecimal))"/>
                </xsl:if>
                <xsl:if test ="string-length($ValeurEntiere)= 11">
                  <xsl:value-of select ="concat((substring($ValeurEntiere,1,2)),' ',(substring($ValeurEntiere,3,3)),' ',(substring($ValeurEntiere,6,3)),' ',(substring($ValeurEntiere,9)),',',($Valeurdecimal))"/>
                </xsl:if>
                <xsl:if test ="string-length($ValeurEntiere)= 12">
                  <xsl:value-of select ="concat((substring($ValeurEntiere,1,3)),' ',(substring($ValeurEntiere,4,3)),' ',(substring($ValeurEntiere,7,3)),' ',(substring($ValeurEntiere,10)),',',($Valeurdecimal))"/>
                </xsl:if>
                <xsl:if test ="string-length($ValeurEntiere)= 13">
                  <xsl:value-of select ="concat((substring($ValeurEntiere,1,4)),' ',(substring($ValeurEntiere,5,3)),' ',(substring($ValeurEntiere,8,3)),' ',(substring($ValeurEntiere,11)),',',($Valeurdecimal))"/>
                </xsl:if>
              </xsl:when>
              <xsl:otherwise>
                <!-- chiffres sans partie dcimal -->
                <xsl:if test ="string-length($InputStringNumber)&#60; 5">
                  <xsl:value-of select ="$InputStringNumber"/>
                </xsl:if>
                <xsl:if test ="string-length($InputStringNumber)= 5">
                  <xsl:value-of select ="concat((substring($InputStringNumber,1,2)),' ',(substring($InputStringNumber,3)))"/>
                </xsl:if>
                <xsl:if test ="string-length($InputStringNumber)= 6">
                  <xsl:value-of select ="concat((substring($InputStringNumber,1,3)),' ',(substring($InputStringNumber,4)))"/>
                </xsl:if>
                <xsl:if test ="string-length($InputStringNumber)= 7">
                  <xsl:value-of select ="concat((substring($InputStringNumber,1,4)),' ',(substring($InputStringNumber,5)))"/>
                </xsl:if>
                <xsl:if test ="string-length($InputStringNumber)= 8">
                  <xsl:value-of select ="concat((substring($InputStringNumber,1,2)),' ',(substring($InputStringNumber,3,3)),' ',(substring($InputStringNumber,6)))"/>
                </xsl:if>
                <xsl:if test ="string-length($InputStringNumber)= 9">
                  <xsl:value-of select ="concat((substring($InputStringNumber,1,3)),' ',(substring($InputStringNumber,4,3)),' ',(substring($InputStringNumber,7)))"/>
                </xsl:if>
                <xsl:if test ="string-length($InputStringNumber)= 10">
                  <xsl:value-of select ="concat((substring($InputStringNumber,1,4)),' ',(substring($InputStringNumber,5,3)),' ',(substring($InputStringNumber,8)))"/>
                </xsl:if>
                <xsl:if test ="string-length($InputStringNumber)= 11">
                  <xsl:value-of select ="concat((substring($InputStringNumber,1,2)),' ',(substring($InputStringNumber,3,3)),' ',(substring($InputStringNumber,6,3)),' ',(substring($InputStringNumber,9)))"/>
                </xsl:if>
                <xsl:if test ="string-length($InputStringNumber)= 12">
                  <xsl:value-of select ="concat((substring($InputStringNumber,1,3)),' ',(substring($InputStringNumber,4,3)),' ',(substring($InputStringNumber,7,3)),' ',(substring($InputStringNumber,10)))"/>
                </xsl:if>
                <xsl:if test ="string-length($InputStringNumber)= 13">
                  <xsl:value-of select ="concat((substring($InputStringNumber,1,4)),' ',(substring($InputStringNumber,5,3)),' ',(substring($InputStringNumber,9,3)),' ',(substring($InputStringNumber,11)))"/>
                </xsl:if>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:when>

          <xsl:otherwise>
            <xsl:choose>
              <xsl:when test ="string-length($Valeurdecimal) > 0">
                <!-- chiffres avec partie dcimal -->
                <xsl:if test ="string-length($ValeurEntiere)&#60; 4">
                  <xsl:value-of select ="concat(($ValeurEntiere),',',($Valeurdecimal))"/>
                </xsl:if>
                <xsl:if test ="string-length($ValeurEntiere)= 4">
                  <xsl:value-of select ="concat((substring($ValeurEntiere,1,1)),' ',(substring($ValeurEntiere,2)),',',($Valeurdecimal))"/>
                </xsl:if>
                <xsl:if test ="string-length($ValeurEntiere)= 5">
                  <xsl:value-of select ="concat((substring($ValeurEntiere,1,2)),' ',(substring($ValeurEntiere,3)),',',($Valeurdecimal))"/>
                </xsl:if>
                <xsl:if test ="string-length($ValeurEntiere)= 6">
                  <xsl:value-of select ="concat((substring($ValeurEntiere,1,3)),' ',(substring($ValeurEntiere,4)),',',($Valeurdecimal))"/>
                </xsl:if>
                <xsl:if test ="string-length($ValeurEntiere)= 7">
                  <xsl:value-of select ="concat((substring($ValeurEntiere,1,1)),' ',(substring($ValeurEntiere,2,3)),' ',(substring($ValeurEntiere,5)),',',($Valeurdecimal))"/>
                </xsl:if>
                <xsl:if test ="string-length($ValeurEntiere)= 8">
                  <xsl:value-of select ="concat((substring($ValeurEntiere,1,2)),' ',(substring($ValeurEntiere,3,3)),' ',(substring($ValeurEntiere,6)),',',($Valeurdecimal))"/>
                </xsl:if>
                <xsl:if test ="string-length($ValeurEntiere)= 9">
                  <xsl:value-of select ="concat((substring($ValeurEntiere,1,3)),' ',(substring($ValeurEntiere,4,3)),' ',(substring($ValeurEntiere,7)),',',($Valeurdecimal))"/>
                </xsl:if>
                <xsl:if test ="string-length($ValeurEntiere)= 10">
                  <xsl:value-of select ="concat((substring($ValeurEntiere,1,1)),' ',(substring($ValeurEntiere,2,3)),' ',(substring($ValeurEntiere,5,3)),' ',(substring($ValeurEntiere,8)),',',($Valeurdecimal))"/>
                </xsl:if>
                <xsl:if test ="string-length($ValeurEntiere)= 11">
                  <xsl:value-of select ="concat((substring($ValeurEntiere,1,2)),' ',(substring($ValeurEntiere,3,3)),' ',(substring($ValeurEntiere,6,3)),' ',(substring($ValeurEntiere,9)),',',($Valeurdecimal))"/>
                </xsl:if>
                <xsl:if test ="string-length($ValeurEntiere)= 12">
                  <xsl:value-of select ="concat((substring($ValeurEntiere,1,3)),' ',(substring($ValeurEntiere,4,3)),' ',(substring($ValeurEntiere,7,3)),' ',(substring($ValeurEntiere,10)),',',($Valeurdecimal))"/>
                </xsl:if>
              </xsl:when>
              <xsl:otherwise>
                <!-- chiffres sans partie dcimal -->
                <xsl:if test ="string-length($InputStringNumber)&#60; 4">
                  <xsl:value-of select ="$InputStringNumber"/>
                </xsl:if>
                <xsl:if test ="string-length($InputStringNumber)= 4">
                  <xsl:value-of select ="concat((substring($InputStringNumber,1,1)),' ',(substring($InputStringNumber,2)))"/>
                </xsl:if>
                <xsl:if test ="string-length($InputStringNumber)= 5">
                  <xsl:value-of select ="concat((substring($InputStringNumber,1,2)),' ',(substring($InputStringNumber,3)))"/>
                </xsl:if>
                <xsl:if test ="string-length($InputStringNumber)= 6">
                  <xsl:value-of select ="concat((substring($InputStringNumber,1,3)),' ',(substring($InputStringNumber,4)))"/>
                </xsl:if>
                <xsl:if test ="string-length($InputStringNumber)= 7">
                  <xsl:value-of select ="concat((substring($InputStringNumber,1,1)),' ',(substring($InputStringNumber,2,3)),' ',(substring($InputStringNumber,5)))"/>
                </xsl:if>
                <xsl:if test ="string-length($InputStringNumber)= 8">
                  <xsl:value-of select ="concat((substring($InputStringNumber,1,2)),' ',(substring($InputStringNumber,3,3)),' ',(substring($InputStringNumber,6)))"/>
                </xsl:if>
                <xsl:if test ="string-length($InputStringNumber)= 9">
                  <xsl:value-of select ="concat((substring($InputStringNumber,1,3)),' ',(substring($InputStringNumber,4,3)),' ',(substring($InputStringNumber,7)))"/>
                </xsl:if>
                <xsl:if test ="string-length($InputStringNumber)= 10">
                  <xsl:value-of select ="concat((substring($InputStringNumber,1,1)),' ',(substring($InputStringNumber,2,3)),' ',(substring($InputStringNumber,5,3)),' ',(substring($InputStringNumber,8)))"/>
                </xsl:if>
                <xsl:if test ="string-length($InputStringNumber)= 11">
                  <xsl:value-of select ="concat((substring($InputStringNumber,1,2)),' ',(substring($InputStringNumber,3,3)),' ',(substring($InputStringNumber,6,3)),' ',(substring($InputStringNumber,9)))"/>
                </xsl:if>
                <xsl:if test ="string-length($InputStringNumber)= 12">
                  <xsl:value-of select ="concat((substring($InputStringNumber,1,3)),' ',(substring($InputStringNumber,4,3)),' ',(substring($InputStringNumber,7,3)),' ',(substring($InputStringNumber,10)))"/>
                </xsl:if>
                <xsl:if test ="string-length($InputStringNumber)= 13">
                  <xsl:value-of select ="concat((substring($InputStringNumber,1,1)),' ',(substring($InputStringNumber,2,3)),' ',(substring($InputStringNumber,5,3)),' ',(substring($InputStringNumber,8,3)),' ',(substring($InputStringNumber,11)))"/>
                </xsl:if>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  
  <!-- displayPackageSuivi -->
  <xsl:template name="displayPackageSuivi">
    <xsl:param name="InputStringPack"/>
    <xsl:param name="InputStringSuivi"/>
    <xsl:if test ="string-length($InputStringPack) > 0">
      <xsl:value-of select="concat(($InputStringPack),' / ',($InputStringSuivi))"/>
    </xsl:if>
    <xsl:if test ="string-length($InputStringPack) = 0">
      <xsl:value-of select="$InputStringSuivi"/>
    </xsl:if>
 </xsl:template>

  

  <!-- DisplayTitreDateSuivi -->
  <xsl:template name="DisplayTitreDateSuivi">
    <xsl:param name="InputDate"/>
    <xsl:if test ="string-length($InputDate) > 0">
      <xsl:if test ="(substring($InputDate,3,2) = '01')">
        <xsl:value-of select="concat((substring($InputDate,1,2)),' ','janvier',' ',(substring($InputDate,5,4)))"/>
      </xsl:if>
      <xsl:if test ="(substring($InputDate,3,2) = '02')">
        <xsl:value-of select="concat((substring($InputDate,1,2)),' ','fvrier',' ',(substring($InputDate,5,4)))"/>
      </xsl:if>
      <xsl:if test ="(substring($InputDate,3,2) = '03')">
        <xsl:value-of select="concat((substring($InputDate,1,2)),' ','mars',' ',(substring($InputDate,5,4)))"/>
      </xsl:if>
      <xsl:if test ="(substring($InputDate,3,2) = '04')">
        <xsl:value-of select="concat((substring($InputDate,1,2)),' ','avril',' ',(substring($InputDate,5,4)))"/>
      </xsl:if>
      <xsl:if test ="(substring($InputDate,3,2) = '05')">
        <xsl:value-of select="concat((substring($InputDate,1,2)),' ','mai',' ',(substring($InputDate,5,4)))"/>
      </xsl:if>
      <xsl:if test ="(substring($InputDate,3,2) = '06')">
        <xsl:value-of select="concat((substring($InputDate,1,2)),' ','juin',' ',(substring($InputDate,5,4)))"/>
      </xsl:if>
      <xsl:if test ="(substring($InputDate,3,2) = '07')">
        <xsl:value-of select="concat((substring($InputDate,1,2)),' ','juillet',' ',(substring($InputDate,5,4)))"/>
      </xsl:if>
      <xsl:if test ="(substring($InputDate,3,2) = '08')">
        <xsl:value-of select="concat((substring($InputDate,1,2)),' ','aot',' ',(substring($InputDate,5,4)))"/>
      </xsl:if>
      <xsl:if test ="(substring($InputDate,3,2) = '09')">
        <xsl:value-of select="concat((substring($InputDate,1,2)),' ','septembre',' ',(substring($InputDate,5,4)))"/>
      </xsl:if>
      <xsl:if test ="(substring($InputDate,3,2) = '10')">
        <xsl:value-of select="concat((substring($InputDate,1,2)),' ','octobre',' ',(substring($InputDate,5,4)))"/>
      </xsl:if>
      <xsl:if test ="(substring($InputDate,3,2) = '11')">
        <xsl:value-of select="concat((substring($InputDate,1,2)),' ','novembre',' ',(substring($InputDate,5,4)))"/>
      </xsl:if>
      <xsl:if test ="(substring($InputDate,3,2) = '12')">
        <xsl:value-of select="concat((substring($InputDate,1,2)),' ','dcembre',' ',(substring($InputDate,5,4)))"/>
      </xsl:if>          
    </xsl:if>  
  </xsl:template>

  
  <!-- displayTitrePackageSuivi -->
<xsl:template name="displayTitrePackageSuivi">
  <xsl:param name="InputStringPack"/>
  <xsl:param name="InputStringSuivi"/>
  <xsl:choose>
    <xsl:when test ="string-length($InputStringPack) > 0">
      <xsl:value-of select="concat('Module ',$InputStringPack,'/',$InputStringSuivi)"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="concat('Module ',$InputStringSuivi)"/>
    </xsl:otherwise>
  </xsl:choose>  
</xsl:template>

  <!-- displayFormatAfficheNombre -->
  <xsl:template name="displayFormatAfficheNombre">
    <xsl:param name="Inputnombre"/>
    <xsl:choose>
      <xsl:when test ="string-length($Inputnombre) > 3">
        <xsl:choose>
          <xsl:when test ="string-length($Inputnombre) = 4">
            <xsl:value-of select="concat((substring($Inputnombre,1,1)),' ',(substring($Inputnombre,2,3)))"/>
          </xsl:when>
          <xsl:when test ="string-length($Inputnombre) = 5">
            <xsl:value-of select="concat((substring($Inputnombre,1,2)),' ',(substring($Inputnombre,3,3)))"/>
          </xsl:when>
          <xsl:when test ="string-length($Inputnombre) = 6">
            <xsl:value-of select="concat((substring($Inputnombre,1,3)),' ',(substring($Inputnombre,4,3)))"/>
          </xsl:when>
          <xsl:when test ="string-length($Inputnombre) = 7">
            <xsl:value-of select="concat((substring($Inputnombre,1,1)),' ',(substring($Inputnombre,2,3)),' ',(substring($Inputnombre,5,3)))"/>
          </xsl:when>
          <xsl:when test ="string-length($Inputnombre) = 8">
            <xsl:value-of select="concat((substring($Inputnombre,1,2)),' ',(substring($Inputnombre,3,3)),' ',(substring($Inputnombre,6,3)))"/>
          </xsl:when>
          <xsl:when test ="string-length($Inputnombre) = 9">
            <xsl:value-of select="concat((substring($Inputnombre,1,3)),' ',(substring($Inputnombre,4,3)),' ',(substring($Inputnombre,7,3)))"/>
          </xsl:when>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$Inputnombre"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- displayFormatNombre -->
  <!-- formatage des nombres pour ne pas afficher les zeros innutiles -->
  <!-- le nombre  formater est sur 14 caractres maximun ex +0000000000005 devient +5 -->
  <!-- +0000000000,05 devient +0,05 -->
  <!-- 00000000012.25 devient 12,25 -->
  <xsl:template name="displayFormatNombre">
    <xsl:param name="InputValeur"/>

    <xsl:variable name ="ValeurEntiere" select ="(substring-before($InputValeur,','))"></xsl:variable>
    <xsl:variable name ="Valeurdecimal" select ="(substring-after($InputValeur,','))"></xsl:variable>
    <xsl:variable name ="ValeurEntiereAvecPoint" select ="(substring-before($InputValeur,'.'))"></xsl:variable>
    <xsl:variable name ="ValeurdecimalAvecPoint" select ="(substring-after($InputValeur,'.'))"></xsl:variable>
    <xsl:variable name ="PremierCaractere" select ="substring($InputValeur,1,1)"></xsl:variable>

    <xsl:choose>
      <xsl:when test="contains($InputValeur,',')">
        <xsl:choose>
          <xsl:when test ="($PremierCaractere = '+') or ($PremierCaractere = '-')">
            <xsl:choose>
              <xsl:when test="string-length($ValeurEntiere) = 1">
                <xsl:value-of select="$InputValeur"></xsl:value-of>
              </xsl:when>
              <xsl:otherwise>
                <xsl:choose>
                  <xsl:when test="string-length($ValeurEntiere) = 2">
                    <xsl:value-of select="$InputValeur"></xsl:value-of>
                  </xsl:when>
                  <xsl:when test="string-length($ValeurEntiere) = 3">
                    <xsl:choose>
                      <xsl:when test ="substring($ValeurEntiere,2,1) = '0'">
                        <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiere,3,1)),',',($Valeurdecimal))"/>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="concat(($ValeurEntiere),',',($Valeurdecimal))"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>

                  <xsl:when test="string-length($ValeurEntiere) = 4">
                    <xsl:choose>
                      <xsl:when test ="substring($ValeurEntiere,2,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($ValeurEntiere,3,1) = '0'">
                            <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiere,4,1)),',',($Valeurdecimal))"/>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiere,3,2)),',',($Valeurdecimal))"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="concat(($ValeurEntiere),',',($Valeurdecimal))"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>

                  <xsl:when test="string-length($ValeurEntiere) = 5">
                    <xsl:choose>
                      <xsl:when test ="substring($ValeurEntiere,2,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($ValeurEntiere,3,1) = '0'">
                            <xsl:choose>
                              <xsl:when test ="substring($ValeurEntiere,4,1) = '0'">
                                <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiere,5,1)),',',($Valeurdecimal))"/>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiere,4,2)),',',($Valeurdecimal))"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiere,3,3)),',',($Valeurdecimal))"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="concat(($ValeurEntiere),',',($Valeurdecimal))"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>

                  <xsl:when test="string-length($ValeurEntiere) = 6">
                    <xsl:choose>
                      <xsl:when test ="substring($ValeurEntiere,2,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($ValeurEntiere,3,1) = '0'">
                            <xsl:choose>
                              <xsl:when test ="substring($ValeurEntiere,4,1) = '0'">
                                <xsl:choose>
                                  <xsl:when test ="substring($ValeurEntiere,5,1) = '0'">
                                    <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiere,6,1)),',',($Valeurdecimal))"/>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiere,5,2)),',',($Valeurdecimal))"/>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiere,4,3)),',',($Valeurdecimal))"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiere,3,4)),',',($Valeurdecimal))"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="concat(($ValeurEntiere),',',($Valeurdecimal))"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>

                  <xsl:when test="string-length($ValeurEntiere) = 7">
                    <xsl:choose>
                      <xsl:when test ="substring($ValeurEntiere,2,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($ValeurEntiere,3,1) = '0'">
                            <xsl:choose>
                              <xsl:when test ="substring($ValeurEntiere,4,1) = '0'">
                                <xsl:choose>
                                  <xsl:when test ="substring($ValeurEntiere,5,1) = '0'">
                                    <xsl:choose>
                                      <xsl:when test ="substring($ValeurEntiere,6,1) = '0'">
                                        <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiere,7,1)),',',($Valeurdecimal))"/>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiere,6,2)),',',($Valeurdecimal))"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiere,5,3)),',',($Valeurdecimal))"/>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiere,4,4)),',',($Valeurdecimal))"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiere,3,5)),',',($Valeurdecimal))"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="concat(($ValeurEntiere),',',($Valeurdecimal))"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>

                  <xsl:when test="string-length($ValeurEntiere) = 8">
                    <xsl:choose>
                      <xsl:when test ="substring($ValeurEntiere,2,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($ValeurEntiere,3,1) = '0'">
                            <xsl:choose>
                              <xsl:when test ="substring($ValeurEntiere,4,1) = '0'">
                                <xsl:choose>
                                  <xsl:when test ="substring($ValeurEntiere,5,1) = '0'">
                                    <xsl:choose>
                                      <xsl:when test ="substring($ValeurEntiere,6,1) = '0'">
                                        <xsl:choose>
                                          <xsl:when test ="substring($ValeurEntiere,7,1) = '0'">
                                            <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiere,8,1)),',',($Valeurdecimal))"/>
                                          </xsl:when>
                                          <xsl:otherwise>
                                            <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiere,7,2)),',',($Valeurdecimal))"/>
                                          </xsl:otherwise>
                                        </xsl:choose>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiere,6,3)),',',($Valeurdecimal))"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiere,5,4)),',',($Valeurdecimal))"/>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiere,4,5)),',',($Valeurdecimal))"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiere,3,6)),',',($Valeurdecimal))"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="concat(($ValeurEntiere),',',($Valeurdecimal))"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>

                  <xsl:when test="string-length($ValeurEntiere) = 9">
                    <xsl:choose>
                      <xsl:when test ="substring($ValeurEntiere,2,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($ValeurEntiere,3,1) = '0'">
                            <xsl:choose>
                              <xsl:when test ="substring($ValeurEntiere,4,1) = '0'">
                                <xsl:choose>
                                  <xsl:when test ="substring($ValeurEntiere,5,1) = '0'">
                                    <xsl:choose>
                                      <xsl:when test ="substring($ValeurEntiere,6,1) = '0'">
                                        <xsl:choose>
                                          <xsl:when test ="substring($ValeurEntiere,7,1) = '0'">
                                            <xsl:choose>
                                              <xsl:when test ="substring($ValeurEntiere,8,1) = '0'">
                                                <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiere,9,1)),',',($Valeurdecimal))"/>
                                              </xsl:when>
                                              <xsl:otherwise>
                                                <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiere,8,2)),',',($Valeurdecimal))"/>
                                              </xsl:otherwise>
                                            </xsl:choose>
                                          </xsl:when>
                                          <xsl:otherwise>
                                            <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiere,7,3)),',',($Valeurdecimal))"/>
                                          </xsl:otherwise>
                                        </xsl:choose>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiere,6,4)),',',($Valeurdecimal))"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiere,5,5)),',',($Valeurdecimal))"/>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiere,4,6)),',',($Valeurdecimal))"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiere,3,7)),',',($Valeurdecimal))"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="concat(($ValeurEntiere),',',($Valeurdecimal))"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>

                  <xsl:when test="string-length($ValeurEntiere) = 10">
                    <xsl:choose>
                      <xsl:when test ="substring($ValeurEntiere,2,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($ValeurEntiere,3,1) = '0'">
                            <xsl:choose>
                              <xsl:when test ="substring($ValeurEntiere,4,1) = '0'">
                                <xsl:choose>
                                  <xsl:when test ="substring($ValeurEntiere,5,1) = '0'">
                                    <xsl:choose>
                                      <xsl:when test ="substring($ValeurEntiere,6,1) = '0'">
                                        <xsl:choose>
                                          <xsl:when test ="substring($ValeurEntiere,7,1) = '0'">
                                            <xsl:choose>
                                              <xsl:when test ="substring($ValeurEntiere,8,1) = '0'">
                                                <xsl:choose>
                                                  <xsl:when test ="substring($ValeurEntiere,9,1) = '0'">
                                                    <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiere,10,1)),',',($Valeurdecimal))"/>
                                                  </xsl:when>
                                                  <xsl:otherwise>
                                                    <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiere,9,2)),',',($Valeurdecimal))"/>
                                                  </xsl:otherwise>
                                                </xsl:choose>
                                              </xsl:when>
                                              <xsl:otherwise>
                                                <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiere,8,3)),',',($Valeurdecimal))"/>
                                              </xsl:otherwise>
                                            </xsl:choose>
                                          </xsl:when>
                                          <xsl:otherwise>
                                            <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiere,7,4)),',',($Valeurdecimal))"/>
                                          </xsl:otherwise>
                                        </xsl:choose>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiere,6,5)),',',($Valeurdecimal))"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiere,5,6)),',',($Valeurdecimal))"/>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiere,4,7)),',',($Valeurdecimal))"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiere,3,8)),',',($Valeurdecimal))"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="concat(($ValeurEntiere),',',($Valeurdecimal))"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>

                  <xsl:when test="string-length($ValeurEntiere) = 11">
                    <xsl:choose>
                      <xsl:when test ="substring($ValeurEntiere,2,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($ValeurEntiere,3,1) = '0'">
                            <xsl:choose>
                              <xsl:when test ="substring($ValeurEntiere,4,1) = '0'">
                                <xsl:choose>
                                  <xsl:when test ="substring($ValeurEntiere,5,1) = '0'">
                                    <xsl:choose>
                                      <xsl:when test ="substring($ValeurEntiere,6,1) = '0'">
                                        <xsl:choose>
                                          <xsl:when test ="substring($ValeurEntiere,7,1) = '0'">
                                            <xsl:choose>
                                              <xsl:when test ="substring($ValeurEntiere,8,1) = '0'">
                                                <xsl:choose>
                                                  <xsl:when test ="substring($ValeurEntiere,9,1) = '0'">
                                                    <xsl:choose>
                                                      <xsl:when test ="substring($ValeurEntiere,10,1) = '0'">
                                                        <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiere,11,1)),',',($Valeurdecimal))"/>
                                                      </xsl:when>
                                                      <xsl:otherwise>
                                                        <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiere,10,2)),',',($Valeurdecimal))"/>
                                                      </xsl:otherwise>
                                                    </xsl:choose>
                                                  </xsl:when>
                                                  <xsl:otherwise>
                                                    <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiere,9,3)),',',($Valeurdecimal))"/>
                                                  </xsl:otherwise>
                                                </xsl:choose>
                                              </xsl:when>
                                              <xsl:otherwise>
                                                <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiere,8,4)),',',($Valeurdecimal))"/>
                                              </xsl:otherwise>
                                            </xsl:choose>
                                          </xsl:when>
                                          <xsl:otherwise>
                                            <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiere,7,5)),',',($Valeurdecimal))"/>
                                          </xsl:otherwise>
                                        </xsl:choose>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiere,6,6)),',',($Valeurdecimal))"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiere,5,7)),',',($Valeurdecimal))"/>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiere,4,8)),',',($Valeurdecimal))"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiere,3,9)),',',($Valeurdecimal))"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="concat(($ValeurEntiere),',',($Valeurdecimal))"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                    
                  
                  <xsl:when test="string-length($ValeurEntiere) &gt; 11">
                    <xsl:value-of select="$InputValeur"></xsl:value-of>
                  </xsl:when>
                </xsl:choose>
              </xsl:otherwise>

            </xsl:choose>
          </xsl:when>
          <xsl:otherwise>
            <xsl:choose>

              <xsl:when test="string-length($ValeurEntiere) = 1">
                <xsl:value-of select="$InputValeur"></xsl:value-of>
              </xsl:when>

              <xsl:when test="string-length($ValeurEntiere) = 2">
                <xsl:choose>
                  <xsl:when test ="substring($ValeurEntiere,1,1) = '0'">
                    <xsl:value-of select="concat((substring($ValeurEntiere,2,1)),',',($Valeurdecimal))"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="$InputValeur"></xsl:value-of>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>

              <xsl:when test="string-length($ValeurEntiere) = 3">
                <xsl:choose>
                  <xsl:when test ="substring($ValeurEntiere,1,1) = '0'">
                    <xsl:choose>
                      <xsl:when test ="substring($ValeurEntiere,2,1) = '0'">
                        <xsl:value-of select="concat((substring($ValeurEntiere,3,1)),',',($Valeurdecimal))"/>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="concat((substring($ValeurEntiere,2,2)),',',($Valeurdecimal))"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="$InputValeur"></xsl:value-of>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>

              <xsl:when test="string-length($ValeurEntiere) = 4">
                <xsl:choose>
                  <xsl:when test ="substring($ValeurEntiere,1,1) = '0'">
                    <xsl:choose>
                      <xsl:when test ="substring($ValeurEntiere,2,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($ValeurEntiere,3,1) = '0'">
                            <xsl:value-of select="concat((substring($ValeurEntiere,4,1)),',',($Valeurdecimal))"/>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="concat((substring($ValeurEntiere,3,2)),',',($Valeurdecimal))"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="concat((substring($ValeurEntiere,2,3)),',',($Valeurdecimal))"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="$InputValeur"></xsl:value-of>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>

              <xsl:when test="string-length($ValeurEntiere) = 5">
                <xsl:choose>
                  <xsl:when test ="substring($ValeurEntiere,1,1) = '0'">
                    <xsl:choose>
                      <xsl:when test ="substring($ValeurEntiere,2,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($ValeurEntiere,3,1) = '0'">
                            <xsl:choose>
                              <xsl:when test ="substring($ValeurEntiere,4,1) = '0'">
                                <xsl:value-of select="concat((substring($ValeurEntiere,5,1)),',',($Valeurdecimal))"/>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="concat((substring($ValeurEntiere,4,2)),',',($Valeurdecimal))"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="concat((substring($ValeurEntiere,3,3)),',',($Valeurdecimal))"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="concat((substring($ValeurEntiere,2,4)),',',($Valeurdecimal))"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="$InputValeur"></xsl:value-of>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>

              <xsl:when test="string-length($ValeurEntiere) = 6">
                <xsl:choose>
                  <xsl:when test ="substring($ValeurEntiere,1,1) = '0'">
                    <xsl:choose>
                      <xsl:when test ="substring($ValeurEntiere,2,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($ValeurEntiere,3,1) = '0'">
                            <xsl:choose>
                              <xsl:when test ="substring($ValeurEntiere,4,1) = '0'">
                                <xsl:choose>
                                  <xsl:when test ="substring($ValeurEntiere,5,1) = '0'">
                                    <xsl:value-of select="concat((substring($ValeurEntiere,6,1)),',',($Valeurdecimal))"/>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <xsl:value-of select="concat((substring($ValeurEntiere,5,2)),',',($Valeurdecimal))"/>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="concat((substring($ValeurEntiere,4,3)),',',($Valeurdecimal))"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="concat((substring($ValeurEntiere,3,4)),',',($Valeurdecimal))"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="concat((substring($ValeurEntiere,2,5)),',',($Valeurdecimal))"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="$InputValeur"></xsl:value-of>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>

              <xsl:when test="string-length($ValeurEntiere) = 7">
                <xsl:choose>
                  <xsl:when test ="substring($ValeurEntiere,1,1) = '0'">
                    <xsl:choose>
                      <xsl:when test ="substring($ValeurEntiere,2,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($ValeurEntiere,3,1) = '0'">
                            <xsl:choose>
                              <xsl:when test ="substring($ValeurEntiere,4,1) = '0'">
                                <xsl:choose>
                                  <xsl:when test ="substring($ValeurEntiere,5,1) = '0'">
                                    <xsl:choose>
                                      <xsl:when test ="substring($ValeurEntiere,6,1) = '0'">
                                        <xsl:value-of select="concat((substring($ValeurEntiere,7,1)),',',($Valeurdecimal))"/>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="concat((substring($ValeurEntiere,6,2)),',',($Valeurdecimal))"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <xsl:value-of select="concat((substring($ValeurEntiere,5,3)),',',($Valeurdecimal))"/>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="concat((substring($ValeurEntiere,4,4)),',',($Valeurdecimal))"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="concat((substring($ValeurEntiere,3,5)),',',($Valeurdecimal))"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="concat((substring($ValeurEntiere,2,6)),',',($Valeurdecimal))"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="$InputValeur"></xsl:value-of>
                  </xsl:otherwise>
                </xsl:choose>
               </xsl:when>

              <xsl:when test="string-length($ValeurEntiere) = 8">
                <xsl:choose>
                  <xsl:when test ="substring($ValeurEntiere,1,1) = '0'">
                    <xsl:choose>
                      <xsl:when test ="substring($ValeurEntiere,2,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($ValeurEntiere,3,1) = '0'">
                            <xsl:choose>
                              <xsl:when test ="substring($ValeurEntiere,4,1) = '0'">
                                <xsl:choose>
                                  <xsl:when test ="substring($ValeurEntiere,5,1) = '0'">
                                    <xsl:choose>
                                      <xsl:when test ="substring($ValeurEntiere,6,1) = '0'">
                                        <xsl:choose>
                                          <xsl:when test ="substring($ValeurEntiere,7,1) = '0'">
                                            <xsl:value-of select="concat((substring($ValeurEntiere,8,1)),',',($Valeurdecimal))"/>
                                          </xsl:when>
                                          <xsl:otherwise>
                                            <xsl:value-of select="concat((substring($ValeurEntiere,7,2)),',',($Valeurdecimal))"/>
                                          </xsl:otherwise>
                                        </xsl:choose>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="concat((substring($ValeurEntiere,6,3)),',',($Valeurdecimal))"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <xsl:value-of select="concat((substring($ValeurEntiere,5,4)),',',($Valeurdecimal))"/>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="concat((substring($ValeurEntiere,4,5)),',',($Valeurdecimal))"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="concat((substring($ValeurEntiere,3,6)),',',($Valeurdecimal))"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="concat((substring($ValeurEntiere,2,7)),',',($Valeurdecimal))"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="$InputValeur"></xsl:value-of>
                  </xsl:otherwise>
                </xsl:choose>
               </xsl:when>

              <xsl:when test="string-length($ValeurEntiere) = 9">
                <xsl:choose>
                  <xsl:when test ="substring($ValeurEntiere,1,1) = '0'">
                    <xsl:choose>
                      <xsl:when test ="substring($ValeurEntiere,2,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($ValeurEntiere,3,1) = '0'">
                            <xsl:choose>
                              <xsl:when test ="substring($ValeurEntiere,4,1) = '0'">
                                <xsl:choose>
                                  <xsl:when test ="substring($ValeurEntiere,5,1) = '0'">
                                    <xsl:choose>
                                      <xsl:when test ="substring($ValeurEntiere,6,1) = '0'">
                                        <xsl:choose>
                                          <xsl:when test ="substring($ValeurEntiere,7,1) = '0'">
                                            <xsl:choose>
                                              <xsl:when test ="substring($ValeurEntiere,8,1) = '0'">
                                                <xsl:value-of select="concat((substring($ValeurEntiere,9,1)),',',($Valeurdecimal))"/>
                                              </xsl:when>
                                              <xsl:otherwise>
                                                <xsl:value-of select="concat((substring($ValeurEntiere,8,2)),',',($Valeurdecimal))"/>
                                              </xsl:otherwise>
                                            </xsl:choose>
                                          </xsl:when>
                                          <xsl:otherwise>
                                            <xsl:value-of select="concat((substring($ValeurEntiere,7,3)),',',($Valeurdecimal))"/>
                                          </xsl:otherwise>
                                        </xsl:choose>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="concat((substring($ValeurEntiere,6,4)),',',($Valeurdecimal))"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <xsl:value-of select="concat((substring($ValeurEntiere,5,5)),',',($Valeurdecimal))"/>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="concat((substring($ValeurEntiere,4,6)),',',($Valeurdecimal))"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="concat((substring($ValeurEntiere,3,7)),',',($Valeurdecimal))"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="concat((substring($ValeurEntiere,2,8)),',',($Valeurdecimal))"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="$InputValeur"></xsl:value-of>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>

              <xsl:when test="string-length($ValeurEntiere) = 10">
                <xsl:choose>
                  <xsl:when test ="substring($ValeurEntiere,1,1) = '0'">
                    <xsl:choose>
                      <xsl:when test ="substring($ValeurEntiere,2,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($ValeurEntiere,3,1) = '0'">
                            <xsl:choose>
                              <xsl:when test ="substring($ValeurEntiere,4,1) = '0'">
                                <xsl:choose>
                                  <xsl:when test ="substring($ValeurEntiere,5,1) = '0'">
                                    <xsl:choose>
                                      <xsl:when test ="substring($ValeurEntiere,6,1) = '0'">
                                        <xsl:choose>
                                          <xsl:when test ="substring($ValeurEntiere,7,1) = '0'">
                                            <xsl:choose>
                                              <xsl:when test ="substring($ValeurEntiere,8,1) = '0'">
                                                <xsl:choose>
                                                  <xsl:when test ="substring($ValeurEntiere,9,1) = '0'">
                                                    <xsl:value-of select="concat((substring($ValeurEntiere,10,1)),',',($Valeurdecimal))"/>
                                                  </xsl:when>
                                                  <xsl:otherwise>
                                                    <xsl:value-of select="concat((substring($ValeurEntiere,9,2)),',',($Valeurdecimal))"/>
                                                  </xsl:otherwise>
                                                </xsl:choose>
                                              </xsl:when>
                                              <xsl:otherwise>
                                                <xsl:value-of select="concat((substring($ValeurEntiere,8,3)),',',($Valeurdecimal))"/>
                                              </xsl:otherwise>
                                            </xsl:choose>
                                          </xsl:when>
                                          <xsl:otherwise>
                                            <xsl:value-of select="concat((substring($ValeurEntiere,7,4)),',',($Valeurdecimal))"/>
                                          </xsl:otherwise>
                                        </xsl:choose>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="concat((substring($ValeurEntiere,6,5)),',',($Valeurdecimal))"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <xsl:value-of select="concat((substring($ValeurEntiere,5,6)),',',($Valeurdecimal))"/>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="concat((substring($ValeurEntiere,4,7)),',',($Valeurdecimal))"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="concat((substring($ValeurEntiere,3,8)),',',($Valeurdecimal))"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="concat((substring($ValeurEntiere,2,9)),',',($Valeurdecimal))"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="$InputValeur"></xsl:value-of>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>

              <xsl:when test="string-length($ValeurEntiere) = 11">
                <xsl:choose>
                  <xsl:when test ="substring($ValeurEntiere,1,1) = '0'">
                    <xsl:choose>
                      <xsl:when test ="substring($ValeurEntiere,2,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($ValeurEntiere,3,1) = '0'">
                            <xsl:choose>
                              <xsl:when test ="substring($ValeurEntiere,4,1) = '0'">
                                <xsl:choose>
                                  <xsl:when test ="substring($ValeurEntiere,5,1) = '0'">
                                    <xsl:choose>
                                      <xsl:when test ="substring($ValeurEntiere,6,1) = '0'">
                                        <xsl:choose>
                                          <xsl:when test ="substring($ValeurEntiere,7,1) = '0'">
                                            <xsl:choose>
                                              <xsl:when test ="substring($ValeurEntiere,8,1) = '0'">
                                                <xsl:choose>
                                                  <xsl:when test ="substring($ValeurEntiere,9,1) = '0'">
                                                    <xsl:choose>
                                                      <xsl:when test ="substring($ValeurEntiere,10,1) = '0'">
                                                        <xsl:value-of select="concat((substring($ValeurEntiere,11,1)),',',($Valeurdecimal))"/>
                                                      </xsl:when>
                                                      <xsl:otherwise>
                                                        <xsl:value-of select="concat((substring($ValeurEntiere,10,2)),',',($Valeurdecimal))"/>
                                                      </xsl:otherwise>
                                                    </xsl:choose>
                                                  </xsl:when>
                                                  <xsl:otherwise>
                                                    <xsl:value-of select="concat((substring($ValeurEntiere,9,3)),',',($Valeurdecimal))"/>
                                                  </xsl:otherwise>
                                                </xsl:choose>
                                              </xsl:when>
                                              <xsl:otherwise>
                                                <xsl:value-of select="concat((substring($ValeurEntiere,8,4)),',',($Valeurdecimal))"/>
                                              </xsl:otherwise>
                                            </xsl:choose>
                                          </xsl:when>
                                          <xsl:otherwise>
                                            <xsl:value-of select="concat((substring($ValeurEntiere,7,5)),',',($Valeurdecimal))"/>
                                          </xsl:otherwise>
                                        </xsl:choose>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="concat((substring($ValeurEntiere,6,6)),',',($Valeurdecimal))"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <xsl:value-of select="concat((substring($ValeurEntiere,5,7)),',',($Valeurdecimal))"/>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="concat((substring($ValeurEntiere,4,8)),',',($Valeurdecimal))"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="concat((substring($ValeurEntiere,3,9)),',',($Valeurdecimal))"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="concat((substring($ValeurEntiere,2,10)),',',($Valeurdecimal))"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="$InputValeur"></xsl:value-of>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>

              <xsl:when test="string-length($ValeurEntiere) = 12">
                <xsl:choose>
                  <xsl:when test ="substring($ValeurEntiere,1,1) = '0'">
                    <xsl:choose>
                      <xsl:when test ="substring($ValeurEntiere,2,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($ValeurEntiere,3,1) = '0'">
                            <xsl:choose>
                              <xsl:when test ="substring($ValeurEntiere,4,1) = '0'">
                                <xsl:choose>
                                  <xsl:when test ="substring($ValeurEntiere,5,1) = '0'">
                                    <xsl:choose>
                                      <xsl:when test ="substring($ValeurEntiere,6,1) = '0'">
                                        <xsl:choose>
                                          <xsl:when test ="substring($ValeurEntiere,7,1) = '0'">
                                            <xsl:choose>
                                              <xsl:when test ="substring($ValeurEntiere,8,1) = '0'">
                                                <xsl:choose>
                                                  <xsl:when test ="substring($ValeurEntiere,9,1) = '0'">
                                                    <xsl:choose>
                                                      <xsl:when test ="substring($ValeurEntiere,10,1) = '0'">
                                                        <xsl:choose>
                                                          <xsl:when test ="substring($ValeurEntiere,11,1) = '0'">
                                                            <xsl:value-of select="concat((substring($ValeurEntiere,12,1)),',',($Valeurdecimal))"/>
                                                          </xsl:when>
                                                          <xsl:otherwise>
                                                            <xsl:value-of select="concat((substring($ValeurEntiere,11,2)),',',($Valeurdecimal))"/>
                                                          </xsl:otherwise>
                                                        </xsl:choose>
                                                      </xsl:when>
                                                      <xsl:otherwise>
                                                        <xsl:value-of select="concat((substring($ValeurEntiere,10,3)),',',($Valeurdecimal))"/>
                                                      </xsl:otherwise>
                                                    </xsl:choose>
                                                  </xsl:when>
                                                  <xsl:otherwise>
                                                    <xsl:value-of select="concat((substring($ValeurEntiere,9,4)),',',($Valeurdecimal))"/>
                                                  </xsl:otherwise>
                                                </xsl:choose>
                                              </xsl:when>
                                              <xsl:otherwise>
                                                <xsl:value-of select="concat((substring($ValeurEntiere,8,5)),',',($Valeurdecimal))"/>
                                              </xsl:otherwise>
                                            </xsl:choose>
                                          </xsl:when>
                                          <xsl:otherwise>
                                            <xsl:value-of select="concat((substring($ValeurEntiere,7,6)),',',($Valeurdecimal))"/>
                                          </xsl:otherwise>
                                        </xsl:choose>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="concat((substring($ValeurEntiere,6,7)),',',($Valeurdecimal))"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <xsl:value-of select="concat((substring($ValeurEntiere,5,8)),',',($Valeurdecimal))"/>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="concat((substring($ValeurEntiere,4,9)),',',($Valeurdecimal))"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="concat((substring($ValeurEntiere,3,10)),',',($Valeurdecimal))"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="concat((substring($ValeurEntiere,2,11)),',',($Valeurdecimal))"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="$InputValeur"></xsl:value-of>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>
              
              <xsl:otherwise >
                <xsl:value-of select="$InputValeur"></xsl:value-of>
              </xsl:otherwise>
            </xsl:choose>

          </xsl:otherwise>

        </xsl:choose>

      </xsl:when>

      <xsl:when test="contains($InputValeur,'.')">
        <xsl:choose>
          <xsl:when test ="($PremierCaractere = '+') or ($PremierCaractere = '-')">
            <xsl:choose>
              <xsl:when test="string-length($ValeurEntiereAvecPoint) = 1">
                <xsl:value-of select="$InputValeur"></xsl:value-of>
              </xsl:when>
              <xsl:otherwise>
                <xsl:choose>
                  <xsl:when test="string-length($ValeurEntiereAvecPoint) = 2">
                    <xsl:value-of select="$InputValeur"></xsl:value-of>
                  </xsl:when>
                  <xsl:when test="string-length($ValeurEntiereAvecPoint) = 3">
                    <xsl:choose>
                      <xsl:when test ="substring($ValeurEntiere,2,1) = '0'">
                        <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiereAvecPoint,3,1)),',',($ValeurdecimalAvecPoint))"/>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="concat(($ValeurEntiereAvecPoint),',',($ValeurdecimalAvecPoint))"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>

                  <xsl:when test="string-length($ValeurEntiereAvecPoint) = 4">
                    <xsl:choose>
                      <xsl:when test ="substring($ValeurEntiereAvecPoint,2,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($ValeurEntiereAvecPoint,3,1) = '0'">
                            <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiereAvecPoint,4,1)),',',($ValeurdecimalAvecPoint))"/>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiereAvecPoint,3,2)),',',($ValeurdecimalAvecPoint))"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="concat(($ValeurEntiereAvecPoint),',',($ValeurdecimalAvecPoint))"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>

                  <xsl:when test="string-length($ValeurEntiereAvecPoint) = 5">
                    <xsl:choose>
                      <xsl:when test ="substring($ValeurEntiereAvecPoint,2,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($ValeurEntiereAvecPoint,3,1) = '0'">
                            <xsl:choose>
                              <xsl:when test ="substring($ValeurEntiereAvecPoint,4,1) = '0'">
                                <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiereAvecPoint,5,1)),',',($ValeurdecimalAvecPoint))"/>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiereAvecPoint,4,2)),',',($ValeurdecimalAvecPoint))"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiereAvecPoint,3,3)),',',($ValeurdecimalAvecPoint))"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="concat(($ValeurEntiereAvecPoint),',',($ValeurdecimalAvecPoint))"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>

                  <xsl:when test="string-length($ValeurEntiereAvecPoint) = 6">
                    <xsl:choose>
                      <xsl:when test ="substring($ValeurEntiereAvecPoint,2,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($ValeurEntiereAvecPoint,3,1) = '0'">
                            <xsl:choose>
                              <xsl:when test ="substring($ValeurEntiereAvecPoint,4,1) = '0'">
                                <xsl:choose>
                                  <xsl:when test ="substring($ValeurEntiereAvecPoint,5,1) = '0'">
                                    <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiereAvecPoint,6,1)),',',($ValeurdecimalAvecPoint))"/>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiereAvecPoint,5,2)),',',($ValeurdecimalAvecPoint))"/>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiereAvecPoint,4,3)),',',($ValeurdecimalAvecPoint))"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiereAvecPoint,3,4)),',',($ValeurdecimalAvecPoint))"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="concat(($ValeurEntiereAvecPoint),',',($ValeurdecimalAvecPoint))"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>

                  <xsl:when test="string-length($ValeurEntiereAvecPoint) = 7">
                    <xsl:choose>
                      <xsl:when test ="substring($ValeurEntiereAvecPoint,2,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($ValeurEntiereAvecPoint,3,1) = '0'">
                            <xsl:choose>
                              <xsl:when test ="substring($ValeurEntiereAvecPoint,4,1) = '0'">
                                <xsl:choose>
                                  <xsl:when test ="substring($ValeurEntiereAvecPoint,5,1) = '0'">
                                    <xsl:choose>
                                      <xsl:when test ="substring($ValeurEntiereAvecPoint,6,1) = '0'">
                                        <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiereAvecPoint,7,1)),',',($ValeurdecimalAvecPoint))"/>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiereAvecPoint,6,2)),',',($ValeurdecimalAvecPoint))"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiereAvecPoint,5,3)),',',($ValeurdecimalAvecPoint))"/>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiereAvecPoint,4,4)),',',($ValeurdecimalAvecPoint))"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiereAvecPoint,3,5)),',',($ValeurdecimalAvecPoint))"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="concat(($ValeurEntiereAvecPoint),',',($ValeurdecimalAvecPoint))"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>

                  <xsl:when test="string-length($ValeurEntiereAvecPoint) = 8">
                    <xsl:choose>
                      <xsl:when test ="substring($ValeurEntiereAvecPoint,2,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($ValeurEntiereAvecPoint,3,1) = '0'">
                            <xsl:choose>
                              <xsl:when test ="substring($ValeurEntiereAvecPoint,4,1) = '0'">
                                <xsl:choose>
                                  <xsl:when test ="substring($ValeurEntiereAvecPoint,5,1) = '0'">
                                    <xsl:choose>
                                      <xsl:when test ="substring($ValeurEntiereAvecPoint,6,1) = '0'">
                                        <xsl:choose>
                                          <xsl:when test ="substring($ValeurEntiereAvecPoint,7,1) = '0'">
                                            <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiereAvecPoint,8,1)),',',($ValeurdecimalAvecPoint))"/>
                                          </xsl:when>
                                          <xsl:otherwise>
                                            <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiereAvecPoint,7,2)),',',($ValeurdecimalAvecPoint))"/>
                                          </xsl:otherwise>
                                        </xsl:choose>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiereAvecPoint,6,3)),',',($ValeurdecimalAvecPoint))"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiereAvecPoint,5,4)),',',($ValeurdecimalAvecPoint))"/>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiereAvecPoint,4,5)),',',($ValeurdecimalAvecPoint))"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiereAvecPoint,3,6)),',',($ValeurdecimalAvecPoint))"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="concat(($ValeurEntiereAvecPoint),',',($ValeurdecimalAvecPoint))"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>

                  <xsl:when test="string-length($ValeurEntiereAvecPoint) = 9">
                    <xsl:choose>
                      <xsl:when test ="substring($ValeurEntiereAvecPoint,2,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($ValeurEntiereAvecPoint,3,1) = '0'">
                            <xsl:choose>
                              <xsl:when test ="substring($ValeurEntiereAvecPoint,4,1) = '0'">
                                <xsl:choose>
                                  <xsl:when test ="substring($ValeurEntiereAvecPoint,5,1) = '0'">
                                    <xsl:choose>
                                      <xsl:when test ="substring($ValeurEntiereAvecPoint,6,1) = '0'">
                                        <xsl:choose>
                                          <xsl:when test ="substring($ValeurEntiereAvecPoint,7,1) = '0'">
                                            <xsl:choose>
                                              <xsl:when test ="substring($ValeurEntiereAvecPoint,8,1) = '0'">
                                                <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiereAvecPoint,9,1)),',',($ValeurdecimalAvecPoint))"/>
                                              </xsl:when>
                                              <xsl:otherwise>
                                                <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiereAvecPoint,8,2)),',',($ValeurdecimalAvecPoint))"/>
                                              </xsl:otherwise>
                                            </xsl:choose>
                                          </xsl:when>
                                          <xsl:otherwise>
                                            <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiereAvecPoint,7,3)),',',($ValeurdecimalAvecPoint))"/>
                                          </xsl:otherwise>
                                        </xsl:choose>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiereAvecPoint,6,4)),',',($ValeurdecimalAvecPoint))"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiereAvecPoint,5,5)),',',($ValeurdecimalAvecPoint))"/>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiereAvecPoint,4,6)),',',($ValeurdecimalAvecPoint))"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiereAvecPoint,3,7)),',',($ValeurdecimalAvecPoint))"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="concat(($ValeurEntiereAvecPoint),',',($ValeurdecimalAvecPoint))"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>

                  <xsl:when test="string-length($ValeurEntiereAvecPoint) = 10">
                    <xsl:choose>
                      <xsl:when test ="substring($ValeurEntiereAvecPoint,2,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($ValeurEntiereAvecPoint,3,1) = '0'">
                            <xsl:choose>
                              <xsl:when test ="substring($ValeurEntiereAvecPoint,4,1) = '0'">
                                <xsl:choose>
                                  <xsl:when test ="substring($ValeurEntiereAvecPoint,5,1) = '0'">
                                    <xsl:choose>
                                      <xsl:when test ="substring($ValeurEntiereAvecPoint,6,1) = '0'">
                                        <xsl:choose>
                                          <xsl:when test ="substring($ValeurEntiereAvecPoint,7,1) = '0'">
                                            <xsl:choose>
                                              <xsl:when test ="substring($ValeurEntiereAvecPoint,8,1) = '0'">
                                                <xsl:choose>
                                                  <xsl:when test ="substring($ValeurEntiereAvecPoint,9,1) = '0'">
                                                    <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiereAvecPoint,10,1)),',',($ValeurdecimalAvecPoint))"/>
                                                  </xsl:when>
                                                  <xsl:otherwise>
                                                    <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiereAvecPoint,9,2)),',',($ValeurdecimalAvecPoint))"/>
                                                  </xsl:otherwise>
                                                </xsl:choose>
                                              </xsl:when>
                                              <xsl:otherwise>
                                                <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiereAvecPoint,8,3)),',',($ValeurdecimalAvecPoint))"/>
                                              </xsl:otherwise>
                                            </xsl:choose>
                                          </xsl:when>
                                          <xsl:otherwise>
                                            <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiereAvecPoint,7,4)),',',($ValeurdecimalAvecPoint))"/>
                                          </xsl:otherwise>
                                        </xsl:choose>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiereAvecPoint,6,5)),',',($ValeurdecimalAvecPoint))"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiereAvecPoint,5,6)),',',($ValeurdecimalAvecPoint))"/>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiereAvecPoint,4,7)),',',($ValeurdecimalAvecPoint))"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiereAvecPoint,3,8)),',',($ValeurdecimalAvecPoint))"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="concat(($ValeurEntiereAvecPoint),',',($ValeurdecimalAvecPoint))"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>

                  <xsl:when test="string-length($ValeurEntiereAvecPoint) = 11">
                    <xsl:choose>
                      <xsl:when test ="substring($ValeurEntiereAvecPoint,2,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($ValeurEntiereAvecPoint,3,1) = '0'">
                            <xsl:choose>
                              <xsl:when test ="substring($ValeurEntiereAvecPoint,4,1) = '0'">
                                <xsl:choose>
                                  <xsl:when test ="substring($ValeurEntiereAvecPoint,5,1) = '0'">
                                    <xsl:choose>
                                      <xsl:when test ="substring($ValeurEntiereAvecPoint,6,1) = '0'">
                                        <xsl:choose>
                                          <xsl:when test ="substring($ValeurEntiereAvecPoint,7,1) = '0'">
                                            <xsl:choose>
                                              <xsl:when test ="substring($ValeurEntiereAvecPoint,8,1) = '0'">
                                                <xsl:choose>
                                                  <xsl:when test ="substring($ValeurEntiereAvecPoint,9,1) = '0'">
                                                    <xsl:choose>
                                                      <xsl:when test ="substring($ValeurEntiereAvecPoint,10,1) = '0'">
                                                        <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiereAvecPoint,11,1)),',',($ValeurdecimalAvecPoint))"/>
                                                      </xsl:when>
                                                      <xsl:otherwise>
                                                        <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiereAvecPoint,10,2)),',',($ValeurdecimalAvecPoint))"/>
                                                      </xsl:otherwise>
                                                    </xsl:choose>
                                                  </xsl:when>
                                                  <xsl:otherwise>
                                                    <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiereAvecPoint,9,3)),',',($ValeurdecimalAvecPoint))"/>
                                                  </xsl:otherwise>
                                                </xsl:choose>
                                              </xsl:when>
                                              <xsl:otherwise>
                                                <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiereAvecPoint,8,4)),',',($ValeurdecimalAvecPoint))"/>
                                              </xsl:otherwise>
                                            </xsl:choose>
                                          </xsl:when>
                                          <xsl:otherwise>
                                            <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiereAvecPoint,7,5)),',',($ValeurdecimalAvecPoint))"/>
                                          </xsl:otherwise>
                                        </xsl:choose>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiereAvecPoint,6,6)),',',($ValeurdecimalAvecPoint))"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiereAvecPoint,5,7)),',',($ValeurdecimalAvecPoint))"/>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiereAvecPoint,4,8)),',',($ValeurdecimalAvecPoint))"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="concat(($PremierCaractere),(substring($ValeurEntiereAvecPoint,3,9)),',',($ValeurdecimalAvecPoint))"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="concat(($ValeurEntiereAvecPoint),',',($ValeurdecimalAvecPoint))"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>

                  <xsl:when test="string-length($ValeurEntiereAvecPoint) &gt; 11">
                    <xsl:value-of select="$InputValeur"></xsl:value-of>
                  </xsl:when>

                </xsl:choose>
              </xsl:otherwise>

            </xsl:choose>
          </xsl:when>
          <xsl:otherwise>
            <xsl:choose>

              <xsl:when test="string-length($ValeurEntiereAvecPoint) = 1">
                <xsl:value-of select="$InputValeur"></xsl:value-of>
              </xsl:when>

              <xsl:when test="string-length($ValeurEntiereAvecPoint) = 2">
                <xsl:choose>
                  <xsl:when test ="substring($ValeurEntiereAvecPoint,1,1) = '0'">
                    <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,2)),',',($ValeurdecimalAvecPoint))"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,1,2)),',',($ValeurdecimalAvecPoint))"/>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>

              <xsl:when test="string-length($ValeurEntiereAvecPoint) = 3">
                <xsl:choose>
                  <xsl:when test ="substring($ValeurEntiereAvecPoint,1,1) = '0'">
                    <xsl:choose>
                      <xsl:when test ="substring($ValeurEntiereAvecPoint,2,1) = '0'">
                        <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,3)),',',($ValeurdecimalAvecPoint))"/>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,2,2)),',',($ValeurdecimalAvecPoint))"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,1,3)),',',($ValeurdecimalAvecPoint))"/>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>

              <xsl:when test="string-length($ValeurEntiereAvecPoint) = 4">
                <xsl:choose>
                  <xsl:when test ="substring($ValeurEntiereAvecPoint,1,1) = '0'">
                    <xsl:choose>
                      <xsl:when test ="substring($ValeurEntiereAvecPoint,2,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($ValeurEntiereAvecPoint,3,1) = '0'">
                            <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,4)),',',($ValeurdecimalAvecPoint))"/>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,3,2)),',',($ValeurdecimalAvecPoint))"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,2,3)),',',($ValeurdecimalAvecPoint))"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,1,4)),',',($ValeurdecimalAvecPoint))"/>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>

              <xsl:when test="string-length($ValeurEntiereAvecPoint) = 5">
                <xsl:choose>
                  <xsl:when test ="substring($ValeurEntiereAvecPoint,1,1) = '0'">
                    <xsl:choose>
                      <xsl:when test ="substring($ValeurEntiereAvecPoint,2,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($ValeurEntiereAvecPoint,3,1) = '0'">
                            <xsl:choose>
                              <xsl:when test ="substring($ValeurEntiereAvecPoint,4,1) = '0'">
                                <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,5)),',',($ValeurdecimalAvecPoint))"/>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,4,2)),',',($ValeurdecimalAvecPoint))"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,3,3)),',',($ValeurdecimalAvecPoint))"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,2,4)),',',($ValeurdecimalAvecPoint))"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,1,5)),',',($ValeurdecimalAvecPoint))"/>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>

              <xsl:when test="string-length($ValeurEntiereAvecPoint) = 6">
                <xsl:choose>
                  <xsl:when test ="substring($ValeurEntiereAvecPoint,1,1) = '0'">
                    <xsl:choose>
                      <xsl:when test ="substring($ValeurEntiereAvecPoint,2,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($ValeurEntiereAvecPoint,3,1) = '0'">
                            <xsl:choose>
                              <xsl:when test ="substring($ValeurEntiereAvecPoint,4,1) = '0'">
                                <xsl:choose>
                                  <xsl:when test ="substring($ValeurEntiereAvecPoint,5,1) = '0'">
                                    <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,6,1)),',',($ValeurdecimalAvecPoint))"/>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,5,2)),',',($ValeurdecimalAvecPoint))"/>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,4,3)),',',($ValeurdecimalAvecPoint))"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,3,4)),',',($ValeurdecimalAvecPoint))"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,2,5)),',',($ValeurdecimalAvecPoint))"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="$InputValeur"></xsl:value-of>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>

              <xsl:when test="string-length($ValeurEntiereAvecPoint) = 7">
                <xsl:choose>
                  <xsl:when test ="substring($ValeurEntiereAvecPoint,1,1) = '0'">
                    <xsl:choose>
                      <xsl:when test ="substring($ValeurEntiereAvecPoint,2,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($ValeurEntiereAvecPoint,3,1) = '0'">
                            <xsl:choose>
                              <xsl:when test ="substring($ValeurEntiereAvecPoint,4,1) = '0'">
                                <xsl:choose>
                                  <xsl:when test ="substring($ValeurEntiereAvecPoint,5,1) = '0'">
                                    <xsl:choose>
                                      <xsl:when test ="substring($ValeurEntiereAvecPoint,6,1) = '0'">
                                        <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,7,1)),',',($ValeurdecimalAvecPoint))"/>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,6,2)),',',($ValeurdecimalAvecPoint))"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,5,3)),',',($ValeurdecimalAvecPoint))"/>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,4,4)),',',($ValeurdecimalAvecPoint))"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,3,5)),',',($ValeurdecimalAvecPoint))"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,2,6)),',',($ValeurdecimalAvecPoint))"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="$InputValeur"></xsl:value-of>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>

              <xsl:when test="string-length($ValeurEntiereAvecPoint) = 8">
                <xsl:choose>
                  <xsl:when test ="substring($ValeurEntiereAvecPoint,1,1) = '0'">
                    <xsl:choose>
                      <xsl:when test ="substring($ValeurEntiereAvecPoint,2,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($ValeurEntiereAvecPoint,3,1) = '0'">
                            <xsl:choose>
                              <xsl:when test ="substring($ValeurEntiereAvecPoint,4,1) = '0'">
                                <xsl:choose>
                                  <xsl:when test ="substring($ValeurEntiereAvecPoint,5,1) = '0'">
                                    <xsl:choose>
                                      <xsl:when test ="substring($ValeurEntiereAvecPoint,6,1) = '0'">
                                        <xsl:choose>
                                          <xsl:when test ="substring($ValeurEntiereAvecPoint,7,1) = '0'">
                                            <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,8,1)),',',($ValeurdecimalAvecPoint))"/>
                                          </xsl:when>
                                          <xsl:otherwise>
                                            <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,7,2)),',',($ValeurdecimalAvecPoint))"/>
                                          </xsl:otherwise>
                                        </xsl:choose>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,6,3)),',',($ValeurdecimalAvecPoint))"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,5,4)),',',($ValeurdecimalAvecPoint))"/>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,4,5)),',',($ValeurdecimalAvecPoint))"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,3,6)),',',($ValeurdecimalAvecPoint))"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,2,7)),',',($ValeurdecimalAvecPoint))"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="$InputValeur"></xsl:value-of>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>

              <xsl:when test="string-length($ValeurEntiereAvecPoint) = 9">
                <xsl:choose>
                  <xsl:when test ="substring($ValeurEntiereAvecPoint,1,1) = '0'">
                    <xsl:choose>
                      <xsl:when test ="substring($ValeurEntiereAvecPoint,2,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($ValeurEntiereAvecPoint,3,1) = '0'">
                            <xsl:choose>
                              <xsl:when test ="substring($ValeurEntiereAvecPoint,4,1) = '0'">
                                <xsl:choose>
                                  <xsl:when test ="substring($ValeurEntiereAvecPoint,5,1) = '0'">
                                    <xsl:choose>
                                      <xsl:when test ="substring($ValeurEntiereAvecPoint,6,1) = '0'">
                                        <xsl:choose>
                                          <xsl:when test ="substring($ValeurEntiereAvecPoint,7,1) = '0'">
                                            <xsl:choose>
                                              <xsl:when test ="substring($ValeurEntiereAvecPoint,8,1) = '0'">
                                                <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,9,1)),',',($ValeurdecimalAvecPoint))"/>
                                              </xsl:when>
                                              <xsl:otherwise>
                                                <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,8,2)),',',($ValeurdecimalAvecPoint))"/>
                                              </xsl:otherwise>
                                            </xsl:choose>
                                          </xsl:when>
                                          <xsl:otherwise>
                                            <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,7,3)),',',($ValeurdecimalAvecPoint))"/>
                                          </xsl:otherwise>
                                        </xsl:choose>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,6,4)),',',($ValeurdecimalAvecPoint))"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,5,5)),',',($ValeurdecimalAvecPoint))"/>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,4,6)),',',($ValeurdecimalAvecPoint))"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,3,7)),',',($ValeurdecimalAvecPoint))"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,2,8)),',',($ValeurdecimalAvecPoint))"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="$InputValeur"></xsl:value-of>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>

              <xsl:when test="string-length($ValeurEntiereAvecPoint) = 10">
                <xsl:choose>
                  <xsl:when test ="substring($ValeurEntiereAvecPoint,1,1) = '0'">
                    <xsl:choose>
                      <xsl:when test ="substring($ValeurEntiereAvecPoint,2,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($ValeurEntiereAvecPoint,3,1) = '0'">
                            <xsl:choose>
                              <xsl:when test ="substring($ValeurEntiereAvecPoint,4,1) = '0'">
                                <xsl:choose>
                                  <xsl:when test ="substring($ValeurEntiereAvecPoint,5,1) = '0'">
                                    <xsl:choose>
                                      <xsl:when test ="substring($ValeurEntiereAvecPoint,6,1) = '0'">
                                        <xsl:choose>
                                          <xsl:when test ="substring($ValeurEntiereAvecPoint,7,1) = '0'">
                                            <xsl:choose>
                                              <xsl:when test ="substring($ValeurEntiereAvecPoint,8,1) = '0'">
                                                <xsl:choose>
                                                  <xsl:when test ="substring($ValeurEntiereAvecPoint,9,1) = '0'">
                                                    <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,10,1)),',',($ValeurdecimalAvecPoint))"/>
                                                  </xsl:when>
                                                  <xsl:otherwise>
                                                    <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,9,2)),',',($ValeurdecimalAvecPoint))"/>
                                                  </xsl:otherwise>
                                                </xsl:choose>
                                              </xsl:when>
                                              <xsl:otherwise>
                                                <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,8,3)),',',($ValeurdecimalAvecPoint))"/>
                                              </xsl:otherwise>
                                            </xsl:choose>
                                          </xsl:when>
                                          <xsl:otherwise>
                                            <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,7,4)),',',($ValeurdecimalAvecPoint))"/>
                                          </xsl:otherwise>
                                        </xsl:choose>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,6,5)),',',($ValeurdecimalAvecPoint))"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,5,6)),',',($ValeurdecimalAvecPoint))"/>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,4,7)),',',($ValeurdecimalAvecPoint))"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,3,8)),',',($ValeurdecimalAvecPoint))"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,2,9)),',',($ValeurdecimalAvecPoint))"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="$InputValeur"></xsl:value-of>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>

              <xsl:when test="string-length($ValeurEntiereAvecPoint) = 11">
                <xsl:choose>
                  <xsl:when test ="substring($ValeurEntiereAvecPoint,1,1) = '0'">
                    <xsl:choose>
                      <xsl:when test ="substring($ValeurEntiereAvecPoint,2,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($ValeurEntiereAvecPoint,3,1) = '0'">
                            <xsl:choose>
                              <xsl:when test ="substring($ValeurEntiereAvecPoint,4,1) = '0'">
                                <xsl:choose>
                                  <xsl:when test ="substring($ValeurEntiereAvecPoint,5,1) = '0'">
                                    <xsl:choose>
                                      <xsl:when test ="substring($ValeurEntiereAvecPoint,6,1) = '0'">
                                        <xsl:choose>
                                          <xsl:when test ="substring($ValeurEntiereAvecPoint,7,1) = '0'">
                                            <xsl:choose>
                                              <xsl:when test ="substring($ValeurEntiereAvecPoint,8,1) = '0'">
                                                <xsl:choose>
                                                  <xsl:when test ="substring($ValeurEntiereAvecPoint,9,1) = '0'">
                                                    <xsl:choose>
                                                      <xsl:when test ="substring($ValeurEntiereAvecPoint,10,1) = '0'">
                                                        <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,11,1)),',',($ValeurdecimalAvecPoint))"/>
                                                      </xsl:when>
                                                      <xsl:otherwise>
                                                        <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,10,2)),',',($ValeurdecimalAvecPoint))"/>
                                                      </xsl:otherwise>
                                                    </xsl:choose>
                                                  </xsl:when>
                                                  <xsl:otherwise>
                                                    <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,9,3)),',',($ValeurdecimalAvecPoint))"/>
                                                  </xsl:otherwise>
                                                </xsl:choose>
                                              </xsl:when>
                                              <xsl:otherwise>
                                                <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,8,4)),',',($ValeurdecimalAvecPoint))"/>
                                              </xsl:otherwise>
                                            </xsl:choose>
                                          </xsl:when>
                                          <xsl:otherwise>
                                            <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,7,5)),',',($ValeurdecimalAvecPoint))"/>
                                          </xsl:otherwise>
                                        </xsl:choose>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,6,6)),',',($ValeurdecimalAvecPoint))"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,5,7)),',',($ValeurdecimalAvecPoint))"/>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,4,8)),',',($ValeurdecimalAvecPoint))"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,3,9)),',',($ValeurdecimalAvecPoint))"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,2,10)),',',($ValeurdecimalAvecPoint))"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="$InputValeur"></xsl:value-of>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>

              <xsl:when test="string-length($ValeurEntiereAvecPoint) = 11">
                <xsl:choose>
                  <xsl:when test ="substring($ValeurEntiereAvecPoint,1,1) = '0'">
                    <xsl:choose>
                      <xsl:when test ="substring($ValeurEntiereAvecPoint,2,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($ValeurEntiereAvecPoint,3,1) = '0'">
                            <xsl:choose>
                              <xsl:when test ="substring($ValeurEntiereAvecPoint,4,1) = '0'">
                                <xsl:choose>
                                  <xsl:when test ="substring($ValeurEntiereAvecPoint,5,1) = '0'">
                                    <xsl:choose>
                                      <xsl:when test ="substring($ValeurEntiereAvecPoint,6,1) = '0'">
                                        <xsl:choose>
                                          <xsl:when test ="substring($ValeurEntiereAvecPoint,7,1) = '0'">
                                            <xsl:choose>
                                              <xsl:when test ="substring($ValeurEntiereAvecPoint,8,1) = '0'">
                                                <xsl:choose>
                                                  <xsl:when test ="substring($ValeurEntiereAvecPoint,9,1) = '0'">
                                                    <xsl:choose>
                                                      <xsl:when test ="substring($ValeurEntiereAvecPoint,10,1) = '0'">
                                                        <xsl:choose>
                                                          <xsl:when test ="substring($ValeurEntiereAvecPoint,11,1) = '0'">
                                                            <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,12,1)),',',($ValeurdecimalAvecPoint))"/>
                                                          </xsl:when>
                                                          <xsl:otherwise>
                                                            <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,11,2)),',',($ValeurdecimalAvecPoint))"/>
                                                          </xsl:otherwise>
                                                        </xsl:choose>
                                                      </xsl:when>
                                                      <xsl:otherwise>
                                                        <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,10,3)),',',($ValeurdecimalAvecPoint))"/>
                                                      </xsl:otherwise>
                                                    </xsl:choose>
                                                  </xsl:when>
                                                  <xsl:otherwise>
                                                    <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,9,4)),',',($ValeurdecimalAvecPoint))"/>
                                                  </xsl:otherwise>
                                                </xsl:choose>
                                              </xsl:when>
                                              <xsl:otherwise>
                                                <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,8,5)),',',($ValeurdecimalAvecPoint))"/>
                                              </xsl:otherwise>
                                            </xsl:choose>
                                          </xsl:when>
                                          <xsl:otherwise>
                                            <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,7,6)),',',($ValeurdecimalAvecPoint))"/>
                                          </xsl:otherwise>
                                        </xsl:choose>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,6,7)),',',($ValeurdecimalAvecPoint))"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,5,8)),',',($ValeurdecimalAvecPoint))"/>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,4,9)),',',($ValeurdecimalAvecPoint))"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,3,10)),',',($ValeurdecimalAvecPoint))"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="concat((substring($ValeurEntiereAvecPoint,2,11)),',',($ValeurdecimalAvecPoint))"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="$InputValeur"></xsl:value-of>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>

              <xsl:when test="string-length($ValeurEntiereAvecPoint) &gt; 12">
                <xsl:value-of select="number($InputValeur)"></xsl:value-of>
              </xsl:when>
            </xsl:choose>

          </xsl:otherwise>

        </xsl:choose>

      </xsl:when>
  
      <xsl:otherwise>
        <xsl:choose>
          <xsl:when test="($PremierCaractere = '+') or ($PremierCaractere = '-')">
            <xsl:choose>
              <xsl:when test="string-length($InputValeur) = 2">
                <xsl:value-of select="$InputValeur"></xsl:value-of>
              </xsl:when>
              <xsl:when test="string-length($InputValeur) = 3">
                <xsl:choose>
                  <xsl:when test="substring($InputValeur,2,1) = '0'">
                    <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,3,1)))"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="$InputValeur"></xsl:value-of>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>

              <xsl:when test="string-length($InputValeur) = 4">
                <xsl:choose>
                  <xsl:when test="substring($InputValeur,2,1) = '0'">
                    <xsl:choose>
                      <xsl:when test="substring($InputValeur,3,1) = '0'">
                        <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,4,1)))"/>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,3,2)))"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="$InputValeur"></xsl:value-of>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>

              <xsl:when test="string-length($InputValeur) = 5">
                <xsl:choose>
                  <xsl:when test="substring($InputValeur,2,1) = '0'">
                    <xsl:choose>
                      <xsl:when test="substring($InputValeur,3,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($InputValeur,4,1) = '0'">
                            <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,5,1)))"/>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,4,2)))"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,3,3)))"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="$InputValeur"></xsl:value-of>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>

              <xsl:when test="string-length($InputValeur) = 6">
                <xsl:choose>
                  <xsl:when test="substring($InputValeur,2,1) = '0'">
                    <xsl:choose>
                      <xsl:when test="substring($InputValeur,3,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($InputValeur,4,1) = '0'">
                            <xsl:choose>
                              <xsl:when test ="substring($InputValeur,5,1) = '0'">
                                <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,6,1)))"/>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,5,2)))"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,4,3)))"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,3,4)))"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="$InputValeur"></xsl:value-of>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>

              <xsl:when test="string-length($InputValeur) = 7">
                <xsl:choose>
                  <xsl:when test="substring($InputValeur,2,1) = '0'">
                    <xsl:choose>
                      <xsl:when test="substring($InputValeur,3,1) = '0'">
                        <xsl:choose>
                          <xsl:when test="substring($InputValeur,4,1) = '0'">
                            <xsl:choose>
                              <xsl:when test="substring($InputValeur,5,1) = '0'">
                                <xsl:choose>
                                  <xsl:when test="substring($InputValeur,6,1) = '0'">
                                    <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,7,1)))"/>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,6,2)))"/>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,5,3)))"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,4,4)))"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,3,5)))"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="$InputValeur"></xsl:value-of>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>

              <xsl:when test="string-length($InputValeur) = 8">
                <xsl:choose>
                  <xsl:when test ="substring($InputValeur,2,1) = '0'">
                    <xsl:choose>
                      <xsl:when test ="substring($InputValeur,3,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($InputValeur,4,1) = '0'">
                            <xsl:choose>
                              <xsl:when test ="substring($InputValeur,5,1) = '0'">
                                <xsl:choose>
                                  <xsl:when test ="substring($InputValeur,6,1) = '0'">
                                    <xsl:choose>
                                      <xsl:when test ="substring($InputValeur,7,1) = '0'">
                                        <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,8,1)))"/>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,7,2)))"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,6,3)))"/>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,5,4)))"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,4,5)))"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,3,6)))"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="$InputValeur"></xsl:value-of>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>

              <xsl:when test="string-length($InputValeur) = 9">
                <xsl:choose>
                  <xsl:when test ="substring($InputValeur,2,1) = '0'">
                    <xsl:choose>
                      <xsl:when test ="substring($InputValeur,3,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($InputValeur,4,1) = '0'">
                            <xsl:choose>
                              <xsl:when test ="substring($InputValeur,6,1) = '0'">
                                <xsl:choose>
                                  <xsl:when test ="substring($InputValeur,6,1) = '0'">
                                    <xsl:choose>
                                      <xsl:when test ="substring($InputValeur,7,1) = '0'">
                                        <xsl:choose>
                                          <xsl:when test ="substring($InputValeur,8,1) = '0'">
                                            <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,9,1)))"/>
                                          </xsl:when>
                                          <xsl:otherwise>
                                            <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,8,2)))"/>
                                          </xsl:otherwise>
                                        </xsl:choose>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,7,3)))"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,6,4)))"/>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,5,5)))"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,4,6)))"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,3,7)))"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="$InputValeur"></xsl:value-of>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>

              <xsl:when test="string-length($InputValeur) = 10">
                <xsl:choose>
                  <xsl:when test ="substring($InputValeur,2,1) = '0'">
                    <xsl:choose>
                      <xsl:when test ="substring($InputValeur,3,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($InputValeur,4,1) = '0'">
                            <xsl:choose>
                              <xsl:when test ="substring($InputValeur,5,1) = '0'">
                                <xsl:choose>
                                  <xsl:when test ="substring($InputValeur,6,1) = '0'">
                                    <xsl:choose>
                                      <xsl:when test ="substring($InputValeur,7,1) = '0'">
                                        <xsl:choose>
                                          <xsl:when test ="substring($InputValeur,8,1) = '0'">
                                            <xsl:choose>
                                              <xsl:when test ="substring($InputValeur,9,1) = '0'">
                                                <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,10,1)))"/>
                                              </xsl:when>
                                              <xsl:otherwise>
                                                <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,9,2)))"/>
                                              </xsl:otherwise>
                                            </xsl:choose>
                                          </xsl:when>
                                          <xsl:otherwise>
                                            <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,8,3)))"/>
                                          </xsl:otherwise>
                                        </xsl:choose>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,7,4)))"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,6,5)))"/>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,5,6)))"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,4,7)))"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,3,8)))"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="$InputValeur"></xsl:value-of>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>

              <xsl:when test="string-length($InputValeur) = 11">
                <xsl:choose>
                  <xsl:when test ="substring($InputValeur,2,1) = '0'">
                    <xsl:choose>
                      <xsl:when test ="substring($InputValeur,3,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($InputValeur,4,1) = '0'">
                            <xsl:choose>
                              <xsl:when test ="substring($InputValeur,5,1) = '0'">
                                <xsl:choose>
                                  <xsl:when test ="substring($InputValeur,6,1) = '0'">
                                    <xsl:choose>
                                      <xsl:when test ="substring($InputValeur,7,1) = '0'">
                                        <xsl:choose>
                                          <xsl:when test ="substring($InputValeur,8,1) = '0'">
                                            <xsl:choose>
                                              <xsl:when test ="substring($InputValeur,9,1) = '0'">
                                                <xsl:choose>
                                                  <xsl:when test ="substring($InputValeur,10,1) = '0'">
                                                    <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,11,1)))"/>
                                                  </xsl:when>
                                                  <xsl:otherwise>
                                                    <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,10,2)))"/>
                                                  </xsl:otherwise>
                                                </xsl:choose>
                                              </xsl:when>
                                              <xsl:otherwise>
                                                <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,9,3)))"/>
                                              </xsl:otherwise>
                                            </xsl:choose>
                                          </xsl:when>
                                          <xsl:otherwise>
                                            <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,8,4)))"/>
                                          </xsl:otherwise>
                                        </xsl:choose>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,7,5)))"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,6,6)))"/>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,5,7)))"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,4,8)))"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,3,9)))"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,2,10)))"/>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>

              <xsl:when test="string-length($InputValeur) = 12">
                <xsl:choose>
                  <xsl:when test ="substring($InputValeur,2,1) = '0'">
                    <xsl:choose>
                      <xsl:when test ="substring($InputValeur,3,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($InputValeur,4,1) = '0'">
                            <xsl:choose>
                              <xsl:when test ="substring($InputValeur,5,1) = '0'">
                                <xsl:choose>
                                  <xsl:when test ="substring($InputValeur,6,1) = '0'">
                                    <xsl:choose>
                                      <xsl:when test ="substring($InputValeur,7,1) = '0'">
                                        <xsl:choose>
                                          <xsl:when test ="substring($InputValeur,8,1) = '0'">
                                            <xsl:choose>
                                              <xsl:when test ="substring($InputValeur,9,1) = '0'">
                                                <xsl:choose>
                                                  <xsl:when test ="substring($InputValeur,10,1) = '0'">
                                                    <xsl:choose>
                                                      <xsl:when test ="substring($InputValeur,11,1) = '0'">
                                                        <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,12,1)))"/>
                                                      </xsl:when>
                                                      <xsl:otherwise>
                                                        <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,11,2)))"/>
                                                      </xsl:otherwise>
                                                    </xsl:choose>
                                                  </xsl:when>
                                                  <xsl:otherwise>
                                                    <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,10,3)))"/>
                                                  </xsl:otherwise>
                                                </xsl:choose>
                                              </xsl:when>
                                              <xsl:otherwise>
                                                <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,9,4)))"/>
                                              </xsl:otherwise>
                                            </xsl:choose>
                                          </xsl:when>
                                          <xsl:otherwise>
                                            <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,8,5)))"/>
                                          </xsl:otherwise>
                                        </xsl:choose>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,7,6)))"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,6,7)))"/>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,5,8)))"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,4,9)))"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,3,10)))"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="$InputValeur"></xsl:value-of>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>

              <xsl:when test="string-length($InputValeur) = 13">
                <xsl:choose>
                  <xsl:when test ="substring($InputValeur,2,1) = '0'">
                    <xsl:choose>
                      <xsl:when test ="substring($InputValeur,3,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($InputValeur,4,1) = '0'">
                            <xsl:choose>
                              <xsl:when test ="substring($InputValeur,5,1) = '0'">
                                <xsl:choose>
                                  <xsl:when test ="substring($InputValeur,6,1) = '0'">
                                    <xsl:choose>
                                      <xsl:when test ="substring($InputValeur,7,1) = '0'">
                                        <xsl:choose>
                                          <xsl:when test ="substring($InputValeur,8,1) = '0'">
                                            <xsl:choose>
                                              <xsl:when test ="substring($InputValeur,9,1) = '0'">
                                                <xsl:choose>
                                                  <xsl:when test ="substring($InputValeur,10,1) = '0'">
                                                    <xsl:choose>
                                                      <xsl:when test ="substring($InputValeur,11,1) = '0'">
                                                        <xsl:choose>
                                                          <xsl:when test ="substring($InputValeur,12,1) = '0'">
                                                            <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,13,1)))"/>
                                                          </xsl:when>
                                                          <xsl:otherwise>
                                                            <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,12,2)))"/>
                                                          </xsl:otherwise>
                                                        </xsl:choose>
                                                      </xsl:when>
                                                      <xsl:otherwise>
                                                        <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,11,3)))"/>
                                                      </xsl:otherwise>
                                                    </xsl:choose>
                                                  </xsl:when>
                                                  <xsl:otherwise>
                                                    <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,10,4)))"/>
                                                  </xsl:otherwise>
                                                </xsl:choose>
                                              </xsl:when>
                                              <xsl:otherwise>
                                                <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,9,5)))"/>
                                              </xsl:otherwise>
                                            </xsl:choose>
                                          </xsl:when>
                                          <xsl:otherwise>
                                            <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,8,6)))"/>
                                          </xsl:otherwise>
                                        </xsl:choose>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,7,7)))"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,6,8)))"/>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,5,9)))"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,4,10)))"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,3,11)))"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="$InputValeur"></xsl:value-of>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>

              <xsl:when test="string-length($InputValeur) = 14">
                <xsl:choose>
                  <xsl:when test ="substring($InputValeur,2,1) = '0'">
                    <xsl:choose>
                      <xsl:when test ="substring($InputValeur,3,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($InputValeur,4,1) = '0'">
                            <xsl:choose>
                              <xsl:when test ="substring($InputValeur,5,1) = '0'">
                                <xsl:choose>
                                  <xsl:when test ="substring($InputValeur,6,1) = '0'">
                                    <xsl:choose>
                                      <xsl:when test ="substring($InputValeur,7,1) = '0'">
                                        <xsl:choose>
                                          <xsl:when test ="substring($InputValeur,8,1) = '0'">
                                            <xsl:choose>
                                              <xsl:when test ="substring($InputValeur,9,1) = '0'">
                                                <xsl:choose>
                                                  <xsl:when test ="substring($InputValeur,10,1) = '0'">
                                                    <xsl:choose>
                                                      <xsl:when test ="substring($InputValeur,11,1) = '0'">
                                                        <xsl:choose>
                                                          <xsl:when test ="substring($InputValeur,12,1) = '0'">
                                                            <xsl:choose>
                                                              <xsl:when test ="substring($InputValeur,13,1) = '0'">
                                                                <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,14,1)))"/>
                                                              </xsl:when>
                                                              <xsl:otherwise>
                                                                <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,13,2)))"/>
                                                              </xsl:otherwise>
                                                            </xsl:choose>
                                                          </xsl:when>
                                                          <xsl:otherwise>
                                                            <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,12,3)))"/>
                                                          </xsl:otherwise>
                                                        </xsl:choose>
                                                      </xsl:when>
                                                      <xsl:otherwise>
                                                        <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,11,4)))"/>
                                                      </xsl:otherwise>
                                                    </xsl:choose>
                                                  </xsl:when>
                                                  <xsl:otherwise>
                                                    <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,10,5)))"/>
                                                  </xsl:otherwise>
                                                </xsl:choose>
                                              </xsl:when>
                                              <xsl:otherwise>
                                                <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,9,6)))"/>
                                              </xsl:otherwise>
                                            </xsl:choose>
                                          </xsl:when>
                                          <xsl:otherwise>
                                            <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,8,7)))"/>
                                          </xsl:otherwise>
                                        </xsl:choose>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,7,8)))"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,6,9)))"/>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,5,10)))"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,4,11)))"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="concat(($PremierCaractere),(substring($InputValeur,3,12)))"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="$InputValeur"></xsl:value-of>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>


              <xsl:otherwise>
                <xsl:value-of select="$InputValeur"></xsl:value-of>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:when>

          <xsl:otherwise>
            
            <xsl:choose>
              <xsl:when test="string-length($InputValeur) = 1">
                <xsl:value-of select="$InputValeur"></xsl:value-of>
              </xsl:when>
              
              <xsl:when test="string-length($InputValeur) = 2">
                <xsl:choose>
                  <xsl:when test ="substring($InputValeur,1,1) = '0'">
                    <xsl:value-of select="substring($InputValeur,2,1)"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="$InputValeur"></xsl:value-of>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>

              <xsl:when test="string-length($InputValeur) = 3">
                <xsl:choose>
                  <xsl:when test ="substring($InputValeur,1,1) = '0'">
                    <xsl:choose>
                      <xsl:when test ="substring($InputValeur,2,1) = '0'">
                        <xsl:value-of select="substring($InputValeur,3,1)"/>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="substring($InputValeur,2,2)"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="$InputValeur"></xsl:value-of>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>

              <xsl:when test="string-length($InputValeur) = 4">
                <xsl:choose>
                  <xsl:when test ="substring($InputValeur,1,1) = '0'">
                    <xsl:choose>
                      <xsl:when test ="substring($InputValeur,2,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($InputValeur,3,1) = '0'">
                            <xsl:value-of select="substring($InputValeur,4,1)"/>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="substring($InputValeur,3,2)"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="substring($InputValeur,2,3)"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="$InputValeur"></xsl:value-of>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>

              <xsl:when test="string-length($InputValeur) = 5">
                <xsl:choose>
                  <xsl:when test ="substring($InputValeur,1,1) = '0'">
                    <xsl:choose>
                      <xsl:when test ="substring($InputValeur,2,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($InputValeur,3,1) = '0'">
                            <xsl:choose>
                              <xsl:when test ="substring($InputValeur,4,1) = '0'">
                                <xsl:value-of select="substring($InputValeur,5,1)"/>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="substring($InputValeur,4,2)"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="substring($InputValeur,3,3)"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="substring($InputValeur,2,4)"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="$InputValeur"></xsl:value-of>
                  </xsl:otherwise>
                </xsl:choose>              
              </xsl:when>

              <xsl:when test="string-length($InputValeur) = 6">
                <xsl:choose>
                  <xsl:when test ="substring($InputValeur,1,1) = '0'">
                    <xsl:choose>
                      <xsl:when test ="substring($InputValeur,2,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($InputValeur,3,1) = '0'">
                            <xsl:choose>
                              <xsl:when test ="substring($InputValeur,4,1) = '0'">
                                <xsl:choose>
                                  <xsl:when test ="substring($InputValeur,5,1) = '0'">
                                    <xsl:value-of select="substring($InputValeur,6,1)"/>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <xsl:value-of select="substring($InputValeur,5,2)"/>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="substring($InputValeur,4,3)"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="substring($InputValeur,3,4)"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="substring($InputValeur,2,5)"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="$InputValeur"></xsl:value-of>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>

              <xsl:when test="string-length($InputValeur) = 7">
                <xsl:choose>
                  <xsl:when test ="substring($InputValeur,1,1) = '0'">
                    <xsl:choose>
                      <xsl:when test ="substring($InputValeur,2,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($InputValeur,3,1) = '0'">
                            <xsl:choose>
                              <xsl:when test ="substring($InputValeur,4,1) = '0'">
                                <xsl:choose>
                                  <xsl:when test ="substring($InputValeur,5,1) = '0'">
                                    <xsl:choose>
                                      <xsl:when test ="substring($InputValeur,6,1) = '0'">
                                        <xsl:value-of select="substring($InputValeur,7,1)"/>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="substring($InputValeur,6,2)"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <xsl:value-of select="substring($InputValeur,5,3)"/>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="substring($InputValeur,4,4)"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="substring($InputValeur,3,5)"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="substring($InputValeur,2,6)"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="$InputValeur"></xsl:value-of>
                  </xsl:otherwise>
                </xsl:choose>              
              </xsl:when>

              <xsl:when test="string-length($InputValeur) = 8">
                <xsl:choose>
                  <xsl:when test ="substring($InputValeur,1,1) = '0'">
                    <xsl:choose>
                      <xsl:when test ="substring($InputValeur,2,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($InputValeur,3,1) = '0'">
                            <xsl:choose>
                              <xsl:when test ="substring($InputValeur,4,1) = '0'">
                                <xsl:choose>
                                  <xsl:when test ="substring($InputValeur,5,1) = '0'">
                                    <xsl:choose>
                                      <xsl:when test ="substring($InputValeur,6,1) = '0'">
                                        <xsl:choose>
                                          <xsl:when test ="substring($InputValeur,7,1) = '0'">
                                            <xsl:value-of select="substring($InputValeur,8,1)"/>
                                          </xsl:when>
                                          <xsl:otherwise>
                                            <xsl:value-of select="substring($InputValeur,7,2)"/>
                                          </xsl:otherwise>
                                        </xsl:choose>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="substring($InputValeur,6,3)"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <xsl:value-of select="substring($InputValeur,5,4)"/>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="substring($InputValeur,4,5)"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="substring($InputValeur,3,6)"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="substring($InputValeur,2,7)"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="$InputValeur"></xsl:value-of>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>

              <xsl:when test="string-length($InputValeur) = 9">
                <xsl:choose>
                  <xsl:when test ="substring($InputValeur,1,1) = '0'">
                    <xsl:choose>
                      <xsl:when test ="substring($InputValeur,2,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($InputValeur,3,1) = '0'">
                            <xsl:choose>
                              <xsl:when test ="substring($InputValeur,4,1) = '0'">
                                <xsl:choose>
                                  <xsl:when test ="substring($InputValeur,5,1) = '0'">
                                    <xsl:choose>
                                      <xsl:when test ="substring($InputValeur,6,1) = '0'">
                                        <xsl:choose>
                                          <xsl:when test ="substring($InputValeur,7,1) = '0'">
                                            <xsl:choose>
                                              <xsl:when test ="substring($InputValeur,8,1) = '0'">
                                                <xsl:value-of select="substring($InputValeur,9,1)"/>
                                              </xsl:when>
                                              <xsl:otherwise>
                                                <xsl:value-of select="substring($InputValeur,8,2)"/>
                                              </xsl:otherwise>
                                            </xsl:choose>
                                          </xsl:when>
                                          <xsl:otherwise>
                                            <xsl:value-of select="substring($InputValeur,7,3)"/>
                                          </xsl:otherwise>
                                        </xsl:choose>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="substring($InputValeur,6,4)"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <xsl:value-of select="substring($InputValeur,5,5)"/>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="substring($InputValeur,4,6)"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="substring($InputValeur,3,7)"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="substring($InputValeur,2,8)"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="$InputValeur"></xsl:value-of>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>

              <xsl:when test="string-length($InputValeur) = 10">
                <xsl:choose>
                  <xsl:when test ="substring($InputValeur,1,1) = '0'">
                    <xsl:choose>
                      <xsl:when test ="substring($InputValeur,2,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($InputValeur,3,1) = '0'">
                            <xsl:choose>
                              <xsl:when test ="substring($InputValeur,4,1) = '0'">
                                <xsl:choose>
                                  <xsl:when test ="substring($InputValeur,5,1) = '0'">
                                    <xsl:choose>
                                      <xsl:when test ="substring($InputValeur,6,1) = '0'">
                                        <xsl:choose>
                                          <xsl:when test ="substring($InputValeur,7,1) = '0'">
                                            <xsl:choose>
                                              <xsl:when test ="substring($InputValeur,8,1) = '0'">
                                                <xsl:choose>
                                                  <xsl:when test ="substring($InputValeur,9,1) = '0'">
                                                    <xsl:value-of select="substring($InputValeur,10,1)"/>
                                                  </xsl:when>
                                                  <xsl:otherwise>
                                                    <xsl:value-of select="substring($InputValeur,9,2)"/>
                                                  </xsl:otherwise>
                                                </xsl:choose>
                                              </xsl:when>
                                              <xsl:otherwise>
                                                <xsl:value-of select="substring($InputValeur,8,3)"/>
                                              </xsl:otherwise>
                                            </xsl:choose>
                                          </xsl:when>
                                          <xsl:otherwise>
                                            <xsl:value-of select="substring($InputValeur,7,4)"/>
                                          </xsl:otherwise>
                                        </xsl:choose>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="substring($InputValeur,6,5)"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <xsl:value-of select="substring($InputValeur,5,6)"/>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="substring($InputValeur,4,7)"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="substring($InputValeur,3,8)"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="substring($InputValeur,2,9)"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="$InputValeur"></xsl:value-of>
                  </xsl:otherwise>
                </xsl:choose>                            
              </xsl:when>

              <xsl:when test="string-length($InputValeur) = 11">
                <xsl:choose>
                  <xsl:when test ="substring($InputValeur,1,1) = '0'">
                    <xsl:choose>
                      <xsl:when test ="substring($InputValeur,2,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($InputValeur,3,1) = '0'">
                            <xsl:choose>
                              <xsl:when test ="substring($InputValeur,4,1) = '0'">
                                <xsl:choose>
                                  <xsl:when test ="substring($InputValeur,5,1) = '0'">
                                    <xsl:choose>
                                      <xsl:when test ="substring($InputValeur,6,1) = '0'">
                                        <xsl:choose>
                                          <xsl:when test ="substring($InputValeur,7,1) = '0'">
                                            <xsl:choose>
                                              <xsl:when test ="substring($InputValeur,8,1) = '0'">
                                                <xsl:choose>
                                                  <xsl:when test ="substring($InputValeur,9,1) = '0'">
                                                    <xsl:choose>
                                                      <xsl:when test ="substring($InputValeur,10,1) = '0'">
                                                        <xsl:value-of select="substring($InputValeur,11,1)"/>
                                                      </xsl:when>
                                                      <xsl:otherwise>
                                                        <xsl:value-of select="substring($InputValeur,10,2)"/>
                                                      </xsl:otherwise>
                                                    </xsl:choose>
                                                  </xsl:when>
                                                  <xsl:otherwise>
                                                    <xsl:value-of select="substring($InputValeur,9,3)"/>
                                                  </xsl:otherwise>
                                                </xsl:choose>
                                              </xsl:when>
                                              <xsl:otherwise>
                                                <xsl:value-of select="substring($InputValeur,8,4)"/>
                                              </xsl:otherwise>
                                            </xsl:choose>
                                          </xsl:when>
                                          <xsl:otherwise>
                                            <xsl:value-of select="substring($InputValeur,7,5)"/>
                                          </xsl:otherwise>
                                        </xsl:choose>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="substring($InputValeur,6,6)"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <xsl:value-of select="substring($InputValeur,5,7)"/>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="substring($InputValeur,4,8)"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="substring($InputValeur,3,9)"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="substring($InputValeur,2,10)"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="$InputValeur"></xsl:value-of>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>

              <xsl:when test="string-length($InputValeur) = 12">
                <xsl:choose>
                  <xsl:when test ="substring($InputValeur,1,1) = '0'">
                    <xsl:choose>
                      <xsl:when test ="substring($InputValeur,2,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($InputValeur,3,1) = '0'">
                            <xsl:choose>
                              <xsl:when test ="substring($InputValeur,4,1) = '0'">
                                <xsl:choose>
                                  <xsl:when test ="substring($InputValeur,5,1) = '0'">
                                    <xsl:choose>
                                      <xsl:when test ="substring($InputValeur,6,1) = '0'">
                                        <xsl:choose>
                                          <xsl:when test ="substring($InputValeur,7,1) = '0'">
                                            <xsl:choose>
                                              <xsl:when test ="substring($InputValeur,8,1) = '0'">
                                                <xsl:choose>
                                                  <xsl:when test ="substring($InputValeur,9,1) = '0'">
                                                    <xsl:choose>
                                                      <xsl:when test ="substring($InputValeur,10,1) = '0'">
                                                        <xsl:choose>
                                                          <xsl:when test ="substring($InputValeur,11,1) = '0'">
                                                            <xsl:value-of select="substring($InputValeur,12,1)"/>
                                                          </xsl:when>
                                                          <xsl:otherwise>
                                                            <xsl:value-of select="substring($InputValeur,11,2)"/>
                                                          </xsl:otherwise>
                                                        </xsl:choose>
                                                      </xsl:when>
                                                      <xsl:otherwise>
                                                        <xsl:value-of select="substring($InputValeur,10,3)"/>
                                                      </xsl:otherwise>
                                                    </xsl:choose>
                                                  </xsl:when>
                                                  <xsl:otherwise>
                                                    <xsl:value-of select="substring($InputValeur,9,4)"/>
                                                  </xsl:otherwise>
                                                </xsl:choose>
                                              </xsl:when>
                                              <xsl:otherwise>
                                                <xsl:value-of select="substring($InputValeur,8,5)"/>
                                              </xsl:otherwise>
                                            </xsl:choose>
                                          </xsl:when>
                                          <xsl:otherwise>
                                            <xsl:value-of select="substring($InputValeur,7,6)"/>
                                          </xsl:otherwise>
                                        </xsl:choose>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="substring($InputValeur,6,7)"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <xsl:value-of select="substring($InputValeur,5,8)"/>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="substring($InputValeur,4,9)"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="substring($InputValeur,3,10)"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="substring($InputValeur,2,11)"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="$InputValeur"></xsl:value-of>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>

              <xsl:when test="string-length($InputValeur) = 13">
                <xsl:choose>
                  <xsl:when test ="substring($InputValeur,1,1) = '0'">
                    <xsl:choose>
                      <xsl:when test ="substring($InputValeur,2,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($InputValeur,3,1) = '0'">
                            <xsl:choose>
                              <xsl:when test ="substring($InputValeur,4,1) = '0'">
                                <xsl:choose>
                                  <xsl:when test ="substring($InputValeur,5,1) = '0'">
                                    <xsl:choose>
                                      <xsl:when test ="substring($InputValeur,6,1) = '0'">
                                        <xsl:choose>
                                          <xsl:when test ="substring($InputValeur,7,1) = '0'">
                                            <xsl:choose>
                                              <xsl:when test ="substring($InputValeur,8,1) = '0'">
                                                <xsl:choose>
                                                  <xsl:when test ="substring($InputValeur,9,1) = '0'">
                                                    <xsl:choose>
                                                      <xsl:when test ="substring($InputValeur,10,1) = '0'">
                                                        <xsl:choose>
                                                          <xsl:when test ="substring($InputValeur,11,1) = '0'">
                                                            <xsl:choose>
                                                              <xsl:when test ="substring($InputValeur,12,1) = '0'">
                                                                <xsl:value-of select="substring($InputValeur,13,1)"/>
                                                              </xsl:when>
                                                              <xsl:otherwise>
                                                                <xsl:value-of select="substring($InputValeur,12,2)"/>
                                                              </xsl:otherwise>
                                                            </xsl:choose>
                                                          </xsl:when>
                                                          <xsl:otherwise>
                                                            <xsl:value-of select="substring($InputValeur,11,3)"/>
                                                          </xsl:otherwise>
                                                        </xsl:choose>
                                                      </xsl:when>
                                                      <xsl:otherwise>
                                                        <xsl:value-of select="substring($InputValeur,10,4)"/>
                                                      </xsl:otherwise>
                                                    </xsl:choose>
                                                  </xsl:when>
                                                  <xsl:otherwise>
                                                    <xsl:value-of select="substring($InputValeur,9,5)"/>
                                                  </xsl:otherwise>
                                                </xsl:choose>
                                              </xsl:when>
                                              <xsl:otherwise>
                                                <xsl:value-of select="substring($InputValeur,8,6)"/>
                                              </xsl:otherwise>
                                            </xsl:choose>
                                          </xsl:when>
                                          <xsl:otherwise>
                                            <xsl:value-of select="substring($InputValeur,7,7)"/>
                                          </xsl:otherwise>
                                        </xsl:choose>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="substring($InputValeur,6,8)"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <xsl:value-of select="substring($InputValeur,5,9)"/>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="substring($InputValeur,4,10)"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="substring($InputValeur,3,11)"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="substring($InputValeur,2,12)"/>
                      </xsl:otherwise>
                    </xsl:choose>                    
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="$InputValeur"></xsl:value-of>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>

              <xsl:when test="string-length($InputValeur) = 14">
                <xsl:choose>
                  <xsl:when test ="substring($InputValeur,1,1) = '0'">
                    <xsl:choose>
                      <xsl:when test ="substring($InputValeur,2,1) = '0'">
                        <xsl:choose>
                          <xsl:when test ="substring($InputValeur,3,1) = '0'">
                            <xsl:choose>
                              <xsl:when test ="substring($InputValeur,4,1) = '0'">
                                <xsl:choose>
                                  <xsl:when test ="substring($InputValeur,5,1) = '0'">
                                    <xsl:choose>
                                      <xsl:when test ="substring($InputValeur,6,1) = '0'">
                                        <xsl:choose>
                                          <xsl:when test ="substring($InputValeur,7,1) = '0'">
                                            <xsl:choose>
                                              <xsl:when test ="substring($InputValeur,8,1) = '0'">
                                                <xsl:choose>
                                                  <xsl:when test ="substring($InputValeur,9,1) = '0'">
                                                    <xsl:choose>
                                                      <xsl:when test ="substring($InputValeur,10,1) = '0'">
                                                        <xsl:choose>
                                                          <xsl:when test ="substring($InputValeur,11,1) = '0'">
                                                            <xsl:choose>
                                                              <xsl:when test ="substring($InputValeur,12,1) = '0'">
                                                                <xsl:choose>
                                                                  <xsl:when test ="substring($InputValeur,13,1) = '0'">
                                                                    <xsl:value-of select="substring($InputValeur,14,1)"/>
                                                                  </xsl:when>
                                                                  <xsl:otherwise>
                                                                    <xsl:value-of select="substring($InputValeur,13,2)"/>
                                                                  </xsl:otherwise>
                                                                </xsl:choose>
                                                              </xsl:when>
                                                              <xsl:otherwise>
                                                                <xsl:value-of select="substring($InputValeur,12,3)"/>
                                                              </xsl:otherwise>
                                                            </xsl:choose>
                                                          </xsl:when>
                                                          <xsl:otherwise>
                                                            <xsl:value-of select="substring($InputValeur,11,4)"/>
                                                          </xsl:otherwise>
                                                        </xsl:choose>
                                                      </xsl:when>
                                                      <xsl:otherwise>
                                                        <xsl:value-of select="substring($InputValeur,10,5)"/>
                                                      </xsl:otherwise>
                                                    </xsl:choose>
                                                  </xsl:when>
                                                  <xsl:otherwise>
                                                    <xsl:value-of select="substring($InputValeur,9,6)"/>
                                                  </xsl:otherwise>
                                                </xsl:choose>
                                              </xsl:when>
                                              <xsl:otherwise>
                                                <xsl:value-of select="substring($InputValeur,8,7)"/>
                                              </xsl:otherwise>
                                            </xsl:choose>
                                          </xsl:when>
                                          <xsl:otherwise>
                                            <xsl:value-of select="substring($InputValeur,7,8)"/>
                                          </xsl:otherwise>
                                        </xsl:choose>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="substring($InputValeur,6,9)"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <xsl:value-of select="substring($InputValeur,5,10)"/>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="substring($InputValeur,4,11)"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="substring($InputValeur,3,12)"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="substring($InputValeur,2,13)"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="$InputValeur"></xsl:value-of>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>
                  
            </xsl:choose>
               
          </xsl:otherwise>
        </xsl:choose>
       
      </xsl:otherwise>
    </xsl:choose>
    
  </xsl:template>

</xsl:stylesheet> 

