<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
					              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
					              xmlns:bdf="http://banque-france.fr/namespace">
	<xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes"/>
  <xsl:param name="root" select="''"/>

  <xsl:template match="IST01|IST02|IST03|IST04|ISEF08|ISEF09|ISEF10|ISEF11|ISEF12|ISEF13|ISEF15|ISEF17|ISEF18|ISEF20|ISEF21|U101" mode="genTable">
	<table class="clWidth635 clBorderCell">
		<tr>
			<td class="clWidth14"></td>
			<td class="clCouleur2 clValignTop">
				<xsl:apply-templates select="."/>
			</td>
		</tr>
		<tr>
			<td class="clWidth14"></td>
			<td><xsl:call-template name="shim"/></td>
		</tr>
	</table>
</xsl:template>

<xsl:template match="AUTRECARACT">
	<xsl:if test="position()=1">
		<a name="autrescarac"></a>
		<table class="clBorderCell clWidth739">
			<tr class="clAlignCenter">
				<td class="clCouleur2">
          AUTRE(S) CARACTRISTIQUE(S)
        </td>
				<td class="clWidth103 clAlignRight">
					<a href="#ancHaut"><img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page" /></a>
				</td>
			</tr>
		</table>
		<xsl:call-template name="shim"/><br/>
		<xsl:text disable-output-escaping="yes">&lt;table width=&quot;635&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot; class=&quot;clTexte&quot;&gt;</xsl:text>
	</xsl:if>
	<tr> 
		<td class="clWidth20 clValignTop clAlignCenter">-</td>
		<xsl:variable name="value" select="."/>
		<td class="clWidth615"><xsl:value-of select="substring($value,3)"/></td>
	</tr>
	<xsl:if test="position()=last()">
		<xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
	</xsl:if>
</xsl:template>

<xsl:template match="BILAN70|BILAN72">
	<xsl:param name="chiffre"/>
	<table class="clWidth635 clBorderCell">
    <caption class="visually-hidden">DONNES GNRALES</caption>    
		<tr> 
			<td class="clHeight10" colspan="4"></td>
		</tr>
		<tr> 
			<td class="clCouleur2 clWidth290 clHeight14">&#160;Exercices clturs en</td>
      <td class="clFond clWidth115 clHeight14 clAlignRight">
        <xsl:call-template name ="displayDateXsl">
          <xsl:with-param name ="InputDate" select ="($chiffre[1]/@DATCLOT)"/>
        </xsl:call-template>&#160;
      </td>
			<td class="clFond clWidth115 clHeight14 clAlignRight">
        <xsl:call-template name ="displayDateXsl">
          <xsl:with-param name ="InputDate" select ="($chiffre[2]/@DATCLOT)"/>
        </xsl:call-template>&#160;
      </td>
			<td class="clFond clWidth115 clHeight14 clAlignRight">
        <xsl:call-template name ="displayDateXsl">
          <xsl:with-param name ="InputDate" select ="($chiffre[3]/@DATCLOT)"/>
        </xsl:call-template>&#160;
      </td>
		</tr>
		<tr> 
			<td class="clCouleur2 clWidth290 clHeight14">&#160;Dure</td>
			<td class="clFond clWidth115 clHeight14 clAlignRight">
        <xsl:call-template name ="displayDateXsl">
          <xsl:with-param name ="InputDate" select ="($chiffre[1]/@DUREEEX)"/>
        </xsl:call-template>&#160;
      </td>
			<td class="clFond clWidth115 clHeight14 clAlignRight">
        <xsl:call-template name ="displayDateXsl">
          <xsl:with-param name ="InputDate" select ="($chiffre[2]/@DUREEEX)"/>
        </xsl:call-template>&#160;
      </td>
			<td class="clFond clWidth115 clHeight14 clAlignRight">
        <xsl:call-template name ="displayDateXsl">
          <xsl:with-param name ="InputDate" select ="($chiffre[3]/@DUREEEX)"/>
        </xsl:call-template>&#160;
      </td>
		</tr>
		<tr> 
			<td class="clWidth635 clHeight10" colspan="4"></td>
		</tr>
		<tr> 
			<td class="clCouleur2 clWidth290 clHeight14">&#160;Chiffres d'affaires HT (<xsl:value-of select="@UNITE"/> <img src="{$root}Images/risque/euro_symb_bleu.gif" width="8" height="9"/>)</td>
			<td class="clFond clWidth115 clHeight14 clAlignRight"><xsl:apply-templates select="$chiffre[1]/BILAN/p2052FL"/>&#160;</td>
			<td class="clFond clWidth115 clHeight14 clAlignRight"><xsl:apply-templates select="$chiffre[2]/BILAN/p2052FL"/>&#160;</td>
			<td class="clFond clWidth115 clHeight14 clAlignRight"><xsl:apply-templates select="$chiffre[3]/BILAN/p2052FL"/>&#160;</td>
		</tr>
		<tr> 
			<td class="clCouleur2 clWidth290 clHeight14">&#160;&#160;&#160;Dt Exportations</td>
			<td class="clFond clWidth115 clHeight14 clAlignRight"><xsl:apply-templates select="$chiffre[1]/BILAN/p2052FK"/>&#160;</td>
			<td class="clFond clWidth115 clHeight14 clAlignRight"><xsl:apply-templates select="$chiffre[2]/BILAN/p2052FK"/>&#160;</td>
			<td class="clFond clWidth115 clHeight14 clAlignRight"><xsl:apply-templates select="$chiffre[3]/BILAN/p2052FK"/>&#160;</td>
		</tr>
		<tr> 
			<td class="clWidth635 clHeight10" colspan="4"></td>
		</tr>
		<tr> 
			<td class="clCouleur2 clWidth290 clHeight14">&#160;Effectifs </td>
			<td class="clFond clWidth115 clHeight14 clAlignRight"><xsl:apply-templates select="$chiffre[1]/BILAN/p2058YP"/>&#160;</td>
			<td class="clFond clWidth115 clHeight14 clAlignRight"><xsl:apply-templates select="$chiffre[2]/BILAN/p2058YP"/>&#160;</td>
			<td class="clFond clWidth115 clHeight14 clAlignRight"><xsl:apply-templates select="$chiffre[3]/BILAN/p2058YP"/>&#160;</td>
		</tr>
      </table>
	<xsl:call-template name="shim"/><br/>
</xsl:template>

<xsl:template name="risque">
	<xsl:param name="chiffre"/>
	<a name="risqidentifie"></a>
	<table class="clWidth635 clBorderCell" role="presentation">
		<tr class="clAlignCenter">
			<td class="clCouleur2">
        LMENT(S) DE RISQUE IDENTIFI
      </td>
		</tr>
	</table>
	<xsl:call-template name="shim"/><br/>
	<xsl:apply-templates select="//PTF|//POINTFAIBLE" mode="genRisque"/>
	<xsl:call-template name="shim"/><br/>
	<a name="risqpotentiel"></a>
	<table class="clWidth635 clBorderCell">
		<tr class="clAlignCenter">
			<td class="clCouleur2">
        LMENT(S) DE RISQUE POTENTIEL
      </td>
		</tr>
	</table>
	<xsl:call-template name="shim"/><br/>
	<xsl:apply-templates select="//PTI|//POINTINTERRO" mode="genRisque"/>
	<xsl:call-template name="shim"/><br/>
	<table class="clWidth635 clBorderCellspacing1">
		<tr> 
			<td class="clItalic2 clWidth635 clHeight2"> 
				<p>&#160;&#160;Le diagnostic tient compte :</p>
			</td>
		</tr>
		<tr> 
			<td class="clItalic2 clWidth635 clHeight2">&#160;&#160;&#160;- des 3 derniers bilans arrts aux :
        <xsl:call-template name ="displayDateXsl">
          <xsl:with-param name ="InputDate" select ="($chiffre[1]/@DATCLOT)"/>
        </xsl:call-template>&#160;
        <xsl:call-template name ="displayDateXsl">
          <xsl:with-param name ="InputDate" select ="($chiffre[2]/@DATCLOT)"/>
        </xsl:call-template> et <xsl:call-template name ="displayDateXsl">
          <xsl:with-param name ="InputDate" select ="($chiffre[3]/@DATCLOT)"/>
        </xsl:call-template>
      </td>
		</tr>
		<tr> 
			<td class="clItalic2 clWidth635 clHeight2">&#160;&#160;&#160;- d'une comparaison au secteur : <xsl:value-of select="//REFSECTEUR/CODNAF"/>&#160;<xsl:if test="//REFSECTEUR/LIBNAF">(<xsl:value-of select="//REFSECTEUR/LIBNAF"/>)</xsl:if></td>
		</tr>
		<tr> 
			<td class="clItalic2 clWidth635 clHeight2">&#160;&#160;&#160;&#160;&#160;(taux de reprsentativit de l'chantillon FIBEN : <xsl:value-of select="//REFSECTEUR/REPRESENTATIVITE"/>%)</td>
		</tr>
		<tr> 
			<td class="clItalic2 clWidth635 clHeight2">&#160;&#160;&#160;- des dernires centralisations de Risques et d'Incidents de paiement sur effets</td>
		</tr>
		<tr> 
			<td class="clItalic2 clWidth635 clHeight2">&#160;</td>
		</tr>
		<tr> 
			<td class="clItalic2 clWidth635 clHeight2">Il ne fait pas l'analyse d'ventuels documents consolids indispensables pour l'apprciation d'un groupe, ni d'autres informations, pris en compte pour l'octroi de la cotation BdF</td>
		</tr>
	</table>
	<xsl:call-template name="shim"/><br/>
</xsl:template>

<xsl:template match="PTF|PTI" mode="genRisque">
	<table class="clWidth635 clBorderCell" role="presentation">
		<tr>
			<td class="clCouleur2">
				<xsl:apply-templates select="."/>
			</td>
		</tr>
	</table>
</xsl:template>

<xsl:template match="POINTFAIBLE" mode="genRisque">
	<xsl:if test="position()=1">
		<xsl:text disable-output-escaping="yes">&lt;table width=&quot;739&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot; class=&quot;clTexte&quot;&gt;</xsl:text>
		<tr> 
			<td class="clCouleur2 clWidth170 clValignTop"><xsl:value-of select="count(../POINTFAIBLE)"/> point(s) faible(s)</td>
			<td class="clWidth20 clAlignCenter clValignTop">-</td>
			<xsl:variable name="value" select="."/>
			<td class="clWidth445"><xsl:value-of select="substring($value,3)"/></td>
			<td class="clWidth103">&#160;</td>
		</tr>
	</xsl:if>
	<xsl:if test="position()!=1">
		<tr> 
			<td class="clWidth170">&#160;</td>
			<td class="clWidth465" colspan="2">&#160;</td>
			<td class="clWidth103">&#160;</td>
		</tr>
		<tr> 
			<td class="clWidth170">&#160;</td>
			<td class="clWidth20 clAlignCenter clValignTop">-</td>
			<xsl:variable name="value" select="."/>
			<td class="clWidth445"><xsl:value-of select="substring($value,3)"/></td>
			<xsl:if test="position() mod 5 = 0">
				<td class="clWidth103 clAlignRight">
					<a href="#ancHaut"><img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page" /></a>
				</td>
			</xsl:if>
			<xsl:if test="position() mod 5 != 0">
				<td class="clWidth103 clAlignRight">
					&#160;
				</td>
			</xsl:if>
		</tr>
	</xsl:if>
	<xsl:if test="position()=last()">
		<xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
	</xsl:if>
</xsl:template>

<xsl:template match="POINTINTERRO" mode="genRisque">
	<xsl:if test="position()=1">
		<xsl:text disable-output-escaping="yes">&lt;table width=&quot;739&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot; class=&quot;clTexte&quot;&gt;</xsl:text>
		<tr> 
			<td class="clCouleur2 clWidth170 clValignTop"><xsl:value-of select="count(../POINTINTERRO)"/> point(s) d'interrogation</td>
			<td class="clWidth20 clAlignCenter clValignTop">-</td>
			<xsl:variable name="value" select="."/>
			<td class="clWidth445"><xsl:value-of select="substring($value,3)"/></td>
			<xsl:if test="(position() + count(//POINTFAIBLE)) mod 5 = 0">
				<td class="clWidth103 clAlignRight">
					<a href="#ancHaut"><img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page" /></a>
				</td>
			</xsl:if>
			<xsl:if test="(position() + count(//POINTFAIBLE)) mod 5 != 0">
				<td class="clWidth103 clAlignRight">
					&#160;
				</td>
			</xsl:if>
		</tr>
	</xsl:if>
	<xsl:if test="position()!=1">
		<tr> 
			<td class="clWidth170">&#160;</td>
			<td class="clWidth465" colspan="2">&#160;</td>
			<td class="clWidth103">&#160;</td>
		</tr>
		<tr> 
			<td class="clWidth170">&#160;</td>
			<td class="clWidth20 clAlignCenter clValignTop">-</td>
			<xsl:variable name="value" select="."/>
			<td class="clWidth445"><xsl:value-of select="substring($value,3)"/></td>
			<xsl:if test="(position() + count(//POINTFAIBLE)) mod 5 = 0">
				<td class="clWidth103 clAlignRight">
					<a href="#ancHaut"><img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page" /></a>
				</td>
			</xsl:if>
			<xsl:if test="(position() + count(//POINTFAIBLE)) mod 5 != 0">
				<td class="clWidth103 clAlignRight">
					&#160;
				</td>
			</xsl:if>
		</tr>
	</xsl:if>
	<xsl:if test="position()=last()">
		<xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
	</xsl:if>
</xsl:template>

</xsl:stylesheet>
