<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:bdf="http://banque-france.fr/namespace">
  <xsl:import href="../../Ressources/XSL/Commun.xsl"/>
  <xsl:import href="../../Ressources/XSL/commun_transfo.xsl"/>
  <xsl:output method="xml" version="1.0" encoding="utf-8" indent="yes"/>
  <xsl:variable name="dictionnaire" select="document('../../Ressources/XML/DicoLibelle.xml')/dictionnaire"/>
  <xsl:variable name="dictionnaireUK" select="document('../../Ressources/XML/DicoLibelleUK.xml')/dictionnaire"/>


  <xsl:template name ="genHeadSAS">
      <head>
        <meta name="generator" content="HTML Tidy, see www.w3.org" />
        <title>fiben - suivis direct</title>
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <!--Ajouts des fichiers .js:-->
        <xsl:call-template name="insertClientScripts" />

        <!--Ajouts des CSS :-->
        <xsl:call-template name="AjoutCssSAS" />


        <!--Ajout des messages d'erreur:-->
        <xsl:call-template name="AjoutDico" >
          <xsl:with-param name="Lang" select="$Lang" />
        </xsl:call-template>
        <script language="javascript">
          var sBDFId = '';
        </script>
      </head>
  </xsl:template>
  
  <xsl:template name ="genHeadSASplus">
  <head>
    <meta name="generator" content="HTML Tidy, see www.w3.org" />
    <title>fiben - suivis direct</title>
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <!-- Ajouts des fichiers .js: -->
    <xsl:call-template name="insertClientScripts" />
    <script language="javascript" charset="iso-8859-1" src="{$root}Ressources/JavaScript/Constantes_SAS.js">
      <xsl:text disable-output-escaping="yes">&#160;</xsl:text>
    </script>

    <!-- Ajouts des CSS : -->
    <xsl:call-template name="AjoutCssSAS" />

    <!-- Ajout des messages d'erreur: -->
    <xsl:call-template name="AjoutDico" >
      <xsl:with-param name="Lang" select="$Lang" />
    </xsl:call-template>
    <script language="javascript">
      var sBDFId = '';
    </script>
  </head>
  </xsl:template>

  <xsl:template name="AjoutDico">
    <xsl:param name="Lang" select="'fr'"/>
    <xsl:if test="($Lang = 'FR') or ($Lang = '')">
      <script language="javascript" type="text/javascript">
        var aErreur = new Array();
        aErreur['U01']="<xsl:value-of select="$dictionnaire/mot[@id='U01']"/>";
        aErreur['U053']="<xsl:value-of select="$dictionnaire/mot[@id='U053']"/>";
        aErreur['SAS1']="<xsl:value-of select="$dictionnaire/mot[@id='SAS1']"/>";
        aErreur['SAS4']="<xsl:value-of select="$dictionnaire/mot[@id='SAS4']"/>";
        aErreur['SAS6']="<xsl:value-of select="$dictionnaire/mot[@id='SAS6']"/>";
        aErreur["SAS8"]="<xsl:value-of select="$dictionnaire/mot[@id='SAS8']"/>";
        aErreur["SAS9"]="<xsl:value-of select="$dictionnaire/mot[@id='SAS9']"/>";
        aErreur["SAS10"]="<xsl:value-of select="$dictionnaire/mot[@id='SAS10']"/>";
        aErreur["SAS11"]="<xsl:value-of select="$dictionnaire/mot[@id='SAS11']"/>";
        aErreur["SAS12"]="<xsl:value-of select="$dictionnaire/mot[@id='SAS12']"/>";
        aErreur["SAS13"]="<xsl:value-of select="$dictionnaire/mot[@id='SAS13']"/>";
        aErreur["SAS14"]="<xsl:value-of select="$dictionnaire/mot[@id='SAS14']"/>";
        aErreur["SAS24"]="<xsl:value-of select="$dictionnaire/mot[@id='SAS24']"/>";
        aErreur["SAS99"]="<xsl:value-of select="$dictionnaire/mot[@id='SAS99']"/>";
      </script>
    </xsl:if>

    <xsl:if test="$Lang = 'UK'" >
      <script language="javascript" type="text/javascript">
        var aErreur = new Array();
        aErreur['U01']="<xsl:value-of select="$dictionnaireUK/mot[@id='U01']"/>";
        aErreur['U053']="<xsl:value-of select="$dictionnaireUK/mot[@id='U053']"/>";
        aErreur['SAS1']="<xsl:value-of select="$dictionnaireUK/mot[@id='SAS1']"/>";
        aErreur['SAS4']="<xsl:value-of select="$dictionnaireUK/mot[@id='SAS4']"/>";
        aErreur['SAS6']="<xsl:value-of select="$dictionnaireUK/mot[@id='SAS6']"/>";
        aErreur['SAS8']="<xsl:value-of select="$dictionnaireUK/mot[@id='SAS8']"/>";
        aErreur["SAS9"]="<xsl:value-of select="$dictionnaireUK/mot[@id='SAS9']"/>";
        aErreur["SAS10"]="<xsl:value-of select="$dictionnaireUK/mot[@id='SAS10']"/>";
        aErreur["SAS11"]="<xsl:value-of select="$dictionnaireUK/mot[@id='SAS11']"/>";
        aErreur["SAS12"]="<xsl:value-of select="$dictionnaireUK/mot[@id='SAS12']"/>";
        aErreur["SAS13"]="<xsl:value-of select="$dictionnaireUK/mot[@id='SAS13']"/>";
        aErreur["SAS14"]="<xsl:value-of select="$dictionnaireUK/mot[@id='SAS14']"/>";
        aErreur["SAS24"]="<xsl:value-of select="$dictionnaireUK/mot[@id='SAS24']"/>";
        aErreur["SAS99"]="<xsl:value-of select="$dictionnaireUK/mot[@id='SAS99']"/>";
      </script>
    </xsl:if>
  </xsl:template>

  <xsl:template name="AjoutCssSAS" >
    <link type="text/css" rel="stylesheet" href="{$root}Ressources/CSS/Commun.css"></link>
    <link type="text/css" rel="stylesheet" href="{$root}Ressources/CSS/saaralph.css"></link>
    <link type="text/css" rel="stylesheet" href="{$root}Ressources/CSS/newhome.css"></link>
    <link type="text/css" rel="stylesheet" href="{$root}Ressources/CSS/risque.css"></link>

  </xsl:template>
  
  
  <!-- Titre + code banque , guichet et nombre alerte -->
  <xsl:template name="BandeauInf">
    <xsl:param name="Titre"/>
    <xsl:param name="root" select="''"/>
    <table class="clWidth635 clBorderCell">
      <caption class="visually-hidden">Mise sous alerte</caption>
      <tr>
        <td class="clTitreBleu cltitre16 clgras clWidth617 clAlignLeft clValignTop">
            <xsl:value-of select="$Titre"/>
          <br/>
        </td>
      </tr>
    </table>
    <table class="clWidth620 clBorderCell">
      <tr>
        <th class="clTitreBleu clFont12 clWidth100 clHeight30 clAlignLeft clThNonGras">Code banque : </th>
        <td id="cBank" class="clGras clTitre2 clWidth60 clHeight30 ">
          <xsl:value-of select="FIBEN/SERVICESAS/CLIENTSAS/CODEBANQUE"/>
        </td>
        &#160;
        <th class="clTitreBleu clFont12 clWidth10 clHeight30 clAlignLeft clThNonGras">Code guichet : </th>
        <td id="cGuichet" class="clGras clTitre2 clWidth60 clHeight30">
          <xsl:value-of select="FIBEN/SERVICESAS/CLIENTSAS/CODEGUICHET"/>
        </td>
      </tr>
    </table>
    <table class="clWidth635 clBorderCell">
      <tr>
        <th class="clTitreBleu clFont12 clWidth200 clHeight30 clValignTop clAlignLeft clThNonGras clBoxSizing">Nombre d'alertes du guichet:</th>
        <td id="cnbAlerte" class="clGras clWidth10 clHeight30 clValignTop clBoxSizing">
          <xsl:number value="FIBEN/SERVICESAS/CLIENTSAS/NBSAS"/>
        </td>
        <th class="clTitreBleu clFont12 clWidth20 clHeight35 clValignTop clAlignLeft clThNonGras clBoxSizing">/500</th>
        <td class="clWidth15">&#160;</td> 
        <td class="clWidth390 clHeight30">
          <div id="erreur" role="alert" class="clErreur clAlignCenter" style="visibility:visible;z-index:1"></div>
        </td>         
      </tr>
    </table>
  </xsl:template>

  <xsl:template name="BandeauInfSuivi">
    <xsl:param name="Titre"/>
    <xsl:param name="root" select="''"/>
    <table class="clWidth635 clBorderCell">
      <caption class="visually-hidden">Gestion des alertes</caption>
      <tr>
        <td class="clTitreBleu cltitre16 clgras clWidth617 clAlignLeft clValignTop">
            <xsl:value-of select="$Titre"/>
          <br/>
        </td>
      </tr>
    </table>
    <table class="clWidth620 clBorderCell">
      <tr>
        <th class="clTitreBleu clFont12 clWidth100 clHeight30 clAlignLeft clThNonGras">Code banque : </th>
        <td id="cBank" class="clGras clTitre2 clWidth60 clHeight30 ">
          <xsl:value-of select="FIBEN/SERVICESAS/CLIENTSAS/CODEBANQUE"/>
        </td>
        &#160;
        <th class="clTitreBleu clFont12 clWidth10 clHeight30 clAlignLeft clThNonGras">Code guichet : </th>
        <td id="cGuichet" class="clGras clTitre2 clWidth60 clHeight30">
          <xsl:value-of select="FIBEN/SERVICESAS/CLIENTSAS/CODEGUICHET"/>
        </td>
      </tr>
    </table>
    <table class="clWidth635 clBorderCell">
      <tr>
        <th class="clTitreBleu clFont12 clWidth260 clHeight30 clValignTop clAlignLeft clThNonGras">Nombre d'entités sous suivis du guichet:</th>
        <td id="cnbAlerte" class="clGras clWidth20 clHeight30 clValignTop clAlignRight">
          <xsl:number value="FIBEN/SERVICESAS/CLIENTSAS/NBSAS"/>
        </td>
        <th class="clTitreBleu clFont12 clWidth20 clHeight30 clValignTop clAlignLeft clThNonGras">/2000</th>
        <td class="clWidth15 clHeight30">&#160;          
        </td>
        <td class="clWidth390 clHeight30">
          <div id="erreur" role="alert" class="clErreur clAlignCenter" style="visibility:visible;z-index:1"></div>
        </td>
      </tr>
    </table>
  </xsl:template>
 
 
  <!-- Récupération des adresses mails: -->
  <xsl:template name="RecupBALS">
    <!-- modèle : <option value="1">adr1</option> -->
    <xsl:for-each select="FIBEN/SERVICESAS/*/BALS/BAL">
      <xsl:element name="option">
        <xsl:attribute name="value">
          <xsl:number value="position()" format="1"/>
        </xsl:attribute>
        <xsl:value-of select="."/>
      </xsl:element>
    </xsl:for-each>
  </xsl:template>

   <!-- affiche page d'erreur: -->
  <xsl:template name="GestionErreurSAS">
    <xsl:param name="root" select="''"/>
    <xsl:param name="familyTitle" select="''"/>    
    <table class="mainmodule horizontal-auto clBorderCell clWidth700">
      <caption class="visually-hidden">Gestion des erreurs des SAS</caption>
      <tr>
       <td class="clWidth20"> &#160;&#160;&#160; </td>
        <td>
          <table class="clWidth778 clBorderCell" role="presentation">
            <tr>
              <td colspan="4">
                <xsl:call-template name="genTitreModuleSAS" >
                  <xsl:with-param name="root" select="$root"/>
                  <xsl:with-param name="Lang" select="$Lang"/>
                  <xsl:with-param name="familyTitle" select="$familyTitle"/>
                 </xsl:call-template>
                <!--07/11/2008 genidentificaiton si ident vide = erreur call move next produite par javascript displayident -->
                <xsl:if test="/FIBEN/ERREUR/IDENT = '' ">
                  <xsl:variable name ="idnonvide" select ="'_'"  />
                  <xsl:call-template name="genIdentificationSAS">
                    <xsl:with-param name="ident" select="$idnonvide"/>
                  </xsl:call-template>
                </xsl:if>
                <xsl:if test="/FIBEN/ERREUR/IDENT != '' " >
                  <xsl:variable name ="idnonvide" select ="/FIBEN/ERREUR/IDENT"  />
                  <xsl:call-template name="genIdentificationSAS">
                    <xsl:with-param name="ident" select="$idnonvide"/>
                  </xsl:call-template>
                </xsl:if>
              </td>
            </tr>
            <tr>
              <td colspan="4">&#160;</td>
            </tr>
            <tr>
              <td colspan="4">
                <xsl:call-template name="shimSAS">
                  <xsl:with-param name="Root" select="$root" />
                </xsl:call-template>
              </td>
            </tr>
            <tr>
              <td colspan="3" class="clCouleur2 clValignTop">
                <xsl:apply-templates select="/FIBEN/ERREUR/MSG/UT|/FIBEN/ERREUR/MSG/UCR/*|/FIBEN/ERREUR/MSG/IET01"/>
              </td>
            </tr>
            <tr>
              <td colspan="4">
                <xsl:call-template name="shimSAS">
                  <xsl:with-param name="Root" select="$root" />
                </xsl:call-template>
              </td>
            </tr>
            <tr class="clHeight50">
              <td class="clWidth78"></td>
            </tr>
          </table>
        </td>
      </tr>
    </table>
  </xsl:template>
  <xsl:template name="genTitreModuleSAS">
    <xsl:param name="root" select="''"/>
    <xsl:param name="familyName" select="''"/>
    <xsl:param name="Lang" select="''"/>
    <xsl:param name="familyTitle" select="''"/>
    <table class="clWidth635 clBorderCell">
      <caption class="visually-hidden">Gestion des titres des SAS</caption>
      <tr>
        <xsl:if test="$NonResident='NR'">
          <td class="clCouleur1 clValignTop clAlignLeft clWidth617">
            <xsl:if test="$Lang='UK'">
              <xsl:value-of select="$familyTitle"/>
              <br />
              <img src="{$root}images/risque/shim_bleu.gif" width="768" height="1" alt=""/>
              <br />
              <xsl:value-of disable-output-escaping="yes" select="document('../../Ressources/XML/DicoLibelleUK.xml')/dictionnaire/titre[@module=$moddem]"/>
            </xsl:if>

            <xsl:if test="$Lang='FR'">
              <xsl:value-of select="$familyTitle"/>
              <br />
              <img src="{$root}images/risque/shim_bleu.gif" width="768" height="1" alt=""/>
              <br />
              <xsl:value-of disable-output-escaping="yes" select="$dictionnaire/titre[@module=$moddem]"/>
            </xsl:if>

            
          </td>
        </xsl:if>
        <xsl:if test="not($NonResident='NR')">
          <td class="clCouleur1 clValignTop clAlignLeft clWidth617">
            <xsl:value-of select="$familyTitle"/>
            <br />
            <img src="{$root}images/risque/shim_bleu.gif" width="768" height="1" alt=""/>
            <br />
            <xsl:value-of disable-output-escaping="yes" select="$dictionnaire/titre[@module=$moddem]"/>          
          </td>
        </xsl:if>

      </tr>
    </table>
    <br/>
  </xsl:template>
  <xsl:template name="shimSAS">
    <xsl:param name="Root" select="''"/>
    <xsl:param name="FamilyName" select="''"/>
    <xsl:element name="img">
      <xsl:attribute name ="alt"></xsl:attribute>
      <xsl:attribute name="width">768</xsl:attribute>
      <xsl:attribute name="height">1</xsl:attribute>
      <xsl:attribute name="vspace">8</xsl:attribute>
      <xsl:attribute name="src">
        <xsl:value-of select="$Root"/>Images/risque/shim_bleu.gif
      </xsl:attribute>
    </xsl:element>
  </xsl:template>
  <xsl:template name="genIdentificationSAS">
    <xsl:param name="ident"/>
    <xsl:param name="nom"/>
    <table class="clWidth768 clHeight1 clEnTeteTable BorderCell1">
      <caption class="visually-hidden">Identification des SAS</caption>
      <tr>
        <td>
          <table class="clWidth766 clHeight1 clBorderCell" role="presentation">
            <tr>
              <xsl:if test="not($NonResident='NR')">
                <td class="clGrasFond clWidth129 clValignMiddle">
                  &#160;<xsl:call-template name ="displayIdent2Xsl">
                    <xsl:with-param name ="InputIdent" select ="($ident)"/>
                  </xsl:call-template>
                </td>
                <td class="clGrasFond clWidth404 clValignMiddle" colspan="2">
                  &#160;<xsl:value-of select="$nom"/>
                </td>
              </xsl:if>
              <xsl:if test="$NonResident='NR'">
                <xsl:if test="$Lang='FR'">
                  <td class="clGrasFond clWidth129 clValignMiddle">
                    &#160;<xsl:call-template name ="displayIdent2Xsl">
                      <xsl:with-param name ="InputIdent" select ="($ident)"/>
                    </xsl:call-template>
                  </td>
                  <td class="clGrasFond clWidth404 clValignMiddle" colspan="2">
                    &#160;<xsl:value-of select="$nom"/>
                  </td>
                </xsl:if>
                <xsl:if test="$Lang='UK'">
                  <td class="clGrasFond clWidth145 clValignMiddle">
                    &#160;<xsl:call-template name ="displayIdent2Xsl">
                      <xsl:with-param name ="InputIdent" select ="($ident)"/>
                    </xsl:call-template>
                  </td>
                  <td class="clGrasFond clValignMiddle" colspan="2">
                    &#160;<xsl:value-of select="$nom"/>
                  </td>
                </xsl:if>
              </xsl:if>           
            </tr>
          </table>
        </td>
      </tr>
    </table>
  </xsl:template>

  <!-- *************************************************************************************************
                            pour afficher la réponse à l'abonnement à un micro module
  ******************************************************************************************************* -->
  <xsl:template name="DisplayMicroModule">
    <html lang="fr" xmlns="http://www.w3.org/1999/xhtml">
      <title>Réponse à l'abonnement à un micro module</title>
      <xsl:call-template name="genHeadSAS">
      </xsl:call-template>
      <body class="clBodybgcolorWhite">
        <xsl:call-template name="genFondMenu">
          <xsl:with-param name="root" select="$root"/>
          <xsl:with-param name="type" select="'suivi'" />
        </xsl:call-template>
        <!-- Affichage des menus: EVOL 2016 -->
        <xsl:copy-of select="$menuHTML1"/>

        <xsl:if test="/FIBEN/ERREUR">
          <xsl:call-template name="GestionErreurSAS" >
            <xsl:with-param name="root" select="$root"/>
            <xsl:with-param name="familyTitle" select="$familyTitle" />
          </xsl:call-template>
        </xsl:if >
        <xsl:if test="not(/FIBEN/ERREUR)">
          <table class="mainmodule horizontal-auto HomeData clBorderCell">
            <caption class="visually-hidden">Réponse à l'abonnement à un micro module</caption>
            <tr>
             <td class="clWidth20"></td>
              <td class="clWidth636" colspan="2">
                <form method="Post" name="frmForm1">
                  <input type="hidden" name="ident" value=""/>
                  <table class="clWidth778 clBorderCell" role="presentation">
                    <tr>
                      <td>
                        <!-- Affichage du bandeau titre: -->
                        <xsl:call-template name="BandeauInfSuivi" >
                          <xsl:with-param name="Titre" select="'Compte-rendu de la mise sous suivi'" />
                          <xsl:with-param name="root" select="$root"/>
                        </xsl:call-template>
                        &#160;
                      </td>
                    </tr>
                  </table>

                  <img src="{$root}images/risque/shim_bleu.gif" width="768" height="1" alt=""/>
                  <br/>
                  <br/>
                  <div  id="Lst_CR_MiseSousSuivi" class="clLst_Alertes" >

                    <!-- ajout de l'ensemble des lignes avec les données-->
                    <xsl:if test ="//SUCCES">
                      <xsl:call-template name ="CreationOK"></xsl:call-template>
                    </xsl:if>
                    <br/>
                    <xsl:if test ="//ECHECS/ECHEC">
                      <xsl:call-template name ="CreationKO"></xsl:call-template>
                    </xsl:if>
                    <br/>
                  </div>

                  <br/>
                  <img src="{$root}images/risque/shim_bleu.gif" width="768" height="1" alt=""/>
                  <br/>

                </form>
              </td>
            </tr>
          </table>
        </xsl:if>

        <xsl:call-template name="genBasPage"/>
      </body>
    </html>
  </xsl:template>


  <xsl:template name="CreationOK">
    <!-- tableau pour MISE SOUS SUIVI OK -->
    <table class="clWidthMax clBorderCell">
      <caption class="visually-hidden">Tableau de mise sous suivi OK</caption>
      <tr>
        <td class="clWidth10">&#160;</td>
        <th class="clGras clWidth748 clAlignLeft" colspan="5">
          Les opérations de création ont été enregistrées :
        </th>
      </tr>
      <tr class="clTitreBleu clFont12 clHeight25">
        <td class="clWidth10">&#160;</td>
        <th class="clWidth153 clAlignLeft clThNonGras"> Identifiants mis sous suivi</th>
        <th class="clWidth82 clAlignCenter clThNonGras"> Date de fin</th>
        <th class="clWidth48 clAlignCenter clThNonGras"> Suivi </th>
        <th class="clWidth275 clAlignCenter clThNonGras"> Référence </th>
        <td class="clWidth210">&#160;</td>
      </tr>
    </table>
    <xsl:for-each select="//SUCCES/SUCCE">
      <table class="clWidthMax clBorderCell" role="presentation">
        <tr class="cltexte">
          <td class="clWidth10">&#160;</td>
          <td class="clWidth153">
            <xsl:value-of select="./IDENTOK"/>
          </td>
          <td class="clWidth82 clAlignCenter">
            <xsl:value-of select="concat(substring(../../DATEFINSUIVI,1,2),'/',substring(../../DATEFINSUIVI,3,4))"/>
          </td>
          <td class="clWidth48 clAlignCenter">
            <xsl:value-of select="../../TYPESUIVI"/>
          </td>
          <td class="clWidth275 clAlignCenter">

            <xsl:value-of select="./REFOK"/>
          </td>
          <td class="clWidth210">
            &#160;
          </td>
        </tr>
      </table>
    </xsl:for-each>

  </xsl:template>



  <xsl:template name="CreationKO">
    <!-- tableau pour OPERATION DE CREATION KO-->
    <table class="clWidthMax clBorderCell">
      <caption class="visually-hidden">Tableau de mise sous suivi KO</caption>
      <tr>
        <td class="clWidth10">&#160;</td>
        <th class="clGras clWidth748 clAlignLeft" colspan="5">
          Les opérations de création n'ont pu être enregistrées :
        </th>
      </tr>
     <tr class="clTitreBleu clFont12 clHeight25">
        <td class="clWidth10">&#160;</td>
        <th class="clWidth153 clAlignLeft clThNonGras "> Identifiants mis sous suivi</th>
        <th class="clWidth82 clAlignCenter clThNonGras"> Date de fin</th>
        <th class="clWidth48 clAlignCenter clThNonGras"> Suivi </th>
        <th class="clWidth275 clAlignCenter clThNonGras"> Référence </th>
        <th class="clWidth210 clAlignLeft clThNonGras"> Motif du rejet</th>
      </tr>
    </table>
    <xsl:for-each select="//ECHECS/ECHEC">
      <table class="clWidthMax clBorderCell">
        <tr class=" cltexte">
          <td class="clWidth10">&#160;</td>
          <td class="cltexte clWidth153 clValignTop">
            <xsl:value-of select="IDENTKO"/>
          </td>
          <xsl:choose>
            <xsl:when test ="substring(../../DATEFINSUIVI,1,6) = '129999'">
              <td class="clWidth82 clAlignCenter clValignTop">
                <xsl:value-of select="'N.P'"/>
              </td>
            </xsl:when>
            <xsl:otherwise>
              <td class="clWidth82 clAlignCenter clValignTop">
                <xsl:value-of select="concat(substring(../../DATEFINSUIVI,1,2),'/',substring(../../DATEFINSUIVI,3,4))"/>
              </td>
            </xsl:otherwise>
          </xsl:choose>
          <td class="clWidth48 clAlignCenter clValignTop">
            <xsl:value-of select="../../TYPESUIVI"/>
          </td>
          <td class="clWidth275 clAlignCenter clValignTop">
            <xsl:value-of select="REFKO"/>
          </td>
          <td class="clWidth210">
            <xsl:call-template name="traduction">
              <xsl:with-param name="code" select="MOTIF"/>
            </xsl:call-template>
          </td>
        </tr>
      </table>
    </xsl:for-each>
  </xsl:template>
  
  
</xsl:stylesheet>
