<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"   xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
					            xmlns:msxsl="urn:schemas-microsoft-com:xslt"
					            xmlns:bdf="http://banque-france.fr/namespace"
				                xmlns:exsl="http://exslt.org/common"
                                extension-element-prefixes="exsl"
>
    <xsl:import href="../../Ressources/XSL/commun_transfo.xsl"/>
    <xsl:import href="../../Ressources/XSL/commun.xsl"/>
	<xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes"/>
    <xsl:param name="root" select="''"/>
    <xsl:param name="module" select="''"/>
    <xsl:param name="refint" select="''"/>
    <xsl:param name="id" select="''"/>
    <xsl:param name="origine" select="''"/>
    <xsl:param name="Lang" select="''"/>
    <xsl:param name="SimpleRalph" select="''"/>
    <xsl:variable name="dicoFR" select="document('../../Ressources/XML/DicoFR.xml')/dicoFR"/>
    <xsl:variable name="dicoUK" select="document('../../Ressources/XML/DicoUK.xml')/dicoUK"/>
    <xsl:variable name="dicoPays" select="document('../../Ressources/XML/DicoPays.xml')/dicoPAYS"/>
    <xsl:variable name="dictionnaire" select="document('../../Ressources/XML/DicoLibelle.xml')/dictionnaire"/>
    <xsl:variable name="dicoPaysUK" select="document('../../Ressources/XML/DicoPaysUK.xml')/dicoPAYS"/>
    <xsl:variable name="dictionnaireUK" select="document('../../Ressources/XML/DicoLibelleUK.xml')/dictionnaire"/>

	<xsl:template name="split">
		<xsl:param name="string"/>
		<xsl:param name="delimiter"/>
		<xsl:choose>
			<xsl:when test="contains($string, $delimiter)">
				<xsl:variable name="before" select="substring-before($string, $delimiter)"/>
				<xsl:variable name="after" select="substring-after($string, $delimiter)"/>
				<token>
					<xsl:value-of select="$before"/>
				</token>
				<xsl:call-template name="split">
					<xsl:with-param name="string" select="$after"/>
					<xsl:with-param name="delimiter" select="$delimiter"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<token>
					<xsl:value-of select="$string"/>
				</token>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
  <xsl:template name="insertClientScripts">
    <script language="javascript" src="{$root}Ressources/JavaScript/Constantes.js">
      <xsl:text disable-output-escaping="yes">&#160;</xsl:text>
    </script>
    <script language="javascript" src="{$root}Ressources/JavaScript/Date.js">
      <xsl:text disable-output-escaping="yes">&#160;</xsl:text>
    </script>
    <script language="javascript" src="{$root}Ressources/JavaScript/String.js">
      <xsl:text disable-output-escaping="yes">&#160;</xsl:text>
    </script>
    <script language="javascript" src="{$root}Ressources/JavaScript/Identifiant.js">
      <xsl:text disable-output-escaping="yes">&#160;</xsl:text>
    </script>
    <script language="javascript" src="{$root}Ressources/JavaScript/Commun.js">
      <xsl:text disable-output-escaping="yes">&#160;</xsl:text>
    </script>
    <script language="javascript" src="{$root}Ressources/JavaScript/Commun_RALPH.js">
      <xsl:text disable-output-escaping="yes">&#160;</xsl:text>
    </script>
    <script language="javascript" charset="iso-8859-1" src="{$root}Ressources/JavaScript/newhome.js">
      <xsl:text disable-output-escaping="yes">&#160;</xsl:text>
    </script>
  </xsl:template>

  <xsl:template name="genEnTeteRalph">
    <xsl:call-template name="genTitreModule" />
  </xsl:template>

	<xsl:template match="IRECH|SCR|IST07|U051|U052|U057|LS01|LS02|LS04|LS03" mode="genLib">
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr class="clAlignLeft">
        <td class="clCouleur2">
          <xsl:apply-templates select="."/>
          <br/>
        </td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template match="LS05" mode="genLib">
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr class="clAlignLeft">
        <td class="clCouleur2">
          <xsl:apply-templates select="."/>
          <a class="clCouleur2" href="mailto:fiben@banque-france.fr">
            <u>fiben@banque-france.fr</u>
          </a>
          <br/>
        </td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template name="genTitreModule">
    <!--<table class="clWidth635" border="1" cellspacing="0" cellpadding="0">-->
    <tr>
      <xsl:if test="not($NonResident = 'NR')">
        <td class="clWidth14"></td>
        <td colspan="4" class="clCouleur1 clWidth739 clValignTop clAlignLeft">
          <xsl:value-of select="$familyTitle"/>
          <br />
          <img src="{$root}Images/risque/shim_bleu.gif" width="635" height="1" alt=""/>
          <br />
          <xsl:value-of disable-output-escaping="yes" select="$dictionnaire/titre[@module=$moddem]"/>
        </td>
      </xsl:if>
    </tr>
    <!--</table>-->
    <br/>
  </xsl:template>
  <xsl:template match="/FIBEN/DEMANDE">
    <link rel="stylesheet" href="{$root}Ressources/CSS/Commun.css" />
    <xsl:variable name="ACTBDF" select="RECHACT"/>
    <xsl:variable name="COPAYS" select="RECHCOPAYS"/>
    <xsl:variable name="from">'</xsl:variable>
    <xsl:variable name="to">&#146;</xsl:variable>
    <xsl:variable name="LibActivite" select="translate($dictionnaire//ssclasse[@id=$ACTBDF],$from,$to)"/>
    <xsl:variable name="LibActiviteUK" select="translate($dictionnaireUK//ssclasse[@id=$ACTBDF],$from,$to)"/>
    <xsl:variable name="LibPays" select="translate($dicoPays/ pays[@id=$COPAYS],$from,$to)"/>
    <xsl:variable name="LibPaysUK" select="translate($dicoPaysUK/ pays[@id=$COPAYS],$from,$to)"/>
	<xsl:call-template name="shim"/>

    <xsl:choose>
      <xsl:when test ="string-length(/FIBEN/DEMANDE/RECHOIXDEN) >= 3">
        <xsl:call-template name="ChoixLibRecherche">
           <xsl:with-param name="motlib" select ="'m07_NoDeSiEn'" />
        </xsl:call-template>
      </xsl:when>
      <xsl:when test ="(/FIBEN/DEMANDE/RECHOIXDEN = 'NS') or (/FIBEN/DEMANDE/RECHOIXDEN = 'SN')">
        <xsl:call-template name="ChoixLibRecherche">
          <xsl:with-param  name="motlib" select="'m07_NoDeNS'"  />
        </xsl:call-template>
      </xsl:when>
      <xsl:when test ="(/FIBEN/DEMANDE/RECHOIXDEN = 'NE') or (/FIBEN/DEMANDE/RECHOIXDEN = 'EN')">
        <xsl:call-template name="ChoixLibRecherche">
          <xsl:with-param  name="motlib" select="'m07_NoDeNE'"  />
        </xsl:call-template>
      </xsl:when>
      <xsl:when test ="(/FIBEN/DEMANDE/RECHOIXDEN = 'SE') or (/FIBEN/DEMANDE/RECHOIXDEN = 'ES')">
        <xsl:call-template name="ChoixLibRecherche">
          <xsl:with-param  name="motlib" select="'m07_NoDeSE'"  />
        </xsl:call-template>
      </xsl:when>
      <xsl:when test ="/FIBEN/DEMANDE/RECHOIXDEN = 'N'">
        <xsl:call-template name="ChoixLibRecherche">
          <xsl:with-param  name="motlib" select="'m07_NoDeN'"  />
        </xsl:call-template>
      </xsl:when>
      <xsl:when test ="/FIBEN/DEMANDE/RECHOIXDEN = 'S'">
        <xsl:call-template name="ChoixLibRecherche">
          <xsl:with-param  name="motlib" select="'m07_NoDeS'"  />
        </xsl:call-template>
      </xsl:when>
      <xsl:when test ="/FIBEN/DEMANDE/RECHOIXDEN = 'E'">
        <xsl:call-template name="ChoixLibRecherche">
          <xsl:with-param  name="motlib" select="'m07_NoDeE'"  />
        </xsl:call-template>
      </xsl:when>
	  <xsl:when test ="/FIBEN/DEMANDE/RECHOIXDEN = 'C'">
		<xsl:call-template name="ChoixLibRecherche">
			<xsl:with-param  name="motlib" select="'m07_CleBdf'"  />
		</xsl:call-template>
	  </xsl:when>
	  <xsl:when test ="/FIBEN/DEMANDE/RECHOIXDEN = 'I'">
		<xsl:call-template name="ChoixLibRecherche">
			<xsl:with-param  name="motlib" select="'m07_Siren'"  />
		</xsl:call-template>
	  </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="ChoixLibRecherche">
          <xsl:with-param name="motlib" select ="'m07_NoDeSiEn'" />
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>

    <table class="clWidth635 clBorderCellspacing3">
      <caption class="visually-hidden">Informations module recherche alphabétique</caption>
      <tr>
        <!-- Non Resident -->
        <xsl:if test ="$NonResident='NR'">
          <!--  NR anglais ou NR Français -->
          <td class="clCouleur2 clWidth110">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m07_SiegeUni'"/>
            </xsl:call-template>
          </td>
          <xsl:if test="/FIBEN/DEMANDE/RECHSIEGE = 'O'">
            <td class="clFond clWidth82">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m07_Oui'"/>
              </xsl:call-template>
            </td>
          </xsl:if>
          <xsl:if test="not(/FIBEN/DEMANDE/RECHSIEGE)">
            <td class="clFond clWidth82">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m07_Non'"/>
              </xsl:call-template>
            </td>
          </xsl:if>
          <td class="clCouleur2 clWidth95">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m07_TypEnt2'"/>
            </xsl:call-template>
          </td>
          <xsl:if test="string-length(RECHTYPE) != 0">
            <xsl:if test ="$Lang='UK'">
              <xsl:if test ="/FIBEN/DEMANDE/RECHTYPE = 'Non ET'">
                <td class="clFond clWidth114">HO+M</td>
              </xsl:if>
              <xsl:if test ="/FIBEN/DEMANDE/RECHTYPE = 'EJ'">
                <td class="clFond clWidth114">HO</td>
              </xsl:if>
              <xsl:if test ="/FIBEN/DEMANDE/RECHTYPE = 'ET'">
                <td class="clFond clWidth114">AG</td>
              </xsl:if>
              <xsl:if test ="/FIBEN/DEMANDE/RECHTYPE = 'PP'">
                <td class="clFond clWidth114">MA</td>
              </xsl:if>
            </xsl:if>
            <xsl:if test ="$Lang='FR'">
              <xsl:if test ="/FIBEN/DEMANDE/RECHTYPE = 'Non ET'">
                <td class="clFond clWidth114">EJ+PP</td>
              </xsl:if>
              <xsl:if test ="/FIBEN/DEMANDE/RECHTYPE != 'Non ET'">
                <td class="clFond clWidth114">
                  <xsl:value-of select="/FIBEN/DEMANDE/RECHTYPE"/>
                </td>
              </xsl:if>
            </xsl:if>
          </xsl:if>
          <xsl:if test="string-length(RECHTYPE) = 0">
            <td class="clFond clWidth114">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m07_Tous'"/>
              </xsl:call-template>
            </td>
          </xsl:if>
          <td class="clCouleur2 clWidth125">
            &#160;<xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m07_RechEten'"/>
            </xsl:call-template>
          </td>
          <xsl:if test="/FIBEN/DEMANDE/RECHETEND = 'O'">
            <td class="clFond clWidth82">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m07_Oui'"/>
              </xsl:call-template>
            </td>
          </xsl:if>
          <xsl:if test="not(/FIBEN/DEMANDE/RECHETEND)">
            <td class="clFond clWidth82">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m07_Non'"/>
              </xsl:call-template>
            </td>
          </xsl:if>
        </xsl:if>

        <!-- Resident -->
        <xsl:if test="not($NonResident='NR')">
          <td class="clCouleur2 clWidth110">Siège uniquement</td>
          <xsl:if test="/FIBEN/DEMANDE/RECHSIEGE = 'O'">
            <td class="clFond clWidth82">Oui</td>
          </xsl:if>
          <xsl:if test="not(/FIBEN/DEMANDE/RECHSIEGE)">
            <td class="clFond clWidth82">Non</td>
          </xsl:if>
          <td class="clCouleur2 clWidth95">&#160;Type d'entité</td>
          <xsl:if test="string-length(RECHTYPE) != 0">
            <xsl:if test ="/FIBEN/DEMANDE/RECHTYPE = 'Non ET'">
              <td class="clFond clWidth114">EJ+PP</td>
            </xsl:if>
            <xsl:if test ="/FIBEN/DEMANDE/RECHTYPE != 'Non ET'">
              <td class="clFond clWidth114">
                <xsl:value-of select="/FIBEN/DEMANDE/RECHTYPE"/>
              </td>
            </xsl:if>
          </xsl:if>
          <xsl:if test="string-length(RECHTYPE) = 0">
            <td class="clFond clWidth114">Tous</td>
          </xsl:if>

          <td class="clCouleur2 clWidth125">&#160;Recherche étendue</td>
          <xsl:if test="/FIBEN/DEMANDE/RECHETEND = 'O'">
            <td class="clFond clWidth82">Oui</td>
          </xsl:if>
          <xsl:if test="not(/FIBEN/DEMANDE/RECHETEND)">
            <td class="clFond clWidth82">Non</td>
          </xsl:if>
        </xsl:if>
      </tr>
    </table>

    <xsl:if test="RECHADR|RECHCOPOST|RECHVILLE">
      <table class="clWidth635 clBorderCellspacing3">
        <caption class="visually-hidden">informations module recherche alphabétique</caption>
        <tr>
          <!-- Non Resident -->
          <xsl:if test ="$NonResident='NR'">
            <!--  NR anglais ou NR Français -->
            <td class="clCouleur2 clWidth110">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m07_Loca'"/>
              </xsl:call-template>
            </td>
          </xsl:if>
          <!-- Resident -->
          <xsl:if test="not($NonResident='NR')">
            <td class="clCouleur2 clWidth110">Localisation</td>
          </xsl:if>
          <td class="clFond clWidth298" colspan="3">
            <xsl:value-of select="RECHADR"/>
          </td>
          <td class="clFond clWidth45">
            <xsl:value-of select="RECHCOPOST"/>
          </td>
          <td class="clFond clWidth165">
            <xsl:value-of select="RECHVILLE"/>
          </td>
        </tr>
      </table>
    </xsl:if>

	  
    <xsl:if test="RECHCOPAYS">
		
		<!-- On a un cas particulier maintenant de plusieurs pays : donc on cherche au plus simple si on a différent cas: -->
		<!-- * France DROM COM -->
		<!-- * Pays étranger spécifique -->
		<!-- * France DROM COM + Pays étranger spécifique -->
		<!-- * Tous les pays -->
		<xsl:variable name="codeFrance">FR</xsl:variable>
		<xsl:variable name="codeEtranger">DE, AD,</xsl:variable>

        <!-- La seule methode utilisée sera commaCount -->
		<xsl:variable name="originalLength" select="string-length($COPAYS)" />
		<xsl:variable name="withoutCommas" select="translate($COPAYS, ',', '')" />
		<xsl:variable name="newLength" select="string-length($withoutCommas)" />
		<xsl:variable name="commaCount" select="$originalLength - $newLength" />
		<xsl:variable name="dicoPaysSet" select="exsl:node-set($dicoPays)"/>

		<xsl:variable name="tokens">
			<xsl:call-template name="split">
				<xsl:with-param name="string" select="$COPAYS"/>
				<xsl:with-param name="delimiter" select="','"/>
			</xsl:call-template>
		</xsl:variable>

		<table class="clWidth635 clBorderCellspacing3">
          <caption class="visually-hidden">informations module recherche alphabétique - recherche pays</caption>
          <tr>
		    <!-- Affichage des Pays -->
		    <td class="clCouleur2 clWidth110">
			    <xsl:call-template name="tradlib">
				    <xsl:with-param name="Lang" select="$Lang"/>
				    <xsl:with-param name="codeLib" select="'m07_Pays'"/>
			    </xsl:call-template>
		    </td>
		    <td colspan="5" class="clFond">
			    <xsl:choose>
					<!-- Aucunes virgule, on a donc qu'un seul pays étranger -->
					<xsl:when test="$commaCount = 0">
						<xsl:if test ="$Lang='FR'">
							<xsl:value-of select="$LibPays"/>
						</xsl:if>
						<xsl:if test ="$Lang='UK'">
							<xsl:value-of select="$LibPaysUK"/>
						</xsl:if>
					</xsl:when>
				    <!-- Pour l'instant il y a 12 pays DROM-COM. Donc Si on a > 13, on a forcément tous les pays (France + Tout Etranger)-->
				    <xsl:when test="$commaCount &gt; 13 and contains($COPAYS, $codeFrance)">
					    <xsl:call-template name="tradlib">
						    <xsl:with-param name="Lang" select="$Lang"/>
						    <xsl:with-param name="codeLib" select="'m07_Tous'"/>
					    </xsl:call-template>
				    </xsl:when>
				    <!-- Sinon on a France + un pays, ou tous les pays etrangers -->
				    <xsl:otherwise>
					    <!-- On affiche d'abord si la france existe-->
					    <xsl:if test="contains($COPAYS, $codeFrance)">
						    <xsl:call-template name="tradlib">
							    <xsl:with-param name="Lang" select="$Lang"/>
							    <xsl:with-param name="codeLib" select="'m07_FranceDromCom'"/>
						    </xsl:call-template>
					    </xsl:if>
					    <xsl:if test="contains($COPAYS, $codeFrance) and $commaCount = 13">
						    <!-- On a France + quelque chose -->
						    <xsl:text>, </xsl:text>
					    </xsl:if>
					    <xsl:if test="$commaCount = 13">
						    <!-- On a France + un seul pays-->
						    <!-- Afficher le dernier élément -->
						    <xsl:for-each select="exsl:node-set($tokens)/token">
							    <xsl:if test="position() = last()">
								    <xsl:variable name="code" select="normalize-space(.)"/>
									<xsl:if test ="$Lang='FR'">
								        <xsl:value-of select="$dicoPays/pays[@id = $code]"/>
									</xsl:if>
									<xsl:if test ="$Lang='UK'">
										<xsl:value-of select="$dicoPaysUK/pays[@id = $code]"/>
									</xsl:if>
							    </xsl:if>
						    </xsl:for-each>
					    </xsl:if>
					    <xsl:if test="$commaCount &gt; 13">
						    <!-- On a seulement tous les pays etrangers -->
						    <xsl:call-template name="tradlib">
							    <xsl:with-param name="Lang" select="$Lang"/>
							    <xsl:with-param name="codeLib" select="'m07_PaysHorsFrance'"/>
						    </xsl:call-template>
					    </xsl:if>
				    </xsl:otherwise>
			    </xsl:choose>
		    </td>
		  </tr>
        </table>      
    </xsl:if>      
    <xsl:if test="not(RECHCOPAYS)">
      <xsl:if test="not($SimpleRalph='O')">
        <table class="clWidth635 clBorderCellspacing3">
          <caption class="visually-hidden">informations module recherche alphabétique - recherche pays</caption>
          <tr>
            <!-- Non Resident -->
            <xsl:if test ="$NonResident='NR'">
              <!--  NR anglais ou NR Français -->
              <td class="clCouleur2 clWidth110">
                <xsl:call-template name="tradlib">
                  <xsl:with-param name="Lang" select="$Lang"/>
                  <xsl:with-param name="codeLib" select="'m07_Pays'"/>
                </xsl:call-template>
              </td>
              <td colspan="5" class="clFond">
                <xsl:call-template name="tradlib">
                  <xsl:with-param name="Lang" select="$Lang"/>
                  <xsl:with-param name="codeLib" select="'m07_Tous'"/>
                </xsl:call-template>
              </td>
            </xsl:if>
            <!-- Resident -->
            <xsl:if test="not($NonResident='NR')">
              <td class="clCouleur2 clWidth110">Pays</td>
              <td colspan="5" class="clFond">
                Tous
              </td>
            </xsl:if>
          </tr>
        </table>
      </xsl:if>
    </xsl:if>
    <xsl:if test="RECHACT">
      <table class="clWidth635 clBorderCellspacing3">
        <caption class="visually-hidden">informations module recherche alphabétique - recherche activité</caption>
        <tr>
          <!-- Non Resident -->
          <xsl:if test ="$NonResident='NR'">
            <!--  NR anglais ou NR Français -->
            <td class="clCouleur2 clWidth110">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m07_Actvi'"/>
              </xsl:call-template>
            </td>
            <xsl:if test ="$Lang='UK'">
              <td colspan="5" class="clFond">
                <xsl:value-of select="RECHACT"/>
                <span class="Style3">
                  &#160;
                  <xsl:value-of select="$LibActiviteUK"/>
                </span>
              </td>
            </xsl:if>
            <xsl:if test ="$Lang='FR'">
              <td colspan="5" class="clFond">
                <xsl:value-of select="RECHACT"/>
                <span class="Style3">
                  &#160;
                  <xsl:value-of select="$LibActivite"/>
                </span>
              </td>
            </xsl:if>
          </xsl:if>
          <!-- Resident -->
          <xsl:if test="not($NonResident='NR')">
            <td class="clCouleur2 clWidth110">Activité</td>
            <td colspan="5" class="clFond">
              <xsl:value-of select="RECHACT"/>
              <span class="Style3">
                &#160;
                <xsl:value-of select="$LibActivite"/>
              </span>
            </td>
          </xsl:if>
        </tr>
      </table>
    </xsl:if>
    <!-- Partie non diffuser pour fiben (uniquement en Inet2 -->
    <!--<xsl:if test="RECHUA|RECHETAT">
      <table class="clWidth635 clBorderCellspacing3">
        <tr>
          --><!-- Non Resident --><!--
    <xsl:if test ="$NonResident='NR'">
      --><!-- NR anglais ou NR français--><!--
      <td class="clCouleur2 clWidth110">
        <xsl:call-template name="tradlib">
          <xsl:with-param name="Lang" select="$Lang"/>
          <xsl:with-param name="codeLib" select="'m07_Uag'"/>
        </xsl:call-template>
      </td>
      <td colspan="2" class="clFond">
        <xsl:value-of select="RECHUA"/>
      </td>
      <td class="clCouleur2 clWidth114">
        &#160;<xsl:call-template name="tradlib">
          <xsl:with-param name="Lang" select="$Lang"/>
          <xsl:with-param name="codeLib" select="'m07_EtaEnt'"/>
        </xsl:call-template>
      </td>
      <td class="clFond clWidth125">
        <xsl:if test="RECHETAT = 'TE'">
          &#160;<xsl:call-template name="tradlib">
            <xsl:with-param name="Lang" select="$Lang"/>
            <xsl:with-param name="codeLib" select="'m07_Tous'"/>
          </xsl:call-template>
        </xsl:if>
        <xsl:if test="RECHETAT = 'DI'">
          &#160;<xsl:call-template name="tradlib">
            <xsl:with-param name="Lang" select="$Lang"/>
            <xsl:with-param name="codeLib" select="'m07_Dif'"/>
          </xsl:call-template>
        </xsl:if>
      </td>
      <td class="clCouleur2 clWidth92"></td>
    </xsl:if>
    --><!-- Resident --><!--
    <xsl:if test="not($NonResident='NR')">
      <td class="clCouleur2 clWidth110">Ua gestionnaire</td>
      <td colspan="2" class="clFond">
        <xsl:value-of select="RECHUA"/>
      </td>
      <td class="clCouleur2 clWidth114">&#160;Etat de l'entité</td>
      <td class="clFond clWidth125">
        <xsl:if test="RECHETAT = 'TE'">
          &#160;Tout état
        </xsl:if>
        <xsl:if test="RECHETAT = 'DI'">
          &#160;Diffusibles
        </xsl:if>
      </td>
      <td class="clCouleur2 clWidth92"></td>
    </xsl:if>
    </tr>
    </table>
    </xsl:if>-->
  </xsl:template>
  
  <xsl:template match="/FIBEN/reponses/ReponseFibenDetail">
    <xsl:param name='nbReponsesAffichees'/>
    <xsl:variable name="pays" select="copays"/>
    <xsl:variable name="from">'</xsl:variable>
    <xsl:variable name="to">&#146;</xsl:variable>
    <xsl:variable name="ACTBDF" select="coact"/>
    <xsl:variable name="LibPays" select="translate($dicoPays/pays[@id=$pays],$from,$to)"/>
    <xsl:variable name="LibNAF" select="translate($dictionnaire//ssclasse[@id=$ACTBDF],$from,$to)"/>
    <xsl:variable name="LibPaysUK" select="translate($dicoPaysUK/pays[@id=$pays],$from,$to)"/>
    <xsl:variable name="LibNAFUK" select="translate($dictionnaireUK//ssclasse[@id=$ACTBDF],$from,$to)"/>
   
    <table class="clBorderCell clWidth739">
      <caption class="visually-hidden">informations sur les réponses du module recherche alphabétique</caption>
      <tr>
        <xsl:if test="string-length(ident) &lt; 14">
          <td class="clGrasFond clWidth115 clValignMiddle">
            <xsl:if test="$NonResident='NR'">
              <xsl:if test ="$Lang='UK'">
                <a href="#nullepart" onclick="requestBDFInfos('27|Z1|','','{$familyNumber}','{ident}',cstMultipleConfirmUK)" class="clGrasFond">
                  <u>
                    <xsl:call-template name ="displaySirenXsl">
                      <xsl:with-param name ="InputSiren" select ="ident"/>
                    </xsl:call-template>
                  </u>
                </a>
              </xsl:if>
               <xsl:if test ="$Lang='FR'">
                <a href="#nullepart" onclick="requestBDFInfos('27|Z1|','','{$familyNumber}','{ident}',cstMultipleConfirm)" class="clGrasFond">
                  <u>
                    <xsl:call-template name ="displaySirenXsl">
                      <xsl:with-param name ="InputSiren" select ="ident"/>
                    </xsl:call-template>
                  </u>
                </a>
              </xsl:if>
            </xsl:if>
        <xsl:if test="not($NonResident='NR')">
            <a href="#nullepart" onclick="requestBDFInfos('27|Z1|','','{$familyNumber}','{ident}',cstMultipleConfirm)" class="clGrasFond">
              <u>
                <xsl:call-template name ="displaySirenXsl">
                  <xsl:with-param name ="InputSiren" select ="ident"/>
                </xsl:call-template>
              </u>
            </a>
            </xsl:if>
          </td>
        </xsl:if>
        <xsl:if test="string-length(ident) = 14">
          <td class="clGrasFond clWidth115 clValignMiddle">
            <xsl:if test="$NonResident='NR'">
              <xsl:if test ="$Lang='UK'">
                <a href="#nullepart" onclick="requestBDFInfos('27|Z1|','','{$familyNumber}','{substring(ident,1,9)}',cstMultipleConfirmUK)" class="clGrasFond">
                  <u>
                    <xsl:call-template name ="displaySirenXsl">
                      <xsl:with-param name ="InputSiren" select ="substring(ident,1,9)"/>
                    </xsl:call-template>
                  </u>
                </a>&#160;&#160;<xsl:value-of select="substring(ident,10,14)"/>
              </xsl:if>
               <xsl:if test ="$Lang='FR'">
                <a href="#nullepart" onclick="requestBDFInfos('27|Z1|','','{$familyNumber}','{substring(ident,1,9)}',cstMultipleConfirm)" class="clGrasFond">
                  <u>
                    <xsl:call-template name ="displaySirenXsl">
                      <xsl:with-param name ="InputSiren" select ="substring(ident,1,9)"/>
                    </xsl:call-template>
                  </u>
                </a>&#160;&#160;<xsl:value-of select="substring(ident,10,14)"/>
              </xsl:if>             
            </xsl:if> 
             <xsl:if test="not($NonResident='NR')">
              <a href="#nullepart" onclick="requestBDFInfos('27|Z1|','','{$familyNumber}','{substring(ident,1,9)}',cstMultipleConfirm)" class="clGrasFond">
                <u>
                  <xsl:call-template name ="displaySirenXsl">
                    <xsl:with-param name ="InputSiren" select ="substring(ident,1,9)"/>
                  </xsl:call-template>
                </u>
              </a>&#160;&#160;<xsl:value-of select="substring(ident,10,14)"/>
            </xsl:if> 
          </td>
        </xsl:if>
        <td class="clGrasFond clValignMiddle" colspan="4">
          &#160;<xsl:value-of select="denom"/>
        </td>
        <!-- Non Resident -->
        <xsl:if test ="$NonResident='NR'">
          <xsl:if test ="$Lang='UK'">
            <td class="clFond clWidth115 clAlignRight">
              <a href="#nullePart" onclick="requestInfosLibelle('{$ACTBDF}',cstWordingNew)" class="clTexte">
                <u>
                  <xsl:value-of select="coact"/>
                </u>
              </a>&#160;
            </td>
          </xsl:if>
           <xsl:if test ="$Lang='FR'">
            <td class="clFond clWidth115 clAlignRight">
              <a href="#nullePart" onclick="requestInfosLibelle('{$ACTBDF}',cstWordingNew)" class="clTexte">
                <u>
                  <xsl:value-of select="coact"/>
                </u>
              </a>&#160;
            </td>
          </xsl:if>
          
        </xsl:if>
        <xsl:if test="not($NonResident='NR')">
          <td class="clFond clWidth115 clAlignRight">
            <a href="#nullePart" onclick="requestInfosLibelle('{$ACTBDF}',cstWordingNew)" class="clTexte">
              <u>
                <xsl:value-of select="coact"/>
              </u>
            </a>&#160;
          </td>
        </xsl:if>
        <xsl:if test="position() mod 8 = 0">
          <td class="clWidth103 clAlignRight">
            <a href="#ancHaut">
              <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page" />
            </a>
          </td>
        </xsl:if>
        <xsl:if test="position() mod 8 != 0">
          <td class="clWidth103 clAlignRight">
            &#160;
          </td>
        </xsl:if>        
      </tr>
    </table>
    
    <xsl:if test="string-length(identNat) != 0">
      <table class="clWidth635 clBorderCell" role="presentation">        
        <tr>
           <xsl:if test="string-length(ident) != 13">
             <xsl:if test="string-length(enseigne) != 0 and string-length(sigle) != 0">
               <xsl:if test ="$NonResident='NR'">
                     <td class="clTexte clWidth115">
                        <xsl:call-template name="tradlib">
                          <xsl:with-param name="Lang" select="$Lang"/>
                          <xsl:with-param name="codeLib" select="'m07_SigEns'"/>
                        </xsl:call-template>
                    </td>
              </xsl:if>
              <xsl:if test="not($NonResident='NR')">
                  <td class="clTexte clWidth115">Enseigne/Sigle: </td>
              </xsl:if>
              <td colspan="3" class="clTexte">
                &#160;<xsl:value-of select="enseigne"/>&#160;/&#160;<xsl:value-of select="sigle"/>
              </td>
            </xsl:if>
             <xsl:if test="string-length(enseigne) != 0 and string-length(sigle) = 0">
               <xsl:if test ="$NonResident='NR'">
                     <td class="clTexte clWidth115">
                        <xsl:call-template name="tradlib">
                          <xsl:with-param name="Lang" select="$Lang"/>
                          <xsl:with-param name="codeLib" select="'m07_Ensei'"/>
                        </xsl:call-template>
                    </td>
              </xsl:if>
              <xsl:if test="not($NonResident='NR')">
                  <td class="clTexte clWidth115">Enseigne: </td>
              </xsl:if>
              <td colspan="3" class="clTexte">
                &#160;<xsl:value-of select="enseigne"/>&#160;
              </td>
            </xsl:if>
             <xsl:if test="string-length(enseigne) = 0 and string-length(sigle) != 0">
               <xsl:if test ="$NonResident='NR'">
                     <td class="clTexte clWidth115">
                        <xsl:call-template name="tradlib">
                          <xsl:with-param name="Lang" select="$Lang"/>
                          <xsl:with-param name="codeLib" select="'m07_Sigl'"/>
                        </xsl:call-template>
                    </td>
              </xsl:if>
              <xsl:if test="not($NonResident='NR')">
                  <td class="clTexte clWidth115">Sigle: </td>
              </xsl:if>
              <td colspan="3" class="clTexte">
                &#160;<xsl:value-of select="sigle"/>&#160;
              </td>
            </xsl:if>
          </xsl:if>
          <xsl:if test="string-length(ident) = 13 and string-length(marital) != 0">
            
            <xsl:if test ="$NonResident='NR'">
              <!-- NR anglais ou NR français-->
              <td class="clTexte clWidth115">
                <xsl:call-template name="tradlib">
                  <xsl:with-param name="Lang" select="$Lang"/>
                  <xsl:with-param name="codeLib" select="'m07_NomMar'"/>
                </xsl:call-template>:&#160;
              </td>
            </xsl:if>
            <!-- Resident -->
            <xsl:if test="not($NonResident='NR')">
              <td class="clTexte clWidth115">Nom marital: </td>
            </xsl:if>
            <td colspan="3" class="clTexte">
              &#160;<xsl:value-of select="marital"/>
            </td>
          </xsl:if>

          <xsl:if test="string-length(idLei) != 0 ">
            <xsl:if test="not($NonResident='NR')">
              <td class="clTexte clWidth300">
                Legal Entity Identifier:&#160;<xsl:value-of select="idLei"/>
                <xsl:if test="string-length(idLei) != 0 ">
                  <br />
                  Identifiant National:&#160;&#160;&#160;&#160;&#160;<xsl:value-of select="identNat"/>
                </xsl:if>
              </td>
            </xsl:if>
            <xsl:if test="($NonResident='NR')">
              <td class="clTexte clWidth120">
                Legal Entity Identifier:&#160;<xsl:value-of select="idLei"/>
                <br />
                <xsl:call-template name="tradlib">
                  <xsl:with-param name="Lang" select="$Lang"/>
                  <xsl:with-param name="codeLib" select="'m07_Idnat'"/>
                </xsl:call-template>
                <xsl:value-of select="identNat"/>
              </td>
            </xsl:if>
          </xsl:if>
          <xsl:if test="string-length(idLei) = 0 ">
            <xsl:if test="not($NonResident='NR')">
              <td class="clTexte clWidth300">
                Identifiant National:&#160;&#160;&#160;&#160;&#160;<xsl:value-of select="identNat"/>
              </td>
            </xsl:if>
            <xsl:if test="($NonResident='NR')">
              <td class="clTexte clWidth120">
                <xsl:call-template name="tradlib">
                  <xsl:with-param name="Lang" select="$Lang"/>
                  <xsl:with-param name="codeLib" select="'m07_Idnat'"/>
                </xsl:call-template>
                <xsl:value-of select="identNat"/>
              </td>
            </xsl:if>
          </xsl:if>

    </tr>
    </table>
    </xsl:if>
    <xsl:if test="string-length(identNat) = 0 ">
      <table class="clWidth635 clBorderCell" role="presentation">        
        <tr>
          <xsl:if test="string-length(ident) != 13">
            <xsl:if test="string-length(sigle) !=0 and string-length(enseigne) !=0">
              <!-- Non Resident -->
              <xsl:if test ="$NonResident='NR'">
                <!-- NR anglais ou NR français-->
                <td class="clTexte clWidth115">
                  <xsl:call-template name="tradlib">
                    <xsl:with-param name="Lang" select="$Lang"/>
                    <xsl:with-param name="codeLib" select="'m07_SigEns'"/>
                  </xsl:call-template>
                </td>
              </xsl:if>
              <!-- Resident -->
              <xsl:if test="not($NonResident='NR')">
                <td class="clTexte clWidth115">Enseigne/Sigle: </td>
              </xsl:if>
              <td class="clTexte clAlignLeft" colspan="5">
                &#160;<xsl:value-of select="enseigne"/>&#160;/&#160;<xsl:value-of select="sigle"/>
              </td>
            </xsl:if>
            <xsl:if test="string-length(sigle) = 0 and string-length(enseigne) !=0">
              <!-- Non Resident -->
              <xsl:if test ="$NonResident='NR'">
                <!-- NR anglais ou NR français-->
                <td class="clTexte clWidth115">
                  <xsl:call-template name="tradlib">
                    <xsl:with-param name="Lang" select="$Lang"/>
                    <xsl:with-param name="codeLib" select="'m07_Ensei'"/>
                  </xsl:call-template>
                </td>
              </xsl:if>
              <!-- Resident -->
              <xsl:if test="not($NonResident='NR')">
                <td class="clTexte clWidth115">Enseigne: </td>
              </xsl:if>
              <td class="clTexte clAlignLeft" colspan="5">
                &#160;<xsl:value-of select="enseigne"/>
              </td>
            </xsl:if>
            <xsl:if test="string-length(sigle) !=0 and string-length(enseigne) =0">
              <!-- Non Resident -->
              <xsl:if test ="$NonResident='NR'">
                <!-- NR anglais ou NR français-->
                <td class="clTexte clWidth115">
                  <xsl:call-template name="tradlib">
                    <xsl:with-param name="Lang" select="$Lang"/>
                    <xsl:with-param name="codeLib" select="'m07_Sigl'"/>
                  </xsl:call-template>
                </td>
              </xsl:if>
              <!-- Resident -->
              <xsl:if test="not($NonResident='NR')">
                <td class="clTexte clWidth115">Sigle: </td>
              </xsl:if>
              <td class="clTexte clAlignLeft" colspan="5">
                &#160;<xsl:value-of select="sigle"/>
              </td>
            </xsl:if>
          </xsl:if>
          <xsl:if test="string-length(ident) = 13 and string-length(marital) != 0">
            <!-- Non Resident -->
            <xsl:if test ="$NonResident='NR'">
              <!-- NR anglais ou NR français-->
              <td class="clTexte clWidth115">
                <xsl:call-template name="tradlib">
                  <xsl:with-param name="Lang" select="$Lang"/>
                  <xsl:with-param name="codeLib" select="'m07_NomMar'"/>
                </xsl:call-template>
              </td>
            </xsl:if>
            <!-- Resident -->
            <xsl:if test="not($NonResident='NR')">
              <td class="clTexte clWidth115">Nom marital: </td>
            </xsl:if>
            <td class="clTexte clAlignLeft" colspan="5">
              &#160;<xsl:value-of select="marital"/>
            </td>
          </xsl:if>
          <xsl:if test="string-length(idLei) != 0 ">
            <xsl:if test="not($NonResident='NR')">
              <td class="clTexte clWidth300">
                Legal Entity Identifier:&#160;<xsl:value-of select="idLei"/>
              </td>
            </xsl:if>
            <xsl:if test="($NonResident='NR')">
              <td class="clTexte clWidth300">
                Legal Entity Identifier:&#160;<xsl:value-of select="idLei"/>
              </td>
            </xsl:if>
          </xsl:if>
        </tr>
      </table>
    </xsl:if>
    <table class="clWidth635 clBorderCell" role="presentation">      
      <tr>
        <xsl:if test="copays != 'FR'">
          <xsl:if test=" string-length(ville) != 0">
            <!-- NR anglais -->
            <xsl:if test ="$NonResident='NR'">
              <xsl:if test ="$Lang='UK'">
                <td colspan="6" class="clTexte">
                  <xsl:value-of select="ville"/><!--&#160;&#160;<xsl:value-of select="$LibPaysUK"/>-->
                </td>
              </xsl:if>
              <xsl:if test ="$Lang='FR'">
                <td colspan="6" class="clTexte">
                  <xsl:value-of select="ville"/><!--&#160;&#160;<xsl:value-of select="$LibPaysUK"/>-->
                </td>
              </xsl:if>
            </xsl:if>
            <!-- Resident -->
            <xsl:if test="not($NonResident='NR')">
              <td colspan="6" class="clTexte">
                <xsl:value-of select="ville"/><!--&#160;&#160;<xsl:value-of select="$LibPays"/>-->
              </td>
            </xsl:if>
          </xsl:if>
          <xsl:if test=" string-length(ville) = 0">
            <!-- NR anglais -->
            <xsl:if test ="$NonResident='NR'">
              <xsl:if test ="$Lang='FR'">
                <td colspan="6" class="clTexte">
                  <xsl:value-of select="$LibPays"/>
                </td>
              </xsl:if> 
              <xsl:if test ="$Lang='UK'">
                <td colspan="6" class="clTexte">
                  <xsl:value-of select="$LibPaysUK"/>
                </td>
              </xsl:if> 
            </xsl:if>
            <!-- Resident -->
            <xsl:if test="not($NonResident='NR')">
              <td colspan="6" class="clTexte">
                <xsl:value-of select="$LibPays"/>
              </td>
            </xsl:if>
          </xsl:if>
        </xsl:if>
        <xsl:if test="copays = 'FR'">
          <td colspan="6" class="clTexte">
            <xsl:value-of select="copost"/>&#160;&#160;<xsl:value-of select="ville"/>
          </td>
        </xsl:if>
      </tr>
      <tr>
        <td colspan="6" class="clTexte">
          <xsl:value-of select="adresse"/>
        </td>
      </tr>
      <tr>
        <td class="clWidth635 clHeight10" colspan="6"></td>
      </tr>
    </table>
  </xsl:template>
  
  <!-- fin premiere partie du bandeau reprenant les paramètres de la demande-->
  
  
  <xsl:template name ="ChoixLibRecherche" >
    <xsl:param name="motlib" />   
    
    <table class="clWidth635 clBorderCellspacing3" role="presentation">
      <tr>
        <!-- Non Resident-->
        <xsl:if test ="$NonResident='NR'">
          <!--  NR anglais-->
          <xsl:if test ="$Lang='UK'">
            <xsl:choose>
              <xsl:when test="($motlib = 'M07_NoDeSiEn')">
                <td class="clCouleur2 clWidth260" colspan="0">
                  <xsl:call-template name="tradlib">
                    <xsl:with-param name="Lang" select="$Lang"/>
                    <xsl:with-param name="codeLib" select="$motlib"/>
                  </xsl:call-template>
                </td>
                <td class="clFond clWidth380" colspan="4">
                  <xsl:value-of select="/FIBEN/DEMANDE/RECHDEN"/>
                </td>
              </xsl:when>
              <xsl:otherwise>
                <td class="clCouleur2 clWidth50" colspan="0">
                  <xsl:call-template name="tradlib">
                    <xsl:with-param name="Lang" select="$Lang"/>
                    <xsl:with-param name="codeLib" select="$motlib"/>
                  </xsl:call-template>
                </td>
                <td class="clFond clWidth380" colspan="4">
                  <xsl:value-of select="/FIBEN/DEMANDE/RECHDEN"/>
                </td>
              </xsl:otherwise>               
            </xsl:choose>             
          </xsl:if>
          <!--  NR français -->
          <xsl:if test ="$Lang='FR'">
            <xsl:choose>
              <xsl:when test="($motlib = 'm07_NoDeSiEn')">
                <td class="clCouleur2 clWidth220" colspan="0">
                  <xsl:call-template name="tradlib">
                    <xsl:with-param name="Lang" select="$Lang"/>
                    <xsl:with-param name="codeLib" select="$motlib"/>
                  </xsl:call-template>
                </td>
                <td class="clFond clWidth380" colspan="4">
                  <xsl:value-of select="/FIBEN/DEMANDE/RECHDEN"/>
                </td>
              </xsl:when>
              <xsl:otherwise>
                <td class="clCouleur2 clWidth50" colspan="0">
                  <xsl:call-template name="tradlib">
                    <xsl:with-param name="Lang" select="$Lang"/>
                    <xsl:with-param name="codeLib" select="$motlib"/>
                  </xsl:call-template>
                </td>
                <td class="clFond clWidth380" colspan="4">
                  <xsl:value-of select="/FIBEN/DEMANDE/RECHDEN"/>
                </td>
              </xsl:otherwise> 
            </xsl:choose>           
          </xsl:if>
        </xsl:if>
        <!-- Resident -->
        <xsl:if test="not($NonResident='NR')">
          <xsl:choose>
            <xsl:when test="($motlib = 'm07_NoDeSiEn')">
              <td class="clCouleur2 clWidth220" colspan="0">
                <xsl:call-template name="tradlib">
                  <xsl:with-param name="codeLib" select="$motlib"/>
                </xsl:call-template>
              </td>
              <td class="clFond clWidth380" colspan="4">
                <xsl:value-of select="/FIBEN/DEMANDE/RECHDEN"/>
              </td>
            </xsl:when>
            <xsl:otherwise>
              <td class="clCouleur2 clWidth50" colspan="0">
                <xsl:call-template name="tradlib">
                  <xsl:with-param name="codeLib" select="$motlib"/>
                </xsl:call-template>
              </td>
              <td class="clFond clWidth380" colspan="4">
                <xsl:value-of select="/FIBEN/DEMANDE/RECHDEN"/>
              </td>
            </xsl:otherwise> 
          </xsl:choose>
        </xsl:if>
      </tr>
    </table>
  </xsl:template>
</xsl:stylesheet>
