<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
					              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
					              xmlns:bdf="http://banque-france.fr/namespace">
	<xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes"/>

<xsl:template match="DENOM" mode="display3lignes">
	<div class="clTexteGras_imp" title="{.}">
		<xsl:value-of select="substring(.,1,15)"/><br />
		<xsl:value-of select="substring(.,16,15)"/><br />
		<xsl:value-of select="substring(.,31,15)"/>
		<xsl:if test="substring(.,31,15)=''">
			<br />
		</xsl:if>
	</div>
</xsl:template>

<xsl:template match="PP" mode="display2lignes">
  <xsl:variable name="nom_prenom">
    <xsl:call-template name ="displayInLowerCaseXsl">
      <xsl:with-param name ="InputStringNom" select ="(IDENTITE/NOM)"/>
      <xsl:with-param name ="InputStringPrenom" select ="(IDENTITE/PRENOM)"/>
    </xsl:call-template>    
  </xsl:variable>
	<div class="clTexteGras_imp">
		<xsl:value-of select="substring($nom_prenom,1,15)"/><br />
		<xsl:value-of select="substring($nom_prenom,16,15)"/>
		<xsl:if test="substring($nom_prenom,16,15)=''">
			<br />
		</xsl:if>
		<xsl:if test="IDENTITE/NOMCONJ">
			<div class="clOrgTexte2_imp">
				Nom marital <xsl:value-of select="substring(IDENTITE/NOMCONJ,1,5)"/>
			</div>
		</xsl:if>
		<xsl:if test="not(IDENTITE/NOMCONJ)">
			<br />&#160;
		</xsl:if>
	</div>
</xsl:template>

</xsl:stylesheet>
