<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
					              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
					              xmlns:bdf="http://banque-france.fr/namespace">
	<xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes"/>

  <xsl:param name="root" select="''"/>
  
<xsl:template match="DENOM" mode="display3lignes">
	<div class="clOrgTexteGrasBox">
		<xsl:value-of select="substring(.,1,16)"/><br />
		<xsl:value-of select="substring(.,17,16)"/><br />
		<xsl:value-of select="substring(.,33,14)"/>
		<xsl:if test="substring(.,33,14)=''">
			<br />
		</xsl:if>
		<xsl:if test="substring(.,47)!=''">
			<img src="{$root}Images/Commun/org_denom.gif" width="20" height="10" hspace="0" border="0" title="{.}" alt="{.}" />
		</xsl:if>
	</div>
</xsl:template>
  <xsl:template match="DENOM" mode="displayInlineBlock">
    <div class="clTexteGras">
      <xsl:value-of select="substring(.,1,47)"/>
      <xsl:if test="substring(.,47)!=''">
        <img src="{$root}Images/Commun/org_denom.gif" width="20" height="10" hspace="0" border="0" title="{.}" alt="{.}" />
      </xsl:if>
    </div>
  </xsl:template>
  
<!-- 2018 - nouvelle version afficher denom tronque -->
  <xsl:template name="displayDenomTronquee">
    <xsl:param name='Denom'/>
    <xsl:value-of select="substring($Denom,1,41)"/>
    <xsl:if test ="substring($Denom,42,3)!=''">
      <span class="infobulle" aria-label="{$Denom}">...</span>
    </xsl:if>
  </xsl:template>
  
   <xsl:template name="displayDenomTronqueeV2">
    <xsl:param name='Denom'/>
    <xsl:value-of select="substring($Denom,1,25)"/>
    <xsl:if test ="substring($Denom,26,3)!=''">
      <span class="infobulle" aria-label="{$Denom}">...</span>
    </xsl:if>
  </xsl:template>
  
    
<xsl:template match="PP" mode="display2lignes">
  <xsl:variable name="nom_prenom">
    <xsl:call-template name ="displayInLowerCaseXsl">
      <xsl:with-param name ="InputStringNom" select ="(IDENTITE/NOM)"/>
      <xsl:with-param name ="InputStringPrenom" select ="(IDENTITE/PRENOM)"/>
    </xsl:call-template>    
  </xsl:variable>
	<p class="tailleDenom clTexteGras margin3" >
		<xsl:value-of select="substring($nom_prenom,1,31)"/>
		<xsl:if test="substring($nom_prenom,32,3)!=''">
      <span class="infobulle" aria-label="{$nom_prenom}">...</span>
		</xsl:if>
		<xsl:if test="IDENTITE/NOMCONJ">
			<br />
				Nom marital <xsl:value-of select="substring(IDENTITE/NOMCONJ,1,10)"/>
				<xsl:if test="substring(IDENTITE/NOMCONJ,11,3)!=''">
          <span class="infobulle" aria-label="{IDENTITE/NOMCONJ}">...</span>
				</xsl:if>
		</xsl:if>
	</p>
</xsl:template>

  <xsl:template name="displayLienCliquable">
    <xsl:param name='ident'/>
    <xsl:param name='lstModules'/>
    <a href="#nullepart" onclick="requestBDFInfos('{$lstModules}','','{$familyNumber}','{.}',cstMultipleConfirm)" class="clOrgBoldlien">
      <xsl:call-template name ="displaySirenXsl">
        <xsl:with-param name ="InputSiren" select ="$ident"/>
      </xsl:call-template>
    </a>
  </xsl:template> 
  
</xsl:stylesheet>
