<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:bdf="http://banque-france.fr/namespace">
	<xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes"/>
  <xsl:param name="root" select="''"/>
  
<xsl:template match="AFFECTATION">
	<table class="clWidth635 clBorderCell" role="presentation">
		<tr class="clAlignCenter">
			<td class="clCouleur2">AFFECTATION DU RSULTAT DU DERNIER EXERCICE<br /></td>
		</tr>
	</table>
	<xsl:call-template name="shim"/><br/>	
	<table class="clWidth635 clBorderCell">
    <caption class="visually-hidden">AFFECTATION DU RSULTAT DU DERNIER EXERCICE</caption>
		<tr> 
			<th class="clCouleur2 clWidth200 clHeight15 clAlignLeft clThNonGras">&#160;Rsultat de l'exercice</th>
			<xsl:apply-templates select="p0DA"/>
			<td class="clCouleur2 clWidth85">&#160;</td>
			<th class="clCouleur2 clWidth200 clHeight15 clAlignLeft clThNonGras">&#160;Distribution de dividendes</th>
			<xsl:apply-templates select="pK00036"/>
		</tr>
		<tr> 
			<th class="clCouleur2 clWidth200 clHeight15 clAlignLeft clThNonGras">&#160;Report  nouveau antrieur</th>
			<xsl:apply-templates select="p0CA"/>
			<th class="clCouleur2 clWidth85 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;rparti en&#160;</th>
			<th class="clCouleur2 clWidth200 clHeight15 clAlignLeft clThNonGras">&#160;Report  nouveau</th>
			<xsl:apply-templates select="pZGA"/>
		</tr>
		<tr> 
			<th class="clCouleur2 clWidth200 clHeight15 clAlignLeft clThNonGras">&#160;Prlv. antrieurs sur rserves</th>
			<xsl:apply-templates select="p0EA"/>
			<td class="clCouleur2 clWidth85">&#160;</td>
			<th class="clCouleur2 clWidth200 clHeight15 clAlignLeft clThNonGras">&#160;Prlv. antrieurs sur rserves</th>
			<xsl:apply-templates select="pK00362"/>
		</tr>
		<tr> 
			<th class="clCouleur2 clWidth200 clHeight15 clAlignLeft clThNonGras">&#160;Total affectation par anticipation</th>
			<xsl:apply-templates select="pK00858"/>
			<td class="clWidth85 clCouleur2" colspan="4">&#160;</td>
		</tr>
	</table>
	<xsl:call-template name="shim"/><br/>
</xsl:template>
  
<xsl:template match="p0DA|p0CA|p0EA|pK00036|pZGA|pK00362">
	<td class="clFond clWidth75 clAlignRight">
		<xsl:if test="@ETAT">
			<xsl:value-of select="@ETAT"/>
		</xsl:if>
		<xsl:if test="not(@ETAT)">
      <xsl:call-template name ="displayNumberXsl">
        <xsl:with-param name ="InputStringNumber" select ="(.)"/>
      </xsl:call-template>
		</xsl:if>
	</td>
	<td class="clFond clWidth1">&#160;</td>
</xsl:template>

<xsl:template match="pK00858">
	<td class="clGrasFond clWidth75 clAlignRight">
		<xsl:if test="@ETAT">
			<xsl:value-of select="@ETAT"/>
		</xsl:if>
		<xsl:if test="not(@ETAT)">
      <xsl:call-template name ="displayNumberXsl">
        <xsl:with-param name ="InputStringNumber" select ="(.)"/>
      </xsl:call-template>
		</xsl:if>
	</td>
	<td class="clGrasFond clWidth1">&#160;</td>
</xsl:template>

<xsl:template match="STECONSO" mode="genLib">
	<xsl:param name="goIdent" select="''"/>
	<table class="clWidth635 clBorderCell" role="presentation">
		<tr>
			<td class="clCouleur2" colspan="2">&#160;<xsl:apply-templates select="."/>
			</td>
		</tr>
		<tr>
			<td class="clWidth130"/>
			 <td class="clWidth505 clAlignRight">
				<a href="#nullepart" onClick="requestBDFInfos('27|30|66|67|','','{$familyNumber}','{$goIdent}',cstMultipleConfirm);">
				<img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
				</a>
			</td>
		</tr>
	</table>
	<xsl:call-template name="shim"/>
	<br/>
</xsl:template>
	
<xsl:template match="EJ">
	<xsl:if test="position()=1">
		<table class="clWidth635 clBorderCell" role="presentation">
			<tr class="clAlignCenter">
				<td class="clCouleurGras">SOCIT(S) CONSOLIDANT L'ENTREPRISE<br/>
				</td>
			</tr>
		</table>
		<xsl:call-template name="shim"/>
		<br/>
	</xsl:if>
  <table class="clWidth635 clBorderCell">
    <tr>
		<td class="clFond clWidth130 clHeight14">&#160;<xsl:call-template name ="displaySirenXsl">
      <xsl:with-param name ="InputSiren" select ="(IDENTS)"/>
    </xsl:call-template>
  </td>
		<td class="clFond clWidth425 clHeight14">&#160;<xsl:value-of select="DENOM"/>
		</td>
      <td class="clFond clWidth80 clAlignRight">
        au <xsl:call-template name ="displayDateXsl">
          <xsl:with-param name ="InputDate" select ="(@DATPERI)"/>
        </xsl:call-template>
      </td>
	</tr>
	<tr>
		<td class="clWidth130"/>
		<td class="clWidth425"/>
		<td class="clWidth80 clAlignRight">
			<a href="#nullepart" onClick="requestBDFInfos('27|30|66|67|','','{$familyNumber}','{IDENTS}',cstMultipleConfirm);">
			<img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
			</a>
		</td>
	</tr>
  </table>
  <xsl:if test="position()=last()">
    <xsl:call-template name="shim"/>
    <br/>
  </xsl:if>
</xsl:template>
</xsl:stylesheet>
