<?xml version="1.0" encoding="iso-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
					              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
					              xmlns:bdf="http://banque-france.fr/namespace">
  <xsl:import href="../../Ressources/XSL/commun_transfo.xsl"/>
  <xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes" />
  <xsl:param name="moddem" select="/FIBEN/@MODDEM"/>
  <xsl:variable name="dictionnaire" select="document('../../Ressources/XML/DicoLibelle.xml')/dictionnaire"/>
  <xsl:variable name="dictionnaireUK" select="document('../../Ressources/XML/DicoLibelleUK.xml')/dictionnaire"/>
  <xsl:variable name="dicoFR" select="document('../../Ressources/XML/DicoFR.xml')/dicoFR"/>
  <xsl:variable name="dicoUK" select="document('../../Ressources/XML/DicoUK.xml')/dicoUK"/>
  <xsl:variable name="Lang" select="''"/>
  <xsl:variable name="codeLib" select="''"/>
  <xsl:variable name="NonResident" select="''"/>

  <xsl:template match="node()[@ISCODE='1']">
    <xsl:variable name="attribute" select="name(.)"/>
    <xsl:if test="$Lang = 'FR'">
      <xsl:value-of select="$dictionnaire/mot[@id=$attribute]"/>
      <xsl:apply-templates select="." mode="displayAfterLibelle"/>
    </xsl:if>
    <xsl:if test="$Lang = ''">
      <xsl:value-of select="$dictionnaire/mot[@id=$attribute]"/>
      <xsl:apply-templates select="." mode="displayAfterLibelle"/>
    </xsl:if>
    <xsl:if test="$Lang = 'UK'" >
      <xsl:value-of select="$dictionnaireUK/mot[@id=$attribute]"/>
      <xsl:apply-templates select="." mode="displayAfterLibelle"/>
    </xsl:if>
  </xsl:template>

  <xsl:template match="NBFONCTOT[@ISCODE='1']">
    <xsl:call-template name="traduction">
      <xsl:with-param name="code" select="'NBFONCTOT'"/>
    </xsl:call-template>
  </xsl:template>
  <xsl:template match="NBETABTOT[@ISCODE='1']">
    <xsl:call-template name="traduction">
      <xsl:with-param name="code" select="'NBETABTOT'"/>
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="DERNHOMO[@ISCODE='1']">
    <tr>
      <td class="clCouleur2 clWidth130">
        <xsl:call-template name="traduction">
          <xsl:with-param name="code" select="'DERNHOMO'"/>
        </xsl:call-template>
      </td>
    </tr>

  </xsl:template>

  <xsl:template match="ENTMORT[@ISCODE='1']">
    <xsl:if test="not(../IDNOUV)">
      <br />
    </xsl:if>
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
        <td class="clCouleur2">
          <xsl:call-template name="traduction">
            <xsl:with-param name="code" select="'ENTMORT'"/>
          </xsl:call-template>
        </td>
      </tr>
    </table>
  </xsl:template>

  <!--template displayAfterLibelle-->

  <xsl:template match="FINSADIR" mode="displayAfterLibelle">
    &#160;<xsl:call-template name ="displayDateXsl">
      <xsl:with-param name ="InputDate" select ="(.)"/>
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="U052" mode="displayAfterLibelle">
    &#160;<xsl:value-of select="."/>
  </xsl:template>

  <xsl:template match="IT01|IS01" mode="displayAfterLibelle">
    &#160;<xsl:call-template name ="displayDateXsl">
      <xsl:with-param name ="InputDate" select ="(.)"/>
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="CCD2|COD2" mode="displayAfterLibelle">
    <xsl:if test="not($NonResident = 'NR')">
      &#160;<xsl:call-template name ="displayIdentXsl">
        <xsl:with-param name ="InputIdent" select ="(.)"/>
      </xsl:call-template><a href="#nullepart" onclick="requestBDFInfos('56','','{$familyNumber}','',cstSimpleConfirm)">
        <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" border="0" align="absbottom" alt="plus d'infos"/>
      </a>
    </xsl:if>
  </xsl:template>

  <xsl:template match="CCD1|CCD3|COD1|COD3" mode="displayAfterLibelle">
    <xsl:if test="not($NonResident = 'NR')">
      &#160;<xsl:call-template name ="displayIdentXsl">
        <xsl:with-param name ="InputIdent" select ="(.)"/>
      </xsl:call-template><a href="#nullepart" onclick="requestBDFInfos('51|56|','','{$familyNumber}','',cstMultipleConfirm)">
        <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" border="0" align="absbottom" alt="plus d'infos"/>
      </a>
    </xsl:if>
  </xsl:template>


  <xsl:template match="CCS1|COS1" mode="displayAfterLibelle">
    <xsl:if test="not($NonResident = 'NR')">
      &#160;<xsl:call-template name ="displayIdentXsl">
        <xsl:with-param name ="InputIdent" select ="(.)"/>
      </xsl:call-template><a href="#nullepart" onclick="requestBDFInfos('27|45|','','{$familyNumber}','',cstMultipleConfirm)">
        <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" border="0" align="absbottom" alt="plus d'infos"/>
      </a>
    </xsl:if>
  </xsl:template>

  <xsl:template match="JUGEIND" mode="displayAfterLibelle">
    &#160;
  </xsl:template>

  <xsl:template match="CCB1Ap|CCB1Bp|CCB1Cp|CCB1Dp|CCB1Ep|CCB1Fp|CCR1Ap|CCR1Bp|CCR1Cp|CCR1Dp|CCR1Ep|CCR1Fp" mode="displayAfterLibelle">
    <xsl:if test="not($NonResident='NR')">
      <a href="#nullepart" onclick="requestBDFInfos('VB','','{$familyNumber}','',false,false,this)">
        <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" border="0" align="absbottom" title="Gnrer une Vitrine Bilans" alt="Gnrer une Vitrine Bilans" />
      </a>
    </xsl:if>
  </xsl:template>

  <xsl:template match="CCE1A|CCE1B" mode="displayAfterLibelle">
    <xsl:if test="not($NonResident='NR')">
      <a href="#nullepart" onclick="requestBDFInfos('52','','{$familyNumber}','',cstSimpleConfirm)">
        <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" border="0" align="absbottom" alt="plus d'infos"/>
      </a>
    </xsl:if>
  </xsl:template>

  <xsl:template match="CCE2A|CCE2B" mode="displayAfterLibelle">
    <xsl:if test="not($NonResident='NR')">
      <a href="#nullepart" onclick="requestBDFInfos('54','','{$familyNumber}','',cstSimpleConfirm)">
        <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" border="0" align="absbottom" alt="plus d'infos"/>
      </a>
    </xsl:if>
  </xsl:template>

  <xsl:template match="CCE3|COE3" mode="displayAfterLibelle">
    <xsl:if test="not($NonResident='NR')">
      <a href="#nullepart" onclick="requestBDFInfos('52|54|57|','','{$familyNumber}','',cstMultipleConfirm)">
        <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" border="0" align="absbottom" alt="plus d'infos"/>
      </a>
    </xsl:if>
  </xsl:template>

  <xsl:template match="MG7|CCI1|CCE8|COI1" mode="displayAfterLibelle">
    <xsl:if test="not($NonResident='NR')">
      <a href="#nullepart" onclick="requestBDFInfos('29','','{$familyNumber}','{//IDENTS|//IDRENV}',cstSimpleConfirm)">
        <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" border="0" align="absbottom" alt="plus d'infos"/>
      </a>
    </xsl:if>
  </xsl:template>

  <xsl:template match="MGP" mode="displayAfterLibelle">
    <xsl:if test="not($NonResident='NR')">
      <a href="#nullepart" onclick="requestBDFInfos('45','','{$familyNumber}','{//IDENTS|//IDRENV}',cstSimpleConfirm)">
        <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" border="0" align="absbottom" alt="plus d'infos"/>
      </a>
    </xsl:if>
  </xsl:template>

  <xsl:template match="ICB02" mode="displayAfterLibelle">
    <xsl:if test="not($NonResident='NR')">
      <a href="#nullepart" onclick="requestBDFInfos('28','','{$familyNumber}','{.}',cstSimpleConfirm)" class="clCouleur2">
        <u>
          <xsl:value-of select="."/>
        </u>
      </a>
    </xsl:if>
  </xsl:template>

  <xsl:template match="ISTAN" mode="displayAfterLibelle">
    <a href="#nullepart" onclick="requestBDFInfos('DE','','{$familyNumber}','{.}',cstSimpleConfirm)" class="clCouleur2">
      <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" border="0" align="absbottom" alt="plus d'infos"/>
    </a>
  </xsl:template>

  <xsl:template match="IST51|IST53F|IST53G|IST56|IST53" mode="displayAfterLibelle">
    <xsl:variable name="numModule" select="substring(name(),4,2)"/>
    <a href="#nullepart" onclick="requestBDFInfos('{$numModule}','','{$familyNumber}','',false,false,this)" class="clCouleur2">
      <u>
        <xsl:value-of select="$numModule"/>
      </u>
    </a>
  </xsl:template>

  <xsl:template name="traduction">
    <xsl:param name="code"/>
    <xsl:if test="not($Lang = 'UK')">
      <xsl:value-of select="$dictionnaire/mot[@id=$code]"/>
    </xsl:if>
    <xsl:if test="$Lang = 'UK'">
      <xsl:variable name="dictionnaire" select="document('../../Ressources/XML/DicoLibelleUK.xml')/dictionnaire"/>
      <xsl:value-of select="$dictionnaire/mot[@id=$code]"/>
    </xsl:if>
  </xsl:template>

  <xsl:template name="traductionTypeSuivi">
    <xsl:param name="codeTypeSuivi"/>
    <xsl:if test="not($Lang = 'UK')">
      <xsl:value-of select="$dictionnaire/titre[@module=$codeTypeSuivi]"/>
    </xsl:if>
    <xsl:if test="$Lang = 'UK'">
      <xsl:variable name="dictionnaire" select="document('../../Ressources/XML/DicoLibelleUK.xml')/dictionnaire"/>
      <xsl:value-of select="$dictionnaire/titre[@module=$codeTypeSuivi]"/>
    </xsl:if>
  </xsl:template>




  <xsl:template name="insertClientScripts">
    <script language="javascript" charset="iso-8859-1" src="{$root}Ressources/JavaScript/Constantes.js">
      <xsl:text disable-output-escaping="yes">&#160;</xsl:text>
    </script>
    <script language="javascript" charset="iso-8859-1" src="{$root}Ressources/JavaScript/Date.js">
      <xsl:text disable-output-escaping="yes">&#160;</xsl:text>
    </script>
    <script language="javascript" charset="iso-8859-1" src="{$root}Ressources/JavaScript/String.js">
      <xsl:text disable-output-escaping="yes">&#160;</xsl:text>
    </script>
    <script language="javascript" charset="iso-8859-1" src="{$root}Ressources/JavaScript/Identifiant.js">
      <xsl:text disable-output-escaping="yes">&#160;</xsl:text>
    </script>
    <script language="javascript" charset="iso-8859-1" src="{$root}Ressources/JavaScript/Commun.js">
      <xsl:text disable-output-escaping="yes">&#160;</xsl:text>
    </script>
    <script language="javascript" charset="iso-8859-1" src="{$root}Ressources/JavaScript/Commun_RALPH.js">
      <xsl:text disable-output-escaping="yes">&#160;</xsl:text>
    </script>
    <script language="javascript" charset="iso-8859-1" src="{$root}Ressources/JavaScript/Commun_SAS.js">
      <xsl:text disable-output-escaping="yes">&#160;</xsl:text>
    </script>
    <script language="javascript" charset="iso-8859-1" src="{$root}Ressources/JavaScript/newhome.js">
      <xsl:text disable-output-escaping="yes">&#160;</xsl:text>
    </script>
  </xsl:template>

  <!-- *********************************************************************************************************************************************************** -->

  <xsl:template name="genHead">
    <xsl:param name="ident"/>
    <head>
      <xsl:if test="/FIBEN/@GRAPHE">
        <title>
          FIBEN - module <xsl:value-of select="/FIBEN/@MODDEM"/> - <xsl:value-of select="$ident"/> - <xsl:value-of select="/FIBEN/REFINT"/> - graphiques
        </title>
      </xsl:if>
      <xsl:if test="not(/FIBEN/@GRAPHE)">
        <title>
          FIBEN - module <xsl:value-of select="/FIBEN/@MODDEM"/> - <xsl:value-of select="$ident"/> - <xsl:value-of select="/FIBEN/REFINT"/>
        </title>
      </xsl:if>
      <meta http-equiv="X-UA-Compatible" content="IE=edge" />
      <xsl:call-template name="insertClientScripts"/>
      <script language="javascript">
        var sModule = '<xsl:value-of select="FIBEN/@MODDEM"/>';
        var sClientRef = "<xsl:value-of select="FIBEN/REFINT"/>";
        var sBDFId = "<xsl:value-of select="$ident"/>";
        var sFamily = '<xsl:value-of select="$familyNumber"/>';
      </script>
      <link rel="stylesheet" href="{$root}Ressources/CSS/Commun.css" />
      <link rel="stylesheet" href="{$root}Ressources/CSS/newhome.css" />
      <link rel="stylesheet" href="{$root}Ressources/CSS/risque.css" />
      <link rel="stylesheet" href="{$root}Ressources/CSS/organigrammes.css" />
    </head>
  </xsl:template>


  <xsl:template name="genEnTete">
    <xsl:param name="ident"/>
    <xsl:param name="nom"/>
    <xsl:param name="nomconj"/>
    <xsl:param name="valcot"/>
    <xsl:param name="datcot"/>
    <xsl:param name="datexa"/>
    <xsl:param name="dateseg"/>
    <xsl:param name="datsegrv"/>
    <xsl:param name="idrenv"/>
    <xsl:param name="valindic"/>
    <xsl:param name="datindic"/>
    <xsl:param name="indexa2"/>
    <xsl:param name="segment"/>
    <xsl:param name="datseg"/>
    <xsl:param name ="datexseg"/>

    <xsl:call-template name="genTitreModule" />
    <xsl:call-template name="genIdentification">
      <xsl:with-param name="ident" select="$ident"/>
      <xsl:with-param name="nom" select="$nom"/>
      <xsl:with-param name="nomconj" select="$nomconj"/>
      <xsl:with-param name="valcot" select="$valcot"/>
      <xsl:with-param name="datcot" select="$datcot"/>
      <xsl:with-param name="datexa" select="$datexa"/>
      <xsl:with-param name="dateseg" select="$dateseg"/>
      <xsl:with-param name="datsegrv" select="$datsegrv"/>
      <xsl:with-param name="idrenv" select="$idrenv"/>
      <xsl:with-param name="valindic" select="$valindic"/>
      <xsl:with-param name="datindic" select="$datindic"/>
      <xsl:with-param name="indexa2" select="$indexa2"/>
      <xsl:with-param name="segment"  select="$segment"/>
      <xsl:with-param name="datseg"  select="$datseg"/>
      <xsl:with-param name ="datexseg" select ="$datexseg"/>
    </xsl:call-template>

    <xsl:if test="$valcot and /FIBEN/@MODDEM!='AN' and /FIBEN/@MODDEM!='DE' and /FIBEN/@MODDEM!=20 and /FIBEN/@MODDEM!=37 and /FIBEN/@MODDEM!=70 and /FIBEN/@MODDEM!=72 and not(/FIBEN/@GRAPHE)">

      <xsl:if test="(not($valcot='J0' or $valcot='K0' or $valcot='L0' or $valcot='M0' or $valcot='X0') or (($valcot='J0' or $valcot='K0' or $valcot='L0' or $valcot='M0' or $valcot='X0') and $segment=''))">
        <xsl:if test="not($valcot='NS')">
          <xsl:if test ="not($valcot='ND')">
            <xsl:if test="not($NonResident='NR')">
              <img src="{$root}Images/Commun/shim.gif" width="545" height="12" border="0" alt="" />
              <a href="#nullePart" onclick="requestBDFInfos('37','','{$familyNumber}','',cstSimpleConfirm);">
                <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" border="0" alt="plus d'infos"/>
              </a>
              <br/>
            </xsl:if>
          </xsl:if>
        </xsl:if>
      </xsl:if>
    </xsl:if>


    <xsl:if test="$segment!='' and /FIBEN/@MODDEM!='DE' and /FIBEN/@MODDEM!=20 and /FIBEN/@MODDEM!=39">
      <xsl:if test="not($valcot='NS')">
        <xsl:if test="not($valcot='ND')">
          <xsl:if test="not($NonResident='NR')">
            <img src="{$root}Images/Commun/shim.gif" width="545" height="12" border="0" alt=""/>
            <a href="#nullePart" onclick="requestBDFInfos('37|39|','','{$familyNumber}','',cstMultipleConfirm);">
              <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" border="0" alt="plus d'infos"/>
            </a>
            <br/>
          </xsl:if>
        </xsl:if>
      </xsl:if>      
    </xsl:if>

    <xsl:apply-templates select="/FIBEN/PERSONNE/IDNOUV"/>
    <xsl:apply-templates select="/FIBEN/PERSONNE/ENTMORT"/>
    <xsl:apply-templates select="/FIBEN/PERSONNE/LEI | 
                           /FIBEN/PERSONNE/MODULE27/PM27/*/LEI | 
                           /FIBEN/PERSONNE/MODULE28/PM/*/LEI | 
                           /FIBEN/PERSONNE/MODULE29/PM/*/LEI | 
                           /FIBEN/PERSONNE/MODULE31/PM/*/LEI | 
                           /FIBEN/PERSONNE/MODULE32/PM/*/LEI | 
                           /FIBEN/PERSONNE/MODULE40/PM/*/LEI | 
                           /FIBEN/PERSONNE/MODULEOR/PM/*/LEI "/>
    <xsl:apply-templates select="/FIBEN/PERSONNE/MODULE27/PM27/*/IDENTNATIONAL | /FIBEN/PERSONNE/MODULE28/PM/*/IDENTNATIONAL | /FIBEN/PERSONNE/MODULE29/PM/*/IDENTNATIONAL | /FIBEN/PERSONNE/MODULE31/PM/*/IDENTNATIONAL | /FIBEN/PERSONNE/MODULE32/PM/*/IDENTNATIONAL|/FIBEN/PERSONNE/MODULE40/PM/*/IDENTNATIONAL | /FIBEN/PERSONNE/MODULEOR/PM/*/IDENTNATIONAL "/>
    <!-- presentation du bandeau diffrente si module 37  GDC2014 il faut mettre les homonymes avant l'adresse-->
    <xsl:if test ="/FIBEN/PERSONNE/MODULE37//HOMONYME">
      <xsl:if test ="/FIBEN/PERSONNE/ENTMORT">
        <xsl:call-template name="shim"/>
      </xsl:if>
      <xsl:apply-templates select="/FIBEN/PERSONNE/MODULE37//HOMONYME"/>
    </xsl:if>

    <xsl:apply-templates select="/FIBEN/PERSONNE/LIEU"/>

  </xsl:template>

  <xsl:template match="NAISSANCE">
    <tr>
      <td class="clCouleur2 clWidth130">
        <xsl:if test="$NonResident='NR'">
          <xsl:call-template name="tradlib">
            <xsl:with-param name="lang" select="$Lang"/>
            <xsl:with-param name="codeLib" select="'m00_NeeLe'"/>
          </xsl:call-template>
        </xsl:if>
        <xsl:if test="not($NonResident='NR')">
          <xsl:value-of select="$dicoFR/mot[@id='m00_NeeLe']"/>
        </xsl:if>
      </td>
      <td class="clFond clWidth505" colspan="2">
        &#160;<xsl:call-template name ="displayDateXsl">
          <xsl:with-param name ="InputDate" select ="(DATNAISS)"/>
        </xsl:call-template>
      </td>
    </tr>
    <xsl:if test="LNAISS">
      <tr>
        <td class="clCouleur2 clWidth130">
          <xsl:if test="$NonResident='NR'">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m00_a'"/>
            </xsl:call-template>
          </xsl:if>
          <xsl:if test="not($NonResident='NR')">
            <xsl:value-of select="$dicoFR/mot[@id='m00_a']"/>
          </xsl:if>
        </td>
        <td class="clTexte clWidth505" colspan="2">
          &#160;<xsl:value-of select="LNAISS"/>&#160;
          <xsl:if test="DEPNAISS">
            (<xsl:value-of select="DEPNAISS"/>)
          </xsl:if>
        </td>
      </tr>
    </xsl:if>
  </xsl:template>

  <xsl:template match="LIEU">
    <xsl:if test="(/FIBEN/PERSONNE/MODULE27/PM27/EI27) | (/FIBEN/PERSONNE/MODULE27/PM27/EJ27)">
      <xsl:apply-templates select="LEI"/>
      <xsl:apply-templates select="IDENTNATIONAL"/>
    </xsl:if>
    <xsl:call-template name="shim"/>
    <table class="clWidth635 clBorderCell">
      <caption class="visually-hidden">Naissance et Adresse</caption>
      <xsl:apply-templates select="//NAISSANCE"/>
      <xsl:apply-templates select="ADRESS"/>
      <xsl:text disable-output-escaping="yes">&lt;tr&gt;</xsl:text>
      <xsl:if test="not(ADRESS)">
         <td class="clCouleur2 clWidth130">
          <xsl:if test="$NonResident='NR'">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m00_Adresse'"/>
            </xsl:call-template>
          </xsl:if>
          <xsl:if test="not($NonResident='NR')">
            <xsl:value-of select="$dicoFR/mot[@id='m00_Adresse']"/>
          </xsl:if>
        </td>
        <xsl:if test="not(//NAISSANCE) or (//NAISSANCE/DATNAISS and //NAISSANCE/LNAISS)">
          <xsl:call-template name="displayLocaliCpmaj">
            <xsl:with-param name="class">clFond</xsl:with-param>
          </xsl:call-template>
        </xsl:if>
        <xsl:if test="//NAISSANCE/DATNAISS and not(//NAISSANCE/LNAISS)">
          <xsl:call-template name="displayLocaliCpmaj">
            <xsl:with-param name="class">clTexte</xsl:with-param>
          </xsl:call-template>
        </xsl:if>
      </xsl:if>
      <xsl:if test="ADRESS">
         <td class="clCouleur2 clWidth130">&#160;</td>
        <xsl:if test="not(//NAISSANCE) or (//NAISSANCE/DATNAISS and //NAISSANCE/LNAISS)">
          <xsl:call-template name="displayLocaliCpmaj">
            <xsl:with-param name="class">clTexte</xsl:with-param>
          </xsl:call-template>
        </xsl:if>
        <xsl:if test="//NAISSANCE/DATNAISS and not(//NAISSANCE/LNAISS)">
          <xsl:call-template name="displayLocaliCpmaj">
            <xsl:with-param name="class">clFond</xsl:with-param>
          </xsl:call-template>
        </xsl:if>
      </xsl:if>
    </table>
    <xsl:call-template name="shim"/>
  </xsl:template>

  <xsl:template name="displayLocaliCpmaj">
    <xsl:param name="class"/>
    <xsl:variable name="class2">
      <xsl:if test="$class='clFond'">clTexte</xsl:if>
      <xsl:if test="$class='clTexte'">clFond</xsl:if>
    </xsl:variable>

    <xsl:if test="(TELEPH)">
      <td>
        <table class="clBorderCell clWidth505" role="presentation">
          <tr>
            <td class="{$class} clWidth345">
              &#160;<xsl:value-of select="LOCALI"/>
            </td>

            <td class="clCouleur2 clWidth33">
              &#160;&#160;
              <xsl:if test="$NonResident= 'NR'">
                <xsl:call-template name="tradlib">
                  <xsl:with-param name="Lang" select="$Lang"/>
                  <xsl:with-param name="codeLib" select="'m00_Tel'"/>
                </xsl:call-template>
              </xsl:if>
              <xsl:if test="not($NonResident= 'NR')">
                <xsl:value-of select="$dicoFR/mot[@id='m00_Tel']"/>
              </xsl:if>
            </td>
            <td class="clTexte clWidth127">
              &#160;<xsl:call-template name ="displayTeleph2">
                <xsl:with-param name ="InputNumTel" select ="TELEPH"/>
              </xsl:call-template>
            </td>
          </tr>
        </table>
      </td>
    </xsl:if>
    <xsl:if test="not(TELEPH)">
      <td class="{$class} clWidth505">
        &#160;<xsl:value-of select="LOCALI"/>
      </td>
    </xsl:if>
    <xsl:text disable-output-escaping="yes">&lt;/tr&gt;&lt;tr&gt;</xsl:text>
     <td class="clCouleur2 clWidth130">
      <xsl:if test="$NonResident='NR'">
        <xsl:call-template name="tradlib">
          <xsl:with-param name="Lang" select="$Lang"/>
          <xsl:with-param name="codeLib" select="'m00_DosGer'"/>
        </xsl:call-template>
      </xsl:if>
      <xsl:if test="not($NonResident='NR')">
        <xsl:value-of select="$dicoFR/mot[@id='m00_DosGer']"/>
      </xsl:if>
    </td>
    <xsl:choose>
      <xsl:when test="substring(CPMAJ,1,6)='IEDOM:'">
        <xsl:if test="$NonResident='NR'">
          <xsl:if test="$Lang='FR'">
            <td class="{$class2} clWidth505">
              &#160;IEDOM&#160;:&#160;<a href="#nullepart" class="{$class2}" onclick="requestStaticNRFR('', cstAdress);">
                <u>
                  <xsl:value-of select="substring(CPMAJ,7,20)"/>
                </u>
              </a>
            </td>
          </xsl:if>
          <xsl:if test="$Lang='UK'">
            <td class="{$class2} clWidth505">
              &#160;IEDOM&#160;:&#160;<a href="#nullepart" class="{$class2}" onclick="requestStaticNRUK('', cstAdressUK);">
                <u>
                  <xsl:value-of select="substring(CPMAJ,7,20)"/>
                </u>
              </a>
            </td>
          </xsl:if>
        </xsl:if>
        <xsl:if test="not($NonResident='NR')">
          <td class="{$class2} clWidth505">
            &#160;IEDOM&#160;:&#160;<a href="#nullepart" class="{$class2}" onclick="requestStatic('', cstAdress);">
              <u>
                <xsl:value-of select="substring(CPMAJ,7,20)"/>
              </u>
            </a>
          </td>
        </xsl:if>
      </xsl:when>
      <xsl:otherwise>
        <xsl:if test="$NonResident='NR'">
          <xsl:if test="$Lang='FR'">
            <td class="{$class2} clWidth505">
              &#160;BANQUE DE FRANCE&#160;:&#160;<a href="#nullepart" class="{$class2}" onclick="requestStaticNRFR('', cstAdress);">
                <u>
                  <xsl:value-of select="CPMAJ"/>
                </u>
              </a>
            </td>
          </xsl:if>
          <xsl:if test="$Lang='UK'">
            <td class="{$class2} clWidth505">
              &#160;BANQUE DE FRANCE&#160;:&#160;<a href="#nullepart" class="{$class2}" onclick="requestStaticNRUK('', cstAdressUK);">
                <u>
                  <xsl:value-of select="CPMAJ"/>
                </u>
              </a>
            </td>
          </xsl:if>
        </xsl:if>
        <xsl:if test="not($NonResident='NR')">
          <td class="{$class2} clWidth505">
            &#160;BANQUE DE FRANCE&#160;:&#160;<a href="#nullepart" class="{$class2}" onclick="requestStatic('', cstAdress);">
              <u>
                <xsl:value-of select="CPMAJ"/>
              </u>
            </a>
          </td>
        </xsl:if>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:text disable-output-escaping="yes">&lt;/tr&gt;</xsl:text>
  </xsl:template>

  <xsl:template match="ADRESS">

    <tr>
       <td class="clCouleur2 clWidth130">
        <xsl:if test="position()=1">
          <xsl:if test="$NonResident='NR'">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m00_Adresse'"/>
            </xsl:call-template>
          </xsl:if>
          <xsl:if test="not($NonResident='NR')">
            <xsl:value-of select="$dicoFR/mot[@id='m00_Adresse']"/>
          </xsl:if>
        </xsl:if>
      </td>
      <xsl:if test="not(//NAISSANCE) or (//NAISSANCE/DATNAISS and //NAISSANCE/LNAISS)">
        <td class="clFond clWidth505">
          &#160;<xsl:value-of select="."/>
        </td>
      </xsl:if>
      <xsl:if test="//NAISSANCE/DATNAISS and not(//NAISSANCE/LNAISS)">
        <td class="clTexte clWidth505">
          &#160;<xsl:value-of select="."/>
        </td>
      </xsl:if>
    </tr>

  </xsl:template>

  <xsl:template match="IDNOUV">
    <br />
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
        <td class="clCouleur2 clWidth130">
          <xsl:if test="$NonResident='NR'">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m00_NouIde'"/>
            </xsl:call-template>
          </xsl:if>
          <xsl:if test="not($NonResident='NR')">
            <xsl:value-of select="$dicoFR/mot[@id='m00_NouIde']"/>
          </xsl:if>
        </td>
        <td class="clTexte clWidth505 clHeight14" colspan="2">
          &#160;<xsl:call-template name ="displayIdentXsl">
            <xsl:with-param name ="InputIdent" select ="(.)"/>
          </xsl:call-template>
        </td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template name="genIdentification">
    <xsl:param name="ident"/>
    <xsl:param name="nom"/>
    <xsl:param name="nomconj"/>
    <xsl:param name="valcot"/>
    <xsl:param name="datcot"/>
    <xsl:param name="datexa"/>
    <xsl:param name="dateseg"/>
    <xsl:param name="datsegrv"/>
    <xsl:param name="idrenv"/>
    <xsl:param name="valindic"/>
    <xsl:param name="datindic"/>
    <xsl:param name="indexa2"/>
    <xsl:param name="segment"/>
    <xsl:param name="datseg"/>
    <xsl:param name ="datexseg"/>

    <!---modification pour le x0 pierre-->


    <xsl:if test="(($valcot='J0' or $valcot='K0' or $valcot='L0' or $valcot='M0' or $valcot='X0') and $segment!='')">

      <!-- modification DIFFENT-30 Alain 03/2023 -->

      <xsl:if test="(/FIBEN/PERSONNE/MODULE27|/FIBEN/PERSONNE/MODULE57|/FIBEN/PERSONNE/MODULE58|/FIBEN/PERSONNE/MODULE59|/FIBEN/PERSONNE/MODULEDE)">
        <table class="clWidth635 clEnTeteTable clBorderCellpadding1 clHeight34">
          <caption class="visually-hidden">Information sur l'entit interrog</caption>
          <tr>
            <td>
              <table class="clWidth633 clBorderCellpadding1 clHeight17" role="presentation">
                <!-- 1ere ligne cotation -->
                <tr>
                  <xsl:if test="not($NonResident='NR')">
                    <td class="clGrasFond clWidth129 clValignMiddle">
                      &#160;<xsl:call-template name ="displayIdent2Xsl">
                        <xsl:with-param name ="InputIdent" select ="($ident)"/>
                      </xsl:call-template>
                    </td>
                    <td class="clGrasFond Width380 clValignMiddle">
                      &#160;<xsl:value-of select="$nom"/>
                    </td>
                  </xsl:if>
                  <xsl:if test="$NonResident='NR'">
                    <xsl:if test="$Lang='FR'">
                      <td class="clGrasFond clWidth129 clValignMiddle">
                        &#160;<xsl:call-template name ="displayIdent2Xsl">
                          <xsl:with-param name ="InputIdent" select ="($ident)"/>
                        </xsl:call-template>
                      </td>
                      <td class="clGrasFond Width380 clValignMiddle">
                        &#160;<xsl:value-of select="$nom"/>
                      </td>
                    </xsl:if>
                    <xsl:if test="$Lang='UK'">
                      <td class="clGrasFond clWidth145 clValignMiddle">
                        &#160;<xsl:call-template name ="displayIdent2Xsl">
                          <xsl:with-param name ="InputIdent" select ="($ident)"/>
                        </xsl:call-template>
                      </td>
                      <td class="clGrasFond clValignMiddle">
                        &#160;<xsl:value-of select="$nom"/>
                      </td>
                    </xsl:if>
                  </xsl:if>
                  <td class="clGrasFond clValignMiddle clAlignRight" colspan="2">
                    &#160;
                    <xsl:if test="$NonResident='NR'">
                      <xsl:call-template name="tradlib">
                        <xsl:with-param name="Lang" select="$Lang"/>
                        <xsl:with-param name="codeLib" select="'m00_Cot'"/>
                      </xsl:call-template>
                    </xsl:if>
                    <xsl:if test="not($NonResident='NR')">
                      <xsl:value-of select="$dicoFR/mot[@id='m00_Cot']"/>
                    </xsl:if>
                    <xsl:if test ="$valcot='ND'">
                      <a href="#nullepart" class="clGrasFond" onclick="requestVariousInfos('{$valcot}',cstCotationNonDif,'{$ident}')">
                        <u>
                          <xsl:value-of select="$valcot"/>
                        </u>
                      </a>&#160;
                    </xsl:if>
                    <xsl:if test ="not($valcot='ND')">
                      <a href="#nullepart" class="clGrasFond" onclick="requestVariousInfos('{$valcot}',cstCotation,'{$ident}')">
                        <u>
                          <xsl:value-of select="$valcot"/>
                        </u>
                      </a>&#160;
                    </xsl:if>
                  </td>
                </tr>
              </table>
              <table class="clWidth633 clBorderCellpadding1 clHeight17" role="presentation">
                <!-- 2eme ligne cotation -->
                <xsl:if test="$datcot!=''">
                  <tr>
                    <td class="clFond clWidth129 clValignMiddle">&#160;</td>
                    <td class="clFond clWidth10">&#160;</td>
                    <td class="clFond clWidth504 clAlignRight" colspan="2">
                      &#160;
                      <xsl:if test="$datcot!=''">
                        <xsl:if test="$NonResident='NR'">
                          <xsl:call-template name="tradlib">
                            <xsl:with-param name="Lang" select="$Lang"/>
                            <xsl:with-param name="codeLib" select="'m00_DepLe'"/>
                          </xsl:call-template>
                        </xsl:if>
                        <xsl:if test="not($NonResident='NR')">
                          <xsl:value-of select="$dicoFR/mot[@id='m00_DepLe']"/>
                        </xsl:if>
                        <xsl:call-template name ="displayDateXsl">
                          <xsl:with-param name ="InputDate" select ="($datcot)"/>
                        </xsl:call-template>
                        <xsl:if test="$datexa!=''">

                          <xsl:if test="$NonResident='NR'">
                            <xsl:call-template name="tradlib">
                              <xsl:with-param name="Lang" select="$Lang"/>
                              <xsl:with-param name="codeLib" select="'m00_RevLe'"/>
                            </xsl:call-template>
                          </xsl:if>
                          <xsl:if test="not($NonResident='NR')">
                            <xsl:value-of select="$dicoFR/mot[@id='m00_RevLe']"/>
                          </xsl:if>
                          <xsl:call-template name ="displayDateXsl">
                            <xsl:with-param name ="InputDate" select ="($datexa)"/>
                          </xsl:call-template>)
                        </xsl:if>
                      </xsl:if>
                    </td>
                  </tr>
                </xsl:if>
                <xsl:if test="$datcot=''">
                  <tr>
                    <td class="clFond clWidth129 clValignMiddle">&#160;</td>
                    <td class="clFond clWidth10">&#160;</td>
                    <td class="clFond clWidth504 clAlignRight" colspan="2">&#160;</td>
                  </tr>
                </xsl:if>
              </table>
              <table class="clWidth633 clBorderCellpadding1 clHeight17" role="presentation">
                <!-- 1ere ligne segmentation -->
                <tr>
                  <td class="clFond clWidth129 clValignMiddle">&#160;</td>
                  <td class="clGrasFond clWidth254 clValignMiddle"></td>
                  <td class="clGrasFond clValignMiddle clAlignRight" colspan="2">
                    &#160;
                    <xsl:if test="$NonResident='NR'">
                      <xsl:call-template name="tradlib">
                        <xsl:with-param name="Lang" select="$Lang"/>
                        <xsl:with-param name="codeLib" select="'m00_Seg'"/>
                      </xsl:call-template>                     
                    </xsl:if>
                    <xsl:if test="not($NonResident='NR')">
                      <xsl:value-of select="$dicoFR/mot[@id='m00_Seg']"/>                     
                    </xsl:if>
                    <xsl:if test="$Lang='FR'">
                       <a href="#nullepart" class="clGrasFond" onclick="requestInfosLibelle('segmentation',cstSegment)">
                        <u>
                          <xsl:value-of select="$segment"/>
                        </u>
                      </a>&#160;
                    </xsl:if>
                    <xsl:if test="$Lang='UK'">
                      <a href="#nullepart" class="clGrasFond" onclick="requestInfosLibelle('segmentation',cstSegmentUK)">
                        <u>
                          <xsl:value-of select="$segment"/>
                        </u>
                      </a>&#160;
                    </xsl:if>                    
                  </td>
                </tr>
              </table>
              <table class="clWidth633 clBorderCellpadding1 clHeight17" role="presentation">
                <!-- 2eme ligne segmentation -->
                <xsl:if test="$dateseg!=''">
                  <tr>
                    <td class="clFond clWidth129 clValignMiddle">&#160;</td>
                    <td class="clFond clWidth10">&#160;</td>
                    <td class="clFond clWidth504 clAlignRight" colspan="2">
                      &#160;
                      <xsl:if test="$dateseg!=''">
                        <xsl:if test="$NonResident='NR'">
                          <xsl:call-template name="tradlib">
                            <xsl:with-param name="Lang" select="$Lang"/>
                            <xsl:with-param name="codeLib" select="'m00_DepLe'"/>
                          </xsl:call-template>
                        </xsl:if>
                        <xsl:if test="not($NonResident='NR')">
                          <xsl:value-of select="$dicoFR/mot[@id='m00_DepLe']"/>
                        </xsl:if>
                        <xsl:call-template name ="displayDateXsl">
                          <xsl:with-param name ="InputDate" select ="($dateseg)"/>
                        </xsl:call-template>
                        <xsl:if test="$datsegrv!=''">

                          <xsl:if test="$NonResident='NR'">
                            <xsl:call-template name="tradlib">
                              <xsl:with-param name="Lang" select="$Lang"/>
                              <xsl:with-param name="codeLib" select="'m00_RevLe'"/>
                            </xsl:call-template>
                          </xsl:if>
                          <xsl:if test="not($NonResident='NR')">
                            <xsl:value-of select="$dicoFR/mot[@id='m00_RevLe']"/>
                          </xsl:if>
                          <xsl:call-template name ="displayDateXsl">
                            <xsl:with-param name ="InputDate" select ="($datsegrv)"/>
                          </xsl:call-template>)
                        </xsl:if>
                      </xsl:if>
                    </td>
                  </tr>
                </xsl:if>
                <xsl:if test="$dateseg=''">
                  <tr>
                    <td class="clFond clWidth129 clValignMiddle">&#160;</td>
                    <td class="clFond clWidth10">&#160;</td>
                    <td class="clFond clWidth504 clAlignRight" colspan="2">&#160;</td>
                  </tr>
                </xsl:if>
              </table>
            </td>
          </tr>
        </table>

      </xsl:if>
      <xsl:if test="(/FIBEN/PERSONNE/MODULE51|/FIBEN/PERSONNE/MODULE56|/FIBEN/PERSONNE/MODULE67|/FIBEN/PERSONNE/MODULEAN|/FIBEN/PERSONNE/MODULEOD|/FIBEN/@GRAPHE)">
        <table class="clWidth635 clEnTeteTable clBorderCellpadding1 clHeight34">
          <caption class="visually-hidden">Information sur l'entit interrog</caption>
          <tr>
            <td>
              <table class="clWidth633 clBorderCellpadding1 clHeight17" role="presentation">                
                <tr>
                  <xsl:if test="not($NonResident='NR')">
                    <td class="clGrasFond clWidth129 clValignMiddle">
                      &#160;<xsl:call-template name ="displayIdent2Xsl">
                        <xsl:with-param name ="InputIdent" select ="($ident)"/>
                      </xsl:call-template>
                    </td>
                    <td class="clGrasFond clWidth254 clValignMiddle">
                      &#160;<xsl:value-of select="$nom"/>
                    </td>
                  </xsl:if>
                  <xsl:if test="$NonResident='NR'">
                    <xsl:if test="$Lang='FR'">
                      <td class="clGrasFond clWidth129 clValignMiddle">
                        &#160;<xsl:call-template name ="displayIdent2Xsl">
                          <xsl:with-param name ="InputIdent" select ="($ident)"/>
                        </xsl:call-template>
                      </td>
                      <td class="clGrasFond clWidth254 clValignMiddle">
                        &#160;<xsl:value-of select="$nom"/>
                      </td>
                    </xsl:if>
                    <xsl:if test="$Lang='UK'">
                      <td class="clGrasFond clWidth145 clValignMiddle">
                        &#160;<xsl:call-template name ="displayIdent2Xsl">
                          <xsl:with-param name ="InputIdent" select ="($ident)"/>
                        </xsl:call-template>
                      </td>
                      <td class="clGrasFond clValignMiddle">
                        &#160;<xsl:value-of select="$nom"/>
                      </td>
                    </xsl:if>
                  </xsl:if>
                  <td class="clGrasFond clValignMiddle clAlignRight" colspan="2">
                    &#160;
                    <xsl:if test="$NonResident='NR'">
                      <xsl:call-template name="tradlib">
                        <xsl:with-param name="Lang" select="$Lang"/>
                        <xsl:with-param name="codeLib" select="'m00_CotSeg'"/>
                      </xsl:call-template>
                    </xsl:if>
                    <xsl:if test="not($NonResident='NR')">
                      <xsl:value-of select="$dicoFR/mot[@id='m00_CotSeg']"/>
                    </xsl:if>

                    <xsl:choose>
                      <xsl:when test ="/FIBEN/PERSONNE/MODULEDE|/FIBEN/PERSONNE/MODULEAN ">
                        <xsl:value-of select="$valcot"/>&#160;|
                        <a href="#nullepart" class="clGrasFond" onclick="requestInfosLibelle('segmentation',cstSegment)">
                          <u>
                            <xsl:value-of select="$segment"/>
                          </u>
                        </a>&#160;
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:if test ="$valcot='ND'">
                          <a href="#nullepart" class="clGrasFond" onclick="requestVariousInfos('{$valcot}',cstCotationNonDif,'{$ident}')">
                            <u>
                              <xsl:value-of select="$valcot"/>
                            </u>
                          </a>&#160;
                        </xsl:if>
                        <xsl:if test ="not($valcot='ND')">
                          <a href="#nullepart" class="clGrasFond" onclick="requestVariousInfos('{$valcot}',cstCotation,'{$ident}')">
                            <u>
                              <xsl:value-of select="$valcot"/>
                            </u>
                          </a>&#160;
                        </xsl:if>
                        &#160;|
                        <a href="#nullepart" class="clGrasFond" onclick="requestInfosLibelle('segmentation',cstSegment)">
                          <u>
                            <xsl:value-of select="$segment"/>
                          </u>
                        </a>&#160;
                      </xsl:otherwise>
                    </xsl:choose>
                  </td>
                </tr>
                <xsl:if test="$datcot!=''">
                  <tr>
                    <td class="clFond clWidth129 clValignMiddle">&#160;</td>
                    <td class="clFond clWidth200">&#160;</td>
                    <td class="clFond clWidth304 clAlignRight" colspan="2">
                      &#160;
                      <xsl:if test="$datcot!=''">
                        <xsl:if test="$NonResident='NR'">
                          <xsl:call-template name="tradlib">
                            <xsl:with-param name="Lang" select="$Lang"/>
                            <xsl:with-param name="codeLib" select="'m00_DepLe'"/>
                          </xsl:call-template>
                        </xsl:if>
                        <xsl:if test="not($NonResident='NR')">
                          <xsl:value-of select="$dicoFR/mot[@id='m00_DepLe']"/>
                        </xsl:if>
                        <xsl:call-template name ="displayDateXsl">
                          <xsl:with-param name ="InputDate" select ="($datcot)"/>
                        </xsl:call-template>
                        <xsl:if test="$datexa!=''">

                          <xsl:if test="$NonResident='NR'">
                            <xsl:call-template name="tradlib">
                              <xsl:with-param name="Lang" select="$Lang"/>
                              <xsl:with-param name="codeLib" select="'m00_RevLe'"/>
                            </xsl:call-template>
                          </xsl:if>
                          <xsl:if test="not($NonResident='NR')">
                            <xsl:value-of select="$dicoFR/mot[@id='m00_RevLe']"/>
                          </xsl:if>
                          <xsl:call-template name ="displayDateXsl">
                            <xsl:with-param name ="InputDate" select ="($datexa)"/>
                          </xsl:call-template>)
                        </xsl:if>
                      </xsl:if>
                    </td>
                  </tr>
                </xsl:if>
                <xsl:if test="$datcot=''">
                  <tr>
                    <td class="clFond clWidth129 clValignMiddle">&#160;</td>
                    <td class="clFond clWidth200">&#160;</td>
                    <td class="clFond clWidth304 clAlignRight" colspan="2">&#160;</td>
                  </tr>
                </xsl:if>
              </table>
            </td>
          </tr>
        </table>

      </xsl:if>

      <xsl:if test ="/FIBEN/PERSONNE/MODULE20">
        <table class="clWidth635 clEnTeteTable clBorderCellpadding1 clHeight34">
          <caption class="visually-hidden">Information sur l'entit interrog</caption>
          <tr>
            <td>
              <table class="clWidth633 clBorderCellpadding1 clHeight17" role="presentation">
                <!-- 1ere ligne cotation -->
                <tr>
                  <xsl:if test="not($NonResident='NR')">
                    <td class="clGrasFond clWidth129 clValignMiddle">
                      &#160;<xsl:call-template name ="displayIdent2Xsl">
                        <xsl:with-param name ="InputIdent" select ="($ident)"/>
                      </xsl:call-template>
                    </td>
                    <td class="clGrasFond Width380 clValignMiddle">
                      &#160;<xsl:value-of select="$nom"/>
                    </td>
                  </xsl:if>
                  <xsl:if test="$NonResident='NR'">
                    <xsl:if test="$Lang='FR'">
                      <td class="clGrasFond clWidth129 clValignMiddle">
                        &#160;<xsl:call-template name ="displayIdent2Xsl">
                          <xsl:with-param name ="InputIdent" select ="($ident)"/>
                        </xsl:call-template>
                      </td>
                      <td class="clGrasFond Width380 clValignMiddle">
                        &#160;<xsl:value-of select="$nom"/>
                      </td>
                    </xsl:if>
                    <xsl:if test="$Lang='UK'">
                      <td class="clGrasFond clWidth145 clValignMiddle">
                        &#160;<xsl:call-template name ="displayIdent2Xsl">
                          <xsl:with-param name ="InputIdent" select ="($ident)"/>
                        </xsl:call-template>
                      </td>
                      <td class="clGrasFond clValignMiddle">
                        &#160;<xsl:value-of select="$nom"/>
                      </td>
                    </xsl:if>
                  </xsl:if>
                  <td class="clGrasFond clValignMiddle clAlignRight" colspan="2">
                    &#160;
                    <xsl:if test="$NonResident='NR'">
                      <xsl:call-template name="tradlib">
                        <xsl:with-param name="Lang" select="$Lang"/>
                        <xsl:with-param name="codeLib" select="'m00_Cot'"/>
                      </xsl:call-template>
                    </xsl:if>
                    <xsl:if test="not($NonResident='NR')">
                      <xsl:value-of select="$dicoFR/mot[@id='m00_Cot']"/>
                    </xsl:if>
                    <!--<a href="#nullepart" class="clGrasFond" onclick="requestVariousInfos('{$valcot}',cstCotation,'{$ident}')">
                      <u>-->
                    <xsl:value-of select="$valcot"/>
                    <!--</u>
                    </a>-->
                  </td>
                </tr>
              </table>

              <xsl:if test="$datcot!=''">
                <!-- 2eme ligne cotation -->
                <table class="clWidth633 clBorderCellpadding1 clHeight17" role="presentation">
                  <tr>
                    <td class="clFond clWidth129 clValignMiddle">&#160;</td>
                    <td class="clFond clWidth10">&#160;</td>
                    <td class="clFond clWidth504 clAlignRight" colspan="2">
                      &#160;
                      <xsl:if test="$datcot!=''">
                        <xsl:if test="$NonResident='NR'">
                          <xsl:call-template name="tradlib">
                            <xsl:with-param name="Lang" select="$Lang"/>
                            <xsl:with-param name="codeLib" select="'m00_DepLe'"/>
                          </xsl:call-template>
                        </xsl:if>
                        <xsl:if test="not($NonResident='NR')">
                          <xsl:value-of select="$dicoFR/mot[@id='m00_DepLe']"/>
                        </xsl:if>
                        <xsl:call-template name ="displayDateXsl">
                          <xsl:with-param name ="InputDate" select ="($datcot)"/>
                        </xsl:call-template>
                        <xsl:if test="$datexa!=''">

                          <xsl:if test="$NonResident='NR'">
                            <xsl:call-template name="tradlib">
                              <xsl:with-param name="Lang" select="$Lang"/>
                              <xsl:with-param name="codeLib" select="'m00_RevLe'"/>
                            </xsl:call-template>
                          </xsl:if>
                          <xsl:if test="not($NonResident='NR')">
                            <xsl:value-of select="$dicoFR/mot[@id='m00_RevLe']"/>
                          </xsl:if>
                          <xsl:call-template name ="displayDateXsl">
                            <xsl:with-param name ="InputDate" select ="($datexa)"/>
                          </xsl:call-template>)
                        </xsl:if>
                      </xsl:if>
                    </td>
                  </tr>
                </table>
              </xsl:if>
              <xsl:if test="$datcot=''">
                <table class="clWidth633 clBorderCellpadding1 clHeight17" role="presentation">
                  <tr>
                    <td class="clFond clWidth129 clValignMiddle">&#160;</td>
                    <td class="clFond clWidth10">&#160;</td>
                    <td class="clFond clWidth504 clAlignRight" colspan="2">&#160;</td>
                  </tr>
                </table>
              </xsl:if>
              <!-- partie segmentation 1ere ligne -->
              <xsl:if test="$segment!=''">
                <table class="clWidth633 clBorderCellpadding1 clHeight17" role="presentation">
                  <tr>
                    <td class="clFond clWidth129 clValignMiddle">&#160;</td>
                    <td class="clGrasFond Width380 clValignMiddle"></td>
                    <td class="clGrasFond clValignMiddle clAlignRight" colspan="2">
                      &#160;
                      <xsl:if test="$NonResident='NR'">
                        <xsl:call-template name="tradlib">
                          <xsl:with-param name="Lang" select="$Lang"/>
                          <xsl:with-param name="codeLib" select="'m00_Seg'"/>
                        </xsl:call-template>
                      </xsl:if>
                      <xsl:if test="not($NonResident='NR')">
                        <xsl:value-of select="$dicoFR/mot[@id='m00_Seg']"/>
                      </xsl:if>
                      <!--<a href="#nullepart" class="clGrasFond" onclick="requestStatic('',cstSegment)">
                        <u>-->
                      <xsl:value-of select="$segment"/>
                      <!--</u>
                      </a>-->
                    </td>
                  </tr>
                </table>
              </xsl:if>
              <!-- 2eme ligne segmentation-->
              <xsl:if test="$datseg!=''">
                <table class="clWidth633 clBorderCellpadding1 clHeight17" role="presentation">
                  <tr>
                    <td class="clFond clWidth129 clValignMiddle">&#160;</td>
                    <td class="clFond clWidth10">&#160;</td>
                    <td class="clFond clWidth504 clAlignRight" colspan="2">
                      &#160;
                      <xsl:if test="$datseg!=''">
                        <xsl:if test="$NonResident='NR'">
                          <xsl:call-template name="tradlib">
                            <xsl:with-param name="Lang" select="$Lang"/>
                            <xsl:with-param name="codeLib" select="'m00_DepLe'"/>
                          </xsl:call-template>
                        </xsl:if>
                        <xsl:if test="not($NonResident='NR')">
                          <xsl:value-of select="$dicoFR/mot[@id='m00_DepLe']"/>
                        </xsl:if>
                        <xsl:call-template name ="displayDateXsl">
                          <xsl:with-param name ="InputDate" select ="($datseg)"/>
                        </xsl:call-template>
                      </xsl:if>
                      <xsl:if test="$datexseg!=''">
                        <xsl:if test="$NonResident='NR'">
                          <xsl:call-template name="tradlib">
                            <xsl:with-param name="Lang" select="$Lang"/>
                            <xsl:with-param name="codeLib" select="'m00_RevLe'"/>
                          </xsl:call-template>
                        </xsl:if>
                        <xsl:if test="not($NonResident='NR')">
                          <xsl:value-of select="$dicoFR/mot[@id='m00_RevLe']"/>
                        </xsl:if>
                        <xsl:call-template name ="displayDateXsl">
                          <xsl:with-param name ="InputDate" select ="($datexseg)"/>
                        </xsl:call-template>)
                      </xsl:if>
                    </td>
                  </tr>
                </table>
              </xsl:if>
              <xsl:if test="$datseg=''">
                <table class="clWidth633 clBorderCellpadding1 clHeight17" role="presentation">
                  <tr>
                    <td class="clFond clWidth129 clValignMiddle">&#160;</td>
                    <td class="clFond clWidth10">&#160;</td>
                    <td class="clFond clWidth504 clAlignRight" colspan="2">&#160;</td>
                  </tr>
                </table>
              </xsl:if>
            </td>
          </tr>
        </table>
      </xsl:if>
    </xsl:if>
    <xsl:if test="/FIBEN/PERSONNE/MODULE39/DIFF39">
      <table class="clWidth635 clEnTeteTable clBorderCellpadding1 clHeight34">
        <caption class="visually-hidden">Information sur l'entit interrog</caption>
        <tr>
          <td>
            <table class="clWidth633 clBorderCellpadding1 clHeight17" role="presentation">
              <tr>
                <xsl:if test="not($NonResident='NR')">
                  <td class="clGrasFond clWidth129 clValignMiddle">
                    &#160;<xsl:call-template name ="displayIdent2Xsl">
                      <xsl:with-param name ="InputIdent" select ="($ident)"/>
                    </xsl:call-template>
                  </td>
                  <td class="clGrasFond Width380 clValignMiddle">
                    &#160;<xsl:value-of select="$nom"/>
                  </td>
                </xsl:if>
                <xsl:if test="$NonResident='NR'">
                  <xsl:if test="$Lang='FR'">
                    <td class="clGrasFond clWidth129 clValignMiddle">
                      &#160;<xsl:call-template name ="displayIdent2Xsl">
                        <xsl:with-param name ="InputIdent" select ="($ident)"/>
                      </xsl:call-template>
                    </td>
                    <td class="clGrasFond Width380 clValignMiddle">
                      &#160;<xsl:value-of select="$nom"/>
                    </td>
                  </xsl:if>
                  <xsl:if test="$Lang='UK'">
                    <td class="clGrasFond clWidth145 clValignMiddle">
                      &#160;<xsl:call-template name ="displayIdent2Xsl">
                        <xsl:with-param name ="InputIdent" select ="($ident)"/>
                      </xsl:call-template>
                    </td>
                    <td class="clGrasFond clValignMiddle">
                      &#160;<xsl:value-of select="$nom"/>
                    </td>
                  </xsl:if>
                </xsl:if>
                <xsl:if test="$segment!=''">
                  <td class="clGrasFond clValignMiddle clAlignRight" colspan="2">
                    <xsl:if test="$NonResident='NR'">
                      <xsl:call-template name="tradlib">
                        <xsl:with-param name="Lang" select="$Lang"/>
                        <xsl:with-param name="codeLib" select="'m00_Seg'"/>
                      </xsl:call-template>
                    </xsl:if>
                    <xsl:if test="not($NonResident='NR')">
                      <xsl:value-of select="$dicoFR/mot[@id='m00_Seg']"/>
                    </xsl:if>
                    <xsl:if test="$Lang='FR'">
                      <a href="#nullepart" class="clGrasFond" onclick="requestInfosLibelle('segmentation',cstSegment)">
                        <u>
                          <xsl:value-of select="$segment"/>
                        </u>
                      </a>&#160;
                    </xsl:if>
                    <xsl:if test="$Lang='UK'">
                      <a href="#nullepart" class="clGrasFond" onclick="requestInfosLibelle('segmentation',cstSegmentUK)">
                        <u>
                          <xsl:value-of select="$segment"/>
                        </u>
                      </a>&#160;
                    </xsl:if> 
                  </td>
                </xsl:if>
                <xsl:if test="$segment=''">
                  <td class="clGrasFond clValignMiddle clAlignRight" colspan="2">
                    &#160;
                  </td>
                </xsl:if>
              </tr>
            </table>
            <table class="clWidth633 clBorderCellpadding1 clHeight17" role="presentation">
              <xsl:if test="$datseg!=''">
                <tr>
                  <td class="clFond clWidth129 clValignMiddle">&#160;</td>
                  <td class="clFond clWidth100">&#160;</td>
                  <td class="clFond clWidth404 clAlignRight" colspan="2">
                    &#160;
                    <xsl:if test="$datseg!=''">
                      <xsl:if test="$NonResident='NR'">
                        <xsl:call-template name="tradlib">
                          <xsl:with-param name="Lang" select="$Lang"/>
                          <xsl:with-param name="codeLib" select="'m00_DepLe'"/>
                        </xsl:call-template>
                      </xsl:if>
                      <xsl:if test="not($NonResident='NR')">
                        <xsl:value-of select="$dicoFR/mot[@id='m00_DepLe']"/>
                      </xsl:if>
                      <xsl:call-template name ="displayDateXsl">
                        <xsl:with-param name ="InputDate" select ="($datseg)"/>
                      </xsl:call-template>
                      <xsl:if test="$datexa!=''">

                        <xsl:if test="$NonResident='NR'">
                          <xsl:call-template name="tradlib">
                            <xsl:with-param name="Lang" select="$Lang"/>
                            <xsl:with-param name="codeLib" select="'m00_RevLe'"/>
                          </xsl:call-template>
                        </xsl:if>
                        <xsl:if test="not($NonResident='NR')">
                          <xsl:value-of select="$dicoFR/mot[@id='m00_RevLe']"/>
                        </xsl:if>
                        <xsl:call-template name ="displayDateXsl">
                          <xsl:with-param name ="InputDate" select ="($datexa)"/>
                        </xsl:call-template>)
                      </xsl:if>
                    </xsl:if>
                  </td>
                </tr>
              </xsl:if>
              <xsl:if test="$datseg=''">
                <tr>
                  <td class="clFond clWidthMax" colspan="4">&#160;</td>
                </tr>
              </xsl:if>
            </table>
          </td>
        </tr>
      </table>
    </xsl:if>

    <!--********************************* Partie Module53 ***********************************-->
    <!--******************************** Alain fevrier 2015 ******************************** -->


    <xsl:if test="((/FIBEN/PERSONNE/MODULE53/PM53/EI53/IDENTS) | (/FIBEN/PERSONNE/MODULE53/PM53/EJ))">
      <table class="clWidth635 clEnTeteTable clBorderCellpadding1 clHeight34">
        <caption class="visually-hidden">Information sur l'entit interrog</caption>
        <tr>
          <td>
            <!-- 1ere ligne avec l'identifiant le nom (ou denom) et la cotation -->
            <table class="clWidth633 clBorderCellpadding1 clHeight17" role="presentation">
              <tr>
                <xsl:if test="not($NonResident='NR')">
                  <td class="clGrasFond clWidth128 clValignMiddle">
                    &#160;<xsl:call-template name ="displayIdent2Xsl">
                      <xsl:with-param name ="InputIdent" select ="($ident)"/>
                    </xsl:call-template>
                  </td>
                  <xsl:choose>
                    <xsl:when test ="(($valcot='J0' or $valcot='K0' or $valcot='L0' or $valcot='M0' or $valcot='X0') and $segment!='')">
                      <!-- cotation et segmentation donc la cellule pour la denomination est plus petite-->
                      <td class="clGrasFond clWidth320 clValignMiddle">
                        &#160;<xsl:value-of select="$nom"/>
                      </td>
                    </xsl:when>
                    <xsl:otherwise>
                      <td class="clGrasFond clWidth405 clValignMiddle">
                        &#160;<xsl:value-of select="$nom"/>
                      </td>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:if>
                <xsl:if test="$NonResident='NR'">
                  <xsl:if test="$Lang='FR'">
                    <td class="clGrasFond clWidth128 clValignMiddle">
                      &#160;<xsl:call-template name ="displayIdent2Xsl">
                        <xsl:with-param name ="InputIdent" select ="($ident)"/>
                      </xsl:call-template>
                    </td>
                    <xsl:choose>
                      <xsl:when test ="(($valcot='J0' or $valcot='K0' or $valcot='L0' or $valcot='M0' or $valcot='X0') and $segment!='')">
                        <!-- cotation et segmentation donc la cellule pour la denomination est plus petite-->
                        <td class="clGrasFond clWidth320 clValignMiddle">
                          &#160;<xsl:value-of select="$nom"/>
                        </td>
                      </xsl:when>
                      <xsl:otherwise>
                        <td class="clGrasFond clWidth405 clValignMiddle">
                          &#160;<xsl:value-of select="$nom"/>
                        </td>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:if>
                  <xsl:if test="$Lang='UK'">
                    <td class="clGrasFond clWidth145 clValignMiddle">
                      &#160;<xsl:call-template name ="displayIdent2Xsl">
                        <xsl:with-param name ="InputIdent" select ="($ident)"/>
                      </xsl:call-template>
                    </td>
                    <xsl:choose>
                      <xsl:when test ="(($valcot='J0' or $valcot='K0' or $valcot='L0' or $valcot='M0' or $valcot='X0') and $segment!='')">
                        <!-- cotation et segmentation donc la cellule pour la denomination est plus petite-->
                        <td class="clGrasFond clWidth314 clValignMiddle">
                          &#160;<xsl:value-of select="$nom"/>
                        </td>
                      </xsl:when>
                      <xsl:otherwise>
                        <td class="clGrasFond clWidth388 clValignMiddle">
                          &#160;<xsl:value-of select="$nom"/>
                        </td>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:if>
                </xsl:if>
                <xsl:choose >
                  <xsl:when test ="(($valcot='J0' or $valcot='K0' or $valcot='L0' or $valcot='M0' or $valcot='X0') and $segment!='')">
                    <!-- cotation et segmentation-->
                    <td class="clGrasFond clWidth185 clAlignRight clValignMiddle">
                      <xsl:if test="$NonResident='NR'">
                        <xsl:call-template name="tradlib">
                          <xsl:with-param name="Lang" select="$Lang"/>
                          <xsl:with-param name="codeLib" select="'m00_CotSeg'"/>
                        </xsl:call-template>
                      </xsl:if>
                      <xsl:if test="not($NonResident='NR')">
                        <xsl:value-of select="$dicoFR/mot[@id='m00_CotSeg']"/>
                      </xsl:if>
                      <a href="#nullepart" class="clGrasFond" onclick="requestVariousInfos('{$valcot}',cstCotation,'{$ident}')">
                        <u>
                          <xsl:value-of select="$valcot"/>
                        </u>
                      </a>&#160;|
                      <a href="#nullepart" class="clGrasFond" onclick="requestInfosLibelle('segmentation',cstSegment)">
                        <u>
                          <xsl:value-of select="$segment"/>
                        </u>
                      </a>&#160;
                    </td>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:choose>
                      <xsl:when test="$valcot!=''">
                        <td class="clGrasFond clWidth100 clAlignRight clValignMiddle">
                          <xsl:if test="$NonResident='NR'">
                            <xsl:call-template name="tradlib">
                              <xsl:with-param name="Lang" select="$Lang"/>
                              <xsl:with-param name="codeLib" select="'m00_Cot'"/>
                            </xsl:call-template>
                          </xsl:if>
                          <xsl:if test="not($NonResident='NR')">
                            <xsl:value-of select="$dicoFR/mot[@id='m00_Cot']"/>
                          </xsl:if>
                          <xsl:if test ="$valcot!='ND'">
                            <a href="#nullepart" class="clGrasFond" onclick="requestVariousInfos('{$valcot}',cstCotation,'{$ident}')">
                              <u>
                                <xsl:value-of select="$valcot"/>
                              </u>
                            </a>&#160;
                          </xsl:if>
                          <xsl:if test ="$valcot='ND'">
                            <a href="#nullepart" class="clGrasFond" onclick="requestVariousInfos('{$valcot}',cstCotationNonDif,'{$ident}')">
                              <u>
                                <xsl:value-of select="$valcot"/>
                              </u>
                            </a>&#160;
                          </xsl:if>
                        </td>
                      </xsl:when>
                      <xsl:otherwise>
                        <td class="clGrasFond clWidth100 clAlignRight clValignMiddle">
                          &#160;
                        </td>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:otherwise>
                </xsl:choose>
              </tr>
              <!-- pas de nom marital et pas d'identifiant de renvoi ==> 2eme ligne vide -->
              <xsl:if test="not($idrenv) and not($nomconj)">
                <xsl:choose>
                  <xsl:when test ="$NonResident='NR'">
                    <xsl:choose>
                      <xsl:when test ="$Lang='FR'">
                        <tr>
                          <td class="clGrasFond clWidth128 clValignMiddle">
                            &#160;
                          </td>
                          <xsl:choose>
                            <xsl:when test ="(($valcot='J0' or $valcot='K0' or $valcot='L0' or $valcot='M0' or $valcot='X0') and $segment!='')">
                              <!-- cotation et segmentation donc la cellule pour la denomination est plus petite-->
                              <td class="clGrasFond clWidth320 clValignMiddle">
                                &#160;
                              </td>
                              <td class="clGrasFond clWidth100 clAlignRight clValignMiddle">
                                &#160;
                              </td>
                            </xsl:when>
                            <xsl:otherwise>
                              <td class="clGrasFond clWidth405 clValignMiddle">
                                &#160;
                              </td>
                              <td class="clGrasFond clWidth100 clAlignRight clValignMiddle">
                                &#160;
                              </td>
                            </xsl:otherwise>
                          </xsl:choose>
                        </tr>
                      </xsl:when>
                      <xsl:otherwise>
                        <tr>
                          <td class="clGrasFond clWidth145 clValignMiddle">
                            &#160;
                          </td>
                          <xsl:choose>
                            <xsl:when test ="(($valcot='J0' or $valcot='K0' or $valcot='L0' or $valcot='M0' or $valcot='X0') and $segment!='')">
                              <!-- cotation et segmentation donc la cellule pour la denomination est plus petite-->
                              <td class="clGrasFond clWidth303 clValignMiddle">
                                &#160;
                              </td>
                              <td class="clGrasFond clWidth100 clAlignRight clValignMiddle">
                                &#160;
                              </td>
                            </xsl:when>
                            <xsl:otherwise>
                              <td class="clGrasFond clWidth388 clValignMiddle">
                                &#160;
                              </td>
                              <td class="clGrasFond clWidth100 clAlignRight clValignMiddle">
                                &#160;
                              </td>
                            </xsl:otherwise>
                          </xsl:choose>
                        </tr>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:otherwise >
                    <tr>
                      <td class="clGrasFond clWidth128 clValignMiddle">
                        &#160;
                      </td>
                      <xsl:choose>
                        <xsl:when test ="(($valcot='J0' or $valcot='K0' or $valcot='L0' or $valcot='M0' or $valcot='X0') and $segment!='')">
                          <!-- cotation et segmentation donc la cellule pour la denomination est plus petite-->
                          <td class="clGrasFond clWidth320 clValignMiddle">
                            &#160;
                          </td>
                          <td class="clGrasFond clWidth100 clAlignRight clValignMiddle">
                            &#160;
                          </td>
                        </xsl:when>
                        <xsl:otherwise>
                          <td class="clGrasFond clWidth405 clValignMiddle">
                            &#160;
                          </td>
                          <td class="clGrasFond clWidth100 clAlignRight clValignMiddle">
                            &#160;
                          </td>
                        </xsl:otherwise>
                      </xsl:choose>
                    </tr>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:if>
            </table>

            <xsl:if test="/FIBEN/PERSONNE/MODULE53/PM53/EI53/IDENTS">
              <!-- 2eme ligne avec le nom marital -->
              <xsl:if test="$nomconj!=''">
                <table class="clWidth633 clBorderCellpadding1 clHeight17" role="presentation">
                  <tr>
                    <xsl:if test="$NonResident='NR'">
                      <xsl:if test="$Lang='FR'">
                        <td class="clFond clWidth128 clValignMiddle">
                          &#160;
                          <xsl:call-template name="tradlib">
                            <xsl:with-param name="Lang" select="$Lang"/>
                            <xsl:with-param name="codeLib" select="'m00_Conjoi'"/>
                          </xsl:call-template>
                        </td>
                        <td class="clFond clWidth505 clAlignLeft">
                          &#160;
                          <xsl:value-of select="$nomconj"/>
                        </td>
                      </xsl:if>
                      <xsl:if test="$Lang='UK'">
                        <td class="clFond clWidth140 clValignMiddle">
                          &#160;
                          <xsl:call-template name="tradlib">
                            <xsl:with-param name="Lang" select="$Lang"/>
                            <xsl:with-param name="codeLib" select="'m00_Conjoi'"/>
                          </xsl:call-template>
                        </td>
                        <td class="clFond clWidth493 clAlignLeft">
                          &#160;<xsl:value-of select="$nomconj"/>
                        </td>
                      </xsl:if>
                    </xsl:if>
                    <xsl:if test="not($NonResident='NR')">
                      <td class="clFond clWidth128 clValignMiddle">
                        &#160;<xsl:value-of select="$dicoFR/mot[@id='m00_Conjoi']"/>
                      </td>
                      <td class="clFond clWidth505 clAlignLeft">
                        &#160;<xsl:value-of select="$nomconj"/>
                      </td>
                    </xsl:if>
                  </tr>
                </table>
              </xsl:if>
              <!-- 3eme ligne identifiant de renvoi (ou 2eme ligne si pas de nom marital)-->
              <xsl:if test="$idrenv !=''">
                <table class="clWidth633 clBorderCellpadding1 clHeight17" role="presentation">
                  <tr>
                    <xsl:if test ="$NonResident='NR'">
                      <xsl:if test="$Lang='FR'">
                        <td class="clFond clWidth128 clValignMiddle">
                          &#160;
                          <xsl:call-template name="tradlib">
                            <xsl:with-param name="Lang" select="$Lang"/>
                            <xsl:with-param name="codeLib" select="'m00_IdeRen'"/>
                          </xsl:call-template>
                        </td>
                         <td class="clFond clWidth110">
                          &#160;
                          <xsl:call-template name ="displayIdentXsl">
                            <xsl:with-param name ="InputIdent" select ="($idrenv)"/>
                          </xsl:call-template>
                        </td>
                        <xsl:choose>
                          <xsl:when test ="$valindic!=''">
                            <td class="clGrasFond clWidth110 clAlignRight clValignMiddle">
                              &#160;
                              <xsl:call-template name="tradlib">
                                <xsl:with-param name="Lang" select="$Lang"/>
                                <xsl:with-param name="codeLib" select="'m00_Indi'"/>
                              </xsl:call-template>
                              <a href="#nullepart" class="clGrasFond" onclick="requestVariousInfos('{$valindic}',cstCotation,'{$ident}')">
                                <u>
                                  <xsl:value-of select="$valindic"/>
                                </u>
                              </a>&#160;
                            </td>
                            <td class="clFond clWidth285 clAlignLeft">
                              <!--<a href="#nullepart" onClick="requestBDFInfos('37','','{$familyNumber}','{$idrenv}',cstSimpleConfirm);">
                                                              <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                                                          </a>-->
                            </td>
                          </xsl:when>
                          <xsl:otherwise>
                            <td class="clGrasFond clWidth110 clValignMiddle">
                              &#160;
                            </td>
                            <td class="clFond clWidth285">
                              &#160;
                            </td>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:if>
                      <xsl:if test="$Lang='UK'">
                        <td class="clFond clWidth140 clValignMiddle">
                          &#160;
                          <xsl:call-template name="tradlib">
                            <xsl:with-param name="Lang" select="$Lang"/>
                            <xsl:with-param name="codeLib" select="'m00_IdeRen'"/>
                          </xsl:call-template>
                        </td>
                         <td class="clFond clWidth110">
                          &#160;
                          <xsl:call-template name ="displayIdentXsl">
                            <xsl:with-param name ="InputIdent" select ="($idrenv)"/>
                          </xsl:call-template>
                        </td>
                        <xsl:choose>
                          <xsl:when test="$valindic!=''">
                            <td class="clGrasFond clWidth110 clAlignRight clValignMiddle">
                              &#160;
                              <xsl:call-template name="tradlib">
                                <xsl:with-param name="Lang" select="$Lang"/>
                                <xsl:with-param name="codeLib" select="'m00_Indi'"/>
                              </xsl:call-template>
                              <a href="#nullepart" class="clGrasFond" onclick="requestVariousInfos('{$valindic}',cstCotation,'{$ident}')">
                                <u>
                                  <xsl:value-of select="$valindic"/>
                                </u>
                              </a>&#160;
                            </td>
                            <td class="clFond clWidth273 clAlignLeft">
                              <!--<a href="#nullepart" onClick="requestBDFInfos('37','','{$familyNumber}','{$idrenv}',cstSimpleConfirm);">
                                                              <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                                                          </a>-->
                            </td>
                          </xsl:when>
                          <xsl:otherwise>
                            <td class="clGrasFond clWidth110 clValignMiddle">
                              &#160;
                            </td>
                            <td class="clFond clWidth273">
                              &#160;
                            </td>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:if>
                    </xsl:if>
                    <xsl:if test="not($NonResident='NR')">
                      <td class="clFond clWidth128 clValignMiddle">
                        &#160;
                        <xsl:value-of select="$dicoFR/mot[@id='m00_IdeRen']"/>
                      </td>
                       <td class="clFond clWidth110">
                        &#160;<xsl:call-template name ="displayIdentXsl">
                          <xsl:with-param name ="InputIdent" select ="($idrenv)"/>
                        </xsl:call-template>
                      </td>
                      <xsl:choose>
                        <xsl:when test ="$valindic!=''">
                          <td class="clGrasFond clWidth110 clAlignRight clValignMiddle">
                            &#160;
                            <xsl:value-of select="$dicoFR/mot[@id='m00_Indi']"/>
                            <a href="#nullepart" class="clGrasFond" onclick="requestVariousInfos('{$valindic}',cstCotation,'{$ident}')">
                              <u>
                                <xsl:value-of select="$valindic"/>
                              </u>
                            </a>&#160;
                          </td>
                          <td class="clFond clWidth285 clAlignLeft">
                            <a href="#nullepart" onClick="requestBDFInfos('37','','{$familyNumber}','{$idrenv}',cstSimpleConfirm);">
                              <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                            </a>
                          </td>
                        </xsl:when>
                        <xsl:otherwise>
                          <td class="clGrasFond clWidth110 clValignMiddle">
                            &#160;
                          </td>
                          <td class="clFond clWidth285">
                            &#160;
                          </td>
                        </xsl:otherwise>
                      </xsl:choose>

                    </xsl:if>
                  </tr>
                </table>
              </xsl:if>

            </xsl:if>
          </td>
        </tr>
      </table>
    </xsl:if>


    <xsl:if test="((/FIBEN/PERSONNE/MODULE53/PP) | (/FIBEN/PERSONNE/MODULE53/PM53/EI53/IDENTC))">
      <table class="clWidth635 clEnTeteTable clBorderCellpadding1 clHeight34">
         <caption class="visually-hidden">Information sur l'entit interrog</caption>
        <tr>
          <td>
            <table class="clWidth633 clBorderCellpadding1 clHeight17" role="presentation">
              <tr>
                <!-- 1ere ligne identifiant, Nom et Indicateur -->
                <xsl:if test="not($NonResident='NR')">
                  <td class="clGrasFond clWidth128 clValignMiddle">
                    &#160;
                    <xsl:call-template name ="displayIdent2Xsl">
                      <xsl:with-param name ="InputIdent" select ="($ident)"/>
                    </xsl:call-template>
                  </td>
                  <td class="clGrasFond clWidth383 clValignMiddle">
                    &#160;
                    <xsl:value-of select="$nom"/>
                  </td>
                </xsl:if>
                <xsl:if test="$NonResident='NR'">
                  <xsl:if test="$Lang='FR'">
                    <td class="clGrasFond clWidth128 clValignMiddle">
                      &#160;
                      <xsl:call-template name ="displayIdent2Xsl">
                        <xsl:with-param name ="InputIdent" select ="($ident)"/>
                      </xsl:call-template>
                    </td>
                    <td class="clGrasFond clWidth383 clValignMiddle">
                      &#160;
                      <xsl:value-of select="$nom"/>
                    </td>
                  </xsl:if>
                  <xsl:if test="$Lang='UK'">
                    <td class="clGrasFond clWidth145 clValignMiddle">
                      &#160;
                      <xsl:call-template name ="displayIdent2Xsl">
                        <xsl:with-param name ="InputIdent" select ="($ident)"/>
                      </xsl:call-template>
                    </td>
                    <td class="clGrasFond clWidth366 clValignMiddle">
                      &#160;
                      <xsl:value-of select="$nom"/>
                    </td>
                  </xsl:if>
                </xsl:if>
                <xsl:if test ="/FIBEN/PERSONNE/MODULE53/PM53/EI53/IDENTC">
                  <xsl:choose >
                    <xsl:when test ="$valindic!=''">
                      <td class="clGrasFond clWidth122 clAlignRight clValignMiddle">
                        <xsl:if test="$NonResident='NR'">
                          <xsl:call-template name="tradlib">
                            <xsl:with-param name="Lang" select="$Lang"/>
                            <xsl:with-param name="codeLib" select="'m00_Indica'"/>
                          </xsl:call-template>
                        </xsl:if>
                        <xsl:if test="not($NonResident='NR')">
                          <xsl:value-of select="$dicoFR/mot[@id='m00_Indica']"/>
                        </xsl:if>
                        <a href="#nullepart" class="clGrasFond" onclick="requestVariousInfos('{$valindic}',cstCotation,'{$ident}')">
                          <u>
                            <xsl:value-of select="$valindic"/>
                          </u>
                        </a>&#160;
                      </td>
                    </xsl:when>
                    <xsl:otherwise>
                      <td class="clGrasFond clWidth122 clAlignRight clValignMiddle">
                        &#160;
                      </td>
                    </xsl:otherwise>
                  </xsl:choose>

                </xsl:if>
                <xsl:if test ="/FIBEN/PERSONNE/MODULE53/PP">
                  <xsl:choose >
                    <xsl:when test ="$valcot!=''">
                      <td class="clGrasFond clWidth122 clAlignRight clValignMiddle">
                        <xsl:if test="$NonResident='NR'">
                          <xsl:call-template name="tradlib">
                            <xsl:with-param name="Lang" select="$Lang"/>
                            <xsl:with-param name="codeLib" select="'m00_Indica'"/>
                          </xsl:call-template>
                        </xsl:if>
                        <xsl:if test="not($NonResident='NR')">
                          <xsl:value-of select="$dicoFR/mot[@id='m00_Indica']"/>
                        </xsl:if>
                        <a href="#nullepart" class="clGrasFond" onclick="requestVariousInfos('{$valcot}',cstCotation,'{$ident}')">
                          <u>
                            <xsl:value-of select="$valcot"/>
                          </u>
                        </a>&#160;
                      </td>
                    </xsl:when>
                    <xsl:otherwise>
                      <td class="clGrasFond clWidth122 clAlignRight clValignMiddle">
                        &#160;
                      </td>
                    </xsl:otherwise>
                  </xsl:choose>

                </xsl:if>
              </tr>
              <!-- pas de nom marital et pas d'identifiant de renvoi ==> 2eme ligne vide -->
              <xsl:if test="not($idrenv) and not($nomconj)">
                <xsl:choose>
                  <xsl:when test ="$NonResident='NR'">
                    <xsl:choose>
                      <xsl:when test ="$Lang='FR'">
                        <tr>
                          <td class="clGrasFond clWidth128 clValignMiddle">
                            &#160;
                          </td>
                          <td class="clGrasFond clWidth383 clValignMiddle">
                            &#160;
                          </td>
                          <td class="clGrasFond clWidth122 clAlignRight clValignMiddle">
                            &#160;
                          </td>
                        </tr>
                      </xsl:when>
                      <xsl:otherwise>
                        <tr>
                          <td class="clGrasFond clWidth145 clValignMiddle">
                            &#160;
                          </td>
                          <td class="clGrasFond clWidth366 clValignMiddle">
                            &#160;
                          </td>
                          <td class="clGrasFond clWidth122 clAlignRight clValignMiddle">
                            &#160;
                          </td>
                        </tr>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:otherwise>
                    <tr>
                      <td class="clGrasFond clWidth128 clValignMiddle">
                        &#160;
                      </td>
                      <td class="clGrasFond clWidth383 clValignMiddle">
                        &#160;
                      </td>
                      <td class="clGrasFond clWidth122 clAlignRight clValignMiddle">
                        &#160;
                      </td>
                    </tr>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:if>
            </table>

            <!-- 2eme ligne avec le nom marital -->
            <xsl:if test="$nomconj!=''">
              <table class="clWidth633 clBorderCellpadding1 clHeight17" role="presentation">
                <tr>
                  <xsl:if test="$NonResident='NR'">
                    <xsl:if test="$Lang='FR'">
                      <td class="clFond clWidth128 clValignMiddle">
                        &#160;
                        <xsl:call-template name="tradlib">
                          <xsl:with-param name="Lang" select="$Lang"/>
                          <xsl:with-param name="codeLib" select="'m00_Conjoi'"/>
                        </xsl:call-template>
                      </td>
                      <td class="clFond clWidth505 clAlignLeft">
                        &#160;
                        <xsl:value-of select="$nomconj"/>
                      </td>
                    </xsl:if>
                    <xsl:if test="$Lang='UK'">
                      <td class="clFond clWidth140 clValignMiddle">
                        &#160;
                        <xsl:call-template name="tradlib">
                          <xsl:with-param name="Lang" select="$Lang"/>
                          <xsl:with-param name="codeLib" select="'m00_Conjoi'"/>
                        </xsl:call-template>
                      </td>
                      <td class="clFond clWidth493 clAlignLeft">
                        &#160;
                        <xsl:value-of select="$nomconj"/>
                      </td>
                    </xsl:if>
                  </xsl:if>
                  <xsl:if test="not($NonResident='NR')">
                    <td class="clFond clWidth128 clValignMiddle">
                      &#160;
                      <xsl:value-of select="$dicoFR/mot[@id='m00_Conjoi']"/>
                    </td>
                    <td class="clFond clWidth505 clAlignLeft">
                      &#160;
                      <xsl:value-of select="$nomconj"/>
                    </td>
                  </xsl:if>
                </tr>
              </table >
            </xsl:if>
            <!-- 3eme ligne identifiant de renvoi (ou 2eme ligne si pas de nom marital)-->
            <xsl:if test="$idrenv !=''">
              <table class="clWidth633 clBorderCellpadding1 clHeight17" role="presentation">
                <tr>
                  <xsl:if test="$NonResident='NR'">
                    <xsl:if test="$Lang='FR'">
                      <td class="clFond clWidth128 clValignMiddle">
                        &#160;
                        <xsl:call-template name="tradlib">
                          <xsl:with-param name="Lang" select="$Lang"/>
                          <xsl:with-param name="codeLib" select="'m00_IdeRen'"/>
                        </xsl:call-template>
                      </td>
                       <td class="clFond clWidth110">
                        &#160;
                        <xsl:call-template name ="displayIdentXsl">
                          <xsl:with-param name ="InputIdent" select ="($idrenv)"/>
                        </xsl:call-template>
                      </td>
                      <xsl:choose >
                        <xsl:when test ="$valcot!=''">
                          <td class="clGrasFond clWidth110 clAlignRight clValignMiddle">
                            &#160;
                            <xsl:call-template name="tradlib">
                              <xsl:with-param name="Lang" select="$Lang"/>
                              <xsl:with-param name="codeLib" select="'m00_Cota'"/>
                            </xsl:call-template>
                            <a href="#nullepart" class="clGrasFond" onclick="requestVariousInfos('{$valcot}',cstCotation,'{$ident}')">
                              <u>
                                <xsl:value-of select="$valcot"/>
                              </u>
                            </a>&#160;
                          </td>
                          <td class="clFond clWidth285 clAlignLeft">
                            <!--<a href="#nullepart" onClick="requestBDFInfos('37','','{$familyNumber}','{$idrenv}',cstSimpleConfirm);">
                                                          <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                                                      </a>-->
                          </td>
                        </xsl:when>
                        <xsl:otherwise>
                          <td class="clGrasFond clWidth110 clAlignRight clValignMiddle">
                            &#160;
                          </td>
                          <td class="clFond clWidth285">
                            &#160;
                          </td>
                        </xsl:otherwise>
                      </xsl:choose>
                    </xsl:if>
                    <xsl:if test="$Lang='UK'">
                      <td class="clFond clWidth140 clValignMiddle">
                        &#160;
                        <xsl:call-template name="tradlib">
                          <xsl:with-param name="Lang" select="$Lang"/>
                          <xsl:with-param name="codeLib" select="'m00_IdeRen'"/>
                        </xsl:call-template>
                      </td>
                      <td class="clFond clWidth110" colspan="2">
                        &#160;
                        <xsl:call-template name ="displayIdentXsl">
                          <xsl:with-param name ="InputIdent" select ="($idrenv)"/>
                        </xsl:call-template>
                      </td>
                      <xsl:choose>
                        <xsl:when test ="$valcot!=''">
                          <td class="clGrasFond clWidth110 clAlignRight clValignMiddle">
                            &#160;
                            <xsl:call-template name="tradlib">
                              <xsl:with-param name="Lang" select="$Lang"/>
                              <xsl:with-param name="codeLib" select="'m00_Cota'"/>
                            </xsl:call-template>
                            <a href="#nullepart" class="clGrasFond" onclick="requestVariousInfos('{$valcot}',cstCotation,'{$ident}')">
                              <u>
                                <xsl:value-of select="$valcot"/>
                              </u>
                            </a>&#160;
                          </td>
                          <td class="clFond clWidth273 clAlignLeft">
                            <!--<a href="#nullepart" onClick="requestBDFInfos('37','','{$familyNumber}','{$idrenv}',cstSimpleConfirm);">
                                                          <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                                                      </a>-->
                          </td>
                        </xsl:when>
                        <xsl:otherwise>
                          <td class="clGrasFond clWidth110 clAlignRight clValignMiddle">
                            &#160;
                          </td>
                          <td class="clFond clWidth273">
                            &#160;
                          </td>
                        </xsl:otherwise>
                      </xsl:choose>
                    </xsl:if>
                  </xsl:if>

                  <xsl:if test="not($NonResident='NR')">
                    <td class="clFond clWidth128 clValignMiddle">
                      &#160;
                      <xsl:value-of select="$dicoFR/mot[@id='m00_IdeRen']"/>
                    </td>
                     <td class="clFond clWidth110">
                      &#160;
                      <xsl:call-template name ="displayIdentXsl">
                        <xsl:with-param name ="InputIdent" select ="($idrenv)"/>
                      </xsl:call-template>
                    </td>
                    <xsl:choose>
                      <xsl:when test ="$valcot!=''">
                        <td class="clGrasFond clWidth110 clAlignRight clValignMiddle">
                          &#160;
                          <xsl:value-of select="$dicoFR/mot[@id='m00_Cota']"/>
                          <a href="#nullepart" class="clGrasFond" onclick="requestVariousInfos('{$valcot}',cstCotation,'{$ident}')">
                            <u>
                              <xsl:value-of select="$valcot"/>
                            </u>
                          </a>&#160;
                        </td>
                        <td class="clFond clWidth285 clAlignLeft">
                          <a href="#nullepart" onClick="requestBDFInfos('37','','{$familyNumber}','{$idrenv}',cstSimpleConfirm);">
                            <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                          </a>
                        </td>
                      </xsl:when>
                      <xsl:otherwise>
                        <td class="clGrasFond clWidth110 clAlignRight clValignMiddle">
                          &#160;
                        </td>
                        <td class="clFond clWidth285">
                          &#160;
                        </td>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:if>
                </tr>
              </table>
            </xsl:if>
          </td>
        </tr>
      </table>
    </xsl:if>

    <!-- ********************************************************************-->

    <xsl:if test="(/FIBEN/PERSONNE/MODULE37/PM37)">
      <table class="clWidth635 clEnTeteTable clBorderCellpadding1 clHeight34">
        <caption class="visually-hidden">Information sur l'entit interrog</caption>
        <tr>
          <td>
            <table class="clWidth633 clBorderCellpadding1 clHeight17" role="presentation">
              <tr>
                <xsl:if test="not($NonResident='NR')">
                  <td class="clGrasFond clWidth128 clValignMiddle">
                    &#160;<xsl:call-template name ="displayIdent2Xsl">
                      <xsl:with-param name ="InputIdent" select ="($ident)"/>
                    </xsl:call-template>
                  </td>
                  <td class="clGrasFond Width380 clValignMiddle">
                    &#160;<xsl:value-of select="$nom"/>
                  </td>
                </xsl:if>
                <xsl:if test="$NonResident='NR'">
                  <xsl:if test="$Lang='FR'">
                    <td class="clGrasFond clWidth128 clValignMiddle">
                      &#160;<xsl:call-template name ="displayIdent2Xsl">
                        <xsl:with-param name ="InputIdent" select ="($ident)"/>
                      </xsl:call-template>
                    </td>
                    <td class="clGrasFond Width380 clValignMiddle">
                      &#160;<xsl:value-of select="$nom"/>
                    </td>
                  </xsl:if>
                  <xsl:if test="$Lang='UK'">
                    <td class="clGrasFond clWidth145 clValignMiddle">
                      &#160;<xsl:call-template name ="displayIdent2Xsl">
                        <xsl:with-param name ="InputIdent" select ="($ident)"/>
                      </xsl:call-template>
                    </td>
                    <td class="clGrasFond clValignMiddle">
                      &#160;<xsl:value-of select="$nom"/>
                    </td>
                  </xsl:if>
                </xsl:if>
                <xsl:if test="$valcot!=''">
                  <td class="clGrasFond clValignMiddle clAlignRight" colspan="2">
                    <xsl:if test="$NonResident='NR'">
                      <xsl:call-template name="tradlib">
                        <xsl:with-param name="Lang" select="$Lang"/>
                        <xsl:with-param name="codeLib" select="'m00_Cot'"/>
                      </xsl:call-template>
                    </xsl:if>
                    <xsl:if test="not($NonResident='NR')">
                      <xsl:value-of select="$dicoFR/mot[@id='m00_Cot']"/>
                    </xsl:if>
                    <xsl:value-of select="$valcot"/>
                  </td>
                </xsl:if>
                <xsl:if test="$valcot=''">
                  <td class="clGrasFond clValignMiddle clAlignRight" colspan="2">
                    &#160;
                  </td>
                </xsl:if>
              </tr>
            </table>
            <table class="clWidth633 clBorderCellpadding1 clHeight17" role="presentation">
              <tr>
                <xsl:if test="$nomconj!=''">
                  <xsl:if test="$NonResident='NR'">
                    <xsl:if test="$Lang='FR'">
                      <td class="clFond clWidth128 clValignMiddle">
                        &#160;
                        <xsl:call-template name="tradlib">
                          <xsl:with-param name="Lang" select="$Lang"/>
                          <xsl:with-param name="codeLib" select="'m00_Conjoi'"/>
                        </xsl:call-template>
                      </td>
                      <td class="clFond clWidth237" colspan="2">
                        &#160;<xsl:value-of select="$nomconj"/>
                      </td>
                    </xsl:if>
                    <xsl:if test="$Lang='UK'">
                      <td class="clFond clWidth140 clValignMiddle">
                        &#160;
                        <xsl:call-template name="tradlib">
                          <xsl:with-param name="Lang" select="$Lang"/>
                          <xsl:with-param name="codeLib" select="'m00_Conjoi'"/>
                        </xsl:call-template>
                      </td>
                      <td class="clFond clWidth225" colspan="2">
                        &#160;<xsl:value-of select="$nomconj"/>
                      </td>
                    </xsl:if>
                  </xsl:if>
                  <xsl:if test="not($NonResident='NR')">
                    <td class="clFond clWidth128 clValignMiddle">
                      &#160;
                      <xsl:value-of select="$dicoFR/mot[@id='m00_Conjoi']"/>
                    </td>
                    <td class="clFond clWidth237" colspan="2">
                      &#160;<xsl:value-of select="$nomconj"/>
                    </td>
                  </xsl:if>
                </xsl:if>
                <xsl:if test="$idrenv and (not($nomconj)or $nomconj='')">
                  <xsl:if test="$NonResident='NR'">
                    <xsl:if test="$Lang='FR'">
                      <td class="clFond clWidth128 clValignMiddle">
                        &#160;
                        <xsl:call-template name="tradlib">
                          <xsl:with-param name="Lang" select="$Lang"/>
                          <xsl:with-param name="codeLib" select="'m00_IdeRen'"/>
                        </xsl:call-template>
                      </td>
                      <td class="clFond clWidth237" colspan="2">
                        &#160;<xsl:call-template name ="displayIdentXsl">
                          <xsl:with-param name ="InputIdent" select ="($idrenv)"/>
                        </xsl:call-template>
                      </td>
                    </xsl:if>
                    <xsl:if test="$Lang='UK'">
                      <td class="clFond clWidth140 clValignMiddle">
                        &#160;
                        <xsl:call-template name="tradlib">
                          <xsl:with-param name="Lang" select="$Lang"/>
                          <xsl:with-param name="codeLib" select="'m00_IdeRen'"/>
                        </xsl:call-template>
                      </td>
                      <td class="clFond clWidth225" colspan="2">
                        &#160;<xsl:call-template name ="displayIdentXsl">
                          <xsl:with-param name ="InputIdent" select ="($idrenv)"/>
                        </xsl:call-template>
                      </td>
                    </xsl:if>
                  </xsl:if>
                  <xsl:if test="not($NonResident='NR')">
                    <td class="clFond clWidth128 clValignMiddle">
                      <xsl:value-of select="$dicoFR/mot[@id='m00_IdeRen']"/>
                    </td>
                    <td class="clFond clWidth237" colspan="2">
                      &#160;<xsl:call-template name ="displayIdentXsl">
                        <xsl:with-param name ="InputIdent" select ="($idrenv)"/>
                      </xsl:call-template>
                    </td>
                  </xsl:if>
                </xsl:if>
                <xsl:if test="$idrenv or $nomconj!=''">
                  <td class="clFond clWidth268 clAlignRight">
                    &#160;
                    <xsl:if test="$datcot">
                      <xsl:if test="$NonResident='NR'">
                        <xsl:call-template name="tradlib">
                          <xsl:with-param name="Lang" select="$Lang"/>
                          <xsl:with-param name="codeLib" select="'m00_DepLe'"/>
                        </xsl:call-template>
                      </xsl:if>
                      <xsl:if test="not($NonResident='NR')">
                        <xsl:value-of select="$dicoFR/mot[@id='m00_DepLe']"/>
                      </xsl:if>
                      <xsl:call-template name ="displayDateXsl">
                        <xsl:with-param name ="InputDate" select ="($datcot)"/>
                      </xsl:call-template>
                      <xsl:if test="$datexa!=''">
                        <xsl:if test="$NonResident='NR'">
                          <xsl:call-template name="tradlib">
                            <xsl:with-param name="Lang" select="$Lang"/>
                            <xsl:with-param name="codeLib" select="'m00_RevLe'"/>
                          </xsl:call-template>
                        </xsl:if>
                        <xsl:if test="not($NonResident='NR')">
                          <xsl:value-of select="$dicoFR/mot[@id='m00_RevLe']"/>
                        </xsl:if>
                        <xsl:call-template name ="displayDateXsl">
                          <xsl:with-param name ="InputDate" select ="($datexa)"/>
                        </xsl:call-template>)
                      </xsl:if>
                    </xsl:if>
                  </td>
                </xsl:if>
                <xsl:if test="not($idrenv) and (not($nomconj)or$nomconj='')">
                  <td class="clFond clWidth128">&#160;</td>
                  <td class="clFond clWidth505 clAlignRight" colspan="3">
                    &#160;
                    <xsl:if test="$datcot!=''">
                      <xsl:if test="$NonResident='NR'">
                        <xsl:call-template name="tradlib">
                          <xsl:with-param name="Lang" select="$Lang"/>
                          <xsl:with-param name="codeLib" select="'m00_DepLe'"/>
                        </xsl:call-template>
                      </xsl:if>
                      <xsl:if test="not($NonResident='NR')">
                        <xsl:value-of select="$dicoFR/mot[@id='m00_DepLe']"/>
                      </xsl:if>
                      <xsl:call-template name ="displayDateXsl">
                        <xsl:with-param name ="InputDate" select ="($datcot)"/>
                      </xsl:call-template>
                      <xsl:if test="$datexa!=''">

                        <xsl:if test="$NonResident='NR'">
                          <xsl:call-template name="tradlib">
                            <xsl:with-param name="Lang" select="$Lang"/>
                            <xsl:with-param name="codeLib" select="'m00_RevLe'"/>
                          </xsl:call-template>
                        </xsl:if>
                        <xsl:if test="not($NonResident='NR')">
                          <xsl:value-of select="$dicoFR/mot[@id='m00_RevLe']"/>
                        </xsl:if>
                        <xsl:call-template name ="displayDateXsl">
                          <xsl:with-param name ="InputDate" select ="($datexa)"/>
                        </xsl:call-template>)
                      </xsl:if>
                    </xsl:if>
                  </td>
                </xsl:if>
              </tr>
            </table>
            <xsl:if test="$idrenv and $nomconj!=''">
              <table class="clWidth633 clBorderCellpadding1 clHeight17" role="presentation">
                <tr>
                  <xsl:if test="$NonResident='NR'">
                    <td class="clFond clWidth158 clValignMiddle">
                      &#160;
                      <xsl:call-template name="tradlib">
                        <xsl:with-param name="Lang" select="$Lang"/>
                        <xsl:with-param name="codeLib" select="'m00_IdeRen'"/>
                      </xsl:call-template>
                    </td>
                    <td class="clFond clWidth115" colspan="2">
                      &#160;<xsl:call-template name ="displayIdentXsl">
                        <xsl:with-param name ="InputIdent" select ="($idrenv)"/>
                      </xsl:call-template>
                    </td>
                    <td class="clFond clWidth360 clAlignLeft">
                      <!--<a href="#nullepart" onClick="requestBDFInfos('37','','{$familyNumber}','{$idrenv}',cstSimpleConfirm);">
                        <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                      </a>-->
                    </td>
                  </xsl:if>
                  <xsl:if test="not($NonResident='NR')">
                    <td class="clFond clWidth128 clValignMiddle">
                      &#160;
                      <xsl:value-of select="$dicoFR/mot[@id='m00_IdeRen']"/>
                    </td>
                    <td class="clFond clWidth125" colspan="2">
                      &#160;<xsl:call-template name ="displayIdentXsl">
                        <xsl:with-param name ="InputIdent" select ="($idrenv)"/>
                      </xsl:call-template>
                    </td>
                    <td class="clFond clWidth380 clAlignLeft">
                      <a href="#nullepart" onClick="requestBDFInfos('37','','{$familyNumber}','{$idrenv}',cstSimpleConfirm);">
                        <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                      </a>
                    </td>
                  </xsl:if>
                </tr>
              </table>
            </xsl:if>
          </td>
        </tr>
      </table>
    </xsl:if>

    <xsl:if test="(/FIBEN/PERSONNE/MODULE37/PP37 | /FIBEN/PERSONNE/MODULE37/PPEI37)">
      <table class="clWidth635 clEnTeteTable clBorderCellpadding1 clHeight34">
        <caption class="visually-hidden">Information sur l'entit interrog</caption>
        <tr>
          <td>
            <table class="clWidth633 clBorderCellpadding1 clHeight17" role="presentation">
              <tr>
                <xsl:if test="not($NonResident='NR')">
                  <td class="clGrasFond clWidth128 clValignMiddle">
                    &#160;<xsl:call-template name ="displayIdent2Xsl">
                      <xsl:with-param name ="InputIdent" select ="($ident)"/>
                    </xsl:call-template>
                  </td>
                  <td class="clGrasFond Width380 clValignMiddle">
                    &#160;<xsl:value-of select="$nom"/>
                  </td>
                </xsl:if>
                <xsl:if test="$NonResident='NR'">
                  <xsl:if test="$Lang='FR'">
                    <td class="clGrasFond clWidth128 clValignMiddle">
                      &#160;<xsl:call-template name ="displayIdent2Xsl">
                        <xsl:with-param name ="InputIdent" select ="($ident)"/>
                      </xsl:call-template>
                    </td>
                    <td class="clGrasFond Width380 clValignMiddle">
                      &#160;<xsl:value-of select="$nom"/>
                    </td>
                  </xsl:if>
                  <xsl:if test="$Lang='UK'">
                    <td class="clGrasFond clWidth145 clValignMiddle">
                      &#160;<xsl:call-template name ="displayIdent2Xsl">
                        <xsl:with-param name ="InputIdent" select ="($ident)"/>
                      </xsl:call-template>
                    </td>
                    <td class="clGrasFond clValignMiddle">
                      &#160;<xsl:value-of select="$nom"/>
                    </td>
                  </xsl:if>
                </xsl:if>
                <xsl:if test="$valcot!=''">
                  <td class="clGrasFond clValignMiddle clAlignRight" colspan="2">
                    <xsl:if test="$NonResident='NR'">
                      <xsl:call-template name="tradlib">
                        <xsl:with-param name="Lang" select="$Lang"/>
                        <xsl:with-param name="codeLib" select="'m00_Indica'"/>
                      </xsl:call-template>
                    </xsl:if>
                    <xsl:if test="not($NonResident='NR')">
                      <xsl:value-of select="$dicoFR/mot[@id='m00_Indica']"/>
                    </xsl:if>
                    <xsl:value-of select="$valcot"/>
                  </td>
                </xsl:if>
                <xsl:if test="$valcot=''">
                  <td class="clGrasFond clValignMiddle clAlignRight" colspan="2">
                    &#160;
                  </td>
                </xsl:if>
              </tr>
            </table>
            <table class="clWidth633 clBorderCellpadding1 clHeight17" role="presentation">
              <tr>
                <xsl:if test="$nomconj!=''">
                  <xsl:if test="$NonResident='NR'">
                    <xsl:if test="$Lang='FR'">
                      <td class="clFond clWidth128 clValignMiddle">
                        &#160;
                        <xsl:call-template name="tradlib">
                          <xsl:with-param name="Lang" select="$Lang"/>
                          <xsl:with-param name="codeLib" select="'m00_Conjoi'"/>
                        </xsl:call-template>
                      </td>
                      <td class="clFond clWidth237" colspan="2">
                        &#160;<xsl:value-of select="$nomconj"/>
                      </td>
                    </xsl:if>
                    <xsl:if test="$Lang='UK'">
                      <td class="clFond clWidth140 clValignMiddle">
                        &#160;
                        <xsl:call-template name="tradlib">
                          <xsl:with-param name="Lang" select="$Lang"/>
                          <xsl:with-param name="codeLib" select="'m00_Conjoi'"/>
                        </xsl:call-template>
                      </td>
                      <td class="clFond clWidth225" colspan="2">
                        &#160;<xsl:value-of select="$nomconj"/>
                      </td>
                    </xsl:if>
                  </xsl:if>
                  <xsl:if test="not($NonResident='NR')">
                    <td class="clFond clWidth128 clValignMiddle">
                      &#160;
                      <xsl:value-of select="$dicoFR/mot[@id='m00_Conjoi']"/>
                    </td>
                    <td class="clFond clWidth237" colspan="2">
                      &#160;<xsl:value-of select="$nomconj"/>
                    </td>
                  </xsl:if>
                </xsl:if>
                <xsl:if test="$idrenv and (not($nomconj)or $nomconj='')">
                  <xsl:if test="$NonResident='NR'">
                    <xsl:if test="$Lang='FR'">
                      <td class="clFond clWidth128 clValignMiddle">
                        &#160;
                        <xsl:call-template name="tradlib">
                          <xsl:with-param name="Lang" select="$Lang"/>
                          <xsl:with-param name="codeLib" select="'m00_IdeRen'"/>
                        </xsl:call-template>
                      </td>
                      <td class="clFond clWidth237" colspan="2">
                        &#160;<xsl:call-template name ="displayIdentXsl">
                          <xsl:with-param name ="InputIdent" select ="($idrenv)"/>
                        </xsl:call-template>
                      </td>
                    </xsl:if>
                    <xsl:if test="$Lang='UK'">
                      <td class="clFond clWidth140 clValignMiddle">
                        &#160;
                        <xsl:call-template name="tradlib">
                          <xsl:with-param name="Lang" select="$Lang"/>
                          <xsl:with-param name="codeLib" select="'m00_IdeRen'"/>
                        </xsl:call-template>
                      </td>
                      <td class="clFond clWidth225" colspan="2">
                        &#160;<xsl:call-template name ="displayIdentXsl">
                          <xsl:with-param name ="InputIdent" select ="($idrenv)"/>
                        </xsl:call-template>
                      </td>
                    </xsl:if>
                  </xsl:if>
                  <xsl:if test="not($NonResident='NR')">
                    <td class="clFond clWidth128 clValignMiddle">
                      <xsl:value-of select="$dicoFR/mot[@id='m00_IdeRen']"/>
                    </td>
                    <td class="clFond clWidth237" colspan="2">
                      &#160;<xsl:call-template name ="displayIdentXsl">
                        <xsl:with-param name ="InputIdent" select ="($idrenv)"/>
                      </xsl:call-template>
                    </td>
                  </xsl:if>
                </xsl:if>
                <xsl:if test="$idrenv or $nomconj!=''">
                  <td class="clFond clWidth268 clAlignRight">
                    &#160;
                    <xsl:if test="$datcot">
                      <xsl:if test="$NonResident='NR'">
                        <xsl:call-template name="tradlib">
                          <xsl:with-param name="Lang" select="$Lang"/>
                          <xsl:with-param name="codeLib" select="'m00_DepLe'"/>
                        </xsl:call-template>
                      </xsl:if>
                      <xsl:if test="not($NonResident='NR')">
                        <xsl:value-of select="$dicoFR/mot[@id='m00_DepLe']"/>
                      </xsl:if>
                      <xsl:call-template name ="displayDateXsl">
                        <xsl:with-param name ="InputDate" select ="($datcot)"/>
                      </xsl:call-template>
                      <xsl:if test="$datexa!=''">
                        <xsl:if test="$NonResident='NR'">
                          <xsl:call-template name="tradlib">
                            <xsl:with-param name="Lang" select="$Lang"/>
                            <xsl:with-param name="codeLib" select="'m00_RevLe'"/>
                          </xsl:call-template>
                        </xsl:if>
                        <xsl:if test="not($NonResident='NR')">
                          <xsl:value-of select="$dicoFR/mot[@id='m00_RevLe']"/>
                        </xsl:if>
                        <xsl:call-template name ="displayDateXsl">
                          <xsl:with-param name ="InputDate" select ="($datexa)"/>
                        </xsl:call-template>)
                      </xsl:if>
                    </xsl:if>
                  </td>
                </xsl:if>
                <xsl:if test="not($idrenv) and (not($nomconj)or$nomconj='')">
                  <td class="clFond clWidth128">&#160;</td>
                  <td class="clFond clWidth505 clAlignRight" colspan="3">
                    &#160;
                    <xsl:if test="$datcot!=''">
                      <xsl:if test="$NonResident='NR'">
                        <xsl:call-template name="tradlib">
                          <xsl:with-param name="Lang" select="$Lang"/>
                          <xsl:with-param name="codeLib" select="'m00_DepLe'"/>
                        </xsl:call-template>
                      </xsl:if>
                      <xsl:if test="not($NonResident='NR')">
                        <xsl:value-of select="$dicoFR/mot[@id='m00_DepLe']"/>
                      </xsl:if>
                      <xsl:call-template name ="displayDateXsl">
                        <xsl:with-param name ="InputDate" select ="($datcot)"/>
                      </xsl:call-template>
                      <xsl:if test="$datexa!=''">

                        <xsl:if test="$NonResident='NR'">
                          <xsl:call-template name="tradlib">
                            <xsl:with-param name="Lang" select="$Lang"/>
                            <xsl:with-param name="codeLib" select="'m00_RevLe'"/>
                          </xsl:call-template>
                        </xsl:if>
                        <xsl:if test="not($NonResident='NR')">
                          <xsl:value-of select="$dicoFR/mot[@id='m00_RevLe']"/>
                        </xsl:if>
                        <xsl:call-template name ="displayDateXsl">
                          <xsl:with-param name ="InputDate" select ="($datexa)"/>
                        </xsl:call-template>)
                      </xsl:if>
                    </xsl:if>
                  </td>
                </xsl:if>
              </tr>
            </table>
            <xsl:if test="$idrenv and $nomconj!=''">
              <table class="clWidth633 clBorderCellpadding1 clHeight17" role="presentation">
                <tr>
                  <xsl:if test="$NonResident='NR'">
                    <td class="clFond clWidth158 clValignMiddle">
                      &#160;
                      <xsl:call-template name="tradlib">
                        <xsl:with-param name="Lang" select="$Lang"/>
                        <xsl:with-param name="codeLib" select="'m00_IdeRen'"/>
                      </xsl:call-template>
                    </td>
                    <td class="clFond clWidth115" colspan="2">
                      &#160;<xsl:call-template name ="displayIdentXsl">
                        <xsl:with-param name ="InputIdent" select ="($idrenv)"/>
                      </xsl:call-template>
                    </td>
                    <td class="clFond clWidth360 clAlignLeft">
                      <!--<a href="#nullepart" onClick="requestBDFInfos('37','','{$familyNumber}','{$idrenv}',cstSimpleConfirm);">
                        <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                      </a>-->
                    </td>
                  </xsl:if>
                  <xsl:if test="not($NonResident='NR')">
                    <td class="clFond clWidth128 clValignMiddle">
                      &#160;
                      <xsl:value-of select="$dicoFR/mot[@id='m00_IdeRen']"/>
                    </td>
                    <td class="clFond clWidth115" colspan="2">
                      &#160;<xsl:call-template name ="displayIdentXsl">
                        <xsl:with-param name ="InputIdent" select ="($idrenv)"/>
                      </xsl:call-template>
                    </td>
                    <td class="clFond clWidth390 clAlignLeft">
                      <a href="#nullepart" onClick="requestBDFInfos('37','','{$familyNumber}','{$idrenv}',cstSimpleConfirm);">
                        <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                      </a>
                    </td>
                  </xsl:if>
                </tr>
              </table>
            </xsl:if>
          </td>
        </tr>
      </table>
    </xsl:if>

    <xsl:if test="not(/FIBEN/PERSONNE/MODULE37|/FIBEN/PERSONNE/MODULE39/DIFF39|/FIBEN/PERSONNE/MODULE53)">
      <xsl:if test="(not($valcot='J0' or $valcot='K0' or $valcot='L0' or $valcot='M0' or $valcot='X0') or $segment='')">

        <table class="clWidth635 clEnTeteTable clBorderCellpadding1 clHeight34">
          <caption class="visually-hidden">Information sur l'entit interrog</caption>
          <tr>
            <td>
              <table class="clWidth633 clHeight17 clBorderCell">
                <tr>
                  <xsl:if test="not($NonResident='NR')">
                    <td class="clGrasFond clWidth129 clValignMiddle clBoxSizing">
                      &#160;<xsl:call-template name ="displayIdent2Xsl">
                        <xsl:with-param name ="InputIdent" select ="($ident)"/>
                      </xsl:call-template>
                    </td>
                    <td class="clGrasFond clWidth404 clValignMiddle clBoxSizing" colspan="2">
                     &#160;<xsl:value-of select="$nom"/>
                    </td>
                  </xsl:if>
                  <xsl:if test="$NonResident='NR'">
                    <xsl:if test="$Lang='FR'">
                      <td class="clGrasFond clWidth129 clValignMiddle clBoxSizing">
                        &#160;<xsl:call-template name ="displayIdent2Xsl">
                          <xsl:with-param name ="InputIdent" select ="($ident)"/>
                        </xsl:call-template>
                      </td>
                      <td class="clGrasFond clWidth404 clValignMiddle clBoxSizing" colspan="2">
                        &#160;<xsl:value-of select="$nom"/>
                      </td>
                    </xsl:if>
                    <xsl:if test="$Lang='UK'">
                      <td class="clGrasFond clWidth145 clValignMiddle clBoxSizing">
                        &#160;<xsl:call-template name ="displayIdent2Xsl">
                          <xsl:with-param name ="InputIdent" select ="($ident)"/>
                        </xsl:call-template>
                      </td>
                      <td class="clGrasFond clValignMiddle clBoxSizing" colspan="2">
                        &#160;<xsl:value-of select="$nom"/>
                      </td>
                    </xsl:if>
                  </xsl:if>
                  <td class="clGrasFond clWidth102 clAlignRight clValignMiddle clBoxSizing">
                    &#160;

                    <!--***********************bandeau-->
                    <xsl:if  test="not((/FIBEN/PERSONNE/MODULE20)|(/FIBEN/PERSONNE/MODULE27/PM27/EI27)|(/FIBEN/PERSONNE/MODULE27/PP)|(/FIBEN/PERSONNE/MODULE37)|(/FIBEN/PERSONNE/MODULE56)|(/FIBEN/PERSONNE/MODULEDE/EIPP))">
                      <xsl:if test="not($valcot='NS')">
                        <!-- Cas du module 27, EJ Non rsident : Masque la cotation -->
                        <xsl:if test="$valcot and /FIBEN/@MODDEM!=20 and /FIBEN/@MODDEM!=37 and not(/FIBEN/@GRAPHE)">
                          <xsl:if test="$NonResident='NR'">
                            <xsl:call-template name="tradlib">
                              <xsl:with-param name="Lang" select="$Lang"/>
                              <xsl:with-param name="codeLib" select="'m00_Cot'"/>
                            </xsl:call-template>
                          </xsl:if>
                          <xsl:if test="not($NonResident='NR')">
                            <xsl:value-of select="$dicoFR/mot[@id='m00_Cot']"/>
                          </xsl:if>
                          <xsl:choose>
                            <xsl:when test ="/FIBEN/PERSONNE/MODULEDE|/FIBEN/PERSONNE/MODULEAN">
                              <xsl:value-of select="$valcot"/>
                            </xsl:when>
                            <xsl:otherwise>
                              <xsl:if test="$valcot='ND'">
                                <a href="#nullepart" class="clGrasFond" onclick="requestVariousInfos('{$valcot}',cstCotationNonDif,'{$ident}')">
                                  <u>
                                    <xsl:value-of select="$valcot"/>
                                  </u>
                                </a>&#160;
                              </xsl:if>
                              <xsl:if test="not($valcot='ND')">
                                <a href="#nullepart" class="clGrasFond" onclick="requestVariousInfos('{$valcot}',cstCotation,'{$ident}')">
                                  <u>
                                    <xsl:value-of select="$valcot"/>
                                  </u>
                                </a>&#160;
                              </xsl:if>
                            </xsl:otherwise>
                          </xsl:choose>
                        </xsl:if>
                      </xsl:if>
                      <xsl:if test="$valcot and (/FIBEN/@MODDEM=20 or /FIBEN/@MODDEM=37 or boolean(/FIBEN/@GRAPHE))">
                        <xsl:if test="$NonResident='NR'">
                          <xsl:call-template name="tradlib">
                            <xsl:with-param name="Lang" select="$Lang"/>
                            <xsl:with-param name="codeLib" select="'m00_Cot'"/>
                          </xsl:call-template>
                        </xsl:if>
                        <xsl:if test="not($NonResident='NR')">
                          <xsl:value-of select="$dicoFR/mot[@id='m00_Cot']"/>
                        </xsl:if>
                        <xsl:value-of select="$valcot"/>&#160;
                      </xsl:if>
                    </xsl:if>
                    <xsl:if  test="((/FIBEN/PERSONNE/MODULE20/EJ)|(/FIBEN/PERSONNE/MODULE27/PM27/EI27/IDENTS)|(/FIBEN/PERSONNE/MODULE37/PM37)|(/FIBEN/PERSONNE/MODULE56/PM56/EJ)|(/FIBEN/PERSONNE/MODULEDE/EIPP/IDENTS))">
                      <xsl:if test="not($valcot='NS')">
                        <xsl:if test="$valcot and /FIBEN/@MODDEM!=20 and /FIBEN/@MODDEM!=37 and not(/FIBEN/@GRAPHE)">
                          <xsl:if test="$NonResident='NR'">
                            <xsl:call-template name="tradlib">
                              <xsl:with-param name="Lang" select="$Lang"/>
                              <xsl:with-param name="codeLib" select="'m00_Cot'"/>
                            </xsl:call-template>
                          </xsl:if>
                          <xsl:if test="not($NonResident='NR')">
                            <xsl:value-of select="$dicoFR/mot[@id='m00_Cot']"/>
                          </xsl:if>
                          <xsl:choose>
                            <xsl:when test ="/FIBEN/PERSONNE/MODULEDE">
                              <xsl:value-of select="$valcot"/>
                            </xsl:when>
                            <xsl:otherwise>
                              <xsl:if test ="$valcot='ND'">
                                <a href="#nullepart" class="clGrasFond" onclick="requestVariousInfos('{$valcot}',cstCotationNonDif,'{$ident}')">
                                  <u>
                                    <xsl:value-of select="$valcot"/>
                                  </u>
                                </a>&#160;
                              </xsl:if>
                              <xsl:if test ="not($valcot='ND')">
                                <a href="#nullepart" class="clGrasFond" onclick="requestVariousInfos('{$valcot}',cstCotation,'{$ident}')">
                                  <u>
                                    <xsl:value-of select="$valcot"/>
                                  </u>
                                </a>&#160;
                              </xsl:if>

                            </xsl:otherwise>
                          </xsl:choose>
                        </xsl:if>
                        <xsl:if test="$valcot and (/FIBEN/@MODDEM=20 or /FIBEN/@MODDEM=37 or boolean(/FIBEN/@GRAPHE))">
                          <xsl:if test="$NonResident='NR'">
                            <xsl:call-template name="tradlib">
                              <xsl:with-param name="Lang" select="$Lang"/>
                              <xsl:with-param name="codeLib" select="'m00_Cot'"/>
                            </xsl:call-template>
                          </xsl:if>
                          <xsl:if test="not($NonResident='NR')">
                            <xsl:value-of select="$dicoFR/mot[@id='m00_Cot']"/>
                          </xsl:if>
                          <xsl:value-of select="$valcot"/>&#160;
                        </xsl:if>
                      </xsl:if>
                    </xsl:if>
                    <xsl:if  test="((/FIBEN/PERSONNE/MODULE20/PP)|(/FIBEN/PERSONNE/MODULE27/PP)|(/FIBEN/PERSONNE/MODULE37/PP37)|(/FIBEN/PERSONNE/MODULE56/PP)|(/FIBEN/PERSONNE/MODULE56/PM56/EI56))">
                      <xsl:if test="$valcot and /FIBEN/@MODDEM!=20 and /FIBEN/@MODDEM!=37 and not(/FIBEN/@GRAPHE)">
                        <xsl:if test="not($valcot='NS')">
                          <xsl:if test="$NonResident='NR'">
                            <xsl:call-template name="tradlib">
                              <xsl:with-param name="Lang" select="$Lang"/>
                              <xsl:with-param name="codeLib" select="'m00_Indica'"/>
                            </xsl:call-template>
                          </xsl:if>
                          <xsl:if test="not($NonResident='NR')">
                            <xsl:value-of select="$dicoFR/mot[@id='m00_Indica']"/>
                          </xsl:if>
                          <xsl:if test ="$valcot='ND'">
                            <a href="#nullepart" class="clGrasFond" onclick="requestVariousInfos('{$valcot}',cstCotationNonDif,'{$ident}')">
                              <u>
                                <xsl:value-of select="$valcot"/>
                              </u>
                            </a>&#160;
                          </xsl:if>
                          <xsl:if test ="not($valcot='ND')">
                            <a href="#nullepart" class="clGrasFond" onclick="requestVariousInfos('{$valcot}',cstCotation,'{$ident}')">
                              <u>
                                <xsl:value-of select="$valcot"/>
                              </u>
                            </a>&#160;
                          </xsl:if>
                        </xsl:if>
                      </xsl:if>
                      <xsl:if test="$valcot and (/FIBEN/@MODDEM=20 or /FIBEN/@MODDEM=37 or boolean(/FIBEN/@GRAPHE))">
                        <xsl:if test="$NonResident='NR'">
                          <xsl:call-template name="tradlib">
                            <xsl:with-param name="Lang" select="$Lang"/>
                            <xsl:with-param name="codeLib" select="'m00_Indica'"/>
                          </xsl:call-template>
                        </xsl:if>
                        <xsl:if test="not($NonResident='NR')">
                          <xsl:value-of select="$dicoFR/mot[@id='m00_Indica']"/>
                        </xsl:if>
                        <xsl:value-of select="$valcot"/>&#160;
                      </xsl:if>
                    </xsl:if>
                    <!--changement du parametre pour les ei interroges par une cl bdf -->
                    <xsl:if  test="((/FIBEN/PERSONNE/MODULE27/PM27/EI27/IDENTC)|(/FIBEN/PERSONNE/MODULEDE/EIPP/IDENTC))">
                      <xsl:if test="not($valcot='NS')">
                        <xsl:if test="$valindic and /FIBEN/@MODDEM!=20 and /FIBEN/@MODDEM!=37 and not(/FIBEN/@GRAPHE)">
                          <xsl:if test="$NonResident='NR'">
                            <xsl:call-template name="tradlib">
                              <xsl:with-param name="Lang" select="$Lang"/>
                              <xsl:with-param name="codeLib" select="'m00_Indica'"/>
                            </xsl:call-template>
                          </xsl:if>
                          <xsl:if test="not($NonResident='NR')">
                            <xsl:value-of select="$dicoFR/mot[@id='m00_Indica']"/>
                          </xsl:if>
                          <xsl:if test ="$valindic='ND'">
                            <a href="#nullepart" class="clGrasFond" onclick="requestVariousInfos('{$valindic}',cstCotationNonDif,'{$ident}')">
                              <u>
                                <xsl:value-of select="$valindic"/>
                              </u>
                            </a>&#160;
                          </xsl:if>
                          <xsl:if test ="not($valindic='ND')">
                            <a href="#nullepart" class="clGrasFond" onclick="requestVariousInfos('{$valindic}',cstCotation,'{$ident}')">
                              <u>
                                <xsl:value-of select="$valindic"/>
                              </u>
                            </a>&#160;
                          </xsl:if>
                        </xsl:if>
                      </xsl:if>
                      <xsl:if test="$valindic and (/FIBEN/@MODDEM=20 or /FIBEN/@MODDEM=37 or boolean(/FIBEN/@GRAPHE))">
                        <xsl:if test="not($valcot='NS')">
                          <xsl:if test="$NonResident='NR'">
                            <xsl:call-template name="tradlib">
                              <xsl:with-param name="Lang" select="$Lang"/>
                              <xsl:with-param name="codeLib" select="'m00_Indica'"/>
                            </xsl:call-template>
                          </xsl:if>
                          <xsl:if test="not($NonResident='NR')">
                            <xsl:value-of select="$dicoFR/mot[@id='m00_Indica']"/>
                          </xsl:if>
                          <xsl:value-of select="$valindic"/>&#160;
                        </xsl:if>
                      </xsl:if>
                    </xsl:if>
                    <!--fin du cas ligne 1 ei-idents-->
                  </td>
                </tr>
              </table>

              <!-- fin de ligne 1 cotation-->
              <table class="clWidth633 clHeight17 clBorderCell">

                <xsl:if test="not((/FIBEN/PERSONNE/MODULE27/PM27/EI27)|(/FIBEN/PERSONNE/MODULEDE/EIPP))">
                  <tr>
                    <xsl:if test="not($valcot='NS')">
                      <xsl:if test="$nomconj!=''">
                        <xsl:if test="$NonResident='NR'">
                          <xsl:if test="$Lang='FR'">
                            <td class="clFond clWidth129 clValignMiddle clBoxSizing">
                              &#160;
                              <xsl:call-template name="tradlib">
                                <xsl:with-param name="Lang" select="$Lang"/>
                                <xsl:with-param name="codeLib" select="'m00_Conjoi'"/>
                              </xsl:call-template>
                            </td>
                            <td class="clFond clWidth244 clBoxSizing" colspan="2" >
                              &#160;<xsl:value-of select="$nomconj"/>
                            </td>
                          </xsl:if>
                          <xsl:if test="$Lang='UK'">
                            <td class="clFond clWidth145 clValignMiddle clBoxSizing">
                              &#160;
                              <xsl:call-template name="tradlib">
                                <xsl:with-param name="Lang" select="$Lang"/>
                                <xsl:with-param name="codeLib" select="'m00_Conjoi'"/>
                              </xsl:call-template>
                            </td>
                            <td class="clFond clWidth228 clBoxSizing" colspan="2" >
                              &#160;<xsl:value-of select="$nomconj"/>
                            </td>
                          </xsl:if>
                        </xsl:if>
                        <xsl:if test="not($NonResident='NR')">
                          <td class="clFond clWidth129 clValignMiddle clBoxSizing">
                            &#160;
                            <xsl:value-of select="$dicoFR/mot[@id='m00_Conjoi']"/>
                          </td>
                          <td class="clFond clWidth244 clBoxSizing" colspan="2" >
                            &#160;<xsl:value-of select="$nomconj"/>
                          </td>
                        </xsl:if>
                      </xsl:if>
                    </xsl:if>
                    <xsl:if test="$idrenv and (not($nomconj)or $nomconj='')">
                      <xsl:if test="$NonResident='NR'">
                        <xsl:if test="$Lang='FR'">
                          <td class="clFond clWidth129 clValignMiddle clBoxSizing">
                            &#160;
                            <xsl:call-template name="tradlib">
                              <xsl:with-param name="Lang" select="$Lang"/>
                              <xsl:with-param name="codeLib" select="'m00_IdeRen'"/>
                            </xsl:call-template>
                          </td>
                          <td class="clFond clWidth244 clBoxSizing" colspan="2" >
                            &#160;<xsl:call-template name ="displayIdentXsl">
                              <xsl:with-param name ="InputIdent" select ="($idrenv)"/>
                            </xsl:call-template>
                          </td>
                        </xsl:if>
                        <xsl:if test="$Lang='UK'">
                          <td class="clFond clWidth145 clValignMiddle clBoxSizing">
                            &#160;
                            <xsl:call-template name="tradlib">
                              <xsl:with-param name="Lang" select="$Lang"/>
                              <xsl:with-param name="codeLib" select="'m00_IdeRen'"/>
                            </xsl:call-template>
                          </td>
                          <td class="clFond clWidth228 clBoxSizing" colspan="2" >
                            &#160;<xsl:call-template name ="displayIdentXsl">
                              <xsl:with-param name ="InputIdent" select ="($idrenv)"/>
                            </xsl:call-template>
                          </td>
                        </xsl:if>
                      </xsl:if>
                      <xsl:if test="not($NonResident='NR')">
                        <td class="clFond clWidth129 clValignMiddle clBoxSizing">
                          <xsl:value-of select="$dicoFR/mot[@id='m00_IdeRen']"/>
                        </td>
                        <td class="clFond clWidth244" colspan="2" >
                          &#160;<xsl:call-template name ="displayIdentXsl">
                            <xsl:with-param name ="InputIdent" select ="($idrenv)"/>
                          </xsl:call-template>
                        </td>
                      </xsl:if>
                    </xsl:if>
                    <xsl:if test="$idrenv or $nomconj!=''">
                      <td class="clFond clWidth260 clAlignRight clBoxSizing">
                        &#160;
                        <xsl:if test="not($valcot='NS')">
                          <!-- Cas du module 27, EJ Non rsident : Masque la date de cotation -->
                          <xsl:if test="$datcot">
                            <xsl:if test="$NonResident='NR'">
                              <xsl:call-template name="tradlib">
                                <xsl:with-param name="Lang" select="$Lang"/>
                                <xsl:with-param name="codeLib" select="'m00_DepLe'"/>
                              </xsl:call-template>
                            </xsl:if>
                            <xsl:if test="not($NonResident='NR')">
                              <xsl:value-of select="$dicoFR/mot[@id='m00_DepLe']"/>
                            </xsl:if>
                            <xsl:call-template name ="displayDateXsl">
                              <xsl:with-param name ="InputDate" select ="($datcot)"/>
                            </xsl:call-template>
                            <xsl:if test="$datexa!=''">
                              <xsl:if test="$NonResident='NR'">
                                <xsl:call-template name="tradlib">
                                  <xsl:with-param name="Lang" select="$Lang"/>
                                  <xsl:with-param name="codeLib" select="'m00_RevLe'"/>
                                </xsl:call-template>
                              </xsl:if>
                              <xsl:if test="not($NonResident='NR')">
                                <xsl:value-of select="$dicoFR/mot[@id='m00_RevLe']"/>
                              </xsl:if>
                              <xsl:call-template name ="displayDateXsl">
                                <xsl:with-param name ="InputDate" select ="($datexa)"/>
                              </xsl:call-template>)
                            </xsl:if>
                          </xsl:if>
                        </xsl:if>
                      </td>
                    </xsl:if>
                    <xsl:if test="not($idrenv) and (not($nomconj)or$nomconj='')">
                      <td class="clFond clWidth129 clBoxSizing">&#160;</td>
                      <td class="clFond clWidth504 clAlignRight clBoxSizing" colspan="3">
                        &#160;
                        <xsl:if test="not($valcot='NS')">
                          <!-- Cas du module 27, EJ Non rsident : Masque la date de cotation -->
                          <xsl:if test="$datcot!=''">
                            <xsl:if test="$NonResident='NR'">
                              <xsl:call-template name="tradlib">
                                <xsl:with-param name="Lang" select="$Lang"/>
                                <xsl:with-param name="codeLib" select="'m00_DepLe'"/>
                              </xsl:call-template>
                            </xsl:if>
                            <xsl:if test="not($NonResident='NR')">
                              <xsl:value-of select="$dicoFR/mot[@id='m00_DepLe']"/>
                            </xsl:if>
                            <xsl:call-template name ="displayDateXsl">
                              <xsl:with-param name ="InputDate" select ="($datcot)"/>
                            </xsl:call-template>
                            <xsl:if test="$datexa!=''">

                              <xsl:if test="$NonResident='NR'">
                                <xsl:call-template name="tradlib">
                                  <xsl:with-param name="Lang" select="$Lang"/>
                                  <xsl:with-param name="codeLib" select="'m00_RevLe'"/>
                                </xsl:call-template>
                              </xsl:if>
                              <xsl:if test="not($NonResident='NR')">
                                <xsl:value-of select="$dicoFR/mot[@id='m00_RevLe']"/>
                              </xsl:if>
                              <xsl:call-template name ="displayDateXsl">
                                <xsl:with-param name ="InputDate" select ="($datexa)"/>
                              </xsl:call-template>)
                            </xsl:if>
                          </xsl:if>
                        </xsl:if>
                      </td>
                    </xsl:if>

                  </tr>
                  <xsl:if test="$idrenv and $nomconj!=''">
                    <tr>
                      <xsl:if test="$NonResident='NR'">
                        <td class="clFond clWidth160 clValignMiddle clBoxSizing">
                          &#160;
                          <xsl:call-template name="tradlib">
                            <xsl:with-param name="Lang" select="$Lang"/>
                            <xsl:with-param name="codeLib" select="'m00_IdeRen'"/>
                          </xsl:call-template>
                        </td>
                        <td class="clFond clWidth213 clBoxSizing" colspan="2">
                          &#160;<xsl:call-template name ="displayIdentXsl">
                            <xsl:with-param name ="InputIdent" select ="($idrenv)"/>
                          </xsl:call-template>
                        </td>
                        <td class="clFond clWidth260 clAlignRight clBoxSizing">&#160;</td>
                      </xsl:if>
                      <xsl:if test="not($NonResident='NR')">
                        <td class="clFond clWidth129 clValignMiddle clBoxSizing">
                          &#160;
                          <xsl:value-of select="$dicoFR/mot[@id='m00_IdeRen']"/>
                        </td>
                        <td class="clFond clWidth244 clBoxSizing" colspan="2">
                          &#160;<xsl:call-template name ="displayIdentXsl">
                            <xsl:with-param name ="InputIdent" select ="($idrenv)"/>
                          </xsl:call-template>
                        </td>
                        <td class="clFond clWidth260 clAlignRight clBoxSizing">&#160;</td>
                      </xsl:if>
                    </tr>
                  </xsl:if>
                </xsl:if>
                <!--cas de ei avec rajout de l'indicateur dirigeant-->
                <xsl:if test="((/FIBEN/PERSONNE/MODULE27/PM27/EI27)|(/FIBEN/PERSONNE/MODULEDE/EIPP))">
                  <!--cas des cles bdf -->
                  <xsl:if  test="((/FIBEN/PERSONNE/MODULE27/PM27/EI27/IDENTC)|(/FIBEN/PERSONNE/MODULEDE/EIPP/IDENTC))">
                    <tr>
                      <xsl:if test="$nomconj!=''">
                        <xsl:if test="$NonResident='NR'">
                          <xsl:if test="$Lang='FR'">
                            <td class="clFond clWidth129 clValignMiddle clBoxSizing">
                              &#160;
                              <xsl:call-template name="tradlib">
                                <xsl:with-param name="Lang" select="$Lang"/>
                                <xsl:with-param name="codeLib" select="'m00_Conjoi'"/>
                              </xsl:call-template>
                            </td>
                            <td class="clFond clWidth200 clBoxSizing" colspan="2">
                              &#160;<xsl:value-of select="$nomconj"/>
                            </td>
                          </xsl:if>
                          <xsl:if test="$Lang='UK'">
                            <td class="clFond clWidth145 clValignMiddle clBoxSizing">
                              &#160;
                              <xsl:call-template name="tradlib">
                                <xsl:with-param name="Lang" select="$Lang"/>
                                <xsl:with-param name="codeLib" select="'m00_Conjoi'"/>
                              </xsl:call-template>
                            </td>
                            <td class="clFond clWidth228 clBoxSizing" colspan="2" >
                              &#160;<xsl:value-of select="$nomconj"/>
                            </td>
                          </xsl:if>
                        </xsl:if>
                        <xsl:if test="not($NonResident='NR')">
                          <td class="clFond clWidth129 clValignMiddle clBoxSizing">
                            &#160;
                            <xsl:value-of select="$dicoFR/mot[@id='m00_Conjoi']"/>
                          </td>
                          <td class="clFond clWidth200 clBoxSizing" colspan="2">
                            &#160;<xsl:value-of select="$nomconj"/>
                          </td>
                        </xsl:if>
                      </xsl:if>
                      <xsl:if test="not(/FIBEN/PERSONNE/MODULE27/PM27/EI27/IDENTITE/NOMCONJ | /FIBEN/PERSONNE/MODULEDE/EIPP/IDENTITE/NOMCONJ)">

                        <td class="clFond clWidth129 clValignMiddle">
                          &#160;
                        </td>
                        <td class="clFond clWidth200" colspan="2">
                          &#160;
                        </td>

                      </xsl:if>

                      <!--td width="129" class="clFond">&#160;</td-->
                      <td class="clFond clWidth304 clAlignRight" colspan="3">
                        &#160;
                        <xsl:if test="not($valcot='NS')">
                          <xsl:if test="$datindic!=''">
                            <xsl:if test="$NonResident='NR'">
                              <xsl:call-template name="tradlib">
                                <xsl:with-param name="Lang" select="$Lang"/>
                                <xsl:with-param name="codeLib" select="'m00_DepLe'"/>
                              </xsl:call-template>
                            </xsl:if>
                            <xsl:if test="not($NonResident='NR')">
                              <xsl:value-of select="$dicoFR/mot[@id='m00_DepLe']"/>
                            </xsl:if>
                            <xsl:call-template name ="displayDateXsl">
                              <xsl:with-param name ="InputDate" select ="($datindic)"/>
                            </xsl:call-template>
                            <xsl:if test="$indexa2!=''">

                              <xsl:if test="$NonResident='NR'">
                                <xsl:call-template name="tradlib">
                                  <xsl:with-param name="Lang" select="$Lang"/>
                                  <xsl:with-param name="codeLib" select="'m00_RevLe'"/>
                                </xsl:call-template>
                              </xsl:if>
                              <xsl:if test="not($NonResident='NR')">
                                <xsl:value-of select="$dicoFR/mot[@id='m00_RevLe']"/>
                              </xsl:if>
                              <xsl:call-template name ="displayDateXsl">
                                <xsl:with-param name ="InputDate" select ="($indexa2)"/>
                              </xsl:call-template>)
                            </xsl:if>
                          </xsl:if>
                        </xsl:if>
                      </td>
                    </tr>
                    <!--ligne 3 idrenv avec sa cotation -->
                    <tr>
                      <xsl:if test="$NonResident='NR'">
                        <td class="clFond clWidth129 clValignMiddle clBoxSizing">
                          &#160;
                          <xsl:if test="not($valcot='NS')">
                            <xsl:call-template name="tradlib">
                              <xsl:with-param name="Lang" select="$Lang"/>
                              <xsl:with-param name="codeLib" select="'m00_IdeRen'"/>
                            </xsl:call-template>
                          </xsl:if>
                        </td>
                        <td class="clFond clWidth100 clBoxSizing">
                          &#160;
                          <xsl:if test="not($valcot='NS')">
                            <xsl:call-template name ="displayIdentXsl">
                              <xsl:with-param name ="InputIdent" select ="($idrenv)"/>
                            </xsl:call-template>
                          </xsl:if>
                        </td>
                        <td class="clGrasFond clWidth100 clAlignRight clValignMiddle clBoxSizing">
                          &#160;
                          <xsl:if test="not($valcot='NS')">
                            <xsl:call-template name="tradlib">
                              <xsl:with-param name="Lang" select="$Lang"/>
                              <xsl:with-param name="codeLib" select="'m00_Cota'"/>
                            </xsl:call-template>

                            <!-- Diffusi-82_ano1 Suppression du lien de cotation sur le module DE -->
                            <xsl:choose>
                              <xsl:when test ="/FIBEN/PERSONNE/MODULEDE/EIPP">
                                <xsl:value-of select="$valcot"/>&#160;
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:if test ="$valcot='ND'">
                                  <a href="#nullepart" class="clGrasFond" onclick="requestVariousInfos('{$valcot}',cstCotationNonDif,'{$ident}')">
                                    <u>
                                      <xsl:value-of select="$valcot"/>
                                    </u>
                                  </a>&#160;
                                </xsl:if>
                                <xsl:if test ="not($valcot='ND')">
                                  <a href="#nullepart" class="clGrasFond" onclick="requestVariousInfos('{$valcot}',cstCotation,'{$ident}')">
                                    <u>
                                      <xsl:value-of select="$valcot"/>
                                    </u>
                                  </a>&#160;
                                </xsl:if>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:if>
                        </td>
                        <td class="clFond clWidth304 clAlignRight clBoxSizing">
                          &#160;
                          <xsl:if test="not($valcot='NS')">
                            <xsl:if test="$datcot!=''">
                              <xsl:if test="$NonResident='NR'">
                                <xsl:call-template name="tradlib">
                                  <xsl:with-param name="Lang" select="$Lang"/>
                                  <xsl:with-param name="codeLib" select="'m00_DepLe'"/>
                                </xsl:call-template>
                              </xsl:if>
                              <xsl:if test="not($NonResident='NR')">
                                <xsl:value-of select="$dicoFR/mot[@id='m00_DepLe']"/>
                              </xsl:if>
                              <xsl:call-template name ="displayDateXsl">
                                <!-- <xsl:with-param name ="InputDate" select ="($datindic)"/>-->
                                <xsl:with-param name ="InputDate" select ="($datcot)"/>
                              </xsl:call-template>
                              <xsl:if test="$datexa!=''">

                                <xsl:if test="$NonResident='NR'">
                                  <xsl:call-template name="tradlib">
                                    <xsl:with-param name="Lang" select="$Lang"/>
                                    <xsl:with-param name="codeLib" select="'m00_RevLe'"/>
                                  </xsl:call-template>
                                </xsl:if>
                                <xsl:if test="not($NonResident='NR')">
                                  <xsl:value-of select="$dicoFR/mot[@id='m00_RevLe']"/>
                                </xsl:if>
                                <xsl:call-template name ="displayDateXsl">
                                  <xsl:with-param name ="InputDate" select ="($datexa)"/>
                                </xsl:call-template>)
                              </xsl:if>
                            </xsl:if>
                          </xsl:if>
                        </td>



                      </xsl:if>
                      <xsl:if test="not($NonResident='NR')">
                        <td class="clFond clWidth129 clValignMiddle clBoxSizing">
                          &#160;
                          <xsl:value-of select="$dicoFR/mot[@id='m00_IdeRen']"/>
                        </td>
                        <td class="clFond clWidth100 clBoxSizing">
                          &#160;<xsl:call-template name ="displayIdentXsl">
                            <xsl:with-param name ="InputIdent" select ="($idrenv)"/>
                          </xsl:call-template>
                        </td>
                        <td class="clGrasFond clWidth100 clAlignRight clValignMiddle clBoxSizing">
                          &#160;
                          <xsl:if test="not($valcot='NS')">
                            <xsl:value-of select="$dicoFR/mot[@id='m00_Cota']"/>


                            <!-- Diffusi-82_ano1 Suppression du lien de cotation sur le module DE -->
                            <xsl:choose>
                              <xsl:when test ="/FIBEN/PERSONNE/MODULEDE/EIPP">
                                <xsl:value-of select="$valcot"/>&#160;
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:if test ="$valcot='ND'">
                                  <a href="#nullepart" class="clGrasFond" onclick="requestVariousInfos('{$valcot}',cstCotationNonDif,'{$ident}')">
                                    <u>
                                      <xsl:value-of select="$valcot"/>
                                    </u>
                                  </a>&#160;
                                </xsl:if>
                                <xsl:if test ="not($valcot='ND')">
                                  <a href="#nullepart" class="clGrasFond" onclick="requestVariousInfos('{$valcot}',cstCotation,'{$ident}')">
                                    <u>
                                      <xsl:value-of select="$valcot"/>
                                    </u>
                                  </a>&#160;
                                </xsl:if>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:if>
                        </td>
                        <td class="clFond clWidth304 clAlignRight clBoxSizing" colspan="3">
                          &#160;
                          <xsl:if test="not($valcot='NS')">
                            <xsl:if test="$datcot!=''">
                              <xsl:if test="$NonResident='NR'">
                                <xsl:call-template name="tradlib">
                                  <xsl:with-param name="Lang" select="$Lang"/>
                                  <xsl:with-param name="codeLib" select="'m00_DepLe'"/>
                                </xsl:call-template>
                              </xsl:if>
                              <xsl:if test="not($NonResident='NR')">
                                <xsl:value-of select="$dicoFR/mot[@id='m00_DepLe']"/>
                              </xsl:if>
                              <xsl:call-template name ="displayDateXsl">
                                <xsl:with-param name ="InputDate" select ="($datcot)"/>
                              </xsl:call-template>
                              <xsl:if test="$datexa!=''">

                                <xsl:if test="$NonResident='NR'">
                                  <xsl:call-template name="tradlib">
                                    <xsl:with-param name="Lang" select="$Lang"/>
                                    <xsl:with-param name="codeLib" select="'m00_RevLe'"/>
                                  </xsl:call-template>
                                </xsl:if>
                                <xsl:if test="not($NonResident='NR')">
                                  <xsl:value-of select="$dicoFR/mot[@id='m00_RevLe']"/>
                                </xsl:if>
                                <xsl:call-template name ="displayDateXsl">
                                  <xsl:with-param name ="InputDate" select ="($datexa)"/>
                                </xsl:call-template>)
                              </xsl:if>
                            </xsl:if>
                          </xsl:if>
                        </td>
                      </xsl:if>
                    </tr>
                  </xsl:if>
                  <xsl:if  test="((/FIBEN/PERSONNE/MODULE27/PM27/EI27/IDENTS)|(/FIBEN/PERSONNE/MODULEDE/EIPP/IDENTS))">
                    <tr>
                      <xsl:if test="$nomconj!=''">
                        <xsl:if test="$NonResident='NR'">
                          <xsl:if test="$Lang='FR'">
                            <td class="clFond clWidth129 clValignMiddle clBoxSizing">
                              &#160;
                              <xsl:call-template name="tradlib">
                                <xsl:with-param name="Lang" select="$Lang"/>
                                <xsl:with-param name="codeLib" select="'m00_Conjoi'"/>
                              </xsl:call-template>
                            </td>
                            <td class="clFond clWidth200 clBoxSizing" colspan="2">
                              &#160;<xsl:value-of select="$nomconj"/>
                            </td>
                          </xsl:if>
                          <xsl:if test="$Lang='UK'">
                            <td class="clFond clWidth145 clValignMiddle clBoxSizing">
                              &#160;
                              <xsl:call-template name="tradlib">
                                <xsl:with-param name="Lang" select="$Lang"/>
                                <xsl:with-param name="codeLib" select="'m00_Conjoi'"/>
                              </xsl:call-template>
                            </td>
                            <td class="clFond clWidth228 clBoxSizing" colspan="2" >
                              &#160;<xsl:value-of select="$nomconj"/>
                            </td>
                          </xsl:if>
                        </xsl:if>
                        <xsl:if test="not($NonResident='NR')">
                          <td class="clFond clWidth129 clValignMiddle clBoxSizing">
                            &#160;
                            <xsl:value-of select="$dicoFR/mot[@id='m00_Conjoi']"/>
                          </td>
                          <td class="clFond clWidth200 clBoxSizing" colspan="2">
                            &#160;<xsl:value-of select="$nomconj"/>
                          </td>
                        </xsl:if>
                      </xsl:if>
                      <xsl:if test="not(/FIBEN/PERSONNE/MODULE27/PM27/EI27/IDENTITE/NOMCONJ | /FIBEN/PERSONNE/MODULEDE/EIPP/IDENTITE/NOMCONJ)">

                        <td class="clFond clWidth129 clValignMiddle clBoxSizing">
                          &#160;

                        </td>
                        <td class="clFond clWidth200 clBoxSizing" colspan="2">
                          &#160;
                        </td>


                      </xsl:if>
                      <!--td width="129" class="clFond">&#160;</td-->
                      <td class="clFond clWidth304 clAlignRight clBoxSizing" colspan="3">
                        &#160;
                        <xsl:if test="not($valcot='NS')">
                          <!-- Cas du module 27, EI Non rsident : Masque la date de cotation -->
                          <xsl:if test="$datcot!=''">
                            <xsl:if test="$NonResident='NR'">
                              <xsl:call-template name="tradlib">
                                <xsl:with-param name="Lang" select="$Lang"/>
                                <xsl:with-param name="codeLib" select="'m00_DepLe'"/>
                              </xsl:call-template>
                            </xsl:if>
                            <xsl:if test="not($NonResident='NR')">
                              <xsl:value-of select="$dicoFR/mot[@id='m00_DepLe']"/>
                            </xsl:if>
                            <xsl:call-template name ="displayDateXsl">
                              <xsl:with-param name ="InputDate" select ="($datcot)"/>
                            </xsl:call-template>
                            <xsl:if test="$datexa !=''">

                              <xsl:if test="$NonResident='NR'">
                                <xsl:call-template name="tradlib">
                                  <xsl:with-param name="Lang" select="$Lang"/>
                                  <xsl:with-param name="codeLib" select="'m00_RevLe'"/>
                                </xsl:call-template>
                              </xsl:if>
                              <xsl:if test="not($NonResident='NR')">
                                <xsl:value-of select="$dicoFR/mot[@id='m00_RevLe']"/>
                              </xsl:if>
                              <xsl:call-template name ="displayDateXsl">
                                <xsl:with-param name ="InputDate" select ="($datexa)"/>
                              </xsl:call-template>)
                            </xsl:if>
                          </xsl:if>
                        </xsl:if>
                      </td>

                    </tr>
                    <!--ligne 3 idrenv avec sa cotation -->
                    <tr>
                      <xsl:if test="$NonResident='NR'">
                        <td class="clFond clWidth145 clValignMiddle clBoxSizing">
                          &#160;
                          <xsl:call-template name="tradlib">
                            <xsl:with-param name="Lang" select="$Lang"/>
                            <xsl:with-param name="codeLib" select="'m00_IdeRen'"/>
                          </xsl:call-template>
                        </td>
                        <td class="clFond clWidth100 clBoxSizing" colspan="2">
                          &#160;<xsl:call-template name ="displayIdentXsl">
                            <xsl:with-param name ="InputIdent" select ="($idrenv)"/>
                          </xsl:call-template>
                        </td>
                        <xsl:if test="not($valcot='NS')">
                          <td class="clGrasFond clWidth106 clAlignRight clValignMiddle clBoxSizing">
                            &#160;
                            <xsl:call-template name="tradlib">
                              <xsl:with-param name="Lang" select="$Lang"/>
                              <xsl:with-param name="codeLib" select="'m00_Indi'"/>
                            </xsl:call-template>
                            <xsl:if test ="$valindic='ND'">
                              <a href="#nullepart" class="clGrasFond" onclick="requestVariousInfos('{$valindic}',cstCotationNonDif,'{$ident}')">
                                <u>
                                  <xsl:value-of select="$valindic"/>
                                </u>
                              </a>&#160;
                            </xsl:if>
                            <xsl:if test ="not($valindic='ND')">
                              <a href="#nullepart" class="clGrasFond" onclick="requestVariousInfos('{$valindic}',cstCotation,'{$ident}')">
                                <u>
                                  <xsl:value-of select="$valindic"/>
                                </u>
                              </a>&#160;
                            </xsl:if>
                          </td>
                          <td class="clFond clWidth298 clAlignRight clBoxSizing">
                            &#160;
                            <xsl:if test="$datindic!=''">
                              <xsl:if test="$NonResident='NR'">
                                <xsl:call-template name="tradlib">
                                  <xsl:with-param name="Lang" select="$Lang"/>
                                  <xsl:with-param name="codeLib" select="'m00_DepLe'"/>
                                </xsl:call-template>
                              </xsl:if>
                              <xsl:if test="not($NonResident='NR')">
                                <xsl:value-of select="$dicoFR/mot[@id='m00_DepLe']"/>
                              </xsl:if>
                              <xsl:call-template name ="displayDateXsl">
                                <xsl:with-param name ="InputDate" select ="($datindic)"/>
                              </xsl:call-template>
                              <xsl:if test="$indexa2!=''">

                                <xsl:if test="$NonResident='NR'">
                                  <xsl:call-template name="tradlib">
                                    <xsl:with-param name="Lang" select="$Lang"/>
                                    <xsl:with-param name="codeLib" select="'m00_RevLe'"/>
                                  </xsl:call-template>
                                </xsl:if>
                                <xsl:if test="not($NonResident='NR')">
                                  <xsl:value-of select="$dicoFR/mot[@id='m00_RevLe']"/>
                                </xsl:if>
                                <xsl:call-template name ="displayDateXsl">
                                  <xsl:with-param name ="InputDate" select ="($indexa2)"/>
                                </xsl:call-template>)
                              </xsl:if>
                            </xsl:if>
                          </td>
                        </xsl:if>
                        <xsl:if test="($valcot='NS')">
                          <td class="clFond clWidth298 clAlignRight clBoxSizing">&#160;</td>
                        </xsl:if>
                      </xsl:if>
                      <xsl:if test="not($NonResident='NR')">
                        <xsl:if test="$idrenv !=''">
                          <td class="clFond clWidth129 clValignMiddle clBoxSizing">
                            &#160;
                            <xsl:value-of select="$dicoFR/mot[@id='m00_IdeRen']"/>
                          </td>
                          <td class="clFond clWidth100 clBoxSizing">
                            &#160;<xsl:call-template name ="displayIdentXsl">
                              <xsl:with-param name ="InputIdent" select ="($idrenv)"/>
                            </xsl:call-template>
                          </td>
                          <td class="clGrasFond clWidth106 clAlignRight clValignMiddle clBoxSizing">
                            &#160;
                            <xsl:if test="not($valcot='NS')">
                              <xsl:value-of select="$dicoFR/mot[@id='m00_Indi']"/>

                              <xsl:if test ="$valindic='ND'">
                                <a href="#nullepart" class="clGrasFond" onclick="requestVariousInfos('{$valindic}',cstCotationNonDif,'{$ident}')">
                                  <u>
                                    <xsl:value-of select="$valindic"/>
                                  </u>
                                </a>&#160;
                              </xsl:if>
                              <xsl:if test ="not($valindic='ND')">
                                <a href="#nullepart" class="clGrasFond" onclick="requestVariousInfos('{$valindic}',cstCotation,'{$ident}')">
                                  <u>
                                    <xsl:value-of select="$valindic"/>
                                  </u>
                                </a>&#160;
                              </xsl:if>
                            </xsl:if>
                          </td>
                          <td class="clFond clWidth298 clAlignRight clBoxSizing" colspan="3">
                            &#160;
                            <xsl:if test="not($valcot='NS')">
                              <xsl:if test="$datindic!=''">
                                <xsl:if test="$NonResident='NR'">
                                  <xsl:call-template name="tradlib">
                                    <xsl:with-param name="Lang" select="$Lang"/>
                                    <xsl:with-param name="codeLib" select="'m00_DepLe'"/>
                                  </xsl:call-template>
                                </xsl:if>
                                <xsl:if test="not($NonResident='NR')">
                                  <xsl:value-of select="$dicoFR/mot[@id='m00_DepLe']"/>
                                </xsl:if>
                                <xsl:call-template name ="displayDateXsl">
                                  <xsl:with-param name ="InputDate" select ="($datindic)"/>
                                </xsl:call-template>
                                <xsl:if test="$indexa2!=''">

                                  <xsl:if test="$NonResident='NR'">
                                    <xsl:call-template name="tradlib">
                                      <xsl:with-param name="Lang" select="$Lang"/>
                                      <xsl:with-param name="codeLib" select="'m00_RevLe'"/>
                                    </xsl:call-template>
                                  </xsl:if>
                                  <xsl:if test="not($NonResident='NR')">
                                    <xsl:value-of select="$dicoFR/mot[@id='m00_RevLe']"/>
                                  </xsl:if>
                                  <xsl:call-template name ="displayDateXsl">
                                    <xsl:with-param name ="InputDate" select ="($indexa2)"/>
                                  </xsl:call-template>)
                                </xsl:if>
                              </xsl:if>
                            </xsl:if>
                          </td>
                        </xsl:if>
                      </xsl:if>
                    </tr>
                  </xsl:if>
                </xsl:if>
              </table>
            </td>
          </tr>
        </table>
      </xsl:if>
    </xsl:if>
  </xsl:template>

  <xsl:template name="shim">
    <xsl:element name="img">
      <!--<xsl:attribute name ="alt"></xsl:attribute>-->
      <xsl:attribute name="width">635</xsl:attribute>
      <xsl:attribute name="height">1</xsl:attribute>
      <xsl:attribute name="vspace">8</xsl:attribute>
      <xsl:attribute name="src"><xsl:value-of select="$root"/>Images/commun/shim_bleu.gif</xsl:attribute>
    </xsl:element>
  </xsl:template>

  <xsl:template name="fleche_haut">
    <a href="#ancHaut">
      <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page" />
    </a>
  </xsl:template>

  <xsl:template match="HOMONYME">
    <a name="ancHomonyme"></a>
    <table class="clWidth635 clBorderCell">
      <caption class="visually-hidden">Homonyme</caption>
      <xsl:if test ="(/FIBEN/@MODDEM=37) and not(/FIBEN/PERSONNE/ENTMORT)">
        <tr>
          <td class="clTexte clWidth130"> &#160;</td>
          <td class="clTexte clWidth505" colspan="2">
            &#160;
          </td>
        </tr>
      </xsl:if>
      <xsl:apply-templates select="IDENTCH"/>
      <xsl:apply-templates select="DERNHOMO"/>
    </table>
    <xsl:if test ="not(/FIBEN/@MODDEM=37)">
      <xsl:call-template name="shim"/>
    </xsl:if>
    <xsl:if test="(/FIBEN/@MODDEM=DE)">
      <xsl:call-template name="shim"/>
    </xsl:if>
  </xsl:template>

  <xsl:template match="IDENTCH">
    <tr>
      <td class="clCouleur2 clWidth130">
        <xsl:if test="$NonResident='NR'">
          <xsl:call-template name="tradlib">
            <xsl:with-param name="Lang" select="$Lang"/>
            <xsl:with-param name="codeLib" select="'m00_Homony'"/>
          </xsl:call-template>
        </xsl:if>
        <xsl:if test="not($NonResident='NR')">
          <xsl:value-of select="$dicoFR/mot[@id='m00_Homony']"/>
        </xsl:if>
      </td>
      <td class="clFond clWidth505" colspan="2">
        &#160;<xsl:value-of select="."/>
      </td>
    </tr>
    <xsl:if test="$NonResident = 'NR'">
      <tr>
        <td class="clWidth130"></td>
        <td class="clWidth505 clAlignRight" colspan="2">&#160;</td>
      </tr>
    </xsl:if>
    <xsl:if test="not($NonResident = 'NR')">
      <tr>
        <td class="clWidth130"></td>
        <td class="clWidth505 clAlignRight" colspan="2">
          <a href="#nullepart" onclick="requestBDFInfos('{/FIBEN/@MODDEM}','','{$familyNumber}','{.}',cstSimpleConfirm);">
            <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" border="0" alt="plus d'infos"/>
          </a>
        </td>
      </tr>
    </xsl:if>

  </xsl:template>


  <xsl:template match="IDLIES">
    <xsl:if test="/FIBEN/PERSONNE/MODULEDE">
      <xsl:if test="position()=last()">
        <xsl:if test="not(//HOMONYME)">
          <a name="ancHomonyme"></a>
        </xsl:if>
        <table class="clWidth635 clBorderCell" role="presentation">
          <caption class="visually-hidden">Identifiant(s) li(s)</caption>
          <xsl:if test="$NonResident='NR'">
            <xsl:if test="$Lang='FR'">
              <tr>
                <td class="clCouleur2 clWidth130 clHeight14 ">

                  <xsl:call-template name="tradlib">
                    <xsl:with-param name="Lang" select="$Lang"/>
                    <xsl:with-param name="codeLib" select="'m00_IdeLie'"/>
                  </xsl:call-template>

                </td>
                <td class="clTexte clWidth497 clHeight14" colspan="2">
                  <xsl:if test="count(../IDLIES)=1">
                    &#160;<xsl:call-template name ="displayIdentXsl">
                      <xsl:with-param name ="InputIdent" select ="(.)"/>
                    </xsl:call-template>
                  </xsl:if>
                  <xsl:if test="count(../IDLIES)=2">
                    &#160;<xsl:call-template name ="displayConcatIdentXsl">
                      <xsl:with-param name ="InputIdent1" select ="(../IDLIES[1])"/>
                      <xsl:with-param name ="InputIdent2" select ="(.)"/>
                    </xsl:call-template>
                  </xsl:if>
                  <xsl:if test="count(../IDLIES)=3">
                    &#160;<xsl:call-template name ="displayConcatIdentXsl">
                      <xsl:with-param name ="InputIdent1" select ="(../IDLIES[1])"/>
                      <xsl:with-param name ="InputIdent2" select ="(../IDLIES[2])"/>
                      <xsl:with-param name ="InputIdent3" select ="(.)"/>
                    </xsl:call-template>
                  </xsl:if>
                </td>
              </tr>
            </xsl:if>
            <xsl:if test="$Lang='UK'">
              <tr>
                <td class="clCouleur2 clWidth165 clHeight14">
                  <xsl:if test="$NonResident='NR'">
                    <xsl:call-template name="tradlib">
                      <xsl:with-param name="Lang" select="$Lang"/>
                      <xsl:with-param name="codeLib" select="'m00_IdeLie'"/>
                    </xsl:call-template>
                  </xsl:if>
                </td>
                <td class="clTexte clWidth462 clHeight14" colspan="2">
                  <xsl:if test="count(../IDLIES)=1">
                    &#160;<xsl:call-template name ="displayIdentXsl">
                      <xsl:with-param name ="InputIdent" select ="(.)"/>
                    </xsl:call-template>
                  </xsl:if>
                  <xsl:if test="count(../IDLIES)=2">
                    &#160;<xsl:call-template name ="displayConcatIdentXsl">
                      <xsl:with-param name ="InputIdent1" select ="(../IDLIES[1])"/>
                      <xsl:with-param name ="InputIdent2" select ="(.)"/>
                    </xsl:call-template>
                  </xsl:if>
                  <xsl:if test="count(../IDLIES)=3">
                    &#160;<xsl:call-template name ="displayConcatIdentXsl">
                      <xsl:with-param name ="InputIdent1" select ="(../IDLIES[1])"/>
                      <xsl:with-param name ="InputIdent2" select ="(../IDLIES[2])"/>
                      <xsl:with-param name ="InputIdent3" select ="(.)"/>
                    </xsl:call-template>
                  </xsl:if>
                </td>
              </tr>
            </xsl:if>
          </xsl:if>
        </table>
        <xsl:if test="not($NonResident='NR')">
          <table class="clWidth635 clBorderCell">
            <caption class="visually-hidden">Identifiant(s) li(s)</caption>
            <tr>
              <td class="clCouleur2 clWidth128 clHeight14">
                <xsl:value-of select="$dicoFR/mot[@id='m00_IdeLie']"/>
              </td>
              <td class="clTexte clWidth495 clHeight14" colspan="2">
                <xsl:if test="count(../IDLIES)=1">
                  &#160;<xsl:call-template name ="displayIdentXsl">
                    <xsl:with-param name ="InputIdent" select ="(.)"/>
                  </xsl:call-template>
                </xsl:if>
                <xsl:if test="count(../IDLIES)=2">
                  &#160;<xsl:call-template name ="displayConcatIdentXsl">
                    <xsl:with-param name ="InputIdent1" select ="(../IDLIES[1])"/>
                    <xsl:with-param name ="InputIdent2" select ="(.)"/>
                  </xsl:call-template>
                </xsl:if>
                <xsl:if test="count(../IDLIES)=3">
                  &#160;<xsl:call-template name ="displayConcatIdentXsl">
                    <xsl:with-param name ="InputIdent1" select ="(../IDLIES[1])"/>
                    <xsl:with-param name ="InputIdent2" select ="(../IDLIES[2])"/>
                    <xsl:with-param name ="InputIdent3" select ="(.)"/>
                  </xsl:call-template>
                </xsl:if>
              </td>
            </tr>
          </table>
        </xsl:if>
      </xsl:if>
    </xsl:if>
    <xsl:if test="not(/FIBEN/PERSONNE/MODULEDE)">
      <xsl:if test="position()=last()">
        <xsl:if test="not(//HOMONYME)">
          <a name="ancHomonyme"></a>
        </xsl:if>
        <table class="clWidth635 clBorderCell">
          <caption class="visually-hidden">Identifiant(s) li(s)</caption>
          <xsl:if test="$NonResident='NR'">
            <xsl:if test="$Lang='FR'">
              <tr>
                <td class="clCouleur2 clWidth130 clHeight14 ">

                  <xsl:call-template name="tradlib">
                    <xsl:with-param name="Lang" select="$Lang"/>
                    <xsl:with-param name="codeLib" select="'m00_IdeLie'"/>
                  </xsl:call-template>

                </td>
                <td class="clFond clWidth497 clHeight14" colspan="2">
                  <xsl:if test="count(../IDLIES)=1">
                    &#160;<xsl:call-template name ="displayIdentXsl">
                      <xsl:with-param name ="InputIdent" select ="(.)"/>
                    </xsl:call-template>
                  </xsl:if>
                  <xsl:if test="count(../IDLIES)=2">
                    &#160;<xsl:call-template name ="displayConcatIdentXsl">
                      <xsl:with-param name ="InputIdent1" select ="(../IDLIES[1])"/>
                      <xsl:with-param name ="InputIdent2" select ="(.)"/>
                    </xsl:call-template>
                  </xsl:if>
                  <xsl:if test="count(../IDLIES)=3">
                    &#160;<xsl:call-template name ="displayConcatIdentXsl">
                      <xsl:with-param name ="InputIdent1" select ="(../IDLIES[1])"/>
                      <xsl:with-param name ="InputIdent2" select ="(../IDLIES[2])"/>
                      <xsl:with-param name ="InputIdent3" select ="(.)"/>
                    </xsl:call-template>
                  </xsl:if>
                </td>
              </tr>
            </xsl:if>
            <xsl:if test="$Lang='UK'">
              <tr>
                <td class="clCouleur2 clWidth165 clHeight14">
                  <xsl:if test="$NonResident='NR'">
                    <xsl:call-template name="tradlib">
                      <xsl:with-param name="Lang" select="$Lang"/>
                      <xsl:with-param name="codeLib" select="'m00_IdeLie'"/>
                    </xsl:call-template>
                  </xsl:if>
                </td>
                <td class="clFond clWidth462 clHeight14" colspan="2">
                  <xsl:if test="count(../IDLIES)=1">
                    &#160;<xsl:call-template name ="displayIdentXsl">
                      <xsl:with-param name ="InputIdent" select ="(.)"/>
                    </xsl:call-template>
                  </xsl:if>
                  <xsl:if test="count(../IDLIES)=2">
                    &#160;<xsl:call-template name ="displayConcatIdentXsl">
                      <xsl:with-param name ="InputIdent1" select ="(../IDLIES[1])"/>
                      <xsl:with-param name ="InputIdent2" select ="(.)"/>
                    </xsl:call-template>
                  </xsl:if>
                  <xsl:if test="count(../IDLIES)=3">
                    &#160;<xsl:call-template name ="displayConcatIdentXsl">
                      <xsl:with-param name ="InputIdent1" select ="(../IDLIES[1])"/>
                      <xsl:with-param name ="InputIdent2" select ="(../IDLIES[2])"/>
                      <xsl:with-param name ="InputIdent3" select ="(.)"/>
                    </xsl:call-template>
                  </xsl:if>
                </td>
              </tr>
            </xsl:if>
          </xsl:if>
        </table>
        <xsl:if test="not($NonResident='NR')">
          <table class="clWidth635 clBorderCell">
            <caption class="visually-hidden">Identifiant(s) li(s)</caption>
            <tr>
              <td class="clCouleur2 clWidth128 clHeight14">
                <xsl:value-of select="$dicoFR/mot[@id='m00_IdeLie']"/>
              </td>
              <td class="clFond clWidth495 clHeight14" colspan="2">
                <xsl:if test="count(../IDLIES)=1">
                  &#160;<xsl:call-template name ="displayIdentXsl">
                    <xsl:with-param name ="InputIdent" select ="(.)"/>
                  </xsl:call-template>
                </xsl:if>
                <xsl:if test="count(../IDLIES)=2">
                  &#160;<xsl:call-template name ="displayConcatIdentXsl">
                    <xsl:with-param name ="InputIdent1" select ="(../IDLIES[1])"/>
                    <xsl:with-param name ="InputIdent2" select ="(.)"/>
                  </xsl:call-template>
                </xsl:if>
                <xsl:if test="count(../IDLIES)=3">
                  &#160;<xsl:call-template name ="displayConcatIdentXsl">
                    <xsl:with-param name ="InputIdent1" select ="(../IDLIES[1])"/>
                    <xsl:with-param name ="InputIdent2" select ="(../IDLIES[2])"/>
                    <xsl:with-param name ="InputIdent3" select ="(.)"/>
                  </xsl:call-template>
                </xsl:if>
              </td>
            </tr>
          </table>
        </xsl:if>
        <xsl:call-template name="shim"/>
      </xsl:if>


    </xsl:if>
  </xsl:template>

  <xsl:template match="LEI">

    <xsl:call-template name="shim"/>
    <table class="clWidth635 clBorderCell">
      <xsl:if test="$NonResident='NR'">
        <br/>
      </xsl:if>
      <tr>
        <td class="clCouleur2 clWidth126">
          <xsl:if test="$NonResident='NR'">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m00_Idlei'"/>
            </xsl:call-template>
          </xsl:if>
          <xsl:if test="not($NonResident='NR')">
            <xsl:value-of select="$dicoFR/mot[@id='m00_Idlei']"/>
          </xsl:if>
        </td>
        <td class="clTexte clFond clWidth509" colspan="2">
          &#160;<xsl:value-of select="."/>
        </td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template match="IDENTNATIONAL">

    <!--MODULE27-->
    <xsl:if test="not(/FIBEN/PERSONNE/LEI | 
                      /FIBEN/PERSONNE/MODULE27/PM27/*/LEI | 
                      /FIBEN/PERSONNE/MODULE28/PM/*/LEI | 
                      /FIBEN/PERSONNE/MODULE29/PM/*/LEI | 
                      /FIBEN/PERSONNE/MODULE31/PM/*/LEI | 
                      /FIBEN/PERSONNE/MODULE32/PM/*/LEI | 
                      /FIBEN/PERSONNE/MODULE40/PM/*/LEI | 
                      /FIBEN/PERSONNE/MODULEOR/PM/*/LEI) ">
      <xsl:call-template name="shim"/>
    </xsl:if>
    <xsl:if test="(/FIBEN/PERSONNE/MODULE27/PM27)">
      <table class="clWidth635 clBorderCell">
        <caption class="visually-hidden">Identifiant national</caption>
        <xsl:if test="$NonResident='NR'">
          <br/>
        </xsl:if>
        <tr>
          <td class="clCouleur2 clWidth130">
            <xsl:if test="$NonResident='NR'">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m00_Idnatio'"/>
              </xsl:call-template>
            </xsl:if>
            <xsl:if test="not($NonResident='NR')">
              <xsl:value-of select="$dicoFR/mot[@id='m00_Idnatio']"/>
            </xsl:if>
          </td>
          <xsl:if test="/FIBEN/PERSONNE/LEI | 
                        /FIBEN/PERSONNE/MODULE27/PM27/*/LEI |
                        /FIBEN/PERSONNE/MODULE28/PM/*/LEI | 
                        /FIBEN/PERSONNE/MODULE29/PM/*/LEI | 
                        /FIBEN/PERSONNE/MODULE31/PM/*/LEI | 
                        /FIBEN/PERSONNE/MODULE32/PM/*/LEI | 
                        /FIBEN/PERSONNE/MODULE40/PM/*/LEI | 
                        /FIBEN/PERSONNE/MODULEOR/PM/*/LEI ">
            <td class="clTexte clWidth505" colspan="2">
              &#160;<xsl:value-of select="."/>
            </td>
          </xsl:if>
          <xsl:if test="not(/FIBEN/PERSONNE/LEI | 
                      /FIBEN/PERSONNE/MODULE27/PM27/*/LEI | 
                      /FIBEN/PERSONNE/MODULE28/PM/*/LEI | 
                      /FIBEN/PERSONNE/MODULE29/PM/*/LEI | 
                      /FIBEN/PERSONNE/MODULE31/PM/*/LEI | 
                      /FIBEN/PERSONNE/MODULE32/PM/*/LEI | 
                      /FIBEN/PERSONNE/MODULE40/PM/*/LEI | 
                      /FIBEN/PERSONNE/MODULEOR/PM/*/LEI) ">
            <td class="clTexte clFond clWidth505" colspan="2">
              &#160;<xsl:value-of select="."/>
            </td>
          </xsl:if>
        </tr>
      </table>
    </xsl:if>
    <!--AUTRES MODULES-->
    <xsl:if test="not(/FIBEN/PERSONNE/MODULE27/PM27)">
      <table class="clWidth635 clBorderCell">
        <caption class="visually-hidden">Identifiant national</caption>
        <tr>
          <td class="clCouleur2 clWidth130">
            <xsl:if test="$NonResident='NR'">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m00_Idnatio'"/>
              </xsl:call-template>
            </xsl:if>
            <xsl:if test="not($NonResident='NR')">
              <xsl:value-of select="$dicoFR/mot[@id='m00_Idnatio']"/>
            </xsl:if>
          </td>
          <xsl:if test="(/FIBEN/PERSONNE/LEI)">
            <td class="clTexte clWidth505" colspan="2">
              &#160;<xsl:value-of select="."/>
            </td>
          </xsl:if>
          <xsl:if test="not(/FIBEN/PERSONNE/LEI)">
            <td class="clTexte clFond clWidth505" colspan="2">
              &#160;<xsl:value-of select="."/>
            </td>
          </xsl:if>
        </tr>
      </table>
    </xsl:if>

  </xsl:template>

  <xsl:template name="genTitreModule">
    <br/>
    <table class="clWidth635 clBorderCell">
      <caption class="visually-hidden">Titre du module</caption>
      <tr>
        <xsl:if test="$NonResident='NR'">
          <td class="clCouleur1 clValignTop clAlignLeft clWidth617">
            <xsl:if test="$Lang='UK'">
              <xsl:value-of disable-output-escaping="yes" select="document('../../Ressources/XML/DicoLibelleUK.xml')/dictionnaire/titre[@module=$moddem]"/>
            </xsl:if>

            <xsl:if test="$Lang='FR'">
              <xsl:value-of disable-output-escaping="yes" select="$dictionnaire/titre[@module=$moddem]"/>
            </xsl:if>

            <xsl:if test="/FIBEN/@GRAPHE"> - Graphique(s)</xsl:if>
          </td>
        </xsl:if>
        <xsl:if test="not($NonResident='NR')">
          <td class="clCouleur1 clValignTop clAlignLeft clWidth617">
            <xsl:value-of disable-output-escaping="yes" select="$dictionnaire/titre[@module=$moddem]"/>
            <xsl:if test="/FIBEN/@GRAPHE"> - Graphique(s)</xsl:if>
          </td>
        </xsl:if>

       <td class="clValignMiddle clAlignCenter clWidth18">
          <span id="imgNumMod">
            <xsl:value-of select="$moddem"/>
          </span>
        </td>
      </tr>
    </table>
    <br/>
  </xsl:template>


  <xsl:template name="genBasPage">

    <div class="maincontainer horizontal-auto">
      <p id="pConfidentiel">
        <span id="ctl00_lbConfidentiel" >
          <xsl:if test="$NonResident='NR'">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m00_InfCon'"/>
            </xsl:call-template>
          </xsl:if>
          <xsl:if test="$NonResident=''">
            <xsl:value-of select="$dicoFR/mot[@id='m00_InfCon']"/>
          </xsl:if>
        </span>
      </p>
    </div>
    <!-- pied de page -->
    <div id="DivPiedPage" class="maincontainer horizontal-auto clTextCenter" >
      <!-- ligne des menus aide, info, plan, contacts -->
      <div class="clBandeauBoutons3">
        <ul id="lstBoutonsPiedPage" class="lstBoutonsPiedPage colorBodyNewHome">
          <li>
            <span id="btbdf" class="clTransparent clTitreGris " >&#169; Banque de France 2016</span>
          </li>

          <xsl:if test="$Lang='FR'">
            <li>
              <button aria-label="Contacts" title="lien vers la page Contacts" id="btContacts" class="clTransparent clTitreGris" onclick="requestStatic(&#39;&#39;,cstContact);return false;">Contacts</button>
            </li>
            <li>
              <button aria-label="Portail" title="lien vers la Portail" id="btPortail" class="clTransparent clTitreGris" onclick="requestStatic(&#39;&#39;,cstPortail);return false;">Portail</button>
            </li>
            <li>
              <button aria-label="Accessibilit" title="lien vers le document Accessibilit" id="btAccessibilite" class="clTransparent clTitreGris" onclick="requestStatic(&#39;&#39;,cstAccesPdfRapport);return false;">Accessibilit</button>
            </li>
            <li>
              <button aria-label="banque-france.fr" title="lien vers le site banque-france.fr" id="btBdf" class="clTransparent clTitreGris" onclick="requestStatic(&#39;&#39;,cstSiteBDF);return false;">banque-france.fr</button>
            </li>
          </xsl:if>
          <xsl:if test="$Lang=''">
            <li>
              <button aria-label="Contacts" title="lien vers la page Contacts" id="btContacts" class="clTransparent clTitreGris" onclick="requestStatic(&#39;&#39;,cstContact);return false;">Contacts</button>
            </li>
            <li>
              <button aria-label="Portail" title="lien vers la page Portails" id="btPortail" class="clTransparent clTitreGris" onclick="requestStatic(&#39;&#39;,cstPortail);return false;">Portail</button>
            </li>
            <li>
              <button aria-label="Accessibilit" title="lien vers le document Accessibilit" id="btAccessibilite" class="clTransparent clTitreGris" onclick="requestStatic(&#39;&#39;,cstAccesPdfRapport);return false;">Accessibilit</button>
            </li>
            <li>
              <button aria-label="banque-france.fr=" title="lien vers le site banque-france.fr" id="btBdf" class="clTransparent clTitreGris" onclick="requestStatic(&#39;&#39;,cstSiteBDF);return false;">banque-france.fr</button>
            </li>
          </xsl:if>
          <xsl:if test="$Lang='UK'">
            <li>
              <button aria-label="Contact us" title="lien vers la page Contacts" id="btContacts" class="clTransparent clTitreGris" onclick="requestStatic(&#39;&#39;,cstContactUK);return false;">Contact us</button>
            </li>
            <li>
              <button aria-label="Portal" title="lien vers la page Portail" id="btPortail" class="clTransparent clTitreGris" onclick="requestStatic(&#39;&#39;,cstPortail);return false;">Portal</button>
            </li>
            <li>
              <button aria-label="Accessibility" title="lien vers le document Accessibilit" id="btAccessibilite" class="clTransparent clTitreGris" onclick="requestStatic(&#39;&#39;,cstAccesPdfRapportUK);return false;">Accessibility</button>
            </li>
            <li>
              <button aria-label="banque-france.fr=" title="lien vers le site banque-france.fr" id="btBdfUK" class="clTransparent clTitreGris" onclick="requestStatic(&#39;&#39;,cstSiteBDF);return false;">banque-france.fr</button>
            </li>
          </xsl:if>


        </ul>
      </div>

    </div>


  </xsl:template>

  <xsl:template name="genFlecheHaut">
    <td class="clWidth53 clAlignRight">
      <a href="#ancHaut">
        <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page" />
      </a>
    </td>
  </xsl:template>

  <xsl:template name="genFondMenu">
    <xsl:param name="root" select="''"/>
    <xsl:param name="type" select="''"/>
    <a id="ancHaut" name="ancHaut"></a>
    <div id="DivEntete" class="maincontainer horizontal-auto" >
      <div onmouseover="cacheMenus();" class="clBandeauLogos" >
        <!-- haut de l'entete  3 div pour ligne des logos -->
        <div class="divLogoG" >
          <a href="{$root}home.aspx">
            <img id="imgLogoFiben" src="{$root}Images/commun/Logo-BDF-FIBEN_bleu.png" width="100%" style="border-width:0px;"  alt="le logo Banque de France eurosystme pour un retour  la page d'acceuil" title="Accueil"/>
          </a>
        </div>
        <div class="divLogoC"  >
          <span id="lbTitre1" class="clTitreBleu clFloatLeft">
            <xsl:value-of select="$dictionnaire/titre[@module='Z0']"/>
          </span>
          <br />
          <xsl:choose >
            <xsl:when test="$type='ralph'">
              <div id="titreEnteteFiben">
                <span id="lbTitre2" class="clTitreGris">
                  <xsl:value-of select="$dictionnaire/mot[@id='SERV']"/>
                </span>
                <span id="ctl00_lbTitre3" class="clTitreBleu ">
                  &#160;
                  <xsl:value-of select="$dictionnaire/mot[@id='MAITRISQ']"/>
                </span>
              </div>
            </xsl:when>
            <xsl:when test="$type='suivi'">
              <div  id="titreEnteteFiben">
                <span id="lbTitre2" class="clTitreBleu">Suividirect </span>
              </div>
            </xsl:when>
            <xsl:otherwise>
              <form id="frmIdentOuNom" method="get" target="" action="javascript:moduleRequest('',window.document.location);">
                <div id="titreEnteteFiben" >
                  <span id="lbTitre2" class="clTitreGris clFont12" title="Nouvel identifiant">
                    <xsl:if test="$NonResident='NR'">
                      <xsl:call-template name="tradlib">
                        <xsl:with-param name="Lang" select="$Lang"/>
                        <xsl:with-param name="codeLib" select="'m00_NouIde'"/>
                      </xsl:call-template>
                    </xsl:if>
                    <xsl:if test="$NonResident=''">
                      <xsl:value-of select="$dicoFR/mot[@id='m00_NouIde']"/>
                    </xsl:if>
                  </span>
                  &#160;<input type="text" id="ident" size="20" value="" class="clinputIdent colorBodyNewHome" />
                  <button aria-label="New ident" class="clbtNewIdent clAlignBottom" onclick="document.forms['frmIdentOuNom'].Submit;" ></button>
                </div>
              </form>
            </xsl:otherwise>
          </xsl:choose>
        </div>
      </div>
    </div>

  </xsl:template>

  <xsl:template name="genLigneConfidentiel">
    <tr>
       <td class="clWidth64">
        <img src="{$root}Images/Commun/shim.gif" width="14" height="15" alt=""/>
      </td>
      <td  class="clTexteGras" colspan="2">
        <span style="width:550; float:left">
          <xsl:if test="$NonResident='NR'">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m00_Conf'"/>
            </xsl:call-template>
          </xsl:if>
          <xsl:if test="$NonResident=''">
            <xsl:value-of select="$dicoFR/mot[@id='m00_Conf']"/>
          </xsl:if>
        </span>
        <span style="width:80; text-align:right; float:left">
          <xsl:call-template name ="displayDateJourXsl">
            <xsl:with-param name ="InputDate" select ="(/FIBEN/@DATJOUR)"/>
          </xsl:call-template>
        </span>
      </td>
      <td class="clTexteGras clAlignRight">

      </td>

    </tr>

  </xsl:template>

  <xsl:template match="DATBILS">
    <a name="ancCotation"></a>
    <table class="clWidth635 clBorderCell">
      <caption class="visually-hidden">Informations Dernier bilan social</caption>
      <tr>
        <th class="clCouleur2 clWidth392 clAlignLeft clThNonGras clBoxSizing">
          <xsl:if test="$NonResident='NR'">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m00_DeBiSo'"/>
            </xsl:call-template>
          </xsl:if>
          <xsl:if test="not($NonResident='NR')">
            <xsl:value-of select="$dicoFR/mot[@id='m00_DeBiSo']"/>
          </xsl:if>
        </th>
        <td class="clFond clWidth243 clAlignLeft clBoxSizing">
          &#160;<xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="(.)"/>
          </xsl:call-template>
        </td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template match="DATBILC">
    <a name="ancCotation"></a>
    <xsl:variable name="existDatbils" select="../DATBILS"/>
    <table class="clWidth635 clBorderCell">
      <caption class="visually-hidden">Informations Dernier bilan consolid</caption>
      <tr>
        <th class="clCouleur2 clWidth392 clAlignLeft clThNonGras clBoxSizing">
          <xsl:if test="$NonResident='NR'">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m00_DeBiCo'"/>
            </xsl:call-template>
          </xsl:if>
          <xsl:if test="$NonResident=''">
            <xsl:value-of select="$dicoFR/mot[@id='m00_DeBiCo']"/>
          </xsl:if>
        </th>
        <xsl:if test="not($existDatbils)">
          <td class="clFond clWidth243 clAlignLeft clBoxSizing">
            &#160;<xsl:call-template name ="displayDateXsl">
              <xsl:with-param name ="InputDate" select ="(.)"/>
            </xsl:call-template>
          </td>
        </xsl:if>
        <xsl:if test="$existDatbils">
          <td class="clTexte clWidth243 clAlignLeft clBoxSizing">
            &#160;<xsl:call-template name ="displayDateXsl">
              <xsl:with-param name ="InputDate" select ="(.)"/>
            </xsl:call-template>
          </td>
        </xsl:if>
      </tr>
    </table>

  </xsl:template>

  <xsl:template match="COTPREC">
    <xsl:variable name="existDatbil" select="count(../DATBILS)+count(../DATBILC)"/> 
    <xsl:variable name ="datcot" select ="DATCOT"></xsl:variable>
    <xsl:variable name ="jourdatcot" select="substring(DATCOT, 1,2)"></xsl:variable>
    <xsl:variable name ="moisdatcot" select="substring(DATCOT, 3,2)"></xsl:variable>
    <xsl:variable name ="anneedatcot" select="substring(DATCOT, 5,4)"></xsl:variable>
      
        
    <table class="clWidth635 clBorderCell">
      <caption class="visually-hidden">Informations cotation prcdente</caption>
      <xsl:if test="position() mod 2 != 0">
        <tr>
          <xsl:if test="/FIBEN/PERSONNE/MODULE27/PP | /FIBEN/PERSONNE/MODULE37/PP37 | /FIBEN/PERSONNE/MODULE37/PPEI37">
            <xsl:if test="$NonResident='NR'">
              <th class="clCouleur2 clWidth392 clAlignLeft clThNonGras clBoxSizing">
                <xsl:call-template name="tradlib">
                  <xsl:with-param name="Lang" select="$Lang"/>
                  <xsl:with-param name="codeLib" select="'m27_IndPre'"/>
                </xsl:call-template>
              </th>
            </xsl:if>
            <xsl:if test="$NonResident=''">
              <th class="clCouleur2 clWidth392 clAlignLeft clThNonGras clBoxSizing">
                <xsl:value-of select="$dicoFR/mot[@id='m27_IndPre']"/>
              </th>
            </xsl:if>
          </xsl:if>
          <xsl:if test="((/FIBEN/PERSONNE/MODULE27/PM27/EI27) | (/FIBEN/PERSONNE/MODULE27/PM27/EJ27) | (/FIBEN/PERSONNE/MODULEDE/EIPP ) | (/FIBEN/PERSONNE/MODULEDE/EJ) |(/FIBEN/PERSONNE/MODULEAN/EJ) | (/FIBEN/PERSONNE/MODULE37/PM37/EJ37) | (/FIBEN/PERSONNE/MODULE37/PM37/EI37))">
            <xsl:if test="$NonResident='NR'">
              <th class="clCouleur2 clWidth392 clAlignLeft clThNonGras clBoxSizing">
                <xsl:call-template name="tradlib">
                  <xsl:with-param name="Lang" select="$Lang"/>
                  <xsl:with-param name="codeLib" select="'m27_CotPre'"/>
                </xsl:call-template>
              </th>
            </xsl:if>
            <xsl:if test="$NonResident=''">
              <th class="clCouleur2 clWidth392 clAlignLeft clThNonGras clBoxSizing">
                <xsl:value-of select="$dicoFR/mot[@id='m27_CotPre']"/>
              </th>
            </xsl:if>
          </xsl:if>
          <xsl:if test="$existDatbil=0 or $existDatbil=2"> 
            
              <!--recherche si la date de cotation est suprieur au 11/12/2026 alors ne pas afficher la popup (mise en place du nouveau seuil de la cote d'activit le 11/01/2025) -->
              <xsl:choose>
                   <xsl:when test ="$anneedatcot &gt; '2026'">  
                    <!--pas de popup-->  
                      <td class="clFond clWidth69 clBoxSizing">
                      &#160;<xsl:value-of select="VALCOT"/>
                      </td>
                    </xsl:when> 
                    <xsl:otherwise>
                      <xsl:choose>
                          <xsl:when test ="$anneedatcot = '2026'">
                            <xsl:choose>
                              <xsl:when test ="$moisdatcot = '12'">
                                <xsl:choose>
                                  <xsl:when test ="$jourdatcot &gt; '11'">
                                    <!--pas de popup-->
                                    <td class="clFond clWidth69 clBoxSizing">
                                      &#160;<xsl:value-of select="VALCOT"/>
                                    </td>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <!--affiche la popup-->
                                    <td class="clFond clWidth69 clBoxSizing">
                                      &#160;<a href="#nullePart" onclick="requestInfosLibelle('LIBCOTEHJ',cstWordingNew)" class="clTexte">
                                        <u>
                                          <xsl:value-of select="VALCOT"/>
                                        </u>
                                      </a>
                                    </td>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </xsl:when>
                              <xsl:otherwise>
                                <!--affiche la popup-->
                                <td class="clFond clWidth69 clBoxSizing">
                                  &#160;<a href="#nullePart" onclick="requestInfosLibelle('LIBCOTEHJ',cstWordingNew)" class="clTexte">
                                    <u>
                                      <xsl:value-of select="VALCOT"/>
                                    </u>
                                  </a>
                                </td>
                              </xsl:otherwise>                              
                            </xsl:choose> 
                          </xsl:when>
                          <xsl:otherwise>
                            <!--affiche la popup-->
                            <td class="clFond clWidth69 clBoxSizing">
                              &#160;<a href="#nullePart" onclick="requestInfosLibelle('LIBCOTEHJ',cstWordingNew)" class="clTexte">
                                <u>
                                  <xsl:value-of select="VALCOT"/>
                                </u>
                              </a>
                            </td>
                          </xsl:otherwise>
                      </xsl:choose>
                    </xsl:otherwise>
               </xsl:choose>
            
            <th class="clCouleur2 clWidth105 clAlignCenter clThNonGras clBoxSizing">Date</th>

            <td class="clFond clWidth69 clBoxSizing">
              &#160;<xsl:call-template name ="displayDateXsl">
                <xsl:with-param name ="InputDate" select ="(DATCOT)"/>
              </xsl:call-template>
            </td>
          </xsl:if>
          <xsl:if test="$existDatbil=1">
            <xsl:choose >
              <xsl:when test ="((/FIBEN/PERSONNE/MODULE37/PM37/EJ37) | (/FIBEN/PERSONNE/MODULE37/PM37/EI37))">
                 <!--recherche si la date de cotation est suprieur au 11/12/2026 alors ne pas afficher la popup (mise en place du nouveau seuil de la cote d'activit le 11/01/2025) -->
               <xsl:choose>
                   <xsl:when test ="$anneedatcot &gt; '2026'">  
                    <!--pas de popup-->  
                      <td class="clFond clWidth69 clBoxSizing">
                      &#160;<xsl:value-of select="VALCOT"/>
                      </td>
                    </xsl:when> 
                    <xsl:otherwise>
                      <xsl:choose>
                          <xsl:when test ="$anneedatcot = '2026'">
                            <xsl:choose>
                              <xsl:when test ="$moisdatcot = '12'">
                                <xsl:choose>
                                  <xsl:when test ="$jourdatcot &gt; '11'">
                                    <!--pas de popup-->
                                    <td class="clFond clWidth69 clBoxSizing">
                                      &#160;<xsl:value-of select="VALCOT"/>
                                    </td>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <!--affiche la popup-->
                                    <td class="clFond clWidth69 clBoxSizing">
                                      &#160;<a href="#nullePart" onclick="requestInfosLibelle('LIBCOTEHJ',cstWordingNew)" class="clTexte">
                                        <u>
                                          <xsl:value-of select="VALCOT"/>
                                        </u>
                                      </a>
                                    </td>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </xsl:when>
                              <xsl:otherwise>
                                <!--affiche la popup-->
                                <td class="clFond clWidth69 clBoxSizing">
                                  &#160;<a href="#nullePart" onclick="requestInfosLibelle('LIBCOTEHJ',cstWordingNew)" class="clTexte">
                                    <u>
                                      <xsl:value-of select="VALCOT"/>
                                    </u>
                                  </a>
                                </td>
                              </xsl:otherwise>                              
                            </xsl:choose> 
                          </xsl:when>
                          <xsl:otherwise>
                            <!--affiche la popup-->
                            <td class="clFond clWidth69 clBoxSizing">
                              &#160;<a href="#nullePart" onclick="requestInfosLibelle('LIBCOTEHJ',cstWordingNew)" class="clTexte">
                                <u>
                                  <xsl:value-of select="VALCOT"/>
                                </u>
                              </a>
                            </td>
                          </xsl:otherwise>
                      </xsl:choose>
                    </xsl:otherwise>
               </xsl:choose>
              
                <th class="clCouleur2 clWidth105 clAlignCenter clThNonGras clBoxSizing">Date</th>
                <td class="clFond clWidth69 clBoxSizing">
                  &#160;<xsl:call-template name ="displayDateXsl">
                    <xsl:with-param name ="InputDate" select ="(DATCOT)"/>
                  </xsl:call-template>
                </td>
              </xsl:when>
              <xsl:otherwise>
                <xsl:choose>
                  <xsl:when test ="$anneedatcot &gt; '2026'">
                    <!--pas de popup-->
                    <td class="clFond clWidth69 clBoxSizing">
                      &#160;<xsl:value-of select="VALCOT"/>
                    </td>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:choose>
                      <xsl:when test ="$anneedatcot = '2026'">
                        <xsl:choose>
                          <xsl:when test ="$moisdatcot = '12'">
                            <xsl:choose>
                              <xsl:when test ="$jourdatcot &gt; '11'">
                                <!--pas de popup-->
                                <td class="clFond clWidth69 clBoxSizing">
                                  &#160;<xsl:value-of select="VALCOT"/>
                                </td>
                              </xsl:when>
                              <xsl:otherwise>
                                <!--affiche la popup-->
                                <td class="clFond clWidth69 clBoxSizing">
                                  &#160;<a href="#nullePart" onclick="requestInfosLibelle('LIBCOTEHJ',cstWordingNew)" class="clTexte">
                                    <u>
                                      <xsl:value-of select="VALCOT"/>
                                    </u>
                                  </a>
                                </td>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:when>
                          <xsl:otherwise>
                            <!--affiche la popup-->
                            <td class="clFond clWidth69 clBoxSizing">
                              &#160;<a href="#nullePart" onclick="requestInfosLibelle('LIBCOTEHJ',cstWordingNew)" class="clTexte">
                                <u>
                                  <xsl:value-of select="VALCOT"/>
                                </u>
                              </a>
                            </td>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <!--affiche la popup-->
                        <td class="clFond clWidth69 clBoxSizing">
                          &#160;<a href="#nullePart" onclick="requestInfosLibelle('LIBCOTEHJ',cstWordingNew)" class="clTexte">
                            <u>
                              <xsl:value-of select="VALCOT"/>
                            </u>
                          </a>
                        </td>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:otherwise>
                </xsl:choose>
                
                <th class="clCouleur2 clWidth105 clAlignCenter clThNonGras clBoxSizing">Date</th>
                <td class="clTexte clWidth69 clBoxSizing">
                  &#160;<xsl:call-template name ="displayDateXsl">
                    <xsl:with-param name ="InputDate" select ="(DATCOT)"/>
                  </xsl:call-template>
                </td>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:if>
        </tr>
      </xsl:if>
      <xsl:if test="position() mod 2 = 0">
        <tr>
          <xsl:if test="$existDatbil=0 or $existDatbil=2">
            <td class="clCouleur2 clWidth392 clBoxSizing">&#160;</td>
            <xsl:choose>
              <xsl:when test ="$anneedatcot &gt; '2026'">
                <!--pas de popup-->
                <td class="clFond clWidth69 clBoxSizing">
                  &#160;<xsl:value-of select="VALCOT"/>
                </td>
              </xsl:when>
              <xsl:otherwise>
                <xsl:choose>
                  <xsl:when test ="$anneedatcot = '2026'">
                    <xsl:choose>
                      <xsl:when test ="$moisdatcot = '12'">
                        <xsl:choose>
                          <xsl:when test ="$jourdatcot &gt; '11'">
                            <!--pas de popup-->
                            <td class="clFond clWidth69 clBoxSizing">
                              &#160;<xsl:value-of select="VALCOT"/>
                            </td>
                          </xsl:when>
                          <xsl:otherwise>
                            <!--affiche la popup-->
                            <td class="clFond clWidth69 clBoxSizing">
                              &#160;<a href="#nullePart" onclick="requestInfosLibelle('LIBCOTEHJ',cstWordingNew)" class="clTexte">
                                <u>
                                  <xsl:value-of select="VALCOT"/>
                                </u>
                              </a>
                            </td>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <!--affiche la popup-->
                        <td class="clFond clWidth69 clBoxSizing">
                          &#160;<a href="#nullePart" onclick="requestInfosLibelle('LIBCOTEHJ',cstWordingNew)" class="clTexte">
                            <u>
                              <xsl:value-of select="VALCOT"/>
                            </u>
                          </a>
                        </td>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:otherwise>
                    <!--affiche la popup-->
                    <td class="clFond clWidth69 clBoxSizing">
                      &#160;<a href="#nullePart" onclick="requestInfosLibelle('LIBCOTEHJ',cstWordingNew)" class="clTexte">
                        <u>
                          <xsl:value-of select="VALCOT"/>
                        </u>
                      </a>
                    </td>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:otherwise>
            </xsl:choose>
            
           <th class="clCouleur2 clWidth105 clHeight18 clAlignCenter clThNonGras clBoxSizing">Date</th>
            <td class="clTexte clWidth69 clHeight18 clBoxSizing">
              &#160;<xsl:call-template name ="displayDateXsl">
                <xsl:with-param name ="InputDate" select ="(DATCOT)"/>
              </xsl:call-template>
            </td>
          </xsl:if>
          <xsl:if test="$existDatbil=1">
            <td class="clCouleur2 clWidth392 clBoxSizing">&#160;</td>
            <xsl:choose>
              <xsl:when test ="$anneedatcot &gt; '2026'">
                <!--pas de popup-->
                <td class="clFond clWidth69 clBoxSizing">
                  &#160;<xsl:value-of select="VALCOT"/>
                </td>
              </xsl:when>
              <xsl:otherwise>
                <xsl:choose>
                  <xsl:when test ="$anneedatcot = '2026'">
                    <xsl:choose>
                      <xsl:when test ="$moisdatcot = '12'">
                        <xsl:choose>
                          <xsl:when test ="$jourdatcot &gt; '11'">
                            <!--pas de popup-->
                            <td class="clFond clWidth69 clBoxSizing">
                              &#160;<xsl:value-of select="VALCOT"/>
                            </td>
                          </xsl:when>
                          <xsl:otherwise>
                            <!--affiche la popup-->
                            <td class="clFond clWidth69 clBoxSizing">
                              &#160;<a href="#nullePart" onclick="requestInfosLibelle('LIBCOTEHJ',cstWordingNew)" class="clTexte">
                                <u>
                                  <xsl:value-of select="VALCOT"/>
                                </u>
                              </a>
                            </td>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <!--affiche la popup-->
                        <td class="clFond clWidth69 clBoxSizing">
                          &#160;<a href="#nullePart" onclick="requestInfosLibelle('LIBCOTEHJ',cstWordingNew)" class="clTexte">
                            <u>
                              <xsl:value-of select="VALCOT"/>
                            </u>
                          </a>
                        </td>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:otherwise>
                    <!--affiche la popup-->
                    <td class="clFond clWidth69 clBoxSizing">
                      &#160;<a href="#nullePart" onclick="requestInfosLibelle('LIBCOTEHJ',cstWordingNew)" class="clTexte">
                        <u>
                          <xsl:value-of select="VALCOT"/>
                        </u>
                      </a>
                    </td>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:otherwise>
            </xsl:choose>
            
           <th class="clCouleur2 clWidth105 clHeight18 clAlignCenter clThNonGras clBoxSizing">Date</th>
            <td class="clFond clWidth69 clHeight18 clBoxSizing">
              &#160;<xsl:call-template name ="displayDateXsl">
                <xsl:with-param name ="InputDate" select ="(DATCOT)"/>
              </xsl:call-template>
            </td>
          </xsl:if>
        </tr>
      </xsl:if>
    </table>
  </xsl:template>

  <xsl:template match="INDPREC">

    <table class="clWidth635 clBorderCell">
      <caption class="visually-hidden">Informations indicateur prcedent</caption>
      <tr>
        <xsl:if test="position() mod 2 != 0">
          <xsl:if test="((/FIBEN/PERSONNE/MODULE27/PM27/EI27) | (/FIBEN/PERSONNE/MODULEDE/EIPP))">
            <xsl:if test="$NonResident='NR'">
              <th class="clCouleur2 clWidth392 clAlignLeft clThNonGras clBoxSizing">
                <xsl:call-template name="tradlib">
                  <xsl:with-param name="Lang" select="$Lang"/>
                  <xsl:with-param name="codeLib" select="'m27_IndPre'"/>
                </xsl:call-template>
              </th>
            </xsl:if>
            <xsl:if test="$NonResident=''">
              <th class="clCouleur2 clWidth392 clAlignLeft clThNonGras clBoxSizing">
                <xsl:value-of select="$dicoFR/mot[@id='m27_IndPre']"/>
              </th>
            </xsl:if>
          </xsl:if>


          <td class="clFond clWidth69">
            &#160;<xsl:value-of select="VALINDIC"/>
          </td>
          <th class="clCouleur2 clWidth105 clAlignCenter clThNonGras clBoxSizing">Date</th>
          <td class="clFond clWidth69 clBoxSizing">
            &#160;<xsl:call-template name ="displayDateXsl">
              <xsl:with-param name ="InputDate" select ="(DATINDIC)"/>
            </xsl:call-template>
          </td>

        </xsl:if>
      </tr>
      <xsl:if test="position() mod 2 = 0">
        <tr>

          <td class="clCouleur2 clWidth392 clBoxSizing">&#160;</td>
          <td class="clTexte clWidth69 clBoxSizing">
            &#160;<xsl:value-of select="VALINDIC"/>
          </td>
         <th class="clCouleur2 clWidth105 clHeight18 clAlignCenter clThNonGras clBoxSizing">Date</th>
          <td class="clTexte clWidth69 clHeight18 clBoxSizing">
            &#160;<xsl:call-template name ="displayDateXsl">
              <xsl:with-param name ="InputDate" select ="(DATINDIC)"/>
            </xsl:call-template>
          </td>

        </tr>
      </xsl:if>
    </table>
  </xsl:template>

  <xsl:template match="FONCTCOT">
    &#160;<xsl:apply-templates select="*[position()=1]"/>
  </xsl:template>

  <xsl:template match="ERREUR">
    <xsl:param name="alerte" select="'true'"/>
    <tr>
      <td class="clWidth14"></td>
      <td colspan="4">
        <xsl:call-template name="genTitreModule" />
        <!--07/11/2008 genidentificaiton si ident vide = erreur call move next produite par javascript displayident -->
        <xsl:if test="IDENT = '' ">
          <xsl:variable name ="idnonvide" select ="'_'"  />
          <xsl:call-template name="genIdentification">
            <xsl:with-param name="ident" select="$idnonvide"/>
          </xsl:call-template>
        </xsl:if>
        <xsl:if test="IDENT != '' " >
          <xsl:variable name ="idnonvide" select ="IDENT"  />
          <xsl:call-template name="genIdentification">
            <xsl:with-param name="ident" select="$idnonvide"/>
          </xsl:call-template>
        </xsl:if>


      </td>
    </tr>
    <tr>
      <td class="clWidth14"></td>
      <td colspan="4">&#160;</td>
    </tr>
    <tr>
      <td class="clWidth14"></td>
      <td colspan="4">
        <xsl:call-template name="shim"/>
      </td>
    </tr>
    <tr>
      <td class="clWidth14"></td>
      <td colspan="3" class="clCouleur2 clValignTop">
        <xsl:apply-templates select="MSG/UT|MSG/UCR/*|MSG/IET01"/>
      </td>
      <td>&#160;</td>
    </tr>
    <!--cas particulier du module OD : il faut en plus du message d'erreur un lien vers le module 56-->
    <xsl:if test ="$moddem = 'OD'">
      <!--liens vers module 56-->
      <xsl:if test="MSG/UCR/IST06 | MSG/UCR/IST09 | MSG/UCR/U101">
        <tr>
          <td class="clWidth64"></td>
          <td colspan="4">
            <xsl:call-template name="shim"/>
          </td>
        </tr>
        <tr>
          <td class="clWidth64"></td>
          <td class="clCouleur2 clWidth411 clHeight10 clValignMiddle">
            <xsl:value-of select="($dictionnaire/mot[@id='OD56'])"></xsl:value-of>
          </td>
          <td class="clWidth220 clHeight10 clValignMiddle clAlignRight">
            <a href="#nullepart" onClick="requestBDFInfos('56','','{$familyNumber}','{EJ/IDENTS}',cstSimpleConfirm);">
              <img src="{$root}images/Commun/clignotant2.gif" width="85" height="12" border="0" align="absbottom" alt="plus d'infos"/>
            </a>
          </td>
          <td>&#160;</td>
        </tr>
      </xsl:if>
    </xsl:if>
    <tr>
      <td class="clWidth14"></td>
      <td colspan="4">
        <xsl:call-template name="shim"/>
      </td>
    </tr>
    <tr class="clHeight50">
      <td class="clWidth442" colspan="2"></td>

      <td class="clWidth78"></td>
      <!--<xsl:call-template name="genFlecheHaut"/>-->
    </tr>
    <!--<xsl:call-template name="genBasPage"/>-->
  </xsl:template>


  <xsl:template name="tradlib">
    <xsl:param name="codeLib"/>
    <!--xsl:value-of select="$Lang"/-->
    <xsl:if test="$Lang='FR'">
      <xsl:value-of select="$dicoFR/mot[@id=$codeLib]"/>
    </xsl:if>
    <xsl:if test="$Lang='UK'">
      <xsl:value-of select="$dicoUK/mot[@id=$codeLib]"/>
    </xsl:if>
  </xsl:template>

  <xsl:template name="tradLibNaf">
    <xsl:param name="codelib"/>
    <xsl:if test="$Lang = 'FR'">
      <xsl:value-of select="$dictionnaire/division/ssclasse[@id=$codelib]"/>
    </xsl:if>
    <xsl:if test="$Lang = 'UK'">
      <xsl:variable name="dictionnaire" select="document('../../Ressources/XML/DicoLibelleUK.xml')/dictionnaire"/>
      <xsl:value-of select="$dictionnaire/division/ssclasse[@id=$codelib]"/>
    </xsl:if>
  </xsl:template>


</xsl:stylesheet>
