﻿var menus = ['sMenuIdentite', 'sMenuRisque', 'sMenuDirAss', 'sMenuFinance', 'sMenuDossiers', 'sMenuSuivis', 'sMenuBDF', 'sMenuRisqueNRFR', 'sMenuRisqueNRUK'];
var menusDAS = ['infoSession'];
var menusNR = ['sMenuRisqueNRFR', 'sMenuRisqueNRUK'];

//variables globales pour la home page, 
//afin de determiner ce qui a ete saisi dans les differentes zones identifiants (multi identifiants)
var isClefBDF = false;
var isKO = false;
var isMultiID = false;
var isSimpleID = false;
//---------------------------------

function SwapImageOn(obj) {

    var src = obj.src;
    if (src.indexOf('_off.gif') > 0) {
        var srcOn = src.substr(0, obj.src.indexOf('_off.gif'));
        obj.src = srcOn + '_on.gif';
    }
}

function SwapImageOff(obj) {
    var src = obj.src;
    if (src.indexOf('_on.gif') > 0) {
        var srcOn = src.substr(0, obj.src.indexOf('_on.gif'));
        obj.src = srcOn + '_off.gif';
    }
}

function clearTbx(ctrlID) {
    var obj = document.getElementById(ctrlID);
    if (obj != null) {
        if (obj.disabled == false) {
            obj.value = '';
        }
    }
}

function clearAllTbx(objID) {
    var obj = document.getElementById(objID);
    if (obj != null) {
        var elements = obj.getElementsByTagName("input");
        for (var i = 0; i < elements.length; i++) {
            if (elements[i].type == "text") {
                elements[i].value = '';
            }
        }
    }
}


function clearObjTextbox(obj) {
    if (obj != null) {
        if (obj.disabled == false) {
            obj.value = '';
        }
    }
}

function initCheckBox(ctrlID, state) {
    const elements = document.querySelectorAll('[id]');

    const match = Array.from(elements).find(el => el.id.includes(ctrlID));
    if (match) {
        match.checked = state;
    }

}

function initDDL(ctrlID, index) {
    var obj = document.getElementById(ctrlID);
    if (obj != null) {
        obj.selectedIndex = index;
    }
}

// verifie que l'on a saisi dans la zone multi identifiant un identifiant valide et compatible clef bdf eventuellement
function validateId(source, arguments) {
    var sIdent = arguments.Value;
    var Type = iCheckIdentifiant(sIdent);

    if (Type == cstNothing) {
        arguments.IsValid = false;
    } else if (Type == cstBDFKey) {
        var sMod = document.getElementById('txt_mod').value
        if (sMod != '') {
            if (cstValidModuleList4BDFKeys.indexOf("|" + sMod.toUpperCase() + "|") > 0) {
                arguments.IsValid = true;
            } else {
                arguments.IsValid = false;
            }
        }

    } else {
        arguments.IsValid = true;
    }
}

function validateIdSimple(source, arguments) {
    var sIdent = arguments.Value;
    var Type = iCheckIdentifiant(sIdent);

    if (Type == cstNothing) {
        arguments.IsValid = false;
    } else {
        arguments.IsValid = true;
    }
}

function validateModPourClefBDF(source, arguments) {
    var sMod = arguments.Value;
    var sIdent = document.getElementById('ident').value;

    //'si module n'est pas dans la liste des modules on sort du test car déjà vérifié par validateModAutorise
    var lstModAuto = document.getElementById('MPhfModautorises').value;

    if ((lstModAuto.indexOf("|" + sMod.toUpperCase() + "|") > 0) && (sMod.toUpperCase() != "07")) {

        if (sIdent != '') {
            var Type = iCheckIdentifiant(sIdent);

            if (Type == cstBDFKey) {
                var iIndex = cstValidModuleList4BDFKeys.indexOf("|" + sMod.toUpperCase() + "|");
                if (iIndex == -1) {
                    arguments.IsValid = false;
                }
            } else {
                arguments.IsValid = true;
            }
        }
    }
}

function validateModAutorise(source, arguments) {
    var sMod = arguments.Value;
    var lstModAuto = document.getElementById('MPhfModautorises').value;
    var lstModSpec = document.getElementById('MPhfModSpeciaux').value;

    var iIndexMS = lstModSpec.indexOf("|" + sMod.toUpperCase() + "|");
    if (iIndexMS == -1) {
        arguments.IsValid = lstModAuto.indexOf("|" + sMod.toUpperCase() + "|") >= 0;
    }
    else {
        arguments.IsValid = false;
    }
}

//fonctions de validation des champs des saisie nouvelle home page
function validateNewHome(source, arguments) {
    arguments.IsValid = true;

    if (!verifIdentsHomepage) {
        arguments.IsValid = false;
        source.errormessage = "Identifiant non précisé";
    }
}

//renvois true si on a saisi quelquechose dans l'une des zones de saisie identifiant 
//sinon false si rien de saisi dans au moins un identifiant
//met a jour des var globales pour savoir le type d'identifiants renseignés
//menuNR booleen qui indique si l'on a la zone multi identifiants ou non 
function verifIdentsHomepage(menuNR) {
    if (typeof menuNR === 'undefined') {
        menuNR = false;
    }
    var hident = document.getElementById("ident");
    var ident = '';
    if (hident != null) {
        var multiId;
        var ident = hident.value.trim();

        isClefBDF = false;
        isKO = false;
        isMultiID = false;
        isSimpleID = (ident.length > 0);

        if (isSimpleID) {
            verifType(iCheckIdentifiant(ident));
        }

        if (!menuNR) {
            for (i = 1; i <= 10; i++) {
                multiId = document.getElementById("identM" + i).value;
                ident += multiId;
                if (multiId.length > 0) {
                    isMultiID = true;
                    verifType(iCheckIdentifiant(multiId));
                }
            }
        }
    }

    if (ident.length <= 0) {
        return false;
    } else {
        return true;
    }
}

function verifType(typ) {
    switch (typ) {
        case cstNothing:
            isKO = true;
            break;
        case cstBDFKey:
            isClefBDF = true;
            break;
        default:
            isKO = false;
            isClefBDF = false;
    }
}

function validateRechercheAvancee() {
    var oInput = MM_findObj('txt_denom');
    var ok;
    if (oInput.value != "") {
        ok = true;
    } else {
        oInput = MM_findObj('txt_coac');
        if (oInput.value != "") {
            ok = testCPouVille();
        } else {
            ok = testNomRue();
        }
    }
    if (!ok) {
        return false;
    }
    return true;
}

function CacheSousMenuMod(obj) {
    var sMenu = document.getElementById(obj.id);
    if (event.target != null) {
        if (sMenu.style.display == "block") {
            sMenu.style.display = "none";
        }
    }
}

function cacheMenus() {
    // cacher tout sous menu de type DAS et modules
    cacheMenu(menusDAS, null);
    cacheMenu(menus, null);
}

function cacheMenu(menu, idMenu) {
    for (var i = 0; i < menu.length; i++) {
        if ((idMenu == null) || (menu[i] != idMenu)) {
            var divMenu = document.getElementById(menu[i]);
            if (divMenu != null) { divMenu.style.display = 'none'; }
        }
    }
}

//gestion affichage sous menus depuis master page
//si une zone identifiant (demande simple et/ou multiple) est renseignée on active les menus
function AfficheSousMenuMod(obj, idSMenu) {
    var sMenu = document.getElementById(idSMenu);
    var Type = cstSiren;

    //changer la couleur du bouton qui a été clique
    obj.className = "coulGrisClair";

    // 1 - eventuellement cacher tout sous menu affiche
    cacheMenu(menus, idSMenu);

    // 1 bis - eventuellement cacher tout sous menu de type DAS (info session)
    cacheMenu(menusDAS, null);

    // 2 - afficher le sous menu demande 
    sMenu.style.position = "absolute";
    sMenu.style.zIndex = "10";
    sMenu.style.left = obj.offsetLeft + "px";
    sMenu.style.top = (obj.offsetTop + 23).toString() + "px";

    //menu suivis, boutons toujours actif - sinon affichage selon type de siren renseignes
    if (idSMenu != 'sMenuSuivis') {
        var isMenuNR = menusNR.indexOf(idSMenu) >-1;

        //3 - si un ou des idents ont ete saisis activer les boutons - filtre modules si clefBDF
        if (verifIdentsHomepage(isMenuNR)) {

            //si saisie d'un siren ko (errone) ou clef ou siren
            if (isKO) {
                 Type = cstNothing;
            } else if (isClefBDF) {
                 Type = cstBDFKey;
            } else {
                Type = cstSiren;
            }

            //activation des menus et modules selon type saisie
            for (var i = 0; (i < sMenu.children.length) ; i++) {
                if (Type == cstBDFKey) {
                    if (sMenu.children[i].value != undefined) {
                        var mod = sMenu.children[i].innerHTML.substring(0, 2)
                        var iIndex = cstValidModuleList4BDFKeys.indexOf("|" + mod.toUpperCase() + "|");
                        sMenu.children[i].disabled = (iIndex == -1) ? 'disabled' : '';
                    }
                } else {
                    sMenu.children[i].disabled = (Type == cstNothing) ? 'disabled' : '';
                }
            }
            //---- pas d'ident renseigné = pas bouton de module actif ---
        } else {
            for (var j = 0; (j < sMenu.children.length) ; j++) {
                sMenu.children[j].disabled = 'disabled';
            }
        }
    }

    //afficher le sous menu
    if (sMenu.style.display == "none") {
        sMenu.style.display = "block";
    }
}

//gestion affichage sous menus depuis modules
function AfficheSousMenuModMenuMod(obj, idSMenu) {
    var sMenu = document.getElementById(idSMenu);
    var tbxid = MM_findObj('ident');
    //changer la couleur du bouton
    obj.className = "coulGrisClair";

    // 1 - eventuellement cacher tout sous menu affiche
    cacheMenu(menus, idSMenu);
    // 1 bis - eventuellement cacher tout sous menu de type DAS 
    cacheMenu(menusDAS, null);

    // 2 - afficher le sous menu demande 
    sMenu.style.position = "absolute";
    sMenu.style.zIndex = "10";
    sMenu.style.left = obj.offsetLeft + "px";
    sMenu.style.top = (obj.offsetTop + 23).toString() + "px";


    //3-1 si input ident renseigné 
    if (idSMenu != 'sMenuSuivis') {
        if (tbxid != null && tbxid.value.length > 0) {
            var Type = iCheckIdentifiant(tbxid.value.trim());

            for (var i = 0; (i < sMenu.children.length) ; i++) {
                if (Type == cstBDFKey) {
                    if (sMenu.children[i].value != undefined) {
                        var mod = sMenu.children[i].innerHTML.substring(0, 2)
                        var iIndex = cstValidModuleList4BDFKeys.indexOf("|" + mod.toUpperCase() + "|");
                        sMenu.children[i].disabled = (iIndex == -1) ? 'disabled' : '';
                    }
                } else {
                    sMenu.children[i].disabled = (Type == cstNothing) ? 'disabled' : '';
                }
            }
        } else {
            //3-2 - sinon ident utilise par module affiche alors activer les boutons - filtre modules si clefBDF
            if (sBDFId != null && sBDFId.length > 0) {

                var Type = iCheckIdentifiant(sBDFId);

                for (var i = 0; (i < sMenu.children.length) ; i++) {
                    if (Type == cstBDFKey) {
                        if (sMenu.children[i].value != undefined) {
                            var mod = sMenu.children[i].innerHTML.substring(0, 2)
                            var iIndex = cstValidModuleList4BDFKeys.indexOf("|" + mod.toUpperCase() + "|");
                            sMenu.children[i].disabled = (iIndex == -1) ? 'disabled' : '';
                        }
                    } else {
                        sMenu.children[i].disabled = (Type == cstNothing) ? 'disabled' : '';
                    }
                }
                //---- pas d'ident renseigné = pas bouton de module actif ---
            } else {
                for (var j = 0; (j < sMenu.children.length) ; j++) {
                    sMenu.children[j].disabled = 'disabled';
                }
            }
        }
    }
    if (sMenu.style.display == "none") {
        sMenu.style.display = "block";
    }
}

function AfficheInfoSession(obj, idDiv) {
    var sMenu = document.getElementById(idDiv);
    // 1 - eventuellement cacher tout sous menu de type DAS et modules
    cacheMenu(menusDAS, null);
    cacheMenu(menus, null);

    sMenu.style.position = "absolute";
    sMenu.style.zIndex = "10";
    var position = obj.offsetLeft - (550 + 2 - obj.offsetWidth);
    sMenu.style.left = position.toString() + "px";
    sMenu.style.top = (obj.offsetTop + 25).toString() + "px";

    if (sMenu.style.display == "none") {
        sMenu.style.display = "block";
    }
}

//button onmouseover
function ChangeCouleur(obj, couleur) {
    obj.style.backgroundColor = couleur;
}

//button onmouseout
function ResetCouleur(obj) {
    obj.style.backgroundColor = '#E8E8E8';
}

function ResetCouleur2(obj) {
    obj.style.backgroundColor = '#003b7d';
}

function ResetCouleur3(obj) {
    obj.style.backgroundColor = '#d2deef';
}


function ResetTransparent(obj) {
    obj.className = "clTransparentBleu";
}

function AppelModule(numMod) {
    var btValid = document.getElementById('btValider');
    if (btValid == null) {btValid = document.getElementById('btValiderFR');}
    if (btValid == null) { btValid = document.getElementById('btValiderUK'); }

    if (verifIdentsHomepage) {
        if (isSimpleID) {
            document.getElementById('txt_mod1').value = numMod;
        }
        if (isMultiID) {
            document.getElementById('txt_mod').value = numMod;
        }
        btValid.click();
    }
}

function AppelModuleMenuMod(numMod, sFam) {
    var tbxid = MM_findObj('ident');
    var Id;
    var notRalph = true;
    var sURL;


    //1 si input ident renseigné 
    if (tbxid != null && tryClearSpacesSiren(tbxid.value).length > 0) {
        Id = tryClearSpacesSiren(tbxid.value);
        if (Id.length > 9) {
            if (iCheckIdentifiant(Id)) {
                notRalph = true;
            } else {
                // pas siren ni clef = rech alpha
                requestBDFInfos('07', '', '', Id, cstSimpleConfirm);
                notRalph = false;
            }
        }

    } else {// sinon on prends l'id du module affiché
        if (sBDFId != null && sBDFId.length > 0) {
            Id = tryClearSpacesSiren(sBDFId);
        }
    }

    Page_IsValid = true;
    Page_ValidationActive = false;
    var tmp = document.getElementById('txt_denom');
    if (tmp != null) {
        tmp.value = '.';
    }
    if (notRalph) {
        sURL = cstRoot + '/modules/module.aspx?Mod=' + numMod + '&Id=' + Id + '&RefClient=' + sClientRef + '&Famille=' + sFam;
        window.location.href = sURL;
    }

}

function AppelSAS(sModule) {
    var sURL = cstRoot + '/modules/module.aspx?Mod=' + sModule;
    window.location.href = sURL;
}


function LoadDivisions(hf, coact) {
    var i, oOpt, sTxt;
    var oSelect = document.getElementById('lst_Division');
    var lang = document.getElementById(hf);

    oOpt = new Option('...' + strFillIn(134) + '.', '', true, true);
    oSelect.options[oSelect.length] = oOpt;
    if (lang.value == "UK") {
        if (arSectionClasseUK != null) {
            for (i = 0; i < arSectionClasseUK.length; i++) {
                sTxt = arSectionClasseUK[i][0];
                oOpt = new Option(sTxt, sTxt.substr(0, 2), false, false);
                oSelect.options[oSelect.length] = oOpt;

            }
        }
    } else {
        if (arSectionClasse != null) {
            for (i = 0; i < arSectionClasse.length; i++) {
                sTxt = arSectionClasse[i][0];
                oOpt = new Option(sTxt, sTxt.substr(0, 2), false, false);
                oSelect.options[oSelect.length] = oOpt;
            }
        }
    }
    //selection de la ligne a afficher
    if (coact != undefined) {
        if (coact.length > 0) {
            var idx = coact.substr(0, 2) - 1;
            oSelect.options[idx].selected = true;
            initSousClasses(oSelect.options.selectedIndex - 1, 'lst_sousClasse', 'hfLangue')
            if (coact.length = 5) {
                var oLsiteSousClasses = MM_findObj('lst_sousClasse');
                for (i = 1; i < oLsiteSousClasses.options.length; i++) {
                    if (oLsiteSousClasses.options[i].value == coact) {
                        oLsiteSousClasses.options[i].selected = true;
                        break;
                    }
                }
            }
        } else {
            oSelect.options[0].selected = true;
        }
    } else {
        oSelect.options[0].selected = true;
    }
}

function codeactivite2(index) {
    var objRef;
    objRef = MM_findObj('txt_coac');
    var code = index.options[index.selectedIndex].value;

    if (code.length > 2) {
        objRef.value = code;
    } else {

        objRef.value = code + '*';
    }
}
function initSousClasses(iSectIndex, lstSousClasses, hf) {
    var i, oOpt, sTxt;
    var oLsiteSousClasses = MM_findObj(lstSousClasses);
    var lang = document.getElementById(hf);

    oLsiteSousClasses.length = 0;
    oOpt = new Option('...' + strFillIn(134) + '.', '', true, true);
    oLsiteSousClasses.options[oLsiteSousClasses.length] = oOpt;
    if (lang.value == "UK") {
        if (iSectIndex >= 0) {
            for (i = 1; i < arSectionClasseUK[iSectIndex].length; i++) {
                sTxt = arSectionClasseUK[iSectIndex][i];
                oOpt = new Option(sTxt, sTxt.substr(0, 5), false, false);
                oLsiteSousClasses.options[oLsiteSousClasses.length] = oOpt;
            }
        }
    } else {
        if (iSectIndex >= 0) {
            for (i = 1; i < arSectionClasse[iSectIndex].length; i++) {
                sTxt = arSectionClasse[iSectIndex][i];
                oOpt = new Option(sTxt, sTxt.substr(0, 5), false, false);
                oLsiteSousClasses.options[oLsiteSousClasses.length] = oOpt;
            }
        }
    }
}

function newResetFieldsRalph(type) {
    clearTbx('txt_denom');
    initCheckBox('cbxNom', true);
     
    initCheckBox('cbFranceDromCom', true);
    initCheckBox('cbAutrePays', false);

    if (type != "S") {
        clearTbx('txt_codePostal');
        clearTbx('txt_rue');
        clearTbx('txt_ville');
        clearTbx('txt_coac');
        clearTbx('txt_ua');

        initCheckBox('chk_RechEt', false);
        initCheckBox('chk_Siege', true);

        initDDL('lst_Pays', 0);
        initDDL('lst_Type', 0);
        initDDL('lst_Etat', 0);
        initDDL('lst_Division', 0);
        initDDL('lst_sousClasse', 0);
    }

    var summaryErr = document.getElementById('vsErrorsRalph');
    summaryErr.innerHTML = '';
    summaryErr.innerText = '';

    return false;
}
function ValidateBalsSuivis(source, arguments) {
    var sBal = arguments.Value.toUpperCase();
    sCtrl = source.controltovalidate;
    sBal1 = document.getElementById('tbxBal1').value.toUpperCase();
    if (sCtrl == 'tbxBal2') {
        sBalx = document.getElementById('tbxBal3').value.toUpperCase();
    } else {
        sBalx = document.getElementById('tbxBal2').value.toUpperCase();
    }

    if ((sBal != sBal1) && (sBal != sBalx)) {
        arguments.IsValid = true;
    } else {
        arguments.IsValid = true;
    }

}
//annule saisie du ; sur onkeypress
function InterditPointVirguleMail(event, tbx) {
    if (!event && window.event) {
        //cas IE
        event = window.event;
        var code = event.keyCode;
    } else {
        //Cas FF
        code = event.charCode;
    }
    // si on a appuyé sur ;
    if (code == 59) {
        return false;
    }
    else {
        return true;
    }
}

function activeProgressBar() {
    var prog = document.getElementById('pnProgress');
    prog.style.display = 'block';
}
