//<SCRIPT Language="JavaScript">

//function qui retourne le resultat de l'algorithme siren qui doit tre multiple de 10
function nGetAlgoSiren(sString)
{
	iLengthString=sString.length ;
	if (iLengthString==9)
	{
		nAlgoSiren=0 ;
	}
	if (sString.length!=0)
	{
		if(iLengthString%2==0) //rang pair
		{
			nTemp = 2*(sString.substring(0,1)) ;
			if ((nTemp.toString()).length==2)
			{	
				nTemp= parseInt((nTemp.toString()).substring(0,1)) + parseInt((nTemp.toString()).substring(1,2)) ;
			}
			nAlgoSiren += nTemp + nGetAlgoSiren(sString.substring(1,iLengthString));
		}
		else //rang impair
		{
			nTemp = parseInt(sString.substring(0,1)) ;
			nAlgoSiren += parseInt(sString.substring(0,1)) + nGetAlgoSiren(sString.substring(1,iLengthString));
		}
	}
	return(nAlgoSiren)
}

//function qui verifie qu'on a bien un numro SIREN
function bCheckSirenNumber(sString)
{
	var iLengthIdent=sString.length ; //longueur de l'identifiant
	var bIsSiren=false ;
	if ((iLengthIdent==9)&&(sString.indexOf(" ")==-1)&&(isNaN(sString)==false))
	{
		if (sString.substring(0,2)=="20")
		{
			bIsSiren=true ;
		}
		else
		{
			//variable pour la fonction nGetAlgoSiren
			//(hors fonction car rcursive)
			var iLengthString ;
			var nAlgoSiren ;
			var nTemp ;
			if (nGetAlgoSiren(sString)%10==0) //multiple de 10 ?
			{
				bIsSiren=true ;
			}
		}
	}
	return(bIsSiren);
}

//function qui vrifie la validit de la date
function bCheckBirthDay(sDate)
{
	var bIsDate=false ;
	//exeption
	if (sDate=="000000")
	{
		bIsDate=true ;
	}
	else
	{
		//exeption encore
		if ((sDate.substring(0,2)=="00")&&(sDate.substring(2,4)>=0)&&(sDate.substring(2,4)<13)&&(sDate.substring(4,6)>=0)&&(sDate.substring(4,6)<100))
		{
			bIsDate=true ;
		}
		else
		{
			bIsDate=bCheckDate(sDate.substring(0,2),sDate.substring(2,4),'20' + sDate.substring(4,6))
		}
	} 
	return(bIsDate) ;
}
		
//fonction rcursive qui verifie que si la chaine comporte un chiffre,il s'agit du premier du suffixe
//declaration hors fonction car celle ci est rcursive
function bCheckBdfKeySuffix(sString)
{
var bIsCheck, sLetter;	
	bIsCheck=true ; 
	sLetter=sString.substring(0,1) ;
	if (sLetter!="")
	{
		if (isNaN(sLetter)==false) //la lettre est un chiffre
		{
			if(sLetter==" ")
			{
				bIsCheck=bCheckBdfKeySuffix(sString.substring(1,sString.length)) ;
			}
			else
			{
				//on verifie qu'il s'agit des 2 derniers caracteres
				if (sString.length!=2 || isNaN(sString))
				{
					bIsCheck=false ;
				}
			}
		}
		else
		{
			bIsCheck=bCheckBdfKeySuffix(sString.substring(1,sString.length)) ;
		}
	}
	return(bIsCheck)
}

//fonction qui verifie :
//	si la chaine comporte des blancs,il sont contigus et en fin de zone
//	la chaine hors suffixe fait au maximum 5 caracteres
function bCheckBdfKeyBlank(sString)
{
	var iBlank, bIsCheck, sLetter, sBlank, iLetter ;
	//on retire le suffixe s'il est prsent
	if (!(isNaN(sString.substr(sString.length-1,1))))
	{
		sString=sString.substring(0,sString.length-2) ;
	}
	if (sString.length>4)
	{
		bIsCheck=false ;
	}
	else
	{
		bIsCheck=true ;
		sLetter=sString.substring(0,1) ;
		if (sLetter!="")
		{
			iBlank=sString.indexOf(" ") ;
			if (iBlank!=-1)
			{
				//les blancs doivent tre contigus et en fin de zone
				sBlank=sString.substring(iBlank,sString.length) ;
				sBlank=replaceChar(sBlank," ","")
				if (sBlank.length!=0)
				{
					bIsCheck=false ;
				}
			}
			sString = sString.toUpperCase();
			while (sString.length>0) 
			{
				iLetter = sString.charCodeAt(0);
				if ((iLetter<65 || iLetter>90 ) && iLetter!=32)
				{
					bIsCheck=false;
					break;
				}
				sString=sString.substr(1);
			}
		}
	}
	return(bIsCheck)
}

//fonction qui teste l'identifiant
function iCheckIdentifiant(sIdent)
{
	var iCheckIdent = cstSiren ; //on suppose que c'est un nsiren
	var sLetter1;

	let sIdentTrimed = tryClearSpacesSiren(sIdent);

	if (bCheckSirenNumber(sIdentTrimed)==false) //ce n'est pas un nsiren
	{
		if (bCheckBirthDay(sIdentTrimed.substring(0,6))==false) //erreur au niveau de la date de naissance
		{
			iCheckIdent=cstNothing ;
		}
		else
		{
			sLetter1 = sIdentTrimed.substring(6,7) ;
			if ((isNaN(sLetter1)==false)||(sLetter1==" ")) //erreur au niveau de la premiere lettre
			{
				iCheckIdent=cstNothing ;
			}
			else
			{
				if (bCheckBdfKeySuffix(sIdentTrimed.substring(7, sIdentTrimed.length))==false)//erreur au niveau des chiffres
				{
					iCheckIdent=cstNothing ;
				}
				else
				{
					if (bCheckBdfKeyBlank(sIdentTrimed.substring(7, sIdentTrimed.length))==false)//erreur au niveau des blancs
					{
						iCheckIdent=cstNothing ;
					}
					else
					{
						iCheckIdent=cstBDFKey ;
					}
				}
			}
		}
	}
	return(iCheckIdent);
}

// fonction qui valide un code guichet
function bCheckCdGuichet(sCdGuichet) {
	
	if ((sCdGuichet.length == 5) && (parseInt(sCdGuichet) != Number.NaN)) return true; 
	return false;
}

function bCheckEmail(sEmail) {
	if (sEmail.length > 75) return false;

	const emailRegex = /^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/;

	return emailRegex.test(sEmail); 
}