var jj;	//jour
var mm;	//mois
var aa;	//annee
var aaaa;	//annee sur 4 car.

//Formate une date au format J/M/AA (JJ/MM/AAAA) en AAAAMMJJ
function FormatDateAMJ(sDate)
{
	sDate = FormatAffDate(sDate);
	return(GetWord(sDate,3,"/") + GetWord(sDate,2,"/") + GetWord(sDate,1,"/"));
}

//Formate une date au format anglais MM/JJ/AAAA (ou J/M/AA) en JJ/MM/AAAA
function FmtDateEnglishToFrench(sDate)
{
	sDate = FormatAffDate(sDate);
	sDate = GetWord(sDate,2,"/") + '/' + GetWord(sDate,1,"/")+ '/' + GetWord(sDate,3,"/");

	return(sDate);
}

function FormatYear(nYear)
{
	var bReturnValue=true; 

	if (!CheckValue(nYear,0,9999))
	{
		bReturnValue = false;
	}	
	else
	{
		aaaa = parseInt(nYear);
		if (aaaa >= 1900)
		{
			bReturnValue = true;
		}
		else
		{
		// mise en forme de l'annee si elle n'est pas saisie sur 4 chiffres
			if ((aaaa>99) &&(aaaa<1900))
			{
				bReturnValue = false;
			}
			else
			{
				if (aaaa>30)
				{
					aaaa = 1900 + aaaa;
				}
				else
				{
					aaaa = 2000 + aaaa;
				}
			}	
		}
	}		
	return(bReturnValue);
}

//Formate une date en JJ/MM/AAAA
function FormatAffDate(sDate)
{

	var slash1 = -1;
	var slash2 = -1;
	if (sDate != null)
	{
		slash1 = sDate.indexOf("/");
		slash2 = sDate.indexOf("/", slash1+1);
		slash3 = sDate.indexOf(" ",slash2+1);
	}
	if ((slash1 != -1) && (slash2 != -1))
	{
		jj = Replace(sDate.substring(0, slash1)," ","");
		if (jj.length==1) jj = "0" + jj;
		
		mm = Replace(sDate.substring(slash1+1, slash2)," ","");
		if (mm.length==1) mm = "0" + mm;
		
		if ((slash3 != -1))
		{
			aa = sDate.substring(slash2+1, slash3);
		}
		else
		{
			aa = sDate.substring(slash2+1, sDate.length);
		}
		
		if (FormatYear(aa))
		{
			return(jj + "/"+ mm + "/"+ aaaa);
		}
	}
	return("");
}

function FormatDate(oDate)
{
	var sDate;
	var bReturnValue = false;
	
	sDate = FormatAffDate(oDate.value);
	if (sDate!="")
	{	
		oDate.value = sDate;
		bReturnValue= true;
	}
	return(bReturnValue);
}
function bCheckDate(nDay,nMonth,nYear)
{
	var ladate = new Date(nYear, nMonth-1, nDay);
	return ((nYear == ladate.getFullYear()) && (nMonth-1 == ladate.getMonth()) && (nDay == ladate.getDate()))
// m-1 car getMonth retourne un entier entre 0 et 11
}

function DateVerif(oDate)
{
	if (oDate.value != "")
	{
		if (FormatDate(oDate)==false)
		{
			alert('Veuillez ressaisir la date');
			oDate.value="";
			oDate.focus();
			
		}
		else 
		{
			if ((CheckDate(jj, mm, aaaa)==false) && (oDate.value!=""))
			{
				alert('Date incorrecte');
				oDate.value="";
				oDate.focus();
			}
		}
	}
	return(true);
}

// Idem dessus sans message d'alerte
function DateVerifEx(oDate)
{
var bReturnValue = true;

	if (oDate.value != "")
	{
		if (FormatDate(oDate)==false)
		{
			bReturnValue = false;
		}
		else 
		{
			if ((CheckDate(jj, mm, aaaa)==false) && (oDate.value!=""))
			{
				bReturnValue = false;
			}
		}
	}
	return(bReturnValue);
}

function CreateDate(idDate, sValue)
{
	var param ='name="' + idDate + '" onblur="return(DateVerif(this));"';
	
	if ((idDate.substr(2,1) == 'r') == true)
	{
		param = 'class=read readonly tabindex=-1 onFocus="this.blur();"';
	}
	
    return '<input '+
			'OnKeyPress="CheckKey(\'d\')" '+
			' value="' + sValue + '" size=9 maxlength=10  '+
			 param + ' >';
}

function CreateTableDate(idDate,sText,bLock,sValue)
{
	var sDate = '<tr>';
	sDate += '<td nowrap>'+sText+':</td>' ;
	sDate += '<td>' + CreateDate(idDate,bLock,sValue) + '</td>';
	sDate += '</tr>';
	return(sDate);
}

function showMonthOfYear(oDate)
{
	//	Renvoi le mois de la date transmise
	var aMois = new Array("Janvier", "Fvrier", "Mars", 
						"Avril", "Mai", "Juin",
						"Juillet", "Aot", "Septembre",
						"Octobre", "Novembre", "Dcembre");
	var iMois = oDate.getMonth();

	return (aMois[iMois]);
}

//	Transforme un jour en format DD (05)
function Day2Char(sDay) 
{
	sDay = '0' + sDay;
	return (sDay.substr((sDay.length-2),2));
}

// Transforme une date au format JJ/MM/AAAA en un objet
function DateToObject(dDate)
{
	FormatAffDate(dDate);
	var oDate = new Date(aa, mm-1, jj, 0, 0);
    return (oDate);
}

//Vrifie que la date1 est antrieur  la date2
function DatesVerif(dDate1,dDate2) {
    var bReturnValue = true;

	var oDate1 = DateToObject(dDate1);	
	var oDate2 = DateToObject(dDate2);	

	if (oDate1 > oDate2)
	{
		alert("La date de fin doit tre postrieure  la date de dbut");
		bReturnValue = false;
	}
	return(bReturnValue);
}

//Renvoi la date de fin du mois d'une date
function showLastOfMonth(dDate)
{
	var eomDate = new Date(dDate.getFullYear(), dDate.getMonth(), dDate.getDate());	
	eomDate.setMonth(eomDate.getMonth() + 1 );
	eomDate.setDate(1);
	eomDate.setDate( eomDate.getDate() - 1);

	return(eomDate);
}

//Renvoi le nombre de jours entre deux dates
function gapBetweenDates(dDate1,dDate2)
{
	var nJour1 = new Date(dDate1.getFullYear(), dDate1.getMonth(), dDate1.getDate(), 0,  0);
	var nJour2 = new Date(dDate2.getFullYear(), dDate2.getMonth(), dDate2.getDate(), 0,  0);
	var iEcart = ((nJour1 - nJour2)/(1000*60*60*24));
	return(iEcart);
}


