// fonction utilise pour la validation des inscription aux alertes
function validRequestSAS_IA(objLink) {

    var numindentifiant = 10;
    //************************************************//
    // Initialisation de la gestion des erreurs       //
    //************************************************//

    //on supprime le message d'erreur gnral
    var InfoErreur = MM_findObj('erreur');
    InfoErreur.innerHTML = unescape("");

    //on cache par dfaut la signalisation  d'erreur du champ LstAdrMail
    var signalisation = MM_findObj('sgn_LstAdrMail');
    signalisation.style.visibility = 'hidden';

    //on cache par dfaut la signalisation  d'erreur du champ NewAdrMail
    signalisation = MM_findObj('sgn_NewAdrMail');
    signalisation.style.visibility = 'hidden';

    //on cache par dfaut la signalisation d'erreur des champs concernant les identifiants
    for (var i = 1; i <= numindentifiant; i++) {
        signalisation = MM_findObj('sgn_ident' + i);
        signalisation.style.visibility = 'hidden';
    }  

    //************************************************//
    // Rcupration de l'adresse mail cible           //
    //************************************************//	

    //par dfaut on rcupre l'adresse mail slectionne dans la liste 
    var List_adresse_mail = MM_findObj('lst_AdrMail');
    var adresse_mail_cible = List_adresse_mail[List_adresse_mail.value].innerHTML; //outerText;

    //************************************************//
    // Contrle du champ de la nouvelle adresse mail  //
    //************************************************//	
    var txtbox_nouvelle_adresse_mail = MM_findObj('txt_newemail');
    var nouvelle_adresse_mail = txtbox_nouvelle_adresse_mail.value;
    if (nouvelle_adresse_mail != '') {
        if (!bCheckEmail(nouvelle_adresse_mail)) {
            signalisation = MM_findObj('sgn_NewAdrMail');
            signalisation.style.visibility = 'visible';

            InfoErreur.innerHTML = unescape(aErreur['SAS1']);
            return false;
        }
        // format OK	
        adresse_mail_cible = nouvelle_adresse_mail;
    }

    if (adresse_mail_cible == List_adresse_mail[0].innerHTML) {
        //on fait apparaitre les signalisations d'erreur concernes
        signalisation = MM_findObj('sgn_LstAdrMail');
        signalisation.style.visibility = 'visible';

        var controlecomposite = MM_findObj('blc_chp_NewAdrMail');
        if (controlecomposite.style.visibility == 'visible') {
            signalisation = MM_findObj('sgn_NewAdrMail');
            signalisation.style.visibility = 'visible';
        }

        InfoErreur.innerHTML = unescape(aErreur['SAS1']);
        return false;
    }

    //*******************************************************************//
    //contrle des diffrents champ contenant les identifiants.          //
    //*******************************************************************//
    var erreur_identifiant = false;
    var AuMoinsUnIdentifiantSaisie = false;
    var arDico = new Array();
    var DoublonExistant = false;
    var iTypeIdent = 0;

    for (var i = 1; i <= numindentifiant; i++) {
        var champ_identifiant = MM_findObj('txt_ident' + i);
                
        if (champ_identifiant.value != '') {
            AuMoinsUnIdentifiantSaisie = true;
            
            iTypeIdent = iCheckIdentifiant(tryClearSpacesSiren(champ_identifiant.value));
            if (iTypeIdent == cstNothing) {
                signalisation = MM_findObj('sgn_ident' + i);
                signalisation.style.visibility = 'visible';
                erreur_identifiant = true;
            }
            // ajout 30-06-2011 empcher clef BDF sans suffixe . les 2 dernier caracteres doivent etre numeriques
            if (iTypeIdent == cstBDFKey) {
                var str = champ_identifiant.value
                if (isNaN(str.substr(str.length - 2, 2))) {
                    signalisation = MM_findObj('sgn_ident' + i);
                    signalisation.style.visibility = 'visible';
                    erreur_identifiant = true;
                }
            }

            // contrle des doublons
            if (!arDico[champ_identifiant.value]) {
                arDico[champ_identifiant.value] = 'renseigne';
            }
            else {
                DoublonExistant = true;
                signalisation = MM_findObj('sgn_ident' + i);
                signalisation.style.visibility = 'visible';
            }
        }
    }

    if (!AuMoinsUnIdentifiantSaisie) {
        for (var i = 1; i <= numindentifiant; i++) {
            var champ_identifiant = MM_findObj('txt_ident' + i);
            if (champ_identifiant.style.visibility == 'visible') {
                signalisation = MM_findObj('sgn_ident' + i);
                signalisation.style.visibility = 'visible';
            }
        }
        InfoErreur.innerHTML = unescape(aErreur['U053']);
        return false;
    }
    if (erreur_identifiant) {
        InfoErreur.innerHTML = unescape(aErreur['U01']);
        return false;
    }
    if (DoublonExistant) {
        InfoErreur.innerHTML = unescape(aErreur['SAS4']);
        return false;
    }
    /* construction de l'URL*/
    var identifiantsUrl = ''
    for (var i = 1; i <= numindentifiant; i++) {
        var champ_identifiant = MM_findObj('txt_ident' + i);
        if (champ_identifiant.value != '') {
            identifiantsUrl += tryClearSpacesSiren(champ_identifiant.value) + ';';
        }
    }
    // retrait du dernier point-virgule
    identifiantsUrl = identifiantsUrl.substring(0, identifiantsUrl.length - 1);
    var url = cstRoot + '/Modules/Module.aspx?Mod=A2' + '&ID=' + identifiantsUrl + '&BAL=' + adresse_mail_cible;
    /* redirection*/
    if (objLink.tagName == 'BUTTON') {
        window.location.href = url;
    } else {
        objLink.href = url;
    }

}


// fonction utilise pour effacer tout les champs de saisie et les messages d'erreur
function EffacerSAS_IA() {
    var numindentifiant = 10;
    //************************************************//
    //         champ de la nouvelle adresse mail      //
    //************************************************//	
    var txtbox_nouvelle_adresse_mail = MM_findObj('txt_newemail');
    txtbox_nouvelle_adresse_mail.value = "";
 
    //*******************************************************************//
    //        les diffrents champ contenant les identifiants.           //
    //*******************************************************************//   

    for (var i = 1; i <= numindentifiant; i++) {
        var champ_identifiant = MM_findObj('txt_ident' + i);
        champ_identifiant.value = "";
    }

    //************************************************//
    // Initialisation de la gestion des erreurs       //
    //************************************************//

    //on supprime le message d'erreur gnral
    var InfoErreur = MM_findObj('erreur');
    InfoErreur.innerHTML = unescape("");

    //on cache par dfaut la signalisation  d'erreur du champ LstAdrMail
    var signalisation = MM_findObj('sgn_LstAdrMail');
    signalisation.style.visibility = 'hidden';

    //on cache par dfaut la signalisation  d'erreur du champ NewAdrMail
    signalisation = MM_findObj('sgn_NewAdrMail');
    signalisation.style.visibility = 'hidden';

    //on cache par dfaut la signalisation d'erreur des champs concernant les identifiants
    for (var i = 1; i <= numindentifiant; i++) {
        signalisation = MM_findObj('sgn_ident' + i);
        signalisation.style.visibility = 'hidden';
    }  

}


//fonction utilise pour le traitement du cas o le nombre d'adresse mail et/ou le nombre d'alertes est au maximun
function Tst_Conditions_InitialesSAS_IA() {
    var nombreAlerteMAX = 500;
    var nombreBALMAX = 10;

    // test du seuil max du nombre d'alerte
    var ctrl_nbAlerte = document.getElementById("cnbAlerte");
    var nbrAlertre = 0;

    if (ctrl_nbAlerte != null) {
        nbrAlertre = parseInt(ctrl_nbAlerte.innerHTML, 10);
    }

    if (nbrAlertre >= nombreAlerteMAX) {

        //on cache la partie principale           
        var bloc1 = document.getElementById("bloc1");
        bloc1.style.visibility = 'hidden';

        //on fait apparaitre le message concern            
        var bloc2 = document.getElementById("bloc2");
        bloc2.style.visibility = 'visible';

        // on met en rouge de nombre d'alerte
        ctrl_nbAlerte.className = "clTitre222";

        return;
    }

    // test du seuil max du nombre d'adresse mail 
    var lst_AdrMail = document.getElementById("lst_AdrMail");

    // on ne compte pas le premier lment de la liste box "Toutes les adresses mail"
    var nbrAdrMail = 0;

    if (lst_AdrMail != null) {
        nbrAdrMail = lst_AdrMail.length - 1;
    } 

    if (nbrAdrMail >= nombreBALMAX) {

        //on cache la partie principale           
        var bloc1 = document.getElementById("blc_chp_NewAdrMail");
        bloc1.style.visibility = 'hidden';

        //on fait apparaitre le message concern            
        var bloc2 = document.getElementById("blc_msg_NewAdrMail");
        bloc2.style.visibility = 'visible';
    }
    else {

        //on fait la partie principale           
        var bloc1 = document.getElementById("blc_chp_NewAdrMail");
        if (bloc1 != null) {
            bloc1.style.visibility = 'visible';
        }
    }

     //affichage des champs des identifiants ncessaires
      var nombreIdentifiantMAX = 10;
      var nombreIdentifiantMIN = 1;

      var taille = "16"; // IE par dfaut
                           
      var  nombreAlerteRestante = nombreAlerteMAX - nbrAlertre;

        if ((nombreAlerteRestante >= nombreIdentifiantMIN) && (nombreAlerteRestante <= nombreAlerteMAX)) {

            if (nombreAlerteRestante > nombreIdentifiantMAX) {
                nombreAlerteRestante = nombreIdentifiantMAX;
            }

            for (var indexIndentifiant = nombreIdentifiantMIN; indexIndentifiant <= nombreAlerteRestante; indexIndentifiant++) {

                // affichage de la textbox
                var txt_ident = document.getElementById("txt_ident" + indexIndentifiant);

                if (txt_ident != null) {
                    txt_ident.style.visibility = 'visible';

                    // dfinition de la taille du champ
                    txt_ident.size = taille;
                }
            }
        }
}

//*********************************************************************************************//
//                                   Gestion des alertes                                       //
//*********************************************************************************************//


// fonction utilise pour selectionner ou
// dselectionner toutes les les cases  cocher
// dans la gestion des alertes. 
function ChangeSelectionSAS_GA() {

    var case_a_coche = MM_findObj('Toutselectionner');
    var etat = case_a_coche.checked;


    // propagation de l'tat dans toutes les autres cases  cocher ...
    var i = 1; //  ... en partant de la premire

    while ((case_a_coche = MM_findObj('IdSelection' + i)) != null) {

        case_a_coche.checked = etat;
        i++;
    }

    if (etat == false)
    {
        // vidage  du champ contenant le champ de la nouvelle adresse mail
        var txt_box = MM_findObj('txt_newemail');
        txt_box.value = "";

        //  et slection du premier lment de la liste droulante des adresses de transfert
        var Lst_Mail = MM_findObj('Lst_Mail_Transfert');
        Lst_Mail.options[0].selected = true;
    }
}


//fonction utilise lorsque la souris est au dessus du
//champ de la nouvelle adresse mail de transfert
function AdrMailTransfertEvent_GA() {
    var txt_box = MM_findObj('txt_newemail');  
    var Lst_Mail = MM_findObj('lst_AdrMail');

    if ((Lst_Mail.value != 0)) {      
        txt_box.removeAttribute("readOnly");
    }
}
//fonction utilise pour selectionner 
//toutes les cases  cocher
//lorsque une nouvelle adresse mail de transfert est choisie
// dans la gestion des alertes. 
function ChoixMailSAS_GA(control) {
    var txt_box = MM_findObj('txt_newemail');
    var Lst_Mail_Tr = MM_findObj('Lst_Mail_Transfert');
    var Lst_Mail = MM_findObj('lst_AdrMail');

    if (control) {
        // c'est la textbox qui appel la fonction
        // on slectionne le premier lment de la liste droulante des adresses de transfert       
        Lst_Mail_Tr.options[0].selected = true;
    }
    else {

        // c'est la listbox qui appel la fonction
        // on vide la texbox   
        txt_box.value = "";
    }

    // on interdit la saisie lorsque la liste droulante principale 
    // est  toutes les alertes (transfert impossible)

    if ((Lst_Mail.value == 0)) {
        txt_box.value = "";
        txt_box.setAttribute("readOnly", "true");
    }
    else {
        txt_box.removeAttribute("readOnly");
    }

    var etat = false;

    if ((txt_box.value != "") || (Lst_Mail_Tr.value != 0)) {
        etat = true;
    }


    var case_a_coche = MM_findObj('Toutselectionner');
    case_a_coche.checked = etat;

    ChangeSelectionSAS_GA();

}

//fonction utilise pour dselectionner la case  cocher "Toutselectionner"
//et vider le champ de la nouvelle adresse mail, lors d'un clic sur une case  cocher
//dans la gestion des alertes.  
function GestionCaseACocherSAS_GA() {

    // vidage  du champ contenant le champ de la nouvelle adresse mail,
    var txt_box = MM_findObj('txt_newemail');
    txt_box.value = "";

    // slection du premier lment de la liste droulante des adresses de transfert
    var Lst_Mail = MM_findObj('Lst_Mail_Transfert');
    Lst_Mail.options[0].selected = true;

    // et dselection de la case  cocher "Toutselectionner"
    var etat = false;

    var case_a_coche = MM_findObj('Toutselectionner');
    case_a_coche.checked = etat;

}

// fonction utilise pour le transfert des identifiants dans une autre BAL
// dans la gestion des alertes.  
function TransfertRequestSAS_GA(objLink) {
    //on supprime le message d'erreur gnral
    var InfoErreur = MM_findObj('erreur');
    InfoErreur.innerHTML = unescape("");

    var Nouvelle_adr_mail = "";

    var Lst_Mail = MM_findObj('Lst_Mail_Transfert');

    if (Lst_Mail.value == 0) {

        //*******************************************************************//
        //             contrle de la nouvelle adresse mail                  //
        //*******************************************************************//


        var txt_box = MM_findObj('txt_newemail');
        if (txt_box.value == "") {
            InfoErreur.innerHTML = aErreur['SAS8'];
            return;
        }

        Nouvelle_adr_mail = txt_box.value;

        //contrle de prsence des espaces
        if (Nouvelle_adr_mail.indexOf(" ", 0) != -1) {
            InfoErreur.innerHTML = unescape(aErreur['SAS1']);
            return false;
        }

        if (!bCheckEmail(Nouvelle_adr_mail)) {
            InfoErreur.innerHTML = unescape(aErreur['SAS1']);
            return false;
        }
    }
    else {
        Nouvelle_adr_mail = Lst_Mail[Lst_Mail.value].innerHTML;
    }

    //Rcupration de l'adresse mail slectionne dans la liste 
    var List_adresse_mail = MM_findObj('lst_AdrMail');
    var Ancienne_adr_mail = List_adresse_mail[List_adresse_mail.value].innerHTML;

    if (List_adresse_mail.value == 0) {
        InfoErreur.innerHTML = unescape(aErreur['SAS1']);
        return;
    }


    if (Ancienne_adr_mail == Nouvelle_adr_mail) {
        InfoErreur.innerHTML = unescape(aErreur['SAS24']);
        return;
    }


    /* construction de l'URL*/
    var url = cstRoot + '/Modules/Module.aspx?Mod=A4' + '&OldBAL=' + Ancienne_adr_mail + '&NewBAL=' + Nouvelle_adr_mail;

    // redirection
    if (objLink.tagName == 'BUTTON') {
        window.location.href = url;
    } else {
        objLink.href = url;
    }
}


// fonction utilise pour la suppression des identifiants dans la gestion des alertes.  
function SupprRequestSAS_GA(objLink) {

    //on supprime le message d'erreur gnral
    var InfoErreur = MM_findObj('erreur');
    InfoErreur.innerHTML = unescape("");

    //Rcupration de l'adresse mail slectionne dans la liste 
    var List_adresse_mail = MM_findObj('lst_AdrMail');
    var adresse_mail_choisie = List_adresse_mail[List_adresse_mail.value].innerHTML;

    if (List_adresse_mail.value == 0) {
        InfoErreur.innerHTML = unescape(aErreur['SAS1']);
        return;
    }

    var AuMoinsUneCaseEstCochee = false;
    var ToutesLesCasesSontCochees = true;

    // Vrification de l'tat des cases  cocher ...
    var i = 1; //  ... en partant de la premire

    while ((case_a_coche = MM_findObj('IdSelection' + i)) != null) {
        if (case_a_coche.checked == true) {
            AuMoinsUneCaseEstCochee = true;
        }
        else {
            ToutesLesCasesSontCochees = false;
        }

        i++;
    }

    // aucune case n'est selectionne
    if (!AuMoinsUneCaseEstCochee) {
        InfoErreur.innerHTML = unescape(aErreur['U053']);
        return;
    }

    var donneesClient = '';

    /* construction de l'URL*/
    var url = '';

    if (!ToutesLesCasesSontCochees) {
        //nous sommes dans le cas o, on supprime uniquement une partie des Ids slectionns 


        //Rcupration des Ids slectionns 
        var identifiantsSession = '';
        var identifiantsUrl = '';
        var nbidentifiantselectionnes = 0;
        var numindentifiantURLMax = 10;
        var separateur = ';'

        // Vrification de l'tat des cases  cocher ...
        var i = 1;//  ... en partant de la premire

        while ((case_a_coche = MM_findObj('IdSelection' + i)) != null) {
            if (case_a_coche.checked == true) {

                //rcupration de l'identifiant slection
                var textbox = MM_findObj('Identifiant' + i);
                nbidentifiantselectionnes++;

                if (nbidentifiantselectionnes <= numindentifiantURLMax) {
                    identifiantsUrl += textbox.value + separateur;
                }
                else {
                    identifiantsSession += textbox.value + separateur;
                }
            }

            i++;
        }

        // retrait du dernier point-virgule
        identifiantsUrl = identifiantsUrl.substring(0, identifiantsUrl.length - 1);

        if (identifiantsSession.length > 0) {
            identifiantsSession = identifiantsSession.substring(0, identifiantsSession.length - 1);
        }

        url = cstRoot + '/Modules/Module.aspx?Mod=A6' + '&ID=' + identifiantsUrl + '&BAL=' + adresse_mail_choisie + '&NB=' + nbidentifiantselectionnes;

        donneesClient = identifiantsSession + "|" + url;
    }
    else {
      
        requestBDFInfos('A5', '', '', adresse_mail_choisie, cstSimpleConfirm, false, null, null, null);
        return;
    }

    /* gestion du retour serveur*/
    var cb = document.getElementById("BtValider");

    if ((cb != null) && (!ToutesLesCasesSontCochees) && (nbidentifiantselectionnes > numindentifiantURLMax)) {
        // Pour le client HTML, dans la cas de la suppression des identifiants en nb > au max permis dans query string

        /* sauvegarde des donnes dans la textbox*/
        var tb = document.getElementById("DATA_Client");
        tb.value = donneesClient;

        /* simuler le click sur le bouton cach */
        cb.click();
    }
    else {
        // Pour le client automate, dans la cas de la suppression des identifiants
        // et pour la suppression d'une BAL , le client HTML et le client automate, seront traits ici aussi .

        // redirection
        if (objLink.tagName == 'BUTTON') {
            window.location.href = url;
        } else {
            objLink.href = url;
        }
    }
}

//fonction utilise pour le traitement
// du cas o le nombre d'adresse mail est au minimum.
function Tst_lst_MailSAS_GA() {

    var nombreAlerteMIN = 0;
    var nombreAlerteMAX = 500;
	var nbrAlertre = nombreAlerteMIN

    var ctrl_nbAlerte = document.getElementById("cnbAlerte");
    if (ctrl_nbAlerte != null) {
        nbrAlertre = parseInt(ctrl_nbAlerte.innerHTML, 10);
    }

    if (nbrAlertre == nombreAlerteMIN) {
        //on cache la partie principale           
        var bloc1 = document.getElementById("bloc1");
        if (bloc1 != null) {
            bloc1.style.visibility = 'hidden';
        }

        //on fait apparaitre le message concern            
        var bloc2 = document.getElementById("bloc2");
        if (bloc2 != null) {
            bloc2.style.visibility = 'visible';
        }
    }
    else 
    {
        //tout est OK, alors on affiche le reste

        //recherche l'index de l'adresse mail demande
        var lst_AdrMail = document.getElementById("lst_AdrMail");
        if (lst_AdrMail != null) {

            var index = 0; // "Toutes les adresses mail" par dfaut.
            for (var idx = 1; idx < lst_AdrMail.length; idx++) {

                if (window.document.frmForm1.lst_AdrMail[idx].innerHTML == window.document.frmForm1.AdrMailselectionnee.value) {
                    index = idx;
                    break;
                }
            }

            window.document.frmForm1.lst_AdrMail.options[index].selected = true;

            if (index > 0) {

                // affichage de la case "tout selectionner"
                var blc_case_a_coche = MM_findObj('blc_Toutselectionner');
                blc_case_a_coche.style.visibility = 'visible';

                // affichage de toutes les cases  cocher
                var textbox;
                var i = 1;

                while ((textbox = MM_findObj('Identifiant' + i)) != null) {

                    // on affiche la checkbox
                    var case_a_coche = MM_findObj('IdSelection' + i);
                    case_a_coche.style.visibility = 'visible';

                    i++;
                }
            }

            if (nbrAlertre == nombreAlerteMAX) {
                // on met en rouge de nombre d'alerte
                ctrl_nbAlerte.className = "clTitre222";
            }

            MAJ_Lst_TransfertSAS_GA();
        } // fin du test sur lst_adresse 
    } // fin du else
}

//fonction utilise pour la mise  jour
// de la liste des alertes
function MAJ_lst_AlertesSAS_GA() {
    // demande des identifiants de l'adresse mail slectionne
    var adr_mail_selectionnee = window.document.frmForm1.lst_AdrMail[window.document.frmForm1.lst_AdrMail.value].innerHTML;
    if (window.document.frmForm1.lst_AdrMail.value == 0) {
        // on demande toutes les alertes
        adr_mail_selectionnee = "";
    }
    var url = cstRoot + '/Modules/Module.aspx?Mod=A3' + '&Email=' + adr_mail_selectionnee;
    /* redirection*/
     window.location.href = url;
}

//fonction utilise pour la mise  jour de la liste box "Lst_Mail_Transfert"
function MAJ_Lst_TransfertSAS_GA() {

    var Lst_Mail_transfert = MM_findObj('Lst_Mail_Transfert');

    // vidage de la liste box "Lst_Mail_Transfert"
    // on garde toujours le premier lment, d'o i=1
    for (var i = 1; i < Lst_Mail_transfert.length; i++) {

        Lst_Mail_transfert.remove(i);
    }

    // remplissage de la liste box "Lst_Mail_Transfert" avec toutes les BALs sauf celle
    // qui a t slctione dans la liste box "lst_AdrMail"

    var Lst_Mail_declaree = MM_findObj('lst_AdrMail');

    var BAL_selectionnee = Lst_Mail_declaree.value;

    if (BAL_selectionnee != 0) {
        // on ne prend pas le premier lment, d'o i=1
        var j = 1;
        for (var i = j; i < Lst_Mail_declaree.length; i++) {

            if (i != BAL_selectionnee) {

                //cration de l'option pour le select
                var elOptNew = document.createElement('option');
                elOptNew.text = Lst_Mail_declaree[i].innerHTML;
                elOptNew.value = j;

                j++; // pour l'option suivante

                Lst_Mail_transfert.add(elOptNew);
            }
        }
    }
}

//initialisation de variable
var DateFinValide = true;
var ReferenceOK = true;
var IdDateFin = 'DateFinSuivi0';
var IdZoneRef = 'Reference0';
let hasBeenDisplayed = false;

//fonction de vrification de la saisie correcte de la zone de rfrence
function VerifSaisieReference(position) {

    var ZoneDeRefValide = true;   
    var nom_saisie_txt_box_reference = 'Reference' + position;
    var saisie_txt_box_reference = MM_findObj(nom_saisie_txt_box_reference);
    var nom_chk_box_modif = 'chkModif' + position;
    var cb = document.getElementById(nom_chk_box_modif);
    ValeurSaisie = saisie_txt_box_reference.value;
    if (!isMatch(ValeurSaisie, rgxRefClientSuivis)) {

        if (!hasBeenDisplayed)
            alert(unescape(aErreur['SAS99']));

        ZoneDeRefValide = false;
        hasBeenDisplayed = true;
    }
    else {
        hasBeenDisplayed = false;
    }
    if (!ZoneDeRefValide && cb.checked) {
        saisie_txt_box_reference.value = ValeurSaisie;
        saisie_txt_box_reference.select();
        saisie_txt_box_reference.focus();
    }
}

//fonction utilise dans la gestion des suivi lors d'un clic sur une case  cocher
// 1) pour selectionner une ligne de suivi et rendre les champs date fin suivi et rfrence modifiable,
// 2) pour dcocher l'autre case (case modif ou supp ) selon le cas
function GestionCaseACocherSAS_GS(numero, cas) {
    // reconstitution des noms des contrles.
    var nom_txt_box_date = 'DateFinSuivi' + numero;
    var nom_txt_box_reference = 'Reference' + numero;
    var nom_chk_box_modif = 'chkModif' + numero;
    var nom_chk_box_supp = 'chkSup' + numero;

    var txt_box_date = MM_findObj(nom_txt_box_date);
    var txt_box_reference = MM_findObj(nom_txt_box_reference);
    var cbSupp = MM_findObj(nom_chk_box_supp);
    var cbModif = MM_findObj(nom_chk_box_modif);

    if (IdDateFin == nom_txt_box_date) {

        DateFinValide = true;
        ReferenceOK = true;
    }

    if (DateFinValide) {

        if (ReferenceOK) {
            if (cas == 'M') {
                if (cbModif.checked == true) {
                    txt_box_date.removeAttribute("readOnly");
                    txt_box_reference.removeAttribute("readOnly");
                    cbSupp.checked = false;
                    if (txt_box_date.value == "N.P") {
                        txt_box_date.value = "12/9999";
                    }
                    
                    IdDateFin = nom_txt_box_date;                     
                    IdZoneRef = nom_txt_box_reference;
                }
                else {
                    txt_box_date.setAttribute("readOnly", "true");
                    txt_box_reference.setAttribute("readOnly", "true");
                    // recup de la date de fin de suivi qui etait affiche
                    var donne = lst_datefin[parseInt(numero, 10)];
                    // recup de la rfrence qui etait affiche
                    var donneref = lst_zoneref[parseInt(numero, 10)];

                    //if (donne == "12/9999") {
                    //    donne = "N.P";
                    //}
                    txt_box_date.value = donne;
                    txt_box_reference.value = donneref;

                    //comme les champs date fin et rfrence prcdents ont t verifis
                    //et que le champ date fin courant et rfrence courant sont remis  l'etat initiale
                    //on repart comme au tout dbut  =>  IdDateFin = 'DateFinSuivi0' et IdZoneRef = 'Reference0';
                    IdDateFin = 'DateFinSuivi0';
                    IdZoneRef = 'Reference0';
                }
            } else {
                if (cbSupp.checked == true) {
                    cbModif.checked = false;
                    // recup de la date de fin de suivi et de la zone de rfrence qui etait affiche
                    txt_box_date.setAttribute("readOnly", "true");
                    txt_box_reference.setAttribute("readOnly", "true");
                    var donne = lst_datefin[parseInt(numero, 10)];
                    var donneref = lst_zoneref[parseInt(numero, 10)];
                    txt_box_date.value = donne;
                    txt_box_reference.value = donneref;
                }
            }
        }
        else {
            // rfrence invalide
            cbSupp.checked = false;
            cbModif.checked = false;   
        }
    }
    else {
      // date invalide
       cbSupp.checked = false;
       cbModif.checked = false;   
    }
}

// fonctions sur la date de fin de suivi
function FormatYearSuivi(nYear) {
    var bReturnValue = true;

    aaaa = parseInt(nYear);


    if (aaaa < 0 || aaaa > 9999) {
        bReturnValue = false;
    }
    else {
    
        if (aaaa >= 1900) {
            bReturnValue = true;
        }
        else {
            // mise en forme de l'annee si elle n'est pas saisie sur 4 chiffres
            if ((aaaa > 99) && (aaaa < 1900)) {
                bReturnValue = false;
            }
            else {
                if (aaaa > 30) {
                    aaaa = 1900 + aaaa;
                }
                else {
                    aaaa = 2000 + aaaa;
                }
            }
        }
    }
    return (bReturnValue);
}

//Formate une date en MM/AAAA
var mm; //mois
var aa; //annee
var aaaa; //annee sur 4 car.

function FormatAffDateSuivi(sDate) {

    mm = "";
    aa = ""; //annee
    aaaa = ""; //annee sur 4 car.

   
    var slash1 = -1;
    var slash2 = -1;
    if (sDate != null) {
        slash1 = sDate.indexOf("/");
        slash2 = sDate.indexOf(" ", slash1 + 1);
        
    }
    if (slash1 != -1)  {
        mm = sDate.substring(0, slash1);


        if (isNaN(mm) == true) {
           return ("");
        }

        if (mm.indexOf(" ") != -1)
        {
             mm= Replace(mm, " ", "");
        }
      
        if (mm.length == 1) mm = "0" + mm;

        if ((slash2 != -1)) {
            aa = sDate.substring(slash1 + 1, slash2);
        }
        else {
            aa = sDate.substring(slash1 + 1, sDate.length);
        }

        if (isNaN(aa) == true) {
            return ("");
        } 

        if (FormatYearSuivi(aa)) {
            return (mm + "/" + aaaa);
        }
    }
    return ("");
}

function FormatDateSuivi(oDate) {
    var sDate;
    var bReturnValue = false;

    sDate = FormatAffDateSuivi(oDate.value);
    if (sDate != "") {
        oDate.value = sDate;
        bReturnValue = true;
    }
    return (bReturnValue);
}

function CheckDateSuivi(nMonth, nYear) {
    var ladate = new Date(nYear, nMonth - 1, 01);
    // m-1 car getMonth retourne un entier entre 0 et 11
    return ((nYear == ladate.getFullYear()) && (nMonth - 1 == ladate.getMonth()));
}

function DateSuiviVerif(id_oDate, setFocus) {

    var oDate = MM_findObj(id_oDate);
 
    var dateOK = true;

    if (oDate.value != "") {

        if (FormatDateSuivi(oDate) == false) {
            dateOK = false;
            alert(unescape(aErreur['SAS13']));
        } else {
            if ((CheckDateSuivi(mm, aaaa) == false) && (oDate.value != "")) {
                dateOK = false;
                alert(unescape(aErreur['SAS13']));
            }
        }
    } else {

        if (setFocus && DateFinValide) {
            dateOK = false;
            alert(unescape(aErreur['SAS13']));
        }
    }

    if (dateOK) {
        // verification que la date de fin de suivi n'est pas infrieure au mois de l'anne en cours
        var annee = new Date().getFullYear();   //annee en cours
        var mois = new Date().getMonth();       //mois en cours
        var moisSaisie = mm - 1;              // sous forme de valeur numrique

        if (annee > aa) {
            dateOK = false;
            oDate.value = "";
            alert(unescape(aErreur['SAS14']));
        }
        else {
            if ((annee == aa) && (mois > moisSaisie)) {
                dateOK = false;
                oDate.value = "";
                alert(unescape(aErreur['SAS14']));
            }
        }
    }

    if (!dateOK && setFocus) {

        oDate.select();
        oDate.focus();
    }

    return dateOK;
}

//fonction utilise pour afficher une info bulle
function InfoBulle(obj, nb) {

    if (!event && window.event) {
        event = window.event;
    }
    if (obj.value.length < nb) {
        if (event.keyCode == 42) event.keyCode = 0;
    }
}

// fonction utilise pour la modification
// de la date de fin de suivi, de la zone rfrence ou pour les annulations de suivi
// dans la gestion des suivis (GS).
function ModifAnnulRequestSAS_GS(objLink) {

    // verif de la saisie dans la zone rfrence modifie
    var valeurZoneRef = MM_findObj(IdZoneRef);

    //si on est en modif
    if (valeurZoneRef != null) {

        if (!isMatch(valeurZoneRef.value, rgxRefClientSuivis)) {
            alert(unescape(aErreur['SAS99']));
            return false;
        }
    
        // verif de la zone date de fin suivi modifie
        if (!DateSuiviVerif(IdDateFin, true)) {
            return false;
        }
    }

    //on supprime le message d'erreur gnral
    var InfoErreur = MM_findObj('erreur');
    InfoErreur.innerHTML = unescape("");

    var aumoinsunidentifiantselect = false;
    var donneesClient = '';
    /* construction de l'URL*/
    var url = '';
    //Rcupration des Ids slectionns 
    var identifiantsSession = '';
    var identifiantsUrl = '';
    var nbidentifiantselectionnes = 0;
    var numindentifiantURLMax = 1;
    var separateur = ';';
    var indicModif = 'M';
    var indictri = MM_findObj('lst_Trie');

    // Vrification de l'tat des cases  cocher de modification en partant de la premire
    var i = 1; 

    var case_a_cocheModif;

    while ((case_a_cocheModif = MM_findObj('chkModif' + i)) != null) {
        if (case_a_cocheModif.checked == true) {

            aumoinsunidentifiantselect = true
            //rcupration de l'identifiant slection
            var labelId = MM_findObj('Identifiant' + i);
            var textboxZoneReference = MM_findObj('Reference' + i); 
            var textboxTypeSuivi = MM_findObj('TypedeSuivi' + i);
            var textboxDateFin = MM_findObj('DateFinSuivi' + i);
            nbidentifiantselectionnes++;

            if (nbidentifiantselectionnes <= numindentifiantURLMax) {
                identifiantsUrl += '&ID=' + labelId.innerHTML + '&REF=' + textboxZoneReference.value + '&MM=' + textboxTypeSuivi.value + '&action=' + indicModif + '&date=' + (textboxDateFin.value).substring(0, 2) + (textboxDateFin.value).substring(3, 7) + '&tri=' + indictri.value;
            }
            else {
                identifiantsSession += labelId.innerHTML + separateur + textboxZoneReference.value + separateur + textboxTypeSuivi.value + separateur + indicModif + separateur + (textboxDateFin.value).substring(0, 2) + (textboxDateFin.value).substring(3, 7) + separateur + '*';
            }
        }

        i++;
    }
    
    // Vrification de l'tat des cases  cocher de suppression ...
    var indicAnnul = 'S';
    var k = 1; //  ... en partant de la premire
    var case_a_cocheAnnul;

    while ((case_a_cocheAnnul = MM_findObj('chkSup' + k)) != null) {
        if (case_a_cocheAnnul.checked == true) {

            aumoinsunidentifiantselect = true
            //rcupration de l'identifiant slection
            var labelId = MM_findObj('Identifiant' + k);
            var textboxZoneReference = MM_findObj('Reference' + k);
            var textboxTypeSuivi = MM_findObj('TypedeSuivi' + k);
           
            nbidentifiantselectionnes++;

            if (nbidentifiantselectionnes <= numindentifiantURLMax) {
                identifiantsUrl += '&ID=' + labelId.innerHTML + '&REF=' + textboxZoneReference.value + '&MM=' + textboxTypeSuivi.value + '&action=' + indicAnnul + '&tri=' + indictri.value; ;
            }
            else {
                identifiantsSession += labelId.innerHTML + separateur + textboxZoneReference.value + separateur + textboxTypeSuivi.value + separateur + indicAnnul + separateur + separateur + '*';
            }
        }

        k++;
    }

    if (aumoinsunidentifiantselect == true) {

       if (identifiantsSession.length > 0) {
            identifiantsSession = identifiantsSession.substring(0, identifiantsSession.length - 1);
        }

        url = cstRoot + '/Modules/Module.aspx?Mod=S3' + '&NB=' + nbidentifiantselectionnes + identifiantsUrl;

        donneesClient = identifiantsSession + "|" + url;

        /* gestion du retour serveur*/
        var cb = document.getElementById("BtValider");

        if ((cb != null)  && (nbidentifiantselectionnes > numindentifiantURLMax)) {
            // Pour le client HTML, dans la cas de la modification des fin de suivis des identifiants

            //        /* sauvegarde des donnes dans la textbox*/
            var tb = document.getElementById("DATA_Client");
            tb.value = donneesClient;

            //        /* simuler le click sur le bouton cach */
            cb.click();
        }
        else {
            //        // Pour le client automate, dans la cas de la suppression des identifiants
            //        // et pour la suppression d'une BAL , le client HTML et le client automate, seront traits ici aussi .

            //        // redirection
            if (objLink.tagName == 'BUTTON') {
                window.location.href = url;
            } else {
                objLink.href = url;
            }
        }
    } 
}

// fonction qui relance la transaction S2 avec un nouveau critre de tri
function ChangeTriListeSuivis(objLink) {
    const oInput = MM_findObj('lst_Trie');
    const tri = oInput.options[oInput.selectedIndex].value;    
    
    window.location = `${cstRoot}/Modules/Module.aspx?Mod=S2&Tri=${tri}`;

}

// fonction qui relance la transaction S4 avec un nouveau critre de tri
function ChangeTriListeSuivisMouve(objLink) {
    const oInput = MM_findObj('lst_TrieMouve');
    const tri = oInput.options[oInput.selectedIndex].value;

    window.location = (`${cstRoot}/Modules/Module.aspx?Mod=S4&Tri=${tri}`);
}

// fonction qui lance la transaction pour afficher le dtail d'un mouvement suivi S4 -> S5
function VoirDetailSuivi(id, mod, date, pkg, objLink) {
    const indictri = MM_findObj('lst_TrieMouve');
    const tri = indictri.value;

    var sURL = `Modules/Module.aspx?Mod=S5&Id=${id}&PK=${pkg}`;
    sURL = `${sURL}&MM=${mod}&date=${date}&tri=${tri}`;
    window.location = (`${cstRoot}/${sURL}`);
}

// fonction qui lance la transaction pour afficher le dtail d'un mouvement suivi S5 -> S5
function VoirDetailMouvement(chaine) {
    const info = chaine.split(";");
    var sURL = `Modules/Module.aspx?Mod=S5&Id=${info[0]}&PK=${info[1]}`;
    sURL = `${sURL}&MM=${info[2]}&date=${info[3]}`;
    window.location = (`${cstRoot}/${sURL}`);
}

//fonction utilise pour afficher dynamiquement les Textbox des identifiant  saisir
function Tst_Conditions_InitialesSAS_GS() {

    //affichage des champs des identifiants et des champs des rfrences ncessaires
    const nombreIdentifiantMAX = 5;
    const nombreIdentifiantMIN = 1;
    const nomdreReferenceMAX = 5;
    const nombreReferenceMIN = 1;

    const tailleIdent = "17"; // IE par dfaut
    const tailleRef = "22"; // IE par dfaut

    // initialisation force  5
    var nombreSuiviRestante = 5;
    var nombreSuiviRefRestant = 5;

    if (nombreSuiviRestante >= nombreIdentifiantMIN) {

        if (nombreSuiviRestante > nombreIdentifiantMAX) {
            nombreSuiviRestante = nombreIdentifiantMAX;
        }

        for (var indexIndentifiant = nombreIdentifiantMIN; indexIndentifiant <= nombreSuiviRestante; indexIndentifiant++) {

            // affichage de la textbox
            var txt_ident = document.getElementById("txt_ident" + indexIndentifiant);
            if (txt_ident != null) {
                txt_ident.style.visibility = 'visible';

                // dfinition de la taille du champ
                txt_ident.size = tailleIdent;
            }
        }
    }

    if (nombreSuiviRefRestant >= nombreReferenceMIN) {

        if (nombreSuiviRefRestant > nomdreReferenceMAX) {
            nombreSuiviRefRestant = nomdreReferenceMAX;
        }

        for (var indexReference = nombreReferenceMIN; indexReference <= nombreSuiviRefRestant; indexReference++) {

            // affichage de la textbox
            var txt_ref = document.getElementById("txt_ref" + indexReference);
            if (txt_ref != null) {
                txt_ref.style.visibility = 'visible';
                txt_ref.value = '';

                // dfinition de la taille du champ
                txt_ref.size = tailleRef;
            }
        }
    }
}

// fonction utilise pour la validation des inscription aux suivis
function validRequestSAS_GS(objLink)
{
    var numindentifiant = 5;
    var numreference = 5;
    var dateFinSelect = '129999';

    //on supprime le message d'erreur gnral
    var InfoErreur = MM_findObj('erreur');
    InfoErreur.innerHTML = unescape("");
    var signalisation;

    //on cache par dfaut la signalisation d'erreur des champs concernant les identifiants
    for (var i = 1; i <= numindentifiant; i++)
    {
        signalisation = MM_findObj('sgn_ident' + i);
        signalisation.style.visibility = 'hidden';
    }
    //on cache par dfaut la signalisation d'erreur des champs concernant les rfrences
    for (var i = 1; i <= numreference; i++)
     {
        signalisation = MM_findObj('sgn_identRef' + i);
        signalisation.style.visibility = 'hidden';
    }

    //on cache les signalisations d'erreur des champs concernant la date de fin et le module ou package 
    signalisation = MM_findObj('sgn_anneefin');
    signalisation.style.visibility = 'hidden';
    signalisation = MM_findObj('sgn_module');
    signalisation.style.visibility = 'hidden';
    signalisation = MM_findObj('sgn_moisfin');
    signalisation.style.visibility = 'hidden';
   
    //contrle des diffrents champ contenant les identifiants
    var erreur_identifiant = false;
    var AuMoinsUnIdentifiantSaisie = false;
    var arDico = new Array();
    var DoublonExistant = false;
    var iTypeIdent = 0;

    for (var i = 1; i <= numindentifiant; i++)
    {
        var champ_identifiant = MM_findObj('txt_ident' + i);
        var identifiantValue = tryClearSpacesSiren(champ_identifiant.value);

        if (identifiantValue != '')
        {
            AuMoinsUnIdentifiantSaisie = true;

            iTypeIdent = iCheckIdentifiant(identifiantValue);
            if (iTypeIdent == cstNothing)
            {
                signalisation = MM_findObj('sgn_ident' + i);
                signalisation.style.visibility = 'visible';
                erreur_identifiant = true;
            } 

            // ajout 30-06-2011 empcher clef BDF sans suffixe . les 2 dernier caracteres doivent etre numeriques
            if (iTypeIdent == cstBDFKey)
            {
                var str = tryClearSpacesSiren(identifiantValue)
                if (isNaN(str.substr(str.length - 2, 2)))
                {
                    signalisation = MM_findObj('sgn_ident' + i);
                    signalisation.style.visibility = 'visible';
                    erreur_identifiant = true;
                }
            }

            // contrle des doublons
            if (!arDico[identifiantValue])
            {
                arDico[identifiantValue] = 'renseigne';
            }
            else
            {
                DoublonExistant = true;
                signalisation = MM_findObj('sgn_ident' + i);
                signalisation.style.visibility = 'visible';

            }
        }
    }

    if (!AuMoinsUnIdentifiantSaisie)
    {
        for (var i = 1; i <= numindentifiant; i++)
        {
            var champ_identifiant = MM_findObj('txt_ident' + i);

            if (champ_identifiant.style.visibility == 'visible')
            {
                signalisation = MM_findObj('sgn_ident' + i);
                signalisation.style.visibility = 'visible';
            }
        }

        InfoErreur.innerHTML = unescape(aErreur['U053']);
        return false;
    }

    if (erreur_identifiant)
    {
        InfoErreur.innerHTML = unescape(aErreur['U01']);
        return false;
    }

    if (DoublonExistant)
    {
        InfoErreur.innerHTML = unescape(aErreur['SAS4']);
        return false;
    }

    // contrle de la date de fin de suivi
    var oMois = MM_findObj('lst_MoisFinSuivi');
    var oAnnee = MM_findObj('lst_AnneeFinSuivi');
    var oDateFinSuivi = (oMois.options[oMois.selectedIndex].value + oAnnee.options[oAnnee.selectedIndex].value);
    var MoisEnCours = new Date().getMonth() + 1;
    var AnneeEnCours = new Date().getFullYear();

    if (oAnnee.options[oAnnee.selectedIndex].value != '0')
    {
        if (oMois.options[oMois.selectedIndex].value == '0')
        {
            signalisation = MM_findObj('sgn_moisfin');
            signalisation.style.visibility = 'visible';
            InfoErreur.innerHTML = unescape(aErreur['SAS10']);
            return false;
        }
        else
        {
            if (oAnnee.options[oAnnee.selectedIndex].value < AnneeEnCours)
            {
                signalisation = MM_findObj('sgn_anneefin');
                signalisation.style.visibility = 'visible';
                signalisation = MM_findObj('sgn_moisfin');
                signalisation.style.visibility = 'visible'; 
                InfoErreur.innerHTML = unescape(aErreur['SAS11']);
                return false;
            }
            else
            {
                if (oAnnee.options[oAnnee.selectedIndex].value == AnneeEnCours)
                {
                    if (oMois.options[oMois.selectedIndex].value < MoisEnCours)
                    {
                        signalisation = MM_findObj('sgn_moisfin');
                        signalisation.style.visibility = 'visible';
                        signalisation = MM_findObj('sgn_anneefin');
                        signalisation.style.visibility = 'visible';
                        InfoErreur.innerHTML = unescape(aErreur['SAS11']);
                        return false;
                    }
                    else
                    {
                        // la date de fin est valable
                        dateFinSelect = oMois.options[oMois.selectedIndex].value + oAnnee.options[oAnnee.selectedIndex].value;
                        if (dateFinSelect.length == 5)
                        {
                            dateFinSelect = "0" + dateFinSelect;
                        }
                    }
                }
                else
                {
                    // la date de fin est valable
                    dateFinSelect = oMois.options[oMois.selectedIndex].value + oAnnee.options[oAnnee.selectedIndex].value;
                    if (dateFinSelect.length == 5)
                    {
                        dateFinSelect = "0" + dateFinSelect;
                    }
                }
            }
        }
    }
    else
    {
        if (oMois.options[oMois.selectedIndex].value != '0')
        {
            signalisation = MM_findObj('sgn_anneefin');
            signalisation.style.visibility = 'visible';
            InfoErreur.innerHTML = unescape(aErreur['SAS9']);
            return false;
        }
    }

    // controle saisi du code micromodule ou package
    var moduleSaisi = MM_findObj('lst_MMPK');

    if (moduleSaisi.options[moduleSaisi.selectedIndex].value == '0')
    {
        signalisation = MM_findObj('sgn_module');
        signalisation.style.visibility = 'visible';
        InfoErreur.innerHTML = unescape(aErreur['SAS12']);
    }

    // controle de la saisie correcte dans les zones des rfrences
    for (var k = 1; k <= numreference; k++) {
        var zoneRefText = MM_findObj('txt_ref' + k);
        if (!isMatch(zoneRefText.value, rgxRefClientSuivis)) {
            signalisation = MM_findObj('sgn_identRef' + k);
            signalisation.style.visibility = 'visible';
            InfoErreur.innerHTML = unescape(aErreur['SAS99']);
            return false;
        }
    }
         
    // construction de l'URL
    var identifiantsUrl = ''
    for (var i = 1; i <= numindentifiant; i++)
    {
        var champ_identifiant = MM_findObj('txt_ident' + i);
        var champ_reference = MM_findObj('txt_ref' + i);
        let cleanupValue = tryClearSpacesSiren(champ_identifiant.value);

        if (cleanupValue != '')
         {
            identifiantsUrl += cleanupValue + ';' + champ_reference.value + ';';
         }
    }

    // retrait du dernier point-virgule
    identifiantsUrl = identifiantsUrl.substring(0, identifiantsUrl.length - 1);

    var url = cstRoot + '/Modules/Module.aspx?Mod=' + (moduleSaisi.options[moduleSaisi.selectedIndex].value) + '&date=' + dateFinSelect + '&ID=' + identifiantsUrl;

    /* redirection*/
    if (objLink.tagName == 'BUTTON') {
        window.location.href = url;
    } else {
        objLink.href = url;
    }
}

// fonction utilise pour effacer tout les champs de saisie
// et les messages d'erreur et remettre les listes droulantes mois, annee et typemodule  blanc
function EffacerSAS_GS()
{
    var numindentifiant = 5;
    var numreference = 5;

    for (var i = 1; i <= numindentifiant; i++)
    {
        var champ_identifiant = MM_findObj('txt_ident' + i);
        champ_identifiant.value = "";
    }

    for (var i = 1; i <= numreference; i++) {
        var champ_reference = MM_findObj('txt_ref' + i);
        champ_reference.value = "";
    }
    //on supprime le message d'erreur gnral
    var InfoErreur = MM_findObj('erreur');
    InfoErreur.innerHTML = unescape("");
    //on cache les signalisations d'erreur des champs concernant la date de fin et le module ou package 
    var signalisation = MM_findObj('sgn_anneefin');
    signalisation.style.visibility = 'hidden';
    signalisation = MM_findObj('sgn_module');
    signalisation.style.visibility = 'hidden';
    signalisation = MM_findObj('sgn_moisfin');
    signalisation.style.visibility = 'hidden';

    //on cache par dfaut la signalisation d'erreur des champs concernant les identifiants
    for (var i = 1; i <= numindentifiant; i++)
    {
        signalisation = MM_findObj('sgn_ident' + i);
        signalisation.style.visibility = 'hidden';
    }
    //on cache par dfaut la signalisation d'erreur des champs concernant les rfrences
    for (var i = 1; i <= numreference; i++)
     {
        signalisation = MM_findObj('sgn_identRef' + i);
        signalisation.style.visibility = 'hidden';
    }

    initModules(0);
    remplirMoisFin(0);
    remplirAnneeFin(15);
}

// fonctions qui remplissent dynamiquement les liste droulantes de la cration des suivis
// remplir la liste des micro modules et packages
function initModules(iSectIndex)
{
    var oSelect = MM_findObj("lst_MMPK");

    if (oSelect !== "")
    {
        var i, oOpt, sTxt;
        oSelect.length = 0;

        if (iSectIndex >= 0)
        {
            for (i = 0; i < arModSASClasse.length; i++)
            {
                sTxt = arModSASClasse[i];
                oOpt = new Option(sTxt, sTxt.substr(0, 2), false, false);
                oSelect.options.add(oOpt);
            }
        }
        oSelect[iSectIndex].selected = true;
    }
}

// remplir liste  annes pour fin suivi
function remplirAnneeFin(nbAnnees)
{
    var i, oOpt, sTxt, oInput;
    var anneeEnCours;
    var lstAnnee = MM_findObj('lst_AnneeFinSuivi');
    if (lstAnnee != '')
    {
        anneeEnCours = new Date();
        lstAnnee.length = 0;
        oOpt = new Option('...' + strFillIn(10) + '', '0', false, false);
        lstAnnee.options[0] = oOpt;

        for (i = 0; i < nbAnnees; i++)
        {
            sTxt = (anneeEnCours.getFullYear() + i);
            oOpt = new Option(sTxt, sTxt, false, false);
            lstAnnee.options.add(oOpt);
        }
        lstAnnee[0].selected = true;
    }
}

// remplir liste mois pour fin suivi
function remplirMoisFin(iSectIndex)
{
    var oSelect = MM_findObj('lst_MoisFinSuivi');

    if (oSelect != '')
    {
        var i, oOpt, sTxt, oInput;
        oSelect.length = 0;
        oOpt = new Option('...' + strFillIn(7) + '', '0', false, false);
        oSelect.options[0] = oOpt;
        if (iSectIndex >= 0)
        {
            for (i = 0; i < arMoisFinSASClasse.length; i++)
            {
                sTxt = arMoisFinSASClasse[i];
                oOpt = new Option(sTxt, sTxt, false, false);
                oSelect.options.add(oOpt);
            }
        }
        oSelect[iSectIndex].selected = true;
    }
}
