<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
					              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
					              xmlns:bdf="http://banque-france.fr/namespace">
  <xsl:import href="../../Ressources/XSL/Commun.xsl"/>
  <xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes" />
  <xsl:param name="langage" select="'fr'"/>
  <xsl:param name="root" select="'/Fiben/'"/>
  <xsl:param name="familyName" select="''"/>
  <xsl:param name="familyNumber" select="''"/>
  <xsl:param name="familyTitle" select="''"/>
  <xsl:param name="nextModule" select="''"/>
  <xsl:param name="nextId" select="''"/>
  <xsl:param name="nextFamily" select="''"/>
  <xsl:param name="Lang" select="'FR'"/>
  <xsl:param name="NonResident" select="''"/>
  <xsl:param name="menuHTML1"/>


  <xsl:template match="/">
    <html lang="fr">
      <title>Module VB - Vitrine bilans</title>
      <xsl:call-template name="genHead">
        <xsl:with-param name="ident" select="FIBEN/ERREUR/IDENT | FIBEN/PERSONNE/MODULEVB/EJ/IDENTS"/>
      </xsl:call-template>
      <body class="clBodybgcolorWhite">
        <xsl:call-template name="genFondMenu">
          <xsl:with-param name="root" select="$root"/>
        </xsl:call-template>
        <xsl:copy-of select="$menuHTML1"/>
        
        <table class="mainmodule horizontal-auto clBorderCell">
          <caption class="visually-hidden">Module VB - Vitrine bilans</caption>
          <xsl:call-template name="genLigneConfidentiel" />
          <xsl:apply-templates select="/FIBEN/ERREUR"/>
          <xsl:if test="not(/FIBEN/ERREUR)">
            <tr>
              <td class="clWidth14"></td>
              <td class="clCouleur2 clValignTop clWidth739" colspan="4">
                <xsl:call-template name="genEnTete">
                  <xsl:with-param name="ident" select="FIBEN/PERSONNE/MODULEVB/EJ/IDENTS"/>
                  <xsl:with-param name="nom" select="FIBEN/PERSONNE/MODULEVB/EJ/DENOM"/>
                </xsl:call-template>
                <xsl:apply-templates select="FIBEN/PERSONNE/MODULEVB/IST17" mode="genLib"/>

                <!-- ********* Appel du template de fabrication du Tableau ********* -->

                <xsl:if test="not(FIBEN/PERSONNE/MODULEVB/IST17)">
                  <xsl:call-template name ="genVB"/>
                  <!-- tous modules sauf 66 et 67-->
                  <xsl:if test ="/FIBEN/PERSONNE/MODULEVB/MODULE/DONMOD[../NUMMOD!=66 and ../NUMMOD!=67]">
                    <xsl:call-template name ="genVBtitre">
                      <xsl:with-param name ="titre" select ="'Donnes comptables sur base sociale'"/>
                    </xsl:call-template>
                    <xsl:call-template name="RechDateTableauVB">
                      <xsl:with-param name ="max" select ="count(//DONMOD[../NUMMOD!=66 and ../NUMMOD!=67])"/>
                      <xsl:with-param name ="listeDateTest" select ="/FIBEN/PERSONNE/MODULEVB/MODULE/DONMOD[../NUMMOD!=66 and ../NUMMOD!=67]/@DATCLOT"/>
                      <xsl:with-param name ="listeDureeTest" select="/FIBEN/PERSONNE/MODULEVB/MODULE/DONMOD[../NUMMOD!=66 and ../NUMMOD!=67]/@DUREEEX"/>
                      <xsl:with-param name="dateClot1" select="'129999'"/>
                      <xsl:with-param name="dateClot2" select="'128888'"/>
                      <xsl:with-param name="dateClot3" select="'127777'"/>
                      <xsl:with-param name="dateDuree1" select="'99'"/>
                      <xsl:with-param name="dateDuree2" select="'88'"/>
                      <xsl:with-param name="dateDuree3" select="'77'"/>
                      <xsl:with-param name ="n" select ="1"/>
                      <xsl:with-param name ="TypeTableau" select ="'Social'"/>
                    </xsl:call-template>
                  </xsl:if>
                  <!-- uniquement modules 66 et 67-->
                  <xsl:if test ="/FIBEN/PERSONNE/MODULEVB/MODULE/DONMOD[../NUMMOD=66 or ../NUMMOD=67]">
                    <xsl:call-template name ="genVBtitre">
                      <xsl:with-param name ="titre" select ="'Donnes comptables sur base consolide'"/>
                    </xsl:call-template>
                    <xsl:call-template name="RechDateTableauVB">
                      <xsl:with-param name ="max" select ="count(//DONMOD[../NUMMOD=66 or ../NUMMOD=67])"/>
                      <xsl:with-param name ="listeDateTest" select ="/FIBEN/PERSONNE/MODULEVB/MODULE/DONMOD[../NUMMOD=66 or ../NUMMOD=67]/@DATCLOT"/>
                      <xsl:with-param name ="listeDureeTest" select="/FIBEN/PERSONNE/MODULEVB/MODULE/DONMOD[../NUMMOD=66 or ../NUMMOD=67]/@DUREEEX"/>
                      <xsl:with-param name="dateClot1" select="'129999'"/>
                      <xsl:with-param name="dateClot2" select="'128888'"/>
                      <xsl:with-param name="dateClot3" select="'127777'"/>
                      <xsl:with-param name="dateDuree1" select="'99'"/>
                      <xsl:with-param name="dateDuree2" select="'88'"/>
                      <xsl:with-param name="dateDuree3" select="'77'"/>
                      <xsl:with-param name ="n" select ="1"/>
                      <xsl:with-param name ="TypeTableau" select ="'Conso'"/>
                    </xsl:call-template>
                  </xsl:if>
                </xsl:if>
                <xsl:call-template name="shim"/>
              </td>
            </tr>
            <tr>
              <td class="clWidth442 clAlignRight" colspan="4"></td>
              <xsl:if test="not(//IST17)">
                  <a href="#ancHaut" >
                    <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" alt="Retour en haut de la page"/>
                  </a>
              </xsl:if>
            </tr>
            
          </xsl:if>
        </table>
        <xsl:call-template name="genBasPage"/>
      </body>
    </html>
  </xsl:template>

  <!--************************************* Partie Tableau Vitrine Bilan ********************************************************************-->

  <xsl:template name ="RechDateTableauVB">
    <xsl:param name ="n"/>
    <xsl:param name ="max"/>
    <xsl:param name ="listeDateTest"/>
    <xsl:param name ="listeDureeTest"/>
    <xsl:param name ="dateTest"/>
    <xsl:param name ="dateClot1"/>
    <xsl:param name ="dateClot2"/>
    <xsl:param name ="dateClot3"/>
    <xsl:param name ="dateDuree1"/>
    <xsl:param name ="dateDuree2"/>
    <xsl:param name ="dateDuree3"/>
    <xsl:param name ="TypeTableau"/>

    <xsl:if test ="$n &gt; $max">
      <!-- fin du test -->
      <xsl:call-template name ="ChoixTableauVB">
        <xsl:with-param name="dateClot1" select="$dateClot1"/>
        <xsl:with-param name="dateClot2" select="$dateClot2"/>
        <xsl:with-param name="dateClot3" select="$dateClot3"/>
        <xsl:with-param name="dateDuree1" select="$dateDuree1"/>
        <xsl:with-param name="dateDuree2" select="$dateDuree2"/>
        <xsl:with-param name="dateDuree3" select="$dateDuree3"/>
        <xsl:with-param name ="TypeTableau" select ="$TypeTableau"/>
      </xsl:call-template>
    </xsl:if>

    <xsl:if test ="$n &lt;= $max">
      <!-- test -->
      <xsl:choose>
        <xsl:when test ="($dateClot1 = '129999') and ($dateClot1 != $listeDateTest[position()=$n])">

          <xsl:call-template name ="RechDateTableauVB">
            <xsl:with-param name ="n" select ="$n + 1"/>
            <xsl:with-param name ="max" select ="$max"/>
            <xsl:with-param name="dateClot1" select="$listeDateTest[position()=$n]"/>
            <xsl:with-param name="dateClot2" select="$dateClot2"/>
            <xsl:with-param name="dateClot3" select="$dateClot3"/>
            <xsl:with-param name="dateDuree1" select="$listeDureeTest[position()=$n]"/>
            <xsl:with-param name="dateDuree2" select="$dateDuree2"/>
            <xsl:with-param name="dateDuree3" select="$dateDuree3"/>
            <xsl:with-param name ="listeDateTest" select ="$listeDateTest"/>
            <xsl:with-param name ="listeDureeTest" select ="$listeDureeTest"/>
            <xsl:with-param name ="TypeTableau" select ="$TypeTableau"/>
          </xsl:call-template>
        </xsl:when>

        <!-- ***************** 2eme date cloture ********************* -->

        <xsl:when test ="($dateClot2 = '128888') and ($dateClot1 != $listeDateTest[position()=$n])">

          <xsl:call-template name ="RechDateTableauVB">
            <xsl:with-param name ="n" select ="$n + 1"/>
            <xsl:with-param name ="max" select ="$max"/>
            <xsl:with-param name="dateClot1" select="$dateClot1"/>
            <xsl:with-param name="dateClot2" select="$listeDateTest[position()=$n]"/>
            <xsl:with-param name="dateClot3" select="$dateClot3"/>
            <xsl:with-param name="dateDuree1" select="$dateDuree1"/>
            <xsl:with-param name="dateDuree2" select="$listeDureeTest[position()=$n]"/>
            <xsl:with-param name="dateDuree3" select="$dateDuree3"/>
            <xsl:with-param name ="listeDureeTest" select ="$listeDureeTest"/>
            <xsl:with-param name ="listeDateTest" select ="$listeDateTest"/>
            <xsl:with-param name ="TypeTableau" select ="$TypeTableau"/>
          </xsl:call-template>
        </xsl:when>

        <!-- ***************** 3eme date cloture ********************* -->

        <xsl:when test ="($dateClot3 = '127777') and (($dateClot1 != $listeDateTest[position()=$n]) and ($dateClot2 != $listeDateTest[position()=$n]))">

          <xsl:call-template name ="RechDateTableauVB">
            <xsl:with-param name ="n" select ="$n + 1"/>
            <xsl:with-param name ="max" select ="$max"/>
            <xsl:with-param name="dateClot1" select="$dateClot1"/>
            <xsl:with-param name="dateClot2" select="$dateClot2"/>
            <xsl:with-param name="dateClot3" select="$listeDateTest[position()=$n]"/>
            <xsl:with-param name ="listeDateTest" select ="$listeDateTest"/>
            <xsl:with-param name="dateDuree1" select="$dateDuree1"/>
            <xsl:with-param name="dateDuree2" select="$dateDuree2"/>
            <xsl:with-param name="dateDuree3" select="$listeDureeTest[position()=$n]"/>
            <xsl:with-param name ="listeDureeTest" select ="$listeDureeTest"/>
            <xsl:with-param name ="TypeTableau" select ="$TypeTableau"/>
          </xsl:call-template>
        </xsl:when>

        <xsl:otherwise>
          <!-- **************************** boucle de retour ***************************** -->
          <xsl:if test ="$n &lt;= $max ">
            <xsl:call-template name ="RechDateTableauVB">
              <xsl:with-param name ="n" select ="$n + 1"/>
              <xsl:with-param name ="max" select ="$max"/>
              <xsl:with-param name="dateClot1" select="$dateClot1"/>
              <xsl:with-param name="dateClot2" select="$dateClot2"/>
              <xsl:with-param name="dateClot3" select="$dateClot3"/>
              <xsl:with-param name ="listeDateTest" select ="$listeDateTest"/>
              <xsl:with-param name="dateDuree1" select="$dateDuree1"/>
              <xsl:with-param name="dateDuree2" select="$dateDuree2"/>
              <xsl:with-param name="dateDuree3" select="$dateDuree3"/>
              <xsl:with-param name ="listeDureeTest" select ="$listeDureeTest"/>
              <xsl:with-param name ="TypeTableau" select ="$TypeTableau"/>
            </xsl:call-template>
          </xsl:if>
        </xsl:otherwise>

      </xsl:choose>
    </xsl:if>

  </xsl:template>

  <xsl:template name ="ChoixTableauVB">
    <xsl:param name ="dateClot1"/>
    <xsl:param name ="dateClot2"/>
    <xsl:param name ="dateClot3"/>
    <xsl:param name ="dateDuree1"/>
    <xsl:param name ="dateDuree2"/>
    <xsl:param name ="dateDuree3"/>
    <xsl:param name ="TypeTableau"/>
    
    <!-- Formatage des dates de clotures pour avoir l'anne avant le mois  (exemple 042021 devient 202104) -->
    <xsl:variable name ="newDateClot1" select ="concat(substring($dateClot1,3, 4), substring($dateClot1,1, 2))"></xsl:variable>
    <xsl:variable name ="newDateClot2" select ="concat(substring($dateClot2,3, 4), substring($dateClot2,1, 2))"></xsl:variable>
    <xsl:variable name ="newDateClot3" select ="concat(substring($dateClot3,3, 4), substring($dateClot3,1, 2))"></xsl:variable>
      
    
    <xsl:choose>
      <xsl:when test ="$dateClot2 = 128888">
        <!-- tableau  1 colonne -->
        <xsl:call-template name ="TableauVb1Col">
          <xsl:with-param name ="DateClot1erCols" select ="$dateClot1"/>
          <xsl:with-param name ="DateDuree1erCols" select ="$dateDuree1"/>
        </xsl:call-template>
        <xsl:call-template name ="RemplirTableauVb1">
          <xsl:with-param name ="DateClot1erCols" select ="$dateClot1"/>
          <xsl:with-param name ="TypeTableau" select ="$TypeTableau"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:choose>
          <xsl:when test ="$dateClot3 != 127777">
            <!-- tableau  3 colonnes -->
            <xsl:choose>
              <xsl:when test ="($newDateClot3 &gt; $newDateClot2) and ($newDateClot2 &gt; $newDateClot1)">
                <xsl:call-template name ="TableauVb3Cols">
                  <xsl:with-param name ="DateClot1erCols" select ="$dateClot1"/>
                  <xsl:with-param name ="DateClot2emeCols" select ="$dateClot2"/>
                  <xsl:with-param name ="DateClot3emeCols" select ="$dateClot3"/>
                  <xsl:with-param name ="DateDuree1erCols" select ="$dateDuree1"/>
                  <xsl:with-param name ="DateDuree2emeCols" select ="$dateDuree2"/>
                  <xsl:with-param name ="DateDuree3emeCols" select ="$dateDuree3"/>
                </xsl:call-template>
                <xsl:call-template name ="RemplirTableauVb3">
                  <xsl:with-param name ="DateClot1erCols" select ="$dateClot1"/>
                  <xsl:with-param name ="DateClot2emeCols" select ="$dateClot2"/>
                  <xsl:with-param name ="DateClot3emeCols" select ="$dateClot3"/>
                  <xsl:with-param name ="TypeTableau" select ="$TypeTableau"/>
                </xsl:call-template>
              </xsl:when>
              <xsl:when test ="($newDateClot2 &gt; $newDateClot3) and ($newDateClot3 &gt; $newDateClot1)">
                <xsl:call-template name ="TableauVb3Cols">
                  <xsl:with-param name ="DateClot1erCols" select ="$dateClot1"/>
                  <xsl:with-param name ="DateClot2emeCols" select ="$dateClot3"/>
                  <xsl:with-param name ="DateClot3emeCols" select ="$dateClot2"/>
                  <xsl:with-param name ="DateDuree1erCols" select ="$dateDuree1"/>
                  <xsl:with-param name ="DateDuree2emeCols" select ="$dateDuree3"/>
                  <xsl:with-param name ="DateDuree3emeCols" select ="$dateDuree2"/>
                </xsl:call-template>
                <xsl:call-template name ="RemplirTableauVb3">
                  <xsl:with-param name ="DateClot1erCols" select ="$dateClot1"/>
                  <xsl:with-param name ="DateClot2emeCols" select ="$dateClot3"/>
                  <xsl:with-param name ="DateClot3emeCols" select ="$dateClot2"/>
                  <xsl:with-param name ="TypeTableau" select ="$TypeTableau"/>
                </xsl:call-template>
              </xsl:when>
              <xsl:when test ="($newDateClot1 &gt; $newDateClot2) and ($newDateClot3 &gt; $newDateClot1)">
                <xsl:call-template name ="TableauVb3Cols">
                  <xsl:with-param name ="DateClot1erCols" select ="$dateClot2"/>
                  <xsl:with-param name ="DateClot2emeCols" select ="$dateClot1"/>
                  <xsl:with-param name ="DateClot3emeCols" select ="$dateClot3"/>
                  <xsl:with-param name ="DateDuree1erCols" select ="$dateDuree2"/>
                  <xsl:with-param name ="DateDuree2emeCols" select ="$dateDuree1"/>
                  <xsl:with-param name ="DateDuree3emeCols" select ="$dateDuree3"/>
                </xsl:call-template>
                <xsl:call-template name ="RemplirTableauVb3">
                  <xsl:with-param name ="DateClot1erCols" select ="$dateClot2"/>
                  <xsl:with-param name ="DateClot2emeCols" select ="$dateClot1"/>
                  <xsl:with-param name ="DateClot3emeCols" select ="$dateClot3"/>
                  <xsl:with-param name ="TypeTableau" select ="$TypeTableau"/>
                </xsl:call-template>
              </xsl:when>
              <xsl:when test ="($newDateClot1 &gt; $newDateClot3) and ($newDateClot2 &gt; $newDateClot1)">
                <xsl:call-template name ="TableauVb3Cols">
                  <xsl:with-param name ="DateClot1erCols" select ="$dateClot3"/>
                  <xsl:with-param name ="DateClot2emeCols" select ="$dateClot1"/>
                  <xsl:with-param name ="DateClot3emeCols" select ="$dateClot2"/>
                  <xsl:with-param name ="DateDuree1erCols" select ="$dateDuree3"/>
                  <xsl:with-param name ="DateDuree2emeCols" select ="$dateDuree1"/>
                  <xsl:with-param name ="DateDuree3emeCols" select ="$dateDuree2"/>
                </xsl:call-template>
                <xsl:call-template name ="RemplirTableauVb3">
                  <xsl:with-param name ="DateClot1erCols" select ="$dateClot3"/>
                  <xsl:with-param name ="DateClot2emeCols" select ="$dateClot1"/>
                  <xsl:with-param name ="DateClot3emeCols" select ="$dateClot2"/>
                  <xsl:with-param name ="TypeTableau" select ="$TypeTableau"/>
                </xsl:call-template>
              </xsl:when>
              <xsl:when test ="($newDateClot1 &gt; $newDateClot2) and ($newDateClot2 &gt; $newDateClot3)">
                <xsl:call-template name ="TableauVb3Cols">
                  <xsl:with-param name ="DateClot1erCols" select ="$dateClot3"/>
                  <xsl:with-param name ="DateClot2emeCols" select ="$dateClot2"/>
                  <xsl:with-param name ="DateClot3emeCols" select ="$dateClot1"/>
                  <xsl:with-param name ="DateDuree1erCols" select ="$dateDuree3"/>
                  <xsl:with-param name ="DateDuree2emeCols" select ="$dateDuree2"/>
                  <xsl:with-param name ="DateDuree3emeCols" select ="$dateDuree1"/>
                </xsl:call-template>
                <xsl:call-template name ="RemplirTableauVb3">
                  <xsl:with-param name ="DateClot1erCols" select ="$dateClot3"/>
                  <xsl:with-param name ="DateClot2emeCols" select ="$dateClot2"/>
                  <xsl:with-param name ="DateClot3emeCols" select ="$dateClot1"/>
                  <xsl:with-param name ="TypeTableau" select ="$TypeTableau"/>
                </xsl:call-template>
              </xsl:when>
              <xsl:when test ="($newDateClot1 &gt; $newDateClot3) and ($newDateClot3 &gt; $newDateClot2)">
                <xsl:call-template name ="TableauVb3Cols">
                  <xsl:with-param name ="DateClot1erCols" select ="$dateClot2"/>
                  <xsl:with-param name ="DateClot2emeCols" select ="$dateClot3"/>
                  <xsl:with-param name ="DateClot3emeCols" select ="$dateClot1"/>
                  <xsl:with-param name ="DateDuree1erCols" select ="$dateDuree2"/>
                  <xsl:with-param name ="DateDuree2emeCols" select ="$dateDuree3"/>
                  <xsl:with-param name ="DateDuree3emeCols" select ="$dateDuree1"/>
                </xsl:call-template>
                <xsl:call-template name ="RemplirTableauVb3">
                  <xsl:with-param name ="DateClot1erCols" select ="$dateClot2"/>
                  <xsl:with-param name ="DateClot2emeCols" select ="$dateClot3"/>
                  <xsl:with-param name ="DateClot3emeCols" select ="$dateClot1"/>
                  <xsl:with-param name ="TypeTableau" select ="$TypeTableau"/>
                </xsl:call-template>
              </xsl:when>
            </xsl:choose>


          </xsl:when>
          <xsl:otherwise>
            <!-- tableau  2 colonnes-->

            <xsl:if test ="$newDateClot1 &gt; $newDateClot2">
              <xsl:call-template name ="TableauVb2Cols">
                <xsl:with-param name ="DateClot1erCols" select ="$dateClot2"/>
                <xsl:with-param name ="DateClot2emeCols" select ="$dateClot1"/>
                <xsl:with-param name ="DateDuree1erCols" select ="$dateDuree2"/>
                <xsl:with-param name ="DateDuree2emeCols" select ="$dateDuree1"/>
              </xsl:call-template>
              <xsl:call-template name ="RemplirTableauVb2">
                <xsl:with-param name ="DateClot1erCols" select ="$dateClot2"/>
                <xsl:with-param name ="DateClot2emeCols" select ="$dateClot1"/>
                <xsl:with-param name ="TypeTableau" select ="$TypeTableau"/>
              </xsl:call-template>
            </xsl:if>
            <xsl:if test ="$newDateClot2 &gt; $newDateClot1">
              <xsl:call-template name ="TableauVb2Cols">
                <xsl:with-param name ="DateClot1erCols" select ="$dateClot1"/>
                <xsl:with-param name ="DateClot2emeCols" select ="$dateClot2"/>
                <xsl:with-param name ="DateDuree1erCols" select ="$dateDuree1"/>
                <xsl:with-param name ="DateDuree2emeCols" select ="$dateDuree2"/>
              </xsl:call-template>
              <xsl:call-template name ="RemplirTableauVb2">
                <xsl:with-param name ="DateClot1erCols" select ="$dateClot1"/>
                <xsl:with-param name ="DateClot2emeCols" select ="$dateClot2"/>
                <xsl:with-param name ="TypeTableau" select ="$TypeTableau"/>
              </xsl:call-template>
            </xsl:if>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>

  </xsl:template>



  <!-- ***************************** TEMPLATE GENVB ************************************ -->

  <xsl:template name ="genVB">
    <table class="BorderCellcl Width738">
      <caption class="visually-hidden">VITRINE BILANS</caption>
      <tr>
        <td class="clCouleurGras clAlignCenter">VITRINE BILANS</td>
      </tr>
      <tr>
        <td>
          <img src="{$root}Images/risque/shim_bleu.gif" width="635" height="1" vspace="8" alt=""/>
        </td>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth635 clAlignLeft clThNonGras">&#160;Veuillez cliquer sur le module de votre choix</th>
        <td class="clWidth103 clAlignRight">
          <a href="#ancHaut">
            <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" alt="Retour en haut de la page"/>
          </a>
        </td>
      </tr>
    </table>

  </xsl:template>

  <xsl:template name ="genVBtitre">
    <xsl:param name ="titre"/>
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
        <td class="clCouleur2 clWidth285 clHeight10"></td>
      </tr>
      <tr>
        <td class="clCouleur2 clWidth285 clHeight10"></td>
      </tr>
    </table>
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
        <th class="clCouleur2 clWidth285 clHeight10 clAlignLeft clThNonGras">
          <xsl:value-of select ="$titre"/>
        </th>
      </tr>
      <tr>
        <td class="clCouleur2 clWidth285 clHeight10"></td>
      </tr>
    </table>
  </xsl:template>


  <xsl:template name ="TableauVb1Col">
    <xsl:param name ="DateClot1erCols"/>
    <xsl:param name ="DateDuree1erCols"/>

    <table class="clWidth635 clBorderCell">
      <tr class="clWidthMax">
        <th class="clCouleur2 clWidth285 clAlignLeft clThNonGras">&#160;Date de clture</th>
        <td class="clGrasFond clWidth350 clAlignCenter">
          <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="$DateClot1erCols"/>
          </xsl:call-template>
        </td>
      </tr>
      <tr class="clWidthMax">
        <th class="clCouleur2 clWidth285 clAlignLeft clThNonGras">&#160;Dure d'exercice</th>
        <th class="clTexte clWidth350 clAlignCenter clThNonGras">
          <xsl:value-of select ="$DateDuree1erCols"/>&#160;mois
        </th>
      </tr>
      <tr>
        <td class="clCouleur2 clHeight10" colspan="9"></td>
      </tr>
    </table>

  </xsl:template>

  <xsl:template name ="TableauVb2Cols">
    <xsl:param name ="DateClot1erCols"/>
    <xsl:param name ="DateClot2emeCols"/>
    <xsl:param name ="DateDuree1erCols"/>
    <xsl:param name ="DateDuree2emeCols"/>

    <table class="clWidth635 clBorderCell">
      <tr class="clWidthMax">
        <th class="clCouleur2 clWidth285 clAlignLeft clThNonGras">&#160;Date de clture</th>
        <td class="clGrasFond clWidth175 clAlignCenter">
          <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="$DateClot1erCols"/>
          </xsl:call-template>
        </td>
        <td class="clGrasFond clWidth175 clAlignCenter">
          <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="$DateClot2emeCols"/>
          </xsl:call-template>
        </td>
      </tr>
      <tr class="clWidthMax">
        <th class="clCouleur2 clWidth285 clAlignLeft clThNonGras">&#160;Dure d'exercice</th>
        <th class="clTexte clWidth175 clAlignCenter clThNonGras">
          <xsl:value-of select ="$DateDuree1erCols"/>&#160;mois
        </th>
        <th class="clTexte clWidth175 clAlignCenter clThNonGras">
          <xsl:value-of select ="$DateDuree2emeCols"/>&#160;mois
        </th>
      </tr>
      <tr>
        <td class="clCouleur2 clHeight10" colspan="9"></td>
      </tr>
    </table>

  </xsl:template>

  <xsl:template name ="TableauVb3Cols">
    <xsl:param name ="DateClot1erCols"/>
    <xsl:param name ="DateClot2emeCols"/>
    <xsl:param name ="DateClot3emeCols"/>
    <xsl:param name ="DateDuree1erCols"/>
    <xsl:param name ="DateDuree2emeCols"/>
    <xsl:param name ="DateDuree3emeCols"/>

    <table class="clWidth635 clBorderCell" role="presentation">
      <tr class="clWidthMax">
        <th class="clCouleur2 clWidth285 clAlignLeft clThNonGras">&#160;Date de clture</th>
        <td class="clGrasFond clWidth116 clAlignCenter">
          <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="$DateClot1erCols"/>
          </xsl:call-template>
        </td>
        <td class="clGrasFond clWidth116 clAlignCenter">
          <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="$DateClot2emeCols"/>
          </xsl:call-template>
        </td>
        <td class="clGrasFond clWidth116 clAlignCenter">
          <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="$DateClot3emeCols"/>
          </xsl:call-template>
        </td>
      </tr>
      <tr class="clWidthMax">
        <th class="clCouleur2 clWidth285 clAlignLeft clThNonGras">&#160;Dure d'exercice</th>
        <th class="clTexte clWidth116 clAlignCenter clThNonGras">
          <xsl:value-of select ="$DateDuree1erCols"/>&#160;mois
        </th>
        <th class="clTexte clWidth116 clAlignCenter clThNonGras">
          <xsl:value-of select ="$DateDuree2emeCols"/>&#160;mois
        </th>
        <th class="clTexte clWidth116 clAlignCenter clThNonGras">
          <xsl:value-of select ="$DateDuree3emeCols"/>&#160;mois
        </th>
      </tr>
      <tr>
        <td class="clCouleur2 clHeight10" colspan="9"></td>
      </tr>
    </table>

  </xsl:template>

  <xsl:template name ="RemplirTableauVb1">
    <xsl:param name ="DateClot1erCols"/>
    <xsl:param name ="TypeTableau"/>
    <xsl:for-each select ="/FIBEN/PERSONNE/MODULEVB/MODULE">
      <xsl:if test ="$TypeTableau = 'Social'">
        <xsl:if test ="(NUMMOD!=66) and (NUMMOD!=67)">
          <table class="clWidth635 clBorderCell" role="presentation">
            <xsl:if test="position() mod 2 = 0">
              <tr class="clWidthMax">
                <th class="clCouleur2 clWidth285 clAlignLeft clThNonGras">
                  <xsl:variable name ="NumMod" select ="NUMMOD"/>
                  <a href="#nullePart" onclick="requestBDFInfos('{NUMMOD}','','9','',false,false,this);" class="clCouleur2">
                    <u>
                      <xsl:value-of select="NUMMOD"/>
                    </u>
                  </a>
                  &#160;<xsl:value-of select="$dictionnaire/titre[@module=$NumMod]"/>
                </th>
                <td class="clTexte clWidth350 clAlignCenter">
                  <xsl:variable name ="datetest1" select ="DONMOD/@DATCLOT"/>
                  <xsl:if test ="$datetest1 = $DateClot1erCols">
                    X
                  </xsl:if>
                </td>
              </tr>
            </xsl:if>
            <xsl:if test="position() mod 2 = 1">
              <tr class="clWidthMax">
                <th class="clCouleur2 clWidth285 clAlignLeft clThNonGras">
                  <xsl:variable name ="NumMod" select ="NUMMOD"/>
                  <a href="#nullePart" onclick="requestBDFInfos('{NUMMOD}','','9','',false,false,this);" class="clCouleur2">
                    <u>
                      <xsl:value-of select="NUMMOD"/>
                    </u>
                  </a>
                  &#160;<xsl:value-of select="$dictionnaire/titre[@module=$NumMod]"/>
                </th>
                <td class="clFond clWidth350 clAlignCenter">
                  <xsl:variable name ="datetest1" select ="DONMOD/@DATCLOT"/>
                  <xsl:if test ="$datetest1 = $DateClot1erCols">
                    X
                  </xsl:if>
                </td>
              </tr>
            </xsl:if>
          </table>
        </xsl:if>
      </xsl:if>
      <xsl:if test ="$TypeTableau = 'Conso'">
        <xsl:if test ="(NUMMOD=66) or (NUMMOD=67)">
          <table class="clWidth635 clBorderCell">
            <xsl:if test="position() mod 2 = 0">
              <tr class="clWidthMax">
                <th class="clCouleur2 clWidth285 clAlignLeft clThNonGras">
                  <xsl:variable name ="NumMod" select ="NUMMOD"/>
                  <a href="#nullePart" onclick="requestBDFInfos('{NUMMOD}','','9','',false,false,this);" class="clCouleur2">
                    <u>
                      <xsl:value-of select="NUMMOD"/>
                    </u>
                  </a>
                  &#160;<xsl:value-of select="$dictionnaire/titre[@module=$NumMod]"/>
                </th>
                <td class="clTexte clWidth350 clAlignCenter">
                  <xsl:variable name ="datetest1" select ="DONMOD/@DATCLOT"/>
                  <xsl:if test ="$datetest1 = $DateClot1erCols">
                    X
                  </xsl:if>
                </td>
              </tr>
            </xsl:if>
            <xsl:if test="position() mod 2 = 1">
              <tr class="clWidthMax">
                <th class="clCouleur2 clWidth285 clAlignLeft clThNonGras">
                  <xsl:variable name ="NumMod" select ="NUMMOD"/>
                  <a href="#nullePart" onclick="requestBDFInfos('{NUMMOD}','','9','',false,false,this);" class="clCouleur2">
                    <u>
                      <xsl:value-of select="NUMMOD"/>
                    </u>
                  </a>
                  &#160;<xsl:value-of select="$dictionnaire/titre[@module=$NumMod]"/>
                </th>
                <td class="clFond clWidth350 clAlignCenter">
                  <xsl:variable name ="datetest1" select ="DONMOD/@DATCLOT"/>
                  <xsl:if test ="$datetest1 = $DateClot1erCols">
                    X
                  </xsl:if>
                </td>
              </tr>
            </xsl:if>
          </table>
        </xsl:if>
      </xsl:if>
    </xsl:for-each>
  </xsl:template>

  <xsl:template name ="RemplirTableauVb2">
    <xsl:param name ="DateClot1erCols"/>
    <xsl:param name ="DateClot2emeCols"/>
    <xsl:param name ="TypeTableau"/>
    <xsl:for-each select ="/FIBEN/PERSONNE/MODULEVB/MODULE">
      <xsl:if test ="$TypeTableau = 'Social'">
        <xsl:if test ="(NUMMOD!=66) and (NUMMOD!=67)">
          <table class="clWidth635 clBorderCell" role="presentation">
            <xsl:if test="position() mod 2 = 0">
              <tr class="clWidthMax">
                <th class="clCouleur2 clWidth285 clAlignLeft clThNonGras">
                  <xsl:variable name ="NumMod" select ="NUMMOD"/>
                  <a href="#nullePart" onclick="requestBDFInfos('{NUMMOD}','','9','',false,false,this);" class="clCouleur2">
                    <u>
                      <xsl:value-of select="NUMMOD"/>
                    </u>
                  </a>
                  &#160;<xsl:value-of select="$dictionnaire/titre[@module=$NumMod]"/>
                </th>
                <td class="clTexte clWidth175 clAlignCenter">
                  <xsl:variable name ="datetest1" select ="DONMOD/@DATCLOT"/>
                  <xsl:if test ="$datetest1 = $DateClot1erCols">
                    X
                  </xsl:if>
                </td>
                <td class="clTexte clWidth175 clAlignCenter">
                  <xsl:variable name ="datetest2" select ="DONMOD/@DATCLOT"/>
                  <xsl:if test ="$datetest2 = $DateClot2emeCols">
                    X
                  </xsl:if>
                </td>
              </tr>
            </xsl:if>
            <xsl:if test="position() mod 2 = 1">
              <tr class="clWidthMax">
                <th class="clCouleur2 clWidth285 clAlignLeft clThNonGras">
                  <xsl:variable name ="NumMod" select ="NUMMOD"/>
                  <a href="#nullePart" onclick="requestBDFInfos('{NUMMOD}','','9','',false,false,this);" class="clCouleur2">
                    <u>
                      <xsl:value-of select="NUMMOD"/>
                    </u>
                  </a>
                  &#160;<xsl:value-of select="$dictionnaire/titre[@module=$NumMod]"/>
                </th>
                <td class="clFond clWidth175 clAlignCenter">
                  <xsl:variable name ="datetest1" select ="DONMOD/@DATCLOT"/>
                  <xsl:if test ="$datetest1 = $DateClot1erCols">
                    X
                  </xsl:if>
                </td>
                <td class="clFond clWidth175 clAlignCenter">
                  <xsl:variable name ="datetest2" select ="DONMOD/@DATCLOT"/>
                  <xsl:if test ="$datetest2 = $DateClot2emeCols">
                    X
                  </xsl:if>
                </td>
              </tr>
            </xsl:if>
          </table>
        </xsl:if>
      </xsl:if>
      <xsl:if test ="$TypeTableau = 'Conso'">
        <xsl:if test ="(NUMMOD=66) or (NUMMOD=67)">
          <table class="clWidth635 clBorderCell" role="presentation">
            <xsl:if test="position() mod 2 = 0">
              <tr class="clWidthMax">
                <th class="clCouleur2 clWidth285 clAlignLeft clThNonGras">
                  <xsl:variable name ="NumMod" select ="NUMMOD"/>
                  <a href="#nullePart" onclick="requestBDFInfos('{NUMMOD}','','9','',false,false,this);" class="clCouleur2">
                    <u>
                      <xsl:value-of select="NUMMOD"/>
                    </u>
                  </a>
                  &#160;<xsl:value-of select="$dictionnaire/titre[@module=$NumMod]"/>
                </th>
                <td class="clTexte clWidth175 clAlignCenter">
                  <xsl:variable name ="datetest1" select ="DONMOD/@DATCLOT"/>
                  <xsl:if test ="$datetest1 = $DateClot1erCols">
                    X
                  </xsl:if>
                </td>
                <td class="clTexte clWidth175 clAlignCenter">
                  <xsl:variable name ="datetest2" select ="DONMOD/@DATCLOT"/>
                  <xsl:if test ="$datetest2 = $DateClot2emeCols">
                    X
                  </xsl:if>
                </td>
              </tr>
            </xsl:if>
            <xsl:if test="position() mod 2 = 1">
              <tr class="clWidthMax">
                <th class="clCouleur2 clWidth285 clAlignLeft clThNonGras">
                  <xsl:variable name ="NumMod" select ="NUMMOD"/>
                  <a href="#nullePart" onclick="requestBDFInfos('{NUMMOD}','','9','',false,false,this);" class="clCouleur2">
                    <u>
                      <xsl:value-of select="NUMMOD"/>
                    </u>
                  </a>
                  &#160;<xsl:value-of select="$dictionnaire/titre[@module=$NumMod]"/>
                </th>
                <td class="clFond clWidth175 clAlignCenter">
                  <xsl:variable name ="datetest1" select ="DONMOD/@DATCLOT"/>
                  <xsl:if test ="$datetest1 = $DateClot1erCols">
                    X
                  </xsl:if>
                </td>
                <td class="clFond clWidth175 clAlignCenter">
                  <xsl:variable name ="datetest2" select ="DONMOD/@DATCLOT"/>
                  <xsl:if test ="$datetest2 = $DateClot2emeCols">
                    X
                  </xsl:if>
                </td>
              </tr>
            </xsl:if>
          </table>
        </xsl:if>
      </xsl:if>
    </xsl:for-each>
  </xsl:template>

  <xsl:template name ="RemplirTableauVb3">
    <xsl:param name ="DateClot1erCols"/>
    <xsl:param name ="DateClot2emeCols"/>
    <xsl:param name ="DateClot3emeCols"/>
    <xsl:param name ="TypeTableau"/>
    <xsl:for-each select ="/FIBEN/PERSONNE/MODULEVB/MODULE">
      <xsl:if test ="$TypeTableau = 'Social'">
        <xsl:if test ="(NUMMOD!=66) and (NUMMOD!=67)">
          <table class="clWidth635 clBorderCell" role="presentation">
            <xsl:if test="position() mod 2 = 0">
              <tr class="clWidthMax">
                <th class="clCouleur2 clWidth285 clAlignLeft clThNonGras">
                  <xsl:variable name ="NumMod" select ="NUMMOD"/>
                  <a href="#nullePart" onclick="requestBDFInfos('{NUMMOD}','','9','',false,false,this);" class="clCouleur2">
                    <u>
                      <xsl:value-of select="NUMMOD"/>
                    </u>
                  </a>
                  &#160;<xsl:value-of select="$dictionnaire/titre[@module=$NumMod]"/>
                </th>
                <td class="clTexte clWidth116 clAlignCenter">
                  <xsl:variable name ="datetest1" select ="DONMOD/@DATCLOT"/>
                  <xsl:if test ="$datetest1 = $DateClot1erCols">
                    X
                  </xsl:if>
                </td>
                <td class="clTexte clWidth116 clAlignCenter">
                  <xsl:variable name ="datetest2" select ="DONMOD/@DATCLOT"/>
                  <xsl:if test ="$datetest2 = $DateClot2emeCols">
                    X
                  </xsl:if>
                </td>
                <td class="clTexte clWidth116 clAlignCenter">
                  <xsl:variable name ="datetest3" select ="DONMOD/@DATCLOT"/>
                  <xsl:if test ="$datetest3 = $DateClot3emeCols">
                    X
                  </xsl:if>
                </td>
              </tr>
            </xsl:if>
            <xsl:if test="position() mod 2 = 1">
              <tr class="clWidthMax">
                <th class="clCouleur2 clWidth285 clAlignLeft clThNonGras">
                  <xsl:variable name ="NumMod" select ="NUMMOD"/>
                  <a href="#nullePart" onclick="requestBDFInfos('{NUMMOD}','','9','',false,false,this);" class="clCouleur2">
                    <u>
                      <xsl:value-of select="NUMMOD"/>
                    </u>
                  </a>
                  &#160;<xsl:value-of select="$dictionnaire/titre[@module=$NumMod]"/>
                </th>
                <td class="clFond clWidth116 clAlignCenter">
                  <xsl:variable name ="datetest1" select ="DONMOD/@DATCLOT"/>
                  <xsl:if test ="$datetest1 = $DateClot1erCols">
                    X
                  </xsl:if>
                </td>
                <td class="clFond clWidth116 clAlignCenter">
                  <xsl:variable name ="datetest2" select ="DONMOD/@DATCLOT"/>
                  <xsl:if test ="$datetest2 = $DateClot2emeCols">
                    X
                  </xsl:if>
                </td>
                <td class="clFond clWidth116 clAlignCenter">
                  <xsl:variable name ="datetest3" select ="DONMOD/@DATCLOT"/>
                  <xsl:if test ="$datetest3 = $DateClot3emeCols">
                    X
                  </xsl:if>
                </td>
              </tr>
            </xsl:if>
          </table>
        </xsl:if>
      </xsl:if >
      <xsl:if test ="$TypeTableau = 'Conso'">
        <xsl:if test ="(NUMMOD=66) or (NUMMOD=67)">
          <table class="clWidth635 clBorderCell" role="presentation">
            <xsl:if test="position() mod 2 = 0">
              <tr class="clWidthMax">
                <th class="clCouleur2 clWidth285 clAlignLeft clThNonGras">
                  <xsl:variable name ="NumMod" select ="NUMMOD"/>
                  <a href="#nullePart" onclick="requestBDFInfos('{NUMMOD}','','9','',false,false,this);" class="clCouleur2">
                    <u>
                      <xsl:value-of select="NUMMOD"/>
                    </u>
                  </a>
                  &#160;<xsl:value-of select="$dictionnaire/titre[@module=$NumMod]"/>
                </th>
                <td class="clTexte clWidth116 clAlignCenter">
                  <xsl:variable name ="datetest1" select ="DONMOD/@DATCLOT"/>
                  <xsl:if test ="$datetest1 = $DateClot1erCols">
                    X
                  </xsl:if>
                </td>
                <td class="clTexte clWidth116 clAlignCenter">
                  <xsl:variable name ="datetest2" select ="DONMOD/@DATCLOT"/>
                  <xsl:if test ="$datetest2 = $DateClot2emeCols">
                    X
                  </xsl:if>
                </td>
                <td class="clTexte clWidth116 clAlignCenter">
                  <xsl:variable name ="datetest3" select ="DONMOD/@DATCLOT"/>
                  <xsl:if test ="$datetest3 = $DateClot3emeCols">
                    X
                  </xsl:if>
                </td>
              </tr>
            </xsl:if>
            <xsl:if test="position() mod 2 = 1">
              <tr class="clWidthMax">
                <th class="clCouleur2 clWidth285 clAlignLeft clThNonGras">
                  <xsl:variable name ="NumMod" select ="NUMMOD"/>
                  <a href="#nullePart" onclick="requestBDFInfos('{NUMMOD}','','9','',false,false,this);" class="clCouleur2">
                    <u>
                      <xsl:value-of select="NUMMOD"/>
                    </u>
                  </a>
                  &#160;<xsl:value-of select="$dictionnaire/titre[@module=$NumMod]"/>
                </th>
                <td class="clFond clWidth116 clAlignCenter">
                  <xsl:variable name ="datetest1" select ="DONMOD/@DATCLOT"/>
                  <xsl:if test ="$datetest1 = $DateClot1erCols">
                    X
                  </xsl:if>
                </td>
                <td class="clFond clWidth116 clAlignCenter">
                  <xsl:variable name ="datetest2" select ="DONMOD/@DATCLOT"/>
                  <xsl:if test ="$datetest2 = $DateClot2emeCols">
                    X
                  </xsl:if>
                </td>
                <td class="clFond clWidth116 clAlignCenter">
                  <xsl:variable name ="datetest3" select ="DONMOD/@DATCLOT"/>
                  <xsl:if test ="$datetest3 = $DateClot3emeCols">
                    X
                  </xsl:if>
                </td>
              </tr>
            </xsl:if>
          </table>
        </xsl:if>
      </xsl:if >
    </xsl:for-each>
  </xsl:template>

  <!-- ************************************************************************************************************************************** -->

  <xsl:template match="IST17" mode="genLib">
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr class="clAlignLeft">
        <td class="clCouleur2">
          <xsl:apply-templates select="."/>
          <br/>
        </td>
      </tr>
    </table>
  </xsl:template>

</xsl:stylesheet>
