﻿Imports System.IO
Imports System.Xml
Imports BDF.POBI.Commun.Exceptions
Imports BDF.POBI.FIBEN.BAL
Imports BDF.POBI.FIBEN.BAL.Manager
Imports BDF.POBI.FIBEN.Web.Commun

Partial Class modules_module
    Inherits System.Web.UI.Page

    Private ReadOnly oXMLResponse As New XmlDocument
    Private _oFonctionModule As FctsModule
    Private ReadOnly _fonction As Outils.Fcts = New Outils.Fcts(HttpContext.Current)

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs) Handles Me.Load

        Response.CacheControl = "no-cache"
        Response.AddHeader("Pragma", "no-cache")
        Response.ExpiresAbsolute = DateTime.Now.Date
        Response.Expires = -1

        ' Définition des variables
        Dim bIsAutomate As Boolean
        Dim oServRalph As serviceRalph2
        Dim xmlReponseRalph As New XmlDocument

        'vidage des variables de session
        Session("RequestTransaction") = String.Empty
        Session("oFctsModule") = Nothing

        Dim paramIdp = New ParamIdpManager(Context)

        ' Vérification de l'état de l'application (ouverte, fermée)
        If (paramIdp.IsApplicationClosed()) Then

            If Request.QueryString("IsAutomate") = "1" Then
                Response.ContentType = "text/xml"
                Response.Write(paramIdp.GetXmlResponseWhenClosed())
                Session.Abandon()
                HttpContext.Current.ApplicationInstance.CompleteRequest()
                'exit sub pour arreter la suite du code, pas d'appel mvs , pas d'erreur his 102...!!!
                Return
            Else
                Session("sMessage") = paramIdp.GetMessageClosed()
                Session("sMessageGB") = paramIdp.GetMessageClosedGB()
                Server.Transfer(CStr(Application("sRoot")) & "fermeture.aspx")
            End If
        End If

        ' Déclaration de l'objet oXMLData = nouvelle instance de la classe XMLData du context    
        _oFonctionModule = New FctsModule(Context)

        ' Test pour savoir s'il s'agit d'un automate    
        If Request.QueryString("IsAutomate") = "1" Then
            bIsAutomate = True
            _oFonctionModule.oXMLData.VERSION = _oFonctionModule.sCheckVersion(Request.QueryString("Version"))
            If String.IsNullOrEmpty(_oFonctionModule.oXMLData.VERSION) Then
                _oFonctionModule.oXMLData.VERSION = FibenEnvironment.XslTransformStyleSheetVersion
            End If
            _oFonctionModule.oXMLData.TYININ = "X"
        Else
            'Ce n'est pas un automate donc mise a la valeur H(html) de TYININ (type d'interogation)
            bIsAutomate = False
            _oFonctionModule.oXMLData.TYININ = "H"
        End If

        ' On teste la présence du code banque et/ou guichet pour configuration concentrateur
        If Request.QueryString("CdBanque") <> "" Then
            _oFonctionModule.oXMLData.IDGUD1 = _oFonctionModule.sCheckBankOffice(Request.QueryString("CdBanque"), 2)
            If (Request.QueryString("CdGuichet") = "" AndAlso _oFonctionModule.oXMLData.IDGUD1 <> "") Then
                _oFonctionModule.oXMLData.CODE_ERROR = "U04R"
            End If
        End If

        If Request.QueryString("CdGuichet") <> "" Then
            _oFonctionModule.oXMLData.IDGUD2 = _oFonctionModule.sCheckBankOffice(Request.QueryString("CdGuichet"), 1)
        End If

        ' Test pour valider le numéro du module demandé
        _oFonctionModule.oXMLData.XCOMOD = _oFonctionModule.sCheckModuleNumber(UCase(Request.QueryString("Mod")))

        If Not String.IsNullOrEmpty(Request.QueryString("RefClient")) Then
            _oFonctionModule.oXMLData.REFINT = Context.Server.HtmlEncode(Request.QueryString("RefClient"))
        End If

        If bIsAutomate Then
            _oFonctionModule.oXMLData.REFINT = Left(_oFonctionModule.oXMLData.REFINT, 50)
        Else
            _oFonctionModule.oXMLData.REFINT = Left(_oFonctionModule.oXMLData.REFINT, 20)
        End If

        ' Si la requête est correcte et en fonction du module demandé construction de la zone ZBA500
        If _oFonctionModule.oXMLData.CODE_ERROR = "" Then
            If _fonction.isModuleSuivi(_oFonctionModule.oXMLData.XCOMOD) Then
                CaseModulesAlertesSuivis()
            Else
                CasModulesStandards()
            End If
        Else
            _oFonctionModule.oXMLData.ZBA500 = UCase(Request.QueryString("Id"))
        End If

        ' on déclenche la transaction Module 
        Dim sRequestTransaction As String
        Dim SAS = New TraitementSAS(_oFonctionModule)

        'test pour traitement specifique transactions SAS
        If _fonction.isModuleSuivi(_oFonctionModule.oXMLData.XCOMOD) AndAlso Not bIsAutomate Then
            sRequestTransaction = SAS.RequestTransaction
        Else
            sRequestTransaction = _oFonctionModule.oXMLData.RequestTransaction()
        End If

        If sRequestTransaction = String.Empty Then
            Return
        End If

        'pour clients HTML cas des modules SAS de suivi qui ont leur propre page aspx 
        If Not bIsAutomate Then
            If (_oFonctionModule.oXMLData.XCOMOD = "A3" OrElse _oFonctionModule.oXMLData.XCOMOD = "S2") Then
                SAS.Redirection(sRequestTransaction)
                Return
            End If
            If (_oFonctionModule.oXMLData.XCOMOD = "S6") OrElse (_oFonctionModule.oXMLData.XCOMOD = "S7") Then
                SAS.Redirection(sRequestTransaction)
                Return
            End If
        End If

        'nouveau ralph, si tout est ok coté trace mvs du module 07 on appelle le nouveau ralph pour la reponse
        If Left(_oFonctionModule.oXMLData.XCOMOD, 2) = "07" Then
            Try
                xmlReponseRalph.LoadXml(sRequestTransaction)
                
                'garder info trace mvs
                oServRalph = New serviceRalph2(Context) With {
                    .datjour = xmlReponseRalph.SelectSingleNode("FIBEN/@DATJOUR").InnerText,
                    .moddem = xmlReponseRalph.SelectSingleNode("FIBEN/@MODDEM").InnerText
                }
                'appeler nouveau ralph
                sRequestTransaction = oServRalph.AppelServiceRalph2(_oFonctionModule)

            Catch ex As RalphException
                Dim err = New Erreur(Of modules_module)
                err.CatchError(TypeErreur.Ralph2, "Erreur technique sur le module de recherche alphabétique", ex)
                Return
            Catch ex As BusinessRuleException
                Dim err = New Erreur(Of modules_module)
                err.CatchError(TypeErreur.AppelTransactionModules, "Erreur technique sur le module de recherche alphabétique", ex)
                Return
            Catch ex As Exception
                Dim err = New Erreur(Of modules_module)
                err.CatchError(TypeErreur.Applicatif, "Erreur technique sur le module de recherche alphabétique", ex)
                Return
            End Try
        End If

        Try
            Using sr = New StringReader(sRequestTransaction)
                Using oXmlTextReader = New XmlTextReader(sr)
                    oXMLResponse.Load(oXmlTextReader)
                    _oFonctionModule.CheckUnBilledTags(oXMLResponse, _oFonctionModule.oXMLData.XCOMOD)
                End Using
            End Using

        Catch ex As XmlException
            Dim err = New Erreur(Of modules_module)
            err.CatchError(TypeErreur.ParsingXml, $"Erreur technique sur le module demandé : {_oFonctionModule.oXMLData.XCOMOD}", ex)
            Return
        Catch ex As Exception
            Dim err = New Erreur(Of modules_module)
            err.CatchError(TypeErreur.Applicatif, $"Erreur technique sur le module demandé : {_oFonctionModule.oXMLData.XCOMOD}", ex)
            Return
        End Try

        ' Mise à jour de la liste des consultations en attente, de l'historique ou de la rech alpha
        'pour info ISBILLED sinifie que les module sont payant
        If _oFonctionModule.oXMLData.ISBILLED Then
            Select Case Left(_oFonctionModule.oXMLData.XCOMOD, 1)
                Case "0"
                    Session("sLastAlphaSearch") = _oFonctionModule.oXMLData.ZBA500
                    Session("oLastRalph2Search") = _oFonctionModule.demRalph
                Case "1", "A", "S", "P"
                    'modules exclus de l'historique sauf module AN, SC ? et 18
                    If (_oFonctionModule.oXMLData.XCOMOD = "AN") OrElse (_oFonctionModule.oXMLData.XCOMOD = "SC") OrElse (_oFonctionModule.oXMLData.XCOMOD = "18") Then
                        _oFonctionModule.UpdateHistory(_oFonctionModule.oXMLData.ZBA500, _oFonctionModule.oXMLData.XCOMOD, String.Empty)
                    End If
                Case Else
                    _oFonctionModule.UpdateHistory(_oFonctionModule.oXMLData.ZBA500, _oFonctionModule.oXMLData.XCOMOD, String.Empty)
            End Select
        End If
        _oFonctionModule.UpdateMultiConsult(_oFonctionModule.oXMLData.ZBA500, _oFonctionModule.oXMLData.XCOMOD, String.Empty)

        Dim sAppend = New StringBuilder()

        ' on transforme au cas où
        If bIsAutomate Then

            Response.ContentType = "text/xml"
            sAppend.Remove(0, sAppend.Length)
            sAppend.Append("<?xml version=""1.0"" encoding=""ISO-8859-1""?>")
            sAppend.Append(Mid(oXMLResponse.InnerXml, InStr(1, oXMLResponse.InnerXml, "?>") + 2))
            Response.Write(sAppend.ToString)
        Else
            sAppend.Remove(0, sAppend.Length)
            sAppend.Append("<?xml version=""1.0"" encoding=""ISO-8859-1""?>")
            sAppend.Append(Mid(oXMLResponse.InnerXml, InStr(1, oXMLResponse.InnerXml, "?>") + 2))
            Try
                oXMLResponse.LoadXml(sAppend.ToString)
                _oFonctionModule.TransformXML(oXMLResponse, _oFonctionModule.oXMLData.XCOMOD)
            Catch ex As XmlException
                Dim err = New Erreur(Of modules_module)
                err.CatchError(TypeErreur.ParsingXml, $"Erreur de parsing sur lors de l'affichage du module demandé : {_oFonctionModule.oXMLData.XCOMOD}", ex)
                Return
            Catch ex As Exception
                Dim err = New Erreur(Of modules_module)
                err.CatchError(TypeErreur.Applicatif, $"Erreur technique sur lors de l'affichage du module demandé : {_oFonctionModule.oXMLData.XCOMOD}", ex)
                Return
            End Try
        End If

        Try
            Dim nodeDateJour As XmlNode = oXMLResponse.SelectSingleNode("//FIBEN/@DATJOUR")
            If nodeDateJour IsNot Nothing Then
                _oFonctionModule.oXMLData.ValidTicket(nodeDateJour.InnerText)
            Else
                Dim err = New Erreur(Of modules_module)
                err.CatchError(TypeErreur.AppelProcedureTicket, "La transaction du Ticket n'a pas été réalisé date du jour manquante", NameOf(Page_Load))
            End If

        Catch ex As MvsException
            Dim err = New Erreur(Of modules_module)
            err.CatchError(TypeErreur.Applicatif, "Erreur MVS sur La transaction du Ticket", ex)
        Catch ex As Exception
            Dim err = New Erreur(Of modules_module)
            err.CatchError(TypeErreur.Applicatif, "Erreur technique sur La transaction du Ticket", ex)
        End Try
    End Sub

    ''' <summary>
    ''' a partir de la query string recupere les criteres pour la demande ralph
    ''' supprime les eventuels caractères joker qui seraient en 1ere positition des champs texte
    ''' </summary>'
    ''' <returns></returns>
    ''' <remarks></remarks>
    Private Function ConstruitCriteresDemandeRalph() As CritereDemandeRalph
        Dim rep As CritereDemandeRalph = New CritereDemandeRalph
        rep.Denom = UCase(Replace(Request.QueryString("Denom"), "***", "&"))
        rep.Denom = verifieCaractereJoker(rep.Denom)

        rep.ChoixDenom = UCase(Request.QueryString("ChoixDenom"))
        If String.IsNullOrEmpty(rep.ChoixDenom) Then
            rep.ChoixDenom = "NSE"
        End If
        rep.coac = UCase(Request.QueryString("coac"))
        rep.coac = verifieCaractereJoker(rep.coac)

        rep.rue = (UCase(Replace(Request.QueryString("rue"), "***", "&")))
        rep.rue = verifieCaractereJoker(rep.rue)

        rep.pays = UCase(Request.QueryString("pays"))
        rep.CodePost = UCase(Request.QueryString("CodePost"))
        rep.CodePost = verifieCaractereJoker(rep.CodePost)
        rep.ent = UCase(Request.QueryString("ent"))
        If UCase(Request.QueryString("Siege")) = "O" Then
            rep.Siege = True
        Else
            rep.Siege = False
        End If
        rep.ua = UCase(Request.QueryString("ua"))
        rep.ua = verifieCaractereJoker(rep.ua)
        rep.ville = (UCase(Request.QueryString("ville")))
        rep.ville = verifieCaractereJoker(rep.ville)

        If UCase(Request.QueryString("RechEt")) = "O" Then
            rep.RechEt = True
        Else
            rep.RechEt = False
        End If
        rep.Type = UCase(Request.QueryString("Type"))
        rep.TypeNOT = UCase(Request.QueryString("TypeNOT"))
        Return rep

    End Function

    ''' <summary>
    ''' ignore l'utilisation des caractères joker en 1er position
    ''' </summary>
    ''' <param name="s"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Private Function verifieCaractereJoker(ByVal s As String) As String
        Dim critere As String = s
        While ((Left(critere, 1) = "*") OrElse Left(critere, 1) = "?")
            critere = Right(critere, Len(critere) - 1)
        End While
        Return critere
    End Function
  
    ''' <summary>
    ''' traitement specifiques aux modules non modules de suivis
    ''' attention module SC fait partie de cette fonction et n'est pas considéré comme module de suivi
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub CasModulesStandards()

        Select Case Left(_oFonctionModule.oXMLData.XCOMOD, 1)

            Case "0"
                'ajout nouveau ralph
                _oFonctionModule.demRalph = ConstruitCriteresDemandeRalph()
                _oFonctionModule.oXMLData.ZBA500 = UCase(Request.QueryString("Denom")) & ";" & UCase(Request.QueryString("CodePost")) & ";"

                If (Request.QueryString("ssClasse") = "") Then
                    _oFonctionModule.oXMLData.ZBA500 = _oFonctionModule.oXMLData.ZBA500 & UCase(Request.QueryString("Division")) & ";"
                Else
                    _oFonctionModule.oXMLData.ZBA500 = _oFonctionModule.oXMLData.ZBA500 & UCase(Request.QueryString("ssClasse")) & ";"
                End If

                _oFonctionModule.oXMLData.ZBA500 = _oFonctionModule.oXMLData.ZBA500 & UCase(Request.QueryString("Type")) & ";"
                If Request.QueryString("RechEt") = "" Then
                    _oFonctionModule.oXMLData.ZBA500 = _oFonctionModule.oXMLData.ZBA500 & "O;"
                Else
                    _oFonctionModule.oXMLData.ZBA500 = _oFonctionModule.oXMLData.ZBA500 & Request.QueryString("RechEt") & ";"
                End If

                If Session("sLastAlphaSearch") = _oFonctionModule.oXMLData.ZBA500 Then
                    _oFonctionModule.oXMLData.BACK = 1
                End If

            Case "S"
                _oFonctionModule.oXMLData.ZBA500 = ""

            Case Else
                _oFonctionModule.oXMLData.ZBA500 = UCase(Request.QueryString("Id"))
                _oFonctionModule.CheckModuleIsValid4Id(_oFonctionModule.oXMLData.ZBA500, _oFonctionModule.oXMLData.XCOMOD)

                If InStr(Session("sHistory"), "(" & _oFonctionModule.oXMLData.ZBA500 & "|" & _oFonctionModule.oXMLData.XCOMOD) > 0 Then
                    _oFonctionModule.oXMLData.BACK = 1
                End If

                If _oFonctionModule.oXMLData.XCOMOD = "14" Then

                    Dim tCoban As ArrayList = Session("tCoban")
                    Dim tCoban2 As ArrayList = Session("tCobanC")

                    If tCoban Is Nothing AndAlso tCoban2 Is Nothing Then
                        _oFonctionModule.oXMLData.CODE_ERROR = "U059"
                    Else 
                        Dim nbCoban As Integer = IIf(tCoban Is Nothing, 0, tCoban.Count) 
                        nbCoban += IIf(tCoban2 Is Nothing, 0, tCoban2.Count) 
                    
                        If nbCoban = 0 Then
                            _oFonctionModule.oXMLData.CODE_ERROR = "U058"
                        Else    
                            _oFonctionModule.oXMLData.ZBA500 = Request.QueryString("Id") & ";"
                            _oFonctionModule.oXMLData.ZBA500 = _oFonctionModule.oXMLData.ZBA500 & Context.Server.HtmlEncode(Request.QueryString("Cib")) & ";"
                            _oFonctionModule.oXMLData.ZBA500 = _oFonctionModule.oXMLData.ZBA500 & Context.Server.HtmlEncode(Request.QueryString("Cogui")) & ";"
                        End If
                    End If
                End If
        End Select
    End Sub

    ''' <summary>
    ''' traitement specifiques aux modules d'alertes et de suivis
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub CaseModulesAlertesSuivis()

        _oFonctionModule.oXMLData.ZBA500 = String.Empty

        Select Case _oFonctionModule.oXMLData.XCOMOD
            Case "A1", "S1" 'cas ou la zba500 est vide : nb d'alertes ou de suivis positionnes
                _oFonctionModule.oXMLData.ZBA500 = String.Empty
            Case "A3" 'gestion des alertes
                If String.IsNullOrEmpty(Context.Request.QueryString("email")) Then
                    _oFonctionModule.oXMLData.ZBA500 = String.Empty
                Else
                    _oFonctionModule.oXMLData.ZBA500 = Trim(Context.Request.QueryString("email"))
                End If

            Case "A2" 'positionner une alerte
                'limiter les id à 10 
                If _oFonctionModule.VerifBAL(Request.QueryString("BAL")) Then

                    'If _oFonctionModule.VerifBAL(Request.QueryString("BAL")) Then
                    _oFonctionModule.oXMLData.ZBA500 = _oFonctionModule.oXMLData.ZBA500 & Trim(Request.QueryString("BAL")) & ";"
                    _oFonctionModule.oXMLData.ZBA500 = _oFonctionModule.oXMLData.ZBA500 & UCase(limiteEtcompleteStringId(Request.QueryString("Id"), 10)) & ";"
                Else
                    _oFonctionModule.oXMLData.ZBA500 = Request.QueryString("BAL")
                    _oFonctionModule.oXMLData.CODE_ERROR = "SAS1"
                End If

            Case "A4" 'transfert alertes vers nouvelle adresse mail
                If _oFonctionModule.VerifBAL(Request.QueryString("NewBAL")) AndAlso (_oFonctionModule.VerifBAL(Request.QueryString("OldBAL"))) Then
                    _oFonctionModule.oXMLData.ZBA500 = _oFonctionModule.oXMLData.ZBA500 & Request.QueryString("OldBAL") & ";"
                    _oFonctionModule.oXMLData.ZBA500 = _oFonctionModule.oXMLData.ZBA500 & Request.QueryString("NewBAL") & ";"
                Else
                    If Not _oFonctionModule.VerifBAL(Request.QueryString("OldBAL")) Then
                        _oFonctionModule.oXMLData.ZBA500 = Trim(Request.QueryString("OldBAL")) & " "
                    ElseIf Not _oFonctionModule.VerifBAL(Request.QueryString("NewBAL")) Then
                        'on fait un ELSEIF car le code SAS1 est utilisé que pour une adresse mail.
                        _oFonctionModule.oXMLData.ZBA500 = Trim(Request.QueryString("NewBAL"))
                    End If
                    _oFonctionModule.oXMLData.CODE_ERROR = "SAS1"
                End If

            Case "A5" 'supprimer une BAL
                If _oFonctionModule.VerifBAL(Request.QueryString("BAL")) Then
                    _oFonctionModule.oXMLData.ZBA500 = _oFonctionModule.oXMLData.ZBA500 & Request.QueryString("BAL") & ";"
                Else
                    _oFonctionModule.oXMLData.ZBA500 = Request.QueryString("BAL")
                    _oFonctionModule.oXMLData.CODE_ERROR = "SAS1"
                End If

            Case "A6" 'supprimer des id sous alerte
                If _oFonctionModule.VerifBAL(Request.QueryString("BAL")) Then
                    _oFonctionModule.oXMLData.ZBA500 = _oFonctionModule.oXMLData.ZBA500 & Request.QueryString("BAL") & ";"
                    _oFonctionModule.oXMLData.ZBA500 = _oFonctionModule.oXMLData.ZBA500 & UCase(limiteEtcompleteStringId(Request.QueryString("Id"), 10)) & ";"
                Else
                    _oFonctionModule.oXMLData.ZBA500 = Request.QueryString("BAL")
                    _oFonctionModule.oXMLData.CODE_ERROR = "SAS1"
                End If

            Case "S2", "S4" 'par défaut tri par identifiant 'S2 liste des suivis postionnes, S4 liste des mouvements suivis
                If String.IsNullOrEmpty(Request.QueryString("Tri")) Then
                    _oFonctionModule.oXMLData.ZBA500 = _oFonctionModule.oXMLData.ZBA500 & "ID;"
                Else
                    _oFonctionModule.oXMLData.ZBA500 = _oFonctionModule.oXMLData.ZBA500 & Request.QueryString("Tri") & ";"
                End If

            Case "S3" 'gestion des suivis (modif, suppr)
                'attention querystring limitée à 1 info
                _oFonctionModule.oXMLData.ZBA500 = _oFonctionModule.oXMLData.ZBA500 & UCase(Request.QueryString("Id")) & ";"
                _oFonctionModule.oXMLData.ZBA500 = _oFonctionModule.oXMLData.ZBA500 & UCase(Request.QueryString("REF")) & ";"
                _oFonctionModule.oXMLData.ZBA500 = _oFonctionModule.oXMLData.ZBA500 & UCase(Request.QueryString("MM")) & ";"
                _oFonctionModule.oXMLData.ZBA500 = _oFonctionModule.oXMLData.ZBA500 & UCase(Request.QueryString("action")) & ";"
                _oFonctionModule.oXMLData.ZBA500 = _oFonctionModule.oXMLData.ZBA500 & Request.QueryString("date") & ";"
                'verifier que l'id est ok sinon erreur
                _oFonctionModule.verifId(UCase(Request.QueryString("Id")))
                'verifier que la date ok si non vide
                If Not String.IsNullOrEmpty(Request.QueryString("date")) Then
                    _oFonctionModule.VerifDate(Request.QueryString("date"), True)
                End If
                'verifier si ref client ok
                If Not _oFonctionModule.verifRefSuivi(Request.QueryString("REF")) Then
                    _oFonctionModule.oXMLData.CODE_ERROR = "U052"
                End If

            Case "S6" 'consultation mails pour suivis
                _oFonctionModule.oXMLData.ZBA500 = String.Empty

            Case "S7" 'gestion mails pour suivis - attention différent inet2 pour verif BAL
                For i As Integer = 1 To 3
                    Dim b As String = "bal" & i.ToString

                    If Not String.IsNullOrEmpty(Request.QueryString(b)) Then
                        Dim mail As String = Request.QueryString(b).Replace(";", "")
                        If _oFonctionModule.VerifBAL(mail) Then
                            _oFonctionModule.oXMLData.ZBA500 = _oFonctionModule.oXMLData.ZBA500 & mail & ";"
                        Else
                            _oFonctionModule.oXMLData.ZBA500 = mail
                            _oFonctionModule.oXMLData.CODE_ERROR = "SAS1"
                            Exit For
                        End If
                    Else
                        _oFonctionModule.oXMLData.ZBA500 = _oFonctionModule.oXMLData.ZBA500 & ";"
                    End If
                Next

            Case "S5" 'détail d'un mouvement suivis
                'attention querystring limitée à 1 info, pour les clients HTML prevoir variable session pour toutes infos
                _oFonctionModule.oXMLData.ZBA500 = _oFonctionModule.oXMLData.ZBA500 & UCase(limiteEtcompleteStringId(Request.QueryString("Id"), 1))
                _oFonctionModule.oXMLData.ZBA500 = _oFonctionModule.oXMLData.ZBA500 & UCase(Request.QueryString("PK")) & ";"
                _oFonctionModule.oXMLData.ZBA500 = _oFonctionModule.oXMLData.ZBA500 & UCase(Request.QueryString("MM")) & ";"
                _oFonctionModule.oXMLData.ZBA500 = _oFonctionModule.oXMLData.ZBA500 & Request.QueryString("date") & ";"
                'verifier date qui est obligatoire
                _oFonctionModule.VerifDateComplete(Request.QueryString("date"))
                'verifier que l'id est ok sinon erreur
                _oFonctionModule.CheckModuleIsValid4Id(UCase(Request.QueryString("Id")), UCase(Request.QueryString("MM")))

            Case Else  'le case else est pour les transactions correspondant à un micro module ou un package (AD|AC|AJ|AS|AB|AR|AI|AK|AX|AM|AP|AG|AE|AF|PA|PB|PK|PM|PP|PG)
                'verifier la date
                If String.IsNullOrEmpty(Request.QueryString("date")) Then
                    _oFonctionModule.oXMLData.ZBA500 = _oFonctionModule.oXMLData.ZBA500 & "129999;"
                Else
                    _oFonctionModule.VerifDate(Request.QueryString("date"), True)
                    _oFonctionModule.oXMLData.ZBA500 = _oFonctionModule.oXMLData.ZBA500 & Request.QueryString("date") & ";"
                End If
                'Verif caractères dans la zone référence
                If _oFonctionModule.verifRefSuiviSX(Request.QueryString("id").ToUpper) Then
                    _oFonctionModule.oXMLData.ZBA500 = _oFonctionModule.oXMLData.ZBA500 & UCase(limiteEtcompleteStringId(Request.QueryString("Id"), 10))
                Else
                    _oFonctionModule.oXMLData.CODE_ERROR = "U052"
                End If
        End Select
    End Sub
    ''' <summary>
    ''' fonction qui limite a nbId occurences les id et/ou références client
    ''' et qui complete jusqu'a nbId occurences par des id et/ou  reférences client vides par ajout des ; qui sont les séparateurs attendus dans la zba500 
    ''' </summary>
    ''' <param name="sId"></param>
    ''' <param name="nbId"></param>
    ''' <returns></returns>
    Private Function limiteEtcompleteStringId(ByVal sId As String, ByVal nbId As Integer) As String
        'les id sont aussi bien les identifiants que la zone de référence
        Dim rep As String = String.Empty
        Dim idArray As String() = Split(sId, ";")

        For i = 0 To nbId - 1
            If idArray.GetUpperBound(0) >= i Then
                rep = rep & idArray(i) & ";"
            Else
                rep = rep & ";"
            End If
        Next

        Return rep
    End Function
End Class
