<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"  xmlns:bdf="http://banque-france.fr/namespace">
  <xsl:import href="../../Ressources/XSL/Commun.xsl"/>
  <xsl:import href="../../Ressources/XSL/Commun_SAS.xsl"/>
  <xsl:import href="../../Ressources/XSL/commun_transfo.xsl"/>
  <xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes"/>
  <xsl:param name="langage" select="'fr'"/>
  <xsl:param name="familyNumber" select="''"/>
  <xsl:param name="root" select="'/Fiben/'"/>
  <xsl:param name="familyName" select="''"/>
  <xsl:param name="familyTitle" select="''"/>
  <xsl:param name="nextModule" select="''"/>
  <xsl:param name="nextId" select="''"/>
  <xsl:param name="nextFamily" select="''"/>
  <xsl:param name="Lang" select="'FR'"/>
  <xsl:param name="NonResident" select="''"/>
  <xsl:param name="menuHTML1"/>
  <xsl:param name="micromodule" select="''" />

  <!--TEMPLATE PRINCIPAL-->
  <xsl:template match="/">
    <html lang="fr" xmlns="http://www.w3.org/1999/xhtml">
      <title>Module S5 - Information du suivi</title>
      <xsl:call-template name="genHeadSAS">
      </xsl:call-template>
      <body class="clBodybgcolorWhite">
        <xsl:call-template name="genFondMenu">
          <xsl:with-param name="root" select="$root"/>
          <xsl:with-param name="type" select="'suivi'" />
        </xsl:call-template>
        <!-- Affichage des menus: EVOL 2016 -->
        <xsl:copy-of select="$menuHTML1"/>

        <xsl:if test="/FIBEN/ERREUR">
          <xsl:call-template name="GestionErreurSAS" >
            <xsl:with-param name="root" select="$root"/>
            <xsl:with-param name="familyTitle" select="$familyTitle" />
          </xsl:call-template>
        </xsl:if >
        <xsl:if test="not(/FIBEN/ERREUR)">
          <table class="mainmodule horizontal-auto HomeData clBorderCell">
            <caption class="visually-hidden">Module S5 - Information du suivi</caption>
            <tr>
             <td class="clWidth20"></td>
              <td class="clWidth636" colspan="2">
                <form method="Post" name="frmForm1">
                  <input type="hidden" name="ident" value=""/>

                  <!-- Affichage du titre du micromodule : -->
                  <table class="clWidthMax clBorderCell" role="presentation">
                    <tr class="clHeight20">
                      <td class="clTitreBleu cltitre16 clWidth778 clAlignCenter" colspan="2">
                        Information du&#160;
                        <xsl:value-of select="$dictionnaire/titre[@module=$micromodule]"/>
                        &#160;<xsl:value-of select="$micromodule"/>
                      </td>
                    </tr>
                    <tr>
                      <td class="clWidth10">&#160;</td>
                      <td class="clWidth768">
                        <img src="{$root}images/risque/shim_bleu.gif" width="768" height="1" alt=""/>
                      </td>
                    </tr>
                  </table>
                  <!-- tableau affichage de l'identifiant -->
                  <table class="clWidthMax clBorderCell" style="display:block;">
                    <caption class="visually-hidden">Information du suivi</caption>
                    <tr>
                      <td class="clWidth10">&#160;</td>
                      <td class="clGrasFond clWidth140">
                        <xsl:value-of select ="/FIBEN/SERVICESAS/MODULES5/MOUVSUI/IDENT"/>
                      </td>
                      <td class="clGrasFond clWidth628">
                        <xsl:call-template name ="displayInLowerCaseXsl">
                          <xsl:with-param name ="InputStringNom" select ="/FIBEN/SERVICESAS/MODULES5/MOUVSUI/NOM"/>
                          <xsl:with-param name ="InputStringPrenom" select ="/FIBEN/SERVICESAS/MODULES5/MOUVSUI/PRENOM"/>
                        </xsl:call-template>
                      </td>
                    </tr>

                  </table>
                  <!-- tableau affichage du ou des motclés et valeurs avec les cas particulier AF, AP, AJ, AM, AX, AB et AE  -->
                  <!-- ********************************************************************* -->


                  <xsl:variable name ="PremierMotcle" select="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[1]/MOTCLE"></xsl:variable>
                  <xsl:variable name ="NBmotCle" select ="count(/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI)"></xsl:variable>
                  <xsl:choose>
                    <!-- cas des message informatif-->
                    <xsl:when test ="($PremierMotcle = 'CLENOUV') or ($PremierMotcle = 'EFIN') or ($PremierMotcle = 'EIND') or ($PremierMotcle = 'ENTPURG') or ($PremierMotcle = 'IDNOUV') or ($PremierMotcle = 'METAT') or ($PremierMotcle = 'NONRES') or ($PremierMotcle = 'NONECO') or ($PremierMotcle = 'CDIFBILS') or ($PremierMotcle = 'MDIFBILS') or ($PremierMotcle = 'SDIFBILS') or ($PremierMotcle = 'ETAT') or ($PremierMotcle = 'EPIC') or ($PremierMotcle = 'DBILS') or ($PremierMotcle = 'DBILG') or ($PremierMotcle = 'NGRP')">

                      <xsl:choose>
                        <xsl:when test ="($NBmotCle = 1) and(($PremierMotcle = 'CLENOUV') or ($PremierMotcle = 'EFIN') or ($PremierMotcle = 'EIND') or ($PremierMotcle = 'ENTPURG') or ($PremierMotcle = 'IDNOUV') or ($PremierMotcle = 'METAT') or ($PremierMotcle = 'NONRES') or ($PremierMotcle = 'NONECO') or ($PremierMotcle = 'CDIFBILS') or ($PremierMotcle = 'MDIFBILS') or ($PremierMotcle = 'SDIFBILS') or ($PremierMotcle = 'ETAT') or ($PremierMotcle = 'EPIC') or ($PremierMotcle = 'DBILS') or ($PremierMotcle = 'DBILG') or ($PremierMotcle = 'NGRP'))">
                          <xsl:call-template name="MicromoduleMessInformatifSimple">
                            <xsl:with-param name ="MotcleMessInfo" select="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[1]/MOTCLE"></xsl:with-param>
                            <xsl:with-param name ="ValeurMessInfo" select="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[1]/VALEUR"></xsl:with-param>
                            <xsl:with-param name ="DateMouve" select="/FIBEN/SERVICESAS/MODULES5/MOUVSUI/DATEMOUVE"></xsl:with-param>
                            <xsl:with-param name ="position" select ="1"></xsl:with-param>
                            <xsl:with-param name ="Max" select ="count(/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI)"></xsl:with-param>
                          </xsl:call-template>
                        </xsl:when>
                        <xsl:when test ="($NBmotCle > 1) and (($PremierMotcle = 'CLENOUV') or ($PremierMotcle = 'EFIN') or ($PremierMotcle = 'EIND') or ($PremierMotcle = 'ENTPURG') or ($PremierMotcle = 'IDNOUV') or ($PremierMotcle = 'METAT') or ($PremierMotcle = 'NONRES') or ($PremierMotcle = 'NONECO') or ($PremierMotcle = 'CDIFBILS') or ($PremierMotcle = 'MDIFBILS') or ($PremierMotcle = 'SDIFBILS') or ($PremierMotcle = 'ETAT') or ($PremierMotcle = 'EPIC') or ($PremierMotcle = 'DBILS') or ($PremierMotcle = 'DBILG') or ($PremierMotcle = 'NGRP'))">
                          <xsl:call-template name="MicromoduleMessInformatif">
                            <xsl:with-param name ="MotcleMessInfo" select="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[1]/MOTCLE"></xsl:with-param>
                            <xsl:with-param name ="ValeurMessInfo" select="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[1]/VALEUR"></xsl:with-param>
                            <xsl:with-param name ="DateMouve" select="/FIBEN/SERVICESAS/MODULES5/MOUVSUI/DATEMOUVE"></xsl:with-param>
                            <xsl:with-param name ="position" select ="1"></xsl:with-param>
                            <xsl:with-param name ="Max" select ="count(/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI)"></xsl:with-param>
                          </xsl:call-template>
                        </xsl:when>
                      </xsl:choose>
                    </xsl:when>
                    <xsl:otherwise>

                      <xsl:choose>
                        <xsl:when test = "$micromodule = 'AF'">

                          <xsl:call-template name ="TestMicromoduleAF">
                            <xsl:with-param name ="Max" select ="count(/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI)"></xsl:with-param>
                          </xsl:call-template>
                        </xsl:when>

                        <!-- ********************************************************************* -->

                        <xsl:when test ="$micromodule = 'AP'">

                          <xsl:call-template name ="MicromoduleAP">
                            <xsl:with-param name ="numCparticip" select ="1"></xsl:with-param>
                            <xsl:with-param name ="numMparticip" select ="1"></xsl:with-param>
                            <xsl:with-param name ="numSparticip" select ="1"></xsl:with-param>
                            <xsl:with-param name ="numCassoc" select ="1"></xsl:with-param>
                            <xsl:with-param name ="numMassoc" select ="1"></xsl:with-param>
                            <xsl:with-param name ="numSassoc" select ="1"></xsl:with-param>
                            <xsl:with-param name ="position" select ="1"></xsl:with-param>
                            <xsl:with-param name ="indicMess" select ="0"></xsl:with-param>
                            <xsl:with-param name ="Max" select ="(count(/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI)) + 1"></xsl:with-param>
                          </xsl:call-template>

                        </xsl:when>

                        <!-- ********************************************************************* -->

                        <xsl:when test ="$micromodule = 'AJ'">

                          <xsl:call-template name ="MicromoduleAJ">
                            <xsl:with-param name ="numCcodejug" select ="1"></xsl:with-param>
                            <xsl:with-param name ="numMcodejug" select ="1"></xsl:with-param>
                            <xsl:with-param name ="numScodejug" select ="1"></xsl:with-param>
                            <xsl:with-param name ="numCcodevmt" select ="1"></xsl:with-param>
                            <xsl:with-param name ="numMcodevmt" select ="1"></xsl:with-param>
                            <xsl:with-param name ="numScodevmt" select ="1"></xsl:with-param>
                            <xsl:with-param name ="position" select ="1"></xsl:with-param>
                            <xsl:with-param name ="Max" select ="(count(/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI)) + 1"></xsl:with-param>
                          </xsl:call-template>

                        </xsl:when>

                        <!--   ********************************************************************* -->

                        <xsl:when test ="$micromodule = 'AM'">

                          <xsl:call-template name ="MicromoduleAM">
                            <xsl:with-param name ="numCfctacti" select ="1"></xsl:with-param>
                            <xsl:with-param name ="numMfctacti" select ="1"></xsl:with-param>
                            <xsl:with-param name ="numSfctacti" select ="1"></xsl:with-param>
                            <xsl:with-param name ="position" select ="1"></xsl:with-param>
                            <xsl:with-param name ="Max" select ="(count(/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI)) + 1"></xsl:with-param>
                          </xsl:call-template>

                        </xsl:when>

                        <!--   ********************************************************************* -->

                        <xsl:when test ="$micromodule = 'AX'">

                          <xsl:call-template name ="MicromoduleAX">
                            <xsl:with-param name ="numCfoncdir" select ="1"></xsl:with-param>
                            <xsl:with-param name ="numMfoncdir" select ="1"></xsl:with-param>
                            <xsl:with-param name ="numSfoncdir" select ="1"></xsl:with-param>
                            <xsl:with-param name ="position" select ="1"></xsl:with-param>
                            <xsl:with-param name ="Max" select ="(count(/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI)) + 1"></xsl:with-param>
                          </xsl:call-template>

                        </xsl:when>

                        <!--   ********************************************************************* -->


                        <xsl:when test = "$micromodule = 'AB'">


                          <xsl:call-template name ="TestMicromoduleAB">
                            <xsl:with-param name ="position" select ="1"></xsl:with-param>
                            <xsl:with-param name ="Max" select ="count(/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI)"></xsl:with-param>
                          </xsl:call-template>


                        </xsl:when>

                        <!--   ********************************************************************* -->

                        <xsl:when test = "$micromodule = 'AE'">
                          <xsl:variable name ="indic" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[1]/MOTCLE"></xsl:variable>
                          <xsl:choose>
                            <xsl:when test ="$indic = 'NOMGROUP'">
                              <xsl:call-template name ="TestMicromoduleAE">
                                <xsl:with-param name ="position" select ="1"></xsl:with-param>
                                <xsl:with-param name ="Max" select ="count(/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI)"></xsl:with-param>
                              </xsl:call-template>
                            </xsl:when>
                            <xsl:otherwise>
                              <xsl:call-template name ="TestMicromoduleAE2">
                                <xsl:with-param name ="position" select ="1"></xsl:with-param>
                                <xsl:with-param name ="Max" select ="count(/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI)"></xsl:with-param>
                              </xsl:call-template>
                            </xsl:otherwise>
                          </xsl:choose>

                        </xsl:when>

                        <!--   ********************************************************************* -->

                        <xsl:when test = "$micromodule = 'AD'">
                          <xsl:call-template name ="TestMicromoduleAD">
                          </xsl:call-template>

                        </xsl:when>


                        <!--   ********************************************************************* -->

                        <xsl:otherwise>

                          <xsl:call-template name ="AutreMicromodule">
                          </xsl:call-template>

                        </xsl:otherwise>
                      </xsl:choose>

                    </xsl:otherwise>
                  </xsl:choose>

                  <table class="clWidthMax clBorderCell" role="presentation">
                    <tr>
                      <td class="clWidth10">&#160;</td>
                      <td class="clWidth768" colspan="2">
                        <img src="{$root}images/risque/shim_bleu.gif" width="768" height="1" alt=""/>
                      </td>
                    </tr>
                    <tr>
                      <td class="clWidth10">&#160;</td>
                      <td class="clTitreBleu clFont12 clWidth618">
                        <xsl:value-of select="($dictionnaire/mot[@id=(concat('MESSINFO',$micromodule))])"/>
                      </td>
                      <!-- demande de generation "plus d'info" un module + Z1 ou  multimodule + Z1-->
                      <xsl:variable name ="infomodule" select ="($dictionnaire/mot[@id=(concat('PLUSINFO',$micromodule))])"></xsl:variable>
                      <xsl:choose>
                        <xsl:when test ="string-length($infomodule) = 2">
                          <td class="clWidth150 clAlignRight clValignMiddle">
                            <a href="#nullepart" onClick="requestBDFInfos('{concat(($dictionnaire/mot[@id=(concat('PLUSINFO',$micromodule))]),'|','Z1','|')}','','{$familyNumber}','{/FIBEN/SERVICESAS/MODULES5/MOUVSUI/IDENT}',cstMultipleConfirm);">
                              <img src="../images/Commun/clignotant2.gif" width="85" height="12" border="0" align="absbottom" alt="plus d'infos"/>
                            </a>
                          </td>
                        </xsl:when>
                        <xsl:otherwise>
                          <td class="clWidth150 clAlignRight clValignMiddle">
                            <a href="#nullepart" onClick="requestBDFInfos('{concat(($dictionnaire/mot[@id=(concat('PLUSINFO',$micromodule))]),'Z1','|')}','','{$familyNumber}','{/FIBEN/SERVICESAS/MODULES5/MOUVSUI/IDENT}',cstMultipleConfirm);">
                              <img src="../images/Commun/clignotant2.gif" width="85" height="12" border="0" align="absbottom" alt="plus d'infos"/>
                            </a>
                          </td>
                        </xsl:otherwise>
                      </xsl:choose>
                    </tr>
                    <tr>
                      <td class="clWidth10">&#160;</td>
                      <td class="clWidth768" colspan="2">
                        <img src="{$root}images/risque/shim_bleu.gif" width="768" height="1" alt=""/>
                      </td>
                    </tr>
                  </table>

                </form>
              </td>
            </tr>
          </table>
        </xsl:if>

        <xsl:call-template name="genBasPage"/>
      </body>
    </html>
  </xsl:template>


  <!-- ****************** les différents templates d'affichage en fonction du type de micromodule ********************************************** -->

  <xsl:template name ="AutreMicromodule">
    <xsl:for-each select="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI">
      <xsl:variable name ="motcle" select ="MOTCLE"></xsl:variable>
      <!-- test pour affichage format date-->
      <xsl:choose>
        <xsl:when test ="$motcle = 'DATCOT' or $motcle = 'CDATEXA' or $motcle = 'MDATEXA' or $motcle = 'SDATEXA' or $motcle = 'DATSEG' or $motcle = 'XDATEXA' or $motcle = 'DATCLOTG' or $motcle = 'SSEGMENT' or $motcle='MADRESS'">
          <table class="clWidthMax clBorderCell" role="presentation">
            <tr>
              <td class="clWidth10">&#160;</td>
              <td class="clGras clWidth768"></td>
            </tr>
            <tr>
              <td class="clWidth10">&#160;</td>
              <td class="clTexte clWidth768">
                <xsl:value-of select="($dictionnaire/mot[@id=$motcle])"/>&#160;
                <xsl:choose>
                  <xsl:when test ="$motcle = 'DATCLOTG'">
                    <xsl:call-template name ="displayDateClot">
                      <xsl:with-param name ="InputDateClot" select ="VALEUR"/>
                    </xsl:call-template>
                  </xsl:when>
                  <xsl:when test="$motcle = 'MADRESS'">
                    <xsl:call-template name="PrintAdress">
                      <xsl:with-param name="adress" select="VALEUR"></xsl:with-param>
                    </xsl:call-template>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:call-template name ="displayDateXsl">
                      <xsl:with-param name ="InputDate" select ="VALEUR"/>
                    </xsl:call-template>
                  </xsl:otherwise>
                </xsl:choose>

              </td>
            </tr>
          </table>
        </xsl:when>
        <xsl:otherwise>
          <table class="clWidthMax clBorderCell" role="presentation">
            <tr>
              <td class="clWidth10">&#160;</td>
              <td class="clGras clWidth768"></td>
            </tr>
            <tr>
              <td class="clWidth10">&#160;</td>
              <td class="clTexte clWidth768">
                <xsl:value-of select="($dictionnaire/mot[@id=$motcle])"/>&#160;
                <xsl:choose>
                  <xsl:when test ="($motcle = 'NBNVIP') or ($motcle = 'NBNVCC') or ($motcle = 'NBMOIP') or ($motcle = 'NBMOCC') or ($motcle = 'CSEGMENT') or ($motcle = 'MSEGMENT') or ($motcle = 'PEFFECT') or ($motcle = 'PCACONS')">
                    <xsl:call-template name ="displayFormatNombre">
                      <xsl:with-param name ="InputValeur" select ="VALEUR"/>
                    </xsl:call-template>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:choose>
                      <xsl:when test ="./CONVERT">
                        <xsl:variable name ="valeur" select ="VALEUR"></xsl:variable>
                        <xsl:value-of select="($dictionnaire/mot[@id=$valeur])"/>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select ="VALEUR"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:otherwise>

                </xsl:choose>

              </td>
            </tr>
          </table>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:for-each>
  </xsl:template>

  <!-- ******************************* Micromodule AD **********************************************************************************-->

  <xsl:template name="TestMicromoduleAD">

    <xsl:for-each select="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI">
      <xsl:variable name ="motcleAD" select ="MOTCLE"></xsl:variable>

      <xsl:choose>
        <xsl:when test ="$motcleAD = 'MADRESS'">
          <table class="clWidthMax clBorderCell" role="presentation">
            <tr>
              <td class="clWidth10">&#160;</td>
              <td class="clGras clWidth768"></td>
            </tr>
            <tr>
              <td class="clWidth10">&#160;</td>
              <td class="clTexte clWidth768">
                <xsl:value-of select="($dictionnaire/mot[@id=$motcleAD])"/>&#160;
                <xsl:call-template name="PrintAdress">
                  <xsl:with-param name="adress" select="VALEUR"></xsl:with-param>
                </xsl:call-template>
              </td>
            </tr>
          </table>
        </xsl:when>
        <xsl:otherwise>
          <xsl:choose>
            <xsl:when test ="substring($motcleAD,1 ,1) = 'S'">
              <table class="clWidthMax clBorderCell" role="presentation">
                <table class="clWidthMax clBorderCell" role="presentation">
                  <tr>
                    <td class="clWidth10">&#160;</td>
                    <td class="clGras clWidth768"></td>
                  </tr>
                  <tr>
                    <td class="clWidth10">&#160;</td>
                    <td class="clTexte clWidth768">
                      <xsl:value-of select="($dictionnaire/mot[@id=$motcleAD])"/>&#160;
                    </td>
                  </tr>
                </table>
              </table>
            </xsl:when>
            <xsl:otherwise>
              <table class="clWidthMax clBorderCell" role="presentation">
                <tr>
                  <td class="clWidth10">&#160;</td>
                  <td class="clGras clWidth768"></td>
                </tr>
                <tr>
                  <td class="clWidth10">&#160;</td>
                  <td class="clTexte clWidth768">
                    <xsl:value-of select="($dictionnaire/mot[@id=$motcleAD])"/>&#160;
                    <xsl:choose>
                      <xsl:when test ="./CONVERT">
                        <xsl:variable name ="valeur" select ="VALEUR"></xsl:variable>
                        <xsl:value-of select="($dictionnaire/mot[@id=$valeur])"/>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select ="VALEUR"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </td>
                </tr>
              </table>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:for-each>

  </xsl:template>


  <!-- * * * * * * * * * * * * * * Les templates du template Micromodule AD * * * * * * * * * * * * * * * * * * * * * * *-->

  <xsl:template name ="PrintAdress">
    <xsl:param name ="adress" ></xsl:param>
    <br/>
    <xsl:call-template name="AdressFieldLoop">
      <xsl:with-param name ="adress" select="VALEUR"></xsl:with-param>
    </xsl:call-template>
  </xsl:template>


  <xsl:template name ="AdressFieldLoop">
    <xsl:param name ="adress" ></xsl:param>
    <xsl:param name ="nextAdressField" select="$adress"></xsl:param>
    <xsl:choose>
      <xsl:when test="contains($nextAdressField,'|')">
        <xsl:if test ="not(substring-before($nextAdressField,'|')='')">
          <xsl:value-of select="substring-before($nextAdressField,'|')"/>
          <br/>
          <xsl:call-template name ="AdressFieldLoop">
            <xsl:with-param name ="nextAdressField" select ="substring-after($nextAdressField,'|')"></xsl:with-param>
          </xsl:call-template>
        </xsl:if>
        <xsl:if test ="substring-before($nextAdressField,'|')=''">
          <xsl:call-template name ="AdressFieldLoop">
            <xsl:with-param name ="nextAdressField" select ="substring-after($nextAdressField,'|')"></xsl:with-param>
          </xsl:call-template>
        </xsl:if>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select ="$nextAdressField"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- ******************************* Micromodule AF **********************************************************************************-->

  <xsl:template name ="TestMicromoduleAF">
    <xsl:param name ="Max"></xsl:param>
    <!-- test pour savoir si presence de un ou deux exercices comptables ou simplement un mess-->
    <xsl:choose>
      <xsl:when test ="$Max = 1">
        <xsl:call-template name ="AutreMicromodule">
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name ="MicromoduleAF">
          <xsl:with-param name ="position" select ="1"></xsl:with-param>
          <xsl:with-param name ="nbExe" select ="0"></xsl:with-param>
          <xsl:with-param name ="Max" select ="(count(/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI)) + 1"></xsl:with-param>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>

  </xsl:template>


  <xsl:template name ="MicromoduleAF">
    <xsl:param name ="position"></xsl:param>
    <xsl:param name ="nbExe"></xsl:param>
    <xsl:param name ="Max"></xsl:param>

    <!-- test pour savoir si presence de un ou deux exercices comptables ou simplement un mess-->

    <xsl:if test ="$Max = 2">
      <xsl:for-each select="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI">
        <xsl:variable name ="motcle" select ="MOTCLE"></xsl:variable>
        <table class="clWidthMax clBorderCell" role="presentation">
          <tr>
            <td class="clWidth10">&#160;</td>
            <td class="clTexte clWidth768">
              <xsl:value-of select="($dictionnaire/mot[@id=$motcle])"/>&#160;
              <xsl:choose>
                <xsl:when test ="./CONVERT">
                  <xsl:variable name ="valeur" select ="VALEUR"></xsl:variable>
                  <xsl:value-of select="($dictionnaire/mot[@id=$valeur])"/>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select ="VALEUR"/>
                </xsl:otherwise>
              </xsl:choose>
            </td>
          </tr>
        </table>
      </xsl:for-each>
    </xsl:if>

    <xsl:if test ="$position &lt; $Max">

      <xsl:for-each select="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position]">

        <xsl:variable name ="TypeDonnee" select ="MOTCLE"></xsl:variable>

        <xsl:choose>
          <xsl:when test ="$TypeDonnee = 'DATCLOTS'">
            <xsl:call-template name ="MicromoduleAF">
              <xsl:with-param name ="nbExe" select ="$nbExe + 1"></xsl:with-param>
              <xsl:with-param name ="position" select ="$position + 1"></xsl:with-param>
              <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
            </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
            <xsl:call-template name ="MicromoduleAF">
              <xsl:with-param name ="nbExe" select ="$nbExe"></xsl:with-param>
              <xsl:with-param name ="position" select ="$position + 1"></xsl:with-param>
              <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
            </xsl:call-template>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:for-each>
    </xsl:if>
    <xsl:if test ="$position = $Max">

      <table class="clWidthMax clBorderCell" role="presentation">
        <tr>
          <td class="clWidth10 clHeight20">&#160;</td>
          <td class="clWidth768 clHeight20">&#160;</td>
        </tr>
        <tr>
          <td class="clWidth10">&#160;</td>
          <td class="clTexte clWidth768">
            Un bilan social a été enregistré pour cette entité (exprimé en milliers d'euros)
          </td>
        </tr>
      </table>
      <br/>

    </xsl:if>

    <xsl:if test ="($position = $Max) and ($nbExe > 1)">
      <!-- 2 bilans -->
      <xsl:call-template name ="tableau2Bilans">
        <xsl:with-param name ="position2" select ="1"></xsl:with-param>
        <xsl:with-param name ="Max2" select ="(count(/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI)) - 4"></xsl:with-param>
      </xsl:call-template>
    </xsl:if>
    <xsl:if test ="($position = $Max) and ($nbExe = 1)">
      <xsl:call-template name ="tableau1Bilan">
      </xsl:call-template>
    </xsl:if>

    <xsl:if test ="$position = $Max">

      <table class="clWidthMax clBorderCell" role="presentation">
        <tr>
          <td class="clWidth10">&#160;</td>
          <td class="clWidth768">&#160;</td>
        </tr>
        <tr>
          <td class="clWidth10">&#160;</td>
          <td class="clWidth768">&#160;</td>
        </tr>
        <tr>
          <td class="clWidth10">&#160;</td>
          <td class="clTitre35 clWidth768">
            *Le mouvement peut concerner deux exercices comptables de durées différentes
          </td>
        </tr>
      </table>
    </xsl:if>

  </xsl:template>

  <xsl:template name ="tableau2Bilans">
    <xsl:param name="position2"></xsl:param>
    <xsl:param name="Max2"></xsl:param>


    <xsl:if test ="$position2 &lt; $Max2">

      <xsl:for-each select="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position2]">

        <xsl:variable name ="TypeDonnee" select ="MOTCLE"></xsl:variable>

        <table class="clWidthMax clBorderCell" role="presentation">
          <tr>
            <td class="clWidth10">&#160;</td>
            <xsl:choose>
              <xsl:when test ="$TypeDonnee = 'DATCLOTS'">
                <td class="clWidth368">&#160;</td>
                <td class="clGras clWidth130 clAlignCenter">
                  <xsl:call-template name ="displayDateClot">
                    <xsl:with-param name ="InputDateClot" select ="VALEUR"/>
                  </xsl:call-template>
                </td>
                <td class="clWidth90">&#160;</td>
                <td class="clTexte clWidth150 clAlignCenter">
                  <xsl:variable name ="posBilan2" select="$position2 + 5"></xsl:variable>
                  <xsl:call-template name ="displayDateClot">
                    <xsl:with-param name ="InputDateClot" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$posBilan2]/VALEUR"/>
                  </xsl:call-template>
                </td>
              </xsl:when>
              <xsl:when test ="($TypeDonnee = 'P2052FL') or ($TypeDonnee = 'PK00304') or ($TypeDonnee = 'PK00311') or ($TypeDonnee = 'VARK68')" >
                <!-- formatage des valeurs avec suppression des zeros non significatifs -->
                <td class="clTexte clWidth368">
                  <xsl:value-of select="($dictionnaire/mot[@id=$TypeDonnee])"/>&#160;
                </td>
                <td class="clTexte clWidth130 clAlignCenter">
                  <xsl:call-template name ="displayFormatNombre">
                    <xsl:with-param name ="InputValeur" select ="VALEUR"/>
                  </xsl:call-template>
                </td>
                <td class="clWidth90">&#160;</td>
                <td class="clTexte clWidth150 clAlignCenter">
                  <xsl:variable name ="posBilan2" select="$position2 + 5"></xsl:variable>
                  <xsl:call-template name ="displayFormatNombre">
                    <xsl:with-param name ="InputValeur" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$posBilan2]/VALEUR"/>
                  </xsl:call-template>
                </td>
              </xsl:when>
              <xsl:otherwise>
                <td class="clTexte clWidth368">
                  <xsl:value-of select="($dictionnaire/mot[@id=$TypeDonnee])"/>&#160;
                </td>
                <td class="clTexte clWidth130 clAlignCenter">
                  <xsl:value-of select ="VALEUR"/>
                </td>
                <td class="clWidth90">&#160;</td>
                <td class="clTexte clWidth150 clAlignCenter">
                  <xsl:variable name ="posBilan2" select="$position2 + 5"></xsl:variable>
                  <xsl:choose>
                    <xsl:when test ="./CONVERT">
                      <xsl:variable name ="valeur" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$posBilan2]/VALEUR"></xsl:variable>
                      <xsl:value-of select="($dictionnaire/mot[@id=$valeur])"/>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:value-of select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$posBilan2]/VALEUR"/>
                    </xsl:otherwise>
                  </xsl:choose>
                </td>
              </xsl:otherwise>
            </xsl:choose>
          </tr>
        </table>
        <xsl:call-template name ="tableau2Bilans">
          <xsl:with-param name ="position2" select ="$position2 + 1"></xsl:with-param>
          <xsl:with-param name ="Max2" select ="$Max2"></xsl:with-param>
        </xsl:call-template>

      </xsl:for-each>
    </xsl:if>
  </xsl:template>


  <xsl:template name ="tableau1Bilan">
    <xsl:for-each select="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI">
      <xsl:variable name ="motcle" select ="MOTCLE"></xsl:variable>
      <xsl:choose>
        <xsl:when test ="$motcle = 'DATCLOTS'">
          <table class="clWidthMax clBorderCell" role="presentation">
            <tr>
              <td class="clWidth10 clHeight20">&#160;</td>
              <td class="clWidth358 clHeight20">&#160;</td>
              <td class="clWidth410 clHeight20">&#160;</td>
            </tr>
            <tr>
              <td class="clWidth10">&#160;</td>
              <td class="clTexte clWidth358">
                <xsl:value-of select="($dictionnaire/mot[@id=$motcle])"/>&#160;
              </td>
              <td class="clTexte clWidth410">
                <xsl:call-template name ="displayDateClot">
                  <xsl:with-param name ="InputDateClot" select ="VALEUR"/>
                </xsl:call-template>
              </td>
            </tr>
          </table>
        </xsl:when>
        <xsl:when test ="($motcle = 'P2052FL') or ($motcle = 'PK00304') or ($motcle = 'PK00311') or ($motcle = 'VARK68')">
          <table class="clWidthMax clBorderCell" role="presentation">
            <tr>
              <td class="clWidth10">&#160;</td>
              <td class="clTexte clWidth358">
                <xsl:value-of select="($dictionnaire/mot[@id=$motcle])"/>&#160;
              </td>
              <td class="clTexte clWidth410">
                <xsl:call-template name ="displayFormatNombre">
                  <xsl:with-param name ="InputValeur" select ="VALEUR"/>
                </xsl:call-template>
              </td>
            </tr>
          </table>
        </xsl:when>
        <xsl:otherwise>
          <table class="clWidthMax clBorderCell" role="presentation">
            <tr>
              <td class="clWidth10">&#160;</td>
              <td class="clTexte clWidth358">
                <xsl:value-of select="($dictionnaire/mot[@id=$motcle])"/>&#160;
              </td>
              <td class="clTexte clWidth410">
                <xsl:choose>
                  <xsl:when test ="./CONVERT">
                    <xsl:variable name ="valeur" select ="VALEUR"></xsl:variable>
                    <xsl:value-of select="($dictionnaire/mot[@id=$valeur])"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select ="VALEUR"/>
                  </xsl:otherwise>
                </xsl:choose>
              </td>
            </tr>
          </table>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:for-each>
  </xsl:template>

  <!-- * * * * * * * * * * * * * * Les templates du template Micromodule AP * * * * * * * * * * * * * * * * * * * * * * * -->

  <xsl:template name="libelleCASSOC">
    <xsl:param name ="numCassoc"></xsl:param>
    <xsl:param name ="numMassoc"></xsl:param>
    <xsl:param name ="numSassoc"></xsl:param>
    <xsl:param name ="libelle"></xsl:param>
    <xsl:param name ="position"></xsl:param>
    <xsl:param name ="indicMess"></xsl:param>
    <xsl:param name ="Max"></xsl:param>
    <xsl:if test ="($libelle = 'CASSOC' and $numCassoc = '1')">
      <table class="clWidthMax clBorderCell" role="presentation">
        <tr>
          <td class="clWidth10 clHeight20">&#160;</td>
          <td class="clWidth768 clHeight20">&#160;</td>
        </tr>
        <tr>
          <td class="clWidth10">&#160;</td>
          <td class="clTexte clWidth768">
            <xsl:value-of select="($dictionnaire/mot[@id=$libelle])"/>&#160;
          </td>
        </tr>
        <tr>
          <td class="clWidth10 clHeight20">&#160;</td>
          <td class="clWidth768 clHeight20">&#160;</td>
        </tr>
      </table>
      <xsl:variable name ="PositionSuivante"  select ="$position + 1"></xsl:variable>
      <xsl:variable name ="PositionSuivante2"  select ="$position + 2"></xsl:variable>
      <xsl:variable name ="NouedSuivant" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante]/MOTCLE"></xsl:variable>
      <xsl:variable name ="NouedSuivant2" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante2]/VALEUR"></xsl:variable>
      <!-- si la valeur de NouedSuivant = NOASSOC il faut rajouter la valeur de PRASSOC -->
      <xsl:choose>
        <xsl:when test ="$NouedSuivant = 'NOASSOC'">
          <table class="clWidthMax clBorderCell" role="presentation">
            <tr>
              <td class="clWidth10">&#160;</td>
              <td class="clGras clWidth130">
                <!-- cle bdf-->
                <xsl:value-of select ="VALEUR"/>
              </td>
              <td class="clTexte clWidth638">
                <xsl:call-template name ="displayInLowerCaseXsl">
                  <xsl:with-param name ="InputStringNom" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante]/VALEUR"/>
                  <xsl:with-param name ="InputStringPrenom" select ="$NouedSuivant2"/>
                </xsl:call-template>
              </td>
            </tr>
          </table>
          <xsl:call-template name ="MicromoduleAP">
            <xsl:with-param name ="numCassoc" select ="$numCassoc + 1"></xsl:with-param>
            <xsl:with-param name ="numMassoc" select ="$numMassoc"></xsl:with-param>
            <xsl:with-param name ="numSassoc" select ="$numSassoc"></xsl:with-param>
            <xsl:with-param name ="position" select ="$position + 3"></xsl:with-param>
            <xsl:with-param name ="indicMess" select ="1"></xsl:with-param>
            <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
          <xsl:choose>
            <xsl:when test="$NouedSuivant = 'ASSOSPE'">
              <table class="clWidthMax clBorderCell" role="presentation">
                <tr>
                  <td class="clWidth10">&#160;</td>
                  <td class="clTexte clWidth130">
                    <xsl:value-of select="($dictionnaire/mot[@id=$NouedSuivant])"/>
                  </td>
                  <td class="clTexte clWidth638">
                    <xsl:value-of select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante]/VALEUR"/>
                  </td>
                </tr>
              </table>
            </xsl:when>
            <xsl:otherwise>
              <table class="clWidthMax clBorderCell" role="presentation">
                <tr>
                  <td class="clWidth10">&#160;</td>
                  <td class="clTexte clWidth130">
                    <!-- l'identifiant -->
                    <xsl:variable name ="valeur" select ="VALEUR"></xsl:variable>
                    <xsl:value-of select ="concat(substring($valeur,1,3),' ',substring($valeur,4,3),' ',substring($valeur,7,3))"/>
                  </td>
                  <td class="clTexte clWidth638">
                    <xsl:choose>
                      <xsl:when test ="./CONVERT">
                        <xsl:variable name ="valeur" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante]/VALEUR"></xsl:variable>
                        <xsl:value-of select="($dictionnaire/mot[@id=$valeur])"/>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante]/VALEUR"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </td>
                </tr>
              </table>
            </xsl:otherwise>
          </xsl:choose>
          <xsl:call-template name ="MicromoduleAP">
            <xsl:with-param name ="numCassoc" select ="$numCassoc + 1"></xsl:with-param>
            <xsl:with-param name ="numMassoc" select ="$numMassoc"></xsl:with-param>
            <xsl:with-param name ="numSassoc" select ="$numSassoc"></xsl:with-param>
            <xsl:with-param name ="position" select ="$position + 2"></xsl:with-param>
            <xsl:with-param name ="indicMess" select ="1"></xsl:with-param>
            <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
          </xsl:call-template>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:if>
  </xsl:template>

  <xsl:template name="libelleMASSOC">
    <xsl:param name ="numCassoc"></xsl:param>
    <xsl:param name ="numMassoc"></xsl:param>
    <xsl:param name ="numSassoc"></xsl:param>
    <xsl:param name ="libelle"></xsl:param>
    <xsl:param name ="position"></xsl:param>
    <xsl:param name ="indicMess"></xsl:param>
    <xsl:param name ="Max"></xsl:param>
    <xsl:if test ="($libelle = 'MASSOC' and $numMassoc = '1')">
      <table class="clWidthMax clBorderCell" role="presentation">
        <tr>
          <td class="clWidth10 clHeight20">&#160;</td>
          <td class="clWidth768 clHeight20">&#160;</td>
        </tr>
        <tr>
          <td class="clWidth10">&#160;</td>
          <td class="clTexte clWidth768">
            <xsl:value-of select="($dictionnaire/mot[@id=$libelle])"/>&#160;
          </td>
        </tr>
        <tr>
          <td class="clWidth10 clHeight20">&#160;</td>
          <td class="clWidth768 clHeight20">&#160;</td>
        </tr>
      </table>
      <xsl:variable name ="PositionSuivante"  select ="$position + 1"></xsl:variable>
      <xsl:variable name ="PositionSuivante2"  select ="$position + 2"></xsl:variable>
      <xsl:variable name ="NouedSuivant" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante]/MOTCLE"></xsl:variable>
      <xsl:variable name ="NouedSuivant2" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante2]/VALEUR"></xsl:variable>
      <!-- si la valeur de NouedSuivant = NOASSOC il faut rajouter la valeur de PRASSOC -->
      <xsl:choose>
        <xsl:when test ="$NouedSuivant = 'NOASSOC'">
          <table class="clWidthMax clBorderCell" role="presentation">
            <tr>
              <td class="clWidth10">&#160;</td>
              <td class="clTexte clWidth130">
                <!-- cle bdf-->
                <xsl:value-of select ="VALEUR"/>
              </td>
              <td class="clTexte clWidth638">
                <xsl:call-template name ="displayInLowerCaseXsl">
                  <xsl:with-param name ="InputStringNom" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante]/VALEUR"/>
                  <xsl:with-param name ="InputStringPrenom" select ="$NouedSuivant2"/>
                </xsl:call-template>
              </td>
            </tr>
          </table>
          <xsl:call-template name ="MicromoduleAP">
            <xsl:with-param name ="numCassoc" select ="$numCassoc"></xsl:with-param>
            <xsl:with-param name ="numMassoc" select ="$numMassoc + 1"></xsl:with-param>
            <xsl:with-param name ="numSassoc" select ="$numSassoc"></xsl:with-param>
            <xsl:with-param name ="position" select ="$position + 3"></xsl:with-param>
            <xsl:with-param name ="indicMess" select ="1"></xsl:with-param>
            <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
          <xsl:choose>
            <xsl:when test="$NouedSuivant = 'ASSOSPE'">
              <table class="clWidthMax clBorderCell" role="presentation">
                <tr>
                  <td class="clWidth10">&#160;</td>
                  <td class="clTexte clWidth130">
                    <xsl:value-of select="($dictionnaire/mot[@id=$NouedSuivant])"/>
                  </td>
                  <td class="clTexte clWidth638">
                    <xsl:value-of select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante]/VALEUR"/>
                  </td>
                </tr>
              </table>
            </xsl:when>
            <xsl:otherwise>
              <table class="clWidthMax clBorderCell" role="presentation">
                <tr>
                  <td class="clWidth10">&#160;</td>
                  <td class="clTexte clWidth130">
                    <!-- l'identifiant -->
                    <xsl:variable name ="valeur" select ="VALEUR"></xsl:variable>
                    <xsl:value-of select ="concat(substring($valeur,1,3),' ',substring($valeur,4,3),' ',substring($valeur,7,3))"/>
                  </td>
                  <td class="clTexte clWidth638">
                    <xsl:choose>
                      <xsl:when test ="./CONVERT">
                        <xsl:variable name ="valeur" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante]/VALEUR"></xsl:variable>
                        <xsl:value-of select="($dictionnaire/mot[@id=$valeur])"/>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante]/VALEUR"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </td>
                </tr>
              </table>
            </xsl:otherwise>
          </xsl:choose>
          <xsl:call-template name ="MicromoduleAP">
            <xsl:with-param name ="numCassoc" select ="$numCassoc"></xsl:with-param>
            <xsl:with-param name ="numMassoc" select ="$numMassoc + 1"></xsl:with-param>
            <xsl:with-param name ="numSassoc" select ="$numSassoc"></xsl:with-param>
            <xsl:with-param name ="position" select ="$position + 2"></xsl:with-param>
            <xsl:with-param name ="indicMess" select ="1"></xsl:with-param>
            <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
          </xsl:call-template>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:if>
  </xsl:template>


  <xsl:template name="libelleSASSOC">
    <xsl:param name ="numCassoc"></xsl:param>
    <xsl:param name ="numMassoc"></xsl:param>
    <xsl:param name ="numSassoc"></xsl:param>
    <xsl:param name ="libelle"></xsl:param>
    <xsl:param name ="position"></xsl:param>
    <xsl:param name ="indicMess"></xsl:param>
    <xsl:param name ="Max"></xsl:param>
    <xsl:if test ="($libelle = 'SASSOC' and $numSassoc = '1')">
      <table class="clWidthMax clBorderCell" role="presentation">
        <tr>
          <td class="clWidth10 clHeight20">&#160;</td>
          <td class="clWidth768 clHeight20">&#160;</td>
        </tr>
        <tr>
          <td class="clWidth10">&#160;</td>
          <td class="clTexte clWidth768">
            <xsl:value-of select="($dictionnaire/mot[@id=$libelle])"/>&#160;
          </td>
        </tr>
        <tr>
          <td class="clWidth10 clHeight20">&#160;</td>
          <td class="clWidth768 clHeight20">&#160;</td>
        </tr>
      </table>
      <xsl:variable name ="PositionSuivante"  select ="$position + 1"></xsl:variable>
      <xsl:variable name ="PositionSuivante2"  select ="$position + 2"></xsl:variable>
      <xsl:variable name ="NouedSuivant" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante]/MOTCLE"></xsl:variable>
      <xsl:variable name ="NouedSuivant2" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante2]/VALEUR"></xsl:variable>
      <!-- si la valeur de NouedSuivant = NOASSOC il faut rajouter la valeur de PRASSOC -->
      <xsl:choose>
        <xsl:when test ="$NouedSuivant = 'NOASSOC'">
          <table class="clWidthMax clBorderCell" role="presentation">
            <tr>
              <td class="clWidth10">&#160;</td>
              <td class="clTexte clWidth130">
                <!-- cle bdf-->
                <xsl:value-of select ="VALEUR"/>
              </td>
              <td class="clTexte clWidth638">
                <xsl:call-template name ="displayInLowerCaseXsl">
                  <xsl:with-param name ="InputStringNom" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante]/VALEUR"/>
                  <xsl:with-param name ="InputStringPrenom" select ="$NouedSuivant2"/>
                </xsl:call-template>
              </td>
            </tr>
          </table>
          <xsl:call-template name ="MicromoduleAP">
            <xsl:with-param name ="numCassoc" select ="$numCassoc"></xsl:with-param>
            <xsl:with-param name ="numMassoc" select ="$numMassoc"></xsl:with-param>
            <xsl:with-param name ="numSassoc" select ="$numSassoc + 1"></xsl:with-param>
            <xsl:with-param name ="position" select ="$position + 3"></xsl:with-param>
            <xsl:with-param name ="indicMess" select ="1"></xsl:with-param>
            <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
          <xsl:choose>
            <xsl:when test="$NouedSuivant = 'ASSOSPE'">
              <table class="clWidthMax clBorderCell" role="presentation">
                <tr>
                  <td class="clWidth10">&#160;</td>
                  <td class="clTexte clWidth130">
                    <xsl:value-of select="($dictionnaire/mot[@id=$NouedSuivant])"/>
                  </td>
                  <td class="clTexte clWidth638">
                    <xsl:value-of select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante]/VALEUR"/>
                  </td>
                </tr>
              </table>
            </xsl:when>
            <xsl:otherwise>
              <table class="clWidthMax clBorderCell" role="presentation">
                <tr>
                  <td class="clWidth10">&#160;</td>
                  <td class="clTexte clWidth130">
                    <!-- l'identifiant -->
                    <xsl:variable name ="valeur" select ="VALEUR"></xsl:variable>
                    <xsl:value-of select ="concat(substring($valeur,1,3),' ',substring($valeur,4,3),' ',substring($valeur,7,3))"/>
                  </td>
                  <td class="clTexte clWidth638">
                    <xsl:choose>
                      <xsl:when test ="./CONVERT">
                        <xsl:variable name ="valeur" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante]/VALEUR"></xsl:variable>
                        <xsl:value-of select="($dictionnaire/mot[@id=$valeur])"/>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante]/VALEUR"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </td>
                </tr>
              </table>
            </xsl:otherwise>
          </xsl:choose>
          <xsl:call-template name ="MicromoduleAP">
            <xsl:with-param name ="numCassoc" select ="$numCassoc"></xsl:with-param>
            <xsl:with-param name ="numMassoc" select ="$numMassoc"></xsl:with-param>
            <xsl:with-param name ="numSassoc" select ="$numSassoc + 1"></xsl:with-param>
            <xsl:with-param name ="position" select ="$position + 2"></xsl:with-param>
            <xsl:with-param name ="indicMess" select ="1"></xsl:with-param>
            <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
          </xsl:call-template>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:if>
  </xsl:template>

  <xsl:template name="AfficheValeurASSOC">
    <xsl:param name ="numCassoc"></xsl:param>
    <xsl:param name ="numMassoc"></xsl:param>
    <xsl:param name ="numSassoc"></xsl:param>
    <xsl:param name ="libelle"></xsl:param>
    <xsl:param name ="position"></xsl:param>
    <xsl:param name ="indicMess"></xsl:param>
    <xsl:param name ="Max"></xsl:param>

    <xsl:variable name ="PositionSuivante"  select ="$position + 1"></xsl:variable>
    <xsl:variable name ="PositionSuivante2"  select ="$position + 2"></xsl:variable>
    <xsl:variable name ="NouedSuivant" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante]/VALEUR"></xsl:variable>
    <xsl:variable name ="NouedSuivant2" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante2]/VALEUR"></xsl:variable>
    <!-- si la valeur de NouedSuivant = NOASSOC il faut rajouter la valeur de PRASSOC -->
    <xsl:choose>
      <xsl:when test ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante]/MOTCLE = 'NOASSOC'">
        <table class="clWidthMax clBorderCell" role="presentation">
          <tr>
            <td class="clWidth10">&#160;</td>
            <td class="clTexte clWidth130">
              <!-- cle bdf-->
              <xsl:value-of select ="VALEUR"/>
            </td>
            <td class="clTexte clWidth638">
              <xsl:call-template name ="displayInLowerCaseXsl">
                <xsl:with-param name ="InputStringNom" select ="$NouedSuivant"/>
                <xsl:with-param name ="InputStringPrenom" select ="$NouedSuivant2"/>
              </xsl:call-template>
            </td>
          </tr>
        </table>
        <xsl:call-template name ="MicromoduleAP">
          <xsl:with-param name ="numCassoc" select ="$numCassoc + 1"></xsl:with-param>
          <xsl:with-param name ="numMassoc" select ="$numMassoc"></xsl:with-param>
          <xsl:with-param name ="numSassoc" select ="$numSassoc"></xsl:with-param>
          <xsl:with-param name ="position" select ="$position + 3"></xsl:with-param>
          <xsl:with-param name ="indicMess" select ="$indicMess"></xsl:with-param>
          <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:choose>
          <xsl:when test="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante]/MOTCLE = 'ASSOSPE'">
            <xsl:variable name ="LibAsso" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante]/MOTCLE"></xsl:variable>
            <table class="clWidthMax clBorderCell" role="presentation">
              <tr>
                <td class="clWidth10">&#160;</td>
                <td class="clTexte clWidth130">
                  <xsl:value-of select="($dictionnaire/mot[@id=$LibAsso])"/>
                </td>
                <td class="clTexte clWidth638">
                  <xsl:value-of select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante]/VALEUR"/>
                </td>
              </tr>
            </table>
          </xsl:when>
          <xsl:otherwise>
            <table class="clWidthMax clBorderCell" role="presentation">
              <tr>
                <td class="clWidth10">&#160;</td>
                <td class="clTexte clWidth130">
                  <!-- l'identifiant -->
                  <xsl:variable name ="valeur" select ="VALEUR"></xsl:variable>
                  <xsl:value-of select ="concat(substring($valeur,1,3),' ',substring($valeur,4,3),' ',substring($valeur,7,3))"/>
                </td>
                <td class="clTexte clWidth638">
                  <xsl:choose>
                    <xsl:when test ="./CONVERT">
                      <xsl:variable name ="valeur" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante]/VALEUR"></xsl:variable>
                      <xsl:value-of select="($dictionnaire/mot[@id=$valeur])"/>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:value-of select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante]/VALEUR"/>
                    </xsl:otherwise>
                  </xsl:choose>
                </td>
              </tr>
            </table>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:call-template name ="MicromoduleAP">
          <xsl:with-param name ="numCassoc" select ="$numCassoc + 1"></xsl:with-param>
          <xsl:with-param name ="numMassoc" select ="$numMassoc"></xsl:with-param>
          <xsl:with-param name ="numSassoc" select ="$numSassoc"></xsl:with-param>
          <xsl:with-param name ="position" select ="$position + 2"></xsl:with-param>
          <xsl:with-param name ="indicMess" select ="$indicMess"></xsl:with-param>
          <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- template de construction d'un message sur une ligne (mot-cle + valeur)-->

  <xsl:template name="AfficheLibValASSOC">
    <xsl:param name ="numCassoc"></xsl:param>
    <xsl:param name ="numMassoc"></xsl:param>
    <xsl:param name ="numSassoc"></xsl:param>
    <xsl:param name ="libelle"></xsl:param>
    <xsl:param name ="position"></xsl:param>
    <xsl:param name ="indicMess"></xsl:param>
    <xsl:param name ="Max"></xsl:param>
    <table class="clWidthMax clBorderCell" role="presentation">
      <tr>
        <td class="clWidth10 clHeight20">&#160;</td>
        <td class="clWidth768 clHeight20">&#160;</td>
      </tr>
      <tr>
        <td class="clWidth10">&#160;</td>
        <td class="clTexte clWidth768">
          <xsl:value-of select="($dictionnaire/mot[@id=$libelle])"/>&#160;
          <xsl:choose>
            <xsl:when test ="($libelle = 'CCAPIT') or ($libelle = 'MCAPIT') or ($libelle = 'SCAPIT')">
              <xsl:call-template name ="displayFormatNombre">
                <xsl:with-param name ="InputValeur" select ="VALEUR"/>
              </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
              <xsl:choose>
                <xsl:when test ="./CONVERT">
                  <xsl:variable name ="valeur" select ="VALEUR"></xsl:variable>
                  <xsl:value-of select="($dictionnaire/mot[@id=$valeur])"/>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select ="VALEUR"/>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:otherwise>
          </xsl:choose>

        </td>
      </tr>
    </table>
    <xsl:call-template name ="MicromoduleAP">
      <xsl:with-param name ="numCassoc" select ="$numCassoc"></xsl:with-param>
      <xsl:with-param name ="numMassoc" select ="$numMassoc"></xsl:with-param>
      <xsl:with-param name ="numSassoc" select ="$numSassoc"></xsl:with-param>
      <xsl:with-param name ="position" select ="$position + 1"></xsl:with-param>
      <xsl:with-param name ="indicMess" select ="$indicMess"></xsl:with-param>
      <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
    </xsl:call-template>
  </xsl:template>


  <!-- ***************************************** Micromodule AP ***********************************************************-->

  <xsl:template name="MicromoduleAP">
    <xsl:param name ="numCparticip"></xsl:param>
    <xsl:param name ="numMparticip"></xsl:param>
    <xsl:param name ="numSparticip"></xsl:param>
    <xsl:param name ="numCassoc"></xsl:param>
    <xsl:param name ="numMassoc"></xsl:param>
    <xsl:param name ="numSassoc"></xsl:param>
    <xsl:param name ="position"></xsl:param>
    <xsl:param name ="indicMess"></xsl:param>
    <xsl:param name ="Max"></xsl:param>

    <xsl:if test ="$position &lt; $Max">

      <xsl:for-each select="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position]">

        <xsl:variable name ="TypeMotCle" select ="MOTCLE"></xsl:variable>

        <xsl:choose>
          <xsl:when test ="($TypeMotCle = 'CPARTICP') and ($numCparticip = '1')">
            <xsl:call-template name ="libelleCPARTICP">
              <xsl:with-param name ="numCparticip" select ="$numCparticip"></xsl:with-param>
              <xsl:with-param name ="numMparticip" select ="$numMparticip"></xsl:with-param>
              <xsl:with-param name ="numSparticip" select ="$numSparticip"></xsl:with-param>
              <xsl:with-param name ="numCassoc" select ="$numCassoc"></xsl:with-param>
              <xsl:with-param name ="numMassoc" select ="$numMassoc"></xsl:with-param>
              <xsl:with-param name ="numSassoc" select ="$numSassoc"></xsl:with-param>
              <xsl:with-param name ="libelle" select ="$TypeMotCle"></xsl:with-param>
              <xsl:with-param name ="position" select ="$position"></xsl:with-param>
              <xsl:with-param name ="indicMess" select ="$indicMess"></xsl:with-param>
              <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
            </xsl:call-template>
          </xsl:when>

          <xsl:when test ="($TypeMotCle = 'MPARTICP') and ($numMparticip = '1')">
            <xsl:call-template name ="libelleMPARTICP">
              <xsl:with-param name ="numCparticip" select ="$numCparticip"></xsl:with-param>
              <xsl:with-param name ="numMparticip" select ="$numMparticip"></xsl:with-param>
              <xsl:with-param name ="numSparticip" select ="$numSparticip"></xsl:with-param>
              <xsl:with-param name ="numCassoc" select ="$numCassoc"></xsl:with-param>
              <xsl:with-param name ="numMassoc" select ="$numMassoc"></xsl:with-param>
              <xsl:with-param name ="numSassoc" select ="$numSassoc"></xsl:with-param>
              <xsl:with-param name ="libelle" select ="$TypeMotCle"></xsl:with-param>
              <xsl:with-param name ="position" select ="$position"></xsl:with-param>
              <xsl:with-param name ="indicMess" select ="$indicMess"></xsl:with-param>
              <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
            </xsl:call-template>
          </xsl:when>

          <xsl:when test ="($TypeMotCle = 'SPARTICP') and ($numSparticip = '1')">
            <xsl:call-template name ="libelleSPARTICP">
              <xsl:with-param name ="numCparticip" select ="$numCparticip"></xsl:with-param>
              <xsl:with-param name ="numMparticip" select ="$numMparticip"></xsl:with-param>
              <xsl:with-param name ="numSparticip" select ="$numSparticip"></xsl:with-param>
              <xsl:with-param name ="numCassoc" select ="$numCassoc"></xsl:with-param>
              <xsl:with-param name ="numMassoc" select ="$numMassoc"></xsl:with-param>
              <xsl:with-param name ="numSassoc" select ="$numSassoc"></xsl:with-param>
              <xsl:with-param name ="libelle" select ="$TypeMotCle"></xsl:with-param>
              <xsl:with-param name ="position" select ="$position"></xsl:with-param>
              <xsl:with-param name ="indicMess" select ="$indicMess"></xsl:with-param>
              <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
            </xsl:call-template>
          </xsl:when>

          <xsl:when test ="($TypeMotCle = 'CASSOC') and ($numCassoc = '1')">
            <xsl:call-template name ="libelleCASSOC">
              <xsl:with-param name ="numCassoc" select ="$numCassoc"></xsl:with-param>
              <xsl:with-param name ="numMassoc" select ="$numMassoc"></xsl:with-param>
              <xsl:with-param name ="numSassoc" select ="$numSassoc"></xsl:with-param>
              <xsl:with-param name ="libelle" select ="$TypeMotCle"></xsl:with-param>
              <xsl:with-param name ="position" select ="$position"></xsl:with-param>
              <xsl:with-param name ="indicMess" select ="$indicMess"></xsl:with-param>
              <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
            </xsl:call-template>
          </xsl:when>

          <xsl:when test ="($TypeMotCle = 'MASSOC') and ($numMassoc = '1')">
            <xsl:call-template name ="libelleMASSOC">
              <xsl:with-param name ="numCassoc" select ="$numCassoc"></xsl:with-param>
              <xsl:with-param name ="numMassoc" select ="$numMassoc"></xsl:with-param>
              <xsl:with-param name ="numSassoc" select ="$numSassoc"></xsl:with-param>
              <xsl:with-param name ="libelle" select ="$TypeMotCle"></xsl:with-param>
              <xsl:with-param name ="position" select ="$position"></xsl:with-param>
              <xsl:with-param name ="indicMess" select ="$indicMess"></xsl:with-param>
              <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
            </xsl:call-template>
          </xsl:when>

          <xsl:when test ="($TypeMotCle = 'SASSOC') and ($numSassoc = '1')">
            <xsl:call-template name ="libelleSASSOC">
              <xsl:with-param name ="numCassoc" select ="$numCassoc"></xsl:with-param>
              <xsl:with-param name ="numMassoc" select ="$numMassoc"></xsl:with-param>
              <xsl:with-param name ="numSassoc" select ="$numSassoc"></xsl:with-param>
              <xsl:with-param name ="libelle" select ="$TypeMotCle"></xsl:with-param>
              <xsl:with-param name ="position" select ="$position"></xsl:with-param>
              <xsl:with-param name ="indicMess" select ="$indicMess"></xsl:with-param>
              <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
            </xsl:call-template>
          </xsl:when>

          <xsl:when test ="($TypeMotCle = 'CLENOUV') or ($TypeMotCle = 'EFIN') or ($TypeMotCle = 'EIND') or ($TypeMotCle = 'ENTPURG') or ($TypeMotCle = 'IDNOUV') or ($TypeMotCle = 'METAT') or ($TypeMotCle = 'NONRES') or ($TypeMotCle = 'GPARTICP')">
            <xsl:call-template name ="AfficheLibValAP">
              <xsl:with-param name ="numCparticip" select ="$numCparticip"></xsl:with-param>
              <xsl:with-param name ="numMparticip" select ="$numMparticip"></xsl:with-param>
              <xsl:with-param name ="numSparticip" select ="$numSparticip"></xsl:with-param>
              <xsl:with-param name ="libelle" select ="$TypeMotCle"></xsl:with-param>
              <xsl:with-param name ="position" select ="$position"></xsl:with-param>
              <xsl:with-param name ="indicMess" select ="$indicMess"></xsl:with-param>
              <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
            </xsl:call-template>
          </xsl:when>

          <xsl:when test ="($TypeMotCle = 'GASSOC') or ($TypeMotCle = 'CCAPIT') or ($TypeMotCle = 'MCAPIT')  or ($TypeMotCle = 'SCAPIT')">
            <xsl:call-template name ="AfficheLibValASSOC">
              <xsl:with-param name ="numCassoc" select ="$numCassoc"></xsl:with-param>
              <xsl:with-param name ="numMassoc" select ="$numMassoc"></xsl:with-param>
              <xsl:with-param name ="numSassoc" select ="$numSassoc"></xsl:with-param>
              <xsl:with-param name ="libelle" select ="$TypeMotCle"></xsl:with-param>
              <xsl:with-param name ="position" select ="$position"></xsl:with-param>
              <xsl:with-param name ="indicMess" select ="$indicMess"></xsl:with-param>
              <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
            </xsl:call-template>
          </xsl:when>

          <xsl:otherwise>
            <xsl:if test ="($TypeMotCle = 'CPARTICP') or ($TypeMotCle = 'MPARTICP') or ($TypeMotCle = 'SPARTICP')">
              <xsl:call-template name ="AfficheValeurPARTICP">
                <xsl:with-param name ="numCparticip" select ="$numCparticip"></xsl:with-param>
                <xsl:with-param name ="numMparticip" select ="$numMparticip"></xsl:with-param>
                <xsl:with-param name ="numSparticip" select ="$numSparticip"></xsl:with-param>
                <xsl:with-param name ="numCassoc" select ="$numCassoc"></xsl:with-param>
                <xsl:with-param name ="numMassoc" select ="$numMassoc"></xsl:with-param>
                <xsl:with-param name ="numSassoc" select ="$numSassoc"></xsl:with-param>
                <xsl:with-param name ="libelle" select ="$TypeMotCle"></xsl:with-param>
                <xsl:with-param name ="position" select ="$position"></xsl:with-param>
                <xsl:with-param name ="indicMess" select ="$indicMess"></xsl:with-param>
                <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
              </xsl:call-template>
            </xsl:if>
            <xsl:if test ="($TypeMotCle = 'CASSOC') or ($TypeMotCle = 'MASSOC') or ($TypeMotCle = 'SASSOC')">
              <xsl:call-template name ="AfficheValeurASSOC">
                <xsl:with-param name ="numCparticip" select ="$numCparticip"></xsl:with-param>
                <xsl:with-param name ="numMparticip" select ="$numMparticip"></xsl:with-param>
                <xsl:with-param name ="numSparticip" select ="$numSparticip"></xsl:with-param>
                <xsl:with-param name ="numCassoc" select ="$numCassoc"></xsl:with-param>
                <xsl:with-param name ="numMassoc" select ="$numMassoc"></xsl:with-param>
                <xsl:with-param name ="numSassoc" select ="$numSassoc"></xsl:with-param>
                <xsl:with-param name ="libelle" select ="$TypeMotCle"></xsl:with-param>
                <xsl:with-param name ="position" select ="$position"></xsl:with-param>
                <xsl:with-param name ="indicMess" select ="$indicMess"></xsl:with-param>
                <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
              </xsl:call-template>
            </xsl:if>
          </xsl:otherwise>
        </xsl:choose>

      </xsl:for-each>

    </xsl:if>
    <xsl:if test ="($position = $Max) and ($indicMess = '1')">

      <table class="clWidthMax clBorderCell" role="presentation">
        <tr>
          <td class="clWidth10">&#160;</td>
          <td class="clWidth768">&#160;</td>
        </tr>
        <tr>
          <td class="clWidth10">&#160;</td>
          <td class="clWidth768">&#160;</td>
        </tr>
        <tr>
          <td class="clWidth10">&#160;</td>
          <td class="clTitre35 clWidth768">
            *Les associés dont la participation est inférieure à 10% n'apparaîtront pas dans le module 53.
          </td>
        </tr>
      </table>

    </xsl:if>
  </xsl:template>

  <!-- * * * * * * * * * * * * * * Les templates du template Micromodule AP * * * * * * * * * * * * * * * * * * * * * * * -->

  <xsl:template name="libelleCPARTICP">
    <xsl:param name ="numCparticip"></xsl:param>
    <xsl:param name ="numMparticip"></xsl:param>
    <xsl:param name ="numSparticip"></xsl:param>
    <xsl:param name ="numCassoc"></xsl:param>
    <xsl:param name ="numMassoc"></xsl:param>
    <xsl:param name ="numSassoc"></xsl:param>
    <xsl:param name ="libelle"></xsl:param>
    <xsl:param name ="position"></xsl:param>
    <xsl:param name ="indicMess"></xsl:param>
    <xsl:param name ="Max"></xsl:param>
    <xsl:if test ="($libelle = 'CPARTICP' and $numCparticip = '1')">
      <table class="clWidthMax clBorderCell" role="presentation">
        <tr>
          <td class="clWidth10 clHeight20">&#160;</td>
          <td class="clWidth768 clHeight20">&#160;</td>
        </tr>
        <tr>
          <td class="clWidth10">&#160;</td>
          <td class="clTexte clWidth768">
            <xsl:value-of select="($dictionnaire/mot[@id=$libelle])"/>&#160;
          </td>
        </tr>
        <tr>
          <td class="clWidth10 clHeight20">&#160;</td>
          <td class="clWidth768 clHeight20">&#160;</td>
        </tr>
      </table>

      <table class="clWidthMax clBorderCell" role="presentation">
        <tr>
          <td class="clWidth10">&#160;</td>
          <td class="clTexte clWidth130">
            <!-- l'identifiant -->
            <xsl:variable name ="valeur" select ="VALEUR"></xsl:variable>
            <xsl:value-of select ="concat(substring($valeur,1,3),' ',substring($valeur,4,3),' ',substring($valeur,7,3))"/>
          </td>
          <td class="clTexte clWidth638">
            <xsl:variable name ="PositionSuivante"  select ="$position + 1"></xsl:variable>
            <xsl:variable name ="NouedSuivant" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante]/VALEUR"></xsl:variable>
            <xsl:choose>
              <xsl:when test ="./CONVERT">
                <xsl:variable name ="valeur" select ="$NouedSuivant"></xsl:variable>
                <xsl:value-of select="($dictionnaire/mot[@id=$valeur])"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select ="$NouedSuivant"/>
              </xsl:otherwise>
            </xsl:choose>
          </td>
        </tr>
      </table>
      <xsl:call-template name ="MicromoduleAP">
        <xsl:with-param name ="numCparticip" select ="$numCparticip + 1"></xsl:with-param>
        <xsl:with-param name ="numMparticip" select ="$numMparticip"></xsl:with-param>
        <xsl:with-param name ="numSparticip" select ="$numSparticip"></xsl:with-param>
        <xsl:with-param name ="numCassoc" select ="$numCassoc"></xsl:with-param>
        <xsl:with-param name ="numMassoc" select ="$numMassoc"></xsl:with-param>
        <xsl:with-param name ="numSassoc" select ="$numSassoc"></xsl:with-param>
        <xsl:with-param name ="position" select ="$position + 2"></xsl:with-param>
        <xsl:with-param name ="indicMess" select ="1"></xsl:with-param>
        <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <xsl:template name="libelleMPARTICP">
    <xsl:param name ="numCparticip"></xsl:param>
    <xsl:param name ="numMparticip"></xsl:param>
    <xsl:param name ="numSparticip"></xsl:param>
    <xsl:param name ="numCassoc"></xsl:param>
    <xsl:param name ="numMassoc"></xsl:param>
    <xsl:param name ="numSassoc"></xsl:param>
    <xsl:param name ="libelle"></xsl:param>
    <xsl:param name ="position"></xsl:param>
    <xsl:param name ="indicMess"></xsl:param>
    <xsl:param name ="Max"></xsl:param>
    <xsl:if test ="($libelle = 'MPARTICP' and $numMparticip = '1')">
      <table class="clWidthMax clBorderCell" role="presentation">
        <tr>
          <td class="clWidth10 clHeight20">&#160;</td>
          <td class="clWidth768 clHeight20">&#160;</td>
        </tr>
        <tr>
          <td class="clWidth10">&#160;</td>
          <td class="clTexte clWidth768">
            <xsl:value-of select="($dictionnaire/mot[@id=$libelle])"/>&#160;
          </td>
        </tr>
        <tr>
          <td class="clWidth10 clHeight20">&#160;</td>
          <td class="clWidth768 clHeight20">&#160;</td>
        </tr>
      </table>
      <table class="clWidthMax clBorderCell" role="presentation">
        <tr>
          <td class="clWidth10">&#160;</td>
          <td class="clTexte clWidth130">
            <!-- l'identifiant -->
            <xsl:variable name ="valeur" select ="VALEUR"></xsl:variable>
            <xsl:value-of select ="concat(substring($valeur,1,3),' ',substring($valeur,4,3),' ',substring($valeur,7,3))"/>
          </td>
          <td class="clTexte clWidth638">
            <xsl:variable name ="PositionSuivante"  select ="$position + 1"></xsl:variable>
            <xsl:variable name ="NouedSuivant" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante]/VALEUR"></xsl:variable>
            <xsl:choose>
              <xsl:when test ="./CONVERT">
                <xsl:variable name ="valeur" select ="$NouedSuivant"></xsl:variable>
                <xsl:value-of select="($dictionnaire/mot[@id=$valeur])"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select ="$NouedSuivant"/>
              </xsl:otherwise>
            </xsl:choose>
          </td>
        </tr>
      </table>
      <xsl:call-template name ="MicromoduleAP">
        <xsl:with-param name ="numCparticip" select ="$numCparticip"></xsl:with-param>
        <xsl:with-param name ="numMparticip" select ="$numMparticip + 1"></xsl:with-param>
        <xsl:with-param name ="numSparticip" select ="$numSparticip"></xsl:with-param>
        <xsl:with-param name ="numCassoc" select ="$numCassoc"></xsl:with-param>
        <xsl:with-param name ="numMassoc" select ="$numMassoc"></xsl:with-param>
        <xsl:with-param name ="numSassoc" select ="$numSassoc"></xsl:with-param>
        <xsl:with-param name ="position" select ="$position + 2"></xsl:with-param>
        <xsl:with-param name ="indicMess" select ="1"></xsl:with-param>
        <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>


  <xsl:template name="libelleSPARTICP">
    <xsl:param name ="numCparticip"></xsl:param>
    <xsl:param name ="numMparticip"></xsl:param>
    <xsl:param name ="numSparticip"></xsl:param>
    <xsl:param name ="numCassoc"></xsl:param>
    <xsl:param name ="numMassoc"></xsl:param>
    <xsl:param name ="numSassoc"></xsl:param>
    <xsl:param name ="libelle"></xsl:param>
    <xsl:param name ="position"></xsl:param>
    <xsl:param name ="indicMess"></xsl:param>
    <xsl:param name ="Max"></xsl:param>
    <xsl:if test ="($libelle = 'SPARTICP' and $numSparticip = '1')">
      <table class="clWidthMax clBorderCell" role="presentation">
        <tr>
          <td class="clWidth10 clHeight20">&#160;</td>
          <td class="clWidth768 clHeight20">&#160;</td>
        </tr>
        <tr>
          <td class="clWidth10">&#160;</td>
          <td class="clTexte clWidth768">
            <xsl:value-of select="($dictionnaire/mot[@id=$libelle])"/>&#160;
          </td>
        </tr>
        <tr>
          <td class="clWidth10 clHeight20">&#160;</td>
          <td class="clWidth768 clHeight20">&#160;</td>
        </tr>
      </table>
      <table class="clWidthMax clBorderCell" role="presentation">
        <tr>
          <td class="clWidth10">&#160;</td>
          <td class="clTexte clWidth130">
            <!-- l'identifiant -->
            <xsl:variable name ="valeur" select ="VALEUR"></xsl:variable>
            <xsl:value-of select ="concat(substring($valeur,1,3),' ',substring($valeur,4,3),' ',substring($valeur,7,3))"/>
          </td>
          <td class="clTexte clWidth638">
            <xsl:variable name ="PositionSuivante"  select ="$position + 1"></xsl:variable>
            <xsl:variable name ="NouedSuivant" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante]/VALEUR"></xsl:variable>
            <xsl:choose>
              <xsl:when test ="./CONVERT">
                <xsl:variable name ="valeur" select ="$NouedSuivant"></xsl:variable>
                <xsl:value-of select="($dictionnaire/mot[@id=$valeur])"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select ="$NouedSuivant"/>
              </xsl:otherwise>
            </xsl:choose>
          </td>
        </tr>
      </table>
      <xsl:call-template name ="MicromoduleAP">
        <xsl:with-param name ="numCparticip" select ="$numCparticip"></xsl:with-param>
        <xsl:with-param name ="numMparticip" select ="$numMparticip"></xsl:with-param>
        <xsl:with-param name ="numSparticip" select ="$numSparticip + 1"></xsl:with-param>
        <xsl:with-param name ="numCassoc" select ="$numCassoc"></xsl:with-param>
        <xsl:with-param name ="numMassoc" select ="$numMassoc"></xsl:with-param>
        <xsl:with-param name ="numSassoc" select ="$numSassoc"></xsl:with-param>
        <xsl:with-param name ="position" select ="$position + 2"></xsl:with-param>
        <xsl:with-param name ="indicMess" select ="1"></xsl:with-param>
        <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <xsl:template name="AfficheValeurPARTICP">
    <xsl:param name ="numCparticip"></xsl:param>
    <xsl:param name ="numMparticip"></xsl:param>
    <xsl:param name ="numSparticip"></xsl:param>
    <xsl:param name ="numCassoc"></xsl:param>
    <xsl:param name ="numMassoc"></xsl:param>
    <xsl:param name ="numSassoc"></xsl:param>
    <xsl:param name ="libelle"></xsl:param>
    <xsl:param name ="position"></xsl:param>
    <xsl:param name ="indicMess"></xsl:param>
    <xsl:param name ="Max"></xsl:param>
    <table class="clWidthMax clBorderCell" role="presentation">
      <tr>
        <td class="clWidth10">&#160;</td>
        <td class="clTexte clWidth130">
          <!-- l'identifiant -->
          <xsl:variable name ="valeur" select ="VALEUR"></xsl:variable>
          <xsl:value-of select ="concat(substring($valeur,1,3),' ',substring($valeur,4,3),' ',substring($valeur,7,3))"/>
        </td>
        <td class="clTexte clWidth638">
          <xsl:variable name ="PositionSuivante"  select ="$position + 1"></xsl:variable>
          <xsl:variable name ="NouedSuivant" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante]/VALEUR"></xsl:variable>
          <xsl:choose>
            <xsl:when test ="./CONVERT">
              <xsl:variable name ="valeur" select ="$NouedSuivant"></xsl:variable>
              <xsl:value-of select="($dictionnaire/mot[@id=$valeur])"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select ="$NouedSuivant"/>
            </xsl:otherwise>
          </xsl:choose>
        </td>
      </tr>
    </table>

    <xsl:call-template name ="MicromoduleAP">
      <xsl:with-param name ="numCparticip" select ="$numCparticip"></xsl:with-param>
      <xsl:with-param name ="numMparticip" select ="$numMparticip"></xsl:with-param>
      <xsl:with-param name ="numSparticip" select ="$numSparticip"></xsl:with-param>
      <xsl:with-param name ="numCassoc" select ="$numCassoc"></xsl:with-param>
      <xsl:with-param name ="numMassoc" select ="$numMassoc"></xsl:with-param>
      <xsl:with-param name ="numSassoc" select ="$numSassoc"></xsl:with-param>
      <xsl:with-param name ="position" select ="$position + 2"></xsl:with-param>
      <xsl:with-param name ="indicMess" select ="$indicMess"></xsl:with-param>
      <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
    </xsl:call-template>
  </xsl:template>

  <!-- template de construction d'un message sur une ligne (mot-cle + valeur) -->


  <xsl:template name="AfficheLibValAP">
    <xsl:param name ="numCparticip"></xsl:param>
    <xsl:param name ="numMparticip"></xsl:param>
    <xsl:param name ="numSparticip"></xsl:param>
    <xsl:param name ="numCassoc"></xsl:param>
    <xsl:param name ="numMassoc"></xsl:param>
    <xsl:param name ="numSassoc"></xsl:param>
    <xsl:param name ="libelle"></xsl:param>
    <xsl:param name ="position"></xsl:param>
    <xsl:param name ="indicMess"></xsl:param>
    <xsl:param name ="Max"></xsl:param>
    <table class="clWidthMax clBorderCell" role="presentation">
      <tr>
        <td class="clWidth10 clHeight20">&#160;</td>
        <td class="clWidth768 clHeight20">&#160;</td>
      </tr>
      <tr>
        <td class="clWidth10">&#160;</td>
        <td class="clTexte clWidth768">
          <xsl:value-of select="($dictionnaire/mot[@id=$libelle])"/>&#160;
          <xsl:choose>
            <xsl:when test ="./CONVERT">
              <xsl:variable name ="valeur" select ="VALEUR"></xsl:variable>
              <xsl:value-of select="($dictionnaire/mot[@id=$valeur])"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select ="VALEUR"/>
            </xsl:otherwise>
          </xsl:choose>
        </td>
      </tr>
    </table>
    <xsl:call-template name ="MicromoduleAP">
      <xsl:with-param name ="numCparticip" select ="$numCparticip"></xsl:with-param>
      <xsl:with-param name ="numMparticip" select ="$numMparticip"></xsl:with-param>
      <xsl:with-param name ="numSparticip" select ="$numSparticip"></xsl:with-param>
      <xsl:with-param name ="numCassoc" select ="$numCassoc"></xsl:with-param>
      <xsl:with-param name ="numMassoc" select ="$numMassoc"></xsl:with-param>
      <xsl:with-param name ="numSassoc" select ="$numSassoc"></xsl:with-param>
      <xsl:with-param name ="position" select ="$position + 1"></xsl:with-param>
      <xsl:with-param name ="indicMess" select ="$indicMess"></xsl:with-param>
      <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
    </xsl:call-template>
  </xsl:template>

  <!-- ***************************************** Micromodule AJ ***********************************************************-->

  <xsl:template name="MicromoduleAJ">
    <xsl:param name ="numCcodejug"></xsl:param>
    <xsl:param name ="numMcodejug"></xsl:param>
    <xsl:param name ="numScodejug"></xsl:param>
    <xsl:param name ="numCcodevmt"></xsl:param>
    <xsl:param name ="numMcodevmt"></xsl:param>
    <xsl:param name ="numScodevmt"></xsl:param>
    <xsl:param name ="position"></xsl:param>
    <xsl:param name ="Max"></xsl:param>

    <xsl:if test ="$position &lt; $Max">

      <xsl:for-each select="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position]">

        <xsl:variable name ="TypeCode" select ="MOTCLE"></xsl:variable>

        <xsl:choose>
          <xsl:when test ="($TypeCode = 'CCODEJUG') and ($numCcodejug = '1')">
            <xsl:call-template name ="libelleCCODEJUG">
              <xsl:with-param name ="numCcodejug" select ="$numCcodejug"></xsl:with-param>
              <xsl:with-param name ="numMcodejug" select ="$numMcodejug"></xsl:with-param>
              <xsl:with-param name ="numScodejug" select ="$numScodejug"></xsl:with-param>
              <xsl:with-param name ="numCcodevmt" select ="$numCcodevmt"></xsl:with-param>
              <xsl:with-param name ="numMcodevmt" select ="$numMcodevmt"></xsl:with-param>
              <xsl:with-param name ="numScodevmt" select ="$numScodevmt"></xsl:with-param>
              <xsl:with-param name ="libelle" select ="$TypeCode"></xsl:with-param>
              <xsl:with-param name ="position" select ="$position"></xsl:with-param>
              <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
            </xsl:call-template>
          </xsl:when>

          <xsl:when test ="($TypeCode = 'MCODEJUG') and ($numMcodejug = '1')">
            <xsl:call-template name ="libelleMCODEJUG">
              <xsl:with-param name ="numCcodejug" select ="$numCcodejug"></xsl:with-param>
              <xsl:with-param name ="numMcodejug" select ="$numMcodejug"></xsl:with-param>
              <xsl:with-param name ="numScodejug" select ="$numScodejug"></xsl:with-param>
              <xsl:with-param name ="numCcodevmt" select ="$numCcodevmt"></xsl:with-param>
              <xsl:with-param name ="numMcodevmt" select ="$numMcodevmt"></xsl:with-param>
              <xsl:with-param name ="numScodevmt" select ="$numScodevmt"></xsl:with-param>
              <xsl:with-param name ="libelle" select ="$TypeCode"></xsl:with-param>
              <xsl:with-param name ="position" select ="$position"></xsl:with-param>
              <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
            </xsl:call-template>
          </xsl:when>

          <xsl:when test ="($TypeCode = 'SCODEJUG') and ($numScodejug = '1')">
            <xsl:call-template name ="libelleSCODEJUG">
              <xsl:with-param name ="numCcodejug" select ="$numCcodejug"></xsl:with-param>
              <xsl:with-param name ="numMcodejug" select ="$numMcodejug"></xsl:with-param>
              <xsl:with-param name ="numScodejug" select ="$numScodejug"></xsl:with-param>
              <xsl:with-param name ="numCcodevmt" select ="$numCcodevmt"></xsl:with-param>
              <xsl:with-param name ="numMcodevmt" select ="$numMcodevmt"></xsl:with-param>
              <xsl:with-param name ="numScodevmt" select ="$numScodevmt"></xsl:with-param>
              <xsl:with-param name ="libelle" select ="$TypeCode"></xsl:with-param>
              <xsl:with-param name ="position" select ="$position"></xsl:with-param>
              <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
            </xsl:call-template>
          </xsl:when>

          <xsl:when test ="($TypeCode = 'CCODEVMT') and ($numCcodevmt = '1')">
            <xsl:call-template name ="libelleCCODEVMT">
              <xsl:with-param name ="numCcodejug" select ="$numCcodejug"></xsl:with-param>
              <xsl:with-param name ="numMcodejug" select ="$numMcodejug"></xsl:with-param>
              <xsl:with-param name ="numScodejug" select ="$numScodejug"></xsl:with-param>
              <xsl:with-param name ="numCcodevmt" select ="$numCcodevmt"></xsl:with-param>
              <xsl:with-param name ="numMcodevmt" select ="$numMcodevmt"></xsl:with-param>
              <xsl:with-param name ="numScodevmt" select ="$numScodevmt"></xsl:with-param>
              <xsl:with-param name ="libelle" select ="$TypeCode"></xsl:with-param>
              <xsl:with-param name ="position" select ="$position"></xsl:with-param>
              <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
            </xsl:call-template>
          </xsl:when>

          <xsl:when test ="($TypeCode = 'MCODEVMT') and ($numMcodevmt = '1')">
            <xsl:call-template name ="libelleMCODEVMT">
              <xsl:with-param name ="numCcodejug" select ="$numCcodejug"></xsl:with-param>
              <xsl:with-param name ="numMcodejug" select ="$numMcodejug"></xsl:with-param>
              <xsl:with-param name ="numScodejug" select ="$numScodejug"></xsl:with-param>
              <xsl:with-param name ="numCcodevmt" select ="$numCcodevmt"></xsl:with-param>
              <xsl:with-param name ="numMcodevmt" select ="$numMcodevmt"></xsl:with-param>
              <xsl:with-param name ="numScodevmt" select ="$numScodevmt"></xsl:with-param>
              <xsl:with-param name ="libelle" select ="$TypeCode"></xsl:with-param>
              <xsl:with-param name ="position" select ="$position"></xsl:with-param>
              <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
            </xsl:call-template>
          </xsl:when>

          <xsl:when test ="($TypeCode = 'SCODEVMT') and ($numScodevmt = '1')">
            <xsl:call-template name ="libelleSCODEVMT">
              <xsl:with-param name ="numCcodejug" select ="$numCcodejug"></xsl:with-param>
              <xsl:with-param name ="numMcodejug" select ="$numMcodejug"></xsl:with-param>
              <xsl:with-param name ="numScodejug" select ="$numScodejug"></xsl:with-param>
              <xsl:with-param name ="numCcodevmt" select ="$numCcodevmt"></xsl:with-param>
              <xsl:with-param name ="numMcodevmt" select ="$numMcodevmt"></xsl:with-param>
              <xsl:with-param name ="numScodevmt" select ="$numScodevmt"></xsl:with-param>
              <xsl:with-param name ="libelle" select ="$TypeCode"></xsl:with-param>
              <xsl:with-param name ="position" select ="$position"></xsl:with-param>
              <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
            </xsl:call-template>
          </xsl:when>


          <xsl:when test ="($TypeCode = 'CLENOUV') or ($TypeCode = 'EFIN') or ($TypeCode = 'ENTPURG') or ($TypeCode = 'IDNOUV') or ($TypeCode = 'METAT') or ($TypeCode = 'NONRES') or ($TypeCode = 'GCODEJUG') or ($TypeCode = 'GCODEVMT')">
            <xsl:call-template name ="AfficheLibValAJ">
              <xsl:with-param name ="numCcodejug" select ="$numCcodejug"></xsl:with-param>
              <xsl:with-param name ="numMcodejug" select ="$numMcodejug"></xsl:with-param>
              <xsl:with-param name ="numScodejug" select ="$numScodejug"></xsl:with-param>
              <xsl:with-param name ="numCcodevmt" select ="$numCcodevmt"></xsl:with-param>
              <xsl:with-param name ="numMcodevmt" select ="$numMcodevmt"></xsl:with-param>
              <xsl:with-param name ="numScodevmt" select ="$numScodevmt"></xsl:with-param>
              <xsl:with-param name ="libelle" select ="$TypeCode"></xsl:with-param>
              <xsl:with-param name ="position" select ="$position"></xsl:with-param>
              <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
            </xsl:call-template>
          </xsl:when>

          <xsl:otherwise>
            <xsl:call-template name ="AfficheValeurAJ">
              <xsl:with-param name ="numCcodejug" select ="$numCcodejug"></xsl:with-param>
              <xsl:with-param name ="numMcodejug" select ="$numMcodejug"></xsl:with-param>
              <xsl:with-param name ="numScodejug" select ="$numScodejug"></xsl:with-param>
              <xsl:with-param name ="numCcodevmt" select ="$numCcodevmt"></xsl:with-param>
              <xsl:with-param name ="numMcodevmt" select ="$numMcodevmt"></xsl:with-param>
              <xsl:with-param name ="numScodevmt" select ="$numScodevmt"></xsl:with-param>
              <xsl:with-param name ="libelle" select ="$TypeCode"></xsl:with-param>
              <xsl:with-param name ="position" select ="$position"></xsl:with-param>
              <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
            </xsl:call-template>
          </xsl:otherwise>
        </xsl:choose>

      </xsl:for-each>
    </xsl:if>
  </xsl:template>

  <!-- * * * * * * * * * * * * * * Les templates du template Micromodule AJ * * * * * * * * * * * * * * * * * * * * * * * -->

  <xsl:template name="libelleCCODEJUG">
    <xsl:param name ="numCcodejug"></xsl:param>
    <xsl:param name ="numMcodejug"></xsl:param>
    <xsl:param name ="numScodejug"></xsl:param>
    <xsl:param name ="numCcodevmt"></xsl:param>
    <xsl:param name ="numMcodevmt"></xsl:param>
    <xsl:param name ="numScodevmt"></xsl:param>
    <xsl:param name ="libelle"></xsl:param>
    <xsl:param name ="position"></xsl:param>
    <xsl:param name ="Max"></xsl:param>

    <table class="clWidthMax clBorderCell" role="presentation">
      <tr>
        <td class="clWidth10 clHeight20">&#160;</td>
        <td class="clWidth768 clHeight20">&#160;</td>
      </tr>
      <tr>
        <td class="clWidth10">&#160;</td>
        <td class="clTexte clWidth768">
          <xsl:value-of select="($dictionnaire/mot[@id=$libelle])"/>&#160;
        </td>
      </tr>
      <tr>
        <td class="clWidth10 clHeight20">&#160;</td>
        <td class="clWidth768 clHeight20">&#160;</td>
      </tr>
    </table>

    <table class="clWidthMax clBorderCell" role="presentation">
      <tr>
        <td class="clWidth10">&#160;</td>
        <td class="clTexte clWidth768">
          <xsl:choose>
            <xsl:when test ="./CONVERT">
              <xsl:variable name ="valeur" select ="VALEUR"></xsl:variable>
              <xsl:value-of select="($dictionnaire/mot[@id=$valeur])"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select ="VALEUR"/>
            </xsl:otherwise>
          </xsl:choose>
        </td>
      </tr>
    </table>
    <xsl:call-template name ="MicromoduleAJ">
      <xsl:with-param name ="numCcodejug" select ="$numCcodejug + 1"></xsl:with-param>
      <xsl:with-param name ="numMcodejug" select ="$numMcodejug"></xsl:with-param>
      <xsl:with-param name ="numScodejug" select ="$numScodejug"></xsl:with-param>
      <xsl:with-param name ="numCcodevmt" select ="$numCcodevmt"></xsl:with-param>
      <xsl:with-param name ="numMcodevmt" select ="$numMcodevmt"></xsl:with-param>
      <xsl:with-param name ="numScodevmt" select ="$numScodevmt"></xsl:with-param>
      <xsl:with-param name ="position" select ="$position + 1"></xsl:with-param>
      <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
    </xsl:call-template>

  </xsl:template>

  <xsl:template name="libelleMCODEJUG">
    <xsl:param name ="numCcodejug"></xsl:param>
    <xsl:param name ="numMcodejug"></xsl:param>
    <xsl:param name ="numScodejug"></xsl:param>
    <xsl:param name ="numCcodevmt"></xsl:param>
    <xsl:param name ="numMcodevmt"></xsl:param>
    <xsl:param name ="numScodevmt"></xsl:param>
    <xsl:param name ="libelle"></xsl:param>
    <xsl:param name ="position"></xsl:param>
    <xsl:param name ="Max"></xsl:param>

    <table class="clWidthMax clBorderCell" role="presentation">
      <tr>
        <td class="clWidth10 clHeight20">&#160;</td>
        <td class="clWidth768 clHeight20">&#160;</td>
      </tr>
      <tr>
        <td class="clWidth10">&#160;</td>
        <td class="clTexte clWidth768">
          <xsl:value-of select="($dictionnaire/mot[@id=$libelle])"/>&#160;
        </td>
      </tr>
      <tr>
        <td class="clWidth10 clHeight20">&#160;</td>
        <td class="clWidth768 clHeight20">&#160;</td>
      </tr>
    </table>

    <table class="clWidthMax clBorderCell" role="presentation">
      <tr>
        <td class="clWidth10">&#160;</td>
        <td class="clTexte clWidth768">
          <xsl:choose>
            <xsl:when test ="./CONVERT">
              <xsl:variable name ="valeur" select ="VALEUR"></xsl:variable>
              <xsl:value-of select="($dictionnaire/mot[@id=$valeur])"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select ="VALEUR"/>
            </xsl:otherwise>
          </xsl:choose>
        </td>
      </tr>
    </table>
    <xsl:call-template name ="MicromoduleAJ">
      <xsl:with-param name ="numCcodejug" select ="$numCcodejug"></xsl:with-param>
      <xsl:with-param name ="numMcodejug" select ="$numMcodejug + 1"></xsl:with-param>
      <xsl:with-param name ="numScodejug" select ="$numScodejug"></xsl:with-param>
      <xsl:with-param name ="numCcodevmt" select ="$numCcodevmt"></xsl:with-param>
      <xsl:with-param name ="numMcodevmt" select ="$numMcodevmt"></xsl:with-param>
      <xsl:with-param name ="numScodevmt" select ="$numScodevmt"></xsl:with-param>
      <xsl:with-param name ="position" select ="$position + 1"></xsl:with-param>
      <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
    </xsl:call-template>

  </xsl:template>

  <xsl:template name="libelleSCODEJUG">
    <xsl:param name ="numCcodejug"></xsl:param>
    <xsl:param name ="numMcodejug"></xsl:param>
    <xsl:param name ="numScodejug"></xsl:param>
    <xsl:param name ="numCcodevmt"></xsl:param>
    <xsl:param name ="numMcodevmt"></xsl:param>
    <xsl:param name ="numScodevmt"></xsl:param>
    <xsl:param name ="libelle"></xsl:param>
    <xsl:param name ="position"></xsl:param>
    <xsl:param name ="Max"></xsl:param>

    <table class="clWidthMax clBorderCell" role="presentation">
      <tr>
        <td class="clWidth10 clHeight20">&#160;</td>
        <td class="clWidth768 clHeight20">&#160;</td>
      </tr>
      <tr>
        <td class="clWidth10">&#160;</td>
        <td class="clTexte clWidth768">
          <xsl:value-of select="($dictionnaire/mot[@id=$libelle])"/>&#160;
        </td>
      </tr>
      <tr>
        <td class="clWidth10 clHeight20">&#160;</td>
        <td class="clWidth768 clHeight20">&#160;</td>
      </tr>
    </table>

    <table class="clWidthMax clBorderCell" role="presentation">
      <tr>
        <td class="clWidth10">&#160;</td>
        <td class="clTexte clWidth768">
          <xsl:choose>
            <xsl:when test ="./CONVERT">
              <xsl:variable name ="valeur" select ="VALEUR"></xsl:variable>
              <xsl:value-of select="($dictionnaire/mot[@id=$valeur])"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select ="VALEUR"/>
            </xsl:otherwise>
          </xsl:choose>
        </td>
      </tr>
    </table>
    <xsl:call-template name ="MicromoduleAJ">
      <xsl:with-param name ="numCcodejug" select ="$numCcodejug"></xsl:with-param>
      <xsl:with-param name ="numMcodejug" select ="$numMcodejug"></xsl:with-param>
      <xsl:with-param name ="numScodejug" select ="$numScodejug + 1"></xsl:with-param>
      <xsl:with-param name ="numCcodevmt" select ="$numCcodevmt"></xsl:with-param>
      <xsl:with-param name ="numMcodevmt" select ="$numMcodevmt"></xsl:with-param>
      <xsl:with-param name ="numScodevmt" select ="$numScodevmt"></xsl:with-param>
      <xsl:with-param name ="position" select ="$position + 1"></xsl:with-param>
      <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
    </xsl:call-template>

  </xsl:template>

  <xsl:template name="libelleCCODEVMT">
    <xsl:param name ="numCcodejug"></xsl:param>
    <xsl:param name ="numMcodejug"></xsl:param>
    <xsl:param name ="numScodejug"></xsl:param>
    <xsl:param name ="numCcodevmt"></xsl:param>
    <xsl:param name ="numMcodevmt"></xsl:param>
    <xsl:param name ="numScodevmt"></xsl:param>
    <xsl:param name ="libelle"></xsl:param>
    <xsl:param name ="position"></xsl:param>
    <xsl:param name ="Max"></xsl:param>

    <table class="clWidthMax clBorderCell" role="presentation">
      <tr>
        <td class="clWidth10 clHeight20">&#160;</td>
        <td class="clWidth768 clHeight20">&#160;</td>
      </tr>
      <tr>
        <td class="clWidth10">&#160;</td>
        <td class="clTexte clWidth768">
          <xsl:value-of select="($dictionnaire/mot[@id=$libelle])"/>&#160;
        </td>
      </tr>
      <tr>
        <td class="clWidth10 clHeight20">&#160;</td>
        <td class="clWidth768 clHeight20">&#160;</td>
      </tr>
    </table>

    <table class="clWidthMax clBorderCell" role="presentation">
      <tr>
        <td class="clWidth10">&#160;</td>
        <td class="clTexte clWidth768">
          <xsl:choose>
            <xsl:when test ="./CONVERT">
              <xsl:variable name ="valeur" select ="VALEUR"></xsl:variable>
              <xsl:value-of select="($dictionnaire/mot[@id=$valeur])"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select ="VALEUR"/>
            </xsl:otherwise>
          </xsl:choose>
        </td>
      </tr>
    </table>
    <xsl:call-template name ="MicromoduleAJ">
      <xsl:with-param name ="numCcodejug" select ="$numCcodejug"></xsl:with-param>
      <xsl:with-param name ="numMcodejug" select ="$numMcodejug"></xsl:with-param>
      <xsl:with-param name ="numScodejug" select ="$numScodejug"></xsl:with-param>
      <xsl:with-param name ="numCcodevmt" select ="$numCcodevmt + 1"></xsl:with-param>
      <xsl:with-param name ="numMcodevmt" select ="$numMcodevmt"></xsl:with-param>
      <xsl:with-param name ="numScodevmt" select ="$numScodevmt"></xsl:with-param>
      <xsl:with-param name ="position" select ="$position + 1"></xsl:with-param>
      <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
    </xsl:call-template>

  </xsl:template>

  <xsl:template name="libelleMCODEVMT">
    <xsl:param name ="numCcodejug"></xsl:param>
    <xsl:param name ="numMcodejug"></xsl:param>
    <xsl:param name ="numScodejug"></xsl:param>
    <xsl:param name ="numCcodevmt"></xsl:param>
    <xsl:param name ="numMcodevmt"></xsl:param>
    <xsl:param name ="numScodevmt"></xsl:param>
    <xsl:param name ="libelle"></xsl:param>
    <xsl:param name ="position"></xsl:param>
    <xsl:param name ="Max"></xsl:param>

    <table class="clWidthMax clBorderCell" role="presentation">
      <tr>
        <td class="clWidth10 clHeight20">&#160;</td>
        <td class="clWidth768 clHeight20">&#160;</td>
      </tr>
      <tr>
        <td class="clWidth10">&#160;</td>
        <td class="clTexte clWidth768">
          <xsl:value-of select="($dictionnaire/mot[@id=$libelle])"/>&#160;
        </td>
      </tr>
      <tr>
        <td class="clWidth10 clHeight20">&#160;</td>
        <td class="clWidth768 clHeight20">&#160;</td>
      </tr>
    </table>

    <table class="clWidthMax clBorderCell" role="presentation">
      <tr>
        <td class="clWidth10">&#160;</td>
        <td class="clTexte clWidth768">
          <xsl:choose>
            <xsl:when test ="./CONVERT">
              <xsl:variable name ="valeur" select ="VALEUR"></xsl:variable>
              <xsl:value-of select="($dictionnaire/mot[@id=$valeur])"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select ="VALEUR"/>
            </xsl:otherwise>
          </xsl:choose>
        </td>
      </tr>
    </table>
    <xsl:call-template name ="MicromoduleAJ">
      <xsl:with-param name ="numCcodejug" select ="$numCcodejug"></xsl:with-param>
      <xsl:with-param name ="numMcodejug" select ="$numMcodejug"></xsl:with-param>
      <xsl:with-param name ="numScodejug" select ="$numScodejug"></xsl:with-param>
      <xsl:with-param name ="numCcodevmt" select ="$numCcodevmt"></xsl:with-param>
      <xsl:with-param name ="numMcodevmt" select ="$numMcodevmt + 1"></xsl:with-param>
      <xsl:with-param name ="numScodevmt" select ="$numScodevmt"></xsl:with-param>
      <xsl:with-param name ="position" select ="$position + 1"></xsl:with-param>
      <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
    </xsl:call-template>

  </xsl:template>

  <xsl:template name="libelleSCODEVMT">
    <xsl:param name ="numCcodejug"></xsl:param>
    <xsl:param name ="numMcodejug"></xsl:param>
    <xsl:param name ="numScodejug"></xsl:param>
    <xsl:param name ="numCcodevmt"></xsl:param>
    <xsl:param name ="numMcodevmt"></xsl:param>
    <xsl:param name ="numScodevmt"></xsl:param>
    <xsl:param name ="libelle"></xsl:param>
    <xsl:param name ="position"></xsl:param>
    <xsl:param name ="Max"></xsl:param>

    <table class="clWidthMax clBorderCell" role="presentation">
      <tr>
        <td class="clWidth10 clHeight20">&#160;</td>
        <td class="clWidth768 clHeight20">&#160;</td>
      </tr>
      <tr>
        <td class="clWidth10">&#160;</td>
        <td class="clTexte clWidth768">
          <xsl:value-of select="($dictionnaire/mot[@id=$libelle])"/>&#160;
        </td>
      </tr>
      <tr>
        <td class="clWidth10 clHeight20">&#160;</td>
        <td class="clWidth768 clHeight20">&#160;</td>
      </tr>
    </table>

    <table class="clWidthMax clBorderCell" role="presentation">
      <tr>
        <td class="clWidth10">&#160;</td>
        <td class="clTexte clWidth768">
          <xsl:choose>
            <xsl:when test ="./CONVERT">
              <xsl:variable name ="valeur" select ="VALEUR"></xsl:variable>
              <xsl:value-of select="($dictionnaire/mot[@id=$valeur])"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select ="VALEUR"/>
            </xsl:otherwise>
          </xsl:choose>
        </td>
      </tr>
    </table>
    <xsl:call-template name ="MicromoduleAJ">
      <xsl:with-param name ="numCcodejug" select ="$numCcodejug"></xsl:with-param>
      <xsl:with-param name ="numMcodejug" select ="$numMcodejug"></xsl:with-param>
      <xsl:with-param name ="numScodejug" select ="$numScodejug"></xsl:with-param>
      <xsl:with-param name ="numCcodevmt" select ="$numCcodevmt"></xsl:with-param>
      <xsl:with-param name ="numMcodevmt" select ="$numMcodevmt"></xsl:with-param>
      <xsl:with-param name ="numScodevmt" select ="$numScodevmt + 1"></xsl:with-param>
      <xsl:with-param name ="position" select ="$position + 1"></xsl:with-param>
      <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
    </xsl:call-template>

  </xsl:template>

  <xsl:template name="AfficheValeurAJ">
    <xsl:param name ="numCcodejug"></xsl:param>
    <xsl:param name ="numMcodejug"></xsl:param>
    <xsl:param name ="numScodejug"></xsl:param>
    <xsl:param name ="numCcodevmt"></xsl:param>
    <xsl:param name ="numMcodevmt"></xsl:param>
    <xsl:param name ="numScodevmt"></xsl:param>
    <xsl:param name ="libelle"></xsl:param>
    <xsl:param name ="position"></xsl:param>
    <xsl:param name ="Max"></xsl:param>

    <table class="clWidthMax clBorderCell" role="presentation">
      <tr>
        <td class="clWidth10">&#160;</td>
        <td class="clTexte clWidth768">
          <xsl:choose>
            <xsl:when test ="./CONVERT">
              <xsl:variable name ="valeur" select ="VALEUR"></xsl:variable>
              <xsl:value-of select="($dictionnaire/mot[@id=$valeur])"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select ="VALEUR"/>
            </xsl:otherwise>
          </xsl:choose>
        </td>
      </tr>
    </table>

    <xsl:call-template name ="MicromoduleAJ">
      <xsl:with-param name ="numCcodejug" select ="$numCcodejug"></xsl:with-param>
      <xsl:with-param name ="numMcodejug" select ="$numMcodejug"></xsl:with-param>
      <xsl:with-param name ="numScodejug" select ="$numScodejug"></xsl:with-param>
      <xsl:with-param name ="numCcodevmt" select ="$numCcodevmt"></xsl:with-param>
      <xsl:with-param name ="numMcodevmt" select ="$numMcodevmt"></xsl:with-param>
      <xsl:with-param name ="numScodevmt" select ="$numScodevmt"></xsl:with-param>
      <xsl:with-param name ="position" select ="$position + 1"></xsl:with-param>
      <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
    </xsl:call-template>
  </xsl:template>

  <!-- template de construction d'un message sur une ligne (mot-cle + valeur)
  mise à 0 du nombre Max pour ne pas afficher message en bas de page-->

  <xsl:template name="AfficheLibValAJ">
    <xsl:param name ="numCcodejug"></xsl:param>
    <xsl:param name ="numMcodejug"></xsl:param>
    <xsl:param name ="numScodejug"></xsl:param>
    <xsl:param name ="numCcodevmt"></xsl:param>
    <xsl:param name ="numMcodevmt"></xsl:param>
    <xsl:param name ="numScodevmt"></xsl:param>
    <xsl:param name ="libelle"></xsl:param>
    <xsl:param name ="position"></xsl:param>
    <xsl:param name ="Max"></xsl:param>
    <table class="clWidthMax clBorderCell" role="presentation">
      <tr>
        <td class="clWidth10 clHeight20">&#160;</td>
        <td class="clWidth768 clHeight20">&#160;</td>
      </tr>
      <tr>
        <td class="clWidth10">&#160;</td>
        <td class="clTexte clWidth768">
          <xsl:value-of select="($dictionnaire/mot[@id=$libelle])"/>&#160;
          <xsl:choose>
            <xsl:when test ="./CONVERT">
              <xsl:variable name ="valeur" select ="VALEUR"></xsl:variable>
              <xsl:value-of select="($dictionnaire/mot[@id=$valeur])"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select ="VALEUR"/>
            </xsl:otherwise>
          </xsl:choose>
        </td>
      </tr>
    </table>
    <xsl:call-template name ="MicromoduleAJ">
      <xsl:with-param name ="numCcodejug" select ="$numCcodejug"></xsl:with-param>
      <xsl:with-param name ="numMcodejug" select ="$numMcodejug"></xsl:with-param>
      <xsl:with-param name ="numScodejug" select ="$numScodejug"></xsl:with-param>
      <xsl:with-param name ="numCcodevmt" select ="$numCcodevmt"></xsl:with-param>
      <xsl:with-param name ="numMcodevmt" select ="$numMcodevmt"></xsl:with-param>
      <xsl:with-param name ="numScodevmt" select ="$numScodevmt"></xsl:with-param>
      <xsl:with-param name ="position" select ="$position + 1"></xsl:with-param>
      <xsl:with-param name ="Max" select ="0"></xsl:with-param>
    </xsl:call-template>
  </xsl:template>

  <!-- ***************************************** Micromodule AM ***********************************************************-->

  <xsl:template name="MicromoduleAM">
    <xsl:param name ="numCfctacti"></xsl:param>
    <xsl:param name ="numMfctacti"></xsl:param>
    <xsl:param name ="numSfctacti"></xsl:param>
    <xsl:param name ="position"></xsl:param>
    <xsl:param name ="Max"></xsl:param>

    <xsl:if test ="$position &lt; $Max">

      <xsl:for-each select="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position]">

        <xsl:variable name ="TypeFtc" select ="MOTCLE"></xsl:variable>

        <xsl:choose>
          <xsl:when test ="($TypeFtc = 'CFCTACTI') and ($numCfctacti = '1')">
            <xsl:call-template name ="libelleCFCTACTI">
              <xsl:with-param name ="numCfctacti" select ="$numCfctacti"></xsl:with-param>
              <xsl:with-param name ="numMfctacti" select ="$numMfctacti"></xsl:with-param>
              <xsl:with-param name ="numSfctacti" select ="$numSfctacti"></xsl:with-param>
              <xsl:with-param name ="libelle" select ="$TypeFtc"></xsl:with-param>
              <xsl:with-param name ="position" select ="$position"></xsl:with-param>
              <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test ="($TypeFtc = 'MFCTACTI') and ($numMfctacti = '1')">
            <xsl:call-template name ="libelleMFCTACTI">
              <xsl:with-param name ="numCfctacti" select ="$numCfctacti"></xsl:with-param>
              <xsl:with-param name ="numMfctacti" select ="$numMfctacti"></xsl:with-param>
              <xsl:with-param name ="numSfctacti" select ="$numSfctacti"></xsl:with-param>
              <xsl:with-param name ="libelle" select ="$TypeFtc"></xsl:with-param>
              <xsl:with-param name ="position" select ="$position"></xsl:with-param>
              <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test ="($TypeFtc = 'SFCTACTI') and ($numSfctacti = '1')">
            <xsl:call-template name ="libelleSFCTACTI">
              <xsl:with-param name ="numCfctacti" select ="$numCfctacti"></xsl:with-param>
              <xsl:with-param name ="numMfctacti" select ="$numMfctacti"></xsl:with-param>
              <xsl:with-param name ="numSfctacti" select ="$numSfctacti"></xsl:with-param>
              <xsl:with-param name ="libelle" select ="$TypeFtc"></xsl:with-param>
              <xsl:with-param name ="position" select ="$position"></xsl:with-param>
              <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test ="($TypeFtc = 'CLENOUV') or ($TypeFtc = 'EFIN') or ($TypeFtc = 'EIND') or ($TypeFtc = 'ENTPURG') or ($TypeFtc = 'IDNOUV') or ($TypeFtc = 'METAT') or ($TypeFtc = 'NONRES') or ($TypeFtc = 'GFCTACTI') or ($TypeFtc = 'GFCTDET') or ($TypeFtc = 'IDEICREE')">
            <xsl:call-template name ="AfficheLibValAM">
              <xsl:with-param name ="numCfctacti" select ="$numCfctacti"></xsl:with-param>
              <xsl:with-param name ="numMfctacti" select ="$numMfctacti"></xsl:with-param>
              <xsl:with-param name ="numSfctacti" select ="$numSfctacti"></xsl:with-param>
              <xsl:with-param name ="libelle" select ="$TypeFtc"></xsl:with-param>
              <xsl:with-param name ="position" select ="$position"></xsl:with-param>
              <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
            </xsl:call-template>
          </xsl:when>

          <xsl:otherwise>
            <xsl:call-template name ="AfficheValeurAM">
              <xsl:with-param name ="numCfctacti" select ="$numCfctacti"></xsl:with-param>
              <xsl:with-param name ="numMfctacti" select ="$numMfctacti"></xsl:with-param>
              <xsl:with-param name ="numSfctacti" select ="$numSfctacti"></xsl:with-param>
              <xsl:with-param name ="libelle" select ="$TypeFtc"></xsl:with-param>
              <xsl:with-param name ="position" select ="$position"></xsl:with-param>
              <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
            </xsl:call-template>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:for-each>
    </xsl:if>
  </xsl:template>

  <!-- * * * * * * * * * * * * * * Les templates du template Micromodule AM * * * * * * * * * * * * * * * * * * * * * * * -->

  <xsl:template name="libelleCFCTACTI">
    <xsl:param name ="numCfctacti"></xsl:param>
    <xsl:param name ="numMfctacti"></xsl:param>
    <xsl:param name ="numSfctacti"></xsl:param>
    <xsl:param name ="libelle"></xsl:param>
    <xsl:param name ="position"></xsl:param>
    <xsl:param name ="Max"></xsl:param>
    <table class="clWidthMax clBorderCell" role="presentation">
      <tr>
        <td class="clWidth10 clHeight20">&#160;</td>
        <td class="clWidth768 clHeight20">&#160;</td>
      </tr>
      <tr>
        <td class="clWidth10">&#160;</td>
        <td class="clTexte clWidth768">
          <xsl:value-of select="($dictionnaire/mot[@id=$libelle])"/>&#160;
        </td>
      </tr>
      <tr>
        <td class="clWidth10 clHeight20">&#160;</td>
        <td class="clWidth768 clHeight20">&#160;</td>
      </tr>
    </table>

    <xsl:variable name ="PositionSuivante"  select ="$position + 1"></xsl:variable>
    <xsl:variable name ="PositionSuivante2"  select ="$position + 2"></xsl:variable>
    <xsl:variable name ="NouedSuivant" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante]/MOTCLE"></xsl:variable>
    <xsl:variable name ="NouedSuivant2" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante2]/MOTCLE"></xsl:variable>
    <xsl:variable name ="ValeurNouedSuivant" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante]/VALEUR"></xsl:variable>
    <table class="clWidthMax clBorderCell" role="presentation">

      <tr>
        <td class="clWidth10">&#160;</td>
        <td class="clTexte clWidth200">
          <xsl:value-of select="($dictionnaire/mot[@id=$NouedSuivant2])"/>
        </td>
        <td class="clTexte clWidth568">
          <!-- l'identifiant + denomination -->
          <xsl:variable name ="valeur" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position]/VALEUR"></xsl:variable>
          <xsl:value-of select ="concat(substring($valeur,1,3),' ',substring($valeur,4,3),' ',substring($valeur,7,3))"/>&#160;&#160;
          <xsl:value-of select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante2]/VALEUR"/>

        </td>
      </tr>
      <tr>
        <td class="clWidth10">&#160;</td>
        <td class="clTexte clWidth200">
          <xsl:value-of select="($dictionnaire/mot[@id=$NouedSuivant])"/>
        </td>
        <td class="clTexte clWidth568">
          <xsl:value-of select="($dictionnaire/mot[@id=($ValeurNouedSuivant)])"></xsl:value-of>
        </td>
      </tr>
    </table>
    <xsl:call-template name ="MicromoduleAM">
      <xsl:with-param name ="numCfctacti" select ="$numCfctacti + 1"></xsl:with-param>
      <xsl:with-param name ="numMfctacti" select ="$numMfctacti"></xsl:with-param>
      <xsl:with-param name ="numSfctacti" select ="$numSfctacti"></xsl:with-param>
      <xsl:with-param name ="position" select ="$position + 3"></xsl:with-param>
      <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
    </xsl:call-template>

  </xsl:template>

  <xsl:template name="libelleMFCTACTI">
    <xsl:param name ="numCfctacti"></xsl:param>
    <xsl:param name ="numMfctacti"></xsl:param>
    <xsl:param name ="numSfctacti"></xsl:param>
    <xsl:param name ="libelle"></xsl:param>
    <xsl:param name ="position"></xsl:param>
    <xsl:param name ="Max"></xsl:param>
    <table class="clWidthMax clBorderCell" role="presentation">
      <tr>
        <td class="clWidth10 clHeight20">&#160;</td>
        <td class="clWidth768 clHeight20">&#160;</td>
      </tr>
      <tr>
        <td class="clWidth10">&#160;</td>
        <td class="clTexte clWidth768">
          <xsl:value-of select="($dictionnaire/mot[@id=$libelle])"/>&#160;
        </td>
      </tr>
      <tr>
        <td class="clWidth10 clHeight20">&#160;</td>
        <td class="clWidth768 clHeight20">&#160;</td>
      </tr>
    </table>

    <xsl:variable name ="PositionSuivante"  select ="$position + 1"></xsl:variable>
    <xsl:variable name ="PositionSuivante2"  select ="$position + 2"></xsl:variable>
    <xsl:variable name ="NouedSuivant" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante]/MOTCLE"></xsl:variable>
    <xsl:variable name ="NouedSuivant2" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante2]/MOTCLE"></xsl:variable>
    <xsl:variable name ="ValeurNouedSuivant" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante]/VALEUR"></xsl:variable>
    <table class="clWidthMax clBorderCell" role="presentation">

      <tr>
        <td class="clWidth10">&#160;</td>
        <td class="clTexte clWidth200">
          <xsl:value-of select="($dictionnaire/mot[@id=$NouedSuivant2])"/>
        </td>
        <td class="clTexte clWidth568">
          <!-- l'identifiant + denomination -->
          <xsl:variable name ="valeur" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position]/VALEUR"></xsl:variable>
          <xsl:value-of select ="concat(substring($valeur,1,3),' ',substring($valeur,4,3),' ',substring($valeur,7,3))"/>&#160;&#160;
          <xsl:value-of select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante2]/VALEUR"/>

        </td>
      </tr>
      <tr>
        <td class="clWidth10">&#160;</td>
        <td class="clTexte clWidth200">
          <xsl:value-of select="($dictionnaire/mot[@id=$NouedSuivant])"/>
        </td>
        <td class="clTexte clWidth568">
          <xsl:value-of select="($dictionnaire/mot[@id=($ValeurNouedSuivant)])"></xsl:value-of>
        </td>
      </tr>
    </table>
    <xsl:call-template name ="MicromoduleAM">
      <xsl:with-param name ="numCfctacti" select ="$numCfctacti"></xsl:with-param>
      <xsl:with-param name ="numMfctacti" select ="$numMfctacti + 1"></xsl:with-param>
      <xsl:with-param name ="numSfctacti" select ="$numSfctacti"></xsl:with-param>
      <xsl:with-param name ="position" select ="$position + 3"></xsl:with-param>
      <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
    </xsl:call-template>

  </xsl:template>

  <xsl:template name="libelleSFCTACTI">
    <xsl:param name ="numCfctacti"></xsl:param>
    <xsl:param name ="numMfctacti"></xsl:param>
    <xsl:param name ="numSfctacti"></xsl:param>
    <xsl:param name ="libelle"></xsl:param>
    <xsl:param name ="position"></xsl:param>
    <xsl:param name ="Max"></xsl:param>
    <table class="clWidthMax clBorderCell" role="presentation">
      <tr>
        <td class="clWidth10 clHeight20">&#160;</td>
        <td class="clWidth768 clHeight20">&#160;</td>
      </tr>
      <tr>
        <td class="clWidth10">&#160;</td>
        <td class="clTexte clWidth768">
          <xsl:value-of select="($dictionnaire/mot[@id=$libelle])"/>&#160;
        </td>
      </tr>
      <tr>
        <td class="clWidth10 clHeight20">&#160;</td>
        <td class="clWidth768 clHeight20">&#160;</td>
      </tr>
    </table>

    <xsl:variable name ="PositionSuivante"  select ="$position + 1"></xsl:variable>
    <xsl:variable name ="PositionSuivante2"  select ="$position + 2"></xsl:variable>
    <xsl:variable name ="NouedSuivant" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante]/MOTCLE"></xsl:variable>
    <xsl:variable name ="NouedSuivant2" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante2]/MOTCLE"></xsl:variable>
    <xsl:variable name ="ValeurNouedSuivant" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante]/VALEUR"></xsl:variable>
    <table class="clWidthMax clBorderCell" role="presentation">

      <tr>
        <td class="clWidth10">&#160;</td>
        <td class="clTexte clWidth200">
          <xsl:value-of select="($dictionnaire/mot[@id=$NouedSuivant2])"/>
        </td>
        <td class="clTexte clWidth568">
          <!-- l'identifiant + denomination -->
          <xsl:variable name ="valeur" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position]/VALEUR"></xsl:variable>
          <xsl:value-of select ="concat(substring($valeur,1,3),' ',substring($valeur,4,3),' ',substring($valeur,7,3))"/>&#160;&#160;
          <xsl:value-of select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante2]/VALEUR"/>

        </td>
      </tr>
      <tr>
        <td class="clWidth10">&#160;</td>
        <td class="clTexte clWidth200">
          <xsl:value-of select="($dictionnaire/mot[@id=$NouedSuivant])"/>
        </td>
        <td class="clTexte clWidth568">
          <xsl:value-of select="($dictionnaire/mot[@id=($ValeurNouedSuivant)])"></xsl:value-of>
        </td>
      </tr>
    </table>
    <xsl:call-template name ="MicromoduleAM">
      <xsl:with-param name ="numCfctacti" select ="$numCfctacti"></xsl:with-param>
      <xsl:with-param name ="numMfctacti" select ="$numMfctacti"></xsl:with-param>
      <xsl:with-param name ="numSfctacti" select ="$numSfctacti + 1"></xsl:with-param>
      <xsl:with-param name ="position" select ="$position + 3"></xsl:with-param>
      <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
    </xsl:call-template>
  </xsl:template>



  <xsl:template name="AfficheValeurAM">
    <xsl:param name ="numCfctacti"></xsl:param>
    <xsl:param name ="numMfctacti"></xsl:param>
    <xsl:param name ="numSfctacti"></xsl:param>
    <xsl:param name ="libelle"></xsl:param>
    <xsl:param name ="position"></xsl:param>
    <xsl:param name ="Max"></xsl:param>

    <xsl:variable name ="PositionSuivante"  select ="$position + 1"></xsl:variable>
    <xsl:variable name ="PositionSuivante2"  select ="$position + 2"></xsl:variable>
    <xsl:variable name ="NouedSuivant" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante]/MOTCLE"></xsl:variable>
    <xsl:variable name ="NouedSuivant2" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante2]/MOTCLE"></xsl:variable>
    <xsl:variable name ="ValeurNouedSuivant" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante]/VALEUR"></xsl:variable>
    <table class="clWidthMax clBorderCell" role="presentation">

      <tr>
        <td class="clWidth10">&#160;</td>
        <td class="clTexte clWidth200">
          <xsl:value-of select="($dictionnaire/mot[@id=$NouedSuivant2])"/>
        </td>
        <td class="clTexte clWidth568">
          <!-- l'identifiant + denomination -->
          <xsl:variable name ="valeur" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position]/VALEUR"></xsl:variable>
          <xsl:value-of select ="concat(substring($valeur,1,3),' ',substring($valeur,4,3),' ',substring($valeur,7,3))"/>&#160;&#160;
          <xsl:value-of select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante2]/VALEUR"/>

        </td>
      </tr>
      <tr>
        <td class="clWidth10">&#160;</td>
        <td class="clTexte clWidth200">
          <xsl:value-of select="($dictionnaire/mot[@id=$NouedSuivant])"/>
        </td>
        <td class="clTexte clWidth568">
          <xsl:value-of select="($dictionnaire/mot[@id=($ValeurNouedSuivant)])"></xsl:value-of>
        </td>
      </tr>
    </table>
    <xsl:call-template name ="MicromoduleAM">
      <xsl:with-param name ="numCfctacti" select ="$numCfctacti"></xsl:with-param>
      <xsl:with-param name ="numMfctacti" select ="$numMfctacti"></xsl:with-param>
      <xsl:with-param name ="numSfctacti" select ="$numSfctacti"></xsl:with-param>
      <xsl:with-param name ="position" select ="$position + 3"></xsl:with-param>
      <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
    </xsl:call-template>
  </xsl:template>

  <!-- template de construction d'un message sur une ligne (mot-cle + valeur)
  mise à 0 du nombre Max pour ne pas afficher message en bas de page-->

  <xsl:template name="AfficheLibValAM">
    <xsl:param name ="numCfctacti"></xsl:param>
    <xsl:param name ="numMfctacti"></xsl:param>
    <xsl:param name ="numSfctacti"></xsl:param>
    <xsl:param name ="libelle"></xsl:param>
    <xsl:param name ="position"></xsl:param>
    <xsl:param name ="Max"></xsl:param>
    <table class="clWidthMax clBorderCell" role="presentation">
      <tr>
        <td class="clWidth10 clHeight20">&#160;</td>
        <td class="clWidth768 clHeight20">&#160;</td>
      </tr>
      <tr>
        <td class="clWidth10">&#160;</td>
        <td class="clTexte clWidth768">
          <xsl:value-of select="($dictionnaire/mot[@id=$libelle])"/>&#160;
          <xsl:choose>
            <xsl:when test ="./CONVERT">
              <xsl:variable name ="valeur" select ="VALEUR"></xsl:variable>
              <xsl:value-of select="($dictionnaire/mot[@id=$valeur])"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select ="VALEUR"/>
            </xsl:otherwise>
          </xsl:choose>
        </td>
      </tr>
    </table>
    <xsl:call-template name ="MicromoduleAM">
      <xsl:with-param name ="numCfctacti" select ="$numCfctacti"></xsl:with-param>
      <xsl:with-param name ="numMfctacti" select ="$numMfctacti"></xsl:with-param>
      <xsl:with-param name ="numSfctacti" select ="$numSfctacti"></xsl:with-param>
      <xsl:with-param name ="position" select ="$position + 1"></xsl:with-param>
      <xsl:with-param name ="Max" select ="0"></xsl:with-param>
    </xsl:call-template>
  </xsl:template>


  <!-- ***************************************** Micromodule AX ***********************************************************-->

  <xsl:template name="MicromoduleAX">
    <xsl:param name ="numCfoncdir"></xsl:param>
    <xsl:param name ="numMfoncdir"></xsl:param>
    <xsl:param name ="numSfoncdir"></xsl:param>
    <xsl:param name ="position"></xsl:param>
    <xsl:param name ="Max"></xsl:param>

    <xsl:if test ="$position &lt; $Max">

      <xsl:for-each select="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position]">

        <xsl:variable name ="TypeFonct" select ="MOTCLE"></xsl:variable>

        <xsl:choose>
          <xsl:when test ="($TypeFonct = 'CFONCDIR') and ($numCfoncdir = '1')">
            <xsl:call-template name ="libelleCFONDIR">
              <xsl:with-param name ="numCfoncdir" select ="$numCfoncdir"></xsl:with-param>
              <xsl:with-param name ="numMfoncdir" select ="$numMfoncdir"></xsl:with-param>
              <xsl:with-param name ="numSfoncdir" select ="$numSfoncdir"></xsl:with-param>
              <xsl:with-param name ="libelle" select ="$TypeFonct"></xsl:with-param>
              <xsl:with-param name ="position" select ="$position"></xsl:with-param>
              <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test ="($TypeFonct = 'MFONCDIR') and ($numMfoncdir = '1')">
            <xsl:call-template name ="libelleMFONDIR">
              <xsl:with-param name ="numCfoncdir" select ="$numCfoncdir"></xsl:with-param>
              <xsl:with-param name ="numMfoncdir" select ="$numMfoncdir"></xsl:with-param>
              <xsl:with-param name ="numSfoncdir" select ="$numSfoncdir"></xsl:with-param>
              <xsl:with-param name ="libelle" select ="$TypeFonct"></xsl:with-param>
              <xsl:with-param name ="position" select ="$position"></xsl:with-param>
              <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test ="($TypeFonct = 'SFONCDIR') and ($numSfoncdir = '1')">
            <xsl:call-template name ="libelleSFONDIR">
              <xsl:with-param name ="numCfoncdir" select ="$numCfoncdir"></xsl:with-param>
              <xsl:with-param name ="numMfoncdir" select ="$numMfoncdir"></xsl:with-param>
              <xsl:with-param name ="numSfoncdir" select ="$numSfoncdir"></xsl:with-param>
              <xsl:with-param name ="libelle" select ="$TypeFonct"></xsl:with-param>
              <xsl:with-param name ="position" select ="$position"></xsl:with-param>
              <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test ="($TypeFonct = 'CLENOUV') or ($TypeFonct = 'EFIN') or ($TypeFonct = 'EIND') or ($TypeFonct = 'ENTPURG') or ($TypeFonct = 'IDNOUV') or ($TypeFonct = 'METAT') or ($TypeFonct = 'NONRES') or ($TypeFonct = 'GFONCDIR')">
            <xsl:call-template name ="AfficheLibValAX">
              <xsl:with-param name ="numCfoncdir" select ="$numCfoncdir"></xsl:with-param>
              <xsl:with-param name ="numMfoncdir" select ="$numMfoncdir"></xsl:with-param>
              <xsl:with-param name ="numSfoncdir" select ="$numSfoncdir"></xsl:with-param>
              <xsl:with-param name ="libelle" select ="$TypeFonct"></xsl:with-param>
              <xsl:with-param name ="position" select ="$position"></xsl:with-param>
              <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
            </xsl:call-template>
          </xsl:when>

          <xsl:otherwise>
            <xsl:call-template name ="AfficheValeurAX">
              <xsl:with-param name ="numCfoncdir" select ="$numCfoncdir"></xsl:with-param>
              <xsl:with-param name ="numMfoncdir" select ="$numMfoncdir"></xsl:with-param>
              <xsl:with-param name ="numSfoncdir" select ="$numSfoncdir"></xsl:with-param>
              <xsl:with-param name ="libelle" select ="$TypeFonct"></xsl:with-param>
              <xsl:with-param name ="position" select ="$position"></xsl:with-param>
              <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
            </xsl:call-template>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:for-each>
    </xsl:if>
  </xsl:template>

  <!-- * * * * * * * * * * * * * * Les templates du template Micromodule AX * * * * * * * * * * * * * * * * * * * * * * * -->

  <xsl:template name="libelleCFONDIR">
    <xsl:param name ="numCfoncdir"></xsl:param>
    <xsl:param name ="numMfoncdir"></xsl:param>
    <xsl:param name ="numSfoncdir"></xsl:param>
    <xsl:param name ="libelle"></xsl:param>
    <xsl:param name ="position"></xsl:param>
    <xsl:param name ="Max"></xsl:param>
    <table class="clWidthMax clBorderCell" role="presentation">
      <tr>
        <td class="clWidth10 clHeight20">&#160;</td>
        <td class="clWidth768 clHeight20">&#160;</td>
      </tr>
      <tr>
        <td class="clWidth10">&#160;</td>
        <td class="clTexte clWidth768">
          <xsl:value-of select="($dictionnaire/mot[@id=$libelle])"/>&#160;
        </td>
      </tr>
      <tr>
        <td class="clWidth10 clHeight20">&#160;</td>
        <td class="clWidth768 clHeight20">&#160;</td>
      </tr>
    </table>

    <xsl:variable name ="PositionSuivante"  select ="$position + 1"></xsl:variable>
    <xsl:variable name ="PositionSuivante2"  select ="$position + 2"></xsl:variable>
    <xsl:variable name ="NouedSuivant" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante]/MOTCLE"></xsl:variable>

    <xsl:choose>
      <!-- test si nom et prenom -->
      <xsl:when test ="$NouedSuivant = 'NODIR'">
        <table class="clWidthMax clBorderCell" role="presentation">
          <tr>
            <td class="clWidth10">&#160;</td>
            <td class="clTexte clWidth290">
              <xsl:variable name ="valeur" select ="$NouedSuivant"></xsl:variable>
              <xsl:value-of select="($dictionnaire/mot[@id=$valeur])"/>
            </td>
            <td class="clTexte clWidth478">
              <xsl:call-template name ="displayInLowerCaseXsl">
                <xsl:with-param name ="InputIdentc" select ="VALEUR"/>
                <xsl:with-param name ="InputStringNom" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante]/VALEUR"/>
                <xsl:with-param name ="InputStringPrenom" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante2]/VALEUR"/>
              </xsl:call-template>
            </td>
          </tr>
        </table>
        <xsl:call-template name ="MicromoduleAX">
          <xsl:with-param name ="numCfoncdir" select ="$numCfoncdir + 1"></xsl:with-param>
          <xsl:with-param name ="numMfoncdir" select ="$numMfoncdir"></xsl:with-param>
          <xsl:with-param name ="numSfoncdir" select ="$numSfoncdir"></xsl:with-param>
          <xsl:with-param name ="position" select ="$position + 3"></xsl:with-param>
          <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
        </xsl:call-template>

      </xsl:when>
      <xsl:otherwise>
        <table class="clWidthMax clBorderCell" role="presentation">
          <tr>
            <td class="clWidth10">&#160;</td>
            <td class="clTexte clWidth200">
              <xsl:value-of select="($dictionnaire/mot[@id=$NouedSuivant])"/>
            </td>
            <td class="clTexte clWidth568">
              <xsl:value-of select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position]/VALEUR"/>&#160;
              <xsl:value-of select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante]/VALEUR"/>
            </td>
          </tr>
        </table>
        <xsl:call-template name ="MicromoduleAX">
          <xsl:with-param name ="numCfoncdir" select ="$numCfoncdir + 1"></xsl:with-param>
          <xsl:with-param name ="numMfoncdir" select ="$numMfoncdir"></xsl:with-param>
          <xsl:with-param name ="numSfoncdir" select ="$numSfoncdir"></xsl:with-param>
          <xsl:with-param name ="position" select ="$position + 2"></xsl:with-param>
          <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>

  </xsl:template>


  <xsl:template name="libelleMFONDIR">
    <xsl:param name ="numCfoncdir"></xsl:param>
    <xsl:param name ="numMfoncdir"></xsl:param>
    <xsl:param name ="numSfoncdir"></xsl:param>
    <xsl:param name ="libelle"></xsl:param>
    <xsl:param name ="position"></xsl:param>
    <xsl:param name ="Max"></xsl:param>
    <table class="clWidthMax clBorderCell" role="presentation">
      <tr>
        <td class="clWidth10 clHeight20">&#160;</td>
        <td class="clWidth768 clHeight20">&#160;</td>
      </tr>
      <tr>
        <td class="clWidth10">&#160;</td>
        <td class="clTexte clWidth768">
          <xsl:value-of select="($dictionnaire/mot[@id=$libelle])"/>&#160;
        </td>
      </tr>
      <tr>
        <td class="clWidth10 clHeight20">&#160;</td>
        <td class="clWidth768 clHeight20">&#160;</td>
      </tr>
    </table>

    <xsl:variable name ="PositionSuivante"  select ="$position + 1"></xsl:variable>
    <xsl:variable name ="PositionSuivante2"  select ="$position + 2"></xsl:variable>
    <xsl:variable name ="NouedSuivant" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante]/MOTCLE"></xsl:variable>

    <xsl:choose>
      <!-- test si nom et prenom -->
      <xsl:when test ="$NouedSuivant = 'NODIR'">
        <table class="clWidthMax clBorderCell" role="presentation">
          <tr>
            <td class="clWidth10">&#160;</td>
            <td class="clTexte clWidth290">
              <xsl:variable name ="valeur" select ="$NouedSuivant"></xsl:variable>
              <xsl:value-of select="($dictionnaire/mot[@id=$valeur])"/>
            </td>
            <td class="clTexte clWidth478">
              <xsl:call-template name ="displayInLowerCaseXsl">
                <xsl:with-param name ="InputIdentc" select ="VALEUR"/>
                <xsl:with-param name ="InputStringNom" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante]/VALEUR"/>
                <xsl:with-param name ="InputStringPrenom" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante2]/VALEUR"/>
              </xsl:call-template>
            </td>
          </tr>
        </table>
        <xsl:call-template name ="MicromoduleAX">
          <xsl:with-param name ="numCfoncdir" select ="$numCfoncdir"></xsl:with-param>
          <xsl:with-param name ="numMfoncdir" select ="$numMfoncdir + 1"></xsl:with-param>
          <xsl:with-param name ="numSfoncdir" select ="$numSfoncdir"></xsl:with-param>
          <xsl:with-param name ="position" select ="$position + 3"></xsl:with-param>
          <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
        </xsl:call-template>

      </xsl:when>
      <xsl:otherwise>
        <table class="clWidthMax clBorderCell" role="presentation">
          <tr>
            <td class="clWidth10">&#160;</td>
            <td class="clTexte clWidth200">
              <xsl:value-of select="($dictionnaire/mot[@id=$NouedSuivant])"/>
            </td>
            <td class="clTexte clWidth568">
              <xsl:value-of select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position]/VALEUR"/>&#160;
              <xsl:value-of select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante]/VALEUR"/>
            </td>
          </tr>
        </table>
        <xsl:call-template name ="MicromoduleAX">
          <xsl:with-param name ="numCfoncdir" select ="$numCfoncdir"></xsl:with-param>
          <xsl:with-param name ="numMfoncdir" select ="$numMfoncdir + 1"></xsl:with-param>
          <xsl:with-param name ="numSfoncdir" select ="$numSfoncdir"></xsl:with-param>
          <xsl:with-param name ="position" select ="$position + 2"></xsl:with-param>
          <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>


  <xsl:template name="libelleSFONDIR">
    <xsl:param name ="numCfoncdir"></xsl:param>
    <xsl:param name ="numMfoncdir"></xsl:param>
    <xsl:param name ="numSfoncdir"></xsl:param>
    <xsl:param name ="libelle"></xsl:param>
    <xsl:param name ="position"></xsl:param>
    <xsl:param name ="Max"></xsl:param>
    <table class="clWidthMax clBorderCell" role="presentation">
      <tr>
        <td class="clWidth10 clHeight20">&#160;</td>
        <td class="clWidth768 clHeight20">&#160;</td>
      </tr>
      <tr>
        <td class="clWidth10">&#160;</td>
        <td class="clTexte clWidth768">
          <xsl:value-of select="($dictionnaire/mot[@id=$libelle])"/>&#160;
        </td>
      </tr>
      <tr>
        <td class="clWidth10 clHeight20">&#160;</td>
        <td class="clWidth768 clHeight20">&#160;</td>
      </tr>
    </table>

    <xsl:variable name ="PositionSuivante"  select ="$position + 1"></xsl:variable>
    <xsl:variable name ="PositionSuivante2"  select ="$position + 2"></xsl:variable>
    <xsl:variable name ="NouedSuivant" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante]/MOTCLE"></xsl:variable>

    <xsl:choose>
      <!-- test si nom et prenom -->
      <xsl:when test ="$NouedSuivant = 'NODIR'">
        <table class="clWidthMax clBorderCell" role="presentation">
          <tr>
            <td class="clWidth10">&#160;</td>
            <td class="clTexte clWidth290">
              <xsl:variable name ="valeur" select ="$NouedSuivant"></xsl:variable>
              <xsl:value-of select="($dictionnaire/mot[@id=$valeur])"/>
            </td>
            <td class="clTexte clWidth478">
              <xsl:call-template name ="displayInLowerCaseXsl">
                <xsl:with-param name ="InputIdentc" select ="VALEUR"/>
                <xsl:with-param name ="InputStringNom" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante]/VALEUR"/>
                <xsl:with-param name ="InputStringPrenom" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante2]/VALEUR"/>
              </xsl:call-template>
            </td>
          </tr>
        </table>
        <xsl:call-template name ="MicromoduleAX">
          <xsl:with-param name ="numCfoncdir" select ="$numCfoncdir"></xsl:with-param>
          <xsl:with-param name ="numMfoncdir" select ="$numMfoncdir"></xsl:with-param>
          <xsl:with-param name ="numSfoncdir" select ="$numSfoncdir + 1"></xsl:with-param>
          <xsl:with-param name ="position" select ="$position + 3"></xsl:with-param>
          <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
        </xsl:call-template>

      </xsl:when>
      <xsl:otherwise>
        <table class="clWidthMax clBorderCell" role="presentation">
          <tr>
            <td class="clWidth10">&#160;</td>
            <td class="clTexte clWidth200">
              <xsl:value-of select="($dictionnaire/mot[@id=$NouedSuivant])"/>
            </td>
            <td class="clTexte clWidth568">
              <xsl:value-of select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position]/VALEUR"/>&#160;
              <xsl:value-of select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante]/VALEUR"/>
            </td>
          </tr>
        </table>
        <xsl:call-template name ="MicromoduleAX">
          <xsl:with-param name ="numCfoncdir" select ="$numCfoncdir"></xsl:with-param>
          <xsl:with-param name ="numMfoncdir" select ="$numMfoncdir"></xsl:with-param>
          <xsl:with-param name ="numSfoncdir" select ="$numSfoncdir + 1"></xsl:with-param>
          <xsl:with-param name ="position" select ="$position + 2"></xsl:with-param>
          <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>



  <xsl:template name="AfficheValeurAX">
    <xsl:param name ="numCfoncdir"></xsl:param>
    <xsl:param name ="numMfoncdir"></xsl:param>
    <xsl:param name ="numSfoncdir"></xsl:param>
    <xsl:param name ="libelle"></xsl:param>
    <xsl:param name ="position"></xsl:param>
    <xsl:param name ="Max"></xsl:param>

    <xsl:variable name ="PositionSuivante"  select ="$position + 1"></xsl:variable>
    <xsl:variable name ="PositionSuivante2"  select ="$position + 2"></xsl:variable>
    <xsl:variable name ="NouedSuivant" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante]/MOTCLE"></xsl:variable>

    <xsl:choose>
      <!-- test si nom et prenom -->
      <xsl:when test ="$NouedSuivant = 'NODIR'">
        <table class="clWidthMax clBorderCell" role="presentation">
          <tr>
            <td class="clWidth10">&#160;</td>
            <td class="clTexte clWidth290">
              <xsl:variable name ="valeur" select ="$NouedSuivant"></xsl:variable>
              <xsl:value-of select="($dictionnaire/mot[@id=$valeur])"/>
            </td>
            <td class="clTexte clWidth478">
              <xsl:call-template name ="displayInLowerCaseXsl">
                <xsl:with-param name ="InputIdentc" select ="VALEUR"/>
                <xsl:with-param name ="InputStringNom" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante]/VALEUR"/>
                <xsl:with-param name ="InputStringPrenom" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante2]/VALEUR"/>
              </xsl:call-template>
            </td>
          </tr>
        </table>
        <xsl:call-template name ="MicromoduleAX">
          <xsl:with-param name ="numCfoncdir" select ="$numCfoncdir"></xsl:with-param>
          <xsl:with-param name ="numMfoncdir" select ="$numMfoncdir"></xsl:with-param>
          <xsl:with-param name ="numSfoncdir" select ="$numSfoncdir"></xsl:with-param>
          <xsl:with-param name ="position" select ="$position + 3"></xsl:with-param>
          <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
        </xsl:call-template>

      </xsl:when>
      <xsl:otherwise>
        <table class="clWidthMax clBorderCell" role="presentation">
          <tr>
            <td class="clWidth10">&#160;</td>
            <td class="clTexte clWidth200">
              <xsl:value-of select="($dictionnaire/mot[@id=$NouedSuivant])"/>
            </td>
            <td class="clTexte clWidth568">
              <xsl:value-of select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position]/VALEUR"/>&#160;
              <xsl:value-of select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante]/VALEUR"/>
            </td>
          </tr>
        </table>
        <xsl:call-template name ="MicromoduleAX">
          <xsl:with-param name ="numCfoncdir" select ="$numCfoncdir"></xsl:with-param>
          <xsl:with-param name ="numMfoncdir" select ="$numMfoncdir"></xsl:with-param>
          <xsl:with-param name ="numSfoncdir" select ="$numSfoncdir"></xsl:with-param>
          <xsl:with-param name ="position" select ="$position + 2"></xsl:with-param>
          <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>

  </xsl:template>

  <!-- template de construction d'un message sur une ligne (mot-cle + valeur)
  mise à 0 du nombre Max pour ne pas afficher message en bas de page-->

  <xsl:template name="AfficheLibValAX">
    <xsl:param name ="numCfoncdir"></xsl:param>
    <xsl:param name ="numMfoncdir"></xsl:param>
    <xsl:param name ="numSfoncdir"></xsl:param>
    <xsl:param name ="libelle"></xsl:param>
    <xsl:param name ="position"></xsl:param>
    <xsl:param name ="Max"></xsl:param>
    <table class="clWidthMax clBorderCell" role="presentation">
      <tr>
        <td class="clWidth10 clHeight20">&#160;</td>
        <td class="clWidth768 clHeight20">&#160;</td>
      </tr>
      <tr>
        <td class="clWidth10">&#160;</td>
        <td class="clTexte clWidth768">
          <xsl:value-of select="($dictionnaire/mot[@id=$libelle])"/>&#160;
          <xsl:choose>
            <xsl:when test ="./CONVERT">
              <xsl:variable name ="valeur" select ="VALEUR"></xsl:variable>
              <xsl:value-of select="($dictionnaire/mot[@id=$valeur])"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select ="VALEUR"/>
            </xsl:otherwise>
          </xsl:choose>
        </td>
      </tr>
    </table>
    <xsl:call-template name ="MicromoduleAX">
      <xsl:with-param name ="numCfoncdir" select ="$numCfoncdir"></xsl:with-param>
      <xsl:with-param name ="numMfoncdir" select ="$numMfoncdir"></xsl:with-param>
      <xsl:with-param name ="numSfoncdir" select ="$numSfoncdir"></xsl:with-param>
      <xsl:with-param name ="position" select ="$position + 1"></xsl:with-param>
      <xsl:with-param name ="Max" select ="0"></xsl:with-param>
    </xsl:call-template>
  </xsl:template>


  <!-- ***************************************** Micromodule AB ***********************************************************-->

  <xsl:template name="TestMicromoduleAB">
    <xsl:param name ="Max"></xsl:param>
    <xsl:param name="position"></xsl:param>
    <!-- test pour savoir si message simple (conrespondant à une premiere déclaration) ou construction d'un tableau ou affichage plusieurs motclé spécifique-->
    <xsl:choose>
      <!--recherche si plusieurs mot clé mess informatif -->

      <xsl:when test = "$position = $Max">

        <!-- cas message simple -->
        <xsl:call-template name ="MicromoduleABsimple">
          <xsl:with-param name ="MotcleSimple" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position]/MOTCLE"></xsl:with-param>
          <xsl:with-param name ="ValeurSimple" select="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position]/VALEUR"></xsl:with-param>
          <xsl:with-param name ="DateMouve" select ="/FIBEN/SERVICESAS/MODULES5/MOUVSUI/DATEMOUVE"></xsl:with-param>
        </xsl:call-template>
        <xsl:if test ="substring(/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[1]/MOTCLE,1,1) = 'X'">
          <table class="clWidthMax clBorderCell" role="presentation">
            <tr>
              <td class="clWidth10">&#160;</td>
              <td class="clWidth508">&#160;</td>
              <td class="clWidth260" colspan="2">&#160;</td>
            </tr>
            <tr>
              <td class="clWidth10">&#160;</td>
              <td class="clWidth508">&#160;</td>
              <td class="clWidth260" colspan="2">&#160;</td>
            </tr>
            <tr>
              <td class="clWidth10">&#160;</td>
              <td class="clTitre35 clWidth508">Les variations sont liées à corrections de montants déclarés</td>
              <td class="clWidth260" colspan="2">&#160;</td>
            </tr>
          </table >
        </xsl:if>
      </xsl:when>
      <xsl:when test ="$position &gt; $Max">
        <xsl:if test ="substring(/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[1]/MOTCLE,1,1) = 'X'">
          <!-- ajout message bas de page-->
          <table class="clWidthMax clBorderCell" role="presentation">
            <tr>
              <td class="clWidth10">&#160;</td>
              <td class="clWidth508">&#160;</td>
              <td class="clWidth260" colspan="2">&#160;</td>
            </tr>
            <tr>
              <td class="clWidth10">&#160;</td>
              <td class="clTitre35 clWidth508">Les variations sont liées à corrections de montants déclarés</td>
              <td class="clWidth260" colspan="2">&#160;</td>
            </tr>
          </table >
        </xsl:if>
      </xsl:when>

      <xsl:otherwise>
        <xsl:for-each select="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position]">
          <xsl:variable name ="Motcle" select ="MOTCLE"></xsl:variable>

          <!-- cas de la creation du tableau -->
          <xsl:call-template name ="MicromoduleABTableau">
            <xsl:with-param name ="MotcleTableau" select ="$Motcle"></xsl:with-param>
            <xsl:with-param name ="DateMouve" select ="/FIBEN/SERVICESAS/MODULES5/MOUVSUI/DATEMOUVE"></xsl:with-param>
            <xsl:with-param name ="position" select ="$position"></xsl:with-param>
            <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
          </xsl:call-template>

        </xsl:for-each>

      </xsl:otherwise>
    </xsl:choose>


  </xsl:template>

  <xsl:template name="MicromoduleABsimple">
    <xsl:param name ="MotcleSimple"></xsl:param>
    <xsl:param name ="ValeurSimple"></xsl:param>
    <xsl:param name ="DateMouve"></xsl:param>

    <!-- affichage date de la mise a jour format 31/03/2012 (recup de date du mouvement-->
    <xsl:choose>
      <xsl:when test ="($MotcleSimple = 'CLENOUV') or ($MotcleSimple = 'EFIN') or ($MotcleSimple = 'EIND') or ($MotcleSimple = 'ENTPURG') or ($MotcleSimple = 'IDNOUV') or ($MotcleSimple = 'METAT') or ($MotcleSimple = 'NONRES') or ($MotcleSimple = 'GFONCDIR')">
        <table class="clWidthMax clBorderCell" role="presentation">
          <tr>
            <td class="clWidth10 clHeight20">&#160;</td>
            <td class="clWidth768 clHeight20">&#160;</td>
          </tr>
          <tr>
            <td class="clWidth10">&#160;</td>
            <td class="clTexte clWidth768">
              <xsl:value-of select="($dictionnaire/mot[@id=$MotcleSimple])"/>&#160;
              <xsl:choose>
                <xsl:when test ="./CONVERT">
                  <xsl:value-of select="($dictionnaire/mot[@id=$ValeurSimple])"/>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select ="$ValeurSimple"/>
                </xsl:otherwise>
              </xsl:choose>
            </td>
          </tr>
        </table>

      </xsl:when>
      <xsl:otherwise>
        <table class="clWidthMax clBorderCell" role="presentation">
          <tr>
            <td class="clWidth10">&#160;</td>
            <td class="clWidth100">&#160;</td>
            <td class="clTexte clWidth668"></td>
          </tr>
          <tr>
            <td class="clWidth10">&#160;</td>
            <td class="clTexte clWidth155">Date de la mise à jour : </td>
            <td class="clTexte clWidth613">
              <xsl:call-template name ="displayDateXsl">
                <xsl:with-param name ="InputDate" select ="$DateMouve"/>
              </xsl:call-template>
            </td>
          </tr>
        </table>
        <table class="clWidthMax clBorderCell" role="presentation">
          <tr>
            <td class="clWidth10">&#160;</td>
            <td class="clTexte clWidth768"></td>
          </tr>
        </table>


        <table class="clWidthMax clBorderCell" role="presentation">
          <xsl:if test ="substring($MotcleSimple,1,1) = 'X'">
            <tr>
              <!-- 1er partie libelle -->
              <td class="clWidth10">&#160;</td>
              <td class="clTexte clWidth440">
                <xsl:value-of select="substring(($dictionnaire/mot[@id=(concat('N',substring($MotcleSimple,2,7)))]),1,68)"/>
              </td>
              <td class="clWidth318">&#160;</td>
            </tr>
            <tr>
              <td class="clWidth10">&#160;</td>
              <td class="clWidth440">&#160;</td>
              <td class="clWidth318">&#160;</td>
            </tr>
            <tr>
              <!-- 2eme partie libelle -->
              <td class="clWidth10">&#160;</td>
              <td class="clTexte clWidth440">
                <xsl:value-of select="substring(($dictionnaire/mot[@id=(concat('N',substring($MotcleSimple,2,7)))]),69,64)"/>
                <xsl:call-template name ="displayFormatNombre">
                  <xsl:with-param name ="InputValeur" select ="$ValeurSimple"/>
                </xsl:call-template>
              </td>
              <td class="clWidth318">&#160;</td>
            </tr>
          </xsl:if>
          <xsl:if test ="substring($MotcleSimple,1,1) = 'N'">
            <tr>
              <!-- 1er partie libelle -->
              <td class="clWidth10">&#160;</td>
              <td class="clTexte clWidth440">
                <xsl:value-of select="substring(($dictionnaire/mot[@id=$MotcleSimple]),1,68)"/>
              </td>
              <td class="clWidth318">&#160;</td>
            </tr>
            <tr>
              <td class="clWidth10">&#160;</td>
              <td class="clWidth440">&#160;</td>
              <td class="clWidth318">&#160;</td>
            </tr>
            <tr>
              <!-- 2eme partie libelle -->
              <td class="clWidth10">&#160;</td>
              <td class="clTexte clWidth440">
                <xsl:value-of select="substring(($dictionnaire/mot[@id=$MotcleSimple]),69,64)"/>&#160;
                <xsl:call-template name ="displayFormatNombre">
                  <xsl:with-param name ="InputValeur" select ="$ValeurSimple"/>
                </xsl:call-template>
              </td>
              <td class="clWidth318">&#160;</td>
            </tr>
          </xsl:if>
        </table>

      </xsl:otherwise>
    </xsl:choose>

  </xsl:template>


  <xsl:template name="MicromoduleABTableau">
    <xsl:param name ="MotcleTableau"></xsl:param>
    <xsl:param name ="DateMouve"></xsl:param>
    <xsl:param name ="position"></xsl:param>
    <xsl:param name ="Max"></xsl:param>

    <xsl:variable name ="PositionSuivante"  select ="$position + 1"></xsl:variable>
    <xsl:if test ="$position = 1">

      <!-- affichage date de la mise a jour format 31/03/2012 (recup de date du mouvement-->

      <table class="clWidthMax clBorderCell" role="presentation">
        <tr>
          <td class="clWidth10">&#160;</td>
          <td class="clWidth100">&#160;</td>
          <td class="clTexte clWidth668"></td>
        </tr>
        <tr>
          <td class="clWidth10">&#160;</td>
          <td class="clTexte clWidth155">Date de la mise à jour : </td>
          <td class="clTexte clWidth613">
            <xsl:call-template name ="displayDateXsl">
              <xsl:with-param name ="InputDate" select ="$DateMouve"/>
            </xsl:call-template>
          </td>
        </tr>
      </table>
      <table class="clWidthMax clBorderCell" role="presentation">
        <tr>
          <td class="clWidth10">&#160;</td>
          <td class="clTexte clWidth768"></td>
        </tr>
      </table>
      <table class="clWidthMax clBorderCell" role="presentation">
        <tr>
          <td class="clWidth10">&#160;</td>
          <td class="clTexte clWidth508"></td>
          <td class="clTexte clWidth260 clAlignCenter" colspan="2">Montant centralisé du mois par rapport à</td>
        </tr>
        <tr>
          <td class="clWidth10">&#160;</td>
          <td class="clTexte clWidth508"></td>
          <td class="clTexte clWidth130 clAlignCenter">Mois précédent</td>
          <td class="clTexte clWidth130 clAlignCenter">Année précédente</td>
        </tr>
        <tr>
          <td class="clWidth10">&#160;</td>
          <td class="clWidth508">&#160;</td>
          <td class="clWidth130">&#160;</td>
          <td class="clWidth130">&#160;</td>
        </tr>
      </table>
    </xsl:if>
    <xsl:if test ="$position &lt; $Max">
      <table class="clWidthMax clBorderCell" role="presentation">
        <tr>
          <td class="clWidth10">&#160;</td>
          <xsl:if test ="substring($MotcleTableau,1,1) = 'X'">
            <td class="clTexte clWidth508">
              <xsl:value-of select="($dictionnaire/mot[@id=(concat('V',substring($MotcleTableau,2,7)))])"/>&#160;
            </td>
          </xsl:if>
          <xsl:if test ="substring($MotcleTableau,1,1) = 'V'">
            <td class="clTexte clWidth508">
              <xsl:value-of select="($dictionnaire/mot[@id=$MotcleTableau])"/>&#160;
            </td>
          </xsl:if>
          <td class="clWidth130 clAlignCenter">
            <xsl:variable name ="valeur1erPos" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position]/VALEUR"></xsl:variable>
            <xsl:call-template name ="displayFormatNombre">
              <xsl:with-param name ="InputValeur" select ="$valeur1erPos"/>
            </xsl:call-template>
          </td>
          <td class="clWidth130 clAlignCenter">
            <xsl:variable name ="valeur2emePos" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante]/VALEUR"></xsl:variable>
            <xsl:call-template name ="displayFormatNombre">
              <xsl:with-param name ="InputValeur" select ="$valeur2emePos"/>
            </xsl:call-template>
          </td>
        </tr>
        <tr>
          <td class="clWidth10">&#160;</td>
          <td class="clWidth508">&#160;</td>
          <td class="clWidth130">&#160;</td>
          <td class="clWidth130">&#160;</td>
        </tr>
      </table>
    </xsl:if>
    <xsl:call-template name ="TestMicromoduleAB">
      <xsl:with-param name ="position" select ="$position + 2"></xsl:with-param>
      <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
    </xsl:call-template>

  </xsl:template>





  <!-- ***************************************** Micromodule AE ***********************************************************-->

  <xsl:template name="TestMicromoduleAE">
    <xsl:param name ="Max"></xsl:param>
    <xsl:param name="position"></xsl:param>
    <!-- test pour savoir si message simple (conrespondant à une premiere déclaration) ou construction d'un tableau-->
    <xsl:choose>
      <xsl:when test ="((/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position + 1]/MOTCLE) = 'NGRP') or ((/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position + 1]/MOTCLE) = 'NVDECLAE') or ((/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position + 1]/MOTCLE) = 'XVDECLAE') or ((/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position + 1]/MOTCLE) = 'CLENOUV') or ((/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position + 1]/MOTCLE) = 'EFIN') or ((/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position + 1]/MOTCLE) = 'EIND') or ((/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position + 1]/MOTCLE) = 'ENTPURG') or ((/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position + 1]/MOTCLE) = 'IDNOUV') or ((/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position + 1]/MOTCLE) = 'METAT') or ((/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position + 1]/MOTCLE) = 'NONRES') or ((/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position + 1]/MOTCLE) = 'GFONCDIR')">
        <!-- cas message simple -->
        <xsl:call-template name ="MicromoduleAEsimple">
          <xsl:with-param name ="ValeurNomGroup" select="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position]/VALEUR"></xsl:with-param>
          <xsl:with-param name ="MotcleSimple" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position + 1]/MOTCLE"></xsl:with-param>
          <xsl:with-param name ="ValeurSimple" select="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position + 1]/VALEUR"></xsl:with-param>
          <xsl:with-param name ="DateMouve" select ="/FIBEN/SERVICESAS/MODULES5/MOUVSUI/DATEMOUVE"></xsl:with-param>
        </xsl:call-template>
        <xsl:if test ="(/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position + 1]/MOTCLE) = 'XVDECLAE'">
          <table class="clWidthMax clBorderCell" role="presentation">
            <tr>
              <td class="clWidth10">&#160;</td>
              <td class="clWidth508">&#160;</td>
              <td class="clWidth260" colspan="2">&#160;</td>
            </tr>
            <tr>
              <td class="clWidth10">&#160;</td>
              <td class="clWidth508">&#160;</td>
              <td class="clWidth260" colspan="2">&#160;</td>
            </tr>
            <tr>
              <td class="clWidth10">&#160;</td>
              <td class="clTitre35 clWidth508">Les variations sont liées à corrections de montants déclarés</td>
              <td class="clWidth260" colspan="2">&#160;</td>
            </tr>
          </table >
        </xsl:if>
      </xsl:when>
      <xsl:when test = "not($position &lt; $Max)">
        <xsl:if test ="substring(/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[2]/MOTCLE,1,1) = 'X'">
          <!-- ajout message bas de page-->
          <table class="clWidthMax clBorderCell" role="presentation">
            <tr>
              <td class="clWidth10">&#160;</td>
              <td class="clWidth508">&#160;</td>
              <td class="clWidth260" colspan="2">&#160;</td>
            </tr>
            <tr>
              <td class="clWidth10">&#160;</td>
              <td class="clTitre35 clWidth508">Les variations sont liées à corrections de montants déclarés</td>
              <td class="clWidth260" colspan="2">&#160;</td>
            </tr>
          </table >
        </xsl:if>
      </xsl:when>

      <xsl:otherwise>
        <xsl:for-each select="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position]">

          <!-- cas de la creation du tableau -->
          <xsl:call-template name ="MicromoduleAETableau">
            <xsl:with-param name ="MotcleTableau" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position + 1]/MOTCLE"></xsl:with-param>
            <xsl:with-param name ="DateMouve" select ="/FIBEN/SERVICESAS/MODULES5/MOUVSUI/DATEMOUVE"></xsl:with-param>
            <xsl:with-param name ="positionDebut" select ="$position"></xsl:with-param>
            <xsl:with-param name ="position" select ="$position + 1"></xsl:with-param>
            <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
          </xsl:call-template>

        </xsl:for-each>

      </xsl:otherwise>
    </xsl:choose>


  </xsl:template>

  <xsl:template name="TestMicromoduleAE2">
    <xsl:param name ="Max"></xsl:param>
    <xsl:param name="position"></xsl:param>
    <!-- test pour savoir si message simple (conrespondant à une premiere déclaration) ou construction d'un tableau-->
    <xsl:choose>
      <xsl:when test ="((/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position]/MOTCLE) = 'NGRP') or ((/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position]/MOTCLE) = 'NVDECLAE') or ((/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position]/MOTCLE) = 'XVDECLAE') or ((/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position]/MOTCLE) = 'CLENOUV') or ((/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position]/MOTCLE) = 'EFIN') or ((/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position]/MOTCLE) = 'EIND') or ((/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position]/MOTCLE) = 'ENTPURG') or ((/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position]/MOTCLE) = 'IDNOUV') or ((/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position]/MOTCLE) = 'METAT') or ((/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position]/MOTCLE) = 'NONRES') or ((/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position]/MOTCLE) = 'GFONCDIR')">
        <!-- cas message simple -->
        <xsl:call-template name ="MicromoduleAEsimple2">
          <xsl:with-param name ="MotcleSimple" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position]/MOTCLE"></xsl:with-param>
          <xsl:with-param name ="ValeurSimple" select="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position]/VALEUR"></xsl:with-param>
          <xsl:with-param name ="DateMouve" select ="/FIBEN/SERVICESAS/MODULES5/MOUVSUI/DATEMOUVE"></xsl:with-param>
        </xsl:call-template>
        <xsl:if test ="(/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position]/MOTCLE) = 'XVDECLAE'">
          <table class="clWidthMax clBorderCell" role="presentation">
            <tr>
              <td class="clWidth10">&#160;</td>
              <td class="clWidth508">&#160;</td>
              <td class="clWidth260" colspan="2">&#160;</td>
            </tr>
            <tr>
              <td class="clWidth10">&#160;</td>
              <td class="clWidth508">&#160;</td>
              <td class="clWidth260" colspan="2">&#160;</td>
            </tr>
            <tr>
              <td class="clWidth10">&#160;</td>
              <td class="clTitre35 clWidth508">Les variations sont liées à corrections de montants déclarés</td>
              <td class="clWidth260" colspan="2">&#160;</td>
            </tr>
          </table >
        </xsl:if>
      </xsl:when>
      <xsl:when test = "not($position &lt; $Max)">
        <xsl:if test ="substring(/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[1]/MOTCLE,1,1) = 'X'">
          <!-- ajout message bas de page-->
          <table class="clWidthMax clBorderCell" role="presentation">
            <tr>
              <td class="clWidth10">&#160;</td>
              <td class="clWidth508">&#160;</td>
              <td class="clWidth260" colspan="2">&#160;</td>
            </tr>
            <tr>
              <td class="clWidth10">&#160;</td>
              <td class="clTitre35 clWidth508">Les variations sont liées à corrections de montants déclarés</td>
              <td class="clWidth260" colspan="2">&#160;</td>
            </tr>
          </table >
        </xsl:if>
      </xsl:when>

      <xsl:otherwise>
        <xsl:for-each select="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position]">

          <!-- cas de la creation du tableau -->
          <xsl:call-template name ="MicromoduleAETableau2">
            <xsl:with-param name ="MotcleTableau" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position]/MOTCLE"></xsl:with-param>
            <xsl:with-param name ="DateMouve" select ="/FIBEN/SERVICESAS/MODULES5/MOUVSUI/DATEMOUVE"></xsl:with-param>
            <xsl:with-param name ="positionDebut" select ="$position"></xsl:with-param>
            <xsl:with-param name ="position" select ="$position"></xsl:with-param>
            <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
          </xsl:call-template>

        </xsl:for-each>

      </xsl:otherwise>
    </xsl:choose>


  </xsl:template>

  <xsl:template name="MicromoduleAEsimple">
    <xsl:param name ="ValeurNomGroup"></xsl:param>
    <xsl:param name ="MotcleSimple"></xsl:param>
    <xsl:param name ="ValeurSimple"></xsl:param>
    <xsl:param name ="DateMouve"></xsl:param>

    <xsl:choose>
      <xsl:when test ="($MotcleSimple = 'NGRP') or ($MotcleSimple = 'CLENOUV') or ($MotcleSimple = 'EFIN') or ($MotcleSimple = 'EIND') or ($MotcleSimple = 'ENTPURG') or ($MotcleSimple = 'IDNOUV') or ($MotcleSimple = 'METAT') or ($MotcleSimple = 'NONRES') or ($MotcleSimple = 'GFONCDIR')">
        <table class="clWidthMax clBorderCell" role="presentation">
          <tr>
            <td class="clWidth10">&#160;</td>
            <td class="clWidth155">&#160;</td>
            <td class="clTexte clWidth613"></td>
          </tr>
          <tr>
            <td class="clWidth10">&#160;</td>
            <td class="clWidth155">Nom du groupe : </td>
            <td class="clTexte clWidth613">
              <xsl:value-of select="$ValeurNomGroup"/>&#160;
            </td>
          </tr>
        </table>
        <table class="clWidthMax clBorderCell" role="presentation">
          <tr>
            <td class="clWidth10 clHeight20">&#160;</td>
            <td class="clWidth768 clHeight20">&#160;</td>
          </tr>
          <tr>
            <td class="clWidth10">&#160;</td>
            <td class="clTexte clWidth768">
              <xsl:value-of select="($dictionnaire/mot[@id=$MotcleSimple])"/>&#160;
              <xsl:choose>
                <xsl:when test ="./CONVERT">
                  <xsl:value-of select="($dictionnaire/mot[@id=$ValeurSimple])"/>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select ="$ValeurSimple"/>
                </xsl:otherwise>
              </xsl:choose>
            </td>
          </tr>
        </table>

      </xsl:when>
      <xsl:otherwise>

        <!-- affichage date de la mise a jour format 31/03/2012 (recup de date du mouvement-->
        <table class="clWidthMax clBorderCell" role="presentation">
          <tr>
            <td class="clWidth10">&#160;</td>
            <td class="clWidth155">&#160;</td>
            <td class="clTexte clWidth613"></td>
          </tr>
          <tr>
            <td class="clWidth10">&#160;</td>
            <td class="clWidth155">Nom du groupe : </td>
            <td class="clTexte clWidth613">
              <xsl:value-of select="$ValeurNomGroup"/>&#160;
            </td>
          </tr>
          <tr>
            <td class="clWidth10">&#160;</td>
            <td class="clWidth155">&#160;</td>
            <td class="clTexte clWidth613"></td>
          </tr>
          <tr>
            <td class="clWidth10">&#160;</td>
            <td class="clTexte clWidth155">Date de la mise à jour : </td>
            <td class="clTexte clWidth613">
              <xsl:call-template name ="displayDateXsl">
                <xsl:with-param name ="InputDate" select ="$DateMouve"/>
              </xsl:call-template>
            </td>
          </tr>
        </table>
        <table class="clWidthMax clBorderCell" role="presentation">
          <tr>
            <td class="clWidth10">&#160;</td>
            <td class="clTexte clWidth768"></td>
          </tr>
        </table>
        <table class="clWidthMax clBorderCell" role="presentation">
          <xsl:if test ="substring($MotcleSimple,1,1) = 'X'">
            <tr>
              <!-- 1er partie libelle -->
              <td class="clWidth10">&#160;</td>
              <td class="clTexte clWidth440">
                <xsl:value-of select="substring(($dictionnaire/mot[@id=(concat('N',substring($MotcleSimple,2,7)))]),1,68)"/>
              </td>
              <td class="clWidth318">&#160;</td>
            </tr>
            <tr>
              <td class="clWidth10">&#160;</td>
              <td class="clWidth440">&#160;</td>
              <td class="clWidth318">&#160;</td>
            </tr>
            <tr>
              <!-- 2eme partie libelle -->
              <td class="clWidth10">&#160;</td>
              <td class="clTexte clWidth440">
                <xsl:value-of select="substring(($dictionnaire/mot[@id=(concat('N',substring($MotcleSimple,2,7)))]),69,64)"/>
                <xsl:call-template name ="displayFormatNombre">
                  <xsl:with-param name ="InputValeur" select ="$ValeurSimple"/>
                </xsl:call-template>
              </td>
              <td class="clWidth318">&#160;</td>
            </tr>
          </xsl:if>
          <xsl:if test ="substring($MotcleSimple,1,1) = 'N'">
            <tr>
              <!-- 1er partie libelle -->
              <td class="clWidth10">&#160;</td>
              <td class="clTexte clWidth440">
                <xsl:value-of select="substring(($dictionnaire/mot[@id=$MotcleSimple]),1,68)"/>
              </td>
              <td class="clWidth318">&#160;</td>
            </tr>
            <tr>
              <td class="clWidth10">&#160;</td>
              <td class="clWidth440">&#160;</td>
              <td class="clWidth318">&#160;</td>
            </tr>
            <tr>
              <!-- 2eme partie libelle -->
              <td class="clWidth10">&#160;</td>
              <td class="clTexte clWidth440">
                <xsl:value-of select="substring(($dictionnaire/mot[@id=$MotcleSimple]),69,64)"/>&#160;
                <xsl:call-template name ="displayFormatNombre">
                  <xsl:with-param name ="InputValeur" select ="$ValeurSimple"/>
                </xsl:call-template>
              </td>
              <td class="clWidth318">&#160;</td>
            </tr>
          </xsl:if>
        </table>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="MicromoduleAEsimple2">
    <xsl:param name ="MotcleSimple"></xsl:param>
    <xsl:param name ="ValeurSimple"></xsl:param>
    <xsl:param name ="DateMouve"></xsl:param>

    <xsl:choose>
      <xsl:when test ="($MotcleSimple = 'NGRP') or ($MotcleSimple = 'CLENOUV') or ($MotcleSimple = 'EFIN') or ($MotcleSimple = 'EIND') or ($MotcleSimple = 'ENTPURG') or ($MotcleSimple = 'IDNOUV') or ($MotcleSimple = 'METAT') or ($MotcleSimple = 'NONRES') or ($MotcleSimple = 'GFONCDIR')">
        <table class="clWidthMax clBorderCell" role="presentation">
          <tr>
            <td class="clWidth10 clHeight20">&#160;</td>
            <td class="clWidth768 clHeight20">&#160;</td>
          </tr>
          <tr>
            <td class="clWidth10">&#160;</td>
            <td class="clTexte clWidth768">
              <xsl:value-of select="($dictionnaire/mot[@id=$MotcleSimple])"/>&#160;
              <xsl:choose>
                <xsl:when test ="./CONVERT">
                  <xsl:value-of select="($dictionnaire/mot[@id=$ValeurSimple])"/>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select ="$ValeurSimple"/>
                </xsl:otherwise>
              </xsl:choose>
            </td>
          </tr>
        </table>

      </xsl:when>
      <xsl:otherwise>

        <!-- affichage date de la mise a jour format 31/03/2012 (recup de date du mouvement-->
        <table class="clWidthMax clBorderCell" role="presentation">
          <tr>
            <td class="clWidth10">&#160;</td>
            <td class="clWidth155">&#160;</td>
            <td class="clTexte clWidth613"></td>
          </tr>
          <tr>
            <td class="clWidth10">&#160;</td>
            <td class="clTexte clWidth155">Date de la mise à jour : </td>
            <td class="clTexte clWidth613">
              <xsl:call-template name ="displayDateXsl">
                <xsl:with-param name ="InputDate" select ="$DateMouve"/>
              </xsl:call-template>
            </td>
          </tr>
        </table>
        <table class="clWidthMax clBorderCell" role="presentation">
          <tr>
            <td class="clWidth10">&#160;</td>
            <td class="clTexte clWidth768"></td>
          </tr>
        </table>
        <table class="clWidthMax clBorderCell" role="presentation">
          <xsl:if test ="substring($MotcleSimple,1,1) = 'X'">
            <tr>
              <!-- 1er partie libelle -->
              <td class="clWidth10">&#160;</td>
              <td class="clTexte clWidth440">
                <xsl:value-of select="substring(($dictionnaire/mot[@id=(concat('N',substring($MotcleSimple,2,7)))]),1,68)"/>
              </td>
              <td class="clWidth318">&#160;</td>
            </tr>
            <tr>
              <td class="clWidth10">&#160;</td>
              <td class="clWidth440">&#160;</td>
              <td class="clWidth318">&#160;</td>
            </tr>
            <tr>
              <!-- 2eme partie libelle -->
              <td class="clWidth10">&#160;</td>
              <td class="clTexte clWidth440">
                <xsl:value-of select="substring(($dictionnaire/mot[@id=(concat('N',substring($MotcleSimple,2,7)))]),69,64)"/>
                <xsl:call-template name ="displayFormatNombre">
                  <xsl:with-param name ="InputValeur" select ="$ValeurSimple"/>
                </xsl:call-template>
              </td>
              <td class="clWidth318">&#160;</td>
            </tr>
          </xsl:if>
          <xsl:if test ="substring($MotcleSimple,1,1) = 'N'">
            <tr>
              <!-- 1er partie libelle -->
              <td class="clWidth10">&#160;</td>
              <td class="clTexte clWidth440">
                <xsl:value-of select="substring(($dictionnaire/mot[@id=$MotcleSimple]),1,68)"/>
              </td>
              <td class="clWidth318">&#160;</td>
            </tr>
            <tr>
              <td class="clWidth10">&#160;</td>
              <td class="clWidth440">&#160;</td>
              <td class="clWidth318">&#160;</td>
            </tr>
            <tr>
              <!-- 2eme partie libelle -->
              <td class="clWidth10">&#160;</td>
              <td class="clTexte clWidth440">
                <xsl:value-of select="substring(($dictionnaire/mot[@id=$MotcleSimple]),69,64)"/>&#160;
                <xsl:call-template name ="displayFormatNombre">
                  <xsl:with-param name ="InputValeur" select ="$ValeurSimple"/>
                </xsl:call-template>
              </td>
              <td class="clWidth318">&#160;</td>
            </tr>
          </xsl:if>
        </table>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="MicromoduleAETableau">
    <xsl:param name ="MotcleTableau"></xsl:param>
    <xsl:param name ="DateMouve"></xsl:param>
    <xsl:param name ="positionDebut"></xsl:param>
    <xsl:param name ="position"></xsl:param>
    <xsl:param name ="Max"></xsl:param>

    <xsl:variable name ="PositionSuivante"  select ="$position + 1"></xsl:variable>
    <xsl:if test ="$position = 2">

      <!-- affichage date de la mise a jour format 31/03/2012 (recup de date du mouvement-->

      <table class="clWidthMax clBorderCell" role="presentation">
        <tr>
          <td class="clWidth10">&#160;</td>
          <td class="clWidth155">&#160;</td>
          <td class="clTexte clWidth613"></td>
        </tr>
        <tr>
          <td class="clWidth10">&#160;</td>
          <td class="clWidth155">Nom du groupe : </td>
          <td class="clTexte clWidth613">
            <xsl:value-of select="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$positionDebut]/VALEUR"/>&#160;
          </td>
        </tr>
        <tr>
          <td class="clWidth10">&#160;</td>
          <td class="clWidth155">&#160;</td>
          <td class="clTexte clWidth613"></td>
        </tr>
        <tr>
          <td class="clWidth10">&#160;</td>
          <td class="clTexte clWidth155">Date de la mise à jour : </td>
          <td class="clTexte clWidth613">
            <xsl:call-template name ="displayDateXsl">
              <xsl:with-param name ="InputDate" select ="$DateMouve"/>
            </xsl:call-template>
          </td>
        </tr>
      </table>
      <table class="clWidthMax clBorderCell" role="presentation">
        <tr>
          <td class="clWidth10">&#160;</td>
          <td class="clTexte clWidth768"></td>
        </tr>
      </table>
      <table class="clWidthMax clBorderCell" role="presentation">
        <tr>
          <td class="clWidth10">&#160;</td>
          <td class="clTexte clWidth508"></td>
          <td class="clTexte clWidth260 clAlignCenter" colspan="2">Montant centralisé du mois par rapport à</td>
        </tr>
        <tr>
          <td class="clWidth10">&#160;</td>
          <td class="clTexte clWidth508"></td>
          <td class="clTexte clWidth130 clAlignCenter">Mois précédent</td>
          <td class="clTexte clWidth130 clAlignCenter">Année précédente</td>
        </tr>
        <tr>
          <td class="clWidth10">&#160;</td>
          <td class="clWidth508">&#160;</td>
          <td class="clWidth130">&#160;</td>
          <td class="clWidth130">&#160;</td>
        </tr>
      </table>
    </xsl:if>
    <xsl:if test ="$position &lt; $Max">
      <table class="clWidthMax clBorderCell" role="presentation">
        <tr>
          <td class="clWidth10">&#160;</td>
          <xsl:if test ="substring($MotcleTableau,1,1) = 'X'">
            <td class="clTexte clWidth508">
              <xsl:value-of select="($dictionnaire/mot[@id=(concat('V',substring($MotcleTableau,2,7)))])"/>&#160;
            </td>
          </xsl:if>
          <xsl:if test ="substring($MotcleTableau,1,1) = 'V'">
            <td class="clTexte clWidth508">
              <xsl:value-of select="($dictionnaire/mot[@id=$MotcleTableau])"/>&#160;
            </td>
          </xsl:if>
          <td class="clWidth130 clAlignCenter">
            <xsl:variable name ="valeur1erPos" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position]/VALEUR"></xsl:variable>
            <xsl:call-template name ="displayFormatNombre">
              <xsl:with-param name ="InputValeur" select ="$valeur1erPos"/>
            </xsl:call-template>
          </td>
          <td class="clWidth130 clAlignCenter">
            <xsl:variable name ="valeur2emePos" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante]/VALEUR"></xsl:variable>
            <xsl:call-template name ="displayFormatNombre">
              <xsl:with-param name ="InputValeur" select ="$valeur2emePos"/>
            </xsl:call-template>
          </td>
        </tr>
        <tr>
          <td class="clWidth10">&#160;</td>
          <td class="clWidth508">&#160;</td>
          <td class="clWidth130">&#160;</td>
          <td class="clWidth130">&#160;</td>
        </tr>
      </table>
    </xsl:if>
    <xsl:call-template name ="TestMicromoduleAE">
      <xsl:with-param name ="position" select ="$position + 1"></xsl:with-param>
      <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
    </xsl:call-template>

  </xsl:template>

  <xsl:template name="MicromoduleAETableau2">
    <xsl:param name ="MotcleTableau"></xsl:param>
    <xsl:param name ="DateMouve"></xsl:param>
    <xsl:param name ="positionDebut"></xsl:param>
    <xsl:param name ="position"></xsl:param>
    <xsl:param name ="Max"></xsl:param>

    <xsl:variable name ="PositionSuivante"  select ="$position + 1"></xsl:variable>
    <xsl:if test ="$position = 1">

      <!-- affichage date de la mise a jour format 31/03/2012 (recup de date du mouvement-->

      <table class="clWidthMax clBorderCell" role="presentation">
        <tr>
          <td class="clWidth10">&#160;</td>
          <td class="clWidth155">&#160;</td>
          <td class="clTexte clWidth613"></td>
        </tr>

        <tr>
          <td class="clWidth10">&#160;</td>
          <td class="clTexte clWidth155">Date de la mise à jour : </td>
          <td class="clTexte clWidth613">
            <xsl:call-template name ="displayDateXsl">
              <xsl:with-param name ="InputDate" select ="$DateMouve"/>
            </xsl:call-template>
          </td>
        </tr>
      </table>
      <table class="clWidthMax clBorderCell" role="presentation">
        <tr>
          <td class="clWidth10">&#160;</td>
          <td class="clTexte clWidth768"></td>
        </tr>
      </table>
      <table class="clWidthMax clBorderCell" role="presentation">
        <tr>
          <td class="clWidth10">&#160;</td>
          <td class="clTexte clWidth508"></td>
          <td class="clTexte clWidth260 clAlignCenter" colspan="2">Montant centralisé du mois par rapport à</td>
        </tr>
        <tr>
          <td class="clWidth10">&#160;</td>
          <td class="clTexte clWidth508"></td>
          <td class="clTexte clWidth130 clAlignCenter">Mois précédent</td>
          <td class="clTexte clWidth130 clAlignCenter">Année précédente</td>
        </tr>
        <tr>
          <td class="clWidth10">&#160;</td>
          <td class="clWidth508">&#160;</td>
          <td class="clWidth130">&#160;</td>
          <td class="clWidth130">&#160;</td>
        </tr>
      </table>
    </xsl:if>
    <xsl:if test ="$position &lt; $Max">
      <table class="clWidthMax clBorderCell" role="presentation">
        <tr>
          <td class="clWidth10">&#160;</td>
          <xsl:if test ="substring($MotcleTableau,1,1) = 'X'">
            <td class="clTexte clWidth508">
              <xsl:value-of select="($dictionnaire/mot[@id=(concat('V',substring($MotcleTableau,2,7)))])"/>&#160;
            </td>
          </xsl:if>
          <xsl:if test ="substring($MotcleTableau,1,1) = 'V'">
            <td class="clTexte clWidth508">
              <xsl:value-of select="($dictionnaire/mot[@id=$MotcleTableau])"/>&#160;
            </td>
          </xsl:if>
          <td class="clWidth130 clAlignCenter">
            <xsl:variable name ="valeur1erPos" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position]/VALEUR"></xsl:variable>
            <xsl:call-template name ="displayFormatNombre">
              <xsl:with-param name ="InputValeur" select ="$valeur1erPos"/>
            </xsl:call-template>
          </td>
          <td class="clWidth130 clAlignCenter">
            <xsl:variable name ="valeur2emePos" select ="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$PositionSuivante]/VALEUR"></xsl:variable>
            <xsl:call-template name ="displayFormatNombre">
              <xsl:with-param name ="InputValeur" select ="$valeur2emePos"/>
            </xsl:call-template>
          </td>
        </tr>
        <tr>
          <td class="clWidth10">&#160;</td>
          <td class="clWidth508">&#160;</td>
          <td class="clWidth130">&#160;</td>
          <td class="clWidth130">&#160;</td>
        </tr>
      </table>
    </xsl:if>
    <xsl:call-template name ="TestMicromoduleAE2">
      <xsl:with-param name ="position" select ="$position + 2"></xsl:with-param>
      <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
    </xsl:call-template>

  </xsl:template>

  <xsl:template name="MicromoduleMessInformatifSimple">
    <xsl:param name ="MotcleMessInfo"></xsl:param>
    <xsl:param name ="ValeurMessInfo"></xsl:param>
    <xsl:param name ="DateMouve"></xsl:param>
    <xsl:param name ="position"></xsl:param>
    <xsl:param name ="Max"></xsl:param>


    <table class="clWidthMax clBorderCell" role="presentation">
      <tr>
        <td class="clWidth10 clHeight20">&#160;</td>
        <td class="clWidth768 clHeight20">&#160;</td>
      </tr>
      <tr>
        <td class="clWidth10">&#160;</td>
        <td class="clTexte clWidth768">
          <xsl:value-of select="($dictionnaire/mot[@id=$MotcleMessInfo])"/>&#160;
          <xsl:choose>
            <xsl:when test ="./CONVERT">
              <xsl:value-of select="($dictionnaire/mot[@id=$MotcleMessInfo])"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select ="$ValeurMessInfo"/>
            </xsl:otherwise>
          </xsl:choose>
        </td>
      </tr>
    </table>

  </xsl:template >

  <xsl:template name="MicromoduleMessInformatif">
    <xsl:param name ="MotcleMessInfo"></xsl:param>
    <xsl:param name ="ValeurMessInfo"></xsl:param>
    <xsl:param name ="DateMouve"></xsl:param>
    <xsl:param name ="position"></xsl:param>
    <xsl:param name ="Max"></xsl:param>

    <xsl:if test ="not($position &gt; $Max)">
      <xsl:for-each select="/FIBEN/SERVICESAS/MODULES5/MOTCLESUIVI[$position]">
        <xsl:variable name ="Motcle99" select ="MOTCLE"></xsl:variable>
        <xsl:variable name ="Valeur99" select="VALEUR"></xsl:variable>

        <!-- plusieur ligne de message d'erreur -->
        <xsl:call-template name ="AfficheMessInformatif">
          <xsl:with-param name ="MotcleMessInfo" select ="$Motcle99"></xsl:with-param>
          <xsl:with-param name ="ValeurMessInfo" select ="$Valeur99"></xsl:with-param>
          <xsl:with-param name ="DateMouve" select ="/FIBEN/SERVICESAS/MODULES5/MOUVSUI/DATEMOUVE"></xsl:with-param>
          <xsl:with-param name ="position" select ="$position"></xsl:with-param>
          <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
        </xsl:call-template>
      </xsl:for-each>
    </xsl:if>


  </xsl:template >


  <xsl:template name="AfficheMessInformatif">
    <xsl:param name ="MotcleMessInfo"></xsl:param>
    <xsl:param name ="ValeurMessInfo"></xsl:param>
    <xsl:param name ="DateMouve"></xsl:param>
    <xsl:param name ="position"></xsl:param>
    <xsl:param name ="Max"></xsl:param>
    <table class="clWidthMax clBorderCell" role="presentation">
      <tr>
        <td class="clWidth10 clHeight20">&#160;</td>
        <td class="clWidth768 clHeight20">&#160;</td>
      </tr>
      <tr>
        <td class="clWidth10">&#160;</td>
        <td class="clTexte clWidth768">
          <xsl:value-of select="($dictionnaire/mot[@id=$MotcleMessInfo])"/>&#160;
          <xsl:choose>
            <xsl:when test ="./CONVERT">
              <xsl:value-of select="($dictionnaire/mot[@id=$MotcleMessInfo])"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select ="$ValeurMessInfo"/>
            </xsl:otherwise>
          </xsl:choose>
        </td>
      </tr>
    </table>
    <xsl:call-template name ="MicromoduleMessInformatif">
      <xsl:with-param name ="position" select ="$position + 1"></xsl:with-param>
      <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
    </xsl:call-template>
  </xsl:template>


</xsl:stylesheet>





