<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"  xmlns:bdf="http://banque-france.fr/namespace">
  <xsl:import href="../../Ressources/XSL/Commun.xsl"/>
  <xsl:import href="../../Ressources/XSL/Commun_SAS.xsl"/>
  <xsl:import href="../../Ressources/XSL/commun_transfo.xsl"/>
  <xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes"/>
  <xsl:param name="langage" select="'fr'"/>
  <xsl:param name="familyNumber" select="''"/>
  <xsl:param name="root" select="'/Fiben/'"/>
  <xsl:param name="familyName" select="''"/>
  <xsl:param name="familyTitle" select="''"/>
  <xsl:param name="nextModule" select="''"/>
  <xsl:param name="nextId" select="''"/>
  <xsl:param name="nextFamily" select="''"/>
  <xsl:param name="Lang" select="'FR'"/>
  <xsl:param name="NonResident" select="''"/>
  <xsl:param name="menuHTML1"/>

  <!--TEMPLATE PRINCIPAL-->
  <xsl:template match="/">
    <html lang="fr" xmlns="http://www.w3.org/1999/xhtml">
      <title>Module S4 - Liste des mouvements sur les entités suivies</title>
      <xsl:call-template name="genHeadSAS">
      </xsl:call-template>
      <body class="clBodybgcolorWhite">
        <xsl:call-template name="genFondMenu">
          <xsl:with-param name="root" select="$root"/>
          <xsl:with-param name="type" select="'suivi'" />
        </xsl:call-template>
        <!-- Affichage des menus: EVOL 2016 -->
        <xsl:copy-of select="$menuHTML1"/>
       
        <xsl:if test="/FIBEN/ERREUR">
          <xsl:call-template name="GestionErreurSAS" >
            <xsl:with-param name="root" select="$root"/>
            <xsl:with-param name="familyTitle" select="$familyTitle" />
          </xsl:call-template>
        </xsl:if >
        <xsl:if test="not(/FIBEN/ERREUR)">
          <table class="mainmodule horizontal-auto HomeData clBorderCell">
            <caption class="visually-hidden">Module S4 - Liste des mouvements sur les entités suivies</caption>
            <tr>
             <td class="clWidth20"></td>
              <td class="clWidth636" colspan="2">
                <form method="Post" name="frmForm1">
                  <input type="hidden" name="ident" value=""/>
                  <table class="clWidthMax clBorderCell" role="presentation">
                    <tr>
                      <td>
                        <!-- Affichage du bandeau titre: -->
                        <xsl:call-template name="BandeauInfSuivi" >
                          <xsl:with-param name="Titre" select="$dictionnaire/titre[@module=$moddem]"/>
                          <xsl:with-param name="root" select="$root"/>
                        </xsl:call-template>
                        &#160;
                      </td>
                    </tr>
                  </table>

                  <!-- si pas de mouvements de suivi afficher un message d'info-->
                  <xsl:choose>
                    <xsl:when test ="FIBEN/SERVICESAS/CLIENTSAS/NBSAS = 0">
                      <table class="clWidthMax clBorderCell">
                        <tr>
                          <td class="clWidth17"></td>
                          <td class="clTitre2 clWidth768 clAlignLeft">Vous n'avez actuellement aucun suivi en cours</td>
                        </tr>
                      </table>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:choose>
                        <xsl:when test ="count(//MOUVE) = 0">
                          <table class="clBorderCell clWidth778" role="presentation">
                            <tr>
                              <td class="clWidth17"></td>
                              <td class="clTitre2 clWidth768 clAlignLeft"> Vous n'avez actuellement aucun mouvements sur vos entités sous suivi</td>
                            </tr>
                          </table>
                        </xsl:when>
                        <xsl:otherwise>
                          <!-- tableau pour choix du tri-->
                          <table class="clWidthMax clBorderCell" role="presentation">
                            <tr>
                               <td class="clWidth19"> </td>
                              <td class="clGras clWidth269 clBorder0">
                                Triez vos mouvements par :
                              </td>
                              <td class="clWidth500 clAlignLeft">

                                <select id="lst_TrieMouve"  size="1" class="clChamp" onchange="ChangeTriListeSuivisMouve(this);">
                                  <xsl:variable name="tri" select="//TRI"/>
                                  <xsl:choose>
                                    <xsl:when test="$tri='DA'">
                                      <option selected="true" value="DA">Date de mouvement</option>
                                      <option value="ID">Identifiant</option>
                                      <option value="RF">Référence</option>
                                      <option value="TY">Type de suivi</option>                                      
                                    </xsl:when>
                                    <xsl:when test="$tri='ID'">
                                      <option  value="DA">Date de mouvement</option>
                                      <option selected="true" value="ID">Identifiant</option>
                                      <option value="RF">Référence</option>
                                      <option value="TY">Type de suivi</option>                                     
                                    </xsl:when>
                                    <xsl:when test="$tri='RF'">
                                      <option value="DA">Date de mouvement</option>
                                      <option value="ID">Identifiant</option>
                                      <option selected="true" value="RF">Référence</option>
                                      <option value="TY">Type de suivi</option>                                      
                                    </xsl:when>
                                    <xsl:when test="$tri='TY'">
                                      <option value="DA">Date de mouvement</option>
                                      <option value="ID">Identifiant</option>
                                      <option value="RF">Référence</option>
                                      <option selected="true" value="TY">Type de suivi</option>                                      
                                    </xsl:when>                                    
                                    <xsl:otherwise>
                                      <option selected="true" value="DA">Date de mouvement</option>
                                      <option value="ID">Identifiant</option>
                                      <option value="RF">Référence</option>
                                      <option value="TY">Type de suivi</option>                                      
                                    </xsl:otherwise>
                                  </xsl:choose>
                                </select>
                              </td>
                            </tr>
                          </table>
                          <br/>

                          <img src="{$root}images/risque/shim_bleu.gif" width="768" height="1" alt=""/>
                          <br/>
                          <!-- tableau des entités sous suivi -->
                          <div  id="Lst_Suivis" class="clLst_Alertes" >
                            <!-- tester présence balise MOUV avant appel <xsl:call-template name="LigneMouveSuivis"> -->
                            <!-- ajout de l'ensemble des lignes avec les données-->
                            <xsl:if test="count(//MOUVE) != 0">

                              <!-- traitement du premier mouvement-->
                              <!-- cas des données triées par date -->
                              <xsl:if test ="(//TRI) = 'DA'">
                                <xsl:call-template name ="ligneDate">
                                  <xsl:with-param name ="dateafficher" select ="//MOUVE[1]/DATEMOUVE/text()"/>
                                </xsl:call-template>
                              </xsl:if>
                              <!--  cas des données triées par Type de suivi -->
                              <xsl:if test ="(//TRI) = 'TY'">
                                <xsl:call-template name ="ligneTypeSuivi">
                                  <xsl:with-param name ="typesuivi" select ="//MOUVE[1]/TYPESUIVI/text()"/>
                                  <xsl:with-param name ="package" select ="//MOUVE[1]/PACKAGE/text()"/>
                                </xsl:call-template>
                              </xsl:if>
                              <!--  cas des données triées par Référence -->
                              <xsl:if test ="(//TRI) = 'RF'">
                                <xsl:call-template name ="ligneRef">
                                  <xsl:with-param name ="reference" select ="//MOUVE[1]/REFERENCE/text()"/>                                 
                                </xsl:call-template>
                              </xsl:if>
                              <!--  cas des données triées par identifiants -->
                              <xsl:if test ="(//TRI) = 'ID'">
                                <xsl:call-template name ="ligneIdent">
                                  <xsl:with-param name ="nom" select ="//MOUVE[1]/NOM/text()"/>
                                  <xsl:with-param name ="prenom" select ="//MOUVE[1]/PRENOM/text()"/>
                                </xsl:call-template>
                              </xsl:if>

                              <xsl:call-template name ="LigneDonnee">
                                <xsl:with-param name ="donnees" select ="//MOUVE[1]"></xsl:with-param>
                                <xsl:with-param name="tri" select ="//TRI"></xsl:with-param>
                              </xsl:call-template>

                              <!-- traitement du reste des mouvements-->
                              <xsl:if test="count(//MOUVE) &gt; 1">
                                <xsl:call-template name="LigneMouveSuivis">
                                  <xsl:with-param name="debut" select="2" />
                                  <xsl:with-param name="fin" select="count(//MOUVE)" />
                                </xsl:call-template>
                              </xsl:if>
                            </xsl:if>
                          </div>
                          <br/>
                       </xsl:otherwise>
                      </xsl:choose>
                    </xsl:otherwise>
                  </xsl:choose>
                  <img src="{$root}images/risque/shim_bleu.gif" width="768" height="1" alt=""/>
                  <br/>
                </form>
              </td>
            </tr>
          </table>
        </xsl:if>

        <xsl:call-template name="genBasPage"/>

      </body>
    </html>
  </xsl:template>


  <xsl:template name="LigneMouveSuivis">
    <xsl:param name="debut" />
    <xsl:param name="fin"  />
    
    <!-- cas des donnes tries par date -->
    <xsl:if test ="(//TRI) = 'DA'">

    <xsl:variable name ="DateCourant"  select ="//MOUVE[$debut]/DATEMOUVE/text()"/>
 
      <xsl:variable name ="Positiondateprecedente" select ="$debut - 1"/>
      <xsl:variable name ="dateprecedente" select ="//MOUVE[$Positiondateprecedente]/DATEMOUVE/text()"/>
      <xsl:if test="$dateprecedente[1]!=$DateCourant[1]">
        <br/>
        <xsl:call-template name ="Ligneshim"></xsl:call-template>
        <xsl:call-template name ="ligneDate">
          <xsl:with-param name ="dateafficher" select ="$DateCourant[1]"/>
        </xsl:call-template>
      </xsl:if>
    </xsl:if>
    <!-- cas des donnes tries par TYPE DE SUIVI -->
    <xsl:if test ="(//TRI) = 'TY'">
      <xsl:variable name ="TypeSuiviCourant"  select ="//MOUVE[$debut]/TYPESUIVI/text()"/>
      <xsl:variable name ="Positiontypesuiviprecedent" select ="$debut - 1"/>
      <xsl:variable name ="TypeSuiviprecedent" select ="//MOUVE[$Positiontypesuiviprecedent]/TYPESUIVI/text()"/>
      <xsl:if test="$TypeSuiviprecedent[1]!=$TypeSuiviCourant[1]">
        <br/>
        <xsl:call-template name ="Ligneshim"></xsl:call-template>
        <xsl:call-template name ="ligneTypeSuivi">
          <xsl:with-param name ="typesuivi" select ="//MOUVE[$debut]/TYPESUIVI/text()"/>
          <xsl:with-param name ="package" select ="//MOUVE[$debut]/PACKAGE/text()"/>
        </xsl:call-template>
      </xsl:if>
    </xsl:if>
    <!-- cas des donnes tries par identifiant -->
    <xsl:if test ="(//TRI) = 'ID'">
      <xsl:variable name ="identCourant"  select ="//MOUVE[$debut]/IDENT/text()"/>
      <xsl:variable name ="Positionidentprecedent" select ="$debut - 1"/>
      <xsl:variable name ="Identprecedent" select ="//MOUVE[$Positionidentprecedent]/IDENT/text()"/>
      <xsl:if test="$Identprecedent[1]!=$identCourant[1]">
        <br/>
        <xsl:call-template name ="Ligneshim"></xsl:call-template>
        <xsl:call-template name ="ligneIdent">
          <xsl:with-param name ="nom" select ="//MOUVE[$debut]/NOM/text()"/>
          <xsl:with-param name ="prenom" select ="//MOUVE[$debut]/PRENOM/text()"/>
        </xsl:call-template>
      </xsl:if>
    </xsl:if>
    <!-- cas des donnes tries par Référence -->
    <xsl:if test ="(//TRI) = 'RF'">
      <xsl:variable name ="referenceCourante"  select ="//MOUVE[$debut]/REFERENCE"/>
      <xsl:variable name ="Positionreferenceprecedent" select ="$debut - 1"/>
      <xsl:variable name ="Referenceprecedent" select ="//MOUVE[$Positionreferenceprecedent]/REFERENCE"/>     
      <xsl:if test="$Referenceprecedent != $referenceCourante">
        <br/>
        <xsl:call-template name ="Ligneshim"></xsl:call-template>
        <xsl:call-template name ="ligneRef">
          <xsl:with-param name ="reference" select ="//MOUVE[$debut]/REFERENCE/text()"/>          
        </xsl:call-template>
      </xsl:if>
    </xsl:if>
    <!-- ***********************************************************************************************************************************-->
    <!-- ****** Affichage des données: ******* -->

    <xsl:call-template name ="LigneDonnee">
        <xsl:with-param name ="donnees" select ="//MOUVE[$debut]"></xsl:with-param>
      <xsl:with-param name="tri" select ="//TRI"></xsl:with-param>
      </xsl:call-template>

    <!-- Fin affichage des données: -->

    <!-- si on n'a pas fini la boucle on continue -->
    <xsl:if test="$debut &lt; $fin">
      <xsl:call-template name="LigneMouveSuivis">
        <xsl:with-param name="debut" select="($debut)+1" />
        <xsl:with-param name="fin" select="$fin" />
      </xsl:call-template>
    </xsl:if>

  </xsl:template>


  <xsl:template name ="Ligneshim">
    <table class="clWidth758 clBorderCell" role="presentation">
      <tr>
         <td class="clWidth19"> </td>
        <td>
          <img src="{$root}images/risque/shim_bleu.gif" width="758" height="1" alt=""/>
        </td>
      </tr>      
    </table>
  </xsl:template>

  <xsl:template name ="ligneDate">
    <xsl:param name="dateafficher"></xsl:param>
    <table class="clBorderCell clFont12 clWidth758" role="presentation">
      <tr class="clHeight30">
        <td class="clTexteGras clWidth140 clAlignLeft">
          <xsl:call-template name ="DisplayTitreDateSuivi">
            <xsl:with-param name ="InputDate" select ="$dateafficher"></xsl:with-param>
          </xsl:call-template>
        </td>
        <td class="clTexte clWidth377 clAlignLeft">
          &#160;
        </td>
        <td class="clTexte clWidth130 clAlignLeft">
          &#160;
        </td>
        <td class="clTexte clWidth96 clAlignCenter">
          &#160;
        </td>
      </tr>
      <tr class="clHeight10">
        <th class="clTitreBleu clWidth140 clAlignLeft clThNonGras">Identifiant</th>
        <th class="clTitreBleu clWidth377 clAlignLeft clThNonGras">Dénomination / Nom</th>
        <th class="clTitreBleu clWidth130 clAlignCenter clThNonGras">Référence</th>
        <th class="clTitreBleu clWidth96 clAlignCenter clThNonGras">Suivi</th>
      </tr>
    </table>

  </xsl:template>

  
  <xsl:template name ="ligneTypeSuivi">
    <xsl:param name="typesuivi"></xsl:param>
    <xsl:param name="package"></xsl:param>
    <table class="clBorderCell clFont12 clWidth758">
      <tr class="clHeight30">

        <td class="clTexteGras clWidth551 clAlignLeft" colspan="3">
          Module&#160;<xsl:value-of select="$typesuivi"/>
          &#160;:&#160;
          <xsl:call-template name="traductionTypeSuivi">
            <xsl:with-param name="codeTypeSuivi" select="$typesuivi"/>
          </xsl:call-template>        
        </td>
       <td class="clTexte clWidth192 clAlignCenter" colspan="2">
          &#160;
        </td>
      </tr>
      <tr class="clHeight10">

        <th class="clTitreBleu clWidth140 clAlignLeft clThNonGras">Identifiant</th>
        <th class="clTitreBleu clWidth281 clAlignLeft clThNonGras">Dénomination / Nom</th>
        <th class="clTitreBleu clWidth130 clAlignCenter clThNonGras">Référence</th>
        <th class="clTitreBleu clWidth96 clAlignCenter clThNonGras">Package</th>  
        <th class="clTitreBleu clWidth96 clAlignCenter clThNonGras">Date MVT</th>
      </tr>
    </table>

  </xsl:template>

  <xsl:template name ="ligneRef">
    <xsl:param name="reference"></xsl:param>    
    <table class="clBorderCell clFont12 clWidth758" role="presentation">
      <tr class="clHeight30">
        <td class="clTexteGras clWidth551 clAlignLeft" colspan="2">
          <xsl:value-of select="$reference"/>
        </td>
        <td class="clTexte clWidth96 clAlignCenter">
          &#160;
        </td>
        <td class="clTexte clWidth96 clAlignCenter">
          &#160;
        </td>
      </tr>
      <tr class="clHeight10">
        <th class="clTitreBleu clWidth140 clAlignLeft clThNonGras">Identifiant</th>
        <th class="clTitreBleu clWidth411 clAlignLeft clThNonGras">Dénomination / Nom</th>        
        <th class="clTitreBleu clWidth96 clAlignCenter clThNonGras">Suivi</th>
        <th class="clTitreBleu clWidth96 clAlignCenter clThNonGras">Date MVT</th>
      </tr>
    </table>

  </xsl:template>

  <xsl:template name ="ligneIdent">
    <xsl:param name="nom"></xsl:param>
    <xsl:param name ="prenom"></xsl:param>
   <table class="clBorderCell clFont12 clWidth758">
      <tr class="clHeight30">

        <td class="clTexteGras clWidth551 clAlignLeft" colspan="3">
          <xsl:call-template name ="displayInLowerCaseXsl">
            <xsl:with-param name ="InputStringNom" select ="$nom"/>
            <xsl:with-param name ="InputStringPrenom" select ="$prenom"/>
          </xsl:call-template>         
        </td>
       <td class="clTexte clWidth192 clAlignCenter" colspan="2">
          &#160;
        </td>
      </tr>
      <tr class="clHeight10">
        <th class="clTitreBleu clWidth140 clAlignLeft clThNonGras">Identifiant</th>
        <th class="clTitreBleu clWidth281 clAlignCenter clThNonGras">&#160;</th>
        <th class="clTitreBleu clWidth130 clAlignCenter clThNonGras">Référence</th>
        <th class="clTitreBleu clWidth96 clAlignCenter clThNonGras">Suivi</th>
        <th class="clTitreBleu clWidth96 clAlignCenter clThNonGras">Date MVT</th>
      </tr>
    </table>

  </xsl:template>

  <xsl:template name ="LigneDonnee">
    <xsl:param name="donnees"/>
    <xsl:param name="tri"/>
    
    
    <table class="clWidth758 clBorderCell" role="presentation">
     <tr class="clHeight15">
        
        <td class="clGras clWidth140 clAlignLeft">
          <a class="clGras" href="#nullepart" onclick="VoirDetailSuivi('{$donnees/IDENT}','{$donnees/TYPESUIVI}','{$donnees/DATEMOUVE}','{$donnees/PACKAGE }','(this)'); ">
            <xsl:value-of select="$donnees/IDENT"/>
          </a>
        </td>
        <xsl:if test ="$tri = 'DA'">
          <td class="clTexte clWidth377 clAlignLeft">
            <xsl:call-template name ="displayInLowerCaseXsl">
              <xsl:with-param name ="InputStringNom" select ="$donnees/NOM"/>
              <xsl:with-param name ="InputStringPrenom" select ="$donnees/PRENOM"/>
            </xsl:call-template>
          </td>
          <td class="clTexte clWidth130 clAlignCenter">
            <xsl:value-of select="$donnees/REFERENCE"/>
          </td>
          <td class="clTexte clWidth96 clAlignCenter">
            <xsl:call-template name ="displayPackageSuivi">
              <xsl:with-param name ="InputStringPack" select ="$donnees/PACKAGE"/>
              <xsl:with-param name ="InputStringSuivi" select ="$donnees/TYPESUIVI"/>
            </xsl:call-template>
          </td>
        </xsl:if>
        <xsl:if test ="$tri = 'TY'">
          <td class="clTexte clWidth281 clAlignLeft">
            <xsl:call-template name ="displayInLowerCaseXsl">
              <xsl:with-param name ="InputStringNom" select ="$donnees/NOM"/>
              <xsl:with-param name ="InputStringPrenom" select ="$donnees/PRENOM"/>
            </xsl:call-template>
          </td>
          <td class="clTexte clWidth130 clAlignCenter">
            <xsl:value-of select="$donnees/REFERENCE"/>
          </td>
          <td class="clTexte clWidth96 clAlignCenter">
            <xsl:value-of select="$donnees/PACKAGE"/>
          </td>        
          <td class="clTexte clWidth96 clAlignCenter">
            <xsl:call-template name ="displayDateXsl">
              <xsl:with-param name ="InputDate" select ="$donnees/DATEMOUVE"></xsl:with-param>
            </xsl:call-template>
          </td>
        </xsl:if>
        <xsl:if test ="$tri = 'RF'">
          <td class="clTexte clWidth411 clAlignLeft">
            <xsl:call-template name ="displayInLowerCaseXsl">
              <xsl:with-param name ="InputStringNom" select ="$donnees/NOM"/>
              <xsl:with-param name ="InputStringPrenom" select ="$donnees/PRENOM"/>
            </xsl:call-template>
          </td>         
          <td class="clTexte clWidth96 clAlignCenter">
            <xsl:call-template name ="displayPackageSuivi">
              <xsl:with-param name ="InputStringPack" select ="$donnees/PACKAGE"/>
              <xsl:with-param name ="InputStringSuivi" select ="$donnees/TYPESUIVI"/>
            </xsl:call-template>
          </td>
          <td class="clTexte clWidth96 clAlignCenter">
            <xsl:call-template name ="displayDateXsl">
              <xsl:with-param name ="InputDate" select ="$donnees/DATEMOUVE"></xsl:with-param>
            </xsl:call-template>
          </td>
        </xsl:if>
        <xsl:if test ="$tri = 'ID'">
          <td class="clTexte clWidth281 clAlignLeft">
            &#160;
          </td>
          <td class="clTexte clWidth130 clAlignCenter">
            <xsl:value-of select="$donnees/REFERENCE"/>
          </td>
          <td class="clTexte clWidth96 clAlignCenter">
            <xsl:call-template name ="displayPackageSuivi">
              <xsl:with-param name ="InputStringPack" select ="$donnees/PACKAGE"/>
              <xsl:with-param name ="InputStringSuivi" select ="$donnees/TYPESUIVI"/>
            </xsl:call-template>
          </td>
          <td class="clTexte clWidth96 clAlignCenter">
            <xsl:call-template name ="displayDateXsl">
              <xsl:with-param name ="InputDate" select ="$donnees/DATEMOUVE"></xsl:with-param>
            </xsl:call-template>
          </td>
        </xsl:if>
      </tr>
    </table>
  </xsl:template>

</xsl:stylesheet>





