﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"  xmlns:bdf="http://banque-france.fr/namespace">
  <xsl:import href="../../Ressources/XSL/Commun.xsl"/>
  <xsl:import href="../../Ressources/XSL/Commun_SAS.xsl"/>
  <xsl:import href="../../Ressources/XSL/commun_transfo.xsl"/>
  <xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes"/>
  <xsl:param name="langage" select="'Fr'"/>
  <xsl:param name="familyNumber" select="''"/>
  <xsl:param name="root" select="'/Fiben/'"/>
  <xsl:param name="Lang" select="'FR'"/>
  <xsl:param name="familyName" select="''"/>
  <xsl:param name="familyTitle" select="''"/>
  <xsl:param name="nextModule" select="''"/>
  <xsl:param name="nextId" select="''"/>
  <xsl:param name="nextFamily" select="''"/>  
  <xsl:param name="menuHTML1"/>
  <xsl:param name="NonResident" select="''"/>

  <!--TEMPLATE PRINCIPAL-->
  <xsl:template match="/">
    <html lang="fr" xmlns="http://www.w3.org/1999/xhtml">
      <title>Module S3 - Compte-rendu des demandes de modification des suivis</title>
      <xsl:call-template name="genHeadSAS">
      </xsl:call-template>
      <body class="clBodybgcolorWhite">
        <xsl:call-template name="genFondMenu">
          <xsl:with-param name="root" select="$root"/>
          <xsl:with-param name="type" select="'suivi'" />        
        </xsl:call-template>
        <!-- Affichage des menus: EVOL 2016 -->
        <xsl:copy-of select="$menuHTML1"/>
        
        <table class="mainmodule horizontal-auto HomeData clBorderCell">
          <caption class="visually-hidden">Module S3 - Compte-rendu des demandes de modification des suivis</caption>
          <xsl:apply-templates select="/FIBEN/ERREUR"/>
          <xsl:if test="not(/FIBEN/ERREUR)">
            <tr>
             <td class="clWidth20"></td>
              <td class="clWidth636" colspan="2">
                <form method="Post" name="frmForm1">
                  <input type="hidden" name="ident" value=""/>
                  <table class="clWidthMax clBorderCell" role="presentation">
                    <tr>
                      <td>
                        <!-- Affichage du bandeau titre: -->
                        <xsl:call-template name="BandeauInfSuivi" >
                          <xsl:with-param name="Titre" select="$dictionnaire/titre[@module=$moddem]"/>
                          <xsl:with-param name="root" select="$root"/>
                        </xsl:call-template>
                        &#160;
                      </td>
                    </tr>
                  </table>
                  <img src="{$root}images/risque/shim_bleu.gif" width="768" height="1" alt=""/>
                  <br/>
                  <br/>

                  <div  id="Lst_CR_GestionSuivi" class="clLst_Alertes" >

                    <!-- ajout de l'ensemble des lignes avec les données-->
					  <xsl:choose>
						<xsl:when test ="//REUSSITES/REUSSITEMODIF">
                          <xsl:call-template name ="ReussiteModif"></xsl:call-template>
                        </xsl:when>
						  <xsl:when test ="//REUSSITES/REUSSITESUPPR">
							  <xsl:call-template name ="ReussiteSuppr"></xsl:call-template>
						  </xsl:when>
						  <xsl:when test ="//ECHECS3/ECHECMODIF">
							  <xsl:call-template name ="EchecModif"></xsl:call-template>
						  </xsl:when>
						  <xsl:otherwise>
							  <xsl:call-template name ="EchecSuppr"></xsl:call-template>
						  </xsl:otherwise>
					  </xsl:choose>
					  <br/>

				  </div>
                  <br/>
                  <img src="{$root}images/risque/shim_bleu.gif" width="768" height="1" alt=""/>
                  <br/>
                  
                </form>
              </td>
            </tr>
            
          </xsl:if>
         </table>
        <xsl:call-template name="genBasPage"/>

      </body>
    </html>
  </xsl:template>


  <xsl:template name="ReussiteModif">
    <!-- tableau pour modification ok-->
    <table class="clBorderCell clFont12 clWidth758">
      <caption class="visually-hidden">Tableau des modifications OK</caption>
      <tr>
        <td class="clWidth10">&#160;</td>  
        <td class="clGras clWidth748" colspan="5">
          Les opérations de modifications ont été enregistrées :
        </td>        
      </tr>
     <tr class="clHeight25">
        <td class="clWidth10">&#160;</td>
        <th class="clTitreBleu clWidth150 clAlignLeft clThNonGras"> Identifiants mis sous suivi</th>
        <th class="clTitreBleu clWidth90 clAlignCenter clThNonGras"> Date de fin</th>
        <th class="clTitreBleu clWidth55 clAlignCenter clThNonGras"> Suivi </th>
        <th class="clTitreBleu clWidth453 clAlignLeft clThNonGras"> Référence </th>     
      </tr>
    </table>
      <xsl:for-each select="//REUSSITES/REUSSITEMODIF">
       <table class="clWidth758 clBorderCell" role="presentation">
          <tr>
            <td class="clWidth10">&#160;</td>
           <td class="clTexte clWidth150">
              <xsl:value-of select="IDENTOK"/>
            </td>
            <td class="clTexte clWidth90 clAlignCenter">
              <xsl:choose>
                <xsl:when test ="substring(DATEFIN,1,6) = '129999'">
                  <xsl:value-of select="'N.P'"/>
                </xsl:when>
                <xsl:when test ="string-length(DATEFIN) = 0">
                  <xsl:value-of select="'N.P'"/>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select="concat(substring(DATEFIN,1,2),'/',substring(DATEFIN,3,4))"/>
                </xsl:otherwise>
              </xsl:choose>
             
            </td>
            <td class="clTexte clWidth55 clAlignCenter">
              <xsl:value-of select="TYPESUIVI"/>
            </td>
            <td class="clTexte clWidth453">
              <xsl:value-of select="REFERENCE"/>
            </td>
          </tr>
        </table>        
      </xsl:for-each>
      
  </xsl:template>

  <xsl:template name="ReussiteSuppr">
    <!-- tableau pour suppression  ok-->
   <table class="clBorderCell clFont12 clWidth758">
     <caption class="visually-hidden">Tableau pour suppression OK</caption>
      <tr>
        <td class="clWidth10">&#160;</td>
        <td class="clGras clWidth748" colspan="5">
          Les opérations de suppression sont prises en compte à dater :&#160;
          <xsl:call-template name ="displayDateJourXsl">
            <xsl:with-param name ="InputDate" select ="(/FIBEN/@DATJOUR)"/>
          </xsl:call-template>
        </td>
      </tr>
     <tr class="clHeight25">
        <td class="clWidth10">&#160;</td>
        <th class="clTitreBleu clWidth150 clThNonGras"> Identifiants mis sous suivi</th>
        <th class="clTitreBleu clWidth90 clAlignCenter clThNonGras"> Date de fin</th>
        <th class="clTitreBleu clWidth55 clAlignCenter clThNonGras"> Suivi </th>
        <th class="clTitreBleu clWidth453 clAlignLeft clThNonGras"> Référence </th>
      </tr>
    </table>
    <xsl:for-each select="//REUSSITES/REUSSITESUPPR">
      <table class="clWidth758 clBorderCell">
        <tr>
          <td class="clWidth10">&#160;</td>
         <td class="clTexte clWidth150">
            <xsl:value-of select="IDENTOK"/>
          </td>
          <td class="clTexte clWidth90 clAlignCenter">
            <xsl:choose>
              <xsl:when test ="substring(DATEFIN,1,6) = '129999'">
                <xsl:value-of select="'N.P'"/>
              </xsl:when>
              <xsl:when test ="string-length(DATEFIN) = 0">
                <xsl:value-of select="'N.P'"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="concat(substring(DATEFIN,1,2),'/',substring(DATEFIN,3,4))"/>
              </xsl:otherwise>
            </xsl:choose>
          </td>
          <td class="clTexte clWidth55 clAlignCenter">
            <xsl:value-of select="TYPESUIVI"/>
          </td>
          <td class="clTexte clWidth453">
            <xsl:value-of select="REFERENCE"/>
          </td>
        </tr>
      </table>
    </xsl:for-each>

  </xsl:template>

  <xsl:template name="EchecModif">
    <!-- tableau pour modification KO-->
   <table class="clBorderCell clFont12 clWidth758">
     <caption class="visually-hidden">Tableau pour modification KO</caption>
      <tr>
        <td class="clWidth10">&#160;</td>
        <td class="clGras clWidth748" colspan="5">
          Les opérations de modification n'ont pas été enregistrées :
        </td>
      </tr>
     <tr class="clHeight25">
        <td class="clWidth10">&#160;</td>
        <th class="clTitreBleu clWidth150 clThNonGras"> Identifiants mis sous suivi</th>
        <th class="clTitreBleu clWidth90 clAlignCenter clThNonGras"> Date de fin</th>
        <th class="clTitreBleu clWidth55 clAlignCenter clThNonGras"> Suivi </th>
        <th class="clTitreBleu clWidth130 clAlignLeft clThNonGras"> Référence</th>
        <th class="clTitreBleu clWidth323 clAlignLeft clThNonGras"> Motif du rejet</th>
      </tr>
    </table>
    <xsl:for-each select="//ECHECS3/ECHECMODIF">
      <table class="clWidth758 clBorderCell">
        <tr>
          <td class="clWidth10">&#160;</td>
          <td class="clTexte clValignTop clWidth150">
            <xsl:value-of select="IDENTKO"/>
          </td>
          <td class="clTexte clWidth90 clValignTop clAlignCenter">
            <xsl:choose>
              <xsl:when test ="substring(DATEFIN,1,6) = '129999'">
                <xsl:value-of select="'N.P'"/>
              </xsl:when>
              <xsl:when test ="string-length(DATEFIN) = 0">
                <xsl:value-of select="'N.P'"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="concat(substring(DATEFIN,1,2),'/',substring(DATEFIN,3,4))"/>
              </xsl:otherwise>
            </xsl:choose>
          </td>
          <td class="clTexte clWidth55 clValignTop clAlignCenter">
            <xsl:value-of select="TYPESUIVI"/>
          </td>
          <td class="clTexte clWidth130 clValignTop clAlignLeft">
            <xsl:value-of select="REFERENCE"/>
          </td>
          <td class="clTexte clWidth323">
            &#160;<xsl:call-template name="traduction">
              <xsl:with-param name="code" select="//MOTIF"/>
            </xsl:call-template>           
          </td>
        </tr>
      </table>
    </xsl:for-each>

  </xsl:template>

  <xsl:template name="EchecSuppr">
    <!-- tableau pour SUPPRESSION KO-->
   <table class="clBorderCell clFont12 clWidth758">
     <caption class="visually-hidden">Tableau pour suppression KO</caption>
      <tr>
        <td class="clWidth10">&#160;</td>
        <td class="clGras clWidth748" colspan="5">
          Les opérations de suppression n'ont pas été enregistrées :
        </td>
      </tr>
      <tr class="clHeight25">
        <td class="clWidth10">&#160;</td>
        <th class="clTitreBleu clWidth150 clThNonGras"> Identifiants mis sous suivi</th>
        <th class="clTitreBleu clWidth90 clAlignCenter clThNonGras"> Date de fin</th>
        <th class="clTitreBleu clWidth55 clAlignCenter clThNonGras"> Suivi </th>
        <th class="clTitreBleu clWidth130 clThNonGras"> Référence</th>
        <th class="clTitreBleu clWidth323 clThNonGras"> Motif du rejet</th>
      </tr>
    </table>
    <xsl:for-each select="//ECHECS3/ECHECSUPPR">
      <table class="clWidth758 clBorderCell">
        <tr>
          <td class="clWidth10">&#160;</td>
          <td class="clTexte clValignTop clWidth150">
            <xsl:value-of select="IDENTKO"/>
          </td>
          <td class="clTexte clWidth90 clValignTop clAlignCenter">
            <xsl:choose>
              <xsl:when test ="substring(DATEFIN,1,6) = '129999'">
                <xsl:value-of select="'N.P'"/>
              </xsl:when>
              <xsl:when test ="string-length(DATEFIN) = 0">
                <xsl:value-of select="'N.P'"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="concat(substring(DATEFIN,1,2),'/',substring(DATEFIN,3,4))"/>
              </xsl:otherwise>
            </xsl:choose>
          </td>
          <td class="clTexte clWidth55 clValignTop clAlignCenter">
            <xsl:value-of select="TYPESUIVI"/>
          </td>
          <td class="clTexte clWidth130 clValignTop clAlignLeft">
            <xsl:value-of select="REFERENCE"/>
          </td>
          <td class="clTexte clWidth323">                     
            <xsl:call-template name="traduction">
              <xsl:with-param name="code" select="//MOTIF"/>
            </xsl:call-template>
          </td>
        </tr>
      </table>
    </xsl:for-each>

  </xsl:template>

 
</xsl:stylesheet>
