<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"  xmlns:bdf="http://banque-france.fr/namespace">
  <xsl:import href="../../Ressources/XSL/Commun.xsl"/>
  <xsl:import href="../../Ressources/XSL/Commun_SAS.xsl"/>
  <xsl:import href="../../Ressources/XSL/commun_transfo.xsl"/>
  <xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes"/>
  <xsl:param name="langage" select="'fr'"/>
  <xsl:param name="familyNumber" select="''"/>
  <xsl:param name="root" select="'/Fiben/'"/>
  <xsl:param name="familyName" select="''"/>
  <xsl:param name="familyTitle" select="''"/>
  <xsl:param name="nextModule" select="''"/>
  <xsl:param name="nextId" select="''"/>
  <xsl:param name="nextFamily" select="''"/>
  <xsl:param name="Lang" select="'FR'"/>
  <xsl:param name="NonResident" select="''"/>
  <xsl:param name="menuHTML1"/>

  <!--TEMPLATE PRINCIPAL-->
  <xsl:template match="/">
    <html lang="fr" xmlns="http://www.w3.org/1999/xhtml">
      <title>Module S2 - Gestion des suivis</title>
      <head>
        <meta name="generator" content="HTML Tidy, see www.w3.org" />        
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <!-- Ajouts des fichiers .js: -->
        <xsl:call-template name="insertClientScripts" />

        <!-- Ajouts des CSS : -->
        <xsl:call-template name="AjoutCssSAS" />

        <!-- Ajout des messages d'erreur: -->
        <xsl:call-template name="AjoutDico" >
          <xsl:with-param name="Lang" select="$Lang" />
        </xsl:call-template>
        <script language="javascript">
          var sBDFId = '';
        </script>
        <!-- Rcupration des dates de fin dans un tableau pour rafficher la date de fin -->
        <!-- lors d'une annulation de modification de date de fin  -->
        <script language="javascript" type="text/javascript" >
          var lst_datefin = new Array();
          var lst_zoneref = new Array();
          <!-- modle : 
                      lst_datefin = new Array();                     
                      lst_datefin [1] = "datefin1";
                      lst_datefin [2] = "datefin2";
        -->
          <xsl:for-each select="FIBEN/SERVICESAS/MODULES2/SUIVI">
            <xsl:variable name ="DateSui" select ="DATEFINSUIVI"/>
            <xsl:variable name ="ZoneRef" select ="REFERENCE"/>
            
            lst_datefin [<xsl:number value="position()" format ="1"/>]="<xsl:value-of select="concat(substring($DateSui,1,2),'/',substring($DateSui,3,4))"/>";
            lst_zoneref [<xsl:number value="position()" format ="1"/>]="<xsl:value-of select="$ZoneRef"/>";
          </xsl:for-each>
        </script>

      </head>
      <body class="clBodybgcolorWhite">
        <xsl:call-template name="genFondMenu">
          <xsl:with-param name="root" select="$root"/>
          <xsl:with-param name="type" select="'suivi'" />
        </xsl:call-template>
        <!-- Affichage des menus: EVOL 2016 -->
        <xsl:copy-of select="$menuHTML1"/>
        
        <table class="mainmodule horizontal-auto HomeData clBorderCell">
          <caption class="visually-hidden">Module S2 - Gestion des suivis</caption>
          <tr>
           <td class="clWidth20"></td>
            <td class="clWidth636" colspan="2">
              <form method="Post" name="frmForm1">
                <input type="hidden" name="ident" value=""/>
                <table class="clWidthMax clBorderCell" role="presentation">
                  <tr>
                    <td>
                      <!-- Affichage du bandeau titre: -->
                      <xsl:call-template name="BandeauInfSuivi" >
                        <xsl:with-param name="Titre" select="$dictionnaire/titre[@module=$moddem]" />
                        <xsl:with-param name="root" select="$root"/>
                      </xsl:call-template>
                      &#160;
                    </td>
                  </tr>
                </table>
                <!-- si pas de suivi afficher un message d'info-->
                <xsl:choose>
                  <xsl:when test ="FIBEN/SERVICESAS/CLIENTSAS/NBSAS = 0">
                    <table class="clWidthMax clBorderCell" role="presentation">
                      <tr>
                        <td class="clWidth7"></td>
                        <td class="clGras clWidth768 clAlignLeft">Vous n'avez actuellement aucun suivi en cours</td>
                      </tr>
                    </table>
                  </xsl:when>
                  <xsl:otherwise>
                    
                    <!-- tableau pour choix du tri-->
                    <table class="clWidthMax clBorderCell" role="presentation">
                      <tr>
                        <td class="clWidth9"> </td>
                        <th class="clGras clWidth321 clBorder0">
                          Triez vos suivis par :
                        </th>
                        <td class="clWidth194 clAlignLeft">

                          <select id="lst_Trie"  size="1" class="clChamp" onchange="ChangeTriListeSuivis(this);">
                            <xsl:variable name="tri" select="//TRI"/>
                            <xsl:choose>
                              <xsl:when test="$tri='ID'">
                                <option selected="true" value="ID">Identifiant</option>
                                <option value="TY">Type de suivi</option>
                                <option value="RF">Référence</option>
                                <option  value="DA">Date de fin</option>
                              </xsl:when>
                              <xsl:when test="$tri='TY'">
                                <option value="ID">Identifiant</option>
                                <option selected="true" value="TY">Type de suivi</option>
                                <option value="RF">Référence</option>
                                <option value="DA">Date de fin</option>
                              </xsl:when>
                              <xsl:when test="$tri='RF'">
                                <option value="ID">Identifiant</option>
                                <option value="TY">Type de suivi</option>
                                <option selected="true" value="RF">Référence</option>
                                <option value="DA">Date de fin</option>
                              </xsl:when>
                              <xsl:when test="$tri='DA'">
                                <option value="ID">Identifiant</option>
                                <option value="TY">Type de suivi</option>
                                <option value="RF">Référence</option>
                                <option selected="true" value="DA">Date de fin</option>
                              </xsl:when>
                              <xsl:otherwise>
                                <option selected="true" value="ID">Identifiant</option>
                                <option value="TY">Type de suivi</option>
                                <option value="RF">Référence</option>
                                <option  value="DA">Date de fin</option>
                              </xsl:otherwise>
                            </xsl:choose>
                          </select>
                        </td>
                        <!-- image pour téléchargement au format Excel-->
                        <td class="clTitre2 clWidth200 clAlignRight">Télécharger au format Excel</td>
                        <td class="clWidth5">&#160;</td>
                        <td class="clWidth49 clAlignRight">
                          <a href="#nullepart" onclick="requestStatic('',cstExportSuiviS2,'')">
                            <img src="{$root}Images/Boutons/Excel.jpg" border="0" alt="lien vers fichier Excel"/>
                          </a>
                        </td>
                      </tr>
                    </table>
                    <br/>

                    <!-- tableau des suivis -->
                    <table class="clWidthMax clBorderCell">
                      <caption class="visually-hidden">tableau des suivis</caption>
                      <tr>
                        <td class="clWidth7"></td>
                        <th class="clTitreBleu clGras clWidth100 clAlignLeft">Identifiant</th>
                        <th class="clTitreBleu clGras clWidth253 clAlignLeft">Dénomination / Nom</th>
                       <th class="clTitreBleu clGras clWidth162 clAlignLeft">Référence</th>
                        <th class="clTitreBleu clGras clWidth40 clAlignLeft">Suivi</th>
                        <th class="clTitreBleu clGras clWidth76 clAlignLeft">Date de fin</th>
                        <th class="clTitreBleu clGras clWidth63 clAlignLeft">Modifier</th>
                        <th class="clTitreBleu clGras clWidth63 clAlignLeft">Supprimer</th>
                        <td class="clWidth16"></td>
                      </tr>
                    </table>
                    <img src="{$root}images/risque/shim_bleu.gif" width="768" height="1" alt=""/>
                    <br/>
                    <br/>
                    <div  id="Lst_Suivis" class="clLst_Alertes" >
                      <br/>
                      <!-- ajout de l'ensemble des lignes avec les donnes-->
                   
                      <!-- tester présence balise SUIVI avant appel <xsl:call-template name="LigneSuivis"> -->
                      <!-- ajout de l'ensemble des lignes avec les donnes-->
                      <xsl:if test="count(//SUIVI) != 0">

                        <xsl:call-template name ="LigneDonne">
                          <xsl:with-param name ="donnees" select ="//SUIVI[1]"></xsl:with-param>
                          <xsl:with-param name ="pos" select ="1"></xsl:with-param>
                        </xsl:call-template>

                        <!-- traitement du reste des mouvements-->
                        <xsl:if test="count(//SUIVI) &gt; 1">
                          <xsl:call-template name="LigneSuivis">
                            <xsl:with-param name="debut" select="2" />
                            <xsl:with-param name="fin" select="count(//SUIVI)" />
                          </xsl:call-template>
                        </xsl:if>

                      </xsl:if>
                    </div>                   
                    <br/>
                    <img src="{$root}images/risque/shim_bleu.gif" width="768" height="1" alt=""/>
                    <br/>

                  </xsl:otherwise>
                </xsl:choose>

              </form>
            </td>
          </tr>
         
        </table>
        <xsl:call-template name="genBasPage"/>
        <table class="clWidth50 clBorderCell" role="presentation">
          <tr>
            <input type="text" size="5" readonly="true" name="DateFinSuivi0" value="12/9999" maxlength="7" style="visibility:hidden" />
          </tr>
          <tr>
            <input type="text" size="5" readonly="true" name="Reference0" value=" " maxlength="15" style="visibility:hidden" />
          </tr>
        </table>

      </body>
    </html>
  </xsl:template>


  <xsl:template name="LigneSuivis">
    <xsl:param name="debut" />
    <xsl:param name="fin"  />


    <!-- cas des donnes tries par date -->
    <xsl:if test ="(//TRI) = 'DA'">
      <xsl:variable name ="DateCourant"  select ="//SUIVI[$debut]/DATEFINSUIVI/text()"/>
      <xsl:variable name ="Positiondateprecedente" select ="$debut - 1"/>
      <xsl:variable name ="dateprecedente" select ="//SUIVI[$Positiondateprecedente]/DATEFINSUIVI/text()"/>
      <xsl:if test="$dateprecedente[1]!=$DateCourant[1]">
        <!--<br/>-->
        <xsl:call-template name ="Ligneshim"></xsl:call-template>
      </xsl:if>
    </xsl:if>
    <!-- cas des donnes tries par TYPE DE SUIVI -->
    <xsl:if test ="(//TRI) = 'TY'">
      <xsl:variable name ="TypeSuiviCourant"  select ="//SUIVI[$debut]/TYPESUIVI/text()"/>
      <xsl:variable name ="Positiontypesuiviprecedent" select ="$debut - 1"/>
      <xsl:variable name ="TypeSuiviprecedent" select ="//SUIVI[$Positiontypesuiviprecedent]/TYPESUIVI/text()"/>
      <xsl:if test="$TypeSuiviprecedent[1]!=$TypeSuiviCourant[1]">
        <!--<br/>-->
        <xsl:call-template name ="Ligneshim"></xsl:call-template>

      </xsl:if>
    </xsl:if>

    <!-- Affichage des donnes: -->

    <xsl:call-template name ="LigneDonne">
      <xsl:with-param name ="donnees" select ="//SUIVI[$debut]"></xsl:with-param>
      <xsl:with-param name ="pos" select ="$debut"></xsl:with-param>
    </xsl:call-template>

    <!-- Fin affichage des donnes: -->

    <!-- si on n'a pas fini la boucle on continue -->
    <xsl:if test="$debut &lt; $fin">
      <xsl:call-template name="LigneSuivis">
        <xsl:with-param name="debut" select="($debut)+1" />
        <xsl:with-param name="fin" select="$fin" />
      </xsl:call-template>
    </xsl:if>

  </xsl:template>





  <xsl:template name ="Ligneshim">
    <table class="clWidth758 clBorderCell" role="presentation">
      <tr class="clHeight30">
        <td class="clWidth9"> </td>
        <td>
          <img src="{$root}images/risque/shim_bleu.gif" width="758" height="1" alt=""/>
        </td>
      </tr>
    </table>
  </xsl:template>


  <xsl:template name="LigneDonne">
    <xsl:param name ="donnees"/>
    <xsl:param name ="pos"/>
    <!--<xsl:for-each select="FIBEN/SERVICESAS/MODULES2/SUIVI">-->
    <xsl:variable name ="DateSui" select ="$donnees/DATEFINSUIVI"/>
    <xsl:variable name ="ZoneRef" select ="$donnees/REFERENCE"/>
    <table class="clWidthMax clBorderCell" role="presentation">
      <tr class="clHeight30">
        <td class="clWidth5"></td>
        <td id="Identifiant{$pos}" class="clTexte clWidth100 clAlignLeft">
          <xsl:value-of select="$donnees/IDENT"/>
        </td>
        <td class="clTexte clWidth240 clAlignLeft">
          <xsl:call-template name ="displayInLowerCaseXsl">
            <xsl:with-param name ="InputStringNom" select ="$donnees/NOM"/>
            <xsl:with-param name ="InputStringPrenom" select ="$donnees/PRENOM"/>
          </xsl:call-template>
        </td>
        <td class="clTexte clWidth180 clAlignCenter">
          <input type="text" size="18" readonly="true" name="Reference{$pos}" value="{$ZoneRef}" maxlength="15"  Title="Référence au format XXX" onblur="VerifSaisieReference('{$pos}');"/>
         
        </td>
        <td id="TypeSuivi{$pos}" class="clTexteGras clWidth42 clAlignCenter">
          <input type="text" size="1" readonly="true" name="TypedeSuivi{$pos}"  class="clTexteGrasMM" value="{$donnees/TYPESUIVI}"  Title="{$dictionnaire/titre[@module=($donnees/TYPESUIVI)]}"/>
          <!--<xsl:value-of select="$donnees/TYPESUIVI"/>-->
        </td>
        <td class="clTexte clWidth78 clAlignCenter">
          <xsl:choose>
            <xsl:when test ="string-length($DateSui) = 0">
              <input type="text" size="5" readonly="true" name="DateFinSuivi{$pos}" value="{'N.P'}" maxlength="7"  Title="Date fin suivi au format MM/SSAA" />
            </xsl:when>
            <xsl:otherwise>
              <input type="text" size="5" readonly="true" name="DateFinSuivi{$pos}" value="{concat(substring($DateSui,1,2),'/',substring($DateSui,3,4))}" maxlength="7"  Title="Date fin suivi au format MM/SSAA" />
            </xsl:otherwise>
          </xsl:choose>
        </td>
        <td class="clTitre2 clWidth64 clAlignCenter">
          <input id="chkModif{$pos}" type="checkbox" style="visibility:visible" onclick="GestionCaseACocherSAS_GS('{$pos}', 'M'); "/>
        </td>
        <td class="clTitre2 clWidth64 clAlignCenter">
          <input id="chkSup{$pos}" type="checkbox" style="visibility:visible" onclick="GestionCaseACocherSAS_GS('{$pos}', 'S'); "/>
        </td>
      </tr>
    </table>
    <!--</xsl:for-each>-->
  </xsl:template>



</xsl:stylesheet>





