﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"  xmlns:bdf="http://banque-france.fr/namespace">
  <xsl:import href="../../Ressources/XSL/Commun.xsl"/>
  <xsl:import href="../../Ressources/XSL/Commun_SAS.xsl"/>
  <xsl:import href="../../Ressources/XSL/commun_transfo.xsl"/>
  <xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes"/>
  <xsl:param name="langage" select="'Fr'"/>
  <xsl:param name="familyNumber" select="''"/>
  <xsl:param name="root" select="'/Fiben/'"/>
  <xsl:param name="familyName" select="''"/>
  <xsl:param name="familyTitle" select="''"/>
  <xsl:param name="nextModule" select="''"/>
  <xsl:param name="nextId" select="''"/>
  <xsl:param name="nextFamily" select="''"/>
  <xsl:param name="Lang" select="'FR'"/>
  <xsl:param name="NonResident" select="''"/>
  <xsl:param name="menuHTML1"/>
  <xsl:param name="id"/>

  <!--TEMPLATE PRINCIPAL-->
  <xsl:template match="/">
    <html lang="fr" xmlns="http://www.w3.org/1999/xhtml">
      <title>Module S1 - Mise sous Suivi</title>
        <xsl:call-template name="genHeadSASplus">
      </xsl:call-template>

      <body class="clBodybgcolorWhite" onload="Tst_Conditions_InitialesSAS_GS();initModules(0);remplirMoisFin(0);remplirAnneeFin(15); " >
        <xsl:call-template name="genFondMenu">
          <xsl:with-param name="root" select="$root"/>
          <xsl:with-param name="type" select="'suivi'" />
        </xsl:call-template>
        <!-- Affichage des menus: EVOL 2016 -->
        <xsl:copy-of select="$menuHTML1"/>
        
        <table class="mainmodule horizontal-auto HomeData clBorderCell">
          <caption class="visually-hidden">Module S1 - Mise sous Suivi</caption>
          <xsl:apply-templates select="/FIBEN/ERREUR"/>
          <xsl:if test="not(/FIBEN/ERREUR)">
            <tr>
             <td class="clWidth20"></td>
              <td class="clWidth636" colspan="2">
                <form method="Post" name="frmForm1">
                  <input type="hidden" name="ident" value=""/>
                  <table class="clWidthMax clBorderCell" role="presentation">
                    <tr>
                      <td>
                        <!-- Affichage du bandeau titre: -->
                        <xsl:call-template name="BandeauInfSuivi" >
                          <xsl:with-param name="Titre" select="$dictionnaire/titre[@module=$moddem]"/>
                          <xsl:with-param name="root" select="$root"/>
                        </xsl:call-template>
                        &#160;
                      </td>
                    </tr>
                  </table>
                  <table class="clWidthMax clBorderCell" role="presentation">
                    <tr>
                      <th class="clTitre2 clWidth260 clAlignLeft">Veuillez saisir 5 identifiants maximun</th>
                      <th class="clTitre2 clWidth200 clAlignCenter">Date de fin</th>
                      <th class="clTitre2 clWidth308 clAlignCenter">Module ou package</th>
                    </tr>
                  </table>
                  <br/>
                  <table class="clWidthMax clBorderCell">
                    <tr>
                      <td class="clWidth10">&#160;</td>
                      <td class="clWidth300">&#160;</td>
                      <td id="sgn_moisfin" class="clErreur" style="visibility:hidden;font-size:14pt" >&gt;</td>
                      <td class="clWidth225 clAlignCenter">
                        <select id="lst_MoisFinSuivi"  size="1" class="clChamp" onchange="">
                          <option value="0">...</option>
                          <option value="1">01</option>
                          <option value="2">02</option>
                          <option value="3">03</option>
                          <option value="4">04</option>
                          <option value="5">05</option>
                          <option value="6">06</option>
                          <option value="7">07</option>
                          <option value="8">08</option>
                          <option value="9">09</option>
                          <option value="10">10</option>
                          <option value="11">11</option>
                          <option value="12">12</option>
                        </select>
                        &#160;
                        <select id="lst_AnneeFinSuivi"  size="1" class="clChamp" onchange="">
                          <option value="0">...</option>
                          <option value="1">2011</option>
                          <option value="2">2012</option>
                          <option value="3">2013</option>
                        </select>
                      </td>
                      <td id="sgn_anneefin" class="clErreur" style="visibility:hidden;font-size:14pt" >&lt;</td>
                      <td class="clWidth225 clAlignCenter">
                        <select id="lst_MMPK"  size="1" class="clChamp" onchange="">
                          <option value="0">...</option>
                          <option value="1">AB</option>
                          <option value="2">AC</option>
                          <option value="3">AD</option>
                          <option value="4">AE</option>
                        </select>
                      </td>
                      <td id="sgn_module" class="clErreur" style="visibility:hidden;font-size:14pt" >&lt;</td>
                    </tr>
                  </table>
                  <br/>
                  <table class="clBorder0">
                    <tr>
                      <td class="clWidth10">&#160;</td>
                      <th class="clTitre2 clWidth125 clAlignCenter">Identifiant</th>
                      <td class="clWidth50"></td>
                      <th class="clTitre2 clWidth150 clAlignCenter">Référence</th>
                      <td class="clWidth443">&#160;</td>
                    </tr>
                  </table>
                  <br/>
                  
                  <table class="clBorder0" role="presentation">
                    <tr>
                      <td>
                        <!--placement des champs des identifiants-->
                        <xsl:call-template name="PlaceChampsIdentifiantSuivi">
                          <xsl:with-param name="debut" select="1" />
                          <xsl:with-param name="fin" select="5" />
                        </xsl:call-template>
                      </td>
                      <td class="clWidth30"></td>
                      <!--placement des champs références-->
                      <td>
                        <xsl:call-template name="PlaceChampsReferenceSuivi">
                          <xsl:with-param name="debut" select="1" />
                          <xsl:with-param name="fin" select="5" />
                        </xsl:call-template>
                      </td>
                    </tr>
                  </table>
                </form>
              </td>
            </tr>
                        
          </xsl:if>
        </table>
        <xsl:call-template name="genBasPage"/>
      </body>
    </html>
  </xsl:template>

  <xsl:template name="PlaceChampsIdentifiantSuivi">
    <xsl:param name="debut"/>
    <xsl:param name="fin" />
    <table class="clBorder0" role="presentation">
      <tr>
        <td id="sgn_ident{$debut}" class="clErreur" style="visibility:hidden;font-size:14pt" >&gt;</td>
        <td  class="clTitre2"  >
          <xsl:if test ="$debut=1">
            <input type="text"   name="txt_ident{$debut}"  id="txt_ident{$debut}" style="visibility:hidden" size="" value="{$id}" maxlength="13"  />
            &#160;&#160;&#160;
          </xsl:if>
          <xsl:if test ="$debut>1">
            <input type="text"   name="txt_ident{$debut}"  id="txt_ident{$debut}" style="visibility:hidden" size="" value="" maxlength="13"  />
            &#160;&#160;&#160;
          </xsl:if>
        </td>
      </tr>
      <tr>
        <td class="clTitre2 clHeight10" colspan="2"></td>
      </tr>
    </table>

    <!--si on n'a pas fini la boucle on continue-->
    <xsl:if test="$debut &lt; $fin">
      <xsl:call-template name="PlaceChampsIdentifiantSuivi">
        <xsl:with-param name="debut" select="($debut)+1" />
        <xsl:with-param name="fin" select="$fin" />
      </xsl:call-template>
    </xsl:if>


  </xsl:template>

  <xsl:template name="PlaceChampsReferenceSuivi">
    <xsl:param name="debut"/>
    <xsl:param name="fin" />
    <table class="clBorder0" role="presentation">
      <tr>
        <td id="sgn_identRef{$debut}" class="clErreur" style="visibility:hidden;font-size:14pt" >&gt;</td>
        <td  class="clTitre2"  >
          <xsl:if test ="$debut=1">
            <input type="text"   name="txt_ref{$debut}"  id="txt_ref{$debut}" style="visibility:hidden" size="" value="{$id}" maxlength="15"  />
            &#160;&#160;&#160;
          </xsl:if>
          <xsl:if test ="$debut>1">
            <input type="text"   name="txt_ref{$debut}" id="txt_ref{$debut}"  style="visibility:hidden" size="" value="" maxlength="15"  />
            &#160;&#160;&#160;
          </xsl:if>
        </td>
      </tr>
      <tr>
        <td class="clTitre2 clHeight10" colspan="2"></td>
      </tr>
    </table>

    <!--si on n'a pas fini la boucle on continue-->
    <xsl:if test="$debut &lt; $fin">
      <xsl:call-template name="PlaceChampsReferenceSuivi">
        <xsl:with-param name="debut" select="($debut)+1" />
        <xsl:with-param name="fin" select="$fin" />
      </xsl:call-template>
    </xsl:if>


  </xsl:template>

</xsl:stylesheet>

