<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                        xmlns:bdf="http://banque-france.fr/namespace">
  <xsl:import href="../../Ressources/XSL/Commun.xsl"/>
  <xsl:import href="../../Ressources/XSL/commun_transfo.xsl"/>
  <xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes" />
  <xsl:param name="langage" select="'fr'"/>
  <xsl:param name="familyName" select="''"/>
  <xsl:param name="root" select="'/Fiben/'"/>
  <xsl:param name="familyNumber" select="''"/>
  <xsl:param name="familyTitle" select="''"/>
  <xsl:param name="nextModule" select="''"/>
  <xsl:param name="nextId" select="''"/>
  <xsl:param name="nextFamily" select="''"/>
  <xsl:param name="Lang" select="'FR'"/>
  <xsl:param name="NonResident" select="''"/>
  <xsl:param name="menuHTML1"/>
  <xsl:param name="sIPEbrkPage" select="''"/>
  <xsl:variable name="condGraph1" select="(//MTCBCT[position()=1] != 0)"/>
  <xsl:variable name="condGraph2" select="(//MTCMLT[position()=1] != 0)"/>
  <xsl:variable name="condGraph3" select="(//MTCBM[position()=1] != 0) or (//MTCBI[position()=1] != 0)" />
  <xsl:variable name="condGraph4" select="(//MTTOT6[position()=1] != 0)"/>
  <xsl:variable name="condGraph5" select="(//MTCC[position()=1] != 0) or (//MTCD[position()=1] != 0)"/>
  <xsl:variable name="condGraph6" select="(//MTAC[position()=1] != 0)"/>
  <xsl:variable name="condGraph7" select="(//MTCBCT[position()=1] != 0)"/>
  <xsl:variable name="condGraph8" select="(//MTCMLT[position()=1] != 0)"/>
  <xsl:variable name="condGraph9" select="(//MTCBM[position()=1] != 0) or (//MTCBI[position()=1] != 0)" />
  <xsl:variable name="condGraph10" select="(//MTTOT6[position()=1] != 0)"/>
  <xsl:variable name="condGraph11" select="(//MTCC[position()=1] != 0) or (//MTCD[position()=1] != 0)"/>
  <xsl:variable name="condGraph12" select="(//MTAC[position()=1] != 0)"/>
  <xsl:variable name="condGraph13" select="((count(/FIBEN/PERSONNE/MODULEOR/DIFFOR/IPEOR/IPERESUME/SITRESM/MTMIPE[text()!='0'])) >= '6') and ((count(/FIBEN/PERSONNE/MODULEOR/DIFFOR/IPEOR/IPERESUME/SITRESM/MTMIPE[text()!='0,0'])) >= '6') and not(FIBEN/PERSONNE/MODULEOR/DIFFOR/IPEOR/IPERESUME/SITRESM[1]/MTIP = '99999') and not(FIBEN/PERSONNE/MODULEOR/DIFFOR/IPEOR/IPERESUME/SITRESM[2]/MTIP = '99999') and not(FIBEN/PERSONNE/MODULEOR/DIFFOR/IPEOR/IPERESUME/SITRESM[3]/MTIP = '99999') and not(FIBEN/PERSONNE/MODULEOR/DIFFOR/IPEOR/IPERESUME/SITRESM[4]/MTIP = '99999') and not(FIBEN/PERSONNE/MODULEOR/DIFFOR/IPEOR/IPERESUME/SITRESM[5]/MTIP = '99999') and not(FIBEN/PERSONNE/MODULEOR/DIFFOR/IPEOR/IPERESUME/SITRESM[6]/MTIP = '99999')  and not(FIBEN/PERSONNE/MODULEOR/DIFFOR/IPEOR/IPERESUME/SITRESM[2]/MTCC = '99999')  and not(FIBEN/PERSONNE/MODULEOR/DIFFOR/IPEOR/IPERESUME/SITRESM[4]/MTCC = '99999') and not(FIBEN/PERSONNE/MODULEOR/DIFFOR/IPEOR/IPERESUME/SITRESM[5]/MTCC = '99999') and not(FIBEN/PERSONNE/MODULEOR/DIFFOR/IPEOR/IPERESUME/SITRESM[6]/MTCC = '99999')"/>
  <xsl:variable name="condGraph" select="boolean($condGraph1 or $condGraph2 or $condGraph3 or $condGraph4 or $condGraph5 or $condGraph6 or $condGraph7 or $condGraph8 or $condGraph9 or $condGraph10 or $condGraph11 or $condGraph12 or $condGraph13)"/>

  <xsl:template match="/">
    <html lang="fr">
      <title>Module OR - Offre Risques</title>
      <xsl:call-template name="genHead">
        <xsl:with-param name="ident" select="FIBEN/ERREUR/IDENT | FIBEN/PERSONNE/MODULEOR/PM/EJ/IDENTS | FIBEN/PERSONNE/MODULEOR/PM/EI/IDENTS | FIBEN/PERSONNE/MODULEOR/PM/EI/IDENTC"/>
      </xsl:call-template>
      <body class="clBodybgcolorWhite">
        <xsl:call-template name="genFondMenu">
          <xsl:with-param name="root" select="$root"/>
        </xsl:call-template>
        <xsl:copy-of select="$menuHTML1"/>

        <table class="mainmodule horizontal-auto clBorderCell">
          <caption class="visually-hidden">Module OR - Offre Risques</caption>
          <xsl:call-template name="genLigneConfidentiel" />
          <xsl:apply-templates select="/FIBEN/ERREUR"/>
          <xsl:if test="not(/FIBEN/ERREUR)">

            <tr>
               <td class="clWidth64"></td>

              <td class="clCouleur2 clValignTop clWidth739" colspan="4">
                <xsl:apply-templates select="FIBEN/PERSONNE/MODULEOR/PM/EJ"/>
                <xsl:apply-templates select="FIBEN/PERSONNE/MODULEOR/PM/EI"/>
                <xsl:apply-templates select="FIBEN/PERSONNE/MODULEOR/PM/EI/IDLIES"/>
                <xsl:if test = "not(PERSONNE/MODULEOR/IST10)">
                  <xsl:apply-templates select="FIBEN/PERSONNE/MODULEOR/DIFFOR"/>
                </xsl:if>
              </td>
            </tr>
            <xsl:if test=" /FIBEN/PERSONNE/MODULEOR/IST06| /FIBEN/PERSONNE/MODULEOR/IST10| //U101">
              <tr>
                <td class="clWidth14"></td>
                <td colspan="3" class="clCouleur2 clValignTop clWidth635">
                  <xsl:apply-templates select=" /FIBEN/PERSONNE/MODULEOR/IST06| /FIBEN/PERSONNE/MODULEOR/IST10| //U101"/>
                </td>
                <td></td>
              </tr>
              <tr>
                <td class="clWidth14"></td>
                <td colspan="4">
                  <xsl:call-template name="shim"/>
                </td>
              </tr>
            </xsl:if>


          </xsl:if>
        </table>
        <xsl:call-template name="genBasPage"/>
        <xsl:call-template name="genGraphOR"/>
      </body>
    </html>
  </xsl:template>

  <!--*********************************************************************-->

  <xsl:template match="FIBEN/PERSONNE/MODULEOR/PM/EJ">
    <xsl:call-template name="genEnTete">
      <xsl:with-param name="ident" select="IDENTS"/>
      <xsl:with-param name="nom" select="DENOM"/>
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="FIBEN/PERSONNE/MODULEOR/PM/EI">
    <xsl:call-template name="genEnTete">
      <xsl:with-param name="ident" select="IDENTS|IDENTC"/>
      <xsl:with-param name="idrenv" select="IDRENV"/>
      <xsl:with-param name="nom">
        <xsl:call-template name ="displayInLowerCaseXsl">
          <xsl:with-param name ="InputStringNom" select ="(IDENTITE/NOM)"/>
          <xsl:with-param name ="InputStringPrenom" select ="(IDENTITE/PRENOM)"/>
        </xsl:call-template>
      </xsl:with-param>
      <xsl:with-param name="nomconj" select="IDENTITE/NOMCONJ"/>
      <xsl:with-param name="idnouv" select="/FIBEN/PERSONNE/IDNOUV"/>
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="DIFFOR">
    <xsl:choose>
      <xsl:when test ="ICB10">
        <xsl:apply-templates select ="ICB10" mode="genDiv"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates select="RISQUESOR"/>
      </xsl:otherwise>
    </xsl:choose>

    <xsl:apply-templates select ="ICIP01" mode="genDiv"/>
    <xsl:if test ="not(ICIP01)">
      <xsl:apply-templates select="IPEOR"/>
    </xsl:if>
    <xsl:apply-templates select="IRELB01" mode="genLib" />
    <xsl:if test="not(IRELB01)">
      <xsl:apply-templates select="RBOR"/>
    </xsl:if>
    <br/>
  </xsl:template>

  <xsl:template match="ICB05" mode="genLib">
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
        <td class="clCouleur2">
          <xsl:apply-templates select="."/>
          <br/>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
        <td class="clCouleur2 clWidth625 clHeight12 clAlignLeft">&#160;PRESENCE DE CONCOURS BANCAIRES EUROPEENS </td>
        <td class="clCouleur2 clWidth10 clHeight12">
        </td>
      </tr>
    </table>
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
        <td class="clCouleur2 clWidth635">
          <br/>
          <div class="clAlignLeft">
            &#160;Pour obtenir le détail de l'endettement européen de cette entreprise, vous pouvez contacter le pôle "produits" &#160;du Service Central des Risques par mail : <a href="mailto:4072-produits-ut@banque-france.fr"></a>4072-produits-ut@banque-france.fr
          </div>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
  </xsl:template>

  <xsl:template match="ICB01|IRELB01" mode="genLib">
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
        <td class="cltexte clAlignLeft">
          <span class="clCouleur2">
            <xsl:apply-templates select="."/>
          </span>
          <br/>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
  </xsl:template>

  <xsl:template match="ICB10" mode="genDiv">
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
        <td class="cltexte clAlignLeft">
          <span class="clCouleur2">
            <xsl:apply-templates select="."/>
          </span>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
  </xsl:template>

  <xsl:template match="ICIP01" mode="genDiv">
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
        <td class="cltexte clAlignLeft">
          <span class="clCouleur2">
            <xsl:apply-templates select="."/>
          </span>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
  </xsl:template>

  <!--**************************************** PARTIE CONCOURS BANCAIRES ********************************************-->
  <xsl:template match="RISQUESOR">

    <a name="ancConcours"></a>

    <!--<div class="clBreakPage"></div>-->
    <table class="clWidth739 clBorderCell" role="presentation">
     <tr class="clAlignCenter">
        <td class="clWidth636 clCouleurGras">SOURCES DE FINANCEMENT RECENSEES AU COURS DES TREIZE DERNIERS MOIS (EN MILLIERS D'EUROS)</td>
        <td class="clWidth103 clAlignRight">
        </td>
      </tr>
    </table>

    <xsl:call-template name="shim"/>
    <br/>
    
    <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/DATCENTR"/>
    

    <xsl:if test="not(/FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/ICB01)">
      <table class="clWidth739 clBorderCell" role="presentation">
       <tr class="clAlignCenter">
          <td class="clCouleurGras clWidth602">CONCOURS BANCAIRES</td>
          <td class="clWidth34"> </td>
          <td class="clWidth103 clAlignRight">
          </td>
        </tr>
      </table>
      <xsl:call-template name="shim"/>
    </xsl:if>

    <!-- appel des différentes parties des risques-->

    <xsl:if test ="/FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/CBEURO">
      <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/CBEURO"/>
    </xsl:if>
    <xsl:choose >
      <xsl:when test ="/FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/ICB05">
        <xsl:call-template name ="ICB05"/>
        <xsl:call-template name="shim"/>
      </xsl:when>
      <xsl:when test ="/FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/ICB01">
        <xsl:call-template name ="ICB01"/>
        <xsl:call-template name="shim"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:choose>
          <xsl:when test ="/FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/ICB04">
            <xsl:call-template name="CUMULCB" />
            <xsl:call-template name ="ICB04"/>
            <xsl:call-template name="shim"/>
          </xsl:when>
          <xsl:when test ="/FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/ICB03">
            <xsl:call-template name ="ICB03"/>
            <xsl:call-template name="shim"/>
            <xsl:call-template name="CUMULCBC" />
          </xsl:when>
          <xsl:otherwise>
            <xsl:call-template name="CUMULCB" />
            <xsl:call-template name="CUMULCBC" />
          </xsl:otherwise>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>

    <xsl:choose>
      <xsl:when test ="/FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/ICB06">
        <xsl:call-template name ="ICB06"/>
        <xsl:call-template name="shim"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="CUMULCIFP" />
      </xsl:otherwise>
    </xsl:choose>

    <xsl:choose>
      <xsl:when test ="/FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/ICB07">
        <xsl:call-template name ="ICB07"/>
        <xsl:call-template name="shim"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:choose>
          <xsl:when test ="/FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/ICB09">

            <!-- Cas particulier pas de concours bancaire individuels mais présence de concours collectif : il faut mettre le titre -->
            <xsl:if test ="/FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/ICB09">
              <table class="clWidth739 clBorderCell" role="presentation">
               <tr class="clAlignCenter">
                  <td class="clCouleurGras clWidth635">CONCOURS D&#201;CLAR&#201;S PAR DES SOCI&#201;T&#201;S DE GESTION DE PORTEFEUILLE ET DES ENTREPRISES</td>
                 <td class="clAlignRight clWidth104">&#160;</td>
                </tr>
               <tr class="clAlignCenter">
                  <td class="clCouleurGras clWidth635"> D'ASSURANCE, MUTUELLES ET INSTITUTIONS DE PR&#201;VOYANCE</td>
                 <td class="clAlignRight clWidth104">&#160;</td>
                </tr>
              </table>
              <xsl:call-template name="shim"/>
              <br/>
            </xsl:if>
            <xsl:call-template name ="ICB09"/>
            <xsl:call-template name="shim"/>
            <xsl:call-template name="CUMULCOAC" />
          </xsl:when>
          <xsl:when test ="/FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/ICB08">
            <xsl:call-template name="CUMULCOA" />
            <xsl:call-template name ="ICB08"/>
            <xsl:call-template name="shim"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:call-template name="CUMULCOA" />
            <xsl:call-template name="CUMULCOAC" />
          </xsl:otherwise>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>


  </xsl:template>
  <xsl:template match="DATCENTR">
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
        <th class="clCouleur2 clHeight12 clWidth200 clAlignLeft clThNonGras">&#160;DERNIÈRE CENTRALISATION AU</th>
        <td class="clFond clHeight12 clWidth200">
          <div class="clAlignRight">
            &#160;<xsl:call-template name ="displayDateXsl">
              <xsl:with-param name ="InputDate" select ="(.)"/>
            </xsl:call-template>
          </div>
        </td>
        <td class="clCouleur2 clWidth235 clHeight12 clAlignRight">
          <div clas="clAlignRight">&#160;&#160;(en milliers d'euros)</div>
        </td>
      </tr>     
    </table>
    <xsl:call-template name="shim"/>
    <br/>
  </xsl:template>
 
  <xsl:template match="CBEURO">
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
        <th class="clCouleur2 clWidth400 clHeight12">&#160;PRESENCE DE CONCOURS BANCAIRES EUROPEENS </th>
        <td class="clCouleur2 clWidth335 clHeight12">
        </td>
      </tr>
    </table>
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
        <td class="clCouleur2 clWidth635">
          <br/>
          <div class="clAlignLeft">
            &#160;Pour obtenir le détail de l'endettement européen de cette entreprise, vous pouvez contacter le pôle "produits" &#160;du Service Central des Risques par mail : <a href="mailto:4072-produits-ut@banque-france.fr"></a>4072-produits-ut@banque-france.fr
          </div>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
  </xsl:template>

  <!-- *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-->
  <!-- ***************** Les messages diffusions des risques  *******************************************-->

  <xsl:template name ="ICB01">
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
       <td class="clCouleur2 clWidth635">
          <xsl:value-of select="($dictionnaire/mot[@id='ICB01'])"></xsl:value-of>
        </td>
      </tr>
    </table>
  </xsl:template>
  <xsl:template name ="ICB03">
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
       <td class="clCouleur2 clWidth635">
          <xsl:value-of select="($dictionnaire/mot[@id='ICB03'])"></xsl:value-of>
        </td>
      </tr>
    </table>
  </xsl:template>
  <xsl:template name ="ICB04">
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
       <td class="clCouleur2 clWidth635">
          <xsl:value-of select="($dictionnaire/mot[@id='ICB04'])"></xsl:value-of>
        </td>
      </tr>
    </table>
  </xsl:template>
  <xsl:template name ="ICB05">
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
       <td class="clCouleur2 clWidth635">
          <xsl:value-of select="($dictionnaire/mot[@id='ICB05'])"></xsl:value-of>
        </td>
      </tr>
    </table>
  </xsl:template>
  <xsl:template name ="ICB06">
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
       <td class="clCouleur2 clWidth635">
          <xsl:value-of select="($dictionnaire/mot[@id='ICB06'])"></xsl:value-of>
        </td>
      </tr>
    </table>
  </xsl:template>
  <xsl:template name ="ICB07">
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
       <td class="clCouleur2 clWidth635">
          <xsl:value-of select="($dictionnaire/mot[@id='ICB07'])"></xsl:value-of>
        </td>
      </tr>
    </table>
  </xsl:template>
  <xsl:template name ="ICB08">
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
       <td class="clCouleur2 clWidth635">
          <xsl:value-of select="($dictionnaire/mot[@id='ICB08'])"></xsl:value-of>
        </td>
      </tr>
    </table>
  </xsl:template>
  <xsl:template name ="ICB09">
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
       <td class="clCouleur2 clWidth635">
          <xsl:value-of select="($dictionnaire/mot[@id='ICB09'])"></xsl:value-of>
        </td>
      </tr>
    </table>
  </xsl:template>

  <!-- *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-->

  <!-- ***************** Concours bancaires individuels ou collectifs *******************************************-->

  <!-- ***************** Concours bancaires individuels *******************************************-->

  <!--DÉTAILS DES CREDITS-->

  <xsl:template name="CUMULCB">
    <div class="clBreakPage"/>
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr class="clAlignCenter">
        <td class="clCouleurGras">
          D&#201;TAILS DES CONCOURS INDIVIDUELS
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>

    <table class="clWidth739 clBorderCell">
      <caption class="visually-hidden">Détails des concours individuels</caption>
      <tr>
        <xsl:apply-templates select="CUMULCB/@MOISREF"/>
        <xsl:apply-templates select="CUMULCB/MTCODCCT"/>
      </tr>
      <tr>
        <td class="clItalic" colspan="11"></td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>

    <table class="clWidth739 clBorderCell">
      <caption class="visually-hidden">Détails des concours individuels</caption>
      <tr>
        <xsl:apply-templates select="CUMULCB/@MOISREF"/>
        <xsl:apply-templates select="CUMULCB/MTCMLT"/>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
    <div class="clBreakPage"/>

    <table class="clWidth739 clBorderCell">
      <caption class="visually-hidden">Détails des concours individuels</caption>
      <tr>
        <xsl:apply-templates select="CUMULCB/@MOISREF"/>
        <xsl:apply-templates select="CUMULCB/MTCC"/>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>

  </xsl:template>

  <xsl:template match="CUMULCB/@MOISREF">
    <xsl:if test="position()=1">
      <xsl:text disable-output-escaping="yes">&lt;td width=&quot;45&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
      <tr>
        <td class="clCouleur2 clWidth45 clHeight20"></td>
      </tr>
      <tr>
        <td class="clCouleur2 clWidth45 clHeight25"></td>
      </tr>
      <tr>
        <td class="clCouleur2 clWidth45 clHeight45"></td>
      </tr>
      <tr>
        <td class="clItalic clWidth45 clHeight5 clAlignCenter clValignBottom"></td>
      </tr>
    </xsl:if>
    <xsl:if test="position() mod 2 != 0">
      <tr>
        <td class="clFond clWidth45 clHeight15 clAlignRight">
          <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="(.)"/>
          </xsl:call-template>
        </td>
      </tr>
    </xsl:if>
    <xsl:if test="position() mod 2 = 0">
      <tr>
        <td class="clTexte clWidth45 clHeight15 clAlignRight">
          <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="(.)"/>
          </xsl:call-template>
        </td>
      </tr>
    </xsl:if>
    <xsl:if test="position()=last()">

      <tr>
        <td class="clItalic clWidth45 clHeight15 clAlignRight">&#160;</td>
      </tr>
      <tr>
        <th class="clFond clWidth45 clHeight15 clAlignRight">
          <b>Moyenne</b>
        </th>
      </tr>
      <tr>
        <td class="clItalic clWidth45 clHeight1">&#160; </td>
      </tr>
      <xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
    </xsl:if>
  </xsl:template>

  <!--CREDIT COURT-->

  <xsl:template match="CUMULCB/MTCODCCT">
    <xsl:if test="position()=1">
      <xsl:text disable-output-escaping="yes">&lt;td width=&quot;739&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
      <a name="credit_ct"></a>
      <xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
      <tr>
        <th colspan="9" class="clCouleur2 clValignTop clHeight20 clWidth580 clAlignCenter clThNonGras" nowrap="true">
          <a name="credit_mobiliseInd"></a>CREDITS MOBILISES
        </th>
        <td class="clWidth114"></td>
      </tr>
      <tr>
        <th colspan="9" class="clCouleur2 clValignTop clHeight25 clWidth580 clAlignCenter clThNonGras" nowrap="true">
          Court terme
          <xsl:if test="$condGraph1">
            <a href="#nullepart" onclick="window.document.forms['FormGraphes'].action='Graphes.aspx#Graphe1';window.document.forms['FormGraphes'].submit	();">
              <img border="0" src="{$root}Images/risque/diagramme_bleu.gif" width="19" height="20" alt="lien vers diagramme"/>
            </a>
          </xsl:if>
          <xsl:if test="not($condGraph1)">
            <img border="0" src="{$root}Images/risque/diagramme_in.gif" width="19" height="20" alt="lien vers diagramme"/>
          </xsl:if>
        </th>

      </tr>
      <tr>
        <th class="clCouleur2 clValignTop clHeight30 clWidth108 clAlignRight clThNonGras">
          Cptes ordinaires débiteurs<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('CO',cstInforisques)" >
            <u>
              (CO)
            </u>
          </a>
        </th>
        <td class="clWidth10"></td>
        <th class="clCouleur2 clValignTop clWidth108 clAlignRight clThNonGras">
          Créances commerciales<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('CC',cstInforisques)" >
            <u>
              (CC)
            </u>
          </a>
        </th>
        <td class="clWidth10"></td>
        <th class="clCouleur2 clValignTop clWidth108 clAlignRight clThNonGras">
          Affacturage<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('AF',cstInforisques)" >
            <u>
              (AF)
            </u>
          </a>
        </th>
        <td class="clCouleur2 clWidth10">&#160;</td>
        <th class="clCouleur2 clValignTop clWidth108 clAlignRight clThNonGras">
          Autres crédits à court terme<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('CA',cstInforisques)" >
            <u>
              (CA)
            </u>
          </a>
        </th>
        <td class="clWidth10 clCouleur2 clAlignCenter clValignBottom">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="45" vspace="0" alt=""/>
        </td>
        <th class="clCouleur2 clValignTop clWidth108 clAlignRight clThNonGras">
          Total court terme <br/>[I]
        </th>
        <td class="clWidth114 clAlignRight"></td>
      </tr>
      <tr>
        <td class="clItalic" colspan="7"></td>
        <td class="clWidth10 clItalic clValignBottom clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="5" vspace="0" alt=""/>
        </td>
        <td class="clItalic" colspan="2"></td>
      </tr>
    </xsl:if>
    <xsl:if test="position() mod 2 != 0">
      <tr>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignRight">&#160;</td>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:apply-templates select="../MTCCCT"/>&#160;
        </td>
        <td class="clFond clWidth10 clAlignRight">&#160;</td>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:apply-templates select="../MTAFCT"/>&#160;
        </td>
        <td class="clFond clWidth10 clAlignRight">&#160;</td>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTACCT)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTCBCT)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clWidth114"></td>
      </tr>
    </xsl:if>
    <xsl:if test="position() mod 2 = 0">
      <tr>
        <td class="clTexte clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clTexte clWidth10 clAlignRight">&#160;</td>
        <td class="clTexte clWidth108 clAlignRight">
          <xsl:apply-templates select="../MTCCCT"/>&#160;
        </td>
        <td class="clTexte clWidth10 clAlignRight">&#160;</td>
        <td class="clTexte clWidth108 clAlignRight">
          <xsl:apply-templates select="../MTAFCT"/>&#160;
        </td>
        <td class="clTexte clWidth10 clAlignRight">&#160;</td>
        <td class="clTexte clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTACCT)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clTexte clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clTexte clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTCBCT)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clWidth114"></td>
      </tr>
    </xsl:if>
    <xsl:if test="position()=last()">
      <tr>
        <td colspan="7" class="clItalic clWidth462"> </td>
        <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth108 clAlignRight"> </td>
        <td class="clWidth114"></td>
      </tr>
      <tr>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCB/MTCODCCT)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignRight">&#160;</td>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCB/MTCCCT)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignRight">&#160;</td>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCB/MTAFCT)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignRight">&#160;</td>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCB/MTACCT)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCB/MTCBCT)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clWidth114"></td>
      </tr>
      <tr>
        <td colspan="10" class="clItalic clHeight1">&#160; </td>
      </tr>

      <xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
    </xsl:if>
  </xsl:template>

  <!--CREDIT MOYEN ET LONG TERME-->

  <xsl:template match="CUMULCB/MTCMLT">

    <xsl:if test="position()=1">

      <xsl:text disable-output-escaping="yes">&lt;td width=&quot;739&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>

      <tr>
        <xsl:if test="($condGraph2)">
          <th rowspan="2" class="clCouleur2 clWidth108 clValignMiddle clAlignRight clThNonGras" nowrap="true">
            <a name="credit_mlt"/>Moyen
            <a href="#nullepart" onclick="window.document.forms['FormGraphes'].action='Graphes.aspx#Graphe2';window.document.forms['FormGraphes'].submit	();">
              <img border="0" src="{$root}Images/risque/diagramme_bleu.gif" width="19" height="20" alt="lien vers diagramme"/>
            </a><br/> et long terme<br/>
            <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('TETA',cstInforisques)" >
              <u>
                (TE+TA)
              </u>
            </a>
            <br/>[II]
          </th>
        </xsl:if>
        <xsl:if test="not($condGraph2)">
          <th rowspan="2" class="clCouleur2 clWidth108 clValignMiddle clAlignRight clThNonGras" nowrap="true">
            <a name="credit_mlt"/>Moyen

            <img border="0" src="{$root}Images/risque/diagramme_in.gif" width="19" height="20" alt="diagramme non disponible"/><br/> et long terme<br/>
            <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('TETA',cstInforisques)" >
              <u>
                (TE+TA)
              </u>
            </a>
            <br/>[II]
          </th>
        </xsl:if>
        <td class="clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
        <xsl:if test="($condGraph3)">
          <th colspan="3" class="clCouleur2 clWidth226 clAlignCenter clValignMiddle clThNonGras" nowrap="true">
            <a name="credit_b">
              Crédits-bails
              <a href="#nullepart" onclick="window.document.forms['FormGraphes'].action='Graphes.aspx#Graphe3';window.document.forms['FormGraphes'].submit	();">
                <img border="0" src="{$root}Images/risque/diagramme_bleu.gif" width="19" height="20" alt="lien vers diagramme"/>
              </a>
            </a>
          </th>
        </xsl:if>
        <xsl:if test="not($condGraph3)">
          <th colspan="3" class="clCouleur2 clWidth226 clAlignCenter clValignMiddle clThNonGras" nowrap="true">
            <a name="credit_b">
              Crédits-bails
              <img border="0" src="{$root}Images/risque/diagramme_in.gif" width="19" height="20" alt="diagramme non disponible"/>
            </a>
          </th>
        </xsl:if>
        <td class="clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
        <th rowspan="2" class="clCouleur2 clWidth88 clValignMiddle clAlignRight clThNonGras" nowrap="true">
          <a name="credit_titr"/>Titrisés<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('IT',cstInforisques)" >
            <u>
              (IT)
            </u>
          </a>
          <br/>[V]
        </th>
        <td class="clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
        <xsl:if test="($condGraph4)">
          <th rowspan="2" class="clCouleur2 clWidth128 clValignMiddle clAlignRight clThNonGras" nowrap="true">
            Total <a href="#nullepart" onclick="window.document.forms['FormGraphes'].action='Graphes.aspx#Graphe4';window.document.forms['FormGraphes'].submit();">
              <img border="0" src="{$root}Images/risque/diagramme_bleu.gif" width="19" height="20" alt="lien vers diagramme"/>
            </a><br/>
            des crédits mobilisés [VI]<br/>[I]+[II]+[III]+[IV]+[V]
          </th>
        </xsl:if>
        <xsl:if test="not($condGraph4)">
          <th rowspan="2" class="clCouleur2 clWidth128 clValignMiddle clAlignRight clThNonGras" nowrap="true">
            Total <img border="0" src="{$root}Images/risque/diagramme_in.gif" width="19" height="20" alt="diagramme non disponible"/><br/>
            des crédits mobilisés [VI]<br/>[I]+[II]+[III]+[IV]+[V]
          </th>
        </xsl:if>

        <td class="clWidth114 clAlignRight">
          <a href="#ancHaut">
            <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page"/>
          </a>
        </td>
      </tr>
      <tr>
        <td class="clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
        <th class="clCouleur2 clWidth108 clAlignRight clValignMiddle clThNonGras">
          Mobiliers
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('BM',cstInforisques)" >
            <u>
              (BM)
            </u>
          </a>
          <br/>[III]
        </th>
        <td class="clCouleur2 clWidth10 clAlignCenter">&#160;</td>
        <th class="clCouleur2 clWidth108 clAlignRight clValignMiddle clThNonGras">
          Immobiliers
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('BI',cstInforisques)" >
            <u>
              (BI)
            </u>
          </a>
          <br/>[IV]
        </th>
        <td class="clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
        <td class="clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
        <td class="clWidth114"></td>
      </tr>
      <tr>
        <td class="clItalic clWidth108"></td>
        <td class="clItalic clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td colspan="3" class="clItalic clWidth226">&#160;</td>
        <td class="clItalic clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth88"></td>
        <td class="clItalic clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth128"></td>
        <td class="clWidth114"></td>
      </tr>
    </xsl:if>

    <xsl:if test="position() mod 2 != 0">
      <tr>

        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTCBM)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10">&#160;</td>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTCBI)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth88 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTTITR)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth128 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTTOT6)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clWidth114"></td>
      </tr>
    </xsl:if>
    <xsl:if test="position() mod 2 = 0">
      <tr>

        <td class="clTexte clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clTexte clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clTexte clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTCBM)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clTexte clWidth10">&#160;</td>
        <td class="clTexte clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTCBI)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clTexte clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clTexte clWidth88 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTTITR)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clTexte clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clTexte clWidth128 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTTOT6)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clWidth114"></td>
      </tr>
    </xsl:if>
    <xsl:if test="position()=last()">
      <tr>
        <td class="clItalic clWidth108"></td>
        <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td colspan="3" class="clItalic clWidth226">&#160;</td>
        <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth88"></td>
        <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic" colspan="2"></td>
      </tr>
      <tr>

        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCB/MTCMLT)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt="" />
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCB/MTCBM)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignRight">&#160;</td>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCB/MTCBI)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth88 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCB/MTTITR)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt="" />
        </td>
        <td class="clFond clWidth128 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCB/MTTOT6)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clWidth114"></td>
      </tr>
      <tr>
        <td colspan="10" class="clItalic clHeight1">&#160;</td>
      </tr>

      <xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
    </xsl:if>
  </xsl:template>
  
  <!-- CREDIT MOBILISABLE -->

  <xsl:template match="CUMULCB/MTCC">
    <xsl:if test="position()=1">
      <xsl:text disable-output-escaping="yes">&lt;td width=&quot;739&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
      <tr>
        <xsl:if test="($condGraph5)">
          <th colspan="5" class="clCouleur2 clHeight25 clWidth270 clAlignCenter clValignMiddle clThNonGras" nowrap="true">
            <a name="credit_mobilisableInd">
              CREDITS MOBILISABLES
              <a href="#nullepart" onclick="window.document.forms['FormGraphes'].action='Graphes.aspx#Graphe5';window.document.forms['FormGraphes'].submit	();">
                <img border="0" src="{$root}Images/risque/diagramme_bleu.gif" width="19" height="20" alt="lien vers diagramme"/>
              </a>
            </a>
          </th>
        </xsl:if>
        <xsl:if test="not($condGraph5)">
          <th colspan="5" class="clCouleur2 clHeight25 clWidth270 clAlignCenter clValignMiddle clThNonGras" nowrap="true">
            <a name="credit_mobilisableInd">
              CREDITS MOBILISABLES

              <img border="0" src="{$root}Images/risque/diagramme_in.gif" width="19" height="20" alt="diagramme non disponible"/>
            </a>
          </th>
        </xsl:if>
        <td class="clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="22" vspace="0" alt=""/>
        </td>
        <th rowspan="2" class="clCouleur2 clWidth93 clValignMiddle clAlignRight clThNonGras" nowrap="true">
          Total <br/>
          crédits mobilisés <br/>
          et mobilisables<br/>
          [VIII]=[VI]+[VII]
        </th>
        <td class="clWidth10 clAlignCenter clValignBottom" rowspan="2">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="91"  vspace="0" alt=""/>
        </td>
        <xsl:if test="($condGraph6)">
          <th rowspan="2" class="clCouleur2 clWidth93 clValignMiddle clAlignCenter clThNonGras" nowrap="true">
            <a name="credit_eg"></a>
            ENGAGEMENTS<br/>
            DE GARANTIE<br/>
            <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('AC',cstInforisques)" >
              <u>
                (AC)
              </u>
            </a>
            <br/>
            <a href="#nullepart" onclick="window.document.forms['FormGraphes'].action='Graphes.aspx#Graphe6';window.document.forms['FormGraphes'].submit	();">
              <img border="0" src="{$root}Images/risque/diagramme_bleu.gif" width="19" height="20" alt="lien vers diagramme"/>
            </a>           
          </th>
        </xsl:if>
        <xsl:if test="not($condGraph6)">
          <th rowspan="2" class="clCouleur2 clWidth93 clValignMiddle clAlignCenter clThNonGras" nowrap="true">
            <a name="credit_eg"></a>
            ENGAGEMENTS<br/>
            DE GARANTIE<br/>
            <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('AC',cstInforisques)" >
              <u>
                (AC)
              </u>
            </a>
            <br/>
          <img border="0" src="{$root}Images/risque/diagramme_in.gif" width="19" height="20" alt="diagramme non disponible"/> 
          </th>
        </xsl:if>
        <td class="clWidth10 clAlignCenter clValignBottom" rowspan="2">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="91"  vspace="0" alt=""/>
        </td>
         <th rowspan="2" class="clCouleur2 clWidth93 clValignMiddle clAlignCenter clThNonGras" nowrap="true">
            <a name="credit_eg"></a>
            TITRES&#160;<br/>
           DE CREANCES<br/>
            NEGOCIABLES<br/>
           <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('IE',cstInforisques)" >
             <u>
               (IE)
             </u>
           </a>
           <br/>   
         </th>
        <td class="clWidth114 clAlignRight">
          <a href="#ancHaut">
            <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page"/>
          </a>
        </td>
      </tr>
      <tr>
       <th class="clCouleur2 clWidth94 clAlignRight clValignMiddle clThNonGras">
          Partie disponible des crédits mobilisables<br/>
         <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('OC',cstInforisques)" >
           <u>
             (OC)
           </u>
         </a>            
        </th>
        <td class="clWidth10"></td>
       <th class="clCouleur2 clWidth80 clAlignRight clValignMiddle clThNonGras">
          Crédits documentaires<br/>
         <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('OD',cstInforisques)" >
           <u>
             (OD)
           </u>
         </a>         
         </th>
        <td class="clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="70"  vspace="0" alt=""/>
        </td>
        <th class="clCouleur2 clWidth76 clAlignRight clValignMiddle clThNonGras">Total crédits mobilisables [VII]</th>
        <td class="clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="70" vspace="0" alt=""/>
        </td>       
        <td class="clWidth114 clAlignRight">          
        </td>        
      </tr>

    </xsl:if>
    <xsl:if test="position() mod 2 != 0">
      <tr>
       <td class="clFond clWidth94 clAlignRight clHeight15">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10">&#160;</td>
       <td class="clFond clWidth80 clAlignRight clHeight15">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTCD)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
       <td class="clFond clWidth76 clAlignRight clHeight15">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTTOT7)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
       <td class="clFond clWidth93 clAlignRight clHeight15">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTTOT8)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
       <td class="clFond clWidth93 clAlignRight clHeight15">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTAC)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth93 clAlignRight clHeight15">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTIE)"/>
          </xsl:call-template>&#160;
        </td>
         <td class="clWidth114 clHeight15"></td>
      </tr>
    </xsl:if>
    <xsl:if test="position() mod 2 = 0">
      <tr>
        <td class="cltexte clWidth94 clAlignRight clHeight15">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="cltexte clWidth10">&#160;</td>
        <td class="cltexte clWidth80 clAlignRight clHeight15">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTCD)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="cltexte clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="cltexte clWidth76 clAlignRight clHeight15">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTTOT7)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="cltexte clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="cltexte clWidth93 clAlignRight clHeight15">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTTOT8)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="cltexte clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
       <td class="clTexte clWidth93 clAlignRight clHeight15">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTAC)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="cltexte clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clTexte clWidth93 clAlignRight clHeight15">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTIE)"/>
          </xsl:call-template>&#160;
        </td>
         <td class="clWidth114 clHeight15"></td>
      </tr>
    </xsl:if>
    <xsl:if test="position()=last()">
      <tr>
        <td class="clItalic clWidth94 clHeight15"></td>
        <td class="clItalic clWidth10 clAlignCenter"></td>
        <td class="clItalic clWidth80 clHeight15"></td>
        <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth76 clHeight15"></td>
        <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth93 clHeight15"></td>
        <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth93 clHeight15"></td>
        <td class="clItalic clWidth10 clAlignCenter"></td>
        <td class="clItalic clWidth93 clHeight15"></td>
        <td class="clItalic clWidth114 clHeight15"></td>
      </tr>
      <tr>
       <td class="clFond clWidth94 clAlignRight clHeight15">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCB/MTCC)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter"></td>
       <td class="clFond clWidth80 clAlignRight clHeight15">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCB/MTCD)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
       <td class="clFond clWidth76 clAlignRight clHeight15">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCB/MTTOT7)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
       <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
       <td class="clFond clWidth93 clAlignRight clHeight15">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCB/MTTOT8)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
       <td class="clFond clWidth93 clAlignRight clHeight15">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCB/MTAC)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth93 clAlignRight clHeight15">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCB/MTIE)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
         <td class="clWidth114 clHeight15"></td>
      </tr>
      <tr>
        <td colspan="12" class="clItalic clHeight1">&#160;</td>
      </tr>
      <xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
    </xsl:if>
  </xsl:template>

  <!-- ***************** Concours bancaires collectifs *******************************************-->

  <!--DÉTAILS DES CREDITS-->

  <xsl:template name="CUMULCBC">
    <div class="clBreakPage"/>
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr class="clAlignCenter">
        <td class="clCouleurGras">
          D&#201;TAILS DES PARTICIPATIONS EN COMPTE COLLECTIF
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>

    <table class="clWidth739 clBorderCell">
      <caption class="visually-hidden">Détails des participations en compte collectif</caption>
      <tr>
        <xsl:apply-templates select="CUMULCBC/@MOISREF"/>
        <xsl:apply-templates select="CUMULCBC/MTCODCCT"/>
      </tr>
      <tr>
        <td class="clItalic" colspan="11"></td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>

    <table class="clWidth739 clBorderCell">
      <caption class="visually-hidden">Détails des participations en compte collectif</caption>
      <tr>
        <xsl:apply-templates select="CUMULCBC/@MOISREF"/>
        <xsl:apply-templates select="CUMULCBC/MTCMLT"/>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
    <div class="clBreakPage"/>

    <table class="clWidth739 clBorderCell">
      <caption class="visually-hidden">Détails des participations en compte collectif</caption>
      <tr>
        <xsl:apply-templates select="CUMULCBC/@MOISREF"/>
        <xsl:apply-templates select="CUMULCBC/MTCC"/>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
  </xsl:template>

  <xsl:template match="CUMULCBC/@MOISREF">
   <xsl:if test="position()=1">
      <xsl:text disable-output-escaping="yes">&lt;td width=&quot;45&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
      <tr>
        <td class="clCouleur2 clWidth45 clHeight20"></td>
      </tr>
      <tr>
        <td class="clCouleur2 clWidth45 clHeight25"></td>
      </tr>
      <tr>
        <td class="clCouleur2 clWidth45 clHeight45"></td>
      </tr>
      <tr>
        <td class="clItalic clWidth45 clHeight5 clAlignCenter clValignBottom"></td>
      </tr>
    </xsl:if>
    <xsl:if test="position() mod 2 != 0">
      <tr>
        <td class="clFond clWidth45 clHeight15 clAlignRight">
          <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="(.)"/>
          </xsl:call-template>
        </td>
      </tr>
    </xsl:if>
    <xsl:if test="position() mod 2 = 0">
      <tr>
        <td class="clTexte clWidth45 clHeight15 clAlignRight">
          <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="(.)"/>
          </xsl:call-template>
        </td>
      </tr>
    </xsl:if>
    <xsl:if test="position()=last()">

      <tr>
        <td class="clItalic clWidth45 clHeight15 clAlignRight">&#160;</td>
      </tr>
      <tr>
        <th class="clFond clWidth45 clHeight15 clAlignRight">
          <b>Moyenne</b>
        </th>
      </tr>
      <tr>
        <td class="clItalic clWidth45 clHeight1">&#160; </td>
      </tr>
      <xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
    </xsl:if>
  </xsl:template>

  <!--CREDIT COURT-->
  <xsl:template match="CUMULCBC/MTCODCCT">
    <xsl:if test="position()=1">
      <xsl:text disable-output-escaping="yes">&lt;td width=&quot;739&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
      <a name="credit_ct"></a>
      <xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
      <tr>
        <th colspan="9" class="clCouleur2 clValignTop clHeight20 clWidth580 clAlignCenter clThNonGras" nowrap="true">
          <a name="MobiliseColl"></a>CREDITS MOBILISES
        </th>
        <td class="clWidth114"></td>
      </tr>
      <tr>
        <th colspan="9" class="clCouleur2 clValignTop clHeight25 clWidth580 clAlignCenter clThNonGras" nowrap="true">
          Court terme
          <xsl:if test="$condGraph7">
            <a href="#nullepart" onclick="window.document.forms['FormGraphes'].action='Graphes.aspx#Graphe7';window.document.forms['FormGraphes'].submit	();">
              <img border="0" src="{$root}Images/risque/diagramme_bleu.gif" width="19" height="20" alt="lien vers diagramme"/>
            </a>
          </xsl:if>
          <xsl:if test="not($condGraph7)">
            <img border="0" src="{$root}Images/risque/diagramme_in.gif" width="19" height="20" alt="diagramme non disponible"/>
          </xsl:if>
        </th>
      </tr>
      <tr>
        <th class="clCouleur2 clValignTop clWidth108 clHeight30 clAlignCenter clThNonGras">
          Cptes ordinaires débiteurs<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('CO',cstInforisques)" >
            <u>
              (CO)
            </u>
          </a>
        </th>
        <td class="clWidth10"></td>
        <th class="clCouleur2 clValignTop clWidth108 clAlignRight clThNonGras">
          Créances commerciales<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('CC',cstInforisques)" >
            <u>
              (CC)
            </u>
          </a>
        </th>
        <td class="clWidth10"></td>
        <th class="clCouleur2 clWidth108 clAlignRight clThNonGras">
          Affacturage<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('AF',cstInforisques)" >
            <u>
              (AF)
            </u>
          </a>
        </th>
        <td class="clCouleur2 clWidth10">&#160;</td>
        <th class="clCouleur2 clValignTop clWidth108 clAlignRight clThNonGras">
          Autres crédits à court terme<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('CA',cstInforisques)" >
            <u>
              (CA)
            </u>
          </a>
        </th>
        <td class="clCouleur2 clValignBottom clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="45" vspace="0" alt=""/>
        </td>
        <th class="clCouleur2 clValignTop clWidth108 clAlignRight clThNonGras">
          Total court terme <br/>[I]
        </th>
        <td class="clWidth114 clAlignRight"></td>
      </tr>
      <tr>
        <td class="clItalic" colspan="7"></td>
        <td class="clItalic clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="5" vspace="0" alt=""/>
        </td>
        <td class="clItalic" colspan="2"></td>
      </tr>
    </xsl:if>
    <xsl:if test="position() mod 2 != 0">
      <tr>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignRight">&#160;</td>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:apply-templates select="../MTCCCT"/>&#160;
        </td>
        <td class="clFond clWidth10 clAlignRight">&#160;</td>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:apply-templates select="../MTAFCT"/>&#160;
        </td>
        <td class="clFond clWidth10 clAlignRight">&#160;</td>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTACCT)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTCBCT)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clWidth114"></td>
      </tr>
    </xsl:if>
    <xsl:if test="position() mod 2 = 0">
      <tr>
        <td class="clTexte clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clTexte clWidth10 clAlignRight">&#160;</td>
        <td class="clTexte clWidth108 clAlignRight">
          <xsl:apply-templates select="../MTCCCT"/>&#160;
        </td>
        <td class="clTexte clWidth10 clAlignRight">&#160;</td>
        <td class="clTexte clWidth108 clAlignRight">
          <xsl:apply-templates select="../MTAFCT"/>&#160;
        </td>
        <td class="clTexte clWidth10 clAlignRight">&#160;</td>
        <td class="clTexte clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTACCT)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clTexte clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clTexte clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTCBCT)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clWidth114"></td>
      </tr>
    </xsl:if>
    <xsl:if test="position()=last()">
      <tr>
        <td colspan="7" class="clItalic clWidth462"> </td>
        <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth108 clAlignRight"> </td>
        <td class="clWidth114"></td>
      </tr>
      <tr>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCBC/MTCODCCT)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignRight">&#160;</td>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCBC/MTCCCT)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignRight">&#160;</td>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCBC/MTAFCT)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignRight">&#160;</td>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCBC/MTACCT)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCBC/MTCBCT)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clWidth114"></td>
      </tr>
      <tr>
        <td class="clItalic clHeight1" colspan="10">&#160; </td>
      </tr>

      <xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
    </xsl:if>
  </xsl:template>

  <!--CREDIT MOYEN ET LONG TERME-->

  <xsl:template match="CUMULCBC/MTCMLT">

    <xsl:if test="position()=1">

      <xsl:text disable-output-escaping="yes">&lt;td width=&quot;739&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>

      <tr>
        <xsl:if test="($condGraph8)">
          <th rowspan="2" class="clCouleur2 clWidth108 clValignMiddle clAlignRight clThNonGras" nowrap="true">
            <a name="credit_mlt"/>Moyen
            <a href="#nullepart" onclick="window.document.forms['FormGraphes'].action='Graphes.aspx#Graphe8';window.document.forms['FormGraphes'].submit	();">
              <img border="0" src="{$root}Images/risque/diagramme_bleu.gif" width="19" height="20" alt="lien vers diagramme"/>
            </a><br/> et long terme<br/>
            <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('TETA',cstInforisques)" >
              <u>
                (TE+TA)
              </u>
            </a>
            <br/>[II]
          </th>
        </xsl:if>
        <xsl:if test="not($condGraph8)">
          <th rowspan="2" class="clCouleur2 clWidth108 clValignMiddle clAlignRight clThNonGras" nowrap="true">
            <a name="credit_mlt"/>Moyen
            <img border="0" src="{$root}Images/risque/diagramme_in.gif" width="19" height="20" alt="diagramme non disponible"/><br/>
            et long terme<br/>
            <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('TETA',cstInforisques)" >
              <u>
                (TE+TA)
              </u>
            </a>
            <br/>[II]  
        </th>
        </xsl:if>
        <td class="clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
        <xsl:if test="($condGraph9)">
          <th colspan="3" class="clCouleur2 clWidth226 clValignMiddle clAlignCenter clThNonGras" nowrap="true">
            <a name="credit_b">
              Crédits-bails
              <a href="#nullepart" onclick="window.document.forms['FormGraphes'].action='Graphes.aspx#Graphe9';window.document.forms['FormGraphes'].submit	();">
                <img border="0" src="{$root}Images/risque/diagramme_bleu.gif" width="19" height="20" alt="lien vers diagramme"/>
              </a>
            </a>
          </th>
        </xsl:if>
        <xsl:if test="not($condGraph9)">
          <th colspan="3" class="clCouleur2 clWidth226 clValignMiddle clAlignCenter clThNonGras" nowrap="true">
            <a name="credit_b">
              Crédits-bails
              <img border="0" src="{$root}Images/risque/diagramme_in.gif" width="19" height="20" alt="diagramme non disponible"/>
            </a>
          </th>
        </xsl:if>
        <td class="clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
        <th rowspan="2" class="clCouleur2 clWidth88 clValignMiddle clAlignRight clThNonGras" nowrap="true">
          <a name="credit_titr"/>Titrisés<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('IT',cstInforisques)" >
            <u>
              (IT)
            </u>
          </a>
          <br/>[V]
        </th>
         <td class="clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
        <xsl:if test="($condGraph10)">
          <th rowspan="2" class="clCouleur2 clWidth128 clValignMiddle clAlignRight clThNonGras" nowrap="true">
            Total <a href="#nullepart" onclick="window.document.forms['FormGraphes'].action='Graphes.aspx#Graphe10';window.document.forms['FormGraphes'].submit();">
              <img border="0" src="{$root}Images/risque/diagramme_bleu.gif" width="19" height="20" alt="lien vers diagramme"/>
            </a><br/>
            des crédits mobilisés [VI]<br/>[I]+[II]+[III]+[IV]+[V]
          </th>
        </xsl:if>
        <xsl:if test="not($condGraph10)">
          <th rowspan="2" class="clCouleur2 clWidth128 clValignMiddle clAlignRight clThNonGras" nowrap="true">
            Total <img border="0" src="{$root}Images/risque/diagramme_in.gif" width="19" height="20" alt="diagramme non disponible"/><br/>
            des crédits mobilisés [VI]<br/>[I]+[II]+[III]+[IV]+[V]
          </th>
        </xsl:if>

        <td class="clAlignRight clWidth114">
          <a href="#ancHaut">
            <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page"/>
          </a>
        </td>
      </tr>
      <tr>
        <td class="clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
       <th class="clCouleur2 clWidth108 clAlignRight clValignMiddle clThNonGras">
          Mobiliers
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('BM',cstInforisques)" >
            <u>
              (BM)
            </u>
          </a><br/>[III]
        </th>
        <td class="clCouleur2 clAlignCenter clWidth10">&#160;</td>
       <th class="clCouleur2 clWidth108 clAlignRight clValignMiddle clThNonGras">
          Immobiliers
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('BI',cstInforisques)" >
            <u>
              (BI)
            </u>
          </a>
          <br/>[IV]
        </th>
         <td class="clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
         <td class="clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
        <td class="clWidth114"></td>
      </tr>
      <tr>
        <td class="clItalic clWidth108"></td>
        <td class="clItalic clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td colspan="3" class="clItalic clWidth226">&#160;</td>
        <td class="clItalic clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth88"></td>
        <td class="clItalic clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth128"></td>
        <td class="clWidth114"></td>        
      </tr>
    </xsl:if>

    <xsl:if test="position() mod 2 != 0">
      <tr>
       <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
       <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTCBM)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10">&#160;</td>
       <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTCBI)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
       <td class="clFond clWidth88 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTTITR)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
       <td class="clFond clWidth128 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTTOT6)"/>
          </xsl:call-template>&#160;
        </td>
         <td class="clWidth114"></td>
      </tr>
    </xsl:if>
    <xsl:if test="position() mod 2 = 0">
      <tr>
       <td class="clTexte clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clTexte clAlignCenter clWidth10">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
       <td class="clTexte clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTCBM)"/>
          </xsl:call-template>&#160;
        </td>
         <td class="clTexte clWidth10">&#160;</td>
       <td class="clTexte clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTCBI)"/>
          </xsl:call-template>&#160;
        </td>
       <td class="clTexte clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
       <td class="clTexte clWidth88 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTTITR)"/>
          </xsl:call-template>&#160;
        </td>
       <td class="clTexte clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
       <td class="clTexte clWidth128 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTTOT6)"/>
          </xsl:call-template>&#160;
        </td>
         <td class="clWidth114"></td>
      </tr>
    </xsl:if>
    <xsl:if test="position()=last()">
      <tr>
        <td class="clItalic clWidth108"></td>
         <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td colspan="3" class="clItalic clWidth226">&#160;</td>
         <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth88"></td>
         <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic" colspan="2"></td>
      </tr>
      <tr>

       <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCBC/MTCMLT)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
       <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCBC/MTCBM)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignRight">&#160;</td>
       <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCBC/MTCBI)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
       <td class="clFond clWidth88 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCBC/MTTITR)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
       <td class="clFond clWidth128 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCBC/MTTOT6)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
         <td class="clWidth114"></td>
      </tr>
      <tr>
        <td class="clItalic clHeight1" colspan="10">&#160;</td>
      </tr>

      <xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
    </xsl:if>
  </xsl:template>

  <!-- CREDIT MOBILISABLE -->
  
   <xsl:template match="CUMULCBC/MTCC">
    <xsl:if test="position()=1">
      <xsl:text disable-output-escaping="yes">&lt;td width=&quot;739&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
      <tr>
        <xsl:if test="($condGraph11)">
          <th colspan="5" class="clCouleur2 clHeight25 clWidth344 clAlignCenter clValignMiddle clThNonGras" nowrap="true">
            <a name="credit_mobilisableColl">
              CREDITS MOBILISABLES
              <a href="#nullepart" onclick="window.document.forms['FormGraphes'].action='Graphes.aspx#Graphe11';window.document.forms['FormGraphes'].submit	();">
                <img border="0" src="{$root}Images/risque/diagramme_bleu.gif" width="19" height="20" alt="lien vers diagramme"/>
              </a>
            </a>
          </th>
        </xsl:if>
        <xsl:if test="not($condGraph11)">
          <th colspan="5" class="clCouleur2 clHeight25 clWidth344 clAlignCenter clValignMiddle clThNonGras" nowrap="true">
            <a name="credit_mobilisableColl">
              CREDITS MOBILISABLES

              <img border="0" src="{$root}Images/risque/diagramme_in.gif" width="19" height="20" alt="diagramme non disponible"/>
            </a>
          </th>
        </xsl:if>
        <td class="clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="22" vspace="0" alt=""/>
        </td>
        <th rowspan="2" class="clCouleur2 clWidth108 clValignMiddle clAlignRight clThNonGras" nowrap="true">
          Total<br/>
          crédits mobilisés<br/>
          et mobilisables<br/>
          [VIII]=[VI]+[VII]
        </th>
        <td class="clWidth10 clAlignCenter clValignBottom" rowspan="2">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="91"  vspace="0" alt=""/>
        </td>
        <xsl:if test="($condGraph12)">
          <th rowspan="2" class="clCouleur2 clWidth108 clValignMiddle clAlignRight clThNonGras" nowrap="true">
            <a name="credit_eg"></a>
            ENGAGEMENTS<br/>
            DE GARANTIE<br/>
            <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('AC',cstInforisques)" >
              <u>
                (AC)
              </u>
            </a>
            <br/>
            <a href="#nullepart" onclick="window.document.forms['FormGraphes'].action='Graphes.aspx#Graphe12';window.document.forms['FormGraphes'].submit	();">
              <img border="0" src="{$root}Images/risque/diagramme_bleu.gif" width="19" height="20" alt="lien vers diagramme"/>
            </a>
          </th>
        </xsl:if>
        <xsl:if test="not($condGraph6)">
          <th rowspan="2" class="clCouleur2 clWidth108 clValignMiddle clAlignRight clThNonGras" nowrap="true">
            <a name="credit_eg"></a>
            ENGAGEMENTS<br/>
            DE GARANTIE<br/>
            <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('AC',cstInforisques)" >
              <u>
                (AC)
              </u>
            </a>     
            <br/>
            <img border="0" src="{$root}Images/risque/diagramme_in.gif" width="19" height="20" alt="diagramme non disponible"/>
            </th>
        </xsl:if>
        <td class="clWidth114 clAlignRight">
          <a href="#ancHaut">
            <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page"/>
          </a>
        </td>
      </tr>
      <tr>
       <th class="clCouleur2 clWidth108 clAlignRight clValignMiddle clThNonGras">
          Partie disponible des crédits mobilisables<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('OC',cstInforisques)" >
            <u>
              (OC)
            </u>
          </a>
        </th>
        <td class="clWidth10"></td>
       <th class="clCouleur2 clWidth108 clAlignRight clValignMiddle clThNonGras">
          Crédits documentaires<br/>
           <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('OD',cstInforisques)" >
            <u>
              (OD)
            </u>
          </a>
        </th>
        <td class="clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="70"  vspace="0" alt=""/>
        </td>
       <th class="clCouleur2 clWidth108 clAlignRight clValignMiddle clThNonGras">Total crédits mobilisables [VII]</th>
        <td class="clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="70" vspace="0" alt=""/>
        </td>
         <td class="clWidth114"></td>
      </tr>

    </xsl:if>
    <xsl:if test="position() mod 2 != 0">
      <tr>
       <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10">&#160;</td>
       <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTCD)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
       <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTTOT7)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
       <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTTOT8)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
       <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTAC)"/>
          </xsl:call-template>&#160;
        </td>
         <td class="clWidth114"></td>
      </tr>
    </xsl:if>
    <xsl:if test="position() mod 2 = 0">
      <tr>
       <td class="cltexte clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="cltexte clWidth10">&#160;</td>
       <td class="cltexte clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTCD)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="cltexte clWidth10 clValignBottom clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
       <td class="cltexte clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTTOT7)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="cltexte clWidth10 clValignBottom clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
       <td class="cltexte clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTTOT8)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="cltexte clWidth10 clValignBottom clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
       <td class="clTexte clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTAC)"/>
          </xsl:call-template>&#160;
        </td>
         <td class="clWidth114"></td>
      </tr>
    </xsl:if>
    <xsl:if test="position()=last()">
      <tr>
        <td class="clItalic clWidth108"></td>
         <td class="clItalic clWidth10 clAlignCenter"></td>
        <td class="clItalic clWidth108"></td>
         <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth108"></td>
         <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth108"></td>
         <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic" colspan="2"></td>
      </tr>
      <tr>
       <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCBC/MTCC)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter"></td>
       <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCBC/MTCD)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
       <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCBC/MTTOT7)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
       <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCBC/MTTOT8)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
       <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCBC/MTAC)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
         <td class="clWidth114"></td>
      </tr>
      <tr>
        <td class="clItalic clHeight1" colspan="10">&#160;</td>
      </tr>
      <xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
    </xsl:if>
  </xsl:template>

  <!-- *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-->
  <!-- *****************Concours déclarés par des intermédiaires en financement participatif *******************************************-->

  <xsl:template name="CUMULCIFP">
    <table class="clWidth739 clBorderCell" role="presentation">
      <tr class="clAlignCenter">
        <td class="clCouleurGras clWidth635">D&#201;TAILS DES CONCOURS D&#201;CLAR&#201;S PAR</td>
        <td class="clAlignRight clWidth104">&#160;</td>
      </tr>
      <tr class="clAlignCenter">
        <td class="clCouleurGras clWidth635">DES INTERMEDIAIRES EN FINANCEMENT PARTICIPATIF</td>
        <td class="clAlignRight clWidth104">&#160;</td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>

    <table class="clWidth635 clBorderCell">
      <caption class="visually-hidden">Détails des concours déclarés par des intermediaires en financement participatif</caption>
      <tr>
        <xsl:apply-templates select="CUMULCIFP/@MOISREF"/>
        <xsl:apply-templates select="CUMULCIFP/MTCD"/>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
  </xsl:template>

  <xsl:template match="CUMULCIFP/@MOISREF">
    <xsl:if test="position()=1">
      <xsl:text disable-output-escaping="yes">&lt;td width=&quot;45&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
      <tr>
        <td class="clCouleur2 clHeight20 clWidth65"></td>
      </tr>
      <tr>
        <td class="clCouleur2 clHeight25 clWidth65"></td>
      </tr>
      <tr>
        <td class="clCouleur2 clHeight5 clWidth65"></td>
      </tr>

    </xsl:if>
    <xsl:if test="position() mod 2 != 0">
      <tr>
        <td class="clFond clWidth65 clHeight15 clAlignRight">
          <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="(.)"/>
          </xsl:call-template>
        </td>
      </tr>
    </xsl:if>
    <xsl:if test="position() mod 2 = 0">
      <tr>
        <td  class="clTexte clWidth65 clHeight15 clAlignRight">
          <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="(.)"/>
          </xsl:call-template>
        </td>
      </tr>
    </xsl:if>
    <xsl:if test="position()=last()">
      <tr>
        <td class="clItalic clWidth45 clHeight15 clAlignRight">&#160;</td>
      </tr>
      <tr>
        <th class="clFond clWidth65 clHeight15 clAlignRight">
          <b>Moyenne</b>
        </th>
      </tr>
      <tr>
        <td class="clItalic clWidth65 clHeight1">&#160; </td>
      </tr>
      <xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
    </xsl:if>
  </xsl:template>

  <xsl:template match="CUMULCIFP/MTCD">
    <xsl:if test="position()=1">
      <xsl:text disable-output-escaping="yes">&lt;td width=&quot;739&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>

      <xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
      <tr>
        <th colspan="9" class="clCouleur2 clValignTop clWidth580 clHeight20 clAlignCenter clThNonGras" nowrap="true">CREDITS MOBILISES</th>
        <td class="clWidth106"></td>
      </tr>

      <tr class="clHeight25">
        <th class="clCouleur2 clValignTop clWidth110 clAlignRight clThNonGras">
          Durée &#60;= à 1 an
        </th>
        <td class="clWidth4"></td>
        <td class="clCouleur2 clValignTop clWidth110 clAlignRight">
          &#160;
        </td>
        <td class="clWidth5"></td>
        <th class="clCouleur2 clValignTop clWidth100 clAlignRight clThNonGras">
          Durée &#62; à 1 an
        </th>
        <td class="clCouleur2 clWidth7">&#160;</td>
        <td class="clCouleur2 clValignTop clWidth110 clAlignRight">
          &#160;
        </td>
        <td class="clCouleur2 clWidth12 clAlignCenter clValignBottom">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="25" vspace="0" alt=""/>
        </td>
        <th class="clCouleur2 clValignTop clWidth110 clAlignRight clThNonGras">
          Total
        </th>
        <td class="clWidth106 clAlignRight"></td>
      </tr>
      <tr class="clHeight5">
        <td class="clItalic" colspan="7"></td>
        <td class="clItalic clWidth110 clAlignCenter clValignBottom">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="5" vspace="0" alt=""/>
        </td>
        <td class="clItalic" colspan="2"></td>
      </tr>
    </xsl:if>
    <xsl:if test="position() mod 2 != 0">
      <tr class="clHeight15">
        <td  class="clFond clWidth110 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth4 clAlignRight">&#160;</td>
        <td class="clFond clWidth110 clAlignRight">&#160;</td>
        <td class="clFond clWidth5 clAlignRight">&#160;</td>
        <td class="clFond clWidth100 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTLD)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth7 clAlignRight">&#160;</td>
        <td class="clFond clWidth110 clAlignRight">&#160;</td>
        <td class="clFond clWidth12 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth110 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTTOT)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clWidth106"></td>
      </tr>
    </xsl:if>
    <xsl:if test="position() mod 2 = 0">
      <tr class="clHeight15">
        <td class="clTexte clWidth110 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clTexte clWidth4 clAlignRight">&#160;</td>
        <td class="clTexte clWidth110 clAlignRight">&#160;</td>
        <td class="clTexte clWidth5 clAlignRight">&#160;</td>
        <td class="clTexte clWidth100 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTLD)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clTexte clWidth7 clAlignRight">&#160;</td>
        <td class="clTexte clWidth110 clAlignRight">&#160;</td>
        <td class="clTexte clWidth12 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clTexte clWidth110 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTTOT)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clWidth106"></td>
      </tr>


    </xsl:if>
    <xsl:if test="position()=last()">
      <tr>
        <td class="clItalic clWidth110 clAlignRight">&#160;</td>
        <td class="clItalic clWidth4 clAlignRight">&#160;</td>
        <td class="clItalic clWidth110 clAlignRight">&#160;</td>
        <td class="clItalic clWidth5 clAlignRight">&#160;</td>
        <td class="clItalic clWidth100 clAlignRight">&#160;</td>
        <td class="clItalic clWidth7 clAlignRight">&#160;</td>
        <td class="clItalic clWidth110 clAlignRight">&#160;</td>
        <td class="clItalic clWidth12 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth110 clAlignRight">&#160;</td>
        <td class="clWidth106"></td>
      </tr>
      <tr>
        <td class="clFond clWidth110 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCIFP/MTCD)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth4 clAlignRight">&#160;</td>
        <td class="clFond clWidth110 clAlignRight">&#160;</td>
        <td class="clFond clWidth5 clAlignRight">&#160;</td>
        <td class="clFond clWidth100 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCIFP/MTLD)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth7 clAlignRight">&#160;</td>
        <td class="clFond clWidth110 clAlignRight">&#160;</td>
        <td class="clFond clWidth12 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth110 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCIFP/MTTOT)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clWidth106"></td>
      </tr>
      <tr>
        <td class="clItalic clHeight1" colspan="10">&#160; </td>
      </tr>

      <xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
    </xsl:if>
  </xsl:template>

  <!-- *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-* -->
  <!-- **************Concours déclarés par des sociétés de gestion de portefeuille et des entreprises d?assurance, mutuelles et institutions de prévoyance *******************************************-->

  <!-- ***************** Concours bancaires individuels *******************************************-->

  <!--DÉTAILS DES CREDITS-->

  <xsl:template name="CUMULCOA">
    <!-- titre du tableau -->
    <table class="clWidth739 clBorderCell" role="presentation">
      <tr class="clAlignCenter">
        <td class="clCouleurGras clWidth635">CONCOURS D&#201;CLAR&#201;S PAR DES SOCI&#201;T&#201;S DE GESTION DE PORTEFEUILLE ET DES ENTREPRISES</td>
        <td class="clAlignRight clWidth104">&#160;</td>
      </tr>
      <tr class="clAlignCenter">
        <td class="clCouleurGras clWidth635"> D'ASSURANCE, MUTUELLES ET INSTITUTIONS DE PR&#201;VOYANCE</td>
        <td class="clAlignRight clWidth104">&#160;</td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>

    <table class="clWidth739 clBorderCell" role="presentation">
      <tr class="clAlignCenter">
        <td class="clCouleurGras clWidth635">D&#201;TAILS DES CONCOURS INDIVIDUELS</td>
        <td class="clAlignRight clWidth104">&#160;</td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
    <table class="clWidth635 clBorderCell">
      <caption class="visually-hidden">Détails des concours individuels</caption>
      <tr>
        <xsl:apply-templates select="CUMULCOA/@MOISREF"/>
        <xsl:apply-templates select="CUMULCOA/MTCCCT"/>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>

    <table class="clWidth739 clBorderCell">
      <caption class="visually-hidden">Détails des concours individuels</caption>
      <tr>
        <xsl:apply-templates select="CUMULCOA/@MOISREF"/>
        <xsl:apply-templates select="CUMULCOA/MTCMLT"/>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>

    <table class="clWidth739 clBorderCell">
      <caption class="visually-hidden">Détails des concours individuels</caption>
      <tr>
        <xsl:apply-templates select="CUMULCOA/@MOISREF"/>
        <xsl:apply-templates select="CUMULCOA/MTCC"/>
      </tr>
    </table>
    <br/>
    <xsl:call-template name="shim"/>
    <br/>

  </xsl:template>

  <xsl:template match="CUMULCOA/@MOISREF">
    <xsl:if test="position()=1">
      <xsl:text disable-output-escaping="yes">&lt;td width=&quot;45&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
      <tr>
        <td class="clCouleur2 clWidth65 clHeight20"></td>
      </tr>
      <tr>
        <td class="clCouleur2 clWidth65 clHeight25"></td>
      </tr>
      <tr>
        <td class="clCouleur2 clWidth65 clHeight45"></td>
      </tr>
      <tr>
        <td class="clItalic clValignBottom clWidth65 clAlignCenter clHeight5"></td>
      </tr>
    </xsl:if>
    <xsl:if test="position() mod 2 != 0">
      <tr>
        <td class="clFond clWidth65 clAlignRight clHeight15">
          <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="(.)"/>
          </xsl:call-template>
        </td>
      </tr>
    </xsl:if>
    <xsl:if test="position() mod 2 = 0">
      <tr>
        <td class="clTexte clWidth65 clAlignRight clHeight15">
          <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="(.)"/>
          </xsl:call-template>
        </td>
      </tr>
    </xsl:if>
    <xsl:if test="position()=last()">

      <tr>
        <td class="clItalic clWidth65 clAlignRight clHeight15">&#160;</td>
      </tr>
      <tr>
        <th class="clFond clWidth65 clAlignRight clHeight15">
          <b>Moyenne</b>
        </th>
      </tr>
      <tr>
        <td class="clItalic clWidth65 clHeight1">&#160; </td>
      </tr>
      <xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
    </xsl:if>


  </xsl:template>

  <!--CREDIT COURT-->

  <xsl:template match="CUMULCOA/MTCCCT">
    <xsl:if test="position()=1">
      <xsl:text disable-output-escaping="yes">&lt;td width=&quot;739&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>

      <xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
      <tr>

        <th colspan="9" class="clCouleur2 clValignTop clHeight20 clWidth580 clAlignCenter clThNonGras" nowrap="true">CREDITS MOBILISES</th>
        <td class="clWidth106"></td>
      </tr>
      <tr>

        <th colspan="9" class="clCouleur2 clValignTop clHeight25 clAlignCenter clThNonGras" nowrap="true">Court terme</th>
      </tr>

      <tr class="clHeight30">
        <td class="clCouleur2 clValignTop clHeight30 clWidth110 clAlignRight">
          &#160;
        </td>
        <td class="clWidth4"></td>
        <th class="clCouleur2 clValignTop clWidth110 clAlignRight clThNonGras">
          Créances<br/>commerciales<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('CCCD',cstInforisques)" >
            <u>
              (CC)
            </u>
          </a>
        </th>
        <td class="clWidth5"></td>
        <td class="clCouleur2 clValignTop clWidth100 clAlignRight">
          &#160;
        </td>
        <td class="clCouleur2 clWidth7">&#160;</td>
        <th class="clCouleur2 clValignTop clWidth110 clAlignRight clThNonGras">
          Autres crédits<br/>à court terme<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('CACD',cstInforisques)" >
            <u>
              (CA)
            </u>
          </a>
        </th>
        <td class="clCouleur2 clValignBottom clWidth12 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="45" vspace="0" alt=""/>
        </td>
        <th class="clCouleur2 clValignTop clWidth110 clAlignRight clThNonGras">
          Total court terme <br/>[I]
        </th>
        <td class="clWidth106 clAlignRight"></td>
      </tr>
      <tr>
        <td class="clItalic" colspan="7"></td>
        <td class="clItalic clValignBottom clWidth12 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="5" vspace="0" alt=""/>
        </td>
        <td class="clItalic" colspan="2"></td>
      </tr>
    </xsl:if>
    <xsl:if test="position() mod 2 != 0">
      <tr>
        <td class="clFond clWidth110 clAlignRight">&#160;</td>
        <td class="clFond clWidth4 clAlignRight">&#160;</td>
        <td class="clFond clWidth110 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth5 clAlignRight">&#160;</td>
        <td class="clFond clWidth100 clAlignRight">&#160;</td>
        <td class="clFond clWidth7 clAlignRight">&#160;</td>
        <td class="clFond clWidth110 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTACCT)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth12 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth110 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTCBCT)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clWidth106"></td>
      </tr>
    </xsl:if>
    <xsl:if test="position() mod 2 = 0">
      <tr>
        <td class="clTexte clWidth110 clAlignRight">&#160;</td>
        <td class="clTexte clWidth4 clAlignRight">&#160;</td>
        <td class="clTexte clWidth110 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clTexte clWidth5 clAlignRight">&#160;</td>
        <td class="clTexte clWidth100 clAlignRight">&#160;</td>
        <td class="clTexte clWidth7 clAlignRight">&#160;</td>
        <td class="clTexte clWidth110 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTACCT)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clTexte clWidth12 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clTexte clWidth110 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTCBCT)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clWidth106"></td>
      </tr>

    </xsl:if>
    <xsl:if test="position()=last()">
      <tr>
        <td class="clItalic clWidth110 clAlignRight">&#160;</td>
        <td class="clItalic clWidth4 clAlignRight">&#160;</td>
        <td class="clItalic clWidth110 clAlignRight">&#160;</td>
        <td class="clItalic clWidth5 clAlignRight">&#160;</td>
        <td class="clItalic clWidth100 clAlignRight">&#160;</td>
        <td class="clItalic clWidth7 clAlignRight">&#160;</td>
        <td class="clItalic clWidth110 clAlignRight">&#160;</td>
        <td class="clItalic clWidth12 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth110 clAlignRight">&#160;</td>
        <td class="clWidth106"></td>
      </tr>
      <tr>
        <td class="clFond clWidth110 clAlignRight">
          &#160;
        </td>
        <td class="clFond clWidth4 clAlignRight">&#160;</td>
        <td class="clFond clWidth110 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOA/MTCCCT)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth5 clAlignRight">&#160;</td>
        <td class="clFond clWidth100 clAlignRight">
          &#160;
        </td>
        <td class="clFond clWidth7 clAlignRight">&#160;</td>
        <td class="clFond clWidth110 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOA/MTACCT)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth12 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth110 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOA/MTCBCT)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clWidth106"></td>
      </tr>
      <tr>
        <td class="clItalic clHeight1" colspan="10">&#160; </td>
      </tr>

      <xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
    </xsl:if>
  </xsl:template>

  <!--CREDIT MOYEN ET LONG TERME-->

  <xsl:template match="CUMULCOA/MTCMLT">

    <xsl:if test="position()=1">

      <xsl:text disable-output-escaping="yes">&lt;td width=&quot;739&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
      <tr>
        <td class="clWidth580 clHeight10" colspan="9"></td>
        <td class="clWidth106"></td>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth103 clValignMiddle clAlignRight clThNonGras" rowspan="2">
          Moyen
          <br/> et long terme<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('TETACD',cstInforisques)" >
            <u>
              (TE+TA)
            </u>
          </a><br/>[II]
        </th>
        <td class="clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
        <th colspan="3" class="clCouleur2 clValignMiddle clAlignCenter clThNonGras" nowrap="true">Crédits-bails </th>
        <td class="clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
        <th rowspan="2" class="clCouleur2  clWidth74 clValignMiddle clAlignRight clThNonGras" nowrap="true">
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('ITCD',cstInforisques)" >
            <u>
              (IT
            </u>
          </a> - Crédits<br/>Titrisés+
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('CRCD',cstInforisques)" >
            <u>
              CR
            </u>
          </a><br/> - Crédits Repris)<br/>[V]
        </th>
        <td class="clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
        <th rowspan="2" class="clCouleur2 clWidth158 clValignMiddle clAlignRight clThNonGras" nowrap="true">
          Total <br/>
          des crédits mobilisés [VI]<br/>[I]+[II]+[III]+[IV]+[V]
        </th>
        <td class="clWidth103 clAlignRight">
          <a href="#ancHaut">
            <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page" />
          </a>
        </td>
      </tr>
      <tr class="clHeight25">
        <td class="clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
        <th class="clCouleur2 clWidth104 clValignMiddle clAlignRight clThNonGras">
          Mobiliers
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('BMCD',cstInforisques)" >
            <u>
              (BM)
            </u>
          </a>
          <br/>[III]
        </th>
        <td class="clCouleur2 clWidth5 clAlignRight">&#160;</td>
        <th class="clCouleur2 clWidth108 clValignMiddle clAlignRight clThNonGras">
          Immobiliers
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('BICD',cstInforisques)" >
            <u>
              (BI)
            </u>
          </a>
          <br/>[IV]
        </th>
        <td class="clWidth4 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
        <td class="clWidth4 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
        <td>&#160;</td>
      </tr>
      <tr>
        <td class="clItalic"></td>
        <td class="clItalic clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif"  width="1" height="5" vspace="0" alt=""/>
        </td>
        <td class="clItalic"></td>
        <td class="clItalic"></td>
        <td class="clItalic"></td>
        <td class="clItalic clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif"  width="1" height="5" vspace="0" alt=""/>
        </td>
        <td class="clItalic"></td>
        <td class="clItalic clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif"  width="1" height="5" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth158"></td>
        <td class="clItalic clWidth104"></td>
      </tr>
    </xsl:if>
    <xsl:if test="position() mod 2 != 0">
      <tr>
        <td class="clFond clWidth103 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth104 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTCBM)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth5">&#160;</td>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTCBI)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth74 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTTITR)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTTOT6)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clItalic">&#160;</td>
      </tr>
    </xsl:if>
    <xsl:if test="position() mod 2 = 0">
      <tr>
        <td class="clTexte clWidth103 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clTexte clAlignCenter clWidth10">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clTexte clWidth104 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTCBM)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clTexte clWidth5">&#160;</td>
        <td class="clTexte clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTCBI)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clTexte clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clTexte clWidth74 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTTITR)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clTexte clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clTexte clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTTOT6)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clItalic">&#160;</td>
      </tr>
    </xsl:if>
    <xsl:if test="position()=last()">
      <tr>
        <td class="clItalic clWidth103 clAlignRight">&#160;</td>
        <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth104 clAlignRight">&#160;</td>
        <td class="clItalic clWidth5">&#160;</td>
        <td class="clItalic clWidth108 clAlignRight">&#160;</td>
        <td class="clItalic clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth74 clAlignRight">&#160;</td>
        <td class="clItalic clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clAlignRight">&#160;</td>
        <td ></td>
      </tr>
      <tr>
        <td class="clFond clWidth103 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOA/MTCMLT)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth104 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOA/MTCBM)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth5 clAlignRight">&#160;</td>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOA/MTCBI)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth74 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOA/MTTITR)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOA/MTTOT6)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td ></td>
      </tr>
      <tr>
        <td class="clItalic clHeight1" colspan="10">&#160;</td>
      </tr>
      <xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
    </xsl:if>

  </xsl:template>

  <!-- CREDIT MOBILISABLE -->

  <xsl:template match="CUMULCOA/MTCC">
    <!--<div class="clBreakPage"></div>-->
    <xsl:if test="position()=1">
      <xsl:text disable-output-escaping="yes">&lt;td width=&quot;739&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
      <tr>
        <th colspan="5" class="clCouleur2 clHeight25 clWidth344 clAlignCenter clValignMiddle clThNonGras" nowrap="true">
          CREDITS MOBILISABLES
        </th>
        <td class="clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="22" vspace="0" alt=""/>
        </td>
        <th rowspan="2" class="clCouleur2 clWidth108 clValignMiddle clAlignRight clThNonGras" nowrap="true">
          Total<br/>
          crédits mobilisés<br/>
          et mobilisables<br/>
          [VIII]=[VI]+[VII]
        </th>
        <td class="clWidth10 clAlignCenter clValignBottom" rowspan="2">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="91"  vspace="0" alt=""/>
        </td>

        <th rowspan="2" class="clCouleur2 clWidth108 clValignMiddle clAlignRight clThNonGras" nowrap="true">
          <a name="credit_eg"></a>
          ENGAGEMENTS<br/>
          DE GARANTIE<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('AC',cstInforisques)" >
            <u>
              (AC)
            </u>
          </a>
          <br/>
        </th>
        <td class="clWidth114 clAlignRight">
          <a href="#ancHaut">
            <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page"/>
          </a>
        </td>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth108 clAlignRight clValignMiddle clThNonGras">
          Partie disponible des crédits mobilisables<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('OC',cstInforisques)" >
            <u>
              (OC)
            </u>
          </a>
        </th>
        <td class="clWidth10"></td>
        <th class="clCouleur2 clWidth108 clAlignRight clValignMiddle clThNonGras">
          Crédits documentaires<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('OD',cstInforisques)" >
            <u>
              (OD)
            </u>
          </a>
        </th>
        <td class="clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="70"  vspace="0" alt=""/>
        </td>
        <th class="clCouleur2 clWidth108 clAlignRight clValignMiddle clThNonGras">Total crédits mobilisables [VII]</th>
        <td class="clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="70" vspace="0" alt=""/>
        </td>
        <td class="clWidth114"></td>
      </tr>

    </xsl:if>
    <xsl:if test="position() mod 2 != 0">
      <tr>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10">&#160;</td>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTCD)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTTOT7)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTTOT8)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTAC)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clWidth114"></td>
      </tr>
    </xsl:if>
    <xsl:if test="position() mod 2 = 0">
      <tr>
        <td class="cltexte clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="cltexte clWidth10">&#160;</td>
        <td class="cltexte clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTCD)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="cltexte clWidth10 clValignBottom clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="cltexte clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTTOT7)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="cltexte clWidth10 clValignBottom clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="cltexte clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTTOT8)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="cltexte clWidth10 clValignBottom clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clTexte clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTAC)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clWidth114"></td>
      </tr>
    </xsl:if>
    <xsl:if test="position()=last()">
      <tr>
        <td class="clItalic clWidth108"></td>
        <td class="clItalic clWidth10 clAlignCenter"></td>
        <td class="clItalic clWidth108"></td>
        <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth108"></td>
        <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth108"></td>
        <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic" colspan="2"></td>
      </tr>
      <tr>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOA/MTCC)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter"></td>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOA/MTCD)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOA/MTTOT7)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOA/MTTOT8)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOA/MTAC)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clWidth114"></td>
      </tr>
      <tr>
        <td class="clItalic clHeight1" colspan="10">&#160;</td>
      </tr>
      <xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
    </xsl:if>

  </xsl:template>

  <!-- ***************** Concours bancaires collectifs *******************************************-->

  <!--DÉTAILS DES CREDITS-->

  <xsl:template name="CUMULCOAC">


    <!-- titre du tableau -->
    <table class="clWidth739 clBorderCell" role="presentation">
      <tr class="clAlignCenter">
        <td class="clCouleurGras clWidth635">D&#201;TAILS DES PARTICIPATIONS EN COMPTE COLLECTIF</td>
        <td class="clAlignRight clWidth104">&#160;</td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
    <table class="clWidth635 clBorderCell">
      <caption class="visually-hidden">Détails des participations en compte collectif</caption>
      <tr>
        <xsl:apply-templates select="CUMULCOAC/@MOISREF"/>
        <xsl:apply-templates select="CUMULCOAC/MTCCCT"/>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>

    <table class="clWidth739 clBorderCell">
      <caption class="visually-hidden">Détails des participations en compte collectif</caption>
      <tr>
        <xsl:apply-templates select="CUMULCOAC/@MOISREF"/>
        <xsl:apply-templates select="CUMULCOAC/MTCMLT"/>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>

    <table class="clWidth739 clBorderCell">
      <caption class="visually-hidden">Détails des participations en compte collectif</caption>
      <tr>
        <xsl:apply-templates select="CUMULCOAC/@MOISREF"/>
        <xsl:apply-templates select="CUMULCOAC/MTCC"/>
      </tr>
    </table>
    <br/>
    <xsl:call-template name="shim"/>
    <br/>

  </xsl:template>

  <xsl:template match="CUMULCOAC/@MOISREF">
    <xsl:if test="position()=1">
      <xsl:text disable-output-escaping="yes">&lt;td width=&quot;45&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
      <tr>
        <td class="clCouleur2 clWidth65 clHeight20"></td>
      </tr>
      <tr>
        <td class="clCouleur2 clWidth65 clHeight25"></td>
      </tr>
      <tr>
        <td class="clCouleur2 clWidth65 clHeight45"></td>
      </tr>
      <tr>
        <td class="clItalic clValignBottom clWidth65 clAlignCenter clHeight5"></td>
      </tr>
    </xsl:if>
    <xsl:if test="position() mod 2 != 0">
      <tr>
        <td class="clFond clWidth65 clAlignRight clHeight15">
          <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="(.)"/>
          </xsl:call-template>
        </td>
      </tr>
    </xsl:if>
    <xsl:if test="position() mod 2 = 0">
      <tr>
        <td class="clTexte clWidth65 clAlignRight clHeight15">
          <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="(.)"/>
          </xsl:call-template>
        </td>
      </tr>
    </xsl:if>
    <xsl:if test="position()=last()">
      <tr>
        <td class="clItalic clWidth65 clAlignRight clHeight15">&#160;</td>
      </tr>
      <tr>
        <th class="clFond clWidth65 clAlignRight clHeight15">
          <b>Moyenne</b>
        </th>
      </tr>
      <tr>
        <td class="clItalic clWidth65 clHeight1">&#160; </td>
      </tr>
      <xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
    </xsl:if>
  </xsl:template>

  <!--CREDIT COURT-->

  <xsl:template match="CUMULCOAC/MTCCCT">
    <xsl:if test="position()=1">
      <xsl:text disable-output-escaping="yes">&lt;td width=&quot;739&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>

      <xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
      <tr>

        <th colspan="9" class="clCouleur2 clValignTop clHeight20 clWidth580 clAlignCenter clThNonGras" nowrap="true">CREDITS MOBILISES</th>
        <td class="clWidth106"></td>
      </tr>
      <tr>

        <th colspan="9" class="clCouleur2 clValignTop clHeight25 clAlignCenter clThNonGras" nowrap="true">Court terme</th>
      </tr>

      <tr class="clHeight30">
        <td class="clCouleur2 clValignTop clHeight30 clWidth110 clAlignRight">
          &#160;
        </td>
        <td class="clWidth4"></td>
        <th class="clCouleur2 clValignTop clWidth110 clAlignRight clThNonGras">
          Créances<br/>commerciales<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('CCCD',cstInforisques)" >
            <u>
              (CC)
            </u>
          </a>
        </th>
        <td class="clWidth5"></td>
        <td class="clCouleur2 clValignTop clWidth100 clAlignRight">
          &#160;
        </td>
        <td class="clCouleur2 clWidth7">&#160;</td>
        <th class="clCouleur2 clValignTop clWidth110 clAlignRight clThNonGras">
          Autres crédits<br/>à court terme<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('CACD',cstInforisques)" >
            <u>
              (CA)
            </u>
          </a>
        </th>
        <td class="clCouleur2 clValignBottom clWidth12 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="45" vspace="0" alt=""/>
        </td>
        <th class="clCouleur2 clValignTop clWidth110 clAlignRight clThNonGras">
          Total court terme <br/>[I]
        </th>
        <td class="clWidth106 clAlignRight"></td>
      </tr>
      <tr>
        <td class="clItalic" colspan="7"></td>
        <td class="clItalic clValignBottom clWidth12 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="5" vspace="0" alt=""/>
        </td>
        <td class="clItalic" colspan="2"></td>
      </tr>

    </xsl:if>
    <xsl:if test="position() mod 2 != 0">
      <tr>
        <td class="clFond clWidth110 clAlignRight">&#160;</td>
        <td class="clFond clWidth4 clAlignRight">&#160;</td>
        <td class="clFond clWidth110 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth5 clAlignRight">&#160;</td>
        <td class="clFond clWidth100 clAlignRight">&#160;</td>
        <td class="clFond clWidth7 clAlignRight">&#160;</td>
        <td class="clFond clWidth110 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTACCT)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth12 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth110 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTCBCT)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clWidth106"></td>
      </tr>


    </xsl:if>
    <xsl:if test="position() mod 2 = 0">
      <tr>
        <td class="clTexte clWidth110 clAlignRight">&#160;</td>
        <td class="clTexte clWidth4 clAlignRight">&#160;</td>
        <td class="clTexte clWidth110 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clTexte clWidth5 clAlignRight">&#160;</td>
        <td class="clTexte clWidth100 clAlignRight">&#160;</td>
        <td class="clTexte clWidth7 clAlignRight">&#160;</td>
        <td class="clTexte clWidth110 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTACCT)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clTexte clWidth12 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clTexte clWidth110 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTCBCT)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clWidth106"></td>
      </tr>


    </xsl:if>
    <xsl:if test="position()=last()">
      <tr>
        <td class="clItalic clWidth110 clAlignRight">&#160;</td>
        <td class="clItalic clWidth4 clAlignRight">&#160;</td>
        <td class="clItalic clWidth110 clAlignRight">&#160;</td>
        <td class="clItalic clWidth5 clAlignRight">&#160;</td>
        <td class="clItalic clWidth100 clAlignRight">&#160;</td>
        <td class="clItalic clWidth7 clAlignRight">&#160;</td>
        <td class="clItalic clWidth110 clAlignRight">&#160;</td>
        <td class="clItalic clWidth12 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth110 clAlignRight">&#160;</td>
        <td class="clWidth106"></td>
      </tr>
      <tr>
        <td class="clFond clWidth110 clAlignRight">
          &#160;
        </td>
        <td class="clFond clWidth4 clAlignRight">&#160;</td>
        <td class="clFond clWidth110 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOAC/MTCCCT)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth5 clAlignRight">&#160;</td>
        <td class="clFond clWidth100 clAlignRight">
          &#160;
        </td>
        <td class="clFond clWidth7 clAlignRight">&#160;</td>
        <td class="clFond clWidth110 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOAC/MTACCT)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth12 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth110 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOAC/MTCBCT)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clWidth106"></td>
      </tr>
      <tr>
        <td class="clItalic clHeight1" colspan="10">&#160; </td>
      </tr>

      <xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
    </xsl:if>
  </xsl:template>

  <!--CREDIT MOYEN ET LONG TERME-->

  <xsl:template match="CUMULCOAC/MTCMLT">

    <xsl:if test="position()=1">

      <xsl:text disable-output-escaping="yes">&lt;td width=&quot;739&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
      <tr>
        <td class="clWidth580 clHeight10" colspan="9"></td>
        <td class="clWidth106"></td>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth103 clValignMiddle clAlignRight clThNonGras" rowspan="2">
          Moyen
          <br/> et long terme<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('TETACD',cstInforisques)" >
            <u>
              (TE+TA)
            </u>
          </a>
          <br/>[II]
        </th>
        <td class="clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
        <th colspan="3" class="clCouleur2 clValignMiddle clAlignCenter clThNonGras" nowrap="true">Crédits-bails </th>
        <td class="clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
        <th rowspan="2" class="clCouleur2  clWidth74 clValignMiddle clAlignRight clThNonGras" nowrap="true">
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('ITCD',cstInforisques)" >
            <u>
              (IT
            </u>
          </a>
          - Crédits<br/>Titrisés+
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('CRCD',cstInforisques)" >
            <u>
              CR
            </u>
          </a>
          <br/>- Crédits Repris)<br/>[V]
        </th>
        <td class="clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
        <th rowspan="2" class="clCouleur2 clWidth158 clValignMiddle clAlignRight clThNonGras" nowrap="true">
          Total <br/>
          des crédits mobilisés [VI]<br/>[I]+[II]+[III]+[IV]+[V]
        </th>
        <td class="clWidth103 clAlignRight">
          <a href="#ancHaut">
            <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page" />
          </a>
        </td>
      </tr>
      <tr class="clHeight25">
        <td class="clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
        <th class="clCouleur2 clWidth104 clValignMiddle clAlignRight clThNonGras">
          Mobiliers
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('BMCD',cstInforisques)" >
            <u>
              (BM)
            </u>
          </a><br/>[III]
        </th>
        <td class="clCouleur2 clWidth5 clAlignRight">&#160;</td>
        <th class="clCouleur2 clWidth108 clAlignRight clValignMiddle clThNonGras">
          Immobiliers
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('BICD',cstInforisques)" >
            <u>
              (BI)
            </u>
          </a>
          <br/>[IV]
        </th>
        <td class="clWidth4 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
        <td class="clWidth4 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
        <td>&#160;</td>
      </tr>
      <tr>
        <td class="clItalic"></td>
        <td class="clItalic clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif"  width="1" height="5" vspace="0" alt=""/>
        </td>
        <td class="clItalic"></td>
        <td class="clItalic"></td>
        <td class="clItalic"></td>
        <td class="clItalic clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif"  width="1" height="5" vspace="0" alt=""/>
        </td>
        <td class="clItalic"></td>
        <td class="clItalic clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif"  width="1" height="5" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth158"></td>
        <td class="clItalic clWidth104"></td>
      </tr>
    </xsl:if>
    <xsl:if test="position() mod 2 != 0">
      <tr>
        <td class="clFond clWidth103 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth104 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTCBM)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth5">&#160;</td>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTCBI)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth74 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTTITR)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTTOT6)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clItalic">&#160;</td>
      </tr>
    </xsl:if>
    <xsl:if test="position() mod 2 = 0">
      <tr>
        <td class="clTexte clWidth103 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clTexte clAlignCenter clWidth10">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clTexte clWidth104 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTCBM)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clTexte clWidth5">&#160;</td>
        <td class="clTexte clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTCBI)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clTexte clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clTexte clWidth74 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTTITR)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clTexte clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clTexte clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTTOT6)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clItalic">&#160;</td>
      </tr>
    </xsl:if>
    <xsl:if test="position()=last()">
      <tr>
        <td class="clItalic clWidth103 clAlignRight">&#160;</td>
        <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth104 clAlignRight">&#160;</td>
        <td class="clItalic clWidth5">&#160;</td>
        <td class="clItalic clWidth108 clAlignRight">&#160;</td>
        <td class="clItalic clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth74 clAlignRight">&#160;</td>
        <td class="clItalic clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clAlignRight">&#160;</td>
        <td ></td>
      </tr>
      <tr>
        <td class="clFond clWidth103 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOAC/MTCMLT)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth104 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOAC/MTCBM)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth5 clAlignRight">&#160;</td>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOAC/MTCBI)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth74 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOAC/MTTITR)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOAC/MTTOT6)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td ></td>
      </tr>
      <tr>
        <td class="clItalic clHeight1" colspan="10">&#160;</td>
      </tr>
      <xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
    </xsl:if>

  </xsl:template>

  <!-- CREDIT MOBILISABLE -->

  <xsl:template match="CUMULCOAC/MTCC">
    <!--<div class="clBreakPage"></div>-->
    <xsl:if test="position()=1">
      <xsl:text disable-output-escaping="yes">&lt;td width=&quot;739&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
      <tr>
        <th colspan="5" class="clCouleur2 clHeight25 clWidth344 clAlignCenter clValignMiddle clThNonGras" nowrap="true">
          CREDITS MOBILISABLES
        </th>
        <td class="clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="22" vspace="0" alt=""/>
        </td>
        <th rowspan="2" class="clCouleur2 clWidth108 clValignMiddle clAlignRight clThNonGras" nowrap="true">
          Total<br/>
          crédits mobilisés<br/>
          et mobilisables<br/>
          [VIII]=[VI]+[VII]
        </th>
        <td class="clWidth10 clAlignCenter clValignBottom" rowspan="2">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="91"  vspace="0" alt=""/>
        </td>

        <th rowspan="2" class="clCouleur2 clWidth108 clValignMiddle clAlignRight clThNonGras" nowrap="true">
          <a name="credit_eg"></a>
          ENGAGEMENTS<br/>
          DE GARANTIE<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('AC',cstInforisques)" >
            <u>
              (AC)
            </u>
          </a>
          <br/>
        </th>
        <td class="clWidth114 clAlignRight">
          <a href="#ancHaut">
            <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page"/>
          </a>
        </td>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth108 clAlignRight clValignMiddle clThNonGras">
          Partie disponible des crédits mobilisables<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('OC',cstInforisques)" >
            <u>
              (OC)
            </u>
          </a>
        </th>
        <td class="clWidth10"></td>
        <th class="clCouleur2 clWidth108 clAlignRight clValignMiddle clThNonGras">
          Crédits documentaires<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('OD',cstInforisques)" >
            <u>
              (OD)
            </u>
          </a>
        </th>
        <td class="clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="70"  vspace="0" alt=""/>
        </td>
        <th class="clCouleur2 clWidth108 clAlignRight clValignMiddle clThNonGras">Total crédits mobilisables [VII]</th>
        <td class="clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="70" vspace="0" alt=""/>
        </td>
        <td class="clWidth114"></td>
      </tr>

    </xsl:if>
    <xsl:if test="position() mod 2 != 0">
      <tr>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10">&#160;</td>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTCD)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTTOT7)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTTOT8)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTAC)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clWidth114"></td>
      </tr>
    </xsl:if>
    <xsl:if test="position() mod 2 = 0">
      <tr>
        <td class="cltexte clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="cltexte clWidth10">&#160;</td>
        <td class="cltexte clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTCD)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="cltexte clWidth10 clValignBottom clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="cltexte clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTTOT7)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="cltexte clWidth10 clValignBottom clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="cltexte clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTTOT8)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="cltexte clWidth10 clValignBottom clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clTexte clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTAC)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clWidth114"></td>
      </tr>
    </xsl:if>
    <xsl:if test="position()=last()">
      <tr>
        <td class="clItalic clWidth108"></td>
        <td class="clItalic clWidth10 clAlignCenter"></td>
        <td class="clItalic clWidth108"></td>
        <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth108"></td>
        <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth108"></td>
        <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic" colspan="2"></td>

      </tr>
      <tr>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOAC/MTCC)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter"></td>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOAC/MTCD)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOAC/MTTOT7)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOAC/MTTOT8)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOAC/MTAC)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clWidth114"></td>
      </tr>
      <tr>
        <td class="clItalic clHeight1" colspan="10">&#160;</td>
      </tr>
      <xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>

    </xsl:if>
  </xsl:template>


  <!-- *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-* -->
  <!--********************************************************************************************************************************************************************-->

  <xsl:template match="MTCCCT">
    <xsl:if test="@ETAT">
      <xsl:value-of select="@ETAT"/>
    </xsl:if>
    <xsl:if test="not(@ETAT)">
      <xsl:call-template name ="displayNumberXsl">
        <xsl:with-param name ="InputStringNumber" select ="(../MTCCCT)"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <xsl:template match="MTAFCT">
    <xsl:if test="@ETAT">
      <xsl:value-of select="@ETAT"/>
    </xsl:if>
    <xsl:if test="not(@ETAT)">
      <xsl:call-template name ="displayNumberXsl">
        <xsl:with-param name ="InputStringNumber" select ="(../MTAFCT)"/>
      </xsl:call-template>
    </xsl:if>

  </xsl:template>

  <xsl:template name="doubleFlux">
    <xsl:param name = "fMTCBM" />
    <xsl:param name = "fMTCBI" />
    <xsl:value-of select = "$fMTCBM+$fMTCBI" />
  </xsl:template>

  <!--**************************************** PARTIE INCIDENTS DE PAIEMENT SUR EFFETS ********************************************-->
  <xsl:template match="IPEOR">
    <div class="clBreakPage"/>
    <table class="clWidth635 clBorderCell" role="presentation">
     <tr class="clAlignCenter">
        <td class="clCouleurGras">
          <a name="incidents_paiementsInd"></a>INCIDENTS DE PAIEMENTS
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
    <table class="clWidth635 clBorderCell">
      <caption class="visually-hidden">DÉTAIL DES INCIDENTS DE PAIEMENT EFFETS SUPÉRIEURS OU ÉGAUX À 1524 EUROS</caption>
      <tr>
        <td colspan="4" class="clWidth635 clCouleur2 clValignTop">
          <xsl:apply-templates select="IPERESUME"/>
          <xsl:call-template name="shim"/>
          <br/>
          <a name="detail"></a>
          <xsl:apply-templates select="CIP03" mode="genDiv"/>
          <xsl:if test="IPEDETAIL">
            <table class="clWidth635 clBorderCell">
              <tr>
                <td class="clCouleurGras clWidth635 clAlignCenter">DÉTAIL DES INCIDENTS DE PAIEMENT EFFETS SUPÉRIEURS OU ÉGAUX À 1524 EUROS</td>
              </tr>
            </table>
            <xsl:call-template name="shim"/>
            <br/>
            <xsl:apply-templates select="IPEDETAIL"/>
          </xsl:if>
        </td>
      </tr>
    </table>

  </xsl:template>

  <xsl:template match="IPERESUME">
    <a name="situation"></a>
    <table class="clWidth635 clBorderCell">
      <caption class="visually-hidden">SITUATION RÉSUMÉE SUR 15 MOIS</caption>
      <tr>
         <td class="clWidth19">&#160;</td>
       <td class="clCouleurGras clWidth597 clAlignCenter">
          SITUATION RÉSUMÉE SUR 15 MOIS&#160;(en
          <xsl:call-template name ="displayUnitXsl">
            <xsl:with-param name ="InputUnit" select ="(./@UNITE)"/>
          </xsl:call-template> euros)
        </td>
         <td class="clWidth19">
          <xsl:if test="not($condGraph13)">
            <img name="Image69" border="0" src="{$root}images/boutons/diagramme_in.gif" width="19" height="20" alt="diagramme non disponible"/>
          </xsl:if>
          <xsl:if test="$condGraph13">
            <a href="#nullepart" onclick="window.document.forms['FormGraphes'].action='Graphes.aspx#graphe13';window.document.forms['FormGraphes'].submit();">
              <img name="Image69" border="0" src="{$root}Images/risque/diagramme_bleu.gif" width="19" height="20" alt="lien vers diagramme"/>
            </a>
          </xsl:if>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
    <table class="clWidth635 clBorderCell">
      <tr>
       <td class="clCouleur2 clValignTop clWidth110 clAlignRight">&#160;</td>
        <th colspan="2" class="clCouleur2 clWidth210 clAlignRight clThNonGras">
          Incapacité
          de payer&#160;&#160;&#160;&#160;&#160;&#160;
        </th>
        <th colspan="2" class="clCouleur2 clWidth210 clAlignRight clThNonGras">
          Contestation de
          créance&#160;&#160;&#160;
        </th>
        <td class="clCouleur2 clWidth105 clAlignRight clValignTop">&#160;</td>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth110 clAlignRight clThNonGras">Mois&#160;</th>
        <th class="clCouleur2 clWidth105 clAlignRight clHeight17 clThNonGras">Nombre&#160;</th>
        <th class="clCouleur2 clWidth105 clAlignRight clHeight17 clThNonGras">Montant&#160;</th>
        <th class="clCouleur2 clWidth105 clAlignRight clHeight17 clThNonGras">Nombre&#160;</th>
        <th class="clCouleur2 clWidth105 clAlignRight clHeight17 clThNonGras">Montant&#160;</th>
        <th class="clCouleur2 clWidth105 clAlignRight clThNonGras">Total&#160;</th>
      </tr>
      <xsl:apply-templates select="SITRESM"/>
      <xsl:apply-templates select="SITREST"/>
    </table>
    <div class="clBreakPage"/>
  </xsl:template>

  <xsl:template match="SITRESM">
   <tr class="clAlignRight">
      <xsl:if test="position() mod 2 = 0">
        <td class="clTexte clWidth110">
          <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="(MOISREF)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clTexte clWidth105">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(NBIP)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clTexte clWidth105">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(MTIP)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clTexte clWidth105">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(NBCC)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clTexte clWidth105">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(MTCC)"/>
          </xsl:call-template>&#160;
        </td>
       <td class="clTexteGras clWidth105">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(MTMIPE)"/>
          </xsl:call-template>&#160;
        </td>
      </xsl:if>
      <xsl:if test="position() mod 2 != 0">
        <td class="clFond clWidth110">
          <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="(MOISREF)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth105">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(NBIP)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth105">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(MTIP)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth105">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(NBCC)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth105">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(MTCC)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clGrasFond clWidth105">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(MTMIPE)"/>
          </xsl:call-template>&#160;
        </td>
      </xsl:if>
    </tr>
  </xsl:template>

  <xsl:template match="SITREST">
   <tr class="clAlignRight">
      <td class="clTexte clWidth110">&#160;</td>
      <td class="clTexte clWidth105">&#160;</td>
      <td class="clTexte clWidth105">&#160;</td>
      <td class="clTexte clWidth105">&#160;</td>
      <td class="clTexte clWidth105">&#160;</td>
      <td class="t3b clWidth105">&#160;</td>
    </tr>
   <tr class="clAlignRight">
      <td class="clCouleur2 clWidth110">Total&#160;</td>
      <td class="clGrasFond clWidth105">
        <xsl:call-template name ="displayNumberXsl">
          <xsl:with-param name ="InputStringNumber" select ="(TOTNBIP)"/>
        </xsl:call-template>&#160;
      </td>
      <td class="clGrasFond clWidth105">
        <xsl:call-template name ="displayNumberXsl">
          <xsl:with-param name ="InputStringNumber" select ="(TOTMTIP)"/>
        </xsl:call-template>&#160;
      </td>
      <td class="clGrasFond clWidth105">
        <xsl:call-template name ="displayNumberXsl">
          <xsl:with-param name ="InputStringNumber" select ="(TOTNBCC)"/>
        </xsl:call-template>&#160;
      </td>
      <td class="clGrasFond clWidth105">
        <xsl:call-template name ="displayNumberXsl">
          <xsl:with-param name ="InputStringNumber" select ="(TOTMTCC)"/>
        </xsl:call-template>&#160;
      </td>
      <td class="clGrasFond clWidth105">
        <xsl:call-template name ="displayNumberXsl">
          <xsl:with-param name ="InputStringNumber" select ="(TOTSEIPE)"/>
        </xsl:call-template>&#160;
      </td>
    </tr>
  </xsl:template>

  <xsl:template match="CIP03" mode="genDiv">
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr class="clAlignLeft">
        <td class="clCouleur2">
          <xsl:apply-templates select="."/>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
  </xsl:template>

  <xsl:template match="IPEDETAIL">
    <table class="clWidth739 clBorderCell">
      <caption class="visually-hidden">Détail des incidents de paiement effets supérieurs ou égaux à1524 euros</caption>
      <xsl:if test="position() > 1">
        <xsl:call-template name="StrSplit">
          <xsl:with-param name="str" select="$sIPEbrkPage"/>
          <xsl:with-param name="moisRefCourant" select="IPEMENS/MOISREF"/>
        </xsl:call-template>
      </xsl:if>

      <xsl:apply-templates select="IPEMENS"/>
      <tr>
        <th class="clCouleur2 clWidth51 clAlignRight clValignBottom clThNonGras">Banque&#160;</th>
        <th class="clCouleur2 clWidth46 clAlignRight clValignBottom clThNonGras">Guichet&#160;</th>
        <th class="clCouleur2 clWidth67 clAlignRight clValignBottom clThNonGras">Échéance&#160;</th>
        <th class="clCouleur2 clWidth43 clAlignRight clThNonGras">
          <p>
            Code<br/>Accept.
          </p>
        </th>
       <td class="clCouleur2 clWidth7 clAlignRight">&#160;</td>
        <th class="clCouleur2 clWidth49 clAlignRight clThNonGras">
          &#160;MdNP<br/>(1)
        </th>
        <th class="clCouleur2 clWidth68 clAlignRight clValignBottom clThNonGras">&#160;Montant</th>
        <th class="clCouleur2 clWidth96 clAlignRight clValignBottom clThNonGras">Identifiant</th>
        <th class="clCouleur2 clWidth208 clAlignRight clValignBottom clThNonGras">&#160;Nom du créancier</th>
        <xsl:if test="position() mod 2 = 0">
          <xsl:call-template name="genFlecheHaut"/>
        </xsl:if>
        <xsl:if test="position() mod 2 != 0">
         <td class="clWidth103"></td>
        </xsl:if>
      </tr>
      <xsl:apply-templates select="IPEDET"/>
      <xsl:if test="position() = last()">
        <tr>
          <td colspan="9" class="clCouleur2 clValignMiddle">
            <br/> (1) MdNP : Motif de non paiement
          </td>
        </tr>
      </xsl:if>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
  </xsl:template>

  <xsl:template match="IPEMENS">
    <tr>
      <th class="clCouleur2 clThNonGras clAlignLeft" colspan="2">&#160;Mois de rejet</th>
     <td class="clGrasFond clWidth67">
        &#160;<xsl:call-template name ="displayDateXsl">
          <xsl:with-param name ="InputDate" select ="(MOISREF)"/>
        </xsl:call-template>
      </td>
      <td class="clCouleur2 clWidth43 clAlignRight">&#160;</td>
     <td class="clCouleur2 clWidth7 clAlignRight">&#160;</td>
      <th class="clCouleur2 clWidth46 clThNonGras clAlignRight">&#160;Montant</th>
      <td class="clGrasFond clWidth68 clAlignRight">
        <xsl:call-template name ="displayNumberXsl">
          <xsl:with-param name ="InputStringNumber" select ="(MT1500E)"/>
        </xsl:call-template>
        <xsl:call-template name ="displayUnitXsl2">
          <xsl:with-param name ="InputUnit" select ="(./@UNITE)"/>
          <xsl:with-param name ="Indic" select ='"1"'/>
        </xsl:call-template>
        &#160;<img src="{$root}images/Commun/euro_symb_noir.png" width="8" height="9"/>&#160;
      </td>
      <td class="clTexte clWidth96 clAlignRight clHeight10"></td>
    </tr>
    <tr>
      <td class="clCouleur2 clWidth51 clHeight10"></td>
      <td class="clTexte clAlignCenter clWidth46 clHeight10"></td>
      <td class="clTexte clWidth67 clHeight10"></td>
     <td class="clCouleur2 clWidth7 clAlignRight clHeight10"></td>
      <td class="clCouleur2 clWidth7 clAlignRight clHeight10"></td>
      <td class="clCouleur2 clWidth49 clHeight10"></td>
      <td class="clTexte clWidth68 clAlignRight clHeight10"></td>
      <td class="clTexte clWidth96 clAlignRight clHeight10"></td>
    </tr>
  </xsl:template>

  <xsl:template match="IPEDET">
    <xsl:variable name="COACCEP">
      <xsl:call-template name="traduction">
        <xsl:with-param name="code" select="COACCEP"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="COMOTIF">
      <xsl:call-template name="traduction">
        <xsl:with-param name="code" select="COMOTIF"/>
      </xsl:call-template>
    </xsl:variable>
    <!--pour remplacer bdf:escapestring-->
    <xsl:variable name="valCOACCEP" select="COACCEP"/>
    <xsl:variable name="valCOMOTIF" select="COMOTIF"/>
    <xsl:choose>
      <xsl:when test="position() = 55">
        <xsl:text disable-output-escaping="yes">&lt;tr class="clBreakPage"&gt;</xsl:text>
      </xsl:when>
      <xsl:when test="position() > 67 and (position()+5) mod 60=0">
        <xsl:text disable-output-escaping="yes">&lt;tr class="clBreakPage"&gt;</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text disable-output-escaping="yes">&lt;tr&gt;</xsl:text>
      </xsl:otherwise>
    </xsl:choose>

    <xsl:if test="position() mod 2 != 0">
      <td class="clFond clAlignRight clWidth51">
        <xsl:value-of select="COBAN"/>&#160;
      </td>
      <td class="clFond clAlignRight clWidth46">
        <xsl:value-of select="COGUI"/>&#160;
      </td>
     <td class="clFond clAlignRight clWidth67">
        <xsl:call-template name ="displayDateXsl">
          <xsl:with-param name ="InputDate" select ="(DATECHIPE)"/>
        </xsl:call-template>&#160;
      </td>
      <td class="clFond clAlignRight clWidth43">
        <a href="#nullePart" onclick="requestInfosLibelle('{$valCOACCEP}',cstWordingCodeAcceptMotif)" class="clTexte">
          <u>
            <xsl:value-of select="COACCEP"/>
          </u>
        </a>&#160;
      </td>
     <td class="clFond clWidth7 clAlignRight">&#160;</td>
      <td class="clFond clAlignRight clWidth49">
        <a href="#nullePart" onclick="requestInfosLibelle('{$valCOMOTIF}',cstWordingCodeAcceptMotif)" class="clTexte">
          <u>
            <xsl:value-of select="COMOTIF"/>
          </u>
        </a>
      </td>
     <td class="clFond clAlignRight clWidth68">
        &#160;
        <xsl:call-template name ="displayNumberXsl">
          <xsl:with-param name ="InputStringNumber" select ="(MTUNIT)"/>
        </xsl:call-template>
      </td>
      <td class="clFond clAlignRight clValignBottom clWidth96">
        &#160;
        <xsl:if test="string-length(IDENTCR) != 0">
          <xsl:call-template name ="displaySirenXsl">
            <xsl:with-param name ="InputSiren" select ="(IDENTCR)"/>
          </xsl:call-template>
        </xsl:if>
      </td>
     <td class="clFond clAlignRight clWidth208">
        &#160;<xsl:value-of select="CREAN"/>&#160;
      </td>
    </xsl:if>
    <xsl:if test="position() mod 2 = 0">
      <td class="clTexte clAlignRight clWidth51">
        <xsl:value-of select="COBAN"/>&#160;
      </td>
     <td class="clTexte clAlignRight clWidth46">
        <xsl:value-of select="COGUI"/>&#160;
      </td>
     <td class="clTexte clAlignRight clWidth67">
        <xsl:call-template name ="displayDateXsl">
          <xsl:with-param name ="InputDate" select ="(DATECHIPE)"/>
        </xsl:call-template>&#160;
      </td>
      <td class="clTexte clWidth43 clAlignRight">
        <a href="#nullePart" onclick="requestInfosLibelle('{$valCOACCEP}',cstWordingCodeAcceptMotif)" class="clTexte">
          <u>
            <xsl:value-of select="COACCEP"/>
          </u>
        </a>&#160;
      </td>
      <td class="clTexte clWidth7 clAlignRight">&#160;</td>
      <td class="clTexte clWidth49 clAlignRight">
        <a href="#nullePart" onclick="requestInfosLibelle('{$valCOMOTIF}',cstWordingCodeAcceptMotif)" class="clTexte">
          <u>
            <xsl:value-of select="COMOTIF"/>
          </u>
        </a>
      </td>
      <td class="clTexte clWidth68 clAlignRight">
        &#160;
        <xsl:call-template name ="displayNumberXsl">
          <xsl:with-param name ="InputStringNumber" select ="(MTUNIT)"/>
        </xsl:call-template>
      </td>
      <td class="clTexte clAlignRight clValignBottom clWidth96">
        &#160;
        <xsl:if test="string-length(IDENTCR) != 0">
          <xsl:call-template name ="displaySirenXsl">
            <xsl:with-param name ="InputSiren" select ="(IDENTCR)"/>
          </xsl:call-template>
        </xsl:if>
      </td>
     <td class="clTexte clAlignRight clWidth208">
        &#160;<xsl:value-of select="CREAN"/>&#160;
      </td>
    </xsl:if>
    <xsl:if test="position() mod 10 = 0">
      <xsl:call-template name="genFlecheHaut"/>
    </xsl:if>
    <xsl:if test="position() mod 10 != 0">
     <td class="clWidth103"></td>
    </xsl:if>
    <xsl:text disable-output-escaping="yes">&lt;/tr&gt;</xsl:text>

    <xsl:choose>
      <xsl:when test="IDENTCR != ''">
        <tr>
         <td class="clAlignRight" colspan="9">
            <a href="#nullepart" onClick="requestBDFInfos('27','','','{IDENTCR}',cstSimpleConfirm,false,this);">
              <img border="0" height="12" src="{$root}images/Commun/clignotant2.gif" width="90" alt="plus d'infos"/>
            </a>
          </td>
        </tr>
      </xsl:when>
      <xsl:when test="CREAN != ''">
        <tr>
         <td class="clAlignRight" colspan="9">
            <a href="#nullepart" onClick="requestBDFInfos('07','','','{CREAN}',cstSimpleConfirm,false,this);">
              <img border="0" height="12" src="{$root}images/Commun/clignotant2.gif" width="90" alt="plus d'infos"/>
            </a>
          </td>
        </tr>
      </xsl:when>
      <xsl:otherwise>
        <tr>
         <td class="clAlignRight" colspan="9">&#160;</td>
        </tr>
      </xsl:otherwise>
    </xsl:choose>
    <!--fin<02/06/2008>-->
  </xsl:template>

  <xsl:template name="StrSplit">
    <xsl:param name="str"/>
    <xsl:param name="moisRefCourant"/>

    <xsl:choose>
      <xsl:when test="contains($str,',')">
        <xsl:if test="$moisRefCourant = substring-before($str,',')">
          <div class="clBreakPage"/>
        </xsl:if>

        <xsl:call-template name="StrSplit">
          <xsl:with-param name="str" select="substring-after($str,',')" />
          <xsl:with-param name="moisRefCourant" select="$moisRefCourant"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:if test="$moisRefCourant = $str">
          <div class="clBreakPage"/>
        </xsl:if>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!--**************************************** PARTIE RELATIONS BANCAIRES ********************************************-->
  <xsl:template match="RBOR">
    <div class="clBreakPage"/>
    <table class="clWidth739 clBorderCell">
      <caption class="visually-hidden">Liste des relations bancaires</caption>
      <tr>
        <td class="clWidth14"></td>
        <td colspan="4" class="clCouleur2 clValignTop">
          <a name="relations_bancairesInd"></a>
          <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEOR/DIFFOR/RBOR/NBRELBAN"/>
          <table class="clWidth739 clBorderCell">
            <tr>
              <td class="clCouleur2 clWidth24 clAlignRight"></td>
              <th class="clCouleur2 clWidth66 clAlignLeft clThNonGras">Banque</th>
              <th class="clCouleur2 clWidth79 clAlignLeft clThNonGras">Guichet</th>
              <th class="clCouleur2 clWidth304 clAlignLeft clThNonGras">Libellé de l'établissement bancaire </th>
             <th class="clCouleur2 clWidth162 clAlignCenter clThNonGras">Date de mise à jour</th>
              <td class="clWidth104"> &#160;</td>
            </tr>
            <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEOR/DIFFOR/RBOR/RELBAN"/>
          </table>
          <xsl:call-template name="shim"/>
        </td>
      </tr>
    </table>
    <br/>
  </xsl:template>

  <xsl:template match="NBRELBAN">
    <table class="clWidth635 clBorderCell" role="presentation">
     <tr class="clAlignCenter">
        <td class="clCouleurGras">
          LISTE DES RELATIONS BANCAIRES (<xsl:value-of select="."/>)
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
  </xsl:template>

  <xsl:template match="RELBAN">
    <xsl:variable name="nbRel">
      <xsl:value-of select="/FIBEN/PERSONNE/MODULEOR/DIFFOR/RBOR/NBRELBAN"/>
    </xsl:variable>
    <xsl:if test="position() mod 2 != 0">
      <tr>
        <td class="clFond clWidth24">&#160;</td>
        <td class="clFond clWidth66">
          <xsl:value-of select="COBAN"/>
        </td>
        <td class="clFond clWidth79">
          <xsl:value-of select="COGUI"/>
        </td>
        <td class="clFond clWidth304">
          <xsl:value-of select="LIBBAN"/>
        </td>
        <td class="clFond clWidth162 clAlignCenter">
          <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="(DATMAJ)"/>
          </xsl:call-template>
        </td>
         <td class="clAlignRight">&#160;</td>
      </tr>
    </xsl:if>
    <xsl:if test="position() mod 2 = 0">
      <tr>
        <td class="clTexte clWidth24 clAlignRight"></td>
        <td class="clTexte clWidth66">
          <xsl:value-of select="COBAN"/>
        </td>
        <td class="clTexte clWidth79">
          <xsl:value-of select="COGUI"/>
        </td>
        <td class="clTexte clWidth304">
          <xsl:value-of select="LIBBAN"/>
        </td>
        <td class="clTexte clWidth162 clAlignCenter">
          <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="(DATMAJ)"/>
          </xsl:call-template>
        </td>
      </tr>
    </xsl:if>

    <xsl:if test="position() = last ()">
      <div class="clBreakPage"></div>
      <xsl:if test="//RBOR/SUITERB">
        <tr>
          <td colspan="6" class="clAlignLeft">
            <xsl:call-template name="shim"/>
            <br/>
          </td>
        </tr>
        <tr>
          <td class="clCouleur2 clWidth530 clHeight10" colspan="4">

            <xsl:value-of select="($dictionnaire/mot[@id='SUITERB'])"></xsl:value-of>
          </td>
          <td class="clWidth105 clHeight1 clAlignRight clValignMiddle">
            <a href="#nullepart" onClick="requestBDFInfos('40','','1','{EJ/IDENTS}',cstSimpleConfirm);">
              <img src="{$root}images/Commun/clignotant2.gif" width="85" height="12" border="0" align="absbottom" alt="plus d'infos"/>
            </a>
          </td>
        </tr>
      </xsl:if>
    </xsl:if>
  </xsl:template>



  <!--**************************************** PARTIE GRAPHIQUES ********************************************-->
  <xsl:template name="genGraphOR">
    <xsl:if test="$condGraph">

      <form action="Graphes.aspx" method="post" name="FormGraphes" target="_blank">
        <input name="familyNumber" type="hidden" value="1"/>
        <input name="moduleNumber" type="hidden" value="{/FIBEN/@MODDEM}"/>
        <xsl:element name="input">
          <xsl:attribute name="name">GrapheData</xsl:attribute>
          <xsl:attribute name="type">hidden</xsl:attribute>

          <xsl:attribute name="value">
            &lt;FIBEN MODDEM=&quot;<xsl:value-of select="FIBEN/@MODDEM"/>&quot; DATJOUR=&quot;<xsl:call-template name ="displayDateForGraph2">
              <xsl:with-param name ="InputDateForGraph" select ="FIBEN/@DATJOUR"/>
            </xsl:call-template> &quot; GRAPHE=&quot;
            <xsl:choose>
              <xsl:when test="FIBEN/PERSONNE/MODULEOR/DIFFOR/ICB01">13</xsl:when>
              <xsl:otherwise>1</xsl:otherwise>
            </xsl:choose>&quot;&gt;&lt;ident&gt;<xsl:value-of select="FIBEN/PERSONNE/MODULEOR/PM/EJ/IDENTS|FIBEN/PERSONNE/MODULEOR/PM/EI/IDENTS|FIBEN/PERSONNE/MODULEOR/PM/EI/IDENTC"/>&lt;/ident&gt;

            <xsl:if test="FIBEN/PERSONNE/MODULEOR/PM/EJ">
              &lt;nom&gt;<xsl:value-of select="FIBEN/PERSONNE/MODULEOR/PM/EJ/DENOM"/>&lt;/nom&gt;
            </xsl:if>
            <xsl:if test="FIBEN/PERSONNE/MODULEOR/PM/EI">
              &lt;nom&gt;<xsl:call-template name ="displayInLowerCaseXsl">
                <xsl:with-param name ="InputStringNom" select ="(FIBEN/PERSONNE/MODULEOR/PM/EI/IDENTITE/NOM)"/>
                <xsl:with-param name ="InputStringPrenom" select ="(FIBEN/PERSONNE/MODULEOR/PM/EI/IDENTITE/PRENOM)"/>
              </xsl:call-template>&lt;/nom&gt;
              &lt;nomconj&gt;<xsl:value-of select="FIBEN/PERSONNE/MODULEOR/PM/EI/IDENTITE/NOMCONJ"/>&lt;/nomconj&gt;
              <xsl:if test="FIBEN/PERSONNE/MODULEOR/PM/EI/IDENTC">
                &lt;idrenv&gt;<xsl:value-of select="FIBEN/PERSONNE/MODULEOR/PM/EI/IDRENV"/>&lt;/idrenv&gt;
              </xsl:if>
            </xsl:if>
            <xsl:if test="FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/CUMULCB" >
              &lt;graphe&gt;
              <xsl:if test="$condGraph1">
                &lt;serie&gt;
                <xsl:for-each select="FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/CUMULCB">
                  &lt;val&gt;<xsl:value-of select="MTCODCCT"/>&lt;/val&gt;
                </xsl:for-each>
                &lt;/serie&gt;
                &lt;serie&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/CUMULCB">
                  &lt;val&gt;<xsl:value-of select="MTCCCT"/>&lt;/val&gt;
                </xsl:for-each>&lt;/serie&gt;
                &lt;serie&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/CUMULCB">
                  &lt;val&gt;<xsl:value-of select="MTAFCT"/>&lt;/val&gt;
                </xsl:for-each>
                &lt;/serie&gt;
                &lt;serie&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/CUMULCB">
                  &lt;val&gt;<xsl:value-of select="MTACCT"/>&lt;/val&gt;
                </xsl:for-each>&lt;/serie&gt;
                &lt;abcisse&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/CUMULCB/@MOISREF">
                  &lt;val&gt;<xsl:call-template name ="displayDateXsl">
                    <xsl:with-param name ="InputDate" select ="(.)"/>
                  </xsl:call-template>&lt;/val&gt;
                </xsl:for-each>&lt;/abcisse&gt;
              </xsl:if>
              &lt;titre&gt;Concours bancaires individuels à court terme&lt;/titre&gt;&lt;signet&gt;Court terme individuel &lt;/signet&gt;&lt;/graphe&gt;
              &lt;graphe&gt;
              <xsl:if test="$condGraph2">
                &lt;serie&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/CUMULCB">
                  &lt;val&gt;<xsl:value-of select="MTCMLT"/>&lt;/val&gt;
                </xsl:for-each>&lt;/serie&gt;
                &lt;abcisse&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/CUMULCB/@MOISREF">
                  &lt;val&gt;<xsl:call-template name ="displayDateXsl">
                    <xsl:with-param name ="InputDate" select ="(.)"/>
                  </xsl:call-template>&lt;/val&gt;
                </xsl:for-each>&lt;/abcisse&gt;
              </xsl:if>
              &lt;titre&gt;Concours bancaires individuels à moyen et long terme&lt;/titre&gt;&lt;signet&gt;Moyen et long terme individuel&lt;/signet&gt;&lt;/graphe&gt;
              &lt;graphe&gt;
              <xsl:if test="$condGraph3">
                &lt;serie&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/CUMULCB">
                  &lt;val&gt;<xsl:value-of select="MTCBI"/>&lt;/val&gt;
                </xsl:for-each>&lt;/serie&gt;
                &lt;serie&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/CUMULCB">
                  &lt;val&gt;<xsl:value-of select="MTCBM"/>&lt;/val&gt;
                </xsl:for-each>&lt;/serie&gt;
                &lt;abcisse&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/CUMULCB/@MOISREF">
                  &lt;val&gt;<xsl:call-template name ="displayDateXsl">
                    <xsl:with-param name ="InputDate" select ="(.)"/>
                  </xsl:call-template>&lt;/val&gt;
                </xsl:for-each>&lt;/abcisse&gt;
              </xsl:if>
              &lt;titre&gt;Concours bancaires individuels : Crédits-bails&lt;/titre&gt;&lt;signet&gt;Crédits-bails individuels&lt;/signet&gt;&lt;/graphe&gt;
              &lt;graphe&gt;
              <xsl:if test="$condGraph4">
                &lt;serie&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/CUMULCB">
                  &lt;val&gt;<xsl:value-of select="MTCBCT"/>&lt;/val&gt;
                </xsl:for-each>&lt;/serie&gt;
                &lt;serie&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/CUMULCB">
                  &lt;val&gt;<xsl:value-of select="MTCMLT"/>&lt;/val&gt;
                </xsl:for-each>&lt;/serie&gt;
                &lt;serie&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/CUMULCB">
                  &lt;val&gt;<xsl:call-template name="doubleFlux">
                    <xsl:with-param name = "fMTCBM" >
                      <xsl:value-of select="MTCBM"/>
                    </xsl:with-param>
                    <xsl:with-param name = "fMTCBI" >
                      <xsl:value-of select="MTCBI"/>
                    </xsl:with-param>
                  </xsl:call-template>&lt;/val&gt;
                </xsl:for-each>&lt;/serie&gt;
                &lt;serie&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/CUMULCB">
                  &lt;val&gt;<xsl:value-of select="MTTITR"/>&lt;/val&gt;
                </xsl:for-each>&lt;/serie&gt;
                &lt;abcisse&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/CUMULCB/@MOISREF">
                  &lt;val&gt;<xsl:call-template name ="displayDateXsl">
                    <xsl:with-param name ="InputDate" select ="(.)"/>
                  </xsl:call-template>&lt;/val&gt;
                </xsl:for-each>&lt;/abcisse&gt;
              </xsl:if>
              &lt;titre&gt;Concours bancaires individuels : Crédits mobilisés(Total VI)&lt;/titre&gt;&lt;signet&gt;Total VI individuel&lt;/signet&gt;&lt;/graphe&gt;
              &lt;graphe&gt;
              <xsl:if test="$condGraph5">
                &lt;serie&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/CUMULCB">
                  &lt;val&gt;<xsl:value-of select="MTCC"/>&lt;/val&gt;
                </xsl:for-each>&lt;/serie&gt;
                &lt;serie&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/CUMULCB">
                  &lt;val&gt;<xsl:value-of select="MTCD"/>&lt;/val&gt;
                </xsl:for-each>&lt;/serie&gt;
                &lt;abcisse&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/CUMULCB/@MOISREF">
                  &lt;val&gt;<xsl:call-template name ="displayDateXsl">
                    <xsl:with-param name ="InputDate" select ="(.)"/>
                  </xsl:call-template>&lt;/val&gt;
                </xsl:for-each>&lt;/abcisse&gt;
              </xsl:if>
              &lt;titre&gt;Concours bancaires individuels : Crédits mobilisables(Total VII)&lt;/titre&gt;&lt;signet&gt;Crédits mobilisables individuels&lt;/signet&gt;&lt;/graphe&gt;
              &lt;graphe&gt;
              <xsl:if test="$condGraph6">
                &lt;serie&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/CUMULCB">
                  &lt;val&gt;<xsl:value-of select="MTAC"/>&lt;/val&gt;
                </xsl:for-each>&lt;/serie&gt;
                &lt;abcisse&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/CUMULCB/@MOISREF">
                  &lt;val&gt;<xsl:call-template name ="displayDateXsl">
                    <xsl:with-param name ="InputDate" select ="(.)"/>
                  </xsl:call-template>&lt;/val&gt;
                </xsl:for-each>&lt;/abcisse&gt;
              </xsl:if>
              &lt;titre&gt;Concours bancaires individuels : Engagements de garantie&lt;/titre&gt;&lt;signet&gt;Engagements de garantie individuels&lt;/signet&gt;&lt;/graphe&gt;
            </xsl:if>
            <xsl:if test="FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/CUMULCBC">
              &lt;graphe&gt;
              <xsl:if test="$condGraph7">
                &lt;serie&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/CUMULCBC">
                  &lt;val&gt;<xsl:value-of select="MTCODCCT"/>&lt;/val&gt;
                </xsl:for-each>
                &lt;/serie&gt;
                &lt;serie&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/CUMULCBC">
                  &lt;val&gt;<xsl:value-of select="MTCCCT"/>&lt;/val&gt;
                </xsl:for-each>&lt;/serie&gt;
                &lt;serie&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/CUMULCBC">
                  &lt;val&gt;<xsl:value-of select="MTAFCT"/>&lt;/val&gt;
                </xsl:for-each>
                &lt;/serie&gt;
                &lt;serie&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/CUMULCBC">
                  &lt;val&gt;<xsl:value-of select="MTACCT"/>&lt;/val&gt;
                </xsl:for-each>&lt;/serie&gt;
                &lt;abcisse&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/CUMULCBC/@MOISREF">
                  &lt;val&gt;<xsl:call-template name ="displayDateXsl">
                    <xsl:with-param name ="InputDate" select ="(.)"/>
                  </xsl:call-template>&lt;/val&gt;
                </xsl:for-each>&lt;/abcisse&gt;
              </xsl:if>
              &lt;titre&gt;Participations en compte collectif : Crédits à court terme&lt;/titre&gt;&lt;signet&gt;Court terme collectif&lt;/signet&gt;&lt;/graphe&gt;
              &lt;graphe&gt;
              <xsl:if test="$condGraph8">
                &lt;serie&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/CUMULCBC">
                  &lt;val&gt;<xsl:value-of select="MTCMLT"/>&lt;/val&gt;
                </xsl:for-each>&lt;/serie&gt;
                &lt;abcisse&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/CUMULCBC/@MOISREF">
                  &lt;val&gt;<xsl:call-template name ="displayDateXsl">
                    <xsl:with-param name ="InputDate" select ="(.)"/>
                  </xsl:call-template>&lt;/val&gt;
                </xsl:for-each>&lt;/abcisse&gt;
              </xsl:if>
              &lt;titre&gt;Participations en compte collectif : Crédits à moyen et long terme&lt;/titre&gt;&lt;signet&gt;Moyen et long terme collectif&lt;/signet&gt;&lt;/graphe&gt;
              &lt;graphe&gt;
              <xsl:if test="$condGraph9">
                &lt;serie&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/CUMULCBC">
                  &lt;val&gt;<xsl:value-of select="MTCBI"/>&lt;/val&gt;
                </xsl:for-each>&lt;/serie&gt;
                &lt;serie&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/CUMULCBC">
                  &lt;val&gt;<xsl:value-of select="MTCBM"/>&lt;/val&gt;
                </xsl:for-each>&lt;/serie&gt;
                &lt;abcisse&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/CUMULCBC/@MOISREF">
                  &lt;val&gt;<xsl:call-template name ="displayDateXsl">
                    <xsl:with-param name ="InputDate" select ="(.)"/>
                  </xsl:call-template>&lt;/val&gt;
                </xsl:for-each>&lt;/abcisse&gt;
              </xsl:if>
              &lt;titre&gt;Participations en compte collectif : Crédits-bails&lt;/titre&gt;&lt;signet&gt;Crédits-bails collectifs&lt;/signet&gt;&lt;/graphe&gt;
              &lt;graphe&gt;
              <xsl:if test="$condGraph10">
                &lt;serie&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/CUMULCBC">
                  &lt;val&gt;<xsl:value-of select="MTCBCT"/>&lt;/val&gt;
                </xsl:for-each>&lt;/serie&gt;
                &lt;serie&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/CUMULCBC">
                  &lt;val&gt;<xsl:value-of select="MTCMLT"/>&lt;/val&gt;
                </xsl:for-each>&lt;/serie&gt;
                &lt;serie&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/CUMULCBC">
                  &lt;val&gt;<xsl:call-template name="doubleFlux">
                    <xsl:with-param name = "fMTCBM" >
                      <xsl:value-of select="MTCBM"/>
                    </xsl:with-param>
                    <xsl:with-param name = "fMTCBI" >
                      <xsl:value-of select="MTCBI"/>
                    </xsl:with-param>
                  </xsl:call-template>&lt;/val&gt;
                </xsl:for-each>&lt;/serie&gt;
                &lt;serie&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/CUMULCBC">
                  &lt;val&gt;<xsl:value-of select="MTTITR"/>&lt;/val&gt;
                </xsl:for-each>&lt;/serie&gt;
                &lt;abcisse&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/CUMULCBC/@MOISREF">
                  &lt;val&gt;<xsl:call-template name ="displayDateXsl">
                    <xsl:with-param name ="InputDate" select ="(.)"/>
                  </xsl:call-template>&lt;/val&gt;
                </xsl:for-each>&lt;/abcisse&gt;
              </xsl:if>
              &lt;titre&gt;Participations en compte collectif : Crédits mobilisés(Total VI)&lt;/titre&gt;&lt;signet&gt;Total VI collectif&lt;/signet&gt;&lt;/graphe&gt;
              &lt;graphe&gt;
              <xsl:if test="$condGraph11">
                &lt;serie&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/CUMULCBC">
                  &lt;val&gt;<xsl:value-of select="MTCC"/>&lt;/val&gt;
                </xsl:for-each>&lt;/serie&gt;
                &lt;serie&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/CUMULCBC">
                  &lt;val&gt;<xsl:value-of select="MTCD"/>&lt;/val&gt;
                </xsl:for-each>&lt;/serie&gt;
                &lt;abcisse&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/CUMULCBC/@MOISREF">
                  &lt;val&gt;<xsl:call-template name ="displayDateXsl">
                    <xsl:with-param name ="InputDate" select ="(.)"/>
                  </xsl:call-template>&lt;/val&gt;
                </xsl:for-each>&lt;/abcisse&gt;
              </xsl:if>
              &lt;titre&gt;Participations en compte collectif : Crédits mobilisables(Total VII)&lt;/titre&gt;&lt;signet&gt;Crédits mobilisables collectifs&lt;/signet&gt;&lt;/graphe&gt;
              &lt;graphe&gt;
              <xsl:if test="$condGraph12">
                &lt;serie&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/CUMULCBC">
                  &lt;val&gt;<xsl:value-of select="MTAC"/>&lt;/val&gt;
                </xsl:for-each>&lt;/serie&gt;
                &lt;abcisse&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULEOR/DIFFOR/RISQUESOR/CUMULCBC/@MOISREF">
                  &lt;val&gt;<xsl:call-template name ="displayDateXsl">
                    <xsl:with-param name ="InputDate" select ="(.)"/>
                  </xsl:call-template>&lt;/val&gt;
                </xsl:for-each>&lt;/abcisse&gt;
              </xsl:if>
              &lt;titre&gt;Participations en compte collectif : Engagements de garantie&lt;/titre&gt;&lt;signet&gt;Engagements de garantie collectifs&lt;/signet&gt;&lt;/graphe&gt;
            </xsl:if>
            <!-- ***************** Graphiques liés aux incidents de paiements ******************************************** -->
            <xsl:if test="FIBEN/PERSONNE/MODULEOR/DIFFOR/IPEOR/IPERESUME">
              &lt;graphe&gt;
              <xsl:if test="$condGraph13">
                &lt;serie&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULEOR/DIFFOR/IPEOR/IPERESUME/SITRESM">
                  &lt;val&gt;<xsl:value-of select="MTIP"/>&lt;/val&gt;
                </xsl:for-each>
                &lt;/serie&gt;&lt;serie&gt;
                <xsl:for-each select="FIBEN/PERSONNE/MODULEOR/DIFFOR/IPEOR/IPERESUME/SITRESM">
                  &lt;val&gt;<xsl:value-of select="MTIP"/>&lt;/val&gt;
                </xsl:for-each>&lt;/serie&gt;&lt;serie&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULEOR/DIFFOR/IPEOR/IPERESUME/SITRESM">
                  &lt;val&gt;<xsl:value-of select="MTCC"/>&lt;/val&gt;
                </xsl:for-each>&lt;/serie&gt;&lt;abcisse&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULEOR/DIFFOR/IPEOR/IPERESUME/SITRESM">
                  &lt;val&gt;<xsl:call-template name ="displayDateXsl">
                    <xsl:with-param name ="InputDate" select ="(MOISREF)"/>
                  </xsl:call-template>&lt;/val&gt;
                </xsl:for-each>&lt;/abcisse&gt;&lt;titre&gt;Incidents de paiement effets au cours des 15 derniers mois (en
                <xsl:call-template name ="displayUnitXsl">
                  <xsl:with-param name ="InputUnit" select ="(FIBEN/PERSONNE/MODULEOR/DIFFOR/IPEOR/IPERESUME/@UNITE)"/>
                </xsl:call-template>
                euros)&lt;/titre&gt;&lt;signet&gt;Situation résumée&lt;/signet&gt;&lt;unite&gt;<xsl:value-of select="FIBEN/PERSONNE/MODULEOR/DIFFOR/IPEOR/IPERESUME/@UNITE"/>&lt;/unite&gt;
              </xsl:if>
              &lt;/graphe&gt;
            </xsl:if>
            &lt;/FIBEN&gt;
          </xsl:attribute>
        </xsl:element>
      </form>
    </xsl:if>
  </xsl:template>

  <xsl:template match="text()"/>

</xsl:stylesheet>
