<?xml version="1.0" encoding="iso-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:bdf="http://banque-france.fr/namespace">
  <xsl:import href="../../Ressources/XSL/Commun.xsl"/>
  <xsl:import href="../../Ressources/XSL/commun_transfo.xsl"/>
  <xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes"/>
  <xsl:param name="langage" select="'fr'"/>
  <xsl:param name="familyNumber" select="''"/>
  <xsl:param name="root" select="'/Fiben/'"/>
  <xsl:param name="familyName" select="''"/>
  <xsl:param name="familyTitle" select="''"/>
  <xsl:param name="nextModule" select="''"/>
  <xsl:param name="nextId" select="''"/>
  <xsl:param name="nextFamily" select="''"/>
  <xsl:param name="Lang" select="'FR'"/>
  <xsl:param name="NonResident" select="''"/>
  <xsl:param name="menuHTML1"/>
  <xsl:variable name="condGraph1" select="//NBASSOCOD>1"/>

  <xsl:template match="/">
    <html lang="fr">
       <title>Module OD - Offre Dirigeants</title>
      <xsl:call-template name="genHead">
        <xsl:with-param name="ident" select="/FIBEN/ERREUR/IDENT | /FIBEN/PERSONNE/MODULEOD/EJ/IDENTS|/FIBEN/ERREUR/IDENTS|FIBEN/ERREUR/IDENTC"/>
      </xsl:call-template>
      <body class="clBodybgcolorWhite">
        <xsl:call-template name="genFondMenu">
          <xsl:with-param name="root" select="$root"/>
        </xsl:call-template>
        <xsl:copy-of select="$menuHTML1"/>

        <table class="maincontainer horizontal-auto clBorderCell">
          <caption class="visually-hidden">Module OD - Offre Dirigeants</caption>
          <xsl:call-template name="genLigneConfidentiel" />
          <xsl:apply-templates select="/FIBEN/ERREUR"/>

          <xsl:if test="not(/FIBEN/ERREUR)">
            
            <tr>
               <td class="clWidth64"></td>
              <td class="clCouleur2 clValignTop clWidth739" colspan="4">


                <!-- appel du template avec parametre segment pas-->
                <xsl:choose >
                  <xsl:when test="/FIBEN/PERSONNE/MODULEOD/DIFFOD/SEGMENT">
                    <xsl:call-template name="genEnTete">
                      <xsl:with-param name="ident" select="/FIBEN/PERSONNE/MODULEOD/EJ/IDENTS"/>
                      <xsl:with-param name="nom" select="/FIBEN/PERSONNE/MODULEOD/EJ/DENOM"/>
                      <xsl:with-param name="valcot" select="/FIBEN/PERSONNE/MODULEOD/DIFFOD/VALCOT"/>
                      <xsl:with-param name="segment" select="/FIBEN/PERSONNE/MODULEOD/DIFFOD/SEGMENT"/>
                    </xsl:call-template>
                  </xsl:when>
                  <xsl:otherwise >
                    <xsl:call-template name="genEnTete">
                      <xsl:with-param name="ident" select="/FIBEN/PERSONNE/MODULEOD/EJ/IDENTS"/>
                      <xsl:with-param name="nom" select="/FIBEN/PERSONNE/MODULEOD/EJ/DENOM"/>
                      <xsl:with-param name="valcot" select="/FIBEN/PERSONNE/MODULEOD/DIFFOD/VALCOT"/>
                    </xsl:call-template>
                  </xsl:otherwise>
                </xsl:choose>

                <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEOD/DIFFOD"/>
                <!-- ***********************  Partie DIRIGEANTS  ****************************** -->
                <xsl:choose>
                  <xsl:when test ="/FIBEN/PERSONNE/MODULEOD/DIFFOD/IST11">
                    <!-- pas de dirigeants-->
                    <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEOD/DIFFOD/IST11"/>
                  </xsl:when>
                  <xsl:otherwise >
                    <!--affichage des dirigeants -->
                    <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEOD/DIFFOD/DIRIGODS"/>
                  </xsl:otherwise>
                </xsl:choose>
                <!-- ***********************  Partie Fonction de Direction du Reprsentant Lgal  ****************************** -->
                <xsl:choose>
                  <xsl:when test ="/FIBEN/PERSONNE/MODULEOD/DIFFOD/ISTOD2">
                    <!-- Absence de personne physique reprsentant lgal actif. Aucune information disponible sur ses fonctions de direction dtenues -->
                    <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEOD/DIFFOD/ISTOD2"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:choose>
                      <xsl:when test ="/FIBEN/PERSONNE/MODULEOD/DIFFOD/REPLEGODS">
                        <!--presence de fonction de direction du representant legal -->
                        <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEOD/DIFFOD/REPLEGODS"/>
                      </xsl:when>
                      <xsl:otherwise>
                        <!-- si pas de fonction de direction exerc par le representant legal : affichage ISTOD1 qui se trouve dans DIRIGODS -->
                        <xsl:call-template name ="ISTOD1">
                          <xsl:with-param name ="position" select ="1"></xsl:with-param>
                          <xsl:with-param name ="Max" select ="/FIBEN/PERSONNE/MODULEOD/DIFFOD/DIRIGODS/DIRIGOD/NBDIRIGEANTOD"></xsl:with-param>
                        </xsl:call-template>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:otherwise>
                </xsl:choose>
                <!-- ***********************  Partie ASSOCIE  ****************************** -->
                <xsl:choose>
                  <xsl:when test ="/FIBEN/PERSONNE/MODULEOD/DIFFOD/OD08">
                    <!-- pas d'associes-->
                    <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEOD/DIFFOD/OD08"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <!-- Affichage de l apartie associes -->
                    <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEOD/DIFFOD/ASSOCOD"/>
                  </xsl:otherwise>
                </xsl:choose>
                <!-- ***********************  Partie PARTICIPATION  ****************************** -->
                <xsl:choose>
                  <xsl:when test ="/FIBEN/PERSONNE/MODULEOD/DIFFOD/OD09">
                    <!-- pas de participations-->
                    <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEOD/DIFFOD/OD09"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <!-- Affichage de la partie participations -->
                    <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEOD/DIFFOD/PARTOD"/>
                  </xsl:otherwise>
                </xsl:choose>


              </td>
            </tr>

            <xsl:if test="/FIBEN/PERSONNE/MODULEOD/IEC01|/FIBEN/PERSONNE/MODULEOD/IST10|/FIBEN/PERSONNE/MODULEOD/U101">
              <tr>
                <td class="clWidth14"></td>
                <td colspan="3" class="clCouleur2 clValignTop clWidth635">
                  <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEOD/IEC01|/FIBEN/PERSONNE/MODULEOD/IST10|/FIBEN/PERSONNE/MODULEOD/U101"/>
                </td>
                <td></td>
              </tr>
              <tr>
                <td class="clWidth14"></td>
                <td colspan="4">
                  <xsl:call-template name="shim"/>
                </td>
              </tr>

            </xsl:if>
            
           
          </xsl:if>
        </table>
        <xsl:call-template name="genBasPage"/>
        
        <xsl:call-template name="genGraphOD"/>
      </body>
    </html>
  </xsl:template>

  <xsl:template match="IEC01|IST10|U101" mode="genTable">
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
        <td class="clWidth14"></td>
        <td class="clCouleur2 clValignTop">
          <xsl:apply-templates select="."/>
        </td>
      </tr>
      <tr>
        <td class="clWidth14"></td>
        <td>
          <xsl:call-template name="shim"/>
        </td>
      </tr>
    </table>
  </xsl:template>


  <!-- *******************************  PARTIE CAPITAL *********************************************** -->

  <xsl:template match="DIFFOD">
    <table class="clWidth635 clBorderCell">
      <caption class="visually-hidden">Capital</caption>
      <tr>
        <xsl:choose>
          <xsl:when test ="OD01">
            <td class="clCouleur2 clAlignLeft" colspan="4">
              <!--Pas d?information recense concernant le capital de cet identifiant.-->
              <xsl:value-of select="($dictionnaire/mot[@id='OD01'])"></xsl:value-of>
            </td>
          </xsl:when>
          <xsl:otherwise>
           <th class="clCouleur2 clWidth130 clAlignLeft clThNonGras">&#160;Capital</th>
           <td class="clFond clWidth365">
              <xsl:if test="p2051DA/@ETAT">
                &#160;<xsl:value-of select="p2051DA/@ETAT"/>
              </xsl:if>
              <xsl:if test="not(p2051DA/@ETAT)">
                &#160;<xsl:call-template name ="displayNumberXsl">
                  <xsl:with-param name ="InputStringNumber" select ="(p2051DA)"/>
                </xsl:call-template>
                &#160;<img src="{$root}Images/risque/euro_symb_noir.png" width="8" />
              </xsl:if>
            </td>
            <th class="clCouleur2 clWidth45 clAlignRight clThNonGras">au&#160;</th>
            <td class="clFond clWidth95 clAlignRight">
              &#160;&#160;<xsl:call-template name ="displayDateXsl">
                <xsl:with-param name ="InputDate" select ="(DATAG)"/>
              </xsl:call-template>&#160;
            </td>
          </xsl:otherwise>
        </xsl:choose>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
  </xsl:template>

  <!-- *******************************  message IST11 *********************************************** -->
  <xsl:template match="IST11">
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr class="clAlignLeft">
        <td class="clCouleur2">
          <xsl:value-of select="($dictionnaire/mot[@id='IST11'])"></xsl:value-of>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
  </xsl:template>

  <!-- *******************************  message IST16 *********************************************** -->
  <xsl:template match="IST16">
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr class="clAlignLeft">
        <td class="clCouleur2">
          <xsl:value-of select="($dictionnaire/mot[@id='IST16'])"></xsl:value-of>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
  </xsl:template>

  <!-- *******************************  PARTIE DIRIGEANT(S) ******************************************* -->
  <xsl:template match ="DIRIGODS">
    <!-- Dirigeant(s) actif(s) -->
    <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEOD/DIFFOD/DIRIGODS/OD02"/>
    <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEOD/DIFFOD/DIRIGODS/DIRIGOD/NBDIRIGEANTOD"/>
    <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEOD/DIFFOD/DIRIGODS/DIRIGOD/DIRIGEANTOD"/>
    <xsl:if test ="/FIBEN/PERSONNE/MODULEOD/DIFFOD/DIRIGODS/DIRIGOD/SUITEDA">
      <xsl:call-template name ="SuiteDirigActif"></xsl:call-template>
    </xsl:if>

    <!-- Dirigeant(s) cesse(s) -->
    <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEOD/DIFFOD/DIRIGODS/OD03"/>
    <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEOD/DIFFOD/DIRIGODS/DIRIGCESSEOD/NBDIRIGEANTCESSEOD"/>
    <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEOD/DIFFOD/DIRIGODS/DIRIGCESSEOD/DIRIGEANTCESSEOD"/>
    <xsl:if test ="/FIBEN/PERSONNE/MODULEOD/DIFFOD/DIRIGODS/DIRIGCESSEOD/SUITEDC">
      <xsl:call-template name ="SuiteDirigCesse"></xsl:call-template>
    </xsl:if>

  </xsl:template>

  <xsl:template match="NBDIRIGEANTOD">
    <xsl:variable name ="nbDirigeant" select ="count(/FIBEN/PERSONNE/MODULEOD/DIFFOD/DIRIGODS/DIRIGOD/DIRIGEANTOD)"></xsl:variable>
    <a name="ancDirigActuel"></a>
    <table class="clWidth635 clBorderCell" role="presentation">
     <tr class="clAlignCenter">
        <td class="clCouleurGras">
          DIRIGEANT(S) ACTIF(S) DE L'ENTREPRISE (<xsl:value-of select="."/>)<br/>
          <xsl:call-template name="shim"/>
        </td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template match="OD02">
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr class="clAlignLeft">
        <td class="clCouleur2">
          <xsl:value-of select="($dictionnaire/mot[@id='OD02'])"></xsl:value-of>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
  </xsl:template>

  <xsl:template match="DIRIGEANTOD">
    <table class="clBorderCell clWidth739">
      <caption class="visually-hidden">DIRIGEANT(S) ACTIF(S) DE L'ENTREPRISE</caption>
      <tr>
        <td class="clGrasFond" colspan="2">
          <xsl:apply-templates select="FONCTCOT"/>
        </td>
        <xsl:if test="FONCTCOT/DATFONCT">
          <th class="clFond clAlignRight clThNonGras" colspan="2"> Depuis le :</th>
          <td class="clFond clWidth90 clAlignRight">
            <xsl:call-template name ="displayDateXsl">
              <xsl:with-param name ="InputDate" select ="(FONCTCOT/DATFONCT)"/>
            </xsl:call-template>
          </td>
        </xsl:if>
        <xsl:if test="not(FONCTCOT/DATFONCT)">
          <td colspan="2" class="clFond">&#160;</td>
          <td class="clFond clWidth90">&#160;</td>
        </xsl:if>
        <xsl:if test="position() mod 3 = 0">
          <td class="clWidth103 clAlignRight" rowspan="3">
            <a href="#ancHaut">
              <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page" />
            </a>
          </td>
        </xsl:if>
        <xsl:if test="position() mod 3 != 0">
          <td class="clWidth103 clAlignRight" rowspan="3">
            &#160;
          </td>
        </xsl:if>
      </tr>
      <tr>
        <xsl:if test="EJ/DENOM">
          <td class="clTexteGras" colspan="5">
            &#160;<xsl:value-of select="EJ/DENOM"/>
          </td>
        </xsl:if>
        <xsl:if test="not(EJ/DENOM)">
          <td class="clTexteGras" colspan="2">
            &#160;<xsl:call-template name ="displayInLowerCaseXsl">
              <xsl:with-param name ="InputStringNom" select ="(PP/IDENTITE/NOM)"/>
              <xsl:with-param name ="InputStringPrenom" select ="(PP/IDENTITE/PRENOM)"/>
            </xsl:call-template>

          </td>
          <xsl:if test="PP/IDENTITE/NOMCONJ">
            <td class="clCouleur2 clWidth79">&#160;Nom marital</td>
            <td class="clTexte" colspan="2">
              &#160;<xsl:value-of select="PP/IDENTITE/NOMCONJ"/>
            </td>
          </xsl:if>
          <xsl:if test="not(PP/IDENTITE/NOMCONJ)">
            <td class="clWidth54">&#160;</td>
            <td colspan="2">&#160;</td>
          </xsl:if>
        </xsl:if>
      </tr>
      <!-- ligne differentes selon cotation avec ou sans segmentation -->

      <xsl:choose>
        <xsl:when test ="FONCTCOT/SEGMENT">
          <tr>
            <th class="clCouleur2 clWidth59 clAlignLeft clValignMiddle clThNonGras">&#160;Identifiant</th>
            <td class="clFond clWidth165">
              &#160;
              <xsl:if test="EJ/IDENTS">
                <xsl:call-template name ="displaySirenXsl">
                  <xsl:with-param name ="InputSiren" select ="(EJ/IDENTS)"/>
                </xsl:call-template>
              </xsl:if>
              <!--<xsl:value-of select="PP/IDENTC"/>-->
            </td>
            <xsl:if test="not(FONCTCOT/VALCOT='NS')">
              <th class="clCouleur2 clWidth153 clAlignLeft clThNonGras">&#160;Cotation | Segmentation</th>
              <xsl:variable name="ident" select="EJ/IDENTS"/>
              <xsl:if test="not(FONCTCOT/VALCOT='ND')">
                <td class="clFond clWidth166">
                  &#160;<a href="#nullepart" class="clFond" onclick="requestVariousInfos('{FONCTCOT/VALCOT}',cstCotation,'{$ident}')">
                    <u>
                      <xsl:value-of select="FONCTCOT/VALCOT"/>
                    </u>
                  </a>
                  <a href="#nullepart" class="clTexte" onclick="requestInfosLibelle('segmentation',cstSegment);">
                    &#160;|&#160;<u>
                      <xsl:value-of select="FONCTCOT/SEGMENT"/>
                    </u>
                  </a>
                </td>
              </xsl:if>
              <xsl:if test="(FONCTCOT/VALCOT='ND')">
                <td class="clFond clWidth166">
                  &#160;<a href="#nullepart" class="clFond" onclick="requestVariousInfos('{FONCTCOT/VALCOT}',cstCotationNonDif,'{$ident}')">
                    <u>
                      <xsl:value-of select="FONCTCOT/VALCOT"/>
                    </u>
                  </a>
                  <a href="#nullepart" class="clTexte" onclick="requestInfosLibelle('segmentation',cstSegment);">
                    &#160;|&#160;<u>
                      <xsl:value-of select="FONCTCOT/SEGMENT"/>
                    </u>
                  </a>
                </td>
              </xsl:if>              
              <td class="clFond clWidth92 clAlignRight clValignMiddle">
                <a href="#nullepart" onClick="requestBDFInfos('27|37|39|56|','','{$familyNumber}','{PP/IDENTC|EJ/IDENTS}',cstMultipleConfirm);">
                  <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                </a>
              </td>
            </xsl:if>
            <xsl:if test="(FONCTCOT/VALCOT='NS')">
             <td class="clFond clWidth319" colspan="2"></td>
              <td class="clFond clWidth92 clAlignRight clValignMiddle">
                <a href="#nullepart" onClick="requestBDFInfos('27|','','{$familyNumber}','{PP/IDENTC|EJ/IDENTS}',cstMultipleConfirm);">
                  <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                </a>
              </td>
            </xsl:if>
          </tr>
          <tr>
            <td class="clTexteGras clAlignLeft" colspan="4">
              &#160;
            </td>
            <td class="clWidth92">
              &#160;
            </td>
          </tr>
        </xsl:when>
        <xsl:otherwise>
          <tr>
            <th class="clCouleur2 clWidth59 clAlignLeft clValignMiddle clThNonGras">&#160;Identifiant</th>
            <td class="clFond clWidth255">
              &#160;
              <xsl:if test="EJ/IDENTS">
                <xsl:call-template name ="displaySirenXsl">
                  <xsl:with-param name ="InputSiren" select ="(EJ/IDENTS)"/>
                </xsl:call-template>
              </xsl:if>
              <xsl:value-of select="PP/IDENTC"/>
            </td>
            <xsl:if test="not(FONCTCOT/VALCOT='NS')">
              <xsl:if test="EJ">
                <th class="clCouleur2 clWidth63 clAlignLeft clThNonGras">&#160;Cotation</th>
              </xsl:if>
              <xsl:if test="PP">
                <th class="clCouleur2 clWidth63 clAlignLeft clThNonGras">&#160;Indicateur</th>
              </xsl:if>
              <xsl:variable name="ident" select="EJ/IDENTS|PP/IDENTC"/>
              <xsl:if test="not(FONCTCOT/VALCOT='ND')">
                <td class="clFond clWidth166">
                  &#160;<a href="#nullepart" class="clFond" onclick="requestVariousInfos('{FONCTCOT/VALCOT}',cstCotation,'{$ident}')">
                    <u>
                      <xsl:value-of select="FONCTCOT/VALCOT"/>
                    </u>
                  </a>
                </td>
              </xsl:if>
              <xsl:if test="(FONCTCOT/VALCOT='ND')">
                <td class="clFond clWidth166">
                  &#160;<a href="#nullepart" class="clFond" onclick="requestVariousInfos('{FONCTCOT/VALCOT}',cstCotationNonDif,'{$ident}')">
                    <u>
                      <xsl:value-of select="FONCTCOT/VALCOT"/>
                    </u>
                  </a>
                </td>
              </xsl:if>              
              <xsl:choose>
                <xsl:when test ="FONCTCOT/OD07">
                  <td class="clFond clWidth92 clAlignRight clValignMiddle">
                    <a href="#nullepart" onClick="requestBDFInfos('27|37|','','{$familyNumber}','{PP/IDENTC|EJ/IDENTS}',cstMultipleConfirm);">
                      <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                    </a>
                  </td>
                </xsl:when>
                <xsl:otherwise>
                  <td class="clFond clWidth92 clAlignRight clValignMiddle">
                    <a href="#nullepart" onClick="requestBDFInfos('27|37|56|','','{$familyNumber}','{PP/IDENTC|EJ/IDENTS}',cstMultipleConfirm);">
                      <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                    </a>
                  </td>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:if>
            <xsl:if test="(FONCTCOT/VALCOT='NS')">
              <td class="clFond clWidth229" colspan="2"></td>
              <td class="clFond clWidth92 clAlignRight clValignMiddle">
                <a href="#nullepart" onClick="requestBDFInfos('27|','','{$familyNumber}','{PP/IDENTC|EJ/IDENTS}',cstMultipleConfirm);">
                  <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                </a>
              </td>
            </xsl:if>
          </tr>
          <xsl:choose>
            <xsl:when test ="FONCTCOT/AUTRFDEI">
              <tr>
                <td class="clTexte clAlignLeft" colspan="4">
                    <xsl:value-of select="($dictionnaire/mot[@id='AUTRFDEI'])"></xsl:value-of>
                </td>
                <td class="clWidth92">
                  &#160;
                </td>
              </tr>
            </xsl:when>
            <xsl:when test ="FONCTCOT/OD07">
              <tr>
                <td class="clTexte clAlignLeft" colspan="4">
                  <xsl:value-of select="($dictionnaire/mot[@id='OD07'])"></xsl:value-of>
                </td>
                <td class="clWidth92">
                  &#160;
                </td>
              </tr>
            </xsl:when>
            <xsl:otherwise>
              <tr>
                <td class="clTexteGras clAlignLeft" colspan="4">
                  &#160;
                </td>
                <td class="clWidth92">
                  &#160;
                </td>
              </tr>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:otherwise>
      </xsl:choose >
    </table>
    <xsl:call-template name="shim"/>
  </xsl:template>

  <xsl:template name="SuiteDirigActif">
    <xsl:if test="position() mod 9 = 0">
      <div class="clBreakPage"></div>
    </xsl:if>
    <xsl:if test="position() = last()">
      <table class="clWidth635 clBorderCell" role="presentation">
        <tr>
          <td class="clCouleur2 clWidth530 clHeight14" colspan="4">
            <br/>
            <xsl:value-of select="($dictionnaire/mot[@id='SUITEDA'])"></xsl:value-of>
          </td>
          <td class="clWidth105 clHeight14 clValignMiddle clAlignRight">
            <a href="#nullepart" onClick="requestBDFInfos('51','','{$familyNumber}','{EJ/IDENTS}',cstSimpleConfirm);">
              <img src="{$root}images/Commun/clignotant2.gif" width="85" height="12" border="0" align="absbottom" alt="plus d'infos"/>
            </a>
          </td>
        </tr>
      </table>
      <xsl:call-template name="shim"/>
    </xsl:if>
  </xsl:template>

  <xsl:template match="NBDIRIGEANTCESSEOD">
    <xsl:variable name ="nbDirigeantCesse" select ="count(/FIBEN/PERSONNE/MODULEOD/DIFFOD/DIRIGODS/DIRIGCESSEOD/DIRIGEANTCESSEOD)"></xsl:variable>
    <a name="ancDirigCesse" />
    <table class="clWidth635 clBorderCell" role="presentation">
     <tr class="clAlignCenter">
        <td class="clCouleurGras">
          DIRIGEANT(S) DE L'ENTREPRISE AYANT CESS&#201;
          SON(LEUR) ACTIVIT&#201; (<xsl:value-of select="."/>)<br/>
          <xsl:call-template name="shim"/>
        </td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template match="OD03">
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr class="clAlignLeft">
        <td class="clCouleur2">
          <xsl:value-of select="($dictionnaire/mot[@id='OD03'])"></xsl:value-of>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
  </xsl:template>

  <xsl:template match="DIRIGEANTCESSEOD">
    <table class="clBorderCell clWidth739">
      <caption class="visually-hidden">DIRIGEANT(S) DE L'ENTREPRISE AYANT CESS SON(LEUR) ACTIVIT</caption>
      <tr>
        <td class="clGrasFond" colspan="2">
          <xsl:apply-templates select="FONCTCOT"/>
        </td>
        <xsl:if test="FONCTCOT/DATFONCT">
          <th class="clFond clAlignRight clThNonGras" colspan="2"> Depuis le :</th>
          <td class="clFond clWidth90 clAlignRight">
            <xsl:call-template name ="displayDateXsl">
              <xsl:with-param name ="InputDate" select ="(FONCTCOT/DATFONCT)"/>
            </xsl:call-template>
          </td>
        </xsl:if>
        <xsl:if test="not(FONCTCOT/DATFONCT)">
          <td colspan="2" class="clFond">&#160;</td>
          <td class="clFond clWidth90">&#160;</td>
        </xsl:if>
        <xsl:if test="position() mod 3 = 0">
          <td class="clWidth103 clAlignRight" rowspan="3">
            <a href="#ancHaut">
              <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page" />
            </a>
          </td>
        </xsl:if>
        <xsl:if test="position() mod 3 != 0">
          <td class="clWidth103 clAlignRight" rowspan="3">
            &#160;
          </td>
        </xsl:if>
      </tr>
      <xsl:apply-templates select="CESSATION"/>

      <tr>
        <xsl:if test="EJ/DENOM">
          <td class="clFond" colspan="5">
            &#160;<xsl:value-of select="EJ/DENOM"/>
          </td>
        </xsl:if>
        <xsl:if test="not(EJ/DENOM)">
          <td class="clGrasFond" colspan="2">
            &#160;<xsl:call-template name ="displayInLowerCaseXsl">
              <xsl:with-param name ="InputStringNom" select ="(PP/IDENTITE/NOM)"/>
              <xsl:with-param name ="InputStringPrenom" select ="(PP/IDENTITE/PRENOM)"/>
            </xsl:call-template>
          </td>
          <xsl:if test="PP/IDENTITE/NOMCONJ">
            <th class="clCouleur2 clWidth79 clAlignLeft clThNonGras">&#160;Nom marital</th>
            <td colspan="2" class="clFond">
              &#160;<xsl:value-of select="PP/IDENTITE/NOMCONJ"/>
            </td>
          </xsl:if>
          <xsl:if test="not(PP/IDENTITE/NOMCONJ)">
            <td class="clFond clWidth54">&#160;</td>
            <td colspan="2" class="clFond">&#160;</td>
          </xsl:if>
        </xsl:if>
      </tr>
      <!-- ligne differentes selon cotation avec ou sans segmentation -->

      <xsl:choose>
        <xsl:when test ="FONCTCOT/SEGMENT">
          <tr>
            <th class="clCouleur2 clWidth59 clAlignLeft clValignMiddle clThNonGras">&#160;Identifiant</th>
            <td class="clTexte clWidth165">
              &#160;
              <xsl:if test="EJ/IDENTS">
                <xsl:call-template name ="displaySirenXsl">
                  <xsl:with-param name ="InputSiren" select ="(EJ/IDENTS)"/>
                </xsl:call-template>
              </xsl:if>
              <!--<xsl:value-of select="PP/IDENTC"/>-->
            </td>
            <xsl:if test="not(FONCTCOT/VALCOT='NS')">
            <th class="clCouleur2 clWidth153 clAlignLeft clThNonGras">&#160;Cotation | Segmentation</th>
            <xsl:variable name="ident" select="EJ/IDENTS"/>
              <xsl:if test="not(FONCTCOT/VALCOT='ND')">
                <td class="clTexte clWidth166">
                  &#160;<a href="#nullepart" class="clTexte" onclick="requestVariousInfos('{FONCTCOT/VALCOT}',cstCotation,'{$ident}')">
                    <u>
                      <xsl:value-of select="FONCTCOT/VALCOT"/>
                    </u>
                  </a>
                  <a href="#nullepart" class="clTexte" onclick="requestInfosLibelle('segmentation',cstSegment);">
                    &#160;|&#160;<u>
                      <xsl:value-of select="FONCTCOT/SEGMENT"/>
                    </u>
                  </a>
                </td>
              </xsl:if>
              <xsl:if test="(FONCTCOT/VALCOT='ND')">
                <td class="clTexte clWidth166">
                  &#160;<a href="#nullepart" class="clTexte" onclick="requestVariousInfos('{FONCTCOT/VALCOT}',cstCotationNonDif,'{$ident}')">
                    <u>
                      <xsl:value-of select="FONCTCOT/VALCOT"/>
                    </u>
                  </a>
                  <a href="#nullepart" class="clTexte" onclick="requestInfosLibelle('segmentation',cstSegment);">
                    &#160;|&#160;<u>
                      <xsl:value-of select="FONCTCOT/SEGMENT"/>
                    </u>
                  </a>
                </td>
              </xsl:if>            
            <td class="clTexte clWidth92 clAlignRight clValignMiddle">
              <a href="#nullepart" onClick="requestBDFInfos('27|37|39|56|','','{$familyNumber}','{PP/IDENTC|EJ/IDENTS}',cstMultipleConfirm);">
                <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
              </a>
            </td>
            </xsl:if>
            <xsl:if test="(FONCTCOT/VALCOT='NS')">
              <td class="clTexte clWidth319" colspan="2"></td>
              <td class="clTexte clWidth92 clAlignRight clValignMiddle">
                <a href="#nullepart" onClick="requestBDFInfos('27|37|39|','','{$familyNumber}','{PP/IDENTC|EJ/IDENTS}',cstMultipleConfirm);">
                  <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                </a>
              </td>
            </xsl:if>
          </tr>
          <tr>
            <td class="clTexteGras clAlignLeft" colspan="4">
              &#160;
            </td>
            <td class="clWidth92">
              &#160;
            </td>
          </tr>
        </xsl:when>
        <xsl:otherwise>
          <tr>
            <th class="clCouleur2 clWidth59 clAlignLeft clValignMiddle clThNonGras">&#160;Identifiant</th>
            <td class="clTexte clWidth255">
              &#160;
              <xsl:if test="EJ/IDENTS">
                <xsl:call-template name ="displaySirenXsl">
                  <xsl:with-param name ="InputSiren" select ="(EJ/IDENTS)"/>
                </xsl:call-template>
              </xsl:if>
              <xsl:value-of select="PP/IDENTC"/>
            </td>
            <xsl:if test="not(FONCTCOT/VALCOT='NS')">
              <xsl:if test="EJ">
                <th class="clCouleur2 clWidth63 clAlignLeft clThNonGras">&#160;Cotation</th>
              </xsl:if>
              <xsl:if test="PP">
                <th class="clCouleur2 clWidth63 clAlignLeft clThNonGras">&#160;Indicateur</th>
              </xsl:if>
              <xsl:variable name="ident" select="EJ/IDENTS|PP/IDENTC"/>
              <xsl:if test="not(FONCTCOT/VALCOT='ND')">
                <td class="clTexte clWidth166">
                  &#160;<a href="#nullepart" class="clTexte" onclick="requestVariousInfos('{FONCTCOT/VALCOT}',cstCotation,'{$ident}')">
                    <u>
                      <xsl:value-of select="FONCTCOT/VALCOT"/>
                    </u>
                  </a>
                </td>
              </xsl:if>
              <xsl:if test="(FONCTCOT/VALCOT='ND')">
                  <td class="clTexte clWidth166">
                &#160;<a href="#nullepart" class="clTexte" onclick="requestVariousInfos('{FONCTCOT/VALCOT}',cstCotationNonDif,'{$ident}')">
                  <u>
                    <xsl:value-of select="FONCTCOT/VALCOT"/>
                  </u>
                </a>
              </td>
              </xsl:if>              
              <td class="clTexte clWidth92 clAlignRight clValignMiddle">
                <a href="#nullepart" onClick="requestBDFInfos('27|37|56|','','{$familyNumber}','{PP/IDENTC|EJ/IDENTS}',cstMultipleConfirm);">
                  <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                </a>
              </td>
            </xsl:if>
            <xsl:if test="FONCTCOT/VALCOT='NS'">
              <td class="clTexte clWidth229" colspan="2"></td>
              <td class="clTexte clWidth92 clAlignRight clValignMiddle">
                <a href="#nullepart" onClick="requestBDFInfos('27|','','{$familyNumber}','{PP/IDENTC|EJ/IDENTS}',cstMultipleConfirm);">
                  <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                </a>
              </td>
            </xsl:if>
          </tr>
          <xsl:choose>
            <xsl:when test ="FONCTCOT/AUTRFDEI">
              <tr>
                <td class="clTexte clAlignLeft" colspan="4">
                    <xsl:value-of select="($dictionnaire/mot[@id='AUTRFDEI'])"></xsl:value-of>
                </td>
                <td class="clWidth92">
                  &#160;
                </td>
              </tr>
            </xsl:when>
            <xsl:otherwise>
              <tr>
                <td class="clTexteGras clAlignLeft" colspan="4">
                  &#160;
                </td>
                <td class="clWidth92">
                  &#160;
                </td>
              </tr>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:otherwise>
      </xsl:choose>


    </table>
    <xsl:call-template name="shim"/>
  </xsl:template>

  <xsl:template match="CESSATION">
    <tr>
      <td class="clTexte" colspan="2" >
        &#160;<xsl:call-template name="traduction">
          <xsl:with-param name="code" select="@COCESS"/>
        </xsl:call-template>
      </td>
      <xsl:if test="@DATCESS != ''">
        <th class="clTexte clAlignRight clThNonGras" colspan="2"> Cess(e) depuis le :</th>
        <td class="clTexte clAlignRight clWidth90">
          <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="(@DATCESS)"/>
          </xsl:call-template>
        </td>
      </xsl:if>
      <xsl:if test="not(@DATCESS)">
        <td class="clTexte" colspan="2">&#160;</td>
        <td class="clFond clWidth90">&#160;</td>
      </xsl:if>


    </tr>
  </xsl:template>

  <xsl:template name="SuiteDirigCesse">
    <xsl:if test="position() mod 9 = 0">
      <div class="clBreakPage"></div>
    </xsl:if>
    <xsl:if test="position() = last()">
      <table class="clWidth635 clBorderCell" role="presentation">
        <tr>
          <td class="clCouleur2 clWidth530 clHeight14" colspan="4">
            <br/>
            <xsl:value-of select="($dictionnaire/mot[@id='SUITEDC'])"></xsl:value-of>
          </td>
          <td class="clWidth105 clHeight14 clValignMiddle clAlignRight">
            <a href="#nullepart" onClick="requestBDFInfos('51','','{$familyNumber}','{EJ/IDENTS}',cstSimpleConfirm);">
              <img src="{$root}images/Commun/clignotant2.gif" width="85" height="12" border="0" align="absbottom" alt="plus d'infos"/>
            </a>
          </td>
        </tr>
      </table>
      <xsl:call-template name="shim"/>
    </xsl:if>
  </xsl:template>


  <!-- *******************************  message ISTOD2 *********************************************** -->
  <xsl:template match="ISTOD2">
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr class="clAlignLeft">
        <td class="clCouleur2">
          <xsl:value-of select="($dictionnaire/mot[@id='ISTOD2'])"/>
          <br/>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
  </xsl:template>

  <!-- *******************************  message ISTOD1 *********************************************** -->
  <xsl:template name="ISTOD1">
    <xsl:param name ="position"></xsl:param>
    <xsl:param name ="Max"></xsl:param>

    <xsl:if test ="not ($position &gt; $Max)">

      <xsl:for-each select="/FIBEN/PERSONNE/MODULEOD/DIFFOD/DIRIGODS/DIRIGOD/DIRIGEANTOD[$position]">
        <xsl:if test ="/FIBEN/PERSONNE/MODULEOD/DIFFOD/DIRIGODS/DIRIGOD/DIRIGEANTOD[$position]/FONCTCOT/ISTOD1">
          <table class="clWidth635 clBorderCell" role="presentation">
            <tr class="clAlignLeft">
              <td class="clCouleur2">
                <xsl:value-of select="($dictionnaire/mot[@id='ISTOD1'])"/>
              </td>
            </tr>
           <tr class="clHeight15 clAlignCenter">
              <td>&#160;</td>
            </tr>
            <tr class="clAlignLeft">
              <td class ="clCouleur2">
                <xsl:call-template name ="displayInLowerCaseXsl">
                  <xsl:with-param name ="InputStringNom" select ="(PP/IDENTITE/NOM)"/>
                  <xsl:with-param name ="InputStringPrenom" select ="(PP/IDENTITE/PRENOM)"/>
                </xsl:call-template>
                &#160;(<xsl:value-of select="(PP/IDENTC)"/>)
              </td>
            </tr>
          </table>
          <xsl:call-template name="shim"/>
          <xsl:call-template name ="ISTOD1">
            <xsl:with-param name ="position" select ="$Max + 1"></xsl:with-param>
            <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
          </xsl:call-template>
        </xsl:if>
        <xsl:call-template name ="ISTOD1">
          <xsl:with-param name ="position" select ="$position + 1"></xsl:with-param>
          <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
        </xsl:call-template>
      </xsl:for-each>
    </xsl:if>
  </xsl:template>


  <!-- *******************************  PARTIE FONCTION(S) DE DIRECTION(S) *********************************** -->
  <xsl:template match="REPLEGODS">
    <!-- Fonction(s) de direction(s) actuelle(s)-->
    <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEOD/DIFFOD/REPLEGODS/OD05"/>
    <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEOD/DIFFOD/REPLEGODS/REPLEGFONCTACTOD/NBFONCTIONOD"/>
    <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEOD/DIFFOD/REPLEGODS/REPLEGFONCTACTOD/FONCTIONOD"/>
    <xsl:if test ="/FIBEN/PERSONNE/MODULEOD/DIFFOD/REPLEGODS/REPLEGFONCTACTOD/SUITEFDA">
      <xsl:call-template name ="SuiteFonctDirection">
          <xsl:with-param name ="position" select ="1"></xsl:with-param>
          <xsl:with-param name ="Max" select ="(/FIBEN/PERSONNE/MODULEOD/DIFFOD/DIRIGODS/DIRIGOD/NBDIRIGEANTOD) + 1"></xsl:with-param>
      </xsl:call-template>
    </xsl:if>

    <!-- Fonction(s) de direction(s) cesse(s)-->
    <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEOD/DIFFOD/REPLEGODS/OD06"/>
    <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEOD/DIFFOD/REPLEGODS/REPLEGFONCTCESSOD/NBFONCTIONCESSEEOD"/>
    <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEOD/DIFFOD/REPLEGODS/REPLEGFONCTCESSOD/FONCTIONCESSEEOD"/>
    <xsl:if test ="/FIBEN/PERSONNE/MODULEOD/DIFFOD/REPLEGODS/REPLEGFONCTCESSOD/SUITEFDC">
      <xsl:call-template name ="SuiteFonctDirectionCesse">
          <xsl:with-param name ="position" select ="1"></xsl:with-param>
          <xsl:with-param name ="Max" select ="(/FIBEN/PERSONNE/MODULEOD/DIFFOD/DIRIGODS/DIRIGOD/NBDIRIGEANTOD) + 1"></xsl:with-param>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <xsl:template match="NBFONCTIONOD">
    <!--<a name="ancFonctActuel"></a>-->
    <!-- recuperation du 1er representant lgal PP -->
    <xsl:call-template name ="FonctActRepLegPP">
      <xsl:with-param name ="position" select ="1"></xsl:with-param>
      <xsl:with-param name ="Max" select ="(/FIBEN/PERSONNE/MODULEOD/DIFFOD/DIRIGODS/DIRIGOD/NBDIRIGEANTOD) + 1"></xsl:with-param>
    </xsl:call-template>
  </xsl:template>


  <xsl:template name ="FonctActRepLegPP">
    <xsl:param name ="position"></xsl:param>
    <xsl:param name ="Max"></xsl:param>

    <xsl:if test ="$position &lt; $Max">

      <xsl:for-each select="/FIBEN/PERSONNE/MODULEOD/DIFFOD/DIRIGODS/DIRIGOD/DIRIGEANTOD[$position]">
        <xsl:if test ="/FIBEN/PERSONNE/MODULEOD/DIFFOD/DIRIGODS/DIRIGOD/DIRIGEANTOD[$position]/FONCTCOT/OD07">
          <!-- les fonctions de directions detenues par le reprsentant lgal -->
          <a name="ancFonctActuel" />
          <table class="clWidth635 clBorderCell" role="presentation">
           <tr class="clAlignCenter">
              <td class="clCouleurGras">
                <xsl:value-of select="/FIBEN/PERSONNE/MODULEOD/DIFFOD/REPLEGODS/REPLEGFONCTACTOD/NBFONCTIONOD"/>&#160;FONCTION(S) DE DIRECTION ACTUELLE DETENUE(S) PAR LE REPRESENTANT LEGAL<br/>
              </td>
            </tr>
           <tr class="clHeight15 clAlignCenter">
              <td>&#160;</td>
            </tr>
           <tr class="clAlignCenter">
              <td class ="clCouleurGras">
                <xsl:call-template name ="displayInLowerCaseXsl">
                  <xsl:with-param name ="InputStringNom" select ="(PP/IDENTITE/NOM)"/>
                  <xsl:with-param name ="InputStringPrenom" select ="(PP/IDENTITE/PRENOM)"/>
                </xsl:call-template>
                &#160;(<xsl:value-of select="(PP/IDENTC)"/>)
                <xsl:call-template name="shim"/>
              </td>
            </tr>
          </table>
          <xsl:call-template name ="FonctActRepLegPP">
            <xsl:with-param name ="position" select ="$Max"></xsl:with-param>
            <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
          </xsl:call-template>
        </xsl:if>
        <xsl:call-template name ="FonctActRepLegPP">
          <xsl:with-param name ="position" select ="$position + 1"></xsl:with-param>
          <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
        </xsl:call-template>
      </xsl:for-each>
    </xsl:if>
  </xsl:template>

  <xsl:template match="OD05">
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr class="clAlignLeft">
        <td class="clCouleur2">
          <xsl:value-of select="($dictionnaire/mot[@id='OD05'])"></xsl:value-of>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
  </xsl:template>

  <xsl:template match="FONCTIONOD">
    <table class="clBorderCell clWidth739">
      <caption class="visually-hidden">Fonction(s) de direction(s) actuelle(s)</caption>
      <tr>
        <td class="clGrasFond" colspan="2">
          <xsl:apply-templates select="FONCTCOT"/>
        </td>
        <xsl:if test="FONCTCOT/DATFONCT">
          <th class="clFond clAlignRight clThNonGras" colspan="2"> Depuis le :</th>
          <td class="clFond clWidth90 clAlignRight">
            <xsl:call-template name ="displayDateXsl">
              <xsl:with-param name ="InputDate" select ="(FONCTCOT/DATFONCT)"/>
            </xsl:call-template>
          </td>
        </xsl:if>
        <xsl:if test="not(FONCTCOT/DATFONCT)">
          <td colspan="2" class="clFond">&#160;</td>
          <td class="clFond clWidth90">&#160;</td>
        </xsl:if>
        <xsl:if test="position() mod 3 = 0">
          <td class="clWidth103 clAlignRight" rowspan="3">
            <a href="#ancHaut">
              <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page" />
            </a>
          </td>
        </xsl:if>
        <xsl:if test="position() mod 3 != 0">
          <td class="clWidth103 clAlignRight" rowspan="3">
            &#160;
          </td>
        </xsl:if>
      </tr>
      <tr>
        <td class="clTexteGras clHeight14" colspan="5">
          &#160;<xsl:value-of select="EJ/DENOM"/>
        </td>
      </tr>
      <xsl:choose>
        <xsl:when test="not(FONCTCOT/SEGMENT)">
          <tr>
            <th class="clCouleur2 clWidth59 clValignMiddle clThNonGras">&#160;Identifiant</th>
            <td class="clFond clWidth255">
              &#160;<xsl:call-template name ="displaySirenXsl">
                <xsl:with-param name ="InputSiren" select ="(EJ/IDENTS)"/>
              </xsl:call-template>
            </td>
            <th class="clCouleur2 clWidth53 clValignMiddle clAlignLeft clThNonGras">&#160;Cotation</th>
            <xsl:if test="not(FONCTCOT/VALCOT='ND')">
             <td class="clFond clWidth176">
                &#160;<a href="#nullepart" class="clFond" onclick="requestVariousInfos('{FONCTCOT/VALCOT}',cstCotation,'{EJ/IDENTS}');">
                  <u>
                    <xsl:value-of 	select="FONCTCOT/VALCOT"/>
                  </u>
                </a>
              </td>
            </xsl:if>
            <xsl:if test="(FONCTCOT/VALCOT='ND')">
             <td class="clFond clWidth176">
                &#160;<a href="#nullepart" class="clFond" onclick="requestVariousInfos('{FONCTCOT/VALCOT}',cstCotationNonDif,'{EJ/IDENTS}');">
                  <u>
                    <xsl:value-of 	select="FONCTCOT/VALCOT"/>
                  </u>
                </a>
              </td>
            </xsl:if>            
            <td class="clFond clWidth92 clAlignRight clValignMiddle">
              <a href="#nullepart" onClick="requestBDFInfos('27|37|51|','','{$familyNumber}','{EJ/IDENTS}',cstMultipleConfirm);">
                <img 	src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
              </a>
            </td>
          </tr >
        </xsl:when >
        <xsl:otherwise>
          <tr>
            <th class="clCouleur2 clWidth59 clValignMiddle clAlignLeft clThNonGras">
              &#160;Identifiant
            </th>
            <td class="clFond clWidth163">
              &#160;<xsl:call-template name ="displaySirenXsl">
                <xsl:with-param name ="InputSiren" select ="(EJ/IDENTS)"/>
              </xsl:call-template>
            </td>
            <th class="clCouleur2 clWidth145 clValignMiddle clAlignLeft clThNonGras">&#160;Cotation | Segmentation</th>
            <xsl:if test="not(FONCTCOT/VALCOT='ND')">
             <td class="clFond clWidth176">
                &#160;<a href="#nullepart" class="clFond" onclick="requestVariousInfos('{FONCTCOT/VALCOT}',cstCotation,'{EJ/IDENTS}');">
                  <u>
                    <xsl:value-of 	select="FONCTCOT/VALCOT"/>
                  </u>
                </a>
                <a href="#nullepart" class="clTexte" onclick="requestInfosLibelle('segmentation',cstSegment);">
                  &#160;|&#160;<u>
                    <xsl:value-of select="FONCTCOT/SEGMENT"/>
                  </u>
                </a>
              </td>
            </xsl:if>
            <xsl:if test="(FONCTCOT/VALCOT='ND')">
             <td class="clFond clWidth176">
                &#160;<a href="#nullepart" class="clFond" onclick="requestVariousInfos('{FONCTCOT/VALCOT}',cstCotationNonDif,'{EJ/IDENTS}');">
                  <u>
                    <xsl:value-of 	select="FONCTCOT/VALCOT"/>
                  </u>
                </a>
                <a href="#nullepart" class="clTexte" onclick="requestInfosLibelle('segmentation',cstSegment);">
                  &#160;|&#160;<u>
                    <xsl:value-of select="FONCTCOT/SEGMENT"/>
                  </u>
                </a>
              </td>
            </xsl:if>           
            <td class="clFond clWidth92 clAlignRight clValignMiddle">
              <a href="#nullepart" onClick="requestBDFInfos('27|37|39|51|','','{$familyNumber}','{EJ/IDENTS}',cstMultipleConfirm);">
                <img 	src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
              </a>
            </td>
          </tr>
        </xsl:otherwise>
      </xsl:choose>
    </table>
    <xsl:call-template name="shim"/>
  </xsl:template>

    <xsl:template name="SuiteFonctDirection">
        <xsl:param name ="position"></xsl:param>
        <xsl:param name ="Max"></xsl:param>

        <xsl:if test ="$position &lt; $Max">

            <xsl:for-each select="/FIBEN/PERSONNE/MODULEOD/DIFFOD/DIRIGODS/DIRIGOD/DIRIGEANTOD[$position]">
                <xsl:if test ="/FIBEN/PERSONNE/MODULEOD/DIFFOD/DIRIGODS/DIRIGOD/DIRIGEANTOD[$position]/FONCTCOT/OD07">
                    <xsl:variable name ="IdentPPLeg" select="(PP/IDENTC)"></xsl:variable>
                    <xsl:if test="position() mod 9 = 0">
                        <div class="clBreakPage"></div>
                    </xsl:if>
                    <xsl:if test="position() = last()">
                        <table class="clWidth635 clBorderCell" role="presentation">
                            <tr>
                                <td class="clCouleur2 clWidth530 clHeight14" colspan="4">
                                    <br/>
                                    <xsl:value-of select="($dictionnaire/mot[@id='SUITEFDA'])"></xsl:value-of>
                                </td>
                                <td class="clWidth105 clHeight14 clValignMiddle clAlignRight">
                                    <a href="#nullepart" onClick="requestBDFInfos('56','','{$familyNumber}','{$IdentPPLeg}',cstSimpleConfirm);">
                                        <img src="{$root}images/Commun/clignotant2.gif" width="85" height="12" border="0" align="absbottom" alt="plus d'infos"/>
                                    </a>
                                </td>
                            </tr>
                        </table>
                        <xsl:call-template name="shim"/>
                    </xsl:if>
                    <xsl:call-template name ="SuiteFonctDirection">
                        <xsl:with-param name ="position" select ="$Max"></xsl:with-param>
                        <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
                    </xsl:call-template>
                </xsl:if >
                <xsl:call-template name ="SuiteFonctDirection">
                    <xsl:with-param name ="position" select ="$position + 1"></xsl:with-param>
                    <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
                </xsl:call-template>

            </xsl:for-each>
        </xsl:if>
    </xsl:template>

  <xsl:template match="NBFONCTIONCESSEEOD">
    <!--<a name="ancFonctCesse"></a>-->
    <!-- recuperation du 1er representant lgal PP -->
    <xsl:call-template name ="FonctCesseRepLegPP">
      <xsl:with-param name ="position" select ="1"></xsl:with-param>
      <xsl:with-param name ="Max" select ="(/FIBEN/PERSONNE/MODULEOD/DIFFOD/DIRIGODS/DIRIGOD/NBDIRIGEANTOD) + 1"></xsl:with-param>
    </xsl:call-template>
  </xsl:template>


  <xsl:template name ="FonctCesseRepLegPP">
    <xsl:param name ="position"></xsl:param>
    <xsl:param name ="Max"></xsl:param>

    <xsl:if test ="$position &lt; $Max">

      <xsl:for-each select="/FIBEN/PERSONNE/MODULEOD/DIFFOD/DIRIGODS/DIRIGOD/DIRIGEANTOD[$position]">
        <xsl:if test ="/FIBEN/PERSONNE/MODULEOD/DIFFOD/DIRIGODS/DIRIGOD/DIRIGEANTOD[$position]/FONCTCOT/OD07">
          <a name="ancFonctCesse"></a>
          <table class="clWidth635 clBorderCell" role="presentation">
           <tr class="clAlignCenter">
              <td class="clCouleurGras">
                <xsl:value-of select="/FIBEN/PERSONNE/MODULEOD/DIFFOD/REPLEGODS/REPLEGFONCTCESSOD/NBFONCTIONCESSEEOD"/>&#160;FONCTION(S) DE DIRECTION CESSEE(S) DETENUE(S) PAR LE REPRESENTANT LEGAL<br/>
              </td>
            </tr>
           <tr class="clHeight15 clAlignCenter">
              <td>&#160;</td>
            </tr>
           <tr class="clAlignCenter">
              <td class ="clCouleurGras">
                <xsl:call-template name ="displayInLowerCaseXsl">
                  <xsl:with-param name ="InputStringNom" select ="(PP/IDENTITE/NOM)"/>
                  <xsl:with-param name ="InputStringPrenom" select ="(PP/IDENTITE/PRENOM)"/>
                </xsl:call-template>
                &#160;(<xsl:value-of select="(PP/IDENTC)"/>)
                <xsl:call-template name="shim"/>
              </td>
            </tr>
          </table>
          <xsl:call-template name ="FonctCesseRepLegPP">
            <xsl:with-param name ="position" select ="$Max"></xsl:with-param>
            <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
          </xsl:call-template>
        </xsl:if>
        <xsl:call-template name ="FonctCesseRepLegPP">
          <xsl:with-param name ="position" select ="$position + 1"></xsl:with-param>
          <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
        </xsl:call-template>

      </xsl:for-each>
    </xsl:if>
  </xsl:template>

  <xsl:template match="OD06">
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr class="clAlignLeft">
        <td class="clCouleur2">
          <xsl:value-of select="($dictionnaire/mot[@id='OD06'])"></xsl:value-of>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
  </xsl:template>

  <xsl:template match="FONCTIONCESSEEOD">
    <table class="clBorderCell clWidth739">
      <caption class="visually-hidden">Fonction(s) de direction(s) cesse(s)</caption>      
      <tr>
        <td class="clGrasFond" colspan="2">
          <xsl:apply-templates select="FONCTCOT"/>
        </td>
        <xsl:if test="FONCTCOT/DATFONCT">
          <th class="clFond clAlignRight clThNonGras" colspan="2"> Depuis le :</th>
          <td class="clFond clWidth90 clAlignRight">
            <xsl:call-template name ="displayDateXsl">
              <xsl:with-param name ="InputDate" select ="(FONCTCOT/DATFONCT)"/>
            </xsl:call-template>
          </td>
        </xsl:if>
        <xsl:if test="not(FONCTCOT/DATFONCT)">
          <td colspan="2" class="clFond">&#160;</td>
          <td class="clFond clWidth90">&#160;</td>
        </xsl:if>
        <xsl:if test="position() mod 3 = 0">
          <td class="clWidth103 clAlignRight" rowspan="3">
            <a href="#ancHaut">
              <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page" />
            </a>
          </td>
        </xsl:if>
        <xsl:if test="position() mod 3 != 0">
          <td class="clWidth103 clAlignRight" rowspan="3">
            &#160;
          </td>
        </xsl:if>
      </tr>
      <xsl:apply-templates select="CESSATION"/>
      <tr>
        <td class="clGrasFond clHeight14" colspan="5">
          &#160;<xsl:value-of select="EJ/DENOM"/>
        </td>
      </tr>
      <xsl:choose >
        <xsl:when test="not(FONCTCOT/SEGMENT)">
          <tr>
            <th class="clCouleur2 clWidth59 clValignMiddle clAlignLeft clThNonGras">
              &#160;Identifiant
            </th>
            <td class="clTexte clWidth255">
              &#160;<xsl:call-template name ="displaySirenXsl">
                <xsl:with-param name ="InputSiren" select ="(EJ/IDENTS)"/>
              </xsl:call-template>
            </td>

            <th class="clCouleur2 clWidth53 clValignMiddle clAlignLeft clThNonGras">&#160;Cotation</th>
            <xsl:if test="not(FONCTCOT/VALCOT='ND')">
              <td class="clTexte clWidth176">
                &#160;<a href="#nullepart" class="clTexte" onclick="requestVariousInfos('{FONCTCOT/VALCOT}',cstCotation,'{EJ/IDENTS}');">
                  <u>
                    <xsl:value-of select="FONCTCOT/VALCOT"/>
                  </u>
                </a>
              </td>
            </xsl:if>
            <xsl:if test="(FONCTCOT/VALCOT='ND')">
              <td class="clTexte clWidth176">
                &#160;<a href="#nullepart" class="clTexte" onclick="requestVariousInfos('{FONCTCOT/VALCOT}',cstCotationNonDif,'{EJ/IDENTS}');">
                  <u>
                    <xsl:value-of select="FONCTCOT/VALCOT"/>
                  </u>
                </a>
              </td>
            </xsl:if>            
            <td class="clTexte clWidth92 clAlignRight clValignMiddle">
              <a href="#nullepart" onClick="requestBDFInfos('27|37|51|','','{$familyNumber}','{EJ/IDENTS}',cstMultipleConfirm);">
                <img 	src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
              </a>
            </td>
          </tr>
        </xsl:when>
        <xsl:otherwise >
          <tr>
            <th class="clCouleur2 clWidth59 clValignMiddle clAlignLeft clThNonGras">
              &#160;Identifiant
            </th>
            <td class="clTexte clWidth163">
              &#160;<xsl:call-template name ="displaySirenXsl">
                <xsl:with-param name ="InputSiren" select ="(EJ/IDENTS)"/>
              </xsl:call-template>
            </td>
            <th class="clCouleur2 clWidth145 clValignMiddle clAlignLeft clThNonGras">&#160;Cotation | Segmentation</th>
            <xsl:if test="not(FONCTCOT/VALCOT='ND')">
              <td class="clTexte clWidth176">
                &#160;<a href="#nullepart" class="clTexte" onclick="requestVariousInfos('{FONCTCOT/VALCOT}',cstCotation,'{EJ/IDENTS}');">
                  <u>
                    <xsl:value-of select="FONCTCOT/VALCOT"/>
                  </u>
                </a>
                <a href="#nullepart" class="clTexte" onclick="requestInfosLibelle('segmentation',cstSegment);">
                  &#160;|&#160;<u>
                    <xsl:value-of select="FONCTCOT/SEGMENT"/>
                  </u>
                </a>
              </td>
            </xsl:if>
            <xsl:if test="(FONCTCOT/VALCOT='ND')">
              <td class="clTexte clWidth176">
                &#160;<a href="#nullepart" class="clTexte" onclick="requestVariousInfos('{FONCTCOT/VALCOT}',cstCotationNonDif,'{EJ/IDENTS}');">
                  <u>
                    <xsl:value-of select="FONCTCOT/VALCOT"/>
                  </u>
                </a>
                <a href="#nullepart" class="clTexte" onclick="requestInfosLibelle('segmentation',cstSegment);">
                  &#160;|&#160;<u>
                    <xsl:value-of select="FONCTCOT/SEGMENT"/>
                  </u>
                </a>
              </td>
            </xsl:if>
           
            <td class="clTexte clWidth92 clAlignRight clValignMiddle">
              <a href="#nullepart" onClick="requestBDFInfos('27|37|39|51|','','{$familyNumber}','{EJ/IDENTS}',cstMultipleConfirm);">
                <img 	src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
              </a>
            </td>
          </tr>
        </xsl:otherwise>
      </xsl:choose>

    </table>
    <xsl:call-template name="shim"/>
  </xsl:template>

    <xsl:template name="SuiteFonctDirectionCesse">

        <xsl:param name ="position"></xsl:param>
        <xsl:param name ="Max"></xsl:param>

        <xsl:if test ="$position &lt; $Max">

            <xsl:for-each select="/FIBEN/PERSONNE/MODULEOD/DIFFOD/DIRIGODS/DIRIGOD/DIRIGEANTOD[$position]">
                <xsl:if test ="/FIBEN/PERSONNE/MODULEOD/DIFFOD/DIRIGODS/DIRIGOD/DIRIGEANTOD[$position]/FONCTCOT/OD07">
                    <xsl:variable name ="IdentPPLeg" select="(PP/IDENTC)"></xsl:variable>
                    <xsl:if test="position() mod 9 = 0">
                        <div class="clBreakPage"></div>
                    </xsl:if>
                    <xsl:if test="position() = last()">
                        <table class="clWidth635 clBorderCell" role="presentation">
                            <tr>
                                <td class="clCouleur2 clWidth530 clHeight14" colspan="4">
                                    <br/>
                                    <xsl:value-of select="($dictionnaire/mot[@id='SUITEFDC'])"></xsl:value-of>
                                </td>
                                <td class="clWidth105 clHeight14 clValignMiddle clAlignRight">
                                    <a href="#nullepart" onClick="requestBDFInfos('56','','{$familyNumber}','{$IdentPPLeg}',cstSimpleConfirm);">
                                        <img src="{$root}images/Commun/clignotant2.gif" width="85" height="12" border="0" align="absbottom" alt="plus d'infos"/>
                                    </a>
                                </td>
                            </tr>
                        </table>
                        <xsl:call-template name="shim"/>
                    </xsl:if>
                    <xsl:call-template name ="SuiteFonctDirectionCesse">
                        <xsl:with-param name ="position" select ="$Max"></xsl:with-param>
                        <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
                    </xsl:call-template>
                </xsl:if >
                <xsl:call-template name ="SuiteFonctDirectionCesse">
                    <xsl:with-param name ="position" select ="$position + 1"></xsl:with-param>
                    <xsl:with-param name ="Max" select ="$Max"></xsl:with-param>
                </xsl:call-template>

            </xsl:for-each>
        </xsl:if>
    </xsl:template>

  <!-- ***********************************  PARTIE ASSOCIE(S) ************************************************** -->
  <xsl:template match="ASSOCOD">
    <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEOD/DIFFOD/ASSOCOD/NBASSOCOD"/>
    <xsl:apply-templates select="ASSOCIEOD"/>
  </xsl:template>

  <xsl:template match="ASSOCIEOD">
    <xsl:apply-templates select="CAPITAL">
      <xsl:with-param name="indice" select="position()"/>
    </xsl:apply-templates>
    <xsl:apply-templates select="ASSOCSPE|ASSOCPP|ASSOCEJ"/>
  </xsl:template>

  <xsl:template match="OD08">
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr class="clAlignLeft">
        <td class="clCouleur2">
          <xsl:value-of select="($dictionnaire/mot[@id='OD08'])"></xsl:value-of>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
  </xsl:template>

  <xsl:template match="NBASSOCOD">
    <xsl:variable name ="nbAssocies" select ="count(/FIBEN/PERSONNE/MODULEOD/DIFFOD/ASSOCOD/ASSOCIEOD)"></xsl:variable>
    <a name="ancAssoc"></a>
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
         <td class="clWidth19">&#160;</td>
        <td class="clCouleurGras clAlignCenter clWidth597">
          PRINCIPAL(AUX) ASSOCI(S) (<xsl:value-of select="."/>)
        </td>
         <td class="clWidth19">
          <xsl:if test="$condGraph1">
            <a href="#nullepart" onclick="window.document.forms['FormGraphes'].action='Graphes.aspx#Graphe1';window.document.forms	['FormGraphes'].submit();">
              <img title="Graphique" alt="Graphique" border="0" height="20" name="dia2" src="{$root}Images/risque/diagramme_bleu.gif" width="19"/>
            </a>
          </xsl:if>
          <xsl:if test="$condGraph1!='true'">
            <img src="{$root}Images/boutons/diagramme_in.gif" width="19" height="20" border="0" title="Graphique" alt="Graphique" />
          </xsl:if>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
  </xsl:template>

  <xsl:template match="ASSOCSPE">
    <table class="clWidth636 clBorderCell">
      <caption class="visually-hidden">Associ(s) spcial(aux)</caption>
      <tr class="clAlignLeft clValignMiddle">
        <td class="clTexte clWidth130">
          &#160;<xsl:value-of select="DENOM"/>
        </td>
        <td class="clWidth182"></td>
        <td class="clWidth80"></td>
       <td class="clWidth118"></td>
        <td class="clWidth95"></td>
      </tr>
      <tr>
        <td colspan="4" >
          &#160;
        </td>
        <td class="clWidth95">
          &#160;
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
  </xsl:template>

  <xsl:template match="ASSOCPP">
    <table class="clWidth636 clBorderCell">
      <caption class="visually-hidden">Associ personne physique</caption>
      <tr>
       <td colspan="2" class="clTexte clWidth312">
          &#160;<xsl:call-template name ="displayInLowerCaseXsl">
            <xsl:with-param name ="InputStringNom" select ="(PP/IDENTITE/NOM)"/>
            <xsl:with-param name ="InputStringPrenom" select ="(PP/IDENTITE/PRENOM)"/>
          </xsl:call-template>
        </td>
        <xsl:if test="PP/IDENTITE/NOMCONJ">
          <th class="clCouleur2 clWidth80 clAlignLeft clThNonGras">&#160;Nom marital</th>
          <td class="clTexte clWidth213" colspan="2">
            &#160;<xsl:value-of select="PP/IDENTITE/NOMCONJ"/>
          </td>
        </xsl:if>
        <xsl:if test="not(PP/IDENTITE/NOMCONJ)">
          <td class="clCouleur2 clWidth80">&#160;</td>
          <td class="clTexte clWidth213" colspan="2">&#160;</td>
        </xsl:if>
      </tr>
      <xsl:choose>
        <xsl:when test ="AUTRFDEI">
          <tr class="clValignMiddle">
            <th class="clCouleur2 clWidth130 clAlignLeft clThNonGras">&#160;Identifiant </th>
            <td class="clFond clWidth182 clAlignLeft">
              &#160;<xsl:value-of select="PP/IDENTC"/>
            </td>
            <xsl:if test="not(VALCOT='NS')">
              <th class="clCouleur2 clWidth80 clAlignLeft clThNonGras">&#160;Indicateur</th>
              <xsl:if test="not(VALCOT='ND')">
                <td class="clFond clWidth118 clAlignLeft">
                  &#160;<a href="#nullepart" class="clFond" onclick="requestVariousInfos('{VALCOT}',cstCotation,'{PP/IDENTC}');">
                    <u>
                      <xsl:value-of select="VALCOT"/>
                    </u>
                  </a>
                </td>
              </xsl:if>
              <xsl:if test="(VALCOT='ND')">
                <td class="clFond clWidth118 clAlignLeft">
                  &#160;<a href="#nullepart" class="clFond" onclick="requestVariousInfos('{VALCOT}',cstCotationNonDif,'{PP/IDENTC}');">
                    <u>
                      <xsl:value-of select="VALCOT"/>
                    </u>
                  </a>
                </td>
              </xsl:if>              
              <td class="clFond clWidth95 clAlignRight">
                <a href="#nullepart" onClick="requestBDFInfos('27|37|53|56|','','{$familyNumber}','{PP/IDENTC}',cstMultipleConfirm);">
                  <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                </a>
              </td>
            </xsl:if>
            <xsl:if test="(VALCOT='NS')">
              <td class="clFond clWidth80" ></td>
              <td class="clFond clWidth118"></td>
              <td class="clFond clWidth95 clAlignRight">
                <a href="#nullepart" onClick="requestBDFInfos('27','','1','{PP/IDENTC}',cstMultipleConfirm);">
                  <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                </a>
              </td>
            </xsl:if>
          </tr>
          <tr>
            <td class="clTexte clAlignLeft" colspan="4">
                <xsl:value-of select="($dictionnaire/mot[@id='AUTRFDEI'])"></xsl:value-of>
            </td>
            <td class="clWidth95">
              &#160;
            </td>
          </tr>
        </xsl:when>
        <xsl:otherwise>
          <tr class="clValignMiddle">
            <th class="clCouleur2 clWidth130 clAlignLeft clThNonGras">&#160;Identifiant </th>
            <td class="clFond clWidth182 clAlignLeft">
              &#160;<xsl:value-of select="PP/IDENTC"/>
            </td>
            <xsl:if test="not(VALCOT='NS')">
              <th class="clCouleur2 clWidth80 clAlignLeft clThNonGras">&#160;Indicateur</th>
              <xsl:if test="not(VALCOT='ND')">
                <td class="clFond clWidth118 clAlignLeft">
                  &#160;<a href="#nullepart" class="clFond" onclick="requestVariousInfos('{VALCOT}',cstCotation,'{PP/IDENTC}');">
                    <u>
                      <xsl:value-of select="VALCOT"/>
                    </u>
                  </a>
                </td>
              </xsl:if>
              <xsl:if test="(VALCOT='ND')">
                <td class="clFond clWidth118 clAlignLeft">
                  &#160;<a href="#nullepart" class="clFond" onclick="requestVariousInfos('{VALCOT}',cstCotationNonDif,'{PP/IDENTC}');">
                    <u>
                      <xsl:value-of select="VALCOT"/>
                    </u>
                  </a>
                </td>
              </xsl:if>             
              <td class="clFond clWidth95 clAlignRight">
                <a href="#nullepart" onClick="requestBDFInfos('27|37|53|','','{$familyNumber}','{PP/IDENTC}',cstMultipleConfirm);">
                  <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                </a>
              </td>
            </xsl:if>
            <xsl:if test="(VALCOT='NS')">
              <td class="clFond clWidth80" ></td>
              <td class="clFond clWidth118"></td>
              <td class="clFond clWidth95 clAlignRight">
                <a href="#nullepart" onClick="requestBDFInfos('27','','1','{PP/IDENTC}',cstMultipleConfirm);">
                  <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                </a>
              </td>
            </xsl:if>
          </tr>
          <tr>
            <td class="clTexteGras clAlignLeft" colspan="4">
              &#160;
            </td>
            <td class="clWidth95">
              &#160;
            </td>
          </tr>
        </xsl:otherwise>
      </xsl:choose>
    </table>
    <xsl:call-template name="shim"/>
  </xsl:template>

  <xsl:template match="ASSOCEJ">
    <table class="clWidth636 clBorderCell">
      <caption class="visually-hidden">Associ entit juridique</caption>
      <tr>
        <td class="clTexte clWidth638 clHeight14" colspan="5">
          &#160;<xsl:value-of select="EJ/DENOM"/>
        </td>
      </tr>
      <tr>
        <td class="clFond clWidth638" colspan="5">
          &#160;<xsl:value-of select="LOCALI"/>
        </td>
      </tr>
    </table>
    <xsl:if test="not(SEGMENT)">
      <table class="clWidth636 clBorderCell">
        <tr>
          <xsl:variable name="locali" select="LOCALI"></xsl:variable>
          <xsl:choose>
            <!--Test si le dbut de la localit est un code postal -> Rsident ou non-->
            <xsl:when test="(number(substring(LOCALI,0,5)) or ($locali='MC MONACO'))">
              <th class="clCouleur2 clWidth130 clAlignLeft clThNonGras">&#160;Identifiant </th>
              <td class="clTexte clWidth182 clAlignLeft">
                &#160;<xsl:call-template name ="displaySirenXsl">
                  <xsl:with-param name ="InputSiren" select ="(EJ/IDENTS)"/>
                </xsl:call-template>
              </td>
              <th class="clCouleur2 clWidth80 clAlignLeft clThNonGras">&#160;Cotation</th>
              <xsl:if test="not(VALCOT='ND')">
                <td class="clTexte clWidth118 clAlignLeft">
                  &#160;<a href="#nullepart" class="clTexte" onclick="requestVariousInfos('{VALCOT}',cstCotation,'{EJ/IDENTS}');">
                    <u>
                      <xsl:value-of select="VALCOT"/>
                    </u>
                  </a>
                </td>
              </xsl:if>
              <xsl:if test="(VALCOT='ND')">
                <td class="clTexte clWidth118 clAlignLeft">
                  &#160;<a href="#nullepart" class="clTexte" onclick="requestVariousInfos('{VALCOT}',cstCotationNonDif,'{EJ/IDENTS}');">
                    <u>
                      <xsl:value-of select="VALCOT"/>
                    </u>
                  </a>
                </td>
              </xsl:if>              
              <td class="clTexte clWidth95 clAlignRight">
                <a href="#nullepart" onClick="requestBDFInfos('27|37|53|','','{$familyNumber}','{EJ/IDENTS}',cstMultipleConfirm);">
                  <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                </a>
              </td>
            </xsl:when>
            <xsl:otherwise>
              <th class="clCouleur2 clWidth130 clAlignLeft clThNonGras">&#160;Identifiant </th>
              <td class="clTexte clWidth182 clAlignLeft">
                &#160;<xsl:call-template name ="displaySirenXsl">
                  <xsl:with-param name ="InputSiren" select ="(EJ/IDENTS)"/>
                </xsl:call-template>
              </td>
              <td class="clCouleur2 clWidth80 clAlignLeft">&#160;</td>
              <td class="clTexte clWidth118 clAlignLeft"></td>
              <td class="clTexte clWidth95 clAlignRight">
                <a href="#nullepart" onClick="requestBDFInfos('27','','{$familyNumber}','{EJ/IDENTS}',cstSimpleConfirm);">
                  <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                </a>
              </td>
            </xsl:otherwise>
          </xsl:choose>
        </tr>
        <tr>
          <td colspan="4" >
            &#160;
          </td>
          <td class="clWidth95">
            &#160;
          </td>
        </tr>
      </table>
    </xsl:if>
    <xsl:if test="SEGMENT">
      <table class="clWidth636 clBorderCell" role="presentation">
        <tr>
          <xsl:variable name="locali" select="LOCALI"></xsl:variable>
          <xsl:choose>
            <!--Test si le dbut de la localit est un code postal -> Rsident ou non-->
            <xsl:when test="(number(substring(LOCALI,0,5)) or ($locali='MC MONACO'))">
              <th class="clCouleur2 clWidth130 clAlignLeft clThNonGras">&#160;Identifiant </th>
              <td class="clTexte clWidth107 clAlignLeft">
                &#160;<xsl:call-template name ="displaySirenXsl">
                  <xsl:with-param name ="InputSiren" select ="(EJ/IDENTS)"/>
                </xsl:call-template>
              </td>
              <th class="clCouleur2 clWidth155 clAlignLeft clThNonGras">&#160;Cotation | Segmentation</th>
              <xsl:if test="not(VALCOT='ND')">
                <td class="clTexte clWidth118 clAlignLeft">
                  &#160;<a href="#nullepart" class="clTexte" onclick="requestVariousInfos('{VALCOT}',cstCotation,'{EJ/IDENTS}');">
                    <u>
                      <xsl:value-of select="VALCOT"/>
                    </u>
                  </a><a href="#nullepart" class="clTexte" onclick="requestInfosLibelle('segmentation',cstSegment);">
                    &#160;|&#160;<u>
                      <xsl:value-of select="SEGMENT"/>
                    </u>
                  </a>
                </td>
              </xsl:if>
              <xsl:if test="(VALCOT='ND')">
                <td class="clTexte clWidth118 clAlignLeft">
                  &#160;<a href="#nullepart" class="clTexte" onclick="requestVariousInfos('{VALCOT}',cstCotationNonDif,'{EJ/IDENTS}');">
                    <u>
                      <xsl:value-of select="VALCOT"/>
                    </u>
                  </a><a href="#nullepart" class="clTexte" onclick="requestInfosLibelle('segmentation',cstSegment);">
                    &#160;|&#160;<u>
                      <xsl:value-of select="SEGMENT"/>
                    </u>
                  </a>
                </td>
              </xsl:if>              
              <td class="clTexte clWidth95 clAlignRight">
                <a href="#nullepart" onClick="requestBDFInfos('27|37|39|53|','','{$familyNumber}','{EJ/IDENTS}',cstMultipleConfirm);">
                  <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                </a>
              </td>
            </xsl:when>
            <xsl:otherwise>
              <th class="clCouleur2 clWidth130 clAlignLeft clThNonGras">&#160;Identifiant </th>
              <td class="clTexte clWidth107 clAlignLeft">
                &#160;<xsl:call-template name ="displaySirenXsl">
                  <xsl:with-param name ="InputSiren" select ="(EJ/IDENTS)"/>
                </xsl:call-template>
              </td>
              <td class="clCouleur2 clWidth155 clAlignLeft">&#160;</td>
              <td class="clTexte clWidth118 clAlignLeft"></td>
              <td class="clTexte clWidth95 clAlignRight">
                <a href="#nullepart" onClick="requestBDFInfos('27|','','{$familyNumber}','{EJ/IDENTS}',cstMultipleConfirm);">
                  <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                </a>
              </td>
            </xsl:otherwise>
          </xsl:choose>
        </tr>
        <tr>
          <td colspan="4" >
            &#160;
          </td>
          <td class="clWidth95">
            &#160;
          </td>
        </tr>
      </table>
    </xsl:if>
    <xsl:call-template name="shim"/>
  </xsl:template>

  <xsl:template match="CAPITAL">
    <xsl:param name="indice"/>
    <table class="clWidth742 clBorderCell">
      <caption class="visually-hidden">Pourcentage dtenu par l'associ</caption>
      <tr>
        <th class="clCouleur2 clWidth130 clAlignLeft clThNonGras">&#160;Pourcentage dtenu</th>
        <td class="clFond clWidth182">
          &#160;<xsl:value-of select="POURCENTAGE"/>
        </td>
         <td class="clFond clWidth80">&#160;</td>
        <xsl:if test="DATDET">
          <th class="clFond clWidth118 clAlignRight clThNonGras">&#160;Depuis le</th>
          <td class="clFond clAlignRight clWidth95">
            <xsl:call-template name ="displayDateXsl">
              <xsl:with-param name ="InputDate" select ="(DATDET)"/>
            </xsl:call-template>&#160;
          </td>
        </xsl:if>
        <xsl:if test="not(DATDET)">
          <td class="clFond clWidth118 clAlignRight">&#160;</td>
          <td class="clFond clAlignRight clWidth95">&#160;</td>
        </xsl:if>
        <xsl:if test="$indice mod 3 = 0">
          <td class="clWidth103 clAlignRight">
            <a href="#ancHaut">
              <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page" />
            </a>
          </td>
        </xsl:if>
        <xsl:if test="$indice mod 3 != 0">
          <td class="clWidth103 clAlignRight">
            &#160;
          </td>
        </xsl:if>
      </tr>
    </table>
  </xsl:template>

  <!-- ***********************************  PARTIE PARTICIPATION(S) ************************************************** -->
  <xsl:template match="OD09">
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr class="clAlignLeft">
        <td class="clCouleur2">
          <xsl:value-of select="($dictionnaire/mot[@id='OD09'])"></xsl:value-of>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
  </xsl:template>
  
  <xsl:template match="PARTOD">
       <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEOD/DIFFOD/PARTOD/NBPARTICIPATION"/>     
        <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEOD/DIFFOD/PARTOD/PARTICIPATION"/>
        <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEOD/DIFFOD/PARTOD/AUTRFDPP"/>
        <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEOD/DIFFOD/PARTOD/AUTRFDEI"/>
      <xsl:if test ="/FIBEN/PERSONNE/MODULEOD/DIFFOD/PARTOD/SUITEP">
        <xsl:call-template name ="SuiteParticipation">
          <xsl:with-param name ="position"></xsl:with-param>
        </xsl:call-template>
      </xsl:if>
  </xsl:template>

  <xsl:template match="NBPARTICIPATION">
   <a name="ancPartic"></a>
   <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
         <td class="clWidth19">&#160;</td>
        <td class="clCouleurGras clAlignCenter clWidth597">
          PRINCIPALE(S) PARTICIPATION(S) (<xsl:value-of select="."/>)
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/> 
  </xsl:template>

  <xsl:template match="PARTICIPATION">
    <xsl:variable name="actbdf" select="ACTBDF"/>  
    <table class="clBorderCell clWidth739">
      <caption class="visually-hidden">Pourcentage dtenu par la(les) principale(s) participation(s)</caption>
      <tr>
        <th class="clCouleur2 clWidth130 clAlignLeft clThNonGras">&#160;Pourcentage d&#233;tenu</th>
        <td class="clFond clWidth107">
          &#160;<xsl:value-of select="CAPITAL/POURCENTAGE"/>
        </td>
        <td class="clFond clWidth155">&#160;</td>
        <xsl:if test="CAPITAL/DATDET">
          <th class="clFond clAlignRight clWidth148 clThNonGras">Depuis le</th>
          <td class="clFond clAlignRight clWidth95">
            <xsl:call-template name ="displayDateXsl">
              <xsl:with-param name ="InputDate" select ="(CAPITAL/DATDET)"/>
            </xsl:call-template>&#160;
          </td>
        </xsl:if>
        <xsl:if test="not(CAPITAL/DATDET)">
          <td class="clFond clAlignRight clWidth148">&#160;</td>
          <td class="clFond clAlignRight clWidth95">&#160;</td>
        </xsl:if>
        <xsl:if test="position() mod 3 = 0">
         <td class="clWidth103 clAlignRight" rowspan="4">
            <a href="#ancHaut">
              <img src="{$root}Images/{$familyName}/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page" />
            </a>
          </td>
        </xsl:if>
        <xsl:if test="position() mod 3 != 0">
         <td class="clWidth103 clAlignRight" rowspan="4">
            &#160;
          </td>
        </xsl:if>
        </tr>
    </table>

    <table class="clWidth635 clBorderCell" role="presentation">
     <tr class="clAlignLeft clValignMiddle">
         <td class="clTexte clWidth130">
          &#160;<xsl:value-of select="EJ/DENOM"/>
        </td>
      </tr>
    </table>

    <table class="clWidth635 clBorderCell">
      <caption class="visually-hidden">Activit BDF de(s) la(les) principale(s) participation(s)</caption>
      <tr>
        <td class="clFond clWidth312" colspan="2">
          &#160;<xsl:value-of select="LOCALI"/>
        </td>
        <th class="clCouleur2 clWidth80 clAlignLeft clThNonGras">&#160;Activit&#233; BDF</th>
        <td class="clFond clWidth243" colspan="2">
          <a href="#nullepart" class="clTexte" onclick="requestInfosLibelle('{$actbdf}',cstWordingNew)" >
            <u>
              <xsl:value-of select="ACTBDF"/>
            </u>
          </a>
        </td>
      </tr>
    </table>

    <xsl:if test="not(SEGMENT)">
      <table class="clWidth635 clBorderCell" role="presentation">
        <tr>
           <th class="clCouleur2 clWidth130 clAlignLeft clThNonGras">&#160;Identifiant</th>
          <td class="clTexte clWidth182">
            &#160;<xsl:call-template name ="displaySirenXsl">
              <xsl:with-param name ="InputSiren" select ="(EJ/IDENTS)"/>
            </xsl:call-template>
          </td>
          <xsl:variable name="locali" select="LOCALI"></xsl:variable>
          <xsl:choose>
            <!--Test si le dbut de la localit est un code postal -> Rsident ou non-->
            <xsl:when test="(number(substring(LOCALI,0,5)) or ($locali='MC MONACO'))">
              <th class="clCouleur2 clWidth80 clAlignLeft clThNonGras">&#160;Cotation</th>
              <xsl:if test="not(VALCOT='ND')">
                <td class="clTexte clWidth148">
                  &#160;<a href="#nullepart" class="clTexte" onclick="requestVariousInfos('{VALCOT}',cstCotation,'{EJ/IDENTS}');">
                    <u>
                      <xsl:value-of select="VALCOT"/>
                    </u>
                  </a>
                </td>
              </xsl:if>
              <xsl:if test="(VALCOT='ND')">
                <td class="clTexte clWidth148">
                  &#160;<a href="#nullepart" class="clTexte" onclick="requestVariousInfos('{VALCOT}',cstCotationNonDif,'{EJ/IDENTS}');">
                    <u>
                      <xsl:value-of select="VALCOT"/>
                    </u>
                  </a>
                </td>
              </xsl:if>  
              <td class="clTexte clWidth95 clAlignRight">
                <a href="#nullepart" onClick="requestBDFInfos('27|37|53|','','{$familyNumber}','{EJ/IDENTS}',cstMultipleConfirm);">
                  <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                </a>
              </td>
            </xsl:when>
            <xsl:otherwise>
              <td class="clCouleur2 clWidth80 clAlignLeft">&#160;</td>
              <td class="clTexte clWidth148">&#160;</td>
              <td class="clTexte clWidth95 clAlignRight">
                <a href="#nullepart" onClick="requestBDFInfos('27','','{$familyNumber}','{EJ/IDENTS}',cstSimpleConfirm);">
                  <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                </a>
              </td>
            </xsl:otherwise>
          </xsl:choose>
        </tr>
      </table>
    </xsl:if>

    <xsl:if test ="SEGMENT">
      <table class="clWidth635 clBorderCell" role="presentation">
        <tr>
           <th class="clCouleur2 clWidth130 clAlignLeft clThNonGras">&#160;Identifiant</th>
          <td class="clTexte clWidth107">
            &#160;<xsl:call-template name ="displaySirenXsl">
              <xsl:with-param name ="InputSiren" select ="(EJ/IDENTS)"/>
            </xsl:call-template>
          </td>
          <xsl:variable name="locali" select="LOCALI"></xsl:variable>
          <xsl:choose>
            <!--Test si le dbut de la localit est un code postal -> Rsident ou non-->
            <xsl:when test="(number(substring(LOCALI,0,5)) or ($locali='MC MONACO'))">
              <th class="clCouleur2 clWidth155 clAlignLeft clThNonGras">&#160;Cotation | Segmentation</th>
              <xsl:if test="not(VALCOT='ND')">
                <td class="clTexte clWidth148">
                  &#160;<a href="#nullepart" class="clTexte" onclick="requestVariousInfos('{VALCOT}',cstCotation,'{EJ/IDENTS}');">
                    <u>
                      <xsl:value-of select="VALCOT"/>
                    </u>
                  </a>&#160;|&#160;
                  <a href="#nullepart" class="clTexte" onclick="requestInfosLibelle('segmentation',cstSegment)">
                    <u>
                      <xsl:value-of select="SEGMENT"/>
                    </u>
                  </a>
                </td>
              </xsl:if>
              <xsl:if test="(VALCOT='ND')">
                <td class="clTexte clWidth148">
                  &#160;<a href="#nullepart" class="clTexte" onclick="requestVariousInfos('{VALCOT}',cstCotationNonDif,'{EJ/IDENTS}');">
                    <u>
                      <xsl:value-of select="VALCOT"/>
                    </u>
                  </a>&#160;|&#160;
                  <a href="#nullepart" class="clTexte" onclick="requestInfosLibelle('segmentation',cstSegment)">
                    <u>
                      <xsl:value-of select="SEGMENT"/>
                    </u>
                  </a>
                </td>
              </xsl:if>              
              <td class="clTexte clWidth95 clAlignRight">
                <a href="#nullepart" onClick="requestBDFInfos('27|37|39|53|','','{$familyNumber}','{EJ/IDENTS}',cstMultipleConfirm);">
                  <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                </a>
              </td>
            </xsl:when>
            <xsl:otherwise>
              <td class="clCouleur2 clWidth155">&#160;</td>
              <td class="clTexte clWidth148">&#160;&#160;&#160;</td>
              <td class="clTexte clWidth95 clAlignRight">
                <a href="#nullepart" onClick="requestBDFInfos('27','','{$familyNumber}','{EJ/IDENTS}',cstSimpleConfirm);">
                  <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                </a>
              </td>
            </xsl:otherwise>
          </xsl:choose>
        </tr>
      </table>
    </xsl:if>
    <xsl:call-template name="shim"/>
  </xsl:template>

  <xsl:template match="AUTRFDPP">
    <table class="clWidth635 clBorderCell clCouleur2" role="presentation">
      <tr>
        <td class="clWidth532 clAlignLeft">
          <!--Prsence de fonction de reprsentant(s) lgal(aux) dans une/des socit(s)-->
          <xsl:value-of select="($dictionnaire/mot[@id='AUTRFDPP'])"/>
        </td>

        <td class="clWidth103 clAlignRight">
          <a href="#nullepart" onclick="requestBDFInfos('56','','','',cstSimpleConfirm);">
            <img border="0" height="12" src="{$root}images/Commun/clignotant2.gif" width="90" alt="plus d'infos"/>
          </a>
        </td>
      </tr>

    </table>
    <xsl:call-template name="shim"/>
    <br/>
  </xsl:template>

  <xsl:template match="AUTRFDEI">
    <table class="clWidth635 clBorderCell clCouleur2" role="presentation">
      <tr>
        <td class="clWidth532 clAlignLeft">
          <!--Prsence d&#039;autre(s) fonction(s) de reprsentant(s) lgal(aux) exerce(s)-->
          <xsl:value-of select="($dictionnaire/mot[@id='AUTRFDEI'])"/>
        </td>

        <td class="clWidth103 clAlignRight">
          <a href="#nullepart" onclick="requestBDFInfos('56','','','',cstSimpleConfirm);">
            <img border="0" height="12" src="{$root}images/Commun/clignotant2.gif" width="90" alt="plus d'infos"/>
          </a>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
  </xsl:template>
  
  <xsl:template name="SuiteParticipation">
      <xsl:if test="position() mod 9 = 0">
        <div class="clBreakPage"></div>
      </xsl:if>
      <xsl:if test="position() = last()">
        <table class="clWidth635 clBorderCell" role="presentation">
          <tr>
            <td class="clCouleur2 clWidth530 clHeight14" colspan="4">
              <br/>
              <xsl:value-of select="($dictionnaire/mot[@id='SUITEP'])"></xsl:value-of>
            </td>
            <td class="clWidth105 clHeight14 clValignMiddle clAlignRight">
              <a href="#nullepart" onClick="requestBDFInfos('53','','{$familyNumber}','{EJ/IDENTS}',cstSimpleConfirm);">
                <img src="{$root}images/Commun/clignotant2.gif" width="85" height="12" border="0" align="absbottom" alt="plus d'infos"/>
              </a>
            </td>
          </tr>
        </table>
        <xsl:call-template name="shim"/>
      </xsl:if>
    </xsl:template>
  
  <xsl:template name="genGraphOD">
    <xsl:if test="$condGraph1">
      <form action="Graphes.aspx" method="post" name="FormGraphes" target="_blank">
        <input name="familyNumber" type="hidden" value="{$familyNumber}"/>
        <input name="moduleNumber" type="hidden" value="{/FIBEN/@MODDEM}"/>
        <xsl:element name="input">
          <xsl:attribute name="name">GrapheData</xsl:attribute>
          <xsl:attribute name="type">hidden</xsl:attribute>
          <xsl:attribute name="value">
            &lt;FIBEN MODDEM=&quot;<xsl:value-of select="FIBEN/@MODDEM"/>&quot; DATJOUR=&quot;<xsl:call-template name ="displayDateForGraph2">
              <xsl:with-param name ="InputDateForGraph" select ="FIBEN/@DATJOUR"/>
            </xsl:call-template>&quot; GRAPHE=&quot;1&quot;&gt;&lt;ident&gt;<xsl:value-of select="FIBEN/PERSONNE/MODULEOD/EJ/IDENTS"/>&lt;/ident&gt;&lt;nom&gt;<xsl:value-of select="FIBEN/PERSONNE/MODULEOD/EJ/DENOM"/>&lt;/nom&gt;&lt;valcot&gt;<xsl:value-of select="FIBEN/PERSONNE/MODULEOD/DIFFOD/VALCOT"/>&lt;/valcot&gt;&lt;segment&gt;<xsl:value-of select="FIBEN/PERSONNE/MODULEOD/DIFFOD/SEGMENT"/>&lt;/segment&gt;&lt;datcot&gt;<xsl:value-of select="FIBEN/PERSONNE/MODULEOD/DIFFOD/DATCOT"/>&lt;/datcot&gt;&lt;datexa&gt;<xsl:value-of select="FIBEN/PERSONNE/MODULEOD/DIFFOD/DATEXA"/>&lt;/datexa&gt;&lt;graphe&gt;&lt;serie&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULEOD/DIFFOD/ASSOCOD/ASSOCIEOD">
              &lt;val&gt;<xsl:value-of select="CAPITAL/POURCENTAGE"/>&lt;/val&gt;
            </xsl:for-each>&lt;/serie&gt;&lt;abcisse&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULEOD/DIFFOD/ASSOCOD/ASSOCIEOD">
              &lt;val&gt;<xsl:if test="ASSOCEJ/EJ">
                <xsl:value-of select="concat(ASSOCEJ/EJ/IDENTS,'     - ',ASSOCEJ/EJ/DENOM)"/>
              </xsl:if><xsl:if test="ASSOCPP/PP">
                <xsl:call-template name ="displayInLowerCaseXsl">
                  <xsl:with-param name ="InputIdentc" select ="(ASSOCPP/PP/IDENTC)"/>
                  <xsl:with-param name ="InputStringNom" select ="(ASSOCPP/PP/IDENTITE/NOM)"/>
                  <xsl:with-param name ="InputStringPrenom" select ="(ASSOCPP/PP/IDENTITE/PRENOM)"/>
                </xsl:call-template>
              </xsl:if><xsl:if test="ASSOCSPE/DENOM">
                <xsl:value-of select="concat('              - ',ASSOCSPE/DENOM)"/>
              </xsl:if>&lt;/val&gt;
            </xsl:for-each>&lt;/abcisse&gt;&lt;titre&gt;Rpartition du capital entre les associs (en pourcentage)&lt;/titre&gt;&lt;/graphe&gt;&lt;/FIBEN&gt;
          </xsl:attribute>
        </xsl:element>
      </form>
    </xsl:if>
  </xsl:template>

  
</xsl:stylesheet>
