﻿Imports System.IO
Imports System.Web.UI.DataVisualization.Charting

Partial Class modules_mOD_graphiques_Graphe1
    Inherits System.Web.UI.Page

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load

        Const nbSeries As Integer = 1
        Const nbValues As Integer = 10 '11

        Dim sTitles(2) As String
        sTitles(0) = "Répartition du capital entre les associés (en pourcentage)" 'titre principal
        sTitles(1) = "" 'Titre des abcisses
        sTitles(2) = "" 'Titre des ordonnées

        Using oGraphique As New NewGraphique(Context, nbSeries, nbValues)
            Using imgStream As New MemoryStream()
                oGraphique.QueryStringToDataTable()
                'maj espaces legende associés
                For Each r As DataRow In oGraphique.data.Rows
                    If Not (IsDBNull(r("Abs"))) Then
                        Dim s As String = r("Abs")
                        If s.Chars(13) = "-" Then
                            r("Abs") = Replace(s, "-", " - ", 1, 1)
                        End If
                    End If
                Next
                ' Ajout valeur pour derniere legende et valeur si total < 100
                Dim sum = oGraphique.data.AsEnumerable().Sum(Function(x) x.Field(Of Double)("Col1"))
                If (oGraphique.data(nbValues - 1)("Col1") = 0) AndAlso sum < 100 Then
                    oGraphique.data(nbValues - 1)("Abs") = "              - Autres associés"
                    oGraphique.data(nbValues - 1)("Col1") = 100 - sum
                End If

                oGraphique.CreatePieGraphImage(sTitles).SaveImage(imgStream, ChartImageFormat.Png)
                'Output the contents of the watermarked image stream
                Response.ContentType = "image/png"
                Response.BinaryWrite(imgStream.GetBuffer())
            End Using
        End Using
    End Sub
End Class
