﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                xmlns:bdf="http://banque-france.fr/namespace">
	<xsl:import href="../../Ressources/XSL/Commun.xsl"/>
	<xsl:import href="../../Ressources/XSL/commun_transfo.xsl"/>
	<xsl:output method="html"
	            version="1.1"
	            encoding="ISO-8859-1"
	            indent="yes"/>
	<xsl:param name="langage"
	           select="'fr'"/>
	<xsl:param name="root"
	           select="'/Fiben/'"/>
	<xsl:param name="familyNumber"
	           select="''"/>
	<xsl:param name="familyName"
	           select="''"/>
	<xsl:param name="familyTitle"
	           select="''"/>
	<xsl:param name="nextModule"
	           select="''"/>
	<xsl:param name="nextId"
	           select="''"/>
	<xsl:param name="nextFamily"
	           select="''"/>
	<xsl:param name="menuHTML1"/>
	<xsl:param name="Lang"
	           select="'FR'"/>
	<xsl:param name="codeLib"
	           select="''"/>
	<xsl:param name="NonResident"
	           select="''"/>
	<xsl:param name="titleUK"
	           select="''"/>
	<!--TEMPLATE PRINCIPAL-->
	<xsl:template match="/">
		<html lang="fr">
			<title>Module DE - Dossier Découverte</title>
			<xsl:call-template name="genHead">
				<xsl:with-param name="ident"
				                select="FIBEN/ERREUR/IDENT | /FIBEN/PERSONNE/MODULEDE/*//IDENTC|/FIBEN/PERSONNE/MODULEDE/*//IDENTS"/>
			</xsl:call-template>
			<body class="clBodybgcolorWhite">
				<xsl:call-template name="genFondMenu">
					<xsl:with-param name="root"
					                select="$root"/>
				</xsl:call-template>
				<xsl:copy-of select="$menuHTML1"/>
				<table class="mainmodule horizontal-auto clBorderCell">
					<caption class="visually-hidden">Module DE - Dossier Découverte</caption>
					<xsl:call-template name="genLigneConfidentiel"/>
					<xsl:apply-templates select="/FIBEN/ERREUR"/>
					<xsl:if test="not(/FIBEN/ERREUR)">
						<tr>
							<td class="clWidth64"/>
							<td class="clCouleur2 clWidth739 clValingTop"
							    colspan="3">
								<!-- DIFFENT-30 Alain 03/2023-->
								<xsl:call-template name="genEnTete">
									<xsl:with-param name="ident"
									                select="/FIBEN/PERSONNE/MODULEDE/*//IDENTC|/FIBEN/PERSONNE/MODULEDE/*//IDENTS"/>
									<xsl:with-param name="nom">
										<xsl:if test="//MODULEDE/EJ/DENOM">
											<xsl:value-of select="//MODULEDE/EJ/DENOM"/>
										</xsl:if>
										<xsl:if test="//MODULEDE/EIPP/IDENTITE/NOM">
											<xsl:call-template name="displayInLowerCaseXsl">
												<xsl:with-param name="InputStringNom"
												                select="(//MODULEDE/EIPP/IDENTITE/NOM)"/>
												<xsl:with-param name="InputStringPrenom"
												                select="(//MODULEDE/EIPP/IDENTITE/PRENOM)"/>
											</xsl:call-template>
										</xsl:if>
									</xsl:with-param>
									<xsl:with-param name="nomconj"
									                select="//MODULEDE/EIPP/IDENTITE/NOMCONJ"/>
									<xsl:with-param name="valcot"
									                select="//INFOCOTATIONPM/VALCOT"/>
									<xsl:with-param name="segment">
										<xsl:if test="//INFOCOTATIONPM/SEGMENT">
											<xsl:value-of select="//INFOCOTATIONPM/SEGMENT"/>
										</xsl:if>
									</xsl:with-param>
									<xsl:with-param name="datcot"
									                select="//INFOCOTATIONPM/DATCOT"/>
									<xsl:with-param name="datexa"
									                select="//INFOCOTATIONPM/DATEXA"/>
									<xsl:with-param name="dateseg"
									                select="//INFOCOTATIONPM/DATESEGA"/>
									<xsl:with-param name="datsegrv"
									                select="//INFOCOTATIONPM/DATESEGR"/>
									<xsl:with-param name="idrenv"
									                select="//MODULEDE/EIPP/IDRENV"/>
									<xsl:with-param name="valindic"
									                select="//INFOCOTATIONPM/VALINDIC"/>
									<xsl:with-param name="datindic"
									                select="//INFOCOTATIONPM/DATINDIC"/>
									<xsl:with-param name="indexa2"
									                select="//INFOCOTATIONPM/DATEXAIN"/>
								</xsl:call-template>
								<xsl:apply-templates select="//INFOJURIDIQUES"/>
								<xsl:apply-templates select="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFOCOMPTABLESDO"/>
								<xsl:apply-templates select="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFOCOTATIONPM"/>
								<xsl:apply-templates select="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFODIRIGEANTS"/>
								<xsl:apply-templates select="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFOASSOCIES"/>
								<xsl:apply-templates select="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFOPARTICIPATIONS"/>
								<xsl:if test="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFOPARTICIPATIONS/SUITEP">
									<xsl:call-template name="SuiteParticipation"/>
								</xsl:if>
								<table class="clWidthMax clBorderCell"
								       role="presentation">
									<tr class="clHeight0">
										<td class="clWidth20"/>
										<td class="clWidth110"/>
										<td class="clWidth125"/>
										<td class="clWidth130"/>
										<td class="clWidth125"/>
										<td class="clWidth125"/>
									</tr>
								</table>
								<xsl:apply-templates select="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFOEVMEVJ"/>
								<xsl:call-template name="shim"/>
								<xsl:apply-templates select="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFOIMPAYESTRIM"/>
								<xsl:apply-templates select="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFORISQUESDO"/>
								<xsl:apply-templates select="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFORELBANC"/>
								<!-- appel partie Vitrine Bilan -->
								<xsl:if test="/FIBEN/PERSONNE/MODULEDE/DIFFDE/IST17">
									<xsl:apply-templates select="FIBEN/PERSONNE/MODULEDE/DIFFDE/IST17"
									                     mode="genLib"/>
								</xsl:if>
								<xsl:if test="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFOVB">
									<xsl:call-template name="genVB"/>
									<!-- tous modules sauf 66 et 67-->
									<xsl:if test="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFOVB/DONMODDO[../NUMMOD!=66 and ../NUMMOD!=67]">
										<xsl:call-template name="genVBtitre">
											<xsl:with-param name="titre"
											                select="'Données comptables sur base sociale'"/>
										</xsl:call-template>
										<xsl:call-template name="RechDateTableauVB">
											<xsl:with-param name="max"
											                select="count(//DONMODDO[../NUMMOD!=66 and ../NUMMOD!=67])"/>
											<xsl:with-param name="listeDateTest"
											                select="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFOVB/DONMODDO[../NUMMOD!=66 and ../NUMMOD!=67]/@DATCLOTV"/>
											<xsl:with-param name="listeDureeTest"
											                select="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFOVB/DONMODDO[../NUMMOD!=66 and ../NUMMOD!=67]/@DUREEEXV"/>
											<xsl:with-param name="dateClot1"
											                select="'129999'"/>
											<xsl:with-param name="dateClot2"
											                select="'128888'"/>
											<xsl:with-param name="dateClot3"
											                select="'127777'"/>
											<xsl:with-param name="dateDuree1"
											                select="'99'"/>
											<xsl:with-param name="dateDuree2"
											                select="'88'"/>
											<xsl:with-param name="dateDuree3"
											                select="'77'"/>
											<xsl:with-param name="n"
											                select="1"/>
											<xsl:with-param name="TypeTableau"
											                select="'Social'"/>
										</xsl:call-template>
									</xsl:if>
									<!-- uniquement modules 66 et 67-->
									<xsl:if test="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFOVB/DONMODDO[../NUMMOD=66 or ../NUMMOD=67]">
										<xsl:call-template name="genVBtitre">
											<xsl:with-param name="titre"
											                select="'Données comptables sur base consolidée'"/>
										</xsl:call-template>
										<xsl:call-template name="RechDateTableauVB">
											<xsl:with-param name="max"
											                select="count(//DONMODDO[../NUMMOD=66 or ../NUMMOD=67])"/>
											<xsl:with-param name="listeDateTest"
											                select="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFOVB/DONMODDO[../NUMMOD=66 or ../NUMMOD=67]/@DATCLOTV"/>
											<xsl:with-param name="listeDureeTest"
											                select="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFOVB/DONMODDO[../NUMMOD=66 or ../NUMMOD=67]/@DUREEEXV"/>
											<xsl:with-param name="dateClot1"
											                select="'129999'"/>
											<xsl:with-param name="dateClot2"
											                select="'128888'"/>
											<xsl:with-param name="dateClot3"
											                select="'127777'"/>
											<xsl:with-param name="dateDuree1"
											                select="'99'"/>
											<xsl:with-param name="dateDuree2"
											                select="'88'"/>
											<xsl:with-param name="dateDuree3"
											                select="'77'"/>
											<xsl:with-param name="n"
											                select="1"/>
											<xsl:with-param name="TypeTableau"
											                select="'Conso'"/>
										</xsl:call-template>
									</xsl:if>
									<xsl:call-template name="shim"/>
								</xsl:if>
								<xsl:apply-templates select="/FIBEN/PERSONNE/MODULEDE/DIFFDE/EJ"/>
								<xsl:apply-templates select="/FIBEN/PERSONNE/MODULEDE/DIFFDE/STECONSO"
								                     mode="genLib"/>
								<xsl:if test="/FIBEN/PERSONNE/MODULEDE/DIFFDE/AUTRFDEI">
									<xsl:call-template name="FONCDIR"/>
								</xsl:if>
							</td>
							<td class="clWidth103 clAlignRight"/>
						</tr>
					</xsl:if>
				</table>
				<xsl:call-template name="genBasPage"/>
			</body>
		</html>
	</xsl:template>
	<!--********************************************************************************************************************************************************************-->
	<!-- ***********************************  bloc INFORMATIONS JURIDIQUES ***************************************************************************************************************-->
	<!--********************************************************************************************************************************************************************-->
	<xsl:template match="INFOJURIDIQUES">
		<a name="ancJurid"/>
		<table class="clWidth635 clBorderCell"
		       role="presentation">
			<tr class="clAlignCenter">
				<td class="clCouleurGras">
					<xsl:call-template name="tradlib">
						<xsl:with-param name="Lang"
						                select="$Lang"/>
						<xsl:with-param name="codeLib"
						                select="'m27_InfJur'"/>
					</xsl:call-template>
				</td>
			</tr>
		</table>
		<xsl:call-template name="shim"/>
		<br/>
		<table class="clWidth635 clBorderCell">
			<caption class="visually-hidden">INFORMATIONS JURIDIQUES</caption>
			<tr>
				<th class="clCouleur2 clWidth130 clAlignLeft clThNonGras">
					<xsl:call-template name="tradlib">
						<xsl:with-param name="Lang"
						                select="$Lang"/>
						<xsl:with-param name="codeLib"
						                select="'m27_CatJur'"/>
					</xsl:call-template>
				</th>
				<td class="clFond"
				    colspan="3">
          &#160;<xsl:value-of select="CODECAT"/>&#160;&#160;&#160;<xsl:value-of select="CATJUR"/>
				</td>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth130 clAlignLeft clThNonGras">
					<xsl:call-template name="tradlib">
						<xsl:with-param name="Lang"
						                select="$Lang"/>
						<xsl:with-param name="codeLib"
						                select="'m27_ActBDF'"/>
					</xsl:call-template>
				</th>
				<td class="clTexte"
				    colspan="3">
          &#160;<xsl:value-of select="ACTBDF"/>&#160;&#160;
          <xsl:if test="$Lang = 'UK'">
						<xsl:call-template name="tradLibNaf">
							<xsl:with-param name="Lang"
							                select="$Lang"/>
							<xsl:with-param name="codelib"
							                select="ACTBDF"/>
						</xsl:call-template>
					</xsl:if>
					<xsl:if test="$Lang = 'FR'">
						<xsl:value-of select="LIBACT"/>
					</xsl:if>
				</td>
			</tr>
			<xsl:apply-templates select="CODNAF"/>
			<xsl:apply-templates select="p2051DA"/>
			<xsl:apply-templates select="ENSEIGNE"/>
			<xsl:if test="not(p2051DA) and not(ENSEIGNE) and DATCRE">
				<tr>
					<td class="clCouleur2 clWidth130">&#160;</td>
					<td class="clTexte clWidth305">&#160;</td>
					<xsl:apply-templates select="DATCRE"/>
				</tr>
			</xsl:if>
			<xsl:apply-templates select="SIGLE"/>
		</table>
		<xsl:if test="//IDLIES">
			<xsl:apply-templates select="//IDLIES"/>
			<xsl:if test="not(//HOMONYME)">
				<xsl:call-template name="shim"/>
			</xsl:if>
		</xsl:if>
		<xsl:if test="//HOMONYME">
			<xsl:apply-templates select="//HOMONYME"/>
		</xsl:if>
		<xsl:if test="not(//HOMONYME) and not(//IDLIES)">
			<xsl:call-template name="shim"/>
		</xsl:if>
	</xsl:template>
	<xsl:template match="CODNAF">
		<tr>
			<th class="clCouleur2 clWidth130 clAlignLeft clThNonGras">
				<xsl:call-template name="tradlib">
					<xsl:with-param name="Lang"
					                select="$Lang"/>
					<xsl:with-param name="codeLib"
					                select="'m27_CodeNaf'"/>
				</xsl:call-template>
			</th>
			<td class="clFond"
			    colspan="3">
        &#160;<xsl:value-of select="."/>&#160;&#160;
        <xsl:if test="$Lang = 'UK'">
					<xsl:call-template name="tradLibNaf">
						<xsl:with-param name="Lang"
						                select="$Lang"/>
						<xsl:with-param name="codelib"
						                select="."/>
					</xsl:call-template>
				</xsl:if>
				<xsl:if test="$Lang = 'FR'">
					<xsl:value-of select="../LIBNAF"/>
				</xsl:if>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="p2051DA">
		<tr>
			<th class="clCouleur2 clWidth130 clAlignLeft clThNonGras">
				<xsl:call-template name="tradlib">
					<xsl:with-param name="Lang"
					                select="$Lang"/>
					<xsl:with-param name="codeLib"
					                select="'m27_Cap'"/>
				</xsl:call-template>
			</th>
			<xsl:if test="../CODNAF">
				<td class="clTexte clWidth305">
					<xsl:if test="@ETAT">
            &#160;<xsl:value-of select="@ETAT"/>
					</xsl:if>
					<xsl:if test="not(@ETAT)">
            &#160;<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(.)"/>
						</xsl:call-template>&#160;<img height="9"
						     src="{$root}images/Commun/euro_symb_noir.png"
						     width="8"
						     alt="symbole euro"/>
					</xsl:if>
					<xsl:if test="../DATAG">
            &#160;
            <xsl:call-template name="tradlib">
							<xsl:with-param name="Lang"
							                select="$Lang"/>
							<xsl:with-param name="codeLib"
							                select="'m27_au'"/>
						</xsl:call-template>&#160;
            <xsl:call-template name="displayDateXsl">
							<xsl:with-param name="InputDate"
							                select="(../DATAG)"/>
						</xsl:call-template>
					</xsl:if>
				</td>
				<xsl:apply-templates select="../DATCRE"/>
				<xsl:if test="not(../DATCRE) and ../SIGLE[1]">
					<xsl:call-template name="SIGLEclTexte">
						<xsl:with-param name="titre">
							<xsl:call-template name="tradlib">
								<xsl:with-param name="Lang"
								                select="$Lang"/>
								<xsl:with-param name="codeLib"
								                select="'m27_Sigle'"/>
							</xsl:call-template>
						</xsl:with-param>
						<xsl:with-param name="sigle"
						                select="../SIGLE[1]"/>
					</xsl:call-template>
				</xsl:if>
			</xsl:if>
			<xsl:if test="not(../CODNAF)">
				<td class="clFond clWidth305">
					<xsl:if test="@ETAT">
            &#160;<xsl:value-of select="@ETAT"/>
					</xsl:if>
					<xsl:if test="not(@ETAT)">
            &#160;<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(.)"/>
						</xsl:call-template>&#160;<img height="9"
						     src="{$root}images/Commun/euro_symb_noir.png"
						     width="8"
						     alt="symbole euro"/>
					</xsl:if>
					<xsl:if test="../DATAG">
            &#160;
            <xsl:call-template name="tradlib">
							<xsl:with-param name="Lang"
							                select="$Lang"/>
							<xsl:with-param name="codeLib"
							                select="'m27_au'"/>
						</xsl:call-template>&#160;
            <xsl:call-template name="displayDateXsl">
							<xsl:with-param name="InputDate"
							                select="(../DATAG)"/>
						</xsl:call-template>
					</xsl:if>
				</td>
				<xsl:apply-templates select="../DATCRE"/>
				<xsl:if test="not(../DATCRE) and ../SIGLE[1]">
					<xsl:call-template name="SIGLEclFond">
						<xsl:with-param name="titre">
							<xsl:call-template name="tradlib">
								<xsl:with-param name="Lang"
								                select="$Lang"/>
								<xsl:with-param name="codeLib"
								                select="'m27_Sigle'"/>
							</xsl:call-template>
						</xsl:with-param>
						<xsl:with-param name="sigle"
						                select="../SIGLE[1]"/>
					</xsl:call-template>
				</xsl:if>
			</xsl:if>
		</tr>
	</xsl:template>
	<xsl:template match="ENSEIGNE">
		<tr>
			<xsl:if test="position()=1">
				<th class="clCouleur2 clWidth130 clAlignLeft clThNonGras">
					<xsl:call-template name="tradlib">
						<xsl:with-param name="Lang"
						                select="$Lang"/>
						<xsl:with-param name="codeLib"
						                select="'m27_Enseig'"/>
					</xsl:call-template>
				</th>
				<xsl:if test="(../CODNAF and ../p2051DA) or (not(../CODNAF) and not(../p2051DA))">
					<td class="clFond">
            &#160;<xsl:value-of select="."/>
					</td>
					<xsl:if test="not(../p2051DA)">
						<xsl:apply-templates select="../DATCRE"/>
					</xsl:if>
					<xsl:if test="((not(../p2051DA) and not(../DATCRE))or(../p2051DA and ../DATCRE))and ../SIGLE[1]">
						<xsl:call-template name="SIGLEclFond">
							<xsl:with-param name="titre">
								<xsl:call-template name="tradlib">
									<xsl:with-param name="Lang"
									                select="$Lang"/>
									<xsl:with-param name="codeLib"
									                select="'m27_Sigle'"/>
								</xsl:call-template>
							</xsl:with-param>
							<xsl:with-param name="sigle"
							                select="../SIGLE[1]"/>
						</xsl:call-template>
					</xsl:if>
					<xsl:if test="../p2051DA and not(../DATCRE) and ../SIGLE[2]">
						<xsl:call-template name="SIGLEclFond">
							<xsl:with-param name="sigle"
							                select="../SIGLE[2]"/>
						</xsl:call-template>
					</xsl:if>
				</xsl:if>
				<xsl:if test="(../CODNAF and not(../p2051DA)) or (not(../CODNAF) and ../p2051DA)">
					<td class="clTexte clWidth305">
            &#160;<xsl:value-of select="."/>
					</td>
					<xsl:if test="not(../p2051DA)">
						<xsl:apply-templates select="../DATCRE"/>
						<xsl:if test="not(../DATCRE)">
							<td class="clTexte clWidth200">&#160;</td>
						</xsl:if>
					</xsl:if>
					<xsl:if test="((not(../p2051DA) and not(../DATCRE))or(../p2051DA and ../DATCRE)) and ../SIGLE[1]">
						<xsl:call-template name="SIGLEclTexte">
							<xsl:with-param name="titre">
								<xsl:call-template name="tradlib">
									<xsl:with-param name="Lang"
									                select="$Lang"/>
									<xsl:with-param name="codeLib"
									                select="'m27_Sigle'"/>
								</xsl:call-template>
							</xsl:with-param>
							<xsl:with-param name="sigle"
							                select="../SIGLE[1]"/>
						</xsl:call-template>
					</xsl:if>
					<xsl:if test="../p2051DA and not(../DATCRE) and ../SIGLE[2]">
						<xsl:call-template name="SIGLEclTexte">
							<xsl:with-param name="sigle"
							                select="../SIGLE[2]"/>
						</xsl:call-template>
					</xsl:if>
				</xsl:if>
			</xsl:if>
			<xsl:if test="position()=2">
				<td class="clCouleur2 clWidth130">&#160;</td>
				<xsl:if test="(../CODNAF and ../p2051DA) or (not(../CODNAF) and not(../p2051DA))">
					<td class="clTexte clWidth305">
            &#160;<xsl:value-of select="."/>
					</td>
					<xsl:if test="not(../p2051DA) and ../DATCRE and ../SIGLE[1]">
						<xsl:call-template name="SIGLEclTexte">
							<xsl:with-param name="titre">
								<xsl:call-template name="tradlib">
									<xsl:with-param name="Lang"
									                select="$Lang"/>
									<xsl:with-param name="codeLib"
									                select="'m27_Sigle'"/>
								</xsl:call-template>
							</xsl:with-param>
							<xsl:with-param name="sigle"
							                select="../SIGLE[1]"/>
						</xsl:call-template>
					</xsl:if>
					<xsl:if test="((not(../p2051DA) and not(../DATCRE))or(../p2051DA and ../DATCRE)) and ../SIGLE[2]">
						<xsl:call-template name="SIGLEclTexte">
							<xsl:with-param name="sigle"
							                select="../SIGLE[2]"/>
						</xsl:call-template>
					</xsl:if>
					<xsl:if test="../p2051DA and not(../DATCRE) and ../SIGLE[3]">
						<xsl:call-template name="SIGLEclTexte">
							<xsl:with-param name="sigle"
							                select="../SIGLE[3]"/>
						</xsl:call-template>
					</xsl:if>
				</xsl:if>
				<xsl:if test="(../CODNAF and not(../p2051DA)) or (not(../CODNAF) and ../p2051DA)">
					<td class="clFond clWidth305">
            &#160;<xsl:value-of select="."/>
					</td>
					<xsl:if test="not(../p2051DA) and ../DATCRE and ../SIGLE[1]">
						<xsl:call-template name="SIGLEclFond">
							<xsl:with-param name="titre">
								<xsl:call-template name="tradlib">
									<xsl:with-param name="Lang"
									                select="$Lang"/>
									<xsl:with-param name="codeLib"
									                select="'m27_Sigle'"/>
								</xsl:call-template>
							</xsl:with-param>
							<xsl:with-param name="sigle"
							                select="../SIGLE[1]"/>
						</xsl:call-template>
					</xsl:if>
					<xsl:if test="((not(../p2051DA) and not(../DATCRE))or(../p2051DA and ../DATCRE)) and ../SIGLE[2]">
						<xsl:call-template name="SIGLEclFond">
							<xsl:with-param name="sigle"
							                select="../SIGLE[2]"/>
						</xsl:call-template>
					</xsl:if>
					<xsl:if test="../p2051DA and not(../DATCRE) and ../SIGLE[3]">
						<xsl:call-template name="SIGLEclFond">
							<xsl:with-param name="sigle"
							                select="../SIGLE[3]"/>
						</xsl:call-template>
					</xsl:if>
				</xsl:if>
			</xsl:if>
		</tr>
	</xsl:template>
	<xsl:template match="DATCRE">
		<th class="clCouleur2 clWidth120 clAlignLeft clThNonGras">
       &#160;
      <xsl:call-template name="tradlib">
				<xsl:with-param name="Lang"
				                select="$Lang"/>
				<xsl:with-param name="codeLib"
				                select="'m27_DatCre'"/>
			</xsl:call-template>
		</th>
		<xsl:if test="../CODNAF">
			<td class="clTexte clWidth80">
        &#160;<xsl:call-template name="displayDateXsl">
					<xsl:with-param name="InputDate"
					                select="(.)"/>
				</xsl:call-template>
			</td>
		</xsl:if>
		<xsl:if test="not(../CODNAF)">
			<td class="clFond clWidth80">
        &#160;<xsl:call-template name="displayDateXsl">
					<xsl:with-param name="InputDate"
					                select="(.)"/>
				</xsl:call-template>
			</td>
		</xsl:if>
	</xsl:template>
	<xsl:template match="SIGLE">
		<xsl:if test="position()=1">
			<xsl:if test="(../DATCRE and not(../ENSEIGNE))or(not(../p2051DA) and count(../ENSEIGNE)=1 and ../DATCRE)">
				<tr>
					<td class="clCouleur2 clWidth130">&#160;</td>
					<td class="clWidth305">&#160;</td>
					<th class="clCouleur2 clWidth120 clAlignLeft clThNonGras">
            &#160;
            <xsl:call-template name="tradlib">
							<xsl:with-param name="Lang"
							                select="$Lang"/>
							<xsl:with-param name="codeLib"
							                select="'m27_Sigle'"/>
						</xsl:call-template>
					</th>
					<xsl:if test="../CODNAF">
						<td class="clFond clWidth80">
              &#160;<xsl:value-of select="."/>
						</td>
					</xsl:if>
					<xsl:if test="not(../CODNAF)">
						<td class="clTexte clWidth80">
              &#160;<xsl:value-of select="."/>
						</td>
					</xsl:if>
				</tr>
			</xsl:if>
			<xsl:if test="not(../DATCRE) and not(../ENSEIGNE) and not (../p2051DA)">
				<tr>
					<td class="clCouleur2 clWidth130">&#160;</td>
					<td class="clWidth305">&#160;</td>
					<td class="clCouleur2 clWidth120">
            &#160;
            <xsl:call-template name="tradlib">
							<xsl:with-param name="Lang"
							                select="$Lang"/>
							<xsl:with-param name="codeLib"
							                select="'m27_Sigle'"/>
						</xsl:call-template>
					</td>
					<xsl:if test="../CODNAF">
						<td class="clTexte clWidth80">
              &#160;<xsl:value-of select="."/>
						</td>
					</xsl:if>
					<xsl:if test="not(../CODNAF)">
						<td class="clFond clWidth80">
              &#160;<xsl:value-of select="."/>
						</td>
					</xsl:if>
				</tr>
			</xsl:if>
		</xsl:if>
		<xsl:if test="position()=2">
			<xsl:if test="(not(../DATCRE) and not(../ENSEIGNE))or(not(../ENSEIGNE[2]) and not(../DATCRE)and not(../p2051DA))">
				<tr>
					<td class="clCouleur2 clWidth130">&#160;</td>
					<td class="clWidth305">&#160;</td>
					<td class="clCouleur2 clWidth120">&#160;</td>
					<xsl:if test="../CODNAF">
						<td class="clFond clWidth80">
              &#160;<xsl:value-of select="."/>
						</td>
					</xsl:if>
					<xsl:if test="not(../CODNAF)">
						<td class="clTexte clWidth80">
              &#160;<xsl:value-of select="."/>
						</td>
					</xsl:if>
				</tr>
			</xsl:if>
			<xsl:if test="(not(../p2051DA) and count(../ENSEIGNE)!=0 and ../DATCRE) or (not(../ENSEIGNE) and ../DATCRE) or (count(../ENSEIGNE)=1 and ../DATCRE and ../p2051DA)">
				<tr>
					<td class="clCouleur2 clWidth130">&#160;</td>
					<td class="clWidth305">&#160;</td>
					<td class="clCouleur2 clWidth120">&#160;</td>
					<xsl:if test="../CODNAF">
						<td class="clTexte clWidth80">
              &#160;<xsl:value-of select="."/>
						</td>
					</xsl:if>
					<xsl:if test="not(../CODNAF)">
						<td class="clFond clWidth80">
              &#160;<xsl:value-of select="."/>
						</td>
					</xsl:if>
				</tr>
			</xsl:if>
		</xsl:if>
		<xsl:if test="position()=3">
			<xsl:if test="not(../ENSEIGNE[2] and ../p2051DA and not(../DATCRE))">
				<tr>
					<td class="clCouleur2 clWidth130">&#160;</td>
					<td class="clWidth305">&#160;</td>
					<td class="clCouleur2 clWidth120">&#160;</td>
					<xsl:if test="(../CODNAF and ../DATCRE) or (not(../CODNAF) and not(../p2051DA) and not(../DATCRE)) or (../p2051DA and not(../CODNAF) and not(../DATCRE))">
						<td class="clFond clWidth80">
              &#160;<xsl:value-of select="."/>
						</td>
					</xsl:if>
					<xsl:if test="(../CODNAF and ../p2051DA and not(../DATCRE)) or (../p2051DA and not(../CODNAF) and ../DATCRE) or (not(../p2051DA) and not(../CODNAF) and ../DATCRE ) or (not(../DATCRE) and not(../p2051DA) and ../CODNAF)">
						<td class="clTexte clWidth80">
              &#160;<xsl:value-of select="."/>
						</td>
					</xsl:if>
				</tr>
			</xsl:if>
		</xsl:if>
		<xsl:if test="position()=4">
			<tr>
				<td class="clCouleur2 clWidth130">&#160;</td>
				<td class="clWidth305">&#160;</td>
				<td class="clCouleur2 clWidth120">&#160;</td>
				<xsl:if test="(../CODNAF and ../DATCRE) or (not(../CODNAF) and not(../p2051DA) and not(../DATCRE)) or (../p2051DA and not(../CODNAF) and not(../DATCRE))">
					<td class="clTexte clWidth80">
            &#160;<xsl:value-of select="."/>
					</td>
				</xsl:if>
				<xsl:if test="(../CODNAF and ../p2051DA and not(../DATCRE)) or (../p2051DA and not(../CODNAF) and ../DATCRE) or (not(../p2051DA) and not(../CODNAF) and ../DATCRE ) or (not(../DATCRE) and not(../p2051DA) and ../CODNAF)">
					<td class="clFond clWidth80">
            &#160;<xsl:value-of select="."/>
					</td>
				</xsl:if>
			</tr>
		</xsl:if>
	</xsl:template>
	<xsl:template name="SIGLEclFond">
		<xsl:param name="titre"/>
		<xsl:param name="sigle"/>
		<td class="clCouleur2 clWidth120">
      &#160;<xsl:value-of select="$titre"/>
		</td>
		<td class="clFond clWidth80">
      &#160;<xsl:value-of select="$sigle"/>
		</td>
	</xsl:template>
	<xsl:template name="SIGLEclTexte">
		<xsl:param name="titre"/>
		<xsl:param name="sigle"/>
		<td class="clCouleur2 clWidth120">
      &#160;<xsl:value-of select="$titre"/>
		</td>
		<td class="clTexte clWidth80">
      &#160;<xsl:value-of select="$sigle"/>
		</td>
	</xsl:template>
	<!--********************************************************************************************************************************************************************-->
	<!-- ***********************************  bloc COMPTE SOCIAUX, COMPTES CONSOLIDEES ***************************************************************************************************************-->
	<!--********************************************************************************************************************************************************************-->
	<xsl:template match="INFOCOMPTABLESDO">
		<a name="ancSociaux"/>
		<xsl:if test="CHIFRSOC/BIL02">
			<xsl:apply-templates select="CHIFRCONS/BILCONSO"/>
			<xsl:if test="not(CHIFRCONS/BILCONSO)">
				<table class="clBorderCell clWidth739">
					<tr class="clAlignCenter">
						<td class="clWidth19">&#160;</td>
						<td class="clCouleurGras clWidth597">
							<xsl:call-template name="tradlib">
								<xsl:with-param name="Lang"
								                select="$Lang"/>
								<xsl:with-param name="codeLib"
								                select="'m27_ChiCle'"/>
							</xsl:call-template>
						</td>
						<td class="clWidth19">

            </td>
						<td class="clWidth103 clAlignRight">			</td>
					</tr>
				</table>
				<xsl:call-template name="shim"/>
				<br/>
			</xsl:if>
			<table class="clWidth635 clBorderCell">
				<tr>
					<td class="clTexte">
						<span class="clCouleur2">
							<xsl:call-template name="traduction">
								<xsl:with-param name="code"
								                select="'BIL02'"/>
							</xsl:call-template>
						</span>
					</td>
				</tr>
			</table>
			<xsl:call-template name="shim"/>
			<br/>
		</xsl:if>
		<xsl:if test="CHIFRSOC/BIL01S">
			<xsl:apply-templates select="CHIFRCONS/BILCONSO"/>
			<xsl:if test="not(CHIFRCONS/BILCONSO)">
				<table class="clBorderCell clWidth739">
					<tr class="clAlignCenter">
						<td class="clWidth19">&#160;</td>
						<td class="clCouleurGras clWidth597">
							<xsl:call-template name="tradlib">
								<xsl:with-param name="Lang"
								                select="$Lang"/>
								<xsl:with-param name="codeLib"
								                select="'m27_ChiCle'"/>
							</xsl:call-template>
						</td>
						<td class="clWidth19">

            </td>
						<td class="clWidth103 clAlignRight">			</td>
					</tr>
				</table>
				<xsl:call-template name="shim"/>
				<br/>
			</xsl:if>
			<table class="clWidth635 clBorderCell">
				<tr>
					<td class="clTexte">
						<span class="clCouleur2">
							<xsl:call-template name="traduction">
								<xsl:with-param name="code"
								                select="'BIL01S'"/>
							</xsl:call-template>
						</span>
					</td>
				</tr>
			</table>
			<xsl:call-template name="shim"/>
			<br/>
		</xsl:if>
		<xsl:if test="not(CHIFRSOC/BIL02) and not(CHIFRSOC/BIL01S) ">
			<xsl:apply-templates select="CHIFRSOC/BILANDE[last()]"/>
		</xsl:if>
		<xsl:if test="CHIFRCONS/BIL01C">
			<xsl:if test="not(CHIFRSOC/BILANDE) and not(CHIFRSOC/BIL01S) and not(CHIFRSOC/BIL02)">
				<table class="clBorderCell clWidth739">
					<tr class="clAlignCenter">
						<td class="clWidth19">&#160;</td>
						<td class="clCouleurGras clWidth597">
							<xsl:call-template name="tradlib">
								<xsl:with-param name="Lang"
								                select="$Lang"/>
								<xsl:with-param name="codeLib"
								                select="'m27_ChiCle'"/>
							</xsl:call-template>
						</td>
						<td class="clWidth19">

            </td>
						<td class="clWidth103 clAlignRight">			</td>
					</tr>
				</table>
				<xsl:call-template name="shim"/>
				<br/>
			</xsl:if>
			<table class="clWidth635 clBorderCell">
				<tr>
					<td class="clTexte">
						<span class="clCouleur2">
							<xsl:call-template name="traduction">
								<xsl:with-param name="code"
								                select="'BIL01C'"/>
							</xsl:call-template>
						</span>
					</td>
				</tr>
			</table>
			<xsl:call-template name="shim"/>
			<br/>
		</xsl:if>
	</xsl:template>
	<xsl:template match="BILANDE">
		<table class="clBorderCell clWidth739">
			<tr class="clAlignCenter">
				<td class="clWidth19">&#160;</td>
				<td class="clCouleurGras clWidth597">
					<xsl:call-template name="tradlib">
						<xsl:with-param name="Lang"
						                select="$Lang"/>
						<xsl:with-param name="codeLib"
						                select="'m27_ChiCle'"/>
					</xsl:call-template>
				</td>
				<td class="clWidth19">

        </td>
				<td class="clWidth103 clAlignRight">
					<a href="#ancHaut">
						<img src="{$root}Images/risque/fleche_haut.gif"
						     width="18"
						     height="18"
						     border="0"
						     name="Image112"
						     alt="Retour en haut de la page"/>
					</a>
				</td>
			</tr>
		</table>
		<xsl:call-template name="shim"/>
		<br/>
		<xsl:if test="//CHIFRCONS/BILCONSO">
			<table class="clWidth635 clHeight125 clBorderCell">
				<tr>
					<td class="clCouleur2"
					    colspan="2">
						<xsl:call-template name="tradlib">
							<xsl:with-param name="Lang"
							                select="$Lang"/>
							<xsl:with-param name="codeLib"
							                select="'m27_ComSoc'"/>
						</xsl:call-template>
					</td>
					<td colspan="{count(../BILANDE)}">
            &#160;
          </td>
					<td class="clWidth15 clHeight125 clValignBottom clAlignMiddle "
					    rowspan="10">
						<img height="125"
						     src="{$root}images/risque/shim_bleu.gif"
						     width="1"
						     alt=""/>
					</td>
					<td class="clCouleur2 clWidth140"
					    colspan="2">
						<xsl:call-template name="tradlib">
							<xsl:with-param name="Lang"
							                select="$Lang"/>
							<xsl:with-param name="codeLib"
							                select="'m27_ComCon'"/>
						</xsl:call-template>
					</td>
					<td colspan="{count(//CHIFRCONS/BILCONSO)}">&#160;</td>
				</tr>
				<tr>
					<td class="clHeight5"
					    colspan="5"/>
					<td class="clHeight5"
					    colspan="4"/>
				</tr>
				<tr>
					<td class="clCouleur2"
					    colspan="2">
						<xsl:call-template name="tradlib">
							<xsl:with-param name="Lang"
							                select="$Lang"/>
							<xsl:with-param name="codeLib"
							                select="'m27_DatClo'"/>
						</xsl:call-template>
					</td>
					<xsl:apply-templates select="../BILANDE/@DATCLOT"/>
					<td class="clCouleur2"
					    colspan="2">
						<xsl:call-template name="tradlib">
							<xsl:with-param name="Lang"
							                select="$Lang"/>
							<xsl:with-param name="codeLib"
							                select="'m27_DatClo'"/>
						</xsl:call-template>
					</td>
					<xsl:apply-templates select="//CHIFRCONS/BILCONSO/@DATCLOT"/>
				</tr>
				<tr>
					<td class="clCouleur2"
					    colspan="2">
						<xsl:call-template name="tradlib">
							<xsl:with-param name="Lang"
							                select="$Lang"/>
							<xsl:with-param name="codeLib"
							                select="'m27_Duree'"/>
						</xsl:call-template>
					</td>
					<xsl:apply-templates select="../BILANDE/@DUREEEX"/>
					<td class="clCouleur2"
					    colspan="2">
						<xsl:call-template name="tradlib">
							<xsl:with-param name="Lang"
							                select="$Lang"/>
							<xsl:with-param name="codeLib"
							                select="'m27_Duree'"/>
						</xsl:call-template>
					</td>
					<xsl:apply-templates select="//CHIFRCONS/BILCONSO/@DUREEEX"/>
				</tr>
				<tr>
					<td class="clHeight5"
					    colspan="5"/>
					<td class="clHeight5"
					    colspan="4"/>
				</tr>
				<tr>
					<td class="clCouleur2 clWidth85 clHeight15">
						<xsl:call-template name="tradlib">
							<xsl:with-param name="Lang"
							                select="$Lang"/>
							<xsl:with-param name="codeLib"
							                select="'m27_CA'"/>
						</xsl:call-template>
            (M<img height="9"
						     src="{$root}images/risque/euro_symb_bleu.gif"
						     width="8"/>)
          </td>
					<td class="clCouleur2 clWidth65 clHeight15">&#160;</td>
					<td colspan="{count(../BILANDE)}"
					    class="clFond"
					    height="15">&#160;</td>
					<td class="clCouleur2 clWidth140  clHeight15"
					    colspan="2">
						<xsl:call-template name="tradlib">
							<xsl:with-param name="Lang"
							                select="$Lang"/>
							<xsl:with-param name="codeLib"
							                select="'m27_CAGRP'"/>
						</xsl:call-template>
            (M<img height="9"
						     src="{$root}images/risque/euro_symb_bleu.gif"
						     width="8"/>)
          </td>
					<td colspan="{count(//CHIFRCONS/BILCONSO)}"
					    class="clFond">&#160;</td>
				</tr>
				<tr>
					<td class="clCouleur2"/>
					<td class="clCouleur2">
						<xsl:call-template name="tradlib">
							<xsl:with-param name="Lang"
							                select="$Lang"/>
							<xsl:with-param name="codeLib"
							                select="'m27_Net'"/>
						</xsl:call-template>
					</td>
					<xsl:apply-templates select="../BILANDE/p2052FL"/>
					<td class="clWidth39"/>
					<td class="clCouleur2 clWidth101">
						<xsl:call-template name="tradlib">
							<xsl:with-param name="Lang"
							                select="$Lang"/>
							<xsl:with-param name="codeLib"
							                select="'m27_Net'"/>
						</xsl:call-template>
					</td>
					<xsl:apply-templates select="//CHIFRCONS/BILCONSO/pCACONS"/>
				</tr>
				<tr>
					<td/>
					<td class="clCouleur2">
						<xsl:call-template name="tradlib">
							<xsl:with-param name="Lang"
							                select="$Lang"/>
							<xsl:with-param name="codeLib"
							                select="'m27_Export'"/>
						</xsl:call-template>
					</td>
					<xsl:apply-templates select="../BILANDE/p2052FK"/>
					<td/>
					<td class="clCouleur2">
						<xsl:call-template name="tradlib">
							<xsl:with-param name="Lang"
							                select="$Lang"/>
							<xsl:with-param name="codeLib"
							                select="'m27_Etranger'"/>
						</xsl:call-template>
					</td>
					<xsl:apply-templates select="//CHIFRCONS/BILCONSO/p2010AD"/>
				</tr>
				<tr>
					<td class="clHeight5"
					    colspan="5"/>
					<td class="clHeight5"
					    colspan="4"/>
				</tr>
				<tr>
					<td class="clCouleur2"
					    colspan="2">
						<xsl:call-template name="tradlib">
							<xsl:with-param name="Lang"
							                select="$Lang"/>
							<xsl:with-param name="codeLib"
							                select="'m27_Effectif'"/>
						</xsl:call-template>
					</td>
					<xsl:apply-templates select="../BILANDE/p2058YP"/>
					<td class="clCouleur2"
					    colspan="2">
						<xsl:call-template name="tradlib">
							<xsl:with-param name="Lang"
							                select="$Lang"/>
							<xsl:with-param name="codeLib"
							                select="'m27_Effectif'"/>
						</xsl:call-template>
					</td>
					<xsl:apply-templates select="//CHIFRCONS/BILCONSO/pEFFECT"/>
				</tr>
				<xsl:if test="../DATDOC">
					<xsl:if test="not($NonResident='NR')">
						<tr>
							<td class="clAlignCenter"
							    colspan="10">

              </td>
						</tr>
					</xsl:if>
					<!--xsl:if test="$NonResident='NR'">
					<tr> 	
						<td class="clAlignCenter" colspan="10">&#160;</td>
					</tr>
				</xsl:if-->
				</xsl:if>
			</table>
			<xsl:call-template name="shim"/>
		</xsl:if>
		<xsl:if test="not(//CHIFRCONS/BILCONSO)">
			<table class="clWidth635 clHeight125 clBorderCell">
				<tr>
					<td class="clCouleur2"
					    colspan="2">
						<xsl:call-template name="tradlib">
							<xsl:with-param name="Lang"
							                select="$Lang"/>
							<xsl:with-param name="codeLib"
							                select="'m27_ComSoc'"/>
						</xsl:call-template>
					</td>
					<td colspan="4">
            &#160;
          </td>
				</tr>
				<tr>
					<td class="clHeight5"
					    colspan="6"/>
				</tr>
				<tr>
					<td class="clCouleur2"
					    colspan="2">
						<xsl:call-template name="tradlib">
							<xsl:with-param name="Lang"
							                select="$Lang"/>
							<xsl:with-param name="codeLib"
							                select="'m27_DatClo'"/>
						</xsl:call-template>
					</td>
					<xsl:apply-templates select="../BILANDE/@DATCLOT"/>
					<td width="{75-25*count(//BILANDE)}%"
					    colspan="{3-count(//BILANDE)}"
					    class="clFond">&#160;</td>
				</tr>
				<tr>
					<td class="clCouleur2"
					    colspan="2">
						<xsl:call-template name="tradlib">
							<xsl:with-param name="Lang"
							                select="$Lang"/>
							<xsl:with-param name="codeLib"
							                select="'m27_Duree'"/>
						</xsl:call-template>
					</td>
					<xsl:apply-templates select="../BILANDE/@DUREEEX"/>
					<td colspan="{3-count(//BILANDE)}"
					    class="clFond">&#160;</td>
				</tr>
				<tr>
					<td class="clHeight5"
					    colspan="6"/>
				</tr>
				<tr>
					<td class="clCouleur2 clWidth85 clHeight15">
						<xsl:call-template name="tradlib">
							<xsl:with-param name="Lang"
							                select="$Lang"/>
							<xsl:with-param name="codeLib"
							                select="'m27_CA'"/>
						</xsl:call-template>
            (M<img height="9"
						     src="{$root}images/risque/euro_symb_bleu.gif"
						     width="8"/>)
          </td>
					<td class="clCouleur2 clWidth65 clHeight15">&#160;</td>
					<td class="clFond clHeight15"
					    colspan="4">&#160;</td>
				</tr>
				<tr>
					<td class="clCouleur2"/>
					<td class="clCouleur2">
						<xsl:call-template name="tradlib">
							<xsl:with-param name="Lang"
							                select="$Lang"/>
							<xsl:with-param name="codeLib"
							                select="'m27_Net'"/>
						</xsl:call-template>
					</td>
					<xsl:apply-templates select="../BILANDE/p2052FL|../BILANDE/p209101"/>
					<td colspan="{3-count(//BILANDE)}"
					    class="clFond">&#160;</td>
				</tr>
				<tr>
					<td/>
					<td class="clCouleur2">
						<xsl:call-template name="tradlib">
							<xsl:with-param name="Lang"
							                select="$Lang"/>
							<xsl:with-param name="codeLib"
							                select="'m27_Export'"/>
						</xsl:call-template>
					</td>
					<xsl:apply-templates select="../BILANDE/p2052FK"/>
					<td colspan="{3-count(//BILANDE)}"
					    class="clFond">&#160;</td>
				</tr>
				<tr>
					<td class="clHeight5"
					    colspan="6"/>
				</tr>
				<tr>
					<td class="clCouleur2"
					    colspan="2">
						<xsl:call-template name="tradlib">
							<xsl:with-param name="Lang"
							                select="$Lang"/>
							<xsl:with-param name="codeLib"
							                select="'m27_Effectif'"/>
						</xsl:call-template>
					</td>
					<xsl:apply-templates select="../BILANDE/p2058YP"/>
					<td colspan="{3-count(//BILANDE)}"
					    class="clFond">&#160;</td>
				</tr>
			</table>
			<xsl:call-template name="shim"/>
		</xsl:if>
	</xsl:template>
	<xsl:template match="BILCONSO">
		<xsl:if test="position()=last()">
			<table class="clWidth635 clBorderCell">
				<caption class="visually-hidden">CHIFFRES CLÉS</caption>
				<tr class="clAlignCenter">
					<td class="clWidth19">&#160;</td>
					<td class="clCouleurgras clWidth597">
						<xsl:call-template name="tradlib">
							<xsl:with-param name="Lang"
							                select="$Lang"/>
							<xsl:with-param name="codeLib"
							                select="'m27_ChiCle'"/>
						</xsl:call-template>
					</td>
					<td class="clWidth19">
          </td>
				</tr>
			</table>
			<xsl:call-template name="shim"/>
			<br/>
      <table class="clWidth635 clHeight125 clBorderCell" role="presentation">
        <tr>
          <th colspan="2" class="clCouleur2 clWidth140 clAlignLeft clThNonGras">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_ComCon'"/>
            </xsl:call-template>
          </th>
          <td colspan="3">&#160;</td>
        </tr>
        <tr>
          <td class="clHeight5" colspan="5"/>
        </tr>
        <tr>
          <th class="clCouleur2 clAlignLeft clThNonGras" colspan="2">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_DatClo'"/>
            </xsl:call-template>
          </th>
          <xsl:apply-templates select="//CHIFRCONS/BILCONSO/@DATCLOT"/>
          <td width="{80-40*count(//CHIFRCONS/BILCONSO)}%" class="clFond">&#160;</td>
        </tr>
        <tr>
          <th class="clCouleur2 clAlignLeft clThNonGras" colspan="2">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_Duree'"/>
            </xsl:call-template>
          </th>
          <xsl:apply-templates select="//CHIFRCONS/BILCONSO/@DUREEEX"/>
          <td class="clFond">&#160;</td>
        </tr>
        <tr>
          <td class="clHeight5" colspan="5"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth140 clHeight15 clThNonGras" colspan="2">
            CA Groupe (M<img height="9" src="{$root}images/risque/euro_symb_bleu.gif" width="8" alt="symbole euro"/>)
          </th>
          <td colspan="3" class="clFond">&#160;</td>
        </tr>
        <tr>
          <td class="clWidth39"/>
          <td class="clCouleur2 clWidth101 clAlignLeft clThNonGras">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_Net'"/>
            </xsl:call-template>
          </td>
          <xsl:apply-templates select="//CHIFRCONS/BILCONSO/pCACONS"/>
          <td class="clFond">&#160;</td>
        </tr>
        <tr>
          <td/>
          <th class="clCouleur2 clAlignLeft clThNonGras">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_Etranger'"/>
            </xsl:call-template>
          </th>
          <xsl:apply-templates select="//CHIFRCONS/BILCONSO/p2010AD"/>
          <td class="clFond">&#160;</td>
        </tr>
        <tr>
          <td class="clHeight5" colspan="5"/>
        </tr>
        <tr>
          <th class="clCouleur2 clAlignLeft clThNonGras" colspan="2">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_Effectif'"/>
            </xsl:call-template>
          </th>
          <xsl:apply-templates select="//CHIFRCONS/BILCONSO/pEFFECT"/>
          <td class="clFond">&#160;</td>
        </tr>
      </table>
			<table class="clWidth635 clHeight125 clBorderCell"
			       role="presentation">
				<tr>
					<td colspan="2"
					    class="clCouleur2 clWidth140">
						<xsl:call-template name="tradlib">
							<xsl:with-param name="Lang"
							                select="$Lang"/>
							<xsl:with-param name="codeLib"
							                select="'m27_ComCon'"/>
						</xsl:call-template>
					</td>
					<td colspan="3">&#160;</td>
				</tr>
				<tr>
					<td class="clHeight5"
					    colspan="5"/>
				</tr>
				<tr>
					<th class="clCouleur2 clAlignLeft clThNonGras"
					    colspan="2">
						<xsl:call-template name="tradlib">
							<xsl:with-param name="Lang"
							                select="$Lang"/>
							<xsl:with-param name="codeLib"
							                select="'m27_DatClo'"/>
						</xsl:call-template>
					</th>
					<xsl:apply-templates select="//CHIFRCONS/BILCONSO/@DATCLOT"/>
					<td width="{80-40*count(//CHIFRCONS/BILCONSO)}%"
					    class="clFond">&#160;</td>
				</tr>
				<tr>
					<th class="clCouleur2 clAlignLeft clThNonGras"
					    colspan="2">
						<xsl:call-template name="tradlib">
							<xsl:with-param name="Lang"
							                select="$Lang"/>
							<xsl:with-param name="codeLib"
							                select="'m27_Duree'"/>
						</xsl:call-template>
					</th>
					<xsl:apply-templates select="//CHIFRCONS/BILCONSO/@DUREEEX"/>
					<td class="clFond">&#160;</td>
				</tr>
				<tr>
					<td class="clHeight5"
					    colspan="5"/>
				</tr>
				<tr>
					<th class="clCouleur2 clWidth140 clHeight15 clThNonGras"
					    colspan="2">
            CA Groupe (M<img height="9"
						     src="{$root}images/risque/euro_symb_bleu.gif"
						     width="8"
						     alt="symbole euro"/>)
          </th>
					<td colspan="3"
					    class="clFond">&#160;</td>
				</tr>
				<tr>
					<td class="clWidth39"/>
					<td class="clCouleur2 clWidth101 clAlignLeft clThNonGras">
						<xsl:call-template name="tradlib">
							<xsl:with-param name="Lang"
							                select="$Lang"/>
							<xsl:with-param name="codeLib"
							                select="'m27_Net'"/>
						</xsl:call-template>
					</td>
					<xsl:apply-templates select="//CHIFRCONS/BILCONSO/pCACONS"/>
					<td class="clFond">&#160;</td>
				</tr>
				<tr>
					<td/>
					<th class="clCouleur2 clAlignLeft clThNonGras">
						<xsl:call-template name="tradlib">
							<xsl:with-param name="Lang"
							                select="$Lang"/>
							<xsl:with-param name="codeLib"
							                select="'m27_Etranger'"/>
						</xsl:call-template>
					</th>
					<xsl:apply-templates select="//CHIFRCONS/BILCONSO/p2010AD"/>
					<td class="clFond">&#160;</td>
				</tr>
				<tr>
					<td class="clHeight5"
					    colspan="5"/>
				</tr>
				<tr>
					<th class="clCouleur2 clAlignLeft clThNonGras"
					    colspan="2">
						<xsl:call-template name="tradlib">
							<xsl:with-param name="Lang"
							                select="$Lang"/>
							<xsl:with-param name="codeLib"
							                select="'m27_Effectif'"/>
						</xsl:call-template>
					</th>
					<xsl:apply-templates select="//CHIFRCONS/BILCONSO/pEFFECT"/>
					<td class="clFond">&#160;</td>
				</tr>
			</table>
			<xsl:call-template name="shim"/>
		</xsl:if>
	</xsl:template>
	<xsl:template match="p2052FL|p209101|p2052FK|pCACONS|p2010AD">
		<xsl:if test="@ETAT">
			<td class="clFond clAlignRight">
        &#160;<xsl:value-of select="@ETAT"/>&#160;
      </td>
		</xsl:if>
		<xsl:if test="not(@ETAT)">
			<td class="clFond clAlignRight">
        &#160;<xsl:call-template name="displayNumberXsl">
					<xsl:with-param name="InputStringNumber"
					                select="(.)"/>
				</xsl:call-template>&#160;
      </td>
		</xsl:if>
	</xsl:template>
	<xsl:template match="p2058YP|pEFFECT">
		<xsl:if test="@ETAT">
			<td class="clFond clAlignRight">
        &#160;<xsl:value-of select="@ETAT"/>&#160;
      </td>
		</xsl:if>
		<xsl:if test="not(@ETAT)">
			<td class="clFond clAlignRight">
        &#160;<xsl:call-template name="displayNumberXsl">
					<xsl:with-param name="InputStringNumber"
					                select="(.)"/>
				</xsl:call-template>&#160;
      </td>
		</xsl:if>
	</xsl:template>
	<xsl:template match="@DATCLOT|@DUREEEX">
		<td class="clFond clAlignRight">
			<xsl:if test="$Lang='FR'">
        &#160;<xsl:call-template name="displayDateXsl">
					<xsl:with-param name="InputDate"
					                select="(.)"/>
				</xsl:call-template>&#160;
      </xsl:if>
			<xsl:if test="$Lang='UK'">
        &#160;<xsl:call-template name="displayDateUKXsl">
					<xsl:with-param name="InputDate"
					                select="(.)"/>
				</xsl:call-template>&#160;
      </xsl:if>
		</td>
	</xsl:template>
	<xsl:template match="@DATCLOTV|@DUREEEXV">
		<td class="clFond clAlignRight">
			<xsl:if test="$Lang='FR'">
        &#160;<xsl:call-template name="displayDateXsl">
					<xsl:with-param name="InputDate"
					                select="(.)"/>
				</xsl:call-template>&#160;
      </xsl:if>
			<xsl:if test="$Lang='UK'">
        &#160;<xsl:call-template name="displayDateUKXsl">
					<xsl:with-param name="InputDate"
					                select="(.)"/>
				</xsl:call-template>&#160;
      </xsl:if>
		</td>
	</xsl:template>
	<!--********************************************************************************************************************************************************************-->
	<!-- ***********************************  bloc LA COTATION BANQUE DE FRANCE***************************************************************************************************************-->
	<!--********************************************************************************************************************************************************************-->
	<xsl:template match="INFOCOTATIONPM">
		<a name="Cotation"/>
		<table class="clBorderCell clWidth739"
		       role="presentation">
			<tr class="clAlignCenter">
				<td class="clWidth19"> </td>
				<td class="clCouleurGras clWidth597"> LA COTATION BANQUE DE FRANCE</td>
				<td class="clWidth19"/>
				<td class="clWidth103 clAlignRight">
					<a href="#ancHaut">
						<img src="{$root}Images/risque/fleche_haut.gif"
						     width="18"
						     height="18"
						     border="0"
						     name="Image112"
						     alt="Retour en haut de la page"/>
					</a>
				</td>
			</tr>
		</table>
		<xsl:call-template name="shim"/>
		<xsl:choose>
			<xsl:when test="VALCOT = 'ND'">
				<table class="clWidth635 clBorderCell"
				       role="presentation">
					<tr>
						<td class="cltitre5 clWidth635 clAlignCenter clBoxSizing">
              Cotation Non Disponible.
            </td>
					</tr>
				</table>
				<xsl:call-template name="shim"/>
				<xsl:choose>
					<xsl:when test="//MODULEDE/EIPP/IDENTS">
						<xsl:apply-templates select="COTPREC"/>
						<xsl:apply-templates select="INDPREC"/>
						<xsl:call-template name="shim"/>
					</xsl:when>
					<xsl:when test="//MODULEDE/EIPP/IDENTC">
						<xsl:apply-templates select="INDPREC"/>
						<xsl:apply-templates select="COTPREC"/>
						<xsl:call-template name="shim"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:apply-templates select="COTPREC"/>
						<xsl:call-template name="shim"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="//IST37">
						<table class="clWidth635 clBorderCell"
						       role="presentation">
							<tr>
								<td class="cltitre5 clWidth635 clAlignCenter clBoxSizing">
                  Cotation Non Disponible.
                </td>
							</tr>
						</table>
						<xsl:call-template name="shim"/>
					</xsl:when>
					<xsl:otherwise>
            <table class="clWidth635 clBorderCell">
              <tr>
                <th class="clCouleur2 clWidth69 clAlignLeft clThNonGras clBoxSizing">Cotation :</th>
                <xsl:if test="DATEXA">
                  <td class="clFond clWidth218 clBoxSizing">
                    &#160;<xsl:value-of select="VALCOT"/>
                  </td>
                  <th class="clCouleur2 clWidth105 clAlignCenter clThNonGras clBoxSizing">depuis le</th>
                  <td class="clFond clWidth69 clBoxSizing">
                    &#160;<xsl:call-template name="displayDateXsl">
                      <xsl:with-param name="InputDate"
											                select="(DATCOT)"/>
                    </xsl:call-template>
                  </td>
                  <th class="clCouleur2 clWidth105 clAlignCenter clThNonGras clBoxSizing">actualisée le</th>
                  <td class="clFond clWidth69 clBoxSizing">
                    &#160;<xsl:call-template name="displayDateXsl">
                      <xsl:with-param name="InputDate"
											                select="(DATEXA)"/>
                    </xsl:call-template>
                  </td>
                </xsl:if>
                <xsl:if test="not(DATEXA)">
                  <td class="clFond clWidth392 clBoxSizing">
                    &#160;<xsl:value-of select="VALCOT"/>
                  </td>
                  <th class="clCouleur2 clWidth105 clAlignCenter clThNonGras clBoxSizing">depuis le</th>
                  <td class="clFond clWidth69 clBoxSizing">
                    &#160;<xsl:call-template name="displayDateXsl">
                      <xsl:with-param name="InputDate"
											                select="(DATCOT)"/>
                    </xsl:call-template>
                  </td>
                </xsl:if>
              </tr>
            </table>

						<xsl:apply-templates select="DATBILS"/>
						<xsl:apply-templates select="DATBILC"/>
						<xsl:choose>
							<xsl:when test="//MODULEDE/EIPP/IDENTS">
								<xsl:apply-templates select="COTPREC"/>
								<xsl:apply-templates select="INDPREC"/>
							</xsl:when>
							<xsl:when test="//MODULEDE/EIPP/IDENTC">
								<xsl:apply-templates select="INDPREC"/>
								<xsl:apply-templates select="COTPREC"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:apply-templates select="COTPREC"/>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:if test="//INFLUENCANTE or //TETEDEGROUPE">
							<xsl:call-template name="shim"/>
							<table class="clWidth635 clBorderCell">
								<caption class="visually-hidden">données sur l'entité influencante ou tête de groupe</caption>
								<xsl:apply-templates select="//INFLUENCANTE"/>
								<xsl:apply-templates select="//TETEDEGROUPE"/>
							</table>
						</xsl:if>
						<xsl:if test="not(//IEC01)">
							<div class="clBreakPage"/>
							<xsl:if test="//MEJ/MEJIG|//MEJ/MEJIS|//MEJ/MEJID|//MEJ/MEJUP|//MEJ/IT01|//MEI/MEIIG/IG01|//MEI/MEIIG/IG02|//MEI/MEIIG/IG03|//MEI/MEIIS/IS02|//MEI/MEIIS/IS06|//MEI/MEIIS/IS09|//MEI/MEIIS/IS10|//MEI/MEIID|BIL06|//MEI/MEIID|BIL07|//MEI/MEIID|BIL08|//MEI/MEIID|BIL09">
								<xsl:call-template name="shim"/>
								<table class="clWidth635 clBorderCell"
								       role="presentation">
									<tr>
										<td class="clCouleurGras">
											<div class="clAlignCenter">
												<xsl:call-template name="tradlib">
													<xsl:with-param name="Lang"
													                select="$Lang"/>
													<xsl:with-param name="codeLib"
													                select="'m37_Caract'"/>
												</xsl:call-template>
												<br/>
											</div>
										</td>
									</tr>
								</table>
								<xsl:call-template name="shim"/>
								<xsl:if test="//MEJ/MEJIG|//MEJ/MEJIS|//MEJ/MEJID|//MEJ/IT01|//MEI/MEIIG/IG01|//MEI/MEIIG/IG02|//MEI/MEIIG/IG03|//MEI/MEIIS/IS02|//MEI/MEIIS/IS06|//MEI/MEIIS/IS09|//MEI/MEIIS/IS10|//MEI/MEIID|BIL06|//MEI/MEIID|BIL07|//MEI/MEIID|BIL08|//MEI/MEIID|BIL09">
									<table class="clWidth635 clBorderCell"
									       role="presentation">
										<xsl:apply-templates select="//MEI/MEIIG/IG01|//MEI/MEIIG/IG02|//MEI/MEIIG/IG03|//MEI/MEIIS/IS02|//MEI/MEIIS/IS06|//MEI/MEIIS/IS09|//MEI/MEIIS/IS10|//MEI/MEIID|BIL06|//MEI/MEIID|BIL07|//MEI/MEIID|BIL08|//MEI/MEIID|BIL09"
										                     mode="displayLib"/>
										<xsl:apply-templates select="//MEJIG/*"
										                     mode="displayLib"/>
										<xsl:apply-templates select="//MEJIS/*"
										                     mode="displayLib"/>
										<xsl:apply-templates select="//MEJID/*"
										                     mode="displayLib"/>
										<xsl:apply-templates select="//MEJ/IT01"
										                     mode="displayLib"/>
									</table>
								</xsl:if>
								<xsl:if test="//MEJ/MEJUP">
									<!--affichage d'un infobulle-->
									<table class="clTexte"
									       title="Se distingue pour la Banque de France par 3 caractéristiques: &#013;
                          - Fort potentiel de croissance &#013;
                          - Usage ou création d'une &#013;
                            technologie nouvelle &#013;
                          - Besoin de financement souvent &#013;
                            assuré par des levées de fonds &#013;Pour plus d'informations, consultez le site utilisateur FIBEN">
										<tr class="clTexte">
											<td class="clWidth122"/>
											<td class="clWidth290">- Analyse tenant compte du modèle de croissance des</td>
											<td class="clWidth223 clSousLigner">start-up</td>
										</tr>
									</table>
								</xsl:if>
							</xsl:if>
							<xsl:call-template name="shim"/>
							<table class="clWidth635 clBorderCell"
							       role="presentation">
								<tr>
									<td class="clCouleurGras">
										<div class="clAlignCenter">
											<xsl:call-template name="tradlib">
												<xsl:with-param name="codeLib"
												                select="'m37_Explititre'"/>
											</xsl:call-template>
											<br/>
										</div>
									</td>
								</tr>
							</table>
							<xsl:call-template name="shim"/>
							<!-- appel template de la cote d'activité -->
							<xsl:apply-templates select="//MPMCA"/>
							<!-- appel template de la cote de crédit -->
							<xsl:call-template name="coteDeCredit"/>
							<!--<xsl:apply-templates select="//MPPCO|//MEICO|//MEJCO"/>-->
							<br/>
						</xsl:if>
						<xsl:if test="//DATESEGA">
							<a name="Segmentation"/>
							<table class="clBorderCell clWidth739">
								<tr class="clAlignCenter">
									<td class="clWidth19"> </td>
									<td class="clCouleurGras clWidth597"> LA SEGMENTATION</td>
									<td class="clWidth19"/>
									<td class="clWidth103 clAlignRight">
										<a href="#ancHaut">
											<img src="{$root}Images/risque/fleche_haut.gif"
											     width="18"
											     height="18"
											     border="0"
											     name="Image112"
											     alt="Retour en haut de la page"/>
										</a>
									</td>
								</tr>
							</table>
							<xsl:call-template name="shim"/>
							<xsl:if test="//DATESEGR">
								<table class="clWidth635 clBorderCell">
									<tr>
										<td class="clCouleur2 clWidth89">Segmentation :</td>
										<td class="clFond clWidth200">
                      &#160;<xsl:value-of select="SEGMENT"/>
										</td>
										<td class="clCouleur2 clWidth105 clHeight1 clAlignCenter">depuis le</td>
										<td class="clFond clWidth68">
                      &#160;<xsl:call-template name="displayDateXsl">
												<xsl:with-param name="InputDate"
												                select="(DATESEGA)"/>
											</xsl:call-template>
										</td>
										<td class="clCouleur2 clWidth105 clHeight18 clAlignCenter">actualisée le</td>
										<td class="clFond clWidth68 clHeight18">
                      &#160;<xsl:call-template name="displayDateXsl">
												<xsl:with-param name="InputDate"
												                select="(DATESEGR)"/>
											</xsl:call-template>
										</td>
									</tr>
								</table>
							</xsl:if>
							<xsl:if test="not (//DATESEGR)">
								<table class="clWidth635 clBorderCell">
									<tr>
										<td class="clCouleur2 clWidth89">Segmentation :</td>
										<td class="clFond clWidth200">
                      &#160;<xsl:value-of select="SEGMENT"/>
										</td>
										<td class="clFond clWidth173"
										    colspan="2"/>
										<td class="clCouleur2 clWidth105 clHeight1 clAlignMiddle">depuis le</td>
										<td class="clFond clWidth68">
                      &#160;<xsl:call-template name="displayDateXsl">
												<xsl:with-param name="InputDate"
												                select="(DATESEGA)"/>
											</xsl:call-template>
										</td>
									</tr>
								</table>
							</xsl:if>
							<xsl:call-template name="shim"/>
							<xsl:if test="SEGDES">
								<table class="clWidth635 clBorderCell">
									<tr>
										<td class="clCouleurGras">
											<div class="clAlignCenter">
                        EXPLICATION DE LA SEGMENTATION<br/>
											</div>
										</td>
									</tr>
								</table>
								<xsl:call-template name="shim"/>
								<table class="clWidth635 clBorderCell">
									<tr>
										<td class="clCouleur2 clWidth175">IMPAYÉS</td>
										<td class="clWidth459 clGrasFond">
											<xsl:value-of select="//IMPAYES"/>
										</td>
									</tr>
								</table>
								<xsl:call-template name="shim"/>
								<table class="clWidth635 clBorderCell">
									<tr>
										<td class="clCouleur2 clWidth175"
										    colspan="2">DESCRIPTIF</td>
										<td class="clWidth459 clGrasFond">
											<xsl:value-of select="//DESCRIPT"/>
										</td>
									</tr>
									<tr>
										<td class="clTexte clWidth20"/>
										<td class="clWidth155 clTexte">Age de l'entreprise:</td>
										<td class="clWidth459 clTexte">
											<xsl:value-of select="//DAGE"/>
										</td>
									</tr>
									<tr>
										<td class="clTexte clWidth20"/>
										<td class="clWidth155 clTexte">Secteur d'activité:</td>
										<td class="clWidth459 clTexte">
											<xsl:value-of select="//DNAF"/>
										</td>
									</tr>
									<tr>
										<td class="clTexte clWidth20"/>
										<td class="clWidth155 clTexte">Catégorie juridique:</td>
										<td class="clWidth459 clTexte">
											<xsl:value-of select="//DCATJUR"/>
										</td>
									</tr>
								</table>
								<xsl:call-template name="shim"/>
								<table class="clWidth635 clBorderCell">
									<tr>
										<td class="clCouleur2 clWidth175">ENDETTEMENT BANCAIRE</td>
										<td class="clWidth459 clGrasFond">
											<xsl:value-of select="//BANC"/>
										</td>
									</tr>
								</table>
								<xsl:call-template name="shim"/>
							</xsl:if>
							<xsl:if test="SEG01">
								<table class="clWidth635 clBorderCell">
									<tr>
										<td class="clWidth612 clFond">
											<xsl:call-template name="traduction">
												<xsl:with-param name="code"
												                select="'SEG01'"/>
											</xsl:call-template>
										</td>
									</tr>
								</table>
								<xsl:call-template name="shim"/>
							</xsl:if>
							<table class="clWidth635 clBorderCell">
								<tr>
									<td class="clWidthMax clHeight20"
									    colspan="2">&#160;</td>
								</tr>
								<tr>
									<td class="clWidth10"/>
									<td class="clStyleDescriptif clWidth620">
										<!--<td width="620" class="cltexte">-->
										<span>
                      La variable <strong>« Impayés »</strong> correspond aux montants cumulés d'incidents de paiement
                      effets de commerce (les contestations de créances CC sont exclues) sur une année, déclarés à la Centrale des Incidents de Paiement sur
                      Effets.
                    </span>
										<br/>
										<br/>
									</td>
								</tr>
								<tr>
									<td class="clWidth10"/>
									<td class="clStyleDescriptif clWidth620">
										<span>
                      La variable <strong>« Descriptive »</strong> agrège 3 informations:&#160;<br/>
                      &#160;&#160;- l'âge de l'entreprise <br/>
                      &#160;&#160;- le secteur d'activité au niveau division NAF<br/>
                      &#160;&#160;- la catégorie juridique<br/>
											<br/>
										</span>
									</td>
								</tr>
								<tr>
									<td class="clWidth10"/>
									<td class="clStyleDescriptif clWidth620">
										<span>
                      La variable <strong>« Endettement Bancaire »</strong>est élaborée à partir des
                      déclarations de concours bancaires mensuels (crédits à court terme et créances commerciales) transmises à la Centrale des
                      Risques.<br/>
											<br/>
										</span>
									</td>
								</tr>
							</table>
							<xsl:call-template name="shim"/>
						</xsl:if>
						<xsl:if test="//DESCRIPTEUR">
							<xsl:call-template name="TableauBRIDGJES"/>
						</xsl:if>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="INFLUENCANTE">
		<tr>
			<td class="clCouleur2 clWidth130">
				<xsl:call-template name="tradlib">
					<xsl:with-param name="Lang"
					                select="$Lang"/>
					<xsl:with-param name="codeLib"
					                select="'m37_EntInf'"/>
				</xsl:call-template>
			</td>
			<td class="clFond clWidth80">
				<xsl:call-template name="displaySirenXsl">
					<xsl:with-param name="InputSiren"
					                select="(EJ/IDENTS)"/>
				</xsl:call-template>
			</td>
			<td class="clFond"
			    colspan="5">
        &#160;<xsl:value-of select="EJ/DENOM"/>
			</td>
		</tr>
		<xsl:if test="not($NonResident='NR')">
			<tr>
				<td class="clWidth130 clHeight14"/>
				<td class="clWidth80 clHeight14"/>
				<td class="clWidth426 clHeight14 clValignMiddle clAlignRight"
				    colspan="5">&#160;</td>
			</tr>
		</xsl:if>
		<xsl:if test="$NonResident='NR'">
			<tr>
				<td class="clWidth130 clHeight14"/>
				<td class="clWidth80 clHeight14"/>
				<td class="clWidth426 clHeight14 clValignMiddle clAlignRight"
				    colspan="5">&#160;</td>
			</tr>
		</xsl:if>
	</xsl:template>
	<xsl:template match="TETEDEGROUPE">
		<tr>
			<td class="clCouleur2 clWidth130 clHeight14 ">
				<xsl:call-template name="tradlib">
					<xsl:with-param name="codeLib"
					                select="'m37_TetGro'"/>
				</xsl:call-template>
			</td>
			<td class="clFond clWidth80 clHeight14">
				<xsl:call-template name="displaySirenXsl">
					<xsl:with-param name="InputSiren"
					                select="(EJ/IDENTS)"/>
				</xsl:call-template>
			</td>
			<td class="clFond clHeight14"
			    colspan="5">
        &#160;<xsl:value-of select="EJ/DENOM"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="IG01|IG02|IG03|IS02|IS06|IS09|IS10|IT01|BIL06|BIL07|BIL08|BIL09"
	              mode="displayLib">
		<tr>
			<td class="clWidth130"/>
			<td class="clTexte clWidth505">
        - <xsl:apply-templates select="."/>
			</td>
		</tr>
	</xsl:template>
	<!--Cote d'activité-->
	<xsl:template match="MPMCA">
		<table class="clWidth635 clBorderCell">
			<caption class="visually-hidden">Explication de la cotation d'activité</caption>
			<tr>
				<th class="clCouleurGras clWidth635 clAlignCenter clBoxSizing"
				    colspan="4">
					<xsl:call-template name="tradlib">
						<xsl:with-param name="Lang"
						                select="$Lang"/>
						<xsl:with-param name="codeLib"
						                select="'m37_CotAct'"/>
					</xsl:call-template>
				</th>
			</tr>
			<tr>
				<td class="clCouleur2 clWidth35 clAlignRight clBoxSizing">
          &#160;<xsl:value-of select="substring(//INFOCOTATIONPM/VALCOT,1,1)"/>&#160;:&#160;
        </td>
				<xsl:apply-templates select="//CA00|CA01|CA02|CA03|CA04|CA05|CA06|CA07|CA08|CA09|CA10|CA11|CA12|CA13|CA14"
				                     mode="displayLib"/>
				<th class="clCouleur2 clWidth75 clAlignLeft clThNonGras clBoxSizing">
					<xsl:call-template name="tradlib">
						<xsl:with-param name="Lang"
						                select="$Lang"/>
						<xsl:with-param name="codeLib"
						                select="'m37_Attribuee'"/>
					</xsl:call-template>
				</th>
				<td class="clTexte clWidth80 clBoxSizing">
					<xsl:call-template name="displayDateXsl">
						<xsl:with-param name="InputDate"
						                select="(//DATCA)"/>
					</xsl:call-template>
				</td>
			</tr>
		</table>
		<xsl:call-template name="shim"/>
	</xsl:template>
	<!--Cote de crédit-->
	<xsl:template name="coteDeCredit">
		<table class="clWidth635 clBorderCell">
			<caption class="visually-hidden">Explication de la cotation de crédit</caption>
			<tr>
				<th class="clCouleurGras clWidth635 clAlignCenter clBoxSizing"
				    colspan="2">
					<xsl:call-template name="tradlib">
						<xsl:with-param name="Lang"
						                select="$Lang"/>
						<xsl:with-param name="codeLib"
						                select="'m37_CotCre'"/>
					</xsl:call-template>
				</th>
			</tr>
		</table>
		<table class="clWidth635 clBorderCell"
		       role="presentation">
			<tr>
				<td class="clCouleur2 clWidth35 clAlignRight clBoxSizing">
          &#160;<xsl:value-of select="substring(//INFOCOTATIONPM/VALCOT,2,3)"/>&#160;:&#160;
        </td>
				<xsl:apply-templates select="//CC01|//MG1P|//MG1|//MG1M|//MG2P|//MG2|//MG2M|//MG3P|//MG3|//MG3M|//MG4P|//MG4|//MG4M|//MG5P|//MG5|//MG5M|//MG6P|//MG6|//MG6M|//MG7|//MG8|//MGP"
				                     mode="displayLib"/>
			</tr>
		</table>
		<table class="clWidth635 clBorderCell"
		       role="presentation">
			<tr>
        <td class="clWidth470 clBoxSizing">&#160;</td>
				<th class="clCouleur2 clWidth75 clAlignLeft clThNonGras clBoxSizing">
					<xsl:call-template name="tradlib">
						<xsl:with-param name="Lang"
						                select="$Lang"/>
						<xsl:with-param name="codeLib"
						                select="'m37_Attribuee'"/>
					</xsl:call-template>					
				</th>
				<td class="clTexte clWidth80 clBoxSizing">
					<xsl:call-template name="displayDateXsl">
						<xsl:with-param name="InputDate"
						                select="(//DATCC)"/>
					</xsl:call-template>
				</td>
			</tr>
		</table>
		<xsl:call-template name="shim"/>
	</xsl:template>
	<xsl:template match="CA00|CA01|CA02|CA03|CA04|CA05|CA06|CA07|CA08|CA09|CA10|CA11|CA12|CA13|CA14"
	              mode="displayLib">
		<td class="clTexte clWidth435 clAlignLeft clBoxSizing">
			<xsl:apply-templates select="."/>
		</td>
	</xsl:template>
	<xsl:template match="CC01|MG1P|MG1|MG1M|MG2P|MG2|MG2M|MG3P|MG3|MG3M|MG4P|MG4|MG4M|MG5P|MG5|MG5M|MG6P|MG6|MG6M|MG7|MG8|MGP"
	              mode="displayLib">
		<td class="clGrasFond clWidth600">
			<xsl:apply-templates select="."/>
		</td>
	</xsl:template>
	<xsl:template match="CCB0|CC03"
	              mode="displayLib">
		<td class="clTexte clWidth597">
			<xsl:apply-templates select="."/>
		</td>
	</xsl:template>
  <xsl:template name="TableauBRIDGJES">
    <table class="clWidth635 clBorderCell">
      <xsl:choose>
        <xsl:when test="//COTECC">
          <caption class="visually-hidden">EXPLICATION DE LA COTE DE CREDIT</caption>
          <tr>
            <th class="clCouleurGras clWidth635 clHeight14 clAlignCenter">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang"
								                select="$Lang"/>
                <xsl:with-param name="codeLib"
								                select="'m37_ExpCotcre'"/>
              </xsl:call-template>
            </th>
          </tr>
        </xsl:when>
        <xsl:otherwise>
          <caption class="visually-hidden">EXPLICATION DE L'INDICATEUR</caption>
          <tr>
            <th class="clCouleurGras clWidth635 clHeight14 clAlignCenter">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang"
								                select="$Lang"/>
                <xsl:with-param name="codeLib"
								                select="'m37_Expindtitre'"/>
              </xsl:call-template>
            </th>
          </tr>
        </xsl:otherwise>
      </xsl:choose>
      <tr>
        <td class="clCouleur2 clWidth635">&#160;</td>
      </tr>
    </table>
    <table class="clWidth635 clBorderCellpadding2 clTableauExpli">
      <caption class="visually-hidden">EXPLICATION DE LA COTE DE CREDIT</caption>
      <tr>
        <th class="clCouleur2Border clWidth260 clAlignCenter">
          <xsl:call-template name="tradlib">
            <xsl:with-param name="Lang"
						                select="$Lang"/>
            <xsl:with-param name="codeLib"
						                select="'m37_Elementan'"/>
          </xsl:call-template>
        </th>
        <th class="clCouleur2Border clWidth260 clAlignCenter">
          <xsl:call-template name="tradlib">
            <xsl:with-param name="Lang"
						                select="$Lang"/>
            <xsl:with-param name="codeLib"
						                select="'m37_Observ'"/>
          </xsl:call-template>
        </th>
        <th class="clCouleur2Border clWidth115 clAlignCenter">
          <xsl:call-template name="tradlib">
            <xsl:with-param name="Lang"
						                select="$Lang"/>
            <xsl:with-param name="codeLib"
						                select="'m37_ElementDet'"/>
          </xsl:call-template>
        </th>
      </tr>
      <xsl:variable name="ElemIDetermin"
			              select="//ELEMI/@DETERMIN"/>
      <xsl:variable name="ElemIValeur"
			              select="//ELEMI/@VALEUR"/>
      <xsl:variable name="ElemIMessage"
			              select="//ELEMI/@MESSAGE"/>
      <xsl:choose>
        <xsl:when test="$ElemIDetermin = 'N'">
          <tr>
            <td class="clTableauCelBlanc clValignTop clWidth260 clAlignLeft">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang"
								                select="$Lang"/>
                <xsl:with-param name="codeLib"
								                select="'m37_DescripteurI'"/>
              </xsl:call-template>
            </td>
            <td class="clTableauCelBlanc clWidth260 clAlignLeft">
              <xsl:if test="$Lang = 'FR'">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemIMessage]"/>
                <xsl:if test="($ElemIValeur = '1') or ($ElemIValeur = '3') or ($ElemIValeur ='5')">
                  <xsl:if test="not($NonResident='NR')">
                    <br/>
                    <br/>
                    <a href="#nullePart"
										   onclick="requestBDFInfos('29','','2','',cstSimpleConfirm);"
										   class="clCouleur2">
                      Pour plus de renseignement :&#160;
                      <u>
                        Module 29 (Incidents effets)
                      </u>
                    </a>
                  </xsl:if>
                </xsl:if>
              </xsl:if>
              <xsl:if test="$Lang = ''">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemIMessage]"/>
              </xsl:if>
              <xsl:if test="$Lang = 'UK'">
                <xsl:value-of select="$dictionnaireUK/mot[@id=$ElemIMessage]"/>
              </xsl:if>
            </td>
            <td class="clTableauCelBlanc clWidth115 clAlignCenter">
              &#160;<xsl:call-template name="tradlib">
                <xsl:with-param name="Lang"
								                select="$Lang"/>
                <xsl:with-param name="codeLib"
								                select="'m37_Non'"/>
              </xsl:call-template>
            </td>
          </tr>
        </xsl:when>
        <xsl:when test="$ElemIDetermin = 'O'">
          <tr>
            <td class="clTableauCelBlanc clValignTop clWidth260 clAlignLeft">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang"
								                select="$Lang"/>
                <xsl:with-param name="codeLib"
								                select="'m37_DescripteurI'"/>
              </xsl:call-template>
            </td>
            <td class="clTableauCelBlancGras clWidth260 clAlignLeft">
              <xsl:if test="$Lang = 'FR'">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemIMessage]"/>
                <xsl:if test="($ElemIValeur = '1') or ($ElemIValeur = '3') or ($ElemIValeur ='5')">
                  <xsl:if test="not($NonResident='NR')">
                    <br/>
                    <br/>
                    <a href="#nullePart"
										   onclick="requestBDFInfos('29','','2','',cstSimpleConfirm);"
										   class="clCouleur2">
                      Pour plus de renseignement :&#160;
                      <u>
                        Module 29 (incidents effets)
                      </u>
                    </a>
                  </xsl:if>
                </xsl:if>
              </xsl:if>
              <xsl:if test="$Lang = ''">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemIMessage]"/>
              </xsl:if>
              <xsl:if test="$Lang = 'UK'">
                <xsl:value-of select="$dictionnaireUK/mot[@id=$ElemIMessage]"/>
              </xsl:if>
            </td>
            <td class="clTableauCelBlanc clWidth115 clAlignCenter">
              &#160;<xsl:call-template name="tradlib">
                <xsl:with-param name="Lang"
								                select="$Lang"/>
                <xsl:with-param name="codeLib"
								                select="'m37_Oui'"/>
              </xsl:call-template>
            </td>
          </tr>
        </xsl:when>
        <xsl:otherwise>
          <tr>
            <td class="clTableauCelGris clvalign clWidth260 clAlignLeft">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang"
								                select="$Lang"/>
                <xsl:with-param name="codeLib"
								                select="'m37_DescripteurI'"/>
              </xsl:call-template>
            </td>
            <td class="clTableauCelGris clWidth260 clAlignLeft">
              &#160;
            </td>
            <td class="clTableauCelGris clWidth115 clAlignCenter">
              &#160;
            </td>
          </tr>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="ElemDDetermin"
			              select="//ELEMD/@DETERMIN"/>
      <xsl:variable name="ElemDValeur"
			              select="//ELEMD/@VALEUR"/>
      <xsl:variable name="ElemDMessage"
			              select="//ELEMD/@MESSAGE"/>
      <xsl:choose>
        <xsl:when test="$ElemDDetermin = 'N'">
          <tr>
            <td class="clTableauCelBlanc clValignTop clWidth260 clAlignLeft">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang"
								                select="$Lang"/>
                <xsl:with-param name="codeLib"
								                select="'m37_DescripteurD'"/>
              </xsl:call-template>
            </td>
            <td class="clTableauCelBlanc clWidth260 clAlignLeft">
              <xsl:if test="$Lang = 'FR'">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemDMessage]"/>
                <xsl:if test="not($NonResident='NR')">
                  <xsl:if test="$ElemDValeur = '1'">
                    <br/>
                    <br/>
                    <a href="#nullePart"
										   onclick="requestBDFInfos('51','','3','',cstSimpleConfirm);"
										   class="clCouleur2">
                      Pour plus de renseignement :&#160;
                      <u>
                        Module 51 (Dirigeants)
                      </u>
                    </a>
                  </xsl:if>
                  <xsl:if test="$ElemDValeur = '2'">
                    <br/>
                    <br/>
                    <a href="#nullePart"
										   onclick="requestBDFInfos('56','','3','',cstSimpleConfirm);"
										   class="clCouleur2">
                      Pour plus de renseignement :&#160;
                      <u>
                        Module 56 (Fonctions de direction)
                      </u>
                    </a>
                  </xsl:if>
                  <xsl:if test="$ElemDValeur = '3'">
                    <br/>
                    <br/>
                    <a href="#nullePart"
										   onclick="requestBDFInfos('51|56|','','3','',cstMultipleConfirm);"
										   class="clCouleur2">
                      Pour plus de renseignement :&#160;
                      <u>
                        Module 51 (Dirigeants) ou Module 56 (Fonctions de direction)
                      </u>
                    </a>
                  </xsl:if>
                </xsl:if>
              </xsl:if>
              <xsl:if test="$Lang = ''">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemDMessage]"/>
              </xsl:if>
              <xsl:if test="$Lang = 'UK'">
                <xsl:value-of select="$dictionnaireUK/mot[@id=$ElemDMessage]"/>
              </xsl:if>
            </td>
            <td class="clTableauCelBlanc clWidth115 clAlignCenter">
              &#160;<xsl:call-template name="tradlib">
                <xsl:with-param name="Lang"
								                select="$Lang"/>
                <xsl:with-param name="codeLib"
								                select="'m37_Non'"/>
              </xsl:call-template>
            </td>
          </tr>
        </xsl:when>
        <xsl:when test="$ElemDDetermin = 'O'">
          <tr>
            <td class="clTableauCelBlanc clValignTop clWidth260 clAlignLeft">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang"
								                select="$Lang"/>
                <xsl:with-param name="codeLib"
								                select="'m37_DescripteurD'"/>
              </xsl:call-template>
            </td>
            <td class="clTableauCelBlancGras clWidth260 clAlignLeft">
              <xsl:if test="$Lang = 'FR'">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemDMessage]"/>
                <xsl:if test="not($NonResident='NR')">
                  <xsl:if test="$ElemDValeur = '1'">
                    <br/>
                    <br/>
                    <a href="#nullePart"
										   onclick="requestBDFInfos('51','','3','',cstSimpleConfirm);"
										   class="clCouleur2">
                      Pour plus de renseignement :&#160;
                      <u>
                        Module 51 (Dirigeants)
                      </u>
                    </a>
                  </xsl:if>
                  <xsl:if test="$ElemDValeur = '2'">
                    <br/>
                    <br/>
                    <a href="#nullePart"
										   onclick="requestBDFInfos('56','','3','',cstSimpleConfirm);"
										   class="clCouleur2">
                      Pour plus de renseignement :&#160;
                      <u>
                        Module 56 (Fonctions de direction)
                      </u>
                    </a>
                  </xsl:if>
                  <xsl:if test="$ElemDValeur = '3'">
                    <br/>
                    <br/>
                    <a href="#nullePart"
										   onclick="requestBDFInfos('51|56|','','3','',cstMultipleConfirm);"
										   class="clCouleur2">
                      Pour plus de renseignement :&#160;
                      <u>
                        Module 51 (Dirigeants) ou Module 56 (Fonctions de direction)
                      </u>
                    </a>
                  </xsl:if>
                </xsl:if>
              </xsl:if>
              <xsl:if test="$Lang = ''">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemDMessage]"/>
              </xsl:if>
              <xsl:if test="$Lang = 'UK'">
                <xsl:value-of select="$dictionnaireUK/mot[@id=$ElemDMessage]"/>
              </xsl:if>
            </td>
            <td class="clTableauCelBlanc clWidth115 clAlignCenter">
              &#160;<xsl:call-template name="tradlib">
                <xsl:with-param name="Lang"
								                select="$Lang"/>
                <xsl:with-param name="codeLib"
								                select="'m37_Oui'"/>
              </xsl:call-template>
            </td>
          </tr>
        </xsl:when>
        <xsl:otherwise>
          <tr>
            <td class="clTableauCelGris clvalign clWidth260 clAlignLeft">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang"
								                select="$Lang"/>
                <xsl:with-param name="codeLib"
								                select="'m37_DescripteurD'"/>
              </xsl:call-template>
            </td>
            <td class="clTableauCelGris clWidth260 clAlignLeft">
              &#160;
            </td>
            <td class="clTableauCelGris clWidth115 clAlignCenter">
              &#160;
            </td>
          </tr>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="ElemGDetermin"
			              select="//ELEMG/@DETERMIN"/>
      <xsl:variable name="ElemGValeur"
			              select="//ELEMG/@VALEUR"/>
      <xsl:variable name="ElemGMessage"
			              select="//ELEMG/@MESSAGE"/>
      <xsl:choose>
        <xsl:when test="$ElemGDetermin = 'N'">
          <tr>
            <td class="clTableauCelBlanc clValignTop clWidth260 clAlignLeft">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang"
								                select="$Lang"/>
                <xsl:with-param name="codeLib"
								                select="'m37_DescripteurG'"/>
              </xsl:call-template>
            </td>
            <td class="clTableauCelBlanc clWidth260 clAlignLeft">
              <xsl:if test="$Lang = 'FR'">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemGMessage]"/>
              </xsl:if>
              <xsl:if test="$Lang = ''">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemGMessage]"/>
              </xsl:if>
              <xsl:if test="$Lang = 'UK'">
                <xsl:value-of select="$dictionnaireUK/mot[@id=$ElemGMessage]"/>
              </xsl:if>
            </td>
            <td class="clTableauCelBlanc clWidth115 clAlignCenter">
              &#160;<xsl:call-template name="tradlib">
                <xsl:with-param name="Lang"
								                select="$Lang"/>
                <xsl:with-param name="codeLib"
								                select="'m37_Non'"/>
              </xsl:call-template>
            </td>
          </tr>
        </xsl:when>
        <xsl:when test="$ElemGDetermin = 'O'">
          <tr>
            <td class="clTableauCelBlanc clValignTop clWidth260 clAlignLeft">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang"
								                select="$Lang"/>
                <xsl:with-param name="codeLib"
								                select="'m37_DescripteurG'"/>
              </xsl:call-template>
            </td>
            <td class="clTableauCelBlancGras clWidth260 clAlignLeft">
              <xsl:if test="$Lang = 'FR'">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemGMessage]"/>
              </xsl:if>
              <xsl:if test="$Lang = ''">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemGMessage]"/>
              </xsl:if>
              <xsl:if test="$Lang = 'UK'">
                <xsl:value-of select="$dictionnaireUK/mot[@id=$ElemGMessage]"/>
              </xsl:if>
            </td>
            <td class="clTableauCelBlanc clWidth115 clAlignCenter">
              &#160;<xsl:call-template name="tradlib">
                <xsl:with-param name="Lang"
								                select="$Lang"/>
                <xsl:with-param name="codeLib"
								                select="'m37_Oui'"/>
              </xsl:call-template>
            </td>
          </tr>
        </xsl:when>
        <xsl:otherwise>
          <tr>
            <td class="clTableauCelGris clvalign clWidth260 clAlignLeft">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang"
								                select="$Lang"/>
                <xsl:with-param name="codeLib"
								                select="'m37_DescripteurG'"/>
              </xsl:call-template>
            </td>
            <td class="clTableauCelGris clWidth260 clAlignLeft">
              &#160;
            </td>
            <td class="clTableauCelGris clWidth115 clAlignCenter">
              &#160;
            </td>
          </tr>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="ElemJDetermin"
			              select="//ELEMJ/@DETERMIN"/>
      <xsl:variable name="ElemJValeur"
			              select="//ELEMJ/@VALEUR"/>
      <xsl:variable name="ElemJMessage"
			              select="//ELEMJ/@MESSAGE"/>
      <xsl:choose>
        <xsl:when test="$ElemJDetermin = 'N'">
          <tr>
            <td class="clTableauCelBlanc clValignTop clWidth260 clAlignLeft">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang"
								                select="$Lang"/>
                <xsl:with-param name="codeLib"
								                select="'m37_DescripteurJ'"/>
              </xsl:call-template>
            </td>
            <td class="clTableauCelBlanc clWidth260 clAlignLeft">
              <xsl:if test="$Lang = 'FR'">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemJMessage]"/>
              </xsl:if>
              <xsl:if test="$Lang = ''">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemJMessage]"/>
              </xsl:if>
              <xsl:if test="$Lang = 'UK'">
                <xsl:value-of select="$dictionnaireUK/mot[@id=$ElemJMessage]"/>
              </xsl:if>
            </td>
            <td class="clTableauCelBlanc clWidth115 clAlignCenter">
              &#160;<xsl:call-template name="tradlib">
                <xsl:with-param name="Lang"
								                select="$Lang"/>
                <xsl:with-param name="codeLib"
								                select="'m37_Non'"/>
              </xsl:call-template>
            </td>
          </tr>
        </xsl:when>
        <xsl:when test="$ElemJDetermin = 'O'">
          <tr>
            <td class="clTableauCelBlanc clValignTop clWidth260 clAlignLeft">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang"
								                select="$Lang"/>
                <xsl:with-param name="codeLib"
								                select="'m37_DescripteurJ'"/>
              </xsl:call-template>
            </td>
            <td class="clTableauCelBlancGras clWidth260 clAlignLeft">
              <xsl:if test="$Lang = 'FR'">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemJMessage]"/>
              </xsl:if>
              <xsl:if test="$Lang = ''">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemJMessage]"/>
              </xsl:if>
              <xsl:if test="$Lang = 'UK'">
                <xsl:value-of select="$dictionnaireUK/mot[@id=$ElemJMessage]"/>
              </xsl:if>
            </td>
            <td class="clTableauCelBlanc clWidth115 clAlignCenter">
              &#160;<xsl:call-template name="tradlib">
                <xsl:with-param name="Lang"
								                select="$Lang"/>
                <xsl:with-param name="codeLib"
								                select="'m37_Oui'"/>
              </xsl:call-template>
            </td>
          </tr>
        </xsl:when>
        <xsl:otherwise>
          <tr>
            <td class="clTableauCelGris clvalign clWidth260 clAlignLeft">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang"
								                select="$Lang"/>
                <xsl:with-param name="codeLib"
								                select="'m37_DescripteurJ'"/>
              </xsl:call-template>
            </td>
            <td class="clTableauCelGris clWidth260 clAlignLeft">
              &#160;
            </td>
            <td class="clTableauCelGris clWidth115 clAlignCenter">
              &#160;
            </td>
          </tr>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="ElemSDetermin"
			              select="//ELEMS/@DETERMIN"/>
      <xsl:variable name="ElemSValeur"
			              select="//ELEMS/@VALEUR"/>
      <xsl:variable name="ElemSMessage"
			              select="//ELEMS/@MESSAGE"/>
      <xsl:choose>
        <xsl:when test="$ElemSDetermin = 'N'">
          <tr>
            <td class="clTableauCelBlanc clValignTop clWidth260 clAlignLeft">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang"
								                select="$Lang"/>
                <xsl:with-param name="codeLib"
								                select="'m37_DescripteurS'"/>
              </xsl:call-template>
            </td>
            <td class="clTableauCelBlanc clWidth260 clAlignLeft">
              <xsl:if test="$Lang = 'FR'">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemSMessage]"/>
                <xsl:if test="not($NonResident='NR')">
                  <xsl:if test="$ElemSValeur = '1'">
                    <br/>
                    <br/>
                    <a href="#nullePart"
										   onclick="requestBDFInfos('45','','3','',cstSimpleConfirm);"
										   class="clCouleur2">
                      Pour plus de renseignement :&#160;
                      <u>
                        Module 45 (Jugements)
                      </u>
                    </a>
                  </xsl:if>
                </xsl:if>
              </xsl:if>
              <xsl:if test="$Lang = ''">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemSMessage]"/>
              </xsl:if>
              <xsl:if test="$Lang = 'UK'">
                <xsl:value-of select="$dictionnaireUK/mot[@id=$ElemSMessage]"/>
              </xsl:if>
            </td>
            <td class="clTableauCelBlanc clWidth115 clAlignCenter">
              &#160;<xsl:call-template name="tradlib">
                <xsl:with-param name="Lang"
								                select="$Lang"/>
                <xsl:with-param name="codeLib"
								                select="'m37_Non'"/>
              </xsl:call-template>
            </td>
          </tr>
        </xsl:when>
        <xsl:when test="$ElemSDetermin = 'O'">
          <tr>
            <td class="clTableauCelBlanc clValignTop clWidth260 clAlignLeft">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang"
								                select="$Lang"/>
                <xsl:with-param name="codeLib"
								                select="'m37_DescripteurS'"/>
              </xsl:call-template>
            </td>
            <td class="clTableauCelBlancGras clWidth260 clAlignLeft">
              <xsl:if test="$Lang = 'FR'">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemSMessage]"/>
                <xsl:if test="not($NonResident='NR')">
                  <xsl:if test="$ElemSValeur = '1'">
                    <br/>
                    <br/>
                    <a href="#nullePart"
										   onclick="requestBDFInfos('45','','3','',cstSimpleConfirm);"
										   class="clCouleur2">
                      Pour plus de renseignement :&#160;
                      <u>
                        Module 45 (Jugements)
                      </u>
                    </a>
                  </xsl:if>
                </xsl:if>
              </xsl:if>
              <xsl:if test="$Lang = ''">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemSMessage]"/>
              </xsl:if>
              <xsl:if test="$Lang = 'UK'">
                <xsl:value-of select="$dictionnaireUK/mot[@id=$ElemSMessage]"/>
              </xsl:if>
            </td>
            <td class="clTableauCelBlanc clWidth115 clAlignCenter">
              &#160;<xsl:call-template name="tradlib">
                <xsl:with-param name="Lang"
								                select="$Lang"/>
                <xsl:with-param name="codeLib"
								                select="'m37_Oui'"/>
              </xsl:call-template>
            </td>
          </tr>
        </xsl:when>
        <xsl:otherwise>
          <tr>
            <td class="clTableauCelGris clvalign clWidth260 clAlignLeft">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang"
								                select="$Lang"/>
                <xsl:with-param name="codeLib"
								                select="'m37_DescripteurS'"/>
              </xsl:call-template>
            </td>
            <td class="clTableauCelGris clWidth260 clAlignLeft">
              &#160;
            </td>
            <td class="clTableauCelGris clWidth115 clAlignCenter">
              &#160;
            </td>
          </tr>
        </xsl:otherwise>
      </xsl:choose>
      <tr>
        <td class="clCouleur2 clWidth260 clAlignLeft">
          <xsl:call-template name="tradlib">
            <xsl:with-param name="Lang"
						                select="$Lang"/>
            <xsl:with-param name="codeLib"
						                select="'m37_DateMaj'"/>
          </xsl:call-template>&#160;
          <xsl:call-template name="displayDateXsl">
            <xsl:with-param name="InputDate"
						                select="(//DESCRIPTEUR/DATEDESC)"/>
          </xsl:call-template>
        </td>
        <td class="clWidth260">
          &#160;
        </td>
        <td class="clWidth115">
          &#160;
        </td>
      </tr>
    </table>
    <br/>
  </xsl:template>
	<!--********************************************************************************************************************************************************************-->
	<!-- ***********************************  bloc dirigeants ***************************************************************************************************************-->
	<!--********************************************************************************************************************************************************************-->
	<!-- l'arborescence XML a était modifié le 18/08/2008 -->
	<xsl:template match="INFODIRIGEANTS">
		<!--<div class="clBreakPage"></div>-->
		<xsl:if test="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFODIRIGEANTS/DIRIGEANTS">
			<xsl:apply-templates select="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFODIRIGEANTS/DIRIGEANTS/NBDIRIGEANTDO"/>
			<xsl:apply-templates select="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFODIRIGEANTS/DIRIGEANTS/DIRIGEANT"/>
			<xsl:if test="not(//INFODIRIGEANTS/DIRIGEANTS/SUITE | //INFODIRIGEANTS/DIRIGEANTS/AUTRFDEJ)">
				<xsl:call-template name="shim"/>
			</xsl:if>
		</xsl:if>
		<xsl:if test="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFODIRIGEANTS/DIRIGEANTSCESSES">
			<xsl:apply-templates select="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFODIRIGEANTS/DIRIGEANTSCESSES/NBDIRIGEANTCESSEDO"/>
			<xsl:apply-templates select="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFODIRIGEANTS/DIRIGEANTSCESSES/DIRIGEANTCESSE"/>
			<!--<xsl:apply-templates select="SUITE" />  le template suite est supprimer car il y a deux fois suite au même niveau-->
			<!-- le plus d'infos est donc rajouté à la fin des templates DIRIGEANT ET DIRIGEANTCESSE -->
			<!--<xsl:call-template name="shim"/>-->
			<xsl:if test="not(//INFODIRIGEANTS/DIRIGEANTSCESSES/SUITE)">
				<xsl:call-template name="shim"/>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<xsl:template match="NBDIRIGEANTDO">
		<a name="Dirigeants"/>
		<table class="clWidth635 clBorderCell"
		       role="presentation">
			<tr class="clAlignCenter">
				<td class="clCouleurGras">
          DIRIGEANT(S) ACTIF(S) DE L'ENTREPRISE (<xsl:value-of select="."/>)<br/>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template match="DIRIGEANT">
		<table class="clBorderCell clWidth739">
			<caption class="visually-hidden">DIRIGEANT(S) ACTIF(S) DE L'ENTREPRISE</caption>
			<tr>
				<td class="clGrasFond"
				    colspan="2">
					<xsl:apply-templates select="FONCTCOT"/>
				</td>
				<xsl:if test="FONCTCOT/DATFONCT">
					<th class="clFond clAlignRight clThNonGras"
					    colspan="2"> Depuis le :</th>
					<td class="clFond clWidth90 clAlignRight">
						<xsl:call-template name="displayDateXsl">
							<xsl:with-param name="InputDate"
							                select="(FONCTCOT/DATFONCT)"/>
						</xsl:call-template>
					</td>
				</xsl:if>
				<xsl:if test="not(FONCTCOT/DATFONCT)">
					<td colspan="2"
					    class="clFond">&#160;</td>
					<td class="clFond clWidth90">&#160;</td>
				</xsl:if>
				<xsl:if test="position() mod 3 = 0">
					<td class="clWidth103 clAlignRight"
					    rowspan="3">
						<a href="#ancHaut">
							<img src="{$root}Images/risque/fleche_haut.gif"
							     width="18"
							     height="18"
							     border="0"
							     name="Image112"
							     alt="Retour en haut de la page"/>
						</a>
					</td>
				</xsl:if>
				<xsl:if test="position() mod 3 != 0">
					<td class="clWidth103 clAlignRight"
					    rowspan="3">
            &#160;
          </td>
				</xsl:if>
			</tr>
			<tr>
				<xsl:if test="EJ/DENOM">
					<td class="clTexteGras"
					    colspan="5">
            &#160;<xsl:value-of select="EJ/DENOM"/>
					</td>
				</xsl:if>
				<xsl:if test="not(EJ/DENOM)">
					<td class="clTexteGras"
					    colspan="2">
            &#160;<xsl:call-template name="displayInLowerCaseXsl">
							<xsl:with-param name="InputStringNom"
							                select="(PP/IDENTITE/NOM)"/>
							<xsl:with-param name="InputStringPrenom"
							                select="(PP/IDENTITE/PRENOM)"/>
						</xsl:call-template>
					</td>
					<xsl:if test="PP/IDENTITE/NOMCONJ">
						<td class="clCouleur2"
						    colspan="3">
              &#160;Nom marital&#160;&#160;&#160;<span class="clTexte">
								<xsl:value-of select="PP/IDENTITE/NOMCONJ"/>
							</span>
						</td>
					</xsl:if>
					<xsl:if test="not(PP/IDENTITE/NOMCONJ)">
						<td class="clWidth54">&#160;</td>
						<td colspan="2">&#160;</td>
					</xsl:if>
				</xsl:if>
			</tr>
			<xsl:if test="EJ">
				<xsl:variable name="ident"
				              select="EJ/IDENTS"/>
				<xsl:if test="FONCTCOT/SEGMENT">
					<tr>
						<th class="clCouleur2 clWidth59 clAlignLeft clValignMiddle clThNonGras">&#160;Identifiant</th>
						<td class="clFond clWidth255">
              &#160;<xsl:call-template name="displaySirenXsl">
								<xsl:with-param name="InputSiren"
								                select="(EJ/IDENTS)"/>
							</xsl:call-template>
						</td>
						<xsl:if test="not(FONCTCOT/VALCOT='NS')">
							<td class="clFond clWidth81"/>
							<th class="clCouleur2 clWidth145 clAlignLeft clThNonGras">&#160;Cotation | Segmentation</th>
							<xsl:if test="not(FONCTCOT/VALCOT='ND')">
								<td class="clFond clWidth89 clValignMiddle clAlignRight">
                  &#160;<a href="#nullepart"
									   class="clFond"
									   onclick="requestVariousInfos('{FONCTCOT/VALCOT}',cstCotation,'{$ident}')">
										<u>
											<xsl:value-of select="FONCTCOT/VALCOT"/>
										</u>
									</a>
									<a href="#nullepart"
									   class="clTexte"
									   onclick="requestInfosLibelle('segmentation',cstSegment);">
                    &#160;|&#160;
                    <u>
											<xsl:value-of select="FONCTCOT/SEGMENT"/>
										</u>
									</a>
								</td>
							</xsl:if>
							<xsl:if test="(FONCTCOT/VALCOT='ND')">
								<td class="clFond clWidth89 clValignMiddle clAlignRight">
                  &#160;<a href="#nullepart"
									   class="clFond"
									   onclick="requestVariousInfos('{FONCTCOT/VALCOT}',cstCotationNonDif,'{$ident}')">
										<u>
											<xsl:value-of select="FONCTCOT/VALCOT"/>
										</u>
									</a>
									<a href="#nullepart"
									   class="clTexte"
									   onclick="requestInfosLibelle('segmentation',cstSegment);">
                    &#160;|&#160;
                    <u>
											<xsl:value-of select="FONCTCOT/SEGMENT"/>
										</u>
									</a>
								</td>
							</xsl:if>
						</xsl:if>
						<xsl:if test="(FONCTCOT/VALCOT='NS')">
							<td class="clFond clWidth315"
							    colspan="3"/>
						</xsl:if>
					</tr>
					<tr>
						<td class="clTexteGras clAlignLeft"
						    colspan="4">
              &#160;
            </td>
						<td class="clWidth92">
              &#160;
            </td>
					</tr>
				</xsl:if>
				<xsl:if test="not (FONCTCOT/SEGMENT)">
					<tr>
						<th class="clCouleur2 clWidth59 clAlignLeft clValignMiddle clThNonGras">&#160;Identifiant</th>
						<td class="clFond clWidth255">
              &#160;<xsl:call-template name="displaySirenXsl">
								<xsl:with-param name="InputSiren"
								                select="(EJ/IDENTS)"/>
							</xsl:call-template>
						</td>
						<xsl:if test="not(FONCTCOT/VALCOT='NS')">
							<td class="clFond clWidth166"/>
							<th class="clCouleur2 clWidth60 clAlignLeft clThNonGras">&#160;Cotation</th>
							<xsl:if test="not(FONCTCOT/VALCOT='ND')">
								<td class="clFond clWidth89 clValignMiddle clAlignRight">
                  &#160;<a href="#nullepart"
									   class="clFond"
									   onclick="requestVariousInfos('{FONCTCOT/VALCOT}',cstCotation,'{$ident}')">
										<u>
											<xsl:value-of select="FONCTCOT/VALCOT"/>
										</u>
									</a>
								</td>
							</xsl:if>
							<xsl:if test="(FONCTCOT/VALCOT='ND')">
								<td class="clFond clWidth89 clValignMiddle clAlignRight">
                  &#160;<a href="#nullepart"
									   class="clFond"
									   onclick="requestVariousInfos('{FONCTCOT/VALCOT}',cstCotationNonDif,'{$ident}')">
										<u>
											<xsl:value-of select="FONCTCOT/VALCOT"/>
										</u>
									</a>
								</td>
							</xsl:if>
						</xsl:if>
						<xsl:if test="(FONCTCOT/VALCOT='NS')">
							<td class="clFond clWidth315"
							    colspan="3"/>
						</xsl:if>
					</tr>
				</xsl:if>
			</xsl:if>
			<xsl:if test="PP">
				<xsl:variable name="ident"
				              select="PP/IDENTC"/>
				<tr>
					<th class="clCouleur2 clWidth59 clAlignLeft clValignMiddle clThNonGras">&#160;Identifiant</th>
					<td class="clFond clWidth255">
            &#160;<xsl:value-of select="PP/IDENTC"/>
					</td>
					<xsl:if test="not(FONCTCOT/VALCOT='NS')">
						<td class="clFond clWidth166"/>
						<th class="clCouleur2 clWidth60 clAlignLeft clThNonGras">&#160;Indicateur</th>
						<xsl:if test="not(FONCTCOT/VALCOT='ND')">
							<td class="clFond clWidth89 clValignMiddle clAlignRight">
                &#160;<a href="#nullepart"
								   class="clFond"
								   onclick="requestVariousInfos('{FONCTCOT/VALCOT}',cstCotation,'{$ident}')">
									<u>
										<xsl:value-of select="FONCTCOT/VALCOT"/>
									</u>
								</a>
							</td>
						</xsl:if>
						<xsl:if test="(FONCTCOT/VALCOT='ND')">
							<td class="clFond clWidth89 clValignMiddle clAlignRight">
                &#160;<a href="#nullepart"
								   class="clFond"
								   onclick="requestVariousInfos('{FONCTCOT/VALCOT}',cstCotationNonDif,'{$ident}')">
									<u>
										<xsl:value-of select="FONCTCOT/VALCOT"/>
									</u>
								</a>
							</td>
						</xsl:if>
					</xsl:if>
					<xsl:if test="(FONCTCOT/VALCOT='NS')">
						<td class="clFond clWidth315"
						    colspan="3"/>
					</xsl:if>
				</tr>
				<xsl:choose>
					<xsl:when test="FONCTCOT/AUTRFDEI">
						<xsl:if test="not(FONCTCOT/VALCOT='NS')">
							<tr>
								<td class="clTexte clAlignLeft"
								    colspan="4">
                  &#160;Présence d&#039;autre(s) fonction(s) de représentant(s) légal(aux) exercée(s)
                </td>
								<td class="clWidth89 clValignMiddle clAlignRight">
                  &#160;<a href="#nullePart"
									   onclick="requestBDFInfos('56','','1','{$ident}',cstSimpleConfirm);">
										<img src="{$root}Images/Commun/clignotant2.gif"
										     width="84"
										     border="0"
										     alt="plus d'infos"/>
									</a>
								</td>
							</tr>
						</xsl:if>
					</xsl:when>
					<xsl:otherwise>
						<tr>
							<td class="clTexteGras clAlignLeft"
							    colspan="4">
                &#160;
              </td>
							<td class="clWidth92">
                &#160;
              </td>
						</tr>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:call-template name="shim"/>
		</table>
		<xsl:if test="position() mod 9 = 0">
			<div class="clBreakPage"/>
		</xsl:if>
		<xsl:if test="position() = last()">
			<xsl:if test="//INFODIRIGEANTS/DIRIGEANTS/AUTRFDEJ">
				<xsl:call-template name="shim"/>
				<table class="clWidth635 clBorderCell"
				       role="presentation">
					<tr>
						<td class="clCouleur2 clWidth530 clHeight14"
						    colspan="4">
							<br/>« Le(s) responsable(s) légal(aux) de cette entreprise détienne(nt) d&#039;autres fonctions de représentant(s) légal(aux)»
            </td>
						<td class="clWidth105 clHeight14 clValignMiddle clAlignRight">
							<a href="#nullepart"
							   onClick="requestBDFInfos('51','','1','{EJ/IDENTS}',cstSimpleConfirm);">
								<img src="{$root}images/Commun/clignotant2.gif"
								     width="85"
								     height="12"
								     border="0"
								     align="absbottom"
								     alt="plus d'infos"/>
							</a>
						</td>
					</tr>
				</table>
				<xsl:call-template name="shim"/>
			</xsl:if>
			<xsl:if test="not(//INFODIRIGEANTS/DIRIGEANTS/AUTRFDEJ)">
				<xsl:if test="//INFODIRIGEANTS/DIRIGEANTS/SUITE">
					<xsl:call-template name="shim"/>
					<table class="clWidth635 clBorderCell"
					       role="presentation">
						<tr>
							<td class="clCouleur2 clWidth530 clHeight14"
							    colspan="4"/>
							<td class="clWidth105 clHeight14 clValignMiddle clAlignRight">
								<a href="#nullepart"
								   onClick="requestBDFInfos('51','','1','{MODULEDE/EJ/IDENTS}',cstSimpleConfirm);">
									<img src="{$root}images/Commun/clignotant2.gif"
									     width="85"
									     height="12"
									     border="0"
									     align="absbottom"
									     alt="plus d'infos"/>
								</a>
							</td>
						</tr>
					</table>
					<xsl:call-template name="shim"/>
				</xsl:if>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<xsl:template match="NBDIRIGEANTCESSEDO">
		<a name="ancCesse"/>
		<table class="clWidth635 clBorderCell"
		       role="pressentation">
			<tr class="clAlignCenter">
				<td class="clCouleurGras">
          DIRIGEANT(S) DE L'ENTREPRISE AYANT CESS&#201; SON(LEUR) ACTIVIT&#201; (<xsl:value-of select="."/>)<br/>
					<!--<xsl:call-template name="shim"/>-->
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template match="DIRIGEANTCESSE">
		<table class="clBorderCell clWidth739">
			<caption class="visually-hidden">DIRIGEANT(S) DE L'ENTREPRISE AYANT CESSÉ SON(LEUR) ACTIVITÉ</caption>
			<tr>
				<td class="clGrasFond"
				    colspan="2">
					<xsl:apply-templates select="FONCTCOT"/>
				</td>
				<xsl:if test="FONCTCOT/DATFONCT">
					<th class="clFond clAlignRight clThNonGras"
					    colspan="2"> Depuis le :</th>
					<td class="clFond clWidth90 clAlignRight">
						<xsl:call-template name="displayDateXsl">
							<xsl:with-param name="InputDate"
							                select="(FONCTCOT/DATFONCT)"/>
						</xsl:call-template>
					</td>
				</xsl:if>
				<xsl:if test="not(FONCTCOT/DATFONCT)">
					<td colspan="2"
					    class="clFond">&#160;</td>
					<td class="clFond clWidth90">&#160;</td>
				</xsl:if>
				<xsl:if test="position() mod 3 = 0">
					<td class="clWidth103 clAlignRight"
					    rowspan="3">
						<a href="#ancHaut">
							<img src="{$root}Images/risque/fleche_haut.gif"
							     width="18"
							     height="18"
							     border="0"
							     name="Image112"
							     alt="Retour en haut de la page"/>
						</a>
					</td>
				</xsl:if>
				<xsl:if test="position() mod 3 != 0">
					<td class="clWidth103 clAlignRight"
					    rowspan="3">
            &#160;
          </td>
				</xsl:if>
			</tr>
			<xsl:apply-templates select="CESSATION"/>
			<tr>
				<xsl:if test="EJ/DENOM">
					<td class="clGrasFond"
					    colspan="5">
            &#160;<xsl:value-of select="EJ/DENOM"/>
					</td>
				</xsl:if>
				<xsl:if test="not(EJ/DENOM)">
					<td class="clGrasFond clWidth315"
					    colspan="2">
            &#160;<xsl:call-template name="displayInLowerCaseXsl">
							<xsl:with-param name="InputStringNom"
							                select="(PP/IDENTITE/NOM)"/>
							<xsl:with-param name="InputStringPrenom"
							                select="(PP/IDENTITE/PRENOM)"/>
						</xsl:call-template>
					</td>
					<xsl:if test="PP/IDENTITE/NOMCONJ">
						<td colspan="3">
							<table class="clWidthMax clBorderCell">
								<tr>
									<th class="clCouleur2 clWidth77 clAlignLeft clThNonGras">&#160;Nom marital</th>
									<td class="clFond clAlignLeft"
									    colspan="2">
                    &#160;
                    <xsl:value-of select="PP/IDENTITE/NOMCONJ"/>
									</td>
								</tr>
							</table>
						</td>
					</xsl:if>
					<xsl:if test="not(PP/IDENTITE/NOMCONJ)">
						<td class="clGrasFond clWidth54">&#160;</td>
						<td colspan="2"
						    class="clGrasFond">&#160;</td>
					</xsl:if>
				</xsl:if>
			</tr>
			<xsl:if test="EJ">
				<xsl:variable name="ident"
				              select="EJ/IDENTS"/>
				<xsl:if test="FONCTCOT/SEGMENT">
					<tr>
						<th class="clCouleur2 clWidth59 clAlignLeft clValignMiddle clThNonGras">&#160;Identifiant</th>
						<td class="clTexte clWidth255">
              &#160;<xsl:call-template name="displaySirenXsl">
								<xsl:with-param name="InputSiren"
								                select="(EJ/IDENTS)"/>
							</xsl:call-template>
						</td>
						<xsl:if test="not(FONCTCOT/VALCOT='NS')">
							<td class="clTexte clWidth81"/>
							<th class="clCouleur2 clWidth145 clAlignLeft clThNonGras">&#160;Cotation | Segmentation</th>
							<xsl:if test="not(FONCTCOT/VALCOT='ND')">
								<td class="clTexte clWidth89 clValignMiddle clAlignRight">
                  &#160;<a href="#nullepart"
									   class="clTexte"
									   onclick="requestVariousInfos('{FONCTCOT/VALCOT}',cstCotation,'{$ident}')">
										<u>
											<xsl:value-of select="FONCTCOT/VALCOT"/>
										</u>
									</a>
									<a href="#nullepart"
									   class="clTexte"
									   onclick="requestInfosLibelle('segmentation',cstSegment);">
                  &#160;|&#160;
                    <u>
											<xsl:value-of select="FONCTCOT/SEGMENT"/>
										</u>
									</a>
								</td>
							</xsl:if>
							<xsl:if test="(FONCTCOT/VALCOT='ND')">
								<td class="clTexte clWidth89 clValignMiddle clAlignRight">
                    &#160;<a href="#nullepart"
									   class="clTexte"
									   onclick="requestVariousInfos('{FONCTCOT/VALCOT}',cstCotationNonDif,'{$ident}')">
										<u>
											<xsl:value-of select="FONCTCOT/VALCOT"/>
										</u>
									</a>
									<a href="#nullepart"
									   class="clTexte"
									   onclick="requestInfosLibelle('segmentation',cstSegment);">
                      &#160;|&#160;
                      <u>
											<xsl:value-of select="FONCTCOT/SEGMENT"/>
										</u>
									</a>
								</td>
							</xsl:if>
						</xsl:if>
						<xsl:if test="(FONCTCOT/VALCOT='NS')">
							<td class="clTexte clWidth315"
							    colspan="3"/>
						</xsl:if>
					</tr>
					<tr>
						<td class="clTexteGras clAlignLeft"
						    colspan="4">
              &#160;
            </td>
						<td class="clWidth92">
              &#160;
            </td>
					</tr>
				</xsl:if>
				<xsl:if test="not(FONCTCOT/SEGMENT)">
					<tr>
						<th class="clCouleur2 clWidth59 clAlignLeft clValignMiddle clThNonGras">&#160;Identifiant</th>
						<td class="clTexte clWidth255">
              &#160;<xsl:call-template name="displaySirenXsl">
								<xsl:with-param name="InputSiren"
								                select="(EJ/IDENTS)"/>
							</xsl:call-template>
						</td>
						<xsl:if test="not(FONCTCOT/VALCOT='NS')">
							<td class="clTexte clWidth166"/>
							<th class="clCouleur2 clWidth60 clAlignLeft clThNonGras">&#160;Cotation</th>
							<xsl:if test="not(FONCTCOT/VALCOT='ND')">
								<td class="clTexte clWidth89 clValignMiddle clAlignRight">
                &#160;<a href="#nullepart"
									   class="clTexte"
									   onclick="requestVariousInfos('{FONCTCOT/VALCOT}',cstCotation,'{$ident}')">
										<u>
											<xsl:value-of select="FONCTCOT/VALCOT"/>
										</u>
									</a>
								</td>
							</xsl:if>
							<xsl:if test="(FONCTCOT/VALCOT='ND')">
								<td class="clTexte clWidth89 clValignMiddle clAlignRight">
                &#160;<a href="#nullepart"
									   class="clTexte"
									   onclick="requestVariousInfos('{FONCTCOT/VALCOT}',cstCotationNonDif,'{$ident}')">
										<u>
											<xsl:value-of select="FONCTCOT/VALCOT"/>
										</u>
									</a>
								</td>
							</xsl:if>
						</xsl:if>
						<xsl:if test="(FONCTCOT/VALCOT='NS')">
							<td class="clTexte clWidth315"
							    colspan="3"/>
						</xsl:if>
					</tr>
					<tr>
						<td class="clTexteGras clAlignLeft"
						    colspan="4">
              &#160;
            </td>
						<td class="clWidth92">
              &#160;
            </td>
					</tr>
				</xsl:if>
			</xsl:if>
			<xsl:if test="PP">
				<xsl:variable name="ident"
				              select="PP/IDENTC"/>
				<tr>
					<th class="clCouleur2 clWidth59 clAlignLeft clValignMiddle clThNonGras">&#160;Identifiant</th>
					<td class="clTexte clWidth255">
            &#160;<xsl:value-of select="PP/IDENTC"/>
					</td>
					<xsl:if test="not(FONCTCOT/VALCOT='NS')">
						<td class="clTexte clWidth166"/>
						<th class="clCouleur2 clWidth60 clAlignLeft clThNonGras">&#160;Indicateur</th>
						<xsl:if test="not(FONCTCOT/VALCOT='ND')">
							<td class="clTexte clWidth89 clValignMiddle clAlignRight">
              &#160;<a href="#nullepart"
								   class="clTexte"
								   onclick="requestVariousInfos('{FONCTCOT/VALCOT}',cstCotation,'{$ident}')">
									<u>
										<xsl:value-of select="FONCTCOT/VALCOT"/>
									</u>
								</a>
							</td>
						</xsl:if>
						<xsl:if test="(FONCTCOT/VALCOT='ND')">
							<td class="clTexte clWidth89 clValignMiddle clAlignRight">
              &#160;<a href="#nullepart"
								   class="clTexte"
								   onclick="requestVariousInfos('{FONCTCOT/VALCOT}',cstCotationNonDif,'{$ident}')">
									<u>
										<xsl:value-of select="FONCTCOT/VALCOT"/>
									</u>
								</a>
							</td>
						</xsl:if>
					</xsl:if>
					<xsl:if test="(FONCTCOT/VALCOT='NS')">
						<td class="clTexte clWidth315"
						    colspan="3"/>
					</xsl:if>
				</tr>
				<xsl:choose>
					<xsl:when test="FONCTCOT/AUTRFDEI">
						<xsl:if test="not(FONCTCOT/VALCOT='NS')">
							<tr>
								<td class="clTexte clAlignLeft"
								    colspan="4">
                  &#160;Présence d&#039;autre(s) fonction(s) de représentant(s) légal(aux) exercée(s)
                </td>
								<td class="clWidth89 clValignMiddle clAlignRight">
                  &#160;<a href="#nullePart"
									   onclick="requestBDFInfos('56','','1','{$ident}',cstSimpleConfirm);">
										<img src="{$root}Images/Commun/clignotant2.gif"
										     width="84"
										     border="0"
										     alt="plus d'infos"/>
									</a>
								</td>
							</tr>
						</xsl:if>
					</xsl:when>
					<xsl:otherwise>
						<tr>
							<td class="clTexteGras clAlignLeft"
							    colspan="4">
                &#160;
              </td>
							<td class="clWidth92">
                &#160;
              </td>
						</tr>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:call-template name="shim"/>
		</table>
		<xsl:if test="position() = last()">
			<xsl:if test="//INFODIRIGEANTS/DIRIGEANTSCESSES/SUITE">
				<xsl:call-template name="shim"/>
				<table class="clWidth635 clBorderCell"
				       role="presentation">
					<tr>
						<td class="clCouleur2 clWidth530 clHeight14"
						    colspan="4"/>
						<td class="clWidth105 clHeight14 clValignMiddle clAlignRight">
							<a href="#nullepart"
							   onClick="requestBDFInfos('51','','1','{MODULEDE/EJ/IDENTS}',cstSimpleConfirm);">
								<img src="{$root}images/Commun/clignotant2.gif"
								     width="85"
								     height="12"
								     border="0"
								     align="absbottom"
								     alt="plus d'infos"/>
							</a>
						</td>
					</tr>
				</table>
				<xsl:call-template name="shim"/>
			</xsl:if>
			<xsl:if test="position() mod 10 = 0">
				<div class="clBreakPage"/>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<xsl:template match="CESSATION">
		<tr>
			<td class="clTexte"
			    colspan="2">
        &#160;<xsl:call-template name="traduction">
					<xsl:with-param name="code"
					                select="@COCESS"/>
				</xsl:call-template>
			</td>
			<xsl:if test="@DATCESS != ''">
				<th class="clTexte clAlignRight clThNonGras"
				    colspan="2"> Cess&#233;(e) depuis le :</th>
				<td class="clTexte clAlignRight clWidth90">
					<xsl:call-template name="displayDateXsl">
						<xsl:with-param name="InputDate"
						                select="(@DATCESS)"/>
					</xsl:call-template>
				</td>
			</xsl:if>
			<xsl:if test="not(@DATCESS)">
				<td colspan="2"
				    class="clFond">&#160;</td>
				<td class="clTexte clWidth90">&#160;</td>
			</xsl:if>
		</tr>
	</xsl:template>
	<!--********************************************************************************************************************************************************************-->
	<!--*********************************    Bloc associe(s)    *************************************************************************************-->
	<!--********************************************************************************************************************************************************************-->
	<xsl:template match="INFOASSOCIES">
		<xsl:apply-templates select="NBASSOCIEDO"/>
		<xsl:apply-templates select="ASSOCIE"/>
	</xsl:template>
	<xsl:template match="NBASSOCIEDO">
		<a name="Associes"/>
		<table class="clBorderCell clWidth739"
		       role="presentation">
			<tr class="clAlignCenter">
				<td class="clCouleurGras clWidth631"
				    colspan="7">
          PRINCIPAL(AUX) ASSOCIE(S) (<xsl:value-of select="."/>)
        </td>
				<td/>
				<td class="clWidth103 clAlignRight">
					<a href="#ancHaut">
						<img src="{$root}Images/risque/fleche_haut.gif"
						     width="18"
						     height="18"
						     border="0"
						     name="Image112"
						     alt="Retour en haut de la page"/>
					</a>
				</td>
			</tr>
		</table>
		<xsl:call-template name="shim"/>
	</xsl:template>
	<xsl:template match="ASSOCIE">
		<xsl:apply-templates select="CAPITAL">
			<xsl:with-param name="indice"
			                select="position()"/>
		</xsl:apply-templates>
		<xsl:apply-templates select="ASSOCSPE|ASSOCPP|ASSOCEJ"/>
	</xsl:template>
	<xsl:template match="CAPITAL">
		<xsl:param name="indice"/>
		<table class="clBorderCell clWidth739">
			<caption class="visually-hidden">Principal(aux) associé(s). Pourcentage de capital détenu</caption>
			<tr>
				<th class="clCouleur2 clWidth130 clAlignLeft clThNonGras">&#160;Pourcentage détenu</th>
				<td class="clFond clWidth105">
          &#160;<xsl:value-of select="POURCENTAGE"/>
				</td>
				<td class="clFond clWidth57">&#160;</td>
				<td class="clFond clWidth167 clAlignRight">&#160;</td>
				<xsl:if test="DATDET">
					<th class="clFond clWidth65 clAlignRight clThNonGras">&#160;Depuis le :</th>
					<td class="clFond clWidth89 clAlignRight">
						<xsl:call-template name="displayDateXsl">
							<xsl:with-param name="InputDate"
							                select="(DATDET)"/>
						</xsl:call-template>&#160;
          </td>
				</xsl:if>
				<xsl:if test="not(DATDET)">
					<td class="clFond clWidth60 clAlignRight">&#160;</td>
					<td class="clFond clWidth89 clAlignRight">&#160;</td>
				</xsl:if>
				<xsl:if test="$indice mod 3 = 0">
					<td class="clWidth103 clAlignRight">
						<a href="#ancHaut">
							<img src="{$root}Images/risque/fleche_haut.gif"
							     width="18"
							     height="18"
							     border="0"
							     name="Image112"
							     alt="Retour en haut de la page"/>
						</a>
					</td>
				</xsl:if>
				<xsl:if test="$indice mod 3 != 0">
					<td class="clWidth103 clAlignRight">
            &#160;
          </td>
				</xsl:if>
			</tr>
		</table>
	</xsl:template>
	<xsl:template match="ASSOCSPE">
		<table class="clWidth633 clBorderCell">
			<caption class="visually-hidden">Associé(s) spécial(aux)</caption>
			<tr class="clAlignLeft clValignMiddle">
				<td colspan="2"
				    class="clGras">
          &#160;<xsl:value-of select="DENOM"/>
				</td>
				<td class="clWidth57"/>
				<td colspan="3"/>
			</tr>
			<tr>
				<td colspan="4">
          &#160;
        </td>
				<td class="clWidth95">
          &#160;
        </td>
			</tr>
		</table>
		<xsl:call-template name="shim"/>
	</xsl:template>
	<xsl:template match="ASSOCPP">
		<table class="clWidth633 clBorderCell">
			<caption class="visually-hidden">Associé personne physique</caption>
			<tr>
				<td colspan="2"
				    class="clGras">
          &#160;<xsl:call-template name="displayInLowerCaseXsl">
						<xsl:with-param name="InputStringNom"
						                select="(PP/IDENTITE/NOM)"/>
						<xsl:with-param name="InputStringPrenom"
						                select="(PP/IDENTITE/PRENOM)"/>
					</xsl:call-template>
				</td>
				<xsl:if test="PP/IDENTITE/NOMCONJ">
					<th class="clCouleur2 clWidth77 clAlignLeft clThNonGras">&#160;Nom marital</th>
					<td class="clTexte"
					    colspan="3">
            &#160;<xsl:value-of select="PP/IDENTITE/NOMCONJ"/>
					</td>
				</xsl:if>
				<xsl:if test="not(PP/IDENTITE/NOMCONJ)">
					<td class="clCouleur2 clWidth57">&#160;</td>
					<td class="clTexte"
					    colspan="3">&#160;</td>
				</xsl:if>
			</tr>
			<xsl:choose>
				<xsl:when test="AUTRFDEI">
					<tr class="clValignMiddle">
						<th class="clCouleur2 clWidth130 clAlignLeft clThNonGras">&#160;Identifiant </th>
						<td class="clFond clWidth182 clAlignLeft">
              &#160;<xsl:value-of select="PP/IDENTC"/>
						</td>
						<xsl:if test="not(VALCOT='NS')">
							<th class="clCouleur2 clWidth80 clAlignLeft clThNonGras">&#160;Indicateur</th>
							<xsl:if test="not(VALCOT='ND')">
								<td class="clFond clWidth118 clAlignLeft">
                &#160;<a href="#nullepart"
									   class="clFond"
									   onclick="requestVariousInfos('{VALCOT}',cstCotation,'{PP/IDENTC}');">
										<u>
											<xsl:value-of select="VALCOT"/>
										</u>
									</a>
								</td>
							</xsl:if>
							<xsl:if test="(VALCOT='ND')">
								<td class="clFond clWidth118 clAlignLeft">
                &#160;<a href="#nullepart"
									   class="clFond"
									   onclick="requestVariousInfos('{VALCOT}',cstCotationNonDif,'{PP/IDENTC}');">
										<u>
											<xsl:value-of select="VALCOT"/>
										</u>
									</a>
								</td>
							</xsl:if>
							<td class="clFond clWidth95 clAlignRight">
								<a href="#nullepart"
								   onClick="requestBDFInfos('27|37|53|56|','','1','{PP/IDENTC}',cstMultipleConfirm);">
									<img src="{$root}Images/Commun/clignotant2.gif"
									     width="90"
									     title="Plus d'infos"
									     alt="Plus d'infos"
									     border="0"/>
								</a>
							</td>
						</xsl:if>
						<xsl:if test="(VALCOT='NS')">
							<td class="clFond clWidth80"/>
							<td class="clFond clWidth118"/>
							<td class="clFond clWidth95 clAlignRight">
								<a href="#nullepart"
								   onClick="requestBDFInfos('27','','1','{PP/IDENTC}',cstMultipleConfirm);">
									<img src="{$root}Images/Commun/clignotant2.gif"
									     width="90"
									     height="12"
									     title="Plus d'infos"
									     alt="Plus d'infos"
									     border="0"/>
								</a>
							</td>
						</xsl:if>
					</tr>
					<tr>
						<td class="clTexte clAlignLeft"
						    colspan="4">
              &#160;Présence d&#039;autre(s) fonction(s) de représentant(s) légal(aux) exercée(s)
            </td>
						<td class="clWidth95">
              &#160;
            </td>
					</tr>
				</xsl:when>
				<xsl:otherwise>
					<tr class="clValignMiddle">
						<th class="clCouleur2 clWidth130 clAlignLeft clThNonGras">&#160;Identifiant </th>
						<td class="clFond clWidth182 clAlignLeft">
              &#160;<xsl:value-of select="PP/IDENTC"/>
						</td>
						<xsl:if test="not(VALCOT='NS')">
							<th class="clCouleur2 clWidth80 clAlignLeft clThNonGras">&#160;Indicateur</th>
							<xsl:if test="not(VALCOT='ND')">
								<td class="clFond clWidth118 clAlignLeft">
                &#160;<a href="#nullepart"
									   class="clFond"
									   onclick="requestVariousInfos('{VALCOT}',cstCotation,'{PP/IDENTC}');">
										<u>
											<xsl:value-of select="VALCOT"/>
										</u>
									</a>
								</td>
							</xsl:if>
							<xsl:if test="(VALCOT='ND')">
								<td class="clFond clWidth118 clAlignLeft">
                &#160;<a href="#nullepart"
									   class="clFond"
									   onclick="requestVariousInfos('{VALCOT}',cstCotationNonDif,'{PP/IDENTC}');">
										<u>
											<xsl:value-of select="VALCOT"/>
										</u>
									</a>
								</td>
							</xsl:if>
							<td class="clFond clWidth95 clAlignRight">
								<a href="#nullepart"
								   onClick="requestBDFInfos('27|37|53|','','1','{PP/IDENTC}',cstMultipleConfirm);">
									<img src="{$root}Images/Commun/clignotant2.gif"
									     width="90"
									     height="12"
									     title="Plus d'infos"
									     alt="Plus d'infos"
									     border="0"/>
								</a>
							</td>
						</xsl:if>
						<xsl:if test="(VALCOT='NS')">
							<td class="clFond clWidth80"/>
							<td class="clFond clWidth118"/>
							<td class="clFond clWidth95 clAlignRight">
								<a href="#nullepart"
								   onClick="requestBDFInfos('27','','1','{PP/IDENTC}',cstMultipleConfirm);">
									<img src="{$root}Images/Commun/clignotant2.gif"
									     width="90"
									     height="12"
									     title="Plus d'infos"
									     alt="Plus d'infos"
									     border="0"/>
								</a>
							</td>
						</xsl:if>
					</tr>
					<tr>
						<td class="clTexteGras clAlignLeft"
						    colspan="4">
              &#160;
            </td>
						<td class="clWidth95">
              &#160;
            </td>
					</tr>
				</xsl:otherwise>
			</xsl:choose>
		</table>
		<xsl:call-template name="shim"/>
	</xsl:template>
	<xsl:template match="ASSOCEJ">
		<table class="clWidth633 clBorderCell">
			<caption class="visually-hidden">Associé entité juridique</caption>
			<tr>
				<td class="clGras clWidth635"
				    colspan="6">
          &#160;<xsl:value-of select="EJ/DENOM"/>
				</td>
			</tr>
			<tr>
				<td class="clFond clWidth636 clAlignLeft"
				    colspan="6">
          &#160;<xsl:value-of select="LOCALI"/>
				</td>
			</tr>
		</table>
		<xsl:if test="not(SEGMENT)">
			<table class="clWidth633 clBorderCell">
				<tr class="clAlignLeft clValignMiddle">
					<th class="clCouleur2 clWidth130 clHeight16 clAlignLeft clThNonGras">&#160;Identifiant </th>
					<td class="clTexte clWidth182 clAlignLeft">
            &#160;<xsl:call-template name="displaySirenXsl">
							<xsl:with-param name="InputSiren"
							                select="(EJ/IDENTS)"/>
						</xsl:call-template>
					</td>
					<td class="clTexte"
					    colspan="2"/>
					<xsl:variable name="locali"
					              select="LOCALI"/>
					<xsl:choose>
						<!--Test si le début de la localité est un code postal -> Résident ou non-->
						<xsl:when test="(number(substring(LOCALI,0,5)) or ($locali='MC MONACO'))">
							<th class="clCouleur2 clWidth80 clAlignLeft clThNonGras">&#160;Cotation</th>
							<xsl:if test="not(VALCOT='ND')">
								<td class="clTexte clWidth118 clAlignLeft">
                  &#160;<a href="#nullepart"
									   class="clTexte"
									   onclick="requestVariousInfos('{VALCOT}',cstCotation,'{EJ/IDENTS|PP/IDENTC}')">
										<u>
											<xsl:value-of select="VALCOT"/>
										</u>
									</a>
								</td>
							</xsl:if>
							<xsl:if test="(VALCOT='ND')">
								<td class="clTexte clWidth118 clAlignLeft">
                &#160;<a href="#nullepart"
									   class="clTexte"
									   onclick="requestVariousInfos('{VALCOT}',cstCotationNonDif,'{EJ/IDENTS|PP/IDENTC}')">
										<u>
											<xsl:value-of select="VALCOT"/>
										</u>
									</a>
								</td>
							</xsl:if>
							<td class="clTexte clWidth95 clAlignRight">
								<a href="#nullepart"
								   onClick="requestBDFInfos('27|37|53|','','{$familyNumber}','{EJ/IDENTS}',cstMultipleConfirm);">
									<img src="{$root}Images/Commun/clignotant2.gif"
									     width="90"
									     height="12"
									     title="Plus d'infos"
									     alt="Plus d'infos"
									     border="0"/>
								</a>
							</td>
						</xsl:when>
						<xsl:otherwise>
							<td class="clWidth65 clAlignLeft">&#160;</td>
							<td class="clWidth89 clAlignRight"/>
						</xsl:otherwise>
					</xsl:choose>
				</tr>
				<tr>
					<td colspan="4">
            &#160;
          </td>
					<td class="clWidth95">
            &#160;
          </td>
				</tr>
			</table>
		</xsl:if>
		<xsl:if test="SEGMENT">
			<table class="clWidth633 clBorderCell">
				<tr class="clAlignLeft clValignMiddle">
					<th class="clCouleur2 clWidth130 clHeight16 clAlignLeft clThNonGras">&#160;Identifiant </th>
					<td class="clTexte clWidth105 clAlignLeft">
            &#160;<xsl:call-template name="displaySirenXsl">
							<xsl:with-param name="InputSiren"
							                select="(EJ/IDENTS)"/>
						</xsl:call-template>
					</td>
					<td class="clTexte clWidth143"
					    colspan="2"/>
					<xsl:variable name="locali"
					              select="LOCALI"/>
					<xsl:choose>
						<!--Test si le début de la localité est un code postal -> Résident ou non-->
						<xsl:when test="(number(substring(LOCALI,0,5)) or ($locali='MC MONACO'))">
							<th class="clCouleur2 clWidth145 clAlignLeft clThNonGras">&#160;Cotation | Segmentation</th>
							<xsl:if test="not(VALCOT='ND')">
								<td class="clTexte clWidth89 clAlignRight">
                &#160;<a href="#nullepart"
									   class="clTexte"
									   onclick="requestVariousInfos('{VALCOT}',cstCotation,'{EJ/IDENTS|PP/IDENTC}')">
										<u>
											<xsl:value-of select="VALCOT"/>
										</u>
									</a>
									<a href="#nullepart"
									   class="clTexte"
									   onclick="requestInfosLibelle('segmentation',cstSegment);">
                  &#160;|&#160;
                  <u>
											<xsl:value-of select="SEGMENT"/>
										</u>
									</a>
								</td>
							</xsl:if>
							<xsl:if test="(VALCOT='ND')">
								<td class="clTexte clWidth89 clAlignRight">
                &#160;<a href="#nullepart"
									   class="clTexte"
									   onclick="requestVariousInfos('{VALCOT}',cstCotationNonDif,'{EJ/IDENTS|PP/IDENTC}')">
										<u>
											<xsl:value-of select="VALCOT"/>
										</u>
									</a>
									<a href="#nullepart"
									   class="clTexte"
									   onclick="requestInfosLibelle('segmentation',cstSegment);">
                  &#160;|&#160;
                  <u>
											<xsl:value-of select="SEGMENT"/>
										</u>
									</a>
								</td>
							</xsl:if>
						</xsl:when>
						<xsl:otherwise>
							<td class="clCouleur2 clWidth145 clAlignLeft">&#160;</td>
							<td class="clTexte clWidth89 clAlignRight"/>
						</xsl:otherwise>
					</xsl:choose>
				</tr>
				<tr>
					<td colspan="4">
            &#160;
          </td>
					<td class="clWidth95">
            &#160;
          </td>
				</tr>
			</table>
		</xsl:if>
		<xsl:call-template name="shim"/>
	</xsl:template>
	<!--********************************************************************************************************************************************************************-->
	<!--*********************************    Bloc participations    *************************************************************************************-->
	<!--********************************************************************************************************************************************************************-->
	<xsl:template match="INFOPARTICIPATIONS">
		<xsl:apply-templates select="NBPARTICIPATIONDO"/>
		<xsl:apply-templates select="PARTICIPATION"/>
	</xsl:template>
	<xsl:template match="NBPARTICIPATIONDO">
		<a name="ancPartic"/>
		<table class="clWidth635 clBorderCell"
		       role="presentation">
			<tr class="clAlignCenter">
				<td class="clCouleurGras">
          PRINCIPALE(S) PARTICIPATION(S) (<xsl:value-of select="."/>)
        </td>
			</tr>
		</table>
		<xsl:call-template name="shim"/>
		<br/>
	</xsl:template>
	<xsl:template match="PARTICIPATION">
		<xsl:variable name="actbdf"
		              select="ACTBDF"/>
		<table class="clBorderCell clWidth739">
			<caption class="visually-hidden">Principale(s) participation(s). Pourcentage détenu</caption>
			<tr>
				<th class="clCouleur2 clWidth130 clAlignLeft clThNonGras">&#160;Pourcentage d&#233;tenu</th>
				<td class="clFond clWidth107">
          &#160;<xsl:value-of select="CAPITAL/POURCENTAGE"/>
				</td>
				<td class="clFond clWidth155">&#160;</td>
				<xsl:if test="CAPITAL/DATDET">
					<th class="clFond clAlignRight clWidth148 clThNonGras">Depuis le</th>
					<td class="clFond clAlignRight clWidth95">
						<xsl:call-template name="displayDateXsl">
							<xsl:with-param name="InputDate"
							                select="(CAPITAL/DATDET)"/>
						</xsl:call-template>&#160;
          </td>
				</xsl:if>
				<xsl:if test="not(CAPITAL/DATDET)">
					<td class="clFond clAlignRight clWidth148">&#160;</td>
					<td class="clFond clAlignRight clWidth95">&#160;</td>
				</xsl:if>
				<xsl:if test="position() mod 3 = 0">
					<td class="clWidth103 clAlignRight"
					    rowspan="4">
						<a href="#ancHaut">
							<img src="{$root}Images/risque/fleche_haut.gif"
							     width="18"
							     height="18"
							     border="0"
							     name="Image112"
							     alt="Retour en haut de la page"/>
						</a>
					</td>
				</xsl:if>
				<xsl:if test="position() mod 3 != 0">
					<td class="clWidth103 clAlignRight"
					    rowspan="4">
            &#160;
          </td>
				</xsl:if>
			</tr>
		</table>
		<table class="clWidth635 clBorderCell">
			<caption class="visually-hidden">Principale(s) participation(s). Dénomination</caption>
			<tr>
				<td class="clTexte clWidth635"
				    colspan="5">
          &#160;<xsl:value-of select="EJ/DENOM"/>
				</td>
			</tr>
		</table>
		<table class="clWidth635 clBorderCell">
			<caption class="visually-hidden">Principale(s) participation(s). Activité BDF</caption>
			<tr>
				<td class="clFond clWidth312"
				    colspan="2">
          &#160;<xsl:value-of select="LOCALI"/>
				</td>
				<td class="clCouleur2 clWidth80 clAlignLeft">&#160;Activit&#233; BDF</td>
				<td class="clFond clWidth243"
				    colspan="2">
					<a href="#nullepart"
					   class="clTexte"
					   onclick="requestInfosLibelle('{$actbdf}',cstWordingNew)">
						<u>
							<xsl:value-of select="ACTBDF"/>
						</u>
					</a>
				</td>
			</tr>
		</table>
		<xsl:if test="not(SEGMENT)">
			<table class="clWidth635 clBorderCell">
				<caption class="visually-hidden">Principale(s) participation(s). Informations</caption>
				<tr>
					<th class="clCouleur2 clWidth130 clAlignLeft clThNonGras">&#160;Identifiant</th>
					<td class="clTexte clWidth182">
            &#160;<xsl:call-template name="displaySirenXsl">
							<xsl:with-param name="InputSiren"
							                select="(EJ/IDENTS)"/>
						</xsl:call-template>
					</td>
					<xsl:variable name="locali"
					              select="LOCALI"/>
					<xsl:choose>
						<!--Test si le début de la localité est un code postal -> Résident ou non-->
						<xsl:when test="(number(substring(LOCALI,0,5)) or ($locali='MC MONACO'))">
							<th class="clCouleur2 clWidth80 clAlignLeft clThNonGras">&#160;Cotation</th>
							<xsl:if test="not(VALCOT='ND')">
								<td class="clTexte clWidth148">
                &#160;<a href="#nullepart"
									   class="clTexte"
									   onclick="requestVariousInfos('{VALCOT}',cstCotation,'{EJ/IDENTS}');">
										<u>
											<xsl:value-of select="VALCOT"/>
										</u>
									</a>
								</td>
							</xsl:if>
							<xsl:if test="(VALCOT='ND')">
								<td class="clTexte clWidth148">
                &#160;<a href="#nullepart"
									   class="clTexte"
									   onclick="requestVariousInfos('{VALCOT}',cstCotationNonDif,'{EJ/IDENTS}');">
										<u>
											<xsl:value-of select="VALCOT"/>
										</u>
									</a>
								</td>
							</xsl:if>
							<td class="clTexte clWidth95 clAlignRight">
								<a href="#nullepart"
								   onClick="requestBDFInfos('27|37|53|','','1','{EJ/IDENTS}',cstMultipleConfirm);">
									<img src="{$root}Images/Commun/clignotant2.gif"
									     width="90"
									     height="12"
									     title="Plus d'infos"
									     alt="Plus d'infos"
									     border="0"/>
								</a>
							</td>
						</xsl:when>
						<xsl:otherwise>
							<td class="clCouleur2 clWidth80 clAlignLeft">&#160;</td>
							<td class="clTexte clWidth148">&#160;</td>
							<td class="clTexte clWidth95 clAlignRight">
								<a href="#nullepart"
								   onClick="requestBDFInfos('27','','1','{EJ/IDENTS}',cstSimpleConfirm);">
									<img src="{$root}Images/Commun/clignotant2.gif"
									     width="90"
									     height="12"
									     title="Plus d'infos"
									     alt="Plus d'infos"
									     border="0"/>
								</a>
							</td>
						</xsl:otherwise>
					</xsl:choose>
				</tr>
			</table>
		</xsl:if>
		<xsl:if test="SEGMENT">
			<table class="clWidth635 clBorderCell">
				<caption class="visually-hidden">Principale(s) participation(s). Informations</caption>
				<tr>
					<th class="clCouleur2 clWidth130 clAlignLeft clThNonGras">&#160;Identifiant</th>
					<td class="clTexte clWidth107">
            &#160;<xsl:call-template name="displaySirenXsl">
							<xsl:with-param name="InputSiren"
							                select="(EJ/IDENTS)"/>
						</xsl:call-template>
					</td>
					<xsl:variable name="locali"
					              select="LOCALI"/>
					<xsl:choose>
						<!--Test si le début de la localité est un code postal -> Résident ou non-->
						<xsl:when test="(number(substring(LOCALI,0,5)) or ($locali='MC MONACO'))">
							<th class="clCouleur2 clWidth155 clAlignLeft clThNonGras">&#160;Cotation | Segmentation</th>
							<xsl:if test="not(VALCOT='ND')">
								<td class="clTexte clWidth148">
                  &#160;<a href="#nullepart"
									   class="clTexte"
									   onclick="requestVariousInfos('{VALCOT}',cstCotation,'{EJ/IDENTS}');">
										<u>
											<xsl:value-of select="VALCOT"/>
										</u>
									</a>&#160;|&#160;
                  <a href="#nullepart"
									   class="clTexte"
									   onclick="requestInfosLibelle('segmentation',cstSegment)">
										<u>
											<xsl:value-of select="SEGMENT"/>
										</u>
									</a>
								</td>
							</xsl:if>
							<xsl:if test="(VALCOT='ND')">
								<td class="clTexte clWidth148">
                  &#160;<a href="#nullepart"
									   class="clTexte"
									   onclick="requestVariousInfos('{VALCOT}',cstCotationNonDif,'{EJ/IDENTS}');">
										<u>
											<xsl:value-of select="VALCOT"/>
										</u>
									</a>&#160;|&#160;
                  <a href="#nullepart"
									   class="clTexte"
									   onclick="requestInfosLibelle('segmentation',cstSegment)">
										<u>
											<xsl:value-of select="SEGMENT"/>
										</u>
									</a>
								</td>
							</xsl:if>
							<td class="clTexte clWidth95 clAlignRight">
								<a href="#nullepart"
								   onClick="requestBDFInfos('27|37|39|53|','','1','{EJ/IDENTS}',cstMultipleConfirm);">
									<img src="{$root}Images/Commun/clignotant2.gif"
									     width="90"
									     height="12"
									     title="Plus d'infos"
									     alt="Plus d'infos"
									     border="0"/>
								</a>
							</td>
						</xsl:when>
						<xsl:otherwise>
							<td class="clCouleur2 clWidth155">&#160;</td>
							<td class="clTexte clWidth148">&#160;&#160;&#160;</td>
							<td class="clTexte clWidth95 clAlignRight">
								<a href="#nullepart"
								   onClick="requestBDFInfos('27','','1','{EJ/IDENTS}',cstSimpleConfirm);">
									<img src="{$root}Images/Commun/clignotant2.gif"
									     width="90"
									     height="12"
									     title="Plus d'infos"
									     alt="Plus d'infos"
									     border="0"/>
								</a>
							</td>
						</xsl:otherwise>
					</xsl:choose>
				</tr>
			</table>
		</xsl:if>
		<xsl:call-template name="shim"/>
	</xsl:template>
	<xsl:template name="SUITE">
		<table class="clWidth635 clBorderCell"
		       role="presentation">
			<tr>
				<td class="clCouleur2 clWidth530 clHeight14"
				    colspan="4"/>
				<td class="clWidth105 clHeight14 clValignMiddle clAlignRight">
					<a href="#nullepart"
					   onClick="requestBDFInfos('53','','1','{/FIBEN/PERSONNE/MODULEDE/EJ/IDENTS|FIBEN/PERSONNE/MODULEDE/EIPP/IDENTS}',cstSimpleConfirm);">
						<img src="../images/Commun/clignotant2.gif"
						     width="85"
						     height="12"
						     border="0"
						     align="absbottom"
						     alt="plus d'infos"/>
					</a>
				</td>
			</tr>
		</table>
		<xsl:call-template name="shim"/>
	</xsl:template>
	<xsl:template name="SuiteParticipation">
		<xsl:if test="position() mod 9 = 0">
			<div class="clBreakPage"/>
		</xsl:if>
		<xsl:if test="position() = last()">
			<table class="clWidth635 clBorderCell"
			       role="presentation">
				<tr>
					<td class="clCouleur2 clWidth530 clHeight14"
					    colspan="4">
						<br/>
						<xsl:value-of select="($dictionnaire/mot[@id='SUITEP'])"/>
					</td>
					<td class="clWidth105 clHeight14 clValignMiddle clAlignRight">
						<a href="#nullepart"
						   onClick="requestBDFInfos('53','','{$familyNumber}','{EJ/IDENTS}',cstSimpleConfirm);">
							<img src="{$root}images/Commun/clignotant2.gif"
							     width="85"
							     height="12"
							     border="0"
							     align="absbottom"
							     alt="plus d'infos"/>
						</a>
					</td>
				</tr>
			</table>
			<xsl:call-template name="shim"/>
		</xsl:if>
	</xsl:template>
	<!--********************************************************************************************************************************************************************-->
	<!-- *********************************    Bloc EVENEMENT MARQUANT, DERNIER JUGEMENT ************************************************************************************-->
	<!-- ************************************************************************************************************************************************************-->
	<xsl:template match="INFOEVMEVJ">
		<a name="ancEvent"/>
		<div class="clBreakPage"/>
		<xsl:if test="EVMARQDO or JUGEMENTS/JUGEIND or JUGEMENTS/JUGEMENT/EVJUD">
			<table class="clBorderCell clWidth739"
			       role="presentation">
				<tr class="clAlignCenter">
					<td colspan="6"
					    class="clCouleurGras">
            ÉVÉNEMENT(S) MARQUANT(S) ET JUDICIAIRE (S)
            <br/>
					</td>
					<td class="clWidth103 clAlignRight">
						<a href="#ancHaut">
							<img src="{$root}Images/risque/fleche_haut.gif"
							     width="18"
							     height="18"
							     border="0"
							     name="Image112"
							     alt="Retour en haut de la page"/>
						</a>
					</td>
				</tr>
			</table>
			<xsl:call-template name="shim"/>
		</xsl:if>
		<xsl:apply-templates select="EVMARQDO"/>
		<xsl:apply-templates select="IEVJ01"
		                     mode="genMessage"/>
		<xsl:if test="not(IEVJ01)">
			<xsl:apply-templates select="JUGEMENTS/JUGEMENT/EVJUD"/>
		</xsl:if>
		<xsl:apply-templates select="JUGEMENTS/JUGEIND"
		                     mode="genTable"/>
	</xsl:template>
	<xsl:template match="EVMARQDO">
		<xsl:if test="position()=1">
			<xsl:text disable-output-escaping="yes">&lt;table width=&quot;739&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
			<tr>
				<th class="clCouleur2 clWidth255 clAlignLeft clThNonGras"
				    colspan="6">
					<xsl:call-template name="tradlib">
						<xsl:with-param name="Lang"
						                select="$Lang"/>
						<xsl:with-param name="codeLib"
						                select="'m27_DerEve'"/>
					</xsl:call-template>
				</th>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth20 clAlignLeft clThNonGras">
					<xsl:call-template name="tradlib">
						<xsl:with-param name="Lang"
						                select="$Lang"/>
						<xsl:with-param name="codeLib"
						                select="'m27_Le'"/>
					</xsl:call-template>
				</th>
				<td class="clFond clWidth110">
          &#160;<xsl:call-template name="displayDateXsl">
						<xsl:with-param name="InputDate"
						                select="(DATEVM)"/>
					</xsl:call-template>&#160;
        </td>
				<xsl:if test="EVMDO">
					<td class="clFond"
					    colspan="2">
						<xsl:apply-templates select="EVMDO"/>
					</td>
				</xsl:if>
				<xsl:if test="not(EVMDO)">
					<td class="clFond clWidth518"
					    colspan="3">
						<xsl:apply-templates select="EVMC|EVMCD|EVMCI|EVMD|EVMDC|EVMDO|EVME|EVMJ|EVMJM|EVMM|EVMR|EVMS|EVMV"/>
					</td>
				</xsl:if>
				<xsl:apply-templates select="IDENTS"
				                     mode="clFond"/>
				<td class="clWidth90 clAlignRight">
        </td>
			</tr>
			<xsl:call-template name="savoirSirenAbsorbant"/>
			<xsl:if test="count(//EVMARQDO)=1">
				<!-- Mise en place d'un trait de fin de tableau dans le cas ou il n'y a que 1 événement marquant -->
				<tr>
					<td class="clTexte"
					    colspan="8">
						<xsl:call-template name="shim"/>
					</td>
				</tr>
				<xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
			</xsl:if>
		</xsl:if>
		<xsl:if test="position()=2">
			<!-- Mise en place d'un trait de séparation entre les 2événements marquant-->
			<tr>
				<td class="clTexte"
				    colspan="8">
					<xsl:call-template name="shim"/>
				</td>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth20 clAlignLeft clThNonGras">
					<xsl:call-template name="tradlib">
						<xsl:with-param name="Lang"
						                select="$Lang"/>
						<xsl:with-param name="codeLib"
						                select="'m27_Le'"/>
					</xsl:call-template>
				</th>
				<td class="clFond clWidth110">
          &#160;<xsl:call-template name="displayDateXsl">
						<xsl:with-param name="InputDate"
						                select="(DATEVM)"/>
					</xsl:call-template>&#160;
        </td>
				<xsl:if test="EVMDO">
					<td class="clFond"
					    colspan="2">
						<xsl:apply-templates select="EVMDO"/>
					</td>
				</xsl:if>
				<xsl:if test="not(EVMDO)">
					<td class="clFond clWidth518"
					    colspan="3">
						<xsl:apply-templates select="EVMC|EVMCD|EVMCI|EVMD|EVMDC|EVMDO|EVME|EVMJ|EVMJM|EVMM|EVMR|EVMS|EVMV"/>
					</td>
				</xsl:if>
				<xsl:apply-templates select="IDENTS"
				                     mode="clFond"/>
				<td class="clWidth90 clAlignRight">

        </td>
			</tr>
			<xsl:call-template name="savoirSirenAbsorbant"/>
			<!-- Mise en place d'un trait de fin de tableau dans le cas ou il y a 2 événements marquants -->
			<tr>
				<td class="clTexte"
				    colspan="8">
					<xsl:call-template name="shim"/>
				</td>
			</tr>
			<xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
		</xsl:if>
	</xsl:template>
	<xsl:template match="JUGEMENTS/JUGEMENT/EVJUD">
		<table class="clBorderCell clWidth739">
			<caption class="visually-hidden">Evénements marquants et judiciaires</caption>
			<tr>
				<th class="clCouleur2 clWidth255 clAlignLeft clThNonGras"
				    colspan="6">
					<xsl:call-template name="tradlib">
						<xsl:with-param name="Lang"
						                select="$Lang"/>
						<xsl:with-param name="codeLib"
						                select="'mDE_DerJug'"/>
					</xsl:call-template>
				</th>
			</tr>
			<tr>
				<td colspan="6"
				    class="clGrasFond">
					<xsl:apply-templates select="EVJAM|EVJAP|EVJCM|EVJCP|EVJCT|EVJCV|EVJDM|EVJDU|EVJEM|EVJFM|EVJFP|EVJGA|EVJGD|EVJGO|EVJGR|EVJHC|EVJHM|EVJIA|EVJIC|EVJIG|EVJIM|EVJIP|EVJIT|EVJLB|EVJLG|EVJLJ|EVJLM|EVJPA|EVJPC|EVJPM|EVJPO|EVJPV|EVJRC|EVJRD|EVJRG|EVJRJ|EVJRL|EVJRM|EVJRP|EVJRR|EVJRS|EVJSM|EVJAC|EVJCR|EVJOS|EVJOB|EVJPS|EVJRPS|EVJOD|EVJOT|EVJOP|EVJPT|EVJRT|EVJMC"/>
				</td>
				<xsl:if test="position() mod 3 = 0">
					<td rowspan="13"
					    class="clWidth103 clAlignRight">
						<a href="#ancHaut">
							<img src="{$root}Images/risque/fleche_haut.gif"
							     width="18"
							     height="18"
							     border="0"
							     name="Image112"
							     alt="Retour en haut de la page"/>
						</a>
					</td>
				</xsl:if>
				<xsl:if test="position() mod 3 != 0">
					<td rowspan="13"
					    class="clWidth103 clAlignRight">
            &#160;
          </td>
				</xsl:if>
			</tr>
			<tr>
				<td class="clCouleur2 clWidth30">&#160;Le</td>
				<td class="clTexte clWidth90">
          &#160;<xsl:call-template name="displayDateXsl">
						<xsl:with-param name="InputDate"
						                select="(DATEVJ)"/>
					</xsl:call-template>
				</td>
				<th class="clCouleur2 clWidth120 clAlignRight clThNonGras">
					<xsl:if test="DATECHJUG">
            Jusqu'au&#160;&#160;
          </xsl:if>
				</th>
				<td class="clTexte clWidth108">
          &#160;
          <xsl:if test="DATECHJUG">
						<xsl:call-template name="displayDateXsl">
							<xsl:with-param name="InputDate"
							                select="(DATECHJUG)"/>
						</xsl:call-template>
					</xsl:if>
				</td>
				<xsl:if test="../TRIBU">
					<th class="clCouleur2 clWidth100 clAlignLeft clThNonGras">&#160;Tribunal</th>
					<td class="clTexte clWidth187">
            &#160;<xsl:value-of select="../TRIBU"/>
					</td>
				</xsl:if>
				<xsl:if test="not(../TRIBU)">
					<td class="clCouleur2 clWidth100">&#160;</td>
					<td class="clTexte clWidth187">&#160;</td>
				</xsl:if>
			</tr>
			<xsl:if test="not(DATECHJUG)">
				<tr>
					<xsl:if test="/FIBEN/PERSONNE/MODULEDE/*//IDENTC">
						<td class="clAlignRight"
						    colspan="6">
            </td>
					</xsl:if>
					<xsl:if test="not(/FIBEN/PERSONNE/MODULEDE/*//IDENTC)">
						<td class="clAlignRight"
						    colspan="6">

            </td>
					</xsl:if>
				</tr>
			</xsl:if>
			<xsl:if test="not(position()=1)">
				<xsl:call-template name="shim"/>
			</xsl:if>
		</table>
	</xsl:template>
	<xsl:template name="savoirSirenAbsorbant">
		<xsl:if test="IDENTS">
			<xsl:if test="not($NonResident='NR')">
				<tr>
					<td class="clWidth20">&#160;</td>
					<td class="clWidth110">&#160;</td>
					<td class="clWidth125">&#160;</td>
					<td class="clWidth130">&#160;</td>
					<td class="clWidth125 clHeight12">
						<a href="#nullepart"
						   onclick="requestBDFInfos('27','','1','{IDENTS[1]}',cstSimpleConfirm);">
							<img align="middle"
							     border="0"
							     height="12"
							     name="ev1"
							     src="{$root}images/Commun/clignotant2.gif"
							     width="85"
							     alt="plus d'infos"/>
						</a>
					</td>
					<xsl:if test="IDENTS[2]">
						<td class="clWidth125 clHeight12">
							<a href="#nullepart"
							   onclick="requestBDFInfos('27','','1','{IDENTS[2]}',cstSimpleConfirm);">
								<img align="middle"
								     border="0"
								     height="12"
								     name="ev2"
								     src="{$root}images/Commun/clignotant2.gif"
								     width="85"
								     alt="plus d'infos"/>
							</a>
						</td>
					</xsl:if>
					<xsl:if test="not(IDENTS[2])">
						<td class="clWidth125 clHeight12">&#160;</td>
					</xsl:if>
				</tr>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<xsl:template match="EVMARQDO/IDENTS"
	              mode="clFond">
		<td class="clFond clWidth125">
			<xsl:call-template name="displaySirenXsl">
				<xsl:with-param name="InputSiren"
				                select="(.)"/>
			</xsl:call-template>
		</td>
		<xsl:if test="position()=1 and position()=last()">
			<td class="clFond clWidth125">&#160;</td>
		</xsl:if>
	</xsl:template>
	<xsl:template match="EVMARQDO/IDENTS"
	              mode="clTexte">
		<td class="clTexte clWidth125">
			<xsl:call-template name="displaySirenXsl">
				<xsl:with-param name="InputSiren"
				                select="(.)"/>
			</xsl:call-template>
		</td>
		<xsl:if test="position()=1 and position()=last()">
			<td class="clTexte clWidth125">&#160;</td>
		</xsl:if>
	</xsl:template>
	<xsl:template match="EVJUD">
		<table class="clBorderCell clWidth739">
			<caption class="visually-hidden">Evénements judiciaires</caption>
			<tr>
				<td colspan="6"
				    class="clGrasFond">
					<xsl:apply-templates select="EVJAM|EVJAP|EVJCM|EVJCP|EVJCT|EVJCV|EVJDM|EVJDU|EVJEM|EVJFM|EVJFP|EVJGA|EVJGD|EVJGO|EVJGR|EVJHC|EVJHM|EVJIA|EVJIC|EVJIG|EVJIM|EVJIP|EVJIT|EVJLB|EVJLG|EVJLJ|EVJLM|EVJPA|EVJPC|EVJPM|EVJPO|EVJPV|EVJRC|EVJRD|EVJRG|EVJRJ|EVJRL|EVJRM|EVJRP|EVJRR|EVJRS|EVJSM|EVJAC|EVJCR|EVJOS|EVJOB|EVJPS|EVJRPS|EVJOD|EVJOT|EVJOP|EVJPT|EVJRT|EVJMC"/>
				</td>
				<td rowspan="13"
				    class="clWidth103 clAlignRight">
          &#160;
        </td>
			</tr>
			<tr>
				<td class="clCouleur2 clWidth30">&#160;Le</td>
				<td class="clTexte clWidth90">
          &#160;<xsl:call-template name="displayDateXsl">
						<xsl:with-param name="InputDate"
						                select="(DATEVJ)"/>
					</xsl:call-template>
				</td>
				<th class="clCouleur2 clWidth120 clAlignRight clThNonGras">
					<xsl:if test="DATECHJUG">
            Jusqu'au&#160;&#160;
          </xsl:if>
				</th>
				<td class="clTexte clWidth108">
          &#160;
          <xsl:if test="DATECHJUG">
						<xsl:call-template name="displayDateXsl">
							<xsl:with-param name="InputDate"
							                select="(DATECHJUG)"/>
						</xsl:call-template>
					</xsl:if>
				</td>
				<xsl:if test="../TRIBU">
					<th class="clCouleur2 clWidth100 clAlignLeft clThNonGras">&#160;Tribunal</th>
					<td class="clTexte clWidth187">
            &#160;<xsl:value-of select="../TRIBU"/>
					</td>
				</xsl:if>
				<xsl:if test="not(../TRIBU)">
					<td class="clCouleur2 clWidth100">&#160;</td>
					<td class="clTexte clWidth187">&#160;</td>
				</xsl:if>
			</tr>
			<xsl:if test="not(DATECHJUG)">
				<xsl:if test="not($NonResident='NR')">
					<tr>
						<xsl:if test="/FIBEN/PERSONNE/MODULEDE/*//IDENTC">
							<td class="clAlignRight"
							    colspan="6">
              </td>
						</xsl:if>
						<xsl:if test="not(/FIBEN/PERSONNE/MODULEDE/*//IDENTC)">
							<td class="clAlignRight"
							    colspan="6">

              </td>
						</xsl:if>
					</tr>
				</xsl:if>
				<xsl:if test="$NonResident='NR'">
					<tr>
						<xsl:if test="/FIBEN/PERSONNE/MODULEDE/*//IDENTC">
							<td class="clAlignRight"
							    colspan="6">&#160;</td>
						</xsl:if>
						<xsl:if test="not(/FIBEN/PERSONNE/MODULEDE/*//IDENTC)">
							<td class="clAlignRight"
							    colspan="6">&#160;</td>
						</xsl:if>
					</tr>
				</xsl:if>
			</xsl:if>
			<xsl:if test="not(position()=1)">
				<xsl:call-template name="shim"/>
			</xsl:if>
		</table>
	</xsl:template>
	<xsl:template match="JUGEIND"
	              mode="genTable">
		<table class="clWidth635 clBorderCell"
		       role="presentation">
			<xsl:if test="count(//EVMARQDO)>0 or //EVJUD">
				<tr>
					<td colspan="6"
					    class="clCouleur2">&#160;</td>
				</tr>
			</xsl:if>
			<tr>
				<td class="clCouleur2"
				    colspan="4">
					<xsl:apply-templates select="."/>
				</td>
				<td class="clFond clWidth290"
				    colspan="2">
          &#160;<xsl:value-of select="."/>
				</td>
			</tr>
			<xsl:if test="not($NonResident='NR')">
				<tr>
					<td class="clWidth20">&#160;</td>
					<td class="clWidth110">&#160;</td>
					<td class="clWidth125">&#160;</td>
					<td class="clWidth130">&#160;</td>
					<td class="clWidth125">&#160;</td>
					<td class="clWidth125 clAlignRight"/>
				</tr>
			</xsl:if>
			<xsl:if test="$NonResident='NR'">
				<tr>
					<td class="clWidth20">&#160;</td>
					<td class="clWidth110">&#160;</td>
					<td class="clWidth125">&#160;</td>
					<td class="clWidth130">&#160;</td>
					<td class="clWidth125">&#160;</td>
					<td class="clWidth125">&#160;</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>
	<xsl:template match="IEVJ01"
	              mode="genMessage">
		<table class="clBorderCell clWidth739"
		       role="presentation">
			<xsl:apply-templates select="."/>
			<br/>
		</table>
	</xsl:template>
	<!--********************************************************************************************************************************************************************-->
	<!-- *********************************    Bloc INCIDENTS DE PAIEMENT ************************************************************************************-->
	<!-- ************************************************************************************************************************************************************-->
	<xsl:template match="INFOIMPAYESTRIM">
		<a name="ancEffet"/>
		<xsl:if test="CIP01 or CIP02">
			<table class="clWidth635 clBorderCell">
				<tr>
					<td class="clTexte">
						<span class="clCouleur2">
							<xsl:apply-templates select="CIP01|CIP02"/>
						</span>
					</td>
				</tr>
			</table>
		</xsl:if>
		<xsl:apply-templates select="IMPAYEDO"/>
		<xsl:call-template name="shim"/>
	</xsl:template>
	<xsl:template match="IMPAYEDO">
		<div class="clBreakPage"/>
		<xsl:if test="position()=last()">
			<table class="clWidth742 clBorderCell"
			       role="presentation">
				<tr>
					<td class="clCouleurGras clWidth602 clAlignCenter">
            INCIDENTS DE
            PAIEMENT SUR EFFETS DE COMMERCE&#160;(en
            <xsl:call-template name="displayUnitXsl">
							<xsl:with-param name="InputUnit"
							                select="(./UNITE)"/>
						</xsl:call-template>
						<!--<xsl:value-of select="bdf:displayUnit(./UNITE)"/>-->
            euros)
          </td>
					<td class="clWidth19">  </td>
					<td class="clWidth103 clAlignRight">
						<a href="#ancHaut">
							<img src="{$root}images/risque/fleche_haut.gif"
							     width="18"
							     height="18"
							     border="0"
							     name="Image112"
							     alt="Retour en haut de la page"/>
						</a>
					</td>
				</tr>
			</table>
			<img width="635"
			     height="1"
			     vspace="8"
			     src="{$root}Images/risque/shim_bleu.gif"
			     alt=""/>
			<table class="clWidth635 clBorderCell">
				<caption class="visually-hidden">Incidents de paiement sur effets de commerce</caption>
				<tr>
					<td class="clCouleur2 clWidth138 clValignTop clAlignRight clThNonGras"> </td>
					<th class="clCouleur2 clAlignRight"
					    colspan="2">
            Incapacité
            de payer      
          </th>
					<th class="clCouleur2 clAlignRight clThNonGras"
					    colspan="2">
            Contestation de
            créance   
          </th>
					<td class="clCouleur2 clWidth80 clValignTop clAlignRight"> </td>
				</tr>
				<tr>
					<th class="clCouleur2 clWidth138 clAlignRight clThNonGras">Trimestre </th>
					<th class="clCouleur2 clWidth99 clHeight17 clAlignRight clThNonGras">Nombre </th>
					<th class="clCouleur2 clWidth84 clHeight17 clAlignRight clThNonGras">Montant </th>
					<th class="clCouleur2 clWidth150 clHeight17 clAlignRight clThNonGras">Nombre </th>
					<th class="clCouleur2 clWidth84 clHeight17 clAlignRight clThNonGras">Montant </th>
					<th class="clCouleur2 clWidth80 clAlignRight clThNonGras">Total </th>
				</tr>
				<xsl:variable name="tmp"
				              select="../IMPAYEDO[1]/MTIPEIP + ../IMPAYEDO[2]/MTIPEIP + ../IMPAYEDO[3]/MTIPEIP + ../IMPAYEDO[4]/MTIPEIP"/>
				<tr>
					<td class="clFond clWidth138 clAlignRight">
            &#160;<xsl:call-template name="displayDateXsl">
							<xsl:with-param name="InputDate"
							                select="(../IMPAYEDO[1]/TRIM)"/>
						</xsl:call-template>&#160;
          </td>
					<td class="clFond clWidth99 clAlignRight">
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../IMPAYEDO[1]/NBIPEIP)"/>
						</xsl:call-template>&#160;
          </td>
					<td class="clFond clWidth84 clAlignRight">
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../IMPAYEDO[1]/MTIPEIP)"/>
						</xsl:call-template>&#160;
          </td>
					<td class="clFond clWidth150 clAlignRight">
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../IMPAYEDO[1]/NBIPECC)"/>
						</xsl:call-template>&#160;
          </td>
					<td class="clFond clWidth84 clAlignRight">
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../IMPAYEDO[1]/MTIPECC)"/>
						</xsl:call-template>&#160;
          </td>
					<td class="clFond clWidth80 clAlignRight">
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../IMPAYEDO[1]/TOT)"/>
						</xsl:call-template>&#160;
          </td>
				</tr>
				<tr>
					<td class="clTexte clWidth138 clAlignRight">
            &#160;<xsl:call-template name="displayDateXsl">
							<xsl:with-param name="InputDate"
							                select="(../IMPAYEDO[2]/TRIM)"/>
						</xsl:call-template>&#160;
          </td>
					<td class="clTexte clWidth99 clAlignRight">
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../IMPAYEDO[2]/NBIPEIP)"/>
						</xsl:call-template>&#160;
          </td>
					<td class="clTexte clWidth84 clAlignRight">
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../IMPAYEDO[2]/MTIPEIP)"/>
						</xsl:call-template>&#160;
          </td>
					<td class="clTexte clWidth150 clAlignRight">
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../IMPAYEDO[2]/NBIPECC)"/>
						</xsl:call-template>&#160;
          </td>
					<td class="clTexte clWidth84 clAlignRight">
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../IMPAYEDO[2]/MTIPECC)"/>
						</xsl:call-template>&#160;
          </td>
					<td class="clTexte clWidth80 clAlignRight">
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../IMPAYEDO[2]/TOT)"/>
						</xsl:call-template>&#160;
          </td>
				</tr>
				<tr>
					<td class="clFond clWidth138 clAlignRight">
            &#160;<xsl:call-template name="displayDateXsl">
							<xsl:with-param name="InputDate"
							                select="(../IMPAYEDO[3]/TRIM)"/>
						</xsl:call-template>&#160;
          </td>
					<td class="clFond clWidth99 clAlignRight">
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../IMPAYEDO[3]/NBIPEIP)"/>
						</xsl:call-template>&#160;
          </td>
					<td class="clFond clWidth84 clAlignRight">
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../IMPAYEDO[3]/MTIPEIP)"/>
						</xsl:call-template>&#160;
          </td>
					<td class="clFond clWidth150 clAlignRight">
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../IMPAYEDO[3]/NBIPECC)"/>
						</xsl:call-template>&#160;
          </td>
					<td class="clFond clWidth84 clAlignRight">
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../IMPAYEDO[3]/MTIPECC)"/>
						</xsl:call-template>&#160;
          </td>
					<td class="clFond clWidth80 clAlignRight">
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../IMPAYEDO[3]/TOT)"/>
						</xsl:call-template>&#160;
          </td>
				</tr>
				<tr>
					<td class="clTexte clWidth138 clAlignRight">
            &#160;<xsl:call-template name="displayDateXsl">
							<xsl:with-param name="InputDate"
							                select="(../IMPAYEDO[4]/TRIM)"/>
						</xsl:call-template>&#160;
          </td>
					<td class="clTexte clWidth99 clAlignRight">
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../IMPAYEDO[4]/NBIPEIP)"/>
						</xsl:call-template>&#160;
          </td>
					<td class="clTexte clWidth84 clAlignRight">
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../IMPAYEDO[4]/MTIPEIP)"/>
						</xsl:call-template>&#160;
          </td>
					<td class="clTexte clWidth150 clAlignRight">
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../IMPAYEDO[4]/NBIPECC)"/>
						</xsl:call-template>&#160;
          </td>
					<td class="clTexte clWidth84 clAlignRight">
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../IMPAYEDO[4]/MTIPECC)"/>
						</xsl:call-template>&#160;
          </td>
					<td class="clTexte clWidth80 clAlignRight">
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../IMPAYEDO[4]/TOT)"/>
						</xsl:call-template>&#160;
          </td>
				</tr>
				<xsl:if test="$tmp>'0'">
					<xsl:if test="not($NonResident='NR')">
						<tr>
							<td class="clWidth405"
							    colspan="2"/>
							<td class="clWidth230 clAlignRight">
								<a href="#nullepart"
								   onclick="requestBDFInfos('29','','','',cstSimpleConfirm);">
									<img border="0"
									     height="12"
									     src="{$root}images/Commun/clignotant2.gif"
									     width="90"
									     alt="plus d'infos"/>
								</a>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="$NonResident='NR'">
						<tr>
							<td class="clWidth635"
							    colspan="3">&#160;</td>
						</tr>
					</xsl:if>
				</xsl:if>
			</table>
		</xsl:if>
	</xsl:template>
	<!--********************************************************************************************************************************************************************-->
	<!-- *********************************    Bloc CONCOURS BANCAIRES- SOURCES DE FINANCEMENT************************************************************************************-->
	<!-- ************************************************************************************************************************************************************-->
	<xsl:template match="INFORISQUESDO">
		<a name="ancConcours"/>
		<xsl:choose>
			<xsl:when test="ICB10">
				<table class="clWidth635 clBorderCell"
				       role="presentation">
					<tr>
						<td class="clCouleur2 clWidth635">
							<xsl:value-of select="($dictionnaire/mot[@id='ICB10'])"/>
						</td>
					</tr>
				</table>
				<xsl:call-template name="shim"/>
			</xsl:when>
			<xsl:otherwise>
				<!--<div class="clBreakPage"></div>-->
				<table class="clBorderCell clWidth739"
				       role="presentation">
					<tr class="clAlignCenter">
						<td class="clCouleurGras clWidth602">SOURCES DE FINANCEMENT (EN MILLIERS D'EUROS)</td>
						<td class="clWidth34"> </td>
						<td class="clWidth103 clAlignRight">
							<a href="#ancHaut">
								<img src="{$root}images/risque/fleche_haut.gif"
								     width="18"
								     height="18"
								     border="0"
								     name="Image112"
								     alt="Retour en haut de la page"/>
							</a>
						</td>
					</tr>
				</table>
				<xsl:call-template name="shim"/>
				<br/>
				<xsl:apply-templates select="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFORISQUESDO/RISQUES/DATCENTR"/>				
				<xsl:if test="not(/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFORISQUESDO/RISQUES/ICB01)">
					<table class="clBorderCell clWidth739">
						<tr class="clAlignCenter">
							<td class="clCouleurGras clWidth602">CONCOURS BANCAIRES</td>
							<td class="clWidth34"> </td>
							<td class="clWidth103 clAlignRight">
								<a href="#ancHaut">
									<img src="{$root}images/risque/fleche_haut.gif"
									     width="18"
									     height="18"
									     border="0"
									     name="Image112"
									     alt="Retour en haut de la page"/>
								</a>
							</td>
						</tr>
					</table>
					<xsl:call-template name="shim"/>
				</xsl:if>
				<!-- appel des différentes parties des risques-->
				<xsl:if test="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFORISQUESDO/RISQUES/CBEURO">
					<xsl:apply-templates select="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFORISQUESDO/RISQUES/CBEURO"/>
				</xsl:if>
				<xsl:choose>
					<xsl:when test="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFORISQUESDO/RISQUES/ICB05">
						<xsl:call-template name="ICB05"/>
						<xsl:call-template name="shim"/>
					</xsl:when>
					<xsl:when test="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFORISQUESDO/RISQUES/ICB01">
						<xsl:call-template name="ICB01"/>
						<xsl:call-template name="shim"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFORISQUESDO/RISQUES/ICB04">                
								<xsl:call-template name="CUMULCB"/>
								<xsl:call-template name="ICB04"/>
								<xsl:call-template name="shim"/>
							</xsl:when>
							<xsl:when test="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFORISQUESDO/RISQUES/ICB03">
								<xsl:call-template name="ICB03"/>
								<xsl:call-template name="shim"/>
								<xsl:call-template name="CUMULCBC"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="CUMULCB"/>
								<xsl:call-template name="CUMULCBC"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:choose>
					<xsl:when test="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFORISQUESDO/RISQUES/ICB06">
						<xsl:call-template name="ICB06"/>
						<xsl:call-template name="shim"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="CUMULCIFP"/>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:choose>
					<xsl:when test="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFORISQUESDO/RISQUES/ICB07">
						<xsl:call-template name="ICB07"/>
						<xsl:call-template name="shim"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFORISQUESDO/RISQUES/ICB09">
								<!-- Cas particulier pas de concours bancaire individuels mais présence de concours collectif : il faut mettre le titre -->
								<table class="clBorderCell clWidth739">
									<tr class="clAlignCenter">
										<td class="clCouleurGras clWidth635">CONCOURS D&#201;CLAR&#201;S PAR DES SOCI&#201;T&#201;S DE GESTION DE PORTEFEUILLE ET DES ENTREPRISES</td>
										<td class="clAlignRight clWidth104">&#160;</td>
									</tr>
									<tr class="clAlignCenter">
										<td class="clCouleurGras clWidth635"> D'ASSURANCE, MUTUELLES ET INSTITUTIONS DE PR&#201;VOYANCE</td>
										<td class="clAlignRight clWidth104">&#160;</td>
									</tr>
								</table>
								<xsl:call-template name="shim"/>
								<br/>
								<xsl:call-template name="ICB09"/>
								<xsl:call-template name="shim"/>
								<xsl:call-template name="CUMULCOAC"/>
							</xsl:when>
							<xsl:when test="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFORISQUESDO/RISQUES/ICB08">
								<xsl:call-template name="CUMULCOA"/>
								<xsl:call-template name="ICB08"/>
								<xsl:call-template name="shim"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="CUMULCOA"/>
								<xsl:call-template name="CUMULCOAC"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="DATCENTR">
		<table class="clWidth635 clBorderCell">
			<caption class="visually-hidden">Dernière centralisation</caption>
			<tr>
				<th class="clCouleur2 clWidth200 clHeight12 clAlignLeft clThNonGras">&#160;DERNIÈRE CENTRALISATION AU</th>
				<td class="clFond clWidth182 clHeight12">
					<div class="clAlignRight">
            &#160;<xsl:call-template name="displayDateXsl">
							<xsl:with-param name="InputDate"
							                select="(.)"/>
						</xsl:call-template>
					</div>
				</td>
				<th class="clCouleur2 clWidth253 clHeight12 clAlignCenter clThNonGras">
					<div class="clAlignRight">&#160;&#160;(en milliers d'euros)</div>
				</th>
			</tr>
		</table>
		<xsl:call-template name="shim"/>
		<br/>
	</xsl:template>
	
	<xsl:template match="CBEURO">
		<table class="clWidth635 clBorderCell">
			<caption class="visually-hidden">Présence de concours bancaires européens</caption>
			<tr>
				<td class="clCouleur2 clWidth400 clHeight12">&#160;PRESENCE DE CONCOURS BANCAIRES EUROPEENS </td>
				<td class="clCouleur2 clWidth235 clHeight12">
        </td>
			</tr>
		</table>
		<table class="clWidth635 clBorderCell">
			<tr>
				<td class="clCouleur2 clWidth635">
					<br/>
					<div class="clAlignLeft">
            &#160;Pour obtenir le détail de l'endettement européen de cette entreprise, vous pouvez contacter le pôle "produits" &#160;du Service Central des Risques par mail : <a href="mailto:4072-produits-ut@banque-france.fr"/>4072-produits-ut@banque-france.fr
          </div>
				</td>
			</tr>
		</table>
		<xsl:call-template name="shim"/>
		<br/>
	</xsl:template>
	<!-- *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-->
	<!-- ***************** Les messages diffusions des risques  *******************************************-->
	<xsl:template name="ICB01">
		<table class="clWidth635 clBorderCell"
		       role="presentation">
			<tr>
				<td class="clCouleur2 clWidth635">
					<xsl:value-of select="($dictionnaire/mot[@id='ICB01'])"/>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="ICB03">
		<table class="clWidth635 clBorderCell"
		       role="presentation">
			<tr>
				<td class="clCouleur2 clWidth635">
					<xsl:value-of select="($dictionnaire/mot[@id='ICB03'])"/>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="ICB04">
		<table class="clWidth635 clBorderCell"
		       role="presentation">
			<tr>
				<td class="clCouleur2 clWidth635">
					<xsl:value-of select="($dictionnaire/mot[@id='ICB04'])"/>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="ICB05">
		<table class="clWidth635 clBorderCell"
		       role="presentation">
			<tr>
				<td class="clCouleur2 clWidth635">
					<xsl:value-of select="($dictionnaire/mot[@id='ICB05'])"/>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="ICB06">
		<table class="clWidth635 clBorderCell"
		       role="presentation">
			<tr>
				<td class="clCouleur2 clWidth635">
					<xsl:value-of select="($dictionnaire/mot[@id='ICB06'])"/>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="ICB07">
		<table class="clWidth635 clBorderCell"
		       role="presentation">
			<tr>
				<td class="clCouleur2 clWidth635">
					<xsl:value-of select="($dictionnaire/mot[@id='ICB07'])"/>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="ICB08">
		<table class="clWidth635 clBorderCell"
		       role="presentation">
			<tr>
				<td class="clCouleur2 clWidth635">
					<xsl:value-of select="($dictionnaire/mot[@id='ICB08'])"/>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="ICB09">
		<table class="clWidth635 clBorderCell"
		       role="presentation">
			<tr>
				<td class="clCouleur2 clWidth635">
					<xsl:value-of select="($dictionnaire/mot[@id='ICB09'])"/>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!-- *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-->
	<!-- ***************** Concours bancaires individuels ou collectifs *******************************************-->
	<!-- ***************** Concours bancaires individuels *******************************************-->
	<!--DÉTAILS DES CREDITS-->
	<xsl:template name="CUMULCB">
		<table class="clBorderCell clWidth739">
			<caption class="visually-hidden">DÉTAILS DES CONCOURS INDIVIDUELS</caption>
			<tr class="clAlignCenter">
				<td class="clCouleurGras clWidth635">D&#201;TAILS DES CONCOURS INDIVIDUELS</td>
				<td class="clAlignRight clWidth104">&#160;</td>
			</tr>
		</table>
		<xsl:call-template name="shim"/>
		<br/>
		<table class="clWidth635 clBorderCell"
		       role="presentation">
			<tr>
				<xsl:apply-templates select="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFORISQUESDO/RISQUES/CUMULCB/@MOISREF"/>
				<xsl:apply-templates select="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFORISQUESDO/RISQUES/CUMULCB/MTCODCCT"/>
			</tr>
		</table>
		<xsl:call-template name="shim"/>
		<br/>
		<table class="clBorderCell clWidth739"
		       role="presentation">
			<tr>
				<xsl:apply-templates select="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFORISQUESDO/RISQUES/CUMULCB/@MOISREF"/>
				<xsl:apply-templates select="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFORISQUESDO/RISQUES/CUMULCB/MTCMLT"/>
			</tr>
		</table>
		<xsl:call-template name="shim"/>
		<br/>
		<table class="clBorderCell clWidth739"
		       role="presentation">
			<tr>
				<xsl:apply-templates select="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFORISQUESDO/RISQUES/CUMULCB/@MOISREF"/>
				<xsl:apply-templates select="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFORISQUESDO/RISQUES/CUMULCB/MTCC"/>
			</tr>
		</table>
		<table class="clWidth635 clBorderCell"
		       role="presentation">
			<tr>
				<td class="clItalic">* Moyenne des crédits sur les 13 derniers mois</td>
			</tr>
		</table>
		<br/>
		<xsl:call-template name="shim"/>
		<br/>
	</xsl:template>
	<xsl:template match="CUMULCB/@MOISREF">
		<xsl:if test="position()=1">
			<xsl:text disable-output-escaping="yes">&lt;td width=&quot;45&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
			<xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
			<tr>
				<td class="clCouleur2 clWidth65 clHeight20"/>
			</tr>
			<tr>
				<td class="clCouleur2 clWidth65 clHeight25"/>
			</tr>
			<tr>
				<td class="clCouleur2 clWidth65 clHeight45"/>
			</tr>
			<tr>
				<td class="clItalic clValignBottom clWidth65 clAlignCenter clHeight5"/>
			</tr>
			<tr>
				<td class="clFond clWidth65 clAlignRight clHeight15">
					<xsl:call-template name="displayDateXsl">
						<xsl:with-param name="InputDate"
						                select="(.)"/>
					</xsl:call-template>
				</td>
			</tr>
			<tr>
				<td class="clItalic clWidth65 clAlignRight clHeight15"/>
			</tr>
		</xsl:if>
		<xsl:if test="position()=last()">
			<tr>
				<th class="clFond clWidth65 clAlignRight clHeight15">
					<b>Moyenne*</b>
				</th>
			</tr>
			<tr>
				<td class="clItalic clWidth65 clHeight1">&#160; </td>
			</tr>
			<xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
			<xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
		</xsl:if>
	</xsl:template>
	<!--CREDIT COURT-->
	<xsl:template match="CUMULCB/MTCODCCT">
		<xsl:if test="position()=1">
			<xsl:text disable-output-escaping="yes">&lt;td width=&quot;739&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
			<xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
			<tr>
				<th colspan="9"
				    class="clCouleur2 clValignTop clHeight20 clWidth580 clAlignCenter clThNonGras"
				    nowrap="true">CREDITS MOBILISES</th>
				<td class="clWidth106"/>
			</tr>
			<tr>
				<th colspan="9"
				    class="clCouleur2 clValignTop clHeight25 clAlignCenter clThNonGras"
				    nowrap="true">Court terme</th>
			</tr>
			<tr class="clHeight30">
				<th class="clCouleur2 clValignTop clHeight30 clWidth110 clAlignRight clThNonGras">
          Cptes ordinaires<br/>débiteurs<br/>
					<a href="#nullepart"
					   class="clTexte"
					   onclick="requestInfosRisques('CO',cstInforisques)">
						<u>
              (CO)
            </u>
					</a>
				</th>
				<td class="clWidth4"/>
				<th class="clCouleur2 clValignTop clWidth110 clAlignRight clThNonGras">
          Créances<br/>commerciales<br/>
					<a href="#nullepart"
					   class="clTexte"
					   onclick="requestInfosRisques('CC',cstInforisques)">
						<u>
              (CC)
            </u>
					</a>
				</th>
				<td class="clWidth5"/>
				<th class="clCouleur2 clValignTop clWidth100 clAlignRight clThNonGras">
          Affacturage<br/>
					<a href="#nullepart"
					   class="clTexte"
					   onclick="requestInfosRisques('AF',cstInforisques)">
						<u>
              (AF)
            </u>
					</a>
				</th>
				<td class="clCouleur2 clWidth7">&#160;</td>
				<th class="clCouleur2 clValignTop clWidth110 clAlignRight clThNonGras">
          Autres crédits à<br/>court terme<br/>
					<a href="#nullepart"
					   class="clTexte"
					   onclick="requestInfosRisques('CA',cstInforisques)">
						<u>
              (CA)
            </u>
					</a>
				</th>
				<td class="clCouleur2 clValignBottom clWidth12 clAlignCenter">
					<img src="{$root}images/risque/shim_bleu.gif"
					     width="1"
					     height="45"
					     vspace="0"
					     alt=""/>
				</td>
				<th class="clCouleur2 clValignTop clWidth110 clAlignRight clThNonGras">
          Total court terme <br/>[I]
        </th>
				<td class="clWidth106 clAlignRight"/>
			</tr>
			<tr>
				<td class="clItalic"
				    colspan="7"/>
				<td class="clItalic clValignBottom clWidth12 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="5"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clItalic"
				    colspan="2"/>
			</tr>
			<tr>
				<td class="clFond clWidth110 clAlignRight">
					<xsl:call-template name="displayNumberXsl">
						<xsl:with-param name="InputStringNumber"
						                select="(.)"/>
					</xsl:call-template>&#160;
        </td>
				<td class="clFond clWidth4 clAlignRight">&#160;</td>
				<td class="clFond clWidth110 clAlignRight">
					<xsl:call-template name="displayNumberXsl">
						<xsl:with-param name="InputStringNumber"
						                select="(../MTCCCT)"/>
					</xsl:call-template>&#160;
        </td>
				<td class="clFond clWidth5 clAlignRight">&#160;</td>
				<td class="clFond clWidth100 clAlignRight">
					<xsl:call-template name="displayNumberXsl">
						<xsl:with-param name="InputStringNumber"
						                select="(../MTAFCT)"/>
					</xsl:call-template>&#160;
        </td>
				<td class="clFond clWidth7 clAlignRight">&#160;</td>
				<td class="clFond clWidth110 clAlignRight">
					<xsl:call-template name="displayNumberXsl">
						<xsl:with-param name="InputStringNumber"
						                select="(../MTACCT)"/>
					</xsl:call-template>&#160;
        </td>
				<td class="clFond clWidth12 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clFond clWidth110 clAlignRight">
					<xsl:call-template name="displayNumberXsl">
						<xsl:with-param name="InputStringNumber"
						                select="(../MTCBCT)"/>
					</xsl:call-template>&#160;
        </td>
				<td class="clWidth106"/>
			</tr>
			<tr>
				<td class="clItalic clWidth110 clAlignRight">&#160;</td>
				<td class="clItalic clWidth4 clAlignRight">&#160;</td>
				<td class="clItalic clWidth110 clAlignRight">&#160;</td>
				<td class="clItalic clWidth5 clAlignRight">&#160;</td>
				<td class="clItalic clWidth100 clAlignRight">&#160;</td>
				<td class="clItalic clWidth7 clAlignRight">&#160;</td>
				<td class="clItalic clWidth110 clAlignRight">&#160;</td>
				<td class="clItalic clWidth12 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clItalic clWidth110 clAlignRight">&#160;</td>
				<td class="clWidth106"/>
			</tr>
		</xsl:if>
		<xsl:if test="position()=last()">
			<tr>
				<td class="clFond clWidth110 clAlignRight">
					<b>
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../../MOYCB/MTCODCCT)"/>
						</xsl:call-template>
					</b>&#160;
        </td>
				<td class="clFond clWidth4 clAlignRight">&#160;</td>
				<td class="clFond clWidth110 clAlignRight">
					<b>
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../../MOYCB/MTCCCT)"/>
						</xsl:call-template>
					</b>&#160;
        </td>
				<td class="clFond clWidth5 clAlignRight">&#160;</td>
				<td class="clFond clWidth100 clAlignRight">
					<b>
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../../MOYCB/MTAFCT)"/>
						</xsl:call-template>
					</b>&#160;
        </td>
				<td class="clFond clWidth7 clAlignRight">&#160;</td>
				<td class="clFond clWidth110 clAlignRight">
					<b>
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../../MOYCB/MTACCT)"/>
						</xsl:call-template>
					</b>&#160;
        </td>
				<td class="clFond clWidth12 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clFond clWidth110 clAlignRight">
					<b>
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../../MOYCB/MTCBCT)"/>
						</xsl:call-template>
					</b>&#160;
        </td>
				<td class="clWidth106"/>
			</tr>
			<tr>
				<td class="clItalic clHeight1"
				    colspan="10">&#160; </td>
			</tr>
			<xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
			<xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
		</xsl:if>
	</xsl:template>
	<!--CREDIT MOYEN ET LONG TERME-->
	<xsl:template match="CUMULCB/MTCMLT">
		<xsl:if test="position()=1">
			<xsl:text disable-output-escaping="yes">&lt;td width=&quot;739&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
			<xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
			<tr>
				<td class="clWidth580 clHeight10"
				    colspan="9"/>
				<td class="clWidth106"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth103 clValignMiddle clAlignRight clThNonGras"
				    rowspan="2">
          Moyen
          <br/> et long terme<br/>
					<a href="#nullepart"
					   class="clTexte"
					   onclick="requestInfosRisques('TETA',cstInforisques)">
						<u>
              (TE+TA)
            </u>
					</a>
					<br/>[II]
        </th>
				<td class="clWidth10 clAlignCenter">
					<img src="{$root}images/risque/shim_bleu.gif"
					     width="1"
					     height="40"
					     vspace="0"
					     alt=""/>
				</td>
				<th colspan="3"
				    class="clCouleur2 clValignMiddle clAlignCenter clThNonGras"
				    nowrap="true">Crédits-bails </th>
				<td class="clAlignCenter">
					<img src="{$root}images/risque/shim_bleu.gif"
					     width="1"
					     height="40"
					     vspace="0"
					     alt=""/>
				</td>
				<th rowspan="2"
				    class="clCouleur2  clWidth74 clValignMiddle clAlignRight clThNonGras"
				    nowrap="true">
          Titrisés<br/>
					<a href="#nullepart"
					   class="clTexte"
					   onclick="requestInfosRisques('IT',cstInforisques)">
						<u>
              (IT)
            </u>
					</a>
					<br/>[V]
        </th>
				<td class="clAlignCenter">
					<img src="{$root}images/risque/shim_bleu.gif"
					     width="1"
					     height="40"
					     vspace="0"
					     alt=""/>
				</td>
				<th rowspan="2"
				    class="clCouleur2 clWidth158 clValignMiddle clAlignRight clThNonGras"
				    nowrap="true">
          Total <br/>
          des crédits mobilisés [VI]<br/>[I]+[II]+[III]+[IV]+[V]
        </th>
				<td class="clWidth103 clAlignRight">
					<a href="#ancHaut">
						<img src="{$root}Images/risque/fleche_haut.gif"
						     width="18"
						     height="18"
						     border="0"
						     name="Image112"
						     alt="Retour en haut de la page"/>
					</a>
				</td>
			</tr>
			<tr class="clHeight25">
				<td class="clWidth10 clAlignCenter">
					<img src="{$root}images/risque/shim_bleu.gif"
					     width="1"
					     height="40"
					     vspace="0"
					     alt=""/>
				</td>
				<th class="clCouleur2 clWidth104 clValignMiddle clAlignRight clThNonGras">
          Mobiliers  <a href="#nullepart"
					   class="clTexte"
					   onclick="requestInfosRisques('BM',cstInforisques)">
						<u>
              (BM)
            </u>
					</a>
					<br/>[III]
        </th>
				<td class="clCouleur2 clWidth5 clAlignRight">&#160;</td>
				<th class="clCouleur2 clWidth108 clAlignRight clValignMiddle clThNonGras">
          Immobiliers
          <a href="#nullepart"
					   class="clTexte"
					   onclick="requestInfosRisques('BI',cstInforisques)">
						<u>
              (BI)
            </u>
					</a>
					<br/>[IV]
        </th>
				<td class="clWidth4 clAlignCenter">
					<img src="{$root}images/risque/shim_bleu.gif"
					     width="1"
					     height="40"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clWidth4 clAlignCenter">
					<img src="{$root}images/risque/shim_bleu.gif"
					     width="1"
					     height="40"
					     vspace="0"
					     alt=""/>
				</td>
				<td>&#160;</td>
			</tr>
			<tr>
				<td class="clItalic"/>
				<td class="clItalic clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="5"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clItalic"/>
				<td class="clItalic"/>
				<td class="clItalic"/>
				<td class="clItalic clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="5"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clItalic"/>
				<td class="clItalic clWidth4 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="5"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clItalic clWidth158"/>
				<td class="clItalic clWidth104"/>
			</tr>
			<tr>
				<td class="clFond clWidth103 clAlignRight">
					<xsl:call-template name="displayNumberXsl">
						<xsl:with-param name="InputStringNumber"
						                select="(.)"/>
					</xsl:call-template>&#160;
        </td>
				<td class="clFond clWidth10 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clFond clWidth104 clAlignRight">
					<xsl:call-template name="displayNumberXsl">
						<xsl:with-param name="InputStringNumber"
						                select="(../MTCBM)"/>
					</xsl:call-template>&#160;
        </td>
				<td class="clFond clWidth5">&#160;</td>
				<td class="clFond clWidth108 clAlignRight">
					<xsl:call-template name="displayNumberXsl">
						<xsl:with-param name="InputStringNumber"
						                select="(../MTCBI)"/>
					</xsl:call-template>&#160;
        </td>
				<td class="clFond clWidth4 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clFond clWidth74 clAlignRight">
					<xsl:call-template name="displayNumberXsl">
						<xsl:with-param name="InputStringNumber"
						                select="(../MTTITR)"/>
					</xsl:call-template>&#160;
        </td>
				<td class="clFond clWidth4 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clFond clAlignRight">
					<xsl:call-template name="displayNumberXsl">
						<xsl:with-param name="InputStringNumber"
						                select="(../MTTOT6)"/>
					</xsl:call-template>&#160;
        </td>
				<td class="clItalic">&#160;</td>
			</tr>
			<tr>
				<td class="clItalic clWidth103 clAlignRight">&#160;</td>
				<td class="clItalic clWidth10 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clItalic clWidth104 clAlignRight">&#160;</td>
				<td class="clItalic clWidth5">&#160;</td>
				<td class="clItalic clWidth108 clAlignRight">&#160;</td>
				<td class="clItalic clWidth4 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clItalic clWidth74 clAlignRight">&#160;</td>
				<td class="clItalic clWidth4 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clItalic clAlignRight">&#160;</td>
				<td/>
			</tr>
		</xsl:if>
		<xsl:if test="position()=last()">
			<tr>
				<td class="clFond clWidth103 clAlignRight">
					<b>
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../../MOYCB/MTCMLT)"/>
						</xsl:call-template>
					</b>&#160;
        </td>
				<td class="clFond clWidth10 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clFond clWidth104 clAlignRight">
					<b>
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../../MOYCB/MTCBM)"/>
						</xsl:call-template>
					</b>&#160;
        </td>
				<td class="clFond clWidth5 clAlignRight">&#160;</td>
				<td class="clFond clWidth108 clAlignRight">
					<b>
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../../MOYCB/MTCBI)"/>
						</xsl:call-template>
					</b>&#160;
        </td>
				<td class="clFond clWidth4 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clFond clWidth74 clAlignRight">
					<b>
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../../MOYCB/MTTITR)"/>
						</xsl:call-template>
					</b>&#160;
        </td>
				<td class="clFond clWidth4 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clFond clAlignRight">
					<b>
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../../MOYCB/MTTOT6)"/>
						</xsl:call-template>
					</b>&#160;
        </td>
				<td/>
			</tr>
			<tr>
				<td class="clItalic clHeight1"
				    colspan="10">&#160;</td>
			</tr>
			<xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
			<xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
		</xsl:if>
	</xsl:template>
	<!-- CREDIT MOBILISABLE -->
	<xsl:template match="CUMULCB/MTCC">
		<!--<div class="clBreakPage"></div>-->
		<xsl:if test="position()=1">
			<xsl:text disable-output-escaping="yes">&lt;td width=&quot;739&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
			<xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
			<tr>
				<td colspan="5"
				    class="clCouleur2 clHeight25 clWidth270 clAlignCenter clValignMiddle"
				    nowrap="true">CREDITS MOBILISABLES </td>
				<td class="clWidth10 clValignBottom clAlignCenter">
					<img src="{$root}images/risque/shim_bleu.gif"
					     width="1"
					     height="22"
					     vspace="0"
					     alt=""/>
				</td>
				<th rowspan="2"
				    class="clCouleur2 clWidth93 clValignMiddle clAlignRight clThNonGras"
				    nowrap="true">
          Total<br/>
          crédits mobilisés<br/>
          et mobilisables <br/>
          [VIII]=[VI]+[VII]
        </th>
				<td rowspan="2"
				    class="clWidth10 clValignBottom clAlignCenter">
					<img src="{$root}images/risque/shim_bleu.gif"
					     width="1"
					     height="91"
					     vspace="0"
					     alt=""/>
				</td>
				<th rowspan="2"
				    class="clCouleur2 clWidth93 clValignMiddle clAlignCenter clThNonGras"
				    nowrap="true">
          ENGAGEMENTS<br/>
          DE GARANTIE<br/>
					<a href="#nullepart"
					   class="clTexte"
					   onclick="requestInfosRisques('AC',cstInforisques)">
						<u>
              (AC)
            </u>
					</a>
					<br/>
				</th>
        <td rowspan="2"
				    class="clWidth10 clValignBottom clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif"
					     width="1"
					     height="91"
					     vspace="0"
					     alt=""/>
        </td>
        <th rowspan="2"
				    class="clCouleur2 clWidth93 clValignMiddle clAlignCenter clThNonGras"
				    nowrap="true">
          TITRES&#160;<br/>
          DE CREANCES<br/>
          NEGOCIABLES<br/>
					<a href="#nullepart"
					   class="clTexte"
					   onclick="requestInfosRisques('IE',cstInforisques)">
						<u>
              (IE)
            </u>
					</a>
					<br/>
				</th>
				<td class="clWidth114 clAlignRight">&#160;</td>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth94 clAlignRight clValignMiddle clThNonGras">
          Partie disponible<br/>des crédits<br/>mobilisables<br/>
					<a href="#nullepart"
					   class="clTexte"
					   onclick="requestInfosRisques('OC',cstInforisques)">
						<u>
              (OC)
            </u>
					</a>
				</th>
				<td class="clWidth10"/>
				<th class="clCouleur2 clWidth80 clAlignRight clValignMiddle clThNonGras">
          Crédits documentaires<br/>
					<a href="#nullepart"
					   class="clTexte"
					   onclick="requestInfosRisques('OD',cstInforisques)">
						<u>
              (OD)
            </u>
					</a>
				</th>
				<td class="clWidth10 clValignBottom clAlignCenter ">
					<img src="{$root}images/risque/shim_bleu.gif"
					     width="1"
					     height="70"
					     vspace="0"
					     alt=""/>
				</td>
				<th class="clCouleur2 clWidth76 clAlignRight clValignMiddle clThNonGras">Total crédits mobilisables [VII]</th>
				<td class="clWidth4 clValignBottom clAlignCenter">
					<img src="{$root}images/risque/shim_bleu.gif"
					     width="1"
					     height="70"
					     vspace="0"
					     alt=""/>
				</td>
        <td class="clWidth114 clAlignRight clBoxSizing"></td>  
			</tr>
			<tr>
				<td class="clFond clWidth94 clAlignRight">
					<xsl:call-template name="displayNumberXsl">
						<xsl:with-param name="InputStringNumber"
						                select="(.)"/>
					</xsl:call-template>&#160;
        </td>
				<td class="clFond clWidth10">&#160;</td>
				<td class="clFond clWidth80 clAlignRight">
					<xsl:call-template name="displayNumberXsl">
						<xsl:with-param name="InputStringNumber"
						                select="(../MTCD)"/>
					</xsl:call-template>&#160;
        </td>
				<td class="clFond clWidth10 clValignBottom clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clFond clWidth76 clAlignRight">
					<xsl:call-template name="displayNumberXsl">
						<xsl:with-param name="InputStringNumber"
						                select="(../MTTOT7)"/>
					</xsl:call-template>&#160;
        </td>
				<td class="clFond clWidth10 clValignBottom clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clFond clWidth93 clAlignRight">
					<xsl:call-template name="displayNumberXsl">
						<xsl:with-param name="InputStringNumber"
						                select="(../MTTOT8)"/>
					</xsl:call-template>&#160;
        </td>
				<td class="clFond clWidth10 clValignBottom clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clFond clWidth93 clAlignRight">
					<xsl:call-template name="displayNumberXsl">
						<xsl:with-param name="InputStringNumber"
						                select="(../MTAC)"/>
					</xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clValignBottom clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
        </td>
        <td class="clFond clWidth93 clAlignRight">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber"
						                select="(../MTIE)"/>
          </xsl:call-template>&#160;
        </td>
				<td class="clItalic clWidth114"/>
			</tr>
			<tr>
				<td class="clItalic clWidth94"/>
				<td class="clItalic clWidth10 clAlignCenter"/>
				<td class="clItalic clWidth80"/>
				<td class="clItalic clWidth10 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clItalic clWidth76"/>
				<td class="clItalic clWidth10 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clItalic clWidth93"/>
				<td class="clItalic clWidth10 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
        <td class="clItalic clWidth93"/>
        <td class="clItalic clWidth10"/>
				<td class="clItalic clWidth93"/>
				<td class="clItalic clWidth114"/>
			</tr>
		</xsl:if>
		<xsl:if test="position()=last()">
			<tr>
				<td class="clFond clWidth94 clAlignRight">
					<b>
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../../MOYCB/MTCC)"/>
						</xsl:call-template>
					</b>&#160;
        </td>
				<td class="clFond clWidth10 clAlignCenter"/>
				<td class="clFond clWidth80 clAlignRight">
					<b>
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../../MOYCB/MTCD)"/>
						</xsl:call-template>
					</b>&#160;
        </td>
				<td class="clFond clWidth10 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clFond clWidth76 clAlignRight">
					<b>
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../../MOYCB/MTTOT7)"/>
						</xsl:call-template>
					</b>&#160;
        </td>
				<td class="clFond clWidth10 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clFond clWidth93 clAlignRight">
					<b>
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../../MOYCB/MTTOT8)"/>
						</xsl:call-template>
					</b>&#160;
        </td>
				<td class="clFond clWidth10 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clFond clWidth93 clAlignRight">
					<b>
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../../MOYCB/MTAC)"/>
						</xsl:call-template>
					</b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
        </td>
        <td class="clFond clWidth93 clAlignRight">
          <b>
            <xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber"
							                select="(../../MOYCB/MTIE)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
				<td class="clWidth114"/>
			</tr>
			<tr>
				<td class="clItalic clHeight1"
				    colspan="12">&#160;</td>
			</tr>
			<xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
			<xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
		</xsl:if>
	</xsl:template>
	<!-- ***************** Concours bancaires collectifs *******************************************-->
	<!--DÉTAILS DES CREDITS-->
	<xsl:template name="CUMULCBC">
		<div class="clBreakPage"/>
		<table class="clWidth635 clBorderCell">
			<tr class="clAlignCenter">
				<td class="clCouleurGras">
          D&#201;TAILS DES PARTICIPATIONS EN COMPTE COLLECTIF
        </td>
			</tr>
		</table>
		<xsl:call-template name="shim"/>
		<br/>
		<table class="clWidth635 clBorderCell">
			<tr>
				<xsl:apply-templates select="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFORISQUESDO/RISQUES/CUMULCBC/@MOISREF"/>
				<xsl:apply-templates select="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFORISQUESDO/RISQUES/CUMULCBC/MTCODCCT"/>
			</tr>
		</table>
		<xsl:call-template name="shim"/>
		<br/>
		<table class="clBorderCell clWidth739">
			<tr>
				<xsl:apply-templates select="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFORISQUESDO/RISQUES/CUMULCBC/@MOISREF"/>
				<xsl:apply-templates select="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFORISQUESDO/RISQUES/CUMULCBC/MTCMLT"/>
			</tr>
		</table>
		<xsl:call-template name="shim"/>
		<br/>
		<table class="clBorderCell clWidth739">
			<tr>
				<xsl:apply-templates select="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFORISQUESDO/RISQUES/CUMULCBC/@MOISREF"/>
				<xsl:apply-templates select="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFORISQUESDO/RISQUES/CUMULCBC/MTCC"/>
			</tr>
		</table>
		<table class="clWidth635 clBorderCell">
			<tr>
				<td class="clItalic">* Moyenne des crédits sur les 13 derniers mois</td>
			</tr>
		</table>
		<br/>
		<xsl:call-template name="shim"/>
		<br/>
	</xsl:template>
	<xsl:template match="CUMULCBC/@MOISREF">
		<xsl:if test="position()=1">
			<xsl:text disable-output-escaping="yes">&lt;td width=&quot;45&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
			<xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
			<tr>
				<td class="clCouleur2 clWidth65 clHeight20"/>
			</tr>
			<tr>
				<td class="clCouleur2 clWidth65 clHeight25"/>
			</tr>
			<tr>
				<td class="clCouleur2 clWidth65 clHeight45"/>
			</tr>
			<tr>
				<td class="clItalic clValignBottom clWidth65 clAlignCenter clHeight5"/>
			</tr>
			<tr>
				<td class="clFond clWidth65 clAlignRight clHeight15">
					<xsl:call-template name="displayDateXsl">
						<xsl:with-param name="InputDate"
						                select="(.)"/>
					</xsl:call-template>
				</td>
			</tr>
			<tr>
				<td class="clItalic clWidth65 clAlignRight clHeight15"/>
			</tr>
		</xsl:if>
		<xsl:if test="position()=last()">
			<tr>
				<th class="clFond clWidth65 clAlignRight clHeight15">
					<b>Moyenne*</b>
				</th>
			</tr>
			<tr>
				<td class="clItalic clWidth65 clHeight1">&#160; </td>
			</tr>
			<xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
			<xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
		</xsl:if>
	</xsl:template>
	<!--CREDIT COURT-->
	<xsl:template match="CUMULCBC/MTCODCCT">
		<xsl:if test="position()=1">
			<xsl:text disable-output-escaping="yes">&lt;td width=&quot;739&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
			<xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
			<tr>
				<th colspan="9"
				    class="clCouleur2 clValignTop clHeight20 clWidth580 clAlignCenter clThNonGras"
				    nowrap="true">CREDITS MOBILISES</th>
				<td class="clWidth106"/>
			</tr>
			<tr>
				<th colspan="9"
				    class="clCouleur2 clValignTop clHeight25 clAlignCenter clThNonGras"
				    nowrap="true">Court terme</th>
			</tr>
			<tr class="clHeight30">
				<th class="clCouleur2 clValignTop clHeight30 clWidth110 clAlignRight clThNonGras">
          Cptes ordinaires<br/>débiteurs<br/>
					<a href="#nullepart"
					   class="clTexte"
					   onclick="requestInfosRisques('CO',cstInforisques)">
						<u>
              (CO)
            </u>
					</a>
				</th>
				<td class="clWidth4"/>
				<th class="clCouleur2 clValignTop clWidth110 clAlignRight clThNonGras">
          Créances<br/>commerciales<br/>
					<a href="#nullepart"
					   class="clTexte"
					   onclick="requestInfosRisques('CC',cstInforisques)">
						<u>
              (CC)
            </u>
					</a>
				</th>
				<td class="clWidth5"/>
				<th class="clCouleur2 clValignTop clWidth100 clAlignRight clThNonGras">
          Affacturage<br/>
					<a href="#nullepart"
					   class="clTexte"
					   onclick="requestInfosRisques('AF',cstInforisques)">
						<u>
              (AF)
            </u>
					</a>
				</th>
				<td class="clCouleur2 clWidth7">&#160;</td>
				<th class="clCouleur2 clValignTop clWidth110 clAlignRight clThNonGras">
          Autres crédits à<br/>court terme<br/>
					<a href="#nullepart"
					   class="clTexte"
					   onclick="requestInfosRisques('CA',cstInforisques)">
						<u>
              (CA)
            </u>
					</a>
				</th>
				<td class="clCouleur2b clValignBottom clWidth12 clAlignCenter">
					<img src="{$root}images/risque/shim_bleu.gif"
					     width="1"
					     height="45"
					     vspace="0"
					     alt=""/>
				</td>
				<th class="clCouleur2 clValignTop clWidth110 clAlignRight clThNonGras">
          Total court terme <br/>[I]
        </th>
				<td class="clWidth106 clAlignRight"/>
			</tr>
			<tr>
				<td class="clItalic"
				    colspan="7"/>
				<td class="clItalic clValignBottom clWidth12 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="5"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clItalic"
				    colspan="2"/>
			</tr>
			<tr>
				<td class="clFond clWidth110 clAlignRight">
					<xsl:call-template name="displayNumberXsl">
						<xsl:with-param name="InputStringNumber"
						                select="(.)"/>
					</xsl:call-template>&#160;
        </td>
				<td class="clFond clWidth4 clAlignRight">&#160;</td>
				<td class="clFond clWidth110 clAlignRight">
					<xsl:call-template name="displayNumberXsl">
						<xsl:with-param name="InputStringNumber"
						                select="(../MTCCCT)"/>
					</xsl:call-template>&#160;
        </td>
				<td class="clFond clWidth5 clAlignRight">&#160;</td>
				<td class="clFond clWidth100 clAlignRight">
					<xsl:call-template name="displayNumberXsl">
						<xsl:with-param name="InputStringNumber"
						                select="(../MTAFCT)"/>
					</xsl:call-template>&#160;
        </td>
				<td class="clFond clWidth7 clAlignRight">&#160;</td>
				<td class="clFond clWidth110 clAlignRight">
					<xsl:call-template name="displayNumberXsl">
						<xsl:with-param name="InputStringNumber"
						                select="(../MTACCT)"/>
					</xsl:call-template>&#160;
        </td>
				<td class="clFond clWidth12 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clFond clWidth110 clAlignRight">
					<xsl:call-template name="displayNumberXsl">
						<xsl:with-param name="InputStringNumber"
						                select="(../MTCBCT)"/>
					</xsl:call-template>&#160;
        </td>
				<td class="clWidth106"/>
			</tr>
			<tr>
				<td class="clItalic clWidth110 clAlignRight">&#160;</td>
				<td class="clItalic clWidth4 clAlignRight">&#160;</td>
				<td class="clItalic clWidth110 clAlignRight">&#160;</td>
				<td class="clItalic clWidth5 clAlignRight">&#160;</td>
				<td class="clItalic clWidth100 clAlignRight">&#160;</td>
				<td class="clItalic clWidth7 clAlignRight">&#160;</td>
				<td class="clItalic clWidth110 clAlignRight">&#160;</td>
				<td class="clItalic clWidth12 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clItalic clWidth110 clAlignRight">&#160;</td>
				<td class="clWidth106"/>
			</tr>
		</xsl:if>
		<xsl:if test="position()=last()">
			<tr>
				<td class="clFond clWidth110 clAlignRight">
					<b>
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../../MOYCBC/MTCODCCT)"/>
						</xsl:call-template>
					</b>&#160;
        </td>
				<td class="clFond clWidth4 clAlignRight">&#160;</td>
				<td class="clFond clWidth110 clAlignRight">
					<b>
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../../MOYCBC/MTCCCT)"/>
						</xsl:call-template>
					</b>&#160;
        </td>
				<td class="clFond clWidth5 clAlignRight">&#160;</td>
				<td class="clFond clWidth100 clAlignRight">
					<b>
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../../MOYCBC/MTAFCT)"/>
						</xsl:call-template>
					</b>&#160;
        </td>
				<td class="clFond clWidth7 clAlignRight">&#160;</td>
				<td class="clFond clWidth110 clAlignRight">
					<b>
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../../MOYCBC/MTACCT)"/>
						</xsl:call-template>
					</b>&#160;
        </td>
				<td class="clFond clWidth12 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clFond clWidth110 clAlignRight">
					<b>
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../../MOYCBC/MTCBCT)"/>
						</xsl:call-template>
					</b>&#160;
        </td>
				<td class="clWidth106"/>
			</tr>
			<tr>
				<td class="clItalic clHeight1"
				    colspan="10">&#160; </td>
			</tr>
			<xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
			<xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
		</xsl:if>
	</xsl:template>
	<!--CREDIT MOYEN ET LONG TERME-->
	<xsl:template match="CUMULCBC/MTCMLT">
		<xsl:if test="position()=1">
			<xsl:text disable-output-escaping="yes">&lt;td width=&quot;739&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
			<xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
			<tr>
				<td class="clWidth580 clHeight10"
				    colspan="9"/>
				<td class="clWidth106"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth103 clValignMiddle clAlignRight clThNonGras"
				   rowspan="2">
          Moyen
          <br/> et long terme<br/>
					<a href="#nullepart"
					   class="clTexte"
					   onclick="requestInfosRisques('TETA',cstInforisques)">
						<u>
              (TE+TA)
            </u>
					</a>
					<br/>[II]
        </th>
				<td class="clWidth10 clAlignCenter">
					<img src="{$root}images/risque/shim_bleu.gif"
					     width="1"
					     height="40"
					     vspace="0"
					     alt=""/>
				</td>
				<th colspan="3"
				    class="clCouleur2 clValignMiddle clAlignCenter clThNonGras"
				    nowrap="true">Crédits-bails </th>
				<td class="clAlignCenter">
					<img src="{$root}images/risque/shim_bleu.gif"
					     width="1"
					     height="40"
					     vspace="0"
					     alt=""/>
				</td>
				<th rowspan="2"
				    class="clCouleur2  clWidth74 clValignMiddle clAlignRight clThNonGras"
				    nowrap="true">
          Titrisés<br/>
					<a href="#nullepart"
					   class="clTexte"
					   onclick="requestInfosRisques('IT',cstInforisques)">
						<u>
              (IT)
            </u>
					</a>
					<br/>[V]
        </th>
				<td class="clAlignCenter">
					<img src="{$root}images/risque/shim_bleu.gif"
					     width="1"
					     height="40"
					     vspace="0"
					     alt=""/>
				</td>
				<th rowspan="2"
				    class="clCouleur2 clWidth158 clValignMiddle clAlignRight clThNonGras"
				    nowrap="true">
          Total <br/>
          des crédits mobilisés [VI]<br/>[I]+[II]+[III]+[IV]+[V]
        </th>
				<td class="clWidth103 clAlignRight">
					<a href="#ancHaut">
						<img src="{$root}Images/risque/fleche_haut.gif"
						     width="18"
						     height="18"
						     border="0"
						     name="Image112"
						     alt="Retour en haut de la page"/>
					</a>
				</td>
			</tr>
			<tr class="clHeight25">
				<td class="clWidth10 clAlignCenter">
					<img src="{$root}images/risque/shim_bleu.gif"
					     width="1"
					     height="40"
					     vspace="0"
					     alt=""/>
				</td>
				<th class="clCouleur2 clWidth104 clValignMiddle clAlignRight clThNonGras">
          Mobiliers
          <a href="#nullepart"
					   class="clTexte"
					   onclick="requestInfosRisques('BM',cstInforisques)">
						<u>
              (BM)
            </u>
					</a>
					<br/>[III]
        </th>
				<td class="clCouleur2 clWidth5 clAlignRight">&#160;</td>
				<th class="clCouleur2 clWidth108 clAlignRight clValignMiddle clThNonGras">
          Immobiliers
          <a href="#nullepart"
					   class="clTexte"
					   onclick="requestInfosRisques('BI',cstInforisques)">
						<u>
              (BI)
            </u>
					</a>
					<br/>[IV]
        </th>
				<td class="clWidth4 clAlignCenter">
					<img src="{$root}images/risque/shim_bleu.gif"
					     width="1"
					     height="40"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clWidth4 clAlignCenter">
					<img src="{$root}images/risque/shim_bleu.gif"
					     width="1"
					     height="40"
					     vspace="0"
					     alt=""/>
				</td>
				<td>&#160;</td>
			</tr>
			<tr>
				<td class="clItalic"/>
				<td class="clItalic clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="5"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clItalic"/>
				<td class="clItalic"/>
				<td class="clItalic"/>
				<td class="clItalic clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="5"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clItalic"/>
				<td class="clItalic clWidth4 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="5"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clItalic clWidth158"/>
				<td class="clItalic clWidth104"/>
			</tr>
			<tr>
				<td class="clFond clWidth103 clAlignRight">
					<xsl:call-template name="displayNumberXsl">
						<xsl:with-param name="InputStringNumber"
						                select="(.)"/>
					</xsl:call-template>&#160;
        </td>
				<td class="clFond clWidth10 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clFond clWidth104 clAlignRight">
					<xsl:call-template name="displayNumberXsl">
						<xsl:with-param name="InputStringNumber"
						                select="(../MTCBM)"/>
					</xsl:call-template>&#160;
        </td>
				<td class="clFond clWidth5">&#160;</td>
				<td class="clFond clWidth108 clAlignRight">
					<xsl:call-template name="displayNumberXsl">
						<xsl:with-param name="InputStringNumber"
						                select="(../MTCBI)"/>
					</xsl:call-template>&#160;
        </td>
				<td class="clFond clWidth4 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clFond clWidth74 clAlignRight">
					<xsl:call-template name="displayNumberXsl">
						<xsl:with-param name="InputStringNumber"
						                select="(../MTTITR)"/>
					</xsl:call-template>&#160;
        </td>
				<td class="clFond clWidth4 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clFond clAlignRight">
					<xsl:call-template name="displayNumberXsl">
						<xsl:with-param name="InputStringNumber"
						                select="(../MTTOT6)"/>
					</xsl:call-template>&#160;
        </td>
				<td class="clItalic">&#160;</td>
			</tr>
			<tr>
				<td class="clItalic clWidth103 clAlignRight">&#160;</td>
				<td class="clItalic clWidth10 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clItalic clWidth104 clAlignRight">&#160;</td>
				<td class="clItalic clWidth5">&#160;</td>
				<td class="clItalic clWidth108 clAlignRight">&#160;</td>
				<td class="clItalic clWidth4 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clItalic clWidth74 clAlignRight">&#160;</td>
				<td class="clItalic clWidth4 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clItalic clAlignRight">&#160;</td>
				<td/>
			</tr>
		</xsl:if>
		<xsl:if test="position()=last()">
			<tr>
				<td class="clFond clWidth103 clAlignRight">
					<b>
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../../MOYCBC/MTCMLT)"/>
						</xsl:call-template>
					</b>&#160;
        </td>
				<td class="clFond clWidth10 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clFond clWidth104 clAlignRight">
					<b>
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../../MOYCBC/MTCBM)"/>
						</xsl:call-template>
					</b>&#160;
        </td>
				<td class="clFond clWidth5 clAlignRight">&#160;</td>
				<td class="clFond clWidth108 clAlignRight">
					<b>
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../../MOYCBC/MTCBI)"/>
						</xsl:call-template>
					</b>&#160;
        </td>
				<td class="clFond clWidth4 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clFond clWidth74 clAlignRight">
					<b>
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../../MOYCBC/MTTITR)"/>
						</xsl:call-template>
					</b>&#160;
        </td>
				<td class="clFond clWidth4 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clFond clAlignRight">
					<b>
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../../MOYCBC/MTTOT6)"/>
						</xsl:call-template>
					</b>&#160;
        </td>
				<td/>
			</tr>
			<tr>
				<td class="clItalic clHeight1"
				    colspan="10">&#160;</td>
			</tr>
			<xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
			<xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
		</xsl:if>
	</xsl:template>
	<!-- CREDIT MOBILISABLE -->
	<xsl:template match="CUMULCBC/MTCC">
		<xsl:if test="position()=1">
			<xsl:text disable-output-escaping="yes">&lt;td width=&quot;739&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
			<xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
			<tr>
				<th colspan="5"
				    class="clCouleur2 clHeight25 clWidth344 clAlignCenter clValignMiddle clThNonGras"
				    nowrap="true">CREDITS MOBILISABLES </th>
				<td class="clWidth4 clValignBottom clAlignCenter">
					<img src="{$root}images/risque/shim_bleu.gif"
					     width="1"
					     height="22"
					     vspace="0"
					     alt=""/>
				</td>
				<th rowspan="2"
				    class="clCouleur2 clWidth94 clValignMiddle clAlignRight clThNonGras"
				    nowrap="true">
          Total<br/>
          crédits mobilisés<br/>
          et mobilisables <br/>
          [VIII]=[VI]+[VII]
        </th>
				<td rowspan="2"
				    class="clWidth4 clValignBottom clAlignCenter">
					<img src="{$root}images/risque/shim_bleu.gif"
					     width="1"
					     height="91"
					     vspace="0"
					     alt=""/>
				</td>
				<th rowspan="2"
				    class="clCouleur2 clWidth94 clValignMiddle clAlignRight clThNonGras"
				    nowrap="true">
          ENGAGEMENTS<br/>
          DE GARANTIE<br/>
					<a href="#nullepart"
					   class="clTexte"
					   onclick="requestInfosRisques('AC',cstInforisques)">
						<u>
              (AC)
            </u>
					</a>
					<br/>
				</th>
				<td class="clWidth104 clAlignRight">&#160;</td>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth113 clAlignRight clValignMiddle clThNonGras">
          Partie disponible<br/>
          des crédits<br/>
          mobilisables
          <br/>
					<a href="#nullepart"
					   class="clTexte"
					   onclick="requestInfosRisques('OC',cstInforisques)">
						<u>
              (OC)
            </u>
					</a>
				</th>
				<td class="clWidth10"/>
				<th class="clCouleur2 clWidth114 clAlignRight clValignMiddle clThNonGras">
          Crédits<br/>
          documentaires<br/>
					<a href="#nullepart"
					   class="clTexte"
					   onclick="requestInfosRisques('OD',cstInforisques)">
						<u>
              (OD)
            </u>
					</a>
				</th>
				<td class="clWidth5 clValignBottom clAlignCenter ">
					<img src="{$root}images/risque/shim_bleu.gif"
					     width="1"
					     height="70"
					     vspace="0"
					     alt=""/>
				</td>
				<th class="clCouleur2 clWidth108 clAlignRight clValignMiddle clThNonGras">Total crédits<br/>mobilisables [VII]</th>
				<td class="clWidth4 clValignBottom clAlignCenter">
					<img src="{$root}images/risque/shim_bleu.gif"
					     width="1"
					     height="70"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clWidth104"/>
			</tr>
			<tr>
				<td class="clFond clWidth113 clAlignRight">
					<xsl:call-template name="displayNumberXsl">
						<xsl:with-param name="InputStringNumber"
						                select="(.)"/>
					</xsl:call-template>&#160;
        </td>
				<td class="clFond clWidth10">&#160;</td>
				<td class="clFond clWidth114 clAlignRight">
					<xsl:call-template name="displayNumberXsl">
						<xsl:with-param name="InputStringNumber"
						                select="(../MTCD)"/>
					</xsl:call-template>&#160;
        </td>
				<td class="clFond clWidth5 clValignBottom clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clFond clWidth108 clAlignRight">
					<xsl:call-template name="displayNumberXsl">
						<xsl:with-param name="InputStringNumber"
						                select="(../MTTOT7)"/>
					</xsl:call-template>&#160;
        </td>
				<td class="clFond clWidth4 clValignBottom clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clFond clWidth94 clAlignRight">
					<xsl:call-template name="displayNumberXsl">
						<xsl:with-param name="InputStringNumber"
						                select="(../MTTOT8)"/>
					</xsl:call-template>&#160;
        </td>
				<td class="clFond clWidth4 clValignBottom clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clFond clWidth94 clAlignRight">
					<xsl:call-template name="displayNumberXsl">
						<xsl:with-param name="InputStringNumber"
						                select="(../MTAC)"/>
					</xsl:call-template>&#160;
        </td>
				<td class="clItalic clWidth104"/>
			</tr>
			<tr>
				<td class="clItalic clWidth113"/>
				<td class="clItalic clWidth10 clAlignCenter"/>
				<td class="clItalic clWidth114"/>
				<td class="clItalic clWidth5 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clItalic clWidth108"/>
				<td class="clItalic clWidth4 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clItalic clWidth94"/>
				<td class="clItalic clWidth4 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clItalic clWidth94"/>
				<td class="clItalic clWidth104"/>
			</tr>
		</xsl:if>
		<xsl:if test="position()=last()">
			<tr>
				<td class="clFond clWidth113 clAlignRight">
					<b>
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../../MOYCBC/MTCC)"/>
						</xsl:call-template>
					</b>&#160;
        </td>
				<td class="clFond clWidth10 clAlignCenter"/>
				<td class="clFond clWidth114 clAlignRight">
					<b>
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../../MOYCBC/MTCD)"/>
						</xsl:call-template>
					</b>&#160;
        </td>
				<td class="clFond clWidth5 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clFond clWidth108 clAlignRight">
					<b>
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../../MOYCBC/MTTOT7)"/>
						</xsl:call-template>
					</b>&#160;
        </td>
				<td class="clFond clWidth4 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clFond clWidth94 clAlignRight">
					<b>
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../../MOYCBC/MTTOT8)"/>
						</xsl:call-template>
					</b>&#160;
        </td>
				<td class="clFond clWidth4 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clFond clWidth94 clAlignRight">
					<b>
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../../MOYCBC/MTAC)"/>
						</xsl:call-template>
					</b>&#160;
        </td>
				<td class="clWidth104"/>
			</tr>
			<tr>
				<td class="clItalic clHeight1"
				    colspan="10">&#160;</td>
			</tr>
			<xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
			<xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
		</xsl:if>
	</xsl:template>
	<!-- *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-->
	<!-- *****************Concours déclarés par des intermédiaires en financement participatif *******************************************-->
	<xsl:template name="CUMULCIFP">
		<table class="clBorderCell clWidth739">
			<tr class="clAlignCenter">
				<td class="clCouleurGras clWidth635">CONCOURS DES INTERMEDIAIRES</td>
				<td class="clAlignRight clWidth104">&#160;</td>
			</tr>
			<tr class="clAlignCenter">
				<td class="clCouleurGras clWidth635">EN FINANCEMENT PARTICIPATIF</td>
				<td class="clAlignRight clWidth104">&#160;</td>
			</tr>
		</table>
		<xsl:call-template name="shim"/>
		<br/>
		<table class="clWidth635 clBorderCell">
			<tr>
				<xsl:apply-templates select="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFORISQUESDO/RISQUES/CUMULCIFP/@MOISREF"/>
				<xsl:apply-templates select="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFORISQUESDO/RISQUES/CUMULCIFP/MTCD"/>
			</tr>
		</table>
		<table class="clWidth635 clBorderCell">
			<tr>
				<td class="clItalic">* Moyenne des crédits sur les 13 derniers mois</td>
			</tr>
		</table>
		<br/>
		<xsl:call-template name="shim"/>
		<br/>
	</xsl:template>
	<xsl:template match="CUMULCIFP/@MOISREF">
		<xsl:if test="position()=1">
			<xsl:text disable-output-escaping="yes">&lt;td width=&quot;45&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
			<xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
			<tr>
				<td class="clCouleur2 clWidth65 clHeight20"/>
			</tr>
			<tr>
				<td class="clCouleur2 clWidth65 clHeight25"/>
			</tr>
			<tr>
				<td class="clCouleur2 clWidth65 clHeight5"/>
			</tr>
			<tr>
				<td class="clFond clWidth65 clAlignRight clHeight15">
					<xsl:call-template name="displayDateXsl">
						<xsl:with-param name="InputDate"
						                select="(.)"/>
					</xsl:call-template>
				</td>
			</tr>
			<tr>
				<td class="clItalic clWidth65 clAlignRight clHeight15"/>
			</tr>
		</xsl:if>
		<xsl:if test="position()=last()">
			<tr>
				<th class="clFond clWidth65 clAlignRight clHeight15">
					<b>Moyenne*</b>
				</th>
			</tr>
			<tr>
				<td class="clItalic clWidth65 clHeight1">&#160; </td>
			</tr>
			<xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
			<xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
		</xsl:if>
	</xsl:template>
	<xsl:template match="CUMULCIFP/MTCD">
		<xsl:if test="position()=1">
			<xsl:text disable-output-escaping="yes">&lt;td width=&quot;739&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
			<xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
			<tr>
				<th colspan="9"
				    class="clCouleur2 clValignTop clHeight20 clWidth580 clAlignCenter clThNonGras"
				    nowrap="true">CREDITS MOBILISES</th>
				<td class="clWidth106"/>
			</tr>
			<tr class="clHeight25">
				<th class="clCouleur2 clValignTop clWidth110 clAlignRight clThNonGras">
          Durée &#60;= à 1 an
        </th>
				<td class="clWidth4"/>
				<td class="clCouleur2 clValignTop clWidth110 clAlignRight">
          &#160;
        </td>
				<td class="clWidth5"/>
				<th class="clCouleur2 clValignTop clWidth100 clAlignRight clThNonGras">
          Durée &#62; à 1 an
        </th>
				<td class="clCouleur2 clWidth7">&#160;</td>
				<td class="clCouleur2 clValignTop clWidth110 clAlignRight">
          &#160;
        </td>
				<td class="clCouleur2b clValignBottom clWidth12 clAlignCenter">
					<img src="{$root}images/risque/shim_bleu.gif"
					     width="1"
					     height="25"
					     vspace="0"
					     alt=""/>
				</td>
				<th class="clCouleur2 clValignTop clWidth110 clAlignRight clThNonGras">
          Total
        </th>
				<td class="clWidth106 clAlignRight"/>
			</tr>
			<tr class="clHeight5">
				<td class="clItalic"
				    colspan="7"/>
				<td class="clItalic clValignBottom clWidth12 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="5"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clItalic"
				    colspan="2"/>
			</tr>
			<tr class="clHeight15">
				<td class="clFond clWidth110 clAlignRight">
					<xsl:call-template name="displayNumberXsl">
						<xsl:with-param name="InputStringNumber"
						                select="(.)"/>
					</xsl:call-template>&#160;
        </td>
				<td class="clFond clWidth4 clAlignRight">&#160;</td>
				<td class="clFond clWidth110 clAlignRight">&#160;</td>
				<td class="clFond clWidth5 clAlignRight">&#160;</td>
				<td class="clFond clWidth100 clAlignRight">
					<xsl:call-template name="displayNumberXsl">
						<xsl:with-param name="InputStringNumber"
						                select="(../MTLD)"/>
					</xsl:call-template>&#160;
        </td>
				<td class="clFond clWidth7 clAlignRight">&#160;</td>
				<td class="clFond clWidth110 clAlignRight">&#160;</td>
				<td class="clFond clWidth12 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clFond clWidth110 clAlignRight">
					<xsl:call-template name="displayNumberXsl">
						<xsl:with-param name="InputStringNumber"
						                select="(../MTTOT)"/>
					</xsl:call-template>&#160;
        </td>
				<td class="clWidth106"/>
			</tr>
			<tr>
				<td class="clItalic clWidth110 clAlignRight">&#160;</td>
				<td class="clItalic clWidth4 clAlignRight">&#160;</td>
				<td class="clItalic clWidth110 clAlignRight">&#160;</td>
				<td class="clItalic clWidth5 clAlignRight">&#160;</td>
				<td class="clItalic clWidth100 clAlignRight">&#160;</td>
				<td class="clItalic clWidth7 clAlignRight">&#160;</td>
				<td class="clItalic clWidth110 clAlignRight">&#160;</td>
				<td class="clItalic clWidth12 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clItalic clWidth110 clAlignRight">&#160;</td>
				<td class="clWidth106"/>
			</tr>
		</xsl:if>
		<xsl:if test="position()=last()">
			<tr>
				<td class="clFond clWidth110 clAlignRight">
					<b>
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../../MOYCIFP/MTCD)"/>
						</xsl:call-template>
					</b>&#160;
        </td>
				<td class="clFond clWidth4 clAlignRight">&#160;</td>
				<td class="clFond clWidth110 clAlignRight">&#160;</td>
				<td class="clFond clWidth5 clAlignRight">&#160;</td>
				<td class="clFond clWidth100 clAlignRight">
					<b>
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../../MOYCIFP/MTLD)"/>
						</xsl:call-template>
					</b>&#160;
        </td>
				<td class="clFond clWidth7 clAlignRight">&#160;</td>
				<td class="clFond clWidth110 clAlignRight">&#160;</td>
				<td class="clFond clWidth12 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clFond clWidth110 clAlignRight">
					<b>
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../../MOYCIFP/MTTOT)"/>
						</xsl:call-template>
					</b>&#160;
        </td>
				<td class="clWidth106"/>
			</tr>
			<tr>
				<td class="clItalic clHeight1"
				    colspan="10">&#160; </td>
			</tr>
			<xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
			<xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
		</xsl:if>
	</xsl:template>
	<!-- *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-* -->
	<!-- **************Concours déclarés par des sociétés de gestion de portefeuille et des entreprises d’assurance, mutuelles et institutions de prévoyance *******************************************-->
	<!-- ***************** Concours bancaires individuels *******************************************-->
	<!--DÉTAILS DES CREDITS-->
	<xsl:template name="CUMULCOA">
		<!-- titre du tableau -->
		<table class="clBorderCell clWidth739">
			<tr class="clAlignCenter">
				<td class="clCouleurGras clWidth635">CONCOURS D&#201;CLAR&#201;S PAR DES SOCI&#201;T&#201;S DE GESTION DE PORTEFEUILLE ET DES ENTREPRISES</td>
				<td class="clAlignRight clWidth104">&#160;</td>
			</tr>
			<tr class="clAlignCenter">
				<td class="clCouleurGras clWidth635">D'ASSURANCE, MUTUELLES ET INSTITUTIONS DE PR&#201;VOYANCE</td>
				<td class="clAlignRight clWidth104">&#160;</td>
			</tr>
		</table>
		<xsl:call-template name="shim"/>
		<br/>
		<table class="clBorderCell clWidth739">
			<tr class="clAlignCenter">
				<td class="clCouleurGras clWidth635">D&#201;TAILS DES CONCOURS INDIVIDUELS</td>
				<td class="clAlignRight clWidth104">&#160;</td>
			</tr>
		</table>
		<xsl:call-template name="shim"/>
		<br/>
		<table class="clWidth635 clBorderCell">
			<tr>
				<xsl:apply-templates select="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFORISQUESDO/RISQUES/CUMULCOA/@MOISREF"/>
				<xsl:apply-templates select="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFORISQUESDO/RISQUES/CUMULCOA/MTCCCT"/>
			</tr>
		</table>
		<xsl:call-template name="shim"/>
		<br/>
		<table class="clBorderCell clWidth739">
			<tr>
				<xsl:apply-templates select="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFORISQUESDO/RISQUES/CUMULCOA/@MOISREF"/>
				<xsl:apply-templates select="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFORISQUESDO/RISQUES/CUMULCOA/MTCMLT"/>
			</tr>
		</table>
		<xsl:call-template name="shim"/>
		<br/>
		<table class="clBorderCell clWidth739">
			<tr>
				<xsl:apply-templates select="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFORISQUESDO/RISQUES/CUMULCOA/@MOISREF"/>
				<xsl:apply-templates select="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFORISQUESDO/RISQUES/CUMULCOA/MTCC"/>
			</tr>
		</table>
		<table class="clWidth635 clBorderCell">
			<tr>
				<td class="clItalic">* Moyenne des crédits sur les 13 derniers mois</td>
			</tr>
		</table>
		<br/>
		<xsl:call-template name="shim"/>
		<br/>
	</xsl:template>
	<xsl:template match="CUMULCOA/@MOISREF">
		<xsl:if test="position()=1">
			<xsl:text disable-output-escaping="yes">&lt;td width=&quot;45&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
			<xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
			<tr>
				<td class="clCouleur2 clWidth65 clHeight20"/>
			</tr>
			<tr>
				<td class="clCouleur2 clWidth65 clHeight25"/>
			</tr>
			<tr>
				<td class="clCouleur2 clWidth65 clHeight45"/>
			</tr>
			<tr>
				<td class="clItalic clValignBottom clWidth65 clAlignCenter clHeight5"/>
			</tr>
			<tr>
				<td class="clFond clWidth65 clAlignRight clHeight15">
					<xsl:call-template name="displayDateXsl">
						<xsl:with-param name="InputDate"
						                select="(.)"/>
					</xsl:call-template>
				</td>
			</tr>
			<tr>
				<td class="clItalic clWidth65 clAlignRight clHeight15"/>
			</tr>
		</xsl:if>
		<xsl:if test="position()=last()">
			<tr>
				<th class="clFond clWidth65 clAlignRight clHeight15">
					<b>Moyenne*</b>
				</th>
			</tr>
			<tr>
				<td class="clItalic clWidth65 clHeight1">&#160; </td>
			</tr>
			<xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
			<xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
		</xsl:if>
	</xsl:template>
	<!--CREDIT COURT-->
	<xsl:template match="CUMULCOA/MTCCCT">
		<xsl:if test="position()=1">
			<xsl:text disable-output-escaping="yes">&lt;td width=&quot;739&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
			<xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
			<tr>
				<th colspan="9"
				    class="clCouleur2 clValignTop clHeight20 clWidth580 clAlignCenter clThNonGras"
				    nowrap="true">CREDITS MOBILISES</th>
				<td class="clWidth106"/>
			</tr>
			<tr>
				<th colspan="9"
				    class="clCouleur2 clValignTop clHeight25 clAlignCenter clThNonGras"
				    nowrap="true">Court terme</th>
			</tr>
			<tr class="clHeight30">
				<td class="clCouleur2 clValignTop clHeight30 clWidth110 clAlignRight">
          &#160;
        </td>
				<td class="clWidth4"/>
				<th class="clCouleur2 clValignTop clWidth110 clAlignRight clThNonGras">
         Créances<br/>commerciales<br/>
					<a href="#nullepart"
					   class="clTexte"
					   onclick="requestInfosRisques('CCCD',cstInforisques)">
						<u>
              (CC)
            </u>
					</a>
				</th>
				<td class="clWidth5"/>
				<td class="clCouleur2 clValignTop clWidth100 clAlignRight">
          &#160;
        </td>
				<td class="clCouleur2 clWidth7">&#160;</td>
				<th class="clCouleur2 clValignTop clWidth110 clAlignRight clThNonGras">
          Autres crédits<br/>à court terme<br/>
					<a href="#nullepart"
					   class="clTexte"
					   onclick="requestInfosRisques('CACD',cstInforisques)">
						<u>
              (CA)
            </u>
					</a>
				</th>
				<td class="clCouleur2b clValignBottom clWidth12 clAlignCenter">
					<img src="{$root}images/risque/shim_bleu.gif"
					     width="1"
					     height="45"
					     vspace="0"
					     alt=""/>
				</td>
				<th class="clCouleur2 clValignTop clWidth110 clAlignRight clThNonGras">
          Total court terme <br/>[I]
        </th>
				<td class="clWidth106 clAlignRight"/>
			</tr>
			<tr>
				<td class="clItalic"
				    colspan="7"/>
				<td class="clItalic clValignBottom clWidth12 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="5"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clItalic"
				    colspan="2"/>
			</tr>
			<tr>
				<td class="clFond clWidth110 clAlignRight">&#160;</td>
				<td class="clFond clWidth4 clAlignRight">&#160;</td>
				<td class="clFond clWidth110 clAlignRight">
					<xsl:call-template name="displayNumberXsl">
						<xsl:with-param name="InputStringNumber"
						                select="(.)"/>
					</xsl:call-template>&#160;
        </td>
				<td class="clFond clWidth5 clAlignRight">&#160;</td>
				<td class="clFond clWidth100 clAlignRight">&#160;</td>
				<td class="clFond clWidth7 clAlignRight">&#160;</td>
				<td class="clFond clWidth110 clAlignRight">
					<xsl:call-template name="displayNumberXsl">
						<xsl:with-param name="InputStringNumber"
						                select="(../MTACCT)"/>
					</xsl:call-template>&#160;
        </td>
				<td class="clFond clWidth12 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clFond clWidth110 clAlignRight">
					<xsl:call-template name="displayNumberXsl">
						<xsl:with-param name="InputStringNumber"
						                select="(../MTCBCT)"/>
					</xsl:call-template>&#160;
        </td>
				<td class="clWidth106"/>
			</tr>
			<tr>
				<td class="clItalic clWidth110 clAlignRight">&#160;</td>
				<td class="clItalic clWidth4 clAlignRight">&#160;</td>
				<td class="clItalic clWidth110 clAlignRight">&#160;</td>
				<td class="clItalic clWidth5 clAlignRight">&#160;</td>
				<td class="clItalic clWidth100 clAlignRight">&#160;</td>
				<td class="clItalic clWidth7 clAlignRight">&#160;</td>
				<td class="clItalic clWidth110 clAlignRight">&#160;</td>
				<td class="clItalic clWidth12 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clItalic clWidth110 clAlignRight">&#160;</td>
				<td class="clWidth106"/>
			</tr>
		</xsl:if>
		<xsl:if test="position()=last()">
			<tr>
				<td class="clFond clWidth110 clAlignRight">
          &#160;
        </td>
				<td class="clFond clWidth4 clAlignRight">&#160;</td>
				<td class="clFond clWidth110 clAlignRight">
					<b>
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../../MOYCOA/MTCCCT)"/>
						</xsl:call-template>
					</b>&#160;
        </td>
				<td class="clFond clWidth5 clAlignRight">&#160;</td>
				<td class="clFond clWidth100 clAlignRight">
          &#160;
        </td>
				<td class="clFond clWidth7 clAlignRight">&#160;</td>
				<td class="clFond clWidth110 clAlignRight">
					<b>
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../../MOYCOA/MTACCT)"/>
						</xsl:call-template>
					</b>&#160;
        </td>
				<td class="clFond clWidth12 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clFond clWidth110 clAlignRight">
					<b>
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../../MOYCOA/MTCBCT)"/>
						</xsl:call-template>
					</b>&#160;
        </td>
				<td class="clWidth106"/>
			</tr>
			<tr>
				<td class="clItalic clHeight1"
				    colspan="10">&#160; </td>
			</tr>
			<xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
			<xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
		</xsl:if>
	</xsl:template>
	<!--CREDIT MOYEN ET LONG TERME-->
	<xsl:template match="CUMULCOA/MTCMLT">
		<xsl:if test="position()=1">
			<xsl:text disable-output-escaping="yes">&lt;td width=&quot;739&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
			<xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
			<tr>
				<td class="clWidth580 clHeight10"
				    colspan="9"/>
				<td class="clWidth106"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth103 clValignMiddle clAlignRight clThNonGras"
				    rowspan="2">
          Moyen
          <br/> et long terme<br/>
					<a href="#nullepart"
					   class="clTexte"
					   onclick="requestInfosRisques('TETACD',cstInforisques)">
						<u>
              (TE+TA)
            </u>
					</a>
					<br/>[II]
        </th>
				<td class="clWidth10 clAlignCenter">
					<img src="{$root}images/risque/shim_bleu.gif"
					     width="1"
					     height="40"
					     vspace="0"
					     alt=""/>
				</td>
				<th colspan="3"
				    class="clCouleur2 clValignMiddle clAlignCenter clThNonGras"
				    nowrap="true">Crédits-bails </th>
				<td class="clAlignCenter">
					<img src="{$root}images/risque/shim_bleu.gif"
					     width="1"
					     height="40"
					     vspace="0"
					     alt=""/>
				</td>
				<th rowspan="2"
				    class="clCouleur2  clWidth74 clValignMiddle clAlignRight clThNonGras"
				    nowrap="true">
					<a href="#nullepart"
					   class="clTexte"
					   onclick="requestInfosRisques('ITCD',cstInforisques)">
						<u>
              (IT 
            </u>
					</a>
          - Crédits<br/>Titrisés+ 
          <a href="#nullepart"
					   class="clTexte"
					   onclick="requestInfosRisques('CRCD',cstInforisques)">
						<u>
            CR
          </u>
					</a>
					<br/>- Crédits Repris)<br/>[V]
        </th>
				<td class="clAlignCenter">
					<img src="{$root}images/risque/shim_bleu.gif"
					     width="1"
					     height="40"
					     vspace="0"
					     alt=""/>
				</td>
				<th rowspan="2"
				    class="clCouleur2 clWidth158 clValignMiddle clAlignRight clThNonGras"
				    nowrap="true">
          Total <br/>
          des crédits mobilisés [VI]<br/>[I]+[II]+[III]+[IV]+[V]
        </th>
				<td class="clWidth103 clAlignRight">
					<a href="#ancHaut">
						<img src="{$root}Images/risque/fleche_haut.gif"
						     width="18"
						     height="18"
						     border="0"
						     name="Image112"
						     alt="Retour en haut de la page"/>
					</a>
				</td>
			</tr>
			<tr class="clHeight25">
				<td class="clWidth10 clAlignCenter">
					<img src="{$root}images/risque/shim_bleu.gif"
					     width="1"
					     height="40"
					     vspace="0"
					     alt=""/>
				</td>
				<th class="clCouleur2 clWidth104 clValignMiddle clAlignRight clThNonGras">
          Mobiliers
          <a href="#nullepart"
					   class="clTexte"
					   onclick="requestInfosRisques('BMCD',cstInforisques)">
						<u>
              (BM)
            </u>
					</a>
					<br/>[III]
        </th>
				<td class="clCouleur2 clWidth5 clAlignRight">&#160;</td>
				<th class="clCouleur2 clWidth108 clAlignRight clValignMiddle clThNonGras">
          Immobiliers 
          <a href="#nullepart"
					   class="clTexte"
					   onclick="requestInfosRisques('BICD',cstInforisques)">
						<u>
            (BI)
          </u>
					</a>
					<br/>[IV]
        </th>
				<td class="clWidth4 clAlignCenter">
					<img src="{$root}images/risque/shim_bleu.gif"
					     width="1"
					     height="40"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clWidth4 clAlignCenter">
					<img src="{$root}images/risque/shim_bleu.gif"
					     width="1"
					     height="40"
					     vspace="0"
					     alt=""/>
				</td>
				<td>&#160;</td>
			</tr>
			<tr>
				<td class="clItalic"/>
				<td class="clItalic clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="5"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clItalic"/>
				<td class="clItalic"/>
				<td class="clItalic"/>
				<td class="clItalic clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="5"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clItalic"/>
				<td class="clItalic clWidth4 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="5"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clItalic clWidth158"/>
				<td class="clItalic clWidth104"/>
			</tr>
			<tr>
				<td class="clFond clWidth103 clAlignRight">
					<xsl:call-template name="displayNumberXsl">
						<xsl:with-param name="InputStringNumber"
						                select="(.)"/>
					</xsl:call-template>&#160;
        </td>
				<td class="clFond clWidth10 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clFond clWidth104 clAlignRight">
					<xsl:call-template name="displayNumberXsl">
						<xsl:with-param name="InputStringNumber"
						                select="(../MTCBM)"/>
					</xsl:call-template>&#160;
        </td>
				<td class="clFond clWidth5">&#160;</td>
				<td class="clFond clWidth108 clAlignRight">
					<xsl:call-template name="displayNumberXsl">
						<xsl:with-param name="InputStringNumber"
						                select="(../MTCBI)"/>
					</xsl:call-template>&#160;
        </td>
				<td class="clFond clWidth4 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clFond clWidth74 clAlignRight">
					<xsl:call-template name="displayNumberXsl">
						<xsl:with-param name="InputStringNumber"
						                select="(../MTTITR)"/>
					</xsl:call-template>&#160;
        </td>
				<td class="clFond clWidth4 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clFond clAlignRight">
					<xsl:call-template name="displayNumberXsl">
						<xsl:with-param name="InputStringNumber"
						                select="(../MTTOT6)"/>
					</xsl:call-template>&#160;
        </td>
				<td class="clItalic">&#160;</td>
			</tr>
			<tr>
				<td class="clItalic clWidth103 clAlignRight">&#160;</td>
				<td class="clItalic clWidth10 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clItalic clWidth104 clAlignRight">&#160;</td>
				<td class="clItalic clWidth5">&#160;</td>
				<td class="clItalic clWidth108 clAlignRight">&#160;</td>
				<td class="clItalic clWidth4 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clItalic clWidth74 clAlignRight">&#160;</td>
				<td class="clItalic clWidth4 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clItalic clAlignRight">&#160;</td>
				<td/>
			</tr>
		</xsl:if>
		<xsl:if test="position()=last()">
			<tr>
				<td class="clFond clWidth103 clAlignRight">
					<b>
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../../MOYCOA/MTCMLT)"/>
						</xsl:call-template>
					</b>&#160;
        </td>
				<td class="clFond clWidth10 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clFond clWidth104 clAlignRight">
					<b>
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../../MOYCOA/MTCBM)"/>
						</xsl:call-template>
					</b>&#160;
        </td>
				<td class="clFond clWidth5 clAlignRight">&#160;</td>
				<td class="clFond clWidth108 clAlignRight">
					<b>
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../../MOYCOA/MTCBI)"/>
						</xsl:call-template>
					</b>&#160;
        </td>
				<td class="clFond clWidth4 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clFond clWidth74 clAlignRight">
					<b>
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../../MOYCOA/MTTITR)"/>
						</xsl:call-template>
					</b>&#160;
        </td>
				<td class="clFond clWidth4 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clFond clAlignRight">
					<b>
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../../MOYCOA/MTTOT6)"/>
						</xsl:call-template>
					</b>&#160;
        </td>
				<td/>
			</tr>
			<tr>
				<td class="clItalic clHeight1"
				    colspan="10">&#160;</td>
			</tr>
			<xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
			<xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
		</xsl:if>
	</xsl:template>
	<!-- CREDIT MOBILISABLE -->
  <xsl:template match="CUMULCOA/MTCC">
    <!--<div class="clBreakPage"></div>-->
    <xsl:if test="position()=1">
      <xsl:text disable-output-escaping="yes">&lt;td width=&quot;739&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
      <tr>
        <th colspan="5" class="clCouleur2 clHeight25 clWidth344 clAlignCenter clValignMiddle clThNonGras" nowrap="true">
          CREDITS MOBILISABLES
        </th>
        <td class="clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="22" vspace="0" alt=""/>
        </td>
        <th rowspan="2" class="clCouleur2 clWidth108 clValignMiddle clAlignRight clThNonGras" nowrap="true">
          Total<br/>
          crédits mobilisés<br/>
          et mobilisables<br/>
          [VIII]=[VI]+[VII]
        </th>
        <td class="clWidth10 clAlignCenter clValignBottom" rowspan="2">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="91"  vspace="0" alt=""/>
        </td>

        <th rowspan="2" class="clCouleur2 clWidth108 clValignMiddle clAlignRight clThNonGras" nowrap="true">
          <a name="credit_eg"></a>
          ENGAGEMENTS<br/>
          DE GARANTIE<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('AC',cstInforisques)" >
            <u>
              (AC)
            </u>
          </a>
          <br/>
        </th>
        <td class="clWidth114 clAlignRight">&#160;</td>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth108 clAlignRight clValignMiddle clThNonGras">
          Partie disponible des crédits mobilisables<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('OC',cstInforisques)" >
            <u>
              (OC)
            </u>
          </a>
        </th>
        <td class="clWidth10"></td>
        <th class="clCouleur2 clWidth108 clAlignRight clValignMiddle clThNonGras">
          Crédits documentaires<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('OD',cstInforisques)" >
            <u>
              (OD)
            </u>
          </a>
        </th>
        <td class="clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="70"  vspace="0" alt=""/>
        </td>
        <th class="clCouleur2 clWidth108 clAlignRight clValignMiddle clThNonGras">Total crédits mobilisables [VII]</th>

        <td class="clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="70" vspace="0" alt=""/>
        </td>
        <td class="clWidth114"></td>
      </tr>
      <tr>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10">&#160;</td>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTCD)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTTOT7)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTTOT8)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTAC)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clWidth114"></td>
      </tr>
      <tr>
        <td class="clItalic clWidth108"/>
        <td class="clItalic clWidth10 clAlignCenter"/>
        <td class="clItalic clWidth108"/>
        <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth108"/>
        <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth108"/>
        <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth108"/>
        <td class="clItalic clWidth114"/>
      </tr>
    </xsl:if>
    <xsl:if test="position()=last()">
      <tr>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOA/MTCC)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter"></td>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOA/MTCD)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOA/MTTOT7)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOA/MTTOT8)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOA/MTAC)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clWidth114"></td>
      </tr>
      <tr>
        <td class="clItalic clHeight1" colspan="10">&#160;</td>
      </tr>
      <xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
    </xsl:if>
  </xsl:template>
	<!-- ***************** Concours bancaires collectifs *******************************************-->
	<!--DÉTAILS DES CREDITS-->
	<xsl:template name="CUMULCOAC">
		<!-- titre du tableau -->
		<table class="clBorderCell clWidth739">
			<tr class="clAlignCenter">
				<td class="clCouleurGras clWidth635">D&#201;TAILS DES PARTICIPATIONS EN COMPTE COLLECTIF</td>
				<td class="clAlignRight clWidth104">&#160;</td>
			</tr>
		</table>
		<xsl:call-template name="shim"/>
		<br/>
		<table class="clWidth635 clBorderCell">
			<tr>
				<xsl:apply-templates select="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFORISQUESDO/RISQUES/CUMULCOAC/@MOISREF"/>
				<xsl:apply-templates select="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFORISQUESDO/RISQUES/CUMULCOAC/MTCCCT"/>
			</tr>
		</table>
		<xsl:call-template name="shim"/>
		<br/>
		<table class="clBorderCell clWidth739">
			<tr>
				<xsl:apply-templates select="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFORISQUESDO/RISQUES/CUMULCOAC/@MOISREF"/>
				<xsl:apply-templates select="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFORISQUESDO/RISQUES/CUMULCOAC/MTCMLT"/>
			</tr>
		</table>
		<xsl:call-template name="shim"/>
		<br/>
		<table class="clBorderCell clWidth739">
			<tr>
				<xsl:apply-templates select="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFORISQUESDO/RISQUES/CUMULCOAC/@MOISREF"/>
				<xsl:apply-templates select="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFORISQUESDO/RISQUES/CUMULCOAC/MTCC"/>
			</tr>
		</table>
		<table class="clWidth635 clBorderCell">
			<tr>
				<td class="clItalic">* Moyenne des crédits sur les 13 derniers mois</td>
			</tr>
		</table>
		<br/>
		<xsl:call-template name="shim"/>
		<br/>
	</xsl:template>
	<xsl:template match="CUMULCOAC/@MOISREF">
		<xsl:if test="position()=1">
			<xsl:text disable-output-escaping="yes">&lt;td width=&quot;45&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
			<xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
			<tr>
				<td class="clCouleur2 clWidth65 clHeight20"/>
			</tr>
			<tr>
				<td class="clCouleur2 clWidth65 clHeight25"/>
			</tr>
			<tr>
				<td class="clCouleur2 clWidth65 clHeight45"/>
			</tr>
			<tr>
				<td class="clItalic clValignBottom clWidth65 clAlignCenter clHeight5"/>
			</tr>
			<tr>
				<td class="clFond clWidth65 clAlignRight clHeight15">
					<xsl:call-template name="displayDateXsl">
						<xsl:with-param name="InputDate"
						                select="(.)"/>
					</xsl:call-template>
				</td>
			</tr>
			<tr>
				<td class="clItalic clWidth65 clAlignRight clHeight15"/>
			</tr>
		</xsl:if>
		<xsl:if test="position()=last()">
			<tr>
				<th class="clFond clWidth65 clAlignRight clHeight15">
					<b>Moyenne*</b>
				</th>
			</tr>
			<tr>
				<td class="clItalic clWidth65 clHeight1">&#160; </td>
			</tr>
			<xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
			<xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
		</xsl:if>
	</xsl:template>
	<!--CREDIT COURT-->
	<xsl:template match="CUMULCOAC/MTCCCT">
		<xsl:if test="position()=1">
			<xsl:text disable-output-escaping="yes">&lt;td width=&quot;739&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
			<xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
			<tr>
				<th colspan="9"
				    class="clCouleur2 clValignTop clHeight20 clWidth580 clAlignCenter clThNonGras"
				    nowrap="true">CREDITS MOBILISES</th>
				<td class="clWidth106"/>
			</tr>
			<tr>
				<th colspan="9"
				    class="clCouleur2 clValignTop clHeight25 clAlignCenter clThNonGras"
				    nowrap="true">Court terme</th>
			</tr>
			<tr class="clHeight30">
				<td class="clCouleur2 clValignTop clHeight30 clWidth110 clAlignRight">
          &#160;
        </td>
				<td class="clWidth4"/>
				<th class="clCouleur2 clValignTop clWidth110 clAlignRight clThNonGras">
          Créances<br/>commerciales<br/>
					<a href="#nullepart"
					   class="clTexte"
					   onclick="requestInfosRisques('CCCD',cstInforisques)">
						<u>
              (CC)
            </u>
					</a>
				</th>
				<td class="clWidth5"/>
				<td class="clCouleur2 clValignTop clWidth100 clAlignRight">
          &#160;
        </td>
				<td class="clCouleur2 clWidth7">&#160;</td>
				<th class="clCouleur2 clValignTop clWidth110 clAlignRight clThNonGras">
          Autres crédits<br/>à court terme<br/>
					<a href="#nullepart"
					   class="clTexte"
					   onclick="requestInfosRisques('CACD',cstInforisques)">
						<u>
              (CA)
            </u>
					</a>
				</th>
				<td class="clCouleur2b clValignBottom clWidth12 clAlignCenter">
					<img src="{$root}images/risque/shim_bleu.gif"
					     width="1"
					     height="45"
					     vspace="0"
					     alt=""/>
				</td>
				<th class="clCouleur2 clValignTop clWidth110 clAlignRight clThNonGras">
          Total court terme <br/>[I]
        </th>
				<td class="clWidth106 clAlignRight"/>
			</tr>
			<tr>
				<td class="clItalic"
				    colspan="7"/>
				<td class="clItalic clValignBottom clWidth12 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="5"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clItalic"
				    colspan="2"/>
			</tr>
			<tr>
				<td class="clFond clWidth110 clAlignRight">&#160;</td>
				<td class="clFond clWidth4 clAlignRight">&#160;</td>
				<td class="clFond clWidth110 clAlignRight">
					<xsl:call-template name="displayNumberXsl">
						<xsl:with-param name="InputStringNumber"
						                select="(.)"/>
					</xsl:call-template>&#160;
        </td>
				<td class="clFond clWidth5 clAlignRight">&#160;</td>
				<td class="clFond clWidth100 clAlignRight">&#160;</td>
				<td class="clFond clWidth7 clAlignRight">&#160;</td>
				<td class="clFond clWidth110 clAlignRight">
					<xsl:call-template name="displayNumberXsl">
						<xsl:with-param name="InputStringNumber"
						                select="(../MTACCT)"/>
					</xsl:call-template>&#160;
        </td>
				<td class="clFond clWidth12 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clFond clWidth110 clAlignRight">
					<xsl:call-template name="displayNumberXsl">
						<xsl:with-param name="InputStringNumber"
						                select="(../MTCBCT)"/>
					</xsl:call-template>&#160;
        </td>
				<td class="clWidth106"/>
			</tr>
			<tr>
				<td class="clItalic clWidth110 clAlignRight">&#160;</td>
				<td class="clItalic clWidth4 clAlignRight">&#160;</td>
				<td class="clItalic clWidth110 clAlignRight">&#160;</td>
				<td class="clItalic clWidth5 clAlignRight">&#160;</td>
				<td class="clItalic clWidth100 clAlignRight">&#160;</td>
				<td class="clItalic clWidth7 clAlignRight">&#160;</td>
				<td class="clItalic clWidth110 clAlignRight">&#160;</td>
				<td class="clItalic clWidth12 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clItalic clWidth110 clAlignRight">&#160;</td>
				<td class="clWidth106"/>
			</tr>
		</xsl:if>
		<xsl:if test="position()=last()">
			<tr>
				<td class="clFond clWidth110 clAlignRight">
          &#160;
        </td>
				<td class="clFond clWidth4 clAlignRight">&#160;</td>
				<td class="clFond clWidth110 clAlignRight">
					<b>
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../../MOYCOAC/MTCCCT)"/>
						</xsl:call-template>
					</b>&#160;
        </td>
				<td class="clFond clWidth5 clAlignRight">&#160;</td>
				<td class="clFond clWidth100 clAlignRight">
          &#160;
        </td>
				<td class="clFond clWidth7 clAlignRight">&#160;</td>
				<td class="clFond clWidth110 clAlignRight">
					<b>
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../../MOYCOAC/MTACCT)"/>
						</xsl:call-template>
					</b>&#160;
        </td>
				<td class="clFond clWidth12 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clFond clWidth110 clAlignRight">
					<b>
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../../MOYCOAC/MTCBCT)"/>
						</xsl:call-template>
					</b>&#160;
        </td>
				<td class="clWidth106"/>
			</tr>
			<tr>
				<td class="clItalic clHeight1"
				    colspan="10">&#160; </td>
			</tr>
			<xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
			<xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
		</xsl:if>
	</xsl:template>
	<!--CREDIT MOYEN ET LONG TERME-->
	<xsl:template match="CUMULCOAC/MTCMLT">
		<xsl:if test="position()=1">
			<xsl:text disable-output-escaping="yes">&lt;td width=&quot;739&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
			<xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
			<tr>
				<td class="clWidth580 clHeight10"
				    colspan="9"/>
				<td class="clWidth106"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth103 clValignMiddle clAlignRight clThNonGras"
				    rowspan="2">
          Moyen
          <br/> et long terme<br/>
					<a href="#nullepart"
					   class="clTexte"
					   onclick="requestInfosRisques('TETACD',cstInforisques)">
						<u>
              (TE+TA)
            </u>
					</a>
					<br/>[II]
        </th>
				<td class="clWidth10 clAlignCenter">
					<img src="{$root}images/risque/shim_bleu.gif"
					     width="1"
					     height="40"
					     vspace="0"
					     alt=""/>
				</td>
				<th colspan="3"
				    class="clCouleur2 clValignMiddle clAlignCenter clThNonGras"
				    nowrap="true">Crédits-bails </th>
				<td class="clAlignCenter">
					<img src="{$root}images/risque/shim_bleu.gif"
					     width="1"
					     height="40"
					     vspace="0"
					     alt=""/>
				</td>
				<th rowspan="2"
				    class="clCouleur2  clWidth74 clValignMiddle clAlignRight clThNonGras"
				    nowrap="true">
					<a href="#nullepart"
					   class="clTexte"
					   onclick="requestInfosRisques('ITCD',cstInforisques)">
						<u>
              (IT
            </u>
					</a>
          - Crédits<br/>Titrisés+ 
          <a href="#nullepart"
					   class="clTexte"
					   onclick="requestInfosRisques('CRCD',cstInforisques)">
						<u>
            CR
          </u>
					</a>
					<br/>- Crédits Repris)<br/>[V]
        </th>
				<td class="clAlignCenter">
					<img src="{$root}images/risque/shim_bleu.gif"
					     width="1"
					     height="40"
					     vspace="0"
					     alt=""/>
				</td>
				<th rowspan="2"
				    class="clCouleur2 clWidth158 clValignMiddle clAlignRight clThNonGras"
				    nowrap="true">
          Total <br/>
          des crédits mobilisés [VI]<br/>[I]+[II]+[III]+[IV]+[V]
        </th>
				<td class="clWidth103 clAlignRight">
					<a href="#ancHaut">
						<img src="{$root}Images/risque/fleche_haut.gif"
						     width="18"
						     height="18"
						     border="0"
						     name="Image112"
						     alt="Retour en haut de la page"/>
					</a>
				</td>
			</tr>
			<tr class="clHeight25">
				<td class="clWidth10 clAlignCenter">
					<img src="{$root}images/risque/shim_bleu.gif"
					     width="1"
					     height="40"
					     vspace="0"
					     alt=""/>
				</td>
				<th class="clCouleur2 clWidth104 clValignMiddle clAlignRight clThNonGras">
          Mobiliers 
          <a href="#nullepart"
					   class="clTexte"
					   onclick="requestInfosRisques('BMCD',cstInforisques)">
						<u>
            (BM)
          </u>
					</a>
					<br/>[III]
        </th>
				<td class="clCouleur2 clWidth5 clAlignRight">&#160;</td>
				<th class="clCouleur2 clWidth108 clAlignRight clValignMiddle clThNonGras">
          Immobiliers 
          <a href="#nullepart"
					   class="clTexte"
					   onclick="requestInfosRisques('BICD',cstInforisques)">
						<u>
            (BI)
          </u>
					</a>
					<br/>[IV]
        </th>
				<td class="clWidth4 clAlignCenter">
					<img src="{$root}images/risque/shim_bleu.gif"
					     width="1"
					     height="40"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clWidth4 clAlignCenter">
					<img src="{$root}images/risque/shim_bleu.gif"
					     width="1"
					     height="40"
					     vspace="0"
					     alt=""/>
				</td>
				<td>&#160;</td>
			</tr>
			<tr>
				<td class="clItalic"/>
				<td class="clItalic clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="5"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clItalic"/>
				<td class="clItalic"/>
				<td class="clItalic"/>
				<td class="clItalic clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="5"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clItalic"/>
				<td class="clItalic clWidth4 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="5"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clItalic clWidth158"/>
				<td class="clItalic clWidth104"/>
			</tr>
			<tr>
				<td class="clFond clWidth103 clAlignRight">
					<xsl:call-template name="displayNumberXsl">
						<xsl:with-param name="InputStringNumber"
						                select="(.)"/>
					</xsl:call-template>&#160;
        </td>
				<td class="clFond clWidth10 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clFond clWidth104 clAlignRight">
					<xsl:call-template name="displayNumberXsl">
						<xsl:with-param name="InputStringNumber"
						                select="(../MTCBM)"/>
					</xsl:call-template>&#160;
        </td>
				<td class="clFond clWidth5">&#160;</td>
				<td class="clFond clWidth108 clAlignRight">
					<xsl:call-template name="displayNumberXsl">
						<xsl:with-param name="InputStringNumber"
						                select="(../MTCBI)"/>
					</xsl:call-template>&#160;
        </td>
				<td class="clFond clWidth4 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clFond clWidth74 clAlignRight">
					<xsl:call-template name="displayNumberXsl">
						<xsl:with-param name="InputStringNumber"
						                select="(../MTTITR)"/>
					</xsl:call-template>&#160;
        </td>
				<td class="clFond clWidth4 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clFond clAlignRight">
					<xsl:call-template name="displayNumberXsl">
						<xsl:with-param name="InputStringNumber"
						                select="(../MTTOT6)"/>
					</xsl:call-template>&#160;
        </td>
				<td class="clItalic">&#160;</td>
			</tr>
			<tr>
				<td class="clItalic clWidth103 clAlignRight">&#160;</td>
				<td class="clItalic clWidth10 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clItalic clWidth104 clAlignRight">&#160;</td>
				<td class="clItalic clWidth5">&#160;</td>
				<td class="clItalic clWidth108 clAlignRight">&#160;</td>
				<td class="clItalic clWidth4 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clItalic clWidth74 clAlignRight">&#160;</td>
				<td class="clItalic clWidth4 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clItalic clAlignRight">&#160;</td>
				<td/>
			</tr>
		</xsl:if>
		<xsl:if test="position()=last()">
			<tr>
				<td class="clFond clWidth103 clAlignRight">
					<b>
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../../MOYCOAC/MTCMLT)"/>
						</xsl:call-template>
					</b>&#160;
        </td>
				<td class="clFond clWidth10 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clFond clWidth104 clAlignRight">
					<b>
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../../MOYCOAC/MTCBM)"/>
						</xsl:call-template>
					</b>&#160;
        </td>
				<td class="clFond clWidth5 clAlignRight">&#160;</td>
				<td class="clFond clWidth108 clAlignRight">
					<b>
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../../MOYCOAC/MTCBI)"/>
						</xsl:call-template>
					</b>&#160;
        </td>
				<td class="clFond clWidth4 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clFond clWidth74 clAlignRight">
					<b>
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../../MOYCOAC/MTTITR)"/>
						</xsl:call-template>
					</b>&#160;
        </td>
				<td class="clFond clWidth4 clAlignCenter">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="15"
					     vspace="0"
					     alt=""/>
				</td>
				<td class="clFond clAlignRight">
					<b>
						<xsl:call-template name="displayNumberXsl">
							<xsl:with-param name="InputStringNumber"
							                select="(../../MOYCOAC/MTTOT6)"/>
						</xsl:call-template>
					</b>&#160;
        </td>
				<td/>
			</tr>
			<tr>
				<td class="clItalic clHeight1"
				    colspan="10">&#160;</td>
			</tr>
			<xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
			<xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
		</xsl:if>
	</xsl:template>
	<!-- CREDIT MOBILISABLE -->
  <xsl:template match="CUMULCOAC/MTCC">
    <!--<div class="clBreakPage"></div>-->
    <xsl:if test="position()=1">
      <xsl:text disable-output-escaping="yes">&lt;td width=&quot;739&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
      <tr>
        <th colspan="5" class="clCouleur2 clHeight25 clWidth344 clAlignCenter clValignMiddle clThNonGras" nowrap="true">
          CREDITS MOBILISABLES
        </th>
        <td class="clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="22" vspace="0" alt=""/>
        </td>
        <th rowspan="2" class="clCouleur2 clWidth108 clValignMiddle clAlignRight clThNonGras" nowrap="true">
          Total<br/>
          crédits mobilisés<br/>
          et mobilisables<br/>
          [VIII]=[VI]+[VII]
        </th>
        <td class="clWidth10 clAlignCenter clValignBottom" rowspan="2">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="91"  vspace="0" alt=""/>
        </td>

        <th rowspan="2" class="clCouleur2 clWidth108 clValignMiddle clAlignRight clThNonGras" nowrap="true">
          <a name="credit_eg"></a>
          ENGAGEMENTS<br/>
          DE GARANTIE<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('AC',cstInforisques)" >
            <u>
              (AC)
            </u>
          </a>
          <br/>
        </th>
        <td class="clWidth114 clAlignRight">&#160;</td>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth108 clAlignRight clValignMiddle clThNonGras">
          Partie disponible des crédits mobilisables<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('OC',cstInforisques)" >
            <u>
              (OC)
            </u>
          </a>
        </th>
        <td class="clWidth10"></td>
        <th class="clCouleur2 clWidth108 clAlignRight clValignMiddle clThNonGras">
          Crédits documentaires<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('OD',cstInforisques)" >
            <u>
              (OD)
            </u>
          </a>
        </th>
        <td class="clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="70"  vspace="0" alt=""/>
        </td>
        <th class="clCouleur2 clWidth108 clAlignRight clValignMiddle clThNonGras">Total crédits mobilisables [VII]</th>


        <td class="clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="70" vspace="0" alt=""/>
        </td>
        <td class="clWidth114"></td>
      </tr>
      <tr>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10">&#160;</td>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTCD)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTTOT7)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTTOT8)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTAC)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clWidth114"></td>
      </tr>
      <tr>
        <td class="clItalic clWidth108"/>
        <td class="clItalic clWidth10 clAlignCenter"/>
        <td class="clItalic clWidth108"/>
        <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth108"/>
        <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth108"/>
        <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth108"/>
        <td class="clItalic clWidth114"/>
      </tr>
    </xsl:if>
    <xsl:if test="position()=last()">
      <tr>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOAC/MTCC)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter"></td>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOAC/MTCD)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOAC/MTTOT7)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOAC/MTTOT8)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOAC/MTAC)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clWidth114"></td>
      </tr>
      <tr>
        <td class="clItalic clHeight1" colspan="10">&#160;</td>
      </tr>
      <xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
    </xsl:if>
  </xsl:template>
	<!-- *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-* -->
	<!--********************************************************************************************************************************************************************-->
	<!--********************************************************************************************************************************************************************-->
	<!--**************************  RELATIONS BANCAIRES      ****************************************************-->
	<xsl:template match="INFORELBANC">
		<a name="ancRelbanc"/>
		<table class="clBorderCell clWidth739"
		       role="presentation">
			<tr class="clAlignCenter">
				<td class="clCouleurGras">
          LISTE DES RELATIONS BANCAIRES (<xsl:value-of select="NBRELBAN"/>)
        </td>
				<td class="clWidth103 clAlignRight">
					<a href="#ancHaut">
						<img src="{$root}Images/risque/fleche_haut.gif"
						     width="18"
						     height="18"
						     border="0"
						     name="Image112"
						     alt="Retour en haut de la page"/>
					</a>
				</td>
			</tr>
		</table>
		<xsl:call-template name="shim"/>
		<table class="clBorderCell clWidth739">
			<caption class="visually-hidden">LISTE DES RELATIONS BANCAIRES</caption>
			<tr>
				<td class="clCouleur2 clWidth24 clAlignRight"/>
				<th class="clCouleur2 clWidth66 clAlignLeft clThNonGras">Banque</th>
				<th class="clCouleur2 clWidth79 clAlignLeft clThNonGras">Guichet</th>
				<th class="clCouleur2 clWidth304 clAlignLeft clThNonGras">Libellé de l'établissement bancaire </th>
				<th class="clCouleur2 clWidth162 clAlignCenter clThNonGras">Date de mise à jour</th>
				<td class="clWidth104"> &#160;</td>
			</tr>
			<xsl:apply-templates select="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFORELBANC/RELBAN"/>
		</table>
		<xsl:call-template name="shim"/>
	</xsl:template>
	<xsl:template match="RELBAN">
		<xsl:if test="position() mod 2 != 0">
			<tr>
				<td class="clFond clWidth24"/>
				<td class="clFond clWidth66">
					<xsl:value-of select="COBAN"/>
				</td>
				<td class="clFond clWidth79">
					<xsl:value-of select="COGUI"/>
				</td>
				<td class="clFond clWidth304">
					<xsl:value-of select="LIBBAN"/>
				</td>
				<td class="clFond clWidth162 clAlignCenter">
					<xsl:call-template name="displayDateXsl">
						<xsl:with-param name="InputDate"
						                select="(DATMAJ)"/>
					</xsl:call-template>
				</td>
				<td class="clAlignRight">&#160;</td>
			</tr>
		</xsl:if>
		<xsl:if test="position() mod 2 = 0">
			<tr>
				<td class="clTexte clWidth24 clAlignRight"/>
				<td class="clTexte clWidth66">
					<xsl:value-of select="COBAN"/>
				</td>
				<td class="clTexte clWidth79">
					<xsl:value-of select="COGUI"/>
				</td>
				<td class="clTexte clWidth304">
					<xsl:value-of select="LIBBAN"/>
				</td>
				<td class="clTexte clWidth162 clAlignCenter">
					<xsl:call-template name="displayDateXsl">
						<xsl:with-param name="InputDate"
						                select="(DATMAJ)"/>
					</xsl:call-template>
				</td>
				<td class="clAlignRight">&#160;</td>
			</tr>
		</xsl:if>
		<xsl:if test="position() = last()">
			<xsl:if test="//INFORELBANC/SUITE">
				<tr>
					<td colspan="5">
						<table class="clWidth635 clBorderCell"
						       role="presentation">
							<tr>
								<td class="clCouleur2 clWidth530 clHeight14"
								    colspan="4"/>
								<td class="clWidth105 clHeight14 clValignMiddle clAlignRight">
									<a href="#nullepart"
									   onClick="requestBDFInfos('40','','1','{EJ/IDENTS}',cstSimpleConfirm);">
										<img src="../images/Commun/clignotant2.gif"
										     width="85"
										     height="12"
										     border="0"
										     align="absbottom"
										     alt="plus d'infos"/>
									</a>
								</td>
							</tr>
						</table>
					</td>
					<td/>
				</tr>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<!--************************************* Partie Tableau Vitrine Bilan ********************************************************************-->
	<xsl:template name="RechDateTableauVB">
		<xsl:param name="n"/>
		<xsl:param name="max"/>
		<xsl:param name="listeDateTest"/>
		<xsl:param name="listeDureeTest"/>
		<xsl:param name="dateTest"/>
		<xsl:param name="dateClot1"/>
		<xsl:param name="dateClot2"/>
		<xsl:param name="dateClot3"/>
		<xsl:param name="dateDuree1"/>
		<xsl:param name="dateDuree2"/>
		<xsl:param name="dateDuree3"/>
		<xsl:param name="TypeTableau"/>
		<xsl:if test="$n &gt; $max">
			<!-- fin du test -->
			<xsl:call-template name="ChoixTableauVB">
				<xsl:with-param name="dateClot1"
				                select="$dateClot1"/>
				<xsl:with-param name="dateClot2"
				                select="$dateClot2"/>
				<xsl:with-param name="dateClot3"
				                select="$dateClot3"/>
				<xsl:with-param name="dateDuree1"
				                select="$dateDuree1"/>
				<xsl:with-param name="dateDuree2"
				                select="$dateDuree2"/>
				<xsl:with-param name="dateDuree3"
				                select="$dateDuree3"/>
				<xsl:with-param name="TypeTableau"
				                select="$TypeTableau"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:if test="$n &lt;= $max">
			<!-- test -->
			<xsl:choose>
				<xsl:when test="($dateClot1 = '129999') and ($dateClot1 != $listeDateTest[position()=$n])">
					<xsl:call-template name="RechDateTableauVB">
						<xsl:with-param name="n"
						                select="$n + 1"/>
						<xsl:with-param name="max"
						                select="$max"/>
						<xsl:with-param name="dateClot1"
						                select="$listeDateTest[position()=$n]"/>
						<xsl:with-param name="dateClot2"
						                select="$dateClot2"/>
						<xsl:with-param name="dateClot3"
						                select="$dateClot3"/>
						<xsl:with-param name="dateDuree1"
						                select="$listeDureeTest[position()=$n]"/>
						<xsl:with-param name="dateDuree2"
						                select="$dateDuree2"/>
						<xsl:with-param name="dateDuree3"
						                select="$dateDuree3"/>
						<xsl:with-param name="listeDateTest"
						                select="$listeDateTest"/>
						<xsl:with-param name="listeDureeTest"
						                select="$listeDureeTest"/>
						<xsl:with-param name="TypeTableau"
						                select="$TypeTableau"/>
					</xsl:call-template>
				</xsl:when>
				<!-- ***************** 2eme date cloture ********************* -->
				<xsl:when test="($dateClot2 = '128888') and ($dateClot1 != $listeDateTest[position()=$n])">
					<xsl:call-template name="RechDateTableauVB">
						<xsl:with-param name="n"
						                select="$n + 1"/>
						<xsl:with-param name="max"
						                select="$max"/>
						<xsl:with-param name="dateClot1"
						                select="$dateClot1"/>
						<xsl:with-param name="dateClot2"
						                select="$listeDateTest[position()=$n]"/>
						<xsl:with-param name="dateClot3"
						                select="$dateClot3"/>
						<xsl:with-param name="dateDuree1"
						                select="$dateDuree1"/>
						<xsl:with-param name="dateDuree2"
						                select="$listeDureeTest[position()=$n]"/>
						<xsl:with-param name="dateDuree3"
						                select="$dateDuree3"/>
						<xsl:with-param name="listeDureeTest"
						                select="$listeDureeTest"/>
						<xsl:with-param name="listeDateTest"
						                select="$listeDateTest"/>
						<xsl:with-param name="TypeTableau"
						                select="$TypeTableau"/>
					</xsl:call-template>
				</xsl:when>
				<!-- ***************** 3eme date cloture ********************* -->
				<xsl:when test="($dateClot3 = '127777') and (($dateClot1 != $listeDateTest[position()=$n]) and ($dateClot2 != $listeDateTest[position()=$n]))">
					<xsl:call-template name="RechDateTableauVB">
						<xsl:with-param name="n"
						                select="$n + 1"/>
						<xsl:with-param name="max"
						                select="$max"/>
						<xsl:with-param name="dateClot1"
						                select="$dateClot1"/>
						<xsl:with-param name="dateClot2"
						                select="$dateClot2"/>
						<xsl:with-param name="dateClot3"
						                select="$listeDateTest[position()=$n]"/>
						<xsl:with-param name="listeDateTest"
						                select="$listeDateTest"/>
						<xsl:with-param name="dateDuree1"
						                select="$dateDuree1"/>
						<xsl:with-param name="dateDuree2"
						                select="$dateDuree2"/>
						<xsl:with-param name="dateDuree3"
						                select="$listeDureeTest[position()=$n]"/>
						<xsl:with-param name="listeDureeTest"
						                select="$listeDureeTest"/>
						<xsl:with-param name="TypeTableau"
						                select="$TypeTableau"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<!-- **************************** boucle de retour ***************************** -->
					<xsl:if test="$n &lt;= $max ">
						<xsl:call-template name="RechDateTableauVB">
							<xsl:with-param name="n"
							                select="$n + 1"/>
							<xsl:with-param name="max"
							                select="$max"/>
							<xsl:with-param name="dateClot1"
							                select="$dateClot1"/>
							<xsl:with-param name="dateClot2"
							                select="$dateClot2"/>
							<xsl:with-param name="dateClot3"
							                select="$dateClot3"/>
							<xsl:with-param name="listeDateTest"
							                select="$listeDateTest"/>
							<xsl:with-param name="dateDuree1"
							                select="$dateDuree1"/>
							<xsl:with-param name="dateDuree2"
							                select="$dateDuree2"/>
							<xsl:with-param name="dateDuree3"
							                select="$dateDuree3"/>
							<xsl:with-param name="listeDureeTest"
							                select="$listeDureeTest"/>
							<xsl:with-param name="TypeTableau"
							                select="$TypeTableau"/>
						</xsl:call-template>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>
	<xsl:template name="ChoixTableauVB">
		<xsl:param name="dateClot1"/>
		<xsl:param name="dateClot2"/>
		<xsl:param name="dateClot3"/>
		<xsl:param name="dateDuree1"/>
		<xsl:param name="dateDuree2"/>
		<xsl:param name="dateDuree3"/>
		<xsl:param name="TypeTableau"/>
		<!-- Formatage des dates de clotures pour avoir l'année avant le mois  (exemple 042021 devient 202104) -->
		<xsl:variable name="newDateClot1"
		              select="concat(substring($dateClot1,3, 4), substring($dateClot1,1, 2))"/>
		<xsl:variable name="newDateClot2"
		              select="concat(substring($dateClot2,3, 4), substring($dateClot2,1, 2))"/>
		<xsl:variable name="newDateClot3"
		              select="concat(substring($dateClot3,3, 4), substring($dateClot3,1, 2))"/>
		<xsl:choose>
			<xsl:when test="$dateClot2 = 128888">
				<!-- tableau à 1 colonne -->
				<xsl:call-template name="TableauVb1Col">
					<xsl:with-param name="DateClot1erCols"
					                select="$dateClot1"/>
					<xsl:with-param name="DateDuree1erCols"
					                select="$dateDuree1"/>
				</xsl:call-template>
				<xsl:call-template name="RemplirTableauVb1">
					<xsl:with-param name="DateClot1erCols"
					                select="$dateClot1"/>
					<xsl:with-param name="TypeTableau"
					                select="$TypeTableau"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="$dateClot3 != 127777">
						<!-- tableau à 3 colonnes -->
						<xsl:choose>
							<xsl:when test="($newDateClot3 &gt; $newDateClot2) and ($newDateClot2 &gt; $newDateClot1)">
								<xsl:call-template name="TableauVb3Cols">
									<xsl:with-param name="DateClot1erCols"
									                select="$dateClot1"/>
									<xsl:with-param name="DateClot2emeCols"
									                select="$dateClot2"/>
									<xsl:with-param name="DateClot3emeCols"
									                select="$dateClot3"/>
									<xsl:with-param name="DateDuree1erCols"
									                select="$dateDuree1"/>
									<xsl:with-param name="DateDuree2emeCols"
									                select="$dateDuree2"/>
									<xsl:with-param name="DateDuree3emeCols"
									                select="$dateDuree3"/>
								</xsl:call-template>
								<xsl:call-template name="RemplirTableauVb3">
									<xsl:with-param name="DateClot1erCols"
									                select="$dateClot1"/>
									<xsl:with-param name="DateClot2emeCols"
									                select="$dateClot2"/>
									<xsl:with-param name="DateClot3emeCols"
									                select="$dateClot3"/>
									<xsl:with-param name="TypeTableau"
									                select="$TypeTableau"/>
								</xsl:call-template>
							</xsl:when>
							<xsl:when test="($newDateClot2 &gt; $newDateClot3) and ($newDateClot3 &gt; $newDateClot1)">
								<xsl:call-template name="TableauVb3Cols">
									<xsl:with-param name="DateClot1erCols"
									                select="$dateClot1"/>
									<xsl:with-param name="DateClot2emeCols"
									                select="$dateClot3"/>
									<xsl:with-param name="DateClot3emeCols"
									                select="$dateClot2"/>
									<xsl:with-param name="DateDuree1erCols"
									                select="$dateDuree1"/>
									<xsl:with-param name="DateDuree2emeCols"
									                select="$dateDuree3"/>
									<xsl:with-param name="DateDuree3emeCols"
									                select="$dateDuree2"/>
								</xsl:call-template>
								<xsl:call-template name="RemplirTableauVb3">
									<xsl:with-param name="DateClot1erCols"
									                select="$dateClot1"/>
									<xsl:with-param name="DateClot2emeCols"
									                select="$dateClot3"/>
									<xsl:with-param name="DateClot3emeCols"
									                select="$dateClot2"/>
									<xsl:with-param name="TypeTableau"
									                select="$TypeTableau"/>
								</xsl:call-template>
							</xsl:when>
							<xsl:when test="($newDateClot1 &gt; $newDateClot2) and ($newDateClot3 &gt; $newDateClot1)">
								<xsl:call-template name="TableauVb3Cols">
									<xsl:with-param name="DateClot1erCols"
									                select="$dateClot2"/>
									<xsl:with-param name="DateClot2emeCols"
									                select="$dateClot1"/>
									<xsl:with-param name="DateClot3emeCols"
									                select="$dateClot3"/>
									<xsl:with-param name="DateDuree1erCols"
									                select="$dateDuree2"/>
									<xsl:with-param name="DateDuree2emeCols"
									                select="$dateDuree1"/>
									<xsl:with-param name="DateDuree3emeCols"
									                select="$dateDuree3"/>
								</xsl:call-template>
								<xsl:call-template name="RemplirTableauVb3">
									<xsl:with-param name="DateClot1erCols"
									                select="$dateClot2"/>
									<xsl:with-param name="DateClot2emeCols"
									                select="$dateClot1"/>
									<xsl:with-param name="DateClot3emeCols"
									                select="$dateClot3"/>
									<xsl:with-param name="TypeTableau"
									                select="$TypeTableau"/>
								</xsl:call-template>
							</xsl:when>
							<xsl:when test="($newDateClot1 &gt; $newDateClot3) and ($newDateClot2 &gt; $newDateClot1)">
								<xsl:call-template name="TableauVb3Cols">
									<xsl:with-param name="DateClot1erCols"
									                select="$dateClot3"/>
									<xsl:with-param name="DateClot2emeCols"
									                select="$dateClot1"/>
									<xsl:with-param name="DateClot3emeCols"
									                select="$dateClot2"/>
									<xsl:with-param name="DateDuree1erCols"
									                select="$dateDuree3"/>
									<xsl:with-param name="DateDuree2emeCols"
									                select="$dateDuree1"/>
									<xsl:with-param name="DateDuree3emeCols"
									                select="$dateDuree2"/>
								</xsl:call-template>
								<xsl:call-template name="RemplirTableauVb3">
									<xsl:with-param name="DateClot1erCols"
									                select="$dateClot3"/>
									<xsl:with-param name="DateClot2emeCols"
									                select="$dateClot1"/>
									<xsl:with-param name="DateClot3emeCols"
									                select="$dateClot2"/>
									<xsl:with-param name="TypeTableau"
									                select="$TypeTableau"/>
								</xsl:call-template>
							</xsl:when>
							<xsl:when test="($newDateClot1 &gt; $newDateClot2) and ($newDateClot2 &gt; $newDateClot3)">
								<xsl:call-template name="TableauVb3Cols">
									<xsl:with-param name="DateClot1erCols"
									                select="$dateClot3"/>
									<xsl:with-param name="DateClot2emeCols"
									                select="$dateClot2"/>
									<xsl:with-param name="DateClot3emeCols"
									                select="$dateClot1"/>
									<xsl:with-param name="DateDuree1erCols"
									                select="$dateDuree3"/>
									<xsl:with-param name="DateDuree2emeCols"
									                select="$dateDuree2"/>
									<xsl:with-param name="DateDuree3emeCols"
									                select="$dateDuree1"/>
								</xsl:call-template>
								<xsl:call-template name="RemplirTableauVb3">
									<xsl:with-param name="DateClot1erCols"
									                select="$dateClot3"/>
									<xsl:with-param name="DateClot2emeCols"
									                select="$dateClot2"/>
									<xsl:with-param name="DateClot3emeCols"
									                select="$dateClot1"/>
									<xsl:with-param name="TypeTableau"
									                select="$TypeTableau"/>
								</xsl:call-template>
							</xsl:when>
							<xsl:when test="($newDateClot1 &gt; $newDateClot3) and ($newDateClot3 &gt; $newDateClot2)">
								<xsl:call-template name="TableauVb3Cols">
									<xsl:with-param name="DateClot1erCols"
									                select="$dateClot2"/>
									<xsl:with-param name="DateClot2emeCols"
									                select="$dateClot3"/>
									<xsl:with-param name="DateClot3emeCols"
									                select="$dateClot1"/>
									<xsl:with-param name="DateDuree1erCols"
									                select="$dateDuree2"/>
									<xsl:with-param name="DateDuree2emeCols"
									                select="$dateDuree3"/>
									<xsl:with-param name="DateDuree3emeCols"
									                select="$dateDuree1"/>
								</xsl:call-template>
								<xsl:call-template name="RemplirTableauVb3">
									<xsl:with-param name="DateClot1erCols"
									                select="$dateClot2"/>
									<xsl:with-param name="DateClot2emeCols"
									                select="$dateClot3"/>
									<xsl:with-param name="DateClot3emeCols"
									                select="$dateClot1"/>
									<xsl:with-param name="TypeTableau"
									                select="$TypeTableau"/>
								</xsl:call-template>
							</xsl:when>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<!-- tableau à 2 colonnes-->
						<xsl:if test="$newDateClot1 &gt; $newDateClot2">
							<xsl:call-template name="TableauVb2Cols">
								<xsl:with-param name="DateClot1erCols"
								                select="$dateClot2"/>
								<xsl:with-param name="DateClot2emeCols"
								                select="$dateClot1"/>
								<xsl:with-param name="DateDuree1erCols"
								                select="$dateDuree2"/>
								<xsl:with-param name="DateDuree2emeCols"
								                select="$dateDuree1"/>
							</xsl:call-template>
							<xsl:call-template name="RemplirTableauVb2">
								<xsl:with-param name="DateClot1erCols"
								                select="$dateClot2"/>
								<xsl:with-param name="DateClot2emeCols"
								                select="$dateClot1"/>
								<xsl:with-param name="TypeTableau"
								                select="$TypeTableau"/>
							</xsl:call-template>
						</xsl:if>
						<xsl:if test="$newDateClot2 &gt; $newDateClot1">
							<xsl:call-template name="TableauVb2Cols">
								<xsl:with-param name="DateClot1erCols"
								                select="$dateClot1"/>
								<xsl:with-param name="DateClot2emeCols"
								                select="$dateClot2"/>
								<xsl:with-param name="DateDuree1erCols"
								                select="$dateDuree1"/>
								<xsl:with-param name="DateDuree2emeCols"
								                select="$dateDuree2"/>
							</xsl:call-template>
							<xsl:call-template name="RemplirTableauVb2">
								<xsl:with-param name="DateClot1erCols"
								                select="$dateClot1"/>
								<xsl:with-param name="DateClot2emeCols"
								                select="$dateClot2"/>
								<xsl:with-param name="TypeTableau"
								                select="$TypeTableau"/>
							</xsl:call-template>
						</xsl:if>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- ***************************** TEMPLATE GENVB ************************************ -->
	<xsl:template name="genVB">
		<div class="clBreakPage"/>
		<a name="VB"/>
		<table class="clBorderCell clWidth739">
			<caption class="visually-hidden">VITRINE BILANS</caption>
			<tr>
				<td class="clCouleurGras clWidth635 clAlignCenter">VITRINE BILANS</td>
				<td class="clWidth103 clAlignRight">
        </td>
			</tr>
			<tr>
				<td colspan="2">
					<img src="{$root}Images/risque/shim_bleu.gif"
					     width="635"
					     height="1"
					     vspace="8"
					     alt=""/>
				</td>
			</tr>
			<tr>
				<th class="clWidth635 clCouleur2 clAlignLeft clThNonGras"
				    colspan="2">&#160;Bilans disponibles dans les modules Fiben : </th>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="genVBtitre">
		<xsl:param name="titre"/>
		<table class="clWidth635 clBorderCell"
		       role="presentation">
			<tr>
				<td class="clCouleur2 clWidth285 clHeight10"/>
			</tr>
			<tr>
				<td class="clCouleur2 clWidth285 clHeight10"/>
			</tr>
		</table>
		<table class="clWidth635 clBorderCell"
		       role="presentation">
			<tr>
				<th class="clCouleur2 clWidth285 clHeight10 clAlignLeft clThNonGras">
					<xsl:value-of select="$titre"/>
				</th>
			</tr>
			<tr>
				<td class="clCouleur2 clWidth285 clHeight10"/>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="TableauVb1Col">
		<xsl:param name="DateClot1erCols"/>
		<xsl:param name="DateDuree1erCols"/>
		<table class="clWidth635 clBorderCell">
			<tr class="clWidthMax">
				<th class="clCouleur2 clWidth285 clAlignLeft clThNonGras">&#160;Date de clôture</th>
				<td class="clGrasFond clWidth350 clAlignCenter">
					<xsl:call-template name="displayDateXsl">
						<xsl:with-param name="InputDate"
						                select="$DateClot1erCols"/>
					</xsl:call-template>
				</td>
			</tr>
			<tr class="clWidthMax">
				<th class="clCouleur2 clWidth285 clAlignLeft clThNonGras">&#160;Durée d'exercice</th>
				<th class="clTexte clWidth350 clAlignCenter clThNonGras">
					<xsl:value-of select="$DateDuree1erCols"/>&#160;mois
        </th>
			</tr>
			<tr>
				<td class="clCouleur2 clHeight10"
				    colspan="9"/>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="TableauVb2Cols">
		<xsl:param name="DateClot1erCols"/>
		<xsl:param name="DateClot2emeCols"/>
		<xsl:param name="DateDuree1erCols"/>
		<xsl:param name="DateDuree2emeCols"/>
		<table class="clWidth635 clBorderCell">
			<tr class="clWidthMax">
				<th class="clCouleur2 clWidth285 clAlignLeft clThNonGras">&#160;Date de clôture</th>
				<td class="clGrasFond clWidth175 clAlignCenter">
					<xsl:call-template name="displayDateXsl">
						<xsl:with-param name="InputDate"
						                select="$DateClot1erCols"/>
					</xsl:call-template>
				</td>
				<td class="clGrasFond clWidth175 clAlignCenter">
					<xsl:call-template name="displayDateXsl">
						<xsl:with-param name="InputDate"
						                select="$DateClot2emeCols"/>
					</xsl:call-template>
				</td>
			</tr>
			<tr class="clWidthMax">
				<th class="clCouleur2 clWidth285 clAlignLeft clThNonGras">&#160;Durée d'exercice</th>
				<th class="clTexte clWidth175 clAlignCenter clThNonGras">
					<xsl:value-of select="$DateDuree1erCols"/>&#160;mois
        </th>
				<th class="clTexte clWidth175 clAlignCenter clThNonGras">
					<xsl:value-of select="$DateDuree2emeCols"/>&#160;mois
        </th>
			</tr>
			<tr>
				<td class="clCouleur2 clHeight10"
				    colspan="9"/>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="TableauVb3Cols">
		<xsl:param name="DateClot1erCols"/>
		<xsl:param name="DateClot2emeCols"/>
		<xsl:param name="DateClot3emeCols"/>
		<xsl:param name="DateDuree1erCols"/>
		<xsl:param name="DateDuree2emeCols"/>
		<xsl:param name="DateDuree3emeCols"/>
		<table class="clWidth635 clBorderCell"
		       role="presentation">
			<tr class="clWidthMax">
				<th class="clCouleur2 clWidth285 clAlignLeft clThNonGras">&#160;Date de clôture</th>
				<td class="clGrasFond clWidth116 clAlignCenter">
					<xsl:call-template name="displayDateXsl">
						<xsl:with-param name="InputDate"
						                select="$DateClot1erCols"/>
					</xsl:call-template>
				</td>
				<td class="clGrasFond clWidth116 clAlignCenter">
					<xsl:call-template name="displayDateXsl">
						<xsl:with-param name="InputDate"
						                select="$DateClot2emeCols"/>
					</xsl:call-template>
				</td>
				<td class="clGrasFond clWidth116 clAlignCenter">
					<xsl:call-template name="displayDateXsl">
						<xsl:with-param name="InputDate"
						                select="$DateClot3emeCols"/>
					</xsl:call-template>
				</td>
			</tr>
			<tr class="clWidthMax">
				<th class="clCouleur2 clWidth285 clAlignLeft clThNonGras">&#160;Durée d'exercice</th>
				<th class="clTexte clWidth116 clAlignCenter clThNonGras">
					<xsl:value-of select="$DateDuree1erCols"/>&#160;mois
        </th>
				<th class="clTexte clWidth116 clAlignCenter clThNonGras">
					<xsl:value-of select="$DateDuree2emeCols"/>&#160;mois
        </th>
				<th class="clTexte clWidth116 clAlignCenter clThNonGras">
					<xsl:value-of select="$DateDuree3emeCols"/>&#160;mois
        </th>
			</tr>
			<tr>
				<td class="clCouleur2 clHeight10"
				    colspan="9"/>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="RemplirTableauVb1">
		<xsl:param name="DateClot1erCols"/>
		<xsl:param name="TypeTableau"/>
		<xsl:for-each select="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFOVB">
			<xsl:if test="$TypeTableau = 'Social'">
				<xsl:if test="DONMODDO[../NUMMOD!=66 and ../NUMMOD!=67]">
					<table class="clWidth635 clBorderCell">
						<xsl:if test="position() mod 2 = 0">
							<tr class="clWidthMax">
								<th class="clCouleur2 clWidth285 clAlignLeft clThNonGras">
									<xsl:variable name="NumMod"
									              select="NUMMOD"/>
									<a href="#nullePart"
									   onclick="requestBDFInfos('{NUMMOD}','','9','',false,false,this);"
									   class="clCouleur2">
										<u>
											<xsl:value-of select="NUMMOD"/>
										</u>
									</a>
                  &#160;<xsl:value-of select="$dictionnaire/titre[@module=$NumMod]"/>
								</th>
								<td class="clTexte clWidth350 clAlignCenter">
									<xsl:variable name="datetest1"
									              select="DONMODDO/@DATCLOTV"/>
									<xsl:if test="$datetest1 = $DateClot1erCols">
                    X
                  </xsl:if>
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="position() mod 2 = 1">
							<tr class="clWidthMax">
								<th class="clCouleur2 clWidth285 clAlignLeft clThNonGras">
									<xsl:variable name="NumMod"
									              select="NUMMOD"/>
									<a href="#nullePart"
									   onclick="requestBDFInfos('{NUMMOD}','','9','',false,false,this);"
									   class="clCouleur2">
										<u>
											<xsl:value-of select="NUMMOD"/>
										</u>
									</a>
                  &#160;<xsl:value-of select="$dictionnaire/titre[@module=$NumMod]"/>
								</th>
								<td class="clFond clWidth350 clAlignCenter">
									<xsl:variable name="datetest1"
									              select="DONMODDO/@DATCLOTV"/>
									<xsl:if test="$datetest1 = $DateClot1erCols">
                    X
                  </xsl:if>
								</td>
							</tr>
						</xsl:if>
					</table>
				</xsl:if>
			</xsl:if>
			<xsl:if test="$TypeTableau = 'Conso'">
				<xsl:if test="DONMODDO[../NUMMOD=66 or ../NUMMOD=67]">
					<table class="clWidth635 clBorderCell">
						<xsl:if test="position() mod 2 = 0">
							<tr class="clWidthMax">
								<th class="clCouleur2 clWidth285 clAlignLeft clThNonGras">
									<xsl:variable name="NumMod"
									              select="NUMMOD"/>
									<a href="#nullePart"
									   onclick="requestBDFInfos('{NUMMOD}','','9','',false,false,this);"
									   class="clCouleur2">
										<u>
											<xsl:value-of select="NUMMOD"/>
										</u>
									</a>
                  &#160;<xsl:value-of select="$dictionnaire/titre[@module=$NumMod]"/>
								</th>
								<td class="clTexte clWidth350 clAlignCenter">
									<xsl:variable name="datetest1"
									              select="DONMODDO/@DATCLOTV"/>
									<xsl:if test="$datetest1 = $DateClot1erCols">
                    X
                  </xsl:if>
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="position() mod 2 = 1">
							<tr class="clWidthMax">
								<th class="clCouleur2 clWidth285 clAlignLeft clThNonGras">
									<xsl:variable name="NumMod"
									              select="NUMMOD"/>
									<a href="#nullePart"
									   onclick="requestBDFInfos('{NUMMOD}','','9','',false,false,this);"
									   class="clCouleur2">
										<u>
											<xsl:value-of select="NUMMOD"/>
										</u>
									</a>
                  &#160;<xsl:value-of select="$dictionnaire/titre[@module=$NumMod]"/>
								</th>
								<td class="clFond clWidth350 clAlignCenter">
									<xsl:variable name="datetest1"
									              select="DONMODDO/@DATCLOTV"/>
									<xsl:if test="$datetest1 = $DateClot1erCols">
                    X
                  </xsl:if>
								</td>
							</tr>
						</xsl:if>
					</table>
				</xsl:if>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="RemplirTableauVb2">
		<xsl:param name="DateClot1erCols"/>
		<xsl:param name="DateClot2emeCols"/>
		<xsl:param name="TypeTableau"/>
		<xsl:for-each select="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFOVB">
			<xsl:if test="$TypeTableau = 'Social'">
				<xsl:if test="DONMODDO[../NUMMOD!=66 and ../NUMMOD!=67]">
					<table class="clWidth635 clBorderCell"
					       role="presentation">
						<xsl:if test="position() mod 2 = 0">
							<tr class="clWidthMax">
								<th class="clCouleur2 clWidth285 clAlignLeft clThNonGras">
									<xsl:variable name="NumMod"
									              select="NUMMOD"/>
									<a href="#nullePart"
									   onclick="requestBDFInfos('{NUMMOD}','','9','',false,false,this);"
									   class="clCouleur2">
										<u>
											<xsl:value-of select="NUMMOD"/>
										</u>
									</a>
                  &#160;<xsl:value-of select="$dictionnaire/titre[@module=$NumMod]"/>
								</th>
								<td class="clTexte clWidth175 clAlignCenter">
									<xsl:variable name="datetest1"
									              select="DONMODDO/@DATCLOTV"/>
									<xsl:if test="$datetest1 = $DateClot1erCols">
                    X
                  </xsl:if>
								</td>
								<td class="clTexte clWidth175 clAlignCenter">
									<xsl:variable name="datetest2"
									              select="DONMODDO/@DATCLOTV"/>
									<xsl:if test="$datetest2 = $DateClot2emeCols">
                    X
                  </xsl:if>
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="position() mod 2 = 1">
							<tr class="clWidthMax">
								<th class="clCouleur2 clWidth285 clAlignLeft clThNonGras">
									<xsl:variable name="NumMod"
									              select="NUMMOD"/>
									<a href="#nullePart"
									   onclick="requestBDFInfos('{NUMMOD}','','9','',false,false,this);"
									   class="clCouleur2">
										<u>
											<xsl:value-of select="NUMMOD"/>
										</u>
									</a>
                  &#160;<xsl:value-of select="$dictionnaire/titre[@module=$NumMod]"/>
								</th>
								<td class="clFond clWidth175 clAlignCenter">
									<xsl:variable name="datetest1"
									              select="DONMODDO/@DATCLOTV"/>
									<xsl:if test="$datetest1 = $DateClot1erCols">
                    X
                  </xsl:if>
								</td>
								<td class="clFond clWidth175 clAlignCenter">
									<xsl:variable name="datetest2"
									              select="DONMODDO/@DATCLOTV"/>
									<xsl:if test="$datetest2 = $DateClot2emeCols">
                    X
                  </xsl:if>
								</td>
							</tr>
						</xsl:if>
					</table>
				</xsl:if>
			</xsl:if>
			<xsl:if test="$TypeTableau = 'Conso'">
				<xsl:if test="DONMODDO[../NUMMOD=66 or ../NUMMOD=67]">
					<table class="clWidth635 clBorderCell">
						<xsl:if test="position() mod 2 = 0">
							<tr class="clWidthMax">
								<th class="clCouleur2 clWidth285 clAlignLeft clThNonGras">
									<xsl:variable name="NumMod"
									              select="NUMMOD"/>
									<a href="#nullePart"
									   onclick="requestBDFInfos('{NUMMOD}','','9','',false,false,this);"
									   class="clCouleur2">
										<u>
											<xsl:value-of select="NUMMOD"/>
										</u>
									</a>
                  &#160;<xsl:value-of select="$dictionnaire/titre[@module=$NumMod]"/>
								</th>
								<td class="clTexte clWidth175 clAlignCenter">
									<xsl:variable name="datetest1"
									              select="DONMODDO/@DATCLOTV"/>
									<xsl:if test="$datetest1 = $DateClot1erCols">
                    X
                  </xsl:if>
								</td>
								<td class="clTexte clWidth175 clAlignCenter">
									<xsl:variable name="datetest2"
									              select="DONMODDO/@DATCLOTV"/>
									<xsl:if test="$datetest2 = $DateClot2emeCols">
                    X
                  </xsl:if>
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="position() mod 2 = 1">
							<tr class="clWidthMax">
								<th class="clCouleur2 clWidth285 clAlignLeft clThNonGras">
									<xsl:variable name="NumMod"
									              select="NUMMOD"/>
									<a href="#nullePart"
									   onclick="requestBDFInfos('{NUMMOD}','','9','',false,false,this);"
									   class="clCouleur2">
										<u>
											<xsl:value-of select="NUMMOD"/>
										</u>
									</a>
                  &#160;<xsl:value-of select="$dictionnaire/titre[@module=$NumMod]"/>
								</th>
								<td class="clFond clWidth175 clAlignCenter">
									<xsl:variable name="datetest1"
									              select="DONMODDO/@DATCLOTV"/>
									<xsl:if test="$datetest1 = $DateClot1erCols">
                    X
                  </xsl:if>
								</td>
								<td class="clFond clWidth175 clAlignCenter">
									<xsl:variable name="datetest2"
									              select="DONMODDO/@DATCLOTV"/>
									<xsl:if test="$datetest2 = $DateClot2emeCols">
                    X
                  </xsl:if>
								</td>
							</tr>
						</xsl:if>
					</table>
				</xsl:if>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="RemplirTableauVb3">
		<xsl:param name="DateClot1erCols"/>
		<xsl:param name="DateClot2emeCols"/>
		<xsl:param name="DateClot3emeCols"/>
		<xsl:param name="TypeTableau"/>
		<xsl:for-each select="/FIBEN/PERSONNE/MODULEDE/DIFFDE/INFOVB">
			<xsl:if test="$TypeTableau = 'Social'">
				<xsl:if test="DONMODDO[../NUMMOD!=66 and ../NUMMOD!=67]">
					<table class="clWidth635 clBorderCell">
						<xsl:if test="position() mod 2 = 0">
							<tr class="clWidthMax">
								<th class="clCouleur2 clWidth285 clAlignLeft clThNonGras">
									<xsl:variable name="NumMod"
									              select="NUMMOD"/>
									<a href="#nullePart"
									   onclick="requestBDFInfos('{NUMMOD}','','9','',false,false,this);"
									   class="clCouleur2">
										<u>
											<xsl:value-of select="NUMMOD"/>
										</u>
									</a>
                  &#160;<xsl:value-of select="$dictionnaire/titre[@module=$NumMod]"/>
								</th>
								<td class="clTexte clWidth116 clAlignCenter">
									<xsl:variable name="datetest1"
									              select="DONMODDO/@DATCLOTV"/>
									<xsl:if test="$datetest1 = $DateClot1erCols">
                    X
                  </xsl:if>
								</td>
								<td class="clTexte clWidth116 clAlignCenter">
									<xsl:variable name="datetest2"
									              select="DONMODDO/@DATCLOTV"/>
									<xsl:if test="$datetest2 = $DateClot2emeCols">
                    X
                  </xsl:if>
								</td>
								<td class="clTexte clWidth116 clAlignCenter">
									<xsl:variable name="datetest3"
									              select="DONMODDO/@DATCLOTV"/>
									<xsl:if test="$datetest3 = $DateClot3emeCols">
                    X
                  </xsl:if>
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="position() mod 2 = 1">
							<tr class="clWidthMax">
								<th class="clCouleur2 clWidth285 clAlignLeft clThNonGras">
									<xsl:variable name="NumMod"
									              select="NUMMOD"/>
									<a href="#nullePart"
									   onclick="requestBDFInfos('{NUMMOD}','','9','',false,false,this);"
									   class="clCouleur2">
										<u>
											<xsl:value-of select="NUMMOD"/>
										</u>
									</a>
                  &#160;<xsl:value-of select="$dictionnaire/titre[@module=$NumMod]"/>
								</th>
								<td class="clFond clWidth116 clAlignCenter">
									<xsl:variable name="datetest1"
									              select="DONMODDO/@DATCLOTV"/>
									<xsl:if test="$datetest1 = $DateClot1erCols">
                    X
                  </xsl:if>
								</td>
								<td class="clFond clWidth116 clAlignCenter">
									<xsl:variable name="datetest2"
									              select="DONMODDO/@DATCLOTV"/>
									<xsl:if test="$datetest2 = $DateClot2emeCols">
                    X
                  </xsl:if>
								</td>
								<td class="clFond clWidth116 clAlignCenter">
									<xsl:variable name="datetest3"
									              select="DONMODDO/@DATCLOTV"/>
									<xsl:if test="$datetest3 = $DateClot3emeCols">
                    X
                  </xsl:if>
								</td>
							</tr>
						</xsl:if>
					</table>
				</xsl:if>
			</xsl:if>
			<xsl:if test="$TypeTableau = 'Conso'">
				<xsl:if test="DONMODDO[../NUMMOD=66 or ../NUMMOD=67]">
					<table class="clWidth635 clBorderCell">
						<xsl:if test="position() mod 2 = 0">
							<tr class="clWidthMax">
								<th class="clCouleur2 clWidth285 clAlignLeft clThNonGras">
									<xsl:variable name="NumMod"
									              select="NUMMOD"/>
									<a href="#nullePart"
									   onclick="requestBDFInfos('{NUMMOD}','','9','',false,false,this);"
									   class="clCouleur2">
										<u>
											<xsl:value-of select="NUMMOD"/>
										</u>
									</a>
                  &#160;<xsl:value-of select="$dictionnaire/titre[@module=$NumMod]"/>
								</th>
								<td class="clTexte clWidth116 clAlignCenter">
									<xsl:variable name="datetest1"
									              select="DONMODDO/@DATCLOTV"/>
									<xsl:if test="$datetest1 = $DateClot1erCols">
                    X
                  </xsl:if>
								</td>
								<td class="clTexte clWidth116 clAlignCenter">
									<xsl:variable name="datetest2"
									              select="DONMODDO/@DATCLOTV"/>
									<xsl:if test="$datetest2 = $DateClot2emeCols">
                    X
                  </xsl:if>
								</td>
								<td class="clTexte clWidth116 clAlignCenter">
									<xsl:variable name="datetest3"
									              select="DONMODDO/@DATCLOTV"/>
									<xsl:if test="$datetest3 = $DateClot3emeCols">
                    X
                  </xsl:if>
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="position() mod 2 = 1">
							<tr class="clWidthMax">
								<th class="clCouleur2 clWidth285 clAlignLeft clThNonGras">
									<xsl:variable name="NumMod"
									              select="NUMMOD"/>
									<a href="#nullePart"
									   onclick="requestBDFInfos('{NUMMOD}','','9','',false,false,this);"
									   class="clCouleur2">
										<u>
											<xsl:value-of select="NUMMOD"/>
										</u>
									</a>
                  &#160;<xsl:value-of select="$dictionnaire/titre[@module=$NumMod]"/>
								</th>
								<td class="clFond clWidth116 clAlignCenter">
									<xsl:variable name="datetest1"
									              select="DONMODDO/@DATCLOTV"/>
									<xsl:if test="$datetest1 = $DateClot1erCols">
                    X
                  </xsl:if>
								</td>
								<td class="clFond clWidth116 clAlignCenter">
									<xsl:variable name="datetest2"
									              select="DONMODDO/@DATCLOTV"/>
									<xsl:if test="$datetest2 = $DateClot2emeCols">
                    X
                  </xsl:if>
								</td>
								<td class="clFond clWidth116 clAlignCenter">
									<xsl:variable name="datetest3"
									              select="DONMODDO/@DATCLOTV"/>
									<xsl:if test="$datetest3 = $DateClot3emeCols">
                    X
                  </xsl:if>
								</td>
							</tr>
						</xsl:if>
					</table>
				</xsl:if>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	<xsl:template match="IST17"
	              mode="genLib">
		<table class="clWidth635 clBorderCell"
		       role="presentation">
			<tr class="clAlignLeft">
				<td class="clCouleur2">
					<xsl:apply-templates select="."/>
					<br/>
				</td>
			</tr>
		</table>
		<xsl:call-template name="shim"/>
	</xsl:template>
	<!--********************************************************************************************************************************************************************-->
	<!--TEMPLATE 5eme PAVE : SOCIETE CONSOLIDANTE-->
	<xsl:template match="DIFFDE/EJ">
		<a name="SteConso"/>
		<xsl:if test="position()=last()">
			<table class="clBorderCell clWidth739"
			       role="presentation">
				<tr class="clAlignCenter">
					<td class="clCouleurGras">
						<xsl:call-template name="tradlib">
							<xsl:with-param name="Lang"
							                select="$Lang"/>
							<xsl:with-param name="codeLib"
							                select="'m27_SoCoEn'"/>
						</xsl:call-template>
					</td>
					<td class="clWidth103 clAlignRight">
						<a href="#ancHaut">
							<img src="{$root}Images/risque/fleche_haut.gif"
							     width="18"
							     height="18"
							     border="0"
							     name="Image112"
							     alt="Retour en haut de la page"/>
						</a>
					</td>
				</tr>
			</table>
			<xsl:call-template name="shim"/>
			<br/>
			<table class="clWidth635 clBorderCell">
				<caption class="visually-hidden">SOCIÉTÉ(S) CONSOLIDANT L'ENTREPRISE</caption>
				<xsl:for-each select="../EJ">
					<tr>
						<td class="clFond clWidth130">
              &#160;<xsl:call-template name="displaySirenXsl">
								<xsl:with-param name="InputSiren"
								                select="(IDENTS)"/>
							</xsl:call-template>
						</td>
						<td class="clFond clWidth425">
              &#160;<xsl:value-of select="DENOM"/>
						</td>
						<td class="clFond clWidth80 clAlignRight">
              &#160;	<xsl:call-template name="tradlib">
								<xsl:with-param name="Lang"
								                select="$Lang"/>
								<xsl:with-param name="codeLib"
								                select="'m27_Au'"/>
							</xsl:call-template>&#160;
              <xsl:call-template name="displayDateXsl">
								<xsl:with-param name="InputDate"
								                select="(@DATPERI)"/>
							</xsl:call-template>
						</td>
					</tr>
					<xsl:if test="not($NonResident='NR')">
						<tr>
							<td class="clWidth635 clAlignRight"
							    colspan="3">
								<a href="#nullepart"
								   onClick="requestBDFInfos('27|30|66|67|','','1','{IDENTS}',cstMultipleConfirm);">
									<img border="0"
									     height="12"
									     src="{$root}images/Commun/clignotant2.gif"
									     width="90"
									     alt="plus d'infos"/>
								</a>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="$NonResident='NR'">
						<tr>
							<td class="clWidth635 clAlignRight"
							    colspan="3">&#160;</td>
						</tr>
					</xsl:if>
				</xsl:for-each>
			</table>
			<xsl:call-template name="shim"/>
		</xsl:if>
	</xsl:template>
	<!--********************************************************************************************************************************************************************-->
	<xsl:template match="STECONSO"
	              mode="genLib">
		<table class="clWidth635 clBorderCell"
		       role="presentation">
			<tr>
				<td class="clCouleur2"
				    colspan="2">
          &#160;<xsl:apply-templates select="."/>
				</td>
			</tr>
			<tr>
				<td class="clWidth130"/>
				<td class="clWidth505 clAlignRight">
					<a href="#nullepart"
					   onClick="requestBDFInfos('27|30|66|67|','','1','{/FIBEN/PERSONNE/MODULE60/EJ/IDENTS}',cstMultipleConfirm);">
						<img src="{$root}Images/Commun/clignotant2.gif"
						     width="90"
						     height="12"
						     alt="Plus d'infos"
						     border="0"/>
					</a>
				</td>
			</tr>
		</table>
		<xsl:call-template name="shim"/>
	</xsl:template>
	<xsl:template match="BIL01S[@ISCODE='1']">
		<xsl:call-template name="shim"/>
		<br/>
		<table class="clWidth635 clHeight125 clBorderCell"
		       role="presentation">
			<tr>
				<td>
					<xsl:call-template name="traduction">
						<xsl:with-param name="code"
						                select="'BIL01S'"/>
					</xsl:call-template>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template match="BIL01C[@ISCODE='1']">
		<xsl:call-template name="shim"/>
		<br/>
		<table class="clWidth635 clHeight125 clBorderCell"
		       role="presentation">
			<tr>
				<td>
					<xsl:call-template name="traduction">
						<xsl:with-param name="code"
						                select="'BIL01C'"/>
					</xsl:call-template>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="FONCDIR">
		<table class="clWidth635 clBorderCell clCouleur2"
		       role="presentation">
			<tr>
				<td class="clAlignLeft clWidth522">
          Présence d&#039;autre(s) fonction(s) de représentant(s) légal(aux) exercée(s)
        </td>
				<td class="clWidth103 clAlignRight">
					<a href="#nullepart"
					   onclick="requestBDFInfos('56','','','',cstSimpleConfirm);">
						<img border="0"
						     height="12"
						     src="{$root}images/Commun/clignotant2.gif"
						     width="90"
						     alt="plus d'infos"/>
					</a>
				</td>
			</tr>
		</table>
		<xsl:call-template name="shim"/>
		<br/>
	</xsl:template>
	<!-- 01/2004 template supprimé : plus besoin d'afficher la succursale dans IEC01 -->
	<xsl:template match="IEC01"
	              mode="DisplayMDE">
		<br/>
		<xsl:apply-templates select="."/>
	</xsl:template>
</xsl:stylesheet>
