﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"  xmlns:bdf="http://banque-france.fr/namespace">
  <xsl:import href="../../Ressources/XSL/Commun.xsl"/>
  <xsl:import href="../../Ressources/XSL/Commun_SAS.xsl"/>
  <xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes"/>
  <xsl:param name="langage" select="'fr'"/>
  <xsl:param name="familyNumber" select="''"/>
  <xsl:param name="root" select="'/Fiben/'"/>
  <xsl:param name="familyName" select="''"/>
  <xsl:param name="familyTitle" select="''"/>
  <xsl:param name="nextModule" select="''"/>
  <xsl:param name="nextId" select="''"/>
  <xsl:param name="nextFamily" select="''"/>
  <xsl:param name="menuHTML1"/>
  <xsl:param name="Lang" select="'FR'"/>
  <xsl:param name="NonResident" select="''"/>



  <!--TEMPLATE PRINCIPAL-->
  <xsl:template match="/">
    <html lang="fr" xmlns="http://www.w3.org/1999/xhtml">
      <title>Module A6 - Compte-rendu de suppression d'identifiant(s)</title>
      <xsl:call-template name="genHeadSAS">
      </xsl:call-template>
      <body class="clBodybgcolorWhite">
        <xsl:call-template name="genFondMenu">
          <xsl:with-param name="root" select="$root"/>
          <xsl:with-param name="type" select="'suivi'" />        
        </xsl:call-template>
        <!-- Affichage des menus: -->
        <xsl:copy-of select="$menuHTML1"/>
        
        <xsl:if test="/FIBEN/ERREUR">
        <xsl:call-template name="GestionErreurSAS" >
          <xsl:with-param name="root" select="$root"/>
          <xsl:with-param name="familyTitle" select="$familyTitle" />
        </xsl:call-template>
        </xsl:if>
        <xsl:if test="not(/FIBEN/ERREUR)">
          <table class="mainmodule horizontal-auto HomeData clBorderCell">
            <caption class="visually-hidden">Module A6 - Compte-rendu de suppression d'identifiant(s)</caption>
            <tr>
             <td class="clWidth20"></td>
              <td class="clWidth636" colspan="2">
                <form  method="get" name="frmForm1">
                  <input type="hidden" name="ident" value=""/>
                  <table class="clWidthMax clBorderCell" role="presentation">
                    <tr>        
                      <td>
                        <!-- Affichage du bandeau inférieur: -->
                        <xsl:call-template name="BandeauInf" >
                          <xsl:with-param name="Titre" select="$dictionnaire/titre[@module=$moddem]"/>
                          <xsl:with-param name="root" select="$root"/>
                        </xsl:call-template>

                        <table class="clBorderCell clWidthMax" role="presentation">
                          <tr>
                            <td> &#160;</td>
                          </tr>
                          <tr>
                            <td class="clGras">
                              <span class="clTexte clValignTop">Adresse mail concernée :  </span>
                              <xsl:value-of select="FIBEN/SERVICESAS/*/BAL"/>
                            </td>
                          </tr>
                          <xsl:if test="FIBEN/SERVICESAS/*/ALERTSUP">
                            <tr>
                              <td> &#160;</td>
                            </tr>
                            <tr>
                              <td class="clGras clTexte clValignTop">
                               Résultat du traitement: 
                                &#160;
                                <xsl:number value="FIBEN/SERVICESAS/*/ALERTSUP"></xsl:number>
                                &#160;  identifiant(s) supprimé(s) avec succès.
                              </td>
                            </tr>
                          </xsl:if>
                          <xsl:if test="FIBEN/SERVICESAS/*/SUCCES">
                            <tr>
                              <td> &#160;</td>
                            </tr>
                            <tr>
                              <td>
                                <span class="clTexte clValignTop">Suppression(s) prise(s) en compte :</span>
                              </td>
                            </tr>
                            <xsl:for-each select="FIBEN/SERVICESAS/*/SUCCES/SUCCE/IDENTOK">
                              <tr>
                                <td class="clGras">
                                  <xsl:value-of select="."/>
                                </td>
                                <xsl:if test="position() mod 30 = 0">
                                   <td class="clAlignRight">
                                    <a href="#ancHaut">
                                      <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page" />
                                    </a>
                                  </td>
                                </xsl:if>
                                <xsl:if test="position() mod 30 != 0">
                                   <td class="clAlignRight">
                                    &#160;
                                  </td>
                                </xsl:if>
                              </tr>
                            </xsl:for-each>
                          </xsl:if >
                          <xsl:if test="FIBEN/SERVICESAS/*/ECHECS">
                            <tr>
                              <td> &#160;</td>
                            </tr>
                            <tr>
                              <td>
                                <span  class="clTitre6 clValignTop">Suppression(s) non traitée(s) :</span>
                              </td>
                            </tr>
                            <table class="clWidthMax">
                              <xsl:for-each select="FIBEN/SERVICESAS/*/ECHECS/ECHEC">
                                <tr >
                                  <td class="clGras clValignTop clWidth20">
                                    <xsl:value-of select="IDENTKO"/>
                                  </td>
                                  <td class="clGras clWidth380">
                                    :
                                    <xsl:call-template name="traduction">
                                      <xsl:with-param name="code" select="MOTIF" />
                                    </xsl:call-template>
                                  </td>
                                  <xsl:if test="position() mod 30 = 0">
                                     <td class="clAlignRight">
                                      <a href="#ancHaut">
                                        <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page" />
                                      </a>
                                    </td>
                                  </xsl:if>
                                  <xsl:if test="position() mod 30 != 0">
                                     <td class="clAlignRight">
                                      &#160;
                                    </td>
                                  </xsl:if>
                                </tr>
                              </xsl:for-each>
                            </table>
                          </xsl:if >
                        </table>
                      </td>
                    </tr> 
                  </table>
                </form>
              </td>
            </tr>
          </table>
        </xsl:if>

        <xsl:call-template name="genBasPage"/>

      </body>
    </html>

  </xsl:template>

  <!--********************************************************************************************************************************************************************-->

</xsl:stylesheet>
