﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"  xmlns:bdf="http://banque-france.fr/namespace">
  <xsl:import href="../../Ressources/XSL/Commun.xsl"/>
  <xsl:import href="../../Ressources/XSL/Commun_SAS.xsl"/>
  <xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes"/>
  <xsl:param name="langage" select="'fr'"/>
  <xsl:param name="familyNumber" select="''"/>
  <xsl:param name="root" select="'/Fiben/'"/>
  <xsl:param name="familyName" select="''"/>
  <xsl:param name="familyTitle" select="''"/>
  <xsl:param name="nextModule" select="''"/>
  <xsl:param name="nextId" select="''"/>
  <xsl:param name="nextFamily" select="''"/>
  <xsl:param name="menuHTML1"/>
  <xsl:param name="Lang" select="'FR'"/>
  <xsl:param name="NonResident" select="''"/>



  <!--TEMPLATE PRINCIPAL-->
  <xsl:template match="/">
    <html lang="fr" xmlns="http://www.w3.org/1999/xhtml">
      <title>Module A5 - Compte-rendu de suppression d'adresse(s) mail</title>
      <xsl:call-template name="genHeadSAS">
      </xsl:call-template>
      <body class="clBodybgcolorWhite">
        <xsl:call-template name="genFondMenu">
          <xsl:with-param name="root" select="$root"/>
          <xsl:with-param name="type" select="'suivi'" />
        </xsl:call-template>
        <!-- Affichage des menus: -->
        <xsl:copy-of select="$menuHTML1"/>
        
        <xsl:if test="/FIBEN/ERREUR">
          <xsl:call-template name="GestionErreurSAS" >
            <xsl:with-param name="root" select="$root"/>
            <xsl:with-param name="familyTitle" select="$familyTitle" />
          </xsl:call-template>
        </xsl:if>
        <table class="mainmodule horizontal-auto HomeData clBorderCell">
          <caption class="visually-hidden">Module A5 - Compte-rendu de suppression d'adresse(s) mail</caption>
          <xsl:if test="not(/FIBEN/ERREUR)">
            <tr>
             <td class="clWidth20"></td>
              <td class="clWidth636" colspan="2">
                <form  method="get" name="frmForm1">
                  <input type="hidden" name="ident" value=""/>
                  <table class="clWidthMax clBorderCell" role="presentation">
                    <tr>
                      <td>
                        <!-- Affichage du bandeau inférieur: -->
                        <xsl:call-template name="BandeauInf" >
                          <xsl:with-param name="Titre" select="$dictionnaire/titre[@module=$moddem]"/>
                          <xsl:with-param name="root" select="$root"/>
                        </xsl:call-template>

                        <table class="clBorderCell clWidthMax" role="presentation">
                          <tr>
                            <td> &#160;</td>
                          </tr>
                          <tr>
                            <td class="clGras">
                              <span  class="clTexte clValignTop">Adresse mail concernée :  </span>
                              <xsl:value-of select="FIBEN/SERVICESAS/*/BAL"/>
                            </td>
                          </tr>
                          <tr>
                            <td> &#160;</td>
                          </tr>
                          <tr>
                            <td class="clGras">
                              <span  class="clTexte clValignTop">Résultat du traitement:  </span>
                              <xsl:if test="not(FIBEN/SERVICESAS/*/CODERET)">
                                &#160; Suppression d&#146;adresse mail réussie.
                              </xsl:if>

                              <xsl:if test="FIBEN/SERVICESAS/*/CODERET">
                                &#160;
                                <xsl:call-template name="traduction">
                                  <xsl:with-param name="code" select="FIBEN/SERVICESAS/*/CODERET" />
                                </xsl:call-template>
                              </xsl:if>
                            </td>
                          </tr>
                        </table>
                      </td>
                    </tr>
                  </table>
                </form>
              </td>
            </tr>
          </xsl:if>
          
        </table>
        <xsl:call-template name="genBasPage"/>
      </body>
    </html>

  </xsl:template>

  <!--********************************************************************************************************************************************************************-->


</xsl:stylesheet>
