﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"  xmlns:bdf="http://banque-france.fr/namespace">
  <xsl:import href="../../Ressources/XSL/Commun.xsl"/>
  <xsl:import href="../../Ressources/XSL/Commun_SAS.xsl"/>
  <xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes"/>
  <xsl:param name="langage" select="'fr'"/>
  <xsl:param name="familyNumber" select="''"/>
  <xsl:param name="root" select="'/Fiben/'"/>
  <xsl:param name="familyName" select="''"/>
  <xsl:param name="familyTitle" select="''"/>
  <xsl:param name="nextModule" select="''"/>
  <xsl:param name="nextId" select="''"/>
  <xsl:param name="nextFamily" select="''"/>
  <xsl:param name="menuHTML1"/>
  <xsl:param name="Lang" select="'FR'"/>
  <xsl:param name="NonResident" select="''"/>


  <!--TEMPLATE PRINCIPAL-->
  <xsl:template match="/">
    <html lang="fr" xmlns="http://www.w3.org/1999/xhtml">
      <title>Module A3 - Gestion des Alertes</title>
      <xsl:call-template name="genHeadSAS">
      </xsl:call-template>
      <body class="clBodybgcolorWhite" onload="Tst_lst_MailSAS_GA();" >
        <xsl:call-template name="genFondMenu">
          <xsl:with-param name="root" select="$root"/>
          <xsl:with-param name="type" select="'suivi'" />
        </xsl:call-template>
        <!-- Affichage des menus: -->
        <xsl:copy-of select="$menuHTML1"/>
        
        <xsl:if test="/FIBEN/ERREUR">
          <xsl:call-template name="GestionErreurSAS" >
            <xsl:with-param name="root" select="$root"/>
            <xsl:with-param name="familyTitle" select="$familyTitle" />
          </xsl:call-template>
        </xsl:if >
        <table class="mainmodule horizontal-auto HomeData clBorderCell">
          <caption class="visually-hidden">Module A3 - Gestion des Alertes</caption>
          <xsl:if test="not(/FIBEN/ERREUR)">
            <tr>
               <td class="clWidth20"></td>
                <td class="clWidth636" colspan="2">
                <form method="Post" name="frmForm1">
                  <input type="hidden" name="ident" value=""/>
                  <table class="clBorderCell" role="presentation">
                    <tr>
                      <td class="clWidth50"> &#160;&#160;&#160; </td>
                      <td>
                        <!-- Affichage du bandeau inférieur: -->
                        <xsl:call-template name="BandeauInf" >
                          <xsl:with-param name="Titre" select="$dictionnaire/titre[@module=$moddem]"/>
                          <xsl:with-param name="root" select="$root"/>
                        </xsl:call-template>
                        &#160;
                        <div  id="bloc1" style="visibility:visible">
                          <!-- des champs cachés pour la gestion de l'affichage   -->
                          <input type="hidden" name="AdrMailselectionnee" value="{FIBEN/SERVICESAS/MODULEA3/ALERTES/@EMAIL}"></input>
                          <!-- Fin des champs cachés pour la gestion de l'affichage -->
                          <div class="clWidthMax clTexte clBorder0">
                            <span >Adresses mail déclarées: &#160;</span>
                            <select id="lst_AdrMail"  size="1" class="clChamp clLstMail" onchange="MAJ_lst_AlertesSAS_GA();">
                              <option value="0">Toutes les adresses mail</option>
                              <!-- Récupération des adresses mails: -->
                              <xsl:call-template name="RecupBALS" />
                            </select>
                          </div>
                          <br/>
                          <img src="{$root}images/risque/shim_bleu.gif" width="768" height="1" alt=""/>
                          <br/>
                     
                          <table class="clWidthMax">
                            <tr>
                             <td class="clTexteGras clAlignLeft">
                                <span >Liste des alertes:</span>
                              </td>
                              <td class="clTexte clAlignRight" style="visibility:hidden" id="blc_Toutselectionner">
                                <span >Tout sélectionner:</span>
                                <input id="Toutselectionner" type="checkbox"  onclick="ChangeSelectionSAS_GA()"/>
                              </td>
                            </tr>
                          </table>
                          <br/>
                          
                          <div  id="Lst_Alertes" class="clLst_Alertes"  >
                            <!-- ajout de l'ensemble des champs avec les identifiants-->
                            <xsl:call-template name="PlaceChampsIdentifiantGA" />
                          </div>
                          
                          <br/>
                          <img src="{$root}images/risque/shim_bleu.gif" width="768" height="1" alt=""/>
                          <br/>
                          <table>
                            <tr>
                              <td class="clTexteGras" >
                                <span >Adresse de transfert : </span>
                              </td>
                            </tr>
                          </table>
                          <br/>
                          <div class="clTexte clWidthMax">
                            <span >Sélectionnez une adresse mail déclarée: &#160;</span>
                            <select id ="Lst_Mail_Transfert" name ="Lst_Mail_Transfert" size="1" class="clChamp clLstMail" onchange="ChoixMailSAS_GA(false)"  >
                              <option value="0">...</option>
                              <script language="JavaScript">
                                var oOpt = new Option('...' + strFillIn(71) + '.','0',true,true);
                                var oSelect=document.getElementById("Lst_Mail_Transfert");
                                oSelect.options[0]=oOpt;
                              </script>
                            </select>
                          </div>
                          <br/>
                          <div class="clTexte clWidthMax">
                            <span  > OU saisissez une nouvelle adresse mail: &#160;</span>
                            <input type="text" name="txt_newemail" value="" maxlength="75" class="clLstMail clChamp"  onmouseover="AdrMailTransfertEvent_GA()" onkeyup="ChoixMailSAS_GA(true)"  readonly="True"  />
                          </div>
                          <br/>
                          <img src="{$root}images/risque/shim_bleu.gif" width="768" height="1" alt=""/>
                        </div>
                        <div id="bloc2" style="visibility:hidden;position:absolute;top:250px">
                          <table>
                            <tr>
                              <td class="clTexte">
                                Aucune alerte n&#039;est enregistrée pour ce code Banque et code Guichet.
                              </td>
                            </tr>
                          </table>
                        </div>
                      </td>
                    </tr>
                  </table>
                </form>
              </td>
            </tr>
          </xsl:if>
          
        </table>
        <xsl:call-template name="genBasPage"/>
      </body>
    </html>

  </xsl:template>

  <!--********************************************************************************************************************************************************************-->

  <xsl:template name="PlaceChampsIdentifiantGA">
    <xsl:variable name="nombreIdentifiantParLigne" select="5" />
    <xsl:for-each select="FIBEN/SERVICESAS/MODULEA3/ALERTES/ALERTE">
      <!-- ajout de deux espaces, une texbox et d'une checkbox-->
      &#160;
      <input type="text" readonly="true" name="Identifiant{position()}" size="15" value="{.}" maxlength="13" class="clTbxSirenAlertes"/>
      <input id="IdSelection{position()}" type="checkbox" style="visibility:hidden" onclick="GestionCaseACocherSAS_GA()"  />

      <!-- tout les n identifiant on saut deux lignes -->
      <xsl:if test="(position() mod  $nombreIdentifiantParLigne) = 0">
        <br/>
        <br/>
      </xsl:if>
    </xsl:for-each>
  </xsl:template>

</xsl:stylesheet>
