﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"  xmlns:bdf="http://banque-france.fr/namespace">
  <xsl:import href="../../Ressources/XSL/Commun.xsl"/>
  <xsl:import href="../../Ressources/XSL/Commun_SAS.xsl"/>
  <xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes"/>
  <xsl:param name="langage" select="'fr'"/>
  <xsl:param name="familyNumber" select="''"/>
  <xsl:param name="root" select="'/Fiben/'"/>
  <xsl:param name="familyName" select="''"/>
  <xsl:param name="familyTitle" select="''"/>
  <xsl:param name="nextModule" select="''"/>
  <xsl:param name="nextId" select="''"/>
  <xsl:param name="nextFamily" select="''"/>
  <xsl:param name="menuHTML1"/>
  <xsl:param name="Lang" select="'FR'"/>
  <xsl:param name="NonResident" select="''"/>



  <!--TEMPLATE PRINCIPAL-->
  <xsl:template match="/">
    <html lang="fr" xmlns="http://www.w3.org/1999/xhtml">
      <title>Module A2 - Compte-rendu des mises sous Alerte</title>
      <xsl:call-template name="genHeadSAS">
      </xsl:call-template>
      <body class="clBodybgcolorWhite">
        <xsl:call-template name="genFondMenu">
          <xsl:with-param name="root" select="$root"/>
          <xsl:with-param name="type" select="'suivi'" />
        </xsl:call-template>
        <!-- Affichage des menus: -->
        <xsl:copy-of select="$menuHTML1"/>
        
        <xsl:if test="/FIBEN/ERREUR">
          <xsl:call-template name="GestionErreurSAS" >
            <xsl:with-param name="root" select="$root"/>
            <xsl:with-param name="familyTitle" select="$familyTitle" />
          </xsl:call-template>
        </xsl:if >
        <xsl:if test="not(/FIBEN/ERREUR)">
          <table class="mainmodule horizontal-auto HomeData clBorderCell clWidth739">
            <caption class="visually-hidden">Module A2 - Compte-rendu des mises sous Alerte</caption>
            <tr>
             <td class="clWidth20"></td>
              <td class="clWidth636" colspan="2">
                <form  method="get" name="frmForm1">
                  <input type="hidden" name="ident" value=""/>
                  <table class="clWidthMax clBorderCell" role="presentation">
                    <tr>
                      <td class="clWidth50"> &#160;&#160;&#160; </td>
                      <td>
                        <!-- Affichage du bandeau inférieur: -->
                        <xsl:call-template name="BandeauInf" >
                          <xsl:with-param name="Titre" select="$dictionnaire/titre[@module=$moddem]"/>
                          <xsl:with-param name="root" select="$root"/>
                        </xsl:call-template>

                        <table class="clWidth739 clBorderCell" role="presentation">
                          <tr>
                            <td> &#160;</td>
                          </tr>
                          <tr>
                            <td class="clGras clTexte clValignTop">
                             Adresse mail concernée :  
                              <xsl:value-of select="FIBEN/SERVICESAS/*/BAL"/>
                            </td>
                          </tr>
                          <xsl:if test="FIBEN/SERVICESAS/*/SUCCES">
                            <tr>
                              <td> &#160;</td>
                            </tr>
                            <tr>
                              <td class="clTexte clValignTop">
                                Enregistrement(s) pris en compte :
                              </td>
                            </tr>
                            <xsl:for-each select="FIBEN/SERVICESAS/*/SUCCES/SUCCE/IDENTOK">
                              <tr>
                                <td class="clGras">
                                  <xsl:value-of select="."/>
                                </td>
                              </tr>
                            </xsl:for-each>
                          </xsl:if >
                          <xsl:if test="FIBEN/SERVICESAS/*/ECHECS">
                            <tr>
                              <td> &#160;</td>
                            </tr>
                            <tr>
                              <td class="clTexte clValignTop">
                                Enregistrement(s) non traité(s) :
                              </td>
                            </tr>
                            <table>
                              <xsl:for-each select="FIBEN/SERVICESAS/*/ECHECS/ECHEC">
                                <xsl:variable name ="identKo" select ="IDENTKO"></xsl:variable>
                                <xsl:choose>
                                  <xsl:when test="string-length($identKo) > 12">
                                    <tr class="clWidth400">
                                      <td class="clGras clValignTop clWidth100">
                                        <xsl:value-of select="IDENTKO"/>
                                      </td>
                                      <td class="clGras clWidth300">
                                        :
                                        <xsl:call-template name="traduction">
                                          <xsl:with-param name="code" select="MOTIF" />
                                        </xsl:call-template>
                                      </td>
                                    </tr>
                                  </xsl:when> 
                                  <xsl:otherwise>
                                    <xsl:choose>
                                      <xsl:when test ="string-length($identKo) > 11">
                                        <tr class="clWidth400">
                                          <td class="clGras clValignTop clWidth90">
                                            <xsl:value-of select="IDENTKO"/>
                                          </td>
                                          <td class="clGras clWidth310">
                                            :
                                            <xsl:call-template name="traduction">
                                              <xsl:with-param name="code" select="MOTIF" />
                                            </xsl:call-template>
                                          </td>
                                        </tr>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:choose>
                                          <xsl:when test ="string-length($identKo) > 10">
                                            <tr class="clWidth400">
                                              <td class="clGras clValignTop clWidth75">
                                                <xsl:value-of select="IDENTKO"/>
                                              </td>
                                              <td class="clGras clWidth325">
                                                :
                                                <xsl:call-template name="traduction">
                                                  <xsl:with-param name="code" select="MOTIF" />
                                                </xsl:call-template>
                                              </td>
                                            </tr>
                                          </xsl:when>
                                          <xsl:otherwise>
                                            <xsl:choose>
                                              <xsl:when test ="string-length($identKo) > 9">
                                                <tr class="clWidth400">
                                                  <td class="clGras clValignTop clWidth60">
                                                    <xsl:value-of select="IDENTKO"/>
                                                  </td>
                                                  <td class="clGras clWidth340">
                                                    :
                                                    <xsl:call-template name="traduction">
                                                      <xsl:with-param name="code" select="MOTIF" />
                                                    </xsl:call-template>
                                                  </td>
                                                </tr>
                                              </xsl:when>
                                              <xsl:otherwise>
                                                <tr class="clWidth400">
                                                  <td class="clGras clValignTop clWidth50">
                                                    <xsl:value-of select="IDENTKO"/>
                                                  </td>
                                                  <td class="clGras clWidth350">
                                                    :
                                                    <xsl:call-template name="traduction">
                                                      <xsl:with-param name="code" select="MOTIF" />
                                                    </xsl:call-template>
                                                  </td>
                                                </tr>
                                              </xsl:otherwise>
                                            </xsl:choose>
                                          </xsl:otherwise>
                                        </xsl:choose>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </xsl:otherwise> 
                                </xsl:choose>                               
                              </xsl:for-each>
                            </table>
                          </xsl:if >
                        </table>
                      </td>
                    </tr>
                  </table>
                </form>
              </td>
            </tr>
          </table>
        </xsl:if >

        <xsl:call-template name="genBasPage"/>

      </body>
    </html>

  </xsl:template>

  <!--********************************************************************************************************************************************************************-->

</xsl:stylesheet>
