﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"  xmlns:bdf="http://banque-france.fr/namespace">
  <xsl:import href="../../Ressources/XSL/Commun.xsl"/>
  <xsl:import href="../../Ressources/XSL/Commun_SAS.xsl"/>
  <xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes"/>
  <xsl:param name="langage" select="'fr'"/>
  <xsl:param name="familyNumber" select="''"/>
  <xsl:param name="root" select="'/Fiben/'"/>
  <xsl:param name="familyName" select="''"/>
  <xsl:param name="familyTitle" select="''"/>
  <xsl:param name="nextModule" select="''"/>
  <xsl:param name="nextId" select="''"/>
  <xsl:param name="nextFamily" select="''"/>
  <xsl:param name="menuHTML1"/>
  <xsl:param name="Lang" select="'FR'"/>
  <xsl:param name="NonResident" select="''"/>



  <!--TEMPLATE PRINCIPAL-->
  <xsl:template match="/">
    <html lang="fr" xmlns="http://www.w3.org/1999/xhtml">
      <title>Module A1 - Mise sous Alerte</title>
      <xsl:call-template name="genHeadSAS">      
      </xsl:call-template>
      <body class="clBodybgcolorWhite" onload="Tst_Conditions_InitialesSAS_IA();"  >
        <xsl:call-template name="genFondMenu">
          <xsl:with-param name="root" select="$root"/>
          <xsl:with-param name="type" select="'suivi'" />
        </xsl:call-template>
        <!-- Affichage des menus: EVOL 2016 -->
        <xsl:copy-of select="$menuHTML1"/>
        
        
        <xsl:if test="/FIBEN/ERREUR">
          <xsl:call-template name="GestionErreurSAS" >
            <xsl:with-param name="root" select="$root"/>
          </xsl:call-template>
        </xsl:if>
        
          <xsl:if test="not(/FIBEN/ERREUR)">
            <table class="mainmodule horizontal-auto HomeData clBorderCell">
              <caption class="visually-hidden">Module A1 - Mise sous Alerte</caption>
            <tr>
             <td class="clWidth20"></td>
              <td class="clWidth636" colspan="2">
                <form  method="get" name="frmForm1" class="marginTop">
                  <input type="hidden" name="ident" value=""/>
                  <table class="clWidthMax clBorderCell" role="presentation">
                    <tr>
                      <td>
                        <!-- Affichage du bandeau inférieur: -->
                        <xsl:call-template name="BandeauInf" >
                          <xsl:with-param name="Titre" select="$dictionnaire/titre[@module=$moddem]"/>
                          <xsl:with-param name="root" select="$root"/>
                        </xsl:call-template>
                        &#160;
                        <div  id="bloc1" style="visibility:visible">
                          <span class="clTexte clWidth400">
                            Adresses mail déclarées: &#160;
                            <select id="lst_AdrMail"  size="1" class="clChamp clLstMail" onchange="javascript: var oInput; oInput=MM_findObj('txt_newemail'); oInput.value='' ">
                              <option value="0">...</option>
                              <script language="JavaScript" charset="iso-8859-1">
                                var oOpt = new Option('...' + strFillIn(71) + '.','0',true,true);
                                var oSelect=document.getElementById("lst_AdrMail");
                                oSelect.options[0]=oOpt;
                              </script>
                              <!-- Récupération des adresses mails: -->
                              <xsl:call-template name="RecupBALS" />
                            </select>
                          </span>
                          <span id="sgn_LstAdrMail" class="clErreur" style="visibility:hidden;font-size:14pt">&#160;&lt;</span>
                          <br/>
                          <br/>
                          <span class="clTexte clWidth355" id="blc_chp_NewAdrMail"  style="visibility:hidden" >
                            OU &#160;  nouvelle adresse mail:
                            &#160;
                            <input type="text" class="clLstMail" name="txt_newemail" size="28" value="" maxlength="75" onkeypress="javascript: var oInput; oInput=MM_findObj('lst_AdrMail'); oInput.value='0'"  />

                          </span>
                          <span id="sgn_NewAdrMail" class="clErreur" style="visibility:hidden;font-size:14pt" >&#160;&lt;</span>
                          <div id="blc_msg_NewAdrMail" style="visibility:hidden">
                            <table>
                              <tr class="clTexte"  >
                                <td> Vous avez déclaré un maximum de 10 boites aux lettres.
                                </td>
                              </tr>
                              <tr class="clTexte"  >
                                <td>
                                  Si vous souhaitez en inscrire une nouvelle, vous devez préalablement supprimer une boite aux lettres au travers
                                </td>
                              </tr>
                              <tr class="clTexte"  >
                                <td>
                                  de l&#039;écran  des gestions des alertes, accessible via le menu « Alertes et Suivis ».
                                </td>
                              </tr>
                            </table>
                          </div >
                          <table border="0" >
                            <tr>
                              <td class="clTexte">
                                Saisissez les identifiants sur lesquels vous souhaitez être alerté:
                              </td>
                            </tr>
                            <tr>
                              <td class="clWidth300 clHeight10"/>
                            </tr>
                          </table>
                          <table>
                            <tr>
                              <!-- placement des champs des identifiants -->
                              <xsl:call-template name="PlaceChampsIdentifiantIA">
                                <xsl:with-param name="debut" select="1" />
                                <xsl:with-param name="fin" select="5" />
                              </xsl:call-template>
                            </tr>
                            <tr>
                              <!-- placement des champs des identifiants -->
                              <xsl:call-template name="PlaceChampsIdentifiantIA">
                                <xsl:with-param name="debut" select="6" />
                                <xsl:with-param name="fin" select="10" />
                              </xsl:call-template>
                            </tr>
                          </table>
                        </div>
                        <div  id="bloc2" style="visibility:hidden;"><!--position:absolute;top:250px-->
                          
                          <table>
                            <tr>
                              <td class="clTexte">
                                Vous avez atteint le nombre maximum d&#039;alertes pour votre guichet.
                              </td>
                            </tr>
                            <tr>
                              <td class="clTexte">
                                Si vous souhaitez en ajouter, vous devez préalablement en supprimer dans la liste des alertes existantes au travers de l&#039;écran
                              </td>
                            </tr>
                            <tr>
                              <td class="clTexte">
                                des gestions des alertes, accessible via le menu « Alertes et Suivis ».
                              </td>
                            </tr>
                          </table>
                        </div>
                      </td>
                    </tr>
                  </table>
                </form>
              </td>
            </tr>
            </table>
          </xsl:if>

          <xsl:call-template name="genBasPage"/>
        
        
      </body>
    </html>

  </xsl:template>

  <!--********************************************************************************************************************************************************************-->

  <xsl:template name="PlaceChampsIdentifiantIA">
    <xsl:param name="debut" />
    <xsl:param name="fin"  />

    <td  id="sgn_ident{$debut}" class="clErreur" style="visibility:hidden;font-size:14pt" >&gt;</td>
    <td  class="clTitre2"  >
      <input type="text" name="txt_ident{$debut}" id="txt_ident{$debut}" style="visibility:hidden" size="" value="" maxlength="13"  />
      &#160;&#160;&#160;
    </td>

    <!-- si on n'a pas fini la boucle on continue -->
    <xsl:if test="$debut &lt; $fin">
      <xsl:call-template name="PlaceChampsIdentifiantIA">
        <xsl:with-param name="debut" select="($debut)+1" />
        <xsl:with-param name="fin" select="$fin" />
      </xsl:call-template>
    </xsl:if>

  </xsl:template>

</xsl:stylesheet>
