<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
					              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
					              xmlns:bdf="http://banque-france.fr/namespace">
	<xsl:import href="../../Ressources/XSL/Commun.xsl"/>
  <xsl:import href="../../Ressources/XSL/commun_transfo.xsl"/>
	<xsl:import href="../../Ressources/XSL/Commun_sef.xsl"/>
	<xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes" />
	<xsl:param name="langage" select="'fr'"/>
	<xsl:param name="familyName" select="''"/>
  <xsl:param name="root" select="'/Fiben/'"/>
	<xsl:param name="familyNumber" select="''"/>
	<xsl:param name="familyTitle" select="''"/>
	<xsl:param name="nextModule" select="''"/>
	<xsl:param name="nextId" select="''"/>
	<xsl:param name="nextFamily" select="''"/>
  <xsl:param name="Lang" select="'FR'"/>
  <xsl:param name="NonResident" select="''"/>
	<xsl:param name="menuHTML1"/>

<xsl:template match="/">
	<html lang="fr">
    <title>Module 72 - Diagnostic synthtique</title>
		<xsl:call-template name="genHead">
			<xsl:with-param name="ident" select="FIBEN/ERREUR/IDENT | FIBEN/PERSONNE/MODULE72/EJ/IDENTS"/>
		</xsl:call-template>
		<body class="clBodybgcolorWhite">
      <xsl:call-template name="genFondMenu">
        <xsl:with-param name="root" select="$root"/>
      </xsl:call-template>
      <xsl:copy-of select="$menuHTML1"/>
      
			<table class="mainmodule horizontal-auto clBorderCell">
        <caption class="visually-hidden">Module 72 - Diagnostic synthtique</caption>
				<xsl:call-template name="genLigneConfidentiel"/>
				<xsl:apply-templates select="/FIBEN/ERREUR"/>
				<xsl:if test="not(/FIBEN/ERREUR)">

					<tr>
						 <td class="clWidth64"></td>
						<td class="clCouleur2 clValignTop clWidth739" colspan="4">
							<xsl:apply-templates select="FIBEN/PERSONNE/MODULE72/*" mode="genTable"/>
						</td>
					</tr>
					
				</xsl:if>
			</table>
      <xsl:call-template name="genBasPage"/>
		</body>
	</html>
</xsl:template>

<xsl:template match="FIBEN/PERSONNE/MODULE72/EJ" mode="genTable">
	<xsl:call-template name="genEnTete">
		<xsl:with-param name="ident" select="IDENTS"/>
		<xsl:with-param name="nom" select="DENOM"/>
		<xsl:with-param name="valcot" select="../DIFF72/COTATIONSEF/VALCOT"/>
		<xsl:with-param name="datcot" select="../DIFF72/COTATIONSEF/DATCOT"/>
		<xsl:with-param name="datexa" select="../DIFF72/COTATIONSEF/DATEXA"/>
	</xsl:call-template>
</xsl:template>

<xsl:template match="IEC01" mode="genTable">
	<table class="clWidth635 clBorderCell" role="presentation">
		<tr>
			<td class="clWidth14"></td>
			<td class="clCouleur2 clValignTop">
				<xsl:apply-templates select="."/>
			</td>
		</tr>
		<tr>
			<td class="clWidth14"></td>
			<td><xsl:call-template name="shim"/></td>
		</tr>
	</table>
</xsl:template>

<xsl:template match="DIFF72" mode="genTable">
	<a name="donneesgene"></a>
	<table class="clWidth635 clBorderCell" role="presentation">
		<tr class="clAlignCenter">
			<td class="clCouleurGras">
				DONNES GNRALES
			</td>
		</tr>
	</table>
	<xsl:call-template name="shim"/><br/>
	<table class="clWidth635 clBorderCell">
    <caption class="visually-hidden">DONNES GNRALES</caption>
		<tr> 
			 <th class="clCouleur2 clWidth130 clAlignLeft clThNonGras">&#160;Catgorie juridique</th>
			<td class="clFond clWidth505">&#160;<xsl:value-of select="CATJUR"/></td>
		</tr>
		<tr> 
			<th class="clCouleur2 clWidth130 clAlignLeft clThNonGras">&#160;Activit BDF</th>
			<td class="clTexte clWidth505">&#160;<xsl:value-of select="ACTBDF"/>&#160;<xsl:value-of select="LIBACT"/><xsl:if test="CODNAF">&#160;(Code NAF dclar diffrent : <xsl:value-of select="CODNAF"/>)</xsl:if></td>
		</tr>
	</table>
	<xsl:apply-templates select="BILAN72">
		<xsl:with-param name="chiffre" select="BILAN72/CHIFFRES72"/>
	</xsl:apply-templates>
	<xsl:apply-templates select="AUTRECARACT"/>
	<xsl:apply-templates select="BILAN72" mode="resultats"/>
	<xsl:apply-templates select="CARACTERISTIQUES"/>
	<xsl:call-template name="risque">
		<xsl:with-param name="chiffre" select="BILAN72/CHIFFRES72"/>
	</xsl:call-template>
</xsl:template>

<xsl:template match="BILAN72" mode="resultats">
	<a name="chiffrescle"></a>
	<div class="clBreakPage"/>
	<xsl:call-template name="shim"/><br/>
	<table class="clWidth635 clBorderCell" role="presentation">
		<tr class="clAlignCenter">
			<td class="clCouleurGras">CHIFFRES-CLS&#160;(en 
        <xsl:call-template name ="displayUnitXsl">
        <xsl:with-param name ="InputUnit" select ="(@UNITE)"/>
      </xsl:call-template>
       euros)</td>
		</tr>
	</table>
	<xsl:call-template name="shim"/>
	<table class="clWidth739 clBorderCell">
    <caption class="visually-hidden">DONNES GNRALES</caption>
		<tr> 
			<td class="clHeight9 " colspan="5"></td>
			<td class="clWidth103" rowspan="14">&#160;</td>
		</tr>
		<tr> 
			<td class="clCouleur2 clWidth270 clHeight14">&#160;Exercices clturs en</td>
			<td class="clCouleur2 clWidth20 clHeight14">&#160;</td>
      <td class="clFond clWidth115 clHeight14 clAlignRight">
        <xsl:call-template name ="displayDateXsl">
          <xsl:with-param name ="InputDate" select ="(CHIFFRES72[1]/@DATCLOT)"/>
        </xsl:call-template>&#160;
      </td>
      <td class="clFond clWidth115 clHeight14 clAlignRight">
        <xsl:call-template name ="displayDateXsl">
          <xsl:with-param name ="InputDate" select ="(CHIFFRES72[2]/@DATCLOT)"/>
        </xsl:call-template>&#160;
      </td>
      <td class="clFond clWidth115 clHeight14 clAlignRight">
        <xsl:call-template name ="displayDateXsl">
          <xsl:with-param name ="InputDate" select ="(CHIFFRES72[3]/@DATCLOT)"/>
        </xsl:call-template>&#160;
      </td>
		</tr>
		<tr> 
			<td class="clCouleur2 clWidth245 clHeight14" colspan="2">&#160;Dure</td>
      <td class="clFond clWidth115 clHeight14 clAlignRight">
        <xsl:call-template name ="displayDateXsl">
          <xsl:with-param name ="InputDate" select ="(CHIFFRES72[1]/@DUREEEX)"/>
        </xsl:call-template>&#160;
      </td>
      <td class="clFond clWidth115 clHeight14 clAlignRight">
        <xsl:call-template name ="displayDateXsl">
          <xsl:with-param name ="InputDate" select ="(CHIFFRES72[2]/@DUREEEX)"/>
        </xsl:call-template>&#160;
      </td>
      <td class="clFond clWidth115 clHeight14 clAlignRight">
        <xsl:call-template name ="displayDateXsl">
          <xsl:with-param name ="InputDate" select ="(CHIFFRES72[3]/@DUREEEX)"/>
        </xsl:call-template>&#160;
      </td>
		</tr>
		<tr> 
			<td class="clWidth635 clHeight10" colspan="5"></td>
		</tr>
		<tr> 
			<td class="clCouleur2 clWidth225 clHeight14 clAlignCenter">RSULTATS</td>
			<td class="clWidth20 clValignTop clAlignCenter">&#160;</td>
			<td class="clWidth115">&#160;</td>
			<td class="clWidth115">&#160;</td>
			<td class="clWidth115">&#160;</td>
		</tr>
		<tr> 
			<td class="clWidth635 clHeight10" colspan="5"></td>
		</tr>
		<tr> 
			<td class="clCouleur2 clWidth225 clHeight14">&#160;Valeur ajoute</td>
			<td class="clCouleur2 clWidth20 clHeight14">&#160;</td>
          		<td class="clFond clWidth115 clHeight14 clAlignRight"><xsl:apply-templates select="CHIFFRES72[1]/RESULTATS/pk00823red"/>&#160;</td>
			<td class="clFond clWidth115 clHeight14 clAlignRight"><xsl:apply-templates select="CHIFFRES72[2]/RESULTATS/pk00823red"/>&#160;</td>
			<td class="clFond clWidth115 clHeight14 clAlignRight"><xsl:apply-templates select="CHIFFRES72[3]/RESULTATS/pk00823red"/>&#160;</td>
		</tr>
		<tr> 
			<td class="clCouleur2 clWidth225 clHeight14">&#160;&#160;Dont charges de personnel </td>
			<td class="clCouleur2 clWidth20 clHeight14">%</td>
          		<td class="clFond clWidth115 clHeight14 clAlignRight"><xsl:apply-templates select="CHIFFRES72[1]/RESULTATS/pk00829"/>&#160;</td>
			<td class="clFond clWidth115 clHeight14 clAlignRight"><xsl:apply-templates select="CHIFFRES72[2]/RESULTATS/pk00829"/>&#160;</td>
			<td class="clFond clWidth115 clHeight14 clAlignRight"><xsl:apply-templates select="CHIFFRES72[3]/RESULTATS/pk00829"/>&#160;</td>
		</tr>
		<tr> 
			<td class="clCouleur2 clWidth225 clHeight14">&#160;Excdent brut d'exploitation / CA </td>
			<td class="clCouleur2 clWidth20 clHeight14">%</td>
          		<td class="clFond clWidth115 clHeight14 clAlignRight"><xsl:apply-templates select="CHIFFRES72[1]/RESULTATS/pk00833"/>&#160;</td>
			<td class="clFond clWidth115 clHeight14 clAlignRight"><xsl:apply-templates select="CHIFFRES72[2]/RESULTATS/pk00833"/>&#160;</td>
			<td class="clFond clWidth115 clHeight14 clAlignRight"><xsl:apply-templates select="CHIFFRES72[3]/RESULTATS/pk00833"/>&#160;</td>
		</tr>
		<tr> 
			<td class="clCouleur2 clWidth225 clHeight14">&#160;Charges financires / EBE </td>
			<td class="clCouleur2 clWidth20 clHeight14">%</td>
          		<td class="clFond clWidth115 clHeight14 clAlignRight"><xsl:apply-templates select="CHIFFRES72[1]/RESULTATS/pk00831"/>&#160;</td>
			<td class="clFond clWidth115 clHeight14 clAlignRight"><xsl:apply-templates select="CHIFFRES72[2]/RESULTATS/pk00831"/>&#160;</td>
			<td class="clFond clWidth115 clHeight14 clAlignRight"><xsl:apply-templates select="CHIFFRES72[3]/RESULTATS/pk00831"/>&#160;</td>
		</tr>
		<tr> 
			<td class="clCouleur2 clWidth225 clHeight14">&#160;Rsultat courant avant impts</td>
			<td class="clCouleur2 clWidth20 clHeight14">&#160;</td>
          		<td class="clFond clWidth115 clHeight14 clAlignRight"><xsl:apply-templates select="CHIFFRES72[1]/RESULTATS/pk00083"/>&#160;</td>
			<td class="clFond clWidth115 clHeight14 clAlignRight"><xsl:apply-templates select="CHIFFRES72[2]/RESULTATS/pk00083"/>&#160;</td>
			<td class="clFond clWidth115 clHeight14 clAlignRight"><xsl:apply-templates select="CHIFFRES72[3]/RESULTATS/pk00083"/>&#160;</td>
		</tr>
		<tr> 
			<td class="clCouleur2 clWidth225 clHeight14">&#160;Rsultat net / CA </td>
			<td class="clCouleur2 clWidth20 clHeight14">%</td>
          		<td class="clFond clWidth115 clHeight14 clAlignRight"><xsl:apply-templates select="CHIFFRES72[1]/RESULTATS/pk00814"/>&#160;</td>
			<td class="clFond clWidth115 clHeight14 clAlignRight"><xsl:apply-templates select="CHIFFRES72[2]/RESULTATS/pk00814"/>&#160;</td>
			<td class="clFond clWidth115 clHeight14 clAlignRight"><xsl:apply-templates select="CHIFFRES72[3]/RESULTATS/pk00814"/>&#160;</td>
		</tr>
		<tr> 
			<td class="clCouleur2 clWidth225 clHeight14">&#160;Capacit d'autofinancement</td>
			<td class="clCouleur2 clWidth20 clHeight14">&#160;</td>
          		<td class="clFond clWidth115 clHeight14 clAlignRight"><xsl:apply-templates select="CHIFFRES72[1]/RESULTATS/pk00839red"/>&#160;</td>
			<td class="clFond clWidth115 clHeight14 clAlignRight"><xsl:apply-templates select="CHIFFRES72[2]/RESULTATS/pk00839red"/>&#160;</td>
			<td class="clFond clWidth115 clHeight14 clAlignRight"><xsl:apply-templates select="CHIFFRES72[3]/RESULTATS/pk00839red"/>&#160;</td>
		</tr>
		<tr> 
			<td class="clWidth635 clHeight10" colspan="5"></td>
		</tr>
		<tr> 
			<td class="clCouleur2 clWidth225 clHeight14 clAlignCenter">STRUCTURES</td>
			<td class="clWidth20 clValignTop clAlignCenter">&#160;</td>
			<td class="clWidth115">&#160;</td>
			<td class="clWidth115">&#160;</td>
			<td class="clWidth115">&#160;</td>
			<td class="clWidth103 clValignTop clAlignRight" rowspan="14">
				<a href="#ancHaut"><img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page" /></a>
			</td>
		</tr>
		<tr> 
			<td class="clWidth635 clHeight10" colspan="5"></td>
		</tr>
		<tr> 
			<td class="clCouleur2 clWidth225 clHeight14">&#160;Fonds propres nets avant rpartition</td>
			<td class="clCouleur2 clWidth20 clHeight14">&#160;</td>
      <td class="clFond clWidth115 clHeight14 clAlignRight"><xsl:apply-templates select="CHIFFRES72[1]/STRUCTURES/pk00106"/>&#160;</td>
			<td class="clFond clWidth115 clHeight14 clAlignRight"><xsl:apply-templates select="CHIFFRES72[2]/STRUCTURES/pk00106"/>&#160;</td>
			<td class="clFond clWidth115 clHeight14 clAlignRight"><xsl:apply-templates select="CHIFFRES72[3]/STRUCTURES/pk00106"/>&#160;</td>
		</tr>
		<tr> 
			<td class="clCouleur2 clWidth225 clHeight14">&#160;Fonds d'emprunt  moyen - long terme</td>
			<td class="clCouleur2 clWidth20 clHeight14">&#160;</td>
      <td class="clFond clWidth115 clHeight14 clAlignRight"><xsl:apply-templates select="CHIFFRES72[1]/STRUCTURES/pk00785"/>&#160;</td>
			<td class="clFond clWidth115 clHeight14 clAlignRight"><xsl:apply-templates select="CHIFFRES72[2]/STRUCTURES/pk00785"/>&#160;</td>
			<td class="clFond clWidth115 clHeight14 clAlignRight"><xsl:apply-templates select="CHIFFRES72[3]/STRUCTURES/pk00785"/>&#160;</td>
		</tr>
		<tr> 
			<td class="clCouleur2 clWidth225 clHeight14">&#160;&#160;Dont bancaire</td>
			<td class="clCouleur2 clWidth20 clHeight14">&#160;</td>
     	<td class="clFond clWidth115 clHeight14 clAlignRight"><xsl:apply-templates select="CHIFFRES72[1]/STRUCTURES/pk00782"/>&#160;</td>
			<td class="clFond clWidth115 clHeight14 clAlignRight"><xsl:apply-templates select="CHIFFRES72[2]/STRUCTURES/pk00782"/>&#160;</td>
			<td class="clFond clWidth115 clHeight14 clAlignRight"><xsl:apply-templates select="CHIFFRES72[3]/STRUCTURES/pk00782"/>&#160;</td>
		</tr>
		<tr> 
			<td class="clCouleur2 clWidth225 clHeight14">&#160;Actif immobilis brut</td>
			<td class="clCouleur2 clWidth20 clHeight14">&#160;</td>
      <td class="clFond clWidth115 clHeight14 clAlignRight"><xsl:apply-templates select="CHIFFRES72[1]/STRUCTURES/pk00777"/>&#160;</td>
			<td class="clFond clWidth115 clHeight14 clAlignRight"><xsl:apply-templates select="CHIFFRES72[2]/STRUCTURES/pk00777"/>&#160;</td>
			<td class="clFond clWidth115 clHeight14 clAlignRight"><xsl:apply-templates select="CHIFFRES72[3]/STRUCTURES/pk00777"/>&#160;</td>
		</tr>
		<tr> 
			<td class="clCouleur2 clWidth225 clHeight14">&#160;Fond de roulement net global</td>
			<td class="clCouleur2 clWidth20 clHeight14">&#160;</td>
      <td class="clFond clWidth115 clHeight14 clAlignRight"><xsl:apply-templates select="CHIFFRES72[1]/STRUCTURES/pk00129"/>&#160;</td>
			<td class="clFond clWidth115 clHeight14 clAlignRight"><xsl:apply-templates select="CHIFFRES72[2]/STRUCTURES/pk00129"/>&#160;</td>
			<td class="clFond clWidth115 clHeight14 clAlignRight"><xsl:apply-templates select="CHIFFRES72[3]/STRUCTURES/pk00129"/>&#160;</td>
		</tr>
		<tr> 
			<td class="clCouleur2 clWidth225 clHeight14">&#160;- BFR (escompte inclus) (1)</td>
			<td class="clCouleur2 clWidth20 clHeight14">&#160;</td>
			<td class="clFond clWidth115 clHeight14 clAlignRight"><xsl:apply-templates select="CHIFFRES72[1]/STRUCTURES/pk00133"/>&#160;</td>
			<td class="clFond clWidth115 clHeight14 clAlignRight"><xsl:apply-templates select="CHIFFRES72[2]/STRUCTURES/pk00133"/>&#160;</td>
			<td class="clFond clWidth115 clHeight14 clAlignRight"><xsl:apply-templates select="CHIFFRES72[3]/STRUCTURES/pk00133"/>&#160;</td>
		</tr>
		<tr> 
			<td class="clCouleur2 clWidth225 clHeight14">&#160;= Trsorerie (escompte inclus) (1)</td>
			<td class="clCouleur2 clWidth20 clHeight14">&#160;</td>
          		<td class="clFond clWidth115 clHeight14 clAlignRight"><xsl:apply-templates select="CHIFFRES72[1]/STRUCTURES/pk00822"/>&#160;</td>
			<td class="clFond clWidth115 clHeight14 clAlignRight"><xsl:apply-templates select="CHIFFRES72[2]/STRUCTURES/pk00822"/>&#160;</td>
			<td class="clFond clWidth115 clHeight14 clAlignRight"><xsl:apply-templates select="CHIFFRES72[3]/STRUCTURES/pk00822"/>&#160;</td>
		</tr>
		<tr> 
			<td class="clHeight10" colspan="5"></td>
		</tr>
		<tr> 
			<td class="clItalic clHeight10" colspan="5">&#160;(1) hors affacturage et crances Dailly cdes non comptabilises en " effets escompts non chus "</td>
		</tr>
		<tr> 
			<td class="clHeight10" colspan="5"></td>
		</tr>
		<tr> 
			<xsl:variable name="casect" select="CASECTEUR"/>
			<td class="clTexte clHeight10" colspan="5"><xsl:value-of select="substring($casect,3)"/></td>
		</tr>
	</table>
	<xsl:call-template name="shim"/>
</xsl:template>

<xsl:template match="p2052FL|p2052FK|p2058YP|pk00823red|pk00829|pk00833|pk00831|pk00083|pk00814|pk00839red|pk00106|pk00785|pk00782|pk00777|pk00129|pk00133|pk00822">
	<xsl:if test="@ETAT">
		<xsl:value-of select="@ETAT"/>
	</xsl:if>
	<xsl:if test="not(@ETAT)">
    <xsl:call-template name ="displayNumberXsl">
      <xsl:with-param name ="InputStringNumber" select ="(.)"/>
    </xsl:call-template>
	</xsl:if>
</xsl:template>

<xsl:template match="CARACTERISTIQUES">
	<a name="caracent"></a>
	<table class="clWidth635 clBorderCell" role="presentation">
		<tr class="clAlignCenter">
			<td class="clCouleurGras">CARACTRISTIQUE(S) DE L'ENTREPRISE</td>
		</tr>
	</table>
	<xsl:call-template name="shim"/><br/>
	<table class="clWidth739 clBorderCell clTexte">
    <caption class="visually-hidden">ACTIVIT ET RSULTATS/STRUCTURES</caption>
		<tr> 
			<th class="clCouleurGras" colspan="2">ACTIVIT ET RSULTATS</th>
			<td class="clWidth103" rowspan="2">&#160;</td>
		</tr>
		<tr>
			 <td class="clHeight10" colspan="2">&#160;</td>
		</tr>
         	<xsl:apply-templates select="ACTIVITERESULTAT"/>
		<tr> 
			 <td class="clHeight10" colspan="2">&#160;</td>
			<td class="clWidth103" rowspan="3">&#160;</td>
		</tr>
		<tr> 
			<th class="clCouleurGras" colspan="2">STRUCTURES</th>
		</tr>
		<tr> 
			 <td class="clHeight10" colspan="2">&#160;</td>
		</tr>
		<xsl:apply-templates select="STRUCTURE"/>
		<tr> 
			 <td class="clHeight10" colspan="2">&#160;</td>
		</tr>
		<xsl:apply-templates select="TRESORERIE"/>
	</table>
	<div class="clBreakPage"/>
	<xsl:call-template name="shim"/><br/>
</xsl:template>

<xsl:template match="ACTIVITERESULTAT">
	<tr> 
		<td class="clWidth20 clValignTop clAlignCenter">-</td>
		<xsl:variable name="value" select="."/>
		<td class="clWidth615"><xsl:value-of select="substring($value,3)"/></td>
		<xsl:if test="position() mod 8 = 0">
			<td class="clWidth103 clAlignRight">
				<a href="#ancHaut"><img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page" /></a>
			</td>
		</xsl:if>
		<xsl:if test="position() mod 8 != 0">
			<td class="clWidth103 clAlignRight">
				&#160;
			</td>
		</xsl:if>
	</tr>
</xsl:template>

<xsl:template match="STRUCTURE">
	<tr> 
		<td class="clWidth20 clValignTop clAlignCenter">-</td>
		<xsl:variable name="value" select="."/>
		<td class="clWidth615"><xsl:value-of select="substring($value,3)"/></td>
		<xsl:if test="(position() + count(//ACTIVITERESULTAT)) mod 8 = 0">
			<td class="clWidth103 clAlignRight">
				<a href="#ancHaut"><img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page" /></a>
			</td>
		</xsl:if>
		<xsl:if test="(position() + count(//ACTIVITERESULTAT)) mod 8 != 0">
			<td class="clWidth103 clAlignRight">
				&#160;
			</td>
		</xsl:if>
	</tr>
</xsl:template>

<xsl:template match="TRESORERIE">
	<tr> 
		<xsl:variable name="value" select="."/>
		<td class="clWidth635" colspan="2"><xsl:value-of select="substring($value,3)"/></td>
		<xsl:if test="(1 + count(//ACTIVITERESULTAT) + count(//STRUCTURE)) mod 8 = 0">
			<td class="clWidth103 clAlignRight">
				<a href="#ancHaut"><img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page" /></a>
			</td>
		</xsl:if>
		<xsl:if test="(1 + count(//ACTIVITERESULTAT) + count(//STRUCTURE)) mod 8 != 0">
			<td class="clWidth103 clAlignRight">
				&#160;
			</td>
		</xsl:if>
	</tr>
</xsl:template>

</xsl:stylesheet>
