<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
					              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
					              xmlns:bdf="http://banque-france.fr/namespace">
	<xsl:import href="../../Ressources/XSL/Commun.xsl"/>
	<xsl:import href="../../Ressources/XSL/Commun_sef.xsl"/>
	<xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes" />
	<xsl:param name="langage" select="'fr'"/>
	<xsl:param name="familyName" select="''"/>
  <xsl:param name="root" select="'/Fiben/'"/>
	<xsl:param name="familyNumber" select="''"/>
	<xsl:param name="familyTitle" select="''"/>
	<xsl:param name="nextModule" select="''"/>
	<xsl:param name="nextId" select="''"/>
	<xsl:param name="nextFamily" select="''"/>
  <xsl:param name="Lang" select="'FR'"/>
  <xsl:param name="NonResident" select="''"/>
	<xsl:param name="menuHTML1"/>

<xsl:template match="/">
	<html lang="fr">
     <title>Module 70 - Elments de risque</title>
		<xsl:call-template name="genHead">
			<xsl:with-param name="ident" select="FIBEN/ERREUR/IDENT | FIBEN/PERSONNE/MODULE70/EJ/IDENTS"/>
		</xsl:call-template>
		<body class="clBodybgcolorWhite">
      <xsl:call-template name="genFondMenu">
        <xsl:with-param name="root" select="$root"/>
      </xsl:call-template>
      <xsl:copy-of select="$menuHTML1"/>
      
			<table class="mainmodule horizontal-auto clBorderCell">
        <caption class="visually-hidden">Module 70 - Elments de risque</caption>
				<xsl:call-template name="genLigneConfidentiel"/>
				<xsl:apply-templates select="/FIBEN/ERREUR"/>
				<xsl:if test="not(/FIBEN/ERREUR)">

					<tr>
						 <td class="clWidth64"></td>
						<td class="clCouleur2 clValignTop clWidth739" colspan="4">
							<xsl:apply-templates select="FIBEN/PERSONNE/MODULE70/*" mode="genTable"/>
						</td>
					</tr>
					
				</xsl:if>
			</table>
      <xsl:call-template name="genBasPage"/>
		</body>
	</html>
</xsl:template>

<xsl:template match="FIBEN/PERSONNE/MODULE70/EJ" mode="genTable">
	<xsl:call-template name="genEnTete">
		<xsl:with-param name="ident" select="IDENTS"/>
		<xsl:with-param name="nom" select="DENOM"/>
		<xsl:with-param name="valcot" select="../DIFF70/COTATIONSEF/VALCOT"/>
		<xsl:with-param name="datcot" select="../DIFF70/COTATIONSEF/DATCOT"/>
		<xsl:with-param name="datexa" select="../DIFF70/COTATIONSEF/DATEXA"/>
	</xsl:call-template>
</xsl:template>

<xsl:template match="IEC01" mode="genTable">
	<table class="clWidth635 clBorderCell" role="presentation">
		<tr>
			<td class="clWidth14"></td>
			<td class="clCouleur2 clValignTop">
				<xsl:apply-templates select="."/>
			</td>
		</tr>
		<tr>
			<td class="clWidth14"></td>
			<td><xsl:call-template name="shim"/></td>
		</tr>
	</table>
</xsl:template>

<xsl:template match="DIFF70" mode="genTable">
	<a name="donneesgene"></a>
	<table class="clWidth635 clBorderCell">
		<tr class="clAlignCenter">
			<td class="clCouleurGras">
				DONNES GNRALES
			</td>
		</tr>
	</table>
	<xsl:call-template name="shim"/><br/>
	<table class="clWidth635 clBorderCell">
    <caption class="visually-hidden">DONNES GNRALES</caption>
		<tr> 
			 <th class="clCouleur2 clWidth130 clAlignLeft clThNonGras">&#160;Catgorie juridique</th>
			<td class="clFond clWidth505">&#160;<xsl:value-of select="CATJUR"/></td>
		</tr>
		<tr> 
			<th class="clCouleur2 clWidth130 clAlignLeft clThNonGras">&#160;Activit BDF</th>
			<td class="clTexte clWidth505">&#160;<xsl:value-of select="ACTBDF"/>&#160;<xsl:value-of select="LIBACT"/><xsl:if test="CODNAF">&#160;(Code NAF dclar diffrent : <xsl:value-of select="CODNAF"/>)</xsl:if></td>
		</tr>
	</table>
	<xsl:apply-templates select="BILAN70">
		<xsl:with-param name="chiffre" select="BILAN70/CHIFFRES70"/>
	</xsl:apply-templates>
	<xsl:apply-templates select="AUTRECARACT"/>
	<xsl:call-template name="shim"/><br/>
	<xsl:call-template name="risque">
		<xsl:with-param name="chiffre" select="BILAN70/CHIFFRES70"/>
	</xsl:call-template>
</xsl:template>

<xsl:template match="p2052FL|p2052FK|p2058YP">
	<xsl:if test="@ETAT">
		<xsl:value-of select="@ETAT"/>
	</xsl:if>
	<xsl:if test="not(@ETAT)">
    <xsl:call-template name ="displayNumberXsl">
      <xsl:with-param name ="InputStringNumber" select ="(.)"/>
    </xsl:call-template>
	</xsl:if>
</xsl:template>

</xsl:stylesheet>
