<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:bdf="http://banque-france.fr/namespace">
  <xsl:import href="../../Ressources/XSL/Commun.xsl"/>
  <xsl:import href="../../Ressources/XSL/Commun_bilans.xsl"/>
  <xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes"/>
  <xsl:param name="langage" select="'fr'"/>
  <xsl:param name="familyName" select="''"/>
  <xsl:param name="root" select="'/Fiben/'"/>
  <xsl:param name="familyNumber" select="''"/>
  <xsl:param name="familyTitle" select="''"/>
  <xsl:param name="nextModule" select="''"/>
  <xsl:param name="nextId" select="''"/>
  <xsl:param name="nextFamily" select="''"/>
  <xsl:param name="Lang" select="'FR'"/>
  <xsl:param name="NonResident" select="''"/>
  <xsl:param name="menuHTML1"/>
  <xsl:template match="/">
    <html lang="fr">
      <title>Module 69 - Liasse fiscale et donnes complmentaires</title>
      <xsl:call-template name="genHead">
        <xsl:with-param name="ident" select="FIBEN/ERREUR/IDENT | FIBEN/PERSONNE/MODULE69/EJ/IDENTS"/>
      </xsl:call-template>
      <body class="clBodybgcolorWhite">
        <xsl:call-template name="genFondMenu">
          <xsl:with-param name="root" select="$root"/>
        </xsl:call-template>
        <xsl:copy-of select="$menuHTML1"/>
        <table class="mainmodule horizontal-auto clBorderCell">
          <caption class="visually-hidden">Module 69 - Liasse fiscale et donnes complmentaires</caption>
          <xsl:call-template name="genLigneConfidentiel"/>
          <xsl:apply-templates select="/FIBEN/ERREUR"/>
          <xsl:if test="not(/FIBEN/ERREUR)">
            <tr>
              <td class="clWidth14"/>
              <td class="clCouleur2 clValignTop clWidth739" colspan="4">
                <xsl:apply-templates select="FIBEN/PERSONNE/MODULE69/EJ"/>
                <xsl:apply-templates select="FIBEN/PERSONNE/MODULE69/IST01|FIBEN/PERSONNE/MODULE69/IST02|FIBEN/PERSONNE/MODULE69/IST03|FIBEN/PERSONNE/MODULE69/IST04|FIBEN/PERSONNE/MODULE69/IST10" mode="genLib"/>
                <xsl:apply-templates select="FIBEN/PERSONNE/MODULE69/DIFF69"/>
              </td>
            </tr>
          </xsl:if>
        </table>
        <xsl:call-template name="genBasPage"/>
      </body>
    </html>
  </xsl:template>
  <xsl:template match="FIBEN/PERSONNE/MODULE69/EJ">
    <xsl:call-template name="genEnTete">
      <xsl:with-param name="ident" select="IDENTS"/>
      <xsl:with-param name="nom" select="DENOM"/>
    </xsl:call-template>
  </xsl:template>
  <xsl:template match="IST01|IST02|IST03|IST04|IST10" mode="genLib">
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
        <td class="clCouleur2">
          <xsl:apply-templates select="."/>
          <br/>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
  </xsl:template>
  <xsl:template match="DIFF69">
    <table class="clWidth635 clBorderCell">
      <caption class="visually-hidden">Information de la liasse fiscale</caption>
      <xsl:if test="@REGFIS">
        <tr>
          <th class="clCouleur2 clWidth150 clAlignLeft clThNonGras">&#160;Rgime fiscal</th>
          <td class="clFond clWidth300">
            &#160;<xsl:value-of select="@REGFIS"/>
          </td>
          <td class="clFond clWidth185">&#160;</td>
        </tr>
        <tr>
          <td class="clWidth105 clHeight14"/>
          <td class="clWidth300 clHeight14"/>
          <td class="clWidth185 clHeight14"/>
        </tr>
      </xsl:if>
      <tr>
        <th class="clCouleur2 clWidth150 clAlignLeft clThNonGras">&#160;Documents comptables</th>
        <td class="clFond clWidth300">&#160;COMPTES SOCIAUX</td>
        <td class="clCouleur2 clWidth185 clAlignRight">&#160;&#160;(exprims en milliers d'euros)</td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
    <xsl:apply-templates select="LIASSE[1]"/>
    <xsl:apply-templates select="HORSLIASSE[1]"/>
    <xsl:apply-templates select="AFFECTATION69[1]"/>
    <xsl:if test="EJ">
      <div class="clBreakPage"/>
    </xsl:if>
    <xsl:call-template name="shim"/>
    <br/>
    <xsl:apply-templates select="EJ"/>
    <xsl:apply-templates select="STECONSO" mode="genLib">
      <xsl:with-param name="goIdent" select="/FIBEN/PERSONNE/MODULE69/EJ/IDENTS"/>
    </xsl:apply-templates>
  </xsl:template>
  <xsl:template match="LIASSE">
    <table class="clWidth635 clBorderCell">
      <tr>
        <th class="clCouleur2 clWidth320 clHeight14 clAlignLeft clThNonGras">&#160;Date de clture</th>
        <xsl:apply-templates select="../LIASSE/@DATCLOT"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth320 clHeight14 clAlignLeft clThNonGras">&#160;Dure</th>
        <xsl:apply-templates select="../LIASSE/@DUREEEX"/>
      </tr>
    </table>
    <div class="clBreakPage"/>
    <xsl:call-template name="shim"/>
    <br/>
    <a name="actif"/>
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr class="clAlignCenter">
        <td class="clCouleurGras">
          ACTIF<br/>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
    <table class="clWidth739 clBorderCell">
      <caption class="visually-hidden">ACTIF IMMOBILIS</caption>
      <tr>
        <td class="clWidth265 clCouleur2 clHeight15 clAlignCenter">&#160;</td>
        <td class="clCouleur2 clWidth55 clHeight15 clAlignCenter">&#160;</td>
        <xsl:apply-templates select="../LIASSE/@DATCLOT"/>
      </tr>
      <tr>
        <td class="clWidth265 clCouleur2 clHeight10 clAlignCenter"/>
        <td class="clCouleur2 clWidth55 clHeight10 clAlignCenter"/>
        <td class="clWidth105 clHeight10 clAlignRight"/>
        <td class="clWidth105 clHeight10 clAlignRight"/>
        <td class="clWidth105 clHeight10 clAlignRight"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clHeight15 clAlignCenter clThNonGras">ACTIF IMMOBILIS</th>
        <td class="clCouleur2 clWidth55 clHeight15 clAlignCenter"/>
        <td class="clWidth105 clHeight15 clAlignRight"/>
        <td class="clWidth105 clHeight15 clAlignRight"/>
        <td class="clWidth105 clHeight15 clAlignRight"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clHeight10"/>
        <td class="clWidth105"/>
        <td class="clWidth105 clHeight10"/>
        <td class="clWidth105 clHeight10"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clHeight15 clAlignLeft clThNonGras">&#160;Capital souscrit non appel (0)</th>
        <th class="clCouleur2 clWidth55 clHeight15 clAlignCenter clThNonGras">2050AA</th>
        <xsl:apply-templates select="../LIASSE/p2050AA"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;IMMOBILISATIONS INCORPORELLES</th>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Frais d'tablissement (brut)</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050AB</th>
        <xsl:apply-templates select="../LIASSE/p2050AB"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Frais d'tablissement (amort. prov.)</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050AC</th>
        <xsl:apply-templates select="../LIASSE/p2050AC"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clHeight14 clAlignLeft clThNonGras">&#160;&#160;Frais de dveloppement (brut)</th>
        <th class="clCouleur2 clWidth55 clHeight14 clAlignCenter clThNonGras">2050CX</th>
        <xsl:apply-templates select="../LIASSE/p2050CX"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clHeight14 clAlignLeft clThNonGras">
          &#160;&#160;Frais de dveloppement (amortis./provisions)
        </th>
        <th class="clCouleur2 clWidth55 clHeight14 clAlignCenter clThNonGras">2050CQ</th>
        <xsl:apply-templates select="../LIASSE/p2050CQ"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">
          &#160;&#160;Concessions brevets... (brut)
        </th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050AF</th>
        <xsl:apply-templates select="../LIASSE/p2050AF"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clHeight14 clAlignLeft clThNonGras">
          &#160;&#160;Concessions brevets... (amort. prov.)
        </th>
        <th class="clCouleur2 clWidth55 clHeight14 clAlignCenter clThNonGras">2050AG</th>
        <xsl:apply-templates select="../LIASSE/p2050AG"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">
          &#160;&#160;Fonds commercial (brut)
        </th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050AH</th>
        <xsl:apply-templates select="../LIASSE/p2050AH"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">
          &#160;&#160;Fonds commercial (amort. prov.)
        </th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050AI</th>
        <xsl:apply-templates select="../LIASSE/p2050AI"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clHeight14 clAlignLeft clThNonGras">
          &#160;&#160;Autres immobilisations incorporelles (brut)
        </th>
        <th class="clCouleur2 clWidth55 clHeight14 clAlignCenter clThNonGras">2050AJ</th>
        <xsl:apply-templates select="../LIASSE/p2050AJ"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clHeight14 clAlignLeft clThNonGras">
          &#160;&#160;Autres immo. incorporelles (amort. prov.)
        </th>
        <th class="clCouleur2 clWidth55 clHeight14 clAlignCenter clThNonGras">2050AK</th>
        <xsl:apply-templates select="../LIASSE/p2050AK"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clHeight14 clAlignLeft clThNonGras">
          &#160;&#160;Avances-acptes s/ immo. incorporelles (brut)
        </th>
        <th class="clCouleur2 clWidth55 clHeight14 clAlignCenter clThNonGras">2050AL</th>
        <xsl:apply-templates select="../LIASSE/p2050AL"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clHeight14 clAlignLeft clThNonGras">
          &#160;&#160;Av.-acpt s/immo. incorporelles (amort. prov)
        </th>
        <th class="clCouleur2 clWidth55 clHeight14 clAlignCenter clThNonGras">2050AM</th>
        <xsl:apply-templates select="../LIASSE/p2050AM"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">
          &#160;IMMOBILISATIONS CORPORELLES
        </th>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth103 clValignBottom clAlignRight" rowspan="5">
          <a href="#ancHaut">
            <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page"/>
          </a>
        </td>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">
          &#160;&#160;Terrains (brut)
        </th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050AN</th>
        <xsl:apply-templates select="../LIASSE/p2050AN"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">
          &#160;&#160;Terrains (amort. prov.)
        </th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050AO</th>
        <xsl:apply-templates select="../LIASSE/p2050AO"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">
          &#160;&#160;Constructions (brut)
        </th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050AP</th>
        <xsl:apply-templates select="../LIASSE/p2050AP"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">
          &#160;&#160;Constructions (amort. prov.)
        </th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050AQ</th>
        <xsl:apply-templates select="../LIASSE/p2050AQ"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clHeight14 clAlignLeft clThNonGras">
          &#160;&#160;Inst. techniques matriel outillage (brut)
        </th>
        <th class="clCouleur2 clWidth55 clHeight14 clAlignCenter clThNonGras">2050AR</th>
        <xsl:apply-templates select="../LIASSE/p2050AR"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clHeight14 clAlignLeft clThNonGras">
          &#160;&#160;Inst. techniq. matriel outillage (amort. prov.)
        </th>
        <th class="clCouleur2 clWidth55 clHeight14 clAlignCenter clThNonGras">2050AS</th>
        <xsl:apply-templates select="../LIASSE/p2050AS"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clHeight14 clAlignLeft clThNonGras">
          &#160;&#160;Autres immobilisations corporelles (brut)
        </th>
        <th class="clCouleur2 clWidth55 clHeight14 clAlignCenter clThNonGras">2050AT</th>
        <xsl:apply-templates select="../LIASSE/p2050AT"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clHeight14 clAlignLeft clThNonGras">
          &#160;&#160;Autres immo. corporelles (amort. prov.)
        </th>
        <th class="clCouleur2 clWidth55 clHeight14 clAlignCenter clThNonGras">2050AU</th>
        <xsl:apply-templates select="../LIASSE/p2050AU"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">
          &#160;&#160;Immobilisations en cours (brut)
        </th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050AV</th>
        <xsl:apply-templates select="../LIASSE/p2050AV"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clHeight14 clAlignLeft clThNonGras">
          &#160;&#160;Immobilisations en cours (amort. prov.)
        </th>
        <th class="clCouleur2 clWidth55 clHeight14 clAlignCenter clThNonGras">2050AW</th>
        <xsl:apply-templates select="../LIASSE/p2050AW"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">
          &#160;&#160;Avances et acomptes (brut)
        </th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050AX</th>
        <xsl:apply-templates select="../LIASSE/p2050AX"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">
          &#160;&#160;Avances et acomptes (amort. prov.)
        </th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050AY</th>
        <xsl:apply-templates select="../LIASSE/p2050AY"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">
          &#160;IMMOBILISATIONS FINANCIRES
        </th>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">
          &#160;&#160;Participations quivalence
        </th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050CS</th>
        <xsl:apply-templates select="../LIASSE/p2050CS"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">
          &#160;&#160;Participations quivalence
          (prov.)
        </th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050CT</th>
        <xsl:apply-templates select="../LIASSE/p2050CT"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">
          &#160;&#160;Autres participations
        </th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050CU</th>
        <xsl:apply-templates select="../LIASSE/p2050CU"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">
          &#160;&#160;Autres participations (prov.)
        </th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050CV</th>
        <xsl:apply-templates select="../LIASSE/p2050CV"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clHeight14 clAlignLeft clThNonGras">
          &#160;&#160;Crances rattaches  des participations
        </th>
        <th class="clCouleur2 clWidth55 clHeight14 clAlignCenter clThNonGras">2050BB</th>
        <xsl:apply-templates select="../LIASSE/p2050BB"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clHeight14 clAlignLeft clThNonGras">
          &#160;&#160;Crances rattaches  des particip. (prov.)
        </th>
        <th class="clCouleur2 clWidth55 clHeight14 clAlignCenter clThNonGras">2050BC</th>
        <xsl:apply-templates select="../LIASSE/p2050BC"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">
          &#160;&#160;Autres titres immobiliss
        </th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050BD</th>
        <xsl:apply-templates select="../LIASSE/p2050BD"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">
          &#160;&#160;Autres titres immobiliss (prov.)
        </th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050BE</th>
        <xsl:apply-templates select="../LIASSE/p2050BE"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">
          &#160;&#160;Prts
        </th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050BF</th>
        <xsl:apply-templates select="../LIASSE/p2050BF"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">
          &#160;&#160;Prts (prov.)
        </th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050BG</th>
        <xsl:apply-templates select="../LIASSE/p2050BG"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">
          &#160;&#160;Autres immobilisations financires
        </th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050BH</th>
        <xsl:apply-templates select="../LIASSE/p2050BH"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clHeight14 clAlignLeft clThNonGras">
          &#160;&#160;Autres immobilisations financires (prov.)
        </th>
        <th class="clCouleur2 clWidth55 clHeight14 clAlignCenter clThNonGras">2050BI</th>
        <xsl:apply-templates select="../LIASSE/p2050BI"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignCenter clThNonGras">TOTAL ACTIF IMMOBILIS [I]</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050BJ</th>
        <xsl:apply-templates select="../LIASSE/p2050BJ"/>
      </tr>
      <tr>
        <td class="clTexte clWidth265 clHeight10"/>
        <td class="clTexte clWidth55 clHeight10"/>
        <td class="clTexte clWidth105 clHeight10"/>
        <td class="clTexte clWidth105 clHeight10"/>
        <td class="clTexte clWidth105 clHeight10"/>
        <td class="clWidth103 clValignBottom clAlignRight" rowspan="2">
          <a href="#ancHaut">
            <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page"/>
          </a>
        </td>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clHeight14 clAlignCenter clThNonGras">TOTAL ACTIF IMMOBILIS [I] (amort. prov.)</th>
        <th class="clCouleur2 clWidth55 clHeight14 clAlignCenter clThNonGras">2050BK</th>
        <xsl:apply-templates select="../LIASSE/p2050BK"/>
      </tr>
    </table>
    <table class="clWidth739 clBorderCell">
      <caption class="visually-hidden">ACTIF CIRCULANT</caption>
      <tr>
        <td class="clWidth265 clCouleur2 clHeight10"/>
        <td class="clWidth55 clHeight10"/>
        <td class="clTexte clWidth105 clHeight10"/>
        <td class="clTexte clWidth105 clHeight10"/>
        <td class="clTexte clWidth105 clHeight10"/>
      </tr>
      <tr class="clBreakPage">
        <td class="clWidth265 clCouleur2 clAlignCenter">ACTIF CIRCULANT</td>
        <td class="clWidth55"/>
        <td class="clWidth105 clAlignRight">&#160;</td>
        <td class="clWidth105 clAlignRight">&#160;</td>
        <td class="clWidth105 clAlignRight">&#160;</td>
      </tr>
      <tr>
        <td class="clWidth265 clCouleur2 clHeight10"/>
        <td class="clWidth55 clHeight10"/>
        <td class="clTexte clWidth105 clHeight10 clAlignRight"/>
        <td class="clTexte clWidth105 clHeight10 clAlignRight"/>
        <td class="clTexte clWidth105 clHeight10 clAlignRight"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;STOCKS</th>
        <td class="clWidth55"/>
        <td class="clTexte clWidth105 clAlignRight">&#160;</td>
        <td class="clTexte clWidth105 clAlignRight">&#160;</td>
        <td class="clTexte clWidth105 clAlignRight">&#160;</td>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Matires premires approvisionnements</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050BL</th>
        <xsl:apply-templates select="../LIASSE/p2050BL"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clHeight14 clAlignLeft clThNonGras">&#160;&#160;Matires premires approvisionn. (prov.)</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050BM</th>
        <xsl:apply-templates select="../LIASSE/p2050BM"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;En-cours production de biens</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050BN</th>
        <xsl:apply-templates select="../LIASSE/p2050BN"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;En-cours production de biens (prov.)</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050BO</th>
        <xsl:apply-templates select="../LIASSE/p2050BO"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;En-cours production de services</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050BP</th>
        <xsl:apply-templates select="../LIASSE/p2050BP"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">
          &#160;&#160;En-cours production de services (prov.)
        </th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050BQ</th>
        <xsl:apply-templates select="../LIASSE/p2050BQ"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Produits intermdiaires et finis</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050BR</th>
        <xsl:apply-templates select="../LIASSE/p2050BR"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Produits intermdiaires et finis (prov.) </th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050BS</th>
        <xsl:apply-templates select="../LIASSE/p2050BS"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Marchandises</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050BT</th>
        <xsl:apply-templates select="../LIASSE/p2050BT"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Marchandises (prov.)</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050BU</th>
        <xsl:apply-templates select="../LIASSE/p2050BU"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clHeight15 clAlignLeft clThNonGras">&#160;&#160;Avances et acptes verss sur commandes</th>
        <th class="clCouleur2 clWidth55 clHeight15 clAlignCenter clThNonGras">2050BV</th>
        <xsl:apply-templates select="../LIASSE/p2050BV"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Avances et acomptes verss (prov.)</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050BW</th>
        <xsl:apply-templates select="../LIASSE/p2050BW"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;CRANCES</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">&#160;</th>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Clients et comptes rattachs</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050BX</th>
        <xsl:apply-templates select="../LIASSE/p2050BX"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Clients et comptes rattachs (prov.)</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050BY</th>
        <xsl:apply-templates select="../LIASSE/p2050BY"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Autres crances</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050BZ</th>
        <xsl:apply-templates select="../LIASSE/p2050BZ"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Autres crances (prov.) </th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050CA</th>
        <xsl:apply-templates select="../LIASSE/p2050CA"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth103 clValignBottom clAlignRight" rowspan="3">
          <a href="#ancHaut">
            <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page"/>
          </a>
        </td>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Capital souscrit appel non vers</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050CB</th>
        <xsl:apply-templates select="../LIASSE/p2050CB"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Capital souscrit appel non vers (prov.)</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050CC</th>
        <xsl:apply-templates select="../LIASSE/p2050CC"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;TRSORERIE-ACTIF</th>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Valeurs mobilires de placement</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050CD</th>
        <xsl:apply-templates select="../LIASSE/p2050CD"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Valeurs mobilires de placement (prov.)</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050CE</th>
        <xsl:apply-templates select="../LIASSE/p2050CE"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Disponibilits</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050CF</th>
        <xsl:apply-templates select="../LIASSE/p2050CF"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Disponibilits (prov.)</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050CG</th>
        <xsl:apply-templates select="../LIASSE/p2050CG"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Charges constates d'avance</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050CH</th>
        <xsl:apply-templates select="../LIASSE/p2050CH"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Charges constates d'avance (prov.)</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050CI</th>
        <xsl:apply-templates select="../LIASSE/p2050CI"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignCenter clThNonGras">TOTAL ACTIF CIRCULANT [II]</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050CJ</th>
        <xsl:apply-templates select="../LIASSE/p2050CJ"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignCenter clThNonGras">TOTAL ACTIF CIRCULANT [II] (prov.)</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050CK</th>
        <xsl:apply-templates select="../LIASSE/p2050CK"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Frais d'mission d'emprunts  taler [III]</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050CW</th>
        <xsl:apply-templates select="../LIASSE/p2050CW"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Primes remboursement des obligations [IV)</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050CM</th>
        <xsl:apply-templates select="../LIASSE/p2050CM"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;carts de conversion actif [V]</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050CN</th>
        <xsl:apply-templates select="../LIASSE/p2050CN"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignCenter clThNonGras">TOTAL GNRAL ACTIF [O  V]</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050CO</th>
        <xsl:apply-templates select="../LIASSE/p2050CO"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignCenter clThNonGras">TOTAL GNRAL ACTIF [O  V] (amort. prov.)</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">20501A</th>
        <xsl:apply-templates select="../LIASSE/p20501A"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clItalic clWidth265 clAlignLeft clThNonGras">&#160;Renvois :</th>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clItalic clWidth265 clAlignLeft clThNonGras">&#160;&#160;Droit au bail</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050RE1</th>
        <xsl:apply-templates select="../LIASSE/p2050RE1"/>
      </tr>
      <tr>
        <th class="clItalic clWidth265 clAlignLeft clThNonGras">&#160;&#160;Part  - 1 an des immob. fin. nettes</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050CP</th>
        <xsl:apply-templates select="../LIASSE/p2050CP"/>
      </tr>
      <tr>
        <th class="clItalic clWidth265 clAlignLeft clThNonGras">&#160;&#160;Part  + 1an </th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050CR</th>
        <xsl:apply-templates select="../LIASSE/p2050CR"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clItalic clWidth265 clAlignLeft clThNonGras">&#160;Clause de rserve de proprit :</th>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth103 clValignBottom clAlignRight" rowspan="2">
          <a href="#ancHaut">
            <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page"/>
          </a>
        </td>
      </tr>
      <tr>
        <th class="clItalic clWidth265 clAlignLeft clThNonGras">&#160;&#160;Immobilisations</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050RP1</th>
        <xsl:apply-templates select="../LIASSE/p2050RP1"/>
      </tr>
      <tr>
        <th class="clItalic clWidth265 clAlignLeft clThNonGras">&#160;&#160;Stocks</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050RP2</th>
        <xsl:apply-templates select="../LIASSE/p2050RP2"/>
      </tr>
      <tr>
        <th class="clItalic clWidth265 clAlignLeft clThNonGras">&#160;&#160;Crances</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2050RP3</th>
        <xsl:apply-templates select="../LIASSE/p2050RP3"/>
      </tr>
    </table>
    <div class="clBreakPage"/>
    <xsl:call-template name="shim"/>
    <br/>
    <a name="passif"/>
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr class="clAlignCenter">
        <td class="clCouleurGras">
          PASSIF AVANT RPARTITION<br/>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
    <table class="clWidth739 clBorderCell">
      <caption class="visually-hidden">PASSIF AVANT RPARTITION</caption>
      <tr>
        <td class="clWidth265 clCouleur2 clAlignCenter">&#160;</td>
        <td class="clWidth55"/>
        <xsl:apply-templates select="../LIASSE/@DATCLOT"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignCenter clThNonGras">CAPITAUX PROPRES</th>
        <td class="clWidth55"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Capital social</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2051DA</th>
        <xsl:apply-templates select="../LIASSE/p2051DA"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Primes d'mission fusion apport</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2051DB</th>
        <xsl:apply-templates select="../LIASSE/p2051DB"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;carts de rvaluation</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2051DC</th>
        <xsl:apply-templates select="../LIASSE/p2051DC"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dont cart d'quivalence</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2051EK</th>
        <xsl:apply-templates select="../LIASSE/p2051EK"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Rserve lgale</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2051DD</th>
        <xsl:apply-templates select="../LIASSE/p2051DD"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Rserves statutaires ou contractuelles</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2051DE</th>
        <xsl:apply-templates select="../LIASSE/p2051DE"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Rserves rglementes</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2051DF</th>
        <xsl:apply-templates select="../LIASSE/p2051DF"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Autres rserves</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2051DG</th>
        <xsl:apply-templates select="../LIASSE/p2051DG"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Report  nouveau (+/-)</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2051DH</th>
        <xsl:apply-templates select="../LIASSE/p2051DH"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Rsultat de l'exercice (+/-)</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2051DI</th>
        <xsl:apply-templates select="../LIASSE/p2051DI"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Subventions d'investissement</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2051DJ</th>
        <xsl:apply-templates select="../LIASSE/p2051DJ"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Provisions rglementes</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2051DK</th>
        <xsl:apply-templates select="../LIASSE/p2051DK"/>
      </tr>
      <tr>
        <td class="clWidth265"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignCenter clThNonGras">&#160;TOTAL CAPITAUX PROPRES [I] (+/-)</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2051DL</th>
        <xsl:apply-templates select="../LIASSE/p2051DL"/>
      </tr>
      <tr>
        <td class="clWidth265"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignCenter clThNonGras">AUTRES FONDS PROPRES</th>
        <td class="clCouleur2 clWidth55 clAlignCenter">&#160;</td>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Produits missions titres participatifs</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2051DM</th>
        <xsl:apply-templates select="../LIASSE/p2051DM"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Avances conditionnes</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2051DN</th>
        <xsl:apply-templates select="../LIASSE/p2051DN"/>
      </tr>
      <tr>
        <td class="clWidth265"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth103 clValignBottom clAlignRight" rowspan="2">
          <a href="#ancHaut">
            <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page"/>
          </a>
        </td>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignCenter clThNonGras">&#160;TOTAL AUTRES FONDS PROPRES [II]</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2051DO</th>
        <xsl:apply-templates select="../LIASSE/p2051DO"/>
      </tr>
      <tr>
        <td class="clWidth265"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignCenter clThNonGras">PROVISIONS POUR RISQUES ET CHARGES</th>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Provisions pour risques</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2051DP</th>
        <xsl:apply-templates select="../LIASSE/p2051DP"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Provisions pour charges</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2051DQ</th>
        <xsl:apply-templates select="../LIASSE/p2051DQ"/>
      </tr>
      <tr>
        <td class="clWidth265"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignCenter clThNonGras">&#160;TOTAL PROVISIONS RISQUES ET CHARGES [III]</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2051DR</th>
        <xsl:apply-templates select="../LIASSE/p2051DR"/>
      </tr>
      <tr>
        <td class="clWidth265"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignCenter clThNonGras">DETTES</th>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Emprunts obligataires convertibles</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2051DS</th>
        <xsl:apply-templates select="../LIASSE/p2051DS"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Autres emprunts obligataires</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2051DT</th>
        <xsl:apply-templates select="../LIASSE/p2051DT"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Emprunts et dettes auprs des tab. de crdit</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2051DU</th>
        <xsl:apply-templates select="../LIASSE/p2051DU"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Emprunts et dettes financires diverses</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2051DV</th>
        <xsl:apply-templates select="../LIASSE/p2051DV"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Avances et acomptes reus sur commandes</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2051DW</th>
        <xsl:apply-templates select="../LIASSE/p2051DW"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Dettes fournisseurs et comptes rattachs</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2051DX</th>
        <xsl:apply-templates select="../LIASSE/p2051DX"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Dettes fiscales et sociales</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2051DY</th>
        <xsl:apply-templates select="../LIASSE/p2051DY"/>
      </tr>
      <tr>
        <th class="clCouleur2 clAlignLeft clThNonGras">&#160;Dettes sur immobilisations et cptes rattachs</th>
        <th class="clCouleur2 clAlignCenter clThNonGras">2051DZ</th>
        <xsl:apply-templates select="../LIASSE/p2051DZ"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Autres dettes</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2051EA</th>
        <xsl:apply-templates select="../LIASSE/p2051EA"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Produits constats d'avance</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2051EB</th>
        <xsl:apply-templates select="../LIASSE/p2051EB"/>
      </tr>
      <tr>
        <td class="clWidth265"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignCenter clThNonGras">&#160;TOTAL DES DETTES [IV]</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2051EC</th>
        <xsl:apply-templates select="../LIASSE/p2051EC"/>
      </tr>
      <tr>
        <td class="clWidth265"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Ecarts de conversion passif [V]</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2051ED</th>
        <xsl:apply-templates select="../LIASSE/p2051ED"/>
      </tr>
      <tr>
        <td class="clWidth265"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignCenter clThNonGras">&#160;TOTAL GNRAL PASSIF [I A V]</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2051EE</th>
        <xsl:apply-templates select="../LIASSE/p2051EE"/>
      </tr>
      <tr>
        <td class="clWidth265"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clItalic clWidth265 clAlignLeft clThNonGras">&#160;Renvois :</th>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth103 clValignBottom clAlignRight" rowspan="2">
          <a href="#ancHaut">
            <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page"/>
          </a>
        </td>
      </tr>
      <tr>
        <th class="clItalic clWidth265 clAlignLeft clThNonGras">&#160;Dettes et produits constats d'avance  - 1 an</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2051EG</th>
        <xsl:apply-templates select="../LIASSE/p2051EG"/>
      </tr>
      <tr>
        <th class="clItalic clWidth265 clAlignLeft clThNonGras">&#160;Concours bancaires courants, soldes crditeurs</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2051EH</th>
        <xsl:apply-templates select="../LIASSE/p2051EH"/>
      </tr>
      <tr>
        <th class="clItalic clWidth265 clAlignLeft clThNonGras">&#160;- Emprunts participatifs</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2051EI</th>
        <xsl:apply-templates select="../LIASSE/p2051EI"/>
      </tr>
    </table>
    <div class="clBreakPage"/>
    <xsl:call-template name="shim"/>
    <br/>
    <a name="resultat"/>
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr class="clAlignCenter">
        <td class="clCouleurGras">
          COMPTE DE RSULTAT<br/>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
    <table class="clWidth739 clBorderCell">
      <caption class="visually-hidden">COMPTE DE RSULTAT</caption>
      <tr>
        <td class="clWidth265 clCouleur2 clAlignCenter">&#160;</td>
        <td class="clWidth55"/>
        <xsl:apply-templates select="../LIASSE/@DATCLOT"/>
      </tr>
      <tr>
        <td class="clWidth265"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignCenter clThNonGras">PRODUITS D'EXPLOITATION</th>
        <td class="clWidth55"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Ventes de marchandises</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2052FC</th>
        <xsl:apply-templates select="../LIASSE/p2052FC"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Production vendue de biens</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2052FF</th>
        <xsl:apply-templates select="../LIASSE/p2052FF"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Production vendue de services</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2052FI</th>
        <xsl:apply-templates select="../LIASSE/p2052FI"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Chiffre d'affaires net France</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2052FJ</th>
        <xsl:apply-templates select="../LIASSE/p2052FJ"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Chiffre d'affaires net Export</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2052FK</th>
        <xsl:apply-templates select="../LIASSE/p2052FK"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Chiffre d'affaires net Total</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2052FL</th>
        <xsl:apply-templates select="../LIASSE/p2052FL"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Production stocke (+/-)</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2052FM</th>
        <xsl:apply-templates select="../LIASSE/p2052FM"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Production immobilise (+/-)</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2052FN</th>
        <xsl:apply-templates select="../LIASSE/p2052FN"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Subventions d'exploitation</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2052FO</th>
        <xsl:apply-templates select="../LIASSE/p2052FO"/>
      </tr>
      <tr>
        <th class="clCouleur2 clAlignLeft clThNonGras">&#160;Reprises s/amort. et prov. transf. de charges</th>
        <th class="clCouleur2 clAlignCenter clThNonGras">
          2052FP
        </th>
        <xsl:apply-templates select="../LIASSE/p2052FP"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Autres produits</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2052FQ</th>
        <xsl:apply-templates select="../LIASSE/p2052FQ"/>
      </tr>
      <tr>
        <td class="clWidth265"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignCenter clThNonGras">TOTAL DES PRODUITS D'EXPLOITATION [I]</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2052FR</th>
        <xsl:apply-templates select="../LIASSE/p2052FR"/>
      </tr>
      <tr>
        <td class="clWidth265"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignCenter clThNonGras">CHARGES D'EXPLOITATION</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">&#160;</th>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth103 clValignBottom clAlignRight" rowspan="7">
          <a href="#ancHaut">
            <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page"/>
          </a>
        </td>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Achat de marchandises</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2052FS</th>
        <xsl:apply-templates select="../LIASSE/p2052FS"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Variation de stock (marchandises)</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2052FT</th>
        <xsl:apply-templates select="../LIASSE/p2052FT"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">
          &#160;Achats matires premires et
          autres approv.
        </th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2052FU</th>
        <xsl:apply-templates select="../LIASSE/p2052FU"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">
          &#160;Variation stock (matires
          prem. et approv.)
        </th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2052FV</th>
        <xsl:apply-templates select="../LIASSE/p2052FV"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Autres achats et charges externes</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2052FW</th>
        <xsl:apply-templates select="../LIASSE/p2052FW"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Impts, taxes et versements assimils</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2052FX</th>
        <xsl:apply-templates select="../LIASSE/p2052FX"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Salaires et traitements</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2052FY</th>
        <xsl:apply-templates select="../LIASSE/p2052FY"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Charges sociales</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2052FZ</th>
        <xsl:apply-templates select="../LIASSE/p2052FZ"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Dotations d'exploitation :</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">&#160;</th>
        <td class="clTexte clWidth105 clAlignRight">
          &#160;
        </td>
        <td class="clTexte clWidth105 clAlignRight">
          &#160;
        </td>
        <td class="clTexte clWidth105 clAlignRight">
          &#160;
        </td>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Sur immobilisations</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">&#160;</th>
        <td class="clTexte clWidth105 clAlignRight">
          &#160;
        </td>
        <td class="clTexte clWidth105 clAlignRight">
          &#160;
        </td>
        <td class="clTexte clWidth105 clAlignRight">
          &#160;
        </td>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;&#160;Dotations aux amortissements</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2052GA</th>
        <xsl:apply-templates select="../LIASSE/p2052GA"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;&#160;Dotations aux provisions</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2052GB</th>
        <xsl:apply-templates select="../LIASSE/p2052GB"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Sur actif circulant : dotations aux provisions</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2052GC</th>
        <xsl:apply-templates select="../LIASSE/p2052GC"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Pour risques/charges : dotations aux prov.</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2052GD</th>
        <xsl:apply-templates select="../LIASSE/p2052GD"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Autres charges</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2052GE</th>
        <xsl:apply-templates select="../LIASSE/p2052GE"/>
      </tr>
      <tr>
        <td class="clWidth265"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignCenter clThNonGras">TOTAL CHARGES D'EXPLOITATION [II]</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2052GF</th>
        <xsl:apply-templates select="../LIASSE/p2052GF"/>
      </tr>
      <tr>
        <td class="clWidth265"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Bnfice attribu ou perte transfre [III]</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2052GH</th>
        <xsl:apply-templates select="../LIASSE/p2052GH"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Perte supporte ou bnfice transfr [V]</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2052GI</th>
        <xsl:apply-templates select="../LIASSE/p2052GI"/>
      </tr>
      <tr>
        <td class="clWidth265"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr class="clBreakPage">
        <th class="clWidth265 clCouleur2 clAlignCenter clThNonGras">PRODUITS FINANCIERS</th>
        <td class="clCouleur2 clWidth55 clAlignCenter">&#160;</td>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Produits financiers de participations</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2052GJ</th>
        <xsl:apply-templates select="../LIASSE/p2052GJ"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clHeight15 clThNonGras">
          &#160;Produits autres val. mob. et crances immo.
        </th>
        <th class="clCouleur2 clWidth55 clHeight15 clAlignCenter clThNonGras">
          2052GK
        </th>
        <xsl:apply-templates select="../LIASSE/p2052GK"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Autres interts et produits assimils</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2052GL</th>
        <xsl:apply-templates select="../LIASSE/p2052GL"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Reprises sur provisions et transfert charges</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2052GM</th>
        <xsl:apply-templates select="../LIASSE/p2052GM"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Diffrences positives de change</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2052GN</th>
        <xsl:apply-templates select="../LIASSE/p2052GN"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clHeight15 clAlignLeft clThNonGras">
          &#160;Produits nets cessions val. mob. placement
        </th>
        <th class="clCouleur2 clWidth55 clHeight15 clAlignCenter clThNonGras">
          2052GO
        </th>
        <xsl:apply-templates select="../LIASSE/p2052GO"/>
      </tr>
      <tr>
        <td class="clWidth265"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignCenter clThNonGras">TOTAL PRODUITS FINANCIERS [V]</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2052GP</th>
        <xsl:apply-templates select="../LIASSE/p2052GP"/>
      </tr>
      <tr>
        <td class="clWidth265"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignCenter clThNonGras">CHARGES FINANCIRES</th>
        <td class="clCouleur2 clWidth55 clAlignCenter">&#160;</td>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth103 clValignBottom clAlignRight" rowspan="2">
          <a href="#ancHaut">
            <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page"/>
          </a>
        </td>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Dotations financires aux amort. et prov.</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2052GQ</th>
        <xsl:apply-templates select="../LIASSE/p2052GQ"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Intrts et charges assimiles</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2052GR</th>
        <xsl:apply-templates select="../LIASSE/p2052GR"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Diffrences ngatives de change</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2052GS</th>
        <xsl:apply-templates select="../LIASSE/p2052GS"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Charges nettes cessions val. mob. placement</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2052GT</th>
        <xsl:apply-templates select="../LIASSE/p2052GT"/>
      </tr>
      <tr>
        <td class="clWidth265"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignCenter clThNonGras">TOTAL CHARGES FINANCIRES (VI)</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2052GU</th>
        <xsl:apply-templates select="../LIASSE/p2052GU"/>
      </tr>
      <tr>
        <td class="clWidth265"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignCenter clThNonGras">PRODUITS EXCEPTIONNELS</th>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Produits exceptionnels s/op. de gestion</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2053HA</th>
        <xsl:apply-templates select="../LIASSE/p2053HA"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Produits exceptionnels s/op. en capital</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2053HB</th>
        <xsl:apply-templates select="../LIASSE/p2053HB"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Reprises sur prov. et transfert de charges</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2053HC</th>
        <xsl:apply-templates select="../LIASSE/p2053HC"/>
      </tr>
      <tr>
        <td class="clWidth265"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignCenter clThNonGras">TOTAL PRODUITS EXCEPTIONNELS (VII)</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2053HD</th>
        <xsl:apply-templates select="../LIASSE/p2053HD"/>
      </tr>
      <tr>
        <td class="clWidth265"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignCenter clThNonGras">&#160;CHARGES EXCEPTIONNELLES</th>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Charges exceptionnelles s/op. de gestion</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2053HE</th>
        <xsl:apply-templates select="../LIASSE/p2053HE"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Charges exceptionnelles s/op. en capital</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2053HF</th>
        <xsl:apply-templates select="../LIASSE/p2053HF"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Dotations exceptionnelles amort. et prov.</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2053HG</th>
        <xsl:apply-templates select="../LIASSE/p2053HG"/>
      </tr>
      <tr>
        <td class="clWidth265"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignCenter clThNonGras">TOTAL CHARGES EXCEPTIONNELLES (VIII)</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2053HH</th>
        <xsl:apply-templates select="../LIASSE/p2053HH"/>
      </tr>
      <tr>
        <td class="clWidth265"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Participation des salaris (IX)</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2053HJ</th>
        <xsl:apply-templates select="../LIASSE/p2053HJ"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Impts sur les bnfices (X) (+/-)</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2053HK</th>
        <xsl:apply-templates select="../LIASSE/p2053HK"/>
      </tr>
      <tr>
        <td class="clWidth265"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignCenter clThNonGras">(A) TOTAL PRODUITS I+III+V+VII </th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2053HL</th>
        <xsl:apply-templates select="../LIASSE/p2053HL"/>
      </tr>
      <tr>
        <td class="clWidth265"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignCenter clThNonGras">(B) TOTAL CHARGES II+IV+VI+VIII+IX+X </th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2053HM</th>
        <xsl:apply-templates select="../LIASSE/p2053HM"/>
      </tr>
      <tr>
        <td class="clWidth265"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth103 clValignBottom clAlignRight" rowspan="2">
          <a href="#ancHaut">
            <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page"/>
          </a>
        </td>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignCenter clThNonGras">BENEFICE OU PERTE : (A) - (B) (+/-)</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2053HN</th>
        <xsl:apply-templates select="../LIASSE/p2053HN"/>
      </tr>
      <tr>
        <td class="clWidth265"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clItalic clWidth265 clAlignLeft clThNonGras">&#160;Renvois sur autres achats et charges externes</th>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clItalic clWidth265 clAlignLeft clThNonGras">&#160;&#160;Dont Crdit-bail mobilier</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2053HP</th>
        <xsl:apply-templates select="../LIASSE/p2053HP"/>
      </tr>
      <tr>
        <th class="clItalic clWidth265 clAlignLeft clThNonGras">&#160;&#160;Dont Crdit-bail immobilier</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2053HQ</th>
        <xsl:apply-templates select="../LIASSE/p2053HQ"/>
      </tr>
    </table>
    <div class="clBreakPage"/>
    <xsl:call-template name="shim"/>
    <br/>
    <a name="annexes"/>
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr class="clAlignCenter">
        <td class="clCouleurGras">
          ANNEXES - EXTRAITS 2054  2058<br/>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
    <table class="clWidth739 clBorderCell">
      <caption class="visually-hidden">ANNEXES - EXTRAITS 2054  2058</caption>
      <tr>
        <td class="clWidth265 clCouleur2 clAlignCenter">&#160;</td>
        <td class="clWidth55"/>
        <xsl:apply-templates select="../LIASSE/@DATCLOT"/>
      </tr>
      <tr>
        <td class="clWidth265 clCouleur2 clAlignCenter clHeight10"/>
        <td class="clWidth55 clHeight10"/>
        <td class="clWidth105 clHeight10"/>
        <td class="clWidth105 clHeight10"/>
        <td class="clWidth105 clHeight10"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignCenter clThNonGras clBoxSizing">IMMOBILISATIONS - AUGMENTATIONS</th>
        <td class="clWidth55"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter clBoxSizing"/>
        <td class="clWidth105 clBoxSizing"/>
        <td class="clWidth105 clBoxSizing"/>
        <td class="clWidth105 clBoxSizing"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clCouleur2 clAlignLeft clThNonGras">&#160;Frais d'tabl. &#38; de dvelop. (augment./acquis.)</th>
        <th class="clAlignCenter clCouleur2 clThNonGras">2054D9</th>
        <xsl:apply-templates select="../LIASSE/p2054D9"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Autres postes immobilisations incorporelles</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2054KF</th>
        <xsl:apply-templates select="../LIASSE/p2054KF"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Total immobilisations corporelles</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2054LP</th>
        <xsl:apply-templates select="../LIASSE/p2054LP"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Total immobilisations financires</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2054LS</th>
        <xsl:apply-templates select="../LIASSE/p2054LS"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignCenter clThNonGras">&#160;TOTAL</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">20540J</th>
        <xsl:apply-templates select="../LIASSE/p20540J"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignCenter clThNonGras">IMMOBILISATIONS - DIMINUTIONS</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">&#160;</th>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Autres immo. corp. : emballages rcuprables</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2054MW</th>
        <xsl:apply-templates select="../LIASSE/p2054MW"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Immobilisations corporelles en cours</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2054MY</th>
        <xsl:apply-templates select="../LIASSE/p2054MY"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Avances et acomptes</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2054NC</th>
        <xsl:apply-templates select="../LIASSE/p2054NC"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignCenter clThNonGras">&#160;TOTAL</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">20540K</th>
        <xsl:apply-templates select="../LIASSE/p20540K"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignCenter clThNonGras">AMORTISSEMENTS</th>
        <td class="clCouleur2 clWidth55 clAlignCenter">&#160;</td>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth103 clValignBottom clAlignRight" rowspan="5">
          <a href="#ancHaut">
            <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page"/>
          </a>
        </td>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Autres immo. corp. : emballages rcuprables</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2055QT</th>
        <xsl:apply-templates select="../LIASSE/p2055QT"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Total immo. amortissables (diminutions)</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">20550Q</th>
        <xsl:apply-templates select="../LIASSE/p20550Q"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Frais d'miss. d'emprunts  taler (augment.)</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2055CR2</th>
        <xsl:apply-templates select="../LIASSE/p2055CR2"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Primes remboursem. obligations (augment.)</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2055PR2</th>
        <xsl:apply-templates select="../LIASSE/p2055PR2"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignCenter clThNonGras">PROVISIONS INSCRITES AU BILAN</th>
        <td class="clCouleur2 clWidth55 clAlignCenter">&#160;</td>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Provisions pour pertes de change</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">20564W</th>
        <xsl:apply-templates select="../LIASSE/p20564W"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignCenter clThNonGras">REPRISES SUR PROVISIONS</th>
        <td class="clCouleur2 clWidth55 clAlignCenter">&#160;</td>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;D'exploitation</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2056UF</th>
        <xsl:apply-templates select="../LIASSE/p2056UF"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Financires</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2056UH</th>
        <xsl:apply-templates select="../LIASSE/p2056UH"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Exceptionnelles</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2056UK</th>
        <xsl:apply-templates select="../LIASSE/p2056UK"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr class="clBreakPage">
        <th class="clWidth265 clCouleur2 clAlignCenter clThNonGras">TAT DES CHANCES CRANCES ET DETTES</th>
        <td class="clCouleur2 clWidth55 clAlignCenter">&#160;</td>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Crances</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">&#160;</th>
        <td class="clWidth105"/>       
        <td class="clWidth105"/>        
        <td class="clWidth105"/>        
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Clients douteux ou litigieux</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2057VA</th>
        <xsl:apply-templates select="../LIASSE/p2057VA"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">
          &#160;&#160;Personnel et comptes
          rattachs
        </th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2057UY</th>
        <xsl:apply-templates select="../LIASSE/p2057UY"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Scurit sociale autres organismes sociaux</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2057UZ</th>
        <xsl:apply-templates select="../LIASSE/p2057UZ"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;tat et autres collectivits publiques </th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras"/>
        <td class="clWidth105 clAlignRight"/>
        <td class="clWidth105 clAlignRight"/>
        <td class="clWidth105 clAlignRight"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;&#160;T.V.A.</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2057VB</th>
        <xsl:apply-templates select="../LIASSE/p2057VB"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clHeight15 clAlignLeft clThNonGras">
          &#160;&#160;&#160;Autres impts taxes et versem. assimils
        </th>
        <th class="clCouleur2 clWidth55 clHeight15 clAlignCenter clThNonGras">
          2057VN
        </th>
        <xsl:apply-templates select="../LIASSE/p2057VN"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;&#160;Divers</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2057VP</th>
        <xsl:apply-templates select="../LIASSE/p2057VP"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Groupe et associs</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2057VC</th>
        <xsl:apply-templates select="../LIASSE/p2057VC"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Dettes</th>
        <td class="clCouleur2 clWidth55 clAlignCenter">&#160;</td>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Personnel et comptes rattachs</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">20578C</th>
        <xsl:apply-templates select="../LIASSE/p20578C"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">
          &#160;&#160;Scurit
          sociale autres organismes sociaux
        </th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">20578D</th>
        <xsl:apply-templates select="../LIASSE/p20578D"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">
          &#160;&#160;tat et autres
          collectivits publiques
        </th>
        <td class="clCouleur2 clWidth55 clAlignCenter"/>
        <td class="clWidth105 clAlignRight"/>
        <td class="clWidth105 clAlignRight"/>
        <td class="clWidth105 clAlignRight"/>
        <td class="clWidth103 clValignBottom clAlignRight" rowspan="4">
          <a href="#ancHaut">
            <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page"/>
          </a>
        </td>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;&#160;Impts sur les bnfices</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">20578E</th>
        <xsl:apply-templates select="../LIASSE/p20578E"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;&#160;T.V.A.</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2057VW</th>
        <xsl:apply-templates select="../LIASSE/p2057VW"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;&#160;Obligations cautionnes</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2057VX</th>
        <xsl:apply-templates select="../LIASSE/p2057VX"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clHeight15 clAlignLeft clThNonGras">
          &#160;&#160;&#160;Autres impts taxes et versem. assimils</th>
          <th class="clCouleur2 clWidth55 clHeight15 clAlignCenter clThNonGras">
            2057VQ</th>
            <xsl:apply-templates select="../LIASSE/p2057VQ"/>
          </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Groupe et associs</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2057VI</th>
        <xsl:apply-templates select="../LIASSE/p2057VI"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Total dettes, produits constats d'avance [X]</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2057VY</th>
        <xsl:apply-templates select="../LIASSE/p2057VY"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;&#160;A 1 an au plus</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2057VZ</th>
        <xsl:apply-templates select="../LIASSE/p2057VZ"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;&#160;A plus d'1 an et 5 ans au plus</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2057VZ3</th>
        <xsl:apply-templates select="../LIASSE/p2057VZ3"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;&#160;A plus de 5 ans</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2057VZ4</th>
        <xsl:apply-templates select="../LIASSE/p2057VZ4"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignCenter clThNonGras">RENSEIGNEMENTS DIVERS </th>
        <td class="clCouleur2 clWidth55 clAlignCenter">&#160;</td>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Tableau affectation exercice prcdent </th>
        <td class="clCouleur2 clWidth55 clAlignCenter">&#160;</td>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Report  nouveau bilan prcdent (+/-)</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">20580C</th>
        <xsl:apply-templates select="../LIASSE/p20580C"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Rsultat exercice prcdent (+/-)</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">20580D</th>
        <xsl:apply-templates select="../LIASSE/p20580D"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Prlvements sur rserves</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">20580E</th>
        <xsl:apply-templates select="../LIASSE/p20580E"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Affectations rserves </th>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;&#160;Rserve lgale</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2058ZB</th>
        <xsl:apply-templates select="../LIASSE/p2058ZB"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;&#160;Rserves spciales + plus value long terme</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2058ZC</th>
        <xsl:apply-templates select="../LIASSE/p2058ZC"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;&#160;Autres rserves</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2058ZD</th>
        <xsl:apply-templates select="../LIASSE/p2058ZD"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clHeight15 clAlignLeft clThNonGras">
          &#160;&#160;&#160;Rserves spciales av. incorp. au capital</th>
          <th class="clCouleur2 clWidth55 clHeight15 clAlignCenter clThNonGras">
            2058A5</th>
            <xsl:apply-templates select="../LIASSE/p2058A5"/>
          </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dividendes</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2058ZE</th>
        <xsl:apply-templates select="../LIASSE/p2058ZE"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Autres rpartitions </th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2058ZF</th>
        <xsl:apply-templates select="../LIASSE/p2058ZF"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Report  nouveau</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2058ZG</th>
        <xsl:apply-templates select="../LIASSE/p2058ZG"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Engagements de </th>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Crdit-bail mobilier</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2058YQ</th>
        <xsl:apply-templates select="../LIASSE/p2058YQ"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">
          &#160;&#160;Crdit-bail immobilier</th>
          <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2058YR</th>
          <xsl:apply-templates select="../LIASSE/p2058YR"/>
        </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Effets ports escompts non chus</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2058YS</th>
        <xsl:apply-templates select="../LIASSE/p2058YS"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Dtail des autres achats et charges externes</th>
        <td class="clCouleur2 clWidth55 clAlignCenter">&#160;</td>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth103 clValignBottom clAlignRight" rowspan="2">
          <a href="#ancHaut">
            <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page"/>
          </a>
        </td>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Sous-traitance</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2058YT</th>
        <xsl:apply-templates select="../LIASSE/p2058YT"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Personnel extrieur  l'entreprise</th>
        <td class="clCouleur2 clWidth55 clAlignCenter">2058YU</td>
        <xsl:apply-templates select="../LIASSE/p2058YU"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;TVA collecte</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2058YY</th>
        <xsl:apply-templates select="../LIASSE/p2058YY"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;TVA dductible sur biens et services</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2058YZ</th>
        <xsl:apply-templates select="../LIASSE/p2058YZ"/>
      </tr>
      <tr>
        <td class="clWidth265 clHeight10"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Effectif moyen du personnel</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">2058YP</th>
        <xsl:apply-templates select="../LIASSE/p2058YP"/>
      </tr>
    </table>
  </xsl:template>
  <xsl:template match="p2050AA|p2050AB|p2050AC|p2050CX|p2050CQ|p2050AF|p2050AG|p2050AH|p2050AI|p2050AJ|p2050AK|p2050AL|p2050AM|p2050AN|p2050AO|p2050AP|p2050AQ|p2050AR|p2050AS|p2050AT|p2050AU|p2050AV|p2050AW|p2050AX|p2050AY|p2050CS|p2050CT|p2050CU|p2050CV|p2050BB|p2050BC|p2050BD|p2050BE|p2050BF|p2050BG|p2050BH|p2050BI|p2050BL|p2050BM|p2050BN|p2050BO|p2050BP|p2050BQ|p2050BR|p2050BS|p2050BT|p2050BU|p2050BV|p2050BW|p2050BX|p2050BY|p2050BZ|p2050CA|p2050CB|p2050CC|p2050CD|p2050CE|p2050CF|p2050CG|p2050CH|p2050CI|p2050CW|p2050CM|p2050CN|p2050RE1|p2050CP|p2050CR|p2050RP1|p2050RP2|p2050RP3|p2051DA|p2051DB|p2051DC|p2051EK|p2051DD|p2051DE|p2051DF|p2051DG|p2051DH|p2051DI|p2051DJ|p2051DK|p2051DM|p2051DN|p2051DP|p2051DQ|p2051DS|p2051DT|p2051DU|p2051DV|p2051DW|p2051DX|p2051DY|p2051DZ|p2051EA|p2051EB|p2051ED|p2051EG|p2051EH|p2051EI|p2052FC|p2052FF|p2052FI|p2052FJ|p2052FK|p2052FL|p2052FM|p2052FN|p2052FO|p2052FP|p2052FQ|p2052FS|p2052FT|p2052FU|p2052FV|p2052FW|p2052FX|p2052FY|p2052FZ|p2052GA|p2052GB|p2052GC|p2052GD|p2052GE|p2052GH|p2052GI|p2052GJ|p2052GK|p2052GL|p2052GM|p2052GN|p2052GO|p2052GQ|p2052GR|p2052GS|p2052GT|p2053HA|p2053HB|p2053HC|p2053HE|p2053HF|p2053HG|p2053HJ|p2053HK|p2053HP|p2053HQ|p2054D9|p2054KF|p2054LP|p2054LS|p20540J|p2054MW|p2054MY|p2054NC|p20540K|p2055QT|p20550Q|p2055CR2|p2055PR2|p20564W|p2056UF|p2056UH|p2056UK|p2057VA|p2057UY|p2057UZ|p2057VB|p2057VN|p2057VP|p2057VC|p20578C|p20578D|p20578E|p2057VW|p2057VX|p2057VQ|p2057VI|p2057VY|p2057VZ|p2057VZ3|p2057VZ4|p20580C|p20580D|p20580E|p2058ZB|p2058ZC|p2058ZD|p2058A5|p2058ZE|p2058ZF|p2058ZG|p2058YQ|p2058YR|p2058YS|p2058YT|p2058YU|p2058YY|p2058YZ|p2058YP">
    <td class="clFond clWidth105 clAlignRight">
      <xsl:if test="@ETAT">
        <xsl:value-of select="@ETAT"/>&#160;
      </xsl:if>
      <xsl:if test="not(@ETAT)">
        <xsl:if test="contains(.,'-')=false">
          +<xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(.)"/>
          </xsl:call-template>&#160;
        </xsl:if>
        <xsl:if test="contains(.,'-')">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(.)"/>
          </xsl:call-template>&#160;
        </xsl:if>
      </xsl:if>
    </td>
    <xsl:if test="position()=last() and position()=1">
      <td class="clFond clWidth105 clAlignRight">&#160;</td>
      <td class="clFond clWidth105 clAlignRight">&#160;</td>
    </xsl:if>
    <xsl:if test="position()=last() and position()=2">
      <td class="clFond clWidth105 clAlignRight">&#160;</td>
    </xsl:if>
  </xsl:template>
  <xsl:template match="p2050BJ|p2050BK|p2050CJ|p2050CK|p2050CO|p20501A|p2051DL|p2051DO|p2051DR|p2051EC|p2051EE|p2052FR|p2052GF|p2052GP|p2052GU|p2053HD|p2053HH|p2053HL|p2053HM|p2053HN">
    <td class="clGrasFond clWidth105 clAlignRight">
      <xsl:if test="@ETAT">
        <xsl:value-of select="@ETAT"/>&#160;
      </xsl:if>
      <xsl:if test="not(@ETAT)">
        <xsl:if test="contains(.,'-')=false">
          +<xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(.)"/>
          </xsl:call-template>&#160;
        </xsl:if>
        <xsl:if test="contains(.,'-')">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(.)"/>
          </xsl:call-template>&#160;
        </xsl:if>
      </xsl:if>
    </td>
    <xsl:if test="position()=last() and position()=1">
      <td class="clFond clWidth105 clAlignRight">&#160;</td>
      <td class="clFond clWidth105 clAlignRight">&#160;</td>
    </xsl:if>
    <xsl:if test="position()=last() and position()=2">
      <td class="clFond clWidth105 clAlignRight">&#160;</td>
    </xsl:if>
  </xsl:template>
  <xsl:template match="HORSLIASSE">
    <a name="horsliasse"/>
    <div class="clBreakPage"/>
    <xsl:call-template name="shim"/>
    <br/>
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr class="clAlignCenter">
        <td class="clCouleurGras">
          DONNES COMPTABLES COMPLMENTAIRES HORS LIASSE FISCALE<br/>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
    <table class="clWidth739 clBorderCell">
      <caption class="visually-hidden">DONNES COMPTABLES COMPLMENTAIRES HORS LIASSE FISCALE</caption>
      <tr>
        <td class="clWidth265 clCouleur2 clAlignCenter">&#160;</td>
        <td class="clWidth55"/>
        <xsl:apply-templates select="../HORSLIASSE/@DATCLOT"/>
      </tr>
      <tr>
        <td class="clCouleur2 clHeight10 clAlignCenter"/>
        <td class="clHeight10"/>
        <td class="clWidth105"/>
        <td class="clHeight10"/>
        <td class="clHeight10"/>
      </tr>
      <tr>
        <td class="clWidth265"/>
        <td class="clWidth55 clAlignCenter"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Clients  l'tranger (extrait BX)</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">&#160;</th>
        <xsl:apply-templates select="../HORSLIASSE/pDC1"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Emballages et matriel  rendre (ext. BZ/VR)</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">&#160;</th>
        <xsl:apply-templates select="../HORSLIASSE/pDC3"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Emballages et matriel consigns (ext. EA/BK)</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">&#160;</th>
        <xsl:apply-templates select="../HORSLIASSE/pDC4"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">
          <p>&#160;Hors bilan</p>
        </th>
        <td class="clCouleur2 clWidth55 clAlignCenter">&#160;</td>
        <td class="clFond clWidth105 clAlignRight">&#160;</td>
        <td class="clFond clWidth105 clAlignRight">&#160;</td>
        <td class="clFond clWidth105 clAlignRight">&#160;</td>
      </tr>
      <tr>
        <th class="clCouleur2 clHeight10 clAlignLeft clThNonGras">&#160;&#160;Crances clients non chues - cession</th>
        <td class="clCouleur2 clHeight10 clAlignCenter"/>
        <td class="clFond clWidth105 clHeight10 clAlignRight">&#160;</td>
        <td class="clFond clWidth105 clHeight10 clAlignRight">&#160;</td>
        <td class="clFond clWidth105 clHeight10 clAlignRight">&#160;</td>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160; " Dailly "&#160;/ affact. -non comprises dans YS&#160;</th>
        <td class="clCouleur2 clWidth55 clAlignCenter">&#160;</td>
        <xsl:apply-templates select="../HORSLIASSE/pDC6"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Crances moyen terme sur tranger</th>
        <td class="clCouleur2 clWidth55 clAlignCenter"/>
        <td class="clFond clWidth105 clHeight10 clAlignRight">&#160;</td>
        <td class="clFond clWidth105 clHeight10 clAlignRight">&#160;</td>
        <td class="clFond clWidth105 clHeight10 clAlignRight">&#160;</td>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clHeight10 clAlignLeft clThNonGras">&#160;&#160;escompts non ch. non comprises dans YS&#160;&#160;</th>
        <td class="clCouleur2 clWidth55 clHeight10 clAlignCenter">
          &#160;
        </td>
        <xsl:apply-templates select="../HORSLIASSE/pDC7"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Crances clients s/ socit groupe (ext. BX)</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">&#160;</th>
        <xsl:apply-templates select="../HORSLIASSE/pDC8"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Dettes fourn. socits du groupe (ext. DX)</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">&#160;</th>
        <xsl:apply-templates select="../HORSLIASSE/pDC9"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Emprunts dettes financires divers - groupe</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">&#160;</th>
        <xsl:apply-templates select="../HORSLIASSE/pDC10"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clHeight15 clAlignLeft clThNonGras">
          &#160;Importations comprises dans achats exercice
        </th>
        <td class="clCouleur2 clWidth55 clHeight15 clAlignCenter">
          &#160;
        </td>
        <xsl:apply-templates select="../HORSLIASSE/pDC11"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Exportations comprises dans CA exercice</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">&#160;</th>
        <xsl:apply-templates select="../HORSLIASSE/pDC12"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Achats aux socits du groupe</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">&#160;</th>
        <xsl:apply-templates select="../HORSLIASSE/pDC13"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Ventes aux socits du groupe</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">&#160;</th>
        <xsl:apply-templates select="../HORSLIASSE/pDC14"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Oprations commissionnes TTC</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">&#160;</th>
        <xsl:apply-templates select="../HORSLIASSE/pDC15"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;TVA sur oprations commissionnes</th>
        <th class="clCouleur2 clWidth55 clAlignCenter clThNonGras">&#160;</th>
        <xsl:apply-templates select="../HORSLIASSE/pDC16"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clHeight15 clAlignLeft clThNonGras">&#160;Valeurs des biens en loc. financire et cb</th>
        <td class="clWidth55 clHeight15"/>
        <td class="clFond clWidth105 clHeight10 clAlignRight">&#160;</td>
        <td class="clFond clWidth105 clHeight10 clAlignRight">&#160;</td>
        <td class="clFond clWidth105 clHeight10 clAlignRight">&#160;</td>
        <td class="clWidth103 clValignBottom clAlignRight" rowspan="2">
          <a href="#ancHaut">
            <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page"/>
          </a>
        </td>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;mobilier utilis en fin d'exercice </th>
        <td class="clCouleur2 clWidth55 clAlignCenter">&#160;</td>
        <xsl:apply-templates select="../HORSLIASSE/pDC17"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Valeurs des biens en loc. financire et cb</th>
        <td class="clWidth55"/>
        <td class="clFond clWidth105 clHeight10 clAlignRight">&#160;</td>
        <td class="clFond clWidth105 clHeight10 clAlignRight">&#160;</td>
        <td class="clFond clWidth105 clHeight10 clAlignRight">&#160;</td>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;immobilier utilis en fin d'exercice</th>
        <td class="clCouleur2 clWidth55 clAlignCenter">&#160;</td>
        <xsl:apply-templates select="../HORSLIASSE/pDC18"/>
      </tr>
    </table>
  </xsl:template>
  <xsl:template match="pDC1|pDC3|pDC4|pDC5|pDC6|pDC7|pDC8|pDC9|pDC10|pDC11|pDC12|pDC13|pDC14|pDC15|pDC16|pDC17|pDC18">
    <td class="clFond clWidth105 clAlignRight">
      <xsl:if test="@ETAT">
        <xsl:value-of select="@ETAT"/>&#160;
      </xsl:if>
      <xsl:if test="not(@ETAT)">
        <xsl:if test="contains(.,'-')=false">
          +<xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(.)"/>
          </xsl:call-template>&#160;
        </xsl:if>
        <xsl:if test="contains(.,'-')">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(.)"/>
          </xsl:call-template>&#160;
        </xsl:if>
      </xsl:if>
    </td>
    <xsl:if test="position()=last() and position()=1">
      <td class="clFond clWidth105 clAlignRight">&#160;</td>
      <td class="clFond clWidth105 clAlignRight">&#160;</td>
    </xsl:if>
    <xsl:if test="position()=last() and position()=2">
      <td class="clFond clWidth105 clAlignRight">&#160;</td>
    </xsl:if>
  </xsl:template>
  <xsl:template match="AFFECTATION69">
    <a name="affectation"/>
    <div class="clBreakPage"/>
    <xsl:call-template name="shim"/>
    <br/>
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr class="clAlignCenter">
        <td class="clCouleurGras">
          AFFECTATION DU RSULTAT DE L'EXERCICE<br/>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
    <table class="clWidth635 clBorderCell">
      <caption class="visually-hidden">AFFECTATION DU RSULTAT DE L'EXERCICE</caption>
      <tr>
        <td class="clWidth265 clCouleur2 ">&#160;</td>
        <td class="clCouleur2 clWidth55 clAlignCenter">&#160;</td>
        <xsl:apply-templates select="../AFFECTATION69/@DATCLOT"/>
      </tr>
      <tr>
        <td class="clCouleur2 clHeight10"/>
        <td class="clCouleur2 clHeight10 clAlignCenter"/>
        <td class="clHeight10 clAlignRight"/>
        <td class="clHeight10 clAlignRight"/>
        <td class="clHeight10 clAlignRight"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Report  nouveau figurant au bilan (+/-)</th>
        <td class="clCouleur2 clWidth55 clAlignCenter">&#160;</td>
        <xsl:apply-templates select="../AFFECTATION69/p0CA"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Rsultat exercice (+/-)</th>
        <td class="clCouleur2 clWidth55 clAlignCenter">&#160;</td>
        <xsl:apply-templates select="../AFFECTATION69/p0DA"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Prlvement sur les rserves</th>
        <td class="clCouleur2 clWidth55 clAlignCenter">&#160;</td>
        <xsl:apply-templates select="../AFFECTATION69/p0EA"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clHeight10 clAlignLeft clThNonGras">&#160;Affectations aux rserves </th>
        <td class="clCouleur2 clWidth55 clHeight10 clAlignCenter">&#160;</td>
        <td class="clWidth105 clHeight10"/>
        <td class="clWidth105 clHeight10"/>
        <td class="clWidth105 clHeight10"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Rserve lgale</th>
        <td class="clCouleur2 clWidth55 clAlignCenter">&#160;</td>
        <xsl:apply-templates select="../AFFECTATION69/pZBA"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Rserve spciale + plus values long terme</th>
        <td class="clCouleur2 clWidth55 clAlignCenter">&#160;</td>
        <xsl:apply-templates select="../AFFECTATION69/pZCA"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Autres rserves</th>
        <td class="clCouleur2 clWidth55 clAlignCenter">&#160;</td>
        <xsl:apply-templates select="../AFFECTATION69/pZDA"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clHeight15 clAlignLeft clThNonGras">&#160;&#160;Rserves spc. av. incorporation au capital</th>
        <td class="clCouleur2 clWidth55 clHeight15 clAlignCenter">&#160;</td>
        <xsl:apply-templates select="../AFFECTATION69/pA5A"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Dividendes</th>
        <td class="clCouleur2 clWidth55 clAlignCenter">&#160;</td>
        <xsl:apply-templates select="../AFFECTATION69/pZEA"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Autres rpartitions</th>
        <td class="clCouleur2 clWidth55 clAlignCenter">&#160;</td>
        <xsl:apply-templates select="../AFFECTATION69/pZFA"/>
      </tr>
      <tr>
        <th class="clWidth265 clCouleur2 clAlignLeft clThNonGras">&#160;Report  nouveau</th>
        <td class="clCouleur2 clWidth55 clAlignCenter">&#160;</td>
        <xsl:apply-templates select="../AFFECTATION69/pZGA"/>
      </tr>
    </table>
  </xsl:template>
  <xsl:template match="@DATCLOT">
    <td class="clGrasFond clWidth105 clAlignRight">
      <xsl:call-template name="displayDateXsl">
        <xsl:with-param name="InputDate" select="(.)"/>
      </xsl:call-template>&#160;
    </td>
    <xsl:if test="position()=last() and position()=1">
      <td class="clFond clWidth105 clAlignRight">&#160;</td>
      <td class="clFond clWidth105 clAlignRight">&#160;</td>
    </xsl:if>
    <xsl:if test="position()=last() and position()=2">
      <td class="clFond clWidth105 clAlignRight">&#160;</td>
    </xsl:if>
  </xsl:template>
  <xsl:template match="@DUREEEX">
    <td class="clFond clWidth105 clAlignRight">
      <xsl:call-template name="displayDateXsl">
        <xsl:with-param name="InputDate" select="(.)"/>
      </xsl:call-template>&#160;
    </td>
    <xsl:if test="position()=last() and position()=1">
      <td class="clFond clWidth105 clAlignRight">&#160;</td>
      <td class="clFond clWidth105 clAlignRight">&#160;</td>
    </xsl:if>
    <xsl:if test="position()=last() and position()=2">
      <td class="clFond clWidth105 clAlignRight">&#160;</td>
    </xsl:if>
  </xsl:template>
  <xsl:template match="p0DA|p0CA|p0EA|pZBA|pZCA|pZDA|pA5A|pZEA|pZFA|pZGA">
    <td class="clFond clWidth105 clAlignRight">
      <xsl:if test="@ETAT">
        <xsl:value-of select="@ETAT"/>&#160;
      </xsl:if>
      <xsl:if test="not(@ETAT)">
        <xsl:if test="contains(.,'-')=false">
          +<xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(.)"/>
          </xsl:call-template>&#160;
        </xsl:if>
        <xsl:if test="contains(.,'-')">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(.)"/>
          </xsl:call-template>&#160;
        </xsl:if>
      </xsl:if>
    </td>
    <xsl:if test="position()=last() and position()=1">
      <td class="clFond clWidth105 clAlignRight">&#160;</td>
      <td class="clFond clWidth105 clAlignRight">&#160;</td>
    </xsl:if>
    <xsl:if test="position()=last() and position()=2">
      <td class="clFond clWidth105 clAlignRight">&#160;</td>
    </xsl:if>
  </xsl:template>
</xsl:stylesheet>
