<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:bdf="http://banque-france.fr/namespace">
	<xsl:import href="../../Ressources/XSL/Commun.xsl"/>
  <xsl:import href="../../Ressources/XSL/commun_transfo.xsl"/>
  <xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes"/>
	<xsl:param name="langage" select="'fr'"/>
	<xsl:param name="familyName" select="''"/>
  <xsl:param name="root" select="'/Fiben/'"/>
	<xsl:param name="familyNumber" select="''"/>
	<xsl:param name="familyTitle" select="''"/>
	<xsl:param name="nextModule" select="''"/>
	<xsl:param name="nextId" select="''"/>
	<xsl:param name="nextFamily" select="''"/>
  <xsl:param name="Lang" select="'FR'"/>
  <xsl:param name="NonResident" select="''"/>
	<xsl:param name="menuHTML1"/>
	
	<!-- graphe 60 -->
	<xsl:variable name="condGraph60" select="boolean(//DONNEESEXERCICE[position()=last()]) and not(boolean(//DONNEESEXERCICE[position()=last()]/p2050AA/@ETAT|//DONNEESEXERCICE[position()=last()]/pK00001/@ETAT|//DONNEESEXERCICE[position()=last()]/pK00021/@ETAT|//DONNEESEXERCICE[position()=last()]/pK00034/@ETAT|//DONNEESEXERCICE[position()=last()]/p2051CL/@ETAT|//DONNEESEXERCICE[position()=last()]/p2051CM/@ETAT|//DONNEESEXERCICE[position()=last()]/p2051CL/@ETAT|//DONNEESEXERCICE[position()=last()]/p2051DL/@ETAT|//DONNEESEXERCICE[position()=last()]/p2051DO/@ETAT|//DONNEESEXERCICE[position()=last()]/p2051DR/@ETAT|//DONNEESEXERCICE[position()=last()]/pK00041/@ETAT|//DONNEESEXERCICE[position()=last()]/p2051EB/@ETAT|//DONNEESEXERCICE[position()=last()]/p2051ED/@ETAT|//DONNEESEXERCICE[position()=last()]/pK00035/@ETAT))  and boolean(number(translate(//DONNEESEXERCICE[position()=last()]/p2051DO,',','.'))	+ 	number(translate(//DONNEESEXERCICE[position()=last()]/p2051DL,',','.'))>=0) and boolean(number(translate(//DONNEESEXERCICE[position()=last()]/pK00035,',','.'))!=0)"/>
	
	<!-- graphe 63 -->
	<xsl:variable name="condGraph63" select="not(boolean(//DONNEESFLUX[last()]/pK00209/@ETAT|//DONNEESFLUX[last()]/pK00235/@ETAT|//DONNEESFLUX[last()]/pK00234/@ETAT)) and (//DONNEESFLUX[last()]/pK00209 != 0 and //DONNEESFLUX[last()]/pK00235 != 0 and //DONNEESFLUX[last()]/pK00234 != 0) and (//DONNEESFLUX[last()]/pK00209 != '0,00' and //DONNEESFLUX[last()]/pK00235 != '0,00' and //DONNEESFLUX[last()]/pK00234 != '0,00') and (//DONNEESFLUX[last()]/pK00209 != '0,0' and //DONNEESFLUX[last()]/pK00235 != '0,0' and //DONNEESFLUX[last()]/pK00234 != '0,0')"/>
	
	<!-- graphe 62 -->
	<xsl:variable name="condGraph62_1" select="boolean(//DONNEESEXERCICE[1] and (not(boolean(//DONNEESEXERCICE[1]/p2053HN/@ETAT or //DONNEESEXERCICE[1]/pK00078/@ETAT or //DONNEESEXERCICE[1]/pK00218/@ETAT or //DONNEESEXERCICE[1]/pK00083/@ETAT))))"/>
	<xsl:variable name="condGraph62_2" select="boolean(//DONNEESEXERCICE[2] and (not(boolean(//DONNEESEXERCICE[2]/p2053HN/@ETAT or //DONNEESEXERCICE[2]/pK00078/@ETAT or //DONNEESEXERCICE[2]/pK00218/@ETAT or //DONNEESEXERCICE[2]/pK00083/@ETAT))))"/>
	<xsl:variable name="condGraph62_3" select="boolean(//DONNEESEXERCICE[3] and (not(boolean(//DONNEESEXERCICE[3]/p2053HN/@ETAT or //DONNEESEXERCICE[3]/pK00078/@ETAT or //DONNEESEXERCICE[3]/pK00218/@ETAT or //DONNEESEXERCICE[3]/pK00083/@ETAT))))"/>
	<xsl:variable name="condGraph62" select="$condGraph62_1 or $condGraph62_2 or $condGraph62_3"/>
	
	<!-- graphe 64 -->
	<xsl:variable name="isFirstAndLastDI" select="count(FIBEN/PERSONNE/MODULE68/DIFF68/DONNEESINDIVIDUELLES68)=1"/>
	
	<xsl:variable name="condGraph64_0" select="boolean(/FIBEN/PERSONNE/MODULE68/DIFF68/DONNEESSECTORIELLES68)"/>
	
	<xsl:variable name="condGraph64_11" select="not(boolean(//DONNEESINDIVIDUELLES68[1]/pK00285/@ETAT)) and  not(boolean(//DONNEESINDIVIDUELLES68[2]/pK00285/@ETAT)) and not(boolean(//DONNEESSECTORIELLES68/pK00285/@ETAT))"/>
	<xsl:variable name="condGraph64_12" select="not(boolean(//DONNEESINDIVIDUELLES68[1]/pK00289/@ETAT)) and  not(boolean(//DONNEESINDIVIDUELLES68[2]/pK00289/@ETAT)) and not(boolean(//DONNEESSECTORIELLES68/pK00289/@ETAT))"/>
	<xsl:variable name="condGraph64_13" select="not(boolean(//DONNEESINDIVIDUELLES68[1]/pK00293/@ETAT)) and  not(boolean(//DONNEESINDIVIDUELLES68[2]/pK00293/@ETAT)) and not(boolean(//DONNEESSECTORIELLES68/pK00293/@ETAT))"/>
	<xsl:variable name="condGraph64_14" select="not(boolean(//DONNEESINDIVIDUELLES68[1]/pK00295/@ETAT))and  not(boolean(//DONNEESINDIVIDUELLES68[2]/pK00295/@ETAT)) and not(boolean(//DONNEESSECTORIELLES68/pK00295/@ETAT))"/>
	<xsl:variable name="condGraph64_1" select="$condGraph64_0 and ($condGraph64_11 or $condGraph64_12 or $condGraph64_13 or $condGraph64_14)"/>
	
	<xsl:variable name="condGraph64_21" select="not(boolean(//DONNEESINDIVIDUELLES68[1]/pK00299/@ETAT)) and not(boolean(//DONNEESINDIVIDUELLES68[2]/pK00299/@ETAT)) and not(number(//DONNEESSECTORIELLES68/pK00299)>=100) and not(number(//DONNEESINDIVIDUELLES68[1]/pK00299)>=100) and not(number(//DONNEESINDIVIDUELLES68[2]/pK00299)>=100)"/>
	<xsl:variable name="condGraph64_22" select="not(boolean(//DONNEESINDIVIDUELLES68[1]/pK00074/@ETAT)) and not(boolean(//DONNEESINDIVIDUELLES68[2]/pK00074/@ETAT)) and not(number(//DONNEESSECTORIELLES68/pK00074)>=100) and not(number(//DONNEESINDIVIDUELLES68[1]/pK00074)>=100) and not(number(//DONNEESINDIVIDUELLES68[2]/pK00074)>=100)"/>
	<xsl:variable name="condGraph64_2" select="$condGraph64_0 and ($condGraph64_21 or $condGraph64_22)"/>
	
	<xsl:variable name="condGraph64_31" select="not(boolean(//DONNEESINDIVIDUELLES68[1]/pK00303/@ETAT)) and not(boolean(//DONNEESINDIVIDUELLES68[2]/pK00303/@ETAT)) and not(boolean(//DONNEESSECTORIELLES68/pK00303/@ETAT))"/>
	<xsl:variable name="condGraph64_32" select="not(boolean(//DONNEESINDIVIDUELLES68[1]/pK00304/@ETAT)) and not(boolean(//DONNEESINDIVIDUELLES68[2]/pK00304/@ETAT)) and not(boolean(//DONNEESSECTORIELLES68/pK00304/@ETAT))"/>
	<xsl:variable name="condGraph64_33" select="not(boolean(//DONNEESINDIVIDUELLES68[1]/pK00307/@ETAT)) and not(boolean(//DONNEESINDIVIDUELLES68[2]/pK00307/@ETAT)) and not(boolean(//DONNEESSECTORIELLES68/pK00307/@ETAT))"/>
	<xsl:variable name="condGraph64_34" select="not(boolean(//DONNEESINDIVIDUELLES68[1]/pK00308/@ETAT)) and not(boolean(//DONNEESINDIVIDUELLES68[2]/pK00308/@ETAT)) and not(boolean(//DONNEESSECTORIELLES68/pK00308/@ETAT))"/>
	<xsl:variable name="condGraph64_35" select="not(boolean(//DONNEESINDIVIDUELLES68[1]/pK00365/@ETAT)) and not(boolean(//DONNEESINDIVIDUELLES68[2]/pK00365/@ETAT)) and not(boolean(//DONNEESSECTORIELLES68/pK00365/@ETAT))"/>
	<xsl:variable name="condGraph64_3" select="$condGraph64_0 and ($condGraph64_31 or $condGraph64_32 or $condGraph64_33 or $condGraph64_34 or $condGraph64_35)"/>
	
	<xsl:variable name="condGraph64_41" select="not(boolean(//DONNEESINDIVIDUELLES68[1]/pK00311/@ETAT)) and not(boolean(//DONNEESINDIVIDUELLES68[2]/pK00311/@ETAT)) and not(boolean(//DONNEESSECTORIELLES68/pK00311/@ETAT))"/>
	<xsl:variable name="condGraph64_42" select="not(boolean(//DONNEESINDIVIDUELLES68[1]/pK00317/@ETAT)) and not(boolean(//DONNEESINDIVIDUELLES68[2]/pK00317/@ETAT)) and not(boolean(//DONNEESSECTORIELLES68/pK00317/@ETAT))"/>
	<xsl:variable name="condGraph64_43" select="not(boolean(//DONNEESINDIVIDUELLES68[1]/pK00320/@ETAT)) and not(boolean(//DONNEESINDIVIDUELLES68[2]/pK00320/@ETAT)) and not(boolean(//DONNEESSECTORIELLES68/pK00320/@ETAT))"/>
	<xsl:variable name="condGraph64_4" select="$condGraph64_0 and ($condGraph64_41 or $condGraph64_42 or $condGraph64_43)"/>
	
	<xsl:variable name="condGraph64_5" select="$condGraph64_0 and not(boolean(//DONNEESINDIVIDUELLES68[1]/pK00319/@ETAT))  and  not(boolean(//DONNEESINDIVIDUELLES68[2]/pK00319/@ETAT)) and not(boolean(//DONNEESSECTORIELLES68/pK00319/@ETAT))"/>
	
	<xsl:variable name="condGraph64" select="$condGraph64_0 and ($condGraph64_1 or $condGraph64_2 or $condGraph64_3 or $condGraph64_4 or $condGraph64_5)"/>
	
	<!-- ensemble des graphes -->
	<xsl:variable name="condGraph68" select="boolean($condGraph60 or $condGraph62 or $condGraph63 or $condGraph64)"/>
	
	<xsl:template match="/">
		<html lang="fr">
      <title>Module 68 - Dossier comptable et financier complet</title>
			<xsl:call-template name="genHead">
				<xsl:with-param name="ident" select="FIBEN/ERREUR/IDENT | FIBEN/PERSONNE/MODULE68/EJ/IDENTS"/>
			</xsl:call-template>
			<body class="clBodybgcolorWhite">
        <xsl:call-template name="genFondMenu">
          <xsl:with-param name="root" select="$root"/>
        </xsl:call-template>
        <xsl:copy-of select="$menuHTML1"/>
        
				<table class="mainmodule horizontal-auto clBorderCell">
          <caption class="visually-hidden">Module 68 - Dossier comptable et financier complet</caption>
          <xsl:call-template name="genLigneConfidentiel" />
					<xsl:apply-templates select="/FIBEN/ERREUR"/>
					<xsl:if test="not(/FIBEN/ERREUR)">
	
            <tr>
              <td class="clWidth14"></td>
							<td class="clCouleur2 clValignTop clWidth739" colspan="4">
								<xsl:apply-templates select="FIBEN/PERSONNE/MODULE68/EJ"/>
								<xsl:apply-templates select="FIBEN/PERSONNE/MODULE68/IST01|FIBEN/PERSONNE/MODULE68/IST02|FIBEN/PERSONNE/MODULE68/IST03|FIBEN/PERSONNE/MODULE68/IST04|FIBEN/PERSONNE/MODULE68/IST05" mode="genLib"/>
								<xsl:apply-templates select="FIBEN/PERSONNE/MODULE68/DIFF68"/>
							</td>
						</tr>
						
						
					</xsl:if>
				</table>
        <xsl:call-template name="genBasPage"/>
				<xsl:if test="$condGraph68">
					<xsl:call-template name="genGraph68">
						<xsl:with-param name="ident" select="/FIBEN/PERSONNE/MODULE68/EJ/IDENTS"/>
						<xsl:with-param name="nom" select="/FIBEN/PERSONNE/MODULE68/EJ/DENOM"/>
					</xsl:call-template>
				</xsl:if>

			</body>
		</html>
	</xsl:template>
	<xsl:template match="FIBEN/PERSONNE/MODULE68/EJ">
		<xsl:call-template name="genEnTete">
			<xsl:with-param name="ident" select="IDENTS"/>
			<xsl:with-param name="nom" select="DENOM"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template match="IST01|IST02|IST03|IST04|IST05" mode="genLib">
		<table class="clWidth635 clBorderCell" role="presentation">
			<tr class="clAlignLeft">
				<td class="clCouleur2">
					<xsl:apply-templates select="."/>
					<br/>
				</td>
			</tr>
		</table>
		<xsl:call-template name="shim"/>
		<br/>
	</xsl:template>
	<xsl:template match="DIFF68">
		<table class="clWidth635 clBorderCell">
      <caption class="visually-hidden">Information du dossier comptable</caption>
			<xsl:if test="@REGFIS">
				<tr>
					<th class="clCouleur2 clWidth150 clAlignLeft clThNonGras">&#160;Rgime fiscal</th>
					<td class="clFond clWidth300">&#160;<xsl:value-of select="@REGFIS"/>
					</td>
					<td class="clFond clWidth185">&#160;</td>
				</tr>
				<tr>
					<td class="clWidth105 clHeight14"/>
					<td class="clWidth300 clHeight14"/>
					<td class="clWidth185 clHeight14"/>
				</tr>
			</xsl:if>
			<tr>
				<th class="clCouleur2 clWidth150 clAlignLeft clThNonGras">&#160;Documents comptables</th>
				<td class="clFond clWidth300">&#160;COMPTES SOCIAUX</td>
				<td class="clCouleur2 clWidth185 clAlignRight">&#160;&#160;(exprims en
        <xsl:call-template name ="displayUnitXsl">
          <xsl:with-param name ="InputUnit" select ="(./@UNITE)"/>
        </xsl:call-template>
          euros)</td>
			</tr>
		</table>
		<xsl:call-template name="shim"/>
		<br/>
		<!-- Date de clture + Dure  -->
		<table class="clWidth635 clBorderCell">
      <caption class="visually-hidden">Information du dossier comptable</caption>
			<tr>
				<th class="clCouleur2 clHeight14 clAlignLeft clThNonGras">&#160;Date de clture</th>
				<xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/@DATCLOT"/>
			</tr>
			<tr>
				<th class="clCouleur2 clHeight14 clAlignLeft clThNonGras">&#160;Dure</th>
				<xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/@DUREEEX"/>
			</tr>
		</table>
		<!--
 ******************************************************************************************************************************************************************************************
 ******************************************************************************************************************************************************************************************
 
 ACTIF NET DTAILL (obligatoire)

******************************************************************************************************************************************************************************************
******************************************************************************************************************************************************************************************
 -->
		<a name="actif"/>
		<div class="clBreakPage"/>
		<xsl:call-template name="shim"/>
		<table class="clWidth635 clBorderCell" role="presentation">      
      <tr class="clAlignCenter">
				<td class="clCouleurGras">ACTIF NET DTAILL</td>
				 <td class="clWidth19">
					<xsl:if test="$condGraph60">
						<a href="#nullepart" onclick="window.document.forms['FormGraphes'].action='Graphes.aspx#Graphe1';window.document.forms['FormGraphes'].submit();">
							<img border="0" src="{$root}Images/risque/diagramme_bleu.gif" width="19" height="20" alt="lien vers diagramme"/>
						</a>
					</xsl:if>
					<xsl:if test="not($condGraph60)">
						<img border="0" src="{$root}Images/boutons/diagramme_in.gif" width="19" height="20" alt="diagramme non disponible"/>
					</xsl:if>
				</td>
			</tr>
		</table>
		<xsl:call-template name="shim"/>
		<br/>
		<table  class="clWidth739 clBorderCell">
       <caption class="visually-hidden">ACTIF NET DTAILL</caption>
			<tr>
				<th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;Date d'arrt</th>
				<xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/@DATCLOT"/>
			</tr>
			<xsl:call-template name="BreakLine310"/>
			<tr>
				<th class="clCouleur2 clWidth275 clAlignCenter clThNonGras">ACTIF</th>
				<td class="clWidth120" colspan="3"/>
			</tr>
			<xsl:call-template name="BreakLine310"/>
			<tr>
				<th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">Capital souscrit non appel</th>
				<xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2050AA">
					<xsl:with-param name="bold">Gras</xsl:with-param>
				</xsl:apply-templates>
			</tr>
			<xsl:call-template name="BreakLine310"/>
			<tr>
				<th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;ACTIF IMMOBILIS (1)</th>
				<xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00001">
					<xsl:with-param name="bold">Gras</xsl:with-param>
				</xsl:apply-templates>
			</tr>
			<xsl:call-template name="BreakLine32"/>
			<tr>
				<th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;&#160;Immobilisations incorporelles</th>
				<xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00005"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;&#160;&#160;Dont Frais d'tablissement</th>
				<xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00006"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;&#160;&#160;Dont Frais de dveloppement</th>
				<xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00007"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;&#160;&#160;Dont Fonds commercial</th>
				<xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00008"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;&#160;Immobilisations corporelles</th>
				<xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00011"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;&#160;Immobilisations financires (2)</th>
				<xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00015"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;&#160;&#160;Dont Participations</th>
				<xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00016"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;&#160;&#160;Dont Crances rattaches  des participations</th>
				<xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00017"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;&#160;&#160;Dont Autres titres immobiliss</th>
				<xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00018"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;&#160;&#160;Dont Prts</th>
				<xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00019"/>
			</tr>
			<xsl:call-template name="BreakLine310"/>
			<tr>
				<th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;ACTIF CIRCULANT (1)</th>
				<xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00021">
					<xsl:with-param name="bold">Gras</xsl:with-param>
				</xsl:apply-templates>
			</tr>
			<xsl:call-template name="BreakLine32"/>
			<tr>
				<th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;&#160;Stocks matires premires, approvisionnem.</th>
				<xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00022"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;&#160;Stocks en cours de production</th>
				<xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00023"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;&#160;Stocks produits intermdiaires et finis</th>
				<xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00024"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;&#160;Stocks marchandises</th>
				<xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00025"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;&#160;Avances et acomptes verss sur commande</th>
				<xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00027"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;&#160;Clients et comptes rattachs (3)</th>
				<xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00028"/>
				 <td class="clAlignRight">
					<a href="#ancHaut">
						<img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" alt="Retour en haut de la page"/>
					</a>
				</td>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth275 clHeight16 clAlignLeft clThNonGras">&#160;&#160;&#160;Dont douteux, litigieux non provisionns (3)</th>
				<xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00029"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;&#160;Autres crances (3)</th>
				<xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00030"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;&#160;&#160;Dont groupes et associs</th>
				<xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2057VC"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;&#160;Capital souscrit et appel, non vers</th>
				<xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00031"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;&#160;Valeurs mobilires de placement</th>
				<xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00032"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;&#160;Disponibilits</th>
				<xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00033"/>
			</tr>
			<xsl:call-template name="BreakLine310"/>
			<tr>
				<th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;Charges constates d'avance (1) (3)</th>
				<xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00034">
					<xsl:with-param name="bold">Gras</xsl:with-param>
				</xsl:apply-templates>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;Frais d'mission d'emprunts  taler</th>
				<xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2050CW">
					<xsl:with-param name="bold">Gras</xsl:with-param>
				</xsl:apply-templates>
			</tr>
			<xsl:call-template name="BreakLine310"/>
			<tr>
				<th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;Primes de remboursement des obligations</th>
				<xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2050CM">
					<xsl:with-param name="bold">Gras</xsl:with-param>
				</xsl:apply-templates>
			</tr>
			<xsl:call-template name="BreakLine310"/>
			<tr>
				<th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;carts de conversion actif</th>
				<xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2050CN">
					<xsl:with-param name="bold">Gras</xsl:with-param>
				</xsl:apply-templates>
			</tr>
			<xsl:call-template name="BreakLine310"/>
			<tr>
				<th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;TOTAL GNRAL</th>
				<xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00035">
					<xsl:with-param name="bold">Gras</xsl:with-param>
				</xsl:apply-templates>
			</tr>
			<xsl:call-template name="BreakLine310"/>
			<tr>
				<th class="clCouleur2 clWidth275 clAlignCenter clThNonGras">AUTRES ENGAGEMENTS</th>
				<td class="clWidth120" colspan="3"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;Clause de rserve de proprit sur immo.</th>
				<xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2050RP1">
					<xsl:with-param name="bold">Gras</xsl:with-param>
				</xsl:apply-templates>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;Clause de rserve de proprit sur stocks</th>
				<xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2050RP2">
					<xsl:with-param name="bold">Gras</xsl:with-param>
				</xsl:apply-templates>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;Clause de rserve de proprit sur crances</th>
				<xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2050RP3">
					<xsl:with-param name="bold">Gras</xsl:with-param>
				</xsl:apply-templates>
			</tr>
			<xsl:call-template name="BreakLine310"/>
			<tr>
				<th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;(1) aprs amortissements et provisions (total)</th>
				<xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p20501A">
					<xsl:with-param name="bold">Gras</xsl:with-param>
				</xsl:apply-templates>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;&#160;sur immobilisations incorporelles</th>
				<xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00004"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;&#160;sur immobilisations corporelles</th>
				<xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00010"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;&#160;sur immobilisations financires</th>
				<xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00014"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;&#160;sur actif circulant</th>
				<xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00055"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;&#160;sur charges constates d'avance</th>
				<xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2050CI"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;(2) dont part  moins d'un an</th>
				<xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2050CP"/>
				 <td class="clAlignRight">
					<a href="#ancHaut">
						<img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" alt="Retour en haut de la page"/>
					</a>
				</td>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;(3) dont part  plus d'un an (total)</th>
				<xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2050CR"/>
			</tr>
		</table>
		<!--
 ******************************************************************************************************************************************************************************************
 ******************************************************************************************************************************************************************************************
 
 PASSIF DTAILL (obligatoire)

******************************************************************************************************************************************************************************************
******************************************************************************************************************************************************************************************
 -->
		<a name="passif"/>
		<div class="clBreakPage"/>
		<xsl:call-template name="shim"/>
		<table class="clWidth635 clBorderCell" role="presentation">
			<tr class="clAlignCenter">
				<td class="clCouleurGras">PASSIF DTAILL</td>
				 <td class="clWidth19">
					<xsl:if test="$condGraph60">
						<a href="#nullepart" onclick="window.document.forms['FormGraphes'].action='Graphes.aspx#Graphe1';window.document.forms['FormGraphes'].submit();">
							<img border="0" src="{$root}Images/risque/diagramme_bleu.gif" width="19" height="20" alt="lien vers diagramme"/>
						</a>
					</xsl:if>
					<xsl:if test="not($condGraph60)">
						<img border="0" src="{$root}Images/boutons/diagramme_in.gif" width="19" height="20" alt="diagramme non disponible"/>
					</xsl:if>
				</td>
			</tr>
		</table>
		<xsl:call-template name="shim"/>
		<br/>	

    <table  class="clWidth739 clBorderCell">
      <caption class="visually-hidden">PASSIF DTAILL</caption>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;Date d'arrt</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/@DATCLOT"/>
      </tr>
      <xsl:call-template name="BreakLine310"/>
      <tr>
        <th class="clCouleur2 clWidth275 clAlignCenter clThNonGras">PASSIF</th>
        <td class="clWidth120" colspan="3"/>
      </tr>
      <xsl:call-template name="BreakLine310"/>
      <tr>
        <th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;CAPITAUX PROPRES</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2051DL">
          <xsl:with-param name="bold">Gras</xsl:with-param>
        </xsl:apply-templates>
      </tr>
      <xsl:call-template name="BreakLine32"/>
      <tr>
        <th class="clCouleur2 clWidth275  clHeight14 clAlignLeft clThNonGras">&#160;&#160;Capital social</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2051DA"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;&#160;Prime d'mission, de fusion, d'apport</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2051DB"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;&#160;carts de rvaluation et d'quivalence</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2051DC"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;&#160;Rserves</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00038"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;&#160;Report  nouveau</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2051DH"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;&#160;Rsultat de l'exercice</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2051DI"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;&#160;Subventions d'investissement</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2051DJ"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;&#160;Provisions rglementes</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2051DK"/>
      </tr>
      <xsl:call-template name="BreakLine310"/>
      <tr>
        <th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;AUTRES FONDS PROPRES</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2051DO">
          <xsl:with-param name="bold">Gras</xsl:with-param>
        </xsl:apply-templates>
      </tr>
      <xsl:call-template name="BreakLine32"/>
      <tr>
        <th class="clCouleur2 clWidth275 clAlignLeft clThNonGras clHeight15">&#160;&#160;Produits des missions de titres particip.</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2051DM"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clAlignLeft clThNonGras clHeight15">&#160;&#160;Avances conditionnes</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2051DN"/>
      </tr>
      <xsl:call-template name="BreakLine310"/>
      <tr>
        <th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;PROVISIONS POUR RISQUES ET CHARGES</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2051DR">
          <xsl:with-param name="bold">Gras</xsl:with-param>
        </xsl:apply-templates>
      </tr>
      <xsl:call-template name="BreakLine32"/>
      <tr>
        <th class="clCouleur2 clWidth275 clAlignLeft clThNonGras clHeight15">&#160;&#160;Provisions pour risques</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2051DP"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clAlignLeft clThNonGras clHeight15">&#160;&#160;Provisions pour charges</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2051DQ"/>
      </tr>
      <xsl:call-template name="BreakLine310"/>
      <tr>
        <th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;DETTES (1) (2)</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00041">
          <xsl:with-param name="bold">Gras</xsl:with-param>
        </xsl:apply-templates>
      </tr>
      <xsl:call-template name="BreakLine32"/>
      <tr>
        <th class="clCouleur2 clWidth275 clAlignLeft clThNonGras clHeight14">&#160;&#160;Dettes Financires</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00043"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;&#160;Emprunts obligataires convertibles</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2051DS"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;&#160;Autres emprunts obligataires</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2051DT"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;&#160;Emprunts et dettes auprs des tab. de crdit</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2051DU"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;&#160;&#160;Dont conc. banc. courants et soldes crditeurs</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2051EH"/>
        <td class="clAlignRight">
          <a href="#ancHaut">
            <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" alt="Retour en haut de la page"/>
          </a>
          </td>
        </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;&#160;Emprunts et dettes financires divers</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2051DV"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;&#160;&#160;Dont emprunts participatifs</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2051EI"/>
      </tr>
      <xsl:call-template name="BreakLine310"/>
      <tr>
        <th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;Avances et acomptes reus sur commandes</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2051DW"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;Dettes fournisseurs et comptes rattachs</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2051DX"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;Dettes fiscales et sociales</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2051DY"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;Dettes sur immo. et comptes rattachs</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2051DZ"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;Autres dettes</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2051EA"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;&#160;Dont Groupe et associs</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2057VI"/>
      </tr>
      <xsl:call-template name="BreakLine310"/>
      <tr>
        <th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;Produits constats d'avance (1) (2)</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2051EB">
          <xsl:with-param name="bold">Gras</xsl:with-param>
        </xsl:apply-templates>
      </tr>
      <xsl:call-template name="BreakLine310"/>
      <tr>
        <th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;carts de conversion passif</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2051ED">
          <xsl:with-param name="bold">Gras</xsl:with-param>
        </xsl:apply-templates>
      </tr>
      <xsl:call-template name="BreakLine310"/>
      <tr>
        <th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;TOTAL GNRAL</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2051EE">
          <xsl:with-param name="bold">Gras</xsl:with-param>
        </xsl:apply-templates>
      </tr>
      <xsl:call-template name="BreakLine310"/>
      <tr>
        <th class="clCouleur2 clWidth275 clAlignCenter clThNonGras">AUTRES ENGAGEMENTS</th>
        <td class="clWidth120" colspan="3"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;Effets escompts non chus</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2058YS">
          <xsl:with-param name="bold">Gras</xsl:with-param>
        </xsl:apply-templates>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;Autres crances cdes non chues</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00048">
          <xsl:with-param name="bold">Gras</xsl:with-param>
        </xsl:apply-templates>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;Engagements de crdit-bail</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00050">
          <xsl:with-param name="bold">Gras</xsl:with-param>
        </xsl:apply-templates>
      </tr>
      <xsl:call-template name="BreakLine310"/>
      <tr>
        <th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;(1) dont part  moins d'un an (total)</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2051EG">
          <xsl:with-param name="bold">Gras</xsl:with-param>
        </xsl:apply-templates>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;(2) dont part (hors avances et acomptes)</th>
        <td class="clWidth120" colspan="3"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;&#160;&#160; 1 an au plus</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2057VZ"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;&#160;&#160;de 1  5 ans</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2057VZ3"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;&#160;&#160; plus de 5 ans</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2057VZ4"/>
        <td class="clAlignRight">
          <a href="#ancHaut">
            <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" alt="Retour en haut de la page"/>
          </a>
          </td>
        </tr>
    </table>
    
    
		<!--  ******************************************************************************************************************************************************************************************
 ******************************************************************************************************************************************************************************************
 
 ACTIVIT ET RSULTAT (obligatoire)

******************************************************************************************************************************************************************************************
******************************************************************************************************************************************************************************************
 -->
		<a name="activite"/>
		<div class="clBreakPage"/>
		<xsl:call-template name="shim"/>
		<table class="clWidth635 clBorderCell" role="presentation">
			<tr class="clAlignCenter">
				<td class="clCouleurGras">ACTIVIT ET RSULTAT</td>
				 <td class="clWidth19">
					<xsl:if test="$condGraph62">
						<a href="#nullepart" onclick="window.document.forms['FormGraphes'].action='Graphes.aspx#Graphe3';window.document.forms['FormGraphes'].submit();">
							<img border="0" src="{$root}Images/risque/diagramme_bleu.gif" width="19" height="20" alt="lien vers diagramme"/>
						</a>
					</xsl:if>
					<xsl:if test="not($condGraph62)">
						<img border="0" src="{$root}Images/boutons/diagramme_in.gif" width="19" height="20" alt="diagramme non disponible"/>
					</xsl:if>
				</td>
			</tr>
		</table>
		<xsl:call-template name="shim"/>
		<br/>
    <table  class="clWidth739 clBorderCell">
      <caption class="visually-hidden">ACTIVIT ET RSULTAT</caption>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;Date d'arrt</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/@DATCLOT"/>
      </tr>
      <xsl:call-template name="BreakLine310"/>
      <tr>
        <th class="clCouleur2 clWidth275 clAlignCenter clThNonGras">ACTIVIT </th>
        <td class="clWidth120" colspan="3"/>
      </tr>
      <xsl:call-template name="BreakLine310"/>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;Effectif moyen du personnel</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2058YP"/>
      </tr>
      <xsl:call-template name="BreakLine310"/>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;Achats et sous-traitance HT</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00059"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;Chiffre d'affaires HT</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2052FL"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;&#160;&#160;France</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2052FJ"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;&#160;&#160;Exportation</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2052FK"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;Ventes non comptab. (ventes  la commission)</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00061"/>
      </tr>
      <xsl:call-template name="BreakLine310"/>
      <tr>
        <th class="clCouleur2 clWidth275 clAlignCenter clThNonGras">RSULTAT </th>
        <td class="clWidth120" colspan="3"/>
      </tr>
      <xsl:call-template name="BreakLine310"/>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;Ventes de marchandises</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2052FC"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;- cot d'achat des marchandises vendues</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00062"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;Achats de marchandises</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2052FS"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;Variation de stock (Marchandises)</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2052FT"/>
      </tr>
      <xsl:call-template name="BreakLine32"/>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;= MARGE COMMERCIALE</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00063">
          <xsl:with-param name="bold">Gras</xsl:with-param>
        </xsl:apply-templates>
      </tr>
      <xsl:call-template name="BreakLine310"/>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;Production vendue</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00064"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;+ Production stocke</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2052FM"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;+ Production immobilise</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2052FN"/>
      </tr>
      <xsl:call-template name="BreakLine32"/>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;= PRODUCTION DE L'EXERCICE</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00065">
          <xsl:with-param name="bold">Gras</xsl:with-param>
        </xsl:apply-templates>
      </tr>
      <xsl:call-template name="BreakLine310"/>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;Marge commerciale</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00063"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;+ production de l'exercice</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00065"/>
        <td class="clAlignRight">
          <a href="#ancHaut">
            <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" alt="Retour en haut de la page"/>
          </a>
          </td>
        </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;- consommation exercice en proven. des tiers</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00067"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;Achats de mat. premires et autres appro.</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2052FU"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;Var. de stock (mat. premires et appro)</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2052FV"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;Autres achats et charges externes</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2052FW"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;&#160;&#160;Dont Sous-traitance</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2058YT"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;&#160;&#160;Dont Personnel extrieur</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2058YU"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;&#160;&#160;Dont Crdit-bail (redevances)</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00052"/>
      </tr>
      <xsl:call-template name="BreakLine32"/>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;= VALEUR AJOUTE</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00068">
          <xsl:with-param name="bold">Gras</xsl:with-param>
        </xsl:apply-templates>
      </tr>
      <xsl:call-template name="BreakLine310"/>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;Valeur ajoute</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00068"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;+ Subventions d'exploitation</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2052FO"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;- Impts et taxes et versements assimils</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2052FX"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;- Charges de personnel</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00073"/>
      </tr>
      <xsl:call-template name="BreakLine32"/>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;= EXCDENT BRUT D'EXPLOITATION</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00075">
          <xsl:with-param name="bold">Gras</xsl:with-param>
        </xsl:apply-templates>
      </tr>
      <xsl:call-template name="BreakLine310"/>
      <tr class="clBreakPage">
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;Excdent brut d'exploitation</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00075"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;&#160;+ reprise/amort. prov. transf. charg. d'exploit.</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2052FP"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;&#160;+ autres produits d'exploitation</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2052FQ"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;&#160;- dotations amort. et prov. d'exploitation</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00077"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;&#160;- autres charges d'exploitation</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2052GE"/>
      </tr>
      <xsl:call-template name="BreakLine32"/>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;= RSULTAT D'EXPLOITATION</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00078">
          <xsl:with-param name="bold">Gras</xsl:with-param>
        </xsl:apply-templates>
      </tr>
      <xsl:call-template name="BreakLine310"/>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;Produits financiers</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2052GP"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;- Charges financires</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2052GU"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;&#160;Dont Intrts et charges assimiles</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2052GR"/>
      </tr>
      <xsl:call-template name="BreakLine32"/>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;= RSULTAT FINANCIER</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00082">
          <xsl:with-param name="bold">Gras</xsl:with-param>
        </xsl:apply-templates>
      </tr>
      <xsl:call-template name="BreakLine310"/>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;Rsultat d'exploitation</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00078"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;+/-quote-part rsultat sur op. en commun</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00080"/>
        <td class="clAlignRight">
          <a href="#ancHaut">
            <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" alt="Retour en haut de la page"/>
          </a>
          </td>
        </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;+ Rsultat financier</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00082"/>
      </tr>
      <xsl:call-template name="BreakLine32"/>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;= RSULTAT COURANT AVANT IMPTS</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00083">
          <xsl:with-param name="bold">Gras</xsl:with-param>
        </xsl:apply-templates>
      </tr>
      <xsl:call-template name="BreakLine310"/>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160; Produits exceptionnels</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2053HD"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;- Charges exceptionnelles</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2053HH"/>
      </tr>
      <xsl:call-template name="BreakLine32"/>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;= RSULTAT EXCEPTIONNEL</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00085">
          <xsl:with-param name="bold">Gras</xsl:with-param>
        </xsl:apply-templates>
      </tr>
      <xsl:call-template name="BreakLine310"/>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;Rsultat courant avant impts</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00083"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;+ Rsultat exceptionnel</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00085"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;- Participation des salaris</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2053HJ"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;- Impts sur les bnfices</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2053HK"/>
      </tr>
      <xsl:call-template name="BreakLine32"/>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;= RSULTAT DE L'EXERCICE</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2053HN">
          <xsl:with-param name="bold">Gras</xsl:with-param>
        </xsl:apply-templates>
      </tr>
      <xsl:call-template name="BreakLine310"/>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;CAPACIT D'AUTOFINANCEMENT</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00218">
          <xsl:with-param name="bold">Gras</xsl:with-param>
        </xsl:apply-templates>
      </tr>
    </table>
		<!--
 ******************************************************************************************************************************************************************************************
 ******************************************************************************************************************************************************************************************
 
 TABLEAU DES FLUX (obligatoire)

******************************************************************************************************************************************************************************************
******************************************************************************************************************************************************************************************
 -->
		<a name="flux"/>
		<div class="clBreakPage"/>
		<xsl:call-template name="shim"/>
		<table class="clWidth635 clBorderCell" role="presentation">
			<tr class="clAlignCenter">
				<td class="clCouleurGras">TABLEAU DES FLUX</td>
				 <td class="clWidth19">
					<xsl:if test="$condGraph63">
						<a href="#nullepart" onclick="window.document.forms['FormGraphes'].action='Graphes.aspx#Graphe2';window.document.forms	['FormGraphes'].submit();">
							<img border="0" src="{$root}Images/risque/diagramme_bleu.gif" width="19" height="20" alt="lien vers diagramme"/>
						</a>
					</xsl:if>
					<xsl:if test="not($condGraph63)">
						<img border="0" src="{$root}Images/boutons/diagramme_in.gif" width="19" height="20" alt="diagramme non disponible"/>
					</xsl:if>
				</td>
			</tr>
		</table>
		<xsl:call-template name="shim"/>
		<br/>
		<!--<table  class="clWidth739 clBorderCell">
      <caption class="visually-hidden">TABLEAU DES FLUX</caption>
      <xsl:variable name ="valeur1erCaractFlux1" select ="../DIFF68/DONNEESFLUX[1]/pK00235"></xsl:variable>
      <xsl:variable name ="valeur1erCaractFlux2" select ="../DIFF68/DONNEESFLUX[2]/pK00235"></xsl:variable>     
			<tr>
				<td class="clCouleur2 clWidth395 clHeight15">&#160;Date d'arrt</td>
        <td class="clGrasFond clWidth120 clAlignRight">
          <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="(../DIFF68/DONNEESFLUX[1]/@DATCLOT)"/>
          </xsl:call-template>&#160;
        </td>
				<xsl:if test="../DIFF68/DONNEESFLUX[2]">
					<td class="clGrasFond clWidth120 clAlignRight">
            <xsl:call-template name ="displayDateXsl">
              <xsl:with-param name ="InputDate" select ="(../DIFF68/DONNEESFLUX[2]/@DATCLOT)"/>
            </xsl:call-template>&#160;
					</td>
				</xsl:if>
				<xsl:if test="not(../DIFF68/DONNEESFLUX[2])">
					<td class="clGrasFond clWidth120 clAlignRight">&#160;</td>
				</xsl:if>
			</tr>
			<xsl:call-template name="BreakLine210"/>
			<tr>
				<td class="clCouleur2 clWidth395 clAlignCenter">FORMATION DE LA TRSORERIE </td>
				<td class="clWidth120" colspan="2"/>
			</tr>
			<xsl:call-template name="BreakLine210"/>
			<tr>
				<td class="clCouleur2 clWidth395 clHeight14">&#160;Excdent brut d'exploitation</td>
				<td class="clFond clWidth120 clAlignRight">
					<xsl:if test="@ETAT">
						<xsl:value-of select="@ETAT"/>&#160;
					</xsl:if>
					<xsl:if test="not(@ETAT)">
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../DIFF68/DONNEESFLUX[1]/pK00075)"/>
            </xsl:call-template>&#160;
					</xsl:if>
				</td>
				<xsl:if test="../DIFF68/DONNEESFLUX[2]">
					<td class="clFond clWidth120 clAlignRight">
						<xsl:if test="@ETAT">
							<xsl:value-of select="@ETAT"/>&#160;
						</xsl:if>
						<xsl:if test="not(@ETAT)">
              <xsl:call-template name ="displayNumberXsl">
                <xsl:with-param name ="InputStringNumber" select ="(../DIFF68/DONNEESFLUX[2]/pK00075)"/>
              </xsl:call-template>&#160;
						</xsl:if>
					</td>
				</xsl:if>
				<xsl:if test="not(../DIFF68/DONNEESFLUX[2])">
					<td class="clFond clWidth120 clAlignRight">&#160;</td>
				</xsl:if>
			</tr>
			<tr>
				<td class="clCouleur2 clWidth395 clHeight14">&#160;- Variation du BFR d'exploitation (1)</td>
				<xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00204"/>
			</tr>
			<xsl:call-template name="BreakLine22"/>
			<tr>
				<td class="clCouleur2 clWidth395 clHeight14">&#160;= EXCDENT DE TRSORERIE D'EXPLOITATION</td>
				<xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00249">
					<xsl:with-param name="bold">Gras</xsl:with-param>
				</xsl:apply-templates>
			</tr>
			<xsl:call-template name="BreakLine210"/>
			<tr>
				<td class="clCouleur2 clWidth395 clHeight14">&#160;Excdent de trsorerie d'exploitation</td>
				<xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00249"/>
			</tr>
			<tr>
				<td class="clCouleur2 clWidth395 clHeight14">&#160;+ Produits et charges hors exploitation</td>
				<xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00260"/>
			</tr>
			<tr>
				<td class="clCouleur2 clWidth395 clHeight14">&#160;- Variation du BFR hors exploitation</td>
				<xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00208"/>
			</tr>
			<xsl:call-template name="BreakLine22"/>
			<tr>
				<td class="clCouleur2 clWidth395 clHeight14">&#160;= EXCDENT DE TRSORERIE GLOBALE</td>
				<xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00261">
					<xsl:with-param name="bold">Gras</xsl:with-param>
				</xsl:apply-templates>
				 <td class="clAlignRight">
					<a href="#ancHaut">
						<img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" alt="Retour en haut de la page"/>
					</a>
				</td>
			</tr>
			<xsl:call-template name="BreakLine210"/>
			<tr>
				<td class="clCouleur2 clWidth395 clHeight14">&#160;Excdent de trsorerie globale</td>
				<xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00261"/>
			</tr>
			<tr>
				<td class="clCouleur2 clWidth395 clHeight14">&#160;- Intrts et charges assimiles</td>
				<xsl:apply-templates select="../DIFF68/DONNEESFLUX/p2052GR" mode="genDF"/>
			</tr>
			<tr>
				<td class="clCouleur2 clWidth395 clHeight14">&#160;- Impts sur les bnfices</td>
				<xsl:apply-templates select="../DIFF68/DONNEESFLUX/p2053HK" mode="genDF"/>
			</tr>
			<tr>
				<td class="clCouleur2 clWidth395 clHeight14">&#160;- Distribution mise en paiement</td>
				<xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00087"/>
			</tr>
			<xsl:call-template name="BreakLine22"/>
			<tr>
				<td class="clCouleur2 clWidth395 clHeight14">&#160;= FLUX DE TRSORERIE AV. REMB. D'EMPRUNTS</td>
				<xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00262">
					<xsl:with-param name="bold">Gras</xsl:with-param>
				</xsl:apply-templates>
			</tr>
			<xsl:call-template name="BreakLine22"/>
			<tr>
				<td class="clItalic clWidth395 clHeight2">(1) y compris " effets escompts non chus "</td>
				<td class="clWidth120" colspan="2"/>
			</tr>
			<xsl:call-template name="BreakLine210"/>
			<tr>
				<td class="clCouleur2 clWidth395 clHeight14">&#160;Flux de trsorerie av. remboursement d'emprunts</td>
				<xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00262"/>
			</tr>
			<tr>
				<td class="clCouleur2 clWidth395 clHeight14">&#160;- Investissement nets de cession</td>
				<xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00267"/>
			</tr>
			<tr>
				<td class="clCouleur2 clWidth395 clHeight14">&#160;+ Variation des emprunts bancaires</td>
				<xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00363"/>
			</tr>
			<tr>
				<td class="clCouleur2 clWidth395 clHeight14">&#160;+ Variation des autres ressources stables</td>
				<xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00364"/>
			</tr>
			<xsl:call-template name="BreakLine22"/>
			<tr>
				<td class="clCouleur2 clWidth395 clHeight14">&#160;= VARIATION DE TRSORERIE</td>
				<xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00234">
					<xsl:with-param name="bold">Gras</xsl:with-param>
				</xsl:apply-templates>
			</tr>
			<xsl:call-template name="BreakLine210"/>
			<tr>
				<td class="clCouleur2 clWidth395 clHeight14">&#160;Variation des disponibilits et des VMP</td>
				<xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00211"/>
			</tr>
			<tr>
				<td class="clCouleur2 clWidth395 clHeight14">&#160;- Variation des crdits de trsorerie (2)</td>
				<xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00889"/>
			</tr>
			<xsl:call-template name="BreakLine22"/>
			<tr>
				<td class="clCouleur2 clWidth395 clHeight14">&#160;= VARIATION DE TRSORERIE</td>
				<xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00234">
					<xsl:with-param name="bold">Gras</xsl:with-param>
				</xsl:apply-templates>
			</tr>
			<xsl:call-template name="BreakLine22"/>
			<tr>
				<td class="clItalic clWidth395 clHeight2">(2) y compris " effets escompts non chus " et billets de trsorerie ventuels</td>
				<td class="clWidth120" colspan="2"/>
			</tr>
			<xsl:call-template name="BreakLine210"/>
			<tr class="clBreakPage">
				<td class="clCouleur2 clWidth395 clAlignCenter">CALCUL DE LA VARIATION DU FRNG</td>
				<td class="clWidth120" colspan="2"/>
			</tr>
			<xsl:call-template name="BreakLine210"/>
			<tr>
				<td class="clCouleur2 clWidth395 clHeight14">&#160;Capacit d'autofinancement</td>
				<xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00218" mode="genDF"/>
			</tr>
			<tr>
				<td class="clCouleur2 clWidth395 clHeight14">&#160;+ Cessions ou rductions d'immobilisations</td>
				<xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00223"/>
			</tr>
			<tr>
				<td class="clCouleur2 clWidth395 clHeight14">&#160;+ Variation positive des fonds propres</td>
				<xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00225"/>
			</tr>
			<tr>
				<td class="clCouleur2 clWidth395 clHeight14">&#160;+ Variation positive des dettes financires</td>
				<xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00227"/>
			</tr>
			<xsl:call-template name="BreakLine22"/>
			<tr>
				<td class="clCouleur2 clWidth395 clHeight14">&#160;= TOTAL DES RESSOURCES (A)</td>
				<xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00228">
					<xsl:with-param name="bold">Gras</xsl:with-param>
				</xsl:apply-templates>
			</tr>
			<xsl:call-template name="BreakLine210"/>
			<tr>
				<td class="clCouleur2 clWidth395 clHeight14">&#160;Distribution mise en paiement</td>
				<xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00087"/>
				 <td class="clAlignRight">
					<a href="#ancHaut">
						<img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" alt="Retour en haut de la page"/>
					</a>
				</td>
			</tr>
			<tr>
				<td class="clCouleur2 clWidth395 clHeight14">&#160;+ Acquisitions d'immobilisations</td>
				<xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00188"/>
			</tr>
			<tr>
				<td class="clCouleur2 clWidth395 clHeight14">&#160;+ Variation ngative des fonds propres</td>
				<xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00229"/>
			</tr>
			<tr>
				<td class="clCouleur2 clWidth395 clHeight14">&#160;+ Variation ngative des dettes financires</td>
				<xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00230"/>
			</tr>
			<tr>
				<td class="clCouleur2 clWidth395 clHeight14">&#160;+ Augmentation des frais d'mission d'emprunts  taler</td>
				<xsl:apply-templates select="../DIFF68/DONNEESFLUX/p2055CR2"/>
			</tr>
			<xsl:call-template name="BreakLine22"/>
			<tr>
				<td class="clCouleur2 clWidth395 clHeight14">&#160;= TOTAL DES EMPLOIS (B)</td>
				<xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00231">
					<xsl:with-param name="bold">Gras</xsl:with-param>
				</xsl:apply-templates>
			</tr>
			<xsl:call-template name="BreakLine210"/>
			<tr>
				<td class="clCouleur2 clWidth395 clHeight14">&#160;DIVERS ET AJUSTEMENTS</td>
				<xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00237">
					<xsl:with-param name="bold">Gras</xsl:with-param>
				</xsl:apply-templates>
			</tr>
			<xsl:call-template name="BreakLine210"/>
			<tr>
				<td class="clCouleur2 clWidth395 clHeight14">&#160;Variation du FRNG (A - B + divers)</td>
				<td class="clFond clWidth120" colspan="2"/>
			</tr>
			<tr>
				<td class="clCouleur2 clWidth395 clHeight14">&#160;EMPLOI NET</td>
        <xsl:if test ="substring($valeur1erCaractFlux1,1,1) = '-'">				
					<td class="clGrasFond clWidth120 clAlignRight">
						<xsl:if test="@ETAT">
							<xsl:value-of select="@ETAT"/>
						</xsl:if>
						<xsl:if test="not(@ETAT)">
              <xsl:call-template name ="displayNumberXsl">
                <xsl:with-param name ="InputStringNumber" select ="(../DIFF68/DONNEESFLUX[1]/pK00235)"/>
              </xsl:call-template>							
						</xsl:if>
					</td>
				</xsl:if>
        <xsl:if test="not(substring($valeur1erCaractFlux1,1,1) = '-')">				
					<td class="clGrasFond clWidth120 clAlignRight">&#160;</td>
				</xsl:if>
				<xsl:if test="count(../DIFF68/DONNEESFLUX/pK00235)=2">
          <xsl:if test ="substring($valeur1erCaractFlux2,1,1) = '-'">					
						<td class="clGrasFond clWidth120 clAlignRight">
							<xsl:if test="@ETAT">
								<xsl:value-of select="@ETAT"/>
							</xsl:if>
							<xsl:if test="not(@ETAT)">
                <xsl:call-template name ="displayNumberXsl">
                  <xsl:with-param name ="InputStringNumber" select ="(../DIFF68/DONNEESFLUX[2]/pK00235)"/>
                </xsl:call-template>							
							</xsl:if>
						</td>
					</xsl:if>
				</xsl:if>
        <xsl:if test="count(../DIFF68/DONNEESFLUX/pK00235)=1 or not(substring($valeur1erCaractFlux2,1,1) = '-')">				
					<td class="clGrasFond clWidth120 clAlignRight">&#160;</td>
				</xsl:if>
			</tr>
			<tr>
				<td class="clCouleur2 clWidth395 clHeight14">&#160;ou</td>
				<td class="clGrasFond clWidth120" colspan="2"/>
			</tr>
			<tr>
				<td class="clCouleur2 clWidth395 clHeight14">&#160;RESSOURCE NETTE</td>
				<xsl:if test="not(substring($valeur1erCaractFlux1,1,1) = '-')">          
					<td class="clGrasFond clWidth120 clAlignRight">
						<xsl:if test="@ETAT">
							<xsl:value-of select="@ETAT"/>
						</xsl:if>
						<xsl:if test="not(@ETAT)">
              <xsl:call-template name ="displayNumberXsl">
                <xsl:with-param name ="InputStringNumber" select ="(../DIFF68/DONNEESFLUX[1]/pK00235)"/>
              </xsl:call-template>							
						</xsl:if>
					</td>
				</xsl:if>
        <xsl:if test="(substring($valeur1erCaractFlux1,1,1) = '-')">				
					<td class="clGrasFond clWidth120 clAlignRight">&#160;</td>
				</xsl:if>
        <xsl:if test="count(../DIFF68/DONNEESFLUX/pK00235)=2">
          <xsl:if test="not(substring($valeur1erCaractFlux2,1,1) = '-')">				  
						<td class="clGrasFond clWidth120 clAlignRight">
							<xsl:if test="@ETAT">
								<xsl:value-of select="@ETAT"/>
							</xsl:if>
							<xsl:if test="not(@ETAT)">
                <xsl:call-template name ="displayNumberXsl">
                  <xsl:with-param name ="InputStringNumber" select ="(../DIFF68/DONNEESFLUX[2]/pK00235)"/>
                </xsl:call-template>								
							</xsl:if>
						</td>
					</xsl:if>
				</xsl:if>
        <xsl:if test="count(../DIFF68/DONNEESFLUX/pK00235)=1 or (substring($valeur1erCaractFlux2,1,1) = '-')">				
					<td class="clGrasFond clWidth120 clAlignRight">&#160;</td>
				</xsl:if>
			</tr>
			<xsl:call-template name="BreakLine22"/>
			<tr>
				<td class="clItalic clWidth395 clHeight2">(1) y compris " effets escompts non chus "</td>
				<td class="clWidth120" colspan="2"/>
			</tr>
			<xsl:call-template name="BreakLine210"/>
			<tr>
				<td class="clCouleur2 clWidth395 clAlignCenter">CALCUL DE LA VARIATION DES BFR</td>
				<td class="clWidth120" colspan="2"/>
			</tr>
			<xsl:call-template name="BreakLine210"/>
			<tr>
				<td class="clCouleur2 clWidth395 clHeight14">&#160;Variation des actifs d'exploitation</td>
				<xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00198"/>
			</tr>
			<tr>
				<td class="clCouleur2 clWidth395 clHeight14">&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;Stocks et en-cours</td>
				<xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00193"/>
			</tr>
			<tr>
				<td class="clCouleur2 clWidth395 clHeight14">&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;+ Avances et acomptes verss sur commande</td>
				<xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00194"/>
			</tr>
			<tr>
				<td class="clCouleur2 clWidth395 clHeight14">&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;+ Crances clients (1) et autres crances</td>
				<xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00196"/>
			</tr>
			<tr>
				<td class="clCouleur2 clWidth395 clHeight14">&#160;- Variation des dettes d'exploitation</td>
				<xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00203"/>
			</tr>
			<tr>
				<td class="clCouleur2 clWidth395 clHeight14">&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;Avances et acomptes reus sur commande</td>
				<xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00200"/>
			</tr>
			<tr>
				<td class="clCouleur2 clWidth395 clHeight14">&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;+ Dettes fournisseurs et autres dettes</td>
				<xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00202"/>
			</tr>
			<xsl:call-template name="BreakLine22"/>
			<tr>
				<td class="clCouleur2 clWidth395 clHeight14">&#160;= VARIATION DU BFR D'EXPLOITATION (C)</td>
				<xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00204">
					<xsl:with-param name="bold">Gras</xsl:with-param>
				</xsl:apply-templates>
			</tr>
			<xsl:call-template name="BreakLine210"/>
			<tr>
				<td class="clCouleur2 clWidth395 clHeight14">&#160;Variation des autres dbiteurs</td>
				<xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00206"/>
			</tr>
			<tr>
				<td class="clCouleur2 clWidth395 clHeight14">&#160;- Variation des autres crditeurs</td>
				<xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00207"/>
				 <td class="clAlignRight">
					<a href="#ancHaut">
						<img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" alt="Retour en haut de la page"/>
					</a>
				</td>
			</tr>
			<xsl:call-template name="BreakLine22"/>
			<tr>
				<td class="clCouleur2 clWidth395 clHeight14">&#160;= VARIATION DU BFR HORS EXPLOITATION (D)</td>
				<xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00208">
					<xsl:with-param name="bold">Gras</xsl:with-param>
				</xsl:apply-templates>
			</tr>
			<xsl:call-template name="BreakLine210"/>
			<tr>
				<td class="clCouleur2 clWidth395 clHeight14">&#160;VARIATION DES BFR (C + D)</td>
				<xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00209">
					<xsl:with-param name="bold">Gras</xsl:with-param>
				</xsl:apply-templates>
			</tr>
			<xsl:call-template name="BreakLine210"/>
			<tr>
				<td class="clCouleur2 clWidth395 clHeight14">&#160;Variation du FRNG</td>
				<xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00235"/>
			</tr>
			<tr>
				<td class="clCouleur2 clWidth395 clHeight14">&#160;- Variation des BFR</td>
				<xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00209"/>
			</tr>
			<xsl:call-template name="BreakLine22"/>
			<tr>
				<td class="clCouleur2 clWidth395 clHeight14">&#160;= VARIATION DE LA TRSORERIE</td>
				<xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00234">
					<xsl:with-param name="bold">Gras</xsl:with-param>
				</xsl:apply-templates>
			</tr>
		</table>-->

    <table  class="clWidth739 clBorderCell">
      <caption class="visually-hidden">TABLEAU DES FLUX</caption>
      <xsl:variable name ="valeur1erCaractFlux1" select ="../DIFF68/DONNEESFLUX[1]/pK00235"></xsl:variable>
      <xsl:variable name ="valeur1erCaractFlux2" select ="../DIFF68/DONNEESFLUX[2]/pK00235"></xsl:variable>
      <tr>
        <th class="clCouleur2 clWidth395 clHeight15 clAlignLeft clThNonGras">&#160;Date d'arrt</th>
          <td class="clGrasFond clWidth120 clAlignRight">
            <xsl:call-template name ="displayDateXsl">
              <xsl:with-param name ="InputDate" select ="(../DIFF68/DONNEESFLUX[1]/@DATCLOT)"/>
            </xsl:call-template>&#160;
            </td>
            <xsl:if test="../DIFF68/DONNEESFLUX[2]">
              <td class="clGrasFond clWidth120 clAlignRight">
                <xsl:call-template name ="displayDateXsl">
                  <xsl:with-param name ="InputDate" select ="(../DIFF68/DONNEESFLUX[2]/@DATCLOT)"/>
                </xsl:call-template>&#160;
                </td>
              </xsl:if>
            <xsl:if test="not(../DIFF68/DONNEESFLUX[2])">
              <td class="clGrasFond clWidth120 clAlignRight">
                &#160;</td>
              </xsl:if>
          </tr>
      <xsl:call-template name="BreakLine210"/>
      <tr>
        <th class="clCouleur2 clWidth395 clAlignCenter clThNonGras">
          FORMATION DE LA TRSORERIE </th>
          <td class="clWidth120" colspan="2"/>
        </tr>
      <xsl:call-template name="BreakLine210"/>
      <tr>
        <th class="clCouleur2 clWidth395 clHeight14 clAlignLeft clThNonGras">&#160;Excdent brut d'exploitation</th>
        <td class="clFond clWidth120 clAlignRight">
          <xsl:if test="@ETAT">
            <xsl:value-of select="@ETAT"/>&#160;
          </xsl:if>
          <xsl:if test="not(@ETAT)">
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../DIFF68/DONNEESFLUX[1]/pK00075)"/>
            </xsl:call-template>&#160;
          </xsl:if>
          </td>
          <xsl:if test="../DIFF68/DONNEESFLUX[2]">
            <td class="clFond clWidth120 clAlignRight">
              <xsl:if test="@ETAT">
                <xsl:value-of select="@ETAT"/>&#160;
              </xsl:if>
              <xsl:if test="not(@ETAT)">
                <xsl:call-template name ="displayNumberXsl">
                  <xsl:with-param name ="InputStringNumber" select ="(../DIFF68/DONNEESFLUX[2]/pK00075)"/>
                </xsl:call-template>&#160;
              </xsl:if>
              </td>
            </xsl:if>
          <xsl:if test="not(../DIFF68/DONNEESFLUX[2])">
            <td class="clFond clWidth120 clAlignRight">
              &#160;</td>
            </xsl:if>
        </tr>
      <tr>
        <th class="clCouleur2 clWidth395 clHeight14 clAlignLeft clThNonGras">&#160;- Variation du BFR d'exploitation (1)</th>
        <xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00204"/>
      </tr>
      <xsl:call-template name="BreakLine22"/>
      <tr>
        <th class="clCouleur2 clWidth395 clHeight14 clAlignLeft clThNonGras">&#160;= EXCDENT DE TRSORERIE D'EXPLOITATION</th>
        <xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00249">
          <xsl:with-param name="bold">Gras</xsl:with-param>
        </xsl:apply-templates>
      </tr>
      <xsl:call-template name="BreakLine210"/>
      <tr>
        <th class="clCouleur2 clWidth395 clHeight14 clAlignLeft clThNonGras">&#160;Excdent de trsorerie d'exploitation</th>
        <xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00249"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth395 clHeight14 clAlignLeft clThNonGras">&#160;+ Produits et charges hors exploitation</th>
        <xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00260"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth395 clHeight14 clAlignLeft clThNonGras">&#160;- Variation du BFR hors exploitation</th>
        <xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00208"/>
      </tr>
      <xsl:call-template name="BreakLine22"/>
      <tr>
        <th class="clCouleur2 clWidth395 clHeight14 clAlignLeft clThNonGras">&#160;= EXCDENT DE TRSORERIE GLOBALE</th>
        <xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00261">
          <xsl:with-param name="bold">Gras</xsl:with-param>
        </xsl:apply-templates>
        <td class="clAlignRight">
          <a href="#ancHaut">
            <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" alt="Retour en haut de la page"/>
          </a>
          </td>
        </tr>
      <xsl:call-template name="BreakLine210"/>
      <tr>
        <th class="clCouleur2 clWidth395 clHeight14 clAlignLeft clThNonGras">&#160;Excdent de trsorerie globale</th>
        <xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00261"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth395 clHeight14 clAlignLeft clThNonGras">&#160;- Intrts et charges assimiles</th>
        <xsl:apply-templates select="../DIFF68/DONNEESFLUX/p2052GR" mode="genDF"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth395 clHeight14 clAlignLeft clThNonGras">&#160;- Impts sur les bnfices</th>
        <xsl:apply-templates select="../DIFF68/DONNEESFLUX/p2053HK" mode="genDF"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth395 clHeight14 clAlignLeft clThNonGras">&#160;- Distribution mise en paiement</th>
        <xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00087"/>
      </tr>
      <xsl:call-template name="BreakLine22"/>
      <tr>
        <th class="clCouleur2 clWidth395 clHeight14 clAlignLeft clThNonGras">&#160;= FLUX DE TRSORERIE AV. REMB. D'EMPRUNTS</th>
        <xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00262">
          <xsl:with-param name="bold">Gras</xsl:with-param>
        </xsl:apply-templates>
      </tr>
      <xsl:call-template name="BreakLine22"/>
      <tr>
        <th class="clItalic clWidth395 clHeight2 clAlignLeft clThNonGras">
          (1) y compris " effets escompts non chus "</th>
          <td class="clWidth120" colspan="2"/>
        </tr>
      <xsl:call-template name="BreakLine210"/>
      <tr>
        <th class="clCouleur2 clWidth395 clHeight14 clAlignLeft clThNonGras">&#160;Flux de trsorerie av. remboursement d'emprunts</th>
        <xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00262"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth395 clHeight14 clAlignLeft clThNonGras">&#160;- Investissement nets de cession</th>
        <xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00267"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth395 clHeight14 clAlignLeft clThNonGras">&#160;+ Variation des emprunts bancaires</th>
        <xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00363"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth395 clHeight14 clAlignLeft clThNonGras">&#160;+ Variation des autres ressources stables</th>
        <xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00364"/>
      </tr>
      <xsl:call-template name="BreakLine22"/>
      <tr>
        <th class="clCouleur2 clWidth395 clHeight14 clAlignLeft clThNonGras">&#160;= VARIATION DE TRSORERIE</th>
        <xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00234">
          <xsl:with-param name="bold">Gras</xsl:with-param>
        </xsl:apply-templates>
      </tr>
      <xsl:call-template name="BreakLine210"/>
      <tr>
        <th class="clCouleur2 clWidth395 clHeight14 clAlignLeft clThNonGras">&#160;Variation des disponibilits et des VMP</th>
        <xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00211"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth395 clHeight14 clAlignLeft clThNonGras">&#160;- Variation des crdits de trsorerie (2)</th>
        <xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00889"/>
      </tr>
      <xsl:call-template name="BreakLine22"/>
      <tr>
        <th class="clCouleur2 clWidth395 clHeight14 clAlignLeft clThNonGras">&#160;= VARIATION DE TRSORERIE</th>
        <xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00234">
          <xsl:with-param name="bold">Gras</xsl:with-param>
        </xsl:apply-templates>
      </tr>
      <xsl:call-template name="BreakLine22"/>
      <tr>
        <th class="clItalic clWidth395 clHeight2 clAlignLeft clThNonGras">
          (2) y compris " effets escompts non chus " et billets de trsorerie ventuels</th>
          <td class="clWidth120" colspan="2"/>
        </tr>
      <xsl:call-template name="BreakLine210"/>
      <tr class="clBreakPage">
        <th class="clCouleur2 clWidth395 clAlignCenter clThNonGras">
          CALCUL DE LA VARIATION DU FRNG</th>
          <td class="clWidth120" colspan="2"/>
        </tr>
      <xsl:call-template name="BreakLine210"/>
      <tr>
        <th class="clCouleur2 clWidth395 clHeight14 clAlignLeft clThNonGras">&#160;Capacit d'autofinancement</th>
        <xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00218" mode="genDF"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth395 clHeight14 clAlignLeft clThNonGras">&#160;+ Cessions ou rductions d'immobilisations</th>
        <xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00223"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth395 clHeight14 clAlignLeft clThNonGras">&#160;+ Variation positive des fonds propres</th>
        <xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00225"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth395 clHeight14 clAlignLeft clThNonGras">&#160;+ Variation positive des dettes financires</th>
        <xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00227"/>
      </tr>
      <xsl:call-template name="BreakLine22"/>
      <tr>
        <th class="clCouleur2 clWidth395 clHeight14 clAlignLeft clThNonGras">&#160;= TOTAL DES RESSOURCES (A)</th>
        <xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00228">
          <xsl:with-param name="bold">Gras</xsl:with-param>
        </xsl:apply-templates>
      </tr>
      <xsl:call-template name="BreakLine210"/>
      <tr>
        <th class="clCouleur2 clWidth395 clHeight14 clAlignLeft clThNonGras">&#160;Distribution mise en paiement</th>
        <xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00087"/>
        <td class="clAlignRight">
          <a href="#ancHaut">
            <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" alt="Retour en haut de la page"/>
          </a>
          </td>
        </tr>
      <tr>
        <th class="clCouleur2 clWidth395 clHeight14 clAlignLeft clThNonGras">&#160;+ Acquisitions d'immobilisations</th>
        <xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00188"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth395 clHeight14 clAlignLeft clThNonGras">&#160;+ Variation ngative des fonds propres</th>
        <xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00229"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth395 clHeight14 clAlignLeft clThNonGras">&#160;+ Variation ngative des dettes financires</th>
        <xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00230"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth395 clHeight14 clAlignLeft clThNonGras">&#160;+ Augmentation des frais d'mission d'emprunts  taler</th>
        <xsl:apply-templates select="../DIFF68/DONNEESFLUX/p2055CR2"/>
      </tr>
      <xsl:call-template name="BreakLine22"/>
      <tr>
        <th class="clCouleur2 clWidth395 clHeight14 clAlignLeft clThNonGras">&#160;= TOTAL DES EMPLOIS (B)</th>
        <xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00231">
          <xsl:with-param name="bold">Gras</xsl:with-param>
        </xsl:apply-templates>
      </tr>
      <xsl:call-template name="BreakLine210"/>
      <tr>
        <th class="clCouleur2 clWidth395 clHeight14 clAlignLeft clThNonGras">&#160;DIVERS ET AJUSTEMENTS</th>
        <xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00237">
          <xsl:with-param name="bold">Gras</xsl:with-param>
        </xsl:apply-templates>
      </tr>
      <xsl:call-template name="BreakLine210"/>
      <tr>
        <th class="clCouleur2 clWidth395 clHeight14 clAlignLeft clThNonGras">&#160;Variation du FRNG (A - B + divers)</th>
        <td class="clFond clWidth120" colspan="2"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth395 clHeight14 clAlignLeft clThNonGras">&#160;EMPLOI NET</th>
        <xsl:if test ="substring($valeur1erCaractFlux1,1,1) = '-'">
          <td class="clGrasFond clWidth120 clAlignRight">
            <xsl:if test="@ETAT">
              <xsl:value-of select="@ETAT"/>
            </xsl:if>
            <xsl:if test="not(@ETAT)">
              <xsl:call-template name ="displayNumberXsl">
                <xsl:with-param name ="InputStringNumber" select ="(../DIFF68/DONNEESFLUX[1]/pK00235)"/>
              </xsl:call-template>
            </xsl:if>
            </td>
          </xsl:if>
        <xsl:if test="not(substring($valeur1erCaractFlux1,1,1) = '-')">
          <td class="clGrasFond clWidth120 clAlignRight">
            &#160;</td>
          </xsl:if>
        <xsl:if test="count(../DIFF68/DONNEESFLUX/pK00235)=2">
          <xsl:if test ="substring($valeur1erCaractFlux2,1,1) = '-'">
            <td class="clGrasFond clWidth120 clAlignRight">
              <xsl:if test="@ETAT">
                <xsl:value-of select="@ETAT"/>
              </xsl:if>
              <xsl:if test="not(@ETAT)">
                <xsl:call-template name ="displayNumberXsl">
                  <xsl:with-param name ="InputStringNumber" select ="(../DIFF68/DONNEESFLUX[2]/pK00235)"/>
                </xsl:call-template>
              </xsl:if>
              </td>
            </xsl:if>
        </xsl:if>
        <xsl:if test="count(../DIFF68/DONNEESFLUX/pK00235)=1 or not(substring($valeur1erCaractFlux2,1,1) = '-')">
          <td class="clGrasFond clWidth120 clAlignRight">
            &#160;</td>
          </xsl:if>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth395 clHeight14 clAlignLeft clThNonGras">&#160;ou</th>
        <td class="clGrasFond clWidth120" colspan="2"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth395 clHeight14 clAlignLeft clThNonGras">&#160;RESSOURCE NETTE</th>
        <xsl:if test="not(substring($valeur1erCaractFlux1,1,1) = '-')">
          <td class="clGrasFond clWidth120 clAlignRight">
            <xsl:if test="@ETAT">
              <xsl:value-of select="@ETAT"/>
            </xsl:if>
            <xsl:if test="not(@ETAT)">
              <xsl:call-template name ="displayNumberXsl">
                <xsl:with-param name ="InputStringNumber" select ="(../DIFF68/DONNEESFLUX[1]/pK00235)"/>
              </xsl:call-template>
            </xsl:if>
            </td>
          </xsl:if>
        <xsl:if test="(substring($valeur1erCaractFlux1,1,1) = '-')">
          <td class="clGrasFond clWidth120 clAlignRight">
            &#160;</td>
          </xsl:if>
        <xsl:if test="count(../DIFF68/DONNEESFLUX/pK00235)=2">
          <xsl:if test="not(substring($valeur1erCaractFlux2,1,1) = '-')">
            <td class="clGrasFond clWidth120 clAlignRight">
              <xsl:if test="@ETAT">
                <xsl:value-of select="@ETAT"/>
              </xsl:if>
              <xsl:if test="not(@ETAT)">
                <xsl:call-template name ="displayNumberXsl">
                  <xsl:with-param name ="InputStringNumber" select ="(../DIFF68/DONNEESFLUX[2]/pK00235)"/>
                </xsl:call-template>
              </xsl:if>
              </td>
            </xsl:if>
        </xsl:if>
        <xsl:if test="count(../DIFF68/DONNEESFLUX/pK00235)=1 or (substring($valeur1erCaractFlux2,1,1) = '-')">
          <td class="clGrasFond clWidth120 clAlignRight">
            &#160;</td>
          </xsl:if>
      </tr>
      <xsl:call-template name="BreakLine22"/>
      <tr>
        <th class="clItalic clWidth395 clHeight2 clAlignLeft clThNonGras">
          (1) y compris " effets escompts non chus "</th>
          <td class="clWidth120" colspan="2"/>
        </tr>
      <xsl:call-template name="BreakLine210"/>
      <tr>
        <th class="clCouleur2 clWidth395 clAlignCenter clThNonGras">
          CALCUL DE LA VARIATION DES BFR</th>
          <td class="clWidth120" colspan="2"/>
        </tr>
      <xsl:call-template name="BreakLine210"/>
      <tr>
        <th class="clCouleur2 clWidth395 clHeight14 clAlignLeft clThNonGras">&#160;Variation des actifs d'exploitation</th>
        <xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00198"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth395 clHeight14 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;Stocks et en-cours</th>
        <xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00193"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth395 clHeight14 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;+ Avances et acomptes verss sur commande</th>
        <xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00194"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth395 clHeight14 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;+ Crances clients (1) et autres crances</th>
        <xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00196"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth395 clHeight14 clAlignLeft clThNonGras">&#160;- Variation des dettes d'exploitation</th>
        <xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00203"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth395 clHeight14 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;Avances et acomptes reus sur commande</th>
        <xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00200"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth395 clHeight14 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;+ Dettes fournisseurs et autres dettes</th>
        <xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00202"/>
      </tr>
      <xsl:call-template name="BreakLine22"/>
      <tr>
        <th class="clCouleur2 clWidth395 clHeight14 clAlignLeft clThNonGras">&#160;= VARIATION DU BFR D'EXPLOITATION (C)</th>
        <xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00204">
          <xsl:with-param name="bold">Gras</xsl:with-param>
        </xsl:apply-templates>
      </tr>
      <xsl:call-template name="BreakLine210"/>
      <tr>
        <th class="clCouleur2 clWidth395 clHeight14 clAlignLeft clThNonGras">&#160;Variation des autres dbiteurs</th>
        <xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00206"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth395 clHeight14 clAlignLeft clThNonGras">&#160;- Variation des autres crditeurs</th>
        <xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00207"/>
        <td class="clAlignRight">
          <a href="#ancHaut">
            <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" alt="Retour en haut de la page"/>
          </a>
          </td>
        </tr>
      <xsl:call-template name="BreakLine22"/>
      <tr>
        <th class="clCouleur2 clWidth395 clHeight14 clAlignLeft clThNonGras">&#160;= VARIATION DU BFR HORS EXPLOITATION (D)</th>
        <xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00208">
          <xsl:with-param name="bold">Gras</xsl:with-param>
        </xsl:apply-templates>
      </tr>
      <xsl:call-template name="BreakLine210"/>
      <tr>
        <th class="clCouleur2 clWidth395 clHeight14 clAlignLeft clThNonGras">&#160;VARIATION DES BFR (C + D)</th>
        <xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00209">
          <xsl:with-param name="bold">Gras</xsl:with-param>
        </xsl:apply-templates>
      </tr>
      <xsl:call-template name="BreakLine210"/>
      <tr>
        <th class="clCouleur2 clWidth395 clHeight14 clAlignLeft clThNonGras">&#160;Variation du FRNG</th>
        <xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00235"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth395 clHeight14 clAlignLeft clThNonGras">&#160;- Variation des BFR</th>
        <xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00209"/>
      </tr>
      <xsl:call-template name="BreakLine22"/>
      <tr>
        <th class="clCouleur2 clWidth395 clHeight14 clAlignLeft clThNonGras">&#160;= VARIATION DE LA TRSORERIE</th>
        <xsl:apply-templates select="../DIFF68/DONNEESFLUX/pK00234">
          <xsl:with-param name="bold">Gras</xsl:with-param>
        </xsl:apply-templates>
      </tr>
    </table>
    
    <!--
 ******************************************************************************************************************************************************************************************
 ******************************************************************************************************************************************************************************************
 
 AUTRES DONNES D'ANALYSE FINANCIRE (obligatoire)

******************************************************************************************************************************************************************************************
******************************************************************************************************************************************************************************************
 -->
		<a name="autres"/>
		<div class="clBreakPage"/>
		<xsl:call-template name="shim"/>
		<table class="clWidth635 clBorderCell" role="presentation">
			<tr class="clAlignCenter">
				<td class="clCouleurGras">AUTRES DONNES D'ANALYSE FINANCIRE</td>
				<td class="clWidth19"/>
			</tr>
		</table>
		<xsl:call-template name="shim"/>
		<br/>
    <table  class="clWidth739 clBorderCell">
      <caption class="visually-hidden">AUTRES DONNES D'ANALYSE FINANCIRE</caption>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;Date d'arrt</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/@DATCLOT"/>
      </tr>
      <xsl:call-template name="BreakLine310"/>
      <tr>
        <th class="clCouleur2 clWidth275 clAlignCenter clThNonGras">CALCUL DE LA CAPACIT D'AUTOFINANCEMENT</th>
        <td class="clWidth120" colspan="3"/>
      </tr>
      <xsl:call-template name="BreakLine310"/>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;Excdent brut (insuffisance) d'exploitation</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00075"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;+ Transferts de charges d'exploitation</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00170"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;+/- Autres produits et autres charges d'expl.</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00171"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;+/- Quote-part rsultats sur op. en commun</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00080"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;+/- Produits financiers et charges financires</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00172"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;(sauf dotations et reprises de provisions)</th>
        <td class="clFond clWidth120" colspan="3"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;+ Produits exceptionnels (sauf op. en capital)</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00217"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;- Charges exceptionnelles (sauf op. en capital)</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2053HE"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;- Participation des salaris et impts s/ bnf.</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00175"/>
      </tr>
      <xsl:call-template name="BreakLine32"/>
      <tr>
        <th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">
          &#160;= CAPACIT D'AUTOFINANCEMENT</th>
          <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00218">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
      <xsl:call-template name="BreakLine310"/>
      <tr>
        <th class="clCouleur2 clWidth275 clAlignCenter clThNonGras">AGRGAT DE LIQUIDIT</th>
        <td class="clWidth120" colspan="3"/>
      </tr>
      <xsl:call-template name="BreakLine310"/>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;Actifs  moins d'un an</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00151"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;- Dettes  moins d'un an</th>
        <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/p2051EG"/>
      </tr>
      <xsl:call-template name="BreakLine32"/>
      <tr>
        <th class="clCouleur2 clWidth275 clAlignLeft clThNonGras">
          &#160;= EXCDENT OU INSUFFISANCE</th>
          <xsl:apply-templates select="../DIFF68/DONNEESEXERCICE/pK00152">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
          <td class="clAlignRight">
            <a href="#ancHaut">
              <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" alt="Retour en haut de la page"/>
            </a>
            </td>
          </tr>
      <xsl:call-template name="BreakLine22"/>
      <tr>
        <th class="clItalic clWidth275 clHeight2 clAlignLeft clThNonGras">
          (1) y compris " effets escompts non chus "</th>
          <td class="clWidth120" colspan="2"/>
        </tr>
    </table>
		<!--
 ******************************************************************************************************************************************************************************************
 ******************************************************************************************************************************************************************************************
 
 RATIOS INDIVIDUELS ET SECTORIELS (obligatoire pour INDIVIDUELS, facultatif pour SECTORIELS)

******************************************************************************************************************************************************************************************
******************************************************************************************************************************************************************************************
 -->
		<a name="ratios"/>
		<div class="clBreakPage"/>
		<xsl:call-template name="shim"/>
		<table class="clWidth635 clBorderCell" role="presentation">
			<tr class="clAlignCenter">
				<td class="clCouleurGras">RATIOS INDIVIDUELS ET SECTORIELS</td>
				 <td class="clWidth19">
					<xsl:if test="$condGraph64">
						<a href="#nullepart" onclick="window.document.forms['FormGraphes'].action='Graphes.aspx#Graphe4';window.document.forms['FormGraphes'].submit();">
							<img border="0" src="{$root}Images/risque/diagramme_bleu.gif" width="19" height="20" alt="lien vers diagramme"/>
						</a>
					</xsl:if>
					<xsl:if test="not($condGraph64)">
						<img border="0" src="{$root}Images/boutons/diagramme_in.gif" width="19" height="20" alt="diagramme non disponible"/>
					</xsl:if>
				</td>
			</tr>
		</table>
		<xsl:call-template name="shim"/>
		<br/>
    <table class="clWidth739 clBorderCell">
      <caption class="visually-hidden">RATIOS INDIVIDUELS ET SECTORIELS</caption>
      <tr>
        <td class="clHeight15 clWidth250"/>
        <td class="clHeight15 clWidth25"/>
        <th class="clCouleur2 clHeight15 clAlignCenter clThNonGras" colspan="2">
          ENTREPRISE</th>
          <td class="clHeight15 clWidth5"/>
          <th class="clCouleur2 clWidth115 clHeight15 clAlignCenter clThNonGras">
            SECTEUR&#160;(3)</th>
          </tr>
      <xsl:call-template name="BreakLineSector"/>
      <tr>
        <th class="clCouleur2 clWidth250 clHeight15 clAlignLeft clThNonGras">&#160;Activit conomique</th>
        <td class="clCouleur2 clWidth25 clAlignCenter">
          &#160;</td>
          <xsl:apply-templates select="../DIFF68/DONNEESINDIVIDUELLES68/CODNAF"/>
          <td class="clWidth5">
            &#160;</td>
            <xsl:if test="../DIFF68/DONNEESSECTORIELLES68">
              <td class="clGrasFond clWidth115 clAlignRight">
                <xsl:value-of select="../DIFF68/CODNAF"/>&#160;
                </td>
              </xsl:if>
            <xsl:if test="not(../DIFF68/DONNEESSECTORIELLES68)">
              <td class="clFond clWidth115 clAlignRight">
                Indisponible</td>
              </xsl:if>
          </tr>
      <tr>
        <th class="clCouleur2 clWidth250 clHeight15 clAlignLeft clThNonGras">&#160;Date d'arrt</th>
        <td class="clCouleur2 clWidth25 clAlignCenter">
          &#160;</td>
          <td class="clGrasFond clWidth120 clAlignRight">
            <xsl:call-template name="displayDateXsl">
              <xsl:with-param name="InputDate" select="(../DIFF68/DONNEESINDIVIDUELLES68[1]/@DATCLOT)"/>
            </xsl:call-template>&#160;
            </td>
            <xsl:if test="../DIFF68/DONNEESINDIVIDUELLES68[2]">
              <td class="clGrasFond clWidth120 clAlignRight">
                <xsl:call-template name="displayDateXsl">
                  <xsl:with-param name="InputDate" select="(../DIFF68/DONNEESINDIVIDUELLES68[2]/@DATCLOT)"/>
                </xsl:call-template>&#160;
                </td>
              </xsl:if>
            <xsl:if test="not(../DIFF68/DONNEESINDIVIDUELLES68[2])">
              <td class="clGrasFond clWidth120 clAlignRight">
                &#160;</td>
              </xsl:if>
            <td class="clWidth5">
              &#160;</td>
              <xsl:if test="../DIFF68/DONNEESSECTORIELLES68">
                <td class="clGrasFond clWidth115 clAlignRight">
                  <xsl:value-of select="../DIFF68/DONNEESSECTORIELLES68/@DATSECT"/>&#160;
                  </td>
                </xsl:if>
              <xsl:if test="not(../DIFF68/DONNEESSECTORIELLES68)">
                <td class="clGrasFond clWidth115 clAlignCenter">
                  &#160;</td>
                </xsl:if>
            </tr>
      <xsl:call-template name="BreakLineSector"/>
      <tr>
        <th class="clCouleur2 clWidth250 clHeight15 clAlignCenter clThNonGras">ACTIVIT</th>
        <td class="clHeight15 clWidth25"/>
        <td class="clWidth120 clHeight15"/>
        <td class="clWidth120 clHeight15"/>
        <td class="clHeight15 clWidth5"/>
        <td class="clWidth115 clHeight15"/>
      </tr>
      <xsl:call-template name="BreakLineSector"/>
      <tr>
        <th class="clCouleur2 clWidth250 clHeight15 clAlignLeft clThNonGras">&#160;Stocks / CA HT (1)</th>
        <td class="clCouleur2 clWidth25 clAlignCenter">
          j</td>
          <xsl:apply-templates select="../DIFF68/DONNEESINDIVIDUELLES68/pK00285"/>
          <td class="clWidth5"/>
          <xsl:if test="../DIFF68/DONNEESSECTORIELLES68">
            <td class="clFond clWidth115 clAlignRight">
              <xsl:call-template name="displayNumberXsl">
                <xsl:with-param name="InputStringNumber" select="(../DIFF68/DONNEESSECTORIELLES68/pK00285)"/>
              </xsl:call-template>&#160;
              </td>
            </xsl:if>
          <xsl:if test="not(../DIFF68/DONNEESSECTORIELLES68)">
            <td class="clFond clWidth115 clAlignRight">
              &#160;</td>
            </xsl:if>
        </tr>
      <tr>
        <th class="clCouleur2 clWidth250 clHeight15 clAlignLeft clThNonGras">&#160;Stocks march. / Cot ach. march. vend. (1)</th>
        <td class="clCouleur2 clWidth25 clAlignCenter">
          j</td>
          <xsl:apply-templates select="../DIFF68/DONNEESINDIVIDUELLES68/pK00286"/>
          <td class="clWidth5"/>
          <xsl:if test="../DIFF68/DONNEESSECTORIELLES68">
            <td class="clFond clWidth115 clAlignRight">
              <xsl:call-template name="displayNumberXsl">
                <xsl:with-param name="InputStringNumber" select="(../DIFF68/DONNEESSECTORIELLES68/pK00286)"/>
              </xsl:call-template>&#160;
              </td>
            </xsl:if>
          <xsl:if test="not(../DIFF68/DONNEESSECTORIELLES68)">
            <td class="clFond clWidth115 clAlignRight">
              &#160;</td>
            </xsl:if>
        </tr>
      <tr>
        <th class="clCouleur2 clWidth250 clHeight15 clAlignLeft clThNonGras">&#160;Stocks MP et appro. / Cot ach. MP (1)</th>
        <td class="clCouleur2 clWidth25 clAlignCenter">
          j</td>
          <xsl:apply-templates select="../DIFF68/DONNEESINDIVIDUELLES68/pK00287"/>
          <td class="clWidth5"/>
          <xsl:if test="../DIFF68/DONNEESSECTORIELLES68">
            <td class="clFond clWidth115 clAlignRight">
              <xsl:call-template name="displayNumberXsl">
                <xsl:with-param name="InputStringNumber" select="(../DIFF68/DONNEESSECTORIELLES68/pK00287)"/>
              </xsl:call-template>&#160;
              </td>
            </xsl:if>
          <xsl:if test="not(../DIFF68/DONNEESSECTORIELLES68)">
            <td class="clFond clWidth115 clAlignRight">
              &#160;</td>
            </xsl:if>
        </tr>
      <tr>
        <th class="clCouleur2 clWidth250 clHeight15 clAlignLeft clThNonGras">&#160;Stocks prod. finis et en cours / Prod. ex.</th>
        <td class="clCouleur2 clWidth25 clAlignCenter">
          j</td>
          <xsl:apply-templates select="../DIFF68/DONNEESINDIVIDUELLES68/pK00288"/>
          <td class="clWidth5"/>
          <xsl:if test="../DIFF68/DONNEESSECTORIELLES68">
            <td class="clFond clWidth115 clAlignRight">
              <xsl:call-template name="displayNumberXsl">
                <xsl:with-param name="InputStringNumber" select="(../DIFF68/DONNEESSECTORIELLES68/pK00288)"/>
              </xsl:call-template>&#160;
              </td>
            </xsl:if>
          <xsl:if test="not(../DIFF68/DONNEESSECTORIELLES68)">
            <td class="clFond clWidth115 clAlignRight">
              &#160;</td>
            </xsl:if>
        </tr>
      <tr>
        <th class="clCouleur2 clWidth250 clHeight15 clAlignLeft clThNonGras">&#160;Clients + Escompte (2) / CA TTC (1)</th>
        <td class="clCouleur2 clWidth25 clAlignCenter">
          j</td>
          <xsl:apply-templates select="../DIFF68/DONNEESINDIVIDUELLES68/pK00289"/>
          <td class="clWidth5"/>
          <xsl:if test="../DIFF68/DONNEESSECTORIELLES68">
            <td class="clFond clWidth115 clAlignRight">
              <xsl:call-template name="displayNumberXsl">
                <xsl:with-param name="InputStringNumber" select="(../DIFF68/DONNEESSECTORIELLES68/pK00289)"/>
              </xsl:call-template>&#160;
              </td>
            </xsl:if>
          <xsl:if test="not(../DIFF68/DONNEESSECTORIELLES68)">
            <td class="clFond clWidth115 clAlignRight">
              &#160;</td>
            </xsl:if>
        </tr>
      <tr>
        <th class="clCouleur2 clWidth250 clHeight15 clAlignLeft clThNonGras">&#160;Fournisseurs / Achats et ch. ext. TTC (1)</th>
        <td class="clCouleur2 clWidth25 clAlignCenter">
          j</td>
          <xsl:apply-templates select="../DIFF68/DONNEESINDIVIDUELLES68/pK00293"/>
          <td class="clWidth5"/>
          <xsl:if test="../DIFF68/DONNEESSECTORIELLES68">
            <td class="clFond clWidth115 clAlignRight">
              <xsl:call-template name="displayNumberXsl">
                <xsl:with-param name="InputStringNumber" select="(../DIFF68/DONNEESSECTORIELLES68/pK00293)"/>
              </xsl:call-template>&#160;
              </td>
            </xsl:if>
          <xsl:if test="not(../DIFF68/DONNEESSECTORIELLES68)">
            <td class="clFond clWidth115 clAlignRight">
              &#160;</td>
            </xsl:if>
        </tr>
      <tr>
        <th class="clCouleur2 clWidth250 clHeight15 clAlignLeft clThNonGras">&#160;BFR d'exploitation (2) / CA HT (1)</th>
        <td class="clCouleur2 clWidth25 clAlignCenter">
          j</td>
          <xsl:apply-templates select="../DIFF68/DONNEESINDIVIDUELLES68/pK00295"/>
          <td class="clWidth5"/>
          <xsl:if test="../DIFF68/DONNEESSECTORIELLES68">
            <td class="clFond clWidth115 clAlignRight">
              <xsl:call-template name="displayNumberXsl">
                <xsl:with-param name="InputStringNumber" select="(../DIFF68/DONNEESSECTORIELLES68/pK00295)"/>
              </xsl:call-template>&#160;
              </td>
            </xsl:if>
          <xsl:if test="not(../DIFF68/DONNEESSECTORIELLES68)">
            <td class="clFond clWidth115 clAlignRight">
              &#160;</td>
            </xsl:if>
        </tr>
      <xsl:call-template name="BreakLineSector"/>
      <tr>
        <th class="clCouleur2 clWidth250 clHeight15 clAlignCenter clThNonGras">RPARTITION DE LA VALEUR AJOUTE</th>
        <td class="clHeight15 clWidth25"/>
        <td class="clWidth120 clHeight15"/>
        <td class="clWidth120 clHeight15"/>
        <td class="clHeight15 clWidth5"/>
        <td class="clWidth115 clHeight15"/>
      </tr>
      <xsl:call-template name="BreakLineSector"/>
      <tr>
        <th class="clCouleur2 clWidth250 clHeight15 clAlignLeft clThNonGras">&#160;Charges de personnel / VA</th>
        <td class="clCouleur2 clWidth25 clAlignCenter">
          %</td>
          <xsl:apply-templates select="../DIFF68/DONNEESINDIVIDUELLES68/pK00074"/>
          <td class="clWidth5"/>
          <xsl:if test="../DIFF68/DONNEESSECTORIELLES68">
            <td class="clFond clWidth115 clAlignRight">
              <xsl:call-template name="displayNumberXsl">
                <xsl:with-param name="InputStringNumber" select="(../DIFF68/DONNEESSECTORIELLES68/pK00074)"/>
              </xsl:call-template>&#160;
              </td>
            </xsl:if>
          <xsl:if test="not(../DIFF68/DONNEESSECTORIELLES68)">
            <td class="clFond clWidth115 clAlignRight">
              &#160;</td>
            </xsl:if>
        </tr>
      <tr>
        <th class="clCouleur2 clWidth250 clHeight15 clAlignLeft clThNonGras">&#160;Autofinancement / VA</th>
        <td class="clCouleur2 clWidth25 clAlignCenter">
          %</td>
          <xsl:apply-templates select="../DIFF68/DONNEESINDIVIDUELLES68/pK00221"/>
          <td class="clWidth5"/>
          <xsl:if test="../DIFF68/DONNEESSECTORIELLES68">
            <td class="clFond clWidth115 clAlignRight">
              <xsl:call-template name="displayNumberXsl">
                <xsl:with-param name="InputStringNumber" select="(../DIFF68/DONNEESSECTORIELLES68/pK00221)"/>
              </xsl:call-template>&#160;
              </td>
            </xsl:if>
          <xsl:if test="not(../DIFF68/DONNEESSECTORIELLES68)">
            <td class="clFond clWidth115 clAlignRight">
              &#160;</td>
            </xsl:if>
        </tr>
      <tr>
        <th class="clCouleur2 clWidth250 clHeight15 clAlignLeft clThNonGras">&#160;Charges financires / VA</th>
        <td class="clCouleur2 clWidth25 clAlignCenter">
          %</td>
          <xsl:apply-templates select="../DIFF68/DONNEESINDIVIDUELLES68/pK00298"/>
          <td class="clWidth5"/>
          <xsl:if test="../DIFF68/DONNEESSECTORIELLES68">
            <td class="clFond clWidth115 clAlignRight">
              <xsl:call-template name="displayNumberXsl">
                <xsl:with-param name="InputStringNumber" select="(../DIFF68/DONNEESSECTORIELLES68/pK00298)"/>
              </xsl:call-template>&#160;
              </td>
            </xsl:if>
          <xsl:if test="not(../DIFF68/DONNEESSECTORIELLES68)">
            <td class="clFond clWidth115 clAlignRight">
              &#160;</td>
            </xsl:if>
        </tr>
      <xsl:call-template name="BreakLineSector"/>
      <tr>
        <th class="clCouleur2 clWidth250 clHeight15 clAlignCenter clThNonGras">PRODUCTIVIT</th>
        <td class="clHeight15 clWidth25"/>
        <td class="clWidth120 clHeight15"/>
        <td class="clWidth120 clHeight15"/>
        <td class="clHeight15 clWidth5"/>
        <td class="clWidth115 clHeight15"/>
      </tr>
      <xsl:call-template name="BreakLineSector"/>
      <tr>
        <th class="clCouleur2 clWidth250 clHeight15 clAlignLeft clThNonGras">&#160;VA / CA HT (1)</th>
        <td class="clCouleur2 clWidth25 clAlignCenter">
          %</td>
          <xsl:apply-templates select="../DIFF68/DONNEESINDIVIDUELLES68/pK00299"/>
          <td class="clWidth5"/>
          <xsl:if test="../DIFF68/DONNEESSECTORIELLES68">
            <td class="clFond clWidth115 clAlignRight">
              <xsl:call-template name="displayNumberXsl">
                <xsl:with-param name="InputStringNumber" select="(../DIFF68/DONNEESSECTORIELLES68/pK00299)"/>
              </xsl:call-template>&#160;
              </td>
            </xsl:if>
          <xsl:if test="not(../DIFF68/DONNEESSECTORIELLES68)">
            <td class="clFond clWidth115 clAlignRight">
              &#160;</td>
            </xsl:if>
        </tr>
      <tr>
        <th class="clCouleur2 clWidth250 clHeight15 clAlignLeft clThNonGras">&#160;Charges de personnel / Effectifs</th>
        <td class="clCouleur2 clWidth25 clAlignCenter">
          k<img height="9" src="{$root}images/risque/euro_symb_bleu.gif" width="8"/>
          </td>
          <xsl:apply-templates select="../DIFF68/DONNEESINDIVIDUELLES68/pK00300"/>
          <td class="clWidth5"/>
          <xsl:if test="../DIFF68/DONNEESSECTORIELLES68">
            <td class="clFond clWidth115 clAlignRight">
              <xsl:call-template name="displayNumberXsl">
                <xsl:with-param name="InputStringNumber" select="(../DIFF68/DONNEESSECTORIELLES68/pK00300)"/>
              </xsl:call-template>&#160;
              </td>
            </xsl:if>
          <xsl:if test="not(../DIFF68/DONNEESSECTORIELLES68)">
            <td class="clFond clWidth115 clAlignRight">
              &#160;</td>
            </xsl:if>
          <td class="clAlignRight">
            <a href="#ancHaut">
              <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" alt="Retour en haut de la page"/>
            </a>
            </td>
          </tr>
      <tr>
        <th class="clCouleur2 clWidth250 clHeight15 clAlignLeft clThNonGras">&#160;VA / Effectifs</th>
        <td class="clCouleur2 clWidth25 clAlignCenter">
          k<img height="9" src="{$root}images/risque/euro_symb_bleu.gif" width="8"/>
          </td>
          <xsl:apply-templates select="../DIFF68/DONNEESINDIVIDUELLES68/pK00301"/>
          <td class="clWidth5"/>
          <xsl:if test="../DIFF68/DONNEESSECTORIELLES68">
            <td class="clFond clWidth115 clAlignRight">
              <xsl:call-template name="displayNumberXsl">
                <xsl:with-param name="InputStringNumber" select="(../DIFF68/DONNEESSECTORIELLES68/pK00301)"/>
              </xsl:call-template>&#160;
              </td>
            </xsl:if>
          <xsl:if test="not(../DIFF68/DONNEESSECTORIELLES68)">
            <td class="clFond clWidth115 clAlignRight">
              &#160;</td>
            </xsl:if>
        </tr>
      <tr>
        <th class="clCouleur2 clWidth250 clHeight15 clAlignLeft clThNonGras">&#160;VA / Immobilisations corporelles brutes</th>
        <td class="clCouleur2 clWidth25 clAlignCenter">
          %</td>
          <xsl:apply-templates select="../DIFF68/DONNEESINDIVIDUELLES68/pK00302"/>
          <td class="clWidth5"/>
          <xsl:if test="../DIFF68/DONNEESSECTORIELLES68">
            <td class="clFond clWidth115 clAlignRight">
              <xsl:call-template name="displayNumberXsl">
                <xsl:with-param name="InputStringNumber" select="(../DIFF68/DONNEESSECTORIELLES68/pK00302)"/>
              </xsl:call-template>&#160;
              </td>
            </xsl:if>
          <xsl:if test="not(../DIFF68/DONNEESSECTORIELLES68)">
            <td class="clFond clWidth115 clAlignRight">
              &#160;</td>
            </xsl:if>
        </tr>
      <xsl:call-template name="BreakLineSector"/>
      <tr>
        <th class="clCouleur2 clWidth250 clHeight15 clAlignCenter clThNonGras">RENTABILIT</th>
        <td class="clHeight15 clWidth25"/>
        <td class="clWidth120 clHeight15"/>
        <td class="clWidth120 clHeight15"/>
        <td class="clHeight15 clWidth5"/>
        <td class="clWidth115 clHeight15"/>
      </tr>
      <xsl:call-template name="BreakLineSector"/>
      <tr>
        <th class="clCouleur2 clWidth250 clHeight15 clAlignLeft clThNonGras">&#160;Marge commerciale / Ventes marchand.</th>
        <td class="clCouleur2 clWidth25 clAlignCenter">
          %</td>
          <xsl:apply-templates select="../DIFF68/DONNEESINDIVIDUELLES68/pK00303"/>
          <td class="clWidth5"/>
          <xsl:if test="../DIFF68/DONNEESSECTORIELLES68">
            <td class="clFond clWidth115 clAlignRight">
              <xsl:call-template name="displayNumberXsl">
                <xsl:with-param name="InputStringNumber" select="(../DIFF68/DONNEESSECTORIELLES68/pK00303)"/>
              </xsl:call-template>&#160;
              </td>
            </xsl:if>
          <xsl:if test="not(../DIFF68/DONNEESSECTORIELLES68)">
            <td class="clFond clWidth115 clAlignRight">
              &#160;</td>
            </xsl:if>
        </tr>
      <tr>
        <th class="clCouleur2 clWidth250 clHeight15 clAlignLeft clThNonGras">&#160;EBE / CA HT (1)</th>
        <td class="clCouleur2 clWidth25 clAlignCenter">
          %</td>
          <xsl:apply-templates select="../DIFF68/DONNEESINDIVIDUELLES68/pK00304"/>
          <td class="clWidth5"/>
          <xsl:if test="../DIFF68/DONNEESSECTORIELLES68">
            <td class="clFond clWidth115 clAlignRight">
              <xsl:call-template name="displayNumberXsl">
                <xsl:with-param name="InputStringNumber" select="(../DIFF68/DONNEESSECTORIELLES68/pK00304)"/>
              </xsl:call-template>&#160;
              </td>
            </xsl:if>
          <xsl:if test="not(../DIFF68/DONNEESSECTORIELLES68)">
            <td class="clFond clWidth115 clAlignRight">
              &#160;</td>
            </xsl:if>
        </tr>
      <tr>
        <th class="clCouleur2 clWidth250 clHeight15 clAlignLeft clThNonGras">&#160;Rsultat courant / Fonds propres appels</th>
        <td class="clCouleur2 clWidth25 clAlignCenter">
          %</td>
          <xsl:apply-templates select="../DIFF68/DONNEESINDIVIDUELLES68/pK00305"/>
          <td class="clWidth5"/>
          <xsl:if test="../DIFF68/DONNEESSECTORIELLES68">
            <td class="clFond clWidth115 clAlignRight">
              <xsl:call-template name="displayNumberXsl">
                <xsl:with-param name="InputStringNumber" select="(../DIFF68/DONNEESSECTORIELLES68/pK00305)"/>
              </xsl:call-template>&#160;
              </td>
            </xsl:if>
          <xsl:if test="not(../DIFF68/DONNEESSECTORIELLES68)">
            <td class="clFond clWidth115 clAlignRight">
              &#160;</td>
            </xsl:if>
        </tr>
      <tr>
        <th class="clCouleur2 clWidth250 clHeight15 clAlignLeft clThNonGras">&#160;Rsultat net / CA HT</th>
        <td class="clCouleur2 clWidth25 clAlignCenter">
          %</td>
          <xsl:apply-templates select="../DIFF68/DONNEESINDIVIDUELLES68/pK00365"/>
          <td class="clWidth5"/>
          <xsl:if test="../DIFF68/DONNEESSECTORIELLES68">
            <td class="clFond clWidth115 clAlignRight">
              <xsl:call-template name="displayNumberXsl">
                <xsl:with-param name="InputStringNumber" select="(../DIFF68/DONNEESSECTORIELLES68/pK00365)"/>
              </xsl:call-template>&#160;
              </td>
            </xsl:if>
          <xsl:if test="not(../DIFF68/DONNEESSECTORIELLES68)">
            <td class="clFond clWidth115 clAlignRight">
              &#160;</td>
            </xsl:if>
        </tr>
      <tr>
        <th class="clCouleur2 clWidth250 clHeight15 clAlignLeft clThNonGras">&#160;EBE / Immo. corp. et inc. brut. + BFR expl. (2)</th>
        <td class="clCouleur2 clWidth25 clAlignCenter">
          %</td>
          <xsl:apply-templates select="../DIFF68/DONNEESINDIVIDUELLES68/pK00306"/>
          <td class="clWidth5"/>
          <xsl:if test="../DIFF68/DONNEESSECTORIELLES68">
            <td class="clFond clWidth115 clAlignRight">
              <xsl:call-template name="displayNumberXsl">
                <xsl:with-param name="InputStringNumber" select="(../DIFF68/DONNEESSECTORIELLES68/pK00306)"/>
              </xsl:call-template>&#160;
              </td>
            </xsl:if>
          <xsl:if test="not(../DIFF68/DONNEESSECTORIELLES68)">
            <td class="clFond clWidth115 clAlignRight">
              &#160;</td>
            </xsl:if>
        </tr>
      <xsl:call-template name="BreakLineSector"/>
      <tr>
        <th class="clCouleur2 clWidth250 clHeight15 clAlignCenter clThNonGras">CHARGES FINANCIRES ET FINANCEMENT</th>
        <td class="clHeight15 clWidth25"/>
        <td class="clWidth120 clHeight15"/>
        <td class="clWidth120 clHeight15"/>
        <td class="clHeight15 clWidth5"/>
        <td class="clWidth115 clHeight15"/>
      </tr>
      <xsl:call-template name="BreakLineSector"/>
      <tr>
        <th class="clCouleur2 clWidth250 clHeight15 clAlignLeft clThNonGras">&#160;Intrts et charges assimiles / EBE</th>
        <td class="clCouleur2 clWidth25 clAlignCenter">
          %</td>
          <xsl:apply-templates select="../DIFF68/DONNEESINDIVIDUELLES68/pK00307"/>
          <td class="clWidth5"/>
          <xsl:if test="../DIFF68/DONNEESSECTORIELLES68">
            <td class="clFond clWidth115 clAlignRight">
              <xsl:call-template name="displayNumberXsl">
                <xsl:with-param name="InputStringNumber" select="(../DIFF68/DONNEESSECTORIELLES68/pK00307)"/>
              </xsl:call-template>&#160;
              </td>
            </xsl:if>
          <xsl:if test="not(../DIFF68/DONNEESSECTORIELLES68)">
            <td class="clFond clWidth115 clAlignRight">
              &#160;</td>
            </xsl:if>
        </tr>
      <tr>
        <th class="clCouleur2 clWidth250 clHeight15 clAlignLeft clThNonGras">&#160;Intrts et charges assimiles / CA HT (1)</th>
        <td class="clCouleur2 clWidth25 clAlignCenter">
          %</td>
          <xsl:apply-templates select="../DIFF68/DONNEESINDIVIDUELLES68/pK00308"/>
          <td class="clWidth5"/>
          <xsl:if test="../DIFF68/DONNEESSECTORIELLES68">
            <td class="clFond clWidth115 clAlignRight">
              <xsl:call-template name="displayNumberXsl">
                <xsl:with-param name="InputStringNumber" select="(../DIFF68/DONNEESSECTORIELLES68/pK00308)"/>
              </xsl:call-template>&#160;
              </td>
            </xsl:if>
          <xsl:if test="not(../DIFF68/DONNEESSECTORIELLES68)">
            <td class="clFond clWidth115 clAlignRight">
              &#160;</td>
            </xsl:if>
        </tr>
      <tr>
        <th class="clCouleur2 clWidth250 clHeight15 clAlignLeft clThNonGras">&#160;Autofinancement / Invest. net + Var. BFR (2)</th>
        <td class="clCouleur2 clWidth25 clAlignCenter">
          %</td>
          <xsl:apply-templates select="../DIFF68/DONNEESINDIVIDUELLES68/pK00309"/>
          <td class="clWidth5"/>
          <xsl:if test="../DIFF68/DONNEESSECTORIELLES68">
            <td class="clFond clWidth115 clAlignRight">
              <xsl:call-template name="displayNumberXsl">
                <xsl:with-param name="InputStringNumber" select="(../DIFF68/DONNEESSECTORIELLES68/pK00309)"/>
              </xsl:call-template>&#160;
              </td>
            </xsl:if>
          <xsl:if test="not(../DIFF68/DONNEESSECTORIELLES68)">
            <td class="clFond clWidth115 clAlignRight">
              &#160;</td>
            </xsl:if>
        </tr>
      <xsl:call-template name="BreakLineSector"/>
      <tr>
        <th class="clCouleur2 clWidth250 clHeight15 clAlignCenter clThNonGras">STRUCTURE</th>
        <td class="clHeight15 clWidth25"/>
        <td class="clWidth120 clHeight15"/>
        <td class="clWidth120 clHeight15"/>
        <td class="clHeight15 clWidth5"/>
        <td class="clWidth115 clHeight15"/>
      </tr>
      <xsl:call-template name="BreakLineSector"/>
      <tr>
        <th class="clCouleur2 clWidth250 clHeight15 clAlignLeft clThNonGras">&#160;Fonds propres nets / Total du bilan</th>
        <td class="clCouleur2 clWidth25 clAlignCenter">
          %</td>
          <xsl:apply-templates select="../DIFF68/DONNEESINDIVIDUELLES68/pK00311"/>
          <td class="clWidth5"/>
          <xsl:if test="../DIFF68/DONNEESSECTORIELLES68">
            <td class="clFond clWidth115 clAlignRight">
              <xsl:call-template name="displayNumberXsl">
                <xsl:with-param name="InputStringNumber" select="(../DIFF68/DONNEESSECTORIELLES68/pK00311)"/>
              </xsl:call-template>&#160;
              </td>
            </xsl:if>
          <xsl:if test="not(../DIFF68/DONNEESSECTORIELLES68)">
            <td class="clFond clWidth115 clAlignRight">
              &#160;</td>
            </xsl:if>
        </tr>
      <tr>
        <th class="clCouleur2 clWidth250 clHeight15 clAlignLeft clThNonGras">&#160;Endettement Financier / Fonds propres nets</th>
        <td class="clCouleur2 clWidth25 clAlignCenter">
          %</td>
          <xsl:apply-templates select="../DIFF68/DONNEESINDIVIDUELLES68/pK00312"/>
          <td class="clWidth5"/>
          <xsl:if test="../DIFF68/DONNEESSECTORIELLES68">
            <td class="clFond clWidth115 clAlignRight">
              <xsl:call-template name="displayNumberXsl">
                <xsl:with-param name="InputStringNumber" select="(../DIFF68/DONNEESSECTORIELLES68/pK00312)"/>
              </xsl:call-template>&#160;
              </td>
            </xsl:if>
          <xsl:if test="not(../DIFF68/DONNEESSECTORIELLES68)">
            <td class="clFond clWidth115 clAlignRight">
              &#160;</td>
            </xsl:if>
        </tr>
      <tr>
        <th class="clCouleur2 clWidth250 clHeight15 clAlignLeft clThNonGras">&#160;Dettes financ. stables / Fonds propres nets</th>
        <td class="clCouleur2 clWidth25 clAlignCenter">
          %</td>
          <xsl:apply-templates select="../DIFF68/DONNEESINDIVIDUELLES68/pK00317"/>
          <td class="clWidth5"/>
          <xsl:if test="../DIFF68/DONNEESSECTORIELLES68">
            <td class="clFond clWidth115 clAlignRight">
              <xsl:call-template name="displayNumberXsl">
                <xsl:with-param name="InputStringNumber" select="(../DIFF68/DONNEESSECTORIELLES68/pK00317)"/>
              </xsl:call-template>&#160;
              </td>
            </xsl:if>
          <xsl:if test="not(../DIFF68/DONNEESSECTORIELLES68)">
            <td class="clFond clWidth115 clAlignRight">
              &#160;</td>
            </xsl:if>
        </tr>
      <tr>
        <th class="clCouleur2 clWidth250 clHeight15 clAlignLeft clThNonGras">&#160;Dettes financires stables / CAF</th>
        <td class="clCouleur2 clWidth25 clAlignCenter">
          A.m.</td>
          <xsl:apply-templates select="../DIFF68/DONNEESINDIVIDUELLES68/pK00319"/>
          <td class="clWidth5"/>
          <xsl:if test="../DIFF68/DONNEESSECTORIELLES68">
            <td class="clFond clWidth115 clAlignRight">
              <xsl:call-template name="displayNumberXsl">
                <xsl:with-param name="InputStringNumber" select="(../DIFF68/DONNEESSECTORIELLES68/pK00319)"/>
              </xsl:call-template>&#160;
              </td>
            </xsl:if>
          <xsl:if test="not(../DIFF68/DONNEESSECTORIELLES68)">
            <td class="clFond clWidth115 clAlignRight">
              &#160;</td>
            </xsl:if>
        </tr>
      <tr>
        <th class="clCouleur2 clWidth250 clHeight15 clAlignLeft clThNonGras">&#160;FRNG / BFR (2)</th>
        <td class="clCouleur2 clWidth25 clAlignCenter">
          %</td>
          <xsl:apply-templates select="../DIFF68/DONNEESINDIVIDUELLES68/pK00320"/>
          <td class="clWidth5"/>
          <xsl:if test="../DIFF68/DONNEESSECTORIELLES68">
            <td class="clFond clWidth115 clAlignRight">
              <xsl:call-template name="displayNumberXsl">
                <xsl:with-param name="InputStringNumber" select="(../DIFF68/DONNEESSECTORIELLES68/pK00320)"/>
              </xsl:call-template>&#160;
              </td>
            </xsl:if>
          <xsl:if test="not(../DIFF68/DONNEESSECTORIELLES68)">
            <td class="clFond clWidth115 clAlignRight">
              &#160;</td>
            </xsl:if>
        </tr>
      <tr>
        <th class="clCouleur2 clWidth250 clHeight15 clAlignLeft clThNonGras">&#160;Amort. et prov. / Immo. corp. et inc. brutes</th>
        <td class="clCouleur2 clWidth25 clAlignCenter">
          %</td>
          <xsl:apply-templates select="../DIFF68/DONNEESINDIVIDUELLES68/pK00325"/>
          <td class="clWidth5"/>
          <xsl:if test="../DIFF68/DONNEESSECTORIELLES68">
            <td class="clFond clWidth115 clAlignRight">
              <xsl:call-template name="displayNumberXsl">
                <xsl:with-param name="InputStringNumber" select="(../DIFF68/DONNEESSECTORIELLES68/pK00325)"/>
              </xsl:call-template>&#160;
              </td>
            </xsl:if>
          <xsl:if test="not(../DIFF68/DONNEESSECTORIELLES68)">
            <td class="clFond clWidth115 clAlignRight">
              &#160;</td>
            </xsl:if>
        </tr>
      <tr>
        <th class="clCouleur2 clWidth250 clHeight15 clAlignLeft clThNonGras">&#160;Concours banc. + escompte (2) / CA HT (1)</th>
        <td class="clCouleur2 clWidth25 clAlignCenter">
          j</td>
          <xsl:apply-templates select="../DIFF68/DONNEESINDIVIDUELLES68/pK00326"/>
          <td class="clWidth5"/>
          <xsl:if test="../DIFF68/DONNEESSECTORIELLES68">
            <td class="clFond clWidth115 clAlignRight">
              <xsl:call-template name="displayNumberXsl">
                <xsl:with-param name="InputStringNumber" select="(../DIFF68/DONNEESSECTORIELLES68/pK00326)"/>
              </xsl:call-template>&#160;
              </td>
            </xsl:if>
          <xsl:if test="not(../DIFF68/DONNEESSECTORIELLES68)">
            <td class="clFond clWidth115 clAlignRight">
              &#160;</td>
            </xsl:if>
        </tr>
      <xsl:call-template name="BreakLineSector"/>
      <tr>
        <th class="clItalic clWidth250 clHeight15 clAlignLeft clThNonGras">
          &#160;(1) non rintgr. des op.  la commission</th>
          <td class="clCouleur2 clWidth25 clAlignCenter">
            k<img height="9" src="{$root}images/risque/euro_symb_bleu.gif" width="8"/>
            </td>
            <xsl:apply-templates select="../DIFF68/DONNEESINDIVIDUELLES68/pK00061B"/>
            <td class="clWidth5"/>
            <td class="clHeight115"/>
          </tr>
      <tr>
        <th class="clItalic clHeight15 clAlignLeft clThNonGras" colspan="6">
          &#160;(2) hors affacturage et Dailly non comptabiliss en "effets escompts non chus"</th>
          <td class="clAlignRight">
            <a href="#ancHaut">
              <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" alt="Retour en haut de la page"/>
            </a>
            </td>
          </tr>
      <tr>
        <th class="clItalic clHeight15 clAlignLeft clThNonGras" colspan="6">
          &#160;(3) anne de centralisation des ratios sectoriels calcule du 1er juillet de l'anne de rfrence au 30 juin de l'anne suivante.</th>
          <td class="clAlignRight">
            </td>
          </tr>
    </table>
		<!--
 ******************************************************************************************************************************************************************************************
 ******************************************************************************************************************************************************************************************
 
 AFFECTATION spcifique au module 68 (facultatif)

******************************************************************************************************************************************************************************************
******************************************************************************************************************************************************************************************
 -->
		<xsl:if test="../DIFF68/AFFECTATION68">
			<a name="affectation"/>
			<xsl:call-template name="shim"/>
			<table class="clWidth635 clBorderCell" role="presentation">
				<tr class="clAlignCenter">
					<td class="clCouleurGras">AFFECTATION DU RSULTAT DU DERNIER EXERCICE<br/>
					</td>
				</tr>
			</table>
			<xsl:call-template name="shim"/>
			<br/>
			<table class="clWidth635 clBorderCell">
        <caption class="visually-hidden">AFFECTATION DU RSULTAT DU DERNIER EXERCICE</caption>
				<tr>
					<th class="clCouleur2 clWidth200 clHeight15 clAlignLeft clThNonGras">&#160;Rsultat de l'exercice prcdent</th>
					<xsl:apply-templates select="../DIFF68/AFFECTATION68/p0DA"/>
					<td class="clTexte clWidth85">&#160;</td>
					<th class="clCouleur2 clWidth200 clHeight15 clAlignLeft clThNonGras">&#160;Distribution de dividendes</th>
					<xsl:apply-templates select="../DIFF68/AFFECTATION68/pK00036"/>
				</tr>
				<tr>
					<th class="clCouleur2 clWidth200 clHeight15 clAlignLeft clThNonGras">&#160;Report  nouveau antrieur</th>
					<xsl:apply-templates select="../DIFF68/AFFECTATION68/p0CA"/>
					<th class="clCouleur2 clWidth85 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;rparti en&#160;</th>
					<th class="clCouleur2 clWidth200 clHeight15 clAlignLeft clThNonGras">&#160;Report  nouveau</th>
					<xsl:apply-templates select="../DIFF68/AFFECTATION68/pZGA"/>
				</tr>
				<tr>
					<th class="clCouleur2 clWidth200 clHeight15 clAlignLeft clThNonGras">&#160;Prlvements sur rserves</th>
					<xsl:apply-templates select="../DIFF68/AFFECTATION68/p0EA"/>
					<td class="clTexte clWidth85">&#160;</td>
					<th class="clCouleur2 clWidth200 clHeight15 clAlignLeft clThNonGras">&#160;Prlvements sur rserves</th>
					<xsl:apply-templates select="../DIFF68/AFFECTATION68/pK00362"/>
				</tr>
			</table>
		</xsl:if>
		<!--
 ******************************************************************************************************************************************************************************************
 ******************************************************************************************************************************************************************************************
 
 SOCIT(S) CONSOLIDANT L'ENTREPRISE (facultatif)

******************************************************************************************************************************************************************************************
******************************************************************************************************************************************************************************************
 -->
		<xsl:if test="EJ">
			<div class="clBreakPage"/>
		</xsl:if>
		<xsl:call-template name="shim"/>
		<br/>
		<xsl:apply-templates select="EJ"/>
		<xsl:apply-templates select="STECONSO" mode="genLib"/>
	</xsl:template>
	<xsl:template name="BreakLineSector">
		<tr>
			<td class="clWidth250 clHeight10"/>
			<td class="clWidth25 clHeight10"/>
			<td class="clWidth120"/>
			<td class="clWidth120"/>
			<td class="clWidth5"/>
			<td class="clHeight115"/>
		</tr>
	</xsl:template>
	<xsl:template name="BreakLine310">
		<tr>
			<td class="clWidth275 clHeight10"/>
			<td class="clWidth120" colspan="3"/>
		</tr>
	</xsl:template>
	<xsl:template name="BreakLine210">
		<tr>
			<td class="clWidth275 clHeight10"/>
			<td class="clWidth120" colspan="2"/>
		</tr>
	</xsl:template>
	<xsl:template name="BreakLine32">
		<tr>
			<td class="clWidth275 clHeight2"/>
			<td class="clWidth120" colspan="3"/>
		</tr>
	</xsl:template>
	<xsl:template name="BreakLine22">
		<tr>
			<td class="clWidth275 clHeight2"/>
			<td class="clWidth120" colspan="2"/>
		</tr>
	</xsl:template>
	
  <xsl:template match="@DATCLOT">
		<xsl:param name="width" select="120"/>
		<td class="clGrasFond clAlignRight" width="{$width}">
      <xsl:call-template name ="displayDateXsl">
        <xsl:with-param name ="InputDate" select ="(.)"/>
      </xsl:call-template>&#160;
		</td>
		<xsl:if test="position()=last() and position()=1">
			<td class="clGrasFond clAlignRight" width="$width">&#160;</td>
			<td class="clGrasFond clAlignRight" width="$width">&#160;</td>
		</xsl:if>
		<xsl:if test="position()=last() and position()=2">
			<td class="clGrasFond clAlignRight" width="$width">&#160;</td>
		</xsl:if>
	</xsl:template>
    
	
<xsl:template match="@DUREEEX">
		<xsl:param name="width" select="120"/>
		<td class="clFond clWidth120 clAlignRight">
      <xsl:call-template name ="displayDateXsl">
        <xsl:with-param name ="InputDate" select ="(.)"/>
      </xsl:call-template>&#160;
		</td>
		<xsl:if test="position()=last() and position()=1">
			<td class="clFond clAlignRight" width="$width">&#160;</td>
			<td class="clFond clAlignRight" width="$width">&#160;</td>
		</xsl:if>
		<xsl:if test="position()=last() and position()=2">
			<td class="clFond clAlignRight" width="$width">&#160;</td>
		</xsl:if>
	</xsl:template>
	<xsl:template match="p2050AA|pK00001|pK00005|pK00006|pK00007|pK00008|pK00011|pK00015|pK00016|pK00017|pK00018|pK00019|pK00021|pK00022|pK00023|pK00024|pK00025|pK00027|pK00028|pK00029|pK00030|p2057VC|pK00031|pK00032|pK00033|pK00034|p2050CW|p2050CM|p2050CN|pK00035|p2050RP1|p2050RP2|p2050RP3|p20501A|pK00004|pK00010|pK00014|pK00055|p2050CI|p2050CP|p2050CR|p2051DL|p2051DA|p2051DB|p2051DC|pK00038|p2051DH|p2051DI|p2051DJ|p2051DK|p2051DO|p2051DM|p2051DN|p2051DR|p2051DP|p2051DQ|pK00041|pK00043|p2051DS|p2051DT|p2051DU|p2051EH|p2051DV|p2051EI|p2051DW|p2051DX|p2051DY|p2051DZ|p2051EA|p2057VI|p2051EB|p2051ED|p2051EE|p2058YS|pK00048|pK00050|p2051EG|p2057VZ|p2057VZ3|p2057VZ4|p2058YP|pK00059|p2052FL|p2052FJ|p2052FK|pK00061|p2052FC|pK00062|p2052FS|p2052FT|pK00063|pK00064|p2052FM|p2052FN|pK00065|pK00067|p2052FU|p2052FV|p2052FW|p2058YT|p2058YU|pK00052|pK00068|p2052FO|p2052FX|pK00073|pK00075|p2052FP|p2052FQ|pK00077|p2052GE|pK00078|pK00080|p2052GP|p2052GU|p2052GR|pK00082|pK00083|p2053HD|p2053HH|pK00085|p2053HJ|p2053HK|p2053HN|pK00218|pK00170|pK00171|pK00172|pK00217|p2053HE|pK00175|pK00151|pK00152|pK00075
">
		<xsl:param name="bold"/>
		<td class="cl{$bold}Fond clWidth120 clAlignRight">
			<xsl:if test="@ETAT">
				<xsl:value-of select="@ETAT"/>&#160;
			</xsl:if>
			<xsl:if test="not(@ETAT)">
        <xsl:call-template name ="displayNumberXsl">
          <xsl:with-param name ="InputStringNumber" select ="(.)"/>
        </xsl:call-template>&#160;
			</xsl:if>
		</td>
		<xsl:if test="position()=last() and position()=1">
			<td class="cl{$bold}Fond clWidth120 clAlignRight">&#160;</td>
			<td class="cl{$bold}Fond clWidth120 clAlignRight">&#160;</td>
		</xsl:if>
		<xsl:if test="position()=last() and position()=2">
			<td class="cl{$bold}Fond clWidth120 clAlignRight">&#160;</td>
		</xsl:if>
	</xsl:template>
	<xsl:template match="pK00204|pK00249|pK00260|pK00208|pK00261|pK00087|pK00262|pK00267|pK00363|pK00364|pK00234|pK00211|pK00889|pK00223|pK00225|pK00227|pK00228|pK00188|pK00229|pK00230|p2055CR2|pK00231|pK00237|pK00198|pK00193|pK00194|pK00196|pK00203|pK00200|pK00202|pK00206|pK00207|pK00209|pK00235|pK00285|pK00286|pK00287|pK00288|pK00289|pK00293|pK00295|pK00074|pK00221|pK00298|pK00299|pK00300|pK00301|pK00302|pK00303|pK00304|pK00305|pK00365|pK00306|pK00307|pK00308|pK00309|pK00311|pK00312|pK00317|pK00319|pK00320|pK00325|pK00326|pK00061B">
		<xsl:param name="bold"/>
		<td class="cl{$bold}Fond clWidth120 clAlignRight">
			<xsl:if test="@ETAT">
				<xsl:value-of select="@ETAT"/>&#160;
			</xsl:if>
			<xsl:if test="not(@ETAT)">
        <xsl:call-template name ="displayNumberXsl">
          <xsl:with-param name ="InputStringNumber" select ="(.)"/>
        </xsl:call-template>&#160;
			</xsl:if>
		</td>
		<xsl:if test="position()=last() and position()=1">
			<td class="cl{$bold}Fond clWidth120 clAlignRight">&#160;</td>
		</xsl:if>
	</xsl:template>
	<!-- pour les elements affiches  la fois sur 2 et 3 colonnes -->
	<xsl:template match="p2052GR|p2053HK|pK00218" mode="genDF">
		<xsl:param name="bold"/>
		<td class="cl{$bold}Fond clWidth120 clAlignRight">
			<xsl:if test="@ETAT">
				<xsl:value-of select="@ETAT"/>&#160;
			</xsl:if>
			<xsl:if test="not(@ETAT)">
        <xsl:call-template name ="displayNumberXsl">
          <xsl:with-param name ="InputStringNumber" select ="(.)"/>
        </xsl:call-template>&#160;
			</xsl:if>
		</td>
		<xsl:if test="position()=last() and position()=1">
			<td class="cl{$bold}Fond clWidth120 clAlignRight">&#160;</td>
		</xsl:if>
	</xsl:template>
	<xsl:template match="p0DA|p0CA|p0EA|pK00036|pZGA|pK00362">
		<td class="clFond clWidth75 clAlignRight">
			<xsl:if test="@ETAT">
				<xsl:value-of select="@ETAT"/>&#160;
			</xsl:if>
			<xsl:if test="not(@ETAT)">
        <xsl:call-template name ="displayNumberXsl">
          <xsl:with-param name ="InputStringNumber" select ="(.)"/>
        </xsl:call-template>&#160;
			</xsl:if>
		</td>
	</xsl:template>
	<xsl:template match="CODNAF">
		<td class="clGrasFond clWidth120 clAlignRight">
			<xsl:value-of select="(.)"/>&#160;
		</td>
		<xsl:if test="position()=last() and position()=1">
			<td class="clGrasFond clWidth120 clAlignRight">&#160;</td>
		</xsl:if>
	</xsl:template>
	<xsl:template match="STECONSO" mode="genLib">
		<table class="clWidth635 clBorderCell">
			<tr>
				<td class="clCouleur2" colspan="2">&#160;<xsl:apply-templates select="."/>
				</td>
			</tr>
			<tr>
				<td class="clWidth130"/>
				 <td class="clWidth505 clAlignRight">
					<a href="#nullepart" onClick="requestBDFInfos('27|30|66|67|','','1','{/FIBEN/PERSONNE/MODULE60/EJ/IDENTS}',cstMultipleConfirm);">
						<img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" alt="Plus d'infos" border="0"/>
					</a>
				</td>
			</tr>
		</table>
		<xsl:call-template name="shim"/>
		<br/>
	</xsl:template>
	<xsl:template match="EJ">
		<xsl:if test="position()=1">
			<table class="clWidth635 clBorderCell">
        <caption class="visually-hidden">SOCIT(S) CONSOLIDANT L'ENTREPRISE</caption>
				<tr class="clAlignCenter">
					<td class="clCouleurGras">SOCIT(S) CONSOLIDANT L'ENTREPRISE<br/>
					</td>
				</tr>
			</table>
			<xsl:call-template name="shim"/>
			<br/>
			<xsl:text disable-output-escaping="yes">&lt;table width=&quot;635&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;
		</xsl:text>
		</xsl:if>
		<tr>
      <td class="clFond clWidth130 clHeight14">
        &#160;<xsl:call-template name ="displaySirenXsl">
          <xsl:with-param name ="InputSiren" select ="(IDENTS)"/>
        </xsl:call-template>
      </td>
			<td class="clFond clWidth425 clHeight14">&#160;<xsl:value-of select="DENOM"/>
			</td>
      <td class="clFond clWidth80 clAlignRight">
        au <xsl:call-template name ="displayDateXsl">
          <xsl:with-param name ="InputDate" select ="(@DATPERI)"/>
        </xsl:call-template>
      </td>
		</tr>
		<tr>
			<td class="clWidth130"/>
			<td class="clWidth425"/>
			<td class="clWidth80 clAlignRight">
				<a href="#nullepart" onClick="requestBDFInfos('27|30|66|67|','','1','{IDENTS}',cstMultipleConfirm);">
					<img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" alt="Plus d'infos" border="0"/>
				</a>
			</td>
		</tr>
		<xsl:if test="position()=last()">
			<xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
			<xsl:call-template name="shim"/>
			<br/>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="genGraph68">
		<xsl:param name="ident"/>
		<xsl:param name="nom"/>
		<form action="Graphes.aspx" method="post" name="FormGraphes" target="_blank">
			<input name="familyNumber" type="hidden" value="1"/>
			<input name="moduleNumber" type="hidden" value="{/FIBEN/@MODDEM}"/>
			<xsl:element name="input">
				<xsl:attribute name="name">GrapheData</xsl:attribute>
				<xsl:attribute name="type">hidden</xsl:attribute>
				<xsl:attribute name="value">
				&lt;FIBEN MODDEM=&quot;<xsl:value-of select="FIBEN/@MODDEM"/>&quot; DATJOUR=&quot;<xsl:call-template name ="displayDateForGraph2">
          <xsl:with-param name ="InputDateForGraph" select ="FIBEN/@DATJOUR"/>
        </xsl:call-template>&quot; GRAPHE=&quot;1&quot;&gt;
				&lt;ident&gt;<xsl:value-of select="$ident"/>&lt;/ident&gt;
				&lt;nom&gt;<xsl:value-of select="$nom"/>&lt;/nom&gt;

				&lt;graphe&gt;
					<xsl:if test="$condGraph60">
						&lt;serie&gt;
&lt;val&gt;<xsl:value-of select="translate(FIBEN/PERSONNE/MODULE68/DIFF68/DONNEESEXERCICE[position()=last()]/pK00001,',','.')"/>&lt;/val&gt;
&lt;val&gt;<xsl:value-of select="translate(FIBEN/PERSONNE/MODULE68/DIFF68/DONNEESEXERCICE[position()=last()]/pK00021,',','.')"/>&lt;/val&gt;
&lt;val&gt;<xsl:value-of select="number(translate(FIBEN/PERSONNE/MODULE68/DIFF68/DONNEESEXERCICE[position()=last()]/pK00034,',','.'))+number(translate(FIBEN/PERSONNE/MODULE68/DIFF68/DONNEESEXERCICE[position()=last()]/p2050AA,',','.'))+number(translate(FIBEN/PERSONNE/MODULE68/DIFF68/DONNEESEXERCICE[position()=last()]/p2050CW,',','.'))+number(translate(FIBEN/PERSONNE/MODULE68/DIFF68/DONNEESEXERCICE[position()=last()]/p2050CM,',','.'))+number(translate(FIBEN/PERSONNE/MODULE68/DIFF68/DONNEESEXERCICE[position()=last()]/p2050CN,',','.'))"/>&lt;/val&gt;
						&lt;/serie&gt;
						&lt;serie&gt;
&lt;val&gt;<xsl:value-of select="number(translate(FIBEN/PERSONNE/MODULE68/DIFF68/DONNEESEXERCICE[position()=last()]/p2051DL,',','.'))+number(translate(FIBEN/PERSONNE/MODULE68/DIFF68/DONNEESEXERCICE[position()=last()]/p2051DO,',','.'))"/>&lt;/val&gt;
&lt;val&gt;<xsl:value-of select="translate(FIBEN/PERSONNE/MODULE68/DIFF68/DONNEESEXERCICE[position()=last()]/pK00041,',','.')"/>&lt;/val&gt;
&lt;val&gt;<xsl:value-of select="number(translate(FIBEN/PERSONNE/MODULE68/DIFF68/DONNEESEXERCICE[position()=last()]/p2051DR,',','.'))+number(translate(FIBEN/PERSONNE/MODULE68/DIFF68/DONNEESEXERCICE[position()=last()]/p2051EB,',','.'))+number(translate(FIBEN/PERSONNE/MODULE68/DIFF68/DONNEESEXERCICE[position()=last()]/p2051ED,',','.'))"/>&lt;/val&gt;
&lt;val&gt;<xsl:value-of select="translate(FIBEN/PERSONNE/MODULE68/DIFF68/DONNEESEXERCICE[position()=last()]/pK00035,',','.')"/>&lt;/val&gt;							&lt;/serie&gt;
					</xsl:if>
&lt;titre&gt;Grandes masses du bilan de l'exercice <xsl:call-template name ="displayDateXsl">
          <xsl:with-param name ="InputDate" select ="(FIBEN/PERSONNE/MODULE68/DIFF68/DONNEESEXERCICE[position()=last()]/@DATCLOT)"/>
        </xsl:call-template> (en pourcentage du Total bilan)&lt;/titre&gt;&lt;signet&gt;Grandes masses du bilan&lt;/signet&gt;
				&lt;type&gt;NF&lt;/type&gt;
				&lt;/graphe&gt;


				
				&lt;graphe&gt;
					<xsl:if test="$condGraph63">
					&lt;serie&gt;
	&lt;val&gt;<xsl:value-of select="translate(FIBEN/PERSONNE/MODULE68/DIFF68/DONNEESFLUX[position()=last()]/pK00209,',','.')"/>&lt;/val&gt;
	&lt;val&gt;<xsl:value-of select="translate(FIBEN/PERSONNE/MODULE68/DIFF68/DONNEESFLUX[position()=last()]/pK00234,',','.')"/>&lt;/val&gt;
	&lt;val&gt;<xsl:value-of select="translate(FIBEN/PERSONNE/MODULE68/DIFF68/DONNEESFLUX[position()=last()]/pK00235,',','.')"/>&lt;/val&gt;
					&lt;/serie&gt;
					&lt;abcisse&gt;&lt;val&gt;BFR&lt;/val&gt;&lt;val&gt;Variation de tr%E9sorerie&lt;/val&gt;&lt;val&gt;FRNG&lt;/val&gt;&lt;/abcisse&gt;						</xsl:if>
	&lt;titre&gt;Variations du BFR, du FRNG et de la trsorerie de l'exercice <xsl:call-template name ="displayDateXsl">
          <xsl:with-param name ="InputDate" select ="(FIBEN/PERSONNE/MODULE68/DIFF68/DONNEESFLUX[position()=last()]/@DATCLOT)"/>
        </xsl:call-template>&lt;/titre&gt;&lt;signet&gt;Tableau des flux et 	financement&lt;/signet&gt;
				&lt;/graphe&gt;



				&lt;graphe&gt;
					<xsl:if test="$condGraph62">
						&lt;serie&gt;
						<xsl:if test="$condGraph62_1">&lt;val&gt;<xsl:value-of select="//DONNEESEXERCICE[1]/pK00078"/>&lt;/val&gt;</xsl:if>
						<xsl:if test="$condGraph62_2">&lt;val&gt;<xsl:value-of select="//DONNEESEXERCICE[2]/pK00078"/>&lt;/val&gt;</xsl:if>
						<xsl:if test="$condGraph62_3">&lt;val&gt;<xsl:value-of select="//DONNEESEXERCICE[3]/pK00078"/>&lt;/val&gt;</xsl:if>
						&lt;/serie&gt;
						&lt;serie&gt;
						<xsl:if test="$condGraph62_1">&lt;val&gt;<xsl:value-of select="//DONNEESEXERCICE[1]/pK00083"/>&lt;/val&gt;</xsl:if>
						<xsl:if test="$condGraph62_2">&lt;val&gt;<xsl:value-of select="//DONNEESEXERCICE[2]/pK00083"/>&lt;/val&gt;</xsl:if>
						<xsl:if test="$condGraph62_3">&lt;val&gt;<xsl:value-of select="//DONNEESEXERCICE[3]/pK00083"/>&lt;/val&gt;</xsl:if>
						&lt;/serie&gt;
						&lt;serie&gt;
						<xsl:if test="$condGraph62_1">&lt;val&gt;<xsl:value-of select="//DONNEESEXERCICE[1]/p2053HN"/>&lt;/val&gt;</xsl:if>
						<xsl:if test="$condGraph62_2">&lt;val&gt;<xsl:value-of select="//DONNEESEXERCICE[2]/p2053HN"/>&lt;/val&gt;</xsl:if>
						<xsl:if test="$condGraph62_3">&lt;val&gt;<xsl:value-of select="//DONNEESEXERCICE[3]/p2053HN"/>&lt;/val&gt;</xsl:if>
						&lt;/serie&gt;
						&lt;serie&gt;
						<xsl:if test="$condGraph62_1">&lt;val&gt;<xsl:value-of select="//DONNEESEXERCICE[1]/pK00218"/>&lt;/val&gt;</xsl:if>
						<xsl:if test="$condGraph62_2">&lt;val&gt;<xsl:value-of select="//DONNEESEXERCICE[2]/pK00218"/>&lt;/val&gt;</xsl:if>
						<xsl:if test="$condGraph62_3">&lt;val&gt;<xsl:value-of select="//DONNEESEXERCICE[3]/pK00218"/>&lt;/val&gt;</xsl:if>
						&lt;/serie&gt;
						&lt;abcisse&gt;
						<xsl:if test="$condGraph62_1">&lt;val&gt;<xsl:call-template name ="displayDateXsl">
              <xsl:with-param name ="InputDate" select ="(//DONNEESEXERCICE[1]/@DATCLOT)"/>
            </xsl:call-template>       &lt;/val&gt;
						</xsl:if>	
						<xsl:if test="$condGraph62_2">&lt;val&gt;<xsl:call-template name ="displayDateXsl">
                <xsl:with-param name ="InputDate" select ="(//DONNEESEXERCICE[2]/@DATCLOT)"/>
              </xsl:call-template>       &lt;/val&gt;
						</xsl:if>
						<xsl:if test="$condGraph62_3">&lt;val&gt;<xsl:call-template name ="displayDateXsl">
              <xsl:with-param name ="InputDate" select ="(//DONNEESEXERCICE[3]/@DATCLOT)"/>
            </xsl:call-template>				  &lt;/val&gt;
						</xsl:if>
						&lt;/abcisse&gt;
					</xsl:if>
					&lt;titre&gt;Soldes intermdiaires de gestion (en 
          <xsl:call-template name ="displayUnitXsl">
          <xsl:with-param name ="InputUnit" select ="(FIBEN/PERSONNE/MODULE68/DIFF68/@UNITE)"/>
        </xsl:call-template>
          euros)&lt;/titre&gt;
					&lt;unite&gt;<xsl:value-of select="FIBEN/PERSONNE/MODULE68/DIFF68/@UNITE"/>&lt;/unite&gt;
					&lt;signet&gt;Soldes intermdiaires de gestion&lt;/signet&gt;
				&lt;/graphe&gt;




				&lt;graphe&gt;
					<xsl:if test="$condGraph64_1">
						&lt;serie&gt;
						<xsl:if test="$condGraph64_11">&lt;val&gt;<xsl:value-of select="//DONNEESINDIVIDUELLES68[1]/pK00285"/>&lt;/val&gt;</xsl:if>
						<xsl:if test="$condGraph64_12">&lt;val&gt;<xsl:value-of select="//DONNEESINDIVIDUELLES68[1]/pK00289"/>&lt;/val&gt;</xsl:if>
						<xsl:if test="$condGraph64_13">&lt;val&gt;<xsl:value-of select="//DONNEESINDIVIDUELLES68[1]/pK00293"/>&lt;/val&gt;</xsl:if>
						<xsl:if test="$condGraph64_14">&lt;val&gt;<xsl:value-of select="//DONNEESINDIVIDUELLES68[1]/pK00295"/>&lt;/val&gt;</xsl:if>
						&lt;titre&gt;ratios individuels <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="(//DONNEESINDIVIDUELLES68[1]/@DATCLOT)"/>
          </xsl:call-template>&lt;/titre&gt;
						&lt;/serie&gt;
						<xsl:if test="not($isFirstAndLastDI)">
						&lt;serie&gt;
						<xsl:if test="$condGraph64_11">&lt;val&gt;<xsl:value-of select="//DONNEESINDIVIDUELLES68[2]/pK00285"/>&lt;/val&gt;</xsl:if>
						<xsl:if test="$condGraph64_12">&lt;val&gt;<xsl:value-of select="//DONNEESINDIVIDUELLES68[2]/pK00289"/>&lt;/val&gt;</xsl:if>
						<xsl:if test="$condGraph64_13">&lt;val&gt;<xsl:value-of select="//DONNEESINDIVIDUELLES68[2]/pK00293"/>&lt;/val&gt;</xsl:if>
						<xsl:if test="$condGraph64_14">&lt;val&gt;<xsl:value-of select="//DONNEESINDIVIDUELLES68[2]/pK00295"/>&lt;/val&gt;</xsl:if>
						&lt;titre&gt;ratios individuels <xsl:call-template name ="displayDateXsl">
                <xsl:with-param name ="InputDate" select ="(//DONNEESINDIVIDUELLES68[2]/@DATCLOT)"/>
              </xsl:call-template>&lt;/titre&gt;
						&lt;/serie&gt;
						</xsl:if>
						&lt;serie&gt;
						<xsl:if test="$condGraph64_11">&lt;val&gt;<xsl:value-of select="//DONNEESSECTORIELLES68/pK00285"/>&lt;/val&gt;</xsl:if>
						<xsl:if test="$condGraph64_12">&lt;val&gt;<xsl:value-of select="//DONNEESSECTORIELLES68/pK00289"/>&lt;/val&gt;</xsl:if>
						<xsl:if test="$condGraph64_13">&lt;val&gt;<xsl:value-of select="//DONNEESSECTORIELLES68/pK00293"/>&lt;/val&gt;</xsl:if>
						<xsl:if test="$condGraph64_14">&lt;val&gt;<xsl:value-of select="//DONNEESSECTORIELLES68/pK00295"/>&lt;/val&gt;</xsl:if>
						&lt;titre&gt;ratios sectoriels <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="(//DONNEESSECTORIELLES68/@DATSECT)"/>
          </xsl:call-template>&lt;/titre&gt;
						&lt;/serie&gt;
						&lt;abcisse&gt;
						<xsl:if test="$condGraph64_11">&lt;val&gt;Stock/CA HT&lt;/val&gt;</xsl:if>
						<xsl:if test="$condGraph64_12">&lt;val&gt;Clients/CA TTC&lt;/val&gt;</xsl:if>
						<xsl:if test="$condGraph64_13">&lt;val&gt;Fourn./Achat TTC&lt;/val&gt;</xsl:if>
						<xsl:if test="$condGraph64_14">&lt;val&gt;BFR/CA HT&lt;/val&gt;</xsl:if>
						&lt;/abcisse&gt;
					</xsl:if>
					&lt;titre&gt;Ratios d'activit individuels et sectoriels&lt;/titre&gt;
					&lt;signet&gt;Ratios d'activit&lt;/signet&gt;
				&lt;/graphe&gt;
			
				&lt;graphe&gt;
					<xsl:if test="$condGraph64_2">
						&lt;serie&gt;
						<xsl:if test="$condGraph64_21">&lt;val&gt;<xsl:value-of select="//DONNEESINDIVIDUELLES68[1]/pK00299"/>&lt;/val&gt;</xsl:if>
						<xsl:if test="$condGraph64_22">&lt;val&gt;<xsl:value-of select="//DONNEESINDIVIDUELLES68[1]/pK00074"/>&lt;/val&gt;</xsl:if>
						&lt;titre&gt;ratios individuels <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="(//DONNEESINDIVIDUELLES68[1]/@DATCLOT)"/>
          </xsl:call-template>&lt;/titre&gt;
						&lt;/serie&gt;
						<xsl:if test="not($isFirstAndLastDI)">
						&lt;serie&gt;
						<xsl:if test="$condGraph64_21">&lt;val&gt;<xsl:value-of select="//DONNEESINDIVIDUELLES68[2]/pK00299"/>&lt;/val&gt;</xsl:if>
						<xsl:if test="$condGraph64_22">&lt;val&gt;<xsl:value-of select="//DONNEESINDIVIDUELLES68[2]/pK00074"/>&lt;/val&gt;</xsl:if>		
						&lt;titre&gt;ratios individuels <xsl:call-template name ="displayDateXsl">
              <xsl:with-param name ="InputDate" select ="(//DONNEESINDIVIDUELLES68[2]/@DATCLOT)"/>
            </xsl:call-template>&lt;/titre&gt;
						&lt;/serie&gt;
						</xsl:if>
						&lt;serie&gt;
						<xsl:if test="$condGraph64_21">&lt;val&gt;<xsl:value-of select="//DONNEESSECTORIELLES68/pK00299"/>&lt;/val&gt;</xsl:if>
						<xsl:if test="$condGraph64_22">&lt;val&gt;<xsl:value-of select="//DONNEESSECTORIELLES68/pK00074"/>&lt;/val&gt;</xsl:if>		
						&lt;titre&gt;ratios sectoriels <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="(//DONNEESSECTORIELLES68/@DATSECT)"/>
          </xsl:call-template>  &lt;/titre&gt;
						&lt;/serie&gt;
						&lt;abcisse&gt;
						<xsl:if test="$condGraph64_21">&lt;val&gt;VA/CA HT&lt;/val&gt;</xsl:if>
						<xsl:if test="$condGraph64_22">&lt;val&gt;Charges pers./VA&lt;/val&gt;</xsl:if>
						&lt;/abcisse&gt;
					</xsl:if>
				&lt;titre&gt;Ratios de productivit individuels et sectoriels&lt;/titre&gt;
				&lt;signet&gt;Ratios de productivit&lt;/signet&gt;
				&lt;/graphe&gt;
			
				&lt;graphe&gt;
					<xsl:if test="$condGraph64_3">
						&lt;serie&gt;
						<xsl:if test="$condGraph64_31">&lt;val&gt;<xsl:value-of select="//DONNEESINDIVIDUELLES68[1]/pK00303"/>&lt;/val&gt;</xsl:if>
						<xsl:if test="$condGraph64_32">&lt;val&gt;<xsl:value-of select="//DONNEESINDIVIDUELLES68[1]/pK00304"/>&lt;/val&gt;</xsl:if>
						<xsl:if test="$condGraph64_33">&lt;val&gt;<xsl:value-of select="//DONNEESINDIVIDUELLES68[1]/pK00307"/>&lt;/val&gt;</xsl:if>
						<xsl:if test="$condGraph64_34">&lt;val&gt;<xsl:value-of select="//DONNEESINDIVIDUELLES68[1]/pK00308"/>&lt;/val&gt;</xsl:if>
						<xsl:if test="$condGraph64_35">&lt;val&gt;<xsl:value-of select="//DONNEESINDIVIDUELLES68[1]/pK00365"/>&lt;/val&gt;</xsl:if>
						&lt;titre&gt;ratios individuels <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="(//DONNEESINDIVIDUELLES68[1]/@DATCLOT)"/>
          </xsl:call-template>&lt;/titre&gt;
						&lt;/serie&gt;
						<xsl:if test="not($isFirstAndLastDI)">
							&lt;serie&gt;
							<xsl:if test="$condGraph64_31">&lt;val&gt;<xsl:value-of select="//DONNEESINDIVIDUELLES68[2]/pK00303"/>&lt;/val&gt;								</xsl:if>
							<xsl:if test="$condGraph64_32">&lt;val&gt;<xsl:value-of select="//DONNEESINDIVIDUELLES68[2]/pK00304"/>&lt;/val&gt;								</xsl:if>
							<xsl:if test="$condGraph64_33">&lt;val&gt;<xsl:value-of select="//DONNEESINDIVIDUELLES68[2]/pK00307"/>&lt;/val&gt;								</xsl:if>
							<xsl:if test="$condGraph64_34">&lt;val&gt;<xsl:value-of select="//DONNEESINDIVIDUELLES68[2]/pK00308"/>&lt;/val&gt;								</xsl:if>
							<xsl:if test="$condGraph64_35">&lt;val&gt;<xsl:value-of select="//DONNEESINDIVIDUELLES68[2]/pK00365"/>&lt;/val&gt;								</xsl:if>
							&lt;titre&gt;ratios individuels <xsl:call-template name ="displayDateXsl">
              <xsl:with-param name ="InputDate" select ="(//DONNEESINDIVIDUELLES68[2]/@DATCLOT)"/>
            </xsl:call-template>&lt;/titre&gt;
							&lt;/serie&gt;
						</xsl:if>
						&lt;serie&gt;
						<xsl:if test="$condGraph64_31">&lt;val&gt;<xsl:value-of select="//DONNEESSECTORIELLES68/pK00303"/>&lt;/val&gt;</xsl:if>
						<xsl:if test="$condGraph64_32">&lt;val&gt;<xsl:value-of select="//DONNEESSECTORIELLES68/pK00304"/>&lt;/val&gt;</xsl:if>
						<xsl:if test="$condGraph64_33">&lt;val&gt;<xsl:value-of select="//DONNEESSECTORIELLES68/pK00307"/>&lt;/val&gt;</xsl:if>
						<xsl:if test="$condGraph64_34">&lt;val&gt;<xsl:value-of select="//DONNEESSECTORIELLES68/pK00308"/>&lt;/val&gt;</xsl:if>
						<xsl:if test="$condGraph64_35">&lt;val&gt;<xsl:value-of select="//DONNEESSECTORIELLES68/pK00365"/>&lt;/val&gt;</xsl:if>
						&lt;titre&gt;ratios sectoriels <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="(//DONNEESSECTORIELLES68/@DATSECT)"/>
          </xsl:call-template>&lt;/titre&gt;
						&lt;/serie&gt;
						&lt;abcisse&gt;
						<xsl:if test="$condGraph64_31">&lt;val&gt;Marge comm./ventes march.&lt;/val&gt;</xsl:if>
						<xsl:if test="$condGraph64_32">&lt;val&gt;EBE/CA HT&lt;/val&gt;</xsl:if>
						<xsl:if test="$condGraph64_33">&lt;val&gt;Int. Charges assim./EBE&lt;/val&gt;</xsl:if>
						<xsl:if test="$condGraph64_34">&lt;val&gt;Int. Charges assim./CA HT&lt;/val&gt;</xsl:if>
						<xsl:if test="$condGraph64_35">&lt;val&gt;R%E9sult. Net/CA HT&lt;/val&gt;</xsl:if>
					&lt;/abcisse&gt;
				</xsl:if>
				&lt;titre&gt;Ratios de rentabilit individuels et sectoriels&lt;/titre&gt;
				&lt;signet&gt;Ratios de rentabilit&lt;/signet&gt;
				&lt;/graphe&gt;

				&lt;graphe&gt;
					<xsl:if test="$condGraph64_4">
						&lt;serie&gt;
						<xsl:if test="$condGraph64_41">&lt;val&gt;<xsl:value-of select="//DONNEESINDIVIDUELLES68[1]/pK00311"/>&lt;/val&gt;</xsl:if>
						<xsl:if test="$condGraph64_42">&lt;val&gt;<xsl:value-of select="//DONNEESINDIVIDUELLES68[1]/pK00317"/>&lt;/val&gt;</xsl:if>
						<xsl:if test="$condGraph64_43">&lt;val&gt;<xsl:value-of select="//DONNEESINDIVIDUELLES68[1]/pK00320"/>&lt;/val&gt;</xsl:if>
						&lt;titre&gt;ratios individuels <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="(//DONNEESINDIVIDUELLES68[1]/@DATCLOT)"/>
          </xsl:call-template>&lt;/titre&gt;
						&lt;/serie&gt;
						<xsl:if test="not($isFirstAndLastDI)">
							&lt;serie&gt;
							<xsl:if test="$condGraph64_41">&lt;val&gt;<xsl:value-of select="//DONNEESINDIVIDUELLES68[2]/pK00311"/>&lt;/val&gt;								</xsl:if>
							<xsl:if test="$condGraph64_42">&lt;val&gt;<xsl:value-of select="//DONNEESINDIVIDUELLES68[2]/pK00317"/>&lt;/val&gt;								</xsl:if>					
							<xsl:if test="$condGraph64_43">&lt;val&gt;<xsl:value-of select="//DONNEESINDIVIDUELLES68[2]/pK00320"/>&lt;/val&gt;								</xsl:if>
							&lt;titre&gt;ratios individuels <xsl:call-template name ="displayDateXsl">
              <xsl:with-param name ="InputDate" select ="(//DONNEESINDIVIDUELLES68[2]/@DATCLOT)"/>
            </xsl:call-template>&lt;/titre&gt;
							&lt;/serie&gt;
						</xsl:if>
						&lt;serie&gt;
						<xsl:if test="$condGraph64_41">&lt;val&gt;<xsl:value-of select="//DONNEESSECTORIELLES68/pK00311"/>&lt;/val&gt;</xsl:if>
						<xsl:if test="$condGraph64_42">&lt;val&gt;<xsl:value-of select="//DONNEESSECTORIELLES68/pK00317"/>&lt;/val&gt;</xsl:if>
						<xsl:if test="$condGraph64_43">&lt;val&gt;<xsl:value-of select="//DONNEESSECTORIELLES68/pK00320"/>&lt;/val&gt;</xsl:if>
						&lt;titre&gt;ratios sectoriels <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="(//DONNEESSECTORIELLES68/@DATSECT)"/>
          </xsl:call-template>&lt;/titre&gt;
						&lt;/serie&gt;
						&lt;abcisse&gt;
						<xsl:if test="$condGraph64_41">&lt;val&gt;Fds prop. nets/Total Bilan&lt;/val&gt;</xsl:if>
						<xsl:if test="$condGraph64_42">&lt;val&gt;Dettes fin. stab./Fds prop. nets&lt;/val&gt;</xsl:if>
						<xsl:if test="$condGraph64_43">&lt;val&gt;FRNG/BFR&lt;/val&gt;</xsl:if>
						&lt;/abcisse&gt;
						</xsl:if>
					&lt;titre&gt;Ratios de structure individuels et sectoriels en pourcentage&lt;/titre&gt;
					&lt;signet&gt;Ratios de structure en pourcentage&lt;/signet&gt;
				&lt;/graphe&gt;
			
				&lt;graphe&gt;
					<xsl:if test="$condGraph64_5">
						&lt;serie&gt;
						&lt;val&gt;<xsl:value-of select="//DONNEESINDIVIDUELLES68[1]/pK00319"/>&lt;/val&gt;
						&lt;titre&gt;ratios individuels <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="(//DONNEESINDIVIDUELLES68[1]/@DATCLOT)"/>
          </xsl:call-template>&lt;/titre&gt;
						&lt;/serie&gt;
						<xsl:if test="not($isFirstAndLastDI)">
							&lt;serie&gt;
							&lt;val&gt;<xsl:value-of select="//DONNEESINDIVIDUELLES68[2]/pK00319"/>&lt;/val&gt;
							&lt;titre&gt;ratios individuels <xsl:call-template name ="displayDateXsl">
              <xsl:with-param name ="InputDate" select ="(//DONNEESINDIVIDUELLES68[2]/@DATCLOT)"/>
            </xsl:call-template>&lt;/titre&gt;
							&lt;/serie&gt;
						</xsl:if>
						&lt;serie&gt;
						&lt;val&gt;<xsl:value-of select="//DONNEESSECTORIELLES68/pK00319"/>&lt;/val&gt;
						&lt;titre&gt;ratios sectoriels <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="(//DONNEESSECTORIELLES68/@DATSECT)"/>
          </xsl:call-template>&lt;/titre&gt;
						&lt;/serie&gt;
						&lt;abcisse&gt;&lt;val&gt;Dettes fin. stab./CAF&lt;/val&gt;&lt;/abcisse&gt;
					</xsl:if>
				&lt;titre&gt;Ratios de structure individuels et sectoriels en annes-mois&lt;/titre&gt;
				&lt;signet&gt;Ratios de structure en annes-mois&lt;/signet&gt;
				&lt;/graphe&gt;&lt;/FIBEN&gt;

				</xsl:attribute>
			</xsl:element>
		</form>
	</xsl:template>

</xsl:stylesheet>
