﻿Imports System.IO
Imports System.Web.UI.DataVisualization.Charting
Partial Class modules_m67_graphiques_Graphe1
    Inherits System.Web.UI.Page

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load

        'Les données sont récupérées en 2 séries de 6 valeurs + 6 abcisses;
        'il faut les transformer en 6 séries de 2 valeurs + 2 abcisses pour créer le graphe   
        ' de plus il faut éliminer la série où tous les postes comptables sont à '999999'
        ' ainsi que la CAF (6eme poste) dès lors qu'elle est à '999999' pour au moins 1 des 2 années  

        Dim nbSeries As Integer = 6
        Dim nbValues As Integer = 2
        Dim sSerieTitle(nbSeries - 1) As String

        Dim sUnit As String = Request.QueryString("unite")
        Dim sType As String = Request.QueryString("type")

        Dim sTitles(2) As String
        sTitles(0) = "Chiffres-clés consolidés (en " & NewGraphique.sGetUnit(sUnit) & "euros)" 'titre principal
        sTitles(1) = "Date(s) de référence" 'Titre des abcisses
        sTitles(2) = "Montants" 'Titre des ordonnées

        If sType = "NF" Then
            sSerieTitle(0) = "résultat d'exploitation"
            sSerieTitle(1) = "résultat courant avant impôt"
            sSerieTitle(2) = "résultat net"
            sSerieTitle(3) = "résultat net part du groupe"
            sSerieTitle(4) = "résultat net part des minoritaires"
            sSerieTitle(5) = "capacité d'autofinancement"
        End If
        If sType = "IFRS" Then
            sSerieTitle(0) = "résultat opérationnel courant"
            sSerieTitle(1) = "résultat opérationnel"
            sSerieTitle(2) = "résultat net"
            sSerieTitle(3) = "résultat net part du groupe"
            sSerieTitle(4) = "résultat net part des minoritaires"
            sSerieTitle(5) = "capacité d'autofinancement"
        End If

        Using oGraphique As New NewGraphique(Context, nbSeries, nbValues)
            Using imgStream As New MemoryStream()
                oGraphique.QueryStringToDataTableSerieValeurInversee()
                TraitementParticulierGraphique67(oGraphique)
                oGraphique.CreateColumGraphImage(sSerieTitle, sTitles, NewGraphique.Style_None).SaveImage(imgStream, ChartImageFormat.Png)
                'Output the contents of the watermarked image stream
                Response.ContentType = "image/png"
                Response.BinaryWrite(imgStream.GetBuffer())
            End Using
        End Using

       

    End Sub
    ''' <summary>
    ''' il faut éliminer la série ou l' abcisse =0 
    ''' ainsi que la CAF (6eme poste) dès lors qu'elle est à '999999' pour au moins 1 des 2 années  
    ''' </summary>
    ''' <param name="oGraph"></param>
    ''' <remarks></remarks>
    Private Sub TraitementParticulierGraphique67(ByVal oGraph As NewGraphique)
        Dim bsuppCol As Boolean = False

        'suppression serie vide
        If (String.IsNullOrEmpty(oGraph.data(0)("Abs").ToString()) OrElse oGraph.data(0)("Abs").ToString() = "0") Then
            oGraph.data(0).Delete()
            oGraph.nbValues = 1
        End If
        If (String.IsNullOrEmpty(oGraph.data(1)("Abs").ToString()) OrElse oGraph.data(1)("Abs").ToString() = "0") Then
            oGraph.data(1).Delete()
            oGraph.nbValues = 1
        End If

        'suppression 6e serie si 9999999
        For Each r As DataRow In oGraph.data.Rows
            If r("Col6") = 999999 Then
                bsuppCol = True
            End If
            r("Abs") = r("Abs").ToString.Trim()
        Next
        If bsuppCol Then
            oGraph.data.Columns.Remove("Col6")
            oGraph.nbSeries = 5
        End If
    End Sub

End Class
