<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:bdf="http://banque-france.fr/namespace">
  <xsl:import href="../../Ressources/XSL/Commun.xsl"/>
  <xsl:import href="../../Ressources/XSL/commun_transfo.xsl"/>
  <xsl:import href="../../Ressources/XSL/Commun_bilans.xsl"/>
  <xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes"/>
  <xsl:param name="langage" select="'fr'"/>
  <xsl:param name="familyName" select="''"/>
  <xsl:param name="familyNumber" select="''"/>
  <xsl:param name="familyTitle" select="''"/>
  <xsl:param name="root" select="'/Fiben/'"/>
  <xsl:param name="nextModule" select="''"/>
  <xsl:param name="nextId" select="''"/>
  <xsl:param name="nextFamily" select="''"/>
  <xsl:param name="Lang" select="'FR'"/>
  <xsl:param name="NonResident" select="''"/>
  <xsl:param name="menuHTML1"/>
  <xsl:variable name="condGraph60" select="(boolean(//DONNEESCONSO[position()=last()]/BILAN67) and not(boolean(//DONNEESCONSO[position()=last()]/BILAN67/p2011CA/@ETAT|//DONNEESCONSO[position()=last()]/BILAN67/pK01143/@ETAT|//DONNEESCONSO[position()=last()]/BILAN67/pK01151/@ETAT|//DONNEESCONSO[position()=last()]/BILAN67/pK01880/@ETAT|//DONNEESCONSO[position()=last()]/BILAN67/p2011DJ/@ETAT|//DONNEESCONSO[position()=last()]/BILAN67/p2011EE/@ETAT|//DONNEESCONSO[position()=last()]/BILAN67/pK01171/@ETAT|//DONNEESCONSO[position()=last()]/BILAN67/pK01172/@ETAT|//DONNEESCONSO[position()=last()]/BILAN67/pK01174/@ETAT|//DONNEESCONSO[position()=last()]/BILAN67/pK01177/@ETAT|//DONNEESCONSO[position()=last()]/BILAN67/pK01882/@ETAT|//DONNEESCONSO[position()=last()]/BILAN67/p2012HZ/@ETAT|//DONNEESCONSO[position()=last()]/BILAN67/p2012IY/@ETAT|//DONNEESCONSO[position()=last()]/BILAN67/pK01187/@ETAT))  and boolean(number(translate(//DONNEESCONSO[position()=last()]/BILAN67/pK01171,',','.'))>=0) and boolean(number(translate(//DONNEESCONSO[position()=last()]/BILAN67/pK01187,',','.'))!=0)) or (boolean(//DONNEESCONSO[position()=last()]/BILAN67IFRS) and not(boolean(//DONNEESCONSO[position()=last()]/BILAN67IFRS/pK02399/@ETAT|//DONNEESCONSO[position()=last()]/BILAN67IFRS/pK02403/@ETAT|//DONNEESCONSO[position()=last()]/BILAN67IFRS/p2011EAR/@ETAT|//DONNEESCONSO[position()=last()]/BILAN67IFRS/pK02411/@ETAT|//DONNEESCONSO[position()=last()]/BILAN67IFRS/pK02419/@ETAT|//DONNEESCONSO[position()=last()]/BILAN67IFRS/pK02423/@ETAT|//DONNEESCONSO[position()=last()]/BILAN67IFRS/p2018FBJ/@ETAT|//DONNEESCONSO[position()=last()]/BILAN67IFRS/p2011DS/@ETAT))and boolean(number(translate(//DONNEESCONSO[position()=last()]/BILAN67IFRS/pK02411,',','.'))>=0) and boolean(number(translate(//DONNEESCONSO[position()=last()]/BILAN67IFRS/p2011DS,',','.'))!=0))"/>
  <xsl:variable name="condGraph63" select="not(boolean(//DONNEESCONSO[position()=last()]/TABLEAUFINANCEMENT/p2015UK/@ETAT|//DONNEESCONSO[position()=last()]/TABLEAUFINANCEMENT/p2015UJ/@ETAT|//DONNEESCONSO[position()=last()]/TABLEAUFINANCEMENT/p2015UN/@ETAT)) and (//DONNEESCONSO[position()=last()]/TABLEAUFINANCEMENT/p2015UK != 0 and //DONNEESCONSO[position()=last()]/TABLEAUFINANCEMENT/p2015UJ != 0 and //DONNEESCONSO[position()=last()]/TABLEAUFINANCEMENT/p2015UN != 0) and (//DONNEESCONSO[position()=last()]/TABLEAUFINANCEMENT/p2015UK != '0,00' and //DONNEESCONSO[position()=last()]/TABLEAUFINANCEMENT/p2015UJ != '0,00' and //DONNEESCONSO[position()=last()]/TABLEAUFINANCEMENT/p2015UN != '0,00') and (//DONNEESCONSO[position()=last()]/TABLEAUFINANCEMENT/p2015UK != '0,0' and //DONNEESCONSO[position()=last()]/TABLEAUFINANCEMENT/p2015UJ != '0,0' and //DONNEESCONSO[position()=last()]/TABLEAUFINANCEMENT/p2015UN != '0,0')"/>
  <xsl:variable name="condGraph66" select="boolean(//DONNEESCONSO/RESULTAT)or boolean(//DONNEESCONSO/RESULTATIFRS)"/>
  <xsl:variable name="condGraph" select="boolean($condGraph60 or $condGraph63 or $condGraph66)"/>
  <xsl:template match="/">
    <html lang="fr">
      <title>Module 67 - Dossier comptes consolids</title>
      <xsl:call-template name="genHead">
        <xsl:with-param name="ident" select="FIBEN/ERREUR/IDENT | FIBEN/PERSONNE/MODULE67/EJ/IDENTS"/>
      </xsl:call-template>
      <body class="clBodybgcolorWhite">
        <xsl:call-template name="genFondMenu">
          <xsl:with-param name="root" select="$root"/>
        </xsl:call-template>
        <xsl:copy-of select="$menuHTML1"/>
        
        <table class="mainmodule horizontal-auto clBorderCell">
          <caption class="visually-hidden">Module 67 - Dossier comptes consolids</caption>
          <xsl:call-template name="genLigneConfidentiel" />
          <xsl:apply-templates select="/FIBEN/ERREUR"/>
          <xsl:if test="not(/FIBEN/ERREUR)">

            <tr>
              <td class="clWidth64"></td>
              <td class="clCouleur2 clValignTop clWidth739" colspan="4">
                <xsl:apply-templates select="FIBEN/PERSONNE/MODULE67/EJ"/>
                <xsl:apply-templates select="FIBEN/PERSONNE/MODULE67/IEC01|FIBEN/PERSONNE/MODULE67/IST/IST08|FIBEN/PERSONNE/MODULE67/IST/IST03|FIBEN/PERSONNE/MODULE67/IST/IST04|FIBEN/PERSONNE/MODULE67/IST/IST10" mode="genLib"/>
                <xsl:apply-templates select="FIBEN/PERSONNE/MODULE67/IST/EJ"/>
                <xsl:apply-templates select="FIBEN/PERSONNE/MODULE67/DIFF67"/>
              </td>
            </tr>
                       
          </xsl:if>
        </table>
        <xsl:call-template name="genBasPage"/>
        <!-- appel du template avec parametre segment  pas -->
        <xsl:choose>
          <xsl:when test ="/FIBEN/PERSONNE/MODULE67/DIFF67/SEGMENT">
            <xsl:call-template name="genGraph67">
              <xsl:with-param name="ident" select="/FIBEN/PERSONNE/MODULE67/EJ/IDENTS"/>
              <xsl:with-param name="nom" select="/FIBEN/PERSONNE/MODULE67/EJ/DENOM"/>
              <xsl:with-param name="valcot" select="/FIBEN/PERSONNE/MODULE67/DIFF67/VALCOT"/>
              <xsl:with-param name="segment" select="/FIBEN/PERSONNE/MODULE67/DIFF67/SEGMENT"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
            <xsl:call-template name="genGraph67">
              <xsl:with-param name="ident" select="/FIBEN/PERSONNE/MODULE67/EJ/IDENTS"/>
              <xsl:with-param name="nom" select="/FIBEN/PERSONNE/MODULE67/EJ/DENOM"/>
              <xsl:with-param name="valcot" select="/FIBEN/PERSONNE/MODULE67/DIFF67/VALCOT"/>
            </xsl:call-template>
          </xsl:otherwise>
        </xsl:choose>

  
      </body>
    </html>
  </xsl:template>

  <xsl:template match="FIBEN/PERSONNE/MODULE67/EJ">
    <!-- appel du template avec parametre segment  pas -->
    <xsl:choose>
      <xsl:when test ="//DIFF67/SEGMENT">
        <xsl:call-template name="genEnTete">
          <xsl:with-param name="ident" select="IDENTS"/>
          <xsl:with-param name="nom" select="DENOM"/>
          <xsl:with-param name="valcot" select="//DIFF67/VALCOT"/>
          <xsl:with-param name="segment" select="//DIFF67/SEGMENT"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="genEnTete">
          <xsl:with-param name="ident" select="IDENTS"/>
          <xsl:with-param name="nom" select="DENOM"/>
          <xsl:with-param name="valcot" select="//DIFF67/VALCOT"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>

  </xsl:template>

  <xsl:template match="IEC01|IST08|IST03|IST04|IST10" mode="genLib">
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr class="clAlignLeft">
        <td class="clCouleur2">
          <xsl:apply-templates select="."/>
          <br/>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
  </xsl:template>

  <xsl:template match="DIFF67">
    <table class="clWidth635 clBorderCell">
      <caption class="visually-hidden">Informations sur le groupe dont l'entit interroge est entit consolidante</caption>
      <tr>
        <th class="clCouleur2 clWidth130 clAlignLeft clThNonGras">&#160;Nom du groupe</th>
        <td class="clFond clWidth505">
          &#160;<xsl:value-of select="../DIFF67/NOMGROUP"/>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
    <xsl:if test="SURGROUPE">
      <table class="clWidth635 clBorderCell" role="presentation">
        <tr>
          <th colspan="2" class="clCouleur2 clHeight16 clAlignLeft clThNonGras">&#160;Prsence de sur-groupe(s)</th>
        </tr>
      </table>
      <table class="clWidth635 clBorderCell" role="presentation">
        <xsl:apply-templates select="../DIFF67/SURGROUPE"/>
      </table>
      <xsl:call-template name="shim"/>
      <br/>
    </xsl:if>
    <xsl:if test="SOUSGROUPE">
      <table class="clWidth635 clBorderCell" role="presentation">
        <tr>
          <th colspan="2" class="clCouleur2 clHeight16 clAlignLeft clThNonGras">
            Prsence de sous-groupe(s)<br/>
          </th>
        </tr>
      </table>
      <table class="clWidth635 clBorderCell" role="presentation">
        <xsl:apply-templates select="../DIFF67/SOUSGROUPE"/>
      </table>
      <xsl:call-template name="shim"/>
      <br/>
    </xsl:if>
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
        <th colspan="2" class="clCouleur2 clHeight16 clAlignLeft clThNonGras">&#160;Activit principale du groupe</th>
      </tr>
      <tr>
        <xsl:variable name="element" select="../DIFF67/ACTGR/@COACT"/>
        <td class="clFond clWidth130">
          &#160;<xsl:value-of select="$element"/>
        </td>
        <td class="clFond clWidth505">
          &#160;<xsl:value-of select="$dictionnaire//division[@id=$element]/text()"/>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
        <th class="clCouleur2 clWidth150 clAlignLeft clThNonGras">&#160;Documents comptables</th>
        <td class="clFond clWidth300">&#160;COMPTES CONSOLIDS</td>
        <td class="clCouleur2 clWidth185 clAlignRight">&#160;&#160;(exprims en milliers d'euros)</td>
      </tr>
      <tr>
       <td class="clWidth150 clHeight10"/>
        <td class="clWidth300 clHeight10"/>
        <td class="clWidth185 clHeight10"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth150 clAlignLeft clThNonGras">&#160;Norme comptable utilise</th>
        <td class="clFond clWidth300">
          &#160;<xsl:value-of select="../DIFF67/NORMCPT"/>
        </td>
        <td class="clFond clWidth185 clHeight14"/>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
    <!-- Date de clture + Dure + Effectif du groupe  -->
    <table class="clWidth739 clBorderCell" role="presentation">
      <tr>
        <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Date de clture</th>
        <xsl:apply-templates select="../DIFF67/DONNEESCONSO/@DATCLOT">
          <xsl:with-param name="largeur">140</xsl:with-param>
        </xsl:apply-templates>
        <td class="clWidth104 clAlignRight">&#160;</td>
        
      </tr>
      <tr>
        <td colspan="3"/>
      </tr>
      <tr>
        <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Dure</th>
        <xsl:apply-templates select="../DIFF67/DONNEESCONSO/@DUREEEX"/>
        <td class="clWidth104 clAlignRight">&#160;</td>
        
      </tr>
      <tr>
        <th class="clCouleur2 clAlignLeft clThNonGras">&#160;Effectif du groupe</th>
        <xsl:apply-templates select="../DIFF67/DONNEESCONSO/pEFFECT"/>
      </tr>
      <tr>
        <th class="clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dont effectif  l'tranger</th>
        <xsl:apply-templates select="../DIFF67/DONNEESCONSO/pEFFETRG"/>
      </tr>
    </table>
    <div class="clBreakPage"/>
    <xsl:call-template name="shim"/>
    <br/>

    <!--  creation de deux nouveaux template pour distinguer bilan67/bilan67IFRS  -->

    <xsl:call-template name="BILAN67"/>
    <xsl:call-template name="RESULTAT"/>
    <xsl:call-template name="TABLEAUFINANCEMENT"/>
    <xsl:call-template name="TABLEAUFLUX"/>
    <xsl:call-template name="ANALYSEFINANCIERE"/>
    <xsl:call-template name="PERIMETRE"/>
    <!--	 ******************************************************************************************************************************************************************************************
 ******************************************************************************************************************************************************************************************
 
 LISTE DES SOCITI(S) CONSOLIDANT L'ENTREPRISE (facultatif)

******************************************************************************************************************************************************************************************
******************************************************************************************************************************************************************************************
 -->
    <xsl:if test="EJ">
      <div class="clBreakPage"/>
    </xsl:if>
    <xsl:call-template name="shim"/>
    <br/>
    <xsl:apply-templates select="../DIFF67/EJ"/>
    <!--
 ******************************************************************************************************************************************************************************************
 ******************************************************************************************************************************************************************************************
 
 FIN DU TRAITEMENT DE DIFF67

******************************************************************************************************************************************************************************************
******************************************************************************************************************************************************************************************
 -->

  </xsl:template>

  <!-- BILAN CONSOLID NORME FRANCAISE -->
  <xsl:template name="BILAN67">
    <xsl:if test="../DIFF67/DONNEESCONSO/BILAN67">
      <a name="bilan"/>
      <table class="clWidth739 clBorderCell" role="presentation">
        <tr>
           <td class="clWidth19">&#160;</td>
         <td class="clCouleurGras clWidth597 clAlignCenter">BILAN CONSOLID</td>
          <td>
            <xsl:if test="$condGraph60">
              <a href="#nullepart" onclick="window.document.forms['FormGraphes'].action='Graphes.aspx#Graphe1';window.document.forms['FormGraphes'].submit();">
                <img border="0" src="{$root}Images/risque/diagramme_bleu.gif" width="19" height="20" alt="lien vers diagramme"/>
              </a>
            </xsl:if>
            <xsl:if test="not($condGraph60)">
              <img border="0" src="{$root}Images/boutons/diagramme_in.gif" width="19" height="20" alt="diagramme non disponible"/>
            </xsl:if>
          </td>
           <td class="clAlignRight">
            <a href="#ancHaut">
              <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" alt="Retour en haut de la page"/>
            </a>
          </td>
        </tr>
      </table>
      <xsl:call-template name="shim"/>
      <br/>
      <table class="clWidth739 clBorderCell">
        <caption class="visually-hidden">BILAN CONSOLID</caption>
        <!--  ****************************************************          ACTIF         **************************************************** -->
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Date d'arrt</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/@DATCLOT">
            <xsl:with-param name="largeur">140</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <tr>
          <td colspan="3"/>
        </tr>
        <tr>
          <td class="clWidth355 clCouleur2 clAlignCenter clThNonGras">ACTIF</td>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Capital souscrit non appel</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/p2011CA">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;ACTIF IMMOBILIS (1)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/pK01143">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
          <td class="clCouleur2">&#160;</td>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'2'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Immobilisations incorporelles</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/p2011CB"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dont Fonds commercial</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/p2011CC"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dont Marques</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/p2011CD"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dont Parts de march</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/p2011CF"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;carts d'acquisition</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/pK01144"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Immobilisations corporelles</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/p2011CH"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dont Immobilisations acquises en crdit bail</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/p2011CI"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Immobilisations financires</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/p2011CK"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Titres mis en quivalence</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/p2011CN"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Autres valeurs immobilises</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/pK01694"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;ACTIF CIRCULANT (1) (3)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/pK01151">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'2'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Stocks et en-cours</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/p2011CT"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Avances et acomptes verss</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/p2011CY"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Crances</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/pK01879"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dont Clients et comptes rattachs</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/pK01145"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dont Impts diffrs actif</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/pK01149"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Valeurs mobilires de placement</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/p2011DF"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Disponibilits</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/p2011DH"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Comptes de rgularisation et autres postes (3)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/pK01880">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Actifs du secteur financier</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/p2011DJ">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Actifs nets en cours de cession</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/p2011EE">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;TOTAL GNRAL</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/pK01154">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clItalic clAlignLeft clThNonGras">&#160;(1) Aprs amortissements et provisions</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/p2011DT">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <tr>
          <th class="clWidth355 clItalic clAlignLeft clThNonGras">&#160;Sur actif immobilis</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/p2011DU"/>
        </tr>
        <tr>
          <th class="clWidth355 clItalic clAlignLeft clThNonGras">&#160;&#160;Dont Amortissements sur cart d'acquisition</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/p2011DV"/>
        </tr>
        <tr>
          <th class="clWidth355 clItalic clAlignLeft clThNonGras">&#160;&#160;Dont Amortissements sur immobilisations corporelles</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/p2011DW"/>
        </tr>
        <tr>
          <th class="clWidth355 clItalic clAlignLeft clThNonGras">&#160;&#160;Dont Provisions sur immobilisations financires</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/p2011DX"/>
        </tr>
        <tr>
          <th class="clWidth355 clItalic clAlignLeft clThNonGras">&#160;Sur actif circulant</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/p2011DY"/>
        </tr>
        <tr>
          <th class="clWidth355 clItalic clAlignLeft clThNonGras">&#160;&#160;(2) Dont Part  moins d'un an</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/p2011EA"/>
        </tr>
        <tr>
          <th class="clWidth355 clItalic clAlignLeft clThNonGras">&#160;&#160;(3) Dont Part  plus d'un an</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/p2011EB"/>
        </tr>
        <!--  ****************************************************          PASSIF         **************************************************** -->
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr class="clBreakPage">
          <th class="clWidth355 clCouleur2 clAlignCenter clThNonGras">PASSIF</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/@DATCLOT">
            <xsl:with-param name="largeur">140</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;CAPITAUX PROPRES (GROUPE)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/pK01166">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'2'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dont Capital</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/p2012GA"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dont Prime</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/p2012GB"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dont Rserves</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/pRESERVES"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dont cart de conversion</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/p2012GE"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dont Report  nouveau</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/p2012GF"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dont cart de 1re consolidation avec cration d' actions</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/p2012GI"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dont Actions propres ( - )</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/p2012GK"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dont Rsultat part du groupe</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/pRESPRTGR"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;INTRTS MINORITAIRES</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/pK01167">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'2'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dont Rsultat part des minoritaires</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/pRESPRTMI"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;CAPITAUX PROPRES TOTAUX</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/pK01171">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;FONDS NON REMBOURSABLES</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/pK01172">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'2'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dont Titres participatifs</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/p2012GQ"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dont Titres subordonns  dure indtermine (TSDI)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/p2012GR"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;PROVISIONS POUR RISQUES ET CHARGES</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/pK01174">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'2'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dont Provisions pour retraites</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/p2012GW"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dont Provisions pour impts diffrs</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/pK01175"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dont Provisions pour restructuration</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/p2012GY"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dont Provisions pour carts d'acquisition ngatifs</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/pK01176"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;DETTES (1)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/pK01177">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dettes Financires</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/pK01178"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;&#160;Dont Emprunts obligataires convertibles</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/p2012HC"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;&#160;Dont Autres emprunts obligataires</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/p2012HD"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;&#160;Dont TSDI reconditionns</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/p2012IX"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;&#160;Dont Emprunts participatifs</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/p2012HB"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;&#160;Dont Emprunts et dettes auprs des Etab de crdit</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/pK01179"/>
        </tr>
        
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;Dont Concours bancaires et soldes crditeurs</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/p2012HF"/>
       </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;&#160;Dont Crdit-bail</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/p2012HI"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Avances et acomptes reus</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/p2012HO"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dettes fournisseurs et comptes rattachs</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/p2012HP"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Autres dettes</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/pK01881"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Comptes de rgularisation et autres postes (1)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/pK01882">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Passifs du secteur financier</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/p2012HZ">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Passifs nets en cours de cession</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/p2012IY">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;TOTAL GNRAL</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/pK01187">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clItalic clAlignLeft clThNonGras">&#160;(1) Dont Part  moins d'un an</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/pK01188"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;AUTRES ENGAGEMENTS</th>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'2'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Effets escompts non chus et aut. crances cdes</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/pK01282"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Engagements de crdit-bail  payer</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67/p2012IN"/>
        </tr>
      </table>
    </xsl:if>
    <!-- ********* BILAN AUX NORMES IFRS ************************* -->

    <xsl:if test="../DIFF67/DONNEESCONSO/BILAN67IFRS">
      <a name="bilan"></a>
      <table class="clWidth739 clBorderCell" role="presentation">
        <tr>
           <td class="clWidth19">&#160;</td>
         <td class="clCouleurGras clWidth597 clAlignCenter">BILAN CONSOLID</td>
          <td>
            <xsl:if test="$condGraph60">
              <a href="#nullepart" onclick="window.document.forms['FormGraphes'].action='Graphes.aspx#Graphe1';window.document.forms['FormGraphes'].submit();">
                <img border="0" src="{$root}Images/risque/diagramme_bleu.gif" width="19" height="20" alt="lien vers diagramme"/>
              </a>
            </xsl:if>
            <xsl:if test="not($condGraph60)">
              <img border="0" src="{$root}Images/boutons/diagramme_in.gif" width="19" height="20" alt="diagramme non disponible"/>
            </xsl:if>
          </td>
           <td class="clAlignRight">
            <a href="#ancHaut">
              <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" alt="Retour en haut de la page"/>
            </a>
          </td>
        </tr>
      </table>
      <img width="635" height="1" vspace="8" src="{$root}Images/risque/shim_bleu.gif" alt=""/>
      <br/>
      <table class="clWidth739 clBorderCell">
        <caption class="visually-hidden">BILAN CONSOLID</caption>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Date d'arrt</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/@DATCLOT">
            <xsl:with-param name="largeur">140</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <tr>
          <td colspan="3"></td>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">ACTIF</th>
        </tr>
        <tr>
          <td class="clWidth355 clHeight6"></td>
          <td class="clWidth140 clHeight6" colspan="2"></td>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">ACTIF NON COURANT (1)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/pK02399">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clHeight10 clAlignLeft clThNonGras">Dont immo. mises en concession </th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2011CS"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'6'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Immobilisations incorporelles</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/pK02395"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Dont Frais de dveloppement</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2011EJ"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Dont logiciels</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2011EI"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Dont Brevets, droits et assimils</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2011EG"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Dont Marques</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2011CD"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Dont Fichier clients</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2011EK"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Dont Autres immo. incorporelles issues d'une acquisition</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2011EBA"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'6'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">carts d'acquisition (1)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/pK02396"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'6'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clHeight10 clAlignLeft clThNonGras">Immobilisations corporelles (1) (2)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2011CH"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Dont Terrains et constructions</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2011EN"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Dont Immobilisations donnes en location</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2011EBB"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Dont Actifs biologiques</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2011EP"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Dont Immeubles de placement</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2011EQ"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Dont quipements</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2011ER"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Dont Matriels de transport</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2011ES"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'6'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Immobilisations financires</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2011CK"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clHeight10 clAlignLeft clThNonGras">Prts et crances</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2011CL"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Dont groupe et associs</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2011EU"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Participations non consolides</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2011CM"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'6'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Titres mis en quivalence</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2011CN"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Dont carts d'acquisition (1)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2011EV"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Dont Socits contrles conjointement</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2011EW"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'6'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Impts diffrs actif (3)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2011EX"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'6'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Autres actifs non courants</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2011EZ"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Dont surplus sur engagements de retraite</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2011EAA"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Dont trsor. ou quiv. donns en garantie</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2011EAB"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'6'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">ACTIF COURANT (1) (5)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/pK02403">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>       
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Stocks et en cours</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2011CT"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Marchandises</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2011CU"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Matires premires et approvisionnement</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2011CV"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Produits finis et en-cours</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2011CW"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Travaux en cours sur contrat</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2011CX"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'6'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Crances oprationnelles</th>
           <td class="clWidth140" colspan="2"></td>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Avances et acomptes verss</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2011CY"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Clients et comptes rattachs(4) (6)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2011CZ"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Autres crances oprationnelles(4) (6)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2011DC"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Charges constates d'avance</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2011EAJ"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'6'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Instruments de couverture</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2011EAK"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Actifs financiers court-terme</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2011EAL"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Dont Actions</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2011EAM"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Dont prts (4)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2011EAN"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Trsorerie et quivalents de trsorerie</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/pK02402"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Autres actifs court-terme (4)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2011EAZ"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'6'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">ACTIFS DESTINS A LA VENTE</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2011EAR">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'6'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">TOTAL GNRAL</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2011DS">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'6'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clItalic clAlignLeft clThNonGras">(1) Amortissements et provisions s/actif non courant</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2011EAS">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <tr>
          <th class="clWidth355 clItalic clHeight16 clAlignLeft clThNonGras">&#160;   Dont Dprciation cart d'acquisition</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2011EAT"/>
        </tr>
        <tr>
          <th class="clWidth355 clItalic clAlignLeft clThNonGras">  &#160;      Dont Amorts immob. incorp.</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2011EH"/>
        </tr>
        <tr>
          <th class="clWidth355 clItalic clAlignLeft clThNonGras"> &#160;  Dont Amorts immob. corp.</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2011DW"/>
        </tr>
        <tr>
          <th class="clWidth355 clItalic clAlignLeft clThNonGras">&#160;   Dont Provisions sur immo financ.</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2011DX"/>
        </tr>
        <tr>
          <th class="clWidth355 clItalic clAlignLeft clThNonGras"> &#160;  Amortissements et provisions s/actif courant</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2011EAU"/>
        </tr>
        <tr>
          <th class="clWidth355 clItalic clAlignLeft clThNonGras">(2) Immobilisations acquises en crdit-bail</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2011EAW"/>
        </tr>
        <tr>
          <th class="clWidth355 clItalic clAlignLeft clThNonGras">(3) Impts diffrs actif  moins d'un an</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2011EY"/>
        </tr>
        <tr>
          <th class="clWidth355 clItalic clAlignLeft clThNonGras">(4) Dont Groupe et associs</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/pK02404"/>
        </tr>
        <tr>
          <th class="clWidth355 clItalic clAlignLeft clThNonGras">(5) Dont Actif courant  plus d'un an (total)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2011EAY"/>
        </tr>
        <tr>
          <th class="clWidth355 clItalic clAlignLeft clThNonGras">(6) Dont mobiliss ou titriss</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/pK02405"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'6'"/>
        </xsl:call-template>
        <tr class="clBreakPage">
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">PASSIF</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/@DATCLOT">
            <xsl:with-param name="largeur">140</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'7'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">CAPITAUX PROPRES TOTAUX</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/pK02411">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'2'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Capitaux propres groupe</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/pK02409"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Capital</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2018FA"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Primes</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/pK02455"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Capital souscrit non appel (-)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2018FC"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Rserves</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/pK02408"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Dont Instruments financiers ass.  C.P.</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/pK02671"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">lements compt. direct. en cap. propres</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2018FBU"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Dont Rvaluation des actifs non financiers</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/pK03724"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Dont Rvaluation instr. financiers disp.  la vente</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/pK03725"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Dont &#201;carts de conversion</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/pK03726"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Dont &#201;carts lis aux instruments de couverture</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/pK03727"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Dont autres lments directement comptabiliss en cap.Propres </th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/pK03728"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Actions propres (-)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2018FJ"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Rsultat part du groupe</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2019SBL">
            <xsl:with-param name="largeur">140</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'7'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">INTRTS MINORITAIRES</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/pK02410">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Dont Rsultat part des minoritaires</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2019SBM">
            <xsl:with-param name="largeur">140</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'7'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">PASSIF NON COURANT</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/pK02419">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Provisions (7)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2018FO"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Dont Provisions pour restructuration</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2018FQ"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Dont Provisions environnementales</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2018FR"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Dont Provisions pour litiges &amp; risques commerciaux</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/pK02457"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'7'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Engagements de retraite (8)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/pK02412"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Impts diffrs passif (9)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2018FW"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'7'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Dettes  long terme</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/pK02418"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Dettes financires  long terme(10, 11, 12)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/pK02416"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Emprunts obligataires convertibles</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2018FZ"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Autres Emprunts obligataires</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2018FAA"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Emprunts &amp; dettes tab. crdit</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2018FAB"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Location-financement</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2018FAC"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Apports groupe et associs</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2018FAD"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Autres dettes financires  long terme </th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/pK02605"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Autres dettes  long terme</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/pK02417"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'7'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">PASSIF COURANT</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/pK02423">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Dettes financires  court terme (10, 11, 12)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/pK02420"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Dont Part court terme des emprunts  long terme</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2018FAL"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Dont Concours bancaires courants &amp; solde crditeur</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2018FAM"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Dont Billets de trsorerie</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2018FAN"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Dont Location-financement</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2018FAO"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Dont Crances mobilises</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2018FAP"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Dont Apports groupe et associs</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2018FAQ"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'7'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Dettes oprationnelles (13)</th>
           <td class="clWidth140" colspan="2"></td>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Avances et acomptes reus</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2018FAT"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Dettes fournisseurs &amp; comptes rattachs</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2018FAU"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Produits constats d'avance</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2018FAZ"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Dont Subventions</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2018FBA"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Autres dettes oprationnelles</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2018FAV"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Dont Dettes fiscales</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2018FAW"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'7'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Instruments de couverture</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2018FBB"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Autres dettes  court terme</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/pK02422"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'7'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">PASSIFS DESTINS  LA VENTE</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2018FBJ">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'7'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">TOTAL GNRAL</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2018FBK">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'7'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clItalic clAlignLeft clThNonGras">(7) Provisions  moins d'un an ou courantes</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2018FBL">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <tr>
          <th class="clWidth355 clItalic clAlignLeft clThNonGras">(8) Engagements de retraite  moins d'un an</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/pK02413"/>
        </tr>
        <tr>
          <th class="clWidth355 clItalic clAlignLeft clThNonGras">(9) Impts diffrs passif  moins d'un an</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2018FX"/>
        </tr>
        <tr>
          <th class="clWidth355 clItalic clAlignLeft clThNonGras">(10) Dettes financires (LT et CT)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/pK02424"/>
        </tr>
        <tr>
          <th class="clWidth355 clItalic clAlignLeft clThNonGras">        Dont Part  plus de 5 ans</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2018FBM"/>
        </tr>
        <tr>
          <th class="clWidth355 clItalic clAlignLeft clThNonGras">(11) Lignes crdit conf. non utilises</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2018FBN"/>
        </tr>
        <tr>
          <th class="clWidth355 clItalic clAlignLeft clThNonGras">        Dont Part  moins d'un an</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2018FBO"/>
        </tr>
        <tr>
          <th class="clWidth355 clItalic clAlignLeft clThNonGras">(12) Dont Emprunts non porteurs d'intrts</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2018FBP"/>
        </tr>
        <tr>
          <th class="clWidth355 clItalic clAlignLeft clThNonGras">(13) Part dettes oprationn.  plus d'un an</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2018FBQ"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'7'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clItalic clAlignLeft clThNonGras">Crances cdes avec transfert de risque</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/BILAN67IFRS/p2018FBR"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'2'"/>
        </xsl:call-template>
      </table>
    </xsl:if>
  </xsl:template>

  <!-- COMPTE DE RSULTAT PAR NATURE (facultatif) -->
  <xsl:template name="RESULTAT">
    <xsl:if test="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATNATURE">
      <div class="clBreakPage"/>
      <a name="resnature"/>
      <xsl:call-template name="shim"/>
      <br/>
      <table class="clWidth739 clBorderCell" role=" presentation">
        <tr>
           <td class="clWidth19">&#160;</td>
         <td class="clCouleurGras clWidth597 clAlignCenter">COMPTE DE RSULTAT PAR NATURE</td>
          <td>
            <xsl:if test="$condGraph66">
              <a href="#nullepart" onclick="window.document.forms['FormGraphes'].action='Graphes.aspx#Graphe2';window.document.forms['FormGraphes'].submit();">
                <img border="0" src="{$root}Images/risque/diagramme_bleu.gif" width="19" height="20" alt="lien vers diagramme"/>
              </a>
            </xsl:if>
            <xsl:if test="not($condGraph66)">
              <img border="0" src="{$root}Images/boutons/diagramme_in.gif" width="19" height="20" alt="diagramme non disponible"/>
            </xsl:if>
          </td>
          <td class="clCouleur2">&#160;</td>
        </tr>
      </table>
      <xsl:call-template name="shim"/>
      <br/>
      <table class="clWidth739 clBorderCell">
        <caption class="visually-hidden">COMPTE DE RSULTAT PAR NATURE</caption>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Date d'arrt</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/@DATCLOT">
            <xsl:with-param name="largeur">140</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'8'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Chiffre d'affaires consolid</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATNATURE/pK01191"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;&#160;Dont Chiffre d'affaires tranger</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATNATURE/p2010ADN"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;+ Production stocke et immobilise</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATNATURE/pK01192"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;- Achats consomms et autres achats et charges externes</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATNATURE/pK01195"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'2'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;= VALEUR AJOUTE</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATNATURE/pK01196">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Valeur ajoute</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATNATURE/pK01196"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;+ Subventions d'exploitation</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATNATURE/pK01197"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;- Charges de personnel</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATNATURE/pK01198"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;- Impts et taxes et versements assimils</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATNATURE/p2013KJ"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'2'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;= EXCDENT BRUT D'EXPLOITATION</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATNATURE/pK01199">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Excdent brut d'exploitation</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATNATURE/pK01199"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;+ Autres produits d'exploitation</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATNATURE/pK01200"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;- Autres charges d'exploitation</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATNATURE/pK01201"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;- Dotations nettes et transferts de charges</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATNATURE/pK01883"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'2'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;= RSULTAT D'EXPLOITATION (A)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATNATURE/pK01208">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Quote-part sur oprations faites en commun (B)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATNATURE/p2013LB"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Produits financiers</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATNATURE/pK01209"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dont Produits de placement</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATNATURE/pK01210"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;- Charges financires</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATNATURE/pK01212"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dont Intrts et charges assimiles</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATNATURE/pK01213"/>
        </tr>
        <tr>
          <td class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;+ cart de Conversion</td>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATNATURE/p2013LO"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'2'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clHeight2 clAlignLeft clThNonGras">
            &#160;= RSULTAT FINANCIER
            (C)
          </th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATNATURE/pK01219">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dont lments comptabiliss par le groupe en exploitation</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATNATURE/pK01220"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;(A) + (B) + (C)</th>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;= RSULTAT COURANT AV. IMPT ENTREPRISES INTGRES</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATNATURE/pK01221">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Produits exceptionnels</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATNATURE/pK01222"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;- Charges exceptionnelles</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATNATURE/pK01225"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'2'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;= RSULTAT EXCEPTIONNEL</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATNATURE/pK01234">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dont Dotation nette aux amortissements et provisions</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATNATURE/pK01231"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dont Plus ou moins-value de cession</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATNATURE/pK01240"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dont lments comptabiliss par le groupe en exploitation</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATNATURE/pK01235"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Rsultat courant avant impt des entreprises intgres</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATNATURE/pK01221"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;+ Rsultat exceptionnel</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATNATURE/pK01234"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;- Impts sur les bnfices</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATNATURE/p2013MG"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dont Variation des impts diffrs</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATNATURE/p2013MH"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;- Participation des salaris</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATNATURE/pK01236"/>
        </tr>
        <tr>
          <td class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;+ Divers</td>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATNATURE/p2013MJ"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'2'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;= RSULTAT NET CONSOLID DES ENTREPRISES INTGRES</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATNATURE/pK01237">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Rsultat net consolid des entreprises intgres</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATNATURE/pK01237"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;+ Quote-part rsultats dans socits en quivalence</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATNATURE/p2013MK"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'2'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;= RSULTAT NET CONSOLID AV. AMORT.  CARTS ACQUIS.</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATNATURE/pK01238">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Rsultat net consolid av. amort. carts acquis.</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATNATURE/pK01238"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;- Dotation nette amortissement carts d'acquisition</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATNATURE/pK01239"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'2'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;= RSULTAT NET CONSOLID</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATNATURE/p2013MM">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dont Part du groupe</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATNATURE/p2013MN"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dont Part des minoritaires</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATNATURE/p2013MO"/>
        </tr>
      </table>
    </xsl:if>
    <!--
 ******************************************************************************************************************************************************************************************
 ******************************************************************************************************************************************************************************************
 
 COMPTE DE RSULTAT FONCTIONNEL (facultatif)

******************************************************************************************************************************************************************************************
******************************************************************************************************************************************************************************************
 -->
    <xsl:if test="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATFONCTIONNEL">
      <div class="clBreakPage"/>
      <a name="resfonctionnel"/>
      <xsl:call-template name="shim"/>
      <br/>
      <table class="clWidth739 clBorderCell" role="presentation">
        <tr>
           <td class="clWidth19">&#160;</td>
         <td class="clCouleurGras clWidth597 clAlignCenter">COMPTE DE RSULTAT FONCTIONNEL</td>
          <td>
            <xsl:if test="$condGraph66">
              <a href="#nullepart" onclick="window.document.forms['FormGraphes'].action='Graphes.aspx#Graphe2';window.document.forms['FormGraphes'].submit();">
                <img border="0" src="{$root}Images/risque/diagramme_bleu.gif" width="19" height="20" alt="lien vers diagramme"/>
              </a>
            </xsl:if>
            <xsl:if test="not($condGraph66)">
              <img border="0" src="{$root}Images/boutons/diagramme_in.gif" width="19" height="20" alt="diagramme non disponible"/>
            </xsl:if>
          </td>
          <td class="clCouleur2">&#160;</td>
        </tr>
      </table>
      <xsl:call-template name="shim"/>
      <br/>
      <table class="clWidth739 clBorderCell">
        <caption class="visually-hidden">COMPTE DE RSULTAT FONCTIONNEL</caption>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Date d'arrt</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/@DATCLOT">
            <xsl:with-param name="largeur">140</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Chiffre d'affaires consolid</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATFONCTIONNEL/p2014OA"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dont Chiffre d'affaires tranger</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATFONCTIONNEL/p2010ADF"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;- Cot des ventes et frais oprationnels</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATFONCTIONNEL/pK01242"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;+ Autres produits et charges d'exploitation</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATFONCTIONNEL/pK01243"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'2'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;= MARGE OPRATIONNELLE ou RSULTAT D'EXPLOIT. (A)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATFONCTIONNEL/pK01244">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Quote-part sur oprations faites en commun (B)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATFONCTIONNEL/p2014PJ">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Produits financiers</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATFONCTIONNEL/pK01248"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dont Produits de placement</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATFONCTIONNEL/p2014PL"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">- Charges financires</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATFONCTIONNEL/p2014PP"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dont Intrts et charges assimiles</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATFONCTIONNEL/p2014PQ"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;+ cart de conversion</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATFONCTIONNEL/p2014PW"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;+ lments financiers comptabiliss en exploitation</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATFONCTIONNEL/pK01245"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'2'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;= RSULTAT FINANCIER (C)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATFONCTIONNEL/pK01255">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;(A) + (B) + (C)</th>
          <td class="clWidth140"/>
          <td class="clWidth140"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;= RSULTAT COURANT AV. IMPT ENTREPRISES INTGRES</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATFONCTIONNEL/pK01256">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Produits exceptionnels</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATFONCTIONNEL/pK01259"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;- Charges exceptionnelles</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATFONCTIONNEL/pK01641"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">
            &#160;+ lments exceptionnels
            comptabiliss en exploitation
          </th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATFONCTIONNEL/pK01257"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'2'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;= RSULTAT EXCEPTIONNEL</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATFONCTIONNEL/pK01266">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dont Dotation nette aux amortissements et provisions</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATFONCTIONNEL/pK01264"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dont Plus ou moins-value de cession</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATFONCTIONNEL/p2014QZ"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Rsultat courant avant impt des entreprises intgres</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATFONCTIONNEL/pK01256"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;+ Rsultat exceptionnel</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATFONCTIONNEL/pK01266"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;- Impts sur les bnfices</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATFONCTIONNEL/p2014QO"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dont Variation des impts diffrs</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATFONCTIONNEL/p2014QP"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;- Participation des salaris</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATFONCTIONNEL/pK01267"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;+ Divers </th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATFONCTIONNEL/p2014QR"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'2'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;= RSULTAT NET CONSOLID DES ENTREPRISES INTGRES</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATFONCTIONNEL/pK01268">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Rsultat net consolid des entreprises intgres</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATFONCTIONNEL/pK01268"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;+ Quote-part des rsultats dans socits en quivalence</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATFONCTIONNEL/p2014QS"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'2'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;= RSULTAT NET CONSOLID AV. AMORT. CART ACQUIS.</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATFONCTIONNEL/pK01269">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Rsultat net consolid av. amort. cart acquis.</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATFONCTIONNEL/pK01269"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;- Dotation nette amortissement carts d'acquisition</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATFONCTIONNEL/pK01270"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'2'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;= RSULTAT NET CONSOLID</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATFONCTIONNEL/p2014QU">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dont Part du groupe</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATFONCTIONNEL/p2014QV"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dont Part des minoritaires</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTAT/RESULTATFONCTIONNEL/p2014QW"/>
        </tr>
      </table>

    </xsl:if>
    <!-- ******************************************************************************************-->
    <xsl:if test="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS">
      <div class="clBreakPage"/>
      <a name="resnature"/>
      <xsl:call-template name="shim"/>
      <br/>
      <table class="clWidth739 clBorderCell" role="presentation">
        <tr>
           <td class="clWidth19"></td>
         <td class="clCouleurGras clWidth597 clAlignCenter">COMPTE DE RSULTAT PAR NATURE</td>
          <td>
            <xsl:if test="$condGraph66">
              <a href="#nullepart" onclick="window.document.forms['FormGraphes'].action='Graphes.aspx#Graphe2';window.document.forms['FormGraphes'].submit();">
                <img border="0" src="{$root}Images/risque/diagramme_bleu.gif" width="19" height="20" alt="lien vers diagramme"/>
              </a>
            </xsl:if>
            <xsl:if test="not($condGraph66)">
              <img border="0" src="{$root}Images/boutons/diagramme_in.gif" width="19" height="20" alt="diagramme non disponible"/>
            </xsl:if>
          </td>
          <td class="clCouleur2">&#160;</td>
        </tr>

      </table>
      <xsl:call-template name="shim"/>
      <br/>
      <table class="clWidth739 clBorderCell">
        <caption class="visually-hidden">COMPTE DE RSULTAT PAR NATURE</caption>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">&#160;Date d'arrt</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/@DATCLOT">
            <xsl:with-param name="largeur">110</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <tr>
          <td class="clWidth415 clHeight10"></td>
          <td class="clWidth110 clHeight10" colspan="2"></td>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">Chiffre d'affaires consolid</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/p2019SAN"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">Dont Chiffre d'affaires tranger</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/p2019SBN2"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">+ Autres produits de l'activit</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/pK02425N"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras"> Dont Redevances, licences...</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/p2019SDN"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras"> Dont Produits financiers lis  l'exploitation</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/p2019SEN"/>
        </tr>
        <tr>
          <td class="clWidth415 clHeight10"></td>
          <td class="clWidth110 clHeight10" colspan="2"></td>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">- Variation stocks de produits finis et travaux en cours</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/pK02426"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">- Achats consomms</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/pK02428"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">- Autres achats et charges externes</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/pK02430"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras"> Dont Personnel externe</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/p2019SQ"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras"> Dont Frais de sous-traitance</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/p2019SS"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras"> Dont Charges locatives</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/p2019ST"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras"> Dont Redevances, droits d'auteur...</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/p2019SCH"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">- Charges de personnel</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/pK02695"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras"> Dont Salaires et charges sociales</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/p2019SK"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras"> Dont Engagements de retraite (charge ou produit)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/p2019SL"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras"> Dont Avantages au personnel (stock-options, plans d'pargne)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/p2019SN"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras"> Dont Participation des salaris</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/p2019SO"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">- Frais de recherche</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/pK02432"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">- Impts et taxes et versements assimils</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/p2019SV"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">+ Autres produits et charges d'exploitation</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/pK02694"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras"> Dont Plus/moins values de cession</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/pK02444N"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras"> Dont Quote-part sur oprations faites en commun</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/p2019SACN"/>
        </tr>
        <tr>
          <td class="clWidth415 clHeight10"></td>
          <td class="clWidth110 clHeight10" colspan="2"></td>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">- Dotations nettes amortissements et provisions d'exploitation</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/pK02718"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">Dont Dotations amortissements sur immos en location financement</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/p2019SX"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">Dont Dotations amortis. sur immos incorp.  dure de vie dfinie</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/p2019SCO"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">Dont Dotations nettes provisions d'exploitation</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/pK02440"/>
        </tr>
        <tr>
         <td class="clWidth415 clHeight2"></td>
          <td class="clWidth110 clHeight2" colspan="2"></td>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">= RSULTAT OPRATIONNEL COURANT</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/pK02697">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <tr>
          <td class="clWidth415 clHeight10"></td>
          <td class="clWidth110 clHeight10" colspan="2"></td>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">Rsultat oprationnel courant</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/pK02697">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">+ Autres produits et charges oprationnels</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/pK02696"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">Dont +/- values nettes de cession d'actifs non financiers</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/p2019SAGN"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">Dont Charges de restructuration et licenciement</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/pK02686"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">Dont Dotations nettes aux amort. et prov. non rcurrentes</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/p2019SAIN"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">Dont Variation juste valeur immeubles de placem. et actifs biologiques</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/pK02450N"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">Dont Profits de dilution</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/p2019SAON"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">Dont Effet du changement d'estimation</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/p2019SAPN"/>
        </tr>
        <tr>
         <td class="clWidth415 clHeight2"></td>
          <td class="clWidth110 clHeight2" colspan="2"></td>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">= RSULTAT OPRATIONNEL</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/p2019SARN">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <tr>
          <td class="clWidth415 clHeight10"></td>
          <td class="clWidth110 clHeight10" colspan="2"></td>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">Rsultat oprationnel</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/p2019SARN"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">- Cot de l'endettement financier net</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/p2019SASN"/>
          
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">Dont Intrts et charges assimiles (y compris location financement)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/p2019SATN"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">Dont Intrts perus sur trsorerie et quivalents de trsorerie</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/p2019SAUN"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras"> Dont Rsultat cession des VMP</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/p2019SAVN"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">Dont Rsultat des couvertures sur l'endettement et la trso. (ou quiv.)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/p2019SAWN"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">+ Autres produits et charges financiers</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/p2019SAXN"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">Dont Charges (produits) d'actualisation</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/p2019SCMN"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">- Charge d'impt</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/p2019SBEN"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">+ Divers (non courant)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/p2019SBGN"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">+ Quote-part du rsultat net des sts mises en quivalence</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/p2019SBHN"/>
        </tr>
        <tr>
         <td class="clWidth415 clHeight2"></td>
          <td class="clWidth110 clHeight2" colspan="2"></td>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">= RSULTAT NET DES ACTIVITS EN COURS</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/p2019SBIN">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <tr>
          <td class="clWidth415 clHeight10"></td>
          <td class="clWidth110 clHeight10" colspan="2"></td>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">Rsultat net des activits en cours</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/p2019SBIN"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">+ Rsultat net des activits arrtes</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/p2019SBJN"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">= RSULTAT NET CONSOLID</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/p2019SBKN">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">Dont Part du groupe</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/p2019SBLN">
            <xsl:with-param name="largeur">110</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">Dont Part des minoritaires</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATNATUREIFRS/p2019SBMN">
            <xsl:with-param name="largeur">110</xsl:with-param>
          </xsl:apply-templates>
        </tr>
      </table>
    </xsl:if>

    <xsl:if test="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATFONCTIONNELIFRS">

      <div class="clBreakPage"></div>
      <a name="resfonctionnel"></a>
      <xsl:call-template name="shim"/>
      <br/>
      <table class="clWidth739 clBorderCell" role="presentation">
        <tr>
           <td class="clWidth19"></td>
         <td class="clCouleurGras clWidth597 clAlignCenter">COMPTE DE RSULTAT FONCTIONNEL</td>
          <td>
            <xsl:if test="$condGraph66">
              <a href="#nullepart" onclick="window.document.forms['FormGraphes'].action='Graphes.aspx#Graphe2';window.document.forms['FormGraphes'].submit();">
                <img border="0" src="{$root}Images/risque/diagramme_bleu.gif" width="19" height="20" alt="lien vers diagramme"/>
              </a>
            </xsl:if>
            <xsl:if test="not($condGraph66)">
              <img border="0" src="{$root}Images/boutons/diagramme_in.gif" width="19" height="20" alt="diagramme non disponible"/>
            </xsl:if>
          </td>
          <td class="clCouleur2"></td>
        </tr>
      </table>
      <xsl:call-template name="shim"/>
      <br/>
      <table class="clWidth739 clBorderCell">
        <caption class="visually-hidden">COMPTE DE RSULTAT FONCTIONNEL</caption>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">Date d'arrt</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/@DATCLOT">
            <xsl:with-param name="largeur">110</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <tr>
          <td class="clWidth415 clHeight10"></td>
          <td class="clWidth110 clHeight10" colspan="2"></td>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">Chiffre d'affaires consolid</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATFONCTIONNELIFRS/p2019SAF"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">Dont Chiffre d'affaires tranger</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATFONCTIONNELIFRS/p2019SBF"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">+ Autres produits de l'activit</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATFONCTIONNELIFRS/pK02425F"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras"> Dont Redevances, licences...</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATFONCTIONNELIFRS/p2019SDF"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras"> Dont Produits financiers lis  l'exploitation</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATFONCTIONNELIFRS/p2019SEF"/>
        </tr>
        <tr>
          <td class="clWidth415 clHeight10"></td>
          <td class="clWidth110 clHeight10" colspan="2"></td>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">- Cot des ventes</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATFONCTIONNELIFRS/p2019SBN"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">- Frais de recherche et dveloppement</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATFONCTIONNELIFRS/pK02433"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">- Frais commerciaux</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATFONCTIONNELIFRS/p2019SBO"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">- Frais gnraux</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATFONCTIONNELIFRS/p2019SBP"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">+ Autres produits et charges d'exploitation</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATFONCTIONNELIFRS/pK02698"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras"> Dont +/- values de cession</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATFONCTIONNELIFRS/pK02444F"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras"> Dont Quote-part sur oprations faites en commun</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATFONCTIONNELIFRS/p2019SACF"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">+ Divers (oprationnel courant)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATFONCTIONNELIFRS/pK02699"/>
        </tr>
        <tr>
         <td class="clWidth415 clHeight2"></td>
          <td class="clWidth110 clHeight2" colspan="2"></td>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">= RSULTAT OPRATIONNEL COURANT</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATFONCTIONNELIFRS/pK02701">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <tr>
          <td class="clWidth415 clHeight10"></td>
          <td class="clWidth110 clHeight10" colspan="2"></td>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">Rsultat oprationnel courant</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATFONCTIONNELIFRS/pK02701"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">+ Autres produits et charges oprationnels</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATFONCTIONNELIFRS/pK02700"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">Dont +/- values de cession d'actifs non rcurrentes / actif non courant</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATFONCTIONNELIFRS/p2019SAGF"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">Dont Charges de restructuration et licenciement</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATFONCTIONNELIFRS/pK02688"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">Dont Dotations nettes aux amort. et prov. non rcurrentes</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATFONCTIONNELIFRS/p2019SAIF"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">Dont Variation juste valeur immeubles de placem. et actifs biologiques</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATFONCTIONNELIFRS/pK02450F"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">Dont Profits de dilution</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATFONCTIONNELIFRS/p2019SAOF"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">Dont Effet du changement d'estimation</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATFONCTIONNELIFRS/p2019SAPF"/>
        </tr>
        <tr>
         <td class="clWidth415 clHeight2"></td>
          <td class="clWidth110 clHeight2" colspan="2"></td>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">= RSULTAT OPRATIONNEL (1)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATFONCTIONNELIFRS/p2019SARF">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <tr>
          <td class="clWidth415 clHeight10"></td>
          <td class="clWidth110 clHeight10" colspan="2"></td>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">Rsultat oprationnel</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATFONCTIONNELIFRS/p2019SARF"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">- Cot de l'endettement financier net</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATFONCTIONNELIFRS/p2019SASF"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras"> Dont Intrts et charges assimiles (y compris location financement)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATFONCTIONNELIFRS/p2019SATF"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras"> Dont Intrts perus sur trsorerie et quivalents de trsorerie</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATFONCTIONNELIFRS/p2019SAUF"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras"> Dont Rsultat cession des VMP</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATFONCTIONNELIFRS/p2019SAVF"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">  Dont Rsultat des couvertures sur l'endettement et la trso. (ou quiv.)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATFONCTIONNELIFRS/p2019SAWF"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">+ Autres produits et charges financiers</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATFONCTIONNELIFRS/p2019SAXF"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">  Dont Charges (produits) d'actualisation</th>
        </tr>
        <tr>
          <td class="clWidth415 clHeight10"></td>
          <td class="clWidth110 clHeight10" colspan="2"></td>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">- Charge d'impt</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATFONCTIONNELIFRS/p2019SBEF"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">+ Divers (non courants)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATFONCTIONNELIFRS/p2019SBGF"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">+ Quote-part du rsultat net dans socits mises en quivalence</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATFONCTIONNELIFRS/p2019SBHF"/>
        </tr>
        <tr>
         <td class="clWidth415 clHeight2"></td>
          <td class="clWidth110 clHeight2" colspan="2"></td>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">= RSULTAT NET DES ACTIVITS EN COURS</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATFONCTIONNELIFRS/p2019SBIF">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <tr>
          <td class="clWidth415 clHeight10"></td>
          <td class="clWidth110 clHeight10" colspan="2"></td>
        </tr>
        <tr>
          <td class="clWidth415 clHeight10"></td>
          <td class="clWidth110 clHeight10" colspan="2"></td>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">Rsultat net des activit en cours</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATFONCTIONNELIFRS/p2019SBIF"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">+ Rsultat net des activits arrtes</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATFONCTIONNELIFRS/p2019SBJF"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">= RSULTAT NET CONSOLID</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATFONCTIONNELIFRS/p2019SBKF">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">Dont Part du groupe</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATFONCTIONNELIFRS/p2019SBLF">
            <xsl:with-param name="largeur">110</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">Dont Part des minoritaires</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATFONCTIONNELIFRS/p2019SBMF">
            <xsl:with-param name="largeur">110</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <tr>
          <td class="clWidth415 clHeight10"></td>
          <td class="clWidth110 clHeight10" colspan="2"></td>
        </tr>
        <tr>
          <th class="clItalic clWidth415 clAlignLeft clThNonGras">(1) Dont Charges de personnel</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATFONCTIONNELIFRS/pK02702"/>
        </tr>
        <tr>
          <th class="clItalic clWidth415 clAlignLeft clThNonGras">             Dont Autres achats et charges externes</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATFONCTIONNELIFRS/pK02431"/>
        </tr>
        <tr>
          <th class="clItalic clWidth415 clAlignLeft clThNonGras">             Dont Dotations aux amortissements et provisions</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/RESULTATIFRS/RESULTATFONCTIONNELIFRS/pK02719"/>
        </tr>
      </table>
    </xsl:if>
  </xsl:template>

  <!-- TABLEAU DE FINANCEMENT SELON GROUPE (facultatif) -->
  <xsl:template name="TABLEAUFINANCEMENT">
    <xsl:if test="../DIFF67/DONNEESCONSO/TABLEAUFINANCEMENT">
      <div class="clBreakPage"/>
      <a name="financement"/>
      <xsl:call-template name="shim"/>
      <br/>
      <table class="clWidth739 clBorderCell" role="presentation">
        <tr>
           <td class="clWidth19">&#160;</td>
         <td class="clCouleurGras clWidth597 clAlignCenter">TABLEAU DE FINANCEMENT SELON GROUPE</td>
          <td>
            <xsl:if test="$condGraph63">
              <a href="#nullepart" onclick="window.document.forms['FormGraphes'].action='Graphes.aspx#Graphe3';window.document.forms['FormGraphes'].submit();">
                <img border="0" src="{$root}Images/risque/diagramme_bleu.gif" width="19" height="20" alt="lien vers diagramme"/>
              </a>
            </xsl:if>
            <xsl:if test="not($condGraph63)">
              <img border="0" src="{$root}Images/boutons/diagramme_in.gif" width="19" height="20" alt="diagramme non disponible"/>
            </xsl:if>
          </td>
          <td class="clCouleur2">&#160;</td>
        </tr>
      </table>
      <xsl:call-template name="shim"/>
      <br/>
      <table class="clWidth739 clBorderCell">
        <caption class="visually-hidden">TABLEAU DE FINANCEMENT SELON GROUPE</caption>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Date d'arrt</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/@DATCLOT">
            <xsl:with-param name="largeur">140</xsl:with-param>
          </xsl:apply-templates>
          <td class="clCouleur2">&#160;</td>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Capacit d'autofinancement</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFINANCEMENT/p2015TJ">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Cessions d'immobilisations corporelles et incorporelles</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFINANCEMENT/p2015TK"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Cessions ou rductions d'immobilisations financires</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFINANCEMENT/p2015TL"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dont Remboursements de prts et assimils</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFINANCEMENT/p2015TM"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Augmentation des fonds propres</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFINANCEMENT/p2015TN"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dont Augmentation de capital et primes en numraire</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFINANCEMENT/p2015TO"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Variation positive des dettes financires</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFINANCEMENT/pK01884"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Dividendes reus des socits mises en quivalence</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFINANCEMENT/p2015TS"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Autres flux de ressources stables</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFINANCEMENT/p2015TT"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'2'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;= TOTAL DES RESSOURCES</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFINANCEMENT/pK01279">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Acquisitions d'immobilisations corporelles et incorporelles</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFINANCEMENT/p2015TU"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Augmentation des carts d'acquisition</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFINANCEMENT/p2015TV"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Acquisitions d'immobilisations financires</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFINANCEMENT/p2015TW"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Augmentation des charges  rpartir sur plusieurs exercices</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFINANCEMENT/p2015TX"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Rduction des fonds propres</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFINANCEMENT/p2015TY"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dont Intrts des minoritaires</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFINANCEMENT/p2015TZ"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Variation ngative des dettes financires</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFINANCEMENT/pK01885"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Dividendes mis en paiement au cours de l'exercice</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFINANCEMENT/p2015UD"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dont Dividendes verss  la socit mre</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFINANCEMENT/p2015UE"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Autres flux d'emplois stables</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFINANCEMENT/p2015UF"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'2'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;= TOTAL DES EMPLOIS</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFINANCEMENT/pK01280">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Total des ressources </th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFINANCEMENT/pK01279"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;- Total des emplois</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFINANCEMENT/pK01280"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'2'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;= EXCDENT (INSUFFISANCE) RESSOURCES SUR EMPLOIS (1)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFINANCEMENT/pK01281">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;+ Incidence variation taux de change (cart conversion) (2)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFINANCEMENT/p2015UG"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;+ Incidence variation primtre de consolidation (3)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFINANCEMENT/p2015UH"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;+ Impact des autres changements (4)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFINANCEMENT/p2015UI"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;= VARIATION DU FONDS DE ROULEMENT (1)  (4)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFINANCEMENT/p2015UJ">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Variation du fonds de roulement</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFINANCEMENT/p2015UJ"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;- Variation des BFR globaux</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFINANCEMENT/p2015UK"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dont Variation des BFR d'exploitation</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFINANCEMENT/p2015UL"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dont Variation des BFR hors exploitation</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFINANCEMENT/p2015UM"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'2'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;= VARIATION DE LA TRSORERIE</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFINANCEMENT/p2015UN">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dont Variation des disponibilits</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFINANCEMENT/p2015UO"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dont Variation des VMP</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFINANCEMENT/p2015UP"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dont (-) Variation des concours bancaires courants</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFINANCEMENT/p2015UQ"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;&#160;Dont (-) Variation des billets de trsorerie et assimils</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFINANCEMENT/p2015UR"/>
        </tr>
      </table>
    </xsl:if>
  </xsl:template>

  <!-- TABLEAU DE FLUX SELON GROUPE (facultatif) -->
  <xsl:template name="TABLEAUFLUX">
    <xsl:if test="../DIFF67/DONNEESCONSO/TABLEAUFLUX">
      <div class="clBreakPage"/>
      <a name="flux"/>
      <xsl:call-template name="shim"/>
      <br/>
      <table class="clWidth739 clBorderCell" role="presentation">
        <tr>
           <td class="clWidth19">&#160;</td>
         <td class="clCouleurGras clWidth597 clAlignCenter">TABLEAU DE FLUX</td>
           <td class="clWidth19">&#160;</td>
          <td class="clCouleur2">&#160;</td>
        </tr>
      </table>
      <xsl:call-template name="shim"/>
      <br/>
      <table class="clWidth739 clBorderCell">
        <caption class="visually-hidden">TABLEAU DE FLUX</caption>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">&#160;Date d'arrt</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/@DATCLOT">
            <xsl:with-param name="largeur">110</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <xsl:call-template name="BreakLine3Cols110">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">&#160;OPTION A</th>
          <td class="clWidth110"/>
          <td class="clWidth110"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols110">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras"> CAF (aprs cot endettement financier net et impt)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFLUX/p2016WL"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras"> + Cot de l'endettement financier net</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFLUX/p2016YE"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras"> + Charge d'impts (y compris impts diffrs)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFLUX/p2016YF"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">= CAF AVANT COT DE L'ENDETTEMENT FINANCIER NET ET IMPTS</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFLUX/p2016YG"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">- Impts verss</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFLUX/p2016WAG"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">- Intrts verss (si non classs en flux de financement)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFLUX/p2016WAE"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras"> + Dividendes reus des sts mises en quivalence (si inclus en FTE)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFLUX/p2016XP"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras"> + Autres flux (dont ajustements,...)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFLUX/pK02854"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras"> - Var. du BFR li  l'activit (y c dettes lies aux avant. du personnel)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFLUX/p2016WM"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols110">
          <xsl:with-param name="newHeight" select="'2'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">= FLUX NET DE TRSORERIE GNR PAR L'ACTIVIT (1)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFLUX/p2016WN">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <xsl:call-template name="BreakLine3Cols110">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">&#160;OPTION B</th>
          <td class="clWidth110"/>
          <td class="clWidth110"/>
           <td class="clAlignRight"></td>
        </tr>
        <xsl:call-template name="BreakLine3Cols110">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">&#160;Rsultat brut d'exploitation ou Excd. brut d'expl. (hors var. stocks)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFLUX/p2016WJ"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">&#160;- Variation du BFR li  l'exploitation</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFLUX/p2016XQ"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols110">
          <xsl:with-param name="newHeight" select="'2'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">&#160;= FLUX NET DE TRSORERIE D'EXPLOITATION</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFLUX/p2016XR">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <xsl:call-template name="BreakLine3Cols110">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">&#160;Flux net de trsorerie d'exploitation</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFLUX/p2016XR"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">+ Autres encaissements et dcaissements lis  l'activit</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFLUX/p2016WK"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols110">
          <xsl:with-param name="newHeight" select="'2'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">   Dont Intrts financiers verss</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFLUX/p2016WAA"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">   Dont Dividendes reus (sts mises en quivalence, titres non conso)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFLUX/p2016YZ"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols110">
          <xsl:with-param name="newHeight" select="'2'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">&#160;= FLUX NET DE TRSORERIE GNR PAR L'ACTIVIT (1)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFLUX/p2016WN">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <xsl:call-template name="BreakLine3Cols110">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">OPTION C : approche directe</th>
          <td class="clWidth110"></td>
          <td class="clWidth110"></td>
        </tr>
        <xsl:call-template name="BreakLine3Cols110">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">&#160;+ Encaissements</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFLUX/pK02855"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">&#160;-&#160; Dcaissements</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFLUX/pK02856"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols110">
          <xsl:with-param name="newHeight" select="'2'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">= FLUX NET DE TRSORERIE GNR PAR L'ACTIVIT (1)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFLUX/p2016WN">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <xsl:call-template name="BreakLine3Cols110">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">&#160;-&#160; Dcaissements sur acquisitions d'immobilisations</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFLUX/p2016XS"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">&#160;+ Encaissements sur cessions d'immobilisations</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFLUX/p2016XT"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">&#160;+ Incidence des variations de primtre</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFLUX/p2016WT"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">&#160;+ Dividendes reus des sts mises en quival.&#160;(si non class en FTE)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFLUX/p2016WS"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">&#160;+ Dividendes reus&#160;/&#160;titres non consolids (si non class en FTE)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFLUX/p2016WAI"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">&#160;+ Produits des intrts financiers reus sur placements de trsorerie</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFLUX/p2016WAJ"/>
        </tr>

        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">&#160;- Autres flux lis aux oprations d'investissement</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFLUX/p2016WU"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">&#160;- Variation des BFR sur oprations d'investissement</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFLUX/p2016WV"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols110">
          <xsl:with-param name="newHeight" select="'2'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">&#160;= FLUX NET TRSORERIE LI AUX OPE. D'INVESTISSEMENT (2)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFLUX/p2016WW">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <xsl:call-template name="BreakLine3Cols110">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">&#160;+ Sommes reues des actionnaires sur augmentation de capital </th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFLUX/p2016WX"/>
        </tr>

        <xsl:if test="../DIFF67/DONNEESCONSO/TABLEAUFLUX/p2016WY">
          <tr>
            <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">&#160;+ Variation des autres fonds propres</th>
            <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFLUX/p2016WY"/>
          </tr>
        </xsl:if>
        <xsl:if test="../DIFF67/DONNEESCONSO/TABLEAUFLUX/p2016YO">
          <tr>
            <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">&#160;+ Sommes reues sur exercice des stocks-options</th>
            <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFLUX/p2016YO"/>
          </tr>
        </xsl:if>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">&#160;-/+ Rachat/Revente d'actions propres</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFLUX/p2016YP"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">&#160;- Dividendes mis en paiement au cours de l'exercice</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFLUX/p2016WZ"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">+ Encaissements sur nouveaux emprunts (y compris location fin.)&#160;(*)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFLUX/p2016XB"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">&#160;- Remboursements d'emprunts (y compris location fin.)&#160;(*)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFLUX/p2016XC"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">(*)&#160; dfaut  : + variation des dettes financires</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFLUX/p2016XD"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">&#160;- Int. fin. nets verss (ou bruts si prod. des intr. fin. class. en FTI)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFLUX/p2016YY"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">&#160;+ Autres flux sur oprations de financement</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFLUX/p2016XE"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">&#160;- Variation des BFR sur oprations de financement</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFLUX/p2016XF"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols110">
          <xsl:with-param name="newHeight" select="'2'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">&#160;= FLUX NET TRSORERIE LI AUX OPE. DE FINANCEMENT (3)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFLUX/p2016XG">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <xsl:call-template name="BreakLine3Cols110">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">&#160;+ Incidence de la variation des cours des devises (4)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFLUX/p2016XH"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">&#160;+ Incidence des changements de mthode (5)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFLUX/p2016XI"/>
        </tr>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">&#160;+ Impact des autres changements (6)</th>
        </tr>
        <xsl:call-template name="BreakLine3Cols110">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth415 clCouleur2 clAlignLeft clThNonGras">&#160;= VARIATION DE LA TRSORERIE (1)  (6)</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/TABLEAUFLUX/p2016XK">
            <xsl:with-param name="bold">Gras</xsl:with-param>
          </xsl:apply-templates>
        </tr>
      </table>
    </xsl:if>
  </xsl:template>

  <!-- LMENTS D'ANALYSE FINANCIRE (obligatoire) -->
  <xsl:template name="ANALYSEFINANCIERE">
    <xsl:if test="../DIFF67/DONNEESCONSO/ANALYSEFINANCIERE">
      <div class="clBreakPage"/>
      <a name="analyse"/>
      <xsl:call-template name="shim"/>
      <br/>
      <table class="clWidth739 clBorderCell" role="presentation">
        <tr>
           <td class="clWidth19">&#160;</td>
         <td class="clCouleurGras clWidth597 clAlignCenter">LMENTS D'ANALYSE FINANCIRE</td>
           <td class="clWidth19">&#160;</td>
          <td class="clCouleur2">&#160;</td>
        </tr>
      </table>
      <xsl:call-template name="shim"/>
      <br/>
      <table class="clWidth739 clBorderCell">
        <caption class="visually-hidden">LMENTS D'ANALYSE FINANCIRE</caption>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Date d'arrt</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/@DATCLOT">
            <xsl:with-param name="largeur">140</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;FRNG</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIERE/pK01376"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;BFR hors effets escompts non chus</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIERE/pK01295"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Trsorerie</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIERE/pK01283"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Fonds propres nets</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIERE/pFONDPR"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Endettement financier</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIERE/pK01353"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Endettement financier net</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIERE/pK01354"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Capacit d'autofinancement selon groupe</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIERE/pCAFGRP"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Capacit d'autofinancement selon BDF</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIERE/pCAF"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
           <th class="clWidth355 clCouleur2 clAlignCenter clThNonGras">AGRGATS DE LIQUIDIT</th>
          <td class="clWidth140"/>
          <td class="clWidth140"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;Actifs  moins d'un an</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIERE/pK01381"/>
        </tr>
        <tr> 
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;- Dettes et comptes de rgularisation  moins d'un an</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIERE/pK01188"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">&#160;= Excdent ou insuffisance</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIERE/pK01382"/>
        </tr>
      </table>

      <!--
 ******************************************************************************************************************************************************************************************
 ******************************************************************************************************************************************************************************************
 
 RATIOS (obligatoire)

******************************************************************************************************************************************************************************************
******************************************************************************************************************************************************************************************
 -->
      <a name="ratios"/>
      <xsl:call-template name="shim"/>
      <br/>
      <table class="clWidth739 clBorderCell" role="presentation">
        <tr>
           <td class="clWidth19">&#160;</td>
         <td class="clCouleurGras clWidth597 clAlignCenter">RATIOS</td>
           <td class="clWidth19">&#160;</td>
        </tr>
      </table>
      <xsl:call-template name="shim"/>
      <br/>
      <table class="clWidth739 clBorderCell">
        <caption class="visually-hidden">RATIOS</caption>
        <tr>
          <th class="clWidth315 clCouleur2 clAlignLeft clThNonGras">&#160;Date d'arrt</th>
           <td class="clWidth40 clCouleur2 clAlignCenter">&#160;</td>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/@DATCLOT">
            <xsl:with-param name="largeur">140</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <xsl:call-template name="BreakLine4Cols"/>
        <tr>
          <th class="clWidth315 clCouleur2 clAlignLeft clThNonGras">&#160;Taux de variation du chiffre d'affaires</th>
           <td class="clWidth40 clCouleur2 clAlignCenter">%</td>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIERE/pTXVCA">
            <xsl:with-param name="largeur">140</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <tr>
          <th class="clWidth315 clCouleur2 clAlignLeft clThNonGras">&#160;EBE / CA HT</th>
           <td class="clWidth40 clCouleur2 clAlignCenter">%</td>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIERE/pEBE_CA"/>
        </tr>
        <xsl:call-template name="BreakLine4Cols"/>
        <tr>
          <th class="clWidth315 clCouleur2 clAlignLeft clThNonGras">&#160;Intrts et charges assimiles / EBE</th>
           <td class="clWidth40 clCouleur2 clAlignCenter">%</td>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIERE/pINT_EBE"/>
        </tr>
        <tr>
          <th class="clWidth315 clCouleur2 clAlignLeft clThNonGras">&#160;Intrts et charges assimiles / CA HT</th>
           <td class="clWidth40 clCouleur2 clAlignCenter">%</td>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIERE/pINT_CA">
            <xsl:with-param name="largeur">140</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <xsl:call-template name="BreakLine4Cols"/>
        <tr>
          <th class="clWidth315 clCouleur2 clAlignLeft clThNonGras">&#160;Rsultat d'exploitation / CA HT</th>
           <td class="clWidth40 clCouleur2 clAlignCenter">%</td>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIERE/pRESEX_CA"/>
        </tr>
        <tr>
          <th class="clWidth315 clCouleur2 clAlignLeft clThNonGras">&#160;Rsultat courant / CA HT</th>
           <td class="clWidth40 clCouleur2 clAlignCenter">%</td>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIERE/pRESC_CA"/>
        </tr>
        <xsl:call-template name="BreakLine4Cols"/>
        <tr>
          <th class="clWidth315 clCouleur2 clAlignLeft clThNonGras">&#160;Rsult. net av. amort. cart acqu. / Cap. propres totaux</th>
           <td class="clWidth40 clCouleur2 clAlignCenter">%</td>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIERE/pRAMT_CP"/>
        </tr>
        <tr>
          <th class="clWidth315 clCouleur2 clAlignLeft clThNonGras">&#160;Rsultat net / Capitaux propres totaux</th>
           <td class="clWidth40 clCouleur2 clAlignCenter">%</td>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIERE/pRNC_CP">
            <xsl:with-param name="largeur">140</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <xsl:call-template name="BreakLine4Cols"/>
        <tr>
          <th class="clWidth315 clCouleur2 clAlignLeft clThNonGras">&#160;Rsultat part du groupe / Capitaux propres groupe</th>
           <td class="clWidth40 clCouleur2 clAlignCenter">%</td>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIERE/pRESPG_CP">
            <xsl:with-param name="largeur">140</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <tr>
          <th class="clWidth315 clCouleur2 clAlignLeft clThNonGras">&#160;Rsultat net (part du groupe) par action</th>
           <td class="clWidth40 clCouleur2 clAlignCenter">
            <img src="{$root}Images/risque/euro_symb_bleu.gif" width="8" height="9" alt="symbole euro"/>
          </td>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIERE/pRESPACT">
            <xsl:with-param name="largeur">140</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <tr>
          <th class="clWidth315 clCouleur2 clAlignLeft clThNonGras">&#160;Rsultat part des minoritaires / Intrts minoritaires</th>
           <td class="clWidth40 clCouleur2 clAlignCenter">%</td>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIERE/pRPRM_IM">
            <xsl:with-param name="largeur">140</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <tr>
          <th class="clWidth315 clCouleur2 clAlignLeft clThNonGras">&#160;Rsultat part des minoritaires / Rsultat net consolid</th>
           <td class="clWidth40 clCouleur2 clAlignCenter">%</td>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIERE/pRPRM_RC">
            <xsl:with-param name="largeur">140</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <xsl:call-template name="BreakLine4Cols"/>
        <tr>
          <th class="clWidth315 clCouleur2 clAlignLeft clThNonGras">&#160;FRNG / CA HT</th>
           <td class="clWidth40 clCouleur2 clAlignCenter">j</td>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIERE/pFRNG_CA">
            <xsl:with-param name="largeur">140</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <tr>
          <th class="clWidth315 clCouleur2 clAlignLeft clThNonGras">&#160;BFR hors effets escompts non chus / CA HT</th>
           <td class="clWidth40 clCouleur2 clAlignCenter">j</td>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIERE/pBFR_CA"/>
        </tr>
        <xsl:call-template name="BreakLine4Cols"/>
        <tr>
          <th class="clWidth315 clCouleur2 clAlignLeft clThNonGras">&#160;Fonds propres nets / Total Bilan</th>
           <td class="clWidth40 clCouleur2 clAlignCenter">%</td>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIERE/pFPN_TB"/>
        </tr>
        <tr>
          <th class="clWidth315 clCouleur2 clAlignLeft clThNonGras">&#160;Fonds non remboursables / Capitaux propres</th>
           <td class="clWidth40 clCouleur2 clAlignCenter">%</td>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIERE/pK01811"/>
        </tr>
        <tr>
          <th class="clWidth315 clCouleur2 clAlignLeft clThNonGras">&#160;Endettement financier / Fonds propres nets</th>
           <td class="clWidth40 clCouleur2 clAlignCenter">%</td>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIERE/pEF_FPN"/>
        </tr>
        <xsl:call-template name="BreakLine4Cols"/>
        <tr>
          <th class="clWidth315 clCouleur2 clAlignLeft clThNonGras">&#160;Dettes fin. + d'1 an (hors crdit-bail) / Fonds prop. nets</th>
           <td class="clWidth40 clCouleur2 clAlignCenter">%</td>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIERE/pDF_FPN"/>
        </tr>
        <tr>
          <th class="clWidth315 clCouleur2 clAlignLeft clThNonGras">&#160;Dettes  caractre bancaire / Endettement financier</th>
           <td class="clWidth40 clCouleur2 clAlignCenter">%</td>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIERE/pK01369"/>
        </tr>
        <tr>
          <th class="clWidth315 clCouleur2 clAlignLeft clThNonGras">&#160;Dettes financires stables / CAF</th>
           <td class="clWidth40 clCouleur2 clAlignCenter">A.m</td>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIERE/pDFS_CAF"/>
        </tr>
        <xsl:call-template name="BreakLine4Cols"/>
        <tr>
          <th class="clWidth315 clCouleur2 clAlignLeft clThNonGras">&#160;Fd cial+marq+part march+carts acq. / Cap. Pr. app.</th>
           <td class="clWidth40 clCouleur2 clAlignCenter">%</td>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIERE/pK01865"/>
        </tr>
      </table>
    </xsl:if>
    <!--
******************************************************************************************************************
						ANALYSE FINANCIERE NORME IFRS

******************************************************************************************************************
-->
    <xsl:if test="../DIFF67/DONNEESCONSO/ANALYSEFINANCIEREIFRS">

      <div class="clBreakPage"/>
      <a name="analyse"></a>
      <xsl:call-template name="shim"/>
      <br/>
      <table class="clWidth739 clBorderCell" role="presentation">
        <tr>
           <td class="clWidth19"></td>
         <td class="clCouleurGras clWidth597 clAlignCenter">LMENTS D'ANALYSE FINANCIRE</td>
           <td class="clWidth19"></td>
          <td class="clCouleur2"></td>
        </tr>
      </table>
      <xsl:call-template name="shim"/>
      <br/>
      <table class="clWidth739 clBorderCell">
        <caption class="visually-hidden">LMENTS D'ANALYSE FINANCIRE</caption>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Date d'arrt</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/@DATCLOT">
            <xsl:with-param name="largeur">110</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">FRNG</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIEREIFRS/pK02494"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">BFR</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIEREIFRS/pK02495"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Actifs-Dettes destins  la vente</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIEREIFRS/pK02614"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Trsorerie nette</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIEREIFRS/pK02496"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Endettement financier</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIEREIFRS/pK02401"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Endettement financier net</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIEREIFRS/pK02485"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Capacit d'autofinancement selon groupe</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIEREIFRS/pCAFGRP"/>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
           <th class="clWidth355 clCouleur2 clAlignCenter clThNonGras">AGRGATS DE LIQUIDIT</th>
           <td class="clWidth140"></td>
           <td class="clWidth140"></td>
        </tr>
        <xsl:call-template name="BreakLine3Cols">
          <xsl:with-param name="newHeight" select="'10'"/>
        </xsl:call-template>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">Actifs  moins d'un an</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIEREIFRS/pK02497"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">- Passifs  moins d'un an</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIEREIFRS/pK02498"/>
        </tr>
        <tr>
          <th class="clWidth355 clCouleur2 clAlignLeft clThNonGras">= Excdent ou insuffisance</th>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIEREIFRS/pK02499"/>
        </tr>
      </table>
      <!--
****************************************************************************************************
ratios
*****************************************************************************************************
-->
      <a name="ratios"></a>
      <xsl:call-template name="shim"/>
      <br/>
      <table class="clWidth739 clBorderCell" role="presentation">
        <tr>
           <td class="clWidth19"></td>
         <td class="clCouleurGras clWidth597 clAlignCenter">RATIOS</td>
           <td class="clWidth19"></td>
        </tr>
      </table>
      <xsl:call-template name="shim"/>
      <br/>
      <table class="clWidth739 clBorderCell">
        <caption class="visually-hidden">RATIOS</caption>
        <tr>
           <th class="clWidth375 clCouleur2 clAlignLeft clThNonGras">Date d'arrt</th>
           <td class="clWidth40 clCouleur2 clAlignCenter"></td>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/@DATCLOT">
            <xsl:with-param name="largeur">110</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <tr>
           <td class="clWidth375 clHeight10"></td>
           <td class="clWidth40 clHeight10"></td>
           <td class="clWidth110 clHeight10"></td>
           <td class="clWidth110 clHeight10"></td>
        </tr>
        <tr>
           <th class="clWidth375 clCouleur2 clAlignLeft clThNonGras">Taux de variation du chiffre d'affaires</th>
           <td class="clWidth40 clCouleur2 clAlignCenter">%</td>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIEREIFRS/pTXVCA">
            <xsl:with-param name="largeur">110</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <tr>
           <th class="clWidth375 clCouleur2 clAlignLeft clThNonGras">Rsultat oprationnel courant / CA HT</th>
           <td class="clWidth40 clCouleur2 clAlignCenter">%</td>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIEREIFRS/pROC_CA"/>
        </tr>
        <tr>
           <td class="clWidth375 clHeight10"></td>
           <td class="clWidth40 clHeight10"></td>
           <td class="clWidth110 clHeight10"></td>
           <td class="clWidth110 clHeight10"></td>
        </tr>
        <tr>
           <th class="clWidth375 clCouleur2 clAlignLeft clThNonGras">Intrts et charges assimiles / Rsultat oprationnel courant</th>
           <td class="clWidth40 clCouleur2 clAlignCenter">%</td>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIEREIFRS/pINT_ROC"/>
        </tr>
        <tr>
           <th class="clWidth375 clCouleur2 clAlignLeft clThNonGras">Intrts et charges assimiles / CA HT</th>
           <td class="clWidth40 clCouleur2 clAlignCenter">%</td>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIEREIFRS/pINT_CA">
            <xsl:with-param name="largeur">110</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <tr>
           <td class="clWidth375 clHeight10"></td>
           <td class="clWidth40 clHeight10"></td>
           <td class="clWidth110 clHeight10"></td>
           <td class="clWidth110 clHeight10"></td>
        </tr>
        <tr>
           <th class="clWidth375 clCouleur2 clAlignLeft clThNonGras">Rsultat oprationnel / CA HT</th>
           <td class="clWidth40 clCouleur2 clAlignCenter">%</td>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIEREIFRS/pK02685"/>
        </tr>
        <tr>
           <th class="clWidth375 clCouleur2 clAlignLeft clThNonGras">Rsultat net des activits en cours / CA HT</th>
           <td class="clWidth40 clCouleur2 clAlignCenter">%</td>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIEREIFRS/pK02705"/>
        </tr>
        <tr>
           <td class="clWidth375 clHeight10"></td>
           <td class="clWidth40 clHeight10"></td>
           <td class="clWidth110 clHeight10"></td>
           <td class="clWidth110 clHeight10"></td>
        </tr>
        <tr>
           <th class="clWidth375 clCouleur2 clAlignLeft clThNonGras">Rsultat net / Capitaux propres totaux</th>
           <td class="clWidth40 clCouleur2 clAlignCenter">%</td>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIEREIFRS/pRNC_CP">
            <xsl:with-param name="largeur">110</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <tr>
           <th class="clWidth375 clCouleur2 clAlignLeft clThNonGras">Rsultat part du groupe / Capitaux propres groupe</th>
           <td class="clWidth40 clCouleur2 clAlignCenter">%</td>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIEREIFRS/pRESPG_CP">
            <xsl:with-param name="largeur">110</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <tr>
           <td class="clWidth375 clHeight10"></td>
           <td class="clWidth40 clHeight10"></td>
           <td class="clWidth110 clHeight10"></td>
           <td class="clWidth110 clHeight10"></td>
        </tr>
        <tr>
           <th class="clWidth375 clCouleur2 clAlignLeft clThNonGras">Rsultat net (part du groupe) par action</th>
           <td class="clWidth40 clCouleur2 clAlignCenter">
            <img src="{$root}Images/risque/euro_symb_bleu.gif" width="8" height="9" alt="symbole euro"/>
          </td>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIEREIFRS/pRESPACT">
            <xsl:with-param name="largeur">110</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <tr>
           <th class="clWidth375 clCouleur2 clAlignLeft clThNonGras">Rsultat part des minoritaires / Intrts minoritaires</th>
           <td class="clWidth40 clCouleur2 clAlignCenter">%</td>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIEREIFRS/pRPRM_IM">
            <xsl:with-param name="largeur">110</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <tr>
           <th class="clWidth375 clCouleur2 clAlignLeft clThNonGras">Rsultat part des minoritaires / Rsultat net consolid</th>
           <td class="clWidth40 clCouleur2 clAlignCenter">%</td>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIEREIFRS/pRPRM_RC">
            <xsl:with-param name="largeur">110</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <tr>
           <td class="clWidth375 clHeight10"></td>
           <td class="clWidth40 clHeight10"></td>
           <td class="clWidth110 clHeight10"></td>
           <td class="clWidth110 clHeight10"></td>
        </tr>
        <tr>
           <th class="clWidth375 clCouleur2 clAlignLeft clThNonGras">FRNG / BFR</th>
           <td class="clWidth40 clCouleur2 clAlignCenter">%</td>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIEREIFRS/pK02525"/>
        </tr>
        <tr>
           <th class="clWidth375 clCouleur2 clAlignLeft clThNonGras">FRNG / CA HT</th>
           <td class="clWidth40 clCouleur2 clAlignCenter">j</td>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIEREIFRS/pFRNG_CA">
            <xsl:with-param name="largeur">110</xsl:with-param>
          </xsl:apply-templates>
        </tr>
        <tr>
           <th class="clWidth375 clCouleur2 clAlignLeft clThNonGras">BFR / CA HT</th>
           <td class="clWidth40 clCouleur2 clAlignCenter">j</td>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIEREIFRS/pK02528"/>
        </tr>
        <tr>
           <td class="clWidth375 clHeight10"></td>
           <td class="clWidth40 clHeight10"></td>
           <td class="clWidth110 clHeight10"></td>
           <td class="clWidth110 clHeight10"></td>
        </tr>
        <tr>
           <th class="clWidth375 clCouleur2 clAlignLeft clThNonGras">Capitaux propres / Total Bilan</th>
           <td class="clWidth40 clCouleur2 clAlignCenter">%</td>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIEREIFRS/pK02615"/>
        </tr>
        <tr>
           <th class="clWidth375 clCouleur2 clAlignLeft clThNonGras">Endettement financier / Capitaux propres</th>
           <td class="clWidth40 clCouleur2 clAlignCenter">%</td>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIEREIFRS/pK02616"/>
        </tr>
        <tr>
           <td class="clWidth375 clHeight10"></td>
           <td class="clWidth40 clHeight10"></td>
           <td class="clWidth110 clHeight10"></td>
           <td class="clWidth110 clHeight10"></td>
        </tr>
        <tr>
           <th class="clWidth375 clCouleur2 clAlignLeft clThNonGras">Dettes financires  plus d'un an / Capitaux propres</th>
           <td class="clWidth40 clCouleur2 clAlignCenter">%</td>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIEREIFRS/pK02606"/>
        </tr>
        <tr>
           <th class="clWidth375 clCouleur2 clAlignLeft clThNonGras">Dettes  caractre bancaire / Endettement financier (y c. loc. fin.)</th>
           <td class="clWidth40 clCouleur2 clAlignCenter">%</td>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIEREIFRS/pK02538"/>
        </tr>
        <tr>
           <th class="clWidth375 clCouleur2 clAlignLeft clThNonGras">Dettes financires stables / CAF</th>
           <td class="clWidth40 clCouleur2 clAlignCenter">A.m</td>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIEREIFRS/pK02617"/>
        </tr>
        <tr>
           <td class="clWidth375 clHeight10"></td>
           <td class="clWidth40 clHeight10"></td>
           <td class="clWidth110 clHeight10"></td>
           <td class="clWidth110 clHeight10"></td>
        </tr>
        <tr>
           <th class="clWidth375 clCouleur2 clAlignLeft clThNonGras">Ecarts acquisition largis / Capitaux propres appels</th>
           <td class="clWidth40 clCouleur2 clAlignCenter">%</td>
          <xsl:apply-templates select="../DIFF67/DONNEESCONSO/ANALYSEFINANCIEREIFRS/pK02536"/>
        </tr>
        <tr>
           <td class="clWidth375 clHeight10"></td>
           <td class="clWidth40 clHeight10"></td>
           <td class="clWidth110 clHeight10"></td>
           <td class="clWidth110 clHeight10"></td>
        </tr>
      </table>
    </xsl:if>
  </xsl:template>

  <!-- LISTE DES FILIALES ET SOUS-FILIALES CONSOLIDES (obligatoire) -->
  <xsl:template name="PERIMETRE">
    <div class="clBreakPage"/>
    <a name="filiales"/>
    <xsl:call-template name="shim"/>
    <br/>
    <table class="clWidth739 clBorderCell" role="presentation">
      <tr>
         <td class="clWidth19">&#160;</td>
       <td class="clCouleurGras clWidth597 clAlignCenter">LISTE DES FILIALES ET SOUS-FILIALES CONSOLIDES</td>
         <td class="clWidth19">&#160;</td>
        <td class="clCouleur2">&#160;</td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
    <table class="clWidth739 clBorderCell">
      <caption class="visually-hidden">LISTE DES FILIALES ET SOUS-FILIALES CONSOLIDES</caption>
      <tr>
        <th class="clCouleur2 clWidth175 clHeight15 clAlignLeft clThNonGras">&#160;Primtre diffus complet </th>
       <td class="clFond clWidth60 clHeight15 clAlignRight">
          <xsl:value-of select="../DIFF67/PERIMETRE/PERIMCPL"/>&#160;
        </td>
        <th class="clCouleur2 clWidth60 clHeight15 clAlignRight clThNonGras">au&#160;&#160;</th>
       <td class="clFond clWidth60 clHeight15 clAlignRight">
          <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="(../DIFF67/PERIMETRE/@DATPERI)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clWidth280 clHeight15" colspan="4"/>
        <td class="clWidth104 clCouleur2">&#160;</td>
      </tr>
      <xsl:if test="../DIFF67/PERIMETRE/NBFILIALES">
        <tr>
           <td class="clCouleur2 clWidth455 clHeight15" colspan="5"/>
          <td class="clCouleur2 clWidth60 clHeight15 clAlignRight clThNonGras">IG&#160;</td>
          <td class="clCouleur2 clWidth60 clHeight15 clAlignRight clThNonGras">IP&#160;</td>
          <td class="clCouleur2 clWidth60 clHeight15 clAlignRight clThNonGras">ME&#160;</td>
          <td class="clWidth104 clCouleur2">&#160;</td>
        </tr>
        <tr>
         <th colspan="2" class="clCouleur2 clWidth235 clHeight15 clAlignLeft clThNonGras">&#160;Nombre de filiales consolides</th>
         <td class="clFond clWidth60 clHeight15 clAlignRight">
            <xsl:value-of select="../DIFF67/PERIMETRE/NBFILIALES/NBFILTOT"/>&#160;
          </td>
          <td class="clWidth60 clHeight15"/>
           <th class="clCouleur2 clWidth100 clHeight15 clAlignLeft clThNonGras">rparties en</th>
         <td class="clFond clWidth60 clHeight15 clAlignRight">
            <xsl:value-of select="../DIFF67/PERIMETRE/NBFILIALES/NBFILIG"/>&#160;
          </td>
         <td class="clFond clWidth60 clHeight15 clAlignRight">
            <xsl:value-of select="../DIFF67/PERIMETRE/NBFILIALES/NBFILIP"/>&#160;
          </td>
         <td class="clFond clWidth60 clHeight15 clAlignRight">
            <xsl:value-of select="../DIFF67/PERIMETRE/NBFILIALES/NBFILME"/>&#160;
          </td>
          <td class="clWidth104 clCouleur2">&#160;</td>
        </tr>
      </xsl:if>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
    <xsl:apply-templates select="//FILIALE" mode="genLib"/>
    <a name="sorties"/>
    <xsl:if test="PERIMETRE/FILIALESORTIE">
      <div class="clBreakPage"/>
      <xsl:call-template name="shim"/>
      <br/>
      <table class="clWidth739 clBorderCell" role="presentation">
        <tr>
           <td class="clWidth19">&#160;</td>
         <td class="clCouleurGras clWidth597 clAlignCenter">LISTE DES FILIALES SORTIES DU PRIMTRE AU COURS DU DERNIER EXERCICE</td>
           <td class="clWidth19">&#160;</td>
        </tr>
      </table>
      <xsl:call-template name="shim"/>
      <br/>
      <table class="clWidth739 clBorderCell">
        <caption class="visually-hidden">LISTE DES FILIALES SORTIES DU PRIMTRE AU COURS DU DERNIER EXERCICE</caption>
        <xsl:apply-templates select="../DIFF67/PERIMETRE/FILIALESORTIE"/>
      </table>
    </xsl:if>
  </xsl:template>

  <xsl:template name="BreakLine3Cols">
    <xsl:param name="newHeight"/>
    <tr>
      <xsl:element name="td">
        <xsl:attribute name="width">355</xsl:attribute>
        <xsl:attribute name="height">
          <xsl:value-of select="$newHeight"/>
        </xsl:attribute>
      </xsl:element>
      <xsl:element name="td">
        <xsl:attribute name="width">140</xsl:attribute>
        <xsl:attribute name="colspan">2</xsl:attribute>
        <xsl:attribute name="height">
          <xsl:value-of select="$newHeight"/>
        </xsl:attribute>
      </xsl:element>
    </tr>
  </xsl:template>
  <xsl:template name="BreakLine3Cols110">
    <xsl:param name="newHeight"/>
    <tr>
      <xsl:element name="td">
        <xsl:attribute name="width">415</xsl:attribute>
        <xsl:attribute name="height">
          <xsl:value-of select="$newHeight"/>
        </xsl:attribute>
      </xsl:element>
      <xsl:element name="td">
        <xsl:attribute name="width">110</xsl:attribute>
        <xsl:attribute name="colspan">2</xsl:attribute>
        <xsl:attribute name="height">
          <xsl:value-of select="$newHeight"/>
        </xsl:attribute>
      </xsl:element>
    </tr>
  </xsl:template>
  <xsl:template name="BreakLine4Cols">
    <tr>
       <td class="clWidth315 clHeight10"/>
       <td class="clWidth40 clHeight10"/>
       <td class="clWidth140 clHeight10"/>
       <td class="clWidth140 clHeight10"/>
    </tr>
  </xsl:template>
  <xsl:template match="SURGROUPE">
    <tr>
      <td class="clFond clWidth130">
        &#160;<xsl:call-template name ="displaySirenXsl">
          <xsl:with-param name ="InputSiren" select ="(EJ/IDENTS)"/>
        </xsl:call-template>
      </td>
      <td class="clFond clWidth505">
        &#160;<xsl:value-of select="EJ/DENOM"/>
      </td>
    </tr>
    <tr>
      <td class="clWidth130"/>
       <td class="clWidth505 clAlignRight">
        <a href="#nullepart" onClick="requestBDFInfos('27|30|66|67|','','1','{EJ/IDENTS}',cstMultipleConfirm);">
          <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" alt="Plus d'infos" border="0"/>
        </a>
      </td>
    </tr>
  </xsl:template>
  <xsl:template match="SOUSGROUPE">
    <tr>
      <td class="clFond clWidth130 clHeight14">
        &#160;<xsl:call-template name ="displaySirenXsl">
          <xsl:with-param name ="InputSiren" select ="(EJ/IDENTS)"/>
        </xsl:call-template>
      </td>
       <td class="clFond clWidth505 clHeight14">
        &#160;<xsl:value-of select="EJ/DENOM"/>
      </td>
    </tr>
    <tr>
      <td class="clWidth130"/>
       <td class="clWidth505 clAlignRight">
        <a href="#nullepart" onClick="requestBDFInfos('27|30|66|67|','','1','{EJ/IDENTS}',cstMultipleConfirm);">
          <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" alt="Plus d'infos" border="0"/>
        </a>
      </td>
    </tr>
  </xsl:template>
  <xsl:template match="@DATCLOT">
    <xsl:param name="largeur"/>
    <xsl:choose>
      <xsl:when test ="$largeur = '140'">
        <td class="clWidth140 clGrasFond clAlignRight">
          <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="(.)"/>
          </xsl:call-template>&#160;
        </td>
      </xsl:when>
      <xsl:otherwise>
        <td class="clWidth110 clGrasFond clAlignRight">
          <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="(.)"/>
          </xsl:call-template>&#160;
        </td>        
      </xsl:otherwise> 
    </xsl:choose> 
    <xsl:if test="position()=last() and position()=1">
      <td class="clGrasFond clAlignRight">&#160;</td>      
      
    </xsl:if>
  </xsl:template>

  <xsl:template match="pEFFECT|pEFFETRG">
    <td class="clFond clWidth140 clAlignRight">
      <xsl:if test="@ETAT">
        <xsl:value-of select="@ETAT"/>&#160;
      </xsl:if>
      <xsl:if test="not(@ETAT)">
        <xsl:value-of select="(.)"/>&#160;
      </xsl:if>
    </td>
    <xsl:if test="position()=last() and position()=1">
     <td class="clFond clAlignRight">&#160;</td>
     <td class="clAlignRight">&#160;</td>
    </xsl:if>
    <xsl:if test="position()=last() and position()=2">
     <td class="clAlignRight">&#160;</td>
    </xsl:if>
  </xsl:template>

  <xsl:template match="@DUREEEX">
    <td class="clFond clWidth140 clAlignRight">
      <xsl:call-template name ="displayDateXsl">
        <xsl:with-param name ="InputDate" select ="(.)"/>
      </xsl:call-template>&#160;
    </td>
    <xsl:if test="position()=last() and position()=1">
     <td class="clFond clAlignRight">&#160;</td>
    </xsl:if>
  </xsl:template>

  <!--  postes comptables affichs en caractres gras ou normaux selon le paramtre "bold" -->
  <xsl:template match="p2011CA|pK01143|p2011CB|p2011CC|p2011CD|p2011CF|pK01144|p2011CH|p2011CI|p2011CK|p2011CN|pK01694|pK01151|p2011CT|p2011CY|pK01879|pK01145|pK01149|p2011DF|pK01880|p2011DJ|p2011EE|pK01154|p2011DT|p2011DU|p2011DV|p2011DW|p2011DX|p2011DY|p2011EA|p2011EB|pK01166|p2012GA|p2012GB|pRESERVES|p2012GE|p2012GF|p2012GI|p2012GK|pRESPRTGR|pRESPRTMI|pK01171|pK01172|p2012GQ|p2012GR|pK01174|p2012GW|pK01175|p2012GY|pK01176|pK01177|pK01178|p2012HC|p2012HD|p2012IX|p2012HB|pK01179|p2012HF|p2012HI|p2012HO|p2012HP|pK01881|pK01882|p2012IY|pK01187|pK01188|pK01282|p2012IN|pK01191|p2010ADN|p2010ADF|pK01192|pK01195|pK01196|pK01197|pK01198|p2013KJ|pK01199|pK01200|pK01883|pK01208|p2013LB|pK01209|pK01210|pK01212|pK01213|p2013LO|pK01219|pK01220|pK01221|pK01222|pK01225|pK01234|pK01231|pK01240|pK01235">
    <xsl:param name="bold"/>
     <td class="cl{$bold}Fond clWidth140 clAlignRight clBoxSizing">
      <xsl:if test="@ETAT">
        <xsl:value-of select="@ETAT"/>&#160;
      </xsl:if>
      <xsl:if test="not(@ETAT)">
        <xsl:call-template name ="displayNumberXsl">
          <xsl:with-param name ="InputStringNumber" select ="(.)"/>
        </xsl:call-template>&#160;
      </xsl:if>
    </td>
    <xsl:if test="position()=last() and position()=1">
       <td class="cl{$bold}Fond clWidth140 clAlignRight clBoxSizing">&#160;</td>
    </xsl:if>
  </xsl:template>

  <xsl:template match="p2013MG|p2013MH|p2013MJ|pK01237|p2013MK|pK01238|pK01239|p2013MM|p2013MN|p2013MO|p2014OA|pK01242|pK01243|pK01244|p2014PJ|pK01248|p2014PL|p2014PQ|p2014PW|pK01245|pK01255|pK01256|pK01259|pK01641|pK01257|pK01266|pK01264|p2014QZ|p2014QO|p2014QP|pK01267|p2014QR|pK01268|p2014QS|pK01269|pK01270|p2014QV|p2014QW|p2015TJ|p2015TK|p2015TL|p2015TM|p2015TN|p2015TO|pK01884|p2015TS|p2015TT|pK01279|p2015TU|p2015TV|p2015TW|p2015TX|p2015TY|p2015TZ|pK01885|p2015UD|p2015UE|p2015UF|pK01280|p2015UG|p2015UH|p2015UI|p2015UJ|p2015UK|p2015UL|p2015UM|p2015UN|p2015UO|p2015UP|p2015UQ|p2015UR|pK01376|pK01295|pK01283|pFONDPR|pK01353|pK01354|pCAF|pK01381|pTXVCA|pEBE_CA|pINT_EBE|pINT_CA|pRESEX_CA|pRESC_CA|pRAMT_CP|pBFR_CA|pFPN_TB|pK01811|pEF_FPN|pDF_FPN|pDFS_CAF|pK01865">
    <xsl:param name="bold"/>
     <td class="cl{$bold}Fond clWidth140 clAlignRight clBoxSizing">
      <xsl:if test="@ETAT">
        <xsl:value-of select="@ETAT"/>&#160;
      </xsl:if>
      <xsl:if test="not(@ETAT)">
        <xsl:call-template name ="displayNumberXsl">
          <xsl:with-param name ="InputStringNumber" select ="(.)"/>
        </xsl:call-template>&#160;
      </xsl:if>
    </td>
    <xsl:if test="position()=last() and position()=1">
       <td class="cl{$bold}Fond clWidth140 clAlignRight clBoxSizing">&#160;</td>
    </xsl:if>
  </xsl:template>

  <!--  postes comptables affichs en caractres gras ou normaux selon le paramtre "bold" avec retour en haut de page -->
  <xsl:template match="p2011DH|pK01167|p2012HZ|pK01201|pK01236|p2014PP|p2014QU|pK01281|pK01382|pK01369">
    <xsl:param name="bold"/>
     <td class="cl{$bold}Fond clWidth140 clAlignRight clBoxSizing">
      <xsl:if test="@ETAT">
        <xsl:value-of select="@ETAT"/>&#160;
      </xsl:if>
      <xsl:if test="not(@ETAT)">
        <xsl:call-template name ="displayNumberXsl">
          <xsl:with-param name ="InputStringNumber" select ="(.)"/>
        </xsl:call-template>&#160;
      </xsl:if>
    </td>
    <xsl:if test="position()=last() and position()=1">
       <td class="cl{$bold}Fond clWidth140 clAlignRight clBoxSizing">&#160;</td>
    </xsl:if>
    <xsl:if test="position()=last()">
       <td class="clWidth104 clAlignRight">
        <a href="#ancHaut">
          <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" alt="Retour en haut de la page"/>
        </a>
      </td>
    </xsl:if>
  </xsl:template>

  <xsl:template match="FILIALE" mode="genLib">
    <xsl:variable name="position" select="position()"/>
    <xsl:variable name="precedent" select="position() - 1"/>
    <xsl:if test="($precedent mod 15 = 0) and ($position != 1)">
      <div class="clBreakPage"/>
    </xsl:if>
    <table class="clWidth739 clBorderCell">

      <tr>
         <td colspan="2" class="clHeight10"/>
      </tr>

      <xsl:if test="../FILIALE[$position]/CLASSE1 and not(../FILIALE[$precedent]/CLASSE1)">
        <tr>
          <td colspan="2" class="clCouleur2 clHeight16">
            SOUS-HOLDINGS CONSOLIDANTES ET AUTONOMES
          </td>
        </tr>
      </xsl:if>
      <xsl:if test="../FILIALE[$position]/CLASSE2 and not(../FILIALE[$precedent]/CLASSE2)">

        <tr>
           <td class="clHeight10" colspan="2"></td>
        </tr>
        <tr>
          <td colspan="2" class="clCouleur2 clHeight16">SOUS-HOLDINGS ET FILIALES INFLUENCES PAR L'ENTIT INTERROGE</td>
        </tr>
        <tr>
           <td class="clHeight10" colspan="2"></td>
        </tr>
        <tr>
          <td colspan="2" class="clCouleur2 clHeight16">Cote de crdit groupe</td>
        </tr>
      </xsl:if>
      <xsl:if test="../FILIALE[$position]/CLASSE3 and not(../FILIALE[$precedent]/CLASSE2|../FILIALE[$precedent]/CLASSE3)">
        <tr>
           <td class="clHeight10" colspan="2"></td>
        </tr>
        <tr>
          <td colspan="2" class="clCouleur2 clHeight16">SOUS-HOLDINGS ET FILIALES INFLUENCES PAR L'ENTIT INTERROGE</td>
        </tr>
        <tr>
           <td class="clHeight10" colspan="2"></td>
        </tr>
        <tr>
          <td colspan="2" class="clCouleur2 clHeight16">Cote de crdit influence, influence favorable du groupe</td>
        </tr>
      </xsl:if>
      <xsl:if test="(../FILIALE[$position]/CLASSE3 and not(../FILIALE[$precedent]/CLASSE3) and (../FILIALE[$precedent]/CLASSE2))">

        <tr>
           <td class="clHeight10" colspan="2"></td>
        </tr>
        <tr>
          <td colspan="2" class="clCouleur2 clHeight16">Cote de crdit influence, influence favorable du groupe</td>
        </tr>
      </xsl:if>
      <xsl:if test="(../FILIALE[$position]/CLASSE4 and not(../FILIALE[$precedent]/CLASSE2|../FILIALE[$precedent]/CLASSE3|../FILIALE[$precedent]/CLASSE4))">
        <tr>
           <td class="clHeight10" colspan="2"></td>
        </tr>
        <tr>
          <td colspan="2" class="clCouleur2 clHeight16">SOUS-HOLDINGS ET FILIALES INFLUENCES PAR L'ENTIT INTERROGE</td>
        </tr>
        <tr>
           <td class="clHeight10" colspan="2"></td>
        </tr>
        <tr>
          <td colspan="2" class="clCouleur2 clHeight16">Cote de crdit intrinsque identique  celle du groupe (influence neutre)</td>
        </tr>
      </xsl:if>
      <xsl:if test="(../FILIALE[$position]/CLASSE4 and not(../FILIALE[$precedent]/CLASSE4) and (../FILIALE[$precedent]/CLASSE2|../FILIALE[$precedent]/CLASSE3))">

        <tr>
           <td class="clHeight10" colspan="2"></td>
        </tr>
        <tr>
          <td colspan="2" class="clCouleur2 clHeight16">Cote de crdit intrinsque identique  celle du groupe (influence neutre)</td>
        </tr>
      </xsl:if>
      <xsl:if test="(../FILIALE[$position]/CLASSE5 and not(../FILIALE[$precedent]/CLASSE2|../FILIALE[$precedent]/CLASSE3|../FILIALE[$precedent]/CLASSE4|../FILIALE[$precedent]/CLASSE5))">
        <tr>
           <td class="clHeight10" colspan="2"></td>
        </tr>
        <tr>
          <td colspan="2" class="clCouleur2 clHeight16">SOUS-HOLDINGS ET FILIALES INFLUENCES PAR L'ENTIT INTERROGE</td>
        </tr>
        <tr>
           <td class="clHeight10" colspan="2"></td>
        </tr>
        <tr>
          <td colspan="2" class="clCouleur2 clHeight16">Cote de crdit intrinsque (en attente de l'application de l'influence des comptes consolids du groupe)</td>
        </tr>
      </xsl:if>
      <xsl:if test="(../FILIALE[$position]/CLASSE5 and not(../FILIALE[$precedent]/CLASSE5) and (../FILIALE[$precedent]/CLASSE2|../FILIALE[$precedent]/CLASSE3|../FILIALE[$precedent]/CLASSE4))">

        <tr>
           <td class="clHeight10" colspan="2"></td>
        </tr>
        <tr>
          <td colspan="2" class="clCouleur2 clHeight16">Cote de crdit intrinsque (en attente de l'application de l'influence des comptes consolids du groupe)</td>
        </tr>
      </xsl:if>
      <xsl:if test="(../FILIALE[$position]/CLASSE6 and not(../FILIALE[$precedent]/CLASSE2|../FILIALE[$precedent]/CLASSE3|../FILIALE[$precedent]/CLASSE4|../FILIALE[$precedent]/CLASSE5|../FILIALE[$precedent]/CLASSE6))">
        <tr>
           <td class="clHeight10" colspan="2"></td>
        </tr>
        <tr>
          <td colspan="2" class="clCouleur2 clHeight16">SOUS-HOLDINGS ET FILIALES INFLUENCES PAR L'ENTIT INTERROGE</td>
        </tr>
        <tr>
           <td class="clHeight10" colspan="2"></td>
        </tr>
        <tr>
          <td colspan="2" class="clCouleur2 clHeight16">Cote de crdit influence, influence dfavorable du groupe</td>
        </tr>
      </xsl:if>
      <xsl:if test="(../FILIALE[$position]/CLASSE6 and not(../FILIALE[$precedent]/CLASSE6) and (../FILIALE[$precedent]/CLASSE2|../FILIALE[$precedent]/CLASSE3|../FILIALE[$precedent]/CLASSE4|../FILIALE[$precedent]/CLASSE5))">

        <tr>
           <td class="clHeight10" colspan="2"></td>
        </tr>
        <tr>
          <td colspan="2" class="clCouleur2 clHeight16">Cote de crdit influence, influence dfavorable du groupe</td>
        </tr>
      </xsl:if>
      <xsl:if test="(../FILIALE[$position]/CLASSE7 and not(../FILIALE[$precedent]/CLASSE2|../FILIALE[$precedent]/CLASSE3|../FILIALE[$precedent]/CLASSE4|../FILIALE[$precedent]/CLASSE5|../FILIALE[$precedent]/CLASSE6|../FILIALE[$precedent]/CLASSE7))">
        <tr>
           <td class="clHeight10" colspan="2"></td>
        </tr>
        <tr>
          <td colspan="2" class="clCouleur2 clHeight16">SOUS-HOLDINGS ET FILIALES INFLUENCES PAR L'ENTIT INTERROGE</td>
        </tr>
        <tr>
           <td class="clHeight10" colspan="2"></td>
        </tr>
        <tr>
          <td colspan="2" class="clCouleur2 clHeight16">Informations extra-comptables dfavorables primant l'analyse du groupe</td>
        </tr>
      </xsl:if>
      <xsl:if test="(../FILIALE[$position]/CLASSE7 and not(../FILIALE[$precedent]/CLASSE7) and (../FILIALE[$precedent]/CLASSE2|../FILIALE[$precedent]/CLASSE3|../FILIALE[$precedent]/CLASSE4|../FILIALE[$precedent]/CLASSE5|../FILIALE[$precedent]/CLASSE6))">

        <tr>
           <td class="clHeight10" colspan="2"></td>
        </tr>
        <tr>
          <td colspan="2" class="clCouleur2 clHeight16">Informations extra-comptables dfavorables primant l'analyse du groupe</td>
        </tr>
      </xsl:if>
      <xsl:if test="../FILIALE[$position]/CLASSE8 and not(../FILIALE[$precedent]/CLASSE8)">
        <tr>
          <td colspan="2" class="clCouleur2 clHeight16">
            SOUS-HOLDINGS ET FILIALES INFLUENCES PAR UNE AUTRE ENTIT QUE CELLE INTERROGE
          </td>
        </tr>
      </xsl:if>
      <xsl:if test="../FILIALE[$position]/CLASSE9 and not(../FILIALE[$precedent]/CLASSE9)">
        <tr>
          <td colspan="2" class="clCouleur2 clHeight16">
            SOUS-HOLDINGS ET FILIALES SANS ENTIT INFLUENANTE
          </td>
        </tr>
      </xsl:if>
    </table>
    <table class="clWidth739 clBorderCell">
      <tr>
         <td colspan="6" class="clHeight6"/>
      </tr>
      <tr>
         <td class="clFond clWidth120">
          &#160;<xsl:call-template name ="displaySirenXsl">
            <xsl:with-param name ="InputSiren" select ="(DETAILFILIALE/EJ/IDENTS)"/>
          </xsl:call-template>
        </td>
        <td class="clFond clWidth380">
          &#160;<xsl:value-of select="DETAILFILIALE/EJ/DENOM"/>
        </td>
        <td class="clFond clWidth45 clAlignRight">
          <xsl:value-of select="MODCONSO"/>
        </td>
        <xsl:choose >
          <xsl:when test ="DETAILFILIALE/SEGMENT">
            <td class="clFond clWidth45 clAlignRight">
              <xsl:value-of select="DETAILFILIALE/VALCOT"/>&#160;|&#160;<xsl:value-of select="DETAILFILIALE/SEGMENT"/>
            </td>
          </xsl:when>
          <xsl:otherwise>
            <td class="clFond clWidth45 clAlignRight">
              <xsl:value-of select="DETAILFILIALE/VALCOT"/>
            </td>
          </xsl:otherwise>
        </xsl:choose>

        <xsl:if test="ENTREE='O'">
          <td class="clFond clWidth45 clAlignRight">(E)</td>
        </xsl:if>
        <xsl:if test="not(ENTREE='O')">
          <td class="clFond clWidth45 clAlignRight">&#160;</td>
        </xsl:if>
        <xsl:if test="position() mod 10 = 0">
           <td class="clWidth104 clAlignRight">
            <a href="#ancHaut">
              <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page"/>
            </a>
          </td>
        </xsl:if>
        <xsl:if test="position() mod 10 != 0">
           <td class="clAlignRight">&#160;</td>
        </xsl:if>
      </tr>
      <tr>
         <td class="clTexte clWidth120 clHeight14">&#160;</td>
         <td class="clTexte clWidth380">
          &#160;&#160;<xsl:value-of select="DETAILFILIALE/LOCALI"/>
        </td>
        <xsl:if test="CLASSE1">
           <td colspan="3" class="clHeight14 clAlignRight">
            <a href="#nullepart" onClick="requestBDFInfos('27|30|66|67|','','1','{DETAILFILIALE/EJ/IDENTS}',cstMultipleConfirm);">
              <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" alt="Plus d'infos" border="0"/>
            </a>
          </td>
        </xsl:if>
        <xsl:if test="not(CLASSE1)">
          <xsl:if test ="DETAILFILIALE/SEGMENT">
             <td colspan="3" class="clHeight14 clAlignRight">
              <a href="#nullepart" onClick="requestBDFInfos('27|37|39|','','1','{DETAILFILIALE/EJ/IDENTS}',cstMultipleConfirm);">
                <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" alt="Plus d'infos" border="0"/>
              </a>
            </td>
          </xsl:if>
          <xsl:if test ="not(DETAILFILIALE/SEGMENT)">
             <td colspan="3" class="clHeight14 clAlignRight">
              <a href="#nullepart" onClick="requestBDFInfos('27|37|','','1','{DETAILFILIALE/EJ/IDENTS}',cstMultipleConfirm);">
                <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" alt="Plus d'infos" border="0"/>
              </a>
            </td>
          </xsl:if>
        </xsl:if>
         <td class="clWidth104 clAlignRight">&#160;</td>
      </tr>
    </table>
    <xsl:if test="position()=last()">
      <table class="clWidth739 clBorderCell">
        <tr>
           <td colspan="2" class="clHeight6"/>
        </tr>
        <tr>
          <td class="clItalic" colspan="2">&#160;IG : Filiale consolide selon la mthode de l'intgration globale</td>
        </tr>
        <tr>
          <td class="clItalic" colspan="2">&#160;IP : Filiale consolide selon la mthode de l'intgration proportionnelle</td>
        </tr>
        <tr>
          <td class="clItalic" colspan="2">&#160;ME : Filiale consolide selon la mthode de la mise en quivalence</td>
        </tr>
        <tr>
          <td class="clItalic" colspan="2">&#160;(E) : Socit nouvellement entre dans le primtre de consolidation</td>
        </tr>
      </table>
    </xsl:if>
  </xsl:template>
  <xsl:template match="FILIALESORTIE">
    <tr>
       <td class="clFond clWidth120">
        &#160;<xsl:call-template name ="displaySirenXsl">
          <xsl:with-param name ="InputSiren" select ="(DETAILFILIALE/EJ/IDENTS)"/>
        </xsl:call-template>
      </td>
       <td class="clFond clWidth380">
        &#160;<xsl:value-of select="DETAILFILIALE/EJ/DENOM"/>
      </td>
       <td class="clFond clWidth45">&#160;</td>
      <xsl:choose>
        <xsl:when test ="DETAILFILIALE/SEGMENT">
           <td class="clFond clWidth45 clAlignRight">
            &#160;<xsl:value-of select="DETAILFILIALE/VALCOT"/>&#160;|&#160;<xsl:value-of select="DETAILFILIALE/SEGMENT"/>
          </td>
        </xsl:when>
        <xsl:otherwise>
           <td class="clFond clWidth45 clAlignRight">
            &#160;<xsl:value-of select="DETAILFILIALE/VALCOT"/>
          </td>
        </xsl:otherwise>
      </xsl:choose>

       <td class="clFond clWidth45">&#160;</td>
      <xsl:if test="position() mod 10 = 0">
         <td class="clAlignRight">
          <a href="#ancHaut">
            <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page"/>
          </a>
        </td>
      </xsl:if>
      <xsl:if test="position() mod 10 != 0">
         <td class="clAlignRight">&#160;</td>
      </xsl:if>
    </tr>
    <tr>
      <td class="clTexte clWidth120 clHeight14">&#160;</td>
      <td class="clTexte clWidth380 clHeight14">
        &#160;&#160;<xsl:value-of select="DETAILFILIALE/LOCALI"/>
      </td>
       <td colspan="3" class="clHeight14 clAlignRight">
        <a href="#nullepart" onClick="requestBDFInfos('27|30|66|67|','','1','{DETAILFILIALE/EJ/IDENTS}',cstMultipleConfirm);">
          <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" alt="Plus d'infos" border="0"/>
        </a>
      </td>
    </tr>
    <tr>
      <td class="clHeight6" colspan="5"/>
    </tr>
  </xsl:template>

   <xsl:template name="genGraph67">
    <xsl:param name="ident"/>
    <xsl:param name="nom"/>
    <xsl:param name="nomconj"/>
    <xsl:param name="valcot"/>
    <xsl:param name="segment"/>
    <xsl:param name="datcot"/>
    <xsl:param name="datexa"/>
    <xsl:param name="idrenv"/>
    <form action="Graphes.aspx" method="post" name="FormGraphes" target="_blank">
      <input name="familyNumber" type="hidden" value="1"/>
      <input name="moduleNumber" type="hidden" value="{/FIBEN/@MODDEM}"/>
      <xsl:element name="input">
        <xsl:attribute name="name">GrapheData</xsl:attribute>
        <xsl:attribute name="type">hidden</xsl:attribute>
        <xsl:attribute name="value">
          &lt;FIBEN MODDEM=&quot;<xsl:value-of select="FIBEN/@MODDEM"/>&quot; DATJOUR=&quot;<xsl:call-template name ="displayDateForGraph2">
            <xsl:with-param name ="InputDateForGraph" select ="FIBEN/@DATJOUR"/>
          </xsl:call-template>&quot; GRAPHE=&quot;1&quot;&gt;
          &lt;ident&gt;<xsl:value-of select="$ident"/>&lt;/ident&gt;
          &lt;nom&gt;<xsl:value-of select="$nom"/>&lt;/nom&gt;
          &lt;valcot&gt;<xsl:value-of select="$valcot"/>&lt;/valcot&gt;
          &lt;segment&gt;<xsl:value-of select="$segment"/>&lt;/segment&gt;
          &lt;graphe&gt;
          <xsl:if test="$condGraph60">
            &lt;serie&gt;
            <xsl:if test="//DONNEESCONSO/BILAN67">
              &lt;val&gt;<xsl:value-of select="translate(FIBEN/PERSONNE/MODULE67/DIFF67/DONNEESCONSO[position()=last()]/BILAN67/pK01143,',','.')"/>&lt;/val&gt;
              &lt;val&gt;<xsl:value-of select="translate(FIBEN/PERSONNE/MODULE67/DIFF67/DONNEESCONSO[position()=last()]/BILAN67/pK01151,',','.')"/>&lt;/val&gt;
              &lt;val&gt;<xsl:value-of select="number(translate(FIBEN/PERSONNE/MODULE67/DIFF67/DONNEESCONSO[position()=last()]/BILAN67/pK01880,',','.')) + number(translate(FIBEN/PERSONNE/MODULE67/DIFF67/DONNEESCONSO[position()=last()]/BILAN67/p2011DJ,',','.')) + number(translate(FIBEN/PERSONNE/MODULE67/DIFF67/DONNEESCONSO[position()=last()]/BILAN67/p2011EE,',','.')) + number(translate(FIBEN/PERSONNE/MODULE67/DIFF67/DONNEESCONSO[position()=last()]/BILAN67/p2011CA,',','.'))"/>&lt;/val&gt;
            </xsl:if>
            <xsl:if test="//DONNEESCONSO/BILAN67IFRS">
              &lt;val&gt;<xsl:value-of select="translate(FIBEN/PERSONNE/MODULE67/DIFF67/DONNEESCONSO[position()=last()]/BILAN67IFRS/pK02399,',','.')"/>&lt;/val&gt;
              &lt;val&gt;<xsl:value-of select="translate(FIBEN/PERSONNE/MODULE67/DIFF67/DONNEESCONSO[position()=last()]/BILAN67IFRS/pK02403,',','.')"/>&lt;/val&gt;
              &lt;val&gt;<xsl:value-of select="translate(FIBEN/PERSONNE/MODULE67/DIFF67/DONNEESCONSO[position()=last()]/BILAN67IFRS/p2011EAR,',','.')"/>&lt;/val&gt;
            </xsl:if>
            &lt;/serie&gt;
            &lt;serie&gt;
            <xsl:if test="//DONNEESCONSO/BILAN67">
              &lt;val&gt;<xsl:value-of select="translate(FIBEN/PERSONNE/MODULE67/DIFF67/DONNEESCONSO[position()=last()]/BILAN67/pK01171,',','.')"/>&lt;/val&gt;
              &lt;val&gt;<xsl:value-of select="translate(FIBEN/PERSONNE/MODULE67/DIFF67/DONNEESCONSO[position()=last()]/BILAN67/pK01177,',','.')"/>&lt;/val&gt;
              &lt;val&gt;<xsl:value-of select="number(translate(FIBEN/PERSONNE/MODULE67/DIFF67/DONNEESCONSO[position()=last()]/BILAN67/pK01882,',','.')) + number(translate(FIBEN/PERSONNE/MODULE67/DIFF67/DONNEESCONSO[position()=last()]/BILAN67/p2012HZ,',','.')) + number(translate(FIBEN/PERSONNE/MODULE67/DIFF67/DONNEESCONSO[position()=last()]/BILAN67/p2012IY,',','.')) + number(translate(FIBEN/PERSONNE/MODULE67/DIFF67/DONNEESCONSO[position()=last()]/BILAN67/pK01172,',','.')) + number(translate(FIBEN/PERSONNE/MODULE67/DIFF67/DONNEESCONSO[position()=last()]/BILAN67/pK01174,',','.'))"/>&lt;/val&gt;
              &lt;val&gt;<xsl:value-of select="translate(FIBEN/PERSONNE/MODULE67/DIFF67/DONNEESCONSO[position()=last()]/BILAN67/pK01187,',','.')"/>&lt;/val&gt;
            </xsl:if>
            <xsl:if test="//DONNEESCONSO/BILAN67IFRS">
              &lt;val&gt;<xsl:value-of select="translate(FIBEN/PERSONNE/MODULE67/DIFF67/DONNEESCONSO[position()=last()]/BILAN67IFRS/pK02411,',','.')"/>&lt;/val&gt;
              &lt;val&gt;<xsl:value-of select="translate(FIBEN/PERSONNE/MODULE67/DIFF67/DONNEESCONSO[position()=last()]/BILAN67IFRS/pK02419,',','.')"/>&lt;/val&gt;
              &lt;val&gt;<xsl:value-of select="translate(FIBEN/PERSONNE/MODULE67/DIFF67/DONNEESCONSO[position()=last()]/BILAN67IFRS/pK02423,',','.')"/>&lt;/val&gt;
              &lt;val&gt;<xsl:value-of select="translate(FIBEN/PERSONNE/MODULE67/DIFF67/DONNEESCONSO[position()=last()]/BILAN67IFRS/p2018FBJ,',','.')"/>&lt;/val&gt;
              &lt;val&gt;<xsl:value-of select="translate(FIBEN/PERSONNE/MODULE67/DIFF67/DONNEESCONSO[position()=last()]/BILAN67IFRS/p2011DS,',','.')"/>&lt;/val&gt;
            </xsl:if>
            &lt;/serie&gt;
          </xsl:if>
          &lt;titre&gt;Grandes masses du bilan de l'exercice <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="(FIBEN/PERSONNE/MODULE67/DIFF67/DONNEESCONSO[position()=last()]/@DATCLOT)"/>
          </xsl:call-template> (en pourcentage du Total bilan)&lt;/titre&gt;
          <xsl:if test="//DONNEESCONSO/BILAN67">
            &lt;type&gt;NF&lt;/type&gt;
          </xsl:if>
          <xsl:if test="//DONNEESCONSO/BILAN67IFRS">
            &lt;type&gt;IFRS&lt;/type&gt;
          </xsl:if>
          &lt;signet&gt;Grandes masses du bilan&lt;/signet&gt;
          &lt;/graphe&gt;

          &lt;graphe&gt;
          <xsl:if test="$condGraph66">

            <xsl:for-each select="//DONNEESCONSO">
              <xsl:if test="RESULTAT">
                <xsl:if test="(RESULTAT/RESULTATNATURE and not(RESULTAT/RESULTATNATURE/pK01208/@ETAT='ND'))">
                  &lt;serie&gt;
                  <xsl:if test="RESULTAT/RESULTATNATURE/pK01208/@ETAT='ND'">
                    &lt;val&gt;0&lt;/val&gt;
                  </xsl:if>
                  <xsl:if test="not(RESULTAT/RESULTATNATURE/pK01208/@ETAT)">
                    &lt;val&gt;
                    <xsl:value-of select="RESULTAT/RESULTATNATURE/pK01208"/>
                    &lt;/val&gt;
                  </xsl:if>
                  <xsl:if test="RESULTAT/RESULTATNATURE/pK01221/@ETAT='ND'">
                    &lt;val&gt;0&lt;/val&gt;
                  </xsl:if>
                  <xsl:if test="not(RESULTAT/RESULTATNATURE/pK01221/@ETAT)">
                    &lt;val&gt;
                    <xsl:value-of select="RESULTAT/RESULTATNATURE/pK01221"/>
                    &lt;/val&gt;
                  </xsl:if>
                  <xsl:if test="RESULTAT/RESULTATNATURE/p2013MM/@ETAT='ND'">
                    &lt;val&gt;0&lt;/val&gt;
                  </xsl:if>
                  <xsl:if test="not(RESULTAT/RESULTATNATURE/p2013MM/@ETAT)">
                    &lt;val&gt;
                    <xsl:value-of select="RESULTAT/RESULTATNATURE/p2013MM"/>
                    &lt;/val&gt;
                  </xsl:if>
                  <xsl:if test="RESULTAT/RESULTATNATURE/p2013MN/@ETAT='ND'">
                    &lt;val&gt;0&lt;/val&gt;
                  </xsl:if>
                  <xsl:if test="not(RESULTAT/RESULTATNATURE/p2013MN/@ETAT)">
                    &lt;val&gt;
                    <xsl:value-of select="RESULTAT/RESULTATNATURE/p2013MN"/>
                    &lt;/val&gt;
                  </xsl:if>
                  <xsl:if test="RESULTAT/RESULTATNATURE/p2013MO/@ETAT='ND'">
                    &lt;val&gt;0&lt;/val&gt;
                  </xsl:if>
                  <xsl:if test="not(RESULTAT/RESULTATNATURE/p2013MO/@ETAT)">
                    &lt;val&gt;
                    <xsl:value-of select="RESULTAT/RESULTATNATURE/p2013MO"/>
                    &lt;/val&gt;
                  </xsl:if>
                  <xsl:if test="ANALYSEFINANCIERE/pCAF/@ETAT='ND'">
                    &lt;val&gt;999999&lt;/val&gt;
                  </xsl:if>
                  <xsl:if test="not(ANALYSEFINANCIERE/pCAF/@ETAT)">
                    &lt;val&gt;
                    <xsl:value-of select="ANALYSEFINANCIERE/pCAF"/>
                    &lt;/val&gt;
                  </xsl:if>
                  &lt;/serie&gt;
                </xsl:if>

                <xsl:if test="(not(RESULTAT/RESULTATNATURE) or (RESULTAT/RESULTATNATURE/pK01208/@ETAT='ND'))">
                  &lt;serie&gt;
                  <xsl:if test="RESULTAT/RESULTATFONCTIONNEL/pK01244/@ETAT='ND'">
                    &lt;val&gt;0&lt;/val&gt;
                  </xsl:if>
                  <xsl:if test="not(RESULTAT/RESULTATFONCTIONNEL/pK01244/@ETAT)">
                    &lt;val&gt;
                    <xsl:value-of select="RESULTAT/RESULTATFONCTIONNEL/pK01244"/>
                    &lt;/val&gt;
                  </xsl:if>
                  <xsl:if test="RESULTAT/RESULTATFONCTIONNEL/pK01256/@ETAT='ND'">
                    &lt;val&gt;0&lt;/val&gt;
                  </xsl:if>
                  <xsl:if test="not(RESULTAT/RESULTATFONCTIONNEL/pK01256/@ETAT)">
                    &lt;val&gt;
                    <xsl:value-of select="RESULTAT/RESULTATFONCTIONNEL/pK01256"/>
                    &lt;/val&gt;
                  </xsl:if>
                  <xsl:if test="RESULTAT/RESULTATFONCTIONNEL/p2014QU/@ETAT='ND'">
                    &lt;val&gt;0&lt;/val&gt;
                  </xsl:if>
                  <xsl:if test="not(RESULTAT/RESULTATFONCTIONNEL/p2014QU/@ETAT)">
                    &lt;val&gt;
                    <xsl:value-of select="RESULTAT/RESULTATFONCTIONNEL/p2014QU"/>
                    &lt;/val&gt;
                  </xsl:if>
                  <xsl:if test="RESULTAT/RESULTATFONCTIONNEL/p2014QV/@ETAT='ND'">
                    &lt;val&gt;0&lt;/val&gt;
                  </xsl:if>
                  <xsl:if test="not(RESULTAT/RESULTATFONCTIONNEL/p2014QV/@ETAT)">
                    &lt;val&gt;
                    <xsl:value-of select="RESULTAT/RESULTATFONCTIONNEL/p2014QV"/>
                    &lt;/val&gt;
                  </xsl:if>
                  <xsl:if test="RESULTAT/RESULTATFONCTIONNEL/p2014QW/@ETAT='ND'">
                    &lt;val&gt;0&lt;/val&gt;
                  </xsl:if>
                  <xsl:if test="not(RESULTAT/RESULTATFONCTIONNEL/p2014QW/@ETAT)">
                    &lt;val&gt;
                    <xsl:value-of select="RESULTAT/RESULTATFONCTIONNEL/p2014QW"/>
                    &lt;/val&gt;
                  </xsl:if>
                  <xsl:if test="ANALYSEFINANCIERE/pCAF/@ETAT='ND'">
                    &lt;val&gt;999999&lt;/val&gt;
                  </xsl:if>
                  <xsl:if test="not(ANALYSEFINANCIERE/pCAF/@ETAT)">
                    &lt;val&gt;
                    <xsl:value-of select="ANALYSEFINANCIERE/pCAF"/>
                    &lt;/val&gt;
                  </xsl:if>
                  &lt;/serie&gt;
                </xsl:if>
              </xsl:if>

              <!--xsl:for-each select="//DONNEESCONSO"-->
              <xsl:if test="RESULTATIFRS">
                <xsl:if test="(RESULTATIFRS/RESULTATNATUREIFRS and not(RESULTATIFRS/RESULTATNATUREIFRS/pK02697/@ETAT='ND'))">

                  &lt;serie&gt;
                  <xsl:if test="RESULTATIFRS/RESULTATNATUREIFRS/pK02697/@ETAT='ND'">
                    &lt;val&gt;0&lt;/val&gt;
                  </xsl:if>
                  <xsl:if test="not(RESULTATIFRS/RESULTATNATUREIFRS/pK02697/@ETAT)">
                    &lt;val&gt;
                    <xsl:value-of select="RESULTATIFRS/RESULTATNATUREIFRS/pK02697"/>
                    &lt;/val&gt;
                  </xsl:if>
                  <xsl:if test="RESULTATIFRS/RESULTATNATUREIFRS/p2019SARN/@ETAT='ND'">
                    &lt;val&gt;0&lt;/val&gt;
                  </xsl:if>
                  <xsl:if test="not(RESULTATIFRS/RESULTATNATUREIFRS/p2019SARN/@ETAT)">
                    &lt;val&gt;
                    <xsl:value-of select="RESULTATIFRS/RESULTATNATUREIFRS/p2019SARN"/>
                    &lt;/val&gt;
                  </xsl:if>
                  <xsl:if test="RESULTATIFRS/RESULTATNATUREIFRS/p2019SBKN/@ETAT='ND'">
                    &lt;val&gt;0&lt;/val&gt;
                  </xsl:if>
                  <xsl:if test="not(RESULTATIFRS/RESULTATNATUREIFRS/p2019SBKN/@ETAT)">
                    &lt;val&gt;
                    <xsl:value-of select="RESULTATIFRS/RESULTATNATUREIFRS/p2019SBKN"/>
                    &lt;/val&gt;
                  </xsl:if>
                  <xsl:if test="RESULTATIFRS/RESULTATNATUREIFRS/p2019SBLN/@ETAT='ND'">
                    &lt;val&gt;0&lt;/val&gt;
                  </xsl:if>
                  <xsl:if test="not(RESULTATIFRS/RESULTATNATUREIFRS/p2019SBLN/@ETAT)">
                    &lt;val&gt;
                    <xsl:value-of select="RESULTATIFRS/RESULTATNATUREIFRS/p2019SBLN"/>
                    &lt;/val&gt;
                  </xsl:if>
                  <xsl:if test="RESULTATIFRS/RESULTATNATUREIFRS/p2019SBMN/@ETAT='ND'">
                    &lt;val&gt;0&lt;/val&gt;
                  </xsl:if>
                  <xsl:if test="not(RESULTATIFRS/RESULTATNATUREIFRS/p2019SBMN/@ETAT)">
                    &lt;val&gt;
                    <xsl:value-of select="RESULTATIFRS/RESULTATNATUREIFRS/p2019SBMN"/>
                    &lt;/val&gt;
                  </xsl:if>
                  <xsl:if test="ANALYSEFINANCIEREIFRS/pCAFGRP/@ETAT='ND'">
                    &lt;val&gt;999999&lt;/val&gt;
                  </xsl:if>
                  <xsl:if test="not(ANALYSEFINANCIEREIFRS/pCAFGRP/@ETAT)">
                    &lt;val&gt;
                    <xsl:value-of select="ANALYSEFINANCIEREIFRS/pCAFGRP"/>
                    &lt;/val&gt;
                  </xsl:if>
                  &lt;/serie&gt;
                </xsl:if>

                <xsl:if test="(not(RESULTATIFRS/RESULTATNATUREIFRS) or (RESULTATIFRS/RESULTATNATUREIFRS/pK02697/@ETAT='ND'))">
                  &lt;serie&gt;
                  <xsl:if test="RESULTATIFRS/RESULTATFONCTIONNELIFRS/pK02701/@ETAT='ND'">
                    &lt;val&gt;0&lt;/val&gt;
                  </xsl:if>
                  <xsl:if test="not(RESULTATIFRS/RESULTATFONCTIONNELIFRS/pK02701/@ETAT)">
                    &lt;val&gt;
                    <xsl:value-of select="RESULTATIFRS/RESULTATFONCTIONNELIFRS/pK02701"/>
                    &lt;/val&gt;
                  </xsl:if>
                  <xsl:if test="RESULTATIFRS/RESULTATFONCTIONNELIFRS/p2019SARF/@ETAT='ND'">
                    &lt;val&gt;0&lt;/val&gt;
                  </xsl:if>
                  <xsl:if test="not(RESULTATIFRS/RESULTATFONCTIONNELIFRS/p2019SARF/@ETAT)">
                    &lt;val&gt;
                    <xsl:value-of select="RESULTATIFRS/RESULTATFONCTIONNELIFRS/p2019SARF"/>
                    &lt;/val&gt;
                  </xsl:if>
                  <xsl:if test="RESULTATIFRS/RESULTATFONCTIONNELIFRS/p2019SBKF/@ETAT='ND'">
                    &lt;val&gt;0&lt;/val&gt;
                  </xsl:if>
                  <xsl:if test="not(RESULTATIFRS/RESULTATFONCTIONNELIFRS/p2019SBKF/@ETAT)">
                    &lt;val&gt;
                    <xsl:value-of select="RESULTATIFRS/RESULTATFONCTIONNELIFRS/p2019SBKF"/>
                    &lt;/val&gt;
                  </xsl:if>
                  <xsl:if test="RESULTATIFRS/RESULTATFONCTIONNELIFRS/p2019SBLF/@ETAT='ND'">
                    &lt;val&gt;0&lt;/val&gt;
                  </xsl:if>
                  <xsl:if test="not(RESULTATIFRS/RESULTATFONCTIONNELIFRS/p2019SBLF/@ETAT)">
                    &lt;val&gt;
                    <xsl:value-of select="RESULTATIFRS/RESULTATFONCTIONNELIFRS/p2019SBLF"/>
                    &lt;/val&gt;
                  </xsl:if>
                  <xsl:if test="RESULTATFONCTIONNELIFRS/p2019SBMF/@ETAT='ND'">
                    &lt;val&gt;0&lt;/val&gt;
                  </xsl:if>
                  <xsl:if test="not(RESULTATIFRS/RESULTATFONCTIONNELIFRS/p2019SBMF/@ETAT)">
                    &lt;val&gt;
                    <xsl:value-of select="RESULTATIFRS/RESULTATFONCTIONNELIFRS/p2019SBMF"/>
                    &lt;/val&gt;
                  </xsl:if>
                  <xsl:if test="ANALYSEFINANCIEREIFRS/pCAFGRP/@ETAT='ND'">
                    &lt;val&gt;999999&lt;/val&gt;
                  </xsl:if>
                  <xsl:if test="not(ANALYSEFINANCIEREIFRS/pCAFGRP/@ETAT)">
                    &lt;val&gt;
                    <xsl:value-of select="ANALYSEFINANCIEREIFRS/pCAFGRP"/>
                    &lt;/val&gt;
                  </xsl:if>
                  &lt;/serie&gt;
                </xsl:if>
              </xsl:if>
            </xsl:for-each>

            <xsl:if test="count(//DONNEESCONSO)=1">
              &lt;serie&gt;&lt;val&gt;999999&lt;/val&gt;&lt;val&gt;999999&lt;/val&gt;&lt;val&gt;999999&lt;/val&gt;&lt;val&gt;999999&lt;/val&gt;&lt;val&gt;999999&lt;/val&gt;&lt;val&gt;999999&lt;/val&gt;&lt;/serie&gt;
            </xsl:if>

            &lt;abcisse&gt;
            <xsl:for-each select="//DONNEESCONSO">
              &lt;val&gt;
              <xsl:call-template name ="displayDateXsl">
                <xsl:with-param name ="InputDate" select ="(@DATCLOT)"/>
              </xsl:call-template>&lt;/val&gt;
            </xsl:for-each>
            <xsl:if test="count(//DONNEESCONSO)=2">
              &lt;val&gt;0&lt;/val&gt;&lt;val&gt;0&lt;/val&gt;&lt;val&gt;0&lt;/val&gt;&lt;val&gt;0&lt;/val&gt;
            </xsl:if>
            <xsl:if test="count(//DONNEESCONSO)=1">
              &lt;val&gt;0&lt;/val&gt;&lt;val&gt;0&lt;/val&gt;&lt;val&gt;0&lt;/val&gt;&lt;val&gt;0&lt;/val&gt;&lt;val&gt;0&lt;/val&gt;
            </xsl:if>
            &lt;/abcisse&gt;

          </xsl:if>
          &lt;titre&gt;Chiffres-cls consolids (en milliers d'euros)&lt;/titre&gt;
          &lt;unite&gt;K&lt;/unite&gt;
          <xsl:if test="//DONNEESCONSO/RESULTAT">
            &lt;type&gt;NF&lt;/type&gt;
          </xsl:if>
          <xsl:if test="//DONNEESCONSO/RESULTATIFRS">
            &lt;type&gt;IFRS&lt;/type&gt;
          </xsl:if>

          &lt;signet&gt;Chiffres-cls consolids&lt;/signet&gt;
          &lt;/graphe&gt;

          &lt;graphe&gt;
          <xsl:if test="$condGraph63">
            &lt;serie&gt;
            &lt;val&gt;<xsl:value-of select="translate(FIBEN/PERSONNE/MODULE67/DIFF67/DONNEESCONSO[position()=last()]/TABLEAUFINANCEMENT[position()=last()]/p2015UK,',','.')"/>&lt;/val&gt;
            &lt;val&gt;<xsl:value-of select="translate(FIBEN/PERSONNE/MODULE67/DIFF67/DONNEESCONSO[position()=last()]/TABLEAUFINANCEMENT[position()=last()]/p2015UN,',','.')"/>&lt;/val&gt;
            &lt;val&gt;<xsl:value-of select="translate(FIBEN/PERSONNE/MODULE67/DIFF67/DONNEESCONSO[position()=last()]/TABLEAUFINANCEMENT[position()=last()]/p2015UJ,',','.')"/>&lt;/val&gt;
            &lt;/serie&gt;
          </xsl:if>
          &lt;titre&gt;Variations du BFR, du FRNG et de la trsorerie de l'excercice <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="(FIBEN/PERSONNE/MODULE67/DIFF67/DONNEESCONSO[position()=last()]/@DATCLOT)"/>
          </xsl:call-template> &lt;/titre&gt;&lt;signet&gt;Tableau des flux et financement&lt;/signet&gt;
          &lt;/graphe&gt;

          &lt;/FIBEN&gt;
        </xsl:attribute>
      </xsl:element>
    </form>
  </xsl:template>


  <!--  postes comptables affichs en caractres gras ou normaux selon le paramtre "bold" avec retour en haut de page AVEC LARGEUR 140 -->
  <xsl:template match="p2011CK|pK02499|pK02410|pK02424">
    <xsl:param name="bold"/>
     <td class="cl{$bold}Fond clWidth140 clAlignRight">
      <xsl:if test="@ETAT">
        <xsl:value-of select="@ETAT"/>&#160;
      </xsl:if>
      <xsl:if test="not(@ETAT)">
        <xsl:call-template name ="displayNumberXsl">
          <xsl:with-param name ="InputStringNumber" select ="(.)"/>
        </xsl:call-template>&#160;
      </xsl:if>
    </td>
    <xsl:if test="position()=last() and position()=1">
       <td class="cl{$bold}Fond clWidth140 clAlignRight">&#160;</td>
    </xsl:if>
    <xsl:if test="position()=last()">
       <td class="clWidth104 clAlignRight">
        <a href="#ancHaut">
          <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" alt="Retour en haut de la page"/>
        </a>
      </td>
    </xsl:if>
  </xsl:template>

  <!--  postes comptables affichs en caractres gras ou normaux selon le paramtre "bold" avec retour en haut de page AVEC LARGEUR 110 -->
  <xsl:template match="p2016XE|pK02440|pK02688|pK02538|pK02698|p2016XQ|p2016XF|p2019SBK|p2019SO">
    <xsl:param name="bold"/>
     <td class="cl{$bold}Fond clWidth110 clAlignRight">
      <xsl:if test="@ETAT">
        <xsl:value-of select="@ETAT"/>&#160;
      </xsl:if>
      <xsl:if test="not(@ETAT)">
        <xsl:call-template name ="displayNumberXsl">
          <xsl:with-param name ="InputStringNumber" select ="(.)"/>
        </xsl:call-template>&#160;
      </xsl:if>
    </td>
    <xsl:if test="position()=last() and position()=1">
       <td class="cl{$bold}Fond clWidth110 clAlignRight">&#160;</td>
    </xsl:if>
    <xsl:if test="position()=last()">
       <td class="clWidth104 clAlignRight">
        <a href="#ancHaut">
          <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" alt="Retour en haut de la page"/>
        </a>
      </td>
    </xsl:if>
  </xsl:template>

  <!--  postes comptables affichs en caractres gras ou normaux selon le paramtre "bold" -->
  <xsl:template match="pK02399|p2011CS|pK02395|p2011EJ|p2011EI|p2011EG|p2011CD|p2011EK|p2011EBA|pK02396|p2011CH|p2011EN|p2011EBB|p2011EP|p2011EQ|p2011ER|p2011ES|p2011CL|p2011EU|p2011CM|p2011CN|p2011EV|p2011EW|p2011EX|p2011EZ|p2011EAA|p2011EAB|pK02403|p2011CT|p2011CU|p2011CV|p2011CW|p2011CX|p2011CZ|p2011DC|p2011EAJ|p2011EAK|p2011EAL|p2011EAM|p2011EAN|pK02402|p2011EAZ|p2011EAR|p2011DS|p2011EAS|p2011EAT|p2011EH|p2011DW|p2011DX|p2011EAU|p2011EAW|p2011EY|pK02404|p2011EAY|pK02405|pK02411|pK02409|p2018FA|pK02455|p2018FC|pK02408|pK02671|p2018FBU|pK03724|pK03725|pK03726|pK03727|pK03728|p2018FJ|p2018FO|p2018FQ|p2018FR|pK02457|pK02412|p2018FW|pK02418|pK02416|p2018FZ|p2018FAA|p2018FAB|p2018FAC|p2018FAD|pK02605">
    <xsl:param name="bold"/>
     <td class="cl{$bold}Fond clWidth140 clAlignRight">
      <xsl:if test="@ETAT">
        <xsl:value-of select="@ETAT"/>&#160;
      </xsl:if>
      <xsl:if test="not(@ETAT)">
        <xsl:call-template name ="displayNumberXsl">
          <xsl:with-param name ="InputStringNumber" select ="(.)"/>
        </xsl:call-template>&#160;
      </xsl:if>
    </td>
    <xsl:if test="position()=last() and position()=1">
       <td class="cl{$bold}Fond clWidth140 clAlignRight">&#160;</td>
    </xsl:if>
  </xsl:template>

  <xsl:template match="pK02417|pK02420|p2018FAL|p2018FAM|p2018FAN|p2018FAO|p2018FAP|p2018FAQ|p2018FAT|p2018FAU|p2018FAZ|p2018FBA|p2018FAV|p2018FAW|p2018FBB|pK02422|pK02413|p2018FX|p2018FBM|p2018FBN|p2018FBO|p2018FBP|p2018FBQ|p2018FBR|pK02419|pK02423|p2018FBJ|p2018FBK|p2018FBL|pK02494|pK02495|pK02614|pK02496|pK02401|pK02485|pCAFGRP|pK02497|pK02498">
    <xsl:param name="bold"/>
     <td class="cl{$bold}Fond clWidth140 clAlignRight">
      <xsl:if test="@ETAT">
        <xsl:value-of select="@ETAT"/>&#160;
      </xsl:if>
      <xsl:if test="not(@ETAT)">
        <xsl:call-template name ="displayNumberXsl">
          <xsl:with-param name ="InputStringNumber" select ="(.)"/>
        </xsl:call-template>&#160;
      </xsl:if>
    </td>
    <xsl:if test="position()=last() and position()=1">
       <td class="cl{$bold}Fond clWidth140 clAlignRight">&#160;</td>
    </xsl:if>
  </xsl:template>

  <!-- les deux templates suivants concernent les comptes de resultat et tableaux de flux qui ont une largeur de colonne de 110 et non plus de 140-->
  <xsl:template match="p2019SAN|p2019SAF|p2019SBN2|p2019SBF|pK02425N|pK02425F|p2019SDN|p2019SDF|p2019SEN|p2019SEF|pK02426|pK02428|pK02430|p2019SQ|p2019SS|p2019ST|p2019SCH|p2019SK|pK02695|p2019SL|p2019SN|p2019SO|pK02432|p2019SV|pK02694|pK02444N|pK02444F|p2019SACN|p2019SACF|pK02718|p2019SX|p2019SCO|pK02697|pK02696|p2019SAGN|p2019SAGF|pK02686|p2019SAIN|p2019SAIF|pK02450N|pK02450F|p2019SAON|p2019SAOF|p2019SAPN|p2019SAPF|p2019SARN|p2019SARF|p2019SASN|p2019SASF|p2019SATN|p2019SATF|p2019SAUN|p2019SAUF|p2019SAVN|p2019SAVF|p2019SAWN|p2019SAWF|p2019SAXN|p2019SAXF|p2019SCMN|p2019SCMF|p2019SBEN|p2019SBEF|p2019SBGN|p2019SBGF|p2019SBHN|p2019SBHF|p2019SBIN|p2019SBIF|p2019SBJN|p2019SBJF|p2019SBKN|p2019SBKF|p2019SBN|p2019SBO|p2019SBP">
    <xsl:param name="bold"/>
     <td class="cl{$bold}Fond clWidth110 clAlignRight">
      <xsl:if test="@ETAT">
        <xsl:value-of select="@ETAT"/>&#160;
      </xsl:if>
      <xsl:if test="not(@ETAT)">
        <xsl:call-template name ="displayNumberXsl">
          <xsl:with-param name ="InputStringNumber" select ="(.)"/>
        </xsl:call-template>&#160;
      </xsl:if>
    </td>
    <xsl:if test="position()=last() and position()=1">
       <td class="cl{$bold}Fond clWidth110 clAlignRight">&#160;</td>
    </xsl:if>
  </xsl:template>

  <xsl:template match="pK02433|pK02699|pK02700|pK02701|pK02688|pK02702|pK02431|pK02719|p2016WL|p2016XP|p2016WM|p2016WJ|p2016XR|p2016WK|p2016WN|p2016XS|p2016XT|p2016WS|p2016WT|p2016WU|p2016WV|p2016WW|p2016WX|p2016WY|p2016WZ|p2016XB|p2016XC|p2016XD|p2016XF|p2016XG|p2016XH|p2016XI|p2016XJ|p2016XK|p2016YE|p2016YF|p2016YG|p2016YZ|p2016YO|p2016YP|pTXVCA|pK02683|pK02703|pK02684|pK02704|pK02607|pK02705|pK02685|pK02525|pK02528|pK02615|pK02616|pK02606|pK02617|pK02536|pK02854|pK02855|pK02856|p2016WAA|p2016WAE|p2016WAI|p2016WAJ|p2016WAG|p2016YY|pINT_CA|pINT_ROC|pROC_CA">
    <xsl:param name="bold"/>
     <td class="cl{$bold}Fond clWidth110 clAlignRight">
      <xsl:if test="@ETAT">
        <xsl:value-of select="@ETAT"/>&#160;
      </xsl:if>
      <xsl:if test="not(@ETAT)">
        <xsl:call-template name ="displayNumberXsl">
          <xsl:with-param name ="InputStringNumber" select ="(.)"/>
        </xsl:call-template>&#160;
      </xsl:if>
    </td>
    <xsl:if test="position()=last() and position()=1">
       <td class="cl{$bold}Fond clWidth110 clAlignRight">&#160;</td>
    </xsl:if>
  </xsl:template>

  <!--  Ce template concerne les postes qui appartiennet  plusieurs parties avec des longueurs differentes-->
  <xsl:template match="p2019SBL|p2019SBM|p2019SBLN|p2019SBMN|p2019SBLF|p2019SBMF|pTXVCA|pFRNG_CA|pRPRM_RC|pRPRM_IM|pRESPACT|pRESPG_CP|pRNC_CP|pINT_CA">
    <xsl:param name="largeur"/>
    <xsl:param name="bold"/>
    <td class="cl{$bold}Fond clAlignRight" width="$largeur">
      <xsl:if test="@ETAT">
        <xsl:value-of select="@ETAT"/>&#160;
      </xsl:if>
      <xsl:if test="not(@ETAT)">
        <xsl:call-template name ="displayNumberXsl">
          <xsl:with-param name ="InputStringNumber" select ="(.)"/>
        </xsl:call-template>&#160;
      </xsl:if>
    </td>
    <xsl:if test="position()=last() and position()=1">
      <td class="clFond clAlignRight" width="$largeur">&#160;</td>
    </xsl:if>
  </xsl:template>
</xsl:stylesheet>

