<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
					              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
					              xmlns:bdf="http://banque-france.fr/namespace">
	<xsl:import href="../../Ressources/XSL/Commun.xsl"/>
  <xsl:import href="../../Ressources/XSL/commun_transfo.xsl"/>
	<xsl:import href="../../Ressources/XSL/Commun_bilans.xsl"/>

	<xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes" />
	<xsl:param name="langage" select="'fr'"/>
	<xsl:param name="familyName" select="''"/>
	<xsl:param name="familyNumber" select="''"/>
	<xsl:param name="familyTitle" select="''"/>
  <xsl:param name="root" select="'/Fiben/'"/>
	<xsl:param name="nextModule" select="''"/>
	<xsl:param name="nextId" select="''"/>
	<xsl:param name="nextFamily" select="''"/>
  <xsl:param name="Lang" select="'FR'"/>
  <xsl:param name="NonResident" select="''"/>
	<xsl:param name="menuHTML1"/>
	<xsl:variable name="condGraph1" select="boolean(/FIBEN/PERSONNE/MODULE66/DIFF66)"/>
	<xsl:variable name="isOnlyOneCC" select="count(/FIBEN/PERSONNE/MODULE66/DIFF66/CHIFFRESCONSO | /FIBEN/PERSONNE/MODULE66/DIFF66/CHIFFRESCONSOIFRS)=1"/>

<xsl:template match="/">
	<html lang="fr">
    <title>Module 66 - Chiffres cls consolids</title>
		<xsl:call-template name="genHead">
			<xsl:with-param name="ident" select="FIBEN/ERREUR/IDENT | FIBEN/PERSONNE/MODULE66/EJ/IDENTS"/>
		</xsl:call-template>
		<body class="clBodybgcolorWhite">
      <xsl:call-template name="genFondMenu">
        <xsl:with-param name="root" select="$root"/>
      </xsl:call-template>
      <xsl:copy-of select="$menuHTML1"/>
      
			<table class="mainmodule horizontal-auto clBorderCell">
        <caption class="visually-hidden">Module 66 - Chiffres cls consolids</caption>
					<xsl:call-template name="genLigneConfidentiel" />
					
				<xsl:apply-templates select="/FIBEN/ERREUR"/>
				<xsl:if test="not(/FIBEN/ERREUR)">
          <tr>
             <td class="clWidth64"></td>
						<td class="clCouleur2 clValignTop clWidth739" colspan="4">
							<xsl:apply-templates select="FIBEN/PERSONNE/MODULE66/EJ"/>
							<xsl:apply-templates select="FIBEN/PERSONNE/MODULE66/IST/IST08|FIBEN/PERSONNE/MODULE66/IST/IST03|FIBEN/PERSONNE/MODULE66/IST/IST04|FIBEN/PERSONNE/MODULE66/IST/IST10" mode="genLib"/>
							<xsl:apply-templates select="FIBEN/PERSONNE/MODULE66/IST/EJ"/>
							<xsl:apply-templates select="FIBEN/PERSONNE/MODULE66/DIFF66"/>
						</td>
					</tr>
										
				</xsl:if>
			</table>
      <xsl:call-template name="genBasPage"/>
			<xsl:if test="$condGraph1">
				<xsl:call-template name="genGraph66">
					<xsl:with-param name="ident" select="FIBEN/PERSONNE/MODULE66/EJ/IDENTS"/>
					<xsl:with-param name="nom" select="FIBEN/PERSONNE/MODULE66/EJ/DENOM"/>
				</xsl:call-template>
			</xsl:if>
		</body>
		
	</html>
</xsl:template>

<xsl:template match="FIBEN/PERSONNE/MODULE66/EJ">
	<xsl:call-template name="genEnTete">
		<xsl:with-param name="ident" select="IDENTS"/>
		<xsl:with-param name="nom" select="DENOM"/>
	</xsl:call-template>
</xsl:template>

<xsl:template match="IST08|IST03|IST04|IST10" mode="genLib">
	<table class="clWidth635 clBorderCell" role="presentation">
		<tr class="clAlignLeft">
			<td class="clCouleur2">
				<xsl:apply-templates select="."/><br/>
			</td>
		</tr>
	</table>
	<xsl:call-template name="shim"/><br />
</xsl:template>

<xsl:template match="DIFF66">
	<table class="clWidth635 clBorderCell">
    <caption class="visually-hidden">Informations sur le groupe</caption>
			<tr>
				<th class="clCouleur2 clWidth150 clAlignLeft clThNonGras">&#160;Nom du groupe</th>
				<td class="clFond clWidth300">&#160;<xsl:value-of select="NOMGROUP"/></td>
				<td class="clFond clWidth185 clHeight14"/>
			</tr>
			<tr>
				<td class="clWidth150 clHeight14"/>
				<td class="clWidth300 clHeight14"/>
				<td class="clWidth185 clHeight14"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth150 clAlignLeft clThNonGras">&#160;Documents comptables</th>
				<td class="clFond clWidth300">&#160;COMPTES CONSOLIDS</td>
				<td class="clCouleur2 clWidth185 clAlignRight">&#160;&#160;(exprims en
        <xsl:call-template name ="displayUnitXsl">
          <xsl:with-param name ="InputUnit" select ="(//DIFF66/@UNITE)"/>
        </xsl:call-template>
         euros)</td>
			</tr>
	</table>
	<xsl:call-template name="shim"/>
	<br/>

	<!-- Date de clture + Dure  -->
	
	<table class="clWidth635 clBorderCell">
    <caption class="visually-hidden">Informations sur le groupe</caption>
		<tr> 
			<th class="clCouleur2 clWidth355 clHeight14 clAlignLeft clThNonGras">&#160;Date de clture</th>
			<xsl:apply-templates select="../DIFF66/CHIFFRESCONSO/@DATCLOT"/>
			<xsl:apply-templates select="../DIFF66/CHIFFRESCONSOIFRS/@DATCLOT"/>
		</tr>
		<tr> 
			<th class="clCouleur2 clHeight14 clAlignLeft clThNonGras">&#160;Dure</th>
			<xsl:apply-templates select="../DIFF66/CHIFFRESCONSO/@DUREEEX"/>
			<xsl:apply-templates select="../DIFF66/CHIFFRESCONSOIFRS/@DUREEEX"/>
		</tr>
	</table>
	<xsl:apply-templates select="FILIALESPERI"/>

	<!--    GRANDES MASSES DU COMPTE DE RSULTAT      -->

	<a name="resultat"></a>
	<xsl:call-template name="BILAN66"/>


	<!--   SOCIT(S) CONSOLIDANT L'ENTREPRISE     -->

	<xsl:call-template name="shim"/><br />	
	<xsl:apply-templates select="../DIFF66/EJ"/>
	
</xsl:template>



<xsl:template match="@DATCLOT">
  <td class="clGrasFond clWidth140 clAlignRight">
    <xsl:call-template name ="displayDateXsl">
      <xsl:with-param name ="InputDate" select ="(.)"/>
    </xsl:call-template>&#160;
  </td>
	<xsl:if test="$isOnlyOneCC">
		<td class="clGrasFond clWidth140 clAlignRight">&#160;</td>
	</xsl:if>
</xsl:template>

<xsl:template match="@DUREEEX">
	<td class="clFond clWidth140 clAlignRight">
    <xsl:call-template name ="displayDateXsl">
      <xsl:with-param name ="InputDate" select ="(.)"/>
    </xsl:call-template>&#160;</td>
	<xsl:if test="$isOnlyOneCC">
		<td class="clFond clWidth140 clAlignRight">&#160;</td>
	</xsl:if>
</xsl:template>

<xsl:template match="pCACONS|pEXPORT|pEBE|pRESEXPL|pRESFIN|pRESCAI|pRESEXCEP|pRNCAAEA|pRNC|pRNCPM|pEFFECT|pK01143|pK01144|pK01151|pK01411|pK01171|pK01167|pK01172|pK01174|pK01177|pK01178|pK01154|pCAF|pK01376|pK01295|pK01283|pDET_FP|pCBC_CA|pEBE_CA|pRNC_CA|pRNC_CP|pK01888|pROC_CA">
	<td class="clFond clWidth140 clAlignRight">
		<xsl:if test="@ETAT">
			<xsl:value-of select="@ETAT"/>&#160;
		</xsl:if>
		<xsl:if test="not(@ETAT)">
      <xsl:call-template name ="displayNumberXsl">
        <xsl:with-param name ="InputStringNumber" select ="(.)"/>
      </xsl:call-template>&#160;
		</xsl:if>
	</td>
	<xsl:if test="$isOnlyOneCC">
		<td class="clFond clWidth140 clAlignRight">&#160;</td>
	</xsl:if>
</xsl:template>

<xsl:template match="pROC|p2019SAR|p2019SAS|p2019SBI|pRNC|p2019SBL|pRNCPM|pEFFECT|pK02399|pK02618|pK02403|pK02402|p2011EAR|pK02411|pK02410|pK02419|pK02418|pK02423|pK02420|p2018FBJ|p2018FBK|pK02579|pK02494|pK02495|pK02614|pK02496|pK02606|pCBC_CA|pK02685|pK02705|pRNC_CP|pK02615|pROC_CA">
	<td class="clFond clWidth140 clAlignRight">
		<xsl:if test="@ETAT">
			<xsl:value-of select="@ETAT"/>&#160;
		</xsl:if>
		<xsl:if test="not(@ETAT)">
      <xsl:call-template name ="displayNumberXsl">
        <xsl:with-param name ="InputStringNumber" select ="(.)"/>
      </xsl:call-template>&#160;
		</xsl:if>
	</td>
	<xsl:if test="$isOnlyOneCC">
		<td class="clFond clWidth140 clAlignRight">&#160;</td>
	</xsl:if>
</xsl:template>

<xsl:template match="FILIALESPERI">
	<xsl:call-template name="shim"/>
	<table class="clWidth635 clBorderCell">
    <caption class="visually-hidden">Informations sur le groupe</caption>    
		<tr>
			<th class="clCouleur2 clWidth235 clHeight15 clAlignLeft clThNonGras">&#160;Primtre diffus au</th>
			<td class="clFond clWidth60 clAlignCenter">
        <xsl:call-template name ="displayDateXsl">
          <xsl:with-param name ="InputDate" select ="(DATPERI)"/>
        </xsl:call-template>
      </td>
			<td class="clWidth340 clHeight15" colspan="5"/>
		</tr>
		<tr>
			<td class="clWidth455 clHeight15" colspan="4"/>
			<th class="clCouleur2 clWidth60 clHeight15 clAlignRight clThNonGras">IG</th>
			<th class="clCouleur2 clWidth60 clHeight15 clAlignRight clThNonGras">IP</th>
			<th class="clCouleur2 clWidth60 clHeight15 clAlignRight clThNonGras">ME</th>
		</tr>
		<tr>
			<th class="clCouleur2 clWidth235 clHeight15 clAlignLeft clThNonGras">&#160;Nombre de filiales consolides</th>
			<td class="clFond clWidth60 clAlignRight"><xsl:value-of select="NBFILIALES/NBFILTOT"/>&#160;</td>
			<td class="clWidth60 clHeight15"/>
			<td class="clCouleur2 clWidth100 clHeight15 clAlignLeft clThNonGras">&#160;rparties en</td>
			<td class="clFond clWidth60 clHeight15 clAlignRight"><xsl:value-of select="NBFILIALES/NBFILIG"/></td>
			<td class="clFond clWidth60 clHeight15 clAlignRight"><xsl:value-of select="NBFILIALES/NBFILIP"/></td>
			<td class="clFond clWidth60 clHeight15 clAlignRight"><xsl:value-of select="NBFILIALES/NBFILME"/></td>
		</tr>
	</table>
	<table class="clWidth635 clBorderCell">
		<tr>
			<td class="clItalic clHeight10"/>
		</tr>
		<tr>
			<td class="clItalic">&#160;IG : Filiale consolide selon la mthode de l'intgration globale</td>
		</tr>
		<tr>
			<td class="clItalic">&#160;IP : Filiale consolide selon la mthode de l'intgration proportionnelle</td>
		</tr>
		<tr>
			<td class="clItalic">&#160;ME : Filiale consolide selon la mthode de la mise en quivalence</td>
		</tr>
	</table>
</xsl:template>

<xsl:template name="genGraph66">
	<xsl:param name="ident"/>
	<xsl:param name="nom"/>
	<form action="Graphes.aspx" method="post" name="FormGraphes" target="_blank">
		<input name="familyNumber" type="hidden" value="1"/>
		<input name="moduleNumber" type="hidden" value="{/FIBEN/@MODDEM}"/>
		<xsl:element name="input">
				<xsl:attribute name="name">GrapheData</xsl:attribute>
				<xsl:attribute name="type">hidden</xsl:attribute>
				<xsl:attribute name="value">&lt;FIBEN MODDEM=&quot;<xsl:value-of select="FIBEN/@MODDEM"/>&quot; DATJOUR=&quot;<xsl:call-template name ="displayDateForGraph2">
          <xsl:with-param name ="InputDateForGraph" select ="FIBEN/@DATJOUR"/>
        </xsl:call-template>&quot; GRAPHE=&quot;1&quot;&gt;&lt;ident&gt;<xsl:value-of select="$ident"/>&lt;/ident&gt;	&lt;nom&gt;<xsl:value-of select="$nom"/>&lt;/nom&gt;&lt;graphe&gt;
	<xsl:if test="$condGraph1">
	&lt;serie&gt;
		<xsl:for-each select="//CHIFFRESCONSO">
				<xsl:if test="pRESEXPL/@ETAT='ND'">&lt;val&gt;0&lt;/val&gt;</xsl:if>
				<xsl:if test="not(pRESEXPL/@ETAT)">&lt;val&gt;<xsl:value-of select="pRESEXPL"/>&lt;/val&gt;</xsl:if>
		</xsl:for-each>	
		<xsl:for-each select="//CHIFFRESCONSOIFRS">
				<xsl:if test="pROC/@ETAT='ND'">&lt;val&gt;0&lt;/val&gt;</xsl:if>
				<xsl:if test="not(pROC/@ETAT)">&lt;val&gt;<xsl:value-of select="pROC"/>&lt;/val&gt;</xsl:if>
		</xsl:for-each>
	&lt;/serie&gt;
	&lt;serie&gt;
		<xsl:for-each select="//CHIFFRESCONSO">
				<xsl:if test="pRESCAI/@ETAT='ND'">&lt;val&gt;0&lt;/val&gt;</xsl:if>
				<xsl:if test="not(pRESCAI/@ETAT)">&lt;val&gt;<xsl:value-of select="pRESCAI"/>&lt;/val&gt;</xsl:if>
		</xsl:for-each>	
		<xsl:for-each select="//CHIFFRESCONSOIFRS">
				<xsl:if test="p2019SAR/@ETAT='ND'">&lt;val&gt;0&lt;/val&gt;</xsl:if>
				<xsl:if test="not(p2019SAR/@ETAT)">&lt;val&gt;<xsl:value-of select="p2019SAR"/>&lt;/val&gt;</xsl:if>
		</xsl:for-each>
	&lt;/serie&gt;
	&lt;serie&gt;
		<xsl:for-each select="//CHIFFRESCONSO">
			
				<xsl:if test="pRNC/@ETAT='ND'">&lt;val&gt;0&lt;/val&gt;</xsl:if>
				<xsl:if test="not(pRNC/@ETAT)">&lt;val&gt;<xsl:value-of select="pRNC"/>&lt;/val&gt;</xsl:if>
			</xsl:for-each>
			<xsl:for-each select="//CHIFFRESCONSOIFRS">
				<xsl:if test="pRNC/@ETAT='ND'">&lt;val&gt;0&lt;/val&gt;</xsl:if>
				<xsl:if test="not(pRNC/@ETAT)">&lt;val&gt;<xsl:value-of select="pRNC"/>&lt;/val&gt;</xsl:if>
			
		</xsl:for-each>
	&lt;/serie&gt;
	&lt;serie&gt;
		<xsl:for-each select="//CHIFFRESCONSO">
			
				<xsl:if test="pRNC/@ETAT='ND'">&lt;val&gt;0&lt;/val&gt;</xsl:if>
				<xsl:if test="not(pRNC/@ETAT)">&lt;val&gt;<xsl:value-of select="pRNC"/>&lt;/val&gt;</xsl:if>
			</xsl:for-each>
			<xsl:for-each select="//CHIFFRESCONSOIFRS">
				<xsl:if test="p2019SBL/@ETAT='ND'">&lt;val&gt;0&lt;/val&gt;</xsl:if>
				<xsl:if test="not(p2019SBL/@ETAT)">&lt;val&gt;<xsl:value-of select="p2019SBL"/>&lt;/val&gt;</xsl:if>
			
		</xsl:for-each>
	&lt;/serie&gt;
	&lt;serie&gt;
	<xsl:for-each select="//CHIFFRESCONSO">
			
				<xsl:if test="pRNCPM/@ETAT='ND'">&lt;val&gt;0&lt;/val&gt;</xsl:if>
				<xsl:if test="not(pRNCPM/@ETAT)">&lt;val&gt;<xsl:value-of select="pRNCPM"/>&lt;/val&gt;</xsl:if>
			</xsl:for-each>
			<xsl:for-each select="//CHIFFRESCONSOIFRS">
				<xsl:if test="pRNCPM/@ETAT='ND'">&lt;val&gt;0&lt;/val&gt;</xsl:if>
				<xsl:if test="not(pRNCPM/@ETAT)">&lt;val&gt;<xsl:value-of select="pRNCPM"/>&lt;/val&gt;</xsl:if>
			
		</xsl:for-each>
	&lt;/serie&gt;
	&lt;serie&gt;
		<xsl:for-each select="//CHIFFRESCONSO">
			
				<xsl:if test="pCAF/@ETAT='ND'">&lt;val&gt;999999&lt;/val&gt;</xsl:if>
				<xsl:if test="not(pCAF/@ETAT)">&lt;val&gt;<xsl:value-of select="pCAF"/>&lt;/val&gt;</xsl:if>
			</xsl:for-each>
			<xsl:for-each select="//CHIFFRESCONSOIFRS">
				<xsl:if test="pK02579/@ETAT='ND'">&lt;val&gt;999999&lt;/val&gt;</xsl:if>
				<xsl:if test="not(pK02579/@ETAT)">&lt;val&gt;<xsl:value-of select="pK02579"/>&lt;/val&gt;</xsl:if>
			</xsl:for-each>
	&lt;/serie&gt;
	&lt;abcisse&gt;
		<xsl:for-each select="//CHIFFRESCONSO">&lt;val&gt;
      <xsl:call-template name ="displayDateXsl">
        <xsl:with-param name ="InputDate" select ="(@DATCLOT)"/>
      </xsl:call-template>&lt;/val&gt;
		</xsl:for-each>
		<xsl:for-each select="//CHIFFRESCONSOIFRS">&lt;val&gt;
      <xsl:call-template name ="displayDateXsl">
        <xsl:with-param name ="InputDate" select ="(@DATCLOT)"/>
      </xsl:call-template>&lt;/val&gt;
		</xsl:for-each>
	&lt;/abcisse&gt;
	
	</xsl:if>
	&lt;titre&gt;Chiffres-cls consolids (en
          <xsl:call-template name ="displayUnitXsl">
          <xsl:with-param name ="InputUnit" select ="(FIBEN/PERSONNE/MODULE66/DIFF66/@UNITE)"/>
        </xsl:call-template>
         euros)&lt;/titre&gt;
	&lt;unite&gt;<xsl:value-of select="FIBEN/PERSONNE/MODULE66/DIFF66/@UNITE"/>&lt;/unite&gt;
	
		<xsl:if test="//CHIFFRESCONSO">			
			&lt;type&gt;NF&lt;/type&gt;
		</xsl:if>
		<xsl:if test="//CHIFFRESCONSOIFRS">
			
				&lt;type&gt;IFRS&lt;/type&gt;
			
		</xsl:if>
	
	&lt;/graphe&gt;
	&lt;/FIBEN&gt;
	</xsl:attribute>
	</xsl:element>
	</form>
</xsl:template>

 <xsl:template name="BILAN66">
	<xsl:if test="CHIFFRESCONSO">
		<xsl:call-template name="shim"/><br />	
		<table class="clWidth635 clBorderCell" role="presentation">
			<tr>
				<td class="clCouleurGras clWidth615 clAlignCenter">GRANDES MASSES DU COMPTE DE RSULTAT</td>
				<td>
					<xsl:if test="$condGraph1">
						<a href="#nullepart" onclick="window.document.forms['FormGraphes'].action='Graphes.aspx';window.document.forms['FormGraphes'].submit	();"><img border="0" src="{$root}Images/risque/diagramme_bleu.gif" width="19" height="20" alt="lien vers diagramme"/></a>
					</xsl:if>
					<xsl:if test="not($condGraph1)">
						<img border="0" src="{$root}Images/boutons/diagramme_in.gif" width="19" height="20" alt="diagramme non disponible"/>
					</xsl:if>
				</td>
			</tr>
		</table>
		<xsl:call-template name="shim"/><br />	
		<table class="clWidth635 clBorderCell">
      <caption class="visually-hidden">GRANDES MASSES DU COMPTE DE RSULTAT</caption>
			<tr>
				<th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Date d'arrt</th>
				<xsl:apply-templates select="CHIFFRESCONSO/@DATCLOT"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Chiffre d'affaires</th>
				<xsl:apply-templates select="CHIFFRESCONSO/pCACONS"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Pourcentage de chiffre d'affaires  l'tranger</th>
				<xsl:apply-templates select="CHIFFRESCONSO/pEXPORT"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Excdent brut d'exploitation</th>
				<xsl:apply-templates select="CHIFFRESCONSO/pEBE"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Rsultat d'exploitation</th>
				<xsl:apply-templates select="CHIFFRESCONSO/pRESEXPL"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Rsultat financier</th>
				<xsl:apply-templates select="CHIFFRESCONSO/pRESFIN"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Rsultat courant avant impt</th>
				<xsl:apply-templates select="CHIFFRESCONSO/pRESCAI"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Rsultat exceptionnel</th>
				<xsl:apply-templates select="CHIFFRESCONSO/pRESEXCEP"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Rsultat net consolid av. amortissement cart d'acquisition</th>
				<xsl:apply-templates select="CHIFFRESCONSO/pRNCAAEA"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Rsultat net consolid</th>
				<xsl:apply-templates select="CHIFFRESCONSO/pRNC"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;&#160;Dont part des minoritaires</th>
				<xsl:apply-templates select="CHIFFRESCONSO/pRNCPM"/>
			</tr>
			<tr>
				<td class="clWidth355 clHeight10"/>
				 <td class="clWidth140 clHeight10"/>
				 <td class="clWidth140 clHeight10"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Effectif du groupe</th>
				<xsl:apply-templates select="CHIFFRESCONSO/pEFFECT"/>
			</tr>
		</table>
	
		<!--    GRANDES MASSES DU BILAN     -->
	
		<a name="bilan"></a>
		<div class="clBreakPage"/>
		<xsl:call-template name="shim"/><br />	
		<table  class="clWidth739 clBorderCell" role="presentation">
			<tr>
				<td class="clCouleurGras clWidth615 clAlignCenter">GRANDES MASSES DU BILAN</td>
				 <td class="clWidth19">&#160;</td>
				<td class="clAlignRight"><a href="#ancHaut"><img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" alt="Retour en haut de la page"/></a></td></tr>
		</table>
		<xsl:call-template name="shim"/><br />	
		<table class="clWidth635 clBorderCell">
      <caption class="visually-hidden">GRANDES MASSES DU BILAN</caption>
			<tr>
				<th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Date d'arrt</th>
				<xsl:apply-templates select="CHIFFRESCONSO/@DATCLOT"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Actif immobilis net</th>
				<xsl:apply-templates select="CHIFFRESCONSO/pK01143"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;&#160;Dont cart d'acquisition</th>
				<xsl:apply-templates select="CHIFFRESCONSO/pK01144"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Actif circulant net</th>
				<xsl:apply-templates select="CHIFFRESCONSO/pK01151"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;&#160;Dont disponibilits + VMP</th>
				<xsl:apply-templates select="CHIFFRESCONSO/pK01411"/>
			</tr>
			<tr>
				<td class="clWidth355 clHeight10"/>
				 <td class="clWidth140 clHeight10"/>
				 <td class="clWidth140 clHeight10"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Capitaux propres</th>
				<xsl:apply-templates select="CHIFFRESCONSO/pK01171"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;&#160;Dont intrts minoritaires</th>
				<xsl:apply-templates select="CHIFFRESCONSO/pK01167"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Fonds non remboursables</th>
				<xsl:apply-templates select="CHIFFRESCONSO/pK01172"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Provisions pour risques et charges</th>
				<xsl:apply-templates select="CHIFFRESCONSO/pK01174"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Dettes</th>
				<xsl:apply-templates select="CHIFFRESCONSO/pK01177"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;&#160;Dont dettes financires</th>
				<xsl:apply-templates select="CHIFFRESCONSO/pK01178"/>
			</tr>
			<tr>
				<td class="clWidth355 clHeight10"/>
				 <td class="clWidth140 clHeight10"/>
				 <td class="clWidth140 clHeight10"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Total bilan</th>
				<xsl:apply-templates select="CHIFFRESCONSO/pK01154"/>
			</tr>
		</table>
	
		<!--   LMENTS D'ANALYSE FINANCIRE     -->
	
		<a name="analyse"></a>
		<xsl:call-template name="shim"/><br />	
		<table class="clWidth635 clBorderCell" role="presentation">
			<tr>
				<td class="clCouleurGras clWidth615 clAlignCenter">LMENTS D'ANALYSE FINANCIRE</td>
			</tr>
		</table>
		<xsl:call-template name="shim"/><br />	
		<table class="clWidth635 clBorderCell">
      <caption class="visually-hidden">LMENTS D'ANALYSE FINANCIRE</caption>
			<tr>
				<th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras" colspan="2">&#160;Date d'arrt</th>
				<xsl:apply-templates select="CHIFFRESCONSO/@DATCLOT"/>
			</tr>
			<tr>
				<td class="clWidth325 clHeight10"/>
				<td class="clWidth30 clHeight10"/>
				 <td class="clWidth140 clHeight10"/>
				 <td class="clWidth140 clHeight10"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth325 clHeight16 clAlignLeft clThNonGras">&#160;Capacit d'autofinancement</th>
				<td class="clCouleur2">
					<div class="clAlignRight"><xsl:value-of select="//DIFF66/@UNITE"/><img src="{$root}Images/risque/euro_symb_bleu.gif" width="8" height="9" border="0" alt="symbole euro" />&#160;</div>
				</td>
				<xsl:apply-templates select="CHIFFRESCONSO/pCAF"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth325 clHeight16 clAlignLeft clThNonGras">&#160;FRNG</th>
				<td class="clCouleur2">
					<div class="clAlignRight"><xsl:value-of select="//DIFF66/@UNITE"/><img src="{$root}Images/risque/euro_symb_bleu.gif" width="8" height="9" border="0" alt="symbole euro" />&#160;</div>
				</td>
				<xsl:apply-templates select="CHIFFRESCONSO/pK01376"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth325 clHeight16 clAlignLeft clThNonGras">&#160;BFR hors effets escompts non chus</th>
				<td class="clCouleur2">
					<div class="clAlignRight"><xsl:value-of select="//DIFF66/@UNITE"/><img src="{$root}Images/risque/euro_symb_bleu.gif" width="8" height="9" border="0" alt="symbole euro" />&#160;</div>
				</td>
				<xsl:apply-templates select="CHIFFRESCONSO/pK01295"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth325 clHeight16 clAlignLeft clThNonGras">&#160;Trsorerie</th>
				<td class="clCouleur2">
					<div class="clAlignRight"><xsl:value-of select="//DIFF66/@UNITE"/><img src="{$root}Images/risque/euro_symb_bleu.gif" width="8" height="9" border="0" alt="symbole euro" />&#160;</div>
				</td>
				<xsl:apply-templates select="CHIFFRESCONSO/pK01283"/>
			</tr>
			<tr>
				<td class="clWidth325 clHeight10"/>
				<td class="clWidth30 clHeight10"/>
				 <td class="clWidth140 clHeight10"/>
				 <td class="clWidth140 clHeight10"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth325 clHeight16 clAlignLeft clThNonGras">&#160;Dettes financires stables / Fonds propres nets</th>
				<td class="clCouleur2 clAlignRight">%&#160;	</td>
				<xsl:apply-templates select="CHIFFRESCONSO/pDET_FP"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth325 clHeight16 clAlignLeft clThNonGras">&#160;Concours bancaires courants / CA</th>
				<td class="clCouleur2 clAlignRight">j&#160;	</td>
				<xsl:apply-templates select="CHIFFRESCONSO/pCBC_CA"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth325 clHeight16 clAlignLeft clThNonGras">&#160;EBE / CA</th>
				<td class="clCouleur2 clAlignRight">%&#160;	</td>
				<xsl:apply-templates select="CHIFFRESCONSO/pEBE_CA"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth325 clHeight16 clAlignLeft clThNonGras">&#160;Rsultat net / CA</th>
				<td class="clCouleur2 clAlignRight">%&#160;	</td>
				<xsl:apply-templates select="CHIFFRESCONSO/pRNC_CA"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth325 clHeight16 clAlignLeft clThNonGras">&#160;Rsultat net / Capitaux propres</th>
				<td class="clCouleur2 clAlignRight">%&#160;	</td>
				<xsl:apply-templates select="CHIFFRESCONSO/pRNC_CP"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth325 clHeight16 clAlignLeft clThNonGras">&#160;Capitaux propres / Total Bilan</th>
				<td class="clCouleur2 clAlignRight">%&#160;	</td>
				<xsl:apply-templates select="CHIFFRESCONSO/pK01888"/>
			</tr>
		</table>
	</xsl:if>

	<xsl:if test="CHIFFRESCONSOIFRS">
		<xsl:call-template name="shim"/><br />	
		<table class="clWidth635 clBorderCell" role="presentation">
			<tr>
				<td class="clCouleurGras clWidth615 clAlignCenter">GRANDES MASSES DU COMPTE DE RSULTAT</td>
				<td>
					<xsl:if test="$condGraph1">
						<a href="#nullepart" onclick="window.document.forms['FormGraphes'].action='Graphes.aspx';window.document.forms['FormGraphes'].submit	();"><img border="0" src="{$root}Images/risque/diagramme_bleu.gif" width="19" height="20" alt="lien vers diagramme"/></a>
					</xsl:if>
					<xsl:if test="not($condGraph1)">
						<img border="0" src="{$root}Images/boutons/diagramme_in.gif" width="19" height="20" alt="diagramme non disponible"/>
					</xsl:if>
				</td>
			</tr>
		</table>
		<xsl:call-template name="shim"/><br />	
		<table class="clWidth635 clBorderCell">
      <caption class="visually-hidden">GRANDES MASSES DU COMPTE DE RSULTAT</caption>
			<tr>
				<th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Date d'arrt</th>
				<xsl:apply-templates select="CHIFFRESCONSOIFRS/@DATCLOT"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Chiffre d'affaires</th>
				<xsl:apply-templates select="CHIFFRESCONSOIFRS/pCACONS"/>
			</tr>

			<tr>
				<th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Pourcentage de chiffre d'affaires  l'tranger</th>
				<xsl:apply-templates select="CHIFFRESCONSOIFRS/pEXPORT"/>
			</tr>
			
			<tr>
				<th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Rsultat oprationnel courant</th>
				<xsl:apply-templates select="CHIFFRESCONSOIFRS/pROC"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Rsultat oprationnel</th>
				<xsl:apply-templates select="CHIFFRESCONSOIFRS/p2019SAR"/>
			</tr>
						
			<tr>
				<th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Cot de l'endettement financier net</th>
				<xsl:apply-templates select="CHIFFRESCONSOIFRS/p2019SAS"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Rsultat net des activits en cours</th>
				<xsl:apply-templates select="CHIFFRESCONSOIFRS/p2019SBI"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Rsultat net consolid</th>
				<xsl:apply-templates select="CHIFFRESCONSOIFRS/pRNC"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;&#160;dont part du groupe</th>
				<xsl:apply-templates select="CHIFFRESCONSOIFRS/p2019SBL"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;&#160;dont part des minoritaires</th>
				<xsl:apply-templates select="CHIFFRESCONSOIFRS/pRNCPM"/>
			</tr>
			<tr>
				<td class="clWidth355 clHeight10"/>
				 <td class="clWidth140 clHeight10"/>
				 <td class="clWidth140 clHeight10"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Effectif du groupe</th>
				<xsl:apply-templates select="CHIFFRESCONSOIFRS/pEFFECT"/>
			</tr>
		</table>
	
		<!--    GRANDES MASSES DU BILAN     -->
	
		<a name="bilan"></a>
		<div class="clBreakPage"/>
		<xsl:call-template name="shim"/><br />	
		<table  class="clWidth739 clBorderCell" role="presentation">
			<tr>
				<td class="clCouleurGras clWidth615 clAlignCenter">GRANDES MASSES DU BILAN</td>
				 <td class="clWidth19">&#160;</td>
				<td class="clAlignRight"><a href="#ancHaut"><img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" alt="Retour en haut de la page" /></a></td></tr>
		</table>
		<xsl:call-template name="shim"/><br />	
		<table class="clWidth635 clBorderCell">
      <caption class="visually-hidden">GRANDES MASSES DU BILAN</caption>
			<tr>
				<th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Date d'arrt</th>
				<xsl:apply-templates select="CHIFFRESCONSOIFRS/@DATCLOT"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Actif non courant</th>
				<xsl:apply-templates select="CHIFFRESCONSOIFRS/pK02399"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;&#160;dont carts d'acquisition totaux</th>
				<xsl:apply-templates select="CHIFFRESCONSOIFRS/pK02618"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Actif courant</th>
				<xsl:apply-templates select="CHIFFRESCONSOIFRS/pK02403"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;&#160;Trsorerie et quivalents de trsorerie</th>
				<xsl:apply-templates select="CHIFFRESCONSOIFRS/pK02402"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Actifs destins  la vente</th>
				<xsl:apply-templates select="CHIFFRESCONSOIFRS/p2011EAR"/>
			</tr>
			<tr>
				<td class="clWidth355 clHeight10"/>
				 <td class="clWidth140 clHeight10"/>
				 <td class="clWidth140 clHeight10"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Capitaux propres totaux</th>
				<xsl:apply-templates select="CHIFFRESCONSOIFRS/pK02411"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;&#160;dont intrts minoritaires</th>
				<xsl:apply-templates select="CHIFFRESCONSOIFRS/pK02410"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Passif non courant</th>
				<xsl:apply-templates select="CHIFFRESCONSOIFRS/pK02419"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;&#160;dont dettes  long terme</th>
				<xsl:apply-templates select="CHIFFRESCONSOIFRS/pK02418"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Passif courant</th>
				<xsl:apply-templates select="CHIFFRESCONSOIFRS/pK02423"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;&#160;dont dettes financires CT</th>
				<xsl:apply-templates select="CHIFFRESCONSOIFRS/pK02420"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Passifs destins  la vente</th>
				<xsl:apply-templates select="CHIFFRESCONSOIFRS/p2018FBJ"/>
			</tr>
			<tr>
				<td class="clWidth355 clHeight10"/>
				 <td class="clWidth140 clHeight10"/>
				 <td class="clWidth140 clHeight10"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Total bilan</th>
				<xsl:apply-templates select="CHIFFRESCONSOIFRS/p2018FBK"/>
			</tr>
			</table>
	
		<!--   LMENTS D'ANALYSE FINANCIRE     -->
	
		<a name="analyse"></a>
		<xsl:call-template name="shim"/><br />	
		<table class="clWidth635 clBorderCell" role="presentation">
			<tr>
				<td class="clCouleurGras clWidth615 clAlignCenter">LMENTS D'ANALYSE FINANCIRE</td>
			</tr>
		</table>
		<xsl:call-template name="shim"/><br />	
		<table class="clWidth635 clBorderCell">
      <caption class="visually-hidden">LMENTS D'ANALYSE FINANCIRE</caption>
			<tr>
				<th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras" colspan="2">&#160;Date d'arrt</th>
				<xsl:apply-templates select="CHIFFRESCONSOIFRS/@DATCLOT"/>
			</tr>
			<tr>
				<td class="clWidth325 clHeight10"/>
				<td class="clWidth30 clHeight10"/>
				 <td class="clWidth140 clHeight10"/>
				 <td class="clWidth140 clHeight10"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth325 clHeight16 clAlignLeft clThNonGras">&#160;Capacit d'autofinancement</th>
				<td class="clCouleur2">
					<div class="clAlignRight"><xsl:value-of select="//DIFF66/@UNITE"/><img src="{$root}Images/risque/euro_symb_bleu.gif" width="8" height="9" border="0" alt="symbole euro" />&#160;</div>
				</td>
				<xsl:apply-templates select="CHIFFRESCONSOIFRS/pK02579"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth325 clHeight16 clAlignLeft clThNonGras">&#160;FRNG</th>
				<td class="clCouleur2">
					<div class="clAlignRight"><xsl:value-of select="//DIFF66/@UNITE"/><img src="{$root}Images/risque/euro_symb_bleu.gif" width="8" height="9" border="0" alt="symbole euro" />&#160;</div>
				</td>
				<xsl:apply-templates select="CHIFFRESCONSOIFRS/pK02494"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth325 clHeight16 clAlignLeft clThNonGras">&#160;BFR</th>
				<td class="clCouleur2">
					<div class="clAlignRight"><xsl:value-of select="//DIFF66/@UNITE"/><img src="{$root}Images/risque/euro_symb_bleu.gif" width="8" height="9" border="0" alt="symbole euro" />&#160;</div>
				</td>
				<xsl:apply-templates select="CHIFFRESCONSOIFRS/pK02495"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth325 clHeight16 clAlignLeft clThNonGras">&#160;(ACTIFS-DETTES) DESTINS  LA VENTE</th>
				<td class="clCouleur2">
					<div class="clAlignRight"><xsl:value-of select="//DIFF66/@UNITE"/><img src="{$root}Images/risque/euro_symb_bleu.gif" width="8" height="9" border="0" alt="symbole euro" />&#160;</div>
				</td>
				<xsl:apply-templates select="CHIFFRESCONSOIFRS/pK02614"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth325 clHeight16 clAlignLeft clThNonGras">&#160;Trsorerie</th>
				<td class="clCouleur2">
					<div class="clAlignRight"><xsl:value-of select="//DIFF66/@UNITE"/><img src="{$root}Images/risque/euro_symb_bleu.gif" width="8" height="9" border="0" alt="symbole euro" />&#160;</div>
				</td>
				<xsl:apply-templates select="CHIFFRESCONSOIFRS/pK02496"/>
			</tr>
			<tr>
				<td class="clWidth325 clHeight10"/>
				<td class="clWidth30 clHeight10"/>
				 <td class="clWidth140 clHeight10"/>
				 <td class="clWidth140 clHeight10"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth325 clHeight16 clAlignLeft clThNonGras">&#160;Dettes financires  + d'un an / Capitaux propres</th>
				<td class="clCouleur2 clAlignRight">%&#160;	</td>
				<xsl:apply-templates select="CHIFFRESCONSOIFRS/pK02606"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth325 clHeight16 clAlignLeft clThNonGras">&#160;Concours bancaires courants / CA</th>
				<td class="clCouleur2 clAlignRight">j&#160;	</td>
				<xsl:apply-templates select="CHIFFRESCONSOIFRS/pCBC_CA"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth325 clHeight16 clAlignLeft clThNonGras">&#160;Rsultat oprationnel courant / CA HT</th>
				<td class="clCouleur2 clAlignRight">%&#160;	</td>
				<xsl:apply-templates select="CHIFFRESCONSOIFRS/pROC_CA"/>
			</tr>			
			<tr>
				<th class="clCouleur2 clWidth325 clHeight16 clAlignLeft clThNonGras">&#160;Rsultat oprationnel / CA HT</th>
				<td class="clCouleur2 clAlignRight">%&#160;	</td>
				<xsl:apply-templates select="CHIFFRESCONSOIFRS/pK02685"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth325 clHeight16 clAlignLeft clThNonGras">&#160;Rsultat net des activits en cours / CA HT</th>
				<td class="clCouleur2 clAlignRight">%&#160;	</td>
				<xsl:apply-templates select="CHIFFRESCONSOIFRS/pK02705"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth325 clHeight16 clAlignLeft clThNonGras">&#160;Rsultat net / Capitaux propres</th>
				<td class="clCouleur2 clAlignRight">%&#160;	</td>
				<xsl:apply-templates select="CHIFFRESCONSOIFRS/pRNC_CP"/>
			</tr>
			<tr>
				<th class="clCouleur2 clWidth325 clHeight16 clAlignLeft clThNonGras">&#160;Capitaux propres / Total Bilan</th>
				<td class="clCouleur2 clAlignRight">%&#160;	</td>
				<xsl:apply-templates select="CHIFFRESCONSOIFRS/pK02615"/>
			</tr>
		</table>
	
	</xsl:if>
</xsl:template>

</xsl:stylesheet>
