<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
					              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
					              xmlns:bdf="http://banque-france.fr/namespace">
	<xsl:import href="../../Ressources/XSL/Commun.xsl"/>
  <xsl:import href="../../Ressources/XSL/commun_transfo.xsl"/>
	<xsl:import href="../../Ressources/XSL/Commun_bilans.xsl"/>
	<xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes" />
	<xsl:param name="langage" select="'fr'"/>
	<xsl:param name="familyName" select="''"/>
	<xsl:param name="familyNumber" select="''"/>
  <xsl:param name="root" select="'/Fiben/'"/>
	<xsl:param name="familyTitle" select="''"/>
	<xsl:param name="nextModule" select="''"/>
	<xsl:param name="nextId" select="''"/>
	<xsl:param name="nextFamily" select="''"/>
  <xsl:param name="Lang" select="'FR'"/>
  <xsl:param name="NonResident" select="''"/>
	<xsl:param name="menuHTML1"/>

	<xsl:variable name="condGraph" select="boolean(//BILAN60[position()=last()]) and not(boolean(//BILAN60[position()=last()]/p2050AA/@ETAT|//BILAN60[position()=last()]/pK00001/@ETAT|//BILAN60[position()=last()]/pK00021/@ETAT|//BILAN60[position()=last()]/pK00359/@ETAT|//BILAN60[position()=last()]/p2051DL/@ETAT|//BILAN60[position()=last()]/p2051DO/@ETAT|//BILAN60[position()=last()]/p2051DR/@ETAT|//BILAN60[position()=last()]/pK00041/@ETAT|//BILAN60[position()=last()]/pK00361/@ETAT|//BILAN60[position()=last()]/pK00035/@ETAT)) and boolean(number(translate(FIBEN/PERSONNE/MODULE60/DIFF60/BILAN60[position()=last()]/p2051DO,',','.'))	+ 	number(translate(FIBEN/PERSONNE/MODULE60/DIFF60/BILAN60[position()=last()]/p2051DL,',','.'))>=0) and boolean(number(translate(FIBEN/PERSONNE/MODULE60/DIFF60/BILAN60[position()=last()]/pK00035,',','.'))!=0)"/>

<xsl:template match="/">
	<html lang="fr">
    <title>Module 60 - Bilan synthtiques</title>
		<xsl:call-template name="genHead">
			<xsl:with-param name="ident" select="FIBEN/ERREUR/IDENT | FIBEN/PERSONNE/MODULE60/EJ/IDENTS"/>
		</xsl:call-template>
		<body class="clBodybgcolorWhite">
      <xsl:call-template name="genFondMenu">
        <xsl:with-param name="root" select="$root"/>
      </xsl:call-template>
      <xsl:copy-of select="$menuHTML1"/>
      
			<table class="mainmodule horizontal-auto clBorderCell">
        <caption class="visually-hidden">Module 60 - Bilan synthtique</caption>
        <xsl:call-template name="genLigneConfidentiel" />
				<xsl:apply-templates select="/FIBEN/ERREUR"/>
				<xsl:if test="not(/FIBEN/ERREUR)">

          <tr>
             <td class="clWidth64"></td>
						<td class="clCouleur2 clValignTop clWidth739" colspan="4">
							<xsl:apply-templates select="FIBEN/PERSONNE/MODULE60/EJ"/>
							<xsl:apply-templates select="FIBEN/PERSONNE/MODULE60/IST01|FIBEN/PERSONNE/MODULE60/IST02|FIBEN/PERSONNE/MODULE60/IST03|FIBEN/PERSONNE/MODULE60/IST04" mode="genLib"/>
							<xsl:apply-templates select="FIBEN/PERSONNE/MODULE60/DIFF60"/>
						</td>
					</tr>
					
				</xsl:if>
			</table>
      <xsl:call-template name="genBasPage"/>
			<xsl:call-template name="genGraph60">
				<xsl:with-param name="ident" select="/FIBEN/PERSONNE/MODULE60/EJ/IDENTS"/>
				<xsl:with-param name="nom" select="/FIBEN/PERSONNE/MODULE60/EJ/DENOM"/>
			</xsl:call-template>

		</body>
		
	</html>
</xsl:template>

<xsl:template match="FIBEN/PERSONNE/MODULE60/EJ">
	<xsl:call-template name="genEnTete">
		<xsl:with-param name="ident" select="IDENTS"/>
		<xsl:with-param name="nom" select="DENOM"/>
	</xsl:call-template>
</xsl:template>

<xsl:template match="IST01|IST02|IST03|IST04" mode="genLib">
	<table class="clWidth635 clBorderCell" role="presentation">
		<tr class="clAlignLeft">
			<td class="clCouleur2">
				<xsl:apply-templates select="."/><br/>
			</td>
		</tr>
	</table>
	<xsl:call-template name="shim"/><br />
</xsl:template>

<xsl:template match="DIFF60">
	<table class="clWidth635 clBorderCell" role="presentation">
			<xsl:if test="@REGFIS">
				<tr>
					<th class="clCouleur2 clWidth150 clAlignLeft clThNonGras">&#160;Rgime fiscal</th>
					<td class="clFond clWidth300">&#160;<xsl:value-of select="@REGFIS"/>
					</td>
					<td class="clFond clWidth185">&#160;</td>
				</tr>
				<tr>
					<td class="clWidth105 clHeight14"/>
					<td class="clWidth300 clHeight14"/>
					<td class="clWidth185 clHeight14"/>
				</tr>
			</xsl:if>
			<tr>
				<th class="clCouleur2 clWidth150 clAlignLeft clThNonGras">&#160;Documents comptables</th>
				<td class="clFond clWidth300">&#160;COMPTES SOCIAUX</td>
				<th class="clCouleur2 clWidth185 clAlignRight clThNonGras">&#160;&#160;(exprims en 
          <xsl:call-template name ="displayUnitXsl">
           <xsl:with-param name ="InputUnit" select ="(./@UNITE)"/>
          </xsl:call-template>
         euros)</th>
			</tr>
	</table>
	<xsl:call-template name="shim"/>
	<br/>

	<!-- Date de clture + Dure + Total du bilan  -->
	
	<table class="clWidth635 clBorderCell">
		<tr> 
			<th class="clCouleur2 clHeight14 clAlignLeft clThNonGras">&#160;Date de clture</th>
			<xsl:apply-templates select="../DIFF60/BILAN60/@DATCLOT"/>
		</tr>
		<tr> 
			<th class="clCouleur2 clHeight14 clAlignLeft clThNonGras">&#160;Dure</th>
			<xsl:apply-templates select="../DIFF60/BILAN60/@DUREEEX"/>
		</tr>
		<tr>
			<td class="clHeight14" colspan="4"/>
		</tr>
		<tr> 
			<th class="clCouleur2 clHeight14 clAlignLeft clThNonGras">&#160;Total du bilan</th>
			<xsl:apply-templates select="../DIFF60/BILAN60/pK00035" mode="w120etendu">
				<xsl:with-param name="bold">Gras</xsl:with-param>
			</xsl:apply-templates>
		</tr>
	</table>

	<!-- ACTIF BRUT  -->
	
	<a name="actbrut"></a>
	<xsl:call-template name="shim"/>
	<table class="clWidth635 clBorderCell" role="presentation">
		<tr class="clAlignCenter">
			<td class="clCouleurGras">ACTIF BRUT DU DERNIER EXERCICE</td>
		</tr>
	</table>
	<xsl:call-template name="shim"/><br />	
	<xsl:apply-templates select="ACTIFBRUT"/>

	<!-- BILAN SYNTHTIQUE et AUTRES DONNES ET ENGAGEMENTS HORS BILAN -->
	
	<a name="bilsynth"></a>
	<div class="clBreakPage"/>
	<xsl:call-template name="shim"/>
	<table class="clWidth739 clBorderCell" role="presentation">
		<tr class="clAlignCenter">
			<td class="clCouleurGras clWidth615">BILAN SYNTHTIQUE</td>
			 <td class="clWidth19">
				<xsl:if test="$condGraph">
					<a href="#nullepart" onclick="window.document.forms['FormGraphes'].action='Graphes.aspx';window.document.forms['FormGraphes'].submit();"><img border="0" src="{$root}Images/risque/diagramme_bleu.gif" width="19" height="20" alt="lien vers diagramme"/></a>
				</xsl:if>
				<xsl:if test="not($condGraph)">
					<img border="0" src="{$root}Images/boutons/diagramme_in.gif" width="19" height="20" alt="diagramme non disponible"/>
				</xsl:if>
			</td>
			<td class="clAlignRight"><a href="#ancHaut"><img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" alt="Retour en haut de la page" /></a>	</td>
		</tr>
	</table>
	<xsl:call-template name="shim" /><br />	
	<xsl:apply-templates select="BILAN60[1]"/>

	<!-- AFFECTATION  -->
	
	<xsl:call-template name="shim"/>
	<xsl:apply-templates select="AFFECTATION"/>

	<xsl:apply-templates select="EJ"/>
	<xsl:apply-templates select="STECONSO" mode="genLib">
		<xsl:with-param name="goIdent" select="/FIBEN/PERSONNE/MODULE60/EJ/IDENTS"/>
	</xsl:apply-templates>
</xsl:template>

<xsl:template match="@DATCLOT">
	<!--<xsl:param name="width" select="120"/>-->
  <td class="clGrasFond clWidth58 clAlignRight">
    <xsl:call-template name ="displayDateXsl">
      <xsl:with-param name ="InputDate" select ="(.)"/>
    </xsl:call-template>&#160;
  </td>
	<xsl:if test="position()=last() and position()=1">
		<td class="clGrasFond clWidth58 clAlignRight">&#160;</td>
		<td class="clGrasFond clWidth58 clAlignRight">&#160;</td>
	</xsl:if>
	<xsl:if test="position()=last() and position()=2">
		<td class="clGrasFond clWidth58 clAlignRight">&#160;</td>
	</xsl:if>
</xsl:template>

<xsl:template match="@DUREEEX">
	<xsl:param name="width" select="120"/>
  <td class="clFond clWidth120 clAlignRight">
    <xsl:call-template name ="displayDateXsl">
      <xsl:with-param name ="InputDate" select ="(.)"/>
    </xsl:call-template>&#160;
  </td>
	<xsl:if test="position()=last() and position()=1">
		<td class="clFond clWidth120 clAlignRight">&#160;</td>
		<td class="clFond clWidth120 clAlignRight">&#160;</td>
	</xsl:if>
	<xsl:if test="position()=last() and position()=2">
		<td class="clFond clWidth120 clAlignRight">&#160;</td>
	</xsl:if>
</xsl:template>

<xsl:template match="ACTIFBRUT">
	<table class="clWidth635 clBorderCell">
    <caption class="visually-hidden">Actif brut du dernier exercice</caption>
		<tr> 
			<th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;Date d'arrt</th>
      <td class="clGrasFond clAlignCenter" colspan="3">
        <xsl:call-template name ="displayDateXsl">
          <xsl:with-param name ="InputDate" select ="(../ACTIFBRUT/@DATCLOT)"/>
        </xsl:call-template>&#160;
      </td>
		</tr>
		<tr> 
			<td class="clHeight10" colspan="4"></td>
		</tr>
		<tr class="clCouleur2 clHeight15"> 
			<th class="clWidth275 clAlignLeft clThNonGras">&#160;ACTIF</th>
			<th class="clWidth120"><div class="clAlignRight clThNonGras">Brut</div></th>
			<th class="clWidth120"><div class="clAlignRight clThNonGras">Amortissements/</div></th>
			<th class="clWidth120"><div class="clAlignRight clThNonGras">Net</div></th>
		</tr>
		<tr class="clCouleur2 clHeight15"> 
			<td class="clWidth395" colspan="2"></td>
			<th class="clWidth120"><div class="clAlignRight clThNonGras">Provisions</div></th>
		</tr>
		<tr> 
			<th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;Capital souscrit non appel</th>
			<xsl:apply-templates select="../ACTIFBRUT/p2050AA" mode="w120seul">
				<xsl:with-param name="bold">Gras</xsl:with-param>
			</xsl:apply-templates>
			<td class="clGrasFond clWidth120 clAlignRight">&#160;</td>
			<xsl:apply-templates select="../BILAN60[position()=last()]/p2050AA" mode="w120seul">
				<xsl:with-param name="bold">Gras</xsl:with-param>
			</xsl:apply-templates>
		</tr>
		<tr> 
			<td class="clHeight10" colspan="4"></td>
		</tr>
		<tr> 
			<th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;Actif immobilis</th>
			<xsl:apply-templates select="../ACTIFBRUT/p2050BJ"  mode="w120seul">
				<xsl:with-param name="bold">Gras</xsl:with-param>
			</xsl:apply-templates>
			<xsl:apply-templates select="../ACTIFBRUT/p2050BK" mode="w120seul">
				<xsl:with-param name="bold">Gras</xsl:with-param>
			</xsl:apply-templates>
			<xsl:apply-templates select="../BILAN60[position()=last()]/pK00001" mode="w120seul">
				<xsl:with-param name="bold">Gras</xsl:with-param>
			</xsl:apply-templates>
		</tr>
		<tr> 
			<td class="clHeight2" colspan="4"></td>
		</tr>
		<tr> 
			<th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;Immobilisations incorporelles</th>
			<xsl:apply-templates select="../ACTIFBRUT/pK00003" mode="w120seul"/>
			<xsl:apply-templates select="../ACTIFBRUT/pK00004" mode="w120seul"/>
			<xsl:apply-templates select="../BILAN60[position()=last()]/pK00005" mode="w120seul"/>
		</tr>
		<tr> 
			<th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;Immobilisations corporelles</th>
			<xsl:apply-templates select="../ACTIFBRUT/pK00009" mode="w120seul"/>
			<xsl:apply-templates select="../ACTIFBRUT/pK00010" mode="w120seul"/>
			<xsl:apply-templates select="../BILAN60[position()=last()]/pK00011" mode="w120seul"/>
		</tr>
		<tr> 
			<th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;Immobilisations financires</th>
			<xsl:apply-templates select="../ACTIFBRUT/pK00013" mode="w120seul"/>
			<xsl:apply-templates select="../ACTIFBRUT/pK00014" mode="w120seul"/>
			<xsl:apply-templates select="../BILAN60[position()=last()]/pK00015" mode="w120seul"/>
		</tr>
		<tr> 
			<td class="clHeight10" colspan="4"></td>
		</tr>
		<tr> 
			<th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;Actif circulant</th>
			<xsl:apply-templates select="../ACTIFBRUT/pK00355"  mode="w120seul">
				<xsl:with-param name="bold">Gras</xsl:with-param>
			</xsl:apply-templates>
			<xsl:apply-templates select="../ACTIFBRUT/pK00055" mode="w120seul">
				<xsl:with-param name="bold">Gras</xsl:with-param>
			</xsl:apply-templates>
			<xsl:apply-templates select="../BILAN60[position()=last()]/pK00021" mode="w120seul">
				<xsl:with-param name="bold">Gras</xsl:with-param>
			</xsl:apply-templates>
		</tr>
		<tr> 
			<td class="clHeight2" colspan="4"></td>
		</tr>
		<tr> 
			<th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;Dt Stocks</th>
			<xsl:apply-templates select="../ACTIFBRUT/pK00142" mode="w120seul"/>
			<xsl:apply-templates select="../ACTIFBRUT/pK00358" mode="w120seul"/>
			<xsl:apply-templates select="../BILAN60[position()=last()]/pK00026" mode="w120seul"/>
		</tr>
		<tr> 
			<th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;Avances et acomptes verss</th>
			<xsl:apply-templates select="../ACTIFBRUT/p2050BV" mode="w120seul"/>
			<xsl:apply-templates select="../ACTIFBRUT/p2050BW" mode="w120seul"/>
			<xsl:apply-templates select="../BILAN60[position()=last()]/pK00027" mode="w120seul"/>
		</tr>
		<tr> 
			<th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;Clients</th>
			<xsl:apply-templates select="../ACTIFBRUT/p2050BX" mode="w120seul"/>
			<xsl:apply-templates select="../ACTIFBRUT/p2050BY" mode="w120seul"/>
			<xsl:apply-templates select="../BILAN60[position()=last()]/pK00028" mode="w120seul"/>
		</tr>
		<tr> 
			<th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;Autres crances</th>
			<xsl:apply-templates select="../ACTIFBRUT/p2050BZ" mode="w120seul"/>
			<xsl:apply-templates select="../ACTIFBRUT/p2050CA" mode="w120seul"/>
			<xsl:apply-templates select="../BILAN60[position()=last()]/pK00030" mode="w120seul"/>
		</tr>
		<tr> 
			<th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;Valeurs mobilires de placement</th>
			<xsl:apply-templates select="../ACTIFBRUT/p2050CD" mode="w120seul"/>
			<xsl:apply-templates select="../ACTIFBRUT/p2050CE" mode="w120seul"/>
			<xsl:apply-templates select="../BILAN60[position()=last()]/pK00032" mode="w120seul"/>
		</tr>
		<tr> 
			<th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;Disponibilits</th>
			<xsl:apply-templates select="../ACTIFBRUT/p2050CF" mode="w120seul"/>
			<xsl:apply-templates select="../ACTIFBRUT/p2050CG" mode="w120seul"/>
			<xsl:apply-templates select="../BILAN60[position()=last()]/pK00033" mode="w120seul"/>
		</tr>
		<tr> 
			<td class="clCouleur2 clWidth275 clHeight15">&#160;</td>
			<td class="clFond clWidth120 clHeight15">&#160;</td>
			<td class="clFond clWidth120 clHeight15">&#160;</td>
			<td class="clFond clWidth120 clHeight15">&#160;</td>
		</tr>
		<tr> 
			<th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;Autres postes</th>
			<xsl:apply-templates select="../ACTIFBRUT/pK00357" mode="w120seul">
				<xsl:with-param name="bold">Gras</xsl:with-param>
			</xsl:apply-templates>
			<xsl:apply-templates select="../ACTIFBRUT/p2050CI" mode="w120seul">
				<xsl:with-param name="bold">Gras</xsl:with-param>
			</xsl:apply-templates>
			<xsl:apply-templates select="../BILAN60[position()=last()]/pK00359" mode="w120seul">
				<xsl:with-param name="bold">Gras</xsl:with-param>
			</xsl:apply-templates>
		</tr>
		<tr> 
			<td class="clHeight10" colspan="4"></td>
		</tr>
		<tr> 
			<th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;Total</th>
			<xsl:apply-templates select="../ACTIFBRUT/p2050CO" mode="w120seul">
				<xsl:with-param name="bold">Gras</xsl:with-param>
			</xsl:apply-templates>
			<xsl:apply-templates select="../ACTIFBRUT/p20501A" mode="w120seul">
				<xsl:with-param name="bold">Gras</xsl:with-param>
			</xsl:apply-templates>
			<xsl:apply-templates select="../BILAN60[position()=last()]/pK00035" mode="w120seul">
				<xsl:with-param name="bold">Gras</xsl:with-param>
			</xsl:apply-templates>
		</tr>
	</table>
</xsl:template>

<xsl:template match="BILAN60">
	<table class="clWidth635 clBorderCell">
    <caption class="visually-hidden">Bilan synthtique</caption>
		<tr>
<!-- ****************************************************************************************************************************************************************************
			 table pour l'ACTIF
 *************************************************************************************************************************************************************************** -->
			<td class="clWidth307 clValignTop">
				<table class="clWidth307 clBorderCell">
          <caption class="visually-hidden">Bilan synthtique - partie actif</caption>
					<tr>
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;Date d'arrt</th>
						<xsl:apply-templates select="../BILAN60/@DATCLOT">							
						</xsl:apply-templates>
					</tr>
					<tr>
						<td class="clHeight10" colspan="4"></td>
					</tr>
					<tr>
						<th class="clCouleur2 clWidth133 clAlignCenter clThNonGras">&#160;ACTIF</th>
						<td class="clWidth58"></td>
						<td class="clWidth58"></td>
						<td class="clWidth58"></td>
					</tr>
					<tr>
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;Cap. sous. non appel</th>
							<xsl:apply-templates select="../BILAN60/p2050AA" mode="w58etendu">
								<xsl:with-param name="bold">Gras</xsl:with-param>
							</xsl:apply-templates>
					</tr>
					<tr> 
						<td class="clHeight10" colspan="4"></td>
					</tr>
					<tr> 
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;Actif immobilis</th>
							<xsl:apply-templates select="../BILAN60/pK00001" mode="w58etendu">
								<xsl:with-param name="bold">Gras</xsl:with-param>
							</xsl:apply-templates>
					</tr>
					<tr> 
						<td class="clHeight2" colspan="4"></td>
					</tr>
					<tr> 
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;Immob. incorporelles</th>
							<xsl:apply-templates select="../BILAN60/pK00005" mode="w58etendu"/>
					</tr>
					<tr> 
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;Immob. corporelles</th>
							<xsl:apply-templates select="../BILAN60/pK00011" mode="w58etendu"/>
					</tr>
					<tr> 
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;Immob. financires</th>
							<xsl:apply-templates select="../BILAN60/pK00015" mode="w58etendu"/>
					</tr>
					<tr> 
						<td class="clHeight10" colspan="4"></td>
					</tr>
					<tr> 
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;Actif circulant</th>
							<xsl:apply-templates select="../BILAN60/pK00021" mode="w58etendu">
								<xsl:with-param name="bold">Gras</xsl:with-param>
							</xsl:apply-templates>
					</tr>
					<tr> 
						<td class="clHeight2" colspan="4"></td>
					</tr>
					<tr> 
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;Dt Stocks</th>
							<xsl:apply-templates select="../BILAN60/pK00026" mode="w58etendu"/>
					</tr>
					<tr> 
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;Av. acptes verss</th>
							<xsl:apply-templates select="../BILAN60/pK00027" mode="w58etendu"/>
					</tr>
					<tr> 
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;Clients</th>
							<xsl:apply-templates select="../BILAN60/pK00028" mode="w58etendu"/>
					</tr>
					<tr> 
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;Autres crances</th>
							<xsl:apply-templates select="../BILAN60/pK00030" mode="w58etendu"/>
					</tr>
					<tr> 
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;Valeurs mob. plact.</th>
							<xsl:apply-templates select="../BILAN60/pK00032" mode="w58etendu"/>
					</tr>
					<tr> 
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;Disponibilits</th>
							<xsl:apply-templates select="../BILAN60/pK00033" mode="w58etendu"/>
					</tr>
					<tr> 
						<td class="clHeight10" colspan="4"></td>
					</tr>
					<tr> 
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;Autres postes</th>
							<xsl:apply-templates select="../BILAN60/pK00359" mode="w58etendu">
								<xsl:with-param name="bold">Gras</xsl:with-param>
							</xsl:apply-templates>
					</tr>
					<tr> 
						<td class="clHeight10" colspan="4"></td>
					</tr>
					<tr> 
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;Total</th>
							<xsl:apply-templates select="../BILAN60/pK00035"  mode="w58etendu">
								<xsl:with-param name="bold">Gras</xsl:with-param>
							</xsl:apply-templates>
					</tr>
				</table>
			</td>
		<!-- ****************************************************************************************************************************************************************************
		 	barre verticale de sparation ACTIF/PASSIF
		 *************************************************************************************************************************************************************************** -->
			<td class="clWidth21 clAlignCenter clValignBottom">
				<xsl:call-template name="svim" /><br />
			</td>		
		<!-- ****************************************************************************************************************************************************************************
			 table pour le PASSIF
			*************************************************************************************************************************************************************************** -->
			<td class="clWidth307 clValignTop">
				<table class="clWidth307 clBorderCell">
          <caption class="visually-hidden">Bilan synthtique - partie passif</caption>
					<tr>
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;Date d'arrt</th>
						<xsl:apply-templates select="../BILAN60/@DATCLOT">							
						</xsl:apply-templates>
					</tr>
					<tr>
						<td class="clHeight10" colspan="4"></td>
					</tr>
					<tr>
						<th class="clCouleur2 clWidth133 clAlignCenter clThNonGras">&#160;PASSIF</th>
						<td class="clWidth58"></td>
						<td class="clWidth58"></td>
						<td class="clWidth58"></td>
					</tr>
					<tr>
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;Capitaux propres</th>
							<xsl:apply-templates select="../BILAN60/p2051DL" mode="w58etendu">
								<xsl:with-param name="bold">Gras</xsl:with-param>
							</xsl:apply-templates>
					</tr>
					<tr> 
						<td class="clHeight2" colspan="4"></td>
					</tr>
					<tr> 
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;Dt capital social</th>
							<xsl:apply-templates select="../BILAN60/p2051DA" mode="w58etendu"/>
					</tr>
					<tr> 
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;Rsult. exercice</th>
							<xsl:apply-templates select="../BILAN60/p2051DI" mode="w58etendu"/>
					</tr>
					<tr> 
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;Provisions rgl.</th>
							<xsl:apply-templates select="../BILAN60/p2051DK" mode="w58etendu"/>
					</tr>
					<tr> 
						<td class="clHeight10" colspan="4"></td>
					</tr>
					<tr> 
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;Autres fonds propres</th>
							<xsl:apply-templates select="../BILAN60/p2051DO" mode="w58etendu">
								<xsl:with-param name="bold">Gras</xsl:with-param>
							</xsl:apply-templates>
					</tr>
					<tr> 
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;Prov. risq. et charges</th>
							<xsl:apply-templates select="../BILAN60/p2051DR" mode="w58etendu">
								<xsl:with-param name="bold">Gras</xsl:with-param>
							</xsl:apply-templates>
					</tr>
					<tr> 
						<td class="clHeight10" colspan="4"></td>
					</tr>
					<tr> 
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;Dettes</th>
							<xsl:apply-templates select="../BILAN60/pK00041" mode="w58etendu">
								<xsl:with-param name="bold">Gras</xsl:with-param>
							</xsl:apply-templates>
					</tr>
					<tr> 
						<td class="clHeight2" colspan="4"></td>
					</tr>
					<tr> 
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;Dt Dettes tab. crdit</th>
							<xsl:apply-templates select="../BILAN60/p2051DU" mode="w58etendu"/>
					</tr>
					<tr> 
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;CBC et s. crd.</th>
							<xsl:apply-templates select="../BILAN60/p2051EH" mode="w58etendu"/>
					</tr>
					<tr> 
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;Autres dettes fin.</th>
							<xsl:apply-templates select="../BILAN60/pK00360" mode="w58etendu"/>
					</tr>
					<tr> 
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;Av.acptes reus</th>
							<xsl:apply-templates select="../BILAN60/p2051DW" mode="w58etendu"/>
					</tr>
					<tr> 
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;Fournisseurs</th>
							<xsl:apply-templates select="../BILAN60/p2051DX" mode="w58etendu"/>
					</tr>
					<tr> 
						<td class="clHeight10" colspan="4"></td>
					</tr>
					<tr> 
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;Autres postes</th>
							<xsl:apply-templates select="../BILAN60/pK00361" mode="w58etendu">
								<xsl:with-param name="bold">Gras</xsl:with-param>
							</xsl:apply-templates>
					</tr>
					<tr> 
						<td class="clHeight10" colspan="4"></td>
					</tr>
					<tr> 
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;Total</th>
							<xsl:apply-templates select="../BILAN60/p2051EE" mode="w58etendu">
								<xsl:with-param name="bold">Gras</xsl:with-param>
							</xsl:apply-templates>
					</tr>
				</table>
			</td>
		</tr >
	</table>

	<!-- AUTRES DONNES ET ENGAGEMENTS HORS BILAN  -->
	
	<a name="engag"></a>
	<xsl:call-template name="shim"/>
	<table class="clWidth635 clBorderCell" role="presentation">
		<tr class="clAlignCenter">
			<td class="clCouleurGras">AUTRES DONNES ET ENGAGEMENTS HORS BILAN</td>
		</tr>
	</table>
	<xsl:call-template name="shim"/>
	<table class="clWidth635 clBorderCell">
    <caption class="visually-hidden">AUTRES DONNES ET ENGAGEMENTS HORS BILAN</caption>
		<tr> 
			<th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;Date d'arrt</th>
			<td colspan="3" class="clAlignCenter">
					<xsl:apply-templates select="../BILAN60/@DATCLOT"/>
			</td>
		</tr>
		<tr> 
			<td class="clHeight10" colspan="4"></td>
		</tr>
		<tr> 
			<th class="clCouleur2 clWidth275 clAlignCenter clThNonGras">&#160;AUTRES DONNES</th>
		</tr>
		<tr> 
			<th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;Part -1 an immobilisations financires</th>
			<td colspan="3" class="clAlignCenter">
					<xsl:apply-templates select="../BILAN60/p2050CP" mode="w120etendu"/>
			</td>
		</tr>
		<tr> 
			<th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;Part -1 an actif circulant et charges const.</th>
			<td colspan="3" class="clAlignCenter">
					<xsl:apply-templates select="../BILAN60/p2050CR" mode="w120etendu"/>
			</td>
		</tr>
		<tr> 
			<th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;Part -1 an dettes et prod. const. d'avance</th>
			<td colspan="3" class="clAlignCenter">
					<xsl:apply-templates select="../BILAN60/p2051EG" mode="w120etendu"/>
			</td>
		</tr>
		<tr> 
			<td class="clHeight10" colspan="4"></td>
		</tr>
		<tr> 
			<th class="clCouleur2 clWidth275 clAlignCenter clThNonGras">&#160;ENGAGEMENTS HORS BILAN</th>
		</tr>
		<tr> 
			<th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;Effets escompts non chus</th>
			<td colspan="3" class="clAlignCenter">
					<xsl:apply-templates select="../BILAN60/p2058YS" mode="w120etendu"/>
			</td>
		</tr>
		<tr> 
			<th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;Autres crances cdes</th>
			<td colspan="3" class="clAlignCenter">
					<xsl:apply-templates select="../BILAN60/pK00048" mode="w120etendu"/>
			</td>
		</tr>
		<tr> 
			<th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;Engagements de crdit-bail</th>
			<td colspan="3" class="clAlignCenter">
					<xsl:apply-templates select="../BILAN60/pK00050" mode="w120etendu"/>
			</td>
		</tr>
	</table>	
</xsl:template>

<xsl:template match="pK00003|pK00004|pK00005|pK00009|pK00010|pK00011|pK00013|pK00014|pK00015|pK00142|pK00358|pK00026|p2050BV|p2050BW|pK00027|p2050BX|p2050BY|pK00028|p2050BZ|p2050CA|pK00030|p2050CD|p2050CE|pK00032|p2050CF|p2050CG|pK00033|p2051DA|p2051DI|p2051DK|p2051DU|p2051EH|pK00360|p2051DW|p2051DX|p2050CP|p2050CR|p2051EG|p2058YS|pK00048|pK00050|p2050AA|p2050BJ|p2050BK|pK00001|pK00355|pK00055|pK00021|pK00357|p2050CI|pK00359|p2050CO|p20501A|pK00035|p2051DL|p2051DO|p2051DR|pK00041|pK00361|p2051EE" mode="w120seul">
	<xsl:param name="bold"/>
	<td class="cl{$bold}Fond clWidth120 clAlignRight">
		<xsl:if test="@ETAT">
			<xsl:value-of select="@ETAT"/>&#160;
		</xsl:if>
		<xsl:if test="not(@ETAT)">
      <xsl:call-template name ="displayNumberXsl">
        <xsl:with-param name ="InputStringNumber" select ="(.)"/>
      </xsl:call-template>&#160;
		</xsl:if>	
	</td>
</xsl:template>

<xsl:template match="pK00003|pK00004|pK00005|pK00009|pK00010|pK00011|pK00013|pK00014|pK00015|pK00142|pK00358|pK00026|p2050BV|p2050BW|pK00027|p2050BX|p2050BY|pK00028|p2050BZ|p2050CA|pK00030|p2050CD|p2050CE|pK00032|p2050CF|p2050CG|pK00033|p2051DA|p2051DI|p2051DK|p2051DU|p2051EH|pK00360|p2051DW|p2051DX|p2050CP|p2050CR|p2051EG|p2058YS|pK00048|pK00050|p2050AA|p2050BJ|p2050BK|pK00001|pK00355|pK00055|pK00021|pK00357|p2050CI|pK00359|p2050CO|p20501A|pK00035|p2051DL|p2051DO|p2051DR|pK00041|pK00361|p2051EE" mode="w58etendu">
	<xsl:param name="bold"/>
	<td class="cl{$bold}Fond clWidth58 clAlignRight">
		<xsl:if test="@ETAT">
			<xsl:value-of select="@ETAT"/>&#160;
		</xsl:if>
		<xsl:if test="not(@ETAT)">
      <xsl:call-template name ="displayNumberXsl">
        <xsl:with-param name ="InputStringNumber" select ="(.)"/>
      </xsl:call-template>&#160;
		</xsl:if>	
	</td>
	<xsl:if test="position()=last() and position()=1">
		<td class="cl{$bold}Fond clWidth58 clAlignRight">&#160;</td>
		<td class="cl{$bold}Fond clWidth58 clAlignRight">&#160;</td>
	</xsl:if>
	<xsl:if test="position()=last() and position()=2">
		<td class="cl{$bold}Fond clWidth58 clAlignRight">&#160;</td>
	</xsl:if>
</xsl:template>

<xsl:template match="p2050CP|p2050CR|p2051EG|p2058YS|pK00048|pK00050|pK00035" mode="w120etendu">
	<xsl:param name="bold"/>
	<td class="cl{$bold}Fond clWidth120 clAlignRight">
		<xsl:if test="@ETAT">
			<xsl:value-of select="@ETAT"/>&#160;
		</xsl:if>
		<xsl:if test="not(@ETAT)">
      <xsl:call-template name ="displayNumberXsl">
        <xsl:with-param name ="InputStringNumber" select ="(.)"/>
      </xsl:call-template>&#160;
		</xsl:if>	
	</td>
	<xsl:if test="position()=last() and position()=1">
		<td class="cl{$bold}Fond clWidth120 clAlignRight">&#160;</td>
		<td class="cl{$bold}Fond clWidth120 clAlignRight">&#160;</td>
	</xsl:if>
	<xsl:if test="position()=last() and position()=2">
		<td class="cl{$bold}Fond clWidth120 clAlignRight">&#160;</td>
	</xsl:if>
</xsl:template>

<xsl:template name="svim">
	<xsl:element name="img">
    <xsl:attribute name ="alt"></xsl:attribute>
		<xsl:attribute name="width">1</xsl:attribute>
		<xsl:attribute name="height">303</xsl:attribute>
		<xsl:attribute name="vspace">8</xsl:attribute>
		<xsl:attribute name="src"><xsl:value-of select="$root"/>Images/risque/shim_bleu.gif</xsl:attribute>
	</xsl:element>
</xsl:template>
	
<xsl:template name="genGraph60">
	<xsl:param name="ident"/>
	<xsl:param name="nom"/> 
	<xsl:param name="nomconj"/>
	<xsl:param name="valcot"/>
	<xsl:param name="datcot"/>  
	<xsl:param name="datexa"/>  
	<xsl:param name="idrenv"/>
	<form action="Graphes.aspx" method="post" name="FormGraphes" target="_blank">
		<input name="familyNumber" type="hidden" value="1"/>
		<input name="moduleNumber" type="hidden" value="{/FIBEN/@MODDEM}"/>
		<xsl:element name="input">
			<xsl:attribute name="name">GrapheData</xsl:attribute>
			<xsl:attribute name="type">hidden</xsl:attribute>
			<xsl:attribute name="value">
			&lt;FIBEN MODDEM=&quot;<xsl:value-of select="FIBEN/@MODDEM"/>&quot; DATJOUR=&quot;<xsl:call-template name ="displayDateForGraph2">
        <xsl:with-param name ="InputDateForGraph" select ="FIBEN/@DATJOUR"/>
      </xsl:call-template>&quot; GRAPHE=&quot;1&quot;&gt;
			&lt;ident&gt;<xsl:value-of select="$ident"/>&lt;/ident&gt;
			&lt;nom&gt;<xsl:value-of select="$nom"/>&lt;/nom&gt;
			&lt;nomconj&gt;<xsl:value-of select="$nomconj"/>&lt;/nomconj&gt;
			&lt;datcot&gt;<xsl:value-of select="$datcot"/>&lt;/datcot&gt;
			&lt;graphe&gt;
				<xsl:if test="$condGraph">
					&lt;serie&gt;
						&lt;val&gt;<xsl:value-of select="translate(FIBEN/PERSONNE/MODULE60/DIFF60/BILAN60[position()=last()]/pK00001,',','.')"/>&lt;/val&gt;
						&lt;val&gt;<xsl:value-of select="translate(FIBEN/PERSONNE/MODULE60/DIFF60/BILAN60[position()=last()]/pK00021,',','.')"/>&lt;/val&gt;
						&lt;val&gt;<xsl:value-of select="number(translate(FIBEN/PERSONNE/MODULE60/DIFF60/BILAN60[position()=last()]/pK00359,',','.')) + number(translate(FIBEN/PERSONNE/MODULE60/DIFF60/BILAN60[position()=last()]/p2050AA,',','.'))"/>&lt;/val&gt;
					&lt;/serie&gt;
					&lt;serie&gt;
						&lt;val&gt;<xsl:value-of select="number(translate(FIBEN/PERSONNE/MODULE60/DIFF60/BILAN60[position()=last()]/p2051DO,',','.')) + number(translate(FIBEN/PERSONNE/MODULE60/DIFF60/BILAN60[position()=last()]/p2051DL,',','.'))"/>&lt;/val&gt;
						&lt;val&gt;<xsl:value-of select="translate(FIBEN/PERSONNE/MODULE60/DIFF60/BILAN60[position()=last()]/pK00041,',','.')"/>&lt;/val&gt;
						&lt;val&gt;<xsl:value-of select="number(translate(FIBEN/PERSONNE/MODULE60/DIFF60/BILAN60[position()=last()]/pK00361,',','.')) + number(translate(FIBEN/PERSONNE/MODULE60/DIFF60/BILAN60[position()=last()]/p2051DR,',','.'))"/>&lt;/val&gt;
						&lt;val&gt;<xsl:value-of select="translate(FIBEN/PERSONNE/MODULE60/DIFF60/BILAN60[position()=last()]/pK00035,',','.')"/>&lt;/val&gt;
					&lt;/serie&gt;
				</xsl:if>
				&lt;titre&gt;Grandes masses du bilan de l'exercice <xsl:call-template name ="displayDateXsl">
        <xsl:with-param name ="InputDate" select ="(FIBEN/PERSONNE/MODULE60/DIFF60/BILAN60[position()=last()]/@DATCLOT)"/>
      </xsl:call-template> (en pourcentage du Total bilan)
				&lt;/titre&gt;
				&lt;type&gt;NF&lt;/type&gt;
			&lt;/graphe&gt;&lt;/FIBEN&gt;
			</xsl:attribute>
		</xsl:element>
	</form>
</xsl:template>
  
</xsl:stylesheet>
