﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
					              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
					              xmlns:bdf="http://banque-france.fr/namespace"
                        xmlns:exslt="http://exslt.org/common">
  <xsl:import href="../../Ressources/XSL/Commun.xsl"/>
  <xsl:import href="../../Ressources/XSL/commun_transfo.xsl"/>
  <xsl:import href="../../Ressources/XSL/Commun_orga.xsl"/>
  <xsl:output method="html" version="1.1" encoding="ISO-8859-15" indent="yes" />
  <xsl:param name="langage" select="'fr'"/>
  <xsl:param name="familyName" select="''"/>
  <xsl:param name="root" select="'/Fiben/'"/>
  <xsl:param name="familyNumber" select="''"/>
  <xsl:param name="familyTitle" select="''"/>
  <xsl:param name="nextModule" select="''"/>
  <xsl:param name="nextId" select="''"/>
  <xsl:param name="nextFamily" select="''"/>
  <xsl:param name="Lang" select="'FR'"/>
  <xsl:param name="NonResident" select="''"/>
  <xsl:param name="menuHTML1"/>
  <xsl:param name="maxFoncDir" select="0"/>
  <xsl:variable name="SizeTabGraph" select ="'600'"></xsl:variable>

  <xsl:template match="/">
    <html lang="fr">
      <title>Module 59 - Chaine d'associés</title>
      <xsl:call-template name="genHead">
        <xsl:with-param name="ident" select="FIBEN/ERREUR/IDENT | FIBEN/PERSONNE/MODULE59/EJ/IDENTS"/>
      </xsl:call-template>
      <body class="clBodybgcolorWhite">
        <xsl:call-template name="genFondMenu">
          <xsl:with-param name="root" select="$root"/>
        </xsl:call-template>
        <xsl:copy-of select="$menuHTML1"/>
        <table class="mainmodule horizontal-auto clBorderCell">
          <caption class="visually-hidden">Module 59 - Chaine d'associés</caption>
          <xsl:call-template name="genLigneConfidentiel" />
          <xsl:apply-templates select="/FIBEN/ERREUR"/>
          <xsl:if test="not(/FIBEN/ERREUR)">
            <tr>
               <td class="clWidth64"></td>
              <td class="clCouleur2 clValignTop clWidth739" colspan="4">
                <xsl:apply-templates select="FIBEN/PERSONNE/MODULE59/EJ"/>
                <xsl:choose>
                  <xsl:when test ="FIBEN/PERSONNE/MODULE59/U101|FIBEN/PERSONNE/MODULE59/U102|FIBEN/PERSONNE/MODULE59/U103|FIBEN/PERSONNE/MODULE59/U107|FIBEN/PERSONNE/MODULE59/IST06|FIBEN/PERSONNE/MODULE59/IST09|FIBEN/PERSONNE/MODULE59/IST10|FIBEN/PERSONNE/MODULE59/IST51|FIBEN/PERSONNE/MODULE59/IST53|FIBEN/PERSONNE/MODULE59/IST59">
                    <xsl:apply-templates select="FIBEN/PERSONNE/MODULE59/U101|FIBEN/PERSONNE/MODULE59/U102|FIBEN/PERSONNE/MODULE59/U103|FIBEN/PERSONNE/MODULE59/U107|FIBEN/PERSONNE/MODULE59/IST06|FIBEN/PERSONNE/MODULE59/IST09|FIBEN/PERSONNE/MODULE59/IST10|FIBEN/PERSONNE/MODULE59/IST51|FIBEN/PERSONNE/MODULE59/IST53|FIBEN/PERSONNE/MODULE59/IST59" mode="genTable"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:call-template name="Entete59"  ></xsl:call-template>
                  </xsl:otherwise>
                </xsl:choose>
              </td>
            </tr>
          </xsl:if>
        </table>
        <xsl:if test="not(/FIBEN/ERREUR)">
          <!-- on sort l'organigramme du tableau principal pour risque de décallage vers la gauche si beaucoup de colonnes -->
          <table class="horizontal-auto clBorderCell" role="presentation">
            <tr>
               <td class="clWidth64"></td>
              <td class="clCouleur2 clValignTop clWidth739" colspan="4">
                <xsl:apply-templates select="FIBEN/PERSONNE/MODULE59/DIFF59"/>
              </td>
            </tr>
          </table>
          <!-- on refait un tableau pour l'affichage SUITE, pour que ce soit centré sur la page -->
          <table class="horizontal-auto clBorderCell" role="presentation">
            <tr>
               <td class="clWidth64"></td>
              <td class="clCouleur2 clValignTop clWidth739" colspan="4">
                <xsl:if test ="not(FIBEN/PERSONNE/MODULE59/U101|FIBEN/PERSONNE/MODULE59/U102|FIBEN/PERSONNE/MODULE59/U103|FIBEN/PERSONNE/MODULE59/U107|FIBEN/PERSONNE/MODULE59/IST06|FIBEN/PERSONNE/MODULE59/IST09|FIBEN/PERSONNE/MODULE59/IST10|FIBEN/PERSONNE/MODULE59/IST51|FIBEN/PERSONNE/MODULE59/IST53|FIBEN/PERSONNE/MODULE59/IST59)">
                  <img src="{$root}Images/risque/shim_bleu.gif" width="635" height="1" vspace="8" alt=""/>
                </xsl:if>
                <xsl:apply-templates select="//SUITE"/>
              </td>
            </tr>
          </table>
        </xsl:if>
        <xsl:call-template name="genBasPage"/>

      </body>
    </html>
  </xsl:template>


  <!-- template entete du module -->
  <xsl:template match="FIBEN/PERSONNE/MODULE59/EJ">
    <xsl:choose>
      <xsl:when test ="../DIFF59/SEGMENT">
        <xsl:call-template name="genEnTete">
          <xsl:with-param name="ident" select="IDENTS"/>
          <xsl:with-param name="nom" select="DENOM"/>
          <xsl:with-param name="valcot" select="../DIFF59/VALCOT"/>
          <xsl:with-param name="segment" select="../DIFF59/SEGMENT"/>
          <xsl:with-param name="datcot" select="../DIFF59/DATCOT"/>
          <xsl:with-param name="datexa" select="../DIFF59/DATEXA"/>
          <xsl:with-param name="dateseg" select="../DIFF59/DATESEG"/>
          <xsl:with-param name="datsegrv" select="../DIFF59/DATSEGRV"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="genEnTete">
          <xsl:with-param name="ident" select="IDENTS"/>
          <xsl:with-param name="nom" select="DENOM"/>
          <xsl:with-param name="valcot" select="../DIFF59/VALCOT"/>
          <xsl:with-param name="datcot" select="../DIFF59/DATCOT"/>
          <xsl:with-param name="datexa" select="../DIFF59/DATEXA"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- template si code retour erreur -->
  <xsl:template match="U101|U102|U103|U107|IST06|IST09|IST10|IST51|IST53|IST59" mode="genTable">
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
        <td class="clWidth14"></td>
        <td class="clCouleur2 clValignTop">
          <xsl:apply-templates select="."/>
        </td>
      </tr>
      <tr>
        <td class="clWidth14"></td>
        <td>
          <xsl:call-template name="shim"/>
        </td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template name="Entete59">

    <table class="clBorderCell" role="presentation">
      <tr>
        <td class="clCouleur2 clWidth605 clAlignCenter">
          Avertissement : Ces informations ne se substituent pas au registre de déclaration des bénéficiaires effectifs mentionnés à l'article L561-46 du Code Monétaire et Financier
        </td>
      </tr>
      <tr>
        <td>
          <xsl:call-template name="shim"/>
        </td>
      </tr>
    </table >
    <!-- début écriture organigramme -->
    <table class="clBorderCell">
      <caption class="visually-hidden">Organigramme Chaine d'associés</caption>
      <tr>
        <td class="clCouleurGras clWidth605 clAlignCenter">
          ORGANIGRAMME AU <xsl:call-template name ="displayDateJourXsl">
            <xsl:with-param name ="InputDate" select ="(/FIBEN/@DATJOUR)"/>
          </xsl:call-template>
        </td>
      </tr>
      <tr>
        <td>
          <xsl:call-template name="shim"/>
        </td>
      </tr>
      <tr>
        <td class="clWidth605">
          <table cellpadding="2px">
            <tr>
              <td>
                <span class="legendeOvale"  >&#160;...&#160;</span>
                <span class="clTexteLegende">&#160;Entité interrogée&#160;</span>
              </td>
              <td>
                <span  class="blocOrange legende" >&#160;...&#160;</span>
                <span class="clTexteLegende">&#160;Associé personne morale</span>
              </td>
              <td>
                <span  class="blocBleu legende" >&#160;...&#160;</span>
                <span class="clTexteLegende">&#160;Associé présent à  un niveau inférieur</span>
              </td>
            </tr>
            <tr>
              <td colspan="2">
                <span  class="blocRouge legende" >&#160;...&#160;</span>
                <span class="clTexteLegende">&#160;Pas d'associé ni de représentant légal personne physique</span>
              </td>
              <td>
                <span  class="blocVert legende" >&#160;...&#160;</span>
                <span class="clTexteLegende">&#160;Associé personne physique</span>
              </td>
            </tr>
            <tr>
              <td colspan="2">
                <span  class="blocVertBlanc legende" >&#160;...&#160;</span>
                <span class="clTexteLegende">&#160;Représentant légal personne physique</span>
              </td>
              <td>&#160;</td>
            </tr>
          </table>
        </td>
      </tr>
      <tr>
        <td>
          <xsl:call-template name="shim"/>
        </td>
      </tr>
    </table>

  </xsl:template>

  <!--ORGANIGRAMME-->
  <xsl:template match="DIFF59">
    <div class="clBreakPage" ></div>

    <!-- calcul de la profondeur du flux pour optimiser taille tableau de l'organigramme -->
    <xsl:variable name="Size">
      <lstAss>
        <xsl:for-each select="child::ASSOCPP59|child::ASSOCEJ59|child::ASSOCSPE59" >
          <nodeAss>
            <xsl:call-template name="profondeur">
              <xsl:with-param name="noeud" select="."/>
              <xsl:with-param name="prof" select="1"/>
            </xsl:call-template>
          </nodeAss>
        </xsl:for-each>
      </lstAss>
    </xsl:variable>

    <!-- test utilisation fonctions specifique msxml ou exslt -->
    <xsl:variable name="maxValue">
      <xsl:choose>
        <xsl:when test="function-available('msxsl:node-set')" >
          <xsl:for-each select="msxsl:node-set($Size)/lstAss/nodeAss" >
            <xsl:sort data-type="number" order="descending" />
            <xsl:if test="position()=1">
              <xsl:variable name ="maxi" select="./node()[1]"></xsl:variable>
              <xsl:choose>
                <xsl:when test=" ($maxi)[1] > 12">
                  <xsl:value-of select="2750" />
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select="(./node()[1] * 250) + 250" />
                </xsl:otherwise>
              </xsl:choose>
            </xsl:if>
          </xsl:for-each>
        </xsl:when>
        <xsl:otherwise>
          <xsl:for-each select="exslt:node-set($Size)/lstAss/nodeAss" >
            <xsl:sort data-type="number" order="descending" />
            <xsl:if test="position()=1">
              <xsl:choose>
                <xsl:when test="./node()[1] > 12">
                  <xsl:value-of select="2750" />
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select="(./node()[1] * 250) + 250" />
                </xsl:otherwise>
              </xsl:choose>
            </xsl:if>
          </xsl:for-each>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>


    <!-- tableau principal pour les blocs de l'organigramme -->
    <table class="clBorderCell Organigramme" width="{($maxValue)}" >
      <tr>
       <td rowspan="0" class="alignTop" align="right">
          <!-- 1er TD pour garder la colonne de l'élipse bleue-->
          <!-- entite interrogée elipse bleu -->
          <div class="ovaleBleu " >
            <p class="texteOrg">
              <xsl:call-template name ="displayDenomTronquee">
                <xsl:with-param name ="Denom" select ="//MODULE59/EJ/DENOM"/>
              </xsl:call-template>
            </p>
          </div>
          <!-- FIN 1er TD colonne de l'élipse bleue-->
        </td>
        <td  class="alignTop">
          <!-- 2eme TD pour mettre la flèche -->
          <span class="imgfleche ">
            <img src="{$root}Images/Commun/flecheBleue.gif" />
          </span>
        </td>
        <td>
          <!-- 3eme TD pour mettre tout les autres div de l'organigramme-->
          <div id="ColAssocies" class="blocInline bordureFleche" >
            <table class="Organigramme">
              <xsl:apply-templates select="//DIFF59/ASSOCPP59|//DIFF59/ASSOCEJ59|//DIFF59/ASSOCSPE59|//DIFF59/REPLEGAUX59/REPLEGAL59" mode="premierNiveau" />
            </table>
          </div>
          <!-- FIN 3eme TD pour les autres blocs de l'organigramme-->
        </td>
      </tr>
    </table>
    <!-- FIN tableu principal pour les blocs de l'organigramme -->

  </xsl:template>
  <!-- === associes de premier niveau soit EJ soit PP === -->
  <!-- cadres verts PP -->
  <xsl:template match="ASSOCPP59" mode="premierNiveau">
    <tr>
      <td>
        <div class="blocInline PasBordureFleche">
          <div class="blocVert arrondiEnligne tailleBloc " >
            <xsl:apply-templates select="."/>
          </div>
        </div>
        <xsl:call-template name="verifieAssociesNiveauSuivant" />
      </td>
    </tr>
  </xsl:template>

  <!-- cadres oranges EJ  et cadres rouges et Assoc Speciaux-->
  <xsl:template match="ASSOCEJ59|ASSOCSPE59" mode="premierNiveau">
    <tr>
      <td>
        <div class="blocInline PasBordureFleche">
          <!-- si Pas d'associé ni de représentant légal personne physique -->
          <xsl:if test ="not(./ASSOCPP59|./ASSOCEJ59|./ASSOCSPE59|./REPLEGAUX59/REPLEGAL59)">
            <div class="blocRouge arrondiEnligne tailleBloc" >
              <xsl:apply-templates select="."/>
            </div>
          </xsl:if>
          <xsl:if test ="./ASSOCPP59|./ASSOCEJ59|./ASSOCSPE59|./REPLEGAUX59/REPLEGAL59">
            <div class="blocOrange arrondiEnligne tailleBloc" >
              <xsl:apply-templates select="."/>
            </div>
          </xsl:if>
        </div>
        <xsl:call-template name="verifieAssociesNiveauSuivant" />
      </td>
    </tr>
  </xsl:template>

  <!-- cadres verts fond blanc, representants legaux -->
  <xsl:template match="REPLEGAL59" mode="premierNiveau">
    <tr>
      <td>
        <div class="blocInline PasBordureFleche">
          <div class="blocVertBlanc arrondiEnligne tailleBloc" >
            <xsl:apply-templates select="."/>
          </div>
        </div>
        <xsl:call-template name="verifieAssociesNiveauSuivant" />
      </td>
    </tr>
  </xsl:template>




  <!-- === FIN associes de premier niveau soit EJ soit PP === -->

  <!-- === vérifie s'il y a des associes de  niveau suivant === -->
  <xsl:template name="verifieAssociesNiveauSuivant">
    <xsl:if test ="./ASSOCPP59|./ASSOCEJ59|./ASSOCSPE59|./REPLEGAUX59/REPLEGAL59">
      <table class="blocInline Organigramme clBorderCell" >
        <tr>
          <td class="alignTop">
            <span class="imgfleche ">
              <img src="{$root}Images/Commun/flecheBleue.gif" />
            </span>
          </td>
          <td class="blocInline">
            <xsl:choose>
              <xsl:when test="(count(child::ASSOCPP59) + count(child::ASSOCEJ59) + count(child::ASSOCSPE59)+ count(child::REPLEGAUX59/REPLEGAL59)) &gt; 1">
                <div class="blocInline bordureFleche">
                  <!-- associé niveau suivant : n -->
                  <xsl:apply-templates select="ASSOCPP59|ASSOCEJ59|ASSOCSPE59|REPLEGAUX59/REPLEGAL59" mode="NiveauN" />
                </div>
              </xsl:when>
              <xsl:otherwise>
                <div class="blocInline pasBordureFleche">
                  <!-- associé niveau suivant : n -->
                  <xsl:apply-templates select="ASSOCPP59|ASSOCEJ59|ASSOCSPE59|REPLEGAUX59/REPLEGAL59" mode="NiveauN" />
                </div>
              </xsl:otherwise>
            </xsl:choose>
          </td>
        </tr>
      </table>

    </xsl:if>
  </xsl:template>

  <!-- ===  associes de niveaux suivants 
            - soit EJ 
            - soit PP  
            - soit assoc spe 
            - soit rep legal  
  === -->

  <!-- cadres verts PP -->
  <xsl:template match="ASSOCPP59" mode="NiveauN">

    <xsl:if test="./ASSOCPP59|./ASSOCEJ59|./ASSOCSPE59|./REPLEGAUX59/REPLEGAL59">
      <div class="blocVert arrondiEnligne tailleBloc" >
        <xsl:apply-templates select="."/>
      </div>
    </xsl:if>
    <xsl:if test="not(./ASSOCPP59|./ASSOCEJ59|./ASSOCSPE59|./REPLEGAUX59/REPLEGAL59)">
      <div class="arrondiBlock"></div>
      <div class="blocVert arrondiEnLigne tailleBloc" >
        <xsl:apply-templates select="."/>
      </div>
    </xsl:if>
    <xsl:call-template name="verifieAssociesNiveauSuivant" />
  </xsl:template>

  <!-- cadres verts fond blanc, representants legaux -->
  <xsl:template match="REPLEGAL59" mode="NiveauN">
    <xsl:if test="./ASSOCPP59|./ASSOCEJ59|./ASSOCSPE59|./REPLEGAUX59/REPLEGAL59">
      <div class="blocVertBlanc arrondiEnligne tailleBloc" >
        <xsl:apply-templates select="."/>
      </div>
    </xsl:if>
    <xsl:if test="not(./ASSOCPP59|./ASSOCEJ59|./ASSOCSPE59|./REPLEGAUX59/REPLEGAL59)">
      <div class="arrondiBlock"></div>
      <div class="blocVertBlanc arrondiEnLigne tailleBloc" >
        <xsl:apply-templates select="."/>
      </div>
    </xsl:if>
    <xsl:call-template name="verifieAssociesNiveauSuivant" />
  </xsl:template>

  <!-- cadres oranges EJ  et Assoc Speciaux-->
  <xsl:template match="ASSOCEJ59|ASSOCSPE59" mode="NiveauN">
    <!-- Si present niveau precedent : test sur balise PRESENTNIVINF -->
    <xsl:if test ="./PRESENTNIVINF">
      <div class="arrondiBlock"></div>
      <div class="blocBleu arrondiEnLigne tailleBloc" >
        <xsl:apply-templates select="."/>
      </div>
    </xsl:if>
    <xsl:if test ="not(./PRESENTNIVINF)">
      <!-- si Pas d'associé ni de représentant légal personne physique -->
      <xsl:if test="./ASSOCPP59|./ASSOCEJ59|./ASSOCSPE59|./REPLEGAUX59/REPLEGAL59">
        <div class="arrondiBlock"></div>
        <div class="blocOrange arrondiEnligne tailleBloc" >
          <xsl:apply-templates select="."/>
        </div>

      </xsl:if>
      <xsl:if test="not(./ASSOCPP59|./ASSOCEJ59|./ASSOCSPE59|./REPLEGAUX59/REPLEGAL59)">

        <div class="blocRouge arrondiBlock tailleBloc" >
          <xsl:apply-templates select="."/>
        </div>
      </xsl:if>
    </xsl:if>
    <xsl:call-template name="verifieAssociesNiveauSuivant" />
  </xsl:template>

  <!--  *************************************************************************
         template affichage données dans le cadre  : 
         (Fonction, nom, siren, participations, cotations...)  
        ******************************************************************************-->
  <xsl:template match="ASSOCPP59|ASSOCEJ59|ASSOCSPE59|REPLEGAL59">
    <xsl:variable name="from">'</xsl:variable>
    <xsl:variable name="to">&#146;</xsl:variable>
    <xsl:variable name="lib_fonct"  select="name(FONCTCOT/*[position()=1])"/>
    <xsl:variable name="Libfonction" select="translate($dictionnaire/mot[@id=$lib_fonct],$from,$to)"/>
    <xsl:variable name="Code_fonct"  select="substring(name(FONCTCOT/*[1]),3)"/>

    <!-- affichage fonction et date si renseignée -->
    <xsl:if test="FONCTCOT/DATFONCT">
      <p class="clTexteGrey clAlignCenter">
        <span class="infobulle" aria-label="{$Libfonction}">
          <xsl:value-of select="$Code_fonct"/>
        </span>

        &#160;le <xsl:call-template name ="displayDateOrg2">
          <xsl:with-param name ="InputDateOrg" select ="FONCTCOT/DATFONCT"/>
        </xsl:call-template>
      </p>
    </xsl:if>

    <!-- affichage denom ou nom prénom selon le cas avec taille variable du bloc-->
    <xsl:if test="EJ/DENOM|DENOM">
      <p class="clTexteGras tailleDenom margin3">
        <xsl:call-template name ="displayDenomTronqueeV2">
          <xsl:with-param name ="Denom" select ="EJ/DENOM|DENOM"/>
        </xsl:call-template>
      </p>
    </xsl:if>

    <xsl:if test="PP">
      <xsl:apply-templates select="PP" mode="display2lignes"/>
    </xsl:if>
    <!--  affichage lien siren ou clef  -->
    <xsl:apply-templates select="EJ/IDENTS|IDENTS|PP/IDENTC|IDENTC" mode="LienMultiple"/>

    <!--  affichage capital -->
    <xsl:apply-templates select="CAPITAL"/>

    <xsl:choose>
      <xsl:when test="EJ/DENOM">
        <!--  affichage cotation si balise VALCOT présente (c.a.d. résidente) pour EJ-->

        <xsl:if test="VALCOT">
          <xsl:choose>
            <xsl:when test="SEGMENT">
              <xsl:apply-templates select="SEGMENT"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:apply-templates select="VALCOT"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:if>
      </xsl:when>
      <xsl:otherwise>
        <!--  affichage cotation pour les rep legaux-->
        <xsl:if test="VALCOT|./FONCTCOT/VALCOT">
          <xsl:apply-templates select="VALCOT|./FONCTCOT/VALCOT"/>
        </xsl:if>
      </xsl:otherwise>
    </xsl:choose>

  </xsl:template>

  <xsl:template match="CAPITAL">
    <p class="clOrgTexteCapital margin3 clAlignCenter">
      <xsl:value-of select="POURCENTAGE"/>%
      <xsl:if test="DATDET">
        au <xsl:call-template name ="displayDateOrg2">
          <xsl:with-param name ="InputDateOrg" select ="DATDET"/>
        </xsl:call-template>

      </xsl:if>
    </p>
  </xsl:template>

  <xsl:template match="VALCOT">
    <p class="clTexteGrey clAlignCenter">
      <xsl:value-of select="."/>
    </p>
  </xsl:template>
  <xsl:template match="SEGMENT">
    <p class="clTexteGrey clAlignCenter">
      <xsl:value-of select="../VALCOT"/>&#160;|&#160;<xsl:value-of select="(.)"/>
    </p>
  </xsl:template>

  <!-- div - ajouts de liens cliquables pour consultation d'autres modules 
  TODO : copie du 58 a vérifier pour 59 si balise VALCOT alors résident ou monégasque -->
  <xsl:template match="EJ/IDENTS|IDENTS|PP/IDENTC|IDENTC" mode="LienMultiple">
    <p class="margin3 clAlignCenter">
      <xsl:choose>
        <xsl:when test ="../../VALCOT|../../FONCTCOT/VALCOT">
          <!-- résidents -->
          <xsl:if test="../../EJ">
            <xsl:choose>
              <xsl:when test ="../../SEGMENT">
                <xsl:call-template name ="displayLienCliquable">
                  <xsl:with-param name ="ident" select ="(.)"/>
                  <xsl:with-param name ="lstModules" select ="('27|37|39|')"/>
                </xsl:call-template>
              </xsl:when>
              <xsl:otherwise>
                <xsl:call-template name ="displayLienCliquable">
                  <xsl:with-param name ="ident" select ="(.)"/>
                  <xsl:with-param name ="lstModules" select ="('27|37|')"/>
                </xsl:call-template>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:if>
          <xsl:if test="../../PP">
            <xsl:call-template name ="displayLienCliquable">
              <xsl:with-param name ="ident" select ="(.)"/>
              <xsl:with-param name ="lstModules" select ="('27|37|')"/>
            </xsl:call-template>
          </xsl:if>
        </xsl:when>
        <xsl:otherwise>
          <!-- non résidents -->
          <xsl:if test="../../EJ">
            <xsl:call-template name ="displayLienCliquable">
              <xsl:with-param name ="ident" select ="(.)"/>
              <xsl:with-param name ="lstModules" select ="('27')"/>
            </xsl:call-template>
          </xsl:if>
          <xsl:if test="../../PP">
            <xsl:call-template name ="displayLienCliquable">
              <xsl:with-param name ="ident" select ="(.)"/>
              <xsl:with-param name ="lstModules" select ="('27')"/>
            </xsl:call-template>
          </xsl:if>
        </xsl:otherwise>
      </xsl:choose>
    </p>
  </xsl:template>


  <!--SUITE-->

  <xsl:template match="SUITE">
    <xsl:if test="position()=1">
      <xsl:text disable-output-escaping="yes">
			&lt;table width=&quot;635&quot; border=&quot;0&quot; cellspacing=&quot;1&quot; cellpadding=&quot;0&quot;&gt;
				&lt;tr&gt;
					&lt;td width=&quot;635&quot; class=&quot;clItalic&quot; height=&quot;2&quot;&gt;
		</xsl:text>
      Les entités suivantes comportent plus de 10 représentants légaux. Pour obtenir la liste complète, cliquez sur l'identifiant afin de générer le module correspondant : "51 - Dirigeants de l'entreprise" :
    </xsl:if>
    <xsl:if test="position()!=last()">
      <xsl:apply-templates select=".." mode="displaySirenForSuite"/> -
    </xsl:if>
    <xsl:if test="position()=last()">
      <xsl:apply-templates select=".."  mode="displaySirenForSuite"/>
      <xsl:text disable-output-escaping="yes">
					&lt;/td&gt;
				&lt;/tr&gt;
			&lt;/table&gt;
		</xsl:text>
      <img src="{$root}Images/risque/shim_bleu.gif" width="635" height="1" vspace="8" alt=""/>
      <br />
      <br />
    </xsl:if>
  </xsl:template>

  <xsl:template match="DIFF59" mode="displaySirenForSuite">
    <a href="#nullepart" onclick="requestBDFInfos('51','','{$familyNumber}','{../EJ/IDENTS}',false,false,this)" class="clItalic">
      <u>
        <xsl:call-template name ="displaySirenXsl">
          <xsl:with-param name ="InputSiren" select ="(../EJ/IDENTS)"/>
        </xsl:call-template>
      </u>
    </a>
  </xsl:template>

  <xsl:template match="ASSOCEJ59|ASSOCSPE59" mode="displaySirenForSuite">
    <a href="#nullepart" onclick="requestBDFInfos('51','','{$familyNumber}','{EJ/IDENTS}',false,false,this)" class="clItalic">
      <u>
        <xsl:call-template name ="displaySirenXsl">
          <xsl:with-param name ="InputSiren" select ="(EJ/IDENTS)"/>
        </xsl:call-template>
      </u>
    </a>
  </xsl:template>

  <xsl:template match="ASSOCPP59" mode="displaySirenForSuite">
    <a href="#nullepart" onclick="requestBDFInfos('51','','{$familyNumber}','{PP/IDENTC}',false,false,this)" class="clItalic">
      <u>
        <xsl:call-template name ="displaySirenXsl">
          <xsl:with-param name ="InputSiren" select ="(PP/IDENTC)"/>
        </xsl:call-template>
      </u>
    </a>
  </xsl:template>


  <xsl:template name="profondeur">
    <xsl:param name="noeud"/>
    <xsl:param name="prof" select="0"/>
    <xsl:choose>
      <xsl:when test="$noeud/ASSOCPP59|$noeud/ASSOCEJ59|$noeud/ASSOCSPE59|$noeud/REPLEGAUX59/REPLEGAL59">
        <xsl:call-template name="profondeur">
          <xsl:with-param name="noeud" select="$noeud/*"/>
          <xsl:with-param name="prof" select="$prof + 1"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$prof"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>


</xsl:stylesheet>
