<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
					              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
					              xmlns:bdf="http://banque-france.fr/namespace">
  <xsl:import href="../../Ressources/XSL/Commun.xsl"/>
  <xsl:import href="../../Ressources/XSL/commun_transfo.xsl"/>
  <xsl:import href="../../Ressources/XSL/Commun_orga.xsl"/>
  <xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes" />
  <xsl:param name="langage" select="'fr'"/>
  <xsl:param name="familyName" select="''"/>
  <xsl:param name="root" select="'/Fiben/'"/>
  <xsl:param name="familyNumber" select="''"/>
  <xsl:param name="familyTitle" select="''"/>
  <xsl:param name="nextModule" select="''"/>
  <xsl:param name="nextId" select="''"/>
  <xsl:param name="nextFamily" select="''"/>
  <xsl:param name="Lang" select="'FR'"/>
  <xsl:param name="NonResident" select="''"/>
  <xsl:param name="menuHTML1"/>
  <xsl:param name="maxFoncDir" select="0"/>

  <xsl:param name="nbRepLegaux" select="count(//DIFF58/REPLEGAUX/REPLEGAL)"/>

  <xsl:template match="/">
    <html lang="fr">
      <title>Module 58 - Organigramme liens de direction</title>
      <xsl:call-template name="genHead">
        <xsl:with-param name="ident" select="FIBEN/ERREUR/IDENT | FIBEN/PERSONNE/MODULE58/EJ/IDENTS"/>
      </xsl:call-template>
      <body class="clBodybgcolorWhite">
        <xsl:call-template name="genFondMenu">
          <xsl:with-param name="root" select="$root"/>
        </xsl:call-template>
        <xsl:copy-of select="$menuHTML1"/>

        <table class="mainmodule horizontal-auto clBorderCell">
          <caption class="visually-hidden">Module 58 - Organigramme liens de direction</caption>
          <xsl:call-template name="genLigneConfidentiel" />
          <xsl:apply-templates select="/FIBEN/ERREUR"/>
          <xsl:if test="not(/FIBEN/ERREUR)">
            <tr>
               <td class="clWidth64"></td>
              <td class="clCouleur2 clValignTop clWidth739" colspan="4">
                <xsl:apply-templates select="FIBEN/PERSONNE/MODULE58/EJ"/>
                <xsl:choose >
                  <xsl:when test ="FIBEN/PERSONNE/MODULE58/IEC01|FIBEN/PERSONNE/MODULE58/IST10|FIBEN/PERSONNE/MODULE58/U101|FIBEN/PERSONNE/MODULE58/IST51|FIBEN/PERSONNE/MODULE58/IST56">
                    <xsl:apply-templates select="FIBEN/PERSONNE/MODULE58/IEC01|FIBEN/PERSONNE/MODULE58/IST10|FIBEN/PERSONNE/MODULE58/U101|FIBEN/PERSONNE/MODULE58/IST51|FIBEN/PERSONNE/MODULE58/IST56" mode="genTable"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:call-template name="Entete58"  ></xsl:call-template>
                  </xsl:otherwise>
                </xsl:choose>

              </td>
            </tr>
          </xsl:if>
        </table>
        <xsl:if test="not(/FIBEN/ERREUR)">
          <!-- on sort l'organigramme du tableau principal pour risque de décallage vers la gauche si beaucoup de colonnes -->
          <table class="horizontal-auto clBorderCell" role="presentation">
            <tr>
               <td class="clWidth64"></td>
              <td class="clCouleur2 clValignTop clWidth739" colspan="4">
                <xsl:apply-templates select="FIBEN/PERSONNE/MODULE58/DIFF58"/>
              </td>
            </tr>
          </table>
          <!-- on refait un tableau pour l'affichage SUITE, pour que ce soit centré sur la page -->
          <table class="horizontal-auto clBorderCell" role="presentation">
            <tr>
               <td class="clWidth64"></td>
              <td class="clCouleur2 clValignTop clWidth739" colspan="4">
                <xsl:if test ="not(FIBEN/PERSONNE/MODULE58/IEC01|FIBEN/PERSONNE/MODULE58/IST10|FIBEN/PERSONNE/MODULE58/U101|FIBEN/PERSONNE/MODULE58/IST51|FIBEN/PERSONNE/MODULE58/IST56)">
                  <img src="{$root}Images/risque/shim_bleu.gif" width="635" height="1" vspace="8" alt=""/>
                </xsl:if>
                <xsl:apply-templates select="//DIRECTIONS/SUITE"/>
                <xsl:apply-templates select="//REPLEGAUX/SUITE"/>
                <xsl:apply-templates select="//REPLEGAUX/REPLEGAL" mode="printnext"/>
              </td>
            </tr>
          </table>
        </xsl:if>
        <xsl:call-template name="genBasPage"/>
      </body>
    </html>
  </xsl:template>

  <xsl:template match="FIBEN/PERSONNE/MODULE58/EJ">
    <!-- appel du template avec parametre segment  pas -->
    <xsl:choose>
      <xsl:when test ="../DIFF58/SEGMENT">
        <xsl:call-template name="genEnTete">
          <xsl:with-param name="ident" select="IDENTS"/>
          <xsl:with-param name="nom" select="DENOM"/>
          <xsl:with-param name="valcot" select="../DIFF58/VALCOT"/>
          <xsl:with-param name="segment" select="../DIFF58/SEGMENT"/>
          <xsl:with-param name="datcot" select="../DIFF58/DATCOT"/>
          <xsl:with-param name="datexa" select="../DIFF58/DATEXA"/>
          <xsl:with-param name="dateseg" select="../DIFF58/DATESEG"/>
          <xsl:with-param name="datsegrv" select="../DIFF58/DATSEGRV"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="genEnTete">
          <xsl:with-param name="ident" select="IDENTS"/>
          <xsl:with-param name="nom" select="DENOM"/>
          <xsl:with-param name="valcot" select="../DIFF58/VALCOT"/>
          <xsl:with-param name="datcot" select="../DIFF58/DATCOT"/>
          <xsl:with-param name="datexa" select="../DIFF58/DATEXA"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="IEC01|IST10|U101|IST51|IST56" mode="genTable">
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
        <td class="clWidth14"></td>
        <td class="clCouleur2 clValignTop">
          <xsl:apply-templates select="."/>
        </td>
      </tr>
      <tr>
        <td class="clWidth14"></td>
        <td>
          <xsl:call-template name="shim"/>
        </td>
      </tr>
    </table>
  </xsl:template>

  <!--ORGANIGRAMME-->
  <xsl:template name="Entete58">
    <!-- entête et légende organigramme -->
   <table class="clBorderCell">
     <caption class="visually-hidden">Organigramme liens de direction</caption>
      <tr>
        <td class="clCouleurGras clWidth605 clAlignCenter">
          ORGANIGRAMME AU <xsl:call-template name ="displayDateJourXsl">
            <xsl:with-param name ="InputDate" select ="(/FIBEN/@DATJOUR)"/>
          </xsl:call-template>
        </td>
      </tr>
      <tr>
        <td>
          <xsl:call-template name="shim"/>
        </td>
      </tr>
      <tr>
        <td class="clWidth605 clHeight30">
          <span class="legendeOvale"  >&#160;...&#160;</span>
          <span class="clTexteLegende">&#160;Entité interrogée&#160;</span>
          <span  class="blocRouge legende" >&#160;...&#160;</span>
          <span class="clTexteLegende">&#160;Représentants légaux</span>
          <xsl:if test="//DIFF58/DIRECTIONS">
            <span class="blocVert legende" >&#160;...&#160;</span>
            <span class="clTexteLegende">&#160;Fonctions de direction exercées</span>
          </xsl:if>
        </td>
      </tr>
      <xsl:if test="//REPLEGAL/DIRECTIONS">
        <tr>
          <td class="clWidth605 clHeight40">
            <span class="blocBleu legende" >&#160;...&#160;</span>
            <span class="clTexteLegende">&#160;Fonctions de direction exercées par les représentants légaux</span>
          </td>
        </tr>
      </xsl:if>
      <tr>
        <td>
          <xsl:call-template name="shim"/>
        </td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template match="DIFF58">
    <div class="clBreakPage"/>


    <!-- table principale pour les blocs de l'organigramme -->
   <table class="clBorderCell">
      <tr>
         <td class="clAlignRight">&#160;</td>
        <td class="clAlignCenter clValignBottom">
          <img src="{$root}Images/Commun/org_gde_fleche_red.gif" width="138" height="72" />
        </td>
        <!-- afficher les blocs rouges : représentants légaux (ajoute des TD)-->
        <xsl:apply-templates select="//DIFF58/REPLEGAUX/REPLEGAL" mode="rep_legaux"/>
      </tr>
      <tr>
        <td>&#160;</td>
        <td>&#160;</td>
        <xsl:apply-templates select="//DIFF58/REPLEGAUX/REPLEGAL" mode="FlecheFonction2"/>
      </tr>
      <tr>
        <td rowspan="2">&#160;</td>
       <td rowspan="2" class="clAlignCenter clValignTop">
          <!-- nouvelle presentation elipse en css -->
          <div class="ovaleBleu " >
            <p class="texteOrg">
              <xsl:call-template name ="displayDenomTronquee">
                <xsl:with-param name ="Denom" select ="//MODULE58/EJ/DENOM"/>
              </xsl:call-template>
            </p>
          </div>
          <!-- fin elipse bleue -->
          <xsl:if test="//DIFF58/DIRECTIONS/DIRECTION58">
            <table class="clBorderCell clWidth139 ">
              <tr>
                 <td class="clAlignCenter">
                  <img width="15" height="8" src="/FIBEN/Images/Commun/org_fleche_red.gif" style="padding:5px;" />
                </td>
              </tr>
              <tr>
               <td class="clAlignCenter clValignTop">
                  <!-- afficher les blocs verts : fonctions de direction-->
                  <xsl:apply-templates select="//DIFF58/DIRECTIONS/DIRECTION58" mode="direction1"/>
                </td>
              </tr>
            </table>
          </xsl:if>
        </td>
        <!-- afficher les éventuels blocs bleus : Fonctions de direction exercées par les représentants légaux (ajoute des TD)-->
        <xsl:if test="//REPLEGAL/DIRECTIONS">
          <xsl:apply-templates select="//DIFF58/REPLEGAUX/REPLEGAL" mode="direction2"/>
        </xsl:if>
      </tr>

    </table>

  </xsl:template>

  <!-- DIV - ajouts de liens cliquables pour consultation d'autres modules -->
  <xsl:template match="EJ/IDENTS|EI58/IDENTS|PP/IDENTC" mode="LienMultiple">
    <div class="clAlignCenter">

      <xsl:if test="../../../REPLEGAL">
        <a href="#nullepart" onclick="requestBDFInfos('27|37|','','1','{.}',cstMultipleConfirm)" class="clOrgBoldlienV2">
          <xsl:call-template name ="displayIdentXsl">
            <xsl:with-param name ="InputIdent" select ="(.)"/>
          </xsl:call-template>
        </a>
      </xsl:if>
      <xsl:if test="not(../../../REPLEGAL)">
        <xsl:if test="../../EJ">
          <a href="#nullepart" onclick="requestBDFInfos('27|37|51|','','1','{.}',cstMultipleConfirm)" class="clOrgBoldlienV2">
            <xsl:call-template name ="displayIdentXsl">
              <xsl:with-param name ="InputIdent" select ="(.)"/>
            </xsl:call-template>
          </a>
        </xsl:if>
        <xsl:if test="../../EI58">
          <a href="#nullepart" onclick="requestBDFInfos('27|37|','','1','{.}',cstMultipleConfirm)" class="clOrgBoldlienV2">
            <xsl:call-template name ="displayIdentXsl">
              <xsl:with-param name ="InputIdent" select ="(.)"/>
            </xsl:call-template>
          </a>
        </xsl:if>
      </xsl:if>
    </div>
  </xsl:template>
  <xsl:template match="EJ/IDENTS|EI58/IDENTS|PP/IDENTC" mode="LienMultipleSegment">
    <div class="clAlignCenter">
      <xsl:if test="../../../REPLEGAL">
        <a href="#nullepart" onclick="requestBDFInfos('27|37|39|','','1','{.}',cstMultipleConfirm)" class="clOrgBoldlienV2">
          <xsl:call-template name ="displayIdentXsl">
            <xsl:with-param name ="InputIdent" select ="(.)"/>
          </xsl:call-template>
        </a>
      </xsl:if>
      <xsl:if test="not(../../../REPLEGAL)">
        <xsl:if test="../../EJ">
          <a href="#nullepart" onclick="requestBDFInfos('27|37|39|51|','','1','{.}',cstMultipleConfirm)" class="clOrgBoldlienV2">
            <xsl:call-template name ="displayIdentXsl">
              <xsl:with-param name ="InputIdent" select ="(.)"/>
            </xsl:call-template>
          </a>
        </xsl:if>
        <xsl:if test="../../EI58">
          <a href="#nullepart" onclick="requestBDFInfos('27|37|39|','','1','{.}',cstMultipleConfirm)" class="clOrgBoldlienV2">
            <xsl:call-template name ="displayIdentXsl">
              <xsl:with-param name ="InputIdent" select ="(.)"/>
            </xsl:call-template>
          </a>
        </xsl:if>
      </xsl:if>
    </div>
  </xsl:template>


  <!--Représentant légaux de L'ENTITE INTERROGE-->
  <xsl:template match="//DIFF58/REPLEGAUX/REPLEGAL" mode="rep_legaux">
    <xsl:variable name="preced" select="preceding-sibling::*"/>
    <xsl:if test="not($preced/PP/IDENTC=PP/IDENTC or $preced/EJ/IDENTS=EJ/IDENTS)">
      <!--<td height="95" width="138" align="center">-->
      <td>
        <!-- cadres rouges representants legaux -->
        <Div class="blocRouge arrondi tailleBloc " >
          <xsl:apply-templates select="."/>
        </Div>
      </td>
    </xsl:if>
  </xsl:template>

  <xsl:template match="//DIFF58/REPLEGAUX/REPLEGAL" mode="FlecheFonction2">
    <xsl:variable name="preced" select="preceding-sibling::*"/>
    <xsl:if test="not($preced/PP/IDENTC=PP/IDENTC or $preced/EJ/IDENTS=EJ/IDENTS)">
      <xsl:if test="count(DIRECTIONS)>0">
        <td class="clWidth138 clAlignCenter">
          <img src="{$root}Images/Commun/org_fleche_red.gif" width="15" height="8" />
        </td>
      </xsl:if>
      <xsl:if test="count(DIRECTIONS)=0">
        <td class="clWidth138 clAlignCenter">&#160;</td>
      </xsl:if>
    </xsl:if>
  </xsl:template>

  <xsl:template match="REPLEGAL" mode="printnext">
    <!-- ajout d'un cartouche en bas d'écran -->
    <xsl:variable name="preced" select="preceding-sibling::*"/>
    <xsl:if test="PP">
      <xsl:variable name="val" select="PP/IDENTC"/>
      <xsl:variable name="nbPreced" select="count($preced/PP[IDENTC=$val])"/>
      <xsl:if test="$nbPreced=1">
        <table class="clWidth635 clBorderCell">
          <tr>
            <xsl:variable name="lib_fonct1" select="name(FONCTCOT/*[position()=1])"/>
            <xsl:variable name="from">'</xsl:variable>
            <xsl:variable name="to">&#146;</xsl:variable>
            <xsl:variable name="Libfonction1" select="translate($dictionnaire/mot[@id=$lib_fonct1],$from,$to)"/>

            <td class="clItalic clWidthMax">
              <xsl:value-of select="$val"/> exerce d'autres fonctions de direction : <a href="#nullepart" onclick="requestVariousInfos('{$Libfonction1}',cstWording)" class="clItalic">
                <u>
                  <xsl:value-of select="substring(name(FONCTCOT/*[1]),3)"/>
                </u>
              </a>
              <xsl:if test="FONCTCOT/DATFONCT">
                &#160;LE <xsl:call-template name ="displayDateOrg2">
                  <xsl:with-param name ="InputDateOrg" select ="FONCTCOT/DATFONCT"/>
                </xsl:call-template>

              </xsl:if>
              <xsl:variable name="follows" select="following-sibling::*"/>
              <xsl:for-each select="$follows">
                <xsl:variable name="lib_fonct2" select="name(FONCTCOT/*[position()=1])"/>
                <xsl:variable name="Libfonction2" select="translate($dictionnaire/mot[@id=$lib_fonct2],$from,$to)"/>
                <xsl:if test="PP/IDENTC=$val">
                  , <a href="#nullepart" onclick="requestVariousInfos('{$val}',cstWording)">
                    <u>
                      <xsl:value-of select="substring(name(FONCTCOT/*[1]),3)"/>
                    </u>
                  </a>
                  <xsl:if test="FONCTCOT/DATFONCT">
                    &#160;LE <xsl:call-template name ="displayDateOrg2">
                      <xsl:with-param name ="InputDateOrg" select ="FONCTCOT/DATFONCT"/>
                    </xsl:call-template>

                  </xsl:if>
                </xsl:if>
              </xsl:for-each>
            </td>
          </tr>
        </table>
        <img src="{$root}Images/risque/shim_bleu.gif" width="635" height="1" vspace="8" alt=""/>
      </xsl:if>
    </xsl:if>
    <xsl:if test="EJ">
      <xsl:variable name="val" select="EJ/IDENTS"/>
      <xsl:variable name="nbPreced" select="count($preced/EJ[IDENTS=$val])"/>

      <xsl:if test="$nbPreced=1">
        <table class="clWidth635 clBorderCell">
          <tr>
            <xsl:variable name="from">'</xsl:variable>
            <xsl:variable name="to">&#146;</xsl:variable>
            <xsl:variable name="lib_fonct1" select="name(FONCTCOT/*[position()=1])"/>
            <xsl:variable name="Libfonction1" select="translate($dictionnaire/mot[@id=$lib_fonct1],$from,$to)"/>
            <td class="clItalic clWidthMax">
              <xsl:call-template name ="displaySirenXsl">
                <xsl:with-param name ="InputSiren" select ="($val)"/>
              </xsl:call-template> exerce d'autres fonctions de direction : <a href="#nullepart"  onclick="requestVariousInfos('{$Libfonction1}',cstWording)" class="clItalic">
                <u>
                  <xsl:value-of select="substring(name(FONCTCOT/*[1]),3)"/>
                </u>
              </a>
              <xsl:if test="FONCTCOT/DATFONCT">
                &#160;LE <xsl:call-template name ="displayDateOrg2">
                  <xsl:with-param name ="InputDateOrg" select ="FONCTCOT/DATFONCT"/>
                </xsl:call-template>

              </xsl:if>
              <xsl:variable name="follows" select="following-sibling::*"/>
              <xsl:for-each select="$follows">
                <xsl:variable name="lib_fonct2"  select="name(FONCTCOT/*[position()=1])"/>

                <xsl:variable name="Libfonction2" select="translate($dictionnaire/mot[@id=$lib_fonct2],$from,$to)"/>
                <xsl:if test="EJ/IDENTS=$val">
                  , <a href="#nullepart" onclick="requestVariousInfos('{$Libfonction2}',cstWording)">
                    <u>
                      <xsl:value-of select="substring(name(FONCTCOT/*[1]),3)"/>
                    </u>
                  </a><xsl:if test="FONCTCOT/DATFONCT">
                    &#160;LE <xsl:call-template name ="displayDateOrg2">
                      <xsl:with-param name ="InputDateOrg" select ="FONCTCOT/DATFONCT"/>
                    </xsl:call-template>

                  </xsl:if>
                </xsl:if>
              </xsl:for-each>
            </td>
          </tr>
        </table>
        <img src="{$root}Images/risque/shim_bleu.gif" width="635" height="1" vspace="8" alt=""/>
      </xsl:if>
    </xsl:if>
  </xsl:template>

  <!--FONCTION DE DIRECTION DE l'ENTITE  INTERROGE-->
  <xsl:template match="//DIFF58/DIRECTIONS/DIRECTION58" mode="direction1">
    <Div class="blocVert arrondi tailleBloc " >
      <xsl:apply-templates select="."/>
    </Div>
  </xsl:template>

  <!-- REPRESENTANTS LEGAUX-->
  <xsl:template match="DIFF58/REPLEGAUX/REPLEGAL" mode="direction2">
    <xsl:variable name="preced" select="preceding-sibling::*"/>
    <xsl:if test="not($preced/PP/IDENTC=PP/IDENTC or $preced/EJ/IDENTS=EJ/IDENTS)">
      <!--<td height="95" width="138" align="center" class="clValignTop">-->
     <td class="clAlignCenter clValignTop">
        <xsl:if test="count(DIRECTIONS)>0">
          <xsl:apply-templates select="DIRECTIONS/DIRECTION58" mode="direction2"/>
        </xsl:if>
        <xsl:if test="count(DIRECTIONS)=0">
          &#160;
        </xsl:if>
      </td>
    </xsl:if>
  </xsl:template>

  <!--FONCTION DE DIRECTION DES REPRESENTANTS LEGAUX-->
  <xsl:template match="DIRECTIONS/DIRECTION58" mode="direction2">
    <Div class="blocBleu arrondi tailleBloc " >
      <xsl:apply-templates select="."/>
    </Div>
  </xsl:template>


  <!--template dans cadre-->
  <xsl:template match="REPLEGAL|DIRECTION58">
    <xsl:variable name="from">'</xsl:variable>
    <xsl:variable name="to">&#146;</xsl:variable>
    <xsl:variable name="lib_fonct"  select="name(FONCTCOT/*[position()=1])"/>
    <xsl:variable name="Libfonction" select="translate($dictionnaire/mot[@id=$lib_fonct],$from,$to)"/>
    <xsl:variable name="Code_fonct"  select="substring(name(FONCTCOT/*[1]),3)"/>
    <!-- affichage fonction et date si renseignée -->
    <div class="clTexteGrey clAlignCenter">
      <span class="infobulle" aria-label="{$Libfonction}">
        <xsl:value-of select="$Code_fonct"/>
      </span>
      <xsl:if test="FONCTCOT/DATFONCT">
        &#160;le <xsl:call-template name ="displayDateOrg2">
          <xsl:with-param name ="InputDateOrg" select ="FONCTCOT/DATFONCT"/>
        </xsl:call-template>
      </xsl:if>
    </div>

    <!-- affichage denom ou nom prénom selon le cas 
          taille variable du bloc-->
    <xsl:if test="EJ/DENOM">
      <p class="clTexteGras tailleDenom">
        <xsl:call-template name ="displayDenomTronqueeV2">
          <xsl:with-param name ="Denom" select ="EJ/DENOM"/>
        </xsl:call-template>
      </p>
    </xsl:if>
    <xsl:if test="PP">
      <xsl:apply-templates select="PP" mode="display2lignes"/>
    </xsl:if>


    <!--  affichage lien siren ou clef , lien en dessous et cotation -->
    <!--<xsl:apply-templates select="EJ/IDENTS|EI58|IDENTS|PP/IDENTC" mode="LienMultiple"/>-->
    <xsl:variable name ="valcot" select="FONCTCOT/VALCOT"/>
    <xsl:if test ="FONCTCOT/SEGMENT">
      <xsl:apply-templates select="EJ/IDENTS|EI58|IDENTS|PP/IDENTC" mode="LienMultipleSegment"/>
     <div class="clAlignCenter clTexteGrey">
        <xsl:value-of select="FONCTCOT/VALCOT"/>&#160;|&#160;<xsl:value-of select="FONCTCOT/SEGMENT"/>
      </div>
    </xsl:if>
    <xsl:if test="not(FONCTCOT/SEGMENT)">
      <xsl:apply-templates select="EJ/IDENTS|EI58|IDENTS|PP/IDENTC" mode="LienMultiple"/>
     <div class="clAlignCenter clTexteGrey">
        <xsl:value-of select="FONCTCOT/VALCOT"/>
      </div>
    </xsl:if>
  </xsl:template>

  <xsl:template match="DIRECTIONS/SUITE">
    <xsl:if test="position()=1">
      <xsl:text disable-output-escaping="yes">
			&lt;table width=&quot;635&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;
				&lt;tr&gt;&lt;td width=&quot;100%&quot;class=&quot;clItalic&quot; height=&quot;2&quot;&gt;
		</xsl:text>
      Les entités suivantes comportent plus que les 50 fonctions de direction affichées. Pour obtenir la liste complète, cliquez sur l'identifiant afin de générer le module correspondant : "56 - Fonctions de direction" :
    </xsl:if>

    <xsl:if test="position()!=last()">
      <xsl:apply-templates select="../.." mode="displaySirenForSuite"/>
    </xsl:if>
    <xsl:if test="position()=last()">
      <xsl:variable name="preced" select="preceding-sibling::*"/>
      <xsl:apply-templates select="../.." mode="displaySirenForSuite"/>

      <xsl:text disable-output-escaping="yes">	&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;
		</xsl:text>
      <img src="{$root}Images/risque/shim_bleu.gif" width="635" height="1" vspace="8" alt=""/>
    </xsl:if>
  </xsl:template>

  <xsl:template match="DIFF58" mode="displaySirenForSuite">
    <xsl:variable name="preced" select="preceding-sibling::*"/>
    <xsl:if test="not($preced/EJ/IDENTS=EJ/IDENTS)">
      <a href="#nullepart" onclick="requestBDFInfos('56','','1','{../EJ/IDENTS}',false,false,this)" class="clItalic">
        <u>
          <xsl:call-template name ="displaySirenXsl">
            <xsl:with-param name ="InputSiren" select ="(../EJ/IDENTS)"/>
          </xsl:call-template>
        </u> -
      </a>
    </xsl:if>
  </xsl:template>

  <xsl:template match="DIRECTION58" mode="displaySirenForSuite">
    <xsl:variable name="preced" select="preceding-sibling::*"/>
    <xsl:if test="not($preced/EJ/IDENTS=EJ/IDENTS)">
      <a href="#nullepart" onclick="requestBDFInfos('56','','1','{../EJ/IDENTS}',false,false,this)" class="clItalic">
        <u>
          <xsl:call-template name ="displaySirenXsl">
            <xsl:with-param name ="InputSiren" select ="(../EJ/IDENTS)"/>
          </xsl:call-template>
        </u> -
      </a>
    </xsl:if>
  </xsl:template>

  <xsl:template match="REPLEGAL" mode="displaySirenForSuite">
    <xsl:if test="EJ">
      <xsl:variable name="preced" select="preceding-sibling::*"/>
      <xsl:if test="not($preced/EJ/IDENTS=EJ/IDENTS)">
        <a href="#nullepart" onclick="requestBDFInfos('56','','1','{EJ/IDENTS}',false,false,this)" class="clItalic">
          <u>
            <xsl:call-template name ="displaySirenXsl">
              <xsl:with-param name ="InputSiren" select ="(EJ/IDENTS)"/>
            </xsl:call-template>
          </u> -
        </a>
      </xsl:if>
    </xsl:if>
    <xsl:if test="PP">
      <xsl:variable name="preced" select="preceding-sibling::*"/>
      <xsl:if test="not($preced/PP/IDENTC=PP/IDENTC)">
        <a href="#nullepart" onclick="requestBDFInfos('56','','1','{PP/IDENTC}',false,false,this)" class="clItalic">
          <u>
            <xsl:value-of select="PP/IDENTC"/>
          </u> -
        </a>
      </xsl:if>
    </xsl:if>
  </xsl:template>

  <xsl:template match="REPLEGAUX/SUITE">
    <table class="clWidth635 clBorderCell">
      <tr>
       <td class="clItalic clWidthMax clHeight2">
          D'autres dirigeants sont disponibles. Vous pouvez les consulter en générant le module <a href="#nullepart" onclick="requestBDFInfos('51','','1','{//MODULE58/EJ/IDENTS}',false,false,this)" class="clItalic">
            <u>51</u>
          </a> : Dirigeants de l'entreprise
        </td>
      </tr>
      <tr>
        <td class="clWidthMax">
          <img src="{$root}Images/risque/shim_bleu.gif" width="635" height="1" vspace="8" alt=""/>
        </td>
      </tr>
    </table>
  </xsl:template>

</xsl:stylesheet>