<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
					              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
					              xmlns:bdf="http://banque-france.fr/namespace">
  <xsl:import href="../../Ressources/XSL/Commun.xsl"/>
  <xsl:import href="../../Ressources/XSL/commun_transfo.xsl"/>
  <xsl:import href="../../Ressources/XSL/Commun_orga.xsl"/>
  <xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes" />
  <xsl:param name="langage" select="'fr'"/>
  <xsl:param name="familyName" select="''"/>
  <xsl:param name="root" select="'/Fiben/'"/>
  <xsl:param name="familyNumber" select="''"/>
  <xsl:param name="familyTitle" select="''"/>
  <xsl:param name="nextModule" select="''"/>
  <xsl:param name="nextId" select="''"/>
  <xsl:param name="nextFamily" select="''"/>
   <xsl:param name="Lang" select="'FR'"/>
  <xsl:param name="NonResident" select="''"/>
  <xsl:param name="menuHTML1"/>
  <xsl:variable name="condGraph1" select="count(//DIFF57/ASSOCEJ57|//DIFF57/ASSOCSPE57|//DIFF57/ASSOCPP57)>1"/>

  <xsl:param name="maxAssocDAssoc" select="0"/>
  <xsl:param name="maxParticipations" select="0"/>

  <xsl:param name="nbAssoc" select="count(//DIFF57/ASSOCEJ57|//DIFF57/ASSOCPP57|//DIFF57/ASSOCSPE57)"/>
  <xsl:param name="nbFiliales" select="count(//DIFF57/PARTICIPATION57)"/>
  <!--<xsl:variable name="condImprime" select="(10>$nbAssoc and $nbAssoc>0) and not(($maxAssocDAssoc>9 and 6>$nbAssoc) or ($maxAssocDAssoc>5 and $nbAssoc>5))"/>-->
  <xsl:variable name="condImprime" select="0"/>
  <xsl:param name="condNavig" select="0"/>

  <xsl:template match="/">
    <html lang="fr">
      <title>Module 57 - Organigramme liens financiers</title>
      <xsl:call-template name="genHead">
        <xsl:with-param name="ident" select="FIBEN/ERREUR/IDENT | FIBEN/PERSONNE/MODULE57/EJ/IDENTS"/>
      </xsl:call-template>
      <body class="clBodybgcolorWhite">
        <xsl:call-template name="genFondMenu">
          <xsl:with-param name="root" select="$root"/>
        </xsl:call-template>
        <xsl:copy-of select="$menuHTML1"/>

        <table class="mainmodule horizontal-auto clBorderCell">
          <caption class="visually-hidden">Module 57 - Organigramme liens financiers</caption>
          <xsl:call-template name="genLigneConfidentiel" />
          <xsl:apply-templates select="/FIBEN/ERREUR"/>
          <xsl:if test="not(/FIBEN/ERREUR)">
            <tr>
               <td class="clWidth64"></td>
              <td class="clCouleur2 clValignTop clWidth739" colspan="4">
                <xsl:apply-templates select="FIBEN/PERSONNE/MODULE57/EJ"/>
                <xsl:choose>
                  <xsl:when test ="FIBEN/PERSONNE/MODULE57/IEC01|FIBEN/PERSONNE/MODULE57/IST10|FIBEN/PERSONNE/MODULE57/IST53F|FIBEN/PERSONNE/MODULE57/IST53G">
                    <xsl:apply-templates select="FIBEN/PERSONNE/MODULE57/IEC01|FIBEN/PERSONNE/MODULE57/IST10|FIBEN/PERSONNE/MODULE57/IST53F|FIBEN/PERSONNE/MODULE57/IST53G" mode="genTable"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:call-template name="Entete57"  ></xsl:call-template>
                  </xsl:otherwise>
                </xsl:choose>
              </td>
            </tr>

          </xsl:if>
        </table>
        <!-- on sort l'organigramme du tableau principal pour risque de dcallage vers la gauche si beaucoup de colonnes -->
        <table class="horizontal-auto clBorderCell" role="presentation">
          <tr>
             <td class="clWidth64"></td>
            <td class="clCouleur2 clValignTop clWidth739" colspan="4">
              <xsl:apply-templates select="FIBEN/PERSONNE/MODULE57/DIFF57"/>
            </td>
          </tr>
        </table>
        <!-- on refait un tableau pour l'affichage SUITE, pour que ce soit centr sur la page -->
        <table class="horizontal-auto clBorderCell" role="presentation">
          <tr>
             <td class="clWidth64"></td>
            <td class="clCouleur2 clValignTop clWidth739" colspan="4">
              <xsl:if test ="not(FIBEN/PERSONNE/MODULE57/IEC01|FIBEN/PERSONNE/MODULE57/IST10|FIBEN/PERSONNE/MODULE57/IST53F|FIBEN/PERSONNE/MODULE57/IST53G)">
                <img src="{$root}Images/risque/shim_bleu.gif" width="635" height="1" vspace="8" alt=""/>
              </xsl:if>
              <xsl:apply-templates select="//SUITE"/>
            </td>
          </tr>
        </table>
        <xsl:call-template name="genBasPage"/>
        <xsl:call-template name="genGraph57"/>
      </body>
    </html>
  </xsl:template>

  <xsl:template match="FIBEN/PERSONNE/MODULE57/EJ">
    <!-- appel du template avec parametre segment  pas -->
    <xsl:choose>
      <xsl:when test ="../DIFF57/SEGMENT">
        <xsl:call-template name="genEnTete">
          <xsl:with-param name="ident" select="IDENTS"/>
          <xsl:with-param name="nom" select="DENOM"/>
          <xsl:with-param name="valcot" select="../DIFF57/VALCOT"/>
          <xsl:with-param name="segment" select="../DIFF57/SEGMENT"/>
          <xsl:with-param name="datcot" select="../DIFF57/DATCOT"/>
          <xsl:with-param name="datexa" select="../DIFF57/DATEXA"/>
          <xsl:with-param name="dateseg" select="../DIFF57/DATESEG"/>
          <xsl:with-param name="datsegrv" select="../DIFF57/DATSEGRV"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="genEnTete">
          <xsl:with-param name="ident" select="IDENTS"/>
          <xsl:with-param name="nom" select="DENOM"/>
          <xsl:with-param name="valcot" select="../DIFF57/VALCOT"/>
          <xsl:with-param name="datcot" select="../DIFF57/DATCOT"/>
          <xsl:with-param name="datexa" select="../DIFF57/DATEXA"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="IEC01|IST10|IST53F|IST53G" mode="genTable">
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
        <td class="clWidth14"></td>
        <td class="clCouleur2 clValignTop">
          <xsl:apply-templates select="."/>
        </td>
      </tr>
      <tr>
        <td class="clWidth14"></td>
        <td>
          <xsl:call-template name="shim"/>
        </td>
      </tr>
    </table>
  </xsl:template>

  <!--ORGANIGRAMME-->
  <xsl:template name="Entete57">
    <!-- dbut criture organigramme -->
   <table class="clBorderCell" role="presentation">
     <caption class="visually-hidden">Organigramme liens financiers</caption>
     <tr>
        <td class="clCouleurGras clWidth605 clAlignCenter">
          ORGANIGRAMME AU <xsl:call-template name ="displayDateJourXsl">
            <xsl:with-param name ="InputDate" select ="(/FIBEN/@DATJOUR)"/>
          </xsl:call-template>
        </td>
      </tr>
      <tr>
        <td>
          <xsl:call-template name="shim"/>
        </td>
      </tr>
      <tr>
        <td class="clWidth605 clHeight30">
          <span class="legendeOvale"  >&#160;...&#160;</span>
          <span class="clTexteLegende">&#160;Entit interroge&#160;</span>
          <span  class="blocRouge legende" >&#160;...&#160;</span>
          <span class="clTexteLegende">&#160;Associs</span>
          <xsl:if test="count(//ASSOCEJ57/ASSOCEJ57|//ASSOCEJ57/ASSOCPP57|//ASSOCEJ57/ASSOCSPE57)>0">
            <span class="blocOrange legende" >&#160;...&#160;</span>
            <span class="clTexteLegende">&#160;Associs principaux d'associs</span>
          </xsl:if>
          <xsl:if test="//ASSOCEJ57/PARTICIPATION57">
            <span class="blocBleu legende" >&#160;...&#160;</span>
            <span class="clTexteLegende">&#160;Socits soeurs</span>
          </xsl:if>
          <xsl:if test="//DIFF57/PARTICIPATION57">
            <span class="blocVert legende" >&#160;...&#160;</span>
            <span class="clTexteLegende">&#160;Filiales</span>
          </xsl:if>

        </td>
      </tr>
      <tr>
        <td>
          <xsl:call-template name="shim"/>
        </td>
      </tr>
    </table>
  </xsl:template>
  
  <xsl:template match="DIFF57">
    <div class="clBreakPage"/>

    <!-- table principale pour les blocs de l'organigramme -->
   <table class="clBorderCell">
      <xsl:if test="count(ASSOCEJ57/ASSOCEJ57|ASSOCEJ57/ASSOCPP57|ASSOCEJ57/ASSOCSPE57)>0">
        <tr>
          <td class="clWidth5">&#160;</td>
          <td>&#160;</td>
          <!-- afficher les blocs jaunes : associs principaux d'associs (ajoute des TD)-->
          <xsl:apply-templates select="//DIFF57/ASSOCEJ57|//DIFF57/ASSOCPP57|//DIFF57/ASSOCSPE57" mode="ASSOC2"/>
        </tr>
      </xsl:if>
      <tr>
        <td>&#160;</td>
         <td class="clAlignRight">
          <xsl:if test="$condGraph1">
            <a href="#nullepart" onclick="window.document.forms['FormGraphes'].action='Graphes.aspx#Graphe1';window.document.forms	['FormGraphes'].submit();">
              <img title="Graphique" alt="Graphique" border="0" height="20" name="dia2" src="{$root}Images/risque/diagramme_bleu.gif" width="19"/>
            </a>
          </xsl:if>
          <xsl:if test="not($condGraph1)">
            <img src="{$root}Images/boutons/diagramme_in.gif" width="19" height="20" border="0" title="Graphique" alt="Graphique" />
          </xsl:if>
        </td>
        <xsl:apply-templates select="//DIFF57/ASSOCEJ57|//DIFF57/ASSOCPP57|//DIFF57/ASSOCSPE57" mode="FlecheAssoc2"/>
      </tr>
      <tr>
         <td class="clAlignRight">&#160;</td>
        <td class="clAlignCenter clValignBottom">
          <img src="{$root}Images/Commun/org_gde_fleche_red.gif" width="138" height="72" />
        </td>
        <!-- afficher les blocs rouges : Associs (ajoute des TD)-->
        <xsl:apply-templates select="//DIFF57/ASSOCEJ57|//DIFF57/ASSOCPP57|//DIFF57/ASSOCSPE57" mode="ASSOC1"/>
      </tr>
      <tr>
        <td>&#160;</td>
        <td>&#160;</td>
        <xsl:apply-templates select="//DIFF57/ASSOCEJ57|//DIFF57/ASSOCPP57|//DIFF57/ASSOCSPE57" mode="FlecheParticip2"/>
      </tr>
      <tr>
        <td rowspan="2">&#160;</td>
       <td rowspan="2" class="clAlignCenter clValignTop">
          <!-- nouvelle presentation elipse en css -->
          <div class="ovaleBleu " >
            <p class="texteOrg">
              <xsl:call-template name ="displayDenomTronquee">
                <xsl:with-param name ="Denom" select ="//MODULE57/EJ/DENOM"/>
              </xsl:call-template>
            </p>
          </div>
          <!-- fin elipse bleue -->
          <xsl:if test="//DIFF57/PARTICIPATION57">
            <table class="clBorderCell clWidth139 ">
              <tr>
                 <td class="clAlignCenter">
                  <img width="15" height="8" src="/FIBEN/Images/Commun/org_fleche_red.gif" style="padding:5px;" />
                </td>
              </tr>
              <tr>
               <td class="clAlignCenter clValignTop">
                  <!--afficher les blocs verts : (filliales)-->
                  <xsl:apply-templates select="//DIFF57/PARTICIPATION57" mode="PARTICIP1"/>
                </td>
              </tr>
            </table>
          </xsl:if>
        </td>
        <xsl:if test="//ASSOCEJ57/PARTICIPATION57">
          <!-- afficher les ventuels blocs bleus : Participations des Associs (ajoute des TD)-->
          <xsl:apply-templates select="//DIFF57/ASSOCEJ57|//DIFF57/ASSOCPP57|//DIFF57/ASSOCSPE57" mode="PARTICIP2"/>
        </xsl:if>
      </tr>
    </table>
  </xsl:template>

  <!--PARTICIPATION DE l'ENTITE  INTERROGE (filliales)-->
  <xsl:template match="PARTICIPATION57" mode="PARTICIP1">
    <Div class="blocVert arrondi tailleBloc " >
      <xsl:apply-templates select="."/>
    </Div>
  </xsl:template>

  <!--ASSOCIE DE L'ENTITE INTERROGE-->
  <xsl:template match="DIFF57/ASSOCEJ57|DIFF57/ASSOCPP57|DIFF57/ASSOCSPE57" mode="ASSOC1">
    <td >
      <Div class="blocRouge arrondi tailleBloc " >
        <xsl:apply-templates select="."/>
      </Div>
    </td>
  </xsl:template>

  <!--ASSOCIE DES ASSOCIES-->

  <!--<xsl:template match="DIFF57/ASSOCPP57|DIFF57/ASSOCSPE57" mode="ASSOC2">
	-->
  <!--<td >&#160;</td>-->
  <!--
</xsl:template>-->

  <xsl:template match="DIFF57/ASSOCEJ57" mode="ASSOC2">
    <!--<td >-->
    <xsl:if test="count(ASSOCEJ57|ASSOCPP57|ASSOCSPE57)>0">
      <!--<table border="0" cellpadding="2" cellspacing="0">-->
      <xsl:apply-templates select="ASSOCEJ57|ASSOCPP57|ASSOCSPE57" mode="ASSOC2"/>
      <!--</table>-->
    </xsl:if>
    <xsl:if test="count(ASSOCEJ57|ASSOCPP57|ASSOCSPE57)=0">
      &#160;
    </xsl:if>
    <!--</td>-->
  </xsl:template>

  <xsl:template match="ASSOCEJ57|ASSOCPP57|ASSOCSPE57" mode="ASSOC2">
    <!--<tr>-->
    <td>
      <Div class="blocOrange arrondi tailleBloc " >
        <xsl:apply-templates select="."/>
      </Div>
    </td>
    <!-- </tr>-->
  </xsl:template>

  <!--PARTICIPATIONS DES ASSOCIES-->
  <xsl:template match="DIFF57/ASSOCPP57|DIFF57/ASSOCSPE57" mode="PARTICIP2">
    <td >&#160;</td>
  </xsl:template>

  <xsl:template match="DIFF57/ASSOCEJ57" mode="PARTICIP2">
    <td class="clAlignCenter clValignTop">
      <xsl:if test="count(PARTICIPATION57)>0">
        <!--<table border="0" cellpadding="2" cellspacing="0">-->
        <xsl:apply-templates select="PARTICIPATION57" mode="PARTICIP2"/>
        <!--</table>-->
      </xsl:if>
      <xsl:if test="count(PARTICIPATION57)=0">
        &#160;
      </xsl:if>
    </td>
  </xsl:template>

  <xsl:template match="PARTICIPATION57" mode="PARTICIP2">
    <!--<tr>
      <td>-->
    <Div class="blocBleu arrondi tailleBloc " >
      <xsl:apply-templates select="."/>
    </Div>
    <!--</td>
    </tr>-->
  </xsl:template>

  <!--FLECHE ASSOCIES des ASSOCIES / ASSOCIES / PARTICIPATIONS des ASSOCIES-->

  <xsl:template match="DIFF57/ASSOCEJ57|DIFF57/ASSOCPP57|DIFF57/ASSOCSPE57" mode="FlecheAssoc2">
    <xsl:if test="count(ASSOCEJ57|ASSOCPP57|ASSOCSPE57)>0">
       <td class="clAlignCenter">
        <img src="{$root}Images/Commun/org_fleche_red.gif" width="15" height="8" />
      </td>
    </xsl:if>
    <xsl:if test="count(ASSOCEJ57|ASSOCPP57|ASSOCSPE57)=0">
       <td class="clAlignCenter">&#160;</td>
    </xsl:if>
  </xsl:template>

  <xsl:template match="DIFF57/ASSOCEJ57|DIFF57/ASSOCPP57|DIFF57/ASSOCSPE57" mode="FlecheParticip2">
    <xsl:if test="count(PARTICIPATION57)>0">
       <td class="clAlignCenter">
        <img src="{$root}Images/Commun/org_fleche_red.gif" width="15" height="8" />
      </td>
    </xsl:if>
    <xsl:if test="count(PARTICIPATION57)=0">
       <td class="clAlignCenter">&#160;</td>
    </xsl:if>
  </xsl:template>

  <!--    template dans cadre     -->
  <xsl:template match="PARTICIPATION57">
    <p class="clTexteGras tailleDenom">
      <xsl:call-template name ="displayDenomTronqueeV2">
        <xsl:with-param name ="Denom" select ="EJ/DENOM"/>
      </xsl:call-template>
    </p>
    <!--<xsl:apply-templates select="EJ/IDENTS" mode="LienMultiple"/>-->
    <xsl:apply-templates select="CAPITAL"/>

    <xsl:if test ="not(SEGMENT)">
      <xsl:apply-templates select="EJ/IDENTS" mode="LienMultiple"/>      
     <div class="clAlignCenter clTexteGrey">
        <xsl:value-of select="VALCOT"/>
      </div>      
    </xsl:if>
    <xsl:if test ="SEGMENT">
      <xsl:apply-templates select="EJ/IDENTS" mode="LienMultipleSegment"/>      
     <div class="clAlignCenter clTexteGrey">
        <xsl:value-of select="VALCOT"/>&#160;|&#160;<xsl:value-of select="SEGMENT"/>
      </div>     
    </xsl:if>
  </xsl:template>

  <xsl:template match="ASSOCEJ57">
    <p class="clTexteGras tailleDenom">
      <xsl:call-template name ="displayDenomTronqueeV2">
        <xsl:with-param name ="Denom" select ="EJ/DENOM"/>
      </xsl:call-template>
    </p>    
    <xsl:apply-templates select="CAPITAL"/>
    <xsl:if test ="not(SEGMENT)">
      <xsl:apply-templates select="EJ/IDENTS" mode="LienMultiple"/>      
     <div class="clAlignCenter clTexteGrey">
        <xsl:value-of select="VALCOT"/>
      </div>      
    </xsl:if>
    <xsl:if test ="SEGMENT">
      <xsl:apply-templates select="EJ/IDENTS" mode="LienMultipleSegment"/>      
     <div class="clAlignCenter clTexteGrey">
        <xsl:value-of select="VALCOT"/>&#160;|&#160;<xsl:value-of select="SEGMENT"/>
      </div>      
    </xsl:if>
  </xsl:template>

  <xsl:template match="ASSOCPP57">
    <xsl:apply-templates select="PP" mode="display2lignes"/>
    <xsl:apply-templates select="PP/IDENTC" mode="LienMultiple">
      <xsl:with-param name ="valcot" select ="VALCOT"></xsl:with-param>
    </xsl:apply-templates>
    <xsl:apply-templates select="CAPITAL"/>
    <xsl:if test="not(VALCOT='NS')">
     <div class="clAlignCenter clTexteGrey">
        <xsl:value-of select="VALCOT"/>
      </div>
    </xsl:if>
  </xsl:template>

  <xsl:template match="ASSOCSPE57">
    <p class="clTexteGras tailleDenom">
      <xsl:call-template name ="displayDenomTronqueeV2">
        <xsl:with-param name ="Denom" select ="DENOM"/>
      </xsl:call-template>
    </p>
    <xsl:apply-templates select="CAPITAL"/>

  </xsl:template>

  <xsl:template match="CAPITAL">
    <div class="clOrgTexteCapital clAlignCenter">
      <xsl:value-of select="POURCENTAGE"/>%
      <xsl:if test="DATDET">
        au <xsl:call-template name ="displayDateOrg2">
          <xsl:with-param name ="InputDateOrg" select ="DATDET"/>
        </xsl:call-template>

      </xsl:if>
    </div>
  </xsl:template>

  <!--SUITE-->

  <xsl:template match="SUITE">
    <xsl:if test="position()=1">
      <xsl:text disable-output-escaping="yes">
			&lt;table width=&quot;635&quot; border=&quot;0&quot; cellspacing=&quot;1&quot; cellpadding=&quot;0&quot;&gt;
				&lt;tr&gt;
					&lt;td width=&quot;635&quot; class=&quot;clItalic&quot; height=&quot;2&quot;&gt;
		</xsl:text>
      Les entits suivantes comportent plus que les 50 fililales affiches. Pour obtenir la liste complte, cliquez sur l'identifiant afin de gnrer le module correspondant : "53 - Associs et Participations" :
    </xsl:if>
    <xsl:if test="position()!=last()">
      <xsl:apply-templates select=".." mode="displaySirenForSuite"/> -
    </xsl:if>
    <xsl:if test="position()=last()">
      <xsl:apply-templates select=".." mode="displaySirenForSuite"/>
      <xsl:text disable-output-escaping="yes">
					&lt;/td&gt;
				&lt;/tr&gt;
			&lt;/table&gt;
		</xsl:text>
      <img src="{$root}Images/risque/shim_bleu.gif" width="635" height="1" vspace="8" alt=""/>
      <br />
      <br />
    </xsl:if>
  </xsl:template>

  <xsl:template match="DIFF57" mode="displaySirenForSuite">
    <a href="#nullepart" onclick="requestBDFInfos('53','','{$familyNumber}','{../EJ/IDENTS}',false,false,this)" class="clItalic">
      <u>
        <xsl:call-template name ="displaySirenXsl">
          <xsl:with-param name ="InputSiren" select ="(../EJ/IDENTS)"/>
        </xsl:call-template>
      </u>
    </a>
  </xsl:template>

  <xsl:template match="ASSOCEJ57" mode="displaySirenForSuite">
    <a href="#nullepart" onclick="requestBDFInfos('53','','{$familyNumber}','{EJ/IDENTS}',false,false,this)" class="clItalic">
      <u>
        <xsl:call-template name ="displaySirenXsl">
          <xsl:with-param name ="InputSiren" select ="(EJ/IDENTS)"/>
        </xsl:call-template>
      </u>
    </a>
  </xsl:template>

  <xsl:template match="EJ/IDENTS" mode="LienMultiple">
    <div class="clAlignCenter">
      <xsl:if test="../../VALCOT">
        <!--PARTICIPATION DE L'ENTITE ; niveau n-1-->
        <xsl:if test="name(../..)='PARTICIPATION57' and name(../../..)='DIFF57'">
          <a href="#nullepart" onclick="requestBDFInfos('27|37|53|','','{$familyNumber}','{.}',cstMultipleConfirm)" class="clOrgBoldlien">
            <xsl:call-template name ="displaySirenXsl">
              <xsl:with-param name ="InputSiren" select ="(.)"/>
            </xsl:call-template>
          </a>
        </xsl:if>
        <!--PARTICIPATION DES ASSOCIES ; niveau n-->
        <xsl:if test="name(../..)='PARTICIPATION57' and name(../../..)='ASSOCEJ57'">
          <a href="#nullepart" onclick="requestBDFInfos('27|37|53|','','{$familyNumber}','{.}',cstMultipleConfirm)" class="clOrgBoldlien">
            <xsl:call-template name ="displaySirenXsl">
              <xsl:with-param name ="InputSiren" select ="(.)"/>
            </xsl:call-template>
          </a>
        </xsl:if>
        <!--ASSOCIE d'ASSOCIE ; niveau n+2-->
        <xsl:if test="name(../..)='ASSOCEJ57' and name(../../..)='ASSOCEJ57'">
          <a href="#nullepart" onclick="requestBDFInfos('27|37|53|','','{$familyNumber}','{.}',cstMultipleConfirm)" class="clOrgBoldlien">
            <xsl:call-template name ="displaySirenXsl">
              <xsl:with-param name ="InputSiren" select ="(.)"/>
            </xsl:call-template>
          </a>
        </xsl:if>
        <!--ASSOCIE de L'ENTITE INTERROGE ; niveau n+1-->
        <xsl:if test="name(../..)='ASSOCEJ57' and name(../../..)='DIFF57'">
          <xsl:if test="../../PARTICIPATION57 and (../../ASSOCEJ57|../../ASSOCPP57|../../ASSOCSPE57)">
            <a href="#nullepart" onclick="requestBDFInfos('27|37|53|57|','','{$familyNumber}','{.}',cstMultipleConfirm)" class="clOrgBoldlien">
              <xsl:call-template name ="displaySirenXsl">
                <xsl:with-param name ="InputSiren" select ="(.)"/>
              </xsl:call-template>
            </a>
          </xsl:if>
          <xsl:if test="not(../../PARTICIPATION57) and (../../ASSOCEJ57|../../ASSOCPP57|../../ASSOCSPE57)">
            <a href="#nullepart" onclick="requestBDFInfos('27|37|53|','','{$familyNumber}','{.}',cstMultipleConfirm)" class="clOrgBoldlien">
              <xsl:call-template name ="displaySirenXsl">
                <xsl:with-param name ="InputSiren" select ="(.)"/>
              </xsl:call-template>
            </a>
          </xsl:if>
          <xsl:if test="../../PARTICIPATION57 and not(../../ASSOCEJ57|../../ASSOCPP57|../../ASSOCSPE57)">
            <a href="#nullepart" onclick="requestBDFInfos('27|37|','','{$familyNumber}','{.}',cstMultipleConfirm)" class="clOrgBoldlien">
              <xsl:call-template name ="displaySirenXsl">
                <xsl:with-param name ="InputSiren" select ="(.)"/>
              </xsl:call-template>
            </a>
          </xsl:if>
          <xsl:if test="not(../../PARTICIPATION57) and not(../../ASSOCEJ57|../../ASSOCPP57|../../ASSOCSPE57)">
            <a href="#nullepart" onclick="requestBDFInfos('27|37|','','{$familyNumber}','{.}',cstMultipleConfirm)" class="clOrgBoldlien">
              <xsl:call-template name ="displaySirenXsl">
                <xsl:with-param name ="InputSiren" select ="(.)"/>
              </xsl:call-template>
            </a>
          </xsl:if>
        </xsl:if>
      </xsl:if>
      <xsl:if test="not(../../VALCOT)">
        <div class="clOrgBold">
          <xsl:call-template name ="displaySirenXsl">
            <xsl:with-param name ="InputSiren" select ="(.)"/>
          </xsl:call-template>
        </div>
      </xsl:if>
    </div>
  </xsl:template>
  <xsl:template match="EJ/IDENTS" mode="LienMultipleSegment">
    <div class="clAlignCenter">
      <xsl:if test="../../VALCOT">
        <!--PARTICIPATION DE L'ENTITE ; niveau n-1-->
        <xsl:if test="name(../..)='PARTICIPATION57' and name(../../..)='DIFF57'">
          <a href="#nullepart" onclick="requestBDFInfos('27|37|39|53|','','{$familyNumber}','{.}',cstMultipleConfirm)" class="clOrgBoldlien">
            <xsl:call-template name ="displaySirenXsl">
              <xsl:with-param name ="InputSiren" select ="(.)"/>
            </xsl:call-template>
          </a>
        </xsl:if>
        <!--PARTICIPATION DES ASSOCIES ; niveau n-->
        <xsl:if test="name(../..)='PARTICIPATION57' and name(../../..)='ASSOCEJ57'">
          <a href="#nullepart" onclick="requestBDFInfos('27|37|39|53|','','{$familyNumber}','{.}',cstMultipleConfirm)" class="clOrgBoldlien">
            <xsl:call-template name ="displaySirenXsl">
              <xsl:with-param name ="InputSiren" select ="(.)"/>
            </xsl:call-template>
          </a>
        </xsl:if>
        <!--ASSOCIE d'ASSOCIE ; niveau n+2-->
        <xsl:if test="name(../..)='ASSOCEJ57' and name(../../..)='ASSOCEJ57'">
          <a href="#nullepart" onclick="requestBDFInfos('27|37|39|53|','','{$familyNumber}','{.}',cstMultipleConfirm)" class="clOrgBoldlien">
            <xsl:call-template name ="displaySirenXsl">
              <xsl:with-param name ="InputSiren" select ="(.)"/>
            </xsl:call-template>
          </a>
        </xsl:if>
        <!--ASSOCIE de L'ENTITE INTERROGE ; niveau n+1-->
        <xsl:if test="name(../..)='ASSOCEJ57' and name(../../..)='DIFF57'">
          <xsl:if test="../../PARTICIPATION57 and (../../ASSOCEJ57|../../ASSOCPP57|../../ASSOCSPE57)">
            <a href="#nullepart" onclick="requestBDFInfos('27|37|39|53|57|','','{$familyNumber}','{.}',cstMultipleConfirm)" class="clOrgBoldlien">
              <xsl:call-template name ="displaySirenXsl">
                <xsl:with-param name ="InputSiren" select ="(.)"/>
              </xsl:call-template>
            </a>
          </xsl:if>
          <xsl:if test="not(../../PARTICIPATION57) and (../../ASSOCEJ57|../../ASSOCPP57|../../ASSOCSPE57)">
            <a href="#nullepart" onclick="requestBDFInfos('27|37|39|53|','','{$familyNumber}','{.}',cstMultipleConfirm)" class="clOrgBoldlien">
              <xsl:call-template name ="displaySirenXsl">
                <xsl:with-param name ="InputSiren" select ="(.)"/>
              </xsl:call-template>
            </a>
          </xsl:if>
          <xsl:if test="../../PARTICIPATION57 and not(../../ASSOCEJ57|../../ASSOCPP57|../../ASSOCSPE57)">
            <a href="#nullepart" onclick="requestBDFInfos('27|37|39|','','{$familyNumber}','{.}',cstMultipleConfirm)" class="clOrgBoldlien">
              <xsl:call-template name ="displaySirenXsl">
                <xsl:with-param name ="InputSiren" select ="(.)"/>
              </xsl:call-template>
            </a>
          </xsl:if>
          <xsl:if test="not(../../PARTICIPATION57) and not(../../ASSOCEJ57|../../ASSOCPP57|../../ASSOCSPE57)">
            <a href="#nullepart" onclick="requestBDFInfos('27|37|39|','','{$familyNumber}','{.}',cstMultipleConfirm)" class="clOrgBoldlien">
              <xsl:call-template name ="displaySirenXsl">
                <xsl:with-param name ="InputSiren" select ="(.)"/>
              </xsl:call-template>
            </a>
          </xsl:if>
        </xsl:if>
      </xsl:if>
      <xsl:if test="not(../../VALCOT)">
        <div class="clOrgBold">
          <xsl:call-template name ="displaySirenXsl">
            <xsl:with-param name ="InputSiren" select ="(.)"/>
          </xsl:call-template>
        </div>
      </xsl:if>
    </div>
  </xsl:template>

  <xsl:template match="PP/IDENTC" mode="LienMultiple">
    <xsl:param name ="valcot"></xsl:param>
    <div class="clAlignCenter">
      <!--ASSOCIE d'ASSOCIE ; niveau n+2-->
      <xsl:if test="name(../../..)='ASSOCEJ57'">
        <xsl:if test ="not($valcot='NS')">
          <a href="#nullepart" onclick="requestBDFInfos('27|37|53|','','{$familyNumber}','{.}',cstMultipleConfirm)" class="clOrgBoldlien">
            <xsl:value-of select="."/>
          </a>
        </xsl:if>
        <xsl:if test ="($valcot='NS')">
          <a href="#nullepart" onclick="requestBDFInfos('27|','','{$familyNumber}','{.}',cstMultipleConfirm)" class="clOrgBoldlien">
            <xsl:value-of select="."/>
          </a>
        </xsl:if>
      </xsl:if>
      <!--ASSOCIE de L'ENTITE INTERROGE ; niveau n+1-->
      <xsl:if test="name(../../..)='DIFF57'">
        <xsl:if test ="not($valcot='NS')">
          <a href="#nullepart" onclick="requestBDFInfos('27|37|','','{$familyNumber}','{.}',cstMultipleConfirm)" class="clOrgBoldlien">
            <xsl:value-of select="."/>
          </a>
        </xsl:if>
        <!--ASSOCIE NON RESIDENTS-->
        <xsl:if test ="($valcot='NS')">
          <a href="#nullepart" onclick="requestBDFInfos('27|','','{$familyNumber}','{.}',cstMultipleConfirm)" class="clOrgBoldlien">
            <xsl:value-of select="."/>
          </a>
        </xsl:if>
      </xsl:if>

    </div>
  </xsl:template>

  <xsl:template name="genGraph57">
    <xsl:if test="$condGraph1">
      <form action="Graphes.aspx" method="post" name="FormGraphes" target="_blank">
        <input name="familyNumber" type="hidden" value="{$familyNumber}"/>
        <input name="moduleNumber" type="hidden" value="{/FIBEN/@MODDEM}"/>
        <xsl:element name="input">
          <xsl:attribute name="name">GrapheData</xsl:attribute>
          <xsl:attribute name="type">hidden</xsl:attribute>
          <xsl:attribute name="value">
            &lt;FIBEN MODDEM=&quot;<xsl:value-of select="FIBEN/@MODDEM"/>&quot; DATJOUR=&quot;<xsl:call-template name ="displayDateForGraph2">
              <xsl:with-param name ="InputDateForGraph" select ="FIBEN/@DATJOUR"/>
            </xsl:call-template>&quot; GRAPHE=&quot;1&quot;&gt;&lt;ident&gt;<xsl:value-of select="FIBEN/PERSONNE/MODULE57/EJ/IDENTS"/>&lt;/ident&gt;&lt;nom&gt;<xsl:value-of select="FIBEN/PERSONNE/MODULE57/EJ/DENOM"/>&lt;/nom&gt;&lt;valcot&gt;<xsl:value-of select="FIBEN/PERSONNE/MODULE57/DIFF57/VALCOT"/>&lt;/valcot&gt;&lt;segment&gt;<xsl:value-of select="FIBEN/PERSONNE/MODULE57/DIFF57/SEGMENT"/>&lt;/segment&gt;&lt;datcot&gt;<xsl:value-of select="FIBEN/PERSONNE/MODULE57/DIFF57/DATCOT"/>&lt;/datcot&gt;&lt;datexa&gt;<xsl:value-of select="FIBEN/PERSONNE/MODULE57/DIFF57/DATEXA"/>&lt;/datexa&gt;&lt;graphe&gt;&lt;serie&gt;
            <xsl:for-each select="//DIFF57/ASSOCEJ57|//DIFF57/ASSOCSPE57|//DIFF57/ASSOCPP57">
              &lt;val&gt;<xsl:value-of select="CAPITAL/POURCENTAGE"/>&lt;/val&gt;
            </xsl:for-each>&lt;/serie&gt;&lt;abcisse&gt;<xsl:for-each select="//DIFF57/ASSOCEJ57|//DIFF57/ASSOCSPE57|//DIFF57/ASSOCPP57">
              &lt;val&gt;<xsl:value-of select="concat(EJ/IDENTS,DENOM,concat(PP/IDENTC,' ',PP/IDENTITE/NOM),EJ/DENOM,' ',PP/IDENTITE/PRENOM)"/>&lt;/val&gt;
            </xsl:for-each>&lt;/abcisse&gt;&lt;titre&gt;Rpartition du capital entre les associs (en pourcentage)&lt;/titre&gt;&lt;/graphe&gt;&lt;/FIBEN&gt;
          </xsl:attribute>
        </xsl:element>
      </form>
    </xsl:if>
  </xsl:template>


</xsl:stylesheet>
