<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:bdf="http://banque-france.fr/namespace">
	<xsl:import href="../../Ressources/XSL/Commun.xsl"/>
  <xsl:import href="../../Ressources/XSL/commun_transfo.xsl"/>
	<xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes"/>
	<xsl:param name="langage" select="'fr'"/>
	<xsl:param name="familyNumber" select="''"/>
  <xsl:param name="root" select="'/Fiben/'"/>
	<xsl:param name="familyName" select="''"/>
	<xsl:param name="familyTitle" select="''"/>
	<xsl:param name="nextModule" select="''"/>
	<xsl:param name="nextId" select="''"/>
	<xsl:param name="nextFamily" select="''"/>
   <xsl:param name="Lang" select="'FR'"/>
  <xsl:param name="NonResident" select="''"/>
	<xsl:param name="menuHTML1"/>
	
<xsl:template match="/">
		<html lang="fr">
      <title>Module 56 - Fonctions de direction</title>
			<xsl:call-template name="genHead">
				<xsl:with-param name="ident" select="FIBEN/ERREUR/IDENT | /FIBEN/PERSONNE/MODULE56/PM56/*/IDENTS|FIBEN/PERSONNE/MODULE56/PP/IDENTC"/>
			</xsl:call-template>
			<body class="clBodybgcolorWhite">
        <xsl:call-template name="genFondMenu">
          <xsl:with-param name="root" select="$root"/>
        </xsl:call-template>
        <xsl:copy-of select="$menuHTML1"/>
        
			<table class="mainmodule horizontal-auto clBorderCell">
        <caption class="visually-hidden">Module 56 - Fonctions de direction</caption>
				<xsl:call-template name="genLigneConfidentiel"/>
				<xsl:apply-templates select="/FIBEN/ERREUR"/>
				<xsl:if test="not(/FIBEN/ERREUR)">
					
					<tr> 
						 <td class="clWidth64"></td>
						<td class="clCouleur2 clValignTop clWidth739" colspan="4">
              <!-- appel du template avec parametre segment  pas -->
              <xsl:choose>
                <xsl:when test ="/FIBEN/PERSONNE/MODULE56/DIFF56/SEGMENT">
                  <xsl:call-template name="genEnTete">
                    <xsl:with-param name="ident" select="/FIBEN/PERSONNE/MODULE56/PM56/	*/IDENTS|FIBEN/PERSONNE/MODULE56/PP/IDENTC"/>
                    <xsl:with-param name="nom">
                      <xsl:if test ="/FIBEN/PERSONNE/MODULE56/PM56/EJ/DENOM">
                        <xsl:value-of select ="/FIBEN/PERSONNE/MODULE56/PM56/EJ/DENOM"/>
                      </xsl:if>
                      <xsl:if test ="//IDENTITE/NOM">
                        <xsl:call-template name ="displayInLowerCaseXsl">
                          <xsl:with-param name ="InputStringNom" select ="//IDENTITE/NOM"/>
                          <xsl:with-param name ="InputStringPrenom" select ="//IDENTITE/PRENOM"/>
                        </xsl:call-template>
                      </xsl:if>
                    </xsl:with-param>                    
                    <xsl:with-param name="nomconj" select="//IDENTITE/NOMCONJ"/>
                    <xsl:with-param name="valcot" select="/FIBEN/PERSONNE/MODULE56/DIFF56/VALCOT"/>
                    <xsl:with-param name="segment" select="/FIBEN/PERSONNE/MODULE56/DIFF56/SEGMENT"/>
                    <xsl:with-param name="idrenv" select="/FIBEN/PERSONNE/MODULE56/PM56/EI56/IDRENV"/>
                  </xsl:call-template>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:call-template name="genEnTete">
                    <xsl:with-param name="ident" select="/FIBEN/PERSONNE/MODULE56/PM56/	*/IDENTS|FIBEN/PERSONNE/MODULE56/PP/IDENTC"/>
                    <xsl:with-param name="nom">
                      <xsl:if test ="/FIBEN/PERSONNE/MODULE56/PM56/EJ/DENOM">
                        <xsl:value-of select ="/FIBEN/PERSONNE/MODULE56/PM56/EJ/DENOM"/>
                      </xsl:if>
                      
                      <xsl:if test ="//IDENTITE/NOM">
                        <xsl:call-template name ="displayInLowerCaseXsl">
                          <xsl:with-param name ="InputStringNom" select ="//IDENTITE/NOM"/>
                          <xsl:with-param name ="InputStringPrenom" select ="//IDENTITE/PRENOM"/>
                        </xsl:call-template>
                      </xsl:if>
                    </xsl:with-param>
                    <xsl:with-param name="nomconj" select="//IDENTITE/NOMCONJ"/>
                    <xsl:with-param name="valcot" select="/FIBEN/PERSONNE/MODULE56/DIFF56/VALCOT"/>
                    <xsl:with-param name="idrenv" select="/FIBEN/PERSONNE/MODULE56/PM56/EI56/IDRENV"/>
                  </xsl:call-template>
                </xsl:otherwise> 
              </xsl:choose> 
              
							
							<xsl:if test="/FIBEN/PERSONNE/MODULE56/IEC01|/FIBEN/PERSONNE/MODULE56/IST10|/FIBEN/PERSONNE/MODULE56/IST16">
								<table class="clWidth635 clBorderCell" role="presentation">
									<tr>
										<td class="clWidth14"></td>
										<td colspan="4" class="clCouleur2 clValignTop">
											<xsl:apply-templates select="/FIBEN/PERSONNE/MODULE56/IEC01|/FIBEN/PERSONNE/MODULE56/IST10|/FIBEN/PERSONNE/MODULE56/IST16"/>
										</td>
									</tr>
									<tr>
										<td class="clWidth14"></td>
										<td colspan="4"><xsl:call-template name="shim"/></td>
									</tr>
								</table>
							</xsl:if>
							<xsl:apply-templates select="/FIBEN/PERSONNE/MODULE56/DIFF56"/>
							<xsl:apply-templates select="//HOMONYME"/>
							<xsl:apply-templates select="//IDLIES"/>
						</td>
					</tr>
					

				</xsl:if>
			</table>
      <xsl:call-template name="genBasPage"/>
		</body>
	</html>
</xsl:template>
	
<xsl:template match="DIFF56">
	<xsl:if test="FONCTIONSACTIVES/NBFONCTION > 0">		
		<xsl:choose>	
			<xsl:when test="FONCTIONSACTIVES/NBFONCTOT > 700">
			<a name="ancActuelle"></a>
			<table class="clWidth635 clBorderCell" role="presentation">
			<tr class="clAlignCenter">
        <td class="clCouleurGras clHeight25">
          FONCTION(S) DE DIRECTION ACTUELLE(S) (<xsl:value-of select="FONCTIONSACTIVES/NBFONCTION"/> fonction(s) affiche(s) sur un total de <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(FONCTIONSACTIVES/NBFONCTOT)"/>
          </xsl:call-template>)<br/>
        </td>
			</tr>
			</table>
			<table class="clWidth635 clBorderCell" role="presentation">
				<tr>
					<td class="clWidth25"></td>
					<td class="clCouleur2 clWidth580 clAlignCenter"><xsl:apply-templates select="//FONCTIONSACTIVES/NBFONCTOT"/></td>
				</tr>
			</table>
			<img src="{$root}Images/risque/shim_bleu.gif" width="635" height="1" vspace="8" alt=""/>
			</xsl:when>
			<xsl:otherwise>
			<a name="ancActuelle"></a>
			<table class="clWidth635 clBorderCell" role="presentation">
			<tr class="clAlignCenter">
				<td class="clCouleurGras clHeight25">FONCTION(S) DE DIRECTION ACTUELLE(S) (<xsl:value-of select="FONCTIONSACTIVES/NBFONCTION"/>)<br/>
					<img src="{$root}Images/risque/shim_bleu.gif" width="635" height="1" vspace="8" alt=""/>
				</td>
			</tr>
			</table>
			</xsl:otherwise>
		</xsl:choose>		
	</xsl:if>
  
	<xsl:apply-templates select="FONCTIONSACTIVES/DIRECTION"/>	
	<xsl:if test="FONCTIONSANCIENNES/NBFONCTION > 0">		
		<xsl:choose>
			<xsl:when test="FONCTIONSANCIENNES/NBFONCTOT > 0">
			<a name="ancCessee"></a>
		  <table class="clWidth635 clBorderCell" role="presentation">
			<tr class="clAlignCenter">
        <td class="clCouleurGras clHeight25">
          FONCTION(S) DE DIRECTION CESSE(S) (<xsl:value-of select="FONCTIONSANCIENNES/NBFONCTION"/> fonction(s) affiche(s) sur un total de <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(FONCTIONSANCIENNES/NBFONCTOT)"/>
          </xsl:call-template>)<br/>
        </td>
			</tr>
			
		</table>
		  <table class="clWidth635 clBorderCell" role="presentation">
			<tr>
				<td class="clWidth25"></td>
				<td class="clCouleur2 clWidth580 clAlignCenter"><xsl:apply-templates select="//FONCTIONSANCIENNES/NBFONCTOT"/></td>
			</tr>
		</table>
		  <img src="{$root}Images/risque/shim_bleu.gif" width="635" height="1" vspace="8" alt=""/>
		  </xsl:when>
		  <xsl:otherwise>
		  <a name="ancCessee"></a>
		  <table class="clWidth635 clBorderCell" role="presentation">
		<tr class="clAlignCenter"> 
				<td class="clCouleurGras clHeight25">FONCTION(S) DE DIRECTION CESSE(S) (<xsl:value-of select="FONCTIONSANCIENNES/NBFONCTION"/>)<br/>
					<img src="{$root}Images/risque/shim_bleu.gif" width="635" height="1" vspace="8" alt=""/>
				</td>
			</tr>
		</table>
		  </xsl:otherwise>
		</xsl:choose>
		
		<xsl:apply-templates select="FONCTIONSANCIENNES/DIRECTIONCESSEE"/>
	</xsl:if> 
		
	<xsl:if test="(FONCTIONSANCIENNES/NBFONCTION = 0) and (FONCTIONSANCIENNES/NBFONCTOT > 0)">
			<a name="ancCessee"></a>
		<table class="clWidth635 clBorderCell" role="presentation">
			<tr class="clAlignCenter">
        <td class="clCouleurGras clHeight25">
          FONCTION(S) DE DIRECTION CESSE(S) (<xsl:value-of select="FONCTIONSANCIENNES/NBFONCTION"/> fonction(s) affiche(s) sur un total de <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(FONCTIONSANCIENNES/NBFONCTOT)"/>
          </xsl:call-template>)<br/>
        </td>
			</tr>
	 </table>		

		<table class="clWidth635 clBorderCell" role="presentation">
			<tr>
				<td class="clWidth25"></td>
				<td class="clCouleur2 clWidth580 clAlignCenter"><xsl:apply-templates select="//FONCTIONSANCIENNES/NBFONCTOT"/></td>
			 </tr>
		</table>
		<img src="{$root}Images/risque/shim_bleu.gif" width="635" height="1" vspace="8" alt=""/>
		
		<xsl:apply-templates select="FONCTIONSANCIENNES/DIRECTIONCESSEE"/>
	</xsl:if>
	
</xsl:template>

<xsl:template match="FONCTIONSACTIVES/DIRECTION">
	<table class="clWidth739 clBorderCell">
    <caption class="visually-hidden">FONCTION(S) DE DIRECTION ACTUELLE(S)</caption>
		<xsl:apply-templates select="." mode="ligne1">
			<xsl:with-param name="indice" select="position()"/>
		</xsl:apply-templates>
		<tr> 
			<td class="clTexteGras clHeight14" colspan="5">&#160;<xsl:value-of select="EJ/DENOM"/></td>
		</tr>
		
      <xsl:choose>
        <xsl:when test="not(FONCTCOT/SEGMENT)">
          <tr>
            <th class="clCouleur2 clWidth59 clValignMiddle clAlignLeft clThNonGras">&#160;Identifiant</th>
            <td class="clFond clWidth255">
              &#160;<xsl:call-template name ="displaySirenXsl">
                <xsl:with-param name ="InputSiren" select ="(EJ/IDENTS)"/>
              </xsl:call-template>
            </td>
            <xsl:if test="not(FONCTCOT/VALCOT='NS')">
              <th class="clCouleur2 clWidth53 clValignMiddle clAlignLeft clThNonGras">&#160;Cotation</th>
              <xsl:if test ="not(FONCTCOT/VALCOT='ND')">                
               <td class="clFond clWidth176">
                  &#160;<a href="#nullepart" class="clFond" onclick="requestVariousInfos('{FONCTCOT/VALCOT}',cstCotation,'{EJ/IDENTS}');">
                    <u>
                      <xsl:value-of 	select="FONCTCOT/VALCOT"/>                     
                    </u>
                  </a>
                </td>
              </xsl:if>
              <xsl:if test ="(FONCTCOT/VALCOT='ND')">                
               <td class="clFond clWidth176">
                  &#160;<a href="#nullepart" class="clFond" onclick="requestVariousInfos('{FONCTCOT/VALCOT}',cstCotationNonDif,'{EJ/IDENTS}');">
                    <u>
                      <xsl:value-of 	select="FONCTCOT/VALCOT"/>
                    </u>
                  </a>
                </td>
              </xsl:if>             
              <td class="clFond clWidth92 clAlignRight clValignMiddle">
                <a href="#nullepart" onClick="requestBDFInfos('27|37|51|','','1','{EJ/IDENTS}',cstMultipleConfirm);">
                  <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                </a>
              </td>
            </xsl:if>
            <xsl:if test="(FONCTCOT/VALCOT='NS')">
              <td class="clFond clWidth321 clAlignRight clValignMiddle" colspan="3">
                <a href="#nullepart" onClick="requestBDFInfos('27|','','1','{EJ/IDENTS}',cstMultipleConfirm);">
                  <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                </a>
              </td>
            </xsl:if>
          </tr >
        </xsl:when >
        <xsl:otherwise>
          <tr>
            <th class="clCouleur2 clWidth59 clValignMiddle clAlignLeft clThNonGras">
              &#160;Identifiant
            </th>
            <td class="clFond clWidth163">
              &#160;<xsl:call-template name ="displaySirenXsl">
                <xsl:with-param name ="InputSiren" select ="(EJ/IDENTS)"/>
              </xsl:call-template>
            </td>
            <xsl:if test="not(FONCTCOT/VALCOT='NS')">
              <th class="clCouleur2 clWidth145 clValignMiddle clAlignLeft clThNonGras">&#160;Cotation | Segmentation</th>
              <xsl:if test="not(FONCTCOT/VALCOT='ND')">
             <td class="clFond clWidth176">
                &#160;<a href="#nullepart" class="clFond" onclick="requestVariousInfos('{FONCTCOT/VALCOT}',cstCotation,'{EJ/IDENTS}');">
                  <u>
                    <xsl:value-of 	select="FONCTCOT/VALCOT"/>
                  </u>
                </a>
                <a href="#nullepart" class="clTexte" onclick="requestInfosLibelle('segmentation',cstSegment);">
                  &#160;|&#160;<u>
                    <xsl:value-of select="FONCTCOT/SEGMENT"/>
                  </u>
                </a>
              </td>
              </xsl:if>
              <xsl:if test="(FONCTCOT/VALCOT='ND')">
               <td class="clFond clWidth176">
                  &#160;<a href="#nullepart" class="clFond" onclick="requestVariousInfos('{FONCTCOT/VALCOT}',cstCotationNonDif,'{EJ/IDENTS}');">
                    <u>
                      <xsl:value-of 	select="FONCTCOT/VALCOT"/>
                    </u>
                  </a>
                  <a href="#nullepart" class="clTexte" onclick="requestInfosLibelle('segmentation',cstSegment);">
                    &#160;|&#160;<u>
                      <xsl:value-of select="FONCTCOT/SEGMENT"/>
                    </u>
                  </a>
                </td>
              </xsl:if>
              <td class="clFond clWidth92 clAlignRight clValignMiddle">
                <a href="#nullepart" onClick="requestBDFInfos('27|37|39|51|','','1','{EJ/IDENTS}',cstMultipleConfirm);">
                  <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                </a>
              </td>
            </xsl:if>
            <xsl:if test="(FONCTCOT/VALCOT='NS')">
              <td class="clFond clWidth413 clAlignRight clValignMiddle" colspan="3">
                <a href="#nullepart" onClick="requestBDFInfos('27|','','1','{EJ/IDENTS}',cstMultipleConfirm);">
                  <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                </a>
              </td>
            </xsl:if>
          </tr>
        </xsl:otherwise>
      </xsl:choose>
      			
		
	</table>
	<xsl:call-template name="shim"/>
</xsl:template>

<xsl:template match="FONCTIONSANCIENNES/DIRECTIONCESSEE">
	<table class="clWidth739 clBorderCell">
    <caption class="visually-hidden">FONCTION(S) DE DIRECTION CESSE(S)</caption>
		<xsl:apply-templates select="DIRECTION" mode="ligne1">
			<xsl:with-param name="indice" select="position()"/>
		</xsl:apply-templates>
		<xsl:apply-templates select="CESSATION"/>
		<tr> 
			<td class="clFond clHeight14" colspan="5">&#160;<b><xsl:value-of select="DIRECTION/EJ/DENOM"/></b></td>
		</tr>
		
      <xsl:choose >
        <xsl:when test="not(DIRECTION/FONCTCOT/SEGMENT)">
          <tr>
            <th class="clCouleur2 clWidth59 clValignMiddle clAlignLeft clThNonGras">
              &#160;Identifiant
            </th>
            <td class="clTexte clWidth255">
              &#160;<xsl:call-template name ="displaySirenXsl">
                <xsl:with-param name ="InputSiren" select ="(DIRECTION/EJ/IDENTS)"/>
              </xsl:call-template>
            </td>
            <xsl:if test="not(DIRECTION/FONCTCOT/VALCOT='NS')">
              <th class="clCouleur2 clWidth53 clValignMiddle clAlignLeft clThNonGras">&#160;Cotation</th>
              <xsl:if test="not(DIRECTION/FONCTCOT/VALCOT='ND')">
                <td class="clTexte clWidth176">
                  &#160;<a href="#nullepart" class="clTexte" onclick="requestVariousInfos('{DIRECTION/FONCTCOT/VALCOT}',cstCotation,'{DIRECTION/EJ/IDENTS}');">
                    <u>
                      <xsl:value-of select="DIRECTION/FONCTCOT/VALCOT"/>
                    </u>
                  </a>
                </td>
              </xsl:if>
              <xsl:if test="(DIRECTION/FONCTCOT/VALCOT='ND')">
                <td class="clTexte clWidth176">
                  &#160;<a href="#nullepart" class="clTexte" onclick="requestVariousInfos('{DIRECTION/FONCTCOT/VALCOT}',cstCotationNonDif,'{DIRECTION/EJ/IDENTS}');">
                    <u>
                      <xsl:value-of select="DIRECTION/FONCTCOT/VALCOT"/>
                    </u>
                  </a>
                </td>
              </xsl:if>              
              <td class="clTexte clWidth92 clAlignRight clValignMiddle">
                <a href="#nullepart" onClick="requestBDFInfos('27|37|51|','','1','{DIRECTION/EJ/IDENTS}',cstMultipleConfirm);">
                  <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                </a>
              </td>
            </xsl:if>
            <xsl:if test="(DIRECTION/FONCTCOT/VALCOT='NS')">
              <td class="clTexte clWidth321 clAlignRight clValignMiddle" colspan="3">
                <a href="#nullepart" onClick="requestBDFInfos('27|','','1','{DIRECTION/EJ/IDENTS}',cstMultipleConfirm);">
                  <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                </a>
              </td>
            </xsl:if>
          </tr>
        </xsl:when>
        <xsl:otherwise >
          <tr>
            <th class="clCouleur2 clWidth59 clValignMiddle clAlignLeft clThNonGras">
              &#160;Identifiant
            </th>
            <td class="clTexte clWidth163">
              &#160;<xsl:call-template name ="displaySirenXsl">
                <xsl:with-param name ="InputSiren" select ="(DIRECTION/EJ/IDENTS)"/>
              </xsl:call-template>
            </td>
            <xsl:if test="not(DIRECTION/FONCTCOT/VALCOT='NS')">
              <th class="clCouleur2 clWidth145 clValignMiddle clAlignLeft clThNonGras">&#160;Cotation | Segmentation</th>
              <xsl:if test="not(DIRECTION/FONCTCOT/VALCOT='ND')">
                <td class="clTexte clWidth176">
                  &#160;<a href="#nullepart" class="clTexte" onclick="requestVariousInfos('{DIRECTION/FONCTCOT/VALCOT}',cstCotation,'{DIRECTION/EJ/IDENTS}');">
                    <u>
                      <xsl:value-of select="DIRECTION/FONCTCOT/VALCOT"/>
                    </u>
                  </a>
                  <a href="#nullepart" class="clTexte" onclick="requestInfosLibelle('segmentation',cstSegment);">
                    &#160;|&#160;<u>
                      <xsl:value-of select="DIRECTION/FONCTCOT/SEGMENT"/>
                    </u>
                  </a>
                </td>
              </xsl:if>
              <xsl:if test="(DIRECTION/FONCTCOT/VALCOT='ND')">
                <td class="clTexte clWidth176">
                  &#160;<a href="#nullepart" class="clTexte" onclick="requestVariousInfos('{DIRECTION/FONCTCOT/VALCOT}',cstCotationNonDif,'{DIRECTION/EJ/IDENTS}');">
                    <u>
                      <xsl:value-of select="DIRECTION/FONCTCOT/VALCOT"/>
                    </u>
                  </a>
                  <a href="#nullepart" class="clTexte" onclick="requestInfosLibelle('segmentation',cstSegment);">
                    &#160;|&#160;<u>
                      <xsl:value-of select="DIRECTION/FONCTCOT/SEGMENT"/>
                    </u>
                  </a>
                </td>
              </xsl:if>
              
              <td class="clTexte clWidth92 clAlignRight clValignMiddle">
                <a href="#nullepart" onClick="requestBDFInfos('27|37|39|51|','','1','{DIRECTION/EJ/IDENTS}',cstMultipleConfirm);">
                  <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                </a>
              </td>
            </xsl:if>
            <xsl:if test="(DIRECTION/FONCTCOT/VALCOT='NS')">
              <td class="clTexte clWidth413 clAlignRight clValignMiddle" colspan="3">
                <a href="#nullepart" onClick="requestBDFInfos('27|','','1','{DIRECTION/EJ/IDENTS}',cstMultipleConfirm);">
                  <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                </a>
              </td>
            </xsl:if>
          </tr>
        </xsl:otherwise>
      </xsl:choose>
				
	</table>
	<xsl:call-template name="shim"/>
</xsl:template>

<xsl:template match="DIRECTION" mode="ligne1">
	<xsl:param name="indice"/>
	<tr> 
		<td class="clGrasFond" colspan="2">
			<xsl:apply-templates select="FONCTCOT"/>
		</td>
		<xsl:if test="FONCTCOT/DATFONCT">
			<th class="clFond clAlignRight clThNonGras" colspan="2">Depuis le :</th>
			<td class="clFond clAlignRight clWidth92">
        <xsl:call-template name ="displayDateXsl">
          <xsl:with-param name ="InputDate" select ="(FONCTCOT/DATFONCT)"/>
        </xsl:call-template>
      </td>
		</xsl:if>
		<xsl:if test="not(FONCTCOT/DATFONCT)">
			<td colspan="2" class="clFond">&#160;</td>
			<td class="clFond clWidth90">&#160;</td>
		</xsl:if>
		<xsl:if test="$indice mod 3 = 0">
			<td rowspan="5" class="clAlignRight clWidth103">
				<a href="#ancHaut"><img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page" /></a>
			</td>
		</xsl:if>
		<xsl:if test="$indice mod 3 != 0">
			<td rowspan="5" class="clAlignRight clWidth103">
				&#160;
			</td>
		</xsl:if>
	</tr>
</xsl:template>

<xsl:template match="CESSATION">
	<tr> 
		<td class="clTexte clHeight14" colspan="2">
			&#160;<xsl:call-template name="traduction"><xsl:with-param name="code" select="@COCESS"/></xsl:call-template>
		</td>
		<td class="clTexte clWidth54 clHeight14">&#160;</td>
		<th class="clTexte clAlignRight clHeight14 clThNonGras">Depuis le :</th>
    <td class="clTexte clAlignRight clHeight14">
      <xsl:call-template name ="displayDateXsl">
        <xsl:with-param name ="InputDate" select ="(@DATCESS)"/>
      </xsl:call-template>
    </td>
	</tr>
</xsl:template>

</xsl:stylesheet>
