<?xml version="1.0" encoding="iso-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
					              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
					              xmlns:bdf="http://banque-france.fr/namespace">
    <xsl:import href="../../Ressources/XSL/Commun.xsl"/>
    <xsl:import href="../../Ressources/XSL/commun_transfo.xsl"/>
    <xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes" />
    <xsl:param name="langage" select="'fr'"/>
    <xsl:param name="familyName" select="''"/>
    <xsl:param name="root" select="'/Fiben/'"/>
    <xsl:param name="familyNumber" select="''"/>
    <xsl:param name="familyTitle" select="''"/>
    <xsl:param name="nextModule" select="''"/>
    <xsl:param name="nextId" select="''"/>
    <xsl:param name="nextFamily" select="''"/>
  <xsl:param name="Lang" select="'FR'"/>
  <xsl:param name="NonResident" select="''"/>
    <xsl:param name="menuHTML1"/>
    <xsl:variable name="condGraph1" select="//NBASSOCIE>1"/>

    <xsl:template match="/">
        <html lang="fr">
          <title>Module 53 - Associs et Participations</title>
            <xsl:call-template name="genHead">
                <xsl:with-param name="ident" select="FIBEN/ERREUR/IDENT | /FIBEN/PERSONNE/MODULE53/PM53/EJ/IDENTS | /FIBEN/PERSONNE/MODULE53/PM53/EI53/IDENTS | /FIBEN/PERSONNE/MODULE53/PM53/EI53/IDENTC | FIBEN/PERSONNE/MODULE53/PP/IDENTC"/>
            </xsl:call-template>
            <body class="clBodybgcolorWhite">
              <xsl:call-template name="genFondMenu">
                <xsl:with-param name="root" select="$root"/>
              </xsl:call-template>
              <xsl:copy-of select="$menuHTML1"/>
              
                <table class="mainmodule horizontal-auto clBorderCell">
                  <caption class="visually-hidden">Module 53 - Associs et Participations</caption>
                  <xsl:call-template name="genLigneConfidentiel" />
                    <xsl:apply-templates select="/FIBEN/ERREUR"/>
                    <xsl:if test="not(/FIBEN/ERREUR)">

                        <tr>
                             <td class="clWidth64">&#160;</td>
                            <td class="clCouleur2 clValignTop clWidth739" colspan="4">
                                <!-- appel du template avec parametre segment  pas -->

                                <xsl:choose>
                                    <!-- Cas d'une PM (EJ ou EI)  -->
                                    <xsl:when test ="/FIBEN/PERSONNE/MODULE53/PM53/ */IDENTS">
                                        <xsl:call-template name="genEnTete">
                                            <xsl:with-param name="ident" select="/FIBEN/PERSONNE/MODULE53/PM53/EJ/IDENTS | /FIBEN/PERSONNE/MODULE53/PM53/EI53/IDENTS" />
                                            <xsl:with-param name="nom">
                                                <xsl:if test ="/FIBEN/PERSONNE/MODULE53/PM53/EJ/DENOM">
                                                    <xsl:value-of select ="/FIBEN/PERSONNE/MODULE53/PM53/EJ/DENOM"/>
                                                </xsl:if>
                                                <xsl:if test ="/FIBEN/PERSONNE/MODULE53/PM53/EI53/IDENTITE/NOM">
                                                    <xsl:call-template name ="displayInLowerCaseXsl">
                                                        <xsl:with-param name ="InputStringNom" select ="(/FIBEN/PERSONNE/MODULE53/PM53/EI53/IDENTITE/NOM)"/>
                                                        <xsl:with-param name ="InputStringPrenom" select ="(/FIBEN/PERSONNE/MODULE53/PM53/EI53/IDENTITE/PRENOM)"/>
                                                    </xsl:call-template>
                                                </xsl:if>
                                            </xsl:with-param>
                                            <xsl:with-param name="nomconj" select="/FIBEN/PERSONNE/MODULE53/PM53/EI53/IDENTITE/NOMCONJ"/>
                                            <xsl:with-param name="valcot" select="/FIBEN/PERSONNE/MODULE53/DIFF53/VALCOT"/>                                                                       
                                            <xsl:with-param name="valindic" select="/FIBEN/PERSONNE/MODULE53/DIFF53/VALINDIC"/>
                                            <xsl:with-param name="idrenv" select="/FIBEN/PERSONNE/MODULE53/PM53/EI53/IDRENV"/>
                                            <xsl:with-param name ="segment">
                                                <xsl:if test ="/FIBEN/PERSONNE/MODULE53/DIFF53/SEGMENT">
                                                    <xsl:value-of select="/FIBEN/PERSONNE/MODULE53/DIFF53/SEGMENT"/>
                                                </xsl:if>
                                            </xsl:with-param>
                                        </xsl:call-template>
                                    </xsl:when>
                                    <!-- Cas d'une PP (PP ou PPEI)  -->
                                    <xsl:otherwise>
                                        <xsl:call-template name="genEnTete">
                                            <xsl:with-param name="ident" select="FIBEN/PERSONNE/MODULE53/PP/IDENTC | FIBEN/PERSONNE/MODULE53/PM53/EI53/IDENTC" />
                                            <xsl:with-param name="idrenv" select="/FIBEN/PERSONNE/MODULE53/PM53/EI53/IDRENV"/>
                                            <xsl:with-param name="nom">
                                                <xsl:if test ="/FIBEN/PERSONNE/MODULE53/PM53/EI53/IDENTITE/NOM">
                                                    <xsl:call-template name ="displayInLowerCaseXsl">
                                                        <xsl:with-param name ="InputStringNom" select ="(/FIBEN/PERSONNE/MODULE53/PM53/EI53/IDENTITE/NOM)"/>
                                                        <xsl:with-param name ="InputStringPrenom" select ="(/FIBEN/PERSONNE/MODULE53/PM53/EI53/IDENTITE/PRENOM)"/>
                                                    </xsl:call-template>
                                                </xsl:if>
                                                <xsl:if test ="/FIBEN/PERSONNE/MODULE53/PP/IDENTITE/NOM">
                                                    <xsl:call-template name ="displayInLowerCaseXsl">
                                                        <xsl:with-param name ="InputStringNom" select ="(/FIBEN/PERSONNE/MODULE53/PP/IDENTITE/NOM)"/>
                                                        <xsl:with-param name ="InputStringPrenom" select ="(/FIBEN/PERSONNE/MODULE53/PP/IDENTITE/PRENOM)"/>
                                                    </xsl:call-template>
                                                </xsl:if>
                                            </xsl:with-param>
                                            <xsl:with-param name="nomconj" select="/FIBEN/PERSONNE/MODULE53/PP/IDENTITE/NOMCONJ | /FIBEN/PERSONNE/MODULE53/PM53/EI53/IDENTITE/NOMCONJ"/>
                                            <xsl:with-param name="valcot" select="/FIBEN/PERSONNE/MODULE53/DIFF53/VALCOT"/>
                                            <xsl:with-param name="valindic" select="/FIBEN/PERSONNE/MODULE53/DIFF53/VALINDIC"/>                                            
                                        </xsl:call-template>
                                    </xsl:otherwise> 
                                </xsl:choose>

                                <xsl:if test="/FIBEN/PERSONNE/MODULE53/IEC01|/FIBEN/PERSONNE/MODULE53/IST10">
                                    <table class="clWidth635 clBorderCell" role="presentation">
                                        <tr>
                                            <td class="clWidth14"></td>
                                            <td colspan="4" class="clCouleur2 clValignTop">
                                                <xsl:apply-templates select="/FIBEN/PERSONNE/MODULE53/IEC01|/FIBEN/PERSONNE/MODULE53/IST10"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="clWidth14"></td>
                                            <td colspan="4">
                                                <xsl:call-template name="shim"/>
                                            </td>
                                        </tr>
                                    </table>
                                </xsl:if>                               
                               
                                <xsl:apply-templates select="FIBEN/PERSONNE/MODULE53/DIFF53"/>
                                <xsl:apply-templates select="//HOMONYME"/>
                                <xsl:apply-templates select="//IDLIES"/>
                                
                            </td>
                        </tr>
                        <tr>
                            <td colspan="4"></td>
                        </tr>

                    </xsl:if>
                </table>
                <xsl:call-template name="genBasPage"/>
                <xsl:call-template name="genGraph53"/>
            </body>
        </html>
    </xsl:template>

    
    <xsl:template match="IEC01|IST10" mode="genTable">
        <table class="clWidth635 clBorderCell" role="presentation">
            <tr>
                <td class="clWidth14"></td>
                <td class="clCouleur2 clValignTop">
                    <xsl:apply-templates select="."/>
                </td>
            </tr>
            <tr>
                <td class="clWidth14"></td>
                <td>
                    <xsl:call-template name="shim"/>
                </td>
            </tr>
        </table>
    </xsl:template>

    <xsl:template match="DIFF53">        
        <xsl:choose >
            <xsl:when test ="/FIBEN/PERSONNE/MODULE53/DIFF53/IST53A">
                <xsl:apply-templates select="IST53A"/>
            </xsl:when>
            <xsl:when test ="/FIBEN/PERSONNE/MODULE53/DIFF53/IST53B">
                <xsl:apply-templates select="IST53B"/>
            </xsl:when>
            <xsl:when test="/FIBEN/PERSONNE/MODULE53/DIFF53/IST53C">
                <xsl:apply-templates select="IST53C"/>
            </xsl:when>          
            <xsl:otherwise >
               
                        <table class="clWidth635 clBorderCell" role="presentation">
                            <tr>
                                 <th class="clCouleur2 clWidth130 clAlignLeft clThNonGras">&#160;Capital</th>
                               <td class="clFond clWidth365">
                                    <xsl:if test="p2051DA/@ETAT">
                                        &#160;<xsl:value-of select="p2051DA/@ETAT"/>
                                    </xsl:if>
                                    <xsl:if test="not(p2051DA/@ETAT)">
                                        &#160;<xsl:call-template name ="displayNumberXsl">
                                            <xsl:with-param name ="InputStringNumber" select ="(p2051DA)"/>
                                        </xsl:call-template>
                                        &#160;<img src="{$root}Images/risque/euro_symb_noir.png" width="8" alt="symbole euro" />
                                    </xsl:if>
                                </td>
                                <th class="clCouleur2 clWidth45 clAlignRight clThNonGras">au&#160;</th>
                                <td class="clFond clWidth95 clAlignRight">
                                    &#160;&#160;<xsl:call-template name ="displayDateXsl">
                                        <xsl:with-param name ="InputDate" select ="(DATAG)"/>
                                    </xsl:call-template>&#160;
                                </td>
                            </tr>
                        </table>
                        <xsl:call-template name="shim"/>                      
            </xsl:otherwise>
        </xsl:choose>
        <!-- Partie ASSOCIE -->
      <xsl:choose >
      <xsl:when test="/FIBEN/PERSONNE/MODULE53/DIFF53/IST53D">
        <xsl:apply-templates select="IST53D"/>
      </xsl:when>
        <xsl:otherwise >
            <xsl:apply-templates select="/FIBEN/PERSONNE/MODULE53/DIFF53/INFOASSOCIES53/NBASSOCIE"/>
            <xsl:apply-templates select="/FIBEN/PERSONNE/MODULE53/DIFF53/INFOASSOCIES53/ASSOCIE"/>
        </xsl:otherwise>
      </xsl:choose>
        <xsl:choose >
            <!-- Partie PARTICIPATION -->
            <xsl:when test ="/FIBEN/PERSONNE/MODULE53/DIFF53/IST53E">
                <xsl:apply-templates select="IST53E"/>
            </xsl:when>           
            <xsl:otherwise >
                <xsl:apply-templates select="/FIBEN/PERSONNE/MODULE53/DIFF53/INFOPARTICIPATIONS53/AUTRFDPP"/>
                <xsl:apply-templates select="/FIBEN/PERSONNE/MODULE53/DIFF53/INFOPARTICIPATIONS53/AUTRFDEI"/>
                <xsl:apply-templates select="/FIBEN/PERSONNE/MODULE53/DIFF53/INFOPARTICIPATIONS53/NBPARTICIPATION"/>
                <xsl:apply-templates select="/FIBEN/PERSONNE/MODULE53/DIFF53/INFOPARTICIPATIONS53/PARTICIPATION"/>               
            </xsl:otherwise>
        </xsl:choose>

    </xsl:template>


    <xsl:template match="IST53A">
        <table class="clWidth635 clBorderCell clCouleur2" role="presentation">
            <tr>
               <!--Pas d'information recense concernant le capital de cet identifiant)-->
                <td class="clAlignLeft clWidth522">                   
                    <xsl:value-of select="($dictionnaire/mot[@id='IST53A'])"/>
                </td>
                <td class="clWidth103 clAlignRight">
                </td>
            </tr>

        </table>
        <xsl:call-template name="shim"/>
        <br/>
    </xsl:template>
    
    <xsl:template match="IST53B">
        <table class="clWidth635 clBorderCell clCouleur2" role="presentation">
            <tr>
                <td class="clAlignLeft clWidth522">
                    <!--Pas d'information disponible sur les associs pour les personnes physiques)-->
                    <xsl:value-of select="($dictionnaire/mot[@id='IST53B'])"/>
                </td>
                <td class="clWidth103 clAlignRight">
                </td>
            </tr>

        </table>
        <xsl:call-template name="shim"/>
        <br/>
    </xsl:template>

    <xsl:template match="IST53C">
        <table class="clWidth635 clBorderCell clCouleur2" role="presentation">
            <tr>
                <td class="clAlignLeft clWidth522">
                    <!--Pas d'information disponible sur les associs pour les entreprises individuelles)-->
                    <xsl:value-of select="($dictionnaire/mot[@id='IST53C'])"/>
                </td>
                <td class="clWidth103 clAlignRight">
                </td>
            </tr>

        </table>
        <xsl:call-template name="shim"/>
        <br/>
    </xsl:template>

    <xsl:template match="IST53D">
        <table class="clWidth635 clBorderCell clCouleur2" role="presentation">
            <tr>
                <td class="clAlignLeft clWidth522">
                    <!--Pas d'information recense sur les associs pour cet identifiant)-->
                    <xsl:value-of select="($dictionnaire/mot[@id='IST53D'])"/>
                </td>
                <td class="clWidth103 clAlignRight">
                </td>
            </tr>

        </table>
        <xsl:call-template name="shim"/>
        <br/>
    </xsl:template>
    
    <xsl:template match="NBASSOCIE">
        <a name="ancAssoc"></a>
        <table class="clWidth635 clBorderCell">
          <caption class="visually-hidden">PRINCIPAL(AUX) ASSOCI(S)</caption>
            <tr>
                 <td class="clWidth19">&#160;</td>
                <td class="clCouleurGras clAlignCenter clWidth597">
                    PRINCIPAL(AUX) ASSOCI(S) (<xsl:value-of select="."/>)
                </td>
                 <td class="clWidth19">
                    <xsl:if test="$condGraph1">
                        <a href="#nullepart" onclick="window.document.forms['FormGraphes'].action='Graphes.aspx#Graphe1';window.document.forms	['FormGraphes'].submit();">
                            <img title="Graphique" alt="Graphique" border="0" height="20" name="dia2" src="{$root}Images/risque/diagramme_bleu.gif" width="19"/>
                        </a>
                    </xsl:if>
                    <xsl:if test="$condGraph1!='true'">
                        <img src="{$root}Images/boutons/diagramme_in.gif" width="19" height="20" border="0" title="Graphique" alt="Graphique" />
                    </xsl:if>
                </td>
            </tr>
        </table>
        <xsl:call-template name="shim"/>
        <br />
    </xsl:template>
    
    <xsl:template match="ASSOCIE">
        <xsl:apply-templates select="CAPITAL">
            <xsl:with-param name="indice" select="position()"/>
        </xsl:apply-templates>
        
        <xsl:apply-templates select="ASSOCSPE|ASSOCPP|ASSOCEJ"/>
    </xsl:template>

    <xsl:template match="CAPITAL">

        <xsl:param name="indice"/>

        <table class="clWidth739 clBorderCell">
          <caption class="visually-hidden">Principal(aux) associ(s). Pourcentage de capital dtenu</caption>
            <tr>
                <th class="clCouleur2 clWidth130 clAlignLeft clThNonGras">&#160;Pourcentage dtenu</th>
                <td class="clFond clWidth182">
                    &#160;<xsl:value-of select="POURCENTAGE"/>
                </td>
                 <td class="clFond clWidth80">&#160;</td>
                <xsl:if test="DATDET">
                    <th class="clFond clAlignRight clWidth148 clThNonGras">&#160;Depuis le</th>
                    <td class="clFond clAlignRight clWidth95">
                        <xsl:call-template name ="displayDateXsl">
                            <xsl:with-param name ="InputDate" select ="(DATDET)"/>
                        </xsl:call-template>&#160;
                    </td>
                </xsl:if>
                <xsl:if test="not(DATDET)">
                    <td class="clFond clAlignRight clWidth148">&#160;</td>
                    <td class="clFond clAlignRight clWidth95">&#160;</td>
                </xsl:if>
                <xsl:if test="$indice mod 3 = 0">
                    <td class="clWidth103 clAlignRight">
                        <a href="#ancHaut">
                            <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page" />
                        </a>
                    </td>
                </xsl:if>
                <xsl:if test="$indice mod 3 != 0">
                    <td class="clWidth103 clAlignRight">
                        &#160;
                    </td>
                </xsl:if>
            </tr>
        </table>
    </xsl:template>


    <xsl:template match="ASSOCSPE">
        <table class="clWidth635 clBorderCell">
          <caption class="visually-hidden">Associ(s) spcial(aux)</caption>
            <tr class="clAlignLeft clValignMiddle">
                <td class="clTexte clWidth130">
                    &#160;<xsl:value-of select="DENOM"/>
                </td>
                <td class="clWidth182"></td>
                <td class="clWidth80"></td>
                <td class="clWidth148"></td>
                <td class="clWidth95"></td>
            </tr>
            <tr>
                <td colspan="4">
                    &#160;
                </td>
                <td class="clWidth95">
                    &#160;
                </td>
            </tr>

        </table>
        <xsl:call-template name="shim"/>

    </xsl:template>

    <xsl:template match="ASSOCPP">
        <table class="clWidth635 clBorderCell">
          <caption class="visually-hidden">Associ personne physique</caption>
            <tr>
               <td colspan="2" class="clTexte clWidth312">
                    &#160;<xsl:call-template name ="displayInLowerCaseXsl">
                        <xsl:with-param name ="InputStringNom" select ="(PP/IDENTITE/NOM)"/>
                        <xsl:with-param name ="InputStringPrenom" select ="(PP/IDENTITE/PRENOM)"/>
                    </xsl:call-template>
                </td>
                <xsl:if test="PP/IDENTITE/NOMCONJ">
                    <th class="clCouleur2 clWidth80 clAlignLeft clThNonGras">&#160;Nom marital</th>
                    <td colspan="2" class="clTexte clWidth243">
                        &#160;<xsl:value-of select="PP/IDENTITE/NOMCONJ"/>
                    </td>
                </xsl:if>
                <xsl:if test="not(PP/IDENTITE/NOMCONJ)">
                    <td class="clCouleur2 clWidth80">&#160;</td>
                    <td colspan="2" class="clTexte clWidth243">&#160;</td>
                </xsl:if>
            </tr>

            <xsl:choose>
                <xsl:when test ="AUTRFDPP">
                    <tr class="clValignMiddle">
                        <th class="clCouleur2 clWidth130 clAlignLeft clThNonGras">&#160;Identifiant </th>
                        <td class="clFond clWidth182 clAlignLeft">
                            &#160;<xsl:value-of select="PP/IDENTC"/>
                        </td>
                      <xsl:if test="not(VALCOT='NS')">
                        <th class="clCouleur2 clWidth80 clAlignLeft clThNonGras">&#160;Indicateur</th>
                        <xsl:if test ="(VALCOT='ND')">
                          <td class="clFond clWidth148 clAlignLeft">
                            &#160;<a href="#nullepart" class="clFond" onclick="requestVariousInfos('{VALCOT}',cstCotationNonDif,'{PP/IDENTC}');">
                              <u>
                                <xsl:value-of select="VALCOT"/>
                              </u>
                            </a>
                          </td> 
                        </xsl:if>
                        <xsl:if test="not(VALCOT='ND')">
                        <td class="clFond clWidth148 clAlignLeft">
                            &#160;<a href="#nullepart" class="clFond" onclick="requestVariousInfos('{VALCOT}',cstCotation,'{PP/IDENTC}');">
                                <u>
                                    <xsl:value-of select="VALCOT"/>
                                </u>
                            </a>
                        </td>
                        </xsl:if>
                        <td class="clFond clWidth95 clAlignRight">
                            <a href="#nullepart" onClick="requestBDFInfos('27|37|53|56|','','1','{PP/IDENTC}',cstMultipleConfirm);">
                                <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                            </a>
                        </td>
                      </xsl:if>
                      <xsl:if test="(VALCOT='NS')">
                        <td class="clFond clWidth323 clAlignRight" colspan="3">
                          <a href="#nullepart" onClick="requestBDFInfos('27|','','1','{PP/IDENTC}',cstMultipleConfirm);">
                            <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                          </a>
                        </td>
                      </xsl:if>
                    </tr>
                    <tr>
                        <td class="clTexte clAlignLeft" colspan="4">
                            &#160;Prsence de fonction de reprsentant(s) lgal(aux) dans une/des socit(s)
                        </td>
                        <td class="clWidth95">
                            &#160;
                        </td>
                    </tr>
                </xsl:when>
                <xsl:otherwise>
                    <tr class="clValignMiddle">
                        <th class="clCouleur2 clWidth130 clAlignLeft clThNonGras">&#160;Identifiant </th>
                        <td class="clFond clWidth182 clAlignLeft">
                            &#160;<xsl:value-of select="PP/IDENTC"/>
                        </td>
                      <xsl:if test="not(VALCOT='NS')">
                        <th class="clCouleur2 clWidth80 clAlignLeft clThNonGras">&#160;Indicateur</th>
                        <xsl:if test ="(VALCOT='ND')">
                          <td class="clFond clWidth148 clAlignLeft">
                            &#160;<a href="#nullepart" class="clFond" onclick="requestVariousInfos('{VALCOT}',cstCotationNonDif,'{PP/IDENTC}');">
                              <u>
                                <xsl:value-of select="VALCOT"/>
                              </u>
                            </a>
                          </td>
                        </xsl:if>
                        <xsl:if test="not(VALCOT='ND')">
                        <td class="clFond clWidth148 clAlignLeft">
                            &#160;<a href="#nullepart" class="clFond" onclick="requestVariousInfos('{VALCOT}',cstCotation,'{PP/IDENTC}');">
                                <u>
                                    <xsl:value-of select="VALCOT"/>
                                </u>
                            </a>
                        </td>
                        </xsl:if>
                        <td class="clFond clWidth95 clAlignRight">
                            <a href="#nullepart" onClick="requestBDFInfos('27|37|53|','','1','{PP/IDENTC}',cstMultipleConfirm);">
                                <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                            </a>
                        </td>
                      </xsl:if>
                      <xsl:if test="(VALCOT='NS')">
                        <td class="clFond clWidth323 clAlignRight" colspan="3">
                          <a href="#nullepart" onClick="requestBDFInfos('27|','','1','{PP/IDENTC}',cstMultipleConfirm);">
                            <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                          </a>
                        </td>
                      </xsl:if>
                    </tr>
                    <tr>
                        <td class="clTexteGras clAlignLeft" colspan="4">
                            &#160;
                        </td>
                        <td class="clWidth95">
                            &#160;
                        </td>
                    </tr>
                </xsl:otherwise>
            </xsl:choose>

        </table>
        <xsl:call-template name="shim"/>
    </xsl:template>

    <xsl:template match="ASSOCEJ">
        <table class="clWidth635 clBorderCell">
          <caption class="visually-hidden">Associ entit juridique</caption>
            <tr>
                <td class="clTexte clWidth635 clHeight14" colspan="5">
                    &#160;<xsl:value-of select="EJ/DENOM"/>
                </td>
            </tr>
            <tr>
                <td class="clFond clWidth635" colspan="5">
                    &#160;<xsl:value-of select="LOCALI"/>
                </td>
            </tr>
        </table>
        <xsl:if test="not(SEGMENT)">
            <table class="clWidth635 clBorderCell">
                <tr>
                    <th class="clCouleur2 clWidth130 clAlignLeft clThNonGras">&#160;Identifiant </th>
                    <td class="clTexte clWidth182 clAlignLeft">
                        &#160;<xsl:call-template name ="displaySirenXsl">
                            <xsl:with-param name ="InputSiren" select ="(EJ/IDENTS)"/>
                        </xsl:call-template>
                    </td>
                    <xsl:variable name="locali" select="LOCALI"></xsl:variable>
                    <xsl:choose>
                        <!--Test si le dbut de la localit est un code postal -> Rsident ou non-->
                        <xsl:when test="(number(substring(LOCALI,0,5)) or ($locali='MC MONACO'))">
                            <th class="clCouleur2 clWidth80 clAlignLeft clThNonGras">&#160;Cotation</th>
                          <xsl:if test ="(VALCOT='ND')">
                            <td class="clTexte clWidth148 clAlignLeft">
                              &#160;<a href="#nullepart" class="clTexte" onclick="requestVariousInfos('{VALCOT}',cstCotationNonDif,'{EJ/IDENTS}');">
                                <u>
                                  <xsl:value-of select="VALCOT"/>
                                </u>
                              </a>
                            </td>
                          </xsl:if>
                          <xsl:if test="not(VALCOT='ND')">
                            <td class="clTexte clWidth148 clAlignLeft">
                              &#160;<a href="#nullepart" class="clTexte" onclick="requestVariousInfos('{VALCOT}',cstCotation,'{EJ/IDENTS}');">
                                <u>
                                  <xsl:value-of select="VALCOT"/>
                                </u>
                              </a>
                            </td>
                          </xsl:if>
                            <td class="clTexte clWidth95 clAlignRight">
                                <a href="#nullepart" onClick="requestBDFInfos('27|37|53|','','1','{EJ/IDENTS}',cstMultipleConfirm);">
                                    <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                                </a>
                            </td>
                        </xsl:when>
                        <xsl:otherwise>
                            <td class="clCouleur2 clWidth80 clAlignLeft">&#160;</td>
                            <td class="clTexte clWidth148 clAlignLeft">&#160;</td>
                            <td class="clTexte clWidth95 clAlignRight">
                                <a href="#nullepart" onClick="requestBDFInfos('27','','1','{EJ/IDENTS}',cstSimpleConfirm);">
                                    <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                                </a>
                            </td>
                        </xsl:otherwise>
                    </xsl:choose>
                </tr>
                <tr>
                    <td colspan="4">
                        &#160;
                    </td>
                    <td class="clWidth95">
                        &#160;
                    </td>
                </tr>
            </table>
        </xsl:if>
        <xsl:if test="SEGMENT">
            <table class="clWidth635 clBorderCell" role="presentation">
                <tr>
                    <th class="clCouleur2 clWidth130 clAlignLeft clThNonGras">&#160;Identifiant </th>
                    <td class="clTexte clWidth107 clAlignLeft">
                        &#160;<xsl:call-template name ="displaySirenXsl">
                            <xsl:with-param name ="InputSiren" select ="(EJ/IDENTS)"/>
                        </xsl:call-template>
                    </td>
                    <xsl:variable name="locali" select="LOCALI"></xsl:variable>
                    <xsl:choose>
                        <!--Test si le dbut de la localit est un code postal -> Rsident ou non-->
                        <xsl:when test="(number(substring(LOCALI,0,5)) or ($locali='MC MONACO'))">
                            <th class="clCouleur2 clWidth155 clAlignLeft clThNonGras">&#160;Cotation | Segmentation</th>
                          <xsl:if test ="(VALCOT='ND')">
                            <td class="clTexte clWidth148 clAlignLeft">
                              &#160;<a href="#nullepart" class="clTexte" onclick="requestVariousInfos('{VALCOT}',cstCotationNonDif,'{EJ/IDENTS}');">
                                <u>
                                  <xsl:value-of select="VALCOT"/>
                                </u>
                              </a><a href="#nullepart" class="clTexte" onclick="requestInfosLibelle('segmentation',cstSegment);">
                                &#160;|&#160;<u>
                                  <xsl:value-of select="SEGMENT"/>
                                </u>
                              </a>
                            </td>
                          </xsl:if>
                          <xsl:if test="not(VALCOT='ND')">
                            <td class="clTexte clWidth148 clAlignLeft">
                              &#160;<a href="#nullepart" class="clTexte" onclick="requestVariousInfos('{VALCOT}',cstCotation,'{EJ/IDENTS}');">
                                <u>
                                  <xsl:value-of select="VALCOT"/>
                                </u>
                              </a><a href="#nullepart" class="clTexte" onclick="requestInfosLibelle('segmentation',cstSegment);">
                                &#160;|&#160;<u>
                                  <xsl:value-of select="SEGMENT"/>
                                </u>
                              </a>
                            </td>
                          </xsl:if>
                            <td class="clTexte clWidth95 clAlignRight">
                                <a href="#nullepart" onClick="requestBDFInfos('27|37|39|53|','','1','{EJ/IDENTS}',cstMultipleConfirm);">
                                    <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                                </a>
                            </td>
                        </xsl:when>
                        <xsl:otherwise>
                            <td class="clCouleur2 clWidth155 clAlignLeft">&#160;</td>
                            <td class="clTexte clWidth148 clAlignLeft">&#160;&#160;|&#160;</td>
                            <td class="clTexte clWidth95 clAlignRight">
                                <a href="#nullepart" onClick="requestBDFInfos('27','','1','{EJ/IDENTS}',cstSimpleConfirm);">
                                    <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                                </a>
                            </td>
                        </xsl:otherwise>
                    </xsl:choose>
                </tr>
                <tr>
                    <td colspan="4">
                        &#160;
                    </td>
                    <td class="clWidth95">
                        &#160;
                    </td>
                </tr>
            </table>
        </xsl:if>

        <xsl:call-template name="shim"/>

    </xsl:template>

    <xsl:template match="AUTRFDEI">
        <table class="clWidth635 clBorderCell clCouleur2" role="presentation">
            <tr>
                <td class="clWidth532 clAlignLeft">
                    <!--Prsence d&#039;autre(s) fonction(s) de reprsentant(s) lgal(aux) exerce(s)-->
                    <xsl:value-of select="($dictionnaire/mot[@id='AUTRFDEI'])"/>
                </td>

                <td class="clWidth103 clAlignRight">
                    <a href="#nullepart" onclick="requestBDFInfos('56','','','',cstSimpleConfirm);">
                        <img border="0" height="12"	src="{$root}images/Commun/clignotant2.gif" width="90" alt="plus d'infos"/>
                    </a>
                </td>
            </tr>
        </table>
        <xsl:call-template name="shim"/>
        <br/>
    </xsl:template>

    <xsl:template match="AUTRFDPP">
        <table class="clWidth635 clBorderCell clCouleur2" role="presentation">
            <tr>
                <td class="clWidth532 clAlignLeft">
                    <!--Prsence de fonction de reprsentant(s) lgal(aux) dans une/des socit(s)-->
                    <xsl:value-of select="($dictionnaire/mot[@id='AUTRFDPP'])"/>
                </td>

                <td class="clWidth103 clAlignRight">
                    <a href="#nullepart" onclick="requestBDFInfos('56','','','',cstSimpleConfirm);">
                        <img border="0" height="12" src="{$root}images/Commun/clignotant2.gif" width="90" alt="plus d'infos"/>
                    </a>
                </td>
            </tr>

        </table>
        <xsl:call-template name="shim"/>
        <br/>
    </xsl:template>

    <xsl:template match="IST53E">
        <table class="clWidth635 clBorderCell clCouleur2" role="presentation">
            <tr>
                <td class="clAlignLeft clWidth522">
                    <!--Pas d'information recense sur les participations pour cet identifiant)-->
                    <xsl:value-of select="($dictionnaire/mot[@id='IST53E'])"/>
                </td>
                <td class="clWidth103 clAlignRight">
                </td>
            </tr>

        </table>
        <xsl:call-template name="shim"/>
        <br/>
    </xsl:template>

    <xsl:template match="NBPARTICIPATION">
        <a name="ancPartic"></a>
        <table class="clWidth635 clBorderCell" role="presentation">
           <tr class="clAlignCenter">
                <td class="clCouleurGras">
                    PRINCIPALE(S) PARTICIPATION(S) (<xsl:value-of select="."/>)
                </td>
            </tr>
        </table>
        <xsl:call-template name="shim"/>
        <br />
    </xsl:template>

    <xsl:template match="IEC01|IST10" mode="genTable">
        <table class="clWidth635 clBorderCell" role="presentation">
            <tr>
                <td class="clWidth14"></td>
                <td class="clCouleur2 clValignTop">
                    <xsl:apply-templates select="."/>
                </td>
            </tr>
            <tr>
                <td class="clWidth14"></td>
                <td>
                    <xsl:call-template name="shim"/>
                </td>
            </tr>
        </table>
    </xsl:template>

    <xsl:template match="PARTICIPATION">
        <xsl:variable name="actbdf" select="ACTBDF"/>       
        <table class="clWidth739 clBorderCell">
          <caption class="visually-hidden">PRINCIPALE(S) PARTICIPATION(S)</caption>
            <tr>
                <th class="clCouleur2 clWidth130 clAlignLeft clThNonGras">&#160;Pourcentage d&#233;tenu</th>
                <td class="clFond clWidth107">
                    &#160;<xsl:value-of select="CAPITAL/POURCENTAGE"/>
                </td>
                <td class="clFond clWidth155">&#160;</td>
                <xsl:if test="CAPITAL/DATDET">
                    <th class="clFond clAlignRight clWidth148 clThNonGras">Depuis le</th>
                    <td class="clFond clAlignRight clWidth95">
                        <xsl:call-template name ="displayDateXsl">
                            <xsl:with-param name ="InputDate" select ="(CAPITAL/DATDET)"/>
                        </xsl:call-template>&#160;
                    </td>
                </xsl:if>
                <xsl:if test="not(CAPITAL/DATDET)">
                    <td class="clFond clAlignRight clWidth148">&#160;</td>
                    <td class="clFond clAlignRight clWidth95">&#160;</td>
                </xsl:if>
                <xsl:if test="position() mod 3 = 0">
                   <td class="clWidth103 clAlignRight" rowspan="4">
                        <a href="#ancHaut">
                            <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page" />
                        </a>
                    </td>
                </xsl:if>
                <xsl:if test="position() mod 3 != 0">
                   <td class="clWidth103 clAlignRight" rowspan="4">
                        &#160;
                    </td>
                </xsl:if>
            </tr>
        </table>

        <table class="clWidth635 clBorderCell">
          <caption class="visually-hidden">Denomination de la participation</caption>
            <tr>
                <td class="clTexte clWidth635" colspan="5">
                    &#160;<xsl:value-of select="EJ/DENOM"/>
                </td>
            </tr>
        </table>

        <table class="clWidth635 clBorderCell">
          <caption class="visually-hidden">Infos de la participation</caption>
            <tr>
                <td class="clFond clWidth312" colspan="2">
                    &#160;<xsl:value-of select="LOCALI"/>
                </td>
                <th class="clCouleur2 clWidth80 clAlignLeft clThNonGras">&#160;Activit&#233; BDF</th>
                 <td class="clFond clWidth243" colspan="2">
                    <a href="#nullepart" class="clTexte" onclick="requestInfosLibelle('{$actbdf}',cstWordingNew)" >
                        <u>
                            <xsl:value-of select="ACTBDF"/>
                        </u>
                    </a>
                </td>
            </tr>
        </table>

        <xsl:if test="not(SEGMENT)">
            <table class="clWidth635 clBorderCell">
              <caption class="visually-hidden">Infos de la participation</caption>
                <tr>
                    <th class="clCouleur2 clWidth130 clAlignLeft clThNonGras">&#160;Identifiant</th>
                    <td class="clTexte clWidth182">
                        &#160;<xsl:call-template name ="displaySirenXsl">
                            <xsl:with-param name ="InputSiren" select ="(EJ/IDENTS)"/>
                        </xsl:call-template>
                    </td>
                    <xsl:variable name="locali" select="LOCALI"></xsl:variable>
                    <xsl:choose>
                        <!--Test si le dbut de la localit est un code postal -> Rsident ou non-->
                        <xsl:when test="(number(substring(LOCALI,0,5)) or ($locali='MC MONACO'))">
                            <th class="clCouleur2 clWidth80 clAlignLeft clThNonGras">&#160;Cotation</th>
                          <xsl:if test ="VALCOT = 'ND'">
                             <td class="clTexte clWidth148">
                                &#160;<a href="#nullepart" class="clTexte" onclick="requestVariousInfos('{VALCOT}',cstCotationNonDif,'{EJ/IDENTS}');">
                                    <u>
                                        <xsl:value-of select="VALCOT"/>
                                    </u>
                                </a>
                            </td>                          
                          </xsl:if>
                          <xsl:if test ="not(VALCOT = 'ND')">
                            <td class="clTexte clWidth148">
                                &#160;<a href="#nullepart" class="clTexte" onclick="requestVariousInfos('{VALCOT}',cstCotation,'{EJ/IDENTS}');">
                                    <u>
                                        <xsl:value-of select="VALCOT"/>
                                    </u>
                                </a>
                            </td>
                          </xsl:if>
                            <td class="clTexte clWidth95 clAlignRight">
                                <a href="#nullepart" onClick="requestBDFInfos('27|37|53|','','1','{EJ/IDENTS}',cstMultipleConfirm);">
                                    <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                                </a>
                            </td>
                        </xsl:when>
                        <xsl:otherwise>
                            <td class="clCouleur2 clWidth80 clAlignLeft">&#160;</td>
                            <td class="clTexte clWidth148">&#160;</td>
                            <td class="clTexte clWidth95 clAlignRight">
                                <a href="#nullepart" onClick="requestBDFInfos('27','','1','{EJ/IDENTS}',cstSimpleConfirm);">
                                    <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                                </a>
                            </td>
                        </xsl:otherwise>
                    </xsl:choose>
                </tr>
            </table>
        </xsl:if>

        <xsl:if test ="SEGMENT">
            <table class="clWidth635 clBorderCell">
              <caption class="visually-hidden">Infos de la participation</caption>
                <tr>
                     <th class="clCouleur2 clWidth130 clAlignLeft clThNonGras">&#160;Identifiant</th>
                    <td class="clTexte clWidth107">
                        &#160;<xsl:call-template name ="displaySirenXsl">
                            <xsl:with-param name ="InputSiren" select ="(EJ/IDENTS)"/>
                        </xsl:call-template>
                    </td>
                    <xsl:variable name="locali" select="LOCALI"></xsl:variable>
                    <xsl:choose>
                        <!--Test si le dbut de la localit est un code postal -> Rsident ou non-->
                        <xsl:when test="(number(substring(LOCALI,0,5)) or ($locali='MC MONACO'))">
                            <th class="clCouleur2 clWidth155 clAlignLeft clThNonGras">&#160;Cotation | Segmentation</th>
                          <xsl:if test ="VALCOT = 'ND'">
                            <td class="clTexte clWidth148">
                              &#160;<a href="#nullepart" class="clTexte" onclick="requestVariousInfos('{VALCOT}',cstCotationNonDif,'{EJ/IDENTS}');">
                                <u>
                                  <xsl:value-of select="VALCOT"/>
                                </u>
                              </a>&#160;|&#160;
                              <a href="#nullepart" class="clTexte" onclick="requestInfosLibelle('segmentation',cstSegment)">
                                <u>
                                  <xsl:value-of select="SEGMENT"/>
                                </u>
                              </a>
                            </td>
                            </xsl:if>
                          <xsl:if test ="not(VALCOT = 'ND')">
                            <td class="clTexte clWidth148">
                              &#160;<a href="#nullepart" class="clTexte" onclick="requestVariousInfos('{VALCOT}',cstCotation,'{EJ/IDENTS}');">
                                <u>
                                  <xsl:value-of select="VALCOT"/>
                                </u>
                              </a>&#160;|&#160;
                              <a href="#nullepart" class="clTexte" onclick="requestInfosLibelle('segmentation',cstSegment)">
                                <u>
                                  <xsl:value-of select="SEGMENT"/>
                                </u>
                              </a>
                            </td>
                          </xsl:if>                          
                            <td class="clTexte clWidth95 clAlignRight">
                                <a href="#nullepart" onClick="requestBDFInfos('27|37|39|53|','','1','{EJ/IDENTS}',cstMultipleConfirm);">
                                    <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                                </a>
                            </td>
                        </xsl:when>
                        <xsl:otherwise>
                            <td class="clCouleur2 clWidth155">&#160;</td>
                            <td class="clTexte clWidth148">&#160;&#160;&#160;</td>
                            <td class="clTexte clWidth95 clAlignRight">
                                <a href="#nullepart" onClick="requestBDFInfos('27','','1','{EJ/IDENTS}',cstSimpleConfirm);">
                                    <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                                </a>
                            </td>
                        </xsl:otherwise>
                    </xsl:choose>
                </tr>
            </table>
        </xsl:if>
        <xsl:call-template name="shim"/>
    </xsl:template>

    <xsl:template name="genGraph53">
        <xsl:if test="$condGraph1">
            <form action="Graphes.aspx" method="post" name="FormGraphes" target="_blank">
                <input name="familyNumber" type="hidden" value="1"/>
                <input name="moduleNumber" type="hidden" value="{/FIBEN/@MODDEM}"/>
                <xsl:element name="input">
                    <xsl:attribute name="name">GrapheData</xsl:attribute>
                    <xsl:attribute name="type">hidden</xsl:attribute>
                    <xsl:attribute name="value">
                        &lt;FIBEN MODDEM=&quot;<xsl:value-of select="FIBEN/@MODDEM"/>&quot; DATJOUR=&quot;<xsl:call-template name ="displayDateForGraph2">
                            <xsl:with-param name ="InputDateForGraph" select ="FIBEN/@DATJOUR"/>
                        </xsl:call-template>&quot; GRAPHE=&quot;1&quot;&gt;&lt;ident&gt;<xsl:value-of select="FIBEN/PERSONNE/MODULE53/PM53/EJ/IDENTS"/>&lt;/ident&gt;&lt;nom&gt;<xsl:value-of select="FIBEN/PERSONNE/MODULE53/PM53/EJ/DENOM"/>&lt;/nom&gt;&lt;valcot&gt;<xsl:value-of select="FIBEN/PERSONNE/MODULE53/DIFF53/VALCOT"/>&lt;/valcot&gt;&lt;segment&gt;<xsl:value-of select="FIBEN/PERSONNE/MODULE53/DIFF53/SEGMENT"/>&lt;/segment&gt;&lt;datcot&gt;<xsl:value-of select="FIBEN/PERSONNE/MODULE53/DIFF53/DATCOT"/>&lt;/datcot&gt;&lt;datexa&gt;<xsl:value-of select="FIBEN/PERSONNE/MODULE53/DIFF53/DATEXA"/>&lt;/datexa&gt;&lt;graphe&gt;&lt;serie&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULE53/DIFF53/INFOASSOCIES53/ASSOCIE">
                            &lt;val&gt;<xsl:value-of select="CAPITAL/POURCENTAGE"/>&lt;/val&gt;
                        </xsl:for-each>&lt;/serie&gt;&lt;abcisse&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULE53/DIFF53/INFOASSOCIES53/ASSOCIE">
                            &lt;val&gt;<xsl:if test="ASSOCEJ/EJ">
                                <xsl:value-of select="concat(ASSOCEJ/EJ/IDENTS,'     - ',ASSOCEJ/EJ/DENOM)"/>
                            </xsl:if><xsl:if test="ASSOCPP/PP">
                                <xsl:call-template name ="displayInLowerCaseXsl">
                                    <xsl:with-param name ="InputIdentc" select ="(ASSOCPP/PP/IDENTC)"/>
                                    <xsl:with-param name ="InputStringNom" select ="(ASSOCPP/PP/IDENTITE/NOM)"/>
                                    <xsl:with-param name ="InputStringPrenom" select ="(ASSOCPP/PP/IDENTITE/PRENOM)"/>
                                </xsl:call-template>
                            </xsl:if><xsl:if test="ASSOCSPE/DENOM">
                                <xsl:value-of select="concat('              - ',ASSOCSPE/DENOM)"/>
                            </xsl:if>&lt;/val&gt;
                        </xsl:for-each>&lt;/abcisse&gt;&lt;titre&gt;Rpartition du capital entre les associs (en pourcentage)&lt;/titre&gt;&lt;/graphe&gt;&lt;/FIBEN&gt;
                    </xsl:attribute>
                </xsl:element>
            </form>
        </xsl:if>
    </xsl:template>

</xsl:stylesheet>
