<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:bdf="http://banque-france.fr/namespace">
	<xsl:import href="../../Ressources/XSL/Commun.xsl"/>
  <xsl:import href="../../Ressources/XSL/commun_transfo.xsl"/>
	<xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes"/>
	<xsl:param name="langage" select="'fr'"/>
	<xsl:param name="familyNumber" select="''"/>
  <xsl:param name="root" select="'/Fiben/'"/>
	<xsl:param name="familyName" select="''"/>
	<xsl:param name="familyTitle" select="''"/>
	<xsl:param name="nextModule" select="''"/>
	<xsl:param name="nextId" select="''"/>
	<xsl:param name="nextFamily" select="''"/>
  <xsl:param name="Lang" select="'FR'"/>
  <xsl:param name="NonResident" select="''"/>
	<xsl:param name="menuHTML1"/>
	
<xsl:template match="/">
		<html lang="fr">
      <title>Module 51 - Dirigeants de l'entreprise</title>
			<xsl:call-template name="genHead">
				<xsl:with-param name="ident" select="/FIBEN/ERREUR/IDENT | /FIBEN/PERSONNE/MODULE51/EJ/IDENTS|/FIBEN/ERREUR/IDENTS|FIBEN/ERREUR/IDENTC"/>
			</xsl:call-template>
			<body class="clBodybgcolorWhite">
        <xsl:call-template name="genFondMenu">
          <xsl:with-param name="root" select="$root"/>
        </xsl:call-template>
        <xsl:copy-of select="$menuHTML1"/>
        
			<table class="mainmodule horizontal-auto clBorderCell">
        <caption class="visually-hidden">Module 51 - Dirigeants de l'entreprise</caption>
				<xsl:call-template name="genLigneConfidentiel"/>
				<xsl:apply-templates select="/FIBEN/ERREUR"/>
				<xsl:if test="not(/FIBEN/ERREUR)">

					<tr> 
						 <td class="clWidth64"></td>
						<td class="clCouleur2 clValignTop clWidth739" colspan="4">
              <!-- appel du template avec parametre segment  pas-->
              <xsl:choose >
               <xsl:when test="/FIBEN/PERSONNE/MODULE51/DIFF51/SEGMENT">
                  <xsl:call-template name="genEnTete">
                    <xsl:with-param name="ident" select="/FIBEN/PERSONNE/MODULE51/EJ/IDENTS"/>
                    <xsl:with-param name="nom" select="/FIBEN/PERSONNE/MODULE51/EJ/DENOM"/>
                    <xsl:with-param name="valcot" select="/FIBEN/PERSONNE/MODULE51/DIFF51/VALCOT"/>
                    <xsl:with-param name="segment" select="/FIBEN/PERSONNE/MODULE51/DIFF51/SEGMENT"/>
                  </xsl:call-template>
                </xsl:when>
                <xsl:otherwise >
                  <xsl:call-template name="genEnTete">
                    <xsl:with-param name="ident" select="/FIBEN/PERSONNE/MODULE51/EJ/IDENTS"/>
                    <xsl:with-param name="nom" select="/FIBEN/PERSONNE/MODULE51/EJ/DENOM"/>
                    <xsl:with-param name="valcot" select="/FIBEN/PERSONNE/MODULE51/DIFF51/VALCOT"/>
                  </xsl:call-template>
               </xsl:otherwise>
              </xsl:choose>
             						
              <xsl:apply-templates select="/FIBEN/PERSONNE/MODULE51/DIFF51/NBDIRIGEANT"/>
              <xsl:apply-templates select="/FIBEN/PERSONNE/MODULE51/DIFF51/DIRIGEANT"/>
              <xsl:apply-templates select="/FIBEN/PERSONNE/MODULE51/DIFF51/NBDIRIGEANTCESSE"/>
              <xsl:apply-templates select="/FIBEN/PERSONNE/MODULE51/DIFF51/DIRIGEANTCESSE"/>
						</td>
					</tr>
					<xsl:if test="/FIBEN/PERSONNE/MODULE51/IEC01|/FIBEN/PERSONNE/MODULE51/IST10|/FIBEN/PERSONNE/MODULE51/IST11">
						<tr>
							<td class="clWidth64"></td>
							<td colspan="3" class="clCouleur2 clValignTop clWidth635 clAlignJustify">
								<xsl:apply-templates select="/FIBEN/PERSONNE/MODULE51/IEC01|/FIBEN/PERSONNE/MODULE51/IST10|/FIBEN/PERSONNE/MODULE51/IST11"/>
              </td>
              <td class="clWidth104">&#160;</td>
              
						</tr>
						<tr>
							<td class="clWidth14"></td>
							<td colspan="4"><xsl:call-template name="shim"/></td>
						</tr>
					</xsl:if>
					
					
				</xsl:if>
			</table>
      <xsl:call-template name="genBasPage"/>

		</body>
	</html>
</xsl:template>
	
<xsl:template match="NBDIRIGEANT">
  <a name="ancActuel"></a>
	<table class="clWidth635 clBorderCell" role="presentation">
		<tr class="clAlignCenter">
			<td class="clCouleurGras">
			DIRIGEANT(S) ACTIF(S) DE L'ENTREPRISE (<xsl:value-of select="."/>)<br/>
				<xsl:call-template name="shim"/>
			</td>
		</tr>
	</table>
</xsl:template>

<xsl:template match="DIRIGEANT">
	<table class="clWidth739 clBorderCell">
    <caption class="visually-hidden">DIRIGEANT(S) ACTIF(S) DE L'ENTREPRISE</caption>
		<tr>
			<td class="clGrasFond" colspan="2">
				<xsl:apply-templates select="FONCTCOT"/>
			</td>
			<xsl:if test="FONCTCOT/DATFONCT">
				<th class="clFond clAlignRight clThNonGras" colspan="2"> Depuis le :</th>
				<td class="clFond clWidth90 clAlignRight">
          <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="(FONCTCOT/DATFONCT)"/>
          </xsl:call-template>
			  </td>
			</xsl:if>
			<xsl:if test="not(FONCTCOT/DATFONCT)">
				<td colspan="2" class="clFond">&#160;</td>
				<td class="clFond clWidth90">&#160;</td>
			</xsl:if>
			<xsl:if test="position() mod 3 = 0">
				<td class="clWidth103 clAlignRight" rowspan="3">
					<a href="#ancHaut"><img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page" /></a>
				</td>
			</xsl:if>
			<xsl:if test="position() mod 3 != 0">
				<td class="clWidth103 clAlignRight" rowspan="3">
					&#160;
				</td>
			</xsl:if>
		</tr>
		<tr>
			<xsl:if test="EJ/DENOM">
				<td class="clTexteGras" colspan="5">
					&#160;<xsl:value-of select="EJ/DENOM"/>
				</td>
			</xsl:if>
			<xsl:if test="not(EJ/DENOM)">
				<td class="clTexteGras" colspan="2">
					&#160;<xsl:call-template name ="displayInLowerCaseXsl">
          <xsl:with-param name ="InputStringNom" select ="(PP/IDENTITE/NOM)"/>
          <xsl:with-param name ="InputStringPrenom" select ="(PP/IDENTITE/PRENOM)"/>
        </xsl:call-template>
          
				</td>
				<xsl:if test="PP/IDENTITE/NOMCONJ">
					<th class="clCouleur2 clWidth79 clAlignLeft clThNonGras">&#160;Nom marital</th>
					<td class="clTexte" colspan="2">
						&#160;<xsl:value-of select="PP/IDENTITE/NOMCONJ"/>
					</td>
				</xsl:if>
				<xsl:if test="not(PP/IDENTITE/NOMCONJ)">
					<td class="clWidth54">&#160;</td>
					<td colspan="2">&#160;</td>
				</xsl:if>
			</xsl:if>
		</tr>
    <!-- ligne differentes selon cotation avec ou sans segmentation -->

    <xsl:choose>
      <xsl:when test ="FONCTCOT/SEGMENT">
        <tr>
          <th class="clCouleur2 clWidth59 clAlignLeft clValignMiddle clThNonGras">&#160;Identifiant</th>
          <td class="clFond clWidth165">
            &#160;
            <xsl:if test="EJ/IDENTS">
              <xsl:call-template name ="displaySirenXsl">
                <xsl:with-param name ="InputSiren" select ="(EJ/IDENTS)"/>
              </xsl:call-template>
            </xsl:if>
            <!--<xsl:value-of select="PP/IDENTC"/>-->
          </td>

          <xsl:if test="not(FONCTCOT/VALCOT='NS')">
            <th class="clCouleur2 clWidth153 clAlignLeft clThNonGras">&#160;Cotation | Segmentation</th>
            <xsl:variable name="ident" select="EJ/IDENTS"/>
            <xsl:if test="not(FONCTCOT/VALCOT='ND')">
              <td class="clFond clWidth166">
                &#160;<a href="#nullepart" class="clFond" onclick="requestVariousInfos('{FONCTCOT/VALCOT}',cstCotation,'{$ident}')">
                  <u>
                    <xsl:value-of select="FONCTCOT/VALCOT"/>
                  </u>
                </a>
                <a href="#nullepart" class="clTexte" onclick="requestInfosLibelle('segmentation',cstSegment);">
                  &#160;|&#160;<u>
                    <xsl:value-of select="FONCTCOT/SEGMENT"/>
                  </u>
                </a>
              </td>
            </xsl:if>
            <xsl:if test="(FONCTCOT/VALCOT='ND')">
              <td class="clFond clWidth166">
                &#160;<a href="#nullepart" class="clFond" onclick="requestVariousInfos('{FONCTCOT/VALCOT}',cstCotationNonDif,'{$ident}')">
                  <u>
                    <xsl:value-of select="FONCTCOT/VALCOT"/>
                  </u>
                </a>
                <a href="#nullepart" class="clTexte" onclick="requestInfosLibelle('segmentation',cstSegment);">
                  &#160;|&#160;<u>
                    <xsl:value-of select="FONCTCOT/SEGMENT"/>
                  </u>
                </a>
              </td>
            </xsl:if>
            
          </xsl:if>
          <xsl:if test="not(FONCTCOT/VALCOT='NS')">
            <td class="clFond clWidth92 clAlignRight clValignMiddle">
              <a href="#nullepart" onClick="requestBDFInfos('27|37|39|56|','','1','{PP/IDENTC|EJ/IDENTS}',cstMultipleConfirm);">
                <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
              </a>
            </td>
          </xsl:if>
          <xsl:if test="(FONCTCOT/VALCOT='NS')">
           <td class="clFond clWidth319" colspan="2">
              &#160;
            </td>
            <td class="clFond clWidth92 clAlignRight clValignMiddle">
              <a href="#nullepart" onClick="requestBDFInfos('27|','','1','{PP/IDENTC|EJ/IDENTS}',cstMultipleConfirm);">
                <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
              </a>
            </td>
          </xsl:if>
        </tr>
        <tr>
          <td class="clTexte clAlignLeft" colspan="4">
            &#160;
          </td>
          <td class="clWidth92">
            &#160;
          </td>
        </tr>
      </xsl:when>
      <xsl:otherwise>
        <tr>
          <th class="clCouleur2 clWidth59 clAlignLeft clValignMiddle clThNonGras">&#160;Identifiant</th>
          <td class="clFond clWidth255">
            &#160;
            <xsl:if test="EJ/IDENTS">
              <xsl:call-template name ="displaySirenXsl">
                <xsl:with-param name ="InputSiren" select ="(EJ/IDENTS)"/>
              </xsl:call-template>
            </xsl:if>
            <xsl:value-of select="PP/IDENTC"/>
          </td>

          <xsl:if test="not(FONCTCOT/VALCOT='NS')">
            <xsl:if test="EJ">
              <th class="clCouleur2 clWidth63 clAlignLeft clThNonGras">&#160;Cotation</th>
            </xsl:if>
            <xsl:if test="PP">
              <th class="clCouleur2 clWidth63 clAlignLeft clThNonGras">&#160;Indicateur</th>
            </xsl:if>
            <xsl:variable name="ident" select="EJ/IDENTS|PP/IDENTC"/>
            <xsl:if test="not(FONCTCOT/VALCOT='ND')">
              <td class="clFond clWidth166">
                &#160;<a href="#nullepart" class="clFond" onclick="requestVariousInfos('{FONCTCOT/VALCOT}',cstCotation,'{$ident}')">
                  <u>
                    <xsl:value-of select="FONCTCOT/VALCOT"/>
                  </u>
                </a>
              </td>
            </xsl:if>
            <xsl:if test="(FONCTCOT/VALCOT='ND')">
              <td class="clFond clWidth166">
                &#160;<a href="#nullepart" class="clFond" onclick="requestVariousInfos('{FONCTCOT/VALCOT}',cstCotationNonDif,'{$ident}')">
                  <u>
                    <xsl:value-of select="FONCTCOT/VALCOT"/>
                  </u>
                </a>
              </td>
            </xsl:if>
          </xsl:if>
          <xsl:if test="not(FONCTCOT/VALCOT='NS')">
            <td class="clFond clWidth92 clAlignRight clValignMiddle">
              <a href="#nullepart" onClick="requestBDFInfos('27|37|56|','','1','{PP/IDENTC|EJ/IDENTS}',cstMultipleConfirm);">
                <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
              </a>
            </td>
          </xsl:if>
          <xsl:if test="(FONCTCOT/VALCOT='NS')">
           <td class="clFond clWidth319" colspan="2">
              &#160;
            </td>
            <td class="clFond clWidth92 clAlignRight clValignMiddle">
              <a href="#nullepart" onClick="requestBDFInfos('27|','','1','{PP/IDENTC|EJ/IDENTS}',cstMultipleConfirm);">
                <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
              </a>
            </td>
          </xsl:if>
        </tr>
        <xsl:choose>
          <xsl:when test ="FONCTCOT/AUTRFDEI">
            <tr>
              <td class="clTexte clAlignLeft" colspan="4">
                &#160;Prsence d&#039;autre(s) fonction(s) de reprsentant(s) lgal(aux) exerce(s)
              </td>
              <td class="clWidth92">
                &#160;
              </td>
            </tr>
          </xsl:when>
          <xsl:otherwise>
            <tr>
              <td class="clTexte clAlignLeft" colspan="4">
                &#160;
              </td>
              <td class="clWidth92">
                &#160;
              </td>
            </tr>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose> 
    
   
	</table>
	<xsl:call-template name="shim"/>
</xsl:template>
  
  <xsl:template match="NBDIRIGEANTCESSE">
    <a name="ancCesse" />
      <table class="clWidth635 clBorderCell" role="presentation">
       <tr class="clAlignCenter">
          <td class="clCouleurGras">
            DIRIGEANT(S) DE L'ENTREPRISE AYANT CESS&#201;
          SON(LEUR) ACTIVIT&#201; (<xsl:value-of select="."/>)<br/>
            <xsl:call-template name="shim"/>
          </td>
        </tr>
      </table>
    </xsl:template>
  
  <xsl:template match="DIRIGEANTCESSE">
    <table class="clWidth739 clBorderCell">
      <caption class="visually-hidden">
        DIRIGEANT(S) DE L'ENTREPRISE AYANT CESS SON(LEUR) ACTIVIT</caption>
      <tr>
        <td class="clGrasFond" colspan="2">
          <xsl:apply-templates select="FONCTCOT"/>
        </td>
        <xsl:if test="FONCTCOT/DATFONCT">
          <th class="clFond clAlignRight clThNonGras" colspan="2"> Depuis le :</th>
          <td class="clFond clWidth90 clAlignRight">
            <xsl:call-template name ="displayDateXsl">
              <xsl:with-param name ="InputDate" select ="(FONCTCOT/DATFONCT)"/>
            </xsl:call-template>
          </td>
        </xsl:if>
        <xsl:if test="not(FONCTCOT/DATFONCT)">
          <td colspan="2" class="clFond">&#160;</td>
          <td class="clFond clWidth90">&#160;</td>
        </xsl:if>
        <xsl:if test="position() mod 3 = 0">
          <td class="clWidth103 clAlignRight" rowspan="3">
            <a href="#ancHaut">
              <img src="{$root}/Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page" />
            </a>
          </td>
        </xsl:if>
        <xsl:if test="position() mod 3 != 0">
          <td class="clWidth103 clAlignRight" rowspan="3">
            &#160;
          </td>
        </xsl:if>
      </tr>
    <xsl:apply-templates select="CESSATION"/>

      <tr>
        <xsl:if test="EJ/DENOM">
          <td class="clTexteGras" colspan="5">
            &#160;<xsl:value-of select="EJ/DENOM"/>
          </td>
        </xsl:if>
        <xsl:if test="not(EJ/DENOM)">
          <td class="clTexteGras" colspan="2">
            &#160;<xsl:call-template name ="displayInLowerCaseXsl">
            <xsl:with-param name ="InputStringNom" select ="(PP/IDENTITE/NOM)"/>
            <xsl:with-param name ="InputStringPrenom" select ="(PP/IDENTITE/PRENOM)"/>
          </xsl:call-template>
          </td>
          <xsl:if test="PP/IDENTITE/NOMCONJ">
            <th class="clCouleur2 clWidth79 clAlignLeft clThNonGras">&#160;Nom marital</th>
            <td class="clTexte" colspan="2">
              &#160;<xsl:value-of select="PP/IDENTITE/NOMCONJ"/>
            </td>
          </xsl:if>
          <xsl:if test="not(PP/IDENTITE/NOMCONJ)">
            <td class="clWidth54">&#160;</td>
            <td colspan="2">&#160;</td>
          </xsl:if>
        </xsl:if>
      </tr>
      <!-- ligne differentes selon cotation avec ou sans segmentation -->
      
      <xsl:choose>
        <xsl:when test ="FONCTCOT/SEGMENT">
          <tr>

            <th class="clCouleur2 clWidth59 clAlignLeft clValignMiddle clThNonGras">&#160;Identifiant</th>
            <td class="clTexte clWidth165">
              &#160;
              <xsl:if test="EJ/IDENTS">
                <xsl:call-template name ="displaySirenXsl">
                  <xsl:with-param name ="InputSiren" select ="(EJ/IDENTS)"/>
                </xsl:call-template>
              </xsl:if>
              <!--<xsl:value-of select="PP/IDENTC"/>-->
            </td>

            <xsl:if test="not(FONCTCOT/VALCOT='NS')">
              <th class="clCouleur2 clWidth153 clAlignLeft clThNonGras">&#160;Cotation | Segmentation</th>
              <xsl:variable name="ident" select="EJ/IDENTS"/>
              <xsl:if test="not(FONCTCOT/VALCOT='ND')">
                <td class="clTexte clWidth166">
                  &#160;<a href="#nullepart" class="clTexte" onclick="requestVariousInfos('{FONCTCOT/VALCOT}',cstCotation,'{$ident}')">
                    <u>
                      <xsl:value-of select="FONCTCOT/VALCOT"/>
                    </u>
                  </a>
                  <a href="#nullepart" class="clTexte" onclick="requestInfosLibelle('segmentation',cstSegment);">
                    &#160;|&#160;<u>
                      <xsl:value-of select="FONCTCOT/SEGMENT"/>
                    </u>
                  </a>
                </td>
              </xsl:if>
              <xsl:if test="(FONCTCOT/VALCOT='ND')">
                <td class="clTexte clWidth166">
                  &#160;<a href="#nullepart" class="clTexte" onclick="requestVariousInfos('{FONCTCOT/VALCOT}',cstCotationNonDif,'{$ident}')">
                    <u>
                      <xsl:value-of select="FONCTCOT/VALCOT"/>
                    </u>
                  </a>
                  <a href="#nullepart" class="clTexte" onclick="requestInfosLibelle('segmentation',cstSegment);">
                    &#160;|&#160;<u>
                      <xsl:value-of select="FONCTCOT/SEGMENT"/>
                    </u>
                  </a>
                </td>
              </xsl:if>             
            </xsl:if>
            <xsl:if test="not(FONCTCOT/VALCOT='NS')">
              <td class="clTexte clWidth92 clAlignRight clValignMiddle">
                <a href="#nullepart" onClick="requestBDFInfos('27|37|39|56|','','1','{PP/IDENTC|EJ/IDENTS}',cstMultipleConfirm);">
                  <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                </a>
              </td>
            </xsl:if>
            <xsl:if test="(FONCTCOT/VALCOT='NS')">
             <td class="clFond clWidth319" colspan="2">
                &#160;
              </td>
              <td class="clTexte clWidth92 clAlignRight clValignMiddle">
                <a href="#nullepart" onClick="requestBDFInfos('27|','','1','{PP/IDENTC|EJ/IDENTS}',cstMultipleConfirm);">
                  <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                </a>
              </td>
            </xsl:if>
          </tr>
          <tr>
            <td class="clTexte clAlignLeft" colspan="4">
              &#160;
            </td>
            <td class="clWidth92">
              &#160;
            </td>
          </tr>
        </xsl:when>
        <xsl:otherwise>
          <tr>
            <th class="clCouleur2 clWidth59 clAlignLeft clValignMiddle clThNonGras">&#160;Identifiant</th>
            <td class="clFond clWidth255">
              &#160;
              <xsl:if test="EJ/IDENTS">
                <xsl:call-template name ="displaySirenXsl">
                  <xsl:with-param name ="InputSiren" select ="(EJ/IDENTS)"/>
                </xsl:call-template>
              </xsl:if>
              <xsl:value-of select="PP/IDENTC"/>
            </td>

            <xsl:if test="EJ">
              <th class="clCouleur2 clWidth63 clAlignLeft clThNonGras">&#160;Cotation</th>
            </xsl:if>
            <xsl:if test="not(FONCTCOT/VALCOT='NS')">
              <xsl:if test="PP">
                <th class="clCouleur2 clWidth63 clAlignLeft clThNonGras">&#160;Indicateur</th>
              </xsl:if>
              <xsl:variable name="ident" select="EJ/IDENTS|PP/IDENTC"/>
              <xsl:if test="not(FONCTCOT/VALCOT='ND')">
                <td class="clFond clWidth166">
                  &#160;<a href="#nullepart" class="clFond" onclick="requestVariousInfos('{FONCTCOT/VALCOT}',cstCotation,'{$ident}')">
                    <u>
                      <xsl:value-of select="FONCTCOT/VALCOT"/>
                    </u>
                  </a>
                </td>
              </xsl:if>
              <xsl:if test="(FONCTCOT/VALCOT='ND')">
                <td class="clFond clWidth166">
                &#160;<a href="#nullepart" class="clFond" onclick="requestVariousInfos('{FONCTCOT/VALCOT}',cstCotationNonDif,'{$ident}')">
                  <u>
                    <xsl:value-of select="FONCTCOT/VALCOT"/>
                  </u>
                </a>
              </td>
              </xsl:if>
              
            </xsl:if>
            <xsl:if test="not(FONCTCOT/VALCOT='NS')">
              <td class="clFond clWidth92 clAlignRight clValignMiddle">
                <a href="#nullepart" onClick="requestBDFInfos('27|37|56|','','1','{PP/IDENTC|EJ/IDENTS}',cstMultipleConfirm);">
                  <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                </a>
              </td>
            </xsl:if>
            <xsl:if test="(FONCTCOT/VALCOT='NS')">
             <td class="clFond clWidth319" colspan="2">
                &#160;
              </td>
              <td class="clFond clWidth92 clAlignRight clValignMiddle">
                <a href="#nullepart" onClick="requestBDFInfos('27|','','1','{PP/IDENTC|EJ/IDENTS}',cstMultipleConfirm);">
                  <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                </a>
              </td>
            </xsl:if>
          </tr>
          <xsl:choose>
            <xsl:when test ="FONCTCOT/AUTRFDEI">
              <tr>
                <td class="clTexte clAlignLeft" colspan="4">
                  &#160;Prsence d&#039;autre(s) fonction(s) de reprsentant(s) lgal(aux) exerce(s)
                </td>
                <td class="clWidth92">
                  &#160;
                </td>
              </tr>
            </xsl:when>
            <xsl:otherwise>
              <tr>
                <td class="clTexte clAlignLeft" colspan="4">
                  &#160;
                </td>
                <td class="clWidth92">
                  &#160;
                </td>
              </tr>
            </xsl:otherwise>
          </xsl:choose>
          
        </xsl:otherwise> 
      </xsl:choose>
      
     
    </table>
    <xsl:call-template name="shim"/>
  </xsl:template>

  <xsl:template match="CESSATION">
    <tr>
      <td class="clTexte" colspan="2" >
        &#160;<xsl:call-template name="traduction">
          <xsl:with-param name="code" select="@COCESS"/>
        </xsl:call-template>
      </td>
      <xsl:if test="@DATCESS != ''">
        <th class="clTexte clAlignRight clThNonGras" colspan="2"> Cess(e) depuis le :</th>
        <td class="clTexte clAlignRight clWidth90">
          <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="(@DATCESS)"/>
          </xsl:call-template>
        </td>
      </xsl:if>
      <xsl:if test="not(@DATCESS)">
        <td class="clTexte" colspan="2">&#160;</td>
        <td class="clFond clWidth90">&#160;</td>
      </xsl:if>


    </tr>
  </xsl:template>
  

</xsl:stylesheet>
