<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
					              xmlns:bdf="http://banque-france.fr/namespace">
	<xsl:import href="../../Ressources/XSL/Commun.xsl"/>
  <xsl:import href="../../Ressources/XSL/commun_transfo.xsl"/>
	<xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes"/>
	<xsl:param name="langage" select="'fr'"/>
	<xsl:param name="familyName" select="''"/>
  <xsl:param name="root" select="'/Fiben/'"/>
	<xsl:param name="familyNumber" select="''"/>
	<xsl:param name="familyTitle" select="''"/>
	<xsl:param name="nextModule" select="''"/>
	<xsl:param name="nextId" select="''"/>
	<xsl:param name="nextFamily" select="''"/>
   <xsl:param name="Lang" select="'FR'"/>
  <xsl:param name="NonResident" select="''"/>
	<xsl:param name="menuHTML1"/>

<xsl:template match="/">
	<html lang="fr">
    <title>Module 45 - Jugements</title>
		<xsl:call-template name="genHead">
			<xsl:with-param name="ident" select="FIBEN/ERREUR/IDENT | FIBEN/PERSONNE/MODULE45/PP/IDENTC | FIBEN/PERSONNE/MODULE45/PM45/EJ/IDENTS | FIBEN/PERSONNE/MODULE45/PM45/EI45/IDENTS"/>
		</xsl:call-template>
		<body class="clBodybgcolorWhite">
      <xsl:call-template name="genFondMenu">
        <xsl:with-param name="root" select="$root"/>
      </xsl:call-template>
      <xsl:copy-of select="$menuHTML1"/>
      
			<table class="mainmodule horizontal-auto clBorderCell">
        <caption class="visually-hidden">Module 45 - Jugements</caption>
				<xsl:call-template name="genLigneConfidentiel"/>
				<xsl:apply-templates select="/FIBEN/ERREUR"/>
				<xsl:if test="not(/FIBEN/ERREUR)">
					<tr> 
	    				 <td class="clWidth64"></td>
						<td colspan="3" class="clItalic clValignTop clHeight22"></td>
						<td class="clWidth103"></td>
					</tr>
					<tr>
						<td class="clWidth14"></td>
						<td class="clWidth636 clCouleur2 clValignTop" colspan="3">
							<xsl:apply-templates select="FIBEN/PERSONNE/MODULE45/PP"/>
							<xsl:apply-templates select="FIBEN/PERSONNE/MODULE45/PM45/EJ"/>
							<xsl:apply-templates select="FIBEN/PERSONNE/MODULE45/PM45/EI45"/>
						</td>
						<td class="clWidth103 clAlignRight">
							<img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page" />
						</td>
						</tr>
						<tr>
						<td class="clWidth14"></td>
						<td class="clCouleur2 clValignTop clWidth636" colspan="4">
							<xsl:apply-templates select="FIBEN/PERSONNE/MODULE45/IEVJ01" mode="genMessage"/>
							<xsl:apply-templates select="FIBEN/PERSONNE/MODULE45/DIFF45/NBJUGEMENT"/>
							<xsl:apply-templates select="FIBEN/PERSONNE/MODULE45/DIFF45/JUGEMENT/EVJUD"/>
							<xsl:apply-templates select="FIBEN/PERSONNE/MODULE45/DIFF45/PEVJANT" mode="genFont"/>
							<xsl:apply-templates select="FIBEN/PERSONNE/MODULE45/DIFF45/IDLIES"/>
							<xsl:apply-templates select="FIBEN/PERSONNE/MODULE45/PP/HOMONYME"/>
						</td>
					</tr>	

				</xsl:if>
			</table>
		  <xsl:call-template name="genBasPage"/>
		</body>
	</html>
</xsl:template>
	
<xsl:template match="NBJUGEMENT">
	<table class="clWidth635 clBorderCell">
		<tr class="clAlignCenter">
			<td class="clCouleurGras">
				JUGEMENT(S) (<xsl:value-of select="."/>)<br/>
				<xsl:call-template name="shim"/>
			</td>
		</tr>
	</table>
</xsl:template>
<xsl:template match="JUGEMENT/EVJUD">
    <table class="clWidth739 clBorderCell">
      <caption class="visually-hidden">Jugement(s)</caption>
      <tr>
        <td colspan="6" class="clGrasFond">
          &#160;<xsl:apply-templates select="EVJAM|EVJAP|EVJCM|EVJCP|EVJCT|EVJCV|EVJDM|EVJDU|EVJEM|EVJFM|EVJFP|EVJGA|EVJGD|EVJGO|EVJGR|EVJHC|EVJHM|EVJIA|EVJIC|EVJIG|EVJIM|EVJIP|EVJIT|EVJLB|EVJLG|EVJLJ|EVJLM|EVJPA|EVJPC|EVJPM|EVJPO|EVJPV|EVJRC|EVJRD|EVJRG|EVJRJ|EVJRL|EVJRM|EVJRP|EVJRR|EVJRS|EVJSM|EVJAC|EVJCR|EVJOS|EVJOB|EVJPS|EVJRPS|EVJOD|EVJOT|EVJOP|EVJPT|EVJRT|EVJMC"/>
        </td>
        <xsl:if test="position() mod 3 = 0">
          <td rowspan="13" class="clWidth103 clAlignRight">
            <a href="#ancHaut">
              <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page" />
            </a>
          </td>
        </xsl:if>
        <xsl:if test="position() mod 3 != 0">
          <td rowspan="13" class="clWidth103 clAlignRight">
            &#160;
          </td>
        </xsl:if>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth30 clAlignLeft clThNonGras">&#160;Le</th>
        <td class="clTexte clWidth90">
          &#160;
          <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="(DATEVJ)"/>
          </xsl:call-template>
          <xsl:value-of select="Date"/>
        </td>
        <th class="clCouleur2 clWidth120 clAlignRight clThNonGras">
          <xsl:if test="DATECHJUG">
            Jusqu'au&#160;&#160;
          </xsl:if>
        </th>
        <td class="clTexte clWidth108">
          &#160;
          <xsl:if test="DATECHJUG">
            <xsl:call-template name ="displayDateXsl">
              <xsl:with-param name ="InputDate" select ="(DATECHJUG)"/>
            </xsl:call-template>
            <xsl:value-of select="Date"/>
          </xsl:if>
        </td>
        <xsl:if test="../TRIBU">
          <th class="clCouleur2 clWidth100 clAlignLeft clThNonGras">&#160;Tribunal</th>
          <td class="clTexte clWidth187">
            &#160;<xsl:value-of select="../TRIBU"/>
          </td>
        </xsl:if>
        <xsl:if test="not(../TRIBU)">
          <td class="clCouleur2 clWidth100">&#160;</td>
          <td class="clTexte clWidth187">&#160;</td>
        </xsl:if>
      </tr>
    </table>
    <xsl:call-template name="shim"/>

  </xsl:template>

<xsl:template match="PEVJANT" mode="genFont">
	<br />
	<span class="clCouleur2">
		<xsl:apply-templates select="."/>
	</span>
	<br />
	<xsl:call-template name="shim"/>
<br/>
</xsl:template>

<xsl:template match="FIBEN/PERSONNE/MODULE45/PP">
   <!--<xsl:element name="chaine">
            <xsl:value-of select="IDENTITE/PRENOM"/>
          </xsl:element>-->
	<xsl:call-template name="genEnTete">
		<xsl:with-param name="ident" select="IDENTC"/>
		<xsl:with-param name="nom">
      <xsl:call-template name ="displayInLowerCaseXsl">
        <xsl:with-param name ="InputStringNom" select ="(IDENTITE/NOM)"/>
        <xsl:with-param name ="InputStringPrenom" select ="(IDENTITE/PRENOM)"/>
      </xsl:call-template>    
    </xsl:with-param>
		<xsl:with-param name="nomconj" select="IDENTITE/NOMCONJ"/>
		<xsl:with-param name="idnouv" select="/FIBEN/PERSONNE/IDNOUV"/>
	</xsl:call-template>
</xsl:template>

<xsl:template match="FIBEN/PERSONNE/MODULE45/PM45/EJ">
	<xsl:call-template name="genEnTete">
		<xsl:with-param name="ident" select="IDENTS"/>
		<xsl:with-param name="nom" select="DENOM"/>
		<xsl:with-param name="idnouv" select="/FIBEN/PERSONNE/IDNOUV"/>
	</xsl:call-template>
</xsl:template>

  <xsl:template match="FIBEN/PERSONNE/MODULE45/PM45/EI45">
    <xsl:call-template name="genEnTete">
      <xsl:with-param name="ident" select="IDENTS"/>
      <xsl:with-param name="nom">
        <xsl:call-template name ="displayInLowerCaseXsl">
          <xsl:with-param name ="InputStringNom" select ="(IDENTITE/NOM)"/>
          <xsl:with-param name ="InputStringPrenom" select ="(IDENTITE/PRENOM)"/>
        </xsl:call-template>
      </xsl:with-param>
      <xsl:with-param name="nomconj" select="IDENTITE/NOMCONJ"/>
      <xsl:with-param name="idnouv" select="/FIBEN/PERSONNE/IDNOUV"/>
    </xsl:call-template >
  </xsl:template>

<xsl:template match="IEVJ01" mode="genMessage">
	<xsl:apply-templates select="."/>
	<br />
	<xsl:call-template name="shim"/>

	<br/>
</xsl:template>

<xsl:template match="text()"/>

</xsl:stylesheet>

