<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
					              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
					              xmlns:bdf="http://banque-france.fr/namespace">                       
  <xsl:import href="../../Ressources/XSL/Commun.xsl"/>
  <xsl:import href="../../Ressources/XSL/commun_transfo.xsl"/>
  <xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes" />
  <xsl:param name="langage" select="'fr'"/>
  <xsl:param name="familyName" select="''"/>
  <xsl:param name="root" select="'/Fiben/'"/>
  <xsl:param name="familyNumber" select="''"/>
  <xsl:param name="familyTitle" select="''"/>
  <xsl:param name="nextModule" select="''"/>
  <xsl:param name="nextId" select="''"/>
  <xsl:param name="nextFamily" select="''"/>
  <xsl:param name="Lang" select="'FR'"/>
  <xsl:param name="NonResident" select="''"/>
  <xsl:param name="menuHTML1"/>

  <xsl:template match="/">
    <html lang="fr">
      <title>Module 41 - Sige et tablissements secondaires</title>
      <xsl:call-template name="genHead">
        <xsl:with-param name="ident" select="FIBEN/ERREUR/IDENT | FIBEN/PERSONNE/MODULE41/EJ/IDENTS"/>
      </xsl:call-template>
      <body class="clBodybgcolorWhite">
        <xsl:call-template name="genFondMenu">
          <xsl:with-param name="root" select="$root"/>
        </xsl:call-template>
        <xsl:copy-of select="$menuHTML1"/>
        <table class="mainmodule horizontal-auto clBorderCell">
          <caption class="visually-hidden">Module 41 - Sige et tablissements secondaires</caption>
          <xsl:call-template name="genLigneConfidentiel"/>
          <xsl:apply-templates select="/FIBEN/ERREUR"/>
          <xsl:if test="not(/FIBEN/ERREUR)">
            <tr>
               <td class="clWidth64"></td>
              <td class="clCouleur2 clValignTop clWidth739" colspan="4">
                <xsl:apply-templates select="FIBEN/PERSONNE/MODULE41/EJ"/>
                <xsl:apply-templates select="FIBEN/PERSONNE/MODULE41/IST10|FIBEN/PERSONNE/MODULE41/IET02" mode="genTable"/>
                <xsl:apply-templates select="FIBEN/PERSONNE/MODULE41/DIFF41"/>
              </td>
            </tr>

          </xsl:if>
        </table>
        <xsl:call-template name="genBasPage"/>

      </body>
    </html>
  </xsl:template>

  <xsl:template match="FIBEN/PERSONNE/MODULE41/EJ">
    <xsl:call-template name="genEnTete">
      <xsl:with-param name="ident" select="IDENTS"/>
      <xsl:with-param name="nom" select="DENOM"/>
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="IST10|IET02" mode="genTable">
    <table class="clWidth635 clBorderCell">
      <tr>
        <td class="clWidth14"></td>
        <td class="clCouleur2 clValignTop">
          <xsl:apply-templates select="."/>
        </td>
      </tr>
      <tr>
        <td class="clWidth14"></td>
        <td>
          <xsl:call-template name="shim"/>
        </td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template match="DIFF41">
    <xsl:apply-templates select="DATCRE"/>
    <xsl:apply-templates select="MONOETABLISSEMENT"/>
    <xsl:apply-templates select="MULTIETABLISSEMENT"/>
  </xsl:template>

  <xsl:template match="DATCRE">
    <table class="clWidth635 clBorderCell">
      <tr>
        <th class="clCouleur2 clWidth210 clThNonGras clAlignLeft clThNonGras">Anne de cration de l'entreprise</th>
        <td class="clFond clWidth425">
          &#160;<xsl:value-of select="."/>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
  </xsl:template>

  <xsl:template match="MONOETABLISSEMENT">
    <table class="clWidth635 clBorderCell">
     <tr class="clAlignCenter">
        <td class="clCouleurGras">ENTREPRISE MONO-ETABLISSEMENT</td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br />
    <xsl:apply-templates select="INVENTAIRE"/>
  </xsl:template>

  <xsl:template match="MULTIETABLISSEMENT">
    <xsl:if test="ETABLISSEMENT/SIEGE">
      <table class="clWidth635 clBorderCell">
       <tr class="clAlignCenter">
          <td class="clCouleurGras">SIGE SOCIAL</td>
        </tr>
      </table>
      <xsl:call-template name="shim"/>
      <br />
      <xsl:apply-templates select="ETABLISSEMENT[SIEGE]"/>
    </xsl:if>
    <xsl:choose>

      <xsl:when test="(480 > NBETAB)">
        <table class="clWidth635 clBorderCell">
         <tr class="clAlignCenter">
            <td class="clCouleurGras">
              TABLISSEMENTS (<xsl:value-of select="count(ETABLISSEMENT)-count(ETABLISSEMENT[SIEGE])"/>)
            </td>
          </tr>
        </table>
        <xsl:call-template name="shim"/>
        <br />
        <xsl:apply-templates select="ETABLISSEMENT[not(SIEGE)]"/>
      </xsl:when>

      <xsl:when test="(NBETABTOT &gt; 480)">
        <table class="clWidth635 clBorderCell">
         <tr class="clAlignCenter">
            <td class="clCouleurGras clHeight25">
              TABLISSEMENTS (<xsl:value-of select="count(ETABLISSEMENT)-count(ETABLISSEMENT[SIEGE])"/> tablissements affichs sur un total de <xsl:value-of select="NBETABTOT"/>)
            </td>
          </tr>
        </table>
        <table class="clWidth635 clBorderCell">
          <tr>
            <td class="clWidth25"></td>
            <td class="clCouleur2 clWidth580 clAlignCenter">
              <xsl:apply-templates select="//NBETABTOT" />
            </td>

          </tr>
        </table>

        <xsl:call-template name="shim"/>
        <br />
        <xsl:apply-templates select="ETABLISSEMENT[not(SIEGE)]"/>
      </xsl:when>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="ETABLISSEMENT">
    <table class="clWidth739 clBorderCell">
      <tr>
        <th class="clCouleur2 clWidth50 clAlignLeft clThNonGras">&#160;SIRET</th>
       <td class="clFond clWidth160">
          &#160;<xsl:call-template name ="displaySiretXsl">
            <xsl:with-param name ="InputSiret" select ="(SIRET)"/>
          </xsl:call-template>          
        </td>
        <td class="clgRASFond clWidth336">
          <xsl:value-of select="LOCALI"/>
        </td>
        <th class="clCouleur2 clWidth45 clThNonGras">&#160;Anne</th>
        <td class="clFond clWidth45">
          &#160;<xsl:value-of select="INVENTAIRE/DATINV"/>
        </td>
        <xsl:if test="position() mod 3 = 0">
          <td class="clWidth103 clAlignRight">
            <a href="#ancHaut">
              <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page" />
            </a>
          </td>
        </xsl:if>
        <xsl:if test="position() mod 3 != 0">
          <td class="clWidth103 clAlignRight">
            &#160;
          </td>
        </xsl:if>
      </tr>
    </table>
    <table class="clWidth635 clBorderCell">
      <tr>
        <td class="clTexte" colspan="2">
          &#160;<xsl:value-of select="DENOM"/>
        </td>
        <xsl:if test="CESSACT">
          <th class="clCouleur2 clWidth140 clAlignLeft clThNonGras">&#160;Cessation d'activit</th>
          <td class="clTexte clWidth177">
            &#160;<xsl:value-of select="CESSACT"/>
          </td>
        </xsl:if>
        <xsl:if test="not(CESSACT)">
          <td class="clCouleur2 clWidth140">&#160;</td>
          <td class="clTexte clWidth177">&#160;</td>
        </xsl:if>
      </tr>
    </table>
    <xsl:apply-templates select="INVENTAIRE"/>
  </xsl:template>

  <xsl:template match="INVENTAIRE">

    <xsl:variable name="ACTBDF" select="ACTBDF"/>
    <xsl:variable name="CODNAF" select="CODNAF"/>  
    <table class="clWidth635 clBorderCell">
      <tr>
        <th class="clCouleur2 clWidth140 clAlignLeft clThNonGras">&#160;Activit INSEE</th>
        <td class="clFond clWidth178">
          &#160;<a href="#nullePart" onclick="requestInfosLibelle('{$CODNAF}',cstWordingNew)" class="clTexte">
            <u>
              <xsl:value-of select="CODNAF"/>
            </u>
          </a>
        </td>
        <th class="clCouleur2 clWidth140 clAlignLeft clThNonGras">&#160;Activit BDF</th>
        <td class="clFond clWidth177">          
            &#160;<a href="#nullePart" onclick="requestInfosLibelle('{$ACTBDF}',cstWordingNew)" class="clTexte">
              <u>
                <xsl:value-of select="ACTBDF"/>
              </u>
            </a>         
        </td>
      </tr>
      <xsl:apply-templates select="DINV|DINSEE"/>
    </table>
    <xsl:call-template name="shim"/>
    <br />
  </xsl:template>

  <xsl:template match="DINSEE">
    <tr>
      <th class="clCouleur2 clWidth140 clAlignLeft clThNonGras">&#160;Tranche effectif</th>
      <td class="clTexte clWidth178">
        &#160;<xsl:value-of select="TREFF"/><xsl:value-of select="TREFF/@ETAT"/>
      </td>
      <th class="clCouleur2 clWidth140 clAlignLeft clThNonGras">&#160;Tranche C.A. HT</th>
      <td class="clTexte clWidth177">
        &#160;<xsl:value-of select="TRCA"/><xsl:value-of select="TRCA/@ETAT"/>
      </td>
    </tr>
  </xsl:template>

  <xsl:template match="DINV">
    <tr>
      <th class="clCouleur2 clWidth140 clAlignLeft clThNonGras">&#160;Effectif</th>
      <td class="clTexte clWidth178">
        <xsl:if test="p2058YP/@ETAT">
          &#160;<xsl:value-of select="p2058YP/@ETAT"/>
        </xsl:if>
        <xsl:if test="not(p2058YP/@ETAT)">
          &#160;<xsl:call-template name ="displayNumberXsl">
          <xsl:with-param name ="InputStringNumber" select ="(p2058YP)"/>
        </xsl:call-template>          
        </xsl:if>
      </td>
      <th class="clCouleur2 clWidth140 clAlignLeft clThNonGras">&#160;C.A. HT</th>
      <td class="clTexte clWidth177">
        <xsl:if test="pCAHT/@ETAT">
          &#160;<xsl:value-of select="pCAHT/@ETAT"/>
        </xsl:if>
        <xsl:if test="not(pCAHT/@ETAT)">
          &#160;<xsl:call-template name ="displayNumberXsl">
          <xsl:with-param name ="InputStringNumber" select ="(pCAHT)"/>
        </xsl:call-template>&#160;<xsl:value-of select="@UNITE"/><img height="9" src="{$root}Images/Commun/euro_symb_bleu.gif" width="8" alt="symbole euro"/>
        </xsl:if>
      </td>
    </tr>
  </xsl:template>

</xsl:stylesheet>
