<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:bdf="http://banque-france.fr/namespace">
	<xsl:import href="../../Ressources/XSL/Commun.xsl"/>
  <xsl:import href="../../Ressources/XSL/commun_transfo.xsl"/>
	<xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes"/>
	<xsl:param name="langage" select="'fr'"/>
	<xsl:param name="familyNumber" select="''"/>
  <xsl:param name="root" select="'/Fiben/'"/>
	<xsl:param name="familyName" select="''"/>
	<xsl:param name="familyTitle" select="''"/>
	<xsl:param name="nextModule" select="''"/>
	<xsl:param name="nextId" select="''"/>
	<xsl:param name="nextFamily" select="''"/>
	<xsl:param name="menuHTML1"/>
	
<xsl:template match="/">
		<html lang="fr">
      <title>Module 40 - Relations bancaires</title>
			<xsl:call-template name="genHead">
				<xsl:with-param name="ident" select="FIBEN/ERREUR/IDENT | /FIBEN/PERSONNE/MODULE40/PM/*/IDENTS|/FIBEN/PERSONNE/MODULE40/PM/EI/IDENTC"/>
			</xsl:call-template>
			<body class="clBodybgcolorWhite">
        <xsl:call-template name="genFondMenu">
          <xsl:with-param name="root" select="$root"/>
        </xsl:call-template>
        <xsl:copy-of select="$menuHTML1"/>
        
			<table class="mainmodule horizontal-auto clBorderCell">
        <caption class="visually-hidden">Module 40 - Relations bancaires</caption>
				<xsl:call-template name="genLigneConfidentiel"/>
				<xsl:apply-templates select="/FIBEN/ERREUR"/>
				<xsl:if test="not(/FIBEN/ERREUR)">
					<tr> 
						 <td class="clWidth64"></td>
						<td colspan="4" class="clCouleur2 clValignTop">
							<xsl:call-template name="genEnTete">
								<xsl:with-param name="ident" select="/FIBEN/PERSONNE/MODULE40/PM/	*/IDENTS|/FIBEN/PERSONNE/MODULE40/PM/EI/IDENTC"/>
                <xsl:with-param name="nom">
                  <xsl:if test ="/FIBEN/PERSONNE/MODULE40/PM/EJ/DENOM">
                    <xsl:value-of select ="/FIBEN/PERSONNE/MODULE40/PM/EJ/DENOM"/>
                  </xsl:if>
                  <xsl:if test ="/FIBEN/PERSONNE/MODULE40/PM/EI/IDENTITE/NOM">
                    <xsl:call-template name ="displayInLowerCaseXsl">
                      <xsl:with-param name ="InputStringNom" select ="(/FIBEN/PERSONNE/MODULE40/PM/EI/IDENTITE/NOM)"/>
                      <xsl:with-param name ="InputStringPrenom" select ="(/FIBEN/PERSONNE/MODULE40/PM/EI/IDENTITE/PRENOM)"/>
                    </xsl:call-template>
                  </xsl:if>
                </xsl:with-param>                              
                                
								<xsl:with-param name="nomconj" select="//IDENTITE/NOMCONJ"/>
								<xsl:with-param name="idrenv" select="/FIBEN/PERSONNE/MODULE40/PM/EI/IDRENV"/>
							</xsl:call-template>
							<xsl:if test="not(//IRELB01)">
								<xsl:apply-templates select="/FIBEN/PERSONNE/MODULE40/DIFF40/NBRELBAN"/>
								<table class="clWidth739 clBorderCell"> 
									<tr> 
										<td class="clCouleur2 clWidth24 clAlignRight"></td>
										<th class="clCouleur2 clWidth66 clAlignLeft clThNonGras">Banque</th>
										<th class="clCouleur2 clWidth79 clAlignLeft clThNonGras">Guichet</th>
										<th class="clCouleur2 clWidth304 clAlignLeft clThNonGras">Libell de l'tablissement bancaire </th>
										<th class="clCouleur2 clWidth162 clAlignCenter clThNonGras">Date de mise  jour</th>
										<td class="clWidth104"> &#160;</td>
									</tr>
									<xsl:apply-templates select="/FIBEN/PERSONNE/MODULE40/DIFF40/RELBAN"/>
								</table>
							</xsl:if>
							<xsl:if test="//IRELB01">
								<table  class="clWidth739 clBorderCell">
									<tr> 
										<td class="clCouleur2 clAlignLeft"><xsl:apply-templates select="//IRELB01"/></td>
									</tr>
								</table>
							</xsl:if>
							<img src="{$root}Images/risque/shim_bleu.gif" width="635" height="1" vspace="8" alt=""/> 
							<xsl:apply-templates select="//IDLIES"/>
						</td>
					</tr>
					
				</xsl:if>
			</table>
      <xsl:call-template name="genBasPage"/>
		</body>
	</html>
</xsl:template>
	
<xsl:template match="NBRELBAN">
	<table class="clWidth635 clBorderCell">
		<tr class="clAlignCenter">
			<td class="clCouleurGras">
				LISTE DES RELATIONS BANCAIRES (<xsl:value-of select="."/>)<br/>
				<xsl:call-template name="shim"/>
			</td>
		</tr>
	</table>
</xsl:template>

<xsl:template match="RELBAN">
	<xsl:if test="position() mod 2 != 0">
		<tr> 
			<td class="clFond clWidth24">&#160;</td>
			<td class="clFond clWidth66"><xsl:value-of select="COBAN"/></td>
			<td class="clFond clWidth79"><xsl:value-of select="COGUI"/></td>
			<td class="clFond clWidth304"><xsl:value-of select="LIBBAN"/></td>
      <td class="clFond clWidth162 clAlignCenter">
        <xsl:call-template name ="displayDateXsl">
          <xsl:with-param name ="InputDate" select ="(DATMAJ)"/>
        </xsl:call-template>
      </td>
			 <td class="clAlignRight">&#160;</td>
		</tr>
	</xsl:if>
	<xsl:if test="position() mod 2 = 0">
		<tr> 
			<td class="clTexte clWidth24 clAlignRight"></td>
			<td class="clTexte clWidth66"><xsl:value-of select="COBAN"/></td>
			<td class="clTexte clWidth79"><xsl:value-of select="COGUI"/></td>
			<td class="clTexte clWidth304"><xsl:value-of select="LIBBAN"/></td>
      <td class="clTexte clWidth162 clAlignCenter">
        <xsl:call-template name ="displayDateXsl">
          <xsl:with-param name ="InputDate" select ="(DATMAJ)"/>
        </xsl:call-template>
      </td>
			<xsl:if test="position() mod 10 = 0">
				 <td class="clAlignRight">
					<a href="#ancHaut"><img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" 	name="Image112" alt="Retour en haut de la page" /></a>
				</td>
			</xsl:if>
			<xsl:if test="position() mod 10 != 0">
				 <td class="clAlignRight">
					&#160;
				</td>
			</xsl:if>
		</tr>
	</xsl:if>
</xsl:template>
	
</xsl:stylesheet>
